"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import google.protobuf.wrappers_pb2
import google.type.timeofday_pb2
import sys
import typing
import yandex.cloud.mdb.clickhouse.v1.backup_pb2
import yandex.cloud.mdb.clickhouse.v1.cluster_pb2
import yandex.cloud.mdb.clickhouse.v1.config.clickhouse_pb2
import yandex.cloud.mdb.clickhouse.v1.database_pb2
import yandex.cloud.mdb.clickhouse.v1.maintenance_pb2
import yandex.cloud.mdb.clickhouse.v1.user_pb2
import yandex.cloud.operation.operation_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the ClickHouse Cluster resource to return.
    To get the cluster ID, use a [ClusterService.List] request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___GetClusterRequest = GetClusterRequest

@typing.final
class ListClustersRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to list ClickHouse clusters in.
    To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size], the service returns a [ListClustersResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the [ListClustersResponse.next_page_token]
    returned by the previous list request.
    """
    filter: builtins.str
    """A filter expression that filters resources listed in the response.
    The expression must specify:
    1. The field name. Currently you can only use filtering with the [Cluster.name] field.
    2. An `=` operator.
    3. The value in double quotes (`"`). Must be 1-63 characters long and match the regular expression `[a-zA-Z0-9_-]+`.
    """
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "folder_id", b"folder_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListClustersRequest = ListClustersRequest

@typing.final
class ListClustersResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTERS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is larger than [ListClustersRequest.page_size], use the [next_page_token] as the value
    for the [ListClustersRequest.page_token] parameter in the next list request. Each subsequent
    list request will have its own [next_page_token] to continue paging through the results.
    """
    @property
    def clusters(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.mdb.clickhouse.v1.cluster_pb2.Cluster]:
        """List of ClickHouse Cluster resources."""

    def __init__(
        self,
        *,
        clusters: collections.abc.Iterable[yandex.cloud.mdb.clickhouse.v1.cluster_pb2.Cluster] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clusters", b"clusters", "next_page_token", b"next_page_token"]) -> None: ...

global___ListClustersResponse = ListClustersResponse

@typing.final
class CreateClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    ENVIRONMENT_FIELD_NUMBER: builtins.int
    CONFIG_SPEC_FIELD_NUMBER: builtins.int
    DATABASE_SPECS_FIELD_NUMBER: builtins.int
    USER_SPECS_FIELD_NUMBER: builtins.int
    HOST_SPECS_FIELD_NUMBER: builtins.int
    NETWORK_ID_FIELD_NUMBER: builtins.int
    SHARD_NAME_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    SECURITY_GROUP_IDS_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    MAINTENANCE_WINDOW_FIELD_NUMBER: builtins.int
    SHARD_SPECS_FIELD_NUMBER: builtins.int
    DISK_ENCRYPTION_KEY_ID_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to create the ClickHouse cluster in."""
    name: builtins.str
    """Name of the ClickHouse cluster. The name must be unique within the folder."""
    description: builtins.str
    """Description of the ClickHouse cluster."""
    environment: yandex.cloud.mdb.clickhouse.v1.cluster_pb2.Cluster.Environment.ValueType
    """Deployment environment of the ClickHouse cluster."""
    network_id: builtins.str
    """ID of the network to create the cluster in."""
    shard_name: builtins.str
    """Name of the first shard in cluster. If not set, defaults to the value 'shard1'."""
    service_account_id: builtins.str
    """ID of the service account used for access to Object Storage."""
    deletion_protection: builtins.bool
    """Deletion Protection inhibits deletion of the cluster"""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Custom labels for the ClickHouse cluster as `key:value` pairs. Maximum 64 per resource.
        For example, "project": "mvp" or "source": "dictionary".
        """

    @property
    def config_spec(self) -> global___ConfigSpec:
        """Configuration and resources for hosts that should be created for the ClickHouse cluster."""

    @property
    def database_specs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.mdb.clickhouse.v1.database_pb2.DatabaseSpec]:
        """Descriptions of databases to be created in the ClickHouse cluster."""

    @property
    def user_specs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.mdb.clickhouse.v1.user_pb2.UserSpec]:
        """Descriptions of database users to be created in the ClickHouse cluster."""

    @property
    def host_specs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___HostSpec]:
        """Individual configurations for hosts that should be created for the ClickHouse cluster."""

    @property
    def security_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """User security groups"""

    @property
    def maintenance_window(self) -> yandex.cloud.mdb.clickhouse.v1.maintenance_pb2.MaintenanceWindow:
        """Window of maintenance operations."""

    @property
    def shard_specs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ShardSpec]:
        """Configuration(s) of the shard(s) to be created."""

    @property
    def disk_encryption_key_id(self) -> google.protobuf.wrappers_pb2.StringValue:
        """ID of the key to encrypt cluster disks."""

    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        environment: yandex.cloud.mdb.clickhouse.v1.cluster_pb2.Cluster.Environment.ValueType = ...,
        config_spec: global___ConfigSpec | None = ...,
        database_specs: collections.abc.Iterable[yandex.cloud.mdb.clickhouse.v1.database_pb2.DatabaseSpec] | None = ...,
        user_specs: collections.abc.Iterable[yandex.cloud.mdb.clickhouse.v1.user_pb2.UserSpec] | None = ...,
        host_specs: collections.abc.Iterable[global___HostSpec] | None = ...,
        network_id: builtins.str = ...,
        shard_name: builtins.str = ...,
        service_account_id: builtins.str = ...,
        security_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
        deletion_protection: builtins.bool = ...,
        maintenance_window: yandex.cloud.mdb.clickhouse.v1.maintenance_pb2.MaintenanceWindow | None = ...,
        shard_specs: collections.abc.Iterable[global___ShardSpec] | None = ...,
        disk_encryption_key_id: google.protobuf.wrappers_pb2.StringValue | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["config_spec", b"config_spec", "disk_encryption_key_id", b"disk_encryption_key_id", "maintenance_window", b"maintenance_window"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["config_spec", b"config_spec", "database_specs", b"database_specs", "deletion_protection", b"deletion_protection", "description", b"description", "disk_encryption_key_id", b"disk_encryption_key_id", "environment", b"environment", "folder_id", b"folder_id", "host_specs", b"host_specs", "labels", b"labels", "maintenance_window", b"maintenance_window", "name", b"name", "network_id", b"network_id", "security_group_ids", b"security_group_ids", "service_account_id", b"service_account_id", "shard_name", b"shard_name", "shard_specs", b"shard_specs", "user_specs", b"user_specs"]) -> None: ...

global___CreateClusterRequest = CreateClusterRequest

@typing.final
class CreateClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the ClickHouse cluster that is being created."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___CreateClusterMetadata = CreateClusterMetadata

@typing.final
class UpdateClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    CONFIG_SPEC_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    MAINTENANCE_WINDOW_FIELD_NUMBER: builtins.int
    SECURITY_GROUP_IDS_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    NETWORK_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the ClickHouse Cluster resource to update.
    To get the ClickHouse cluster ID, use a [ClusterService.List] request.
    """
    description: builtins.str
    """New description of the ClickHouse cluster."""
    name: builtins.str
    """New name for the cluster."""
    service_account_id: builtins.str
    """ID of the service account used for access to Object Storage."""
    deletion_protection: builtins.bool
    """Deletion Protection inhibits deletion of the cluster"""
    network_id: builtins.str
    """ID of the network to move the cluster to."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which fields of the ClickHouse Cluster resource should be updated."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Custom labels for the ClickHouse cluster as `key:value` pairs. Maximum 64 per resource.
        For example, "project": "mvp" or "source": "dictionary".

        The new set of labels will completely replace the old ones. To add a label, request the current
        set with the [ClusterService.Get] method, then send an [ClusterService.Update] request with the new label added to the set.
        """

    @property
    def config_spec(self) -> global___ConfigSpec:
        """New configuration and resources for hosts in the cluster."""

    @property
    def maintenance_window(self) -> yandex.cloud.mdb.clickhouse.v1.maintenance_pb2.MaintenanceWindow:
        """New maintenance window settings for the cluster."""

    @property
    def security_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """User security groups"""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        config_spec: global___ConfigSpec | None = ...,
        name: builtins.str = ...,
        service_account_id: builtins.str = ...,
        maintenance_window: yandex.cloud.mdb.clickhouse.v1.maintenance_pb2.MaintenanceWindow | None = ...,
        security_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
        deletion_protection: builtins.bool = ...,
        network_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["config_spec", b"config_spec", "maintenance_window", b"maintenance_window", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "config_spec", b"config_spec", "deletion_protection", b"deletion_protection", "description", b"description", "labels", b"labels", "maintenance_window", b"maintenance_window", "name", b"name", "network_id", b"network_id", "security_group_ids", b"security_group_ids", "service_account_id", b"service_account_id", "update_mask", b"update_mask"]) -> None: ...

global___UpdateClusterRequest = UpdateClusterRequest

@typing.final
class UpdateClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the ClickHouse Cluster resource that is being updated."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___UpdateClusterMetadata = UpdateClusterMetadata

@typing.final
class DeleteClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the ClickHouse cluster to delete.
    To get the ClickHouse cluster ID, use a [ClusterService.List] request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___DeleteClusterRequest = DeleteClusterRequest

@typing.final
class DeleteClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the ClickHouse cluster that is being deleted."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___DeleteClusterMetadata = DeleteClusterMetadata

@typing.final
class StartClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the ClickHouse cluster to start."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___StartClusterRequest = StartClusterRequest

@typing.final
class StartClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the ClickHouse cluster being started."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___StartClusterMetadata = StartClusterMetadata

@typing.final
class StopClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the ClickHouse cluster to stop."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___StopClusterRequest = StopClusterRequest

@typing.final
class StopClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the ClickHouse cluster being stopped."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___StopClusterMetadata = StopClusterMetadata

@typing.final
class MoveClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    DESTINATION_FOLDER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the ClickHouse cluster to move."""
    destination_folder_id: builtins.str
    """ID of the destination folder."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        destination_folder_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "destination_folder_id", b"destination_folder_id"]) -> None: ...

global___MoveClusterRequest = MoveClusterRequest

@typing.final
class MoveClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    SOURCE_FOLDER_ID_FIELD_NUMBER: builtins.int
    DESTINATION_FOLDER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the ClickHouse cluster being moved."""
    source_folder_id: builtins.str
    """ID of the source folder."""
    destination_folder_id: builtins.str
    """ID of the destination folder."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        source_folder_id: builtins.str = ...,
        destination_folder_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "destination_folder_id", b"destination_folder_id", "source_folder_id", b"source_folder_id"]) -> None: ...

global___MoveClusterMetadata = MoveClusterMetadata

@typing.final
class AddClusterZookeeperRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    RESOURCES_FIELD_NUMBER: builtins.int
    HOST_SPECS_FIELD_NUMBER: builtins.int
    CONVERT_TABLES_TO_REPLICATED_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the ClickHouse cluster to modify."""
    @property
    def resources(self) -> yandex.cloud.mdb.clickhouse.v1.cluster_pb2.Resources:
        """Resources allocated to Zookeeper hosts."""

    @property
    def host_specs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___HostSpec]:
        """Configuration of ZooKeeper hosts."""

    @property
    def convert_tables_to_replicated(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Enable automatic convertation of non-replicated MergeTree tables to replicated ones."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        resources: yandex.cloud.mdb.clickhouse.v1.cluster_pb2.Resources | None = ...,
        host_specs: collections.abc.Iterable[global___HostSpec] | None = ...,
        convert_tables_to_replicated: google.protobuf.wrappers_pb2.BoolValue | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["convert_tables_to_replicated", b"convert_tables_to_replicated", "resources", b"resources"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "convert_tables_to_replicated", b"convert_tables_to_replicated", "host_specs", b"host_specs", "resources", b"resources"]) -> None: ...

global___AddClusterZookeeperRequest = AddClusterZookeeperRequest

@typing.final
class AddClusterZookeeperMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the ClickHouse cluster."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___AddClusterZookeeperMetadata = AddClusterZookeeperMetadata

@typing.final
class BackupClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the ClickHouse cluster to back up.
    To get the ClickHouse cluster ID use a [ClusterService.List] request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___BackupClusterRequest = BackupClusterRequest

@typing.final
class BackupClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the ClickHouse cluster that is being backed up."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___BackupClusterMetadata = BackupClusterMetadata

@typing.final
class RestoreClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    BACKUP_ID_FIELD_NUMBER: builtins.int
    ADDITIONAL_BACKUP_IDS_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    ENVIRONMENT_FIELD_NUMBER: builtins.int
    CONFIG_SPEC_FIELD_NUMBER: builtins.int
    HOST_SPECS_FIELD_NUMBER: builtins.int
    NETWORK_ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    SECURITY_GROUP_IDS_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    SHARD_SPECS_FIELD_NUMBER: builtins.int
    DISK_ENCRYPTION_KEY_ID_FIELD_NUMBER: builtins.int
    MAINTENANCE_WINDOW_FIELD_NUMBER: builtins.int
    backup_id: builtins.str
    """ID of the backup to restore from. This backup will be used to create one cluster shard.
    To get the backup ID, use a [ClusterService.ListBackups] request.
    """
    name: builtins.str
    """Name of the new ClickHouse cluster. The name must be unique within the folder."""
    description: builtins.str
    """Description of the new ClickHouse cluster."""
    environment: yandex.cloud.mdb.clickhouse.v1.cluster_pb2.Cluster.Environment.ValueType
    """Deployment environment of the new ClickHouse cluster."""
    network_id: builtins.str
    """ID of the network to create the ClickHouse cluster in."""
    folder_id: builtins.str
    """ID of the folder to create the ClickHouse cluster in."""
    service_account_id: builtins.str
    """ID of the service account used for access to Object Storage."""
    deletion_protection: builtins.bool
    """Deletion Protection inhibits deletion of the cluster"""
    @property
    def additional_backup_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Additional IDs of the backups to restore from.
        Each additional backup is responsible for restoring separate shard.
        Restored cluster will have len(additional_backup_ids)+1 shards in total.
        To get the backup ID, use a [ClusterService.ListBackups] request.
        """

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Custom labels for the ClickHouse cluster as `key:value` pairs. Maximum 64 per resource.
        For example, "project": "mvp" or "source": "dictionary".
        """

    @property
    def config_spec(self) -> global___ConfigSpec:
        """Configuration for the ClickHouse cluster to be created."""

    @property
    def host_specs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___HostSpec]:
        """Configurations for ClickHouse hosts that should be created for
        the cluster that is being created from the backup.
        """

    @property
    def security_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """User security groups"""

    @property
    def shard_specs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ShardSpec]:
        """Configuration(s) of the shard(s) in the restored cluster."""

    @property
    def disk_encryption_key_id(self) -> google.protobuf.wrappers_pb2.StringValue:
        """ID of the key to encrypt cluster disks."""

    @property
    def maintenance_window(self) -> yandex.cloud.mdb.clickhouse.v1.maintenance_pb2.MaintenanceWindow:
        """Window of maintenance operations."""

    def __init__(
        self,
        *,
        backup_id: builtins.str = ...,
        additional_backup_ids: collections.abc.Iterable[builtins.str] | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        environment: yandex.cloud.mdb.clickhouse.v1.cluster_pb2.Cluster.Environment.ValueType = ...,
        config_spec: global___ConfigSpec | None = ...,
        host_specs: collections.abc.Iterable[global___HostSpec] | None = ...,
        network_id: builtins.str = ...,
        folder_id: builtins.str = ...,
        service_account_id: builtins.str = ...,
        security_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
        deletion_protection: builtins.bool = ...,
        shard_specs: collections.abc.Iterable[global___ShardSpec] | None = ...,
        disk_encryption_key_id: google.protobuf.wrappers_pb2.StringValue | None = ...,
        maintenance_window: yandex.cloud.mdb.clickhouse.v1.maintenance_pb2.MaintenanceWindow | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["config_spec", b"config_spec", "disk_encryption_key_id", b"disk_encryption_key_id", "maintenance_window", b"maintenance_window"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["additional_backup_ids", b"additional_backup_ids", "backup_id", b"backup_id", "config_spec", b"config_spec", "deletion_protection", b"deletion_protection", "description", b"description", "disk_encryption_key_id", b"disk_encryption_key_id", "environment", b"environment", "folder_id", b"folder_id", "host_specs", b"host_specs", "labels", b"labels", "maintenance_window", b"maintenance_window", "name", b"name", "network_id", b"network_id", "security_group_ids", b"security_group_ids", "service_account_id", b"service_account_id", "shard_specs", b"shard_specs"]) -> None: ...

global___RestoreClusterRequest = RestoreClusterRequest

@typing.final
class RestoreClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    BACKUP_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the new ClickHouse cluster that is being created from a backup."""
    backup_id: builtins.str
    """ID of the backup that is being used for creating a cluster."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        backup_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["backup_id", b"backup_id", "cluster_id", b"cluster_id"]) -> None: ...

global___RestoreClusterMetadata = RestoreClusterMetadata

@typing.final
class RescheduleMaintenanceRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _RescheduleType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _RescheduleTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[RescheduleMaintenanceRequest._RescheduleType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        RESCHEDULE_TYPE_UNSPECIFIED: RescheduleMaintenanceRequest._RescheduleType.ValueType  # 0
        IMMEDIATE: RescheduleMaintenanceRequest._RescheduleType.ValueType  # 1
        """Start the maintenance operation immediately."""
        NEXT_AVAILABLE_WINDOW: RescheduleMaintenanceRequest._RescheduleType.ValueType  # 2
        """Start the maintenance operation within the next available maintenance window."""
        SPECIFIC_TIME: RescheduleMaintenanceRequest._RescheduleType.ValueType  # 3
        """Start the maintenance operation at the specific time."""

    class RescheduleType(_RescheduleType, metaclass=_RescheduleTypeEnumTypeWrapper): ...
    RESCHEDULE_TYPE_UNSPECIFIED: RescheduleMaintenanceRequest.RescheduleType.ValueType  # 0
    IMMEDIATE: RescheduleMaintenanceRequest.RescheduleType.ValueType  # 1
    """Start the maintenance operation immediately."""
    NEXT_AVAILABLE_WINDOW: RescheduleMaintenanceRequest.RescheduleType.ValueType  # 2
    """Start the maintenance operation within the next available maintenance window."""
    SPECIFIC_TIME: RescheduleMaintenanceRequest.RescheduleType.ValueType  # 3
    """Start the maintenance operation at the specific time."""

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    RESCHEDULE_TYPE_FIELD_NUMBER: builtins.int
    DELAYED_UNTIL_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the ClickHouse cluster to reschedule the maintenance operation for."""
    reschedule_type: global___RescheduleMaintenanceRequest.RescheduleType.ValueType
    """The type of reschedule request."""
    @property
    def delayed_until(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time until which this maintenance operation should be delayed. The value should be ahead of the first time when the maintenance operation has been scheduled for no more than two weeks. The value can also point to the past moment of time if [reschedule_type.IMMEDIATE] reschedule type is chosen."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        reschedule_type: global___RescheduleMaintenanceRequest.RescheduleType.ValueType = ...,
        delayed_until: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["delayed_until", b"delayed_until"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "delayed_until", b"delayed_until", "reschedule_type", b"reschedule_type"]) -> None: ...

global___RescheduleMaintenanceRequest = RescheduleMaintenanceRequest

@typing.final
class RescheduleMaintenanceMetadata(google.protobuf.message.Message):
    """Rescheduled maintenance operation metadata."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    DELAYED_UNTIL_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """Required. ID of the ClickHouse cluster."""
    @property
    def delayed_until(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Required. The time until which this maintenance operation is to be delayed."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        delayed_until: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["delayed_until", b"delayed_until"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "delayed_until", b"delayed_until"]) -> None: ...

global___RescheduleMaintenanceMetadata = RescheduleMaintenanceMetadata

@typing.final
class LogRecord(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MessageEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    TIMESTAMP_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    @property
    def timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Log record timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format."""

    @property
    def message(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Contents of the log record."""

    def __init__(
        self,
        *,
        timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        message: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["timestamp", b"timestamp"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["message", b"message", "timestamp", b"timestamp"]) -> None: ...

global___LogRecord = LogRecord

@typing.final
class ListClusterLogsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _ServiceType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ServiceTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ListClusterLogsRequest._ServiceType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        SERVICE_TYPE_UNSPECIFIED: ListClusterLogsRequest._ServiceType.ValueType  # 0
        CLICKHOUSE: ListClusterLogsRequest._ServiceType.ValueType  # 1
        """Logs of ClickHouse activity."""
        CLICKHOUSE_KEEPER: ListClusterLogsRequest._ServiceType.ValueType  # 2
        """Logs of ClickHouse Keeper activity."""

    class ServiceType(_ServiceType, metaclass=_ServiceTypeEnumTypeWrapper): ...
    SERVICE_TYPE_UNSPECIFIED: ListClusterLogsRequest.ServiceType.ValueType  # 0
    CLICKHOUSE: ListClusterLogsRequest.ServiceType.ValueType  # 1
    """Logs of ClickHouse activity."""
    CLICKHOUSE_KEEPER: ListClusterLogsRequest.ServiceType.ValueType  # 2
    """Logs of ClickHouse Keeper activity."""

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    COLUMN_FILTER_FIELD_NUMBER: builtins.int
    SERVICE_TYPE_FIELD_NUMBER: builtins.int
    FROM_TIME_FIELD_NUMBER: builtins.int
    TO_TIME_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the ClickHouse cluster to request logs for.
    To get the ClickHouse cluster ID, use a [ClusterService.List] request.
    """
    service_type: global___ListClusterLogsRequest.ServiceType.ValueType
    """Type of the service to request logs about."""
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size], the service returns a [ListClusterLogsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token.  To get the next page of results, set [page_token] to the [ListClusterLogsResponse.next_page_token]
    returned by the previous list request.
    """
    @property
    def column_filter(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Columns from logs table to request.
        If no columns are specified, entire log records are returned.
        """

    @property
    def from_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Start timestamp for the logs request, in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format."""

    @property
    def to_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """End timestamp for the logs request, in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        column_filter: collections.abc.Iterable[builtins.str] | None = ...,
        service_type: global___ListClusterLogsRequest.ServiceType.ValueType = ...,
        from_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        to_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["from_time", b"from_time", "to_time", b"to_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "column_filter", b"column_filter", "from_time", b"from_time", "page_size", b"page_size", "page_token", b"page_token", "service_type", b"service_type", "to_time", b"to_time"]) -> None: ...

global___ListClusterLogsRequest = ListClusterLogsRequest

@typing.final
class ListClusterLogsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOGS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is larger than [ListClusterLogsRequest.page_size], use the [next_page_token] as the value
    for the [ListClusterLogsRequest.page_token] query parameter in the next list request.
    Each subsequent list request will have its own [next_page_token] to continue paging through the results.
    This value is interchangeable with the [StreamLogRecord.next_record_token] from StreamLogs method.
    """
    @property
    def logs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___LogRecord]:
        """Requested log records."""

    def __init__(
        self,
        *,
        logs: collections.abc.Iterable[global___LogRecord] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["logs", b"logs", "next_page_token", b"next_page_token"]) -> None: ...

global___ListClusterLogsResponse = ListClusterLogsResponse

@typing.final
class StreamLogRecord(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RECORD_FIELD_NUMBER: builtins.int
    NEXT_RECORD_TOKEN_FIELD_NUMBER: builtins.int
    next_record_token: builtins.str
    """This token allows you to continue streaming logs starting from the exact
    same record. To continue streaming, specify value of [next_record_token[
    as value for the [StreamClusterLogsRequest.record_token] parameter in the next StreamLogs request.
    This value is interchangeable with the [ListClusterLogsResponse.next_page_token] from ListLogs method.
    """
    @property
    def record(self) -> global___LogRecord:
        """One of the requested log records."""

    def __init__(
        self,
        *,
        record: global___LogRecord | None = ...,
        next_record_token: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["record", b"record"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["next_record_token", b"next_record_token", "record", b"record"]) -> None: ...

global___StreamLogRecord = StreamLogRecord

@typing.final
class StreamClusterLogsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _ServiceType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ServiceTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[StreamClusterLogsRequest._ServiceType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        SERVICE_TYPE_UNSPECIFIED: StreamClusterLogsRequest._ServiceType.ValueType  # 0
        CLICKHOUSE: StreamClusterLogsRequest._ServiceType.ValueType  # 1
        """Logs of ClickHouse activity."""
        CLICKHOUSE_KEEPER: StreamClusterLogsRequest._ServiceType.ValueType  # 2
        """Logs of ClickHouse Keeper activity."""

    class ServiceType(_ServiceType, metaclass=_ServiceTypeEnumTypeWrapper): ...
    SERVICE_TYPE_UNSPECIFIED: StreamClusterLogsRequest.ServiceType.ValueType  # 0
    CLICKHOUSE: StreamClusterLogsRequest.ServiceType.ValueType  # 1
    """Logs of ClickHouse activity."""
    CLICKHOUSE_KEEPER: StreamClusterLogsRequest.ServiceType.ValueType  # 2
    """Logs of ClickHouse Keeper activity."""

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    COLUMN_FILTER_FIELD_NUMBER: builtins.int
    SERVICE_TYPE_FIELD_NUMBER: builtins.int
    FROM_TIME_FIELD_NUMBER: builtins.int
    TO_TIME_FIELD_NUMBER: builtins.int
    RECORD_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """Required. ID of the ClickHouse cluster."""
    service_type: global___StreamClusterLogsRequest.ServiceType.ValueType
    record_token: builtins.str
    """Record token. Set [record_token] to the [StreamLogRecord.next_record_token] returned by a previous StreamLogs
    request to start streaming from next log record.
    """
    filter: builtins.str
    """A filter expression that filters resources listed in the response.
    The expression must specify:
    1. The field name. Currently filtering can be applied to the [LogRecord.logs.message.hostname], [LogRecord.logs.message.severity] fields.
    2. An `=` operator.
    3. The value in double quotes (`"`). Must be 1-63 characters long and match the regular expression `[a-z0-9.-]{1,61}`.
    Examples of a filter:
    - `message.hostname='node1.db.cloud.yandex.net'`
    - `message.severity IN ('Error', 'Fatal') AND message.hostname != 'node2.db.cloud.yandex.net'`.
    """
    @property
    def column_filter(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Columns from logs table to get in the response."""

    @property
    def from_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Start timestamp for the logs request."""

    @property
    def to_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """End timestamp for the logs request.
        If this field is not set, all existing logs will be sent and then the new ones as
        they appear. In essence it has `tail -f` semantics.
        """

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        column_filter: collections.abc.Iterable[builtins.str] | None = ...,
        service_type: global___StreamClusterLogsRequest.ServiceType.ValueType = ...,
        from_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        to_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        record_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["from_time", b"from_time", "to_time", b"to_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "column_filter", b"column_filter", "filter", b"filter", "from_time", b"from_time", "record_token", b"record_token", "service_type", b"service_type", "to_time", b"to_time"]) -> None: ...

global___StreamClusterLogsRequest = StreamClusterLogsRequest

@typing.final
class ListClusterOperationsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the ClickHouse Cluster resource to list operations for."""
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size], the service returns a [ListClusterOperationsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token.  To get the next page of results, set [page_token] to the [ListClusterOperationsResponse.next_page_token]
    returned by the previous list request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListClusterOperationsRequest = ListClusterOperationsRequest

@typing.final
class ListClusterOperationsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is larger than [ListClusterOperationsRequest.page_size], use the [next_page_token] as the value
    for the [ListClusterOperationsRequest.page_token] query parameter in the next list request.
    Each subsequent list request will have its own [next_page_token] to continue paging through the results.
    """
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.operation.operation_pb2.Operation]:
        """List of Operation resources for the specified ClickHouse cluster."""

    def __init__(
        self,
        *,
        operations: collections.abc.Iterable[yandex.cloud.operation.operation_pb2.Operation] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "operations", b"operations"]) -> None: ...

global___ListClusterOperationsResponse = ListClusterOperationsResponse

@typing.final
class ListClusterBackupsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the ClickHouse cluster.
    To get the ClickHouse cluster ID, use a [ClusterService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size], the service returns a [ListClusterBackupsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the
    [ListClusterBackupsResponse.next_page_token] returned by the previous list request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListClusterBackupsRequest = ListClusterBackupsRequest

@typing.final
class ListClusterBackupsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BACKUPS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is larger than [ListClusterBackupsRequest.page_size], use the [next_page_token] as the value
    for the [ListClusterBackupsRequest.page_token] query parameter in the next list request.
    Each subsequent list request will have its own [next_page_token] to continue paging through the results.
    """
    @property
    def backups(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.mdb.clickhouse.v1.backup_pb2.Backup]:
        """List of ClickHouse Backup resources."""

    def __init__(
        self,
        *,
        backups: collections.abc.Iterable[yandex.cloud.mdb.clickhouse.v1.backup_pb2.Backup] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["backups", b"backups", "next_page_token", b"next_page_token"]) -> None: ...

global___ListClusterBackupsResponse = ListClusterBackupsResponse

@typing.final
class ListClusterHostsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the ClickHouse cluster.
    To get the ClickHouse cluster ID use a [ClusterService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size], the service returns a [ListClusterHostsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token.  To get the next page of results, set [page_token] to the [ListClusterHostsResponse.next_page_token]
    returned by the previous list request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListClusterHostsRequest = ListClusterHostsRequest

@typing.final
class ListClusterHostsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HOSTS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is larger than [ListClusterHostsRequest.page_size], use the [next_page_token] as the value
    for the [ListClusterHostsRequest.page_token] query parameter in the next list request.
    Each subsequent list request will have its own [next_page_token] to continue paging through the results.
    """
    @property
    def hosts(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.mdb.clickhouse.v1.cluster_pb2.Host]:
        """Requested list of hosts for the cluster."""

    def __init__(
        self,
        *,
        hosts: collections.abc.Iterable[yandex.cloud.mdb.clickhouse.v1.cluster_pb2.Host] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["hosts", b"hosts", "next_page_token", b"next_page_token"]) -> None: ...

global___ListClusterHostsResponse = ListClusterHostsResponse

@typing.final
class AddClusterHostsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    HOST_SPECS_FIELD_NUMBER: builtins.int
    COPY_SCHEMA_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the ClickHouse cluster to add hosts to.
    To get the ClickHouse cluster ID, use a [ClusterService.List] request.
    """
    @property
    def host_specs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___HostSpec]:
        """Configurations for ClickHouse hosts that should be added to the cluster."""

    @property
    def copy_schema(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Whether to copy schema to new ClickHouse hosts from replicas."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        host_specs: collections.abc.Iterable[global___HostSpec] | None = ...,
        copy_schema: google.protobuf.wrappers_pb2.BoolValue | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["copy_schema", b"copy_schema"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "copy_schema", b"copy_schema", "host_specs", b"host_specs"]) -> None: ...

global___AddClusterHostsRequest = AddClusterHostsRequest

@typing.final
class AddClusterHostsMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    HOST_NAMES_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the ClickHouse cluster to which the hosts are being added."""
    @property
    def host_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Names of hosts that are being added to the cluster."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        host_names: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "host_names", b"host_names"]) -> None: ...

global___AddClusterHostsMetadata = AddClusterHostsMetadata

@typing.final
class UpdateHostSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HOST_NAME_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    ASSIGN_PUBLIC_IP_FIELD_NUMBER: builtins.int
    host_name: builtins.str
    """Name of the host to update.
    To get the ClickHouse host name, use a [ClusterService.ListHosts] request.
    """
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which fields of the ClickHouse host should be updated."""

    @property
    def assign_public_ip(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Whether the host should get a public IP address on creation."""

    def __init__(
        self,
        *,
        host_name: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        assign_public_ip: google.protobuf.wrappers_pb2.BoolValue | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["assign_public_ip", b"assign_public_ip", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["assign_public_ip", b"assign_public_ip", "host_name", b"host_name", "update_mask", b"update_mask"]) -> None: ...

global___UpdateHostSpec = UpdateHostSpec

@typing.final
class UpdateClusterHostsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    UPDATE_HOST_SPECS_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the ClickHouse cluster to update hosts in.
    To get the ClickHouse cluster ID, use a [ClusterService.List] request.
    """
    @property
    def update_host_specs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___UpdateHostSpec]:
        """New configurations to apply to hosts."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        update_host_specs: collections.abc.Iterable[global___UpdateHostSpec] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "update_host_specs", b"update_host_specs"]) -> None: ...

global___UpdateClusterHostsRequest = UpdateClusterHostsRequest

@typing.final
class UpdateClusterHostsMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    HOST_NAMES_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the ClickHouse cluster to modify hosts in."""
    @property
    def host_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Names of hosts that are being modified."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        host_names: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "host_names", b"host_names"]) -> None: ...

global___UpdateClusterHostsMetadata = UpdateClusterHostsMetadata

@typing.final
class DeleteClusterHostsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    HOST_NAMES_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the ClickHouse cluster to remove hosts from.
    To get the ClickHouse cluster ID, use a [ClusterService.List] request.
    """
    @property
    def host_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Names of hosts to delete."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        host_names: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "host_names", b"host_names"]) -> None: ...

global___DeleteClusterHostsRequest = DeleteClusterHostsRequest

@typing.final
class DeleteClusterHostsMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    HOST_NAMES_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the ClickHouse cluster to remove hosts from."""
    @property
    def host_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Names of hosts that are being deleted."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        host_names: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "host_names", b"host_names"]) -> None: ...

global___DeleteClusterHostsMetadata = DeleteClusterHostsMetadata

@typing.final
class RestartClusterHostsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    HOST_NAMES_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """Required. ID of the Clickhouse cluster."""
    @property
    def host_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Required. Name of the hosts to restart."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        host_names: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "host_names", b"host_names"]) -> None: ...

global___RestartClusterHostsRequest = RestartClusterHostsRequest

@typing.final
class RestartClusterHostsMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    HOST_NAMES_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """Required. ID of the ClickHouse cluster."""
    @property
    def host_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Required. The name of restarting host."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        host_names: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "host_names", b"host_names"]) -> None: ...

global___RestartClusterHostsMetadata = RestartClusterHostsMetadata

@typing.final
class GetClusterShardRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    SHARD_NAME_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster that the shard belongs to.
    To get the cluster ID, use a [ClusterService.List] request.
    To get the name of the database, use a [ClusterService.List] request.
    """
    shard_name: builtins.str
    """Name of the shard to request information about.
    To get the name of a shard, use a [ClusterService.ListShards] request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        shard_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "shard_name", b"shard_name"]) -> None: ...

global___GetClusterShardRequest = GetClusterShardRequest

@typing.final
class ListClusterShardsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the ClickHouse cluster to list shards in.
    To get the cluster ID, use a [ClusterService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size], the service returns a [ListClusterShardsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token.  to get the next page of results, set [page_token] to the [ListClusterShardsResponse.next_page_token]
    returned by the previous list request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListClusterShardsRequest = ListClusterShardsRequest

@typing.final
class ListClusterShardsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SHARDS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is larger than [ListClusterShardsRequest.page_size], use the [next_page_token] as the value
    for the [ListClusterShardsRequest.page_token] parameter in the next list request. Each subsequent
    list request will have its own [next_page_token] to continue paging through the results.
    """
    @property
    def shards(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.mdb.clickhouse.v1.cluster_pb2.Shard]:
        """List of ClickHouse shards."""

    def __init__(
        self,
        *,
        shards: collections.abc.Iterable[yandex.cloud.mdb.clickhouse.v1.cluster_pb2.Shard] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "shards", b"shards"]) -> None: ...

global___ListClusterShardsResponse = ListClusterShardsResponse

@typing.final
class AddClusterShardRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    SHARD_NAME_FIELD_NUMBER: builtins.int
    CONFIG_SPEC_FIELD_NUMBER: builtins.int
    HOST_SPECS_FIELD_NUMBER: builtins.int
    COPY_SCHEMA_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the ClickHouse cluster to add a shard to.
    To get the ClickHouse cluster ID, use a [ClusterService.List] request.
    """
    shard_name: builtins.str
    """Name for the new shard."""
    @property
    def config_spec(self) -> global___ShardConfigSpec:
        """Configuration of the new shard."""

    @property
    def host_specs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___HostSpec]:
        """Configurations for ClickHouse hosts that should be created with the shard."""

    @property
    def copy_schema(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Whether to copy schema to hosts of the shard to be created. The schema is copied from hosts of an existing shard."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        shard_name: builtins.str = ...,
        config_spec: global___ShardConfigSpec | None = ...,
        host_specs: collections.abc.Iterable[global___HostSpec] | None = ...,
        copy_schema: google.protobuf.wrappers_pb2.BoolValue | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["config_spec", b"config_spec", "copy_schema", b"copy_schema"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "config_spec", b"config_spec", "copy_schema", b"copy_schema", "host_specs", b"host_specs", "shard_name", b"shard_name"]) -> None: ...

global___AddClusterShardRequest = AddClusterShardRequest

@typing.final
class AddClusterShardMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    SHARD_NAME_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster that a shard is being added to."""
    shard_name: builtins.str
    """Name of the shard being created."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        shard_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "shard_name", b"shard_name"]) -> None: ...

global___AddClusterShardMetadata = AddClusterShardMetadata

@typing.final
class AddClusterShardsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    SHARD_SPECS_FIELD_NUMBER: builtins.int
    HOST_SPECS_FIELD_NUMBER: builtins.int
    COPY_SCHEMA_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the ClickHouse cluster to add shards to.
    To get the ClickHouse cluster ID, use a [ClusterService.List] request.
    """
    @property
    def shard_specs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ShardSpec]:
        """Properties of each shard to be created.
        If [ShardSpec.config_spec] is not specified for some shard, for this shard
        it defaults to the configuration of the first shard in the cluster.
        """

    @property
    def host_specs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___HostSpec]:
        """Individual configurations for hosts that should be created for the shards.
        Two options are available:
        1. If `host_specs` is empty, each shard's number and configurations of hosts will
           be copied from those of the first shard in the cluster;
        2. Otherwise `host_specs` should contain at least one host per created shard.
        """

    @property
    def copy_schema(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Whether to copy schema to hosts of the new shards. The schema is copied from hosts of an existing shard."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        shard_specs: collections.abc.Iterable[global___ShardSpec] | None = ...,
        host_specs: collections.abc.Iterable[global___HostSpec] | None = ...,
        copy_schema: google.protobuf.wrappers_pb2.BoolValue | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["copy_schema", b"copy_schema"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "copy_schema", b"copy_schema", "host_specs", b"host_specs", "shard_specs", b"shard_specs"]) -> None: ...

global___AddClusterShardsRequest = AddClusterShardsRequest

@typing.final
class AddClusterShardsMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    SHARD_NAMES_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster that the shards are being added to."""
    @property
    def shard_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Names of the shards being created."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        shard_names: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "shard_names", b"shard_names"]) -> None: ...

global___AddClusterShardsMetadata = AddClusterShardsMetadata

@typing.final
class UpdateClusterShardRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    SHARD_NAME_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    CONFIG_SPEC_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the ClickHouse cluster the shard belongs to.
    To get the cluster ID, use a [ClusterService.List] request.
    """
    shard_name: builtins.str
    """Name of the shard to be updated.
    To get the name of a shard, use a [ClusterService.ListShards] request.
    """
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which attributes of the ClickHouse shard should be updated."""

    @property
    def config_spec(self) -> global___ShardConfigSpec:
        """New configuration for the specified shard."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        shard_name: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        config_spec: global___ShardConfigSpec | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["config_spec", b"config_spec", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "config_spec", b"config_spec", "shard_name", b"shard_name", "update_mask", b"update_mask"]) -> None: ...

global___UpdateClusterShardRequest = UpdateClusterShardRequest

@typing.final
class UpdateClusterShardMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    SHARD_NAME_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster that contains the shard being updated."""
    shard_name: builtins.str
    """Name of the shard being updated."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        shard_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "shard_name", b"shard_name"]) -> None: ...

global___UpdateClusterShardMetadata = UpdateClusterShardMetadata

@typing.final
class DeleteClusterShardRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    SHARD_NAME_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the ClickHouse cluster the shard belongs to.
    To get the cluster ID, use a [ClusterService.List] request.
    """
    shard_name: builtins.str
    """Name of the shard to be deleted.
    To get the name of a shard, use a [ClusterService.ListShards] request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        shard_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "shard_name", b"shard_name"]) -> None: ...

global___DeleteClusterShardRequest = DeleteClusterShardRequest

@typing.final
class DeleteClusterShardMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    SHARD_NAME_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster that contains the shard being deleted."""
    shard_name: builtins.str
    """Name of the shard being deleted."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        shard_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "shard_name", b"shard_name"]) -> None: ...

global___DeleteClusterShardMetadata = DeleteClusterShardMetadata

@typing.final
class DeleteClusterShardsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    SHARD_NAMES_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the ClickHouse cluster the shards belong to.
    To get the cluster ID, use a [ClusterService.List] request.
    """
    @property
    def shard_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Names of the shards to be deleted.
        To get the name of a shard, use a [ClusterService.ListShards] request.
        """

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        shard_names: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "shard_names", b"shard_names"]) -> None: ...

global___DeleteClusterShardsRequest = DeleteClusterShardsRequest

@typing.final
class DeleteClusterShardsMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    SHARD_NAMES_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster that contains the shards being deleted."""
    @property
    def shard_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Names of the shards being deleted."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        shard_names: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "shard_names", b"shard_names"]) -> None: ...

global___DeleteClusterShardsMetadata = DeleteClusterShardsMetadata

@typing.final
class GetClusterShardGroupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    SHARD_GROUP_NAME_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster that the shard group belongs to.

    To get the cluster ID, make a [ClusterService.List] request.
    """
    shard_group_name: builtins.str
    """Name of the shard group to request information about.

    To get the name of a shard group, make a [ClusterService.ListShardGroups] request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        shard_group_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "shard_group_name", b"shard_group_name"]) -> None: ...

global___GetClusterShardGroupRequest = GetClusterShardGroupRequest

@typing.final
class ListClusterShardGroupsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster that the shard group belongs to.

    To get the cluster ID, make a [ClusterService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return.

    If the number of available results is larger than [page_size], the service returns a [ListClusterShardGroupsResponse.next_page_token] that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token.

    To get the next page of results, set [page_token] to the [ListClusterShardGroupsResponse.next_page_token] returned by the previous list request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListClusterShardGroupsRequest = ListClusterShardGroupsRequest

@typing.final
class ListClusterShardGroupsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SHARD_GROUPS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests.

    If the number of results is larger than [ListClusterShardGroupsRequest.page_size], use the [next_page_token] as the value for the [ListClusterShardGroupsRequest.page_token] parameter in the next list request.
    Each subsequent list request will have its own [next_page_token] to continue paging through the results.
    """
    @property
    def shard_groups(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.mdb.clickhouse.v1.cluster_pb2.ShardGroup]:
        """List of ClickHouse cluster's shard groups."""

    def __init__(
        self,
        *,
        shard_groups: collections.abc.Iterable[yandex.cloud.mdb.clickhouse.v1.cluster_pb2.ShardGroup] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "shard_groups", b"shard_groups"]) -> None: ...

global___ListClusterShardGroupsResponse = ListClusterShardGroupsResponse

@typing.final
class CreateClusterShardGroupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    SHARD_GROUP_NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    SHARD_NAMES_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the ClickHouse cluster to add a shard group to.

    To get the cluster ID, make a [ClusterService.List] request.
    """
    shard_group_name: builtins.str
    """Name for the new shard group."""
    description: builtins.str
    """Description of the new shard group. 0-256 characters long."""
    @property
    def shard_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of shard names that should be put into the new group.

        To get the list, make a [ClusterService.ListShardGroups] request.
        """

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        shard_group_name: builtins.str = ...,
        description: builtins.str = ...,
        shard_names: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "description", b"description", "shard_group_name", b"shard_group_name", "shard_names", b"shard_names"]) -> None: ...

global___CreateClusterShardGroupRequest = CreateClusterShardGroupRequest

@typing.final
class CreateClusterShardGroupMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    SHARD_GROUP_NAME_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster to add a shard group to."""
    shard_group_name: builtins.str
    """Name of the shard group that is being added."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        shard_group_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "shard_group_name", b"shard_group_name"]) -> None: ...

global___CreateClusterShardGroupMetadata = CreateClusterShardGroupMetadata

@typing.final
class UpdateClusterShardGroupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    SHARD_GROUP_NAME_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    SHARD_NAMES_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the ClickHouse cluster that contains the shard group to update.

    To get the cluster ID, make a [ClusterService.List] request.
    """
    shard_group_name: builtins.str
    """Name of the shard group that should be updated.

    To get the name, make a [ClusterService.ListShardGroups] request.
    """
    description: builtins.str
    """Updated description of the shard group. 0-256 characters long."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask: ...
    @property
    def shard_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Updated list of shard names that belongs to the shard group."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        shard_group_name: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        description: builtins.str = ...,
        shard_names: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "description", b"description", "shard_group_name", b"shard_group_name", "shard_names", b"shard_names", "update_mask", b"update_mask"]) -> None: ...

global___UpdateClusterShardGroupRequest = UpdateClusterShardGroupRequest

@typing.final
class UpdateClusterShardGroupMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    SHARD_GROUP_NAME_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster that contains the shard group being updated."""
    shard_group_name: builtins.str
    """Name of the shard group that is being updated."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        shard_group_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "shard_group_name", b"shard_group_name"]) -> None: ...

global___UpdateClusterShardGroupMetadata = UpdateClusterShardGroupMetadata

@typing.final
class DeleteClusterShardGroupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    SHARD_GROUP_NAME_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the ClickHouse cluster that contains the shard group to delete.

    To get the cluster ID, make a [ClusterService.List] request.
    """
    shard_group_name: builtins.str
    """Name of the shard group that should be deleted.

    To get the name, make a [ClusterService.ListShardGroups] request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        shard_group_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "shard_group_name", b"shard_group_name"]) -> None: ...

global___DeleteClusterShardGroupRequest = DeleteClusterShardGroupRequest

@typing.final
class DeleteClusterShardGroupMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    SHARD_GROUP_NAME_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster that contains the shard group being deleted."""
    shard_group_name: builtins.str
    """Name of the shard group that is being deleted."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        shard_group_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "shard_group_name", b"shard_group_name"]) -> None: ...

global___DeleteClusterShardGroupMetadata = DeleteClusterShardGroupMetadata

@typing.final
class ListClusterExternalDictionariesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster that the external dictionaries belong to."""
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size], the service returns a [ListClusterExternalDictionaryResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the [ListClusterExternalDictionaryResponse.next_page_token]
    returned by a previous list request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListClusterExternalDictionariesRequest = ListClusterExternalDictionariesRequest

@typing.final
class ListClusterExternalDictionariesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EXTERNAL_DICTIONARIES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is larger than [ListClusterExternalDictionaryRequest.page_size], use the [next_page_token] as the value
    for the [ListClusterExternalDictionaryRequest.page_token] parameter in the next list request. Each subsequent
    list request will have its own [next_page_token] to continue paging through the results.
    """
    @property
    def external_dictionaries(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.mdb.clickhouse.v1.config.clickhouse_pb2.ClickhouseConfig.ExternalDictionary]:
        """List of ClickHouse Cluster external dictionaries."""

    def __init__(
        self,
        *,
        external_dictionaries: collections.abc.Iterable[yandex.cloud.mdb.clickhouse.v1.config.clickhouse_pb2.ClickhouseConfig.ExternalDictionary] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["external_dictionaries", b"external_dictionaries", "next_page_token", b"next_page_token"]) -> None: ...

global___ListClusterExternalDictionariesResponse = ListClusterExternalDictionariesResponse

@typing.final
class CreateClusterExternalDictionaryRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    EXTERNAL_DICTIONARY_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the ClickHouse cluster to create the external dictionary for.
    To get the cluster ID, use a [ClusterService.List] request.
    """
    @property
    def external_dictionary(self) -> yandex.cloud.mdb.clickhouse.v1.config.clickhouse_pb2.ClickhouseConfig.ExternalDictionary:
        """Configuration of the external dictionary."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        external_dictionary: yandex.cloud.mdb.clickhouse.v1.config.clickhouse_pb2.ClickhouseConfig.ExternalDictionary | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["external_dictionary", b"external_dictionary"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "external_dictionary", b"external_dictionary"]) -> None: ...

global___CreateClusterExternalDictionaryRequest = CreateClusterExternalDictionaryRequest

@typing.final
class CreateClusterExternalDictionaryMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster for which an external dictionary is being created."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___CreateClusterExternalDictionaryMetadata = CreateClusterExternalDictionaryMetadata

@typing.final
class UpdateClusterExternalDictionaryRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    EXTERNAL_DICTIONARY_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the ClickHouse cluster to update the external dictionary for.
    To get the cluster ID, use a [List] request.
    """
    @property
    def external_dictionary(self) -> yandex.cloud.mdb.clickhouse.v1.config.clickhouse_pb2.ClickhouseConfig.ExternalDictionary:
        """Configuration of the external dictionary."""

    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which fields of the External Dictionary should be updated."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        external_dictionary: yandex.cloud.mdb.clickhouse.v1.config.clickhouse_pb2.ClickhouseConfig.ExternalDictionary | None = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["external_dictionary", b"external_dictionary", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "external_dictionary", b"external_dictionary", "update_mask", b"update_mask"]) -> None: ...

global___UpdateClusterExternalDictionaryRequest = UpdateClusterExternalDictionaryRequest

@typing.final
class UpdateClusterExternalDictionaryMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    EXTERNAL_DICTIONARY_NAME_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster for which an external dictionary is being updated."""
    external_dictionary_name: builtins.str
    """Name of the external dictionary."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        external_dictionary_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "external_dictionary_name", b"external_dictionary_name"]) -> None: ...

global___UpdateClusterExternalDictionaryMetadata = UpdateClusterExternalDictionaryMetadata

@typing.final
class DeleteClusterExternalDictionaryRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    EXTERNAL_DICTIONARY_NAME_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the ClickHouse cluster to delete the external dictionary from.
    To get the cluster ID, use a [ClusterService.List] request.
    """
    external_dictionary_name: builtins.str
    """Name of the external dictionary to delete."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        external_dictionary_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "external_dictionary_name", b"external_dictionary_name"]) -> None: ...

global___DeleteClusterExternalDictionaryRequest = DeleteClusterExternalDictionaryRequest

@typing.final
class DeleteClusterExternalDictionaryMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster where an external dictionary is being deleted."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___DeleteClusterExternalDictionaryMetadata = DeleteClusterExternalDictionaryMetadata

@typing.final
class HostSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ZONE_ID_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    SUBNET_ID_FIELD_NUMBER: builtins.int
    ASSIGN_PUBLIC_IP_FIELD_NUMBER: builtins.int
    SHARD_NAME_FIELD_NUMBER: builtins.int
    zone_id: builtins.str
    """ID of the availability zone where the host resides.
    To get a list of available zones, use the [yandex.cloud.compute.v1.ZoneService.List] request.
    """
    type: yandex.cloud.mdb.clickhouse.v1.cluster_pb2.Host.Type.ValueType
    """Type of the host to be deployed."""
    subnet_id: builtins.str
    """ID of the subnet that the host should belong to. This subnet should be a part
    of the network that the cluster belongs to.
    The ID of the network is set in the [Cluster.network_id] field.
    """
    assign_public_ip: builtins.bool
    """Whether the host should get a public IP address on creation.

    After a host has been created, this setting cannot be changed. To remove an assigned public IP, or to assign
    a public IP to a host without one, recreate the host with [assign_public_ip] set as needed.

    Possible values:
    * false - don't assign a public IP to the host.
    * true - the host should have a public IP address.
    """
    shard_name: builtins.str
    """Name of the shard that the host is assigned to."""
    def __init__(
        self,
        *,
        zone_id: builtins.str = ...,
        type: yandex.cloud.mdb.clickhouse.v1.cluster_pb2.Host.Type.ValueType = ...,
        subnet_id: builtins.str = ...,
        assign_public_ip: builtins.bool = ...,
        shard_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["assign_public_ip", b"assign_public_ip", "shard_name", b"shard_name", "subnet_id", b"subnet_id", "type", b"type", "zone_id", b"zone_id"]) -> None: ...

global___HostSpec = HostSpec

@typing.final
class ConfigSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class Clickhouse(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONFIG_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def config(self) -> yandex.cloud.mdb.clickhouse.v1.config.clickhouse_pb2.ClickhouseConfig:
            """Configuration for a ClickHouse server."""

        @property
        def resources(self) -> yandex.cloud.mdb.clickhouse.v1.cluster_pb2.Resources:
            """Resources allocated to ClickHouse hosts."""

        @property
        def disk_size_autoscaling(self) -> yandex.cloud.mdb.clickhouse.v1.cluster_pb2.DiskSizeAutoscaling:
            """Disk size autoscaling settings."""

        def __init__(
            self,
            *,
            config: yandex.cloud.mdb.clickhouse.v1.config.clickhouse_pb2.ClickhouseConfig | None = ...,
            resources: yandex.cloud.mdb.clickhouse.v1.cluster_pb2.Resources | None = ...,
            disk_size_autoscaling: yandex.cloud.mdb.clickhouse.v1.cluster_pb2.DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> None: ...

    @typing.final
    class Zookeeper(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        RESOURCES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def resources(self) -> yandex.cloud.mdb.clickhouse.v1.cluster_pb2.Resources:
            """Resources allocated to ZooKeeper hosts. If not set, minimal available resources will be used.
            All available resource presets can be retrieved with a [ResourcePresetService.List] request.
            """

        @property
        def disk_size_autoscaling(self) -> yandex.cloud.mdb.clickhouse.v1.cluster_pb2.DiskSizeAutoscaling:
            """Disk size autoscaling settings."""

        def __init__(
            self,
            *,
            resources: yandex.cloud.mdb.clickhouse.v1.cluster_pb2.Resources | None = ...,
            disk_size_autoscaling: yandex.cloud.mdb.clickhouse.v1.cluster_pb2.DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> None: ...

    VERSION_FIELD_NUMBER: builtins.int
    CLICKHOUSE_FIELD_NUMBER: builtins.int
    ZOOKEEPER_FIELD_NUMBER: builtins.int
    BACKUP_WINDOW_START_FIELD_NUMBER: builtins.int
    ACCESS_FIELD_NUMBER: builtins.int
    CLOUD_STORAGE_FIELD_NUMBER: builtins.int
    SQL_DATABASE_MANAGEMENT_FIELD_NUMBER: builtins.int
    SQL_USER_MANAGEMENT_FIELD_NUMBER: builtins.int
    ADMIN_PASSWORD_FIELD_NUMBER: builtins.int
    EMBEDDED_KEEPER_FIELD_NUMBER: builtins.int
    BACKUP_RETAIN_PERIOD_DAYS_FIELD_NUMBER: builtins.int
    version: builtins.str
    """Version of the ClickHouse server software."""
    admin_password: builtins.str
    """Password for user 'admin' that has SQL user management access."""
    @property
    def clickhouse(self) -> global___ConfigSpec.Clickhouse:
        """Configuration and resources for a ClickHouse server."""

    @property
    def zookeeper(self) -> global___ConfigSpec.Zookeeper:
        """Configuration and resources for a ZooKeeper server."""

    @property
    def backup_window_start(self) -> google.type.timeofday_pb2.TimeOfDay:
        """Time to start the daily backup, in the UTC timezone."""

    @property
    def access(self) -> yandex.cloud.mdb.clickhouse.v1.cluster_pb2.Access:
        """Access policy for external services.

        If you want a specific service to access the ClickHouse cluster, then set the necessary values in this policy.
        """

    @property
    def cloud_storage(self) -> yandex.cloud.mdb.clickhouse.v1.cluster_pb2.CloudStorage: ...
    @property
    def sql_database_management(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Whether database management through SQL commands is enabled."""

    @property
    def sql_user_management(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Whether user management through SQL commands is enabled."""

    @property
    def embedded_keeper(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Whether cluster should use embedded Keeper instead of Zookeeper"""

    @property
    def backup_retain_period_days(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Retain period of automatically created backup in days"""

    def __init__(
        self,
        *,
        version: builtins.str = ...,
        clickhouse: global___ConfigSpec.Clickhouse | None = ...,
        zookeeper: global___ConfigSpec.Zookeeper | None = ...,
        backup_window_start: google.type.timeofday_pb2.TimeOfDay | None = ...,
        access: yandex.cloud.mdb.clickhouse.v1.cluster_pb2.Access | None = ...,
        cloud_storage: yandex.cloud.mdb.clickhouse.v1.cluster_pb2.CloudStorage | None = ...,
        sql_database_management: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        sql_user_management: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        admin_password: builtins.str = ...,
        embedded_keeper: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        backup_retain_period_days: google.protobuf.wrappers_pb2.Int64Value | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["access", b"access", "backup_retain_period_days", b"backup_retain_period_days", "backup_window_start", b"backup_window_start", "clickhouse", b"clickhouse", "cloud_storage", b"cloud_storage", "embedded_keeper", b"embedded_keeper", "sql_database_management", b"sql_database_management", "sql_user_management", b"sql_user_management", "zookeeper", b"zookeeper"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["access", b"access", "admin_password", b"admin_password", "backup_retain_period_days", b"backup_retain_period_days", "backup_window_start", b"backup_window_start", "clickhouse", b"clickhouse", "cloud_storage", b"cloud_storage", "embedded_keeper", b"embedded_keeper", "sql_database_management", b"sql_database_management", "sql_user_management", b"sql_user_management", "version", b"version", "zookeeper", b"zookeeper"]) -> None: ...

global___ConfigSpec = ConfigSpec

@typing.final
class ShardConfigSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class Clickhouse(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONFIG_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        WEIGHT_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def config(self) -> yandex.cloud.mdb.clickhouse.v1.config.clickhouse_pb2.ClickhouseConfig:
            """ClickHouse settings for the shard."""

        @property
        def resources(self) -> yandex.cloud.mdb.clickhouse.v1.cluster_pb2.Resources:
            """Computational resources for the shard."""

        @property
        def weight(self) -> google.protobuf.wrappers_pb2.Int64Value:
            """Relative weight of the shard considered when writing data to the cluster.
            For details, see [ClickHouse documentation](https://clickhouse.com/docs/en/operations/table_engines/distributed/).
            """

        @property
        def disk_size_autoscaling(self) -> yandex.cloud.mdb.clickhouse.v1.cluster_pb2.DiskSizeAutoscaling:
            """Disk size autoscaling settings."""

        def __init__(
            self,
            *,
            config: yandex.cloud.mdb.clickhouse.v1.config.clickhouse_pb2.ClickhouseConfig | None = ...,
            resources: yandex.cloud.mdb.clickhouse.v1.cluster_pb2.Resources | None = ...,
            weight: google.protobuf.wrappers_pb2.Int64Value | None = ...,
            disk_size_autoscaling: yandex.cloud.mdb.clickhouse.v1.cluster_pb2.DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources", "weight", b"weight"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources", "weight", b"weight"]) -> None: ...

    CLICKHOUSE_FIELD_NUMBER: builtins.int
    @property
    def clickhouse(self) -> global___ShardConfigSpec.Clickhouse:
        """ClickHouse configuration for a shard."""

    def __init__(
        self,
        *,
        clickhouse: global___ShardConfigSpec.Clickhouse | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["clickhouse", b"clickhouse"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["clickhouse", b"clickhouse"]) -> None: ...

global___ShardConfigSpec = ShardConfigSpec

@typing.final
class ShardSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    CONFIG_SPEC_FIELD_NUMBER: builtins.int
    SHARD_GROUP_NAMES_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the shard to be created."""
    @property
    def config_spec(self) -> global___ShardConfigSpec:
        """Configuration of the shard to be created."""

    @property
    def shard_group_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Shard groups that contain the shard."""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        config_spec: global___ShardConfigSpec | None = ...,
        shard_group_names: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["config_spec", b"config_spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["config_spec", b"config_spec", "name", b"name", "shard_group_names", b"shard_group_names"]) -> None: ...

global___ShardSpec = ShardSpec
