"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import abc
import collections.abc
import grpc
import grpc.aio
import typing
import yandex.cloud.mdb.clickhouse.v1.cluster_pb2
import yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2
import yandex.cloud.operation.operation_pb2

_T = typing.TypeVar("_T")

class _MaybeAsyncIterator(collections.abc.AsyncIterator[_T], collections.abc.Iterator[_T], metaclass=abc.ABCMeta): ...

class _ServicerContext(grpc.ServicerContext, grpc.aio.ServicerContext):  # type: ignore[misc, type-arg]
    ...

class ClusterServiceStub:
    """A set of methods for managing ClickHouse clusters."""

    def __init__(self, channel: typing.Union[grpc.Channel, grpc.aio.Channel]) -> None: ...
    Get: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.GetClusterRequest,
        yandex.cloud.mdb.clickhouse.v1.cluster_pb2.Cluster,
    ]
    """Returns the specified ClickHouse cluster.

    To get the list of available ClickHouse clusters, make a [List] request.
    """

    List: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClustersRequest,
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClustersResponse,
    ]
    """Retrieves a list of ClickHouse clusters that belong
    to the specified folder.
    """

    Create: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.CreateClusterRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Creates a ClickHouse cluster in the specified folder."""

    Update: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.UpdateClusterRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates the specified ClickHouse cluster."""

    Delete: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.DeleteClusterRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Deletes the specified ClickHouse cluster."""

    Start: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.StartClusterRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Starts the specified ClickHouse cluster."""

    Stop: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.StopClusterRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Stops the specified ClickHouse cluster."""

    Move: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.MoveClusterRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Moves a ClickHouse cluster to the specified folder."""

    AddZookeeper: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.AddClusterZookeeperRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Adds a ZooKeeper subcluster to the specified ClickHouse cluster."""

    Backup: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.BackupClusterRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Creates a backup for the specified ClickHouse cluster."""

    Restore: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.RestoreClusterRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Creates a new ClickHouse cluster using the specified backup."""

    RescheduleMaintenance: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.RescheduleMaintenanceRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Reschedules planned maintenance operation."""

    ListLogs: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterLogsRequest,
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterLogsResponse,
    ]
    """Retrieves logs for the specified ClickHouse cluster."""

    StreamLogs: grpc.UnaryStreamMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.StreamClusterLogsRequest,
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.StreamLogRecord,
    ]
    """Same as ListLogs but using server-side streaming. Also allows for `tail -f` semantics."""

    ListOperations: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterOperationsRequest,
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterOperationsResponse,
    ]
    """Retrieves the list of Operation resources for the specified cluster."""

    ListBackups: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterBackupsRequest,
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterBackupsResponse,
    ]
    """Retrieves the list of available backups for the specified ClickHouse cluster."""

    ListHosts: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterHostsRequest,
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterHostsResponse,
    ]
    """Retrieves a list of hosts for the specified cluster."""

    AddHosts: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.AddClusterHostsRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Creates new hosts for a cluster."""

    UpdateHosts: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.UpdateClusterHostsRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates the specified hosts."""

    DeleteHosts: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.DeleteClusterHostsRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Deletes the specified hosts for a cluster."""

    RestartHosts: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.RestartClusterHostsRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]

    GetShard: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.GetClusterShardRequest,
        yandex.cloud.mdb.clickhouse.v1.cluster_pb2.Shard,
    ]
    """Returns the specified shard."""

    ListShards: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterShardsRequest,
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterShardsResponse,
    ]
    """Retrieves a list of shards that belong to the specified cluster."""

    AddShard: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.AddClusterShardRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Creates a new shard in the specified cluster."""

    AddShards: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.AddClusterShardsRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Creates one or more shards in the specified cluster."""

    UpdateShard: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.UpdateClusterShardRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Modifies the specified shard."""

    DeleteShard: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.DeleteClusterShardRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Deletes the specified shard."""

    DeleteShards: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.DeleteClusterShardsRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Deletes the specified shards (one or more)."""

    GetShardGroup: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.GetClusterShardGroupRequest,
        yandex.cloud.mdb.clickhouse.v1.cluster_pb2.ShardGroup,
    ]
    """Returns the specified shard group."""

    ListShardGroups: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterShardGroupsRequest,
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterShardGroupsResponse,
    ]
    """Retrieves a list of shard groups that belong to specified cluster."""

    CreateShardGroup: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.CreateClusterShardGroupRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Creates a new shard group in the specified cluster."""

    UpdateShardGroup: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.UpdateClusterShardGroupRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates the specified shard group."""

    DeleteShardGroup: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.DeleteClusterShardGroupRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Deletes the specified shard group."""

    ListExternalDictionaries: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterExternalDictionariesRequest,
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterExternalDictionariesResponse,
    ]
    """Retrieves a list of external dictionaries that belong to specified cluster."""

    CreateExternalDictionary: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.CreateClusterExternalDictionaryRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Creates an external dictionary for the specified ClickHouse cluster."""

    UpdateExternalDictionary: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.UpdateClusterExternalDictionaryRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates an external dictionary for the specified ClickHouse cluster."""

    DeleteExternalDictionary: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.DeleteClusterExternalDictionaryRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Deletes the specified external dictionary."""

class ClusterServiceAsyncStub:
    """A set of methods for managing ClickHouse clusters."""

    Get: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.GetClusterRequest,
        yandex.cloud.mdb.clickhouse.v1.cluster_pb2.Cluster,
    ]
    """Returns the specified ClickHouse cluster.

    To get the list of available ClickHouse clusters, make a [List] request.
    """

    List: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClustersRequest,
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClustersResponse,
    ]
    """Retrieves a list of ClickHouse clusters that belong
    to the specified folder.
    """

    Create: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.CreateClusterRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Creates a ClickHouse cluster in the specified folder."""

    Update: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.UpdateClusterRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates the specified ClickHouse cluster."""

    Delete: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.DeleteClusterRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Deletes the specified ClickHouse cluster."""

    Start: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.StartClusterRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Starts the specified ClickHouse cluster."""

    Stop: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.StopClusterRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Stops the specified ClickHouse cluster."""

    Move: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.MoveClusterRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Moves a ClickHouse cluster to the specified folder."""

    AddZookeeper: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.AddClusterZookeeperRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Adds a ZooKeeper subcluster to the specified ClickHouse cluster."""

    Backup: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.BackupClusterRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Creates a backup for the specified ClickHouse cluster."""

    Restore: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.RestoreClusterRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Creates a new ClickHouse cluster using the specified backup."""

    RescheduleMaintenance: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.RescheduleMaintenanceRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Reschedules planned maintenance operation."""

    ListLogs: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterLogsRequest,
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterLogsResponse,
    ]
    """Retrieves logs for the specified ClickHouse cluster."""

    StreamLogs: grpc.aio.UnaryStreamMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.StreamClusterLogsRequest,
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.StreamLogRecord,
    ]
    """Same as ListLogs but using server-side streaming. Also allows for `tail -f` semantics."""

    ListOperations: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterOperationsRequest,
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterOperationsResponse,
    ]
    """Retrieves the list of Operation resources for the specified cluster."""

    ListBackups: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterBackupsRequest,
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterBackupsResponse,
    ]
    """Retrieves the list of available backups for the specified ClickHouse cluster."""

    ListHosts: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterHostsRequest,
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterHostsResponse,
    ]
    """Retrieves a list of hosts for the specified cluster."""

    AddHosts: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.AddClusterHostsRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Creates new hosts for a cluster."""

    UpdateHosts: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.UpdateClusterHostsRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates the specified hosts."""

    DeleteHosts: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.DeleteClusterHostsRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Deletes the specified hosts for a cluster."""

    RestartHosts: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.RestartClusterHostsRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]

    GetShard: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.GetClusterShardRequest,
        yandex.cloud.mdb.clickhouse.v1.cluster_pb2.Shard,
    ]
    """Returns the specified shard."""

    ListShards: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterShardsRequest,
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterShardsResponse,
    ]
    """Retrieves a list of shards that belong to the specified cluster."""

    AddShard: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.AddClusterShardRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Creates a new shard in the specified cluster."""

    AddShards: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.AddClusterShardsRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Creates one or more shards in the specified cluster."""

    UpdateShard: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.UpdateClusterShardRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Modifies the specified shard."""

    DeleteShard: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.DeleteClusterShardRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Deletes the specified shard."""

    DeleteShards: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.DeleteClusterShardsRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Deletes the specified shards (one or more)."""

    GetShardGroup: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.GetClusterShardGroupRequest,
        yandex.cloud.mdb.clickhouse.v1.cluster_pb2.ShardGroup,
    ]
    """Returns the specified shard group."""

    ListShardGroups: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterShardGroupsRequest,
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterShardGroupsResponse,
    ]
    """Retrieves a list of shard groups that belong to specified cluster."""

    CreateShardGroup: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.CreateClusterShardGroupRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Creates a new shard group in the specified cluster."""

    UpdateShardGroup: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.UpdateClusterShardGroupRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates the specified shard group."""

    DeleteShardGroup: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.DeleteClusterShardGroupRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Deletes the specified shard group."""

    ListExternalDictionaries: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterExternalDictionariesRequest,
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterExternalDictionariesResponse,
    ]
    """Retrieves a list of external dictionaries that belong to specified cluster."""

    CreateExternalDictionary: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.CreateClusterExternalDictionaryRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Creates an external dictionary for the specified ClickHouse cluster."""

    UpdateExternalDictionary: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.UpdateClusterExternalDictionaryRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates an external dictionary for the specified ClickHouse cluster."""

    DeleteExternalDictionary: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.DeleteClusterExternalDictionaryRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Deletes the specified external dictionary."""

class ClusterServiceServicer(metaclass=abc.ABCMeta):
    """A set of methods for managing ClickHouse clusters."""

    @abc.abstractmethod
    def Get(
        self,
        request: yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.GetClusterRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.mdb.clickhouse.v1.cluster_pb2.Cluster, collections.abc.Awaitable[yandex.cloud.mdb.clickhouse.v1.cluster_pb2.Cluster]]:
        """Returns the specified ClickHouse cluster.

        To get the list of available ClickHouse clusters, make a [List] request.
        """

    @abc.abstractmethod
    def List(
        self,
        request: yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClustersRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClustersResponse, collections.abc.Awaitable[yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClustersResponse]]:
        """Retrieves a list of ClickHouse clusters that belong
        to the specified folder.
        """

    @abc.abstractmethod
    def Create(
        self,
        request: yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.CreateClusterRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Creates a ClickHouse cluster in the specified folder."""

    @abc.abstractmethod
    def Update(
        self,
        request: yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.UpdateClusterRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Updates the specified ClickHouse cluster."""

    @abc.abstractmethod
    def Delete(
        self,
        request: yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.DeleteClusterRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Deletes the specified ClickHouse cluster."""

    @abc.abstractmethod
    def Start(
        self,
        request: yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.StartClusterRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Starts the specified ClickHouse cluster."""

    @abc.abstractmethod
    def Stop(
        self,
        request: yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.StopClusterRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Stops the specified ClickHouse cluster."""

    @abc.abstractmethod
    def Move(
        self,
        request: yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.MoveClusterRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Moves a ClickHouse cluster to the specified folder."""

    @abc.abstractmethod
    def AddZookeeper(
        self,
        request: yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.AddClusterZookeeperRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Adds a ZooKeeper subcluster to the specified ClickHouse cluster."""

    @abc.abstractmethod
    def Backup(
        self,
        request: yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.BackupClusterRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Creates a backup for the specified ClickHouse cluster."""

    @abc.abstractmethod
    def Restore(
        self,
        request: yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.RestoreClusterRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Creates a new ClickHouse cluster using the specified backup."""

    @abc.abstractmethod
    def RescheduleMaintenance(
        self,
        request: yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.RescheduleMaintenanceRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Reschedules planned maintenance operation."""

    @abc.abstractmethod
    def ListLogs(
        self,
        request: yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterLogsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterLogsResponse, collections.abc.Awaitable[yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterLogsResponse]]:
        """Retrieves logs for the specified ClickHouse cluster."""

    @abc.abstractmethod
    def StreamLogs(
        self,
        request: yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.StreamClusterLogsRequest,
        context: _ServicerContext,
    ) -> typing.Union[collections.abc.Iterator[yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.StreamLogRecord], collections.abc.AsyncIterator[yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.StreamLogRecord]]:
        """Same as ListLogs but using server-side streaming. Also allows for `tail -f` semantics."""

    @abc.abstractmethod
    def ListOperations(
        self,
        request: yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterOperationsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterOperationsResponse, collections.abc.Awaitable[yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterOperationsResponse]]:
        """Retrieves the list of Operation resources for the specified cluster."""

    @abc.abstractmethod
    def ListBackups(
        self,
        request: yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterBackupsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterBackupsResponse, collections.abc.Awaitable[yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterBackupsResponse]]:
        """Retrieves the list of available backups for the specified ClickHouse cluster."""

    @abc.abstractmethod
    def ListHosts(
        self,
        request: yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterHostsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterHostsResponse, collections.abc.Awaitable[yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterHostsResponse]]:
        """Retrieves a list of hosts for the specified cluster."""

    @abc.abstractmethod
    def AddHosts(
        self,
        request: yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.AddClusterHostsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Creates new hosts for a cluster."""

    @abc.abstractmethod
    def UpdateHosts(
        self,
        request: yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.UpdateClusterHostsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Updates the specified hosts."""

    @abc.abstractmethod
    def DeleteHosts(
        self,
        request: yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.DeleteClusterHostsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Deletes the specified hosts for a cluster."""

    @abc.abstractmethod
    def RestartHosts(
        self,
        request: yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.RestartClusterHostsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]: ...

    @abc.abstractmethod
    def GetShard(
        self,
        request: yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.GetClusterShardRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.mdb.clickhouse.v1.cluster_pb2.Shard, collections.abc.Awaitable[yandex.cloud.mdb.clickhouse.v1.cluster_pb2.Shard]]:
        """Returns the specified shard."""

    @abc.abstractmethod
    def ListShards(
        self,
        request: yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterShardsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterShardsResponse, collections.abc.Awaitable[yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterShardsResponse]]:
        """Retrieves a list of shards that belong to the specified cluster."""

    @abc.abstractmethod
    def AddShard(
        self,
        request: yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.AddClusterShardRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Creates a new shard in the specified cluster."""

    @abc.abstractmethod
    def AddShards(
        self,
        request: yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.AddClusterShardsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Creates one or more shards in the specified cluster."""

    @abc.abstractmethod
    def UpdateShard(
        self,
        request: yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.UpdateClusterShardRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Modifies the specified shard."""

    @abc.abstractmethod
    def DeleteShard(
        self,
        request: yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.DeleteClusterShardRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Deletes the specified shard."""

    @abc.abstractmethod
    def DeleteShards(
        self,
        request: yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.DeleteClusterShardsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Deletes the specified shards (one or more)."""

    @abc.abstractmethod
    def GetShardGroup(
        self,
        request: yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.GetClusterShardGroupRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.mdb.clickhouse.v1.cluster_pb2.ShardGroup, collections.abc.Awaitable[yandex.cloud.mdb.clickhouse.v1.cluster_pb2.ShardGroup]]:
        """Returns the specified shard group."""

    @abc.abstractmethod
    def ListShardGroups(
        self,
        request: yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterShardGroupsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterShardGroupsResponse, collections.abc.Awaitable[yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterShardGroupsResponse]]:
        """Retrieves a list of shard groups that belong to specified cluster."""

    @abc.abstractmethod
    def CreateShardGroup(
        self,
        request: yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.CreateClusterShardGroupRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Creates a new shard group in the specified cluster."""

    @abc.abstractmethod
    def UpdateShardGroup(
        self,
        request: yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.UpdateClusterShardGroupRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Updates the specified shard group."""

    @abc.abstractmethod
    def DeleteShardGroup(
        self,
        request: yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.DeleteClusterShardGroupRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Deletes the specified shard group."""

    @abc.abstractmethod
    def ListExternalDictionaries(
        self,
        request: yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterExternalDictionariesRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterExternalDictionariesResponse, collections.abc.Awaitable[yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.ListClusterExternalDictionariesResponse]]:
        """Retrieves a list of external dictionaries that belong to specified cluster."""

    @abc.abstractmethod
    def CreateExternalDictionary(
        self,
        request: yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.CreateClusterExternalDictionaryRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Creates an external dictionary for the specified ClickHouse cluster."""

    @abc.abstractmethod
    def UpdateExternalDictionary(
        self,
        request: yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.UpdateClusterExternalDictionaryRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Updates an external dictionary for the specified ClickHouse cluster."""

    @abc.abstractmethod
    def DeleteExternalDictionary(
        self,
        request: yandex.cloud.mdb.clickhouse.v1.cluster_service_pb2.DeleteClusterExternalDictionaryRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Deletes the specified external dictionary."""

def add_ClusterServiceServicer_to_server(servicer: ClusterServiceServicer, server: typing.Union[grpc.Server, grpc.aio.Server]) -> None: ...
