"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing
import yandex.cloud.mdb.elasticsearch.v1.config.elasticsearch_pb2
import yandex.cloud.mdb.elasticsearch.v1.maintenance_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Cluster(google.protobuf.message.Message):
    """An Elasticsearch cluster resource.
    For more information, see the [Concepts](/docs/managed-elasticsearch/concepts) section of the documentation.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Environment:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EnvironmentEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Cluster._Environment.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        ENVIRONMENT_UNSPECIFIED: Cluster._Environment.ValueType  # 0
        PRODUCTION: Cluster._Environment.ValueType  # 1
        """Stable environment with a conservative update policy when only hotfixes are applied during regular maintenance."""
        PRESTABLE: Cluster._Environment.ValueType  # 2
        """Environment with a more aggressive update policy when new versions are rolled out irrespective of backward compatibility."""

    class Environment(_Environment, metaclass=_EnvironmentEnumTypeWrapper): ...
    ENVIRONMENT_UNSPECIFIED: Cluster.Environment.ValueType  # 0
    PRODUCTION: Cluster.Environment.ValueType  # 1
    """Stable environment with a conservative update policy when only hotfixes are applied during regular maintenance."""
    PRESTABLE: Cluster.Environment.ValueType  # 2
    """Environment with a more aggressive update policy when new versions are rolled out irrespective of backward compatibility."""

    class _Health:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _HealthEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Cluster._Health.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        HEALTH_UNKNOWN: Cluster._Health.ValueType  # 0
        """State of the cluster is unknown ([Host.health] of all hosts in the cluster is `UNKNOWN`)."""
        ALIVE: Cluster._Health.ValueType  # 1
        """Cluster is alive and well ([Host.health] of all hosts in the cluster is `ALIVE`)."""
        DEAD: Cluster._Health.ValueType  # 2
        """Cluster is inoperable ([Host.health] of all hosts in the cluster is `DEAD`)."""
        DEGRADED: Cluster._Health.ValueType  # 3
        """Cluster is in degraded state ([Host.health] of at least one of the hosts in the cluster is not `ALIVE`)."""

    class Health(_Health, metaclass=_HealthEnumTypeWrapper): ...
    HEALTH_UNKNOWN: Cluster.Health.ValueType  # 0
    """State of the cluster is unknown ([Host.health] of all hosts in the cluster is `UNKNOWN`)."""
    ALIVE: Cluster.Health.ValueType  # 1
    """Cluster is alive and well ([Host.health] of all hosts in the cluster is `ALIVE`)."""
    DEAD: Cluster.Health.ValueType  # 2
    """Cluster is inoperable ([Host.health] of all hosts in the cluster is `DEAD`)."""
    DEGRADED: Cluster.Health.ValueType  # 3
    """Cluster is in degraded state ([Host.health] of at least one of the hosts in the cluster is not `ALIVE`)."""

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Cluster._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNKNOWN: Cluster._Status.ValueType  # 0
        """Cluster state is unknown."""
        CREATING: Cluster._Status.ValueType  # 1
        """Cluster is being created."""
        RUNNING: Cluster._Status.ValueType  # 2
        """Cluster is running normally."""
        ERROR: Cluster._Status.ValueType  # 3
        """Cluster encountered a problem and cannot operate."""
        UPDATING: Cluster._Status.ValueType  # 4
        """Cluster is being updated."""
        STOPPING: Cluster._Status.ValueType  # 5
        """Cluster is stopping."""
        STOPPED: Cluster._Status.ValueType  # 6
        """Cluster stopped."""
        STARTING: Cluster._Status.ValueType  # 7
        """Cluster is starting."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNKNOWN: Cluster.Status.ValueType  # 0
    """Cluster state is unknown."""
    CREATING: Cluster.Status.ValueType  # 1
    """Cluster is being created."""
    RUNNING: Cluster.Status.ValueType  # 2
    """Cluster is running normally."""
    ERROR: Cluster.Status.ValueType  # 3
    """Cluster encountered a problem and cannot operate."""
    UPDATING: Cluster.Status.ValueType  # 4
    """Cluster is being updated."""
    STOPPING: Cluster.Status.ValueType  # 5
    """Cluster is stopping."""
    STOPPED: Cluster.Status.ValueType  # 6
    """Cluster stopped."""
    STARTING: Cluster.Status.ValueType  # 7
    """Cluster is starting."""

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    ENVIRONMENT_FIELD_NUMBER: builtins.int
    MONITORING_FIELD_NUMBER: builtins.int
    CONFIG_FIELD_NUMBER: builtins.int
    NETWORK_ID_FIELD_NUMBER: builtins.int
    HEALTH_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    SECURITY_GROUP_IDS_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    MAINTENANCE_WINDOW_FIELD_NUMBER: builtins.int
    PLANNED_OPERATION_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the Elasticsearch cluster.
    This ID is assigned at creation time.
    """
    folder_id: builtins.str
    """ID of the folder that the Elasticsearch cluster belongs to."""
    name: builtins.str
    """Name of the Elasticsearch cluster.
    The name must be unique within the folder. 1-63 characters long.
    """
    description: builtins.str
    """Description of the Elasticsearch cluster. 0-256 characters long."""
    environment: global___Cluster.Environment.ValueType
    """Deployment environment of the Elasticsearch cluster."""
    network_id: builtins.str
    """ID of the network that the cluster belongs to."""
    health: global___Cluster.Health.ValueType
    """Aggregated cluster health."""
    status: global___Cluster.Status.ValueType
    """Current state of the cluster."""
    service_account_id: builtins.str
    """ID of the service account used for access to Object Storage."""
    deletion_protection: builtins.bool
    """Deletion Protection inhibits deletion of the cluster"""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Custom labels for the Elasticsearch cluster as `key:value` pairs.
        A maximum of 64 labels per resource is allowed.
        """

    @property
    def monitoring(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Monitoring]:
        """Description of monitoring systems relevant to the Elasticsearch cluster."""

    @property
    def config(self) -> global___ClusterConfig:
        """Configuration of the Elasticsearch cluster."""

    @property
    def security_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """User security groups"""

    @property
    def maintenance_window(self) -> yandex.cloud.mdb.elasticsearch.v1.maintenance_pb2.MaintenanceWindow:
        """Window of maintenance operations."""

    @property
    def planned_operation(self) -> yandex.cloud.mdb.elasticsearch.v1.maintenance_pb2.MaintenanceOperation:
        """Maintenance operation planned at nearest maintenance_window."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        folder_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        environment: global___Cluster.Environment.ValueType = ...,
        monitoring: collections.abc.Iterable[global___Monitoring] | None = ...,
        config: global___ClusterConfig | None = ...,
        network_id: builtins.str = ...,
        health: global___Cluster.Health.ValueType = ...,
        status: global___Cluster.Status.ValueType = ...,
        security_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
        service_account_id: builtins.str = ...,
        deletion_protection: builtins.bool = ...,
        maintenance_window: yandex.cloud.mdb.elasticsearch.v1.maintenance_pb2.MaintenanceWindow | None = ...,
        planned_operation: yandex.cloud.mdb.elasticsearch.v1.maintenance_pb2.MaintenanceOperation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["config", b"config", "created_at", b"created_at", "maintenance_window", b"maintenance_window", "planned_operation", b"planned_operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["config", b"config", "created_at", b"created_at", "deletion_protection", b"deletion_protection", "description", b"description", "environment", b"environment", "folder_id", b"folder_id", "health", b"health", "id", b"id", "labels", b"labels", "maintenance_window", b"maintenance_window", "monitoring", b"monitoring", "name", b"name", "network_id", b"network_id", "planned_operation", b"planned_operation", "security_group_ids", b"security_group_ids", "service_account_id", b"service_account_id", "status", b"status"]) -> None: ...

global___Cluster = Cluster

@typing.final
class Monitoring(google.protobuf.message.Message):
    """Metadata of monitoring system."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LINK_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the monitoring system."""
    description: builtins.str
    """Description of the monitoring system."""
    link: builtins.str
    """Link to the monitoring system charts for the Elasticsearch cluster."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        description: builtins.str = ...,
        link: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "link", b"link", "name", b"name"]) -> None: ...

global___Monitoring = Monitoring

@typing.final
class ClusterConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VERSION_FIELD_NUMBER: builtins.int
    ELASTICSEARCH_FIELD_NUMBER: builtins.int
    EDITION_FIELD_NUMBER: builtins.int
    version: builtins.str
    """Elasticsearch version."""
    edition: builtins.str
    """ElasticSearch edition."""
    @property
    def elasticsearch(self) -> global___Elasticsearch:
        """Configuration and resource allocation for Elasticsearch nodes."""

    def __init__(
        self,
        *,
        version: builtins.str = ...,
        elasticsearch: global___Elasticsearch | None = ...,
        edition: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["elasticsearch", b"elasticsearch"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["edition", b"edition", "elasticsearch", b"elasticsearch", "version", b"version"]) -> None: ...

global___ClusterConfig = ClusterConfig

@typing.final
class Elasticsearch(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class DataNode(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ELASTICSEARCH_CONFIG_SET_7_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        @property
        def elasticsearch_config_set_7(self) -> yandex.cloud.mdb.elasticsearch.v1.config.elasticsearch_pb2.ElasticsearchConfigSet7:
            """Elasticsearch 7.x data node configuration."""

        @property
        def resources(self) -> global___Resources:
            """Resources allocated to Elasticsearch data nodes."""

        def __init__(
            self,
            *,
            elasticsearch_config_set_7: yandex.cloud.mdb.elasticsearch.v1.config.elasticsearch_pb2.ElasticsearchConfigSet7 | None = ...,
            resources: global___Resources | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config", b"config", "elasticsearch_config_set_7", b"elasticsearch_config_set_7", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config", b"config", "elasticsearch_config_set_7", b"elasticsearch_config_set_7", "resources", b"resources"]) -> None: ...
        def WhichOneof(self, oneof_group: typing.Literal["config", b"config"]) -> typing.Literal["elasticsearch_config_set_7"] | None: ...

    @typing.final
    class MasterNode(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        RESOURCES_FIELD_NUMBER: builtins.int
        @property
        def resources(self) -> global___Resources:
            """Resources allocated to Elasticsearch master nodes."""

        def __init__(
            self,
            *,
            resources: global___Resources | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["resources", b"resources"]) -> None: ...

    DATA_NODE_FIELD_NUMBER: builtins.int
    MASTER_NODE_FIELD_NUMBER: builtins.int
    PLUGINS_FIELD_NUMBER: builtins.int
    @property
    def data_node(self) -> global___Elasticsearch.DataNode:
        """Configuration and resource allocation for Elasticsearch data nodes."""

    @property
    def master_node(self) -> global___Elasticsearch.MasterNode:
        """Configuration and resource allocation for Elasticsearch master nodes."""

    @property
    def plugins(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Cluster wide plugins"""

    def __init__(
        self,
        *,
        data_node: global___Elasticsearch.DataNode | None = ...,
        master_node: global___Elasticsearch.MasterNode | None = ...,
        plugins: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["data_node", b"data_node", "master_node", b"master_node"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["data_node", b"data_node", "master_node", b"master_node", "plugins", b"plugins"]) -> None: ...

global___Elasticsearch = Elasticsearch

@typing.final
class Resources(google.protobuf.message.Message):
    """Computational resources."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOURCE_PRESET_ID_FIELD_NUMBER: builtins.int
    DISK_SIZE_FIELD_NUMBER: builtins.int
    DISK_TYPE_ID_FIELD_NUMBER: builtins.int
    resource_preset_id: builtins.str
    """ID of the preset for computational resources available to a host (CPU, memory etc.).
    All available presets are listed in the [documentation](/docs/managed-elasticsearch/concepts/instance-types).
    """
    disk_size: builtins.int
    """Volume of the storage available to a host, in bytes."""
    disk_type_id: builtins.str
    """Type of the storage environment for the host.
    All available types are listed in the [documentation](/docs/managed-elasticsearch/concepts/storage).
    """
    def __init__(
        self,
        *,
        resource_preset_id: builtins.str = ...,
        disk_size: builtins.int = ...,
        disk_type_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["disk_size", b"disk_size", "disk_type_id", b"disk_type_id", "resource_preset_id", b"resource_preset_id"]) -> None: ...

global___Resources = Resources

@typing.final
class Host(google.protobuf.message.Message):
    """Cluster host metadata."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Type:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Host._Type.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        TYPE_UNSPECIFIED: Host._Type.ValueType  # 0
        """Host type is unspecified. Default value."""
        DATA_NODE: Host._Type.ValueType  # 1
        """The host is an Elasticsearch data node."""
        MASTER_NODE: Host._Type.ValueType  # 2
        """The host is an Elasticsearch master node."""

    class Type(_Type, metaclass=_TypeEnumTypeWrapper): ...
    TYPE_UNSPECIFIED: Host.Type.ValueType  # 0
    """Host type is unspecified. Default value."""
    DATA_NODE: Host.Type.ValueType  # 1
    """The host is an Elasticsearch data node."""
    MASTER_NODE: Host.Type.ValueType  # 2
    """The host is an Elasticsearch master node."""

    class _Health:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _HealthEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Host._Health.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNKNOWN: Host._Health.ValueType  # 0
        """Health of the host is unknown."""
        ALIVE: Host._Health.ValueType  # 1
        """The host is performing all its functions normally."""
        DEAD: Host._Health.ValueType  # 2
        """The host is inoperable and cannot perform any of its essential functions."""
        DEGRADED: Host._Health.ValueType  # 3
        """The host is degraded and can perform only some of its essential functions."""

    class Health(_Health, metaclass=_HealthEnumTypeWrapper): ...
    UNKNOWN: Host.Health.ValueType  # 0
    """Health of the host is unknown."""
    ALIVE: Host.Health.ValueType  # 1
    """The host is performing all its functions normally."""
    DEAD: Host.Health.ValueType  # 2
    """The host is inoperable and cannot perform any of its essential functions."""
    DEGRADED: Host.Health.ValueType  # 3
    """The host is degraded and can perform only some of its essential functions."""

    NAME_FIELD_NUMBER: builtins.int
    CLUSTER_ID_FIELD_NUMBER: builtins.int
    ZONE_ID_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    RESOURCES_FIELD_NUMBER: builtins.int
    HEALTH_FIELD_NUMBER: builtins.int
    SERVICES_FIELD_NUMBER: builtins.int
    SUBNET_ID_FIELD_NUMBER: builtins.int
    ASSIGN_PUBLIC_IP_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the host."""
    cluster_id: builtins.str
    """ID of the Elasticsearch cluster."""
    zone_id: builtins.str
    """ID of the availability zone where the host resides."""
    type: global___Host.Type.ValueType
    """Host type."""
    health: global___Host.Health.ValueType
    """Aggregated host health data. If the field has default value, it is not returned in the response."""
    subnet_id: builtins.str
    """ID of the subnet the host resides in."""
    assign_public_ip: builtins.bool
    """The flag that defines whether a public IP address is assigned to the host.

    If the value is `true`, then this host is available on the Internet via it's public IP address.
    """
    @property
    def resources(self) -> global___Resources: ...
    @property
    def services(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Service]:
        """Services provided by the host."""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        cluster_id: builtins.str = ...,
        zone_id: builtins.str = ...,
        type: global___Host.Type.ValueType = ...,
        resources: global___Resources | None = ...,
        health: global___Host.Health.ValueType = ...,
        services: collections.abc.Iterable[global___Service] | None = ...,
        subnet_id: builtins.str = ...,
        assign_public_ip: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["resources", b"resources"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["assign_public_ip", b"assign_public_ip", "cluster_id", b"cluster_id", "health", b"health", "name", b"name", "resources", b"resources", "services", b"services", "subnet_id", b"subnet_id", "type", b"type", "zone_id", b"zone_id"]) -> None: ...

global___Host = Host

@typing.final
class Service(google.protobuf.message.Message):
    """Cluster service metadata."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Type:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Service._Type.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        TYPE_UNSPECIFIED: Service._Type.ValueType  # 0
        ELASTICSEARCH: Service._Type.ValueType  # 1
        """The Elasticsearch service."""

    class Type(_Type, metaclass=_TypeEnumTypeWrapper): ...
    TYPE_UNSPECIFIED: Service.Type.ValueType  # 0
    ELASTICSEARCH: Service.Type.ValueType  # 1
    """The Elasticsearch service."""

    class _Health:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _HealthEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Service._Health.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNKNOWN: Service._Health.ValueType  # 0
        """Health of the service is unknown."""
        ALIVE: Service._Health.ValueType  # 1
        """The service is working normally."""
        DEAD: Service._Health.ValueType  # 2
        """The service is dead or unresponsive."""

    class Health(_Health, metaclass=_HealthEnumTypeWrapper): ...
    UNKNOWN: Service.Health.ValueType  # 0
    """Health of the service is unknown."""
    ALIVE: Service.Health.ValueType  # 1
    """The service is working normally."""
    DEAD: Service.Health.ValueType  # 2
    """The service is dead or unresponsive."""

    TYPE_FIELD_NUMBER: builtins.int
    HEALTH_FIELD_NUMBER: builtins.int
    type: global___Service.Type.ValueType
    """Type of the service provided by the host."""
    health: global___Service.Health.ValueType
    """Service health data. If the field has default value, it is not returned in the response."""
    def __init__(
        self,
        *,
        type: global___Service.Type.ValueType = ...,
        health: global___Service.Health.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["health", b"health", "type", b"type"]) -> None: ...

global___Service = Service
