"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing
import yandex.cloud.mdb.greenplum.v1.backup_pb2
import yandex.cloud.mdb.greenplum.v1.cluster_pb2
import yandex.cloud.mdb.greenplum.v1.config_pb2
import yandex.cloud.mdb.greenplum.v1.host_pb2
import yandex.cloud.mdb.greenplum.v1.maintenance_pb2
import yandex.cloud.mdb.greenplum.v1.pxf_pb2
import yandex.cloud.operation.operation_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Greenplum® cluster resource to return.

    To get the cluster ID, use a [ClusterService.List] request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___GetClusterRequest = GetClusterRequest

@typing.final
class ListClustersRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to list Greenplum® clusters in.

    To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return.

    If the number of available results is larger than [page_size], the service returns a [ListClustersResponse.next_page_token] that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the [ListClustersResponse.next_page_token] returned by the previous list request."""
    filter: builtins.str
    """A filter expression that filters resources listed in the response.

    The expression must specify:

    1. The field name. Currently you can only use filtering with the [Cluster.name] field.

    2. An `=` operator.

    3. The value in double quotes (`"`). Must be 1-63 characters long and match the regular expression `[a-zA-Z0-9_-]+`.
    """
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "folder_id", b"folder_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListClustersRequest = ListClustersRequest

@typing.final
class ListClustersResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTERS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests.

    If the number of results is larger than [ListClustersRequest.page_size], use the [next_page_token] as the value for the [ListClustersRequest.page_token] parameter in the next list request.

    Each subsequent list request has its own [next_page_token] to continue paging through the results.
    """
    @property
    def clusters(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.mdb.greenplum.v1.cluster_pb2.Cluster]:
        """List of Greenplum® cluster resources."""

    def __init__(
        self,
        *,
        clusters: collections.abc.Iterable[yandex.cloud.mdb.greenplum.v1.cluster_pb2.Cluster] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clusters", b"clusters", "next_page_token", b"next_page_token"]) -> None: ...

global___ListClustersResponse = ListClustersResponse

@typing.final
class CreateClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    ENVIRONMENT_FIELD_NUMBER: builtins.int
    CONFIG_FIELD_NUMBER: builtins.int
    MASTER_CONFIG_FIELD_NUMBER: builtins.int
    SEGMENT_CONFIG_FIELD_NUMBER: builtins.int
    MASTER_HOST_COUNT_FIELD_NUMBER: builtins.int
    SEGMENT_IN_HOST_FIELD_NUMBER: builtins.int
    SEGMENT_HOST_COUNT_FIELD_NUMBER: builtins.int
    USER_NAME_FIELD_NUMBER: builtins.int
    USER_PASSWORD_FIELD_NUMBER: builtins.int
    NETWORK_ID_FIELD_NUMBER: builtins.int
    SECURITY_GROUP_IDS_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    HOST_GROUP_IDS_FIELD_NUMBER: builtins.int
    MAINTENANCE_WINDOW_FIELD_NUMBER: builtins.int
    CONFIG_SPEC_FIELD_NUMBER: builtins.int
    CLOUD_STORAGE_FIELD_NUMBER: builtins.int
    MASTER_HOST_GROUP_IDS_FIELD_NUMBER: builtins.int
    SEGMENT_HOST_GROUP_IDS_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    LOGGING_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to create the Greenplum® cluster in."""
    name: builtins.str
    """Name of the Greenplum® cluster. The name must be unique within the folder."""
    description: builtins.str
    """Description of the Greenplum® cluster."""
    environment: yandex.cloud.mdb.greenplum.v1.cluster_pb2.Cluster.Environment.ValueType
    """Deployment environment of the Greenplum® cluster."""
    master_host_count: builtins.int
    """Number of hosts in the master subcluster."""
    segment_in_host: builtins.int
    """Number of segments per host."""
    segment_host_count: builtins.int
    """Number of hosts in the segment subcluster."""
    user_name: builtins.str
    """Owner user name."""
    user_password: builtins.str
    """Owner user password."""
    network_id: builtins.str
    """ID of the network to create the cluster in."""
    deletion_protection: builtins.bool
    """Determines whether the cluster is protected from being deleted."""
    service_account_id: builtins.str
    """ID of the service account used for access Yandex Cloud resources."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Custom labels for the Greenplum® cluster as `key:value` pairs.
        For example, `"project":"mvp"` or `"source":"dictionary"`.
        """

    @property
    def config(self) -> yandex.cloud.mdb.greenplum.v1.cluster_pb2.GreenplumConfig:
        """Greenplum® cluster configuration."""

    @property
    def master_config(self) -> global___MasterSubclusterConfigSpec:
        """Configuration of the Greenplum® master subcluster."""

    @property
    def segment_config(self) -> global___SegmentSubclusterConfigSpec:
        """Configuration of the Greenplum® segment subcluster."""

    @property
    def security_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """User security groups."""

    @property
    def host_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Host groups to place VMs of the cluster in."""

    @property
    def maintenance_window(self) -> yandex.cloud.mdb.greenplum.v1.maintenance_pb2.MaintenanceWindow:
        """A Greenplum® cluster maintenance window. Should be defined by either one of the two options."""

    @property
    def config_spec(self) -> global___ConfigSpec:
        """Configuration of Greenplum® and Odyssey®."""

    @property
    def cloud_storage(self) -> yandex.cloud.mdb.greenplum.v1.cluster_pb2.CloudStorage:
        """Cloud storage settings"""

    @property
    def master_host_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Host groups hosting VMs of the master subcluster."""

    @property
    def segment_host_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Host groups hosting VMs of the segment subcluster."""

    @property
    def logging(self) -> yandex.cloud.mdb.greenplum.v1.cluster_pb2.LoggingConfig:
        """Cloud logging configuration"""

    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        environment: yandex.cloud.mdb.greenplum.v1.cluster_pb2.Cluster.Environment.ValueType = ...,
        config: yandex.cloud.mdb.greenplum.v1.cluster_pb2.GreenplumConfig | None = ...,
        master_config: global___MasterSubclusterConfigSpec | None = ...,
        segment_config: global___SegmentSubclusterConfigSpec | None = ...,
        master_host_count: builtins.int = ...,
        segment_in_host: builtins.int = ...,
        segment_host_count: builtins.int = ...,
        user_name: builtins.str = ...,
        user_password: builtins.str = ...,
        network_id: builtins.str = ...,
        security_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
        deletion_protection: builtins.bool = ...,
        host_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
        maintenance_window: yandex.cloud.mdb.greenplum.v1.maintenance_pb2.MaintenanceWindow | None = ...,
        config_spec: global___ConfigSpec | None = ...,
        cloud_storage: yandex.cloud.mdb.greenplum.v1.cluster_pb2.CloudStorage | None = ...,
        master_host_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
        segment_host_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
        service_account_id: builtins.str = ...,
        logging: yandex.cloud.mdb.greenplum.v1.cluster_pb2.LoggingConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["cloud_storage", b"cloud_storage", "config", b"config", "config_spec", b"config_spec", "logging", b"logging", "maintenance_window", b"maintenance_window", "master_config", b"master_config", "segment_config", b"segment_config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cloud_storage", b"cloud_storage", "config", b"config", "config_spec", b"config_spec", "deletion_protection", b"deletion_protection", "description", b"description", "environment", b"environment", "folder_id", b"folder_id", "host_group_ids", b"host_group_ids", "labels", b"labels", "logging", b"logging", "maintenance_window", b"maintenance_window", "master_config", b"master_config", "master_host_count", b"master_host_count", "master_host_group_ids", b"master_host_group_ids", "name", b"name", "network_id", b"network_id", "security_group_ids", b"security_group_ids", "segment_config", b"segment_config", "segment_host_count", b"segment_host_count", "segment_host_group_ids", b"segment_host_group_ids", "segment_in_host", b"segment_in_host", "service_account_id", b"service_account_id", "user_name", b"user_name", "user_password", b"user_password"]) -> None: ...

global___CreateClusterRequest = CreateClusterRequest

@typing.final
class ConfigSpec(google.protobuf.message.Message):
    """Configuration of Greenplum® and Odyssey®."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GREENPLUM_CONFIG_6_17_FIELD_NUMBER: builtins.int
    GREENPLUM_CONFIG_6_19_FIELD_NUMBER: builtins.int
    GREENPLUM_CONFIG_6_21_FIELD_NUMBER: builtins.int
    GREENPLUM_CONFIG_6_22_FIELD_NUMBER: builtins.int
    GREENPLUM_CONFIG_6_FIELD_NUMBER: builtins.int
    POOL_FIELD_NUMBER: builtins.int
    BACKGROUND_ACTIVITIES_FIELD_NUMBER: builtins.int
    PXF_CONFIG_FIELD_NUMBER: builtins.int
    @property
    def greenplum_config_6_17(self) -> yandex.cloud.mdb.greenplum.v1.config_pb2.GreenplumConfig6_17: ...
    @property
    def greenplum_config_6_19(self) -> yandex.cloud.mdb.greenplum.v1.config_pb2.GreenplumConfig6_19: ...
    @property
    def greenplum_config_6_21(self) -> yandex.cloud.mdb.greenplum.v1.config_pb2.GreenplumConfig6_21: ...
    @property
    def greenplum_config_6_22(self) -> yandex.cloud.mdb.greenplum.v1.config_pb2.GreenplumConfig6_22: ...
    @property
    def greenplum_config_6(self) -> yandex.cloud.mdb.greenplum.v1.config_pb2.GreenplumConfig6: ...
    @property
    def pool(self) -> yandex.cloud.mdb.greenplum.v1.config_pb2.ConnectionPoolerConfig:
        """Odyssey® pool settings."""

    @property
    def background_activities(self) -> yandex.cloud.mdb.greenplum.v1.config_pb2.BackgroundActivitiesConfig:
        """Managed Greenplum® background tasks configuration."""

    @property
    def pxf_config(self) -> yandex.cloud.mdb.greenplum.v1.pxf_pb2.PXFConfig: ...
    def __init__(
        self,
        *,
        greenplum_config_6_17: yandex.cloud.mdb.greenplum.v1.config_pb2.GreenplumConfig6_17 | None = ...,
        greenplum_config_6_19: yandex.cloud.mdb.greenplum.v1.config_pb2.GreenplumConfig6_19 | None = ...,
        greenplum_config_6_21: yandex.cloud.mdb.greenplum.v1.config_pb2.GreenplumConfig6_21 | None = ...,
        greenplum_config_6_22: yandex.cloud.mdb.greenplum.v1.config_pb2.GreenplumConfig6_22 | None = ...,
        greenplum_config_6: yandex.cloud.mdb.greenplum.v1.config_pb2.GreenplumConfig6 | None = ...,
        pool: yandex.cloud.mdb.greenplum.v1.config_pb2.ConnectionPoolerConfig | None = ...,
        background_activities: yandex.cloud.mdb.greenplum.v1.config_pb2.BackgroundActivitiesConfig | None = ...,
        pxf_config: yandex.cloud.mdb.greenplum.v1.pxf_pb2.PXFConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["background_activities", b"background_activities", "greenplum_config", b"greenplum_config", "greenplum_config_6", b"greenplum_config_6", "greenplum_config_6_17", b"greenplum_config_6_17", "greenplum_config_6_19", b"greenplum_config_6_19", "greenplum_config_6_21", b"greenplum_config_6_21", "greenplum_config_6_22", b"greenplum_config_6_22", "pool", b"pool", "pxf_config", b"pxf_config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["background_activities", b"background_activities", "greenplum_config", b"greenplum_config", "greenplum_config_6", b"greenplum_config_6", "greenplum_config_6_17", b"greenplum_config_6_17", "greenplum_config_6_19", b"greenplum_config_6_19", "greenplum_config_6_21", b"greenplum_config_6_21", "greenplum_config_6_22", b"greenplum_config_6_22", "pool", b"pool", "pxf_config", b"pxf_config"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["greenplum_config", b"greenplum_config"]) -> typing.Literal["greenplum_config_6_17", "greenplum_config_6_19", "greenplum_config_6_21", "greenplum_config_6_22", "greenplum_config_6"] | None: ...

global___ConfigSpec = ConfigSpec

@typing.final
class CreateClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Greenplum® cluster that is being created."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___CreateClusterMetadata = CreateClusterMetadata

@typing.final
class UpdateClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    CONFIG_FIELD_NUMBER: builtins.int
    MASTER_CONFIG_FIELD_NUMBER: builtins.int
    SEGMENT_CONFIG_FIELD_NUMBER: builtins.int
    USER_PASSWORD_FIELD_NUMBER: builtins.int
    NETWORK_ID_FIELD_NUMBER: builtins.int
    MAINTENANCE_WINDOW_FIELD_NUMBER: builtins.int
    SECURITY_GROUP_IDS_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    CONFIG_SPEC_FIELD_NUMBER: builtins.int
    CLOUD_STORAGE_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    LOGGING_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Greenplum® cluster resource to update.
    To get the Greenplum® cluster ID, use a [ClusterService.List] request.
    """
    description: builtins.str
    """New description of the Greenplum® cluster."""
    name: builtins.str
    """New name for the cluster."""
    user_password: builtins.str
    """Owner user password."""
    network_id: builtins.str
    """ID of the network to move the cluster to."""
    deletion_protection: builtins.bool
    """Determines whether the cluster is protected from being deleted."""
    service_account_id: builtins.str
    """ID of the service account used for access YC resources."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which fields of the Greenplum® cluster resource should be updated."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Custom labels for the Greenplum® cluster as `key:value` pairs.
        For example, `"project":"mvp"` or `"source":"dictionary"`.

        The new set of labels completely replaces the old one.
        To add a label, request the current set with the [ClusterService.Get] method, then send an [ClusterService.Update] request with the new label added to the set.
        """

    @property
    def config(self) -> yandex.cloud.mdb.greenplum.v1.cluster_pb2.GreenplumConfig:
        """The Greenplum® cluster configuration."""

    @property
    def master_config(self) -> global___MasterSubclusterConfigSpec:
        """Configuration of the Greenplum® master subcluster."""

    @property
    def segment_config(self) -> global___SegmentSubclusterConfigSpec:
        """Configuration of the Greenplum® segment subcluster."""

    @property
    def maintenance_window(self) -> yandex.cloud.mdb.greenplum.v1.maintenance_pb2.MaintenanceWindow:
        """The Greenplum® cluster maintenance window. Should be defined by either one of the two options."""

    @property
    def security_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """User security groups."""

    @property
    def config_spec(self) -> global___ConfigSpec:
        """Settings of the Greenplum® cluster."""

    @property
    def cloud_storage(self) -> yandex.cloud.mdb.greenplum.v1.cluster_pb2.CloudStorage:
        """Cloud storage settings"""

    @property
    def logging(self) -> yandex.cloud.mdb.greenplum.v1.cluster_pb2.LoggingConfig:
        """Cloud logging configuration"""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        name: builtins.str = ...,
        config: yandex.cloud.mdb.greenplum.v1.cluster_pb2.GreenplumConfig | None = ...,
        master_config: global___MasterSubclusterConfigSpec | None = ...,
        segment_config: global___SegmentSubclusterConfigSpec | None = ...,
        user_password: builtins.str = ...,
        network_id: builtins.str = ...,
        maintenance_window: yandex.cloud.mdb.greenplum.v1.maintenance_pb2.MaintenanceWindow | None = ...,
        security_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
        deletion_protection: builtins.bool = ...,
        config_spec: global___ConfigSpec | None = ...,
        cloud_storage: yandex.cloud.mdb.greenplum.v1.cluster_pb2.CloudStorage | None = ...,
        service_account_id: builtins.str = ...,
        logging: yandex.cloud.mdb.greenplum.v1.cluster_pb2.LoggingConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["cloud_storage", b"cloud_storage", "config", b"config", "config_spec", b"config_spec", "logging", b"logging", "maintenance_window", b"maintenance_window", "master_config", b"master_config", "segment_config", b"segment_config", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cloud_storage", b"cloud_storage", "cluster_id", b"cluster_id", "config", b"config", "config_spec", b"config_spec", "deletion_protection", b"deletion_protection", "description", b"description", "labels", b"labels", "logging", b"logging", "maintenance_window", b"maintenance_window", "master_config", b"master_config", "name", b"name", "network_id", b"network_id", "security_group_ids", b"security_group_ids", "segment_config", b"segment_config", "service_account_id", b"service_account_id", "update_mask", b"update_mask", "user_password", b"user_password"]) -> None: ...

global___UpdateClusterRequest = UpdateClusterRequest

@typing.final
class UpdateClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Greenplum® cluster resource that is being updated."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___UpdateClusterMetadata = UpdateClusterMetadata

@typing.final
class AddClusterHostsMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Greenplum Cluster resource that is being updated."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___AddClusterHostsMetadata = AddClusterHostsMetadata

@typing.final
class ExpandRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    SEGMENT_HOST_COUNT_FIELD_NUMBER: builtins.int
    ADD_SEGMENTS_PER_HOST_COUNT_FIELD_NUMBER: builtins.int
    DURATION_FIELD_NUMBER: builtins.int
    PARALLEL_FIELD_NUMBER: builtins.int
    CLOSE_CLUSTER_FIELD_NUMBER: builtins.int
    DELAY_REDISTRIBUTION_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Greenplum Cluster resource to update.
    To get the Greenplum cluster ID, use a [ClusterService.List] request.
    """
    segment_host_count: builtins.int
    """Number of hosts for add to the segment subcluster"""
    add_segments_per_host_count: builtins.int
    """Number of segments per host to add"""
    duration: builtins.int
    """Redistribute duration, in seconds"""
    parallel: builtins.int
    """Redistribute process parallelism, 0 - for automatic detection"""
    close_cluster: builtins.bool
    """Deny all client connections during the expand operation"""
    delay_redistribution: builtins.bool
    """Perform redistribution process by small chunks as background activity"""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        segment_host_count: builtins.int = ...,
        add_segments_per_host_count: builtins.int = ...,
        duration: builtins.int = ...,
        parallel: builtins.int = ...,
        close_cluster: builtins.bool = ...,
        delay_redistribution: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["add_segments_per_host_count", b"add_segments_per_host_count", "close_cluster", b"close_cluster", "cluster_id", b"cluster_id", "delay_redistribution", b"delay_redistribution", "duration", b"duration", "parallel", b"parallel", "segment_host_count", b"segment_host_count"]) -> None: ...

global___ExpandRequest = ExpandRequest

@typing.final
class DeleteClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Greenplum® cluster to delete.
    To get the Greenplum® cluster ID, use a [ClusterService.List] request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___DeleteClusterRequest = DeleteClusterRequest

@typing.final
class DeleteClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Greenplum® cluster that is being deleted."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___DeleteClusterMetadata = DeleteClusterMetadata

@typing.final
class StartClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Greenplum® cluster to start.
    To get the Greenplum® cluster ID, use a [ClusterService.List] request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___StartClusterRequest = StartClusterRequest

@typing.final
class StartClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Greenplum® cluster being started."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___StartClusterMetadata = StartClusterMetadata

@typing.final
class StopClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Greenplum® cluster to stop.
    To get the Greenplum® cluster ID, use a [ClusterService.List] request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___StopClusterRequest = StopClusterRequest

@typing.final
class StopClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Greenplum® cluster being stopped."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___StopClusterMetadata = StopClusterMetadata

@typing.final
class MoveClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    DESTINATION_FOLDER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Greenplum® cluster to move."""
    destination_folder_id: builtins.str
    """ID of the destination folder."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        destination_folder_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "destination_folder_id", b"destination_folder_id"]) -> None: ...

global___MoveClusterRequest = MoveClusterRequest

@typing.final
class MoveClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    SOURCE_FOLDER_ID_FIELD_NUMBER: builtins.int
    DESTINATION_FOLDER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Greenplum® cluster being moved."""
    source_folder_id: builtins.str
    """ID of the source folder."""
    destination_folder_id: builtins.str
    """ID of the destination folder."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        source_folder_id: builtins.str = ...,
        destination_folder_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "destination_folder_id", b"destination_folder_id", "source_folder_id", b"source_folder_id"]) -> None: ...

global___MoveClusterMetadata = MoveClusterMetadata

@typing.final
class RescheduleMaintenanceRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _RescheduleType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _RescheduleTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[RescheduleMaintenanceRequest._RescheduleType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        RESCHEDULE_TYPE_UNSPECIFIED: RescheduleMaintenanceRequest._RescheduleType.ValueType  # 0
        IMMEDIATE: RescheduleMaintenanceRequest._RescheduleType.ValueType  # 1
        NEXT_AVAILABLE_WINDOW: RescheduleMaintenanceRequest._RescheduleType.ValueType  # 2
        SPECIFIC_TIME: RescheduleMaintenanceRequest._RescheduleType.ValueType  # 3

    class RescheduleType(_RescheduleType, metaclass=_RescheduleTypeEnumTypeWrapper): ...
    RESCHEDULE_TYPE_UNSPECIFIED: RescheduleMaintenanceRequest.RescheduleType.ValueType  # 0
    IMMEDIATE: RescheduleMaintenanceRequest.RescheduleType.ValueType  # 1
    NEXT_AVAILABLE_WINDOW: RescheduleMaintenanceRequest.RescheduleType.ValueType  # 2
    SPECIFIC_TIME: RescheduleMaintenanceRequest.RescheduleType.ValueType  # 3

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    RESCHEDULE_TYPE_FIELD_NUMBER: builtins.int
    DELAYED_UNTIL_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """Required. ID of the Greenplum cluster to maintenance reschedule."""
    reschedule_type: global___RescheduleMaintenanceRequest.RescheduleType.ValueType
    """Required. The type of reschedule request."""
    @property
    def delayed_until(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time for SPECIFIC_TIME reschedule. Limited by two weeks since first time scheduled."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        reschedule_type: global___RescheduleMaintenanceRequest.RescheduleType.ValueType = ...,
        delayed_until: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["delayed_until", b"delayed_until"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "delayed_until", b"delayed_until", "reschedule_type", b"reschedule_type"]) -> None: ...

global___RescheduleMaintenanceRequest = RescheduleMaintenanceRequest

@typing.final
class RescheduleMaintenanceMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    DELAYED_UNTIL_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """Required. ID of the Greenplum cluster."""
    @property
    def delayed_until(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Required. New time of the planned maintenance. Can be in the past for rescheduled to "IMMEDIATE"."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        delayed_until: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["delayed_until", b"delayed_until"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "delayed_until", b"delayed_until"]) -> None: ...

global___RescheduleMaintenanceMetadata = RescheduleMaintenanceMetadata

@typing.final
class ListClusterOperationsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Greenplum® cluster resource to list operations for."""
    page_size: builtins.int
    """The maximum number of results per page to return.

    If the number of available results is larger than [page_size], the service returns a [ListClusterOperationsResponse.next_page_token] that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the [ListClusterOperationsResponse.next_page_token] returned by the previous list request."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListClusterOperationsRequest = ListClusterOperationsRequest

@typing.final
class ListClusterOperationsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests.

    If the number of results is larger than [ListClusterOperationsRequest.page_size], use the [next_page_token] as the value for the [ListClusterOperationsRequest.page_token] query parameter in the next list request.

    Each subsequent list request has its own [next_page_token] to continue paging through the results.
    """
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.operation.operation_pb2.Operation]:
        """List of Operation resources for the specified Greenplum® cluster."""

    def __init__(
        self,
        *,
        operations: collections.abc.Iterable[yandex.cloud.operation.operation_pb2.Operation] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "operations", b"operations"]) -> None: ...

global___ListClusterOperationsResponse = ListClusterOperationsResponse

@typing.final
class ListClusterHostsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Greenplum® cluster.

    To get the Greenplum® cluster ID use a [ClusterService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return.

    If the number of available results is larger than [page_size], the service returns a [ListClusterHostsResponse.next_page_token] that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the [ListClusterHostsResponse.next_page_token] returned by the previous list request."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListClusterHostsRequest = ListClusterHostsRequest

@typing.final
class ListClusterHostsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HOSTS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests.

    If the number of results is larger than [ListClusterHostsRequest.page_size], use the [next_page_token] as the value for the [ListClusterHostsRequest.page_token] query parameter in the next list request.

    Each subsequent list request has its own [next_page_token] to continue paging through the results.
    """
    @property
    def hosts(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.mdb.greenplum.v1.host_pb2.Host]:
        """Requested list of hosts for the cluster."""

    def __init__(
        self,
        *,
        hosts: collections.abc.Iterable[yandex.cloud.mdb.greenplum.v1.host_pb2.Host] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["hosts", b"hosts", "next_page_token", b"next_page_token"]) -> None: ...

global___ListClusterHostsResponse = ListClusterHostsResponse

@typing.final
class MasterSubclusterConfigSpec(google.protobuf.message.Message):
    """Configuration of the master subcluster."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOURCES_FIELD_NUMBER: builtins.int
    @property
    def resources(self) -> yandex.cloud.mdb.greenplum.v1.config_pb2.Resources:
        """Resources allocated to Greenplum® master subcluster hosts."""

    def __init__(
        self,
        *,
        resources: yandex.cloud.mdb.greenplum.v1.config_pb2.Resources | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["resources", b"resources"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["resources", b"resources"]) -> None: ...

global___MasterSubclusterConfigSpec = MasterSubclusterConfigSpec

@typing.final
class SegmentSubclusterConfigSpec(google.protobuf.message.Message):
    """Configuration of the segment subcluster."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOURCES_FIELD_NUMBER: builtins.int
    @property
    def resources(self) -> yandex.cloud.mdb.greenplum.v1.config_pb2.Resources:
        """Resources allocated to Greenplum® segment subcluster hosts."""

    def __init__(
        self,
        *,
        resources: yandex.cloud.mdb.greenplum.v1.config_pb2.Resources | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["resources", b"resources"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["resources", b"resources"]) -> None: ...

global___SegmentSubclusterConfigSpec = SegmentSubclusterConfigSpec

@typing.final
class ListClusterLogsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOGS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests.

    If the number of results is larger than [ListClusterLogsRequest.page_size], use the [next_page_token] as the value for the [ListClusterLogsRequest.page_token] query parameter in the next list request.

    Each subsequent list request has its own [next_page_token] to continue paging through the results.

    This value is interchangeable with the [StreamLogRecord.next_record_token] from [StreamLogs] method.
    """
    @property
    def logs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___LogRecord]:
        """Requested log records."""

    def __init__(
        self,
        *,
        logs: collections.abc.Iterable[global___LogRecord] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["logs", b"logs", "next_page_token", b"next_page_token"]) -> None: ...

global___ListClusterLogsResponse = ListClusterLogsResponse

@typing.final
class LogRecord(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MessageEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    TIMESTAMP_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    @property
    def timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Time when the log was recorded."""

    @property
    def message(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Contents of the log record."""

    def __init__(
        self,
        *,
        timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        message: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["timestamp", b"timestamp"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["message", b"message", "timestamp", b"timestamp"]) -> None: ...

global___LogRecord = LogRecord

@typing.final
class ListClusterLogsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _ServiceType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ServiceTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ListClusterLogsRequest._ServiceType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        SERVICE_TYPE_UNSPECIFIED: ListClusterLogsRequest._ServiceType.ValueType  # 0
        """Type is not specified."""
        GREENPLUM: ListClusterLogsRequest._ServiceType.ValueType  # 1
        """Greenplum® activity logs."""
        GREENPLUM_POOLER: ListClusterLogsRequest._ServiceType.ValueType  # 2
        """Greenplum® pooler logs."""
        GREENPLUM_PXF: ListClusterLogsRequest._ServiceType.ValueType  # 3
        """Greenplum® PXF service logs."""

    class ServiceType(_ServiceType, metaclass=_ServiceTypeEnumTypeWrapper): ...
    SERVICE_TYPE_UNSPECIFIED: ListClusterLogsRequest.ServiceType.ValueType  # 0
    """Type is not specified."""
    GREENPLUM: ListClusterLogsRequest.ServiceType.ValueType  # 1
    """Greenplum® activity logs."""
    GREENPLUM_POOLER: ListClusterLogsRequest.ServiceType.ValueType  # 2
    """Greenplum® pooler logs."""
    GREENPLUM_PXF: ListClusterLogsRequest.ServiceType.ValueType  # 3
    """Greenplum® PXF service logs."""

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    COLUMN_FILTER_FIELD_NUMBER: builtins.int
    SERVICE_TYPE_FIELD_NUMBER: builtins.int
    FROM_TIME_FIELD_NUMBER: builtins.int
    TO_TIME_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    ALWAYS_NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Greenplum® cluster to request logs for.

    To get the Greenplum® cluster ID, use a [ClusterService.List] request.
    """
    service_type: global___ListClusterLogsRequest.ServiceType.ValueType
    """Type of the service to request logs about."""
    page_size: builtins.int
    """The maximum number of results per page to return.

    If the number of available results is larger than [page_size], the service returns a [ListClusterLogsResponse.next_page_token] that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the [ListClusterLogsResponse.next_page_token] returned by the previous list request."""
    always_next_page_token: builtins.bool
    """The service always returns a [ListClusterLogsResponse.next_page_token], even if the current page is empty."""
    filter: builtins.str
    """A filter expression that filters resources listed in the response.

    The expression must specify:

    1. A field name. Currently filtering can be applied to the [LogRecord.logs.message.hostname], [LogRecord.logs.message.error_severity] (for `GREENPLUM` service) and [LogRecord.logs.message.level] (for `GREENPLUM_POOLER` service) fields.

    2. A conditional operator. Can be either `=` or `!=` for single values, `IN` or `NOT IN` for lists of values.

    3. A value. Must be 1-63 characters long and match the regular expression `^[a-z0-9.-]{1,61}$`.

    Examples of a filter:
    * `message.hostname='node1.db.cloud.yandex.net'`;
    * `message.error_severity IN ("ERROR", "FATAL", "PANIC") AND message.hostname = "node1.db.cloud.yandex.net"`.
    """
    @property
    def column_filter(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Columns from log table to request.
        If no columns are specified, entire log records are returned.
        """

    @property
    def from_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Start timestamp for the logs request."""

    @property
    def to_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """End timestamp for the logs request."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        column_filter: collections.abc.Iterable[builtins.str] | None = ...,
        service_type: global___ListClusterLogsRequest.ServiceType.ValueType = ...,
        from_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        to_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        always_next_page_token: builtins.bool = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["from_time", b"from_time", "to_time", b"to_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["always_next_page_token", b"always_next_page_token", "cluster_id", b"cluster_id", "column_filter", b"column_filter", "filter", b"filter", "from_time", b"from_time", "page_size", b"page_size", "page_token", b"page_token", "service_type", b"service_type", "to_time", b"to_time"]) -> None: ...

global___ListClusterLogsRequest = ListClusterLogsRequest

@typing.final
class ListClusterBackupsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Greenplum® cluster.

    To get the Greenplum® cluster ID use a [ClusterService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return.

    If the number of available results is larger than [page_size], the service returns a [ListClusterBackupsResponse.next_page_token] that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the [ListClusterBackupsResponse.next_page_token] returned by the previous list request."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListClusterBackupsRequest = ListClusterBackupsRequest

@typing.final
class StreamLogRecord(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RECORD_FIELD_NUMBER: builtins.int
    NEXT_RECORD_TOKEN_FIELD_NUMBER: builtins.int
    next_record_token: builtins.str
    """This token allows you to continue streaming logs starting from the exact same record.

    To do that, specify value of [next_record_token] as the value for [StreamLogs.record_token] parameter in the next [StreamLogs] request.

    This value is interchangeable with [ListLogs.next_page_token] from [ListLogs] method.
    """
    @property
    def record(self) -> global___LogRecord:
        """One of the requested log records."""

    def __init__(
        self,
        *,
        record: global___LogRecord | None = ...,
        next_record_token: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["record", b"record"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["next_record_token", b"next_record_token", "record", b"record"]) -> None: ...

global___StreamLogRecord = StreamLogRecord

@typing.final
class StreamClusterLogsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _ServiceType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ServiceTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[StreamClusterLogsRequest._ServiceType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        SERVICE_TYPE_UNSPECIFIED: StreamClusterLogsRequest._ServiceType.ValueType  # 0
        """Type is not specified."""
        GREENPLUM: StreamClusterLogsRequest._ServiceType.ValueType  # 1
        """Greenplum® activity logs."""
        GREENPLUM_POOLER: StreamClusterLogsRequest._ServiceType.ValueType  # 2
        """Greenplum® pooler logs."""
        GREENPLUM_PXF: StreamClusterLogsRequest._ServiceType.ValueType  # 3
        """Greenplum® PXF service logs."""

    class ServiceType(_ServiceType, metaclass=_ServiceTypeEnumTypeWrapper): ...
    SERVICE_TYPE_UNSPECIFIED: StreamClusterLogsRequest.ServiceType.ValueType  # 0
    """Type is not specified."""
    GREENPLUM: StreamClusterLogsRequest.ServiceType.ValueType  # 1
    """Greenplum® activity logs."""
    GREENPLUM_POOLER: StreamClusterLogsRequest.ServiceType.ValueType  # 2
    """Greenplum® pooler logs."""
    GREENPLUM_PXF: StreamClusterLogsRequest.ServiceType.ValueType  # 3
    """Greenplum® PXF service logs."""

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    COLUMN_FILTER_FIELD_NUMBER: builtins.int
    SERVICE_TYPE_FIELD_NUMBER: builtins.int
    FROM_TIME_FIELD_NUMBER: builtins.int
    TO_TIME_FIELD_NUMBER: builtins.int
    RECORD_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Greenplum® cluster."""
    service_type: global___StreamClusterLogsRequest.ServiceType.ValueType
    """Type of the service to request logs about."""
    record_token: builtins.str
    """Record token. Set [record_token] to the [StreamLogs.next_record_token] returned by the previous [StreamLogs] request to start streaming from the next log record."""
    filter: builtins.str
    """A filter expression that filters resources listed in the response.

    The expression must specify:

    1. A field name. Currently filtering can be applied to the [LogRecord.logs.message.hostname], [LogRecord.logs.message.error_severity] (for GREENPLUM service), [LogRecord.logs.message.level] (for POOLER service) fields.

    2. An `=` operator.

    3. A value in double quotes (`"`). Must be 1-63 characters long and match the regular expression `[a-z0-9.-]{1,61}`.

    Examples of a filter:

    * `message.hostname='node1.db.cloud.yandex.net'`;
    * `message.error_severity IN ("ERROR", "FATAL", "PANIC") AND message.hostname = "node1.db.cloud.yandex.net"`.
    """
    @property
    def column_filter(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Columns from log table to get in the response.
        If no columns are specified, entire log records are returned.
        """

    @property
    def from_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Start timestamp for the logs request."""

    @property
    def to_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """End timestamp for the logs request.

        If this field is not set, all existing logs are sent as well as the new ones as they appear.

        In essence it has `tail -f` semantics.
        """

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        column_filter: collections.abc.Iterable[builtins.str] | None = ...,
        service_type: global___StreamClusterLogsRequest.ServiceType.ValueType = ...,
        from_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        to_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        record_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["from_time", b"from_time", "to_time", b"to_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "column_filter", b"column_filter", "filter", b"filter", "from_time", b"from_time", "record_token", b"record_token", "service_type", b"service_type", "to_time", b"to_time"]) -> None: ...

global___StreamClusterLogsRequest = StreamClusterLogsRequest

@typing.final
class ListClusterBackupsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BACKUPS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests.

    If the number of results is larger than [ListClusterBackupsRequest.page_size], use the [next_page_token] as the value for the [ListClusterBackupsRequest.page_token] query parameter in the next list request.

    Each subsequent list request has its own [next_page_token] to continue paging through the results.
    """
    @property
    def backups(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.mdb.greenplum.v1.backup_pb2.Backup]:
        """List of Greenplum® backups."""

    def __init__(
        self,
        *,
        backups: collections.abc.Iterable[yandex.cloud.mdb.greenplum.v1.backup_pb2.Backup] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["backups", b"backups", "next_page_token", b"next_page_token"]) -> None: ...

global___ListClusterBackupsResponse = ListClusterBackupsResponse

@typing.final
class BackupClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Greenplum cluster to back up.
    To get the Greenplum cluster ID, use a [ClusterService.List] request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___BackupClusterRequest = BackupClusterRequest

@typing.final
class BackupClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    BACKUP_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Greenplum cluster to back up."""
    backup_id: builtins.str
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        backup_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["backup_id", b"backup_id", "cluster_id", b"cluster_id"]) -> None: ...

global___BackupClusterMetadata = BackupClusterMetadata

@typing.final
class RestoreClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    BACKUP_ID_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    ENVIRONMENT_FIELD_NUMBER: builtins.int
    CONFIG_FIELD_NUMBER: builtins.int
    MASTER_RESOURCES_FIELD_NUMBER: builtins.int
    SEGMENT_RESOURCES_FIELD_NUMBER: builtins.int
    NETWORK_ID_FIELD_NUMBER: builtins.int
    SECURITY_GROUP_IDS_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    HOST_GROUP_IDS_FIELD_NUMBER: builtins.int
    PLACEMENT_GROUP_ID_FIELD_NUMBER: builtins.int
    MAINTENANCE_WINDOW_FIELD_NUMBER: builtins.int
    SEGMENT_HOST_COUNT_FIELD_NUMBER: builtins.int
    SEGMENT_IN_HOST_FIELD_NUMBER: builtins.int
    RESTORE_ONLY_FIELD_NUMBER: builtins.int
    MASTER_HOST_GROUP_IDS_FIELD_NUMBER: builtins.int
    SEGMENT_HOST_GROUP_IDS_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    backup_id: builtins.str
    """ID of the backup to create a cluster from.

    To get the backup ID, use a [ClusterService.ListBackups] request.
    """
    folder_id: builtins.str
    """ID of the folder to create the Greenplum® cluster in."""
    name: builtins.str
    """Name of the Greenplum® cluster. The name must be unique within the folder."""
    description: builtins.str
    """Description of the Greenplum® cluster."""
    environment: yandex.cloud.mdb.greenplum.v1.cluster_pb2.Cluster.Environment.ValueType
    """Deployment environment of the Greenplum® cluster."""
    network_id: builtins.str
    """ID of the network to create the cluster in."""
    deletion_protection: builtins.bool
    """Determines whether the cluster is protected from being deleted."""
    placement_group_id: builtins.str
    """ID of the placement group."""
    segment_host_count: builtins.int
    """Number of segment hosts"""
    segment_in_host: builtins.int
    """Number of segments on each host"""
    service_account_id: builtins.str
    """Service account that will be used to access a Yandex Cloud resources"""
    @property
    def time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp of the moment to which the Greenplum cluster should be restored."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Custom labels for the Greenplum® cluster as `key:value` pairs.
        For example, "project":"mvp" or "source":"dictionary".
        """

    @property
    def config(self) -> yandex.cloud.mdb.greenplum.v1.cluster_pb2.GreenplumRestoreConfig:
        """Greenplum® cluster config."""

    @property
    def master_resources(self) -> yandex.cloud.mdb.greenplum.v1.config_pb2.Resources:
        """Resources of the Greenplum® master subcluster."""

    @property
    def segment_resources(self) -> yandex.cloud.mdb.greenplum.v1.config_pb2.Resources:
        """Resources of the Greenplum® segment subcluster."""

    @property
    def security_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """User security groups."""

    @property
    def host_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Host groups to place VMs of cluster on."""

    @property
    def maintenance_window(self) -> yandex.cloud.mdb.greenplum.v1.maintenance_pb2.MaintenanceWindow:
        """A Greenplum® cluster maintenance window. Should be defined by either one of the two options."""

    @property
    def restore_only(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of databases and tables to restore"""

    @property
    def master_host_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Host groups hosting VMs of the master subcluster."""

    @property
    def segment_host_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Host groups hosting VMs of the segment subcluster."""

    def __init__(
        self,
        *,
        backup_id: builtins.str = ...,
        time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        environment: yandex.cloud.mdb.greenplum.v1.cluster_pb2.Cluster.Environment.ValueType = ...,
        config: yandex.cloud.mdb.greenplum.v1.cluster_pb2.GreenplumRestoreConfig | None = ...,
        master_resources: yandex.cloud.mdb.greenplum.v1.config_pb2.Resources | None = ...,
        segment_resources: yandex.cloud.mdb.greenplum.v1.config_pb2.Resources | None = ...,
        network_id: builtins.str = ...,
        security_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
        deletion_protection: builtins.bool = ...,
        host_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
        placement_group_id: builtins.str = ...,
        maintenance_window: yandex.cloud.mdb.greenplum.v1.maintenance_pb2.MaintenanceWindow | None = ...,
        segment_host_count: builtins.int = ...,
        segment_in_host: builtins.int = ...,
        restore_only: collections.abc.Iterable[builtins.str] | None = ...,
        master_host_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
        segment_host_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
        service_account_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["config", b"config", "maintenance_window", b"maintenance_window", "master_resources", b"master_resources", "segment_resources", b"segment_resources", "time", b"time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["backup_id", b"backup_id", "config", b"config", "deletion_protection", b"deletion_protection", "description", b"description", "environment", b"environment", "folder_id", b"folder_id", "host_group_ids", b"host_group_ids", "labels", b"labels", "maintenance_window", b"maintenance_window", "master_host_group_ids", b"master_host_group_ids", "master_resources", b"master_resources", "name", b"name", "network_id", b"network_id", "placement_group_id", b"placement_group_id", "restore_only", b"restore_only", "security_group_ids", b"security_group_ids", "segment_host_count", b"segment_host_count", "segment_host_group_ids", b"segment_host_group_ids", "segment_in_host", b"segment_in_host", "segment_resources", b"segment_resources", "service_account_id", b"service_account_id", "time", b"time"]) -> None: ...

global___RestoreClusterRequest = RestoreClusterRequest

@typing.final
class RestoreClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    BACKUP_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the new Greenplum® cluster that is being created from a backup."""
    backup_id: builtins.str
    """ID of the backup that is being used for creating a cluster."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        backup_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["backup_id", b"backup_id", "cluster_id", b"cluster_id"]) -> None: ...

global___RestoreClusterMetadata = RestoreClusterMetadata
