"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class ResourcePreset(google.protobuf.message.Message):
    """A preset of resources for hardware configuration of Greenplum® hosts."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Type:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ResourcePreset._Type.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        TYPE_UNSPECIFIED: ResourcePreset._Type.ValueType  # 0
        MASTER: ResourcePreset._Type.ValueType  # 1
        """Greenplum® master host."""
        SEGMENT: ResourcePreset._Type.ValueType  # 2
        """Greenplum® segment host."""

    class Type(_Type, metaclass=_TypeEnumTypeWrapper): ...
    TYPE_UNSPECIFIED: ResourcePreset.Type.ValueType  # 0
    MASTER: ResourcePreset.Type.ValueType  # 1
    """Greenplum® master host."""
    SEGMENT: ResourcePreset.Type.ValueType  # 2
    """Greenplum® segment host."""

    ID_FIELD_NUMBER: builtins.int
    ZONE_IDS_FIELD_NUMBER: builtins.int
    DISK_TYPE_IDS_FIELD_NUMBER: builtins.int
    CORES_FIELD_NUMBER: builtins.int
    MEMORY_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    HOST_COUNT_DIVIDER_FIELD_NUMBER: builtins.int
    MAX_SEGMENT_IN_HOST_COUNT_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the resource preset."""
    cores: builtins.int
    """Number of CPU cores for a Greenplum® host created with the preset."""
    memory: builtins.int
    """RAM volume for a Greenplum® host created with the preset, in bytes."""
    type: global___ResourcePreset.Type.ValueType
    """Host type."""
    host_count_divider: builtins.int
    """The number of hosts must be divisible by [host_count_divider]."""
    max_segment_in_host_count: builtins.int
    """Maximum number of segments in segment host."""
    @property
    def zone_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """IDs of availability zones where the resource preset is available."""

    @property
    def disk_type_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """IDs of availability disk types available in the resource preset."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        zone_ids: collections.abc.Iterable[builtins.str] | None = ...,
        disk_type_ids: collections.abc.Iterable[builtins.str] | None = ...,
        cores: builtins.int = ...,
        memory: builtins.int = ...,
        type: global___ResourcePreset.Type.ValueType = ...,
        host_count_divider: builtins.int = ...,
        max_segment_in_host_count: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cores", b"cores", "disk_type_ids", b"disk_type_ids", "host_count_divider", b"host_count_divider", "id", b"id", "max_segment_in_host_count", b"max_segment_in_host_count", "memory", b"memory", "type", b"type", "zone_ids", b"zone_ids"]) -> None: ...

global___ResourcePreset = ResourcePreset
