"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import google.protobuf.wrappers_pb2
import sys
import typing
import yandex.cloud.mdb.kafka.v1.common_pb2
import yandex.cloud.mdb.kafka.v1.maintenance_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Cluster(google.protobuf.message.Message):
    """An Apache Kafka® cluster resource.
    For more information, see the [Concepts](/docs/managed-kafka/concepts) section of the documentation.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Environment:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EnvironmentEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Cluster._Environment.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        ENVIRONMENT_UNSPECIFIED: Cluster._Environment.ValueType  # 0
        PRODUCTION: Cluster._Environment.ValueType  # 1
        """Stable environment with a conservative update policy when only hotfixes are applied during regular maintenance."""
        PRESTABLE: Cluster._Environment.ValueType  # 2
        """Environment with a more aggressive update policy when new versions are rolled out irrespective of backward compatibility."""

    class Environment(_Environment, metaclass=_EnvironmentEnumTypeWrapper): ...
    ENVIRONMENT_UNSPECIFIED: Cluster.Environment.ValueType  # 0
    PRODUCTION: Cluster.Environment.ValueType  # 1
    """Stable environment with a conservative update policy when only hotfixes are applied during regular maintenance."""
    PRESTABLE: Cluster.Environment.ValueType  # 2
    """Environment with a more aggressive update policy when new versions are rolled out irrespective of backward compatibility."""

    class _Health:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _HealthEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Cluster._Health.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        HEALTH_UNKNOWN: Cluster._Health.ValueType  # 0
        """State of the cluster is unknown ([Host.health] of all hosts in the cluster is `UNKNOWN`)."""
        ALIVE: Cluster._Health.ValueType  # 1
        """Cluster is alive and well ([Host.health] of all hosts in the cluster is `ALIVE`)."""
        DEAD: Cluster._Health.ValueType  # 2
        """Cluster is inoperable ([Host.health] of all hosts in the cluster is `DEAD`)."""
        DEGRADED: Cluster._Health.ValueType  # 3
        """Cluster is in degraded state ([Host.health] of at least one of the hosts in the cluster is not `ALIVE`)."""

    class Health(_Health, metaclass=_HealthEnumTypeWrapper): ...
    HEALTH_UNKNOWN: Cluster.Health.ValueType  # 0
    """State of the cluster is unknown ([Host.health] of all hosts in the cluster is `UNKNOWN`)."""
    ALIVE: Cluster.Health.ValueType  # 1
    """Cluster is alive and well ([Host.health] of all hosts in the cluster is `ALIVE`)."""
    DEAD: Cluster.Health.ValueType  # 2
    """Cluster is inoperable ([Host.health] of all hosts in the cluster is `DEAD`)."""
    DEGRADED: Cluster.Health.ValueType  # 3
    """Cluster is in degraded state ([Host.health] of at least one of the hosts in the cluster is not `ALIVE`)."""

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Cluster._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNKNOWN: Cluster._Status.ValueType  # 0
        """Cluster state is unknown."""
        CREATING: Cluster._Status.ValueType  # 1
        """Cluster is being created."""
        RUNNING: Cluster._Status.ValueType  # 2
        """Cluster is running normally."""
        ERROR: Cluster._Status.ValueType  # 3
        """Cluster encountered a problem and cannot operate."""
        UPDATING: Cluster._Status.ValueType  # 4
        """Cluster is being updated."""
        STOPPING: Cluster._Status.ValueType  # 5
        """Cluster is stopping."""
        STOPPED: Cluster._Status.ValueType  # 6
        """Cluster stopped."""
        STARTING: Cluster._Status.ValueType  # 7
        """Cluster is starting."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNKNOWN: Cluster.Status.ValueType  # 0
    """Cluster state is unknown."""
    CREATING: Cluster.Status.ValueType  # 1
    """Cluster is being created."""
    RUNNING: Cluster.Status.ValueType  # 2
    """Cluster is running normally."""
    ERROR: Cluster.Status.ValueType  # 3
    """Cluster encountered a problem and cannot operate."""
    UPDATING: Cluster.Status.ValueType  # 4
    """Cluster is being updated."""
    STOPPING: Cluster.Status.ValueType  # 5
    """Cluster is stopping."""
    STOPPED: Cluster.Status.ValueType  # 6
    """Cluster stopped."""
    STARTING: Cluster.Status.ValueType  # 7
    """Cluster is starting."""

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing.final
    class KafkaUI(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        URL_FIELD_NUMBER: builtins.int
        url: builtins.str
        """URL for connection to kafka ui"""
        def __init__(
            self,
            *,
            url: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["url", b"url"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    ENVIRONMENT_FIELD_NUMBER: builtins.int
    MONITORING_FIELD_NUMBER: builtins.int
    CONFIG_FIELD_NUMBER: builtins.int
    NETWORK_ID_FIELD_NUMBER: builtins.int
    HEALTH_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    SECURITY_GROUP_IDS_FIELD_NUMBER: builtins.int
    HOST_GROUP_IDS_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    MAINTENANCE_WINDOW_FIELD_NUMBER: builtins.int
    PLANNED_OPERATION_FIELD_NUMBER: builtins.int
    KAFKA_UI_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the Apache Kafka® cluster.
    This ID is assigned at creation time.
    """
    folder_id: builtins.str
    """ID of the folder that the Apache Kafka® cluster belongs to."""
    name: builtins.str
    """Name of the Apache Kafka® cluster.
    The name must be unique within the folder. 1-63 characters long. Value must match the regular expression `[a-zA-Z0-9_-]*`.
    """
    description: builtins.str
    """Description of the Apache Kafka® cluster. 0-256 characters long."""
    environment: global___Cluster.Environment.ValueType
    """Deployment environment of the Apache Kafka® cluster."""
    network_id: builtins.str
    """ID of the network that the cluster belongs to."""
    health: global___Cluster.Health.ValueType
    """Aggregated cluster health."""
    status: global___Cluster.Status.ValueType
    """Current state of the cluster."""
    deletion_protection: builtins.bool
    """Deletion Protection inhibits deletion of the cluster"""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Custom labels for the Apache Kafka® cluster as `key:value` pairs.
        A maximum of 64 labels per resource is allowed.
        """

    @property
    def monitoring(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Monitoring]:
        """Description of monitoring systems relevant to the Apache Kafka® cluster.
        * The field is ignored for response of List method.
        """

    @property
    def config(self) -> global___ConfigSpec:
        """Configuration of the Apache Kafka® cluster.
        * The field is ignored for response of List method.
        """

    @property
    def security_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """User security groups"""

    @property
    def host_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Host groups hosting VMs of the cluster."""

    @property
    def maintenance_window(self) -> yandex.cloud.mdb.kafka.v1.maintenance_pb2.MaintenanceWindow:
        """Window of maintenance operations."""

    @property
    def planned_operation(self) -> yandex.cloud.mdb.kafka.v1.maintenance_pb2.MaintenanceOperation:
        """Scheduled maintenance operation."""

    @property
    def kafka_ui(self) -> global___Cluster.KafkaUI:
        """KafkaUI state."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        folder_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        environment: global___Cluster.Environment.ValueType = ...,
        monitoring: collections.abc.Iterable[global___Monitoring] | None = ...,
        config: global___ConfigSpec | None = ...,
        network_id: builtins.str = ...,
        health: global___Cluster.Health.ValueType = ...,
        status: global___Cluster.Status.ValueType = ...,
        security_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
        host_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
        deletion_protection: builtins.bool = ...,
        maintenance_window: yandex.cloud.mdb.kafka.v1.maintenance_pb2.MaintenanceWindow | None = ...,
        planned_operation: yandex.cloud.mdb.kafka.v1.maintenance_pb2.MaintenanceOperation | None = ...,
        kafka_ui: global___Cluster.KafkaUI | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["config", b"config", "created_at", b"created_at", "kafka_ui", b"kafka_ui", "maintenance_window", b"maintenance_window", "planned_operation", b"planned_operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["config", b"config", "created_at", b"created_at", "deletion_protection", b"deletion_protection", "description", b"description", "environment", b"environment", "folder_id", b"folder_id", "health", b"health", "host_group_ids", b"host_group_ids", "id", b"id", "kafka_ui", b"kafka_ui", "labels", b"labels", "maintenance_window", b"maintenance_window", "monitoring", b"monitoring", "name", b"name", "network_id", b"network_id", "planned_operation", b"planned_operation", "security_group_ids", b"security_group_ids", "status", b"status"]) -> None: ...

global___Cluster = Cluster

@typing.final
class Monitoring(google.protobuf.message.Message):
    """Metadata of monitoring system."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LINK_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the monitoring system."""
    description: builtins.str
    """Description of the monitoring system."""
    link: builtins.str
    """Link to the monitoring system charts for the Apache Kafka® cluster."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        description: builtins.str = ...,
        link: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "link", b"link", "name", b"name"]) -> None: ...

global___Monitoring = Monitoring

@typing.final
class ConfigSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class Kafka(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        RESOURCES_FIELD_NUMBER: builtins.int
        KAFKA_CONFIG_2_8_FIELD_NUMBER: builtins.int
        KAFKA_CONFIG_3_FIELD_NUMBER: builtins.int
        @property
        def resources(self) -> global___Resources:
            """Resources allocated to Kafka brokers."""

        @property
        def kafka_config_2_8(self) -> global___KafkaConfig2_8: ...
        @property
        def kafka_config_3(self) -> global___KafkaConfig3: ...
        def __init__(
            self,
            *,
            resources: global___Resources | None = ...,
            kafka_config_2_8: global___KafkaConfig2_8 | None = ...,
            kafka_config_3: global___KafkaConfig3 | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["kafka_config", b"kafka_config", "kafka_config_2_8", b"kafka_config_2_8", "kafka_config_3", b"kafka_config_3", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["kafka_config", b"kafka_config", "kafka_config_2_8", b"kafka_config_2_8", "kafka_config_3", b"kafka_config_3", "resources", b"resources"]) -> None: ...
        def WhichOneof(self, oneof_group: typing.Literal["kafka_config", b"kafka_config"]) -> typing.Literal["kafka_config_2_8", "kafka_config_3"] | None: ...

    @typing.final
    class Zookeeper(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        RESOURCES_FIELD_NUMBER: builtins.int
        @property
        def resources(self) -> global___Resources:
            """Resources allocated to ZooKeeper hosts."""

        def __init__(
            self,
            *,
            resources: global___Resources | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["resources", b"resources"]) -> None: ...

    @typing.final
    class KRaft(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        RESOURCES_FIELD_NUMBER: builtins.int
        @property
        def resources(self) -> global___Resources:
            """Resources allocated to KRaft controller hosts."""

        def __init__(
            self,
            *,
            resources: global___Resources | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["resources", b"resources"]) -> None: ...

    @typing.final
    class RestAPIConfig(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ENABLED_FIELD_NUMBER: builtins.int
        enabled: builtins.bool
        """Is REST API enabled for this cluster."""
        def __init__(
            self,
            *,
            enabled: builtins.bool = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["enabled", b"enabled"]) -> None: ...

    @typing.final
    class KafkaUIConfig(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ENABLED_FIELD_NUMBER: builtins.int
        enabled: builtins.bool
        """Is Kafka UI enabled for this cluster."""
        def __init__(
            self,
            *,
            enabled: builtins.bool = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["enabled", b"enabled"]) -> None: ...

    VERSION_FIELD_NUMBER: builtins.int
    KAFKA_FIELD_NUMBER: builtins.int
    ZOOKEEPER_FIELD_NUMBER: builtins.int
    ZONE_ID_FIELD_NUMBER: builtins.int
    BROKERS_COUNT_FIELD_NUMBER: builtins.int
    ASSIGN_PUBLIC_IP_FIELD_NUMBER: builtins.int
    UNMANAGED_TOPICS_FIELD_NUMBER: builtins.int
    SCHEMA_REGISTRY_FIELD_NUMBER: builtins.int
    ACCESS_FIELD_NUMBER: builtins.int
    REST_API_CONFIG_FIELD_NUMBER: builtins.int
    DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
    KRAFT_FIELD_NUMBER: builtins.int
    KAFKA_UI_CONFIG_FIELD_NUMBER: builtins.int
    version: builtins.str
    """Version of Apache Kafka® used in the cluster. Possible values: `2.8`, `3.0`, `3.1`, `3.2`, `3.3`, `3.4`, `3.5`, `3.6`."""
    assign_public_ip: builtins.bool
    """The flag that defines whether a public IP address is assigned to the cluster.
    If the value is `true`, then Apache Kafka® cluster is available on the Internet via it's public IP address.
    """
    unmanaged_topics: builtins.bool
    """Allows to manage topics via AdminAPI
    Deprecated. Feature enabled permanently.
    """
    schema_registry: builtins.bool
    """Enables managed schema registry on cluster"""
    @property
    def kafka(self) -> global___ConfigSpec.Kafka:
        """Configuration and resource allocation for Kafka brokers."""

    @property
    def zookeeper(self) -> global___ConfigSpec.Zookeeper:
        """Configuration and resource allocation for ZooKeeper hosts."""

    @property
    def zone_id(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """IDs of availability zones where Kafka brokers reside."""

    @property
    def brokers_count(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The number of Kafka brokers deployed in each availability zone."""

    @property
    def access(self) -> global___Access:
        """Access policy for external services."""

    @property
    def rest_api_config(self) -> global___ConfigSpec.RestAPIConfig:
        """Configuration of REST API."""

    @property
    def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
        """DiskSizeAutoscaling settings"""

    @property
    def kraft(self) -> global___ConfigSpec.KRaft:
        """Configuration and resource allocation for KRaft-controller hosts."""

    @property
    def kafka_ui_config(self) -> global___ConfigSpec.KafkaUIConfig:
        """Configuration of Kafka UI."""

    def __init__(
        self,
        *,
        version: builtins.str = ...,
        kafka: global___ConfigSpec.Kafka | None = ...,
        zookeeper: global___ConfigSpec.Zookeeper | None = ...,
        zone_id: collections.abc.Iterable[builtins.str] | None = ...,
        brokers_count: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        assign_public_ip: builtins.bool = ...,
        unmanaged_topics: builtins.bool = ...,
        schema_registry: builtins.bool = ...,
        access: global___Access | None = ...,
        rest_api_config: global___ConfigSpec.RestAPIConfig | None = ...,
        disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        kraft: global___ConfigSpec.KRaft | None = ...,
        kafka_ui_config: global___ConfigSpec.KafkaUIConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["access", b"access", "brokers_count", b"brokers_count", "disk_size_autoscaling", b"disk_size_autoscaling", "kafka", b"kafka", "kafka_ui_config", b"kafka_ui_config", "kraft", b"kraft", "rest_api_config", b"rest_api_config", "zookeeper", b"zookeeper"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["access", b"access", "assign_public_ip", b"assign_public_ip", "brokers_count", b"brokers_count", "disk_size_autoscaling", b"disk_size_autoscaling", "kafka", b"kafka", "kafka_ui_config", b"kafka_ui_config", "kraft", b"kraft", "rest_api_config", b"rest_api_config", "schema_registry", b"schema_registry", "unmanaged_topics", b"unmanaged_topics", "version", b"version", "zone_id", b"zone_id", "zookeeper", b"zookeeper"]) -> None: ...

global___ConfigSpec = ConfigSpec

@typing.final
class Resources(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOURCE_PRESET_ID_FIELD_NUMBER: builtins.int
    DISK_SIZE_FIELD_NUMBER: builtins.int
    DISK_TYPE_ID_FIELD_NUMBER: builtins.int
    resource_preset_id: builtins.str
    """ID of the preset for computational resources available to a host (CPU, memory, etc.).
    All available presets are listed in the [documentation](/docs/managed-kafka/concepts/instance-types).
    """
    disk_size: builtins.int
    """Volume of the storage available to a host, in bytes. Must be greater than 2 * partition segment size in bytes * partitions count, so each partition can have one active segment file and one closed segment file that can be deleted."""
    disk_type_id: builtins.str
    """Type of the storage environment for the host."""
    def __init__(
        self,
        *,
        resource_preset_id: builtins.str = ...,
        disk_size: builtins.int = ...,
        disk_type_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["disk_size", b"disk_size", "disk_type_id", b"disk_type_id", "resource_preset_id", b"resource_preset_id"]) -> None: ...

global___Resources = Resources

@typing.final
class KafkaConfig2_8(google.protobuf.message.Message):
    """Kafka version 2.8 broker configuration."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMPRESSION_TYPE_FIELD_NUMBER: builtins.int
    LOG_FLUSH_INTERVAL_MESSAGES_FIELD_NUMBER: builtins.int
    LOG_FLUSH_INTERVAL_MS_FIELD_NUMBER: builtins.int
    LOG_FLUSH_SCHEDULER_INTERVAL_MS_FIELD_NUMBER: builtins.int
    LOG_RETENTION_BYTES_FIELD_NUMBER: builtins.int
    LOG_RETENTION_HOURS_FIELD_NUMBER: builtins.int
    LOG_RETENTION_MINUTES_FIELD_NUMBER: builtins.int
    LOG_RETENTION_MS_FIELD_NUMBER: builtins.int
    LOG_SEGMENT_BYTES_FIELD_NUMBER: builtins.int
    LOG_PREALLOCATE_FIELD_NUMBER: builtins.int
    SOCKET_SEND_BUFFER_BYTES_FIELD_NUMBER: builtins.int
    SOCKET_RECEIVE_BUFFER_BYTES_FIELD_NUMBER: builtins.int
    AUTO_CREATE_TOPICS_ENABLE_FIELD_NUMBER: builtins.int
    NUM_PARTITIONS_FIELD_NUMBER: builtins.int
    DEFAULT_REPLICATION_FACTOR_FIELD_NUMBER: builtins.int
    MESSAGE_MAX_BYTES_FIELD_NUMBER: builtins.int
    REPLICA_FETCH_MAX_BYTES_FIELD_NUMBER: builtins.int
    SSL_CIPHER_SUITES_FIELD_NUMBER: builtins.int
    OFFSETS_RETENTION_MINUTES_FIELD_NUMBER: builtins.int
    SASL_ENABLED_MECHANISMS_FIELD_NUMBER: builtins.int
    compression_type: yandex.cloud.mdb.kafka.v1.common_pb2.CompressionType.ValueType
    """Cluster topics compression type."""
    @property
    def log_flush_interval_messages(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The number of messages accumulated on a log partition before messages are flushed to disk.

        This is the global cluster-level setting that can be overridden on a topic level by using the [TopicConfig2_8.flush_messages] setting.
        """

    @property
    def log_flush_interval_ms(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The maximum time (in milliseconds) that a message in any topic is kept in memory before flushed to disk.
        If not set, the value of [log_flush_scheduler_interval_ms] is used.

        This is the global cluster-level setting that can be overridden on a topic level by using the [TopicConfig2_8.flush_ms] setting.
        """

    @property
    def log_flush_scheduler_interval_ms(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The frequency of checks (in milliseconds) for any logs that need to be flushed to disk.
        This check is done by the log flusher.
        """

    @property
    def log_retention_bytes(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Partition size limit; Kafka will discard old log segments to free up space if `delete` [TopicConfig2_8.cleanup_policy] is in effect.
        This setting is helpful if you need to control the size of a log due to limited disk space.

        This is the global cluster-level setting that can be overridden on a topic level by using the [TopicConfig2_8.retention_bytes] setting.
        """

    @property
    def log_retention_hours(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The number of hours to keep a log segment file before deleting it."""

    @property
    def log_retention_minutes(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The number of minutes to keep a log segment file before deleting it.

        If not set, the value of [log_retention_hours] is used.
        """

    @property
    def log_retention_ms(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The number of milliseconds to keep a log segment file before deleting it.

        If not set, the value of [log_retention_minutes] is used.

        This is the global cluster-level setting that can be overridden on a topic level by using the [TopicConfig2_8.retention_ms] setting.
        """

    @property
    def log_segment_bytes(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The maximum size of a single log file.

        This is the global cluster-level setting that can be overridden on a topic level by using the [TopicConfig2_8.segment_bytes] setting.
        """

    @property
    def log_preallocate(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Should pre allocate file when create new segment?

        This is the global cluster-level setting that can be overridden on a topic level by using the [TopicConfig2_8.preallocate] setting.
        Deprecated. Feature useless for Yandex Cloud.
        """

    @property
    def socket_send_buffer_bytes(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The SO_SNDBUF buffer of the socket server sockets. If the value is -1, the OS default will be used."""

    @property
    def socket_receive_buffer_bytes(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The SO_RCVBUF buffer of the socket server sockets. If the value is -1, the OS default will be used."""

    @property
    def auto_create_topics_enable(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Enable auto creation of topic on the server"""

    @property
    def num_partitions(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Default number of partitions per topic on the whole cluster"""

    @property
    def default_replication_factor(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Default replication factor of the topic on the whole cluster"""

    @property
    def message_max_bytes(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The largest record batch size allowed by Kafka. Default value: 1048588."""

    @property
    def replica_fetch_max_bytes(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The number of bytes of messages to attempt to fetch for each partition. Default value: 1048576."""

    @property
    def ssl_cipher_suites(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """A list of cipher suites."""

    @property
    def offsets_retention_minutes(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Offset storage time after a consumer group loses all its consumers. Default: 10080."""

    @property
    def sasl_enabled_mechanisms(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[yandex.cloud.mdb.kafka.v1.common_pb2.SaslMechanism.ValueType]:
        """The list of SASL mechanisms enabled in the Kafka server. Default: [SCRAM_SHA_512]."""

    def __init__(
        self,
        *,
        compression_type: yandex.cloud.mdb.kafka.v1.common_pb2.CompressionType.ValueType = ...,
        log_flush_interval_messages: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        log_flush_interval_ms: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        log_flush_scheduler_interval_ms: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        log_retention_bytes: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        log_retention_hours: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        log_retention_minutes: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        log_retention_ms: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        log_segment_bytes: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        log_preallocate: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        socket_send_buffer_bytes: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        socket_receive_buffer_bytes: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        auto_create_topics_enable: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        num_partitions: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        default_replication_factor: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        message_max_bytes: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        replica_fetch_max_bytes: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        ssl_cipher_suites: collections.abc.Iterable[builtins.str] | None = ...,
        offsets_retention_minutes: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        sasl_enabled_mechanisms: collections.abc.Iterable[yandex.cloud.mdb.kafka.v1.common_pb2.SaslMechanism.ValueType] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["auto_create_topics_enable", b"auto_create_topics_enable", "default_replication_factor", b"default_replication_factor", "log_flush_interval_messages", b"log_flush_interval_messages", "log_flush_interval_ms", b"log_flush_interval_ms", "log_flush_scheduler_interval_ms", b"log_flush_scheduler_interval_ms", "log_preallocate", b"log_preallocate", "log_retention_bytes", b"log_retention_bytes", "log_retention_hours", b"log_retention_hours", "log_retention_minutes", b"log_retention_minutes", "log_retention_ms", b"log_retention_ms", "log_segment_bytes", b"log_segment_bytes", "message_max_bytes", b"message_max_bytes", "num_partitions", b"num_partitions", "offsets_retention_minutes", b"offsets_retention_minutes", "replica_fetch_max_bytes", b"replica_fetch_max_bytes", "socket_receive_buffer_bytes", b"socket_receive_buffer_bytes", "socket_send_buffer_bytes", b"socket_send_buffer_bytes"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["auto_create_topics_enable", b"auto_create_topics_enable", "compression_type", b"compression_type", "default_replication_factor", b"default_replication_factor", "log_flush_interval_messages", b"log_flush_interval_messages", "log_flush_interval_ms", b"log_flush_interval_ms", "log_flush_scheduler_interval_ms", b"log_flush_scheduler_interval_ms", "log_preallocate", b"log_preallocate", "log_retention_bytes", b"log_retention_bytes", "log_retention_hours", b"log_retention_hours", "log_retention_minutes", b"log_retention_minutes", "log_retention_ms", b"log_retention_ms", "log_segment_bytes", b"log_segment_bytes", "message_max_bytes", b"message_max_bytes", "num_partitions", b"num_partitions", "offsets_retention_minutes", b"offsets_retention_minutes", "replica_fetch_max_bytes", b"replica_fetch_max_bytes", "sasl_enabled_mechanisms", b"sasl_enabled_mechanisms", "socket_receive_buffer_bytes", b"socket_receive_buffer_bytes", "socket_send_buffer_bytes", b"socket_send_buffer_bytes", "ssl_cipher_suites", b"ssl_cipher_suites"]) -> None: ...

global___KafkaConfig2_8 = KafkaConfig2_8

@typing.final
class KafkaConfig3(google.protobuf.message.Message):
    """Kafka version 3.x broker configuration."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMPRESSION_TYPE_FIELD_NUMBER: builtins.int
    LOG_FLUSH_INTERVAL_MESSAGES_FIELD_NUMBER: builtins.int
    LOG_FLUSH_INTERVAL_MS_FIELD_NUMBER: builtins.int
    LOG_FLUSH_SCHEDULER_INTERVAL_MS_FIELD_NUMBER: builtins.int
    LOG_RETENTION_BYTES_FIELD_NUMBER: builtins.int
    LOG_RETENTION_HOURS_FIELD_NUMBER: builtins.int
    LOG_RETENTION_MINUTES_FIELD_NUMBER: builtins.int
    LOG_RETENTION_MS_FIELD_NUMBER: builtins.int
    LOG_SEGMENT_BYTES_FIELD_NUMBER: builtins.int
    LOG_PREALLOCATE_FIELD_NUMBER: builtins.int
    SOCKET_SEND_BUFFER_BYTES_FIELD_NUMBER: builtins.int
    SOCKET_RECEIVE_BUFFER_BYTES_FIELD_NUMBER: builtins.int
    AUTO_CREATE_TOPICS_ENABLE_FIELD_NUMBER: builtins.int
    NUM_PARTITIONS_FIELD_NUMBER: builtins.int
    DEFAULT_REPLICATION_FACTOR_FIELD_NUMBER: builtins.int
    MESSAGE_MAX_BYTES_FIELD_NUMBER: builtins.int
    REPLICA_FETCH_MAX_BYTES_FIELD_NUMBER: builtins.int
    SSL_CIPHER_SUITES_FIELD_NUMBER: builtins.int
    OFFSETS_RETENTION_MINUTES_FIELD_NUMBER: builtins.int
    SASL_ENABLED_MECHANISMS_FIELD_NUMBER: builtins.int
    compression_type: yandex.cloud.mdb.kafka.v1.common_pb2.CompressionType.ValueType
    """Cluster topics compression type."""
    @property
    def log_flush_interval_messages(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The number of messages accumulated on a log partition before messages are flushed to disk.

        This is the global cluster-level setting that can be overridden on a topic level by using the [TopicConfig3.flush_messages] setting.
        """

    @property
    def log_flush_interval_ms(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The maximum time (in milliseconds) that a message in any topic is kept in memory before flushed to disk.
        If not set, the value of [log_flush_scheduler_interval_ms] is used.

        This is the global cluster-level setting that can be overridden on a topic level by using the [TopicConfig3.flush_ms] setting.
        """

    @property
    def log_flush_scheduler_interval_ms(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The frequency of checks (in milliseconds) for any logs that need to be flushed to disk.
        This check is done by the log flusher.
        """

    @property
    def log_retention_bytes(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Partition size limit; Kafka will discard old log segments to free up space if `delete` [TopicConfig3.cleanup_policy] is in effect.
        This setting is helpful if you need to control the size of a log due to limited disk space.

        This is the global cluster-level setting that can be overridden on a topic level by using the [TopicConfig3.retention_bytes] setting.
        """

    @property
    def log_retention_hours(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The number of hours to keep a log segment file before deleting it."""

    @property
    def log_retention_minutes(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The number of minutes to keep a log segment file before deleting it.

        If not set, the value of [log_retention_hours] is used.
        """

    @property
    def log_retention_ms(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The number of milliseconds to keep a log segment file before deleting it.

        If not set, the value of [log_retention_minutes] is used.

        This is the global cluster-level setting that can be overridden on a topic level by using the [TopicConfig3.retention_ms] setting.
        """

    @property
    def log_segment_bytes(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The maximum size of a single log file.

        This is the global cluster-level setting that can be overridden on a topic level by using the [TopicConfig3.segment_bytes] setting.
        """

    @property
    def log_preallocate(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Should pre allocate file when create new segment?

        This is the global cluster-level setting that can be overridden on a topic level by using the [TopicConfig3.preallocate] setting.
        Deprecated. Feature useless for Yandex Cloud.
        """

    @property
    def socket_send_buffer_bytes(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The SO_SNDBUF buffer of the socket server sockets. If the value is -1, the OS default will be used."""

    @property
    def socket_receive_buffer_bytes(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The SO_RCVBUF buffer of the socket server sockets. If the value is -1, the OS default will be used."""

    @property
    def auto_create_topics_enable(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Enable auto creation of topic on the server"""

    @property
    def num_partitions(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Default number of partitions per topic on the whole cluster"""

    @property
    def default_replication_factor(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Default replication factor of the topic on the whole cluster"""

    @property
    def message_max_bytes(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The largest record batch size allowed by Kafka. Default value: 1048588."""

    @property
    def replica_fetch_max_bytes(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The number of bytes of messages to attempt to fetch for each partition. Default value: 1048576."""

    @property
    def ssl_cipher_suites(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """A list of cipher suites."""

    @property
    def offsets_retention_minutes(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Offset storage time after a consumer group loses all its consumers. Default: 10080."""

    @property
    def sasl_enabled_mechanisms(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[yandex.cloud.mdb.kafka.v1.common_pb2.SaslMechanism.ValueType]:
        """The list of SASL mechanisms enabled in the Kafka server. Default: [SCRAM_SHA_512]."""

    def __init__(
        self,
        *,
        compression_type: yandex.cloud.mdb.kafka.v1.common_pb2.CompressionType.ValueType = ...,
        log_flush_interval_messages: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        log_flush_interval_ms: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        log_flush_scheduler_interval_ms: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        log_retention_bytes: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        log_retention_hours: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        log_retention_minutes: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        log_retention_ms: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        log_segment_bytes: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        log_preallocate: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        socket_send_buffer_bytes: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        socket_receive_buffer_bytes: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        auto_create_topics_enable: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        num_partitions: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        default_replication_factor: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        message_max_bytes: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        replica_fetch_max_bytes: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        ssl_cipher_suites: collections.abc.Iterable[builtins.str] | None = ...,
        offsets_retention_minutes: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        sasl_enabled_mechanisms: collections.abc.Iterable[yandex.cloud.mdb.kafka.v1.common_pb2.SaslMechanism.ValueType] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["auto_create_topics_enable", b"auto_create_topics_enable", "default_replication_factor", b"default_replication_factor", "log_flush_interval_messages", b"log_flush_interval_messages", "log_flush_interval_ms", b"log_flush_interval_ms", "log_flush_scheduler_interval_ms", b"log_flush_scheduler_interval_ms", "log_preallocate", b"log_preallocate", "log_retention_bytes", b"log_retention_bytes", "log_retention_hours", b"log_retention_hours", "log_retention_minutes", b"log_retention_minutes", "log_retention_ms", b"log_retention_ms", "log_segment_bytes", b"log_segment_bytes", "message_max_bytes", b"message_max_bytes", "num_partitions", b"num_partitions", "offsets_retention_minutes", b"offsets_retention_minutes", "replica_fetch_max_bytes", b"replica_fetch_max_bytes", "socket_receive_buffer_bytes", b"socket_receive_buffer_bytes", "socket_send_buffer_bytes", b"socket_send_buffer_bytes"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["auto_create_topics_enable", b"auto_create_topics_enable", "compression_type", b"compression_type", "default_replication_factor", b"default_replication_factor", "log_flush_interval_messages", b"log_flush_interval_messages", "log_flush_interval_ms", b"log_flush_interval_ms", "log_flush_scheduler_interval_ms", b"log_flush_scheduler_interval_ms", "log_preallocate", b"log_preallocate", "log_retention_bytes", b"log_retention_bytes", "log_retention_hours", b"log_retention_hours", "log_retention_minutes", b"log_retention_minutes", "log_retention_ms", b"log_retention_ms", "log_segment_bytes", b"log_segment_bytes", "message_max_bytes", b"message_max_bytes", "num_partitions", b"num_partitions", "offsets_retention_minutes", b"offsets_retention_minutes", "replica_fetch_max_bytes", b"replica_fetch_max_bytes", "sasl_enabled_mechanisms", b"sasl_enabled_mechanisms", "socket_receive_buffer_bytes", b"socket_receive_buffer_bytes", "socket_send_buffer_bytes", b"socket_send_buffer_bytes", "ssl_cipher_suites", b"ssl_cipher_suites"]) -> None: ...

global___KafkaConfig3 = KafkaConfig3

@typing.final
class Host(google.protobuf.message.Message):
    """Cluster host metadata."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Role:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _RoleEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Host._Role.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        ROLE_UNSPECIFIED: Host._Role.ValueType  # 0
        """Role of the host is unspecified. Default value."""
        KAFKA: Host._Role.ValueType  # 1
        """The host is a Kafka broker."""
        ZOOKEEPER: Host._Role.ValueType  # 2
        """The host is a ZooKeeper server."""
        KRAFT: Host._Role.ValueType  # 3
        """The host is a Kafka KRaft controller broker."""

    class Role(_Role, metaclass=_RoleEnumTypeWrapper): ...
    ROLE_UNSPECIFIED: Host.Role.ValueType  # 0
    """Role of the host is unspecified. Default value."""
    KAFKA: Host.Role.ValueType  # 1
    """The host is a Kafka broker."""
    ZOOKEEPER: Host.Role.ValueType  # 2
    """The host is a ZooKeeper server."""
    KRAFT: Host.Role.ValueType  # 3
    """The host is a Kafka KRaft controller broker."""

    class _Health:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _HealthEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Host._Health.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNKNOWN: Host._Health.ValueType  # 0
        """Health of the host is unknown. Default value."""
        ALIVE: Host._Health.ValueType  # 1
        """The host is performing all its functions normally."""
        DEAD: Host._Health.ValueType  # 2
        """The host is inoperable and cannot perform any of its essential functions."""
        DEGRADED: Host._Health.ValueType  # 3
        """The host is degraded and can perform only some of its essential functions."""

    class Health(_Health, metaclass=_HealthEnumTypeWrapper): ...
    UNKNOWN: Host.Health.ValueType  # 0
    """Health of the host is unknown. Default value."""
    ALIVE: Host.Health.ValueType  # 1
    """The host is performing all its functions normally."""
    DEAD: Host.Health.ValueType  # 2
    """The host is inoperable and cannot perform any of its essential functions."""
    DEGRADED: Host.Health.ValueType  # 3
    """The host is degraded and can perform only some of its essential functions."""

    NAME_FIELD_NUMBER: builtins.int
    CLUSTER_ID_FIELD_NUMBER: builtins.int
    ZONE_ID_FIELD_NUMBER: builtins.int
    ROLE_FIELD_NUMBER: builtins.int
    RESOURCES_FIELD_NUMBER: builtins.int
    HEALTH_FIELD_NUMBER: builtins.int
    SUBNET_ID_FIELD_NUMBER: builtins.int
    ASSIGN_PUBLIC_IP_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the host."""
    cluster_id: builtins.str
    """ID of the Apache Kafka® cluster."""
    zone_id: builtins.str
    """ID of the availability zone where the host resides."""
    role: global___Host.Role.ValueType
    """Host role. If the field has default value, it is not returned in the response."""
    health: global___Host.Health.ValueType
    """Aggregated host health data. If the field has default value, it is not returned in the response."""
    subnet_id: builtins.str
    """ID of the subnet the host resides in."""
    assign_public_ip: builtins.bool
    """The flag that defines whether a public IP address is assigned to the node.

    If the value is `true`, then this node is available on the Internet via it's public IP address.
    """
    @property
    def resources(self) -> global___Resources:
        """Computational resources allocated to the host."""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        cluster_id: builtins.str = ...,
        zone_id: builtins.str = ...,
        role: global___Host.Role.ValueType = ...,
        resources: global___Resources | None = ...,
        health: global___Host.Health.ValueType = ...,
        subnet_id: builtins.str = ...,
        assign_public_ip: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["resources", b"resources"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["assign_public_ip", b"assign_public_ip", "cluster_id", b"cluster_id", "health", b"health", "name", b"name", "resources", b"resources", "role", b"role", "subnet_id", b"subnet_id", "zone_id", b"zone_id"]) -> None: ...

global___Host = Host

@typing.final
class Access(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATA_TRANSFER_FIELD_NUMBER: builtins.int
    data_transfer: builtins.bool
    """Allow access for DataTransfer."""
    def __init__(
        self,
        *,
        data_transfer: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["data_transfer", b"data_transfer"]) -> None: ...

global___Access = Access

@typing.final
class DiskSizeAutoscaling(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PLANNED_USAGE_THRESHOLD_FIELD_NUMBER: builtins.int
    EMERGENCY_USAGE_THRESHOLD_FIELD_NUMBER: builtins.int
    DISK_SIZE_LIMIT_FIELD_NUMBER: builtins.int
    planned_usage_threshold: builtins.int
    """Threshold of storage usage (in percent) that triggers automatic scaling of the storage during the maintenance window. Zero value means disabled threshold."""
    emergency_usage_threshold: builtins.int
    """Threshold of storage usage (in percent) that triggers immediate automatic scaling of the storage. Zero value means disabled threshold."""
    disk_size_limit: builtins.int
    """New storage size (in bytes) that is set when one of the thresholds is achieved."""
    def __init__(
        self,
        *,
        planned_usage_threshold: builtins.int = ...,
        emergency_usage_threshold: builtins.int = ...,
        disk_size_limit: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["disk_size_limit", b"disk_size_limit", "emergency_usage_threshold", b"emergency_usage_threshold", "planned_usage_threshold", b"planned_usage_threshold"]) -> None: ...

global___DiskSizeAutoscaling = DiskSizeAutoscaling
