"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.wrappers_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class ConnectorSpec(google.protobuf.message.Message):
    """An object that represents an Apache Kafka® connector.

    See [the documentation](/docs/managed-kafka/concepts/connectors) for details.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class PropertiesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    TASKS_MAX_FIELD_NUMBER: builtins.int
    PROPERTIES_FIELD_NUMBER: builtins.int
    CONNECTOR_CONFIG_MIRRORMAKER_FIELD_NUMBER: builtins.int
    CONNECTOR_CONFIG_S3_SINK_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the connector."""
    @property
    def tasks_max(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Maximum number of connector tasks. Default value is the number of brokers."""

    @property
    def properties(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """A set of properties passed to Managed Service for Apache Kafka® with the connector configuration.
        Example: `sync.topics.config.enabled: true`.
        """

    @property
    def connector_config_mirrormaker(self) -> global___ConnectorConfigMirrorMakerSpec:
        """Configuration of the MirrorMaker connector."""

    @property
    def connector_config_s3_sink(self) -> global___ConnectorConfigS3SinkSpec:
        """Configuration of S3-Sink connector."""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        tasks_max: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        properties: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        connector_config_mirrormaker: global___ConnectorConfigMirrorMakerSpec | None = ...,
        connector_config_s3_sink: global___ConnectorConfigS3SinkSpec | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["connector_config", b"connector_config", "connector_config_mirrormaker", b"connector_config_mirrormaker", "connector_config_s3_sink", b"connector_config_s3_sink", "tasks_max", b"tasks_max"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["connector_config", b"connector_config", "connector_config_mirrormaker", b"connector_config_mirrormaker", "connector_config_s3_sink", b"connector_config_s3_sink", "name", b"name", "properties", b"properties", "tasks_max", b"tasks_max"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["connector_config", b"connector_config"]) -> typing.Literal["connector_config_mirrormaker", "connector_config_s3_sink"] | None: ...

global___ConnectorSpec = ConnectorSpec

@typing.final
class UpdateConnectorSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class PropertiesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    TASKS_MAX_FIELD_NUMBER: builtins.int
    PROPERTIES_FIELD_NUMBER: builtins.int
    CONNECTOR_CONFIG_MIRRORMAKER_FIELD_NUMBER: builtins.int
    CONNECTOR_CONFIG_S3_SINK_FIELD_NUMBER: builtins.int
    @property
    def tasks_max(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Maximum number of connector tasks to update."""

    @property
    def properties(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """A set of new or changed properties to update for the connector. They are passed with the connector configuration to Managed Service for Apache Kafka®.
        Example: `sync.topics.config.enabled: false`.
        """

    @property
    def connector_config_mirrormaker(self) -> global___ConnectorConfigMirrorMakerSpec:
        """Configuration of the MirrorMaker connector."""

    @property
    def connector_config_s3_sink(self) -> global___UpdateConnectorConfigS3SinkSpec:
        """Update specification for S3-Sink Connector."""

    def __init__(
        self,
        *,
        tasks_max: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        properties: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        connector_config_mirrormaker: global___ConnectorConfigMirrorMakerSpec | None = ...,
        connector_config_s3_sink: global___UpdateConnectorConfigS3SinkSpec | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["connector_config", b"connector_config", "connector_config_mirrormaker", b"connector_config_mirrormaker", "connector_config_s3_sink", b"connector_config_s3_sink", "tasks_max", b"tasks_max"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["connector_config", b"connector_config", "connector_config_mirrormaker", b"connector_config_mirrormaker", "connector_config_s3_sink", b"connector_config_s3_sink", "properties", b"properties", "tasks_max", b"tasks_max"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["connector_config", b"connector_config"]) -> typing.Literal["connector_config_mirrormaker", "connector_config_s3_sink"] | None: ...

global___UpdateConnectorSpec = UpdateConnectorSpec

@typing.final
class ConnectorConfigMirrorMakerSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SOURCE_CLUSTER_FIELD_NUMBER: builtins.int
    TARGET_CLUSTER_FIELD_NUMBER: builtins.int
    TOPICS_FIELD_NUMBER: builtins.int
    REPLICATION_FACTOR_FIELD_NUMBER: builtins.int
    topics: builtins.str
    """List of Kafka topics, separated by `,`."""
    @property
    def source_cluster(self) -> global___ClusterConnectionSpec:
        """Source cluster configuration for the MirrorMaker connector."""

    @property
    def target_cluster(self) -> global___ClusterConnectionSpec:
        """Target cluster configuration for the MirrorMaker connector."""

    @property
    def replication_factor(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Replication factor for automatically created topics."""

    def __init__(
        self,
        *,
        source_cluster: global___ClusterConnectionSpec | None = ...,
        target_cluster: global___ClusterConnectionSpec | None = ...,
        topics: builtins.str = ...,
        replication_factor: google.protobuf.wrappers_pb2.Int64Value | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["replication_factor", b"replication_factor", "source_cluster", b"source_cluster", "target_cluster", b"target_cluster"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["replication_factor", b"replication_factor", "source_cluster", b"source_cluster", "target_cluster", b"target_cluster", "topics", b"topics"]) -> None: ...

global___ConnectorConfigMirrorMakerSpec = ConnectorConfigMirrorMakerSpec

@typing.final
class ClusterConnectionSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ALIAS_FIELD_NUMBER: builtins.int
    THIS_CLUSTER_FIELD_NUMBER: builtins.int
    EXTERNAL_CLUSTER_FIELD_NUMBER: builtins.int
    alias: builtins.str
    """Alias of cluster connection configuration.
    Examples: `source`, `target`.
    """
    @property
    def this_cluster(self) -> global___ThisClusterSpec:
        """Connection configuration of the cluster the connector belongs to. As all credentials are already known, leave this parameter empty."""

    @property
    def external_cluster(self) -> global___ExternalClusterConnectionSpec:
        """Configuration of connection to an external cluster with all the necessary credentials."""

    def __init__(
        self,
        *,
        alias: builtins.str = ...,
        this_cluster: global___ThisClusterSpec | None = ...,
        external_cluster: global___ExternalClusterConnectionSpec | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["cluster_connection", b"cluster_connection", "external_cluster", b"external_cluster", "this_cluster", b"this_cluster"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["alias", b"alias", "cluster_connection", b"cluster_connection", "external_cluster", b"external_cluster", "this_cluster", b"this_cluster"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["cluster_connection", b"cluster_connection"]) -> typing.Literal["this_cluster", "external_cluster"] | None: ...

global___ClusterConnectionSpec = ClusterConnectionSpec

@typing.final
class ThisClusterSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ThisClusterSpec = ThisClusterSpec

@typing.final
class ExternalClusterConnectionSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BOOTSTRAP_SERVERS_FIELD_NUMBER: builtins.int
    SASL_USERNAME_FIELD_NUMBER: builtins.int
    SASL_PASSWORD_FIELD_NUMBER: builtins.int
    SASL_MECHANISM_FIELD_NUMBER: builtins.int
    SECURITY_PROTOCOL_FIELD_NUMBER: builtins.int
    SSL_TRUSTSTORE_CERTIFICATES_FIELD_NUMBER: builtins.int
    bootstrap_servers: builtins.str
    """List of bootstrap servers of the cluster, separated by `,`."""
    sasl_username: builtins.str
    """SASL username to use for connection to the cluster."""
    sasl_password: builtins.str
    """SASL password to use for connection to the cluster."""
    sasl_mechanism: builtins.str
    """SASL mechanism to use for connection to the cluster."""
    security_protocol: builtins.str
    """Security protocol to use for connection to the cluster."""
    ssl_truststore_certificates: builtins.str
    """CA in PEM format to connect to external cluster.
    Lines of certificate separated by '\\n' symbol.
    """
    def __init__(
        self,
        *,
        bootstrap_servers: builtins.str = ...,
        sasl_username: builtins.str = ...,
        sasl_password: builtins.str = ...,
        sasl_mechanism: builtins.str = ...,
        security_protocol: builtins.str = ...,
        ssl_truststore_certificates: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["bootstrap_servers", b"bootstrap_servers", "sasl_mechanism", b"sasl_mechanism", "sasl_password", b"sasl_password", "sasl_username", b"sasl_username", "security_protocol", b"security_protocol", "ssl_truststore_certificates", b"ssl_truststore_certificates"]) -> None: ...

global___ExternalClusterConnectionSpec = ExternalClusterConnectionSpec

@typing.final
class ConnectorConfigS3SinkSpec(google.protobuf.message.Message):
    """Specification for Kafka S3-Sink Connector."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TOPICS_FIELD_NUMBER: builtins.int
    FILE_COMPRESSION_TYPE_FIELD_NUMBER: builtins.int
    FILE_MAX_RECORDS_FIELD_NUMBER: builtins.int
    S3_CONNECTION_FIELD_NUMBER: builtins.int
    topics: builtins.str
    """List of Kafka topics, separated by ','."""
    file_compression_type: builtins.str
    """The compression type used for files put on GCS.
    The supported values are: `gzip`, `snappy`, `zstd`, `none`.
    Optional, the default is `none`.
    """
    @property
    def file_max_records(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Max records per file."""

    @property
    def s3_connection(self) -> global___S3ConnectionSpec:
        """Credentials for connecting to S3 storage."""

    def __init__(
        self,
        *,
        topics: builtins.str = ...,
        file_compression_type: builtins.str = ...,
        file_max_records: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        s3_connection: global___S3ConnectionSpec | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["file_max_records", b"file_max_records", "s3_connection", b"s3_connection"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["file_compression_type", b"file_compression_type", "file_max_records", b"file_max_records", "s3_connection", b"s3_connection", "topics", b"topics"]) -> None: ...

global___ConnectorConfigS3SinkSpec = ConnectorConfigS3SinkSpec

@typing.final
class UpdateConnectorConfigS3SinkSpec(google.protobuf.message.Message):
    """Specification for update Kafka S3-Sink Connector."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TOPICS_FIELD_NUMBER: builtins.int
    FILE_MAX_RECORDS_FIELD_NUMBER: builtins.int
    S3_CONNECTION_FIELD_NUMBER: builtins.int
    topics: builtins.str
    """List of Kafka topics, separated by ','."""
    @property
    def file_max_records(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Max records per file."""

    @property
    def s3_connection(self) -> global___S3ConnectionSpec:
        """Credentials for connecting to S3 storage."""

    def __init__(
        self,
        *,
        topics: builtins.str = ...,
        file_max_records: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        s3_connection: global___S3ConnectionSpec | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["file_max_records", b"file_max_records", "s3_connection", b"s3_connection"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["file_max_records", b"file_max_records", "s3_connection", b"s3_connection", "topics", b"topics"]) -> None: ...

global___UpdateConnectorConfigS3SinkSpec = UpdateConnectorConfigS3SinkSpec

@typing.final
class S3ConnectionSpec(google.protobuf.message.Message):
    """Specification for S3Connection -
    settings of connection to AWS-compatible S3 storage, that
    are source or target of Kafka S3-connectors.
    YC Object Storage is AWS-compatible.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BUCKET_NAME_FIELD_NUMBER: builtins.int
    EXTERNAL_S3_FIELD_NUMBER: builtins.int
    bucket_name: builtins.str
    @property
    def external_s3(self) -> global___ExternalS3StorageSpec: ...
    def __init__(
        self,
        *,
        bucket_name: builtins.str = ...,
        external_s3: global___ExternalS3StorageSpec | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["external_s3", b"external_s3", "storage", b"storage"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["bucket_name", b"bucket_name", "external_s3", b"external_s3", "storage", b"storage"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["storage", b"storage"]) -> typing.Literal["external_s3"] | None: ...

global___S3ConnectionSpec = S3ConnectionSpec

@typing.final
class ExternalS3StorageSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCESS_KEY_ID_FIELD_NUMBER: builtins.int
    SECRET_ACCESS_KEY_FIELD_NUMBER: builtins.int
    ENDPOINT_FIELD_NUMBER: builtins.int
    REGION_FIELD_NUMBER: builtins.int
    access_key_id: builtins.str
    secret_access_key: builtins.str
    endpoint: builtins.str
    region: builtins.str
    """Default is 'us-east-1'."""
    def __init__(
        self,
        *,
        access_key_id: builtins.str = ...,
        secret_access_key: builtins.str = ...,
        endpoint: builtins.str = ...,
        region: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["access_key_id", b"access_key_id", "endpoint", b"endpoint", "region", b"region", "secret_access_key", b"secret_access_key"]) -> None: ...

global___ExternalS3StorageSpec = ExternalS3StorageSpec

@typing.final
class Connector(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Health:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _HealthEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Connector._Health.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        HEALTH_UNKNOWN: Connector._Health.ValueType  # 0
        """Health of the connector is unknown."""
        ALIVE: Connector._Health.ValueType  # 1
        """Connector is running."""
        DEAD: Connector._Health.ValueType  # 2
        """Connector has failed to start."""

    class Health(_Health, metaclass=_HealthEnumTypeWrapper): ...
    HEALTH_UNKNOWN: Connector.Health.ValueType  # 0
    """Health of the connector is unknown."""
    ALIVE: Connector.Health.ValueType  # 1
    """Connector is running."""
    DEAD: Connector.Health.ValueType  # 2
    """Connector has failed to start."""

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Connector._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNKNOWN: Connector._Status.ValueType  # 0
        """Connector state is unknown."""
        RUNNING: Connector._Status.ValueType  # 1
        """Connector is running normally."""
        ERROR: Connector._Status.ValueType  # 2
        """Connector has encountered a problem and cannot operate."""
        PAUSED: Connector._Status.ValueType  # 3
        """Connector is paused."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNKNOWN: Connector.Status.ValueType  # 0
    """Connector state is unknown."""
    RUNNING: Connector.Status.ValueType  # 1
    """Connector is running normally."""
    ERROR: Connector.Status.ValueType  # 2
    """Connector has encountered a problem and cannot operate."""
    PAUSED: Connector.Status.ValueType  # 3
    """Connector is paused."""

    @typing.final
    class PropertiesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    TASKS_MAX_FIELD_NUMBER: builtins.int
    PROPERTIES_FIELD_NUMBER: builtins.int
    HEALTH_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    CLUSTER_ID_FIELD_NUMBER: builtins.int
    CONNECTOR_CONFIG_MIRRORMAKER_FIELD_NUMBER: builtins.int
    CONNECTOR_CONFIG_S3_SINK_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the connector."""
    health: global___Connector.Health.ValueType
    """Connector health."""
    status: global___Connector.Status.ValueType
    """Current status of the connector."""
    cluster_id: builtins.str
    """ID of the Apache Kafka® cluster that the connector belongs to."""
    @property
    def tasks_max(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Maximum number of connector tasks. Default value is the number of brokers."""

    @property
    def properties(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """A set of properties passed to Managed Service for Apache Kafka® with the connector configuration.
        Example: `sync.topics.config.enabled: true`.
        """

    @property
    def connector_config_mirrormaker(self) -> global___ConnectorConfigMirrorMaker:
        """Configuration of the MirrorMaker connector."""

    @property
    def connector_config_s3_sink(self) -> global___ConnectorConfigS3Sink:
        """Configuration of S3-Sink connector."""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        tasks_max: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        properties: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        health: global___Connector.Health.ValueType = ...,
        status: global___Connector.Status.ValueType = ...,
        cluster_id: builtins.str = ...,
        connector_config_mirrormaker: global___ConnectorConfigMirrorMaker | None = ...,
        connector_config_s3_sink: global___ConnectorConfigS3Sink | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["connector_config", b"connector_config", "connector_config_mirrormaker", b"connector_config_mirrormaker", "connector_config_s3_sink", b"connector_config_s3_sink", "tasks_max", b"tasks_max"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "connector_config", b"connector_config", "connector_config_mirrormaker", b"connector_config_mirrormaker", "connector_config_s3_sink", b"connector_config_s3_sink", "health", b"health", "name", b"name", "properties", b"properties", "status", b"status", "tasks_max", b"tasks_max"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["connector_config", b"connector_config"]) -> typing.Literal["connector_config_mirrormaker", "connector_config_s3_sink"] | None: ...

global___Connector = Connector

@typing.final
class ConnectorConfigMirrorMaker(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SOURCE_CLUSTER_FIELD_NUMBER: builtins.int
    TARGET_CLUSTER_FIELD_NUMBER: builtins.int
    TOPICS_FIELD_NUMBER: builtins.int
    REPLICATION_FACTOR_FIELD_NUMBER: builtins.int
    topics: builtins.str
    """List of Kafka topics, separated by `,`."""
    @property
    def source_cluster(self) -> global___ClusterConnection:
        """Source cluster connection configuration."""

    @property
    def target_cluster(self) -> global___ClusterConnection:
        """Target cluster connection configuration."""

    @property
    def replication_factor(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Replication factor for automatically created topics."""

    def __init__(
        self,
        *,
        source_cluster: global___ClusterConnection | None = ...,
        target_cluster: global___ClusterConnection | None = ...,
        topics: builtins.str = ...,
        replication_factor: google.protobuf.wrappers_pb2.Int64Value | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["replication_factor", b"replication_factor", "source_cluster", b"source_cluster", "target_cluster", b"target_cluster"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["replication_factor", b"replication_factor", "source_cluster", b"source_cluster", "target_cluster", b"target_cluster", "topics", b"topics"]) -> None: ...

global___ConnectorConfigMirrorMaker = ConnectorConfigMirrorMaker

@typing.final
class ClusterConnection(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ALIAS_FIELD_NUMBER: builtins.int
    THIS_CLUSTER_FIELD_NUMBER: builtins.int
    EXTERNAL_CLUSTER_FIELD_NUMBER: builtins.int
    alias: builtins.str
    """Alias of cluster connection configuration.
    Examples: `source`, `target`.
    """
    @property
    def this_cluster(self) -> global___ThisCluster:
        """Connection configuration of the cluster the connector belongs to. As all credentials are already known, leave this parameter empty."""

    @property
    def external_cluster(self) -> global___ExternalClusterConnection:
        """Configuration of connection to an external cluster with all the necessary credentials."""

    def __init__(
        self,
        *,
        alias: builtins.str = ...,
        this_cluster: global___ThisCluster | None = ...,
        external_cluster: global___ExternalClusterConnection | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["cluster_connection", b"cluster_connection", "external_cluster", b"external_cluster", "this_cluster", b"this_cluster"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["alias", b"alias", "cluster_connection", b"cluster_connection", "external_cluster", b"external_cluster", "this_cluster", b"this_cluster"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["cluster_connection", b"cluster_connection"]) -> typing.Literal["this_cluster", "external_cluster"] | None: ...

global___ClusterConnection = ClusterConnection

@typing.final
class ThisCluster(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ThisCluster = ThisCluster

@typing.final
class ExternalClusterConnection(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BOOTSTRAP_SERVERS_FIELD_NUMBER: builtins.int
    SASL_USERNAME_FIELD_NUMBER: builtins.int
    SASL_MECHANISM_FIELD_NUMBER: builtins.int
    SECURITY_PROTOCOL_FIELD_NUMBER: builtins.int
    bootstrap_servers: builtins.str
    """List of bootstrap servers of the cluster, separated by `,`."""
    sasl_username: builtins.str
    """SASL username to use for connection to the cluster."""
    sasl_mechanism: builtins.str
    """SASL mechanism to use for connection to the cluster."""
    security_protocol: builtins.str
    """Security protocol to use for connection to the cluster."""
    def __init__(
        self,
        *,
        bootstrap_servers: builtins.str = ...,
        sasl_username: builtins.str = ...,
        sasl_mechanism: builtins.str = ...,
        security_protocol: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["bootstrap_servers", b"bootstrap_servers", "sasl_mechanism", b"sasl_mechanism", "sasl_username", b"sasl_username", "security_protocol", b"security_protocol"]) -> None: ...

global___ExternalClusterConnection = ExternalClusterConnection

@typing.final
class ConnectorConfigS3Sink(google.protobuf.message.Message):
    """An Apache Kafka® S3-Sink
    connector resource.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TOPICS_FIELD_NUMBER: builtins.int
    FILE_COMPRESSION_TYPE_FIELD_NUMBER: builtins.int
    FILE_MAX_RECORDS_FIELD_NUMBER: builtins.int
    S3_CONNECTION_FIELD_NUMBER: builtins.int
    topics: builtins.str
    """List of Kafka topics, separated by ','."""
    file_compression_type: builtins.str
    """The compression type used for files put on GCS.
    The supported values are: `gzip`, `snappy`, `zstd`, `none`.
    Optional, the default is `none`.
    """
    @property
    def file_max_records(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Max records per file."""

    @property
    def s3_connection(self) -> global___S3Connection:
        """Credentials for connecting to S3 storage."""

    def __init__(
        self,
        *,
        topics: builtins.str = ...,
        file_compression_type: builtins.str = ...,
        file_max_records: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        s3_connection: global___S3Connection | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["file_max_records", b"file_max_records", "s3_connection", b"s3_connection"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["file_compression_type", b"file_compression_type", "file_max_records", b"file_max_records", "s3_connection", b"s3_connection", "topics", b"topics"]) -> None: ...

global___ConnectorConfigS3Sink = ConnectorConfigS3Sink

@typing.final
class S3Connection(google.protobuf.message.Message):
    """Resource for S3Connection -
    settings of connection to AWS-compatible S3 storage, that
    are source or target of Kafka S3-connectors.
    YC Object Storage is AWS-compatible.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BUCKET_NAME_FIELD_NUMBER: builtins.int
    EXTERNAL_S3_FIELD_NUMBER: builtins.int
    bucket_name: builtins.str
    @property
    def external_s3(self) -> global___ExternalS3Storage: ...
    def __init__(
        self,
        *,
        bucket_name: builtins.str = ...,
        external_s3: global___ExternalS3Storage | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["external_s3", b"external_s3", "storage", b"storage"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["bucket_name", b"bucket_name", "external_s3", b"external_s3", "storage", b"storage"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["storage", b"storage"]) -> typing.Literal["external_s3"] | None: ...

global___S3Connection = S3Connection

@typing.final
class ExternalS3Storage(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCESS_KEY_ID_FIELD_NUMBER: builtins.int
    ENDPOINT_FIELD_NUMBER: builtins.int
    REGION_FIELD_NUMBER: builtins.int
    access_key_id: builtins.str
    endpoint: builtins.str
    region: builtins.str
    """Default is 'us-east-1'"""
    def __init__(
        self,
        *,
        access_key_id: builtins.str = ...,
        endpoint: builtins.str = ...,
        region: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["access_key_id", b"access_key_id", "endpoint", b"endpoint", "region", b"region"]) -> None: ...

global___ExternalS3Storage = ExternalS3Storage
