"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import google.protobuf.wrappers_pb2
import google.type.timeofday_pb2
import sys
import typing
import yandex.cloud.mdb.mongodb.v1.config.mongodb3_6_pb2
import yandex.cloud.mdb.mongodb.v1.config.mongodb4_0_pb2
import yandex.cloud.mdb.mongodb.v1.config.mongodb4_2_pb2
import yandex.cloud.mdb.mongodb.v1.config.mongodb4_4_enterprise_pb2
import yandex.cloud.mdb.mongodb.v1.config.mongodb4_4_pb2
import yandex.cloud.mdb.mongodb.v1.config.mongodb5_0_enterprise_pb2
import yandex.cloud.mdb.mongodb.v1.config.mongodb5_0_pb2
import yandex.cloud.mdb.mongodb.v1.config.mongodb6_0_enterprise_pb2
import yandex.cloud.mdb.mongodb.v1.config.mongodb6_0_pb2
import yandex.cloud.mdb.mongodb.v1.config.mongodb_pb2
import yandex.cloud.mdb.mongodb.v1.maintenance_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Cluster(google.protobuf.message.Message):
    """A managed MongoDB cluster. For more information, see the [documentation](/docs/managed-mongodb/concepts)."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Environment:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EnvironmentEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Cluster._Environment.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        ENVIRONMENT_UNSPECIFIED: Cluster._Environment.ValueType  # 0
        PRODUCTION: Cluster._Environment.ValueType  # 1
        """Stable environment with a conservative update policy: only hotfixes
        are applied during regular maintenance.
        """
        PRESTABLE: Cluster._Environment.ValueType  # 2
        """Environment with more aggressive update policy: new versions
        are rolled out irrespective of backward compatibility.
        """

    class Environment(_Environment, metaclass=_EnvironmentEnumTypeWrapper): ...
    ENVIRONMENT_UNSPECIFIED: Cluster.Environment.ValueType  # 0
    PRODUCTION: Cluster.Environment.ValueType  # 1
    """Stable environment with a conservative update policy: only hotfixes
    are applied during regular maintenance.
    """
    PRESTABLE: Cluster.Environment.ValueType  # 2
    """Environment with more aggressive update policy: new versions
    are rolled out irrespective of backward compatibility.
    """

    class _Health:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _HealthEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Cluster._Health.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        HEALTH_UNKNOWN: Cluster._Health.ValueType  # 0
        """State of the cluster is unknown ([Host.health] for every host in the cluster is UNKNOWN)."""
        ALIVE: Cluster._Health.ValueType  # 1
        """Cluster is alive and well ([Host.health] for every host in the cluster is ALIVE)."""
        DEAD: Cluster._Health.ValueType  # 2
        """Cluster is inoperable ([Host.health] for every host in the cluster is DEAD)."""
        DEGRADED: Cluster._Health.ValueType  # 3
        """Cluster is working below capacity ([Host.health] for at least one host in the cluster is not ALIVE)."""

    class Health(_Health, metaclass=_HealthEnumTypeWrapper): ...
    HEALTH_UNKNOWN: Cluster.Health.ValueType  # 0
    """State of the cluster is unknown ([Host.health] for every host in the cluster is UNKNOWN)."""
    ALIVE: Cluster.Health.ValueType  # 1
    """Cluster is alive and well ([Host.health] for every host in the cluster is ALIVE)."""
    DEAD: Cluster.Health.ValueType  # 2
    """Cluster is inoperable ([Host.health] for every host in the cluster is DEAD)."""
    DEGRADED: Cluster.Health.ValueType  # 3
    """Cluster is working below capacity ([Host.health] for at least one host in the cluster is not ALIVE)."""

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Cluster._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNKNOWN: Cluster._Status.ValueType  # 0
        """Cluster state is unknown."""
        CREATING: Cluster._Status.ValueType  # 1
        """Cluster is being created."""
        RUNNING: Cluster._Status.ValueType  # 2
        """Cluster is running normally."""
        ERROR: Cluster._Status.ValueType  # 3
        """Cluster encountered a problem and cannot operate."""
        UPDATING: Cluster._Status.ValueType  # 4
        """Cluster is being updated."""
        STOPPING: Cluster._Status.ValueType  # 5
        """Cluster is stopping."""
        STOPPED: Cluster._Status.ValueType  # 6
        """Cluster stopped."""
        STARTING: Cluster._Status.ValueType  # 7
        """Cluster is starting."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNKNOWN: Cluster.Status.ValueType  # 0
    """Cluster state is unknown."""
    CREATING: Cluster.Status.ValueType  # 1
    """Cluster is being created."""
    RUNNING: Cluster.Status.ValueType  # 2
    """Cluster is running normally."""
    ERROR: Cluster.Status.ValueType  # 3
    """Cluster encountered a problem and cannot operate."""
    UPDATING: Cluster.Status.ValueType  # 4
    """Cluster is being updated."""
    STOPPING: Cluster.Status.ValueType  # 5
    """Cluster is stopping."""
    STOPPED: Cluster.Status.ValueType  # 6
    """Cluster stopped."""
    STARTING: Cluster.Status.ValueType  # 7
    """Cluster is starting."""

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    ENVIRONMENT_FIELD_NUMBER: builtins.int
    MONITORING_FIELD_NUMBER: builtins.int
    CONFIG_FIELD_NUMBER: builtins.int
    NETWORK_ID_FIELD_NUMBER: builtins.int
    HEALTH_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    SHARDED_FIELD_NUMBER: builtins.int
    MAINTENANCE_WINDOW_FIELD_NUMBER: builtins.int
    PLANNED_OPERATION_FIELD_NUMBER: builtins.int
    SECURITY_GROUP_IDS_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    DISK_ENCRYPTION_KEY_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the MongoDB cluster.
    This ID is assigned by MDB at creation time.
    """
    folder_id: builtins.str
    """ID of the folder that the MongoDB cluster belongs to."""
    name: builtins.str
    """Name of the MongoDB cluster.
    The name is unique within the folder. 1-63 characters long.
    """
    description: builtins.str
    """Description of the MongoDB cluster. 0-256 characters long."""
    environment: global___Cluster.Environment.ValueType
    """Deployment environment of the MongoDB cluster."""
    network_id: builtins.str
    """ID of the network that the cluster belongs to."""
    health: global___Cluster.Health.ValueType
    """Aggregated cluster health."""
    status: global___Cluster.Status.ValueType
    """Current state of the cluster."""
    sharded: builtins.bool
    """Indicates current sharding status of the cluster."""
    deletion_protection: builtins.bool
    """Deletion Protection inhibits deletion of the cluster"""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Custom labels for the MongoDB cluster as `` key:value `` pairs. Maximum 64 per resource."""

    @property
    def monitoring(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Monitoring]:
        """Description of monitoring systems relevant to the MongoDB cluster."""

    @property
    def config(self) -> global___ClusterConfig:
        """Configuration of the MongoDB cluster."""

    @property
    def maintenance_window(self) -> yandex.cloud.mdb.mongodb.v1.maintenance_pb2.MaintenanceWindow:
        """Maintenance window for the cluster."""

    @property
    def planned_operation(self) -> yandex.cloud.mdb.mongodb.v1.maintenance_pb2.MaintenanceOperation:
        """Planned maintenance operation to be started for the cluster within the nearest [maintenance_window]."""

    @property
    def security_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """User security groups"""

    @property
    def disk_encryption_key_id(self) -> google.protobuf.wrappers_pb2.StringValue:
        """ID of the key to encrypt cluster disks."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        folder_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        environment: global___Cluster.Environment.ValueType = ...,
        monitoring: collections.abc.Iterable[global___Monitoring] | None = ...,
        config: global___ClusterConfig | None = ...,
        network_id: builtins.str = ...,
        health: global___Cluster.Health.ValueType = ...,
        status: global___Cluster.Status.ValueType = ...,
        sharded: builtins.bool = ...,
        maintenance_window: yandex.cloud.mdb.mongodb.v1.maintenance_pb2.MaintenanceWindow | None = ...,
        planned_operation: yandex.cloud.mdb.mongodb.v1.maintenance_pb2.MaintenanceOperation | None = ...,
        security_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
        deletion_protection: builtins.bool = ...,
        disk_encryption_key_id: google.protobuf.wrappers_pb2.StringValue | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["config", b"config", "created_at", b"created_at", "disk_encryption_key_id", b"disk_encryption_key_id", "maintenance_window", b"maintenance_window", "planned_operation", b"planned_operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["config", b"config", "created_at", b"created_at", "deletion_protection", b"deletion_protection", "description", b"description", "disk_encryption_key_id", b"disk_encryption_key_id", "environment", b"environment", "folder_id", b"folder_id", "health", b"health", "id", b"id", "labels", b"labels", "maintenance_window", b"maintenance_window", "monitoring", b"monitoring", "name", b"name", "network_id", b"network_id", "planned_operation", b"planned_operation", "security_group_ids", b"security_group_ids", "sharded", b"sharded", "status", b"status"]) -> None: ...

global___Cluster = Cluster

@typing.final
class Monitoring(google.protobuf.message.Message):
    """Monitoring system."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LINK_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the monitoring system."""
    description: builtins.str
    """Description of the monitoring system."""
    link: builtins.str
    """Link to the monitoring system charts for the MongoDB cluster."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        description: builtins.str = ...,
        link: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "link", b"link", "name", b"name"]) -> None: ...

global___Monitoring = Monitoring

@typing.final
class ClusterConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VERSION_FIELD_NUMBER: builtins.int
    FEATURE_COMPATIBILITY_VERSION_FIELD_NUMBER: builtins.int
    MONGODB_3_6_FIELD_NUMBER: builtins.int
    MONGODB_4_0_FIELD_NUMBER: builtins.int
    MONGODB_4_2_FIELD_NUMBER: builtins.int
    MONGODB_4_4_FIELD_NUMBER: builtins.int
    MONGODB_5_0_FIELD_NUMBER: builtins.int
    MONGODB_6_0_FIELD_NUMBER: builtins.int
    MONGODB_4_4_ENTERPRISE_FIELD_NUMBER: builtins.int
    MONGODB_5_0_ENTERPRISE_FIELD_NUMBER: builtins.int
    MONGODB_6_0_ENTERPRISE_FIELD_NUMBER: builtins.int
    BACKUP_WINDOW_START_FIELD_NUMBER: builtins.int
    BACKUP_RETAIN_PERIOD_DAYS_FIELD_NUMBER: builtins.int
    PERFORMANCE_DIAGNOSTICS_FIELD_NUMBER: builtins.int
    ACCESS_FIELD_NUMBER: builtins.int
    MONGODB_CONFIG_FIELD_NUMBER: builtins.int
    version: builtins.str
    """Version of MongoDB server software. Possible values: `3.6`, `4.0`, `4.2`, `4.4`, `4.4-enterprise`, `5.0`, `5.0-enterprise`, `6.0`, `6.0-enterprise`, `7.0`, `7.0-enterprise`."""
    feature_compatibility_version: builtins.str
    """MongoDB feature compatibility version. See usage details in [MongoDB documentation](https://docs.mongodb.com/manual/reference/command/setFeatureCompatibilityVersion/).

    Possible values:
    * `3.6` - persist data compatibility for version 3.6. After setting this option the data will not be compatible with 3.4 or lower.
    * `4.0` - persist data compatibility for version 4.0. After setting this option the data will not be compatible with 3.6 or lower.
    * `4.2` - persist data compatibility for version 4.2. After setting this option the data will not be compatible with 4.0 or lower.
    * `4.4` - persist data compatibility for version 4.4. After setting this option the data will not be compatible with 4.2 or lower.
    * `5.0` - persist data compatibility for version 5.0. After setting this option the data will not be compatible with 5.0 or lower.
    * `6.0` - persist data compatibility for version 6.0. After setting this option the data will not be compatible with 6.0 or lower.
    """
    @property
    def mongodb_3_6(self) -> global___Mongodb3_6:
        """Configuration and resource allocation for a MongoDB 3.6 cluster."""

    @property
    def mongodb_4_0(self) -> global___Mongodb4_0:
        """Configuration and resource allocation for a MongoDB 4.0 cluster."""

    @property
    def mongodb_4_2(self) -> global___Mongodb4_2:
        """Configuration and resource allocation for a MongoDB 4.2 cluster."""

    @property
    def mongodb_4_4(self) -> global___Mongodb4_4:
        """Configuration and resource allocation for a MongoDB 4.4 cluster."""

    @property
    def mongodb_5_0(self) -> global___Mongodb5_0:
        """Configuration and resource allocation for a MongoDB 5.0 cluster."""

    @property
    def mongodb_6_0(self) -> global___Mongodb6_0:
        """Configuration and resource allocation for a MongoDB 6.0 cluster."""

    @property
    def mongodb_4_4_enterprise(self) -> global___Mongodb4_4_enterprise:
        """Configuration and resource allocation for a MongoDB 4.4 Enterprise cluster."""

    @property
    def mongodb_5_0_enterprise(self) -> global___Mongodb5_0_enterprise:
        """Configuration and resource allocation for a MongoDB 5.0 Enterprise cluster."""

    @property
    def mongodb_6_0_enterprise(self) -> global___Mongodb6_0_enterprise:
        """Configuration and resource allocation for a MongoDB 6.0 Enterprise cluster."""

    @property
    def backup_window_start(self) -> google.type.timeofday_pb2.TimeOfDay:
        """Time to start the daily backup, in the UTC timezone."""

    @property
    def backup_retain_period_days(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Retain period of automatically created backup in days"""

    @property
    def performance_diagnostics(self) -> global___PerformanceDiagnosticsConfig:
        """Performance Diagnostic"""

    @property
    def access(self) -> global___Access:
        """Access policy to DB"""

    @property
    def mongodb_config(self) -> global___Mongodb:
        """Configuration and resource allocation for a MongoDB Enterprise cluster."""

    def __init__(
        self,
        *,
        version: builtins.str = ...,
        feature_compatibility_version: builtins.str = ...,
        mongodb_3_6: global___Mongodb3_6 | None = ...,
        mongodb_4_0: global___Mongodb4_0 | None = ...,
        mongodb_4_2: global___Mongodb4_2 | None = ...,
        mongodb_4_4: global___Mongodb4_4 | None = ...,
        mongodb_5_0: global___Mongodb5_0 | None = ...,
        mongodb_6_0: global___Mongodb6_0 | None = ...,
        mongodb_4_4_enterprise: global___Mongodb4_4_enterprise | None = ...,
        mongodb_5_0_enterprise: global___Mongodb5_0_enterprise | None = ...,
        mongodb_6_0_enterprise: global___Mongodb6_0_enterprise | None = ...,
        backup_window_start: google.type.timeofday_pb2.TimeOfDay | None = ...,
        backup_retain_period_days: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        performance_diagnostics: global___PerformanceDiagnosticsConfig | None = ...,
        access: global___Access | None = ...,
        mongodb_config: global___Mongodb | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["access", b"access", "backup_retain_period_days", b"backup_retain_period_days", "backup_window_start", b"backup_window_start", "mongodb", b"mongodb", "mongodb_3_6", b"mongodb_3_6", "mongodb_4_0", b"mongodb_4_0", "mongodb_4_2", b"mongodb_4_2", "mongodb_4_4", b"mongodb_4_4", "mongodb_4_4_enterprise", b"mongodb_4_4_enterprise", "mongodb_5_0", b"mongodb_5_0", "mongodb_5_0_enterprise", b"mongodb_5_0_enterprise", "mongodb_6_0", b"mongodb_6_0", "mongodb_6_0_enterprise", b"mongodb_6_0_enterprise", "mongodb_config", b"mongodb_config", "performance_diagnostics", b"performance_diagnostics"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["access", b"access", "backup_retain_period_days", b"backup_retain_period_days", "backup_window_start", b"backup_window_start", "feature_compatibility_version", b"feature_compatibility_version", "mongodb", b"mongodb", "mongodb_3_6", b"mongodb_3_6", "mongodb_4_0", b"mongodb_4_0", "mongodb_4_2", b"mongodb_4_2", "mongodb_4_4", b"mongodb_4_4", "mongodb_4_4_enterprise", b"mongodb_4_4_enterprise", "mongodb_5_0", b"mongodb_5_0", "mongodb_5_0_enterprise", b"mongodb_5_0_enterprise", "mongodb_6_0", b"mongodb_6_0", "mongodb_6_0_enterprise", b"mongodb_6_0_enterprise", "mongodb_config", b"mongodb_config", "performance_diagnostics", b"performance_diagnostics", "version", b"version"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["mongodb", b"mongodb"]) -> typing.Literal["mongodb_3_6", "mongodb_4_0", "mongodb_4_2", "mongodb_4_4", "mongodb_5_0", "mongodb_6_0", "mongodb_4_4_enterprise", "mongodb_5_0_enterprise", "mongodb_6_0_enterprise"] | None: ...

global___ClusterConfig = ClusterConfig

@typing.final
class Mongodb3_6(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class Mongod(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONFIG_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def config(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb3_6_pb2.MongodConfigSet3_6:
            """Configuration for a mongod 3.6 hosts."""

        @property
        def resources(self) -> global___Resources:
            """Resources allocated to MongoDB hosts."""

        @property
        def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            config: yandex.cloud.mdb.mongodb.v1.config.mongodb3_6_pb2.MongodConfigSet3_6 | None = ...,
            resources: global___Resources | None = ...,
            disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> None: ...

    @typing.final
    class MongoCfg(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONFIG_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def config(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb3_6_pb2.MongoCfgConfigSet3_6: ...
        @property
        def resources(self) -> global___Resources:
            """Resources allocated to mongocfg hosts."""

        @property
        def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            config: yandex.cloud.mdb.mongodb.v1.config.mongodb3_6_pb2.MongoCfgConfigSet3_6 | None = ...,
            resources: global___Resources | None = ...,
            disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> None: ...

    @typing.final
    class Mongos(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONFIG_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def config(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb3_6_pb2.MongosConfigSet3_6: ...
        @property
        def resources(self) -> global___Resources:
            """Resources allocated to mongos hosts."""

        @property
        def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            config: yandex.cloud.mdb.mongodb.v1.config.mongodb3_6_pb2.MongosConfigSet3_6 | None = ...,
            resources: global___Resources | None = ...,
            disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> None: ...

    @typing.final
    class MongoInfra(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONFIG_MONGOS_FIELD_NUMBER: builtins.int
        CONFIG_MONGOCFG_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def config_mongos(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb3_6_pb2.MongosConfigSet3_6: ...
        @property
        def config_mongocfg(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb3_6_pb2.MongoCfgConfigSet3_6: ...
        @property
        def resources(self) -> global___Resources:
            """Resources allocated to mongoinfra (mongos+mongocfg) hosts."""

        @property
        def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            config_mongos: yandex.cloud.mdb.mongodb.v1.config.mongodb3_6_pb2.MongosConfigSet3_6 | None = ...,
            config_mongocfg: yandex.cloud.mdb.mongodb.v1.config.mongodb3_6_pb2.MongoCfgConfigSet3_6 | None = ...,
            resources: global___Resources | None = ...,
            disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config_mongocfg", b"config_mongocfg", "config_mongos", b"config_mongos", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config_mongocfg", b"config_mongocfg", "config_mongos", b"config_mongos", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> None: ...

    MONGOD_FIELD_NUMBER: builtins.int
    MONGOCFG_FIELD_NUMBER: builtins.int
    MONGOS_FIELD_NUMBER: builtins.int
    MONGOINFRA_FIELD_NUMBER: builtins.int
    @property
    def mongod(self) -> global___Mongodb3_6.Mongod:
        """Configuration and resource allocation for mongod in a MongoDB 3.6 cluster."""

    @property
    def mongocfg(self) -> global___Mongodb3_6.MongoCfg:
        """Configuration and resource allocation for mongocfg in a MongoDB 3.6 cluster."""

    @property
    def mongos(self) -> global___Mongodb3_6.Mongos:
        """Configuration and resource allocation for mongos in a MongoDB 3.6 cluster."""

    @property
    def mongoinfra(self) -> global___Mongodb3_6.MongoInfra:
        """Configuration and resource allocation for mongoinfra (mongos+mongocfg) in a MongoDB 3.6 cluster."""

    def __init__(
        self,
        *,
        mongod: global___Mongodb3_6.Mongod | None = ...,
        mongocfg: global___Mongodb3_6.MongoCfg | None = ...,
        mongos: global___Mongodb3_6.Mongos | None = ...,
        mongoinfra: global___Mongodb3_6.MongoInfra | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["mongocfg", b"mongocfg", "mongod", b"mongod", "mongoinfra", b"mongoinfra", "mongos", b"mongos"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["mongocfg", b"mongocfg", "mongod", b"mongod", "mongoinfra", b"mongoinfra", "mongos", b"mongos"]) -> None: ...

global___Mongodb3_6 = Mongodb3_6

@typing.final
class Mongodb4_0(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class Mongod(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONFIG_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def config(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb4_0_pb2.MongodConfigSet4_0:
            """Configuration for mongod 4.0 hosts."""

        @property
        def resources(self) -> global___Resources:
            """Resources allocated to mongod hosts."""

        @property
        def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            config: yandex.cloud.mdb.mongodb.v1.config.mongodb4_0_pb2.MongodConfigSet4_0 | None = ...,
            resources: global___Resources | None = ...,
            disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> None: ...

    @typing.final
    class MongoCfg(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONFIG_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def config(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb4_0_pb2.MongoCfgConfigSet4_0:
            """Configuration for mongocfg 4.0 hosts."""

        @property
        def resources(self) -> global___Resources:
            """Resources allocated to mongocfg hosts."""

        @property
        def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            config: yandex.cloud.mdb.mongodb.v1.config.mongodb4_0_pb2.MongoCfgConfigSet4_0 | None = ...,
            resources: global___Resources | None = ...,
            disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> None: ...

    @typing.final
    class Mongos(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONFIG_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def config(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb4_0_pb2.MongosConfigSet4_0:
            """Configuration for mongos 4.0 hosts."""

        @property
        def resources(self) -> global___Resources:
            """Resources allocated to mongos hosts."""

        @property
        def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            config: yandex.cloud.mdb.mongodb.v1.config.mongodb4_0_pb2.MongosConfigSet4_0 | None = ...,
            resources: global___Resources | None = ...,
            disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> None: ...

    @typing.final
    class MongoInfra(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONFIG_MONGOS_FIELD_NUMBER: builtins.int
        CONFIG_MONGOCFG_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def config_mongos(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb4_0_pb2.MongosConfigSet4_0: ...
        @property
        def config_mongocfg(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb4_0_pb2.MongoCfgConfigSet4_0: ...
        @property
        def resources(self) -> global___Resources:
            """Resources allocated to mongoinfra (mongos+mongocfg) hosts."""

        @property
        def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            config_mongos: yandex.cloud.mdb.mongodb.v1.config.mongodb4_0_pb2.MongosConfigSet4_0 | None = ...,
            config_mongocfg: yandex.cloud.mdb.mongodb.v1.config.mongodb4_0_pb2.MongoCfgConfigSet4_0 | None = ...,
            resources: global___Resources | None = ...,
            disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config_mongocfg", b"config_mongocfg", "config_mongos", b"config_mongos", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config_mongocfg", b"config_mongocfg", "config_mongos", b"config_mongos", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> None: ...

    MONGOD_FIELD_NUMBER: builtins.int
    MONGOCFG_FIELD_NUMBER: builtins.int
    MONGOS_FIELD_NUMBER: builtins.int
    MONGOINFRA_FIELD_NUMBER: builtins.int
    @property
    def mongod(self) -> global___Mongodb4_0.Mongod:
        """Configuration and resource allocation for mongod in a MongoDB 4.0 cluster."""

    @property
    def mongocfg(self) -> global___Mongodb4_0.MongoCfg:
        """Configuration and resource allocation for mongocfg in a MongoDB 4.0 cluster."""

    @property
    def mongos(self) -> global___Mongodb4_0.Mongos:
        """Configuration and resource allocation for mongos in a MongoDB 4.0 cluster."""

    @property
    def mongoinfra(self) -> global___Mongodb4_0.MongoInfra:
        """Configuration and resource allocation for mongoinfra (mongos+mongocfg) in a MongoDB 4.0 cluster."""

    def __init__(
        self,
        *,
        mongod: global___Mongodb4_0.Mongod | None = ...,
        mongocfg: global___Mongodb4_0.MongoCfg | None = ...,
        mongos: global___Mongodb4_0.Mongos | None = ...,
        mongoinfra: global___Mongodb4_0.MongoInfra | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["mongocfg", b"mongocfg", "mongod", b"mongod", "mongoinfra", b"mongoinfra", "mongos", b"mongos"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["mongocfg", b"mongocfg", "mongod", b"mongod", "mongoinfra", b"mongoinfra", "mongos", b"mongos"]) -> None: ...

global___Mongodb4_0 = Mongodb4_0

@typing.final
class Mongodb4_2(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class Mongod(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONFIG_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def config(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb4_2_pb2.MongodConfigSet4_2:
            """Configuration for mongod 4.2 hosts."""

        @property
        def resources(self) -> global___Resources:
            """Resources allocated to mongod hosts."""

        @property
        def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            config: yandex.cloud.mdb.mongodb.v1.config.mongodb4_2_pb2.MongodConfigSet4_2 | None = ...,
            resources: global___Resources | None = ...,
            disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> None: ...

    @typing.final
    class MongoCfg(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONFIG_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def config(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb4_2_pb2.MongoCfgConfigSet4_2:
            """Configuration for mongocfg 4.2 hosts."""

        @property
        def resources(self) -> global___Resources:
            """Resources allocated to mongocfg hosts."""

        @property
        def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            config: yandex.cloud.mdb.mongodb.v1.config.mongodb4_2_pb2.MongoCfgConfigSet4_2 | None = ...,
            resources: global___Resources | None = ...,
            disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> None: ...

    @typing.final
    class Mongos(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONFIG_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def config(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb4_2_pb2.MongosConfigSet4_2:
            """Configuration for mongos 4.2 hosts."""

        @property
        def resources(self) -> global___Resources:
            """Resources allocated to mongos hosts."""

        @property
        def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            config: yandex.cloud.mdb.mongodb.v1.config.mongodb4_2_pb2.MongosConfigSet4_2 | None = ...,
            resources: global___Resources | None = ...,
            disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> None: ...

    @typing.final
    class MongoInfra(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONFIG_MONGOS_FIELD_NUMBER: builtins.int
        CONFIG_MONGOCFG_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def config_mongos(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb4_2_pb2.MongosConfigSet4_2: ...
        @property
        def config_mongocfg(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb4_2_pb2.MongoCfgConfigSet4_2: ...
        @property
        def resources(self) -> global___Resources:
            """Resources allocated to mongoinfra (mongos+mongocfg) hosts."""

        @property
        def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            config_mongos: yandex.cloud.mdb.mongodb.v1.config.mongodb4_2_pb2.MongosConfigSet4_2 | None = ...,
            config_mongocfg: yandex.cloud.mdb.mongodb.v1.config.mongodb4_2_pb2.MongoCfgConfigSet4_2 | None = ...,
            resources: global___Resources | None = ...,
            disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config_mongocfg", b"config_mongocfg", "config_mongos", b"config_mongos", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config_mongocfg", b"config_mongocfg", "config_mongos", b"config_mongos", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> None: ...

    MONGOD_FIELD_NUMBER: builtins.int
    MONGOCFG_FIELD_NUMBER: builtins.int
    MONGOS_FIELD_NUMBER: builtins.int
    MONGOINFRA_FIELD_NUMBER: builtins.int
    @property
    def mongod(self) -> global___Mongodb4_2.Mongod:
        """Configuration and resource allocation for mongod in a MongoDB 4.2 cluster."""

    @property
    def mongocfg(self) -> global___Mongodb4_2.MongoCfg:
        """Configuration and resource allocation for mongocfg in a MongoDB 4.2 cluster."""

    @property
    def mongos(self) -> global___Mongodb4_2.Mongos:
        """Configuration and resource allocation for mongos in a MongoDB 4.2 cluster."""

    @property
    def mongoinfra(self) -> global___Mongodb4_2.MongoInfra:
        """Configuration and resource allocation for mongoinfra (mongos+mongocfg) in a MongoDB 4.2 cluster."""

    def __init__(
        self,
        *,
        mongod: global___Mongodb4_2.Mongod | None = ...,
        mongocfg: global___Mongodb4_2.MongoCfg | None = ...,
        mongos: global___Mongodb4_2.Mongos | None = ...,
        mongoinfra: global___Mongodb4_2.MongoInfra | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["mongocfg", b"mongocfg", "mongod", b"mongod", "mongoinfra", b"mongoinfra", "mongos", b"mongos"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["mongocfg", b"mongocfg", "mongod", b"mongod", "mongoinfra", b"mongoinfra", "mongos", b"mongos"]) -> None: ...

global___Mongodb4_2 = Mongodb4_2

@typing.final
class Mongodb4_4(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class Mongod(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONFIG_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def config(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb4_4_pb2.MongodConfigSet4_4:
            """Configuration for mongod 4.4 hosts."""

        @property
        def resources(self) -> global___Resources:
            """Resources allocated to mongod hosts."""

        @property
        def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            config: yandex.cloud.mdb.mongodb.v1.config.mongodb4_4_pb2.MongodConfigSet4_4 | None = ...,
            resources: global___Resources | None = ...,
            disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> None: ...

    @typing.final
    class MongoCfg(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONFIG_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def config(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb4_4_pb2.MongoCfgConfigSet4_4:
            """Configuration for mongocfg 4.4 hosts."""

        @property
        def resources(self) -> global___Resources:
            """Resources allocated to mongocfg hosts."""

        @property
        def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            config: yandex.cloud.mdb.mongodb.v1.config.mongodb4_4_pb2.MongoCfgConfigSet4_4 | None = ...,
            resources: global___Resources | None = ...,
            disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> None: ...

    @typing.final
    class Mongos(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONFIG_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def config(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb4_4_pb2.MongosConfigSet4_4:
            """Configuration for mongos 4.4 hosts."""

        @property
        def resources(self) -> global___Resources:
            """Resources allocated to mongos hosts."""

        @property
        def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            config: yandex.cloud.mdb.mongodb.v1.config.mongodb4_4_pb2.MongosConfigSet4_4 | None = ...,
            resources: global___Resources | None = ...,
            disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> None: ...

    @typing.final
    class MongoInfra(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONFIG_MONGOS_FIELD_NUMBER: builtins.int
        CONFIG_MONGOCFG_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def config_mongos(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb4_4_pb2.MongosConfigSet4_4: ...
        @property
        def config_mongocfg(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb4_4_pb2.MongoCfgConfigSet4_4: ...
        @property
        def resources(self) -> global___Resources:
            """Resources allocated to mongoinfra (mongos+mongocfg) hosts."""

        @property
        def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            config_mongos: yandex.cloud.mdb.mongodb.v1.config.mongodb4_4_pb2.MongosConfigSet4_4 | None = ...,
            config_mongocfg: yandex.cloud.mdb.mongodb.v1.config.mongodb4_4_pb2.MongoCfgConfigSet4_4 | None = ...,
            resources: global___Resources | None = ...,
            disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config_mongocfg", b"config_mongocfg", "config_mongos", b"config_mongos", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config_mongocfg", b"config_mongocfg", "config_mongos", b"config_mongos", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> None: ...

    MONGOD_FIELD_NUMBER: builtins.int
    MONGOCFG_FIELD_NUMBER: builtins.int
    MONGOS_FIELD_NUMBER: builtins.int
    MONGOINFRA_FIELD_NUMBER: builtins.int
    @property
    def mongod(self) -> global___Mongodb4_4.Mongod:
        """Configuration and resource allocation for mongod in a MongoDB 4.4 cluster."""

    @property
    def mongocfg(self) -> global___Mongodb4_4.MongoCfg:
        """Configuration and resource allocation for mongocfg in a MongoDB 4.4 cluster."""

    @property
    def mongos(self) -> global___Mongodb4_4.Mongos:
        """Configuration and resource allocation for mongos in a MongoDB 4.4 cluster."""

    @property
    def mongoinfra(self) -> global___Mongodb4_4.MongoInfra:
        """Configuration and resource allocation for mongoinfra (mongos+mongocfg) in a MongoDB 4.4 cluster."""

    def __init__(
        self,
        *,
        mongod: global___Mongodb4_4.Mongod | None = ...,
        mongocfg: global___Mongodb4_4.MongoCfg | None = ...,
        mongos: global___Mongodb4_4.Mongos | None = ...,
        mongoinfra: global___Mongodb4_4.MongoInfra | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["mongocfg", b"mongocfg", "mongod", b"mongod", "mongoinfra", b"mongoinfra", "mongos", b"mongos"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["mongocfg", b"mongocfg", "mongod", b"mongod", "mongoinfra", b"mongoinfra", "mongos", b"mongos"]) -> None: ...

global___Mongodb4_4 = Mongodb4_4

@typing.final
class Mongodb4_4_enterprise(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class Mongod(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONFIG_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def config(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb4_4_enterprise_pb2.MongodConfigSet4_4_enterprise:
            """Configuration for mongod 4.4 hosts."""

        @property
        def resources(self) -> global___Resources:
            """Resources allocated to mongod hosts."""

        @property
        def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            config: yandex.cloud.mdb.mongodb.v1.config.mongodb4_4_enterprise_pb2.MongodConfigSet4_4_enterprise | None = ...,
            resources: global___Resources | None = ...,
            disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> None: ...

    @typing.final
    class MongoCfg(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONFIG_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def config(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb4_4_enterprise_pb2.MongoCfgConfigSet4_4_enterprise:
            """Configuration for mongocfg 4.4 hosts."""

        @property
        def resources(self) -> global___Resources:
            """Resources allocated to mongocfg hosts."""

        @property
        def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            config: yandex.cloud.mdb.mongodb.v1.config.mongodb4_4_enterprise_pb2.MongoCfgConfigSet4_4_enterprise | None = ...,
            resources: global___Resources | None = ...,
            disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> None: ...

    @typing.final
    class Mongos(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONFIG_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def config(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb4_4_enterprise_pb2.MongosConfigSet4_4_enterprise:
            """Configuration for mongos 4.4 hosts."""

        @property
        def resources(self) -> global___Resources:
            """Resources allocated to mongos hosts."""

        @property
        def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            config: yandex.cloud.mdb.mongodb.v1.config.mongodb4_4_enterprise_pb2.MongosConfigSet4_4_enterprise | None = ...,
            resources: global___Resources | None = ...,
            disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> None: ...

    @typing.final
    class MongoInfra(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONFIG_MONGOS_FIELD_NUMBER: builtins.int
        CONFIG_MONGOCFG_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def config_mongos(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb4_4_enterprise_pb2.MongosConfigSet4_4_enterprise: ...
        @property
        def config_mongocfg(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb4_4_enterprise_pb2.MongoCfgConfigSet4_4_enterprise: ...
        @property
        def resources(self) -> global___Resources:
            """Resources allocated to mongoinfra (mongos+mongocfg) hosts."""

        @property
        def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            config_mongos: yandex.cloud.mdb.mongodb.v1.config.mongodb4_4_enterprise_pb2.MongosConfigSet4_4_enterprise | None = ...,
            config_mongocfg: yandex.cloud.mdb.mongodb.v1.config.mongodb4_4_enterprise_pb2.MongoCfgConfigSet4_4_enterprise | None = ...,
            resources: global___Resources | None = ...,
            disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config_mongocfg", b"config_mongocfg", "config_mongos", b"config_mongos", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config_mongocfg", b"config_mongocfg", "config_mongos", b"config_mongos", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> None: ...

    MONGOD_FIELD_NUMBER: builtins.int
    MONGOCFG_FIELD_NUMBER: builtins.int
    MONGOS_FIELD_NUMBER: builtins.int
    MONGOINFRA_FIELD_NUMBER: builtins.int
    @property
    def mongod(self) -> global___Mongodb4_4_enterprise.Mongod:
        """Configuration and resource allocation for mongod in a MongoDB 4.4 cluster."""

    @property
    def mongocfg(self) -> global___Mongodb4_4_enterprise.MongoCfg:
        """Configuration and resource allocation for mongocfg in a MongoDB 4.4 cluster."""

    @property
    def mongos(self) -> global___Mongodb4_4_enterprise.Mongos:
        """Configuration and resource allocation for mongos in a MongoDB 4.4 cluster."""

    @property
    def mongoinfra(self) -> global___Mongodb4_4_enterprise.MongoInfra:
        """Configuration and resource allocation for mongoinfra (mongos+mongocfg) in a MongoDB 4.4 cluster."""

    def __init__(
        self,
        *,
        mongod: global___Mongodb4_4_enterprise.Mongod | None = ...,
        mongocfg: global___Mongodb4_4_enterprise.MongoCfg | None = ...,
        mongos: global___Mongodb4_4_enterprise.Mongos | None = ...,
        mongoinfra: global___Mongodb4_4_enterprise.MongoInfra | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["mongocfg", b"mongocfg", "mongod", b"mongod", "mongoinfra", b"mongoinfra", "mongos", b"mongos"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["mongocfg", b"mongocfg", "mongod", b"mongod", "mongoinfra", b"mongoinfra", "mongos", b"mongos"]) -> None: ...

global___Mongodb4_4_enterprise = Mongodb4_4_enterprise

@typing.final
class Mongodb5_0(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class Mongod(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONFIG_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def config(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb5_0_pb2.MongodConfigSet5_0:
            """Configuration for mongod 5.0 hosts."""

        @property
        def resources(self) -> global___Resources:
            """Resources allocated to mongod hosts."""

        @property
        def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            config: yandex.cloud.mdb.mongodb.v1.config.mongodb5_0_pb2.MongodConfigSet5_0 | None = ...,
            resources: global___Resources | None = ...,
            disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> None: ...

    @typing.final
    class MongoCfg(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONFIG_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def config(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb5_0_pb2.MongoCfgConfigSet5_0:
            """Configuration for mongocfg 5.0 hosts."""

        @property
        def resources(self) -> global___Resources:
            """Resources allocated to mongocfg hosts."""

        @property
        def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            config: yandex.cloud.mdb.mongodb.v1.config.mongodb5_0_pb2.MongoCfgConfigSet5_0 | None = ...,
            resources: global___Resources | None = ...,
            disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> None: ...

    @typing.final
    class Mongos(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONFIG_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def config(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb5_0_pb2.MongosConfigSet5_0:
            """Configuration for mongos 5.0 hosts."""

        @property
        def resources(self) -> global___Resources:
            """Resources allocated to mongos hosts."""

        @property
        def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            config: yandex.cloud.mdb.mongodb.v1.config.mongodb5_0_pb2.MongosConfigSet5_0 | None = ...,
            resources: global___Resources | None = ...,
            disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> None: ...

    @typing.final
    class MongoInfra(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONFIG_MONGOS_FIELD_NUMBER: builtins.int
        CONFIG_MONGOCFG_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def config_mongos(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb5_0_pb2.MongosConfigSet5_0: ...
        @property
        def config_mongocfg(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb5_0_pb2.MongoCfgConfigSet5_0: ...
        @property
        def resources(self) -> global___Resources:
            """Resources allocated to mongoinfra (mongos+mongocfg) hosts."""

        @property
        def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            config_mongos: yandex.cloud.mdb.mongodb.v1.config.mongodb5_0_pb2.MongosConfigSet5_0 | None = ...,
            config_mongocfg: yandex.cloud.mdb.mongodb.v1.config.mongodb5_0_pb2.MongoCfgConfigSet5_0 | None = ...,
            resources: global___Resources | None = ...,
            disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config_mongocfg", b"config_mongocfg", "config_mongos", b"config_mongos", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config_mongocfg", b"config_mongocfg", "config_mongos", b"config_mongos", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> None: ...

    MONGOD_FIELD_NUMBER: builtins.int
    MONGOCFG_FIELD_NUMBER: builtins.int
    MONGOS_FIELD_NUMBER: builtins.int
    MONGOINFRA_FIELD_NUMBER: builtins.int
    @property
    def mongod(self) -> global___Mongodb5_0.Mongod:
        """Configuration and resource allocation for mongod in a MongoDB 5.0 cluster."""

    @property
    def mongocfg(self) -> global___Mongodb5_0.MongoCfg:
        """Configuration and resource allocation for mongocfg in a MongoDB 5.0 cluster."""

    @property
    def mongos(self) -> global___Mongodb5_0.Mongos:
        """Configuration and resource allocation for mongos in a MongoDB 5.0 cluster."""

    @property
    def mongoinfra(self) -> global___Mongodb5_0.MongoInfra:
        """Configuration and resource allocation for mongoinfra (mongos+mongocfg) in a MongoDB 5.0 cluster."""

    def __init__(
        self,
        *,
        mongod: global___Mongodb5_0.Mongod | None = ...,
        mongocfg: global___Mongodb5_0.MongoCfg | None = ...,
        mongos: global___Mongodb5_0.Mongos | None = ...,
        mongoinfra: global___Mongodb5_0.MongoInfra | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["mongocfg", b"mongocfg", "mongod", b"mongod", "mongoinfra", b"mongoinfra", "mongos", b"mongos"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["mongocfg", b"mongocfg", "mongod", b"mongod", "mongoinfra", b"mongoinfra", "mongos", b"mongos"]) -> None: ...

global___Mongodb5_0 = Mongodb5_0

@typing.final
class Mongodb5_0_enterprise(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class Mongod(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONFIG_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def config(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb5_0_enterprise_pb2.MongodConfigSet5_0_enterprise:
            """Configuration for mongod 5.0 hosts."""

        @property
        def resources(self) -> global___Resources:
            """Resources allocated to mongod hosts."""

        @property
        def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            config: yandex.cloud.mdb.mongodb.v1.config.mongodb5_0_enterprise_pb2.MongodConfigSet5_0_enterprise | None = ...,
            resources: global___Resources | None = ...,
            disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> None: ...

    @typing.final
    class MongoCfg(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONFIG_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def config(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb5_0_enterprise_pb2.MongoCfgConfigSet5_0_enterprise:
            """Configuration for mongocfg 5.0 hosts."""

        @property
        def resources(self) -> global___Resources:
            """Resources allocated to mongocfg hosts."""

        @property
        def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            config: yandex.cloud.mdb.mongodb.v1.config.mongodb5_0_enterprise_pb2.MongoCfgConfigSet5_0_enterprise | None = ...,
            resources: global___Resources | None = ...,
            disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> None: ...

    @typing.final
    class Mongos(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONFIG_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def config(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb5_0_enterprise_pb2.MongosConfigSet5_0_enterprise:
            """Configuration for mongos 5.0 hosts."""

        @property
        def resources(self) -> global___Resources:
            """Resources allocated to mongos hosts."""

        @property
        def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            config: yandex.cloud.mdb.mongodb.v1.config.mongodb5_0_enterprise_pb2.MongosConfigSet5_0_enterprise | None = ...,
            resources: global___Resources | None = ...,
            disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> None: ...

    @typing.final
    class MongoInfra(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONFIG_MONGOS_FIELD_NUMBER: builtins.int
        CONFIG_MONGOCFG_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def config_mongos(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb5_0_enterprise_pb2.MongosConfigSet5_0_enterprise: ...
        @property
        def config_mongocfg(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb5_0_enterprise_pb2.MongoCfgConfigSet5_0_enterprise: ...
        @property
        def resources(self) -> global___Resources:
            """Resources allocated to mongoinfra (mongos+mongocfg) hosts."""

        @property
        def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            config_mongos: yandex.cloud.mdb.mongodb.v1.config.mongodb5_0_enterprise_pb2.MongosConfigSet5_0_enterprise | None = ...,
            config_mongocfg: yandex.cloud.mdb.mongodb.v1.config.mongodb5_0_enterprise_pb2.MongoCfgConfigSet5_0_enterprise | None = ...,
            resources: global___Resources | None = ...,
            disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config_mongocfg", b"config_mongocfg", "config_mongos", b"config_mongos", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config_mongocfg", b"config_mongocfg", "config_mongos", b"config_mongos", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> None: ...

    MONGOD_FIELD_NUMBER: builtins.int
    MONGOCFG_FIELD_NUMBER: builtins.int
    MONGOS_FIELD_NUMBER: builtins.int
    MONGOINFRA_FIELD_NUMBER: builtins.int
    @property
    def mongod(self) -> global___Mongodb5_0_enterprise.Mongod:
        """Configuration and resource allocation for mongod in a MongoDB 5.0 cluster."""

    @property
    def mongocfg(self) -> global___Mongodb5_0_enterprise.MongoCfg:
        """Configuration and resource allocation for mongocfg in a MongoDB 5.0 cluster."""

    @property
    def mongos(self) -> global___Mongodb5_0_enterprise.Mongos:
        """Configuration and resource allocation for mongos in a MongoDB 5.0 cluster."""

    @property
    def mongoinfra(self) -> global___Mongodb5_0_enterprise.MongoInfra:
        """Configuration and resource allocation for mongoinfra (mongos+mongocfg) in a MongoDB 5.0 cluster."""

    def __init__(
        self,
        *,
        mongod: global___Mongodb5_0_enterprise.Mongod | None = ...,
        mongocfg: global___Mongodb5_0_enterprise.MongoCfg | None = ...,
        mongos: global___Mongodb5_0_enterprise.Mongos | None = ...,
        mongoinfra: global___Mongodb5_0_enterprise.MongoInfra | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["mongocfg", b"mongocfg", "mongod", b"mongod", "mongoinfra", b"mongoinfra", "mongos", b"mongos"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["mongocfg", b"mongocfg", "mongod", b"mongod", "mongoinfra", b"mongoinfra", "mongos", b"mongos"]) -> None: ...

global___Mongodb5_0_enterprise = Mongodb5_0_enterprise

@typing.final
class Mongodb6_0(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class Mongod(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONFIG_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def config(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb6_0_pb2.MongodConfigSet6_0:
            """Configuration for mongod 6.0 hosts."""

        @property
        def resources(self) -> global___Resources:
            """Resources allocated to mongod hosts."""

        @property
        def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            config: yandex.cloud.mdb.mongodb.v1.config.mongodb6_0_pb2.MongodConfigSet6_0 | None = ...,
            resources: global___Resources | None = ...,
            disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> None: ...

    @typing.final
    class MongoCfg(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONFIG_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def config(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb6_0_pb2.MongoCfgConfigSet6_0:
            """Configuration for mongocfg 6.0 hosts."""

        @property
        def resources(self) -> global___Resources:
            """Resources allocated to mongocfg hosts."""

        @property
        def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            config: yandex.cloud.mdb.mongodb.v1.config.mongodb6_0_pb2.MongoCfgConfigSet6_0 | None = ...,
            resources: global___Resources | None = ...,
            disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> None: ...

    @typing.final
    class Mongos(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONFIG_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def config(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb6_0_pb2.MongosConfigSet6_0:
            """Configuration for mongos 6.0 hosts."""

        @property
        def resources(self) -> global___Resources:
            """Resources allocated to mongos hosts."""

        @property
        def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            config: yandex.cloud.mdb.mongodb.v1.config.mongodb6_0_pb2.MongosConfigSet6_0 | None = ...,
            resources: global___Resources | None = ...,
            disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> None: ...

    @typing.final
    class MongoInfra(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONFIG_MONGOS_FIELD_NUMBER: builtins.int
        CONFIG_MONGOCFG_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def config_mongos(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb6_0_pb2.MongosConfigSet6_0: ...
        @property
        def config_mongocfg(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb6_0_pb2.MongoCfgConfigSet6_0: ...
        @property
        def resources(self) -> global___Resources:
            """Resources allocated to mongoinfra (mongos+mongocfg) hosts."""

        @property
        def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            config_mongos: yandex.cloud.mdb.mongodb.v1.config.mongodb6_0_pb2.MongosConfigSet6_0 | None = ...,
            config_mongocfg: yandex.cloud.mdb.mongodb.v1.config.mongodb6_0_pb2.MongoCfgConfigSet6_0 | None = ...,
            resources: global___Resources | None = ...,
            disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config_mongocfg", b"config_mongocfg", "config_mongos", b"config_mongos", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config_mongocfg", b"config_mongocfg", "config_mongos", b"config_mongos", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> None: ...

    MONGOD_FIELD_NUMBER: builtins.int
    MONGOCFG_FIELD_NUMBER: builtins.int
    MONGOS_FIELD_NUMBER: builtins.int
    MONGOINFRA_FIELD_NUMBER: builtins.int
    @property
    def mongod(self) -> global___Mongodb6_0.Mongod:
        """Configuration and resource allocation for mongod in a MongoDB 6.0 cluster."""

    @property
    def mongocfg(self) -> global___Mongodb6_0.MongoCfg:
        """Configuration and resource allocation for mongocfg in a MongoDB 6.0 cluster."""

    @property
    def mongos(self) -> global___Mongodb6_0.Mongos:
        """Configuration and resource allocation for mongos in a MongoDB 6.0 cluster."""

    @property
    def mongoinfra(self) -> global___Mongodb6_0.MongoInfra:
        """Configuration and resource allocation for mongoinfra (mongos+mongocfg) in a MongoDB 6.0 cluster."""

    def __init__(
        self,
        *,
        mongod: global___Mongodb6_0.Mongod | None = ...,
        mongocfg: global___Mongodb6_0.MongoCfg | None = ...,
        mongos: global___Mongodb6_0.Mongos | None = ...,
        mongoinfra: global___Mongodb6_0.MongoInfra | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["mongocfg", b"mongocfg", "mongod", b"mongod", "mongoinfra", b"mongoinfra", "mongos", b"mongos"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["mongocfg", b"mongocfg", "mongod", b"mongod", "mongoinfra", b"mongoinfra", "mongos", b"mongos"]) -> None: ...

global___Mongodb6_0 = Mongodb6_0

@typing.final
class Mongodb6_0_enterprise(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class Mongod(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONFIG_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def config(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb6_0_enterprise_pb2.MongodConfigSet6_0_enterprise:
            """Configuration for mongod 6.0 hosts."""

        @property
        def resources(self) -> global___Resources:
            """Resources allocated to mongod hosts."""

        @property
        def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            config: yandex.cloud.mdb.mongodb.v1.config.mongodb6_0_enterprise_pb2.MongodConfigSet6_0_enterprise | None = ...,
            resources: global___Resources | None = ...,
            disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> None: ...

    @typing.final
    class MongoCfg(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONFIG_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def config(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb6_0_enterprise_pb2.MongoCfgConfigSet6_0_enterprise:
            """Configuration for mongocfg 6.0 hosts."""

        @property
        def resources(self) -> global___Resources:
            """Resources allocated to mongocfg hosts."""

        @property
        def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            config: yandex.cloud.mdb.mongodb.v1.config.mongodb6_0_enterprise_pb2.MongoCfgConfigSet6_0_enterprise | None = ...,
            resources: global___Resources | None = ...,
            disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> None: ...

    @typing.final
    class Mongos(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONFIG_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def config(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb6_0_enterprise_pb2.MongosConfigSet6_0_enterprise:
            """Configuration for mongos 6.0 hosts."""

        @property
        def resources(self) -> global___Resources:
            """Resources allocated to mongos hosts."""

        @property
        def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            config: yandex.cloud.mdb.mongodb.v1.config.mongodb6_0_enterprise_pb2.MongosConfigSet6_0_enterprise | None = ...,
            resources: global___Resources | None = ...,
            disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> None: ...

    @typing.final
    class MongoInfra(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONFIG_MONGOS_FIELD_NUMBER: builtins.int
        CONFIG_MONGOCFG_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def config_mongos(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb6_0_enterprise_pb2.MongosConfigSet6_0_enterprise: ...
        @property
        def config_mongocfg(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb6_0_enterprise_pb2.MongoCfgConfigSet6_0_enterprise: ...
        @property
        def resources(self) -> global___Resources:
            """Resources allocated to mongoinfra (mongos+mongocfg) hosts."""

        @property
        def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            config_mongos: yandex.cloud.mdb.mongodb.v1.config.mongodb6_0_enterprise_pb2.MongosConfigSet6_0_enterprise | None = ...,
            config_mongocfg: yandex.cloud.mdb.mongodb.v1.config.mongodb6_0_enterprise_pb2.MongoCfgConfigSet6_0_enterprise | None = ...,
            resources: global___Resources | None = ...,
            disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config_mongocfg", b"config_mongocfg", "config_mongos", b"config_mongos", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config_mongocfg", b"config_mongocfg", "config_mongos", b"config_mongos", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> None: ...

    MONGOD_FIELD_NUMBER: builtins.int
    MONGOCFG_FIELD_NUMBER: builtins.int
    MONGOS_FIELD_NUMBER: builtins.int
    MONGOINFRA_FIELD_NUMBER: builtins.int
    @property
    def mongod(self) -> global___Mongodb6_0_enterprise.Mongod:
        """Configuration and resource allocation for mongod in a MongoDB 6.0 cluster."""

    @property
    def mongocfg(self) -> global___Mongodb6_0_enterprise.MongoCfg:
        """Configuration and resource allocation for mongocfg in a MongoDB 6.0 cluster."""

    @property
    def mongos(self) -> global___Mongodb6_0_enterprise.Mongos:
        """Configuration and resource allocation for mongos in a MongoDB 6.0 cluster."""

    @property
    def mongoinfra(self) -> global___Mongodb6_0_enterprise.MongoInfra:
        """Configuration and resource allocation for mongoinfra (mongos+mongocfg) in a MongoDB 6.0 cluster."""

    def __init__(
        self,
        *,
        mongod: global___Mongodb6_0_enterprise.Mongod | None = ...,
        mongocfg: global___Mongodb6_0_enterprise.MongoCfg | None = ...,
        mongos: global___Mongodb6_0_enterprise.Mongos | None = ...,
        mongoinfra: global___Mongodb6_0_enterprise.MongoInfra | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["mongocfg", b"mongocfg", "mongod", b"mongod", "mongoinfra", b"mongoinfra", "mongos", b"mongos"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["mongocfg", b"mongocfg", "mongod", b"mongod", "mongoinfra", b"mongoinfra", "mongos", b"mongos"]) -> None: ...

global___Mongodb6_0_enterprise = Mongodb6_0_enterprise

@typing.final
class Mongodb(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class Mongod(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONFIG_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def config(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb_pb2.MongodConfigSet:
            """Configuration for mongod hosts."""

        @property
        def resources(self) -> global___Resources:
            """Resources allocated to mongod hosts."""

        @property
        def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            config: yandex.cloud.mdb.mongodb.v1.config.mongodb_pb2.MongodConfigSet | None = ...,
            resources: global___Resources | None = ...,
            disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> None: ...

    @typing.final
    class MongoCfg(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONFIG_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def config(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb_pb2.MongoCfgConfigSet:
            """Configuration for mongocfg hosts."""

        @property
        def resources(self) -> global___Resources:
            """Resources allocated to mongocfg hosts."""

        @property
        def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            config: yandex.cloud.mdb.mongodb.v1.config.mongodb_pb2.MongoCfgConfigSet | None = ...,
            resources: global___Resources | None = ...,
            disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> None: ...

    @typing.final
    class Mongos(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONFIG_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def config(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb_pb2.MongosConfigSet:
            """Configuration for mongos hosts."""

        @property
        def resources(self) -> global___Resources:
            """Resources allocated to mongos hosts."""

        @property
        def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            config: yandex.cloud.mdb.mongodb.v1.config.mongodb_pb2.MongosConfigSet | None = ...,
            resources: global___Resources | None = ...,
            disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config", b"config", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> None: ...

    @typing.final
    class MongoInfra(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONFIG_MONGOS_FIELD_NUMBER: builtins.int
        CONFIG_MONGOCFG_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        @property
        def config_mongos(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb_pb2.MongosConfigSet: ...
        @property
        def config_mongocfg(self) -> yandex.cloud.mdb.mongodb.v1.config.mongodb_pb2.MongoCfgConfigSet: ...
        @property
        def resources(self) -> global___Resources:
            """Resources allocated to mongoinfra (mongos+mongocfg) hosts."""

        @property
        def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            config_mongos: yandex.cloud.mdb.mongodb.v1.config.mongodb_pb2.MongosConfigSet | None = ...,
            config_mongocfg: yandex.cloud.mdb.mongodb.v1.config.mongodb_pb2.MongoCfgConfigSet | None = ...,
            resources: global___Resources | None = ...,
            disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["config_mongocfg", b"config_mongocfg", "config_mongos", b"config_mongos", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["config_mongocfg", b"config_mongocfg", "config_mongos", b"config_mongos", "disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> None: ...

    MONGOD_FIELD_NUMBER: builtins.int
    MONGOCFG_FIELD_NUMBER: builtins.int
    MONGOS_FIELD_NUMBER: builtins.int
    MONGOINFRA_FIELD_NUMBER: builtins.int
    @property
    def mongod(self) -> global___Mongodb.Mongod:
        """Configuration and resource allocation for mongod in a MongoDB cluster."""

    @property
    def mongocfg(self) -> global___Mongodb.MongoCfg:
        """Configuration and resource allocation for mongocfg in a MongoDB cluster."""

    @property
    def mongos(self) -> global___Mongodb.Mongos:
        """Configuration and resource allocation for mongos in a MongoDB cluster."""

    @property
    def mongoinfra(self) -> global___Mongodb.MongoInfra:
        """Configuration and resource allocation for mongoinfra (mongos+mongocfg) in a MongoDB cluster."""

    def __init__(
        self,
        *,
        mongod: global___Mongodb.Mongod | None = ...,
        mongocfg: global___Mongodb.MongoCfg | None = ...,
        mongos: global___Mongodb.Mongos | None = ...,
        mongoinfra: global___Mongodb.MongoInfra | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["mongocfg", b"mongocfg", "mongod", b"mongod", "mongoinfra", b"mongoinfra", "mongos", b"mongos"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["mongocfg", b"mongocfg", "mongod", b"mongod", "mongoinfra", b"mongoinfra", "mongos", b"mongos"]) -> None: ...

global___Mongodb = Mongodb

@typing.final
class Shard(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    CLUSTER_ID_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the shard."""
    cluster_id: builtins.str
    """ID of the cluster that the shard belongs to."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "name", b"name"]) -> None: ...

global___Shard = Shard

@typing.final
class Host(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Type:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Host._Type.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        TYPE_UNSPECIFIED: Host._Type.ValueType  # 0
        """Type of the host is unspecified. Default value."""
        MONGOD: Host._Type.ValueType  # 1
        """A mongod host."""
        MONGOS: Host._Type.ValueType  # 2
        """A mongos host."""
        MONGOCFG: Host._Type.ValueType  # 3
        """A mongocfg host."""
        MONGOINFRA: Host._Type.ValueType  # 4
        """A mongoinfra (mongos+mongocfg) host."""

    class Type(_Type, metaclass=_TypeEnumTypeWrapper): ...
    TYPE_UNSPECIFIED: Host.Type.ValueType  # 0
    """Type of the host is unspecified. Default value."""
    MONGOD: Host.Type.ValueType  # 1
    """A mongod host."""
    MONGOS: Host.Type.ValueType  # 2
    """A mongos host."""
    MONGOCFG: Host.Type.ValueType  # 3
    """A mongocfg host."""
    MONGOINFRA: Host.Type.ValueType  # 4
    """A mongoinfra (mongos+mongocfg) host."""

    class _Role:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _RoleEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Host._Role.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        ROLE_UNKNOWN: Host._Role.ValueType  # 0
        """Role of the host in the cluster is unknown. Default value."""
        PRIMARY: Host._Role.ValueType  # 1
        """Host is the primary MongoDB server in the cluster."""
        SECONDARY: Host._Role.ValueType  # 2
        """Host is a secondary MongoDB server in the cluster."""

    class Role(_Role, metaclass=_RoleEnumTypeWrapper): ...
    ROLE_UNKNOWN: Host.Role.ValueType  # 0
    """Role of the host in the cluster is unknown. Default value."""
    PRIMARY: Host.Role.ValueType  # 1
    """Host is the primary MongoDB server in the cluster."""
    SECONDARY: Host.Role.ValueType  # 2
    """Host is a secondary MongoDB server in the cluster."""

    class _Health:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _HealthEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Host._Health.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        HEALTH_UNKNOWN: Host._Health.ValueType  # 0
        """Health of the host is unknown. Default value."""
        ALIVE: Host._Health.ValueType  # 1
        """The host is performing all its functions normally."""
        DEAD: Host._Health.ValueType  # 2
        """The host is inoperable, and cannot perform any of its essential functions."""
        DEGRADED: Host._Health.ValueType  # 3
        """The host is degraded, and can perform only some of its essential functions."""

    class Health(_Health, metaclass=_HealthEnumTypeWrapper): ...
    HEALTH_UNKNOWN: Host.Health.ValueType  # 0
    """Health of the host is unknown. Default value."""
    ALIVE: Host.Health.ValueType  # 1
    """The host is performing all its functions normally."""
    DEAD: Host.Health.ValueType  # 2
    """The host is inoperable, and cannot perform any of its essential functions."""
    DEGRADED: Host.Health.ValueType  # 3
    """The host is degraded, and can perform only some of its essential functions."""

    @typing.final
    class HostParameters(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        @typing.final
        class TagsEntry(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            KEY_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            key: builtins.str
            value: builtins.str
            def __init__(
                self,
                *,
                key: builtins.str = ...,
                value: builtins.str = ...,
            ) -> None: ...
            def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

        HIDDEN_FIELD_NUMBER: builtins.int
        SECONDARY_DELAY_SECS_FIELD_NUMBER: builtins.int
        PRIORITY_FIELD_NUMBER: builtins.int
        TAGS_FIELD_NUMBER: builtins.int
        hidden: builtins.bool
        secondary_delay_secs: builtins.int
        priority: builtins.float
        @property
        def tags(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]: ...
        def __init__(
            self,
            *,
            hidden: builtins.bool = ...,
            secondary_delay_secs: builtins.int = ...,
            priority: builtins.float = ...,
            tags: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["hidden", b"hidden", "priority", b"priority", "secondary_delay_secs", b"secondary_delay_secs", "tags", b"tags"]) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    CLUSTER_ID_FIELD_NUMBER: builtins.int
    ZONE_ID_FIELD_NUMBER: builtins.int
    RESOURCES_FIELD_NUMBER: builtins.int
    ROLE_FIELD_NUMBER: builtins.int
    HEALTH_FIELD_NUMBER: builtins.int
    SERVICES_FIELD_NUMBER: builtins.int
    SUBNET_ID_FIELD_NUMBER: builtins.int
    ASSIGN_PUBLIC_IP_FIELD_NUMBER: builtins.int
    SHARD_NAME_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    HOST_PARAMETERS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the MongoDB host. The host name is assigned by MDB at creation time, and cannot be changed.
    1-63 characters long.

    The name is unique across all MDB hosts that exist on the platform, as it defines the FQDN of the host.
    """
    cluster_id: builtins.str
    """ID of the MongoDB host. The ID is assigned by MDB at creation time."""
    zone_id: builtins.str
    """ID of the availability zone where the MongoDB host resides."""
    role: global___Host.Role.ValueType
    """Role of the host in the cluster. If the field has default value, it is not returned in the response."""
    health: global___Host.Health.ValueType
    """Aggregated health of the host. If the field has default value, it is not returned in the response."""
    subnet_id: builtins.str
    """ID of the subnet that the host belongs to."""
    assign_public_ip: builtins.bool
    """Flag showing public IP assignment status to this host."""
    shard_name: builtins.str
    """Shard which this host belongs to."""
    type: global___Host.Type.ValueType
    """Host type. If the field has default value, it is not returned in the response."""
    @property
    def resources(self) -> global___Resources:
        """Resources allocated to the MongoDB host."""

    @property
    def services(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Service]:
        """Services provided by the host."""

    @property
    def host_parameters(self) -> global___Host.HostParameters:
        """Host parameters"""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        cluster_id: builtins.str = ...,
        zone_id: builtins.str = ...,
        resources: global___Resources | None = ...,
        role: global___Host.Role.ValueType = ...,
        health: global___Host.Health.ValueType = ...,
        services: collections.abc.Iterable[global___Service] | None = ...,
        subnet_id: builtins.str = ...,
        assign_public_ip: builtins.bool = ...,
        shard_name: builtins.str = ...,
        type: global___Host.Type.ValueType = ...,
        host_parameters: global___Host.HostParameters | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["host_parameters", b"host_parameters", "resources", b"resources"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["assign_public_ip", b"assign_public_ip", "cluster_id", b"cluster_id", "health", b"health", "host_parameters", b"host_parameters", "name", b"name", "resources", b"resources", "role", b"role", "services", b"services", "shard_name", b"shard_name", "subnet_id", b"subnet_id", "type", b"type", "zone_id", b"zone_id"]) -> None: ...

global___Host = Host

@typing.final
class Service(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Type:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Service._Type.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        TYPE_UNSPECIFIED: Service._Type.ValueType  # 0
        """Service type of the host is unspecified. Default value."""
        MONGOD: Service._Type.ValueType  # 1
        """The host is running a mongod daemon."""
        MONGOS: Service._Type.ValueType  # 2
        """The host is running a mongos daemon."""
        MONGOCFG: Service._Type.ValueType  # 3
        """The host is running a MongoDB config server."""

    class Type(_Type, metaclass=_TypeEnumTypeWrapper): ...
    TYPE_UNSPECIFIED: Service.Type.ValueType  # 0
    """Service type of the host is unspecified. Default value."""
    MONGOD: Service.Type.ValueType  # 1
    """The host is running a mongod daemon."""
    MONGOS: Service.Type.ValueType  # 2
    """The host is running a mongos daemon."""
    MONGOCFG: Service.Type.ValueType  # 3
    """The host is running a MongoDB config server."""

    class _Health:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _HealthEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Service._Health.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        HEALTH_UNKNOWN: Service._Health.ValueType  # 0
        """Health of the server is unknown."""
        ALIVE: Service._Health.ValueType  # 1
        """The server is working normally."""
        DEAD: Service._Health.ValueType  # 2
        """The server is dead or unresponsive."""

    class Health(_Health, metaclass=_HealthEnumTypeWrapper): ...
    HEALTH_UNKNOWN: Service.Health.ValueType  # 0
    """Health of the server is unknown."""
    ALIVE: Service.Health.ValueType  # 1
    """The server is working normally."""
    DEAD: Service.Health.ValueType  # 2
    """The server is dead or unresponsive."""

    TYPE_FIELD_NUMBER: builtins.int
    HEALTH_FIELD_NUMBER: builtins.int
    type: global___Service.Type.ValueType
    """Type of the service provided by the host. If the field has default value, it is not returned in the response."""
    health: global___Service.Health.ValueType
    """Aggregated health of the service. If the field has default value, it is not returned in the response."""
    def __init__(
        self,
        *,
        type: global___Service.Type.ValueType = ...,
        health: global___Service.Health.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["health", b"health", "type", b"type"]) -> None: ...

global___Service = Service

@typing.final
class Resources(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOURCE_PRESET_ID_FIELD_NUMBER: builtins.int
    DISK_SIZE_FIELD_NUMBER: builtins.int
    DISK_TYPE_ID_FIELD_NUMBER: builtins.int
    resource_preset_id: builtins.str
    """ID of the preset for computational resources available to a host (CPU, memory etc.).
    All available presets are listed in the [documentation](/docs/managed-mongodb/concepts/instance-types).
    """
    disk_size: builtins.int
    """Volume of the storage available to a host, in bytes."""
    disk_type_id: builtins.str
    """Type of the storage environment for the host.
    Possible values:
    * network-hdd - network HDD drive,
    * network-ssd - network SSD drive,
    * local-ssd - local SSD storage.
    """
    def __init__(
        self,
        *,
        resource_preset_id: builtins.str = ...,
        disk_size: builtins.int = ...,
        disk_type_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["disk_size", b"disk_size", "disk_type_id", b"disk_type_id", "resource_preset_id", b"resource_preset_id"]) -> None: ...

global___Resources = Resources

@typing.final
class Access(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATA_LENS_FIELD_NUMBER: builtins.int
    WEB_SQL_FIELD_NUMBER: builtins.int
    DATA_TRANSFER_FIELD_NUMBER: builtins.int
    data_lens: builtins.bool
    """Allow access for DataLens."""
    web_sql: builtins.bool
    """Allow access for Web SQL."""
    data_transfer: builtins.bool
    """Allow access for DataTransfer."""
    def __init__(
        self,
        *,
        data_lens: builtins.bool = ...,
        web_sql: builtins.bool = ...,
        data_transfer: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["data_lens", b"data_lens", "data_transfer", b"data_transfer", "web_sql", b"web_sql"]) -> None: ...

global___Access = Access

@typing.final
class PerformanceDiagnosticsConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROFILING_ENABLED_FIELD_NUMBER: builtins.int
    profiling_enabled: builtins.bool
    def __init__(
        self,
        *,
        profiling_enabled: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["profiling_enabled", b"profiling_enabled"]) -> None: ...

global___PerformanceDiagnosticsConfig = PerformanceDiagnosticsConfig

@typing.final
class DiskSizeAutoscaling(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PLANNED_USAGE_THRESHOLD_FIELD_NUMBER: builtins.int
    EMERGENCY_USAGE_THRESHOLD_FIELD_NUMBER: builtins.int
    DISK_SIZE_LIMIT_FIELD_NUMBER: builtins.int
    @property
    def planned_usage_threshold(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Amount of used storage for automatic disk scaling in the maintenance window, 0 means disabled, in percent."""

    @property
    def emergency_usage_threshold(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Amount of used storage for immediately  automatic disk scaling, 0 means disabled, in percent."""

    @property
    def disk_size_limit(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Limit on how large the storage for database instances can automatically grow, in bytes."""

    def __init__(
        self,
        *,
        planned_usage_threshold: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        emergency_usage_threshold: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        disk_size_limit: google.protobuf.wrappers_pb2.Int64Value | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["disk_size_limit", b"disk_size_limit", "emergency_usage_threshold", b"emergency_usage_threshold", "planned_usage_threshold", b"planned_usage_threshold"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["disk_size_limit", b"disk_size_limit", "emergency_usage_threshold", b"emergency_usage_threshold", "planned_usage_threshold", b"planned_usage_threshold"]) -> None: ...

global___DiskSizeAutoscaling = DiskSizeAutoscaling
