"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.wrappers_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class MongodConfig(google.protobuf.message.Message):
    """Configuration of a mongod daemon. Supported options are a limited subset of all
    options described in [MongoDB documentation](https://docs.mongodb.com/v7.0/reference/configuration-options/).
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class Storage(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        @typing.final
        class WiredTiger(google.protobuf.message.Message):
            """Configuration of WiredTiger storage engine."""

            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            @typing.final
            class EngineConfig(google.protobuf.message.Message):
                DESCRIPTOR: google.protobuf.descriptor.Descriptor

                CACHE_SIZE_GB_FIELD_NUMBER: builtins.int
                CACHE_SIZE_FIELD_NUMBER: builtins.int
                @property
                def cache_size_gb(self) -> google.protobuf.wrappers_pb2.DoubleValue:
                    """The maximum size of the internal cache that WiredTiger will use for all data."""

                @property
                def cache_size(self) -> google.protobuf.wrappers_pb2.DoubleValue:
                    """The maximum size of the internal cache that WiredTiger will use for all data in percents."""

                def __init__(
                    self,
                    *,
                    cache_size_gb: google.protobuf.wrappers_pb2.DoubleValue | None = ...,
                    cache_size: google.protobuf.wrappers_pb2.DoubleValue | None = ...,
                ) -> None: ...
                def HasField(self, field_name: typing.Literal["cache_size", b"cache_size", "cache_size_gb", b"cache_size_gb"]) -> builtins.bool: ...
                def ClearField(self, field_name: typing.Literal["cache_size", b"cache_size", "cache_size_gb", b"cache_size_gb"]) -> None: ...

            @typing.final
            class CollectionConfig(google.protobuf.message.Message):
                DESCRIPTOR: google.protobuf.descriptor.Descriptor

                class _Compressor:
                    ValueType = typing.NewType("ValueType", builtins.int)
                    V: typing_extensions.TypeAlias = ValueType

                class _CompressorEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[MongodConfig.Storage.WiredTiger.CollectionConfig._Compressor.ValueType], builtins.type):
                    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
                    COMPRESSOR_UNSPECIFIED: MongodConfig.Storage.WiredTiger.CollectionConfig._Compressor.ValueType  # 0
                    NONE: MongodConfig.Storage.WiredTiger.CollectionConfig._Compressor.ValueType  # 1
                    """No compression."""
                    SNAPPY: MongodConfig.Storage.WiredTiger.CollectionConfig._Compressor.ValueType  # 2
                    """The [Snappy](https://docs.mongodb.com/v7.0/reference/glossary/#std-term-snappy) compression."""
                    ZLIB: MongodConfig.Storage.WiredTiger.CollectionConfig._Compressor.ValueType  # 3
                    """The [zlib](https://docs.mongodb.com/v7.0/reference/glossary/#std-term-zlib) compression."""
                    ZSTD: MongodConfig.Storage.WiredTiger.CollectionConfig._Compressor.ValueType  # 4
                    """The [zstd](https://docs.mongodb.com/v7.0/reference/glossary/#std-term-zstd) compression."""

                class Compressor(_Compressor, metaclass=_CompressorEnumTypeWrapper): ...
                COMPRESSOR_UNSPECIFIED: MongodConfig.Storage.WiredTiger.CollectionConfig.Compressor.ValueType  # 0
                NONE: MongodConfig.Storage.WiredTiger.CollectionConfig.Compressor.ValueType  # 1
                """No compression."""
                SNAPPY: MongodConfig.Storage.WiredTiger.CollectionConfig.Compressor.ValueType  # 2
                """The [Snappy](https://docs.mongodb.com/v7.0/reference/glossary/#std-term-snappy) compression."""
                ZLIB: MongodConfig.Storage.WiredTiger.CollectionConfig.Compressor.ValueType  # 3
                """The [zlib](https://docs.mongodb.com/v7.0/reference/glossary/#std-term-zlib) compression."""
                ZSTD: MongodConfig.Storage.WiredTiger.CollectionConfig.Compressor.ValueType  # 4
                """The [zstd](https://docs.mongodb.com/v7.0/reference/glossary/#std-term-zstd) compression."""

                BLOCK_COMPRESSOR_FIELD_NUMBER: builtins.int
                block_compressor: global___MongodConfig.Storage.WiredTiger.CollectionConfig.Compressor.ValueType
                """Default type of compression to use for collection data."""
                def __init__(
                    self,
                    *,
                    block_compressor: global___MongodConfig.Storage.WiredTiger.CollectionConfig.Compressor.ValueType = ...,
                ) -> None: ...
                def ClearField(self, field_name: typing.Literal["block_compressor", b"block_compressor"]) -> None: ...

            @typing.final
            class IndexConfig(google.protobuf.message.Message):
                DESCRIPTOR: google.protobuf.descriptor.Descriptor

                PREFIX_COMPRESSION_FIELD_NUMBER: builtins.int
                @property
                def prefix_compression(self) -> google.protobuf.wrappers_pb2.BoolValue:
                    """Enables or disables [prefix compression](https://www.mongodb.com/docs/manual/reference/glossary/#std-term-prefix-compression)"""

                def __init__(
                    self,
                    *,
                    prefix_compression: google.protobuf.wrappers_pb2.BoolValue | None = ...,
                ) -> None: ...
                def HasField(self, field_name: typing.Literal["prefix_compression", b"prefix_compression"]) -> builtins.bool: ...
                def ClearField(self, field_name: typing.Literal["prefix_compression", b"prefix_compression"]) -> None: ...

            ENGINE_CONFIG_FIELD_NUMBER: builtins.int
            COLLECTION_CONFIG_FIELD_NUMBER: builtins.int
            INDEX_CONFIG_FIELD_NUMBER: builtins.int
            @property
            def engine_config(self) -> global___MongodConfig.Storage.WiredTiger.EngineConfig:
                """Engine configuration for WiredTiger."""

            @property
            def collection_config(self) -> global___MongodConfig.Storage.WiredTiger.CollectionConfig:
                """Collection configuration for WiredTiger."""

            @property
            def index_config(self) -> global___MongodConfig.Storage.WiredTiger.IndexConfig:
                """Index configuration for WiredTiger"""

            def __init__(
                self,
                *,
                engine_config: global___MongodConfig.Storage.WiredTiger.EngineConfig | None = ...,
                collection_config: global___MongodConfig.Storage.WiredTiger.CollectionConfig | None = ...,
                index_config: global___MongodConfig.Storage.WiredTiger.IndexConfig | None = ...,
            ) -> None: ...
            def HasField(self, field_name: typing.Literal["collection_config", b"collection_config", "engine_config", b"engine_config", "index_config", b"index_config"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing.Literal["collection_config", b"collection_config", "engine_config", b"engine_config", "index_config", b"index_config"]) -> None: ...

        @typing.final
        class Journal(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            COMMIT_INTERVAL_FIELD_NUMBER: builtins.int
            @property
            def commit_interval(self) -> google.protobuf.wrappers_pb2.Int64Value:
                """Commit interval between journal operations, in milliseconds.
                Default: 100.
                """

            def __init__(
                self,
                *,
                commit_interval: google.protobuf.wrappers_pb2.Int64Value | None = ...,
            ) -> None: ...
            def HasField(self, field_name: typing.Literal["commit_interval", b"commit_interval"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing.Literal["commit_interval", b"commit_interval"]) -> None: ...

        WIRED_TIGER_FIELD_NUMBER: builtins.int
        JOURNAL_FIELD_NUMBER: builtins.int
        @property
        def wired_tiger(self) -> global___MongodConfig.Storage.WiredTiger:
            """Configuration of the WiredTiger storage engine."""

        @property
        def journal(self) -> global___MongodConfig.Storage.Journal:
            """Configuration of the MongoDB [journal](https://docs.mongodb.com/v7.0/reference/glossary/#std-term-journal)."""

        def __init__(
            self,
            *,
            wired_tiger: global___MongodConfig.Storage.WiredTiger | None = ...,
            journal: global___MongodConfig.Storage.Journal | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["journal", b"journal", "wired_tiger", b"wired_tiger"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["journal", b"journal", "wired_tiger", b"wired_tiger"]) -> None: ...

    @typing.final
    class OperationProfiling(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _Mode:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _ModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[MongodConfig.OperationProfiling._Mode.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            MODE_UNSPECIFIED: MongodConfig.OperationProfiling._Mode.ValueType  # 0
            OFF: MongodConfig.OperationProfiling._Mode.ValueType  # 1
            """The profiler is off and does not collect any data."""
            SLOW_OP: MongodConfig.OperationProfiling._Mode.ValueType  # 2
            """The profiler collects data for operations that take longer than the value of [slow_op_threshold]."""
            ALL: MongodConfig.OperationProfiling._Mode.ValueType  # 3
            """The profiler collects data for all operations."""

        class Mode(_Mode, metaclass=_ModeEnumTypeWrapper): ...
        MODE_UNSPECIFIED: MongodConfig.OperationProfiling.Mode.ValueType  # 0
        OFF: MongodConfig.OperationProfiling.Mode.ValueType  # 1
        """The profiler is off and does not collect any data."""
        SLOW_OP: MongodConfig.OperationProfiling.Mode.ValueType  # 2
        """The profiler collects data for operations that take longer than the value of [slow_op_threshold]."""
        ALL: MongodConfig.OperationProfiling.Mode.ValueType  # 3
        """The profiler collects data for all operations."""

        MODE_FIELD_NUMBER: builtins.int
        SLOW_OP_THRESHOLD_FIELD_NUMBER: builtins.int
        SLOW_OP_SAMPLE_RATE_FIELD_NUMBER: builtins.int
        mode: global___MongodConfig.OperationProfiling.Mode.ValueType
        """Mode which specifies operations that should be profiled."""
        @property
        def slow_op_threshold(self) -> google.protobuf.wrappers_pb2.Int64Value:
            """The slow operation time threshold, in milliseconds. Operations that run
            for longer than this threshold are considered slow, and are processed by the profiler
            running in the SLOW_OP mode.
            """

        @property
        def slow_op_sample_rate(self) -> google.protobuf.wrappers_pb2.DoubleValue:
            """The fraction of slow operations that should be profiled or logged.
            operationProfiling.slowOpSampleRate accepts values between 0 and 1, inclusive.
            """

        def __init__(
            self,
            *,
            mode: global___MongodConfig.OperationProfiling.Mode.ValueType = ...,
            slow_op_threshold: google.protobuf.wrappers_pb2.Int64Value | None = ...,
            slow_op_sample_rate: google.protobuf.wrappers_pb2.DoubleValue | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["slow_op_sample_rate", b"slow_op_sample_rate", "slow_op_threshold", b"slow_op_threshold"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["mode", b"mode", "slow_op_sample_rate", b"slow_op_sample_rate", "slow_op_threshold", b"slow_op_threshold"]) -> None: ...

    @typing.final
    class Network(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        @typing.final
        class Compression(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            class _Compressor:
                ValueType = typing.NewType("ValueType", builtins.int)
                V: typing_extensions.TypeAlias = ValueType

            class _CompressorEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[MongodConfig.Network.Compression._Compressor.ValueType], builtins.type):
                DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
                COMPRESSOR_UNSPECIFIED: MongodConfig.Network.Compression._Compressor.ValueType  # 0
                SNAPPY: MongodConfig.Network.Compression._Compressor.ValueType  # 1
                """The [Snappy](https://docs.mongodb.com/v4.2/reference/glossary/#term-snappy) compression."""
                ZLIB: MongodConfig.Network.Compression._Compressor.ValueType  # 2
                """The [zlib](https://docs.mongodb.com/v4.2/reference/glossary/#term-zlib) compression."""
                ZSTD: MongodConfig.Network.Compression._Compressor.ValueType  # 3
                """The [zstd](https://docs.mongodb.com/v4.2/reference/glossary/#term-zstd) compression."""
                DISABLED: MongodConfig.Network.Compression._Compressor.ValueType  # 4
                """No compression"""

            class Compressor(_Compressor, metaclass=_CompressorEnumTypeWrapper): ...
            COMPRESSOR_UNSPECIFIED: MongodConfig.Network.Compression.Compressor.ValueType  # 0
            SNAPPY: MongodConfig.Network.Compression.Compressor.ValueType  # 1
            """The [Snappy](https://docs.mongodb.com/v4.2/reference/glossary/#term-snappy) compression."""
            ZLIB: MongodConfig.Network.Compression.Compressor.ValueType  # 2
            """The [zlib](https://docs.mongodb.com/v4.2/reference/glossary/#term-zlib) compression."""
            ZSTD: MongodConfig.Network.Compression.Compressor.ValueType  # 3
            """The [zstd](https://docs.mongodb.com/v4.2/reference/glossary/#term-zstd) compression."""
            DISABLED: MongodConfig.Network.Compression.Compressor.ValueType  # 4
            """No compression"""

            COMPRESSORS_FIELD_NUMBER: builtins.int
            @property
            def compressors(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___MongodConfig.Network.Compression.Compressor.ValueType]:
                """Specifies the default compressor(s) to use for communication between this mongod or mongos instance and:
                - other members of the deployment if the instance is part of a replica set or a sharded cluster
                - mongosh
                - drivers that support the OP_COMPRESSED message format.
                MongoDB supports the following compressors:
                """

            def __init__(
                self,
                *,
                compressors: collections.abc.Iterable[global___MongodConfig.Network.Compression.Compressor.ValueType] | None = ...,
            ) -> None: ...
            def ClearField(self, field_name: typing.Literal["compressors", b"compressors"]) -> None: ...

        MAX_INCOMING_CONNECTIONS_FIELD_NUMBER: builtins.int
        COMPRESSION_FIELD_NUMBER: builtins.int
        @property
        def max_incoming_connections(self) -> google.protobuf.wrappers_pb2.Int64Value:
            """The maximum number of simultaneous connections that mongod will accept."""

        @property
        def compression(self) -> global___MongodConfig.Network.Compression:
            """Compression settings"""

        def __init__(
            self,
            *,
            max_incoming_connections: google.protobuf.wrappers_pb2.Int64Value | None = ...,
            compression: global___MongodConfig.Network.Compression | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["compression", b"compression", "max_incoming_connections", b"max_incoming_connections"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["compression", b"compression", "max_incoming_connections", b"max_incoming_connections"]) -> None: ...

    @typing.final
    class Security(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        @typing.final
        class KMIP(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            SERVER_NAME_FIELD_NUMBER: builtins.int
            PORT_FIELD_NUMBER: builtins.int
            SERVER_CA_FIELD_NUMBER: builtins.int
            CLIENT_CERTIFICATE_FIELD_NUMBER: builtins.int
            KEY_IDENTIFIER_FIELD_NUMBER: builtins.int
            server_name: builtins.str
            """KMIP server name"""
            server_ca: builtins.str
            """KMIP Server CA"""
            client_certificate: builtins.str
            """KMIP client certificate + private key (unencrypted)"""
            key_identifier: builtins.str
            """KMIP Key identifier (if any)"""
            @property
            def port(self) -> google.protobuf.wrappers_pb2.Int64Value:
                """KMIP server port"""

            def __init__(
                self,
                *,
                server_name: builtins.str = ...,
                port: google.protobuf.wrappers_pb2.Int64Value | None = ...,
                server_ca: builtins.str = ...,
                client_certificate: builtins.str = ...,
                key_identifier: builtins.str = ...,
            ) -> None: ...
            def HasField(self, field_name: typing.Literal["port", b"port"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing.Literal["client_certificate", b"client_certificate", "key_identifier", b"key_identifier", "port", b"port", "server_ca", b"server_ca", "server_name", b"server_name"]) -> None: ...

        ENABLE_ENCRYPTION_FIELD_NUMBER: builtins.int
        KMIP_FIELD_NUMBER: builtins.int
        @property
        def enable_encryption(self) -> google.protobuf.wrappers_pb2.BoolValue:
            """If encryption at rest should be enabled or not, MongoDB Enterprise only"""

        @property
        def kmip(self) -> global___MongodConfig.Security.KMIP:
            """`kmip` section of mongod security config, MongoDB Enterprise only"""

        def __init__(
            self,
            *,
            enable_encryption: google.protobuf.wrappers_pb2.BoolValue | None = ...,
            kmip: global___MongodConfig.Security.KMIP | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["enable_encryption", b"enable_encryption", "kmip", b"kmip"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["enable_encryption", b"enable_encryption", "kmip", b"kmip"]) -> None: ...

    @typing.final
    class AuditLog(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        FILTER_FIELD_NUMBER: builtins.int
        RUNTIME_CONFIGURATION_FIELD_NUMBER: builtins.int
        filter: builtins.str
        """Audit filter, should be valid JSON object string"""
        @property
        def runtime_configuration(self) -> google.protobuf.wrappers_pb2.BoolValue:
            """Allows runtime configuration of audit filter and auditAuthorizationSuccess
            !! Available for MongoDB Enterprise only !!
            """

        def __init__(
            self,
            *,
            filter: builtins.str = ...,
            runtime_configuration: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["runtime_configuration", b"runtime_configuration"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["filter", b"filter", "runtime_configuration", b"runtime_configuration"]) -> None: ...

    @typing.final
    class SetParameter(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        @typing.final
        class MirrorReads(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            SAMPLING_RATE_FIELD_NUMBER: builtins.int
            MAX_TIME_MS_FIELD_NUMBER: builtins.int
            @property
            def sampling_rate(self) -> google.protobuf.wrappers_pb2.DoubleValue:
                """The sampling rate used to mirror a subset of operations that support mirroring to a subset of electable secondaries"""

            @property
            def max_time_ms(self) -> google.protobuf.wrappers_pb2.Int64Value:
                """The maximum time in milliseconds for the mirrored reads"""

            def __init__(
                self,
                *,
                sampling_rate: google.protobuf.wrappers_pb2.DoubleValue | None = ...,
                max_time_ms: google.protobuf.wrappers_pb2.Int64Value | None = ...,
            ) -> None: ...
            def HasField(self, field_name: typing.Literal["max_time_ms", b"max_time_ms", "sampling_rate", b"sampling_rate"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing.Literal["max_time_ms", b"max_time_ms", "sampling_rate", b"sampling_rate"]) -> None: ...

        AUDIT_AUTHORIZATION_SUCCESS_FIELD_NUMBER: builtins.int
        ENABLE_FLOW_CONTROL_FIELD_NUMBER: builtins.int
        MIN_SNAPSHOT_HISTORY_WINDOW_IN_SECONDS_FIELD_NUMBER: builtins.int
        FLOW_CONTROL_TARGET_LAG_SECONDS_FIELD_NUMBER: builtins.int
        FLOW_CONTROL_WARN_THRESHOLD_SECONDS_FIELD_NUMBER: builtins.int
        MIGRATE_CLONE_INSERTION_BATCH_DELAY_MS_FIELD_NUMBER: builtins.int
        MIGRATE_CLONE_INSERTION_BATCH_SIZE_FIELD_NUMBER: builtins.int
        ORPHAN_CLEANUP_DELAY_SECS_FIELD_NUMBER: builtins.int
        PERSISTED_CHUNK_CACHE_UPDATE_MAX_BATCH_SIZE_FIELD_NUMBER: builtins.int
        RANGE_DELETER_BATCH_DELAY_MS_FIELD_NUMBER: builtins.int
        RANGE_DELETER_BATCH_SIZE_FIELD_NUMBER: builtins.int
        MIRROR_READS_FIELD_NUMBER: builtins.int
        @property
        def audit_authorization_success(self) -> google.protobuf.wrappers_pb2.BoolValue:
            """Enables the auditing of authorization successes
            https://www.mongodb.com/docs/manual/reference/parameters/#mongodb-parameter-param.auditAuthorizationSuccess
            """

        @property
        def enable_flow_control(self) -> google.protobuf.wrappers_pb2.BoolValue:
            """Enables or disables the mechanism that controls the rate at which the primary applies its writes with the
            goal of keeping the secondary members [majority committed](https://www.mongodb.com/docs/v7.0/reference/command/replSetGetStatus/#replSetGetStatus.optimes.lastCommittedOpTime)
            lag under a configurable maximum value.
            """

        @property
        def min_snapshot_history_window_in_seconds(self) -> google.protobuf.wrappers_pb2.Int64Value:
            """The minimum time window in seconds for which the storage engine keeps the snapshot history."""

        @property
        def flow_control_target_lag_seconds(self) -> google.protobuf.wrappers_pb2.Int64Value:
            """The target maximum majority committed lag when running with flow control"""

        @property
        def flow_control_warn_threshold_seconds(self) -> google.protobuf.wrappers_pb2.Int64Value:
            """The amount of time to wait to log a warning once the flow control mechanism detects the majority commit point has not moved."""

        @property
        def migrate_clone_insertion_batch_delay_ms(self) -> google.protobuf.wrappers_pb2.Int64Value:
            """Time in milliseconds to wait between batches of insertions during cloning step of the migration process."""

        @property
        def migrate_clone_insertion_batch_size(self) -> google.protobuf.wrappers_pb2.Int64Value:
            """The maximum number of documents to insert in a single batch during the cloning step of the migration process."""

        @property
        def orphan_cleanup_delay_secs(self) -> google.protobuf.wrappers_pb2.Int64Value:
            """Minimum delay before a migrated chunk is deleted from the source shard."""

        @property
        def persisted_chunk_cache_update_max_batch_size(self) -> google.protobuf.wrappers_pb2.Int64Value:
            """Specifies the maximum batch size used for updating the persisted chunk cache."""

        @property
        def range_deleter_batch_delay_ms(self) -> google.protobuf.wrappers_pb2.Int64Value:
            """The amount of time in milliseconds to wait before the next batch of deletion during the cleanup stage of chunk migration (or the cleanupOrphaned command)."""

        @property
        def range_deleter_batch_size(self) -> google.protobuf.wrappers_pb2.Int64Value:
            """The maximum number of documents in each batch to delete during the cleanup stage of chunk migration (or the cleanupOrphaned command)."""

        @property
        def mirror_reads(self) -> global___MongodConfig.SetParameter.MirrorReads:
            """Specifies the settings for mirrored reads for the mongod instance"""

        def __init__(
            self,
            *,
            audit_authorization_success: google.protobuf.wrappers_pb2.BoolValue | None = ...,
            enable_flow_control: google.protobuf.wrappers_pb2.BoolValue | None = ...,
            min_snapshot_history_window_in_seconds: google.protobuf.wrappers_pb2.Int64Value | None = ...,
            flow_control_target_lag_seconds: google.protobuf.wrappers_pb2.Int64Value | None = ...,
            flow_control_warn_threshold_seconds: google.protobuf.wrappers_pb2.Int64Value | None = ...,
            migrate_clone_insertion_batch_delay_ms: google.protobuf.wrappers_pb2.Int64Value | None = ...,
            migrate_clone_insertion_batch_size: google.protobuf.wrappers_pb2.Int64Value | None = ...,
            orphan_cleanup_delay_secs: google.protobuf.wrappers_pb2.Int64Value | None = ...,
            persisted_chunk_cache_update_max_batch_size: google.protobuf.wrappers_pb2.Int64Value | None = ...,
            range_deleter_batch_delay_ms: google.protobuf.wrappers_pb2.Int64Value | None = ...,
            range_deleter_batch_size: google.protobuf.wrappers_pb2.Int64Value | None = ...,
            mirror_reads: global___MongodConfig.SetParameter.MirrorReads | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["audit_authorization_success", b"audit_authorization_success", "enable_flow_control", b"enable_flow_control", "flow_control_target_lag_seconds", b"flow_control_target_lag_seconds", "flow_control_warn_threshold_seconds", b"flow_control_warn_threshold_seconds", "migrate_clone_insertion_batch_delay_ms", b"migrate_clone_insertion_batch_delay_ms", "migrate_clone_insertion_batch_size", b"migrate_clone_insertion_batch_size", "min_snapshot_history_window_in_seconds", b"min_snapshot_history_window_in_seconds", "mirror_reads", b"mirror_reads", "orphan_cleanup_delay_secs", b"orphan_cleanup_delay_secs", "persisted_chunk_cache_update_max_batch_size", b"persisted_chunk_cache_update_max_batch_size", "range_deleter_batch_delay_ms", b"range_deleter_batch_delay_ms", "range_deleter_batch_size", b"range_deleter_batch_size"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["audit_authorization_success", b"audit_authorization_success", "enable_flow_control", b"enable_flow_control", "flow_control_target_lag_seconds", b"flow_control_target_lag_seconds", "flow_control_warn_threshold_seconds", b"flow_control_warn_threshold_seconds", "migrate_clone_insertion_batch_delay_ms", b"migrate_clone_insertion_batch_delay_ms", "migrate_clone_insertion_batch_size", b"migrate_clone_insertion_batch_size", "min_snapshot_history_window_in_seconds", b"min_snapshot_history_window_in_seconds", "mirror_reads", b"mirror_reads", "orphan_cleanup_delay_secs", b"orphan_cleanup_delay_secs", "persisted_chunk_cache_update_max_batch_size", b"persisted_chunk_cache_update_max_batch_size", "range_deleter_batch_delay_ms", b"range_deleter_batch_delay_ms", "range_deleter_batch_size", b"range_deleter_batch_size"]) -> None: ...

    @typing.final
    class Oplog(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        MAX_SIZE_PERCENT_FIELD_NUMBER: builtins.int
        MIN_RETENTION_HOURS_FIELD_NUMBER: builtins.int
        @property
        def max_size_percent(self) -> google.protobuf.wrappers_pb2.Int64Value:
            """Oplog maxsize in percents."""

        @property
        def min_retention_hours(self) -> google.protobuf.wrappers_pb2.DoubleValue:
            """The minimum number of hours to preserve an oplog entry, where decimal values represent the fractions of an hour."""

        def __init__(
            self,
            *,
            max_size_percent: google.protobuf.wrappers_pb2.Int64Value | None = ...,
            min_retention_hours: google.protobuf.wrappers_pb2.DoubleValue | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["max_size_percent", b"max_size_percent", "min_retention_hours", b"min_retention_hours"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["max_size_percent", b"max_size_percent", "min_retention_hours", b"min_retention_hours"]) -> None: ...

    STORAGE_FIELD_NUMBER: builtins.int
    OPERATION_PROFILING_FIELD_NUMBER: builtins.int
    NET_FIELD_NUMBER: builtins.int
    SECURITY_FIELD_NUMBER: builtins.int
    AUDIT_LOG_FIELD_NUMBER: builtins.int
    SET_PARAMETER_FIELD_NUMBER: builtins.int
    OPLOG_FIELD_NUMBER: builtins.int
    @property
    def storage(self) -> global___MongodConfig.Storage:
        """`storage` section of mongod configuration."""

    @property
    def operation_profiling(self) -> global___MongodConfig.OperationProfiling:
        """`operationProfiling` section of mongod configuration."""

    @property
    def net(self) -> global___MongodConfig.Network:
        """`net` section of mongod configuration."""

    @property
    def security(self) -> global___MongodConfig.Security:
        """`security` section of mongod configuration."""

    @property
    def audit_log(self) -> global___MongodConfig.AuditLog:
        """`AuditLog` section of mongod configuration."""

    @property
    def set_parameter(self) -> global___MongodConfig.SetParameter:
        """`SetParameter` section of mongod configuration."""

    @property
    def oplog(self) -> global___MongodConfig.Oplog:
        """`Oplog` section of mongod configuration."""

    def __init__(
        self,
        *,
        storage: global___MongodConfig.Storage | None = ...,
        operation_profiling: global___MongodConfig.OperationProfiling | None = ...,
        net: global___MongodConfig.Network | None = ...,
        security: global___MongodConfig.Security | None = ...,
        audit_log: global___MongodConfig.AuditLog | None = ...,
        set_parameter: global___MongodConfig.SetParameter | None = ...,
        oplog: global___MongodConfig.Oplog | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["audit_log", b"audit_log", "net", b"net", "operation_profiling", b"operation_profiling", "oplog", b"oplog", "security", b"security", "set_parameter", b"set_parameter", "storage", b"storage"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["audit_log", b"audit_log", "net", b"net", "operation_profiling", b"operation_profiling", "oplog", b"oplog", "security", b"security", "set_parameter", b"set_parameter", "storage", b"storage"]) -> None: ...

global___MongodConfig = MongodConfig

@typing.final
class MongoCfgConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class Storage(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        @typing.final
        class WiredTiger(google.protobuf.message.Message):
            """Configuration of WiredTiger storage engine."""

            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            @typing.final
            class EngineConfig(google.protobuf.message.Message):
                DESCRIPTOR: google.protobuf.descriptor.Descriptor

                CACHE_SIZE_GB_FIELD_NUMBER: builtins.int
                CACHE_SIZE_FIELD_NUMBER: builtins.int
                @property
                def cache_size_gb(self) -> google.protobuf.wrappers_pb2.DoubleValue:
                    """The maximum size of the internal cache that WiredTiger will use for all data."""

                @property
                def cache_size(self) -> google.protobuf.wrappers_pb2.DoubleValue:
                    """The maximum size of the internal cache that WiredTiger will use for all data in percents."""

                def __init__(
                    self,
                    *,
                    cache_size_gb: google.protobuf.wrappers_pb2.DoubleValue | None = ...,
                    cache_size: google.protobuf.wrappers_pb2.DoubleValue | None = ...,
                ) -> None: ...
                def HasField(self, field_name: typing.Literal["cache_size", b"cache_size", "cache_size_gb", b"cache_size_gb"]) -> builtins.bool: ...
                def ClearField(self, field_name: typing.Literal["cache_size", b"cache_size", "cache_size_gb", b"cache_size_gb"]) -> None: ...

            @typing.final
            class IndexConfig(google.protobuf.message.Message):
                DESCRIPTOR: google.protobuf.descriptor.Descriptor

                PREFIX_COMPRESSION_FIELD_NUMBER: builtins.int
                @property
                def prefix_compression(self) -> google.protobuf.wrappers_pb2.BoolValue:
                    """Enables or disables [prefix compression](https://www.mongodb.com/docs/manual/reference/glossary/#std-term-prefix-compression)"""

                def __init__(
                    self,
                    *,
                    prefix_compression: google.protobuf.wrappers_pb2.BoolValue | None = ...,
                ) -> None: ...
                def HasField(self, field_name: typing.Literal["prefix_compression", b"prefix_compression"]) -> builtins.bool: ...
                def ClearField(self, field_name: typing.Literal["prefix_compression", b"prefix_compression"]) -> None: ...

            ENGINE_CONFIG_FIELD_NUMBER: builtins.int
            INDEX_CONFIG_FIELD_NUMBER: builtins.int
            @property
            def engine_config(self) -> global___MongoCfgConfig.Storage.WiredTiger.EngineConfig:
                """Engine configuration for WiredTiger."""

            @property
            def index_config(self) -> global___MongoCfgConfig.Storage.WiredTiger.IndexConfig:
                """Index configuration for WiredTiger."""

            def __init__(
                self,
                *,
                engine_config: global___MongoCfgConfig.Storage.WiredTiger.EngineConfig | None = ...,
                index_config: global___MongoCfgConfig.Storage.WiredTiger.IndexConfig | None = ...,
            ) -> None: ...
            def HasField(self, field_name: typing.Literal["engine_config", b"engine_config", "index_config", b"index_config"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing.Literal["engine_config", b"engine_config", "index_config", b"index_config"]) -> None: ...

        WIRED_TIGER_FIELD_NUMBER: builtins.int
        @property
        def wired_tiger(self) -> global___MongoCfgConfig.Storage.WiredTiger:
            """Configuration of the WiredTiger storage engine."""

        def __init__(
            self,
            *,
            wired_tiger: global___MongoCfgConfig.Storage.WiredTiger | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["wired_tiger", b"wired_tiger"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["wired_tiger", b"wired_tiger"]) -> None: ...

    @typing.final
    class OperationProfiling(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _Mode:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _ModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[MongoCfgConfig.OperationProfiling._Mode.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            MODE_UNSPECIFIED: MongoCfgConfig.OperationProfiling._Mode.ValueType  # 0
            OFF: MongoCfgConfig.OperationProfiling._Mode.ValueType  # 1
            """The profiler is off and does not collect any data."""
            SLOW_OP: MongoCfgConfig.OperationProfiling._Mode.ValueType  # 2
            """The profiler collects data for operations that take longer than the value of [slow_op_threshold]."""
            ALL: MongoCfgConfig.OperationProfiling._Mode.ValueType  # 3
            """The profiler collects data for all operations."""

        class Mode(_Mode, metaclass=_ModeEnumTypeWrapper): ...
        MODE_UNSPECIFIED: MongoCfgConfig.OperationProfiling.Mode.ValueType  # 0
        OFF: MongoCfgConfig.OperationProfiling.Mode.ValueType  # 1
        """The profiler is off and does not collect any data."""
        SLOW_OP: MongoCfgConfig.OperationProfiling.Mode.ValueType  # 2
        """The profiler collects data for operations that take longer than the value of [slow_op_threshold]."""
        ALL: MongoCfgConfig.OperationProfiling.Mode.ValueType  # 3
        """The profiler collects data for all operations."""

        MODE_FIELD_NUMBER: builtins.int
        SLOW_OP_THRESHOLD_FIELD_NUMBER: builtins.int
        mode: global___MongoCfgConfig.OperationProfiling.Mode.ValueType
        """Mode which specifies operations that should be profiled."""
        @property
        def slow_op_threshold(self) -> google.protobuf.wrappers_pb2.Int64Value:
            """The slow operation time threshold, in milliseconds. Operations that run
            for longer than this threshold are considered slow, and are processed by the profiler
            running in the SLOW_OP mode. For details see [MongoDB documentation](https://www.mongodb.com/docs/v7.0/reference/configuration-options/#mongodb-setting-operationProfiling.slowOpThresholdMs).
            """

        def __init__(
            self,
            *,
            mode: global___MongoCfgConfig.OperationProfiling.Mode.ValueType = ...,
            slow_op_threshold: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["slow_op_threshold", b"slow_op_threshold"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["mode", b"mode", "slow_op_threshold", b"slow_op_threshold"]) -> None: ...

    @typing.final
    class Network(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        @typing.final
        class Compression(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            class _Compressor:
                ValueType = typing.NewType("ValueType", builtins.int)
                V: typing_extensions.TypeAlias = ValueType

            class _CompressorEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[MongoCfgConfig.Network.Compression._Compressor.ValueType], builtins.type):
                DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
                COMPRESSOR_UNSPECIFIED: MongoCfgConfig.Network.Compression._Compressor.ValueType  # 0
                SNAPPY: MongoCfgConfig.Network.Compression._Compressor.ValueType  # 1
                """The [Snappy](https://docs.mongodb.com/v4.2/reference/glossary/#term-snappy) compression."""
                ZLIB: MongoCfgConfig.Network.Compression._Compressor.ValueType  # 2
                """The [zlib](https://docs.mongodb.com/v4.2/reference/glossary/#term-zlib) compression."""
                ZSTD: MongoCfgConfig.Network.Compression._Compressor.ValueType  # 3
                """The [zstd](https://docs.mongodb.com/v4.2/reference/glossary/#term-zstd) compression."""
                DISABLED: MongoCfgConfig.Network.Compression._Compressor.ValueType  # 4
                """No compression"""

            class Compressor(_Compressor, metaclass=_CompressorEnumTypeWrapper): ...
            COMPRESSOR_UNSPECIFIED: MongoCfgConfig.Network.Compression.Compressor.ValueType  # 0
            SNAPPY: MongoCfgConfig.Network.Compression.Compressor.ValueType  # 1
            """The [Snappy](https://docs.mongodb.com/v4.2/reference/glossary/#term-snappy) compression."""
            ZLIB: MongoCfgConfig.Network.Compression.Compressor.ValueType  # 2
            """The [zlib](https://docs.mongodb.com/v4.2/reference/glossary/#term-zlib) compression."""
            ZSTD: MongoCfgConfig.Network.Compression.Compressor.ValueType  # 3
            """The [zstd](https://docs.mongodb.com/v4.2/reference/glossary/#term-zstd) compression."""
            DISABLED: MongoCfgConfig.Network.Compression.Compressor.ValueType  # 4
            """No compression"""

            COMPRESSORS_FIELD_NUMBER: builtins.int
            @property
            def compressors(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___MongoCfgConfig.Network.Compression.Compressor.ValueType]:
                """Specifies the default compressor(s) to use for communication between this mongod or mongos instance and:
                - other members of the deployment if the instance is part of a replica set or a sharded cluster
                - mongosh
                - drivers that support the OP_COMPRESSED message format.
                MongoDB supports the following compressors:
                """

            def __init__(
                self,
                *,
                compressors: collections.abc.Iterable[global___MongoCfgConfig.Network.Compression.Compressor.ValueType] | None = ...,
            ) -> None: ...
            def ClearField(self, field_name: typing.Literal["compressors", b"compressors"]) -> None: ...

        MAX_INCOMING_CONNECTIONS_FIELD_NUMBER: builtins.int
        COMPRESSION_FIELD_NUMBER: builtins.int
        @property
        def max_incoming_connections(self) -> google.protobuf.wrappers_pb2.Int64Value:
            """The maximum number of simultaneous connections that mongocfg will accept."""

        @property
        def compression(self) -> global___MongoCfgConfig.Network.Compression:
            """Compression settings"""

        def __init__(
            self,
            *,
            max_incoming_connections: google.protobuf.wrappers_pb2.Int64Value | None = ...,
            compression: global___MongoCfgConfig.Network.Compression | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["compression", b"compression", "max_incoming_connections", b"max_incoming_connections"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["compression", b"compression", "max_incoming_connections", b"max_incoming_connections"]) -> None: ...

    @typing.final
    class SetParameter(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ENABLE_FLOW_CONTROL_FIELD_NUMBER: builtins.int
        AUDIT_AUTHORIZATION_SUCCESS_FIELD_NUMBER: builtins.int
        @property
        def enable_flow_control(self) -> google.protobuf.wrappers_pb2.BoolValue:
            """Enables or disables the mechanism that controls the rate at which the primary applies its writes with the
            goal of keeping the secondary members [majority committed](https://www.mongodb.com/docs/v4.2/reference/command/replSetGetStatus/#replSetGetStatus.optimes.lastCommittedOpTime)
            lag under a configurable maximum value.
            """

        @property
        def audit_authorization_success(self) -> google.protobuf.wrappers_pb2.BoolValue:
            """Enables the auditing of authorization successes
            https://www.mongodb.com/docs/manual/reference/parameters/#mongodb-parameter-param.auditAuthorizationSuccess
            """

        def __init__(
            self,
            *,
            enable_flow_control: google.protobuf.wrappers_pb2.BoolValue | None = ...,
            audit_authorization_success: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["audit_authorization_success", b"audit_authorization_success", "enable_flow_control", b"enable_flow_control"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["audit_authorization_success", b"audit_authorization_success", "enable_flow_control", b"enable_flow_control"]) -> None: ...

    @typing.final
    class AuditLog(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        FILTER_FIELD_NUMBER: builtins.int
        filter: builtins.str
        """Audit filter, should be valid JSON object string"""
        def __init__(
            self,
            *,
            filter: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["filter", b"filter"]) -> None: ...

    @typing.final
    class Oplog(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        MAX_SIZE_PERCENT_FIELD_NUMBER: builtins.int
        MIN_RETENTION_HOURS_FIELD_NUMBER: builtins.int
        @property
        def max_size_percent(self) -> google.protobuf.wrappers_pb2.Int64Value:
            """Oplog maxsize in percents."""

        @property
        def min_retention_hours(self) -> google.protobuf.wrappers_pb2.DoubleValue:
            """The minimum number of hours to preserve an oplog entry, where decimal values represent the fractions of an hour."""

        def __init__(
            self,
            *,
            max_size_percent: google.protobuf.wrappers_pb2.Int64Value | None = ...,
            min_retention_hours: google.protobuf.wrappers_pb2.DoubleValue | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["max_size_percent", b"max_size_percent", "min_retention_hours", b"min_retention_hours"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["max_size_percent", b"max_size_percent", "min_retention_hours", b"min_retention_hours"]) -> None: ...

    STORAGE_FIELD_NUMBER: builtins.int
    OPERATION_PROFILING_FIELD_NUMBER: builtins.int
    NET_FIELD_NUMBER: builtins.int
    SET_PARAMETER_FIELD_NUMBER: builtins.int
    AUDIT_LOG_FIELD_NUMBER: builtins.int
    OPLOG_FIELD_NUMBER: builtins.int
    @property
    def storage(self) -> global___MongoCfgConfig.Storage:
        """`storage` section of mongocfg configuration."""

    @property
    def operation_profiling(self) -> global___MongoCfgConfig.OperationProfiling:
        """`operationProfiling` section of mongocfg configuration."""

    @property
    def net(self) -> global___MongoCfgConfig.Network:
        """`net` section of mongocfg configuration."""

    @property
    def set_parameter(self) -> global___MongoCfgConfig.SetParameter:
        """`setParameter` section of mongocfg configuration."""

    @property
    def audit_log(self) -> global___MongoCfgConfig.AuditLog:
        """`AuditLog` section of mongocfg configuration."""

    @property
    def oplog(self) -> global___MongoCfgConfig.Oplog:
        """`Oplog` section of mongod configuration."""

    def __init__(
        self,
        *,
        storage: global___MongoCfgConfig.Storage | None = ...,
        operation_profiling: global___MongoCfgConfig.OperationProfiling | None = ...,
        net: global___MongoCfgConfig.Network | None = ...,
        set_parameter: global___MongoCfgConfig.SetParameter | None = ...,
        audit_log: global___MongoCfgConfig.AuditLog | None = ...,
        oplog: global___MongoCfgConfig.Oplog | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["audit_log", b"audit_log", "net", b"net", "operation_profiling", b"operation_profiling", "oplog", b"oplog", "set_parameter", b"set_parameter", "storage", b"storage"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["audit_log", b"audit_log", "net", b"net", "operation_profiling", b"operation_profiling", "oplog", b"oplog", "set_parameter", b"set_parameter", "storage", b"storage"]) -> None: ...

global___MongoCfgConfig = MongoCfgConfig

@typing.final
class MongosConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class Network(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        @typing.final
        class Compression(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            class _Compressor:
                ValueType = typing.NewType("ValueType", builtins.int)
                V: typing_extensions.TypeAlias = ValueType

            class _CompressorEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[MongosConfig.Network.Compression._Compressor.ValueType], builtins.type):
                DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
                COMPRESSOR_UNSPECIFIED: MongosConfig.Network.Compression._Compressor.ValueType  # 0
                SNAPPY: MongosConfig.Network.Compression._Compressor.ValueType  # 1
                """The [Snappy](https://docs.mongodb.com/v4.2/reference/glossary/#term-snappy) compression."""
                ZLIB: MongosConfig.Network.Compression._Compressor.ValueType  # 2
                """The [zlib](https://docs.mongodb.com/v4.2/reference/glossary/#term-zlib) compression."""
                ZSTD: MongosConfig.Network.Compression._Compressor.ValueType  # 3
                """The [zstd](https://docs.mongodb.com/v4.2/reference/glossary/#term-zstd) compression."""
                DISABLED: MongosConfig.Network.Compression._Compressor.ValueType  # 4
                """No compression"""

            class Compressor(_Compressor, metaclass=_CompressorEnumTypeWrapper): ...
            COMPRESSOR_UNSPECIFIED: MongosConfig.Network.Compression.Compressor.ValueType  # 0
            SNAPPY: MongosConfig.Network.Compression.Compressor.ValueType  # 1
            """The [Snappy](https://docs.mongodb.com/v4.2/reference/glossary/#term-snappy) compression."""
            ZLIB: MongosConfig.Network.Compression.Compressor.ValueType  # 2
            """The [zlib](https://docs.mongodb.com/v4.2/reference/glossary/#term-zlib) compression."""
            ZSTD: MongosConfig.Network.Compression.Compressor.ValueType  # 3
            """The [zstd](https://docs.mongodb.com/v4.2/reference/glossary/#term-zstd) compression."""
            DISABLED: MongosConfig.Network.Compression.Compressor.ValueType  # 4
            """No compression"""

            COMPRESSORS_FIELD_NUMBER: builtins.int
            @property
            def compressors(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___MongosConfig.Network.Compression.Compressor.ValueType]:
                """Specifies the default compressor(s) to use for communication between this mongod or mongos instance and:
                - other members of the deployment if the instance is part of a replica set or a sharded cluster
                - mongosh
                - drivers that support the OP_COMPRESSED message format.
                MongoDB supports the following compressors:
                """

            def __init__(
                self,
                *,
                compressors: collections.abc.Iterable[global___MongosConfig.Network.Compression.Compressor.ValueType] | None = ...,
            ) -> None: ...
            def ClearField(self, field_name: typing.Literal["compressors", b"compressors"]) -> None: ...

        MAX_INCOMING_CONNECTIONS_FIELD_NUMBER: builtins.int
        COMPRESSION_FIELD_NUMBER: builtins.int
        @property
        def max_incoming_connections(self) -> google.protobuf.wrappers_pb2.Int64Value:
            """The maximum number of simultaneous connections that mongos will accept."""

        @property
        def compression(self) -> global___MongosConfig.Network.Compression:
            """Compression settings"""

        def __init__(
            self,
            *,
            max_incoming_connections: google.protobuf.wrappers_pb2.Int64Value | None = ...,
            compression: global___MongosConfig.Network.Compression | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["compression", b"compression", "max_incoming_connections", b"max_incoming_connections"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["compression", b"compression", "max_incoming_connections", b"max_incoming_connections"]) -> None: ...

    @typing.final
    class SetParameter(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        AUDIT_AUTHORIZATION_SUCCESS_FIELD_NUMBER: builtins.int
        READ_HEDGING_MODE_FIELD_NUMBER: builtins.int
        SHARDING_TASK_EXECUTOR_POOL_MAX_SIZE_FIELD_NUMBER: builtins.int
        SHARDING_TASK_EXECUTOR_POOL_MAX_CONNECTING_FIELD_NUMBER: builtins.int
        SHARDING_TASK_EXECUTOR_POOL_MIN_SIZE_FIELD_NUMBER: builtins.int
        SHARDING_TASK_EXECUTOR_POOL_REPLICA_SET_MATCHING_FIELD_NUMBER: builtins.int
        SHARDING_TASK_EXECUTOR_POOL_HOST_TIMEOUT_MS_FIELD_NUMBER: builtins.int
        SHARDING_TASK_EXECUTOR_POOL_REFRESH_REQUIREMENT_MS_FIELD_NUMBER: builtins.int
        SHARDING_TASK_EXECUTOR_POOL_REFRESH_TIMEOUT_MS_FIELD_NUMBER: builtins.int
        WARM_MIN_CONNECTIONS_IN_SHARDING_TASK_EXECUTOR_POOL_ON_STARTUP_FIELD_NUMBER: builtins.int
        WARM_MIN_CONNECTIONS_IN_SHARDING_TASK_EXECUTOR_POOL_ON_STARTUP_WAIT_MS_FIELD_NUMBER: builtins.int
        SHARDING_TASK_EXECUTOR_POOL_MAX_SIZE_FOR_CONFIG_SERVERS_FIELD_NUMBER: builtins.int
        SHARDING_TASK_EXECUTOR_POOL_MIN_SIZE_FOR_CONFIG_SERVERS_FIELD_NUMBER: builtins.int
        @property
        def audit_authorization_success(self) -> google.protobuf.wrappers_pb2.BoolValue:
            """Enables the auditing of authorization successes
            https://www.mongodb.com/docs/manual/reference/parameters/#mongodb-parameter-param.auditAuthorizationSuccess
            """

        @property
        def read_hedging_mode(self) -> google.protobuf.wrappers_pb2.StringValue:
            """Specifies whether mongos supports hedged reads for those read operations whose read preference have enabled the hedged read option."""

        @property
        def sharding_task_executor_pool_max_size(self) -> google.protobuf.wrappers_pb2.Int64Value:
            """Maximum number of outbound connections each TaskExecutor connection pool can open to any given mongod instance."""

        @property
        def sharding_task_executor_pool_max_connecting(self) -> google.protobuf.wrappers_pb2.Int64Value:
            """Maximum number of simultaneous initiating connections (including pending connections in setup/refresh state) each TaskExecutor connection pool can have to a mongod instance."""

        @property
        def sharding_task_executor_pool_min_size(self) -> google.protobuf.wrappers_pb2.Int64Value:
            """Minimum number of outbound connections each TaskExecutor connection pool can open to any given mongod instance."""

        @property
        def sharding_task_executor_pool_replica_set_matching(self) -> google.protobuf.wrappers_pb2.StringValue:
            """On a mongos instance, this parameter sets the policy that determines the minimum size limit of its connection pools to nodes within replica sets."""

        @property
        def sharding_task_executor_pool_host_timeout_ms(self) -> google.protobuf.wrappers_pb2.Int64Value:
            """Maximum time that mongos goes without communication to a host before mongos drops all connections to the host."""

        @property
        def sharding_task_executor_pool_refresh_requirement_ms(self) -> google.protobuf.wrappers_pb2.Int64Value:
            """Maximum time the mongos waits before attempting to heartbeat an idle connection in the pool."""

        @property
        def sharding_task_executor_pool_refresh_timeout_ms(self) -> google.protobuf.wrappers_pb2.Int64Value:
            """Maximum time the mongos waits for a heartbeat before timing out the heartbeat."""

        @property
        def warm_min_connections_in_sharding_task_executor_pool_on_startup(self) -> google.protobuf.wrappers_pb2.BoolValue:
            """Configures a mongos instance to prewarm its connection pool on startup."""

        @property
        def warm_min_connections_in_sharding_task_executor_pool_on_startup_wait_ms(self) -> google.protobuf.wrappers_pb2.Int64Value:
            """Sets the timeout threshold in milliseconds for a mongos to wait for ShardingTaskExecutorPoolMinSize connections to be established per shard host when using the warmMinConnectionsInShardingTaskExecutorPoolOnStartup parameter."""

        @property
        def sharding_task_executor_pool_max_size_for_config_servers(self) -> google.protobuf.wrappers_pb2.Int64Value:
            """Optional override for ShardingTaskExecutorPoolMaxSize to set the maximum number of outbound connections each TaskExecutor connection pool can open to a configuration server."""

        @property
        def sharding_task_executor_pool_min_size_for_config_servers(self) -> google.protobuf.wrappers_pb2.Int64Value:
            """Optional override for ShardingTaskExecutorPoolMinSize to set the minimum number of outbound connections each TaskExecutor connection pool can open to a configuration server."""

        def __init__(
            self,
            *,
            audit_authorization_success: google.protobuf.wrappers_pb2.BoolValue | None = ...,
            read_hedging_mode: google.protobuf.wrappers_pb2.StringValue | None = ...,
            sharding_task_executor_pool_max_size: google.protobuf.wrappers_pb2.Int64Value | None = ...,
            sharding_task_executor_pool_max_connecting: google.protobuf.wrappers_pb2.Int64Value | None = ...,
            sharding_task_executor_pool_min_size: google.protobuf.wrappers_pb2.Int64Value | None = ...,
            sharding_task_executor_pool_replica_set_matching: google.protobuf.wrappers_pb2.StringValue | None = ...,
            sharding_task_executor_pool_host_timeout_ms: google.protobuf.wrappers_pb2.Int64Value | None = ...,
            sharding_task_executor_pool_refresh_requirement_ms: google.protobuf.wrappers_pb2.Int64Value | None = ...,
            sharding_task_executor_pool_refresh_timeout_ms: google.protobuf.wrappers_pb2.Int64Value | None = ...,
            warm_min_connections_in_sharding_task_executor_pool_on_startup: google.protobuf.wrappers_pb2.BoolValue | None = ...,
            warm_min_connections_in_sharding_task_executor_pool_on_startup_wait_ms: google.protobuf.wrappers_pb2.Int64Value | None = ...,
            sharding_task_executor_pool_max_size_for_config_servers: google.protobuf.wrappers_pb2.Int64Value | None = ...,
            sharding_task_executor_pool_min_size_for_config_servers: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["audit_authorization_success", b"audit_authorization_success", "read_hedging_mode", b"read_hedging_mode", "sharding_task_executor_pool_host_timeout_ms", b"sharding_task_executor_pool_host_timeout_ms", "sharding_task_executor_pool_max_connecting", b"sharding_task_executor_pool_max_connecting", "sharding_task_executor_pool_max_size", b"sharding_task_executor_pool_max_size", "sharding_task_executor_pool_max_size_for_config_servers", b"sharding_task_executor_pool_max_size_for_config_servers", "sharding_task_executor_pool_min_size", b"sharding_task_executor_pool_min_size", "sharding_task_executor_pool_min_size_for_config_servers", b"sharding_task_executor_pool_min_size_for_config_servers", "sharding_task_executor_pool_refresh_requirement_ms", b"sharding_task_executor_pool_refresh_requirement_ms", "sharding_task_executor_pool_refresh_timeout_ms", b"sharding_task_executor_pool_refresh_timeout_ms", "sharding_task_executor_pool_replica_set_matching", b"sharding_task_executor_pool_replica_set_matching", "warm_min_connections_in_sharding_task_executor_pool_on_startup", b"warm_min_connections_in_sharding_task_executor_pool_on_startup", "warm_min_connections_in_sharding_task_executor_pool_on_startup_wait_ms", b"warm_min_connections_in_sharding_task_executor_pool_on_startup_wait_ms"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["audit_authorization_success", b"audit_authorization_success", "read_hedging_mode", b"read_hedging_mode", "sharding_task_executor_pool_host_timeout_ms", b"sharding_task_executor_pool_host_timeout_ms", "sharding_task_executor_pool_max_connecting", b"sharding_task_executor_pool_max_connecting", "sharding_task_executor_pool_max_size", b"sharding_task_executor_pool_max_size", "sharding_task_executor_pool_max_size_for_config_servers", b"sharding_task_executor_pool_max_size_for_config_servers", "sharding_task_executor_pool_min_size", b"sharding_task_executor_pool_min_size", "sharding_task_executor_pool_min_size_for_config_servers", b"sharding_task_executor_pool_min_size_for_config_servers", "sharding_task_executor_pool_refresh_requirement_ms", b"sharding_task_executor_pool_refresh_requirement_ms", "sharding_task_executor_pool_refresh_timeout_ms", b"sharding_task_executor_pool_refresh_timeout_ms", "sharding_task_executor_pool_replica_set_matching", b"sharding_task_executor_pool_replica_set_matching", "warm_min_connections_in_sharding_task_executor_pool_on_startup", b"warm_min_connections_in_sharding_task_executor_pool_on_startup", "warm_min_connections_in_sharding_task_executor_pool_on_startup_wait_ms", b"warm_min_connections_in_sharding_task_executor_pool_on_startup_wait_ms"]) -> None: ...

    @typing.final
    class AuditLog(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        FILTER_FIELD_NUMBER: builtins.int
        filter: builtins.str
        """Audit filter, should be valid JSON object string"""
        def __init__(
            self,
            *,
            filter: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["filter", b"filter"]) -> None: ...

    NET_FIELD_NUMBER: builtins.int
    SET_PARAMETER_FIELD_NUMBER: builtins.int
    AUDIT_LOG_FIELD_NUMBER: builtins.int
    CHUNK_SIZE_FIELD_NUMBER: builtins.int
    @property
    def net(self) -> global___MongosConfig.Network:
        """Network settings for mongos."""

    @property
    def set_parameter(self) -> global___MongosConfig.SetParameter:
        """`setParameter` section of mongos configuration."""

    @property
    def audit_log(self) -> global___MongosConfig.AuditLog:
        """`AuditLog` section of mongos configuration."""

    @property
    def chunk_size(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """`ChunkSize` parameter of mongos configuration."""

    def __init__(
        self,
        *,
        net: global___MongosConfig.Network | None = ...,
        set_parameter: global___MongosConfig.SetParameter | None = ...,
        audit_log: global___MongosConfig.AuditLog | None = ...,
        chunk_size: google.protobuf.wrappers_pb2.Int64Value | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["audit_log", b"audit_log", "chunk_size", b"chunk_size", "net", b"net", "set_parameter", b"set_parameter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["audit_log", b"audit_log", "chunk_size", b"chunk_size", "net", b"net", "set_parameter", b"set_parameter"]) -> None: ...

global___MongosConfig = MongosConfig

@typing.final
class MongodConfigSet(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EFFECTIVE_CONFIG_FIELD_NUMBER: builtins.int
    USER_CONFIG_FIELD_NUMBER: builtins.int
    DEFAULT_CONFIG_FIELD_NUMBER: builtins.int
    @property
    def effective_config(self) -> global___MongodConfig:
        """Effective mongod settings for a MongoDB cluster (a combination of settings defined
        in [user_config] and [default_config]).
        """

    @property
    def user_config(self) -> global___MongodConfig:
        """User-defined mongod settings for a MongoDB cluster."""

    @property
    def default_config(self) -> global___MongodConfig:
        """Default mongod configuration for a MongoDB cluster."""

    def __init__(
        self,
        *,
        effective_config: global___MongodConfig | None = ...,
        user_config: global___MongodConfig | None = ...,
        default_config: global___MongodConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["default_config", b"default_config", "effective_config", b"effective_config", "user_config", b"user_config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["default_config", b"default_config", "effective_config", b"effective_config", "user_config", b"user_config"]) -> None: ...

global___MongodConfigSet = MongodConfigSet

@typing.final
class MongoCfgConfigSet(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EFFECTIVE_CONFIG_FIELD_NUMBER: builtins.int
    USER_CONFIG_FIELD_NUMBER: builtins.int
    DEFAULT_CONFIG_FIELD_NUMBER: builtins.int
    @property
    def effective_config(self) -> global___MongoCfgConfig:
        """Effective mongocfg settings for a MongoDB cluster (a combination of settings defined
        in [user_config] and [default_config]).
        """

    @property
    def user_config(self) -> global___MongoCfgConfig:
        """User-defined mongocfg settings for a MongoDB cluster."""

    @property
    def default_config(self) -> global___MongoCfgConfig:
        """Default mongocfg configuration for a MongoDB cluster."""

    def __init__(
        self,
        *,
        effective_config: global___MongoCfgConfig | None = ...,
        user_config: global___MongoCfgConfig | None = ...,
        default_config: global___MongoCfgConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["default_config", b"default_config", "effective_config", b"effective_config", "user_config", b"user_config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["default_config", b"default_config", "effective_config", b"effective_config", "user_config", b"user_config"]) -> None: ...

global___MongoCfgConfigSet = MongoCfgConfigSet

@typing.final
class MongosConfigSet(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EFFECTIVE_CONFIG_FIELD_NUMBER: builtins.int
    USER_CONFIG_FIELD_NUMBER: builtins.int
    DEFAULT_CONFIG_FIELD_NUMBER: builtins.int
    @property
    def effective_config(self) -> global___MongosConfig:
        """Effective mongos settings for a MongoDB cluster (a combination of settings defined
        in [user_config] and [default_config]).
        """

    @property
    def user_config(self) -> global___MongosConfig:
        """User-defined mongos settings for a MongoDB cluster."""

    @property
    def default_config(self) -> global___MongosConfig:
        """Default mongos configuration for a MongoDB cluster."""

    def __init__(
        self,
        *,
        effective_config: global___MongosConfig | None = ...,
        user_config: global___MongosConfig | None = ...,
        default_config: global___MongosConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["default_config", b"default_config", "effective_config", b"effective_config", "user_config", b"user_config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["default_config", b"default_config", "effective_config", b"effective_config", "user_config", b"user_config"]) -> None: ...

global___MongosConfigSet = MongosConfigSet
