"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import google.protobuf.wrappers_pb2
import google.type.timeofday_pb2
import sys
import typing
import yandex.cloud.mdb.mysql.v1.backup_pb2
import yandex.cloud.mdb.mysql.v1.cluster_pb2
import yandex.cloud.mdb.mysql.v1.config.mysql5_7_pb2
import yandex.cloud.mdb.mysql.v1.config.mysql8_0_pb2
import yandex.cloud.mdb.mysql.v1.database_pb2
import yandex.cloud.mdb.mysql.v1.maintenance_pb2
import yandex.cloud.mdb.mysql.v1.user_pb2
import yandex.cloud.operation.operation_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster to return information about.

    To get this ID, make a [ClusterService.List] request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___GetClusterRequest = GetClusterRequest

@typing.final
class ListClustersRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to list clusters in.

    To get this ID, make a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return.

    If the number of available results is larger than [page_size], the API returns a [ListClustersResponse.next_page_token] that can be used to get the next page of results in the subsequent [ClusterService.List] requests.
    """
    page_token: builtins.str
    """Page token that can be used to iterate through multiple pages of results.

    To get the next page of results, set [page_token] to the [ListClustersResponse.next_page_token] returned by the previous [ClusterService.List] request.
    """
    filter: builtins.str
    """A filter expression that selects clusters listed in the response.

    The expression must specify:
    1. The field name. Currently you can only use filtering with the [Cluster.name] field.
    2. An `=` operator.
    3. The value in double quotes (`"`). Must be 1-63 characters long and match the regular expression `[a-zA-Z0-9_-]+`.
    """
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "folder_id", b"folder_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListClustersRequest = ListClustersRequest

@typing.final
class ListClustersResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTERS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """The token that can be used to get the next page of results.

    If the number of results is larger than [ListClustersRequest.page_size], use the [next_page_token] as the value for the [ListClustersRequest.page_token] in the subsequent [ClusterService.List] request to iterate through multiple pages of results.

    Each of the subsequent [ClusterService.List] requests should use the [next_page_token] value returned by the previous request to continue paging through the results.
    """
    @property
    def clusters(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.mdb.mysql.v1.cluster_pb2.Cluster]:
        """List of clusters."""

    def __init__(
        self,
        *,
        clusters: collections.abc.Iterable[yandex.cloud.mdb.mysql.v1.cluster_pb2.Cluster] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clusters", b"clusters", "next_page_token", b"next_page_token"]) -> None: ...

global___ListClustersResponse = ListClustersResponse

@typing.final
class CreateClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    ENVIRONMENT_FIELD_NUMBER: builtins.int
    CONFIG_SPEC_FIELD_NUMBER: builtins.int
    DATABASE_SPECS_FIELD_NUMBER: builtins.int
    USER_SPECS_FIELD_NUMBER: builtins.int
    HOST_SPECS_FIELD_NUMBER: builtins.int
    NETWORK_ID_FIELD_NUMBER: builtins.int
    SECURITY_GROUP_IDS_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    HOST_GROUP_IDS_FIELD_NUMBER: builtins.int
    MAINTENANCE_WINDOW_FIELD_NUMBER: builtins.int
    DISK_ENCRYPTION_KEY_ID_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to create the cluster in.

    To get this ID, make a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    name: builtins.str
    """Name of the cluster. The name must be unique within the folder."""
    description: builtins.str
    """Description of the cluster."""
    environment: yandex.cloud.mdb.mysql.v1.cluster_pb2.Cluster.Environment.ValueType
    """Deployment environment of the MySQL cluster."""
    network_id: builtins.str
    """ID of the network to create the cluster in."""
    deletion_protection: builtins.bool
    """This option prevents unintended deletion of the cluster."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Custom labels for the cluster as `key:value` pairs."""

    @property
    def config_spec(self) -> global___ConfigSpec:
        """Configuration of the cluster."""

    @property
    def database_specs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.mdb.mysql.v1.database_pb2.DatabaseSpec]:
        """Configuration of databases in the cluster."""

    @property
    def user_specs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.mdb.mysql.v1.user_pb2.UserSpec]:
        """Configuration of database users in the cluster."""

    @property
    def host_specs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___HostSpec]:
        """Configuration of hosts in the cluster."""

    @property
    def security_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of security group IDs to apply to the cluster."""

    @property
    def host_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Host groups hosting VMs of the cluster."""

    @property
    def maintenance_window(self) -> yandex.cloud.mdb.mysql.v1.maintenance_pb2.MaintenanceWindow:
        """Window of maintenance operations."""

    @property
    def disk_encryption_key_id(self) -> google.protobuf.wrappers_pb2.StringValue:
        """ID of the key to encrypt cluster disks."""

    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        environment: yandex.cloud.mdb.mysql.v1.cluster_pb2.Cluster.Environment.ValueType = ...,
        config_spec: global___ConfigSpec | None = ...,
        database_specs: collections.abc.Iterable[yandex.cloud.mdb.mysql.v1.database_pb2.DatabaseSpec] | None = ...,
        user_specs: collections.abc.Iterable[yandex.cloud.mdb.mysql.v1.user_pb2.UserSpec] | None = ...,
        host_specs: collections.abc.Iterable[global___HostSpec] | None = ...,
        network_id: builtins.str = ...,
        security_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
        deletion_protection: builtins.bool = ...,
        host_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
        maintenance_window: yandex.cloud.mdb.mysql.v1.maintenance_pb2.MaintenanceWindow | None = ...,
        disk_encryption_key_id: google.protobuf.wrappers_pb2.StringValue | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["config_spec", b"config_spec", "disk_encryption_key_id", b"disk_encryption_key_id", "maintenance_window", b"maintenance_window"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["config_spec", b"config_spec", "database_specs", b"database_specs", "deletion_protection", b"deletion_protection", "description", b"description", "disk_encryption_key_id", b"disk_encryption_key_id", "environment", b"environment", "folder_id", b"folder_id", "host_group_ids", b"host_group_ids", "host_specs", b"host_specs", "labels", b"labels", "maintenance_window", b"maintenance_window", "name", b"name", "network_id", b"network_id", "security_group_ids", b"security_group_ids", "user_specs", b"user_specs"]) -> None: ...

global___CreateClusterRequest = CreateClusterRequest

@typing.final
class CreateClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster that is being created."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___CreateClusterMetadata = CreateClusterMetadata

@typing.final
class UpdateClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    CONFIG_SPEC_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    MAINTENANCE_WINDOW_FIELD_NUMBER: builtins.int
    SECURITY_GROUP_IDS_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    NETWORK_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster to update.

    To get this ID, make a [ClusterService.List] request.
    """
    description: builtins.str
    """New description of the cluster."""
    name: builtins.str
    """New name of the cluster."""
    deletion_protection: builtins.bool
    """This option prevents unintended deletion of the cluster."""
    network_id: builtins.str
    """Host groups hosting VMs of the cluster.
    repeated string host_group_ids = 10;

    ID of the network to move the cluster to.
    """
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which settings of the cluster should be updated."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """New set of custom labels for the cluster as `key:value` pairs.

        This set will completely replace the current one.
        To add a label, request the current label set with the [ClusterService.Get] request, then send an [ClusterService.Update] request with the new label added to the current set.
        """

    @property
    def config_spec(self) -> global___ConfigSpec:
        """New configuration of the cluster."""

    @property
    def maintenance_window(self) -> yandex.cloud.mdb.mysql.v1.maintenance_pb2.MaintenanceWindow:
        """Configuration of a maintenance window in an MySQL cluster."""

    @property
    def security_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """New list of security group IDs to apply to the cluster."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        config_spec: global___ConfigSpec | None = ...,
        name: builtins.str = ...,
        maintenance_window: yandex.cloud.mdb.mysql.v1.maintenance_pb2.MaintenanceWindow | None = ...,
        security_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
        deletion_protection: builtins.bool = ...,
        network_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["config_spec", b"config_spec", "maintenance_window", b"maintenance_window", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "config_spec", b"config_spec", "deletion_protection", b"deletion_protection", "description", b"description", "labels", b"labels", "maintenance_window", b"maintenance_window", "name", b"name", "network_id", b"network_id", "security_group_ids", b"security_group_ids", "update_mask", b"update_mask"]) -> None: ...

global___UpdateClusterRequest = UpdateClusterRequest

@typing.final
class UpdateClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster that is being updated."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___UpdateClusterMetadata = UpdateClusterMetadata

@typing.final
class DeleteClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster to delete.

    To get this ID, make a [ClusterService.List] request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___DeleteClusterRequest = DeleteClusterRequest

@typing.final
class DeleteClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster that is being deleted."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___DeleteClusterMetadata = DeleteClusterMetadata

@typing.final
class BackupClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster to back up.

    To get this ID, make a [ClusterService.List] request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___BackupClusterRequest = BackupClusterRequest

@typing.final
class BackupClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    BACKUP_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster that is being backed up."""
    backup_id: builtins.str
    """ID of the MySQL backup that is created."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        backup_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["backup_id", b"backup_id", "cluster_id", b"cluster_id"]) -> None: ...

global___BackupClusterMetadata = BackupClusterMetadata

@typing.final
class RestoreClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    BACKUP_ID_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    ENVIRONMENT_FIELD_NUMBER: builtins.int
    CONFIG_SPEC_FIELD_NUMBER: builtins.int
    HOST_SPECS_FIELD_NUMBER: builtins.int
    NETWORK_ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    SECURITY_GROUP_IDS_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    HOST_GROUP_IDS_FIELD_NUMBER: builtins.int
    MAINTENANCE_WINDOW_FIELD_NUMBER: builtins.int
    DISK_ENCRYPTION_KEY_ID_FIELD_NUMBER: builtins.int
    backup_id: builtins.str
    """ID of the backup to restore from.

    To get this ID, make a [BackupService.List] request (lists all backups in a folder) or a [ClusterService.ListBackups] request (lists all backups for an existing cluster).
    """
    name: builtins.str
    """Name of the new MySQL cluster the backup will be restored to. The name must be unique within the folder."""
    description: builtins.str
    """Description of the new cluster."""
    environment: yandex.cloud.mdb.mysql.v1.cluster_pb2.Cluster.Environment.ValueType
    """Deployment environment of the new cluster."""
    network_id: builtins.str
    """ID of the network to create the new cluster in."""
    folder_id: builtins.str
    """ID of the folder to create the new cluster in."""
    deletion_protection: builtins.bool
    """Deletion Protection inhibits deletion of the cluster"""
    @property
    def time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp of the moment to which the MySQL cluster should be restored."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Custom labels for the new cluster as `key:value` pairs."""

    @property
    def config_spec(self) -> global___ConfigSpec:
        """Configuration of the new cluster."""

    @property
    def host_specs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___HostSpec]:
        """Configuration of hosts in the new cluster."""

    @property
    def security_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of security group IDs to apply to the new cluster."""

    @property
    def host_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Host groups hosting VMs of the cluster."""

    @property
    def maintenance_window(self) -> yandex.cloud.mdb.mysql.v1.maintenance_pb2.MaintenanceWindow:
        """Window of maintenance operations."""

    @property
    def disk_encryption_key_id(self) -> google.protobuf.wrappers_pb2.StringValue:
        """ID of the key to encrypt cluster disks."""

    def __init__(
        self,
        *,
        backup_id: builtins.str = ...,
        time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        environment: yandex.cloud.mdb.mysql.v1.cluster_pb2.Cluster.Environment.ValueType = ...,
        config_spec: global___ConfigSpec | None = ...,
        host_specs: collections.abc.Iterable[global___HostSpec] | None = ...,
        network_id: builtins.str = ...,
        folder_id: builtins.str = ...,
        security_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
        deletion_protection: builtins.bool = ...,
        host_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
        maintenance_window: yandex.cloud.mdb.mysql.v1.maintenance_pb2.MaintenanceWindow | None = ...,
        disk_encryption_key_id: google.protobuf.wrappers_pb2.StringValue | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["config_spec", b"config_spec", "disk_encryption_key_id", b"disk_encryption_key_id", "maintenance_window", b"maintenance_window", "time", b"time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["backup_id", b"backup_id", "config_spec", b"config_spec", "deletion_protection", b"deletion_protection", "description", b"description", "disk_encryption_key_id", b"disk_encryption_key_id", "environment", b"environment", "folder_id", b"folder_id", "host_group_ids", b"host_group_ids", "host_specs", b"host_specs", "labels", b"labels", "maintenance_window", b"maintenance_window", "name", b"name", "network_id", b"network_id", "security_group_ids", b"security_group_ids", "time", b"time"]) -> None: ...

global___RestoreClusterRequest = RestoreClusterRequest

@typing.final
class RestoreClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    BACKUP_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the new cluster that is being created from a backup."""
    backup_id: builtins.str
    """ID of the backup that is being used for creating a cluster."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        backup_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["backup_id", b"backup_id", "cluster_id", b"cluster_id"]) -> None: ...

global___RestoreClusterMetadata = RestoreClusterMetadata

@typing.final
class StartClusterFailoverRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    HOST_NAME_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster to start failover for.

    To get this ID, make a [ClusterService.List] request.
    """
    host_name: builtins.str
    """Host name to switch master role to.
    If not provided, then the master role is switched to the most up-to-date replica host.

    To get this name, make a [ClusterService.ListHosts] request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        host_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "host_name", b"host_name"]) -> None: ...

global___StartClusterFailoverRequest = StartClusterFailoverRequest

@typing.final
class StartClusterFailoverMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster that is being failovered."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___StartClusterFailoverMetadata = StartClusterFailoverMetadata

@typing.final
class RescheduleMaintenanceRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _RescheduleType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _RescheduleTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[RescheduleMaintenanceRequest._RescheduleType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        RESCHEDULE_TYPE_UNSPECIFIED: RescheduleMaintenanceRequest._RescheduleType.ValueType  # 0
        IMMEDIATE: RescheduleMaintenanceRequest._RescheduleType.ValueType  # 1
        """Start the maintenance operation immediately."""
        NEXT_AVAILABLE_WINDOW: RescheduleMaintenanceRequest._RescheduleType.ValueType  # 2
        """Start the maintenance operation within the next available maintenance window."""
        SPECIFIC_TIME: RescheduleMaintenanceRequest._RescheduleType.ValueType  # 3
        """Start the maintenance operation at the specific time."""

    class RescheduleType(_RescheduleType, metaclass=_RescheduleTypeEnumTypeWrapper): ...
    RESCHEDULE_TYPE_UNSPECIFIED: RescheduleMaintenanceRequest.RescheduleType.ValueType  # 0
    IMMEDIATE: RescheduleMaintenanceRequest.RescheduleType.ValueType  # 1
    """Start the maintenance operation immediately."""
    NEXT_AVAILABLE_WINDOW: RescheduleMaintenanceRequest.RescheduleType.ValueType  # 2
    """Start the maintenance operation within the next available maintenance window."""
    SPECIFIC_TIME: RescheduleMaintenanceRequest.RescheduleType.ValueType  # 3
    """Start the maintenance operation at the specific time."""

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    RESCHEDULE_TYPE_FIELD_NUMBER: builtins.int
    DELAYED_UNTIL_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster to reschedule the maintenance operation for.

    To get this ID, make a [ClusterService.List] request.
    """
    reschedule_type: global___RescheduleMaintenanceRequest.RescheduleType.ValueType
    """The type of reschedule request."""
    @property
    def delayed_until(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time until which this maintenance operation should be delayed.
        The value should be ahead of the first time when the maintenance operation has been scheduled for no more than two weeks.
        The value can also point to the past moment of time if `IMMEDIATE` reschedule type is chosen.
        """

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        reschedule_type: global___RescheduleMaintenanceRequest.RescheduleType.ValueType = ...,
        delayed_until: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["delayed_until", b"delayed_until"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "delayed_until", b"delayed_until", "reschedule_type", b"reschedule_type"]) -> None: ...

global___RescheduleMaintenanceRequest = RescheduleMaintenanceRequest

@typing.final
class RescheduleMaintenanceMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    DELAYED_UNTIL_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster the maintenance operation is being rescheduled for."""
    @property
    def delayed_until(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time until which this maintenance operation is to be delayed."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        delayed_until: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["delayed_until", b"delayed_until"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "delayed_until", b"delayed_until"]) -> None: ...

global___RescheduleMaintenanceMetadata = RescheduleMaintenanceMetadata

@typing.final
class LogRecord(google.protobuf.message.Message):
    """A single log record."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MessageEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    TIMESTAMP_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    @property
    def timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp of the log record."""

    @property
    def message(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Contents of the log record."""

    def __init__(
        self,
        *,
        timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        message: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["timestamp", b"timestamp"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["message", b"message", "timestamp", b"timestamp"]) -> None: ...

global___LogRecord = LogRecord

@typing.final
class ListClusterLogsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _ServiceType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ServiceTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ListClusterLogsRequest._ServiceType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        SERVICE_TYPE_UNSPECIFIED: ListClusterLogsRequest._ServiceType.ValueType  # 0
        MYSQL_ERROR: ListClusterLogsRequest._ServiceType.ValueType  # 1
        """MySQL error log."""
        MYSQL_GENERAL: ListClusterLogsRequest._ServiceType.ValueType  # 2
        """MySQL general query log."""
        MYSQL_SLOW_QUERY: ListClusterLogsRequest._ServiceType.ValueType  # 3
        """MySQL slow query log."""
        MYSQL_AUDIT: ListClusterLogsRequest._ServiceType.ValueType  # 4
        """MySQL audit log."""

    class ServiceType(_ServiceType, metaclass=_ServiceTypeEnumTypeWrapper): ...
    SERVICE_TYPE_UNSPECIFIED: ListClusterLogsRequest.ServiceType.ValueType  # 0
    MYSQL_ERROR: ListClusterLogsRequest.ServiceType.ValueType  # 1
    """MySQL error log."""
    MYSQL_GENERAL: ListClusterLogsRequest.ServiceType.ValueType  # 2
    """MySQL general query log."""
    MYSQL_SLOW_QUERY: ListClusterLogsRequest.ServiceType.ValueType  # 3
    """MySQL slow query log."""
    MYSQL_AUDIT: ListClusterLogsRequest.ServiceType.ValueType  # 4
    """MySQL audit log."""

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    COLUMN_FILTER_FIELD_NUMBER: builtins.int
    SERVICE_TYPE_FIELD_NUMBER: builtins.int
    FROM_TIME_FIELD_NUMBER: builtins.int
    TO_TIME_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    ALWAYS_NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster to request logs for.

    To get this ID, make a [ClusterService.List] request.
    """
    service_type: global___ListClusterLogsRequest.ServiceType.ValueType
    """The log type."""
    page_size: builtins.int
    """The maximum number of results per page to return.

    If the number of available results is larger than [page_size], the API returns a [ListClusterLogsResponse.next_page_token] that can be used to get the next page of results in the subsequent [ClusterService.ListLogs] requests.
    """
    page_token: builtins.str
    """Page token that can be used to iterate through multiple pages of results.

    To get the next page of results, set [page_token] to the [ListClusterLogsResponse.next_page_token] returned by the previous [ClusterService.ListLogs] request.
    """
    always_next_page_token: builtins.bool
    """Option that controls the behavior of result pagination.
    If it is set to `true`, then [ListClusterLogsResponse.next_page_token] will always be returned, even if the current page is empty.
    """
    @property
    def column_filter(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Columns from the logs table to request.
        If no columns are specified, complete log records are returned.
        """

    @property
    def from_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Start timestamp for the logs request.
        The logs in the response will be within [from_time] to [to_time] range.
        """

    @property
    def to_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """End timestamp for the logs request.
        The logs in the response will be within [from_time] to [to_time] range.
        """

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        column_filter: collections.abc.Iterable[builtins.str] | None = ...,
        service_type: global___ListClusterLogsRequest.ServiceType.ValueType = ...,
        from_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        to_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        always_next_page_token: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["from_time", b"from_time", "to_time", b"to_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["always_next_page_token", b"always_next_page_token", "cluster_id", b"cluster_id", "column_filter", b"column_filter", "from_time", b"from_time", "page_size", b"page_size", "page_token", b"page_token", "service_type", b"service_type", "to_time", b"to_time"]) -> None: ...

global___ListClusterLogsRequest = ListClusterLogsRequest

@typing.final
class ListClusterLogsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOGS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """The token that can be used to get the next page of results.

    If the number of results is larger than [ListClusterLogsRequest.page_size], use the [next_page_token] as the value for the [ListClusterLogsRequest.page_token] in the subsequent [ClusterService.ListLogs] request to iterate through multiple pages of results.

    Each of the subsequent [ClusterService.ListLogs] requests should use the [next_page_token] value returned by the previous request to continue paging through the results.

    This value is interchangeable with [StreamLogRecord.next_record_token] from [ClusterService.StreamLogs] method.
    """
    @property
    def logs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___LogRecord]:
        """Requested log records."""

    def __init__(
        self,
        *,
        logs: collections.abc.Iterable[global___LogRecord] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["logs", b"logs", "next_page_token", b"next_page_token"]) -> None: ...

global___ListClusterLogsResponse = ListClusterLogsResponse

@typing.final
class StreamLogRecord(google.protobuf.message.Message):
    """A single log record in the logs stream."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RECORD_FIELD_NUMBER: builtins.int
    NEXT_RECORD_TOKEN_FIELD_NUMBER: builtins.int
    next_record_token: builtins.str
    """The token that can be used to continue streaming logs starting from the exact same record.
    To continue streaming, specify value of [next_record_token] as the [StreamClusterLogsRequest.record_token] value in the next [ClusterService.StreamLogs] request.

    This value is interchangeable with [ListClusterLogsResponse.next_page_token] from [ClusterService.ListLogs] method.
    """
    @property
    def record(self) -> global___LogRecord:
        """One of the requested log records."""

    def __init__(
        self,
        *,
        record: global___LogRecord | None = ...,
        next_record_token: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["record", b"record"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["next_record_token", b"next_record_token", "record", b"record"]) -> None: ...

global___StreamLogRecord = StreamLogRecord

@typing.final
class StreamClusterLogsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _ServiceType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ServiceTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[StreamClusterLogsRequest._ServiceType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        SERVICE_TYPE_UNSPECIFIED: StreamClusterLogsRequest._ServiceType.ValueType  # 0
        MYSQL_ERROR: StreamClusterLogsRequest._ServiceType.ValueType  # 1
        """MySQL error log."""
        MYSQL_GENERAL: StreamClusterLogsRequest._ServiceType.ValueType  # 2
        """MySQL general query log."""
        MYSQL_SLOW_QUERY: StreamClusterLogsRequest._ServiceType.ValueType  # 3
        """MySQL slow query log."""
        MYSQL_AUDIT: StreamClusterLogsRequest._ServiceType.ValueType  # 4
        """MySQL audit log."""

    class ServiceType(_ServiceType, metaclass=_ServiceTypeEnumTypeWrapper): ...
    SERVICE_TYPE_UNSPECIFIED: StreamClusterLogsRequest.ServiceType.ValueType  # 0
    MYSQL_ERROR: StreamClusterLogsRequest.ServiceType.ValueType  # 1
    """MySQL error log."""
    MYSQL_GENERAL: StreamClusterLogsRequest.ServiceType.ValueType  # 2
    """MySQL general query log."""
    MYSQL_SLOW_QUERY: StreamClusterLogsRequest.ServiceType.ValueType  # 3
    """MySQL slow query log."""
    MYSQL_AUDIT: StreamClusterLogsRequest.ServiceType.ValueType  # 4
    """MySQL audit log."""

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    COLUMN_FILTER_FIELD_NUMBER: builtins.int
    SERVICE_TYPE_FIELD_NUMBER: builtins.int
    FROM_TIME_FIELD_NUMBER: builtins.int
    TO_TIME_FIELD_NUMBER: builtins.int
    RECORD_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster to stream logs for.

    To get this ID, make a [ClusterService.List] request.
    """
    service_type: global___StreamClusterLogsRequest.ServiceType.ValueType
    """The log type."""
    record_token: builtins.str
    """Record token that can be used to control logs streaming.

    Set [record_token] to the [StreamLogRecord.next_record_token], returned by the previous [ClusterService.StreamLogs] request to start streaming from the next log record.
    """
    filter: builtins.str
    """A filter expression that selects clusters logs listed in the response.

    The expression must specify:
    1. The field name. Currently filtering can be applied to the [LogRecord.logs.hostname] field.
    2. An `=` operator.
    3. The value in double quotes (`"`). Must be 3-63 characters long and match the regular expression `[a-z][-a-z0-9]{1,61}[a-z0-9]`.
    Examples of a filter: `message.hostname='node1.db.cloud.yandex.net'`
    """
    @property
    def column_filter(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Columns from the logs table to request.
        If no columns are specified, complete log records are returned.
        """

    @property
    def from_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Start timestamp for the logs request."""

    @property
    def to_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """End timestamp for the logs request.
        If this field is not set, all existing log records beginning from [from_time] will be returned first, and then the new records will be returned as they appear.

        In essence it has `tail -f` command semantics.
        """

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        column_filter: collections.abc.Iterable[builtins.str] | None = ...,
        service_type: global___StreamClusterLogsRequest.ServiceType.ValueType = ...,
        from_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        to_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        record_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["from_time", b"from_time", "to_time", b"to_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "column_filter", b"column_filter", "filter", b"filter", "from_time", b"from_time", "record_token", b"record_token", "service_type", b"service_type", "to_time", b"to_time"]) -> None: ...

global___StreamClusterLogsRequest = StreamClusterLogsRequest

@typing.final
class ListClusterOperationsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster to list operations for.

    To get this ID, make a [ClusterService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return.

    If the number of available results is larger than [page_size], the API returns a [ListClusterOperationsResponse.next_page_token] that can be used to get the next page of results in the subsequent [ClusterService.ListOperations] requests.
    """
    page_token: builtins.str
    """Page token that can be used to iterate through multiple pages of results.

    To get the next page of results, set [page_token] to the [ListClusterOperationsResponse.next_page_token] returned by the previous [ClusterService.ListOperations] request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListClusterOperationsRequest = ListClusterOperationsRequest

@typing.final
class ListClusterOperationsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """The token that can be used to get the next page of results.

    If the number of results is larger than [ListClusterOperationsRequest.page_size], use the [next_page_token] as the value for the [ListClusterOperationsRequest.page_token] in the subsequent [ClusterService.ListOperations] request to iterate through multiple pages of results.

    Each of the subsequent [ClusterService.ListOperations] requests should use the [next_page_token] value returned by the previous request to continue paging through the results.
    """
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.operation.operation_pb2.Operation]:
        """List of operations in the cluster."""

    def __init__(
        self,
        *,
        operations: collections.abc.Iterable[yandex.cloud.operation.operation_pb2.Operation] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "operations", b"operations"]) -> None: ...

global___ListClusterOperationsResponse = ListClusterOperationsResponse

@typing.final
class ListClusterBackupsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster to list backups for.

    To get this ID, make a [ClusterService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return.

    If the number of available results is larger than [page_size], the API returns a [ListClusterBackupsResponse.next_page_token] that can be used to get the next page of results in the subsequent [ClusterService.ListBackups] requests.
    """
    page_token: builtins.str
    """Page token that can be used to iterate through multiple pages of results.

    To get the next page of results, set [page_token] to the [ListClusterBackupsResponse.next_page_token] returned by the previous [ClusterService.ListBackups] request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListClusterBackupsRequest = ListClusterBackupsRequest

@typing.final
class ListClusterBackupsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BACKUPS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """The token that can be used to get the next page of results.

    If the number of results is larger than [ListClusterBackupsRequest.page_size], use the [next_page_token] as the value for the [ListClusterBackupsRequest.page_token] in the subsequent [ClusterService.ListBackups] request to iterate through multiple pages of results.

    Each of the subsequent [ClusterService.ListBackups] requests should use the [next_page_token] value returned by the previous request to continue paging through the results.
    """
    @property
    def backups(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.mdb.mysql.v1.backup_pb2.Backup]:
        """List of the cluster backups."""

    def __init__(
        self,
        *,
        backups: collections.abc.Iterable[yandex.cloud.mdb.mysql.v1.backup_pb2.Backup] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["backups", b"backups", "next_page_token", b"next_page_token"]) -> None: ...

global___ListClusterBackupsResponse = ListClusterBackupsResponse

@typing.final
class ListClusterHostsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster to list hosts for.

    To get this ID, make a [ClusterService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return.

    If the number of available results is larger than [page_size], the API returns a [ListClusterHostsResponse.next_page_token] that can be used to get the next page of results in the subsequent [ClusterService.ListHosts] requests.
    """
    page_token: builtins.str
    """Page token that can be used to iterate through multiple pages of results.

    To get the next page of results, set [page_token] to the [ListClusterHostsResponse.next_page_token] returned by the previous [ClusterService.ListHosts] request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListClusterHostsRequest = ListClusterHostsRequest

@typing.final
class ListClusterHostsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HOSTS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """The token that can be used to get the next page of results.

    If the number of results is larger than [ListClusterHostsRequest.page_size], use the [next_page_token] as the value for the [ListClusterHostsRequest.page_token] in the subsequent [ClusterService.ListHosts] request to iterate through multiple pages of results.

    Each of the subsequent [ClusterService.ListHosts] requests should use the [next_page_token] value returned by the previous request to continue paging through the results.
    """
    @property
    def hosts(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.mdb.mysql.v1.cluster_pb2.Host]:
        """List of hosts in the cluster."""

    def __init__(
        self,
        *,
        hosts: collections.abc.Iterable[yandex.cloud.mdb.mysql.v1.cluster_pb2.Host] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["hosts", b"hosts", "next_page_token", b"next_page_token"]) -> None: ...

global___ListClusterHostsResponse = ListClusterHostsResponse

@typing.final
class AddClusterHostsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    HOST_SPECS_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster to add hosts to.

    To get this ID, make a [ClusterService.List] request.
    """
    @property
    def host_specs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___HostSpec]:
        """Configuration of the newly added hosts."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        host_specs: collections.abc.Iterable[global___HostSpec] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "host_specs", b"host_specs"]) -> None: ...

global___AddClusterHostsRequest = AddClusterHostsRequest

@typing.final
class AddClusterHostsMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    HOST_NAMES_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster to which the hosts are being added."""
    @property
    def host_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Names of hosts that are being added."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        host_names: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "host_names", b"host_names"]) -> None: ...

global___AddClusterHostsMetadata = AddClusterHostsMetadata

@typing.final
class DeleteClusterHostsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    HOST_NAMES_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster to delete hosts from.

    To get this ID, make a [ClusterService.List] request.
    """
    @property
    def host_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Names of hosts to delete.

        To get these names, make a [ClusterService.ListHosts] request.
        """

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        host_names: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "host_names", b"host_names"]) -> None: ...

global___DeleteClusterHostsRequest = DeleteClusterHostsRequest

@typing.final
class DeleteClusterHostsMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    HOST_NAMES_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster from which the hosts are being deleted."""
    @property
    def host_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Names of hosts that are being deleted."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        host_names: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "host_names", b"host_names"]) -> None: ...

global___DeleteClusterHostsMetadata = DeleteClusterHostsMetadata

@typing.final
class StartClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster to start.

    To get this ID, make a [ClusterService.List] request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___StartClusterRequest = StartClusterRequest

@typing.final
class StartClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster that is being started."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___StartClusterMetadata = StartClusterMetadata

@typing.final
class StopClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster to stop.

    To get this ID, make a [ClusterService.List] request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___StopClusterRequest = StopClusterRequest

@typing.final
class StopClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster that is being stopped."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___StopClusterMetadata = StopClusterMetadata

@typing.final
class MoveClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    DESTINATION_FOLDER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster to move.

    To get this ID, make a [ClusterService.List] request.
    """
    destination_folder_id: builtins.str
    """ID of the destination folder.

    To get this ID, make a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        destination_folder_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "destination_folder_id", b"destination_folder_id"]) -> None: ...

global___MoveClusterRequest = MoveClusterRequest

@typing.final
class MoveClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    SOURCE_FOLDER_ID_FIELD_NUMBER: builtins.int
    DESTINATION_FOLDER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster that is being moved."""
    source_folder_id: builtins.str
    """ID of the source folder."""
    destination_folder_id: builtins.str
    """ID of the destination folder."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        source_folder_id: builtins.str = ...,
        destination_folder_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "destination_folder_id", b"destination_folder_id", "source_folder_id", b"source_folder_id"]) -> None: ...

global___MoveClusterMetadata = MoveClusterMetadata

@typing.final
class UpdateClusterHostsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    UPDATE_HOST_SPECS_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the MySQL cluster to update hosts in.
    To get the MySQL cluster ID, use a [ClusterService.List] request.
    """
    @property
    def update_host_specs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___UpdateHostSpec]:
        """New configurations to apply to hosts."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        update_host_specs: collections.abc.Iterable[global___UpdateHostSpec] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "update_host_specs", b"update_host_specs"]) -> None: ...

global___UpdateClusterHostsRequest = UpdateClusterHostsRequest

@typing.final
class UpdateClusterHostsMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    HOST_NAMES_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster in which the hosts are being updated."""
    @property
    def host_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Names of hosts that are being updated."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        host_names: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "host_names", b"host_names"]) -> None: ...

global___UpdateClusterHostsMetadata = UpdateClusterHostsMetadata

@typing.final
class UpdateHostSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HOST_NAME_FIELD_NUMBER: builtins.int
    REPLICATION_SOURCE_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    BACKUP_PRIORITY_FIELD_NUMBER: builtins.int
    ASSIGN_PUBLIC_IP_FIELD_NUMBER: builtins.int
    PRIORITY_FIELD_NUMBER: builtins.int
    host_name: builtins.str
    """Name of the host to update.
    To get a MySQL host name, use a [ClusterService.ListHosts] request.
    """
    replication_source: builtins.str
    """[Host.name] of the host to be used as the replication source (for cascading replication).
    To get a MySQL host name, use a [ClusterService.ListHosts] request.
    """
    backup_priority: builtins.int
    """Host backup priority."""
    assign_public_ip: builtins.bool
    """Whether the host should get a public IP address on creation."""
    priority: builtins.int
    """Host master promotion priority."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which settings of the MySQL host should be updated."""

    def __init__(
        self,
        *,
        host_name: builtins.str = ...,
        replication_source: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        backup_priority: builtins.int = ...,
        assign_public_ip: builtins.bool = ...,
        priority: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["assign_public_ip", b"assign_public_ip", "backup_priority", b"backup_priority", "host_name", b"host_name", "priority", b"priority", "replication_source", b"replication_source", "update_mask", b"update_mask"]) -> None: ...

global___UpdateHostSpec = UpdateHostSpec

@typing.final
class HostSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ZONE_ID_FIELD_NUMBER: builtins.int
    SUBNET_ID_FIELD_NUMBER: builtins.int
    ASSIGN_PUBLIC_IP_FIELD_NUMBER: builtins.int
    REPLICATION_SOURCE_FIELD_NUMBER: builtins.int
    BACKUP_PRIORITY_FIELD_NUMBER: builtins.int
    PRIORITY_FIELD_NUMBER: builtins.int
    zone_id: builtins.str
    """ID of the availability zone where the host resides.

    To get a list of available zones, make the [yandex.cloud.compute.v1.ZoneService.List] request.
    """
    subnet_id: builtins.str
    """ID of the subnet to assign to the host.

    This subnet should be a part of the cluster network (the network ID is specified in the [ClusterService.CreateClusterRequest.network_id]).
    """
    assign_public_ip: builtins.bool
    """Option that enables public IP address for the host so that the host can be accessed from the internet.

    After a host has been created, this setting cannot be changed.
    To remove an assigned public IP address, or to assign a public IP address to a host without one, recreate the host with the appropriate [assign_public_ip] value set.

    Possible values:
    * `false` - don't assign a public IP address to the host.
    * `true` - assign a public IP address to the host.
    """
    replication_source: builtins.str
    """[Host.name] of the host to be used as the replication source (for cascading replication)."""
    backup_priority: builtins.int
    """Host backup priority"""
    priority: builtins.int
    """Host master promotion priority"""
    def __init__(
        self,
        *,
        zone_id: builtins.str = ...,
        subnet_id: builtins.str = ...,
        assign_public_ip: builtins.bool = ...,
        replication_source: builtins.str = ...,
        backup_priority: builtins.int = ...,
        priority: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["assign_public_ip", b"assign_public_ip", "backup_priority", b"backup_priority", "priority", b"priority", "replication_source", b"replication_source", "subnet_id", b"subnet_id", "zone_id", b"zone_id"]) -> None: ...

global___HostSpec = HostSpec

@typing.final
class ConfigSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VERSION_FIELD_NUMBER: builtins.int
    MYSQL_CONFIG_5_7_FIELD_NUMBER: builtins.int
    MYSQL_CONFIG_8_0_FIELD_NUMBER: builtins.int
    RESOURCES_FIELD_NUMBER: builtins.int
    BACKUP_WINDOW_START_FIELD_NUMBER: builtins.int
    ACCESS_FIELD_NUMBER: builtins.int
    PERFORMANCE_DIAGNOSTICS_FIELD_NUMBER: builtins.int
    BACKUP_RETAIN_PERIOD_DAYS_FIELD_NUMBER: builtins.int
    DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
    version: builtins.str
    """Version of MySQL used in the cluster.

    Possible values: `5.7`, `8.0`.
    No formal validation, a list of supported versions should suffice.
    """
    @property
    def mysql_config_5_7(self) -> yandex.cloud.mdb.mysql.v1.config.mysql5_7_pb2.MysqlConfig5_7:
        """Configuration for a MySQL 5.7 cluster."""

    @property
    def mysql_config_8_0(self) -> yandex.cloud.mdb.mysql.v1.config.mysql8_0_pb2.MysqlConfig8_0:
        """Configuration for a MySQL 8.0 cluster."""

    @property
    def resources(self) -> yandex.cloud.mdb.mysql.v1.cluster_pb2.Resources:
        """Resource preset for the cluster hosts."""

    @property
    def backup_window_start(self) -> google.type.timeofday_pb2.TimeOfDay:
        """Time to start the daily backup, in the UTC timezone."""

    @property
    def access(self) -> yandex.cloud.mdb.mysql.v1.cluster_pb2.Access:
        """Access policy for external services.

        If the specific services need to access the cluster, then set the necessary values in this policy.
        """

    @property
    def performance_diagnostics(self) -> yandex.cloud.mdb.mysql.v1.cluster_pb2.PerformanceDiagnostics:
        """Configuration of the performance diagnostics service."""

    @property
    def backup_retain_period_days(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Retention policy of automated backups."""

    @property
    def disk_size_autoscaling(self) -> yandex.cloud.mdb.mysql.v1.cluster_pb2.DiskSizeAutoscaling:
        """Disk size autoscaling"""

    def __init__(
        self,
        *,
        version: builtins.str = ...,
        mysql_config_5_7: yandex.cloud.mdb.mysql.v1.config.mysql5_7_pb2.MysqlConfig5_7 | None = ...,
        mysql_config_8_0: yandex.cloud.mdb.mysql.v1.config.mysql8_0_pb2.MysqlConfig8_0 | None = ...,
        resources: yandex.cloud.mdb.mysql.v1.cluster_pb2.Resources | None = ...,
        backup_window_start: google.type.timeofday_pb2.TimeOfDay | None = ...,
        access: yandex.cloud.mdb.mysql.v1.cluster_pb2.Access | None = ...,
        performance_diagnostics: yandex.cloud.mdb.mysql.v1.cluster_pb2.PerformanceDiagnostics | None = ...,
        backup_retain_period_days: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        disk_size_autoscaling: yandex.cloud.mdb.mysql.v1.cluster_pb2.DiskSizeAutoscaling | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["access", b"access", "backup_retain_period_days", b"backup_retain_period_days", "backup_window_start", b"backup_window_start", "disk_size_autoscaling", b"disk_size_autoscaling", "mysql_config", b"mysql_config", "mysql_config_5_7", b"mysql_config_5_7", "mysql_config_8_0", b"mysql_config_8_0", "performance_diagnostics", b"performance_diagnostics", "resources", b"resources"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["access", b"access", "backup_retain_period_days", b"backup_retain_period_days", "backup_window_start", b"backup_window_start", "disk_size_autoscaling", b"disk_size_autoscaling", "mysql_config", b"mysql_config", "mysql_config_5_7", b"mysql_config_5_7", "mysql_config_8_0", b"mysql_config_8_0", "performance_diagnostics", b"performance_diagnostics", "resources", b"resources", "version", b"version"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["mysql_config", b"mysql_config"]) -> typing.Literal["mysql_config_5_7", "mysql_config_8_0"] | None: ...

global___ConfigSpec = ConfigSpec
