"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.wrappers_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _GlobalPermission:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _GlobalPermissionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_GlobalPermission.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    GLOBAL_PERMISSION_UNSPECIFIED: _GlobalPermission.ValueType  # 0
    REPLICATION_CLIENT: _GlobalPermission.ValueType  # 1
    """Enables use of the `SHOW MASTER STATUS`, `SHOW SLAVE STATUS`, and `SHOW BINARY LOGS` statements."""
    REPLICATION_SLAVE: _GlobalPermission.ValueType  # 2
    """Enables the account to request updates that have been made to databases on the master server,
    using the `SHOW SLAVE HOSTS`, `SHOW RELAYLOG EVENTS` and `SHOW BINLOG EVENTS` statements.
    """
    PROCESS: _GlobalPermission.ValueType  # 3
    """Enables display of information about the the statements currently being performed by sessions (the set of threads executing within the server).

    The privilege enables use of `SHOW PROCESSLIST` or `mysqladmin` processlist to see threads belonging to other users.
    You can always see your own threads. The `PROCESS` privilege also enables use of `SHOW ENGINE`.
    """
    FLUSH_OPTIMIZER_COSTS: _GlobalPermission.ValueType  # 4
    """Enables use of the `FLUSH OPTIMIZER_COSTS` statement."""
    SHOW_ROUTINE: _GlobalPermission.ValueType  # 5
    """Enables a user to access definitions and properties of all stored routines (stored procedures and functions), even those for which the user is not named as the routine DEFINER.
    This access includes:
    The contents of the Information Schema `ROUTINES` table.
    The `SHOW CREATE FUNCTION` and `SHOW CREATE PROCEDURE` statements.
    The `SHOW FUNCTION CODE` and `SHOW PROCEDURE CODE` statements.
    The SHOW `FUNCTION STATUS` and `SHOW PROCEDURE STATUS` statements.
    """
    MDB_ADMIN: _GlobalPermission.ValueType  # 6
    """Enables use of the KILL command, creating and dropping databases and users, granting privileges to tables and databases."""

class GlobalPermission(_GlobalPermission, metaclass=_GlobalPermissionEnumTypeWrapper): ...

GLOBAL_PERMISSION_UNSPECIFIED: GlobalPermission.ValueType  # 0
REPLICATION_CLIENT: GlobalPermission.ValueType  # 1
"""Enables use of the `SHOW MASTER STATUS`, `SHOW SLAVE STATUS`, and `SHOW BINARY LOGS` statements."""
REPLICATION_SLAVE: GlobalPermission.ValueType  # 2
"""Enables the account to request updates that have been made to databases on the master server,
using the `SHOW SLAVE HOSTS`, `SHOW RELAYLOG EVENTS` and `SHOW BINLOG EVENTS` statements.
"""
PROCESS: GlobalPermission.ValueType  # 3
"""Enables display of information about the the statements currently being performed by sessions (the set of threads executing within the server).

The privilege enables use of `SHOW PROCESSLIST` or `mysqladmin` processlist to see threads belonging to other users.
You can always see your own threads. The `PROCESS` privilege also enables use of `SHOW ENGINE`.
"""
FLUSH_OPTIMIZER_COSTS: GlobalPermission.ValueType  # 4
"""Enables use of the `FLUSH OPTIMIZER_COSTS` statement."""
SHOW_ROUTINE: GlobalPermission.ValueType  # 5
"""Enables a user to access definitions and properties of all stored routines (stored procedures and functions), even those for which the user is not named as the routine DEFINER.
This access includes:
The contents of the Information Schema `ROUTINES` table.
The `SHOW CREATE FUNCTION` and `SHOW CREATE PROCEDURE` statements.
The `SHOW FUNCTION CODE` and `SHOW PROCEDURE CODE` statements.
The SHOW `FUNCTION STATUS` and `SHOW PROCEDURE STATUS` statements.
"""
MDB_ADMIN: GlobalPermission.ValueType  # 6
"""Enables use of the KILL command, creating and dropping databases and users, granting privileges to tables and databases."""
global___GlobalPermission = GlobalPermission

class _AuthPlugin:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _AuthPluginEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_AuthPlugin.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    AUTH_PLUGIN_UNSPECIFIED: _AuthPlugin.ValueType  # 0
    MYSQL_NATIVE_PASSWORD: _AuthPlugin.ValueType  # 1
    """Use [Native Pluggable Authentication](https://dev.mysql.com/doc/refman/8.0/en/native-pluggable-authentication.html)."""
    CACHING_SHA2_PASSWORD: _AuthPlugin.ValueType  # 2
    """Use [Caching SHA-2 Pluggable Authentication](https://dev.mysql.com/doc/refman/8.0/en/caching-sha2-pluggable-authentication.html)."""
    SHA256_PASSWORD: _AuthPlugin.ValueType  # 3
    """Use [SHA-256 Pluggable Authentication](https://dev.mysql.com/doc/refman/8.0/en/sha256-pluggable-authentication.html)."""
    MYSQL_NO_LOGIN: _AuthPlugin.ValueType  # 4
    """Use [MYSQL_NO_LOGIN Pluggable Authentication](https://dev.mysql.com/doc/refman/8.0/en/no-login-pluggable-authentication.html)."""
    MDB_IAMPROXY_AUTH: _AuthPlugin.ValueType  # 5
    """Use [IAM Pluggable Authentication](https://yandex.cloud/en/docs/iam/concepts/authorization/)."""

class AuthPlugin(_AuthPlugin, metaclass=_AuthPluginEnumTypeWrapper): ...

AUTH_PLUGIN_UNSPECIFIED: AuthPlugin.ValueType  # 0
MYSQL_NATIVE_PASSWORD: AuthPlugin.ValueType  # 1
"""Use [Native Pluggable Authentication](https://dev.mysql.com/doc/refman/8.0/en/native-pluggable-authentication.html)."""
CACHING_SHA2_PASSWORD: AuthPlugin.ValueType  # 2
"""Use [Caching SHA-2 Pluggable Authentication](https://dev.mysql.com/doc/refman/8.0/en/caching-sha2-pluggable-authentication.html)."""
SHA256_PASSWORD: AuthPlugin.ValueType  # 3
"""Use [SHA-256 Pluggable Authentication](https://dev.mysql.com/doc/refman/8.0/en/sha256-pluggable-authentication.html)."""
MYSQL_NO_LOGIN: AuthPlugin.ValueType  # 4
"""Use [MYSQL_NO_LOGIN Pluggable Authentication](https://dev.mysql.com/doc/refman/8.0/en/no-login-pluggable-authentication.html)."""
MDB_IAMPROXY_AUTH: AuthPlugin.ValueType  # 5
"""Use [IAM Pluggable Authentication](https://yandex.cloud/en/docs/iam/concepts/authorization/)."""
global___AuthPlugin = AuthPlugin

@typing.final
class User(google.protobuf.message.Message):
    """An object that represents MySQL user.

    See [the documentation](/docs/managed-mysql/operations/cluster-users) for details.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    CLUSTER_ID_FIELD_NUMBER: builtins.int
    PERMISSIONS_FIELD_NUMBER: builtins.int
    GLOBAL_PERMISSIONS_FIELD_NUMBER: builtins.int
    CONNECTION_LIMITS_FIELD_NUMBER: builtins.int
    AUTHENTICATION_PLUGIN_FIELD_NUMBER: builtins.int
    CONNECTION_MANAGER_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the user."""
    cluster_id: builtins.str
    """ID of the cluster the user belongs to."""
    authentication_plugin: global___AuthPlugin.ValueType
    """User authentication plugin."""
    @property
    def permissions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Permission]:
        """Set of permissions granted to the user."""

    @property
    def global_permissions(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___GlobalPermission.ValueType]:
        """Set of global permissions to grant to the user."""

    @property
    def connection_limits(self) -> global___ConnectionLimits:
        """Set of user connection limits."""

    @property
    def connection_manager(self) -> global___ConnectionManager:
        """Connection Manager Connection and settings associated with user. Read only field."""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        cluster_id: builtins.str = ...,
        permissions: collections.abc.Iterable[global___Permission] | None = ...,
        global_permissions: collections.abc.Iterable[global___GlobalPermission.ValueType] | None = ...,
        connection_limits: global___ConnectionLimits | None = ...,
        authentication_plugin: global___AuthPlugin.ValueType = ...,
        connection_manager: global___ConnectionManager | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["connection_limits", b"connection_limits", "connection_manager", b"connection_manager"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["authentication_plugin", b"authentication_plugin", "cluster_id", b"cluster_id", "connection_limits", b"connection_limits", "connection_manager", b"connection_manager", "global_permissions", b"global_permissions", "name", b"name", "permissions", b"permissions"]) -> None: ...

global___User = User

@typing.final
class Permission(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Privilege:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _PrivilegeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Permission._Privilege.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        PRIVILEGE_UNSPECIFIED: Permission._Privilege.ValueType  # 0
        ALL_PRIVILEGES: Permission._Privilege.ValueType  # 1
        """All privileges that can be made available to the user."""
        ALTER: Permission._Privilege.ValueType  # 2
        """Altering tables."""
        ALTER_ROUTINE: Permission._Privilege.ValueType  # 3
        """Altering stored routines and functions."""
        CREATE: Permission._Privilege.ValueType  # 4
        """Creating tables or indexes."""
        CREATE_ROUTINE: Permission._Privilege.ValueType  # 5
        """Creating stored routines."""
        CREATE_TEMPORARY_TABLES: Permission._Privilege.ValueType  # 6
        """Creating temporary tables."""
        CREATE_VIEW: Permission._Privilege.ValueType  # 7
        """Creating views."""
        DELETE: Permission._Privilege.ValueType  # 8
        """Deleting tables."""
        DROP: Permission._Privilege.ValueType  # 9
        """Removing tables or views."""
        EVENT: Permission._Privilege.ValueType  # 10
        """Creating, altering, dropping, or displaying events for the Event Scheduler."""
        EXECUTE: Permission._Privilege.ValueType  # 11
        """Executing stored routines."""
        INDEX: Permission._Privilege.ValueType  # 12
        """Creating and removing indexes."""
        INSERT: Permission._Privilege.ValueType  # 13
        """Inserting rows into the database."""
        LOCK_TABLES: Permission._Privilege.ValueType  # 14
        """Using `LOCK TABLES` statement for tables available with `SELECT` privilege."""
        SELECT: Permission._Privilege.ValueType  # 15
        """Selecting rows from tables.

        Some `SELECT` statements can be allowed without the `SELECT` privilege. All statements that read column values require the `SELECT` privilege.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/privileges-provided.html#priv_select) for details.
        """
        SHOW_VIEW: Permission._Privilege.ValueType  # 16
        """Using the `SHOW CREATE VIEW` statement. Also needed for views used with `EXPLAIN`."""
        TRIGGER: Permission._Privilege.ValueType  # 17
        """Creating, removing, executing, or displaying triggers for a table."""
        UPDATE: Permission._Privilege.ValueType  # 18
        """Updating rows in the database."""
        REFERENCES: Permission._Privilege.ValueType  # 19
        """Creation of a foreign key constraint for the parent table."""

    class Privilege(_Privilege, metaclass=_PrivilegeEnumTypeWrapper): ...
    PRIVILEGE_UNSPECIFIED: Permission.Privilege.ValueType  # 0
    ALL_PRIVILEGES: Permission.Privilege.ValueType  # 1
    """All privileges that can be made available to the user."""
    ALTER: Permission.Privilege.ValueType  # 2
    """Altering tables."""
    ALTER_ROUTINE: Permission.Privilege.ValueType  # 3
    """Altering stored routines and functions."""
    CREATE: Permission.Privilege.ValueType  # 4
    """Creating tables or indexes."""
    CREATE_ROUTINE: Permission.Privilege.ValueType  # 5
    """Creating stored routines."""
    CREATE_TEMPORARY_TABLES: Permission.Privilege.ValueType  # 6
    """Creating temporary tables."""
    CREATE_VIEW: Permission.Privilege.ValueType  # 7
    """Creating views."""
    DELETE: Permission.Privilege.ValueType  # 8
    """Deleting tables."""
    DROP: Permission.Privilege.ValueType  # 9
    """Removing tables or views."""
    EVENT: Permission.Privilege.ValueType  # 10
    """Creating, altering, dropping, or displaying events for the Event Scheduler."""
    EXECUTE: Permission.Privilege.ValueType  # 11
    """Executing stored routines."""
    INDEX: Permission.Privilege.ValueType  # 12
    """Creating and removing indexes."""
    INSERT: Permission.Privilege.ValueType  # 13
    """Inserting rows into the database."""
    LOCK_TABLES: Permission.Privilege.ValueType  # 14
    """Using `LOCK TABLES` statement for tables available with `SELECT` privilege."""
    SELECT: Permission.Privilege.ValueType  # 15
    """Selecting rows from tables.

    Some `SELECT` statements can be allowed without the `SELECT` privilege. All statements that read column values require the `SELECT` privilege.

    See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/privileges-provided.html#priv_select) for details.
    """
    SHOW_VIEW: Permission.Privilege.ValueType  # 16
    """Using the `SHOW CREATE VIEW` statement. Also needed for views used with `EXPLAIN`."""
    TRIGGER: Permission.Privilege.ValueType  # 17
    """Creating, removing, executing, or displaying triggers for a table."""
    UPDATE: Permission.Privilege.ValueType  # 18
    """Updating rows in the database."""
    REFERENCES: Permission.Privilege.ValueType  # 19
    """Creation of a foreign key constraint for the parent table."""

    DATABASE_NAME_FIELD_NUMBER: builtins.int
    ROLES_FIELD_NUMBER: builtins.int
    database_name: builtins.str
    """Name of the database that the permission grants access to."""
    @property
    def roles(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___Permission.Privilege.ValueType]:
        """Roles granted to the user within the database.

        See [the documentation](/docs/managed-mysql/operations/grant) for details.
        """

    def __init__(
        self,
        *,
        database_name: builtins.str = ...,
        roles: collections.abc.Iterable[global___Permission.Privilege.ValueType] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["database_name", b"database_name", "roles", b"roles"]) -> None: ...

global___Permission = Permission

@typing.final
class ConnectionLimits(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MAX_QUESTIONS_PER_HOUR_FIELD_NUMBER: builtins.int
    MAX_UPDATES_PER_HOUR_FIELD_NUMBER: builtins.int
    MAX_CONNECTIONS_PER_HOUR_FIELD_NUMBER: builtins.int
    MAX_USER_CONNECTIONS_FIELD_NUMBER: builtins.int
    @property
    def max_questions_per_hour(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The maximum permitted number of user questions per hour."""

    @property
    def max_updates_per_hour(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The maximum permitted number of user updates per hour."""

    @property
    def max_connections_per_hour(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The maximum permitted number of simultaneous client connections per hour."""

    @property
    def max_user_connections(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The maximum number of simultaneous connections permitted to any given MySQL user account."""

    def __init__(
        self,
        *,
        max_questions_per_hour: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        max_updates_per_hour: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        max_connections_per_hour: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        max_user_connections: google.protobuf.wrappers_pb2.Int64Value | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["max_connections_per_hour", b"max_connections_per_hour", "max_questions_per_hour", b"max_questions_per_hour", "max_updates_per_hour", b"max_updates_per_hour", "max_user_connections", b"max_user_connections"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["max_connections_per_hour", b"max_connections_per_hour", "max_questions_per_hour", b"max_questions_per_hour", "max_updates_per_hour", b"max_updates_per_hour", "max_user_connections", b"max_user_connections"]) -> None: ...

global___ConnectionLimits = ConnectionLimits

@typing.final
class ConnectionManager(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONNECTION_ID_FIELD_NUMBER: builtins.int
    connection_id: builtins.str
    """ID of Connection Manager Connection"""
    def __init__(
        self,
        *,
        connection_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["connection_id", b"connection_id"]) -> None: ...

global___ConnectionManager = ConnectionManager

@typing.final
class UserSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    PASSWORD_FIELD_NUMBER: builtins.int
    PERMISSIONS_FIELD_NUMBER: builtins.int
    GLOBAL_PERMISSIONS_FIELD_NUMBER: builtins.int
    CONNECTION_LIMITS_FIELD_NUMBER: builtins.int
    AUTHENTICATION_PLUGIN_FIELD_NUMBER: builtins.int
    GENERATE_PASSWORD_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the user."""
    password: builtins.str
    """Password of the user."""
    authentication_plugin: global___AuthPlugin.ValueType
    """User authentication plugin."""
    @property
    def permissions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Permission]:
        """Set of permissions granted to the user to access specific databases.
        One permission per database.

        When a permission for a database is set, the user will have access to the database.
        """

    @property
    def global_permissions(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___GlobalPermission.ValueType]:
        """Set of global permissions to grant to the user."""

    @property
    def connection_limits(self) -> global___ConnectionLimits:
        """Set of user connection limits."""

    @property
    def generate_password(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Generate password using Connection Manager."""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        password: builtins.str = ...,
        permissions: collections.abc.Iterable[global___Permission] | None = ...,
        global_permissions: collections.abc.Iterable[global___GlobalPermission.ValueType] | None = ...,
        connection_limits: global___ConnectionLimits | None = ...,
        authentication_plugin: global___AuthPlugin.ValueType = ...,
        generate_password: google.protobuf.wrappers_pb2.BoolValue | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["connection_limits", b"connection_limits", "generate_password", b"generate_password"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["authentication_plugin", b"authentication_plugin", "connection_limits", b"connection_limits", "generate_password", b"generate_password", "global_permissions", b"global_permissions", "name", b"name", "password", b"password", "permissions", b"permissions"]) -> None: ...

global___UserSpec = UserSpec
