"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import google.protobuf.wrappers_pb2
import sys
import typing
import yandex.cloud.mdb.opensearch.v1.backup_pb2
import yandex.cloud.mdb.opensearch.v1.config.opensearch_pb2
import yandex.cloud.mdb.opensearch.v1.maintenance_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Cluster(google.protobuf.message.Message):
    """An OpenSearch cluster resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Environment:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EnvironmentEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Cluster._Environment.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        ENVIRONMENT_UNSPECIFIED: Cluster._Environment.ValueType  # 0
        PRODUCTION: Cluster._Environment.ValueType  # 1
        """Stable environment with a conservative update policy:
        only hotfixes are applied during regular maintenance.
        """
        PRESTABLE: Cluster._Environment.ValueType  # 2
        """Environment with more aggressive update policy: new versions
        are rolled out irrespective of backward compatibility.
        """

    class Environment(_Environment, metaclass=_EnvironmentEnumTypeWrapper): ...
    ENVIRONMENT_UNSPECIFIED: Cluster.Environment.ValueType  # 0
    PRODUCTION: Cluster.Environment.ValueType  # 1
    """Stable environment with a conservative update policy:
    only hotfixes are applied during regular maintenance.
    """
    PRESTABLE: Cluster.Environment.ValueType  # 2
    """Environment with more aggressive update policy: new versions
    are rolled out irrespective of backward compatibility.
    """

    class _Health:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _HealthEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Cluster._Health.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        HEALTH_UNKNOWN: Cluster._Health.ValueType  # 0
        """Health of the cluster is unknown ([Host.health] for every host in the cluster is UNKNOWN)."""
        ALIVE: Cluster._Health.ValueType  # 1
        """Cluster is working normally ([Host.health] for every host in the cluster is ALIVE)."""
        DEAD: Cluster._Health.ValueType  # 2
        """Cluster is inoperable ([Host.health] for every host in the cluster is DEAD)."""
        DEGRADED: Cluster._Health.ValueType  # 3
        """Cluster is working below capacity ([Host.health] for at least one host in the cluster is not ALIVE)."""

    class Health(_Health, metaclass=_HealthEnumTypeWrapper): ...
    HEALTH_UNKNOWN: Cluster.Health.ValueType  # 0
    """Health of the cluster is unknown ([Host.health] for every host in the cluster is UNKNOWN)."""
    ALIVE: Cluster.Health.ValueType  # 1
    """Cluster is working normally ([Host.health] for every host in the cluster is ALIVE)."""
    DEAD: Cluster.Health.ValueType  # 2
    """Cluster is inoperable ([Host.health] for every host in the cluster is DEAD)."""
    DEGRADED: Cluster.Health.ValueType  # 3
    """Cluster is working below capacity ([Host.health] for at least one host in the cluster is not ALIVE)."""

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Cluster._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNKNOWN: Cluster._Status.ValueType  # 0
        """Cluster state is unknown."""
        CREATING: Cluster._Status.ValueType  # 1
        """Cluster is being created."""
        RUNNING: Cluster._Status.ValueType  # 2
        """Cluster is running normally."""
        ERROR: Cluster._Status.ValueType  # 3
        """Cluster has encountered a problem and cannot operate."""
        UPDATING: Cluster._Status.ValueType  # 4
        """Cluster is being updated."""
        STOPPING: Cluster._Status.ValueType  # 5
        """Cluster is stopping."""
        STOPPED: Cluster._Status.ValueType  # 6
        """Cluster has stopped."""
        STARTING: Cluster._Status.ValueType  # 7
        """Cluster is starting."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper):
        """Current state of the cluster."""

    STATUS_UNKNOWN: Cluster.Status.ValueType  # 0
    """Cluster state is unknown."""
    CREATING: Cluster.Status.ValueType  # 1
    """Cluster is being created."""
    RUNNING: Cluster.Status.ValueType  # 2
    """Cluster is running normally."""
    ERROR: Cluster.Status.ValueType  # 3
    """Cluster has encountered a problem and cannot operate."""
    UPDATING: Cluster.Status.ValueType  # 4
    """Cluster is being updated."""
    STOPPING: Cluster.Status.ValueType  # 5
    """Cluster is stopping."""
    STOPPED: Cluster.Status.ValueType  # 6
    """Cluster has stopped."""
    STARTING: Cluster.Status.ValueType  # 7
    """Cluster is starting."""

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    ENVIRONMENT_FIELD_NUMBER: builtins.int
    MONITORING_FIELD_NUMBER: builtins.int
    CONFIG_FIELD_NUMBER: builtins.int
    NETWORK_ID_FIELD_NUMBER: builtins.int
    HEALTH_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    SECURITY_GROUP_IDS_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    MAINTENANCE_WINDOW_FIELD_NUMBER: builtins.int
    PLANNED_OPERATION_FIELD_NUMBER: builtins.int
    DISK_ENCRYPTION_KEY_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the OpenSearch cluster.
    This ID is assigned by the platform at the moment of cluster creation.
    """
    folder_id: builtins.str
    """ID of the folder that the OpenSearch cluster belongs to."""
    name: builtins.str
    """Name of the OpenSearch cluster.
    The name is unique within the folder. 1-63 characters long.
    """
    description: builtins.str
    """Description of the OpenSearch cluster. 0-256 characters long."""
    environment: global___Cluster.Environment.ValueType
    """Deployment environment of the OpenSearch cluster."""
    network_id: builtins.str
    """ID of the cloud network that the cluster belongs to."""
    health: global___Cluster.Health.ValueType
    """Aggregated cluster health."""
    status: global___Cluster.Status.ValueType
    """Current state of the cluster."""
    service_account_id: builtins.str
    """ID of the service account used to access Object Storage."""
    deletion_protection: builtins.bool
    """Determines whether the cluster is protected from being deleted."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Time when the cluster was created."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Custom labels for the OpenSearch cluster as `key:value` pairs.
        Maximum 64 labels per resource.
        """

    @property
    def monitoring(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Monitoring]:
        """Description of monitoring systems relevant to the OpenSearch cluster."""

    @property
    def config(self) -> global___ClusterConfig:
        """Configuration of the OpenSearch cluster."""

    @property
    def security_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """User security groups."""

    @property
    def maintenance_window(self) -> yandex.cloud.mdb.opensearch.v1.maintenance_pb2.MaintenanceWindow:
        """Cluster maintenance window. Should be defined by either one of the two options."""

    @property
    def planned_operation(self) -> yandex.cloud.mdb.opensearch.v1.maintenance_pb2.MaintenanceOperation:
        """Maintenance operation planned at nearest [maintenance_window]."""

    @property
    def disk_encryption_key_id(self) -> google.protobuf.wrappers_pb2.StringValue:
        """ID of the key to encrypt cluster disks."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        folder_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        environment: global___Cluster.Environment.ValueType = ...,
        monitoring: collections.abc.Iterable[global___Monitoring] | None = ...,
        config: global___ClusterConfig | None = ...,
        network_id: builtins.str = ...,
        health: global___Cluster.Health.ValueType = ...,
        status: global___Cluster.Status.ValueType = ...,
        security_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
        service_account_id: builtins.str = ...,
        deletion_protection: builtins.bool = ...,
        maintenance_window: yandex.cloud.mdb.opensearch.v1.maintenance_pb2.MaintenanceWindow | None = ...,
        planned_operation: yandex.cloud.mdb.opensearch.v1.maintenance_pb2.MaintenanceOperation | None = ...,
        disk_encryption_key_id: google.protobuf.wrappers_pb2.StringValue | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["config", b"config", "created_at", b"created_at", "disk_encryption_key_id", b"disk_encryption_key_id", "maintenance_window", b"maintenance_window", "planned_operation", b"planned_operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["config", b"config", "created_at", b"created_at", "deletion_protection", b"deletion_protection", "description", b"description", "disk_encryption_key_id", b"disk_encryption_key_id", "environment", b"environment", "folder_id", b"folder_id", "health", b"health", "id", b"id", "labels", b"labels", "maintenance_window", b"maintenance_window", "monitoring", b"monitoring", "name", b"name", "network_id", b"network_id", "planned_operation", b"planned_operation", "security_group_ids", b"security_group_ids", "service_account_id", b"service_account_id", "status", b"status"]) -> None: ...

global___Cluster = Cluster

@typing.final
class Monitoring(google.protobuf.message.Message):
    """Monitoring system metadata."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LINK_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the monitoring system."""
    description: builtins.str
    """Description of the monitoring system."""
    link: builtins.str
    """Link to the monitoring system charts for the OpenSearch cluster."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        description: builtins.str = ...,
        link: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "link", b"link", "name", b"name"]) -> None: ...

global___Monitoring = Monitoring

@typing.final
class ClusterConfig(google.protobuf.message.Message):
    """The OpenSearch cluster configuration."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VERSION_FIELD_NUMBER: builtins.int
    OPENSEARCH_FIELD_NUMBER: builtins.int
    DASHBOARDS_FIELD_NUMBER: builtins.int
    ACCESS_FIELD_NUMBER: builtins.int
    SNAPSHOT_MANAGEMENT_FIELD_NUMBER: builtins.int
    version: builtins.str
    """Version of the OpenSearch server software."""
    @property
    def opensearch(self) -> global___OpenSearch:
        """OpenSearch configuration."""

    @property
    def dashboards(self) -> global___Dashboards:
        """Dashboards configuration."""

    @property
    def access(self) -> global___Access:
        """Access policy for external services."""

    @property
    def snapshot_management(self) -> yandex.cloud.mdb.opensearch.v1.backup_pb2.SnapshotManagement:
        """Snapshot management configuration"""

    def __init__(
        self,
        *,
        version: builtins.str = ...,
        opensearch: global___OpenSearch | None = ...,
        dashboards: global___Dashboards | None = ...,
        access: global___Access | None = ...,
        snapshot_management: yandex.cloud.mdb.opensearch.v1.backup_pb2.SnapshotManagement | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["access", b"access", "dashboards", b"dashboards", "opensearch", b"opensearch", "snapshot_management", b"snapshot_management"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["access", b"access", "dashboards", b"dashboards", "opensearch", b"opensearch", "snapshot_management", b"snapshot_management", "version", b"version"]) -> None: ...

global___ClusterConfig = ClusterConfig

@typing.final
class OpenSearch(google.protobuf.message.Message):
    """The OpenSearch host group type configuration."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _GroupRole:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _GroupRoleEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[OpenSearch._GroupRole.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        GROUP_ROLE_UNSPECIFIED: OpenSearch._GroupRole.ValueType  # 0
        DATA: OpenSearch._GroupRole.ValueType  # 1
        MANAGER: OpenSearch._GroupRole.ValueType  # 2

    class GroupRole(_GroupRole, metaclass=_GroupRoleEnumTypeWrapper): ...
    GROUP_ROLE_UNSPECIFIED: OpenSearch.GroupRole.ValueType  # 0
    DATA: OpenSearch.GroupRole.ValueType  # 1
    MANAGER: OpenSearch.GroupRole.ValueType  # 2

    @typing.final
    class NodeGroup(google.protobuf.message.Message):
        """Configuration of the host group."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NAME_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        HOSTS_COUNT_FIELD_NUMBER: builtins.int
        ZONE_IDS_FIELD_NUMBER: builtins.int
        SUBNET_IDS_FIELD_NUMBER: builtins.int
        ASSIGN_PUBLIC_IP_FIELD_NUMBER: builtins.int
        ROLES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        name: builtins.str
        """Name of the group. Must be 1-63 characters long."""
        hosts_count: builtins.int
        """Number of hosts in the group."""
        assign_public_ip: builtins.bool
        """Determines whether a public IP is assigned to the hosts in the group."""
        @property
        def resources(self) -> global___Resources:
            """Resources allocated to the hosts."""

        @property
        def zone_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
            """IDs of the availability zones the hosts belong to."""

        @property
        def subnet_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
            """IDs of the subnets that the hosts belong to."""

        @property
        def roles(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___OpenSearch.GroupRole.ValueType]:
            """Roles of the host group."""

        @property
        def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            name: builtins.str = ...,
            resources: global___Resources | None = ...,
            hosts_count: builtins.int = ...,
            zone_ids: collections.abc.Iterable[builtins.str] | None = ...,
            subnet_ids: collections.abc.Iterable[builtins.str] | None = ...,
            assign_public_ip: builtins.bool = ...,
            roles: collections.abc.Iterable[global___OpenSearch.GroupRole.ValueType] | None = ...,
            disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["assign_public_ip", b"assign_public_ip", "disk_size_autoscaling", b"disk_size_autoscaling", "hosts_count", b"hosts_count", "name", b"name", "resources", b"resources", "roles", b"roles", "subnet_ids", b"subnet_ids", "zone_ids", b"zone_ids"]) -> None: ...

    PLUGINS_FIELD_NUMBER: builtins.int
    NODE_GROUPS_FIELD_NUMBER: builtins.int
    OPENSEARCH_CONFIG_SET_2_FIELD_NUMBER: builtins.int
    KEYSTORE_SETTINGS_FIELD_NUMBER: builtins.int
    @property
    def plugins(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Names of the cluster plugins."""

    @property
    def node_groups(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___OpenSearch.NodeGroup]:
        """Host groups of the OpenSearch type."""

    @property
    def opensearch_config_set_2(self) -> yandex.cloud.mdb.opensearch.v1.config.opensearch_pb2.OpenSearchConfigSet2: ...
    @property
    def keystore_settings(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Keystore entries names."""

    def __init__(
        self,
        *,
        plugins: collections.abc.Iterable[builtins.str] | None = ...,
        node_groups: collections.abc.Iterable[global___OpenSearch.NodeGroup] | None = ...,
        opensearch_config_set_2: yandex.cloud.mdb.opensearch.v1.config.opensearch_pb2.OpenSearchConfigSet2 | None = ...,
        keystore_settings: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["config", b"config", "opensearch_config_set_2", b"opensearch_config_set_2"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["config", b"config", "keystore_settings", b"keystore_settings", "node_groups", b"node_groups", "opensearch_config_set_2", b"opensearch_config_set_2", "plugins", b"plugins"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["config", b"config"]) -> typing.Literal["opensearch_config_set_2"] | None: ...

global___OpenSearch = OpenSearch

@typing.final
class Dashboards(google.protobuf.message.Message):
    """The Dashboards host group type configuration."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class NodeGroup(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NAME_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        HOSTS_COUNT_FIELD_NUMBER: builtins.int
        ZONE_IDS_FIELD_NUMBER: builtins.int
        SUBNET_IDS_FIELD_NUMBER: builtins.int
        ASSIGN_PUBLIC_IP_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        name: builtins.str
        """Name of the group. 1-63 characters long."""
        hosts_count: builtins.int
        """Number of hosts in the group."""
        assign_public_ip: builtins.bool
        """Determines whether a public IP is assigned to the hosts in the group."""
        @property
        def resources(self) -> global___Resources:
            """Resources allocated to the hosts."""

        @property
        def zone_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
            """IDs of the availability zones the hosts belong to."""

        @property
        def subnet_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
            """IDs of the subnets that the hosts belong to."""

        @property
        def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            name: builtins.str = ...,
            resources: global___Resources | None = ...,
            hosts_count: builtins.int = ...,
            zone_ids: collections.abc.Iterable[builtins.str] | None = ...,
            subnet_ids: collections.abc.Iterable[builtins.str] | None = ...,
            assign_public_ip: builtins.bool = ...,
            disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["assign_public_ip", b"assign_public_ip", "disk_size_autoscaling", b"disk_size_autoscaling", "hosts_count", b"hosts_count", "name", b"name", "resources", b"resources", "subnet_ids", b"subnet_ids", "zone_ids", b"zone_ids"]) -> None: ...

    NODE_GROUPS_FIELD_NUMBER: builtins.int
    @property
    def node_groups(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Dashboards.NodeGroup]:
        """Host groups of the Dashboards type."""

    def __init__(
        self,
        *,
        node_groups: collections.abc.Iterable[global___Dashboards.NodeGroup] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["node_groups", b"node_groups"]) -> None: ...

global___Dashboards = Dashboards

@typing.final
class Resources(google.protobuf.message.Message):
    """A list of computational resources allocated to a host."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOURCE_PRESET_ID_FIELD_NUMBER: builtins.int
    DISK_SIZE_FIELD_NUMBER: builtins.int
    DISK_TYPE_ID_FIELD_NUMBER: builtins.int
    resource_preset_id: builtins.str
    """ID of the preset for computational resources allocated to a host."""
    disk_size: builtins.int
    """Volume of the storage used by the host, in bytes."""
    disk_type_id: builtins.str
    """Type of the storage used by the host: `network-hdd`, `network-ssd` or `local-ssd`."""
    def __init__(
        self,
        *,
        resource_preset_id: builtins.str = ...,
        disk_size: builtins.int = ...,
        disk_type_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["disk_size", b"disk_size", "disk_type_id", b"disk_type_id", "resource_preset_id", b"resource_preset_id"]) -> None: ...

global___Resources = Resources

@typing.final
class Host(google.protobuf.message.Message):
    """An OpenSearch cluster host resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Health:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _HealthEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Host._Health.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNKNOWN: Host._Health.ValueType  # 0
        """Health of the host is unknown. Default value."""
        ALIVE: Host._Health.ValueType  # 1
        """The host is performing all its functions normally."""
        DEAD: Host._Health.ValueType  # 2
        """The host is inoperable and cannot perform any of its essential functions."""
        DEGRADED: Host._Health.ValueType  # 3
        """The host is working below capacity or not fully functional."""

    class Health(_Health, metaclass=_HealthEnumTypeWrapper): ...
    UNKNOWN: Host.Health.ValueType  # 0
    """Health of the host is unknown. Default value."""
    ALIVE: Host.Health.ValueType  # 1
    """The host is performing all its functions normally."""
    DEAD: Host.Health.ValueType  # 2
    """The host is inoperable and cannot perform any of its essential functions."""
    DEGRADED: Host.Health.ValueType  # 3
    """The host is working below capacity or not fully functional."""

    class _Type:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Host._Type.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        TYPE_UNSPECIFIED: Host._Type.ValueType  # 0
        """Type of the host is unspecified. Default value."""
        OPENSEARCH: Host._Type.ValueType  # 1
        """An OpenSearch type host."""
        DASHBOARDS: Host._Type.ValueType  # 2
        """A Dashboards type host."""

    class Type(_Type, metaclass=_TypeEnumTypeWrapper): ...
    TYPE_UNSPECIFIED: Host.Type.ValueType  # 0
    """Type of the host is unspecified. Default value."""
    OPENSEARCH: Host.Type.ValueType  # 1
    """An OpenSearch type host."""
    DASHBOARDS: Host.Type.ValueType  # 2
    """A Dashboards type host."""

    @typing.final
    class CPUMetric(google.protobuf.message.Message):
        """CPU usage of the host."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        TIMESTAMP_FIELD_NUMBER: builtins.int
        USED_FIELD_NUMBER: builtins.int
        timestamp: builtins.int
        """Time of the record."""
        used: builtins.float
        """Percentage of the CPU used."""
        def __init__(
            self,
            *,
            timestamp: builtins.int = ...,
            used: builtins.float = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["timestamp", b"timestamp", "used", b"used"]) -> None: ...

    @typing.final
    class MemoryMetric(google.protobuf.message.Message):
        """RAM usage of the host."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        TIMESTAMP_FIELD_NUMBER: builtins.int
        USED_FIELD_NUMBER: builtins.int
        TOTAL_FIELD_NUMBER: builtins.int
        timestamp: builtins.int
        """Time of the record."""
        used: builtins.int
        """The amount of RAM used, in bytes."""
        total: builtins.int
        """Total amount of RAM allocated to the host."""
        def __init__(
            self,
            *,
            timestamp: builtins.int = ...,
            used: builtins.int = ...,
            total: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["timestamp", b"timestamp", "total", b"total", "used", b"used"]) -> None: ...

    @typing.final
    class DiskMetric(google.protobuf.message.Message):
        """Disk usage of the host."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        TIMESTAMP_FIELD_NUMBER: builtins.int
        USED_FIELD_NUMBER: builtins.int
        TOTAL_FIELD_NUMBER: builtins.int
        timestamp: builtins.int
        """Time of the record."""
        used: builtins.int
        """The amount of disk space used, in bytes."""
        total: builtins.int
        """Total amount of disk space allocated to the host."""
        def __init__(
            self,
            *,
            timestamp: builtins.int = ...,
            used: builtins.int = ...,
            total: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["timestamp", b"timestamp", "total", b"total", "used", b"used"]) -> None: ...

    @typing.final
    class SystemMetrics(google.protobuf.message.Message):
        """Resources used by the host."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CPU_FIELD_NUMBER: builtins.int
        MEMORY_FIELD_NUMBER: builtins.int
        DISK_FIELD_NUMBER: builtins.int
        @property
        def cpu(self) -> global___Host.CPUMetric:
            """CPU usage of the host."""

        @property
        def memory(self) -> global___Host.MemoryMetric:
            """RAM usage of the host."""

        @property
        def disk(self) -> global___Host.DiskMetric:
            """Disk usage of the host."""

        def __init__(
            self,
            *,
            cpu: global___Host.CPUMetric | None = ...,
            memory: global___Host.MemoryMetric | None = ...,
            disk: global___Host.DiskMetric | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["cpu", b"cpu", "disk", b"disk", "memory", b"memory"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["cpu", b"cpu", "disk", b"disk", "memory", b"memory"]) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    CLUSTER_ID_FIELD_NUMBER: builtins.int
    ZONE_ID_FIELD_NUMBER: builtins.int
    RESOURCES_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    HEALTH_FIELD_NUMBER: builtins.int
    SUBNET_ID_FIELD_NUMBER: builtins.int
    ASSIGN_PUBLIC_IP_FIELD_NUMBER: builtins.int
    SYSTEM_FIELD_NUMBER: builtins.int
    NODE_GROUP_FIELD_NUMBER: builtins.int
    ROLES_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Required. Name of the OpenSearch host.

    The host name is assigned by the platform at creation time and cannot be changed.

    The name is unique across all MDB hosts that exist on the platform, as it defines the FQDN of the host.
    """
    cluster_id: builtins.str
    """Required. ID of the OpenSearch cluster. The ID is assigned by the platform at creation time."""
    zone_id: builtins.str
    """ID of the availability zone the OpenSearch host belongs to."""
    type: global___Host.Type.ValueType
    """Type of the host. If the field has default value, it is not returned in the response."""
    health: global___Host.Health.ValueType
    """Aggregated health of the host. If the field has default value, it is not returned in the response."""
    subnet_id: builtins.str
    """ID of the subnet that the host belongs to."""
    assign_public_ip: builtins.bool
    """Determines whether a public IP is assigned to the host."""
    node_group: builtins.str
    """Name of the host group that the host belongs to."""
    @property
    def resources(self) -> global___Resources:
        """Resources allocated to the OpenSearch host."""

    @property
    def system(self) -> global___Host.SystemMetrics:
        """Resources used by the host."""

    @property
    def roles(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___OpenSearch.GroupRole.ValueType]:
        """Roles of the host."""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        cluster_id: builtins.str = ...,
        zone_id: builtins.str = ...,
        resources: global___Resources | None = ...,
        type: global___Host.Type.ValueType = ...,
        health: global___Host.Health.ValueType = ...,
        subnet_id: builtins.str = ...,
        assign_public_ip: builtins.bool = ...,
        system: global___Host.SystemMetrics | None = ...,
        node_group: builtins.str = ...,
        roles: collections.abc.Iterable[global___OpenSearch.GroupRole.ValueType] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["resources", b"resources", "system", b"system"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["assign_public_ip", b"assign_public_ip", "cluster_id", b"cluster_id", "health", b"health", "name", b"name", "node_group", b"node_group", "resources", b"resources", "roles", b"roles", "subnet_id", b"subnet_id", "system", b"system", "type", b"type", "zone_id", b"zone_id"]) -> None: ...

global___Host = Host

@typing.final
class Access(google.protobuf.message.Message):
    """Access policy for external services."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATA_TRANSFER_FIELD_NUMBER: builtins.int
    SERVERLESS_FIELD_NUMBER: builtins.int
    data_transfer: builtins.bool
    """Determines whether the access to Data Transfer is allowed."""
    serverless: builtins.bool
    """Determines whether the access to Serverless is allowed."""
    def __init__(
        self,
        *,
        data_transfer: builtins.bool = ...,
        serverless: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["data_transfer", b"data_transfer", "serverless", b"serverless"]) -> None: ...

global___Access = Access

@typing.final
class DiskSizeAutoscaling(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PLANNED_USAGE_THRESHOLD_FIELD_NUMBER: builtins.int
    EMERGENCY_USAGE_THRESHOLD_FIELD_NUMBER: builtins.int
    DISK_SIZE_LIMIT_FIELD_NUMBER: builtins.int
    planned_usage_threshold: builtins.int
    """Amount of used storage for automatic disk scaling in the maintenance window, 0 means disabled, in percent."""
    emergency_usage_threshold: builtins.int
    """Amount of used storage for immediately  automatic disk scaling, 0 means disabled, in percent."""
    disk_size_limit: builtins.int
    """Limit on how large the storage for database instances can automatically grow, in bytes."""
    def __init__(
        self,
        *,
        planned_usage_threshold: builtins.int = ...,
        emergency_usage_threshold: builtins.int = ...,
        disk_size_limit: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["disk_size_limit", b"disk_size_limit", "emergency_usage_threshold", b"emergency_usage_threshold", "planned_usage_threshold", b"planned_usage_threshold"]) -> None: ...

global___DiskSizeAutoscaling = DiskSizeAutoscaling
