"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import google.protobuf.wrappers_pb2
import sys
import typing
import yandex.cloud.mdb.opensearch.v1.auth_pb2
import yandex.cloud.mdb.opensearch.v1.backup_pb2
import yandex.cloud.mdb.opensearch.v1.cluster_pb2
import yandex.cloud.mdb.opensearch.v1.config.opensearch_pb2
import yandex.cloud.mdb.opensearch.v1.maintenance_pb2
import yandex.cloud.mdb.operationlog.v1.operation_log_pb2
import yandex.cloud.operation.operation_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the OpenSearch cluster to return.

    To get the cluster ID, use a [ClusterService.List] request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___GetClusterRequest = GetClusterRequest

@typing.final
class ListClustersRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to list OpenSearch clusters in.

    To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return.

    If the number of available results is larger than [page_size], the service returns
    a [ListClustersResponse.next_page_token] that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the [ListClustersResponse.next_page_token]
    returned by the previous list request.
    """
    filter: builtins.str
    """A filter expression that filters resources listed in the response.

    The expression must specify:

    1. The field name. Currently you can only use filtering with the [Cluster.name] field.

    2. An `=` operator.

    3. The value in double quotes (`"`). Must be 1-63 characters long and match the regular expression `[a-zA-Z0-9_-]+`.
    """
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "folder_id", b"folder_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListClustersRequest = ListClustersRequest

@typing.final
class ListClustersResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTERS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests.

    If the number of results is larger than [ListClustersRequest.page_size], use the [next_page_token] as the value
    for the [ListClustersRequest.page_token] parameter in the next list request.

    Each subsequent list request has its own [next_page_token] to continue paging through the results.
    """
    @property
    def clusters(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.mdb.opensearch.v1.cluster_pb2.Cluster]:
        """List of OpenSearch clusters."""

    def __init__(
        self,
        *,
        clusters: collections.abc.Iterable[yandex.cloud.mdb.opensearch.v1.cluster_pb2.Cluster] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clusters", b"clusters", "next_page_token", b"next_page_token"]) -> None: ...

global___ListClustersResponse = ListClustersResponse

@typing.final
class CreateClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    ENVIRONMENT_FIELD_NUMBER: builtins.int
    CONFIG_SPEC_FIELD_NUMBER: builtins.int
    NETWORK_ID_FIELD_NUMBER: builtins.int
    SECURITY_GROUP_IDS_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    MAINTENANCE_WINDOW_FIELD_NUMBER: builtins.int
    DISK_ENCRYPTION_KEY_ID_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to create the OpenSearch cluster in."""
    name: builtins.str
    """Name of the OpenSearch cluster. The name must be unique within the folder."""
    description: builtins.str
    """Description of the OpenSearch cluster."""
    environment: yandex.cloud.mdb.opensearch.v1.cluster_pb2.Cluster.Environment.ValueType
    """Deployment environment of the OpenSearch cluster."""
    network_id: builtins.str
    """ID of the network to create the cluster in."""
    service_account_id: builtins.str
    """ID of the service account used to access Object Storage."""
    deletion_protection: builtins.bool
    """Determines whether the cluster is protected from being deleted."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Custom labels for the OpenSearch cluster as `key:value` pairs.
        For example, `"project": "mvp"` or `"source": "dictionary"`.
        """

    @property
    def config_spec(self) -> global___ConfigCreateSpec:
        """OpenSearch cluster configuration."""

    @property
    def security_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """User security groups."""

    @property
    def maintenance_window(self) -> yandex.cloud.mdb.opensearch.v1.maintenance_pb2.MaintenanceWindow:
        """Cluster maintenance window. Should be defined by either one of the two options."""

    @property
    def disk_encryption_key_id(self) -> google.protobuf.wrappers_pb2.StringValue:
        """ID of the key to encrypt cluster disks."""

    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        environment: yandex.cloud.mdb.opensearch.v1.cluster_pb2.Cluster.Environment.ValueType = ...,
        config_spec: global___ConfigCreateSpec | None = ...,
        network_id: builtins.str = ...,
        security_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
        service_account_id: builtins.str = ...,
        deletion_protection: builtins.bool = ...,
        maintenance_window: yandex.cloud.mdb.opensearch.v1.maintenance_pb2.MaintenanceWindow | None = ...,
        disk_encryption_key_id: google.protobuf.wrappers_pb2.StringValue | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["config_spec", b"config_spec", "disk_encryption_key_id", b"disk_encryption_key_id", "maintenance_window", b"maintenance_window"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["config_spec", b"config_spec", "deletion_protection", b"deletion_protection", "description", b"description", "disk_encryption_key_id", b"disk_encryption_key_id", "environment", b"environment", "folder_id", b"folder_id", "labels", b"labels", "maintenance_window", b"maintenance_window", "name", b"name", "network_id", b"network_id", "security_group_ids", b"security_group_ids", "service_account_id", b"service_account_id"]) -> None: ...

global___CreateClusterRequest = CreateClusterRequest

@typing.final
class CreateClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    OPERATION_LOG_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the OpenSearch cluster that is being created."""
    @property
    def operation_log(self) -> yandex.cloud.mdb.operationlog.v1.operation_log_pb2.OperationLog:
        """Log of actions during operation"""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        operation_log: yandex.cloud.mdb.operationlog.v1.operation_log_pb2.OperationLog | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["operation_log", b"operation_log"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "operation_log", b"operation_log"]) -> None: ...

global___CreateClusterMetadata = CreateClusterMetadata

@typing.final
class UpdateClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    CONFIG_SPEC_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    SECURITY_GROUP_IDS_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    MAINTENANCE_WINDOW_FIELD_NUMBER: builtins.int
    NETWORK_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the OpenSearch cluster resource to update.
    To get the OpenSearch cluster ID, use a [ClusterService.List] request.
    """
    description: builtins.str
    """New description of the OpenSearch cluster."""
    name: builtins.str
    """New name for the cluster. The name must be unique within the folder."""
    service_account_id: builtins.str
    """ID of the service account used to access Object Storage."""
    deletion_protection: builtins.bool
    """Determines whether the cluster is protected from being deleted."""
    network_id: builtins.str
    """ID of the network to move the cluster to."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which fields of the OpenSearch cluster resource should be updated."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Custom labels for the OpenSearch cluster as `key:value` pairs.
        For example, `"project": "mvp"` or `"source": "dictionary"`.

        The new set of labels completely replaces the old one. To add a label, request the current
        set with the [ClusterService.Get] method, then send an [ClusterService.Update] request with the new label added to the set.
        """

    @property
    def config_spec(self) -> global___ConfigUpdateSpec:
        """New cluster configuration"""

    @property
    def security_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """User security groups"""

    @property
    def maintenance_window(self) -> yandex.cloud.mdb.opensearch.v1.maintenance_pb2.MaintenanceWindow:
        """Cluster maintenance window. Should be defined by either one of the two options."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        config_spec: global___ConfigUpdateSpec | None = ...,
        name: builtins.str = ...,
        security_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
        service_account_id: builtins.str = ...,
        deletion_protection: builtins.bool = ...,
        maintenance_window: yandex.cloud.mdb.opensearch.v1.maintenance_pb2.MaintenanceWindow | None = ...,
        network_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["config_spec", b"config_spec", "maintenance_window", b"maintenance_window", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "config_spec", b"config_spec", "deletion_protection", b"deletion_protection", "description", b"description", "labels", b"labels", "maintenance_window", b"maintenance_window", "name", b"name", "network_id", b"network_id", "security_group_ids", b"security_group_ids", "service_account_id", b"service_account_id", "update_mask", b"update_mask"]) -> None: ...

global___UpdateClusterRequest = UpdateClusterRequest

@typing.final
class UpdateClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    OPERATION_LOG_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the OpenSearch cluster resource that is being updated."""
    @property
    def operation_log(self) -> yandex.cloud.mdb.operationlog.v1.operation_log_pb2.OperationLog:
        """Log of actions during operation"""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        operation_log: yandex.cloud.mdb.operationlog.v1.operation_log_pb2.OperationLog | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["operation_log", b"operation_log"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "operation_log", b"operation_log"]) -> None: ...

global___UpdateClusterMetadata = UpdateClusterMetadata

@typing.final
class DeleteClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the OpenSearch cluster to delete.
    To get the OpenSearch cluster ID, use a [ClusterService.List] request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___DeleteClusterRequest = DeleteClusterRequest

@typing.final
class DeleteClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the OpenSearch cluster that is being deleted."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___DeleteClusterMetadata = DeleteClusterMetadata

@typing.final
class ListClusterLogsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _ServiceType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ServiceTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ListClusterLogsRequest._ServiceType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        SERVICE_TYPE_UNSPECIFIED: ListClusterLogsRequest._ServiceType.ValueType  # 0
        """Type is not specified."""
        OPENSEARCH: ListClusterLogsRequest._ServiceType.ValueType  # 1
        """OpenSearch logs."""
        DASHBOARDS: ListClusterLogsRequest._ServiceType.ValueType  # 2
        """Dashboards logs."""

    class ServiceType(_ServiceType, metaclass=_ServiceTypeEnumTypeWrapper): ...
    SERVICE_TYPE_UNSPECIFIED: ListClusterLogsRequest.ServiceType.ValueType  # 0
    """Type is not specified."""
    OPENSEARCH: ListClusterLogsRequest.ServiceType.ValueType  # 1
    """OpenSearch logs."""
    DASHBOARDS: ListClusterLogsRequest.ServiceType.ValueType  # 2
    """Dashboards logs."""

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    COLUMN_FILTER_FIELD_NUMBER: builtins.int
    FROM_TIME_FIELD_NUMBER: builtins.int
    TO_TIME_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    ALWAYS_NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    SERVICE_TYPE_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the OpenSearch cluster to request logs for.

    To get the OpenSearch cluster ID use a [ClusterService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return.

    If the number of available results is larger than [page_size], the service returns a [ListClusterLogsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the
    [ListClusterLogsResponse.next_page_token] returned by the previous list request.
    """
    always_next_page_token: builtins.bool
    """The service always returns a [ListClusterLogsResponse.next_page_token], even if the current page is empty."""
    filter: builtins.str
    """A filter expression that filters resources listed in the response.

    The expression must specify:

    1. A field name. Currently filtering can be applied to the [LogRecord.logs.message.hostname] field.

    2. A conditional operator. Can be either `=` or `!=` for single values, `IN` or `NOT IN` for lists of values.

    3. A value. Must be 1-63 characters long and match the regular expression `^[a-z0-9.-]{1,61}$`.

    Examples of a filter:
    * `message.hostname='node1.db.cloud.yandex.net'`;
    * `message.error_severity IN ("ERROR", "FATAL", "PANIC") AND message.hostname = "node1.db.cloud.yandex.net"`.
    """
    service_type: global___ListClusterLogsRequest.ServiceType.ValueType
    """Type of the service to request logs about."""
    @property
    def column_filter(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Columns from log table to request.
        If no columns are specified, entire log records are returned.
        """

    @property
    def from_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Start timestamp for the logs request."""

    @property
    def to_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """End timestamp for the logs request."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        column_filter: collections.abc.Iterable[builtins.str] | None = ...,
        from_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        to_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        always_next_page_token: builtins.bool = ...,
        filter: builtins.str = ...,
        service_type: global___ListClusterLogsRequest.ServiceType.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["from_time", b"from_time", "to_time", b"to_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["always_next_page_token", b"always_next_page_token", "cluster_id", b"cluster_id", "column_filter", b"column_filter", "filter", b"filter", "from_time", b"from_time", "page_size", b"page_size", "page_token", b"page_token", "service_type", b"service_type", "to_time", b"to_time"]) -> None: ...

global___ListClusterLogsRequest = ListClusterLogsRequest

@typing.final
class LogRecord(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MessageEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    TIMESTAMP_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    @property
    def timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Time when the log was recorded."""

    @property
    def message(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Contents of the log record."""

    def __init__(
        self,
        *,
        timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        message: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["timestamp", b"timestamp"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["message", b"message", "timestamp", b"timestamp"]) -> None: ...

global___LogRecord = LogRecord

@typing.final
class ListClusterLogsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOGS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests.

    If the number of results is larger than [ListClusterLogsRequest.page_size], use the [next_page_token] as the value
    for the [ListClusterLogsRequest.page_token] query parameter in the next list request.

    Each subsequent list request has its own [next_page_token] to continue paging through the results.

    This value is interchangeable with the [StreamLogRecord.next_record_token] from [StreamLogs] method.
    """
    @property
    def logs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___LogRecord]:
        """Requested log records."""

    def __init__(
        self,
        *,
        logs: collections.abc.Iterable[global___LogRecord] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["logs", b"logs", "next_page_token", b"next_page_token"]) -> None: ...

global___ListClusterLogsResponse = ListClusterLogsResponse

@typing.final
class StreamLogRecord(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RECORD_FIELD_NUMBER: builtins.int
    NEXT_RECORD_TOKEN_FIELD_NUMBER: builtins.int
    next_record_token: builtins.str
    """This token allows you to continue streaming logs starting from the exact same record.

    To do that, specify value of [next_record_token] as the value for [StreamLogs.record_token] parameter in the next [StreamLogs] request.

    This value is interchangeable with [ListLogs.next_page_token] from [ListLogs] method.
    """
    @property
    def record(self) -> global___LogRecord:
        """One of the requested log records."""

    def __init__(
        self,
        *,
        record: global___LogRecord | None = ...,
        next_record_token: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["record", b"record"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["next_record_token", b"next_record_token", "record", b"record"]) -> None: ...

global___StreamLogRecord = StreamLogRecord

@typing.final
class StreamClusterLogsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _ServiceType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ServiceTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[StreamClusterLogsRequest._ServiceType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        SERVICE_TYPE_UNSPECIFIED: StreamClusterLogsRequest._ServiceType.ValueType  # 0
        """Type is not specified."""
        OPENSEARCH: StreamClusterLogsRequest._ServiceType.ValueType  # 1
        """OpenSearch logs."""
        DASHBOARDS: StreamClusterLogsRequest._ServiceType.ValueType  # 2
        """Dashboards logs."""

    class ServiceType(_ServiceType, metaclass=_ServiceTypeEnumTypeWrapper): ...
    SERVICE_TYPE_UNSPECIFIED: StreamClusterLogsRequest.ServiceType.ValueType  # 0
    """Type is not specified."""
    OPENSEARCH: StreamClusterLogsRequest.ServiceType.ValueType  # 1
    """OpenSearch logs."""
    DASHBOARDS: StreamClusterLogsRequest.ServiceType.ValueType  # 2
    """Dashboards logs."""

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    COLUMN_FILTER_FIELD_NUMBER: builtins.int
    FROM_TIME_FIELD_NUMBER: builtins.int
    TO_TIME_FIELD_NUMBER: builtins.int
    RECORD_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    SERVICE_TYPE_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the OpenSearch cluster."""
    record_token: builtins.str
    """Record token. Set `record_token` to the `next_record_token` returned by the previous [StreamLogs]
    request to start streaming from the next log record.
    """
    filter: builtins.str
    """A filter expression that filters resources listed in the response.

    The expression must specify:

    1. A field name. Currently filtering can be applied to the [LogRecord.logs.message.hostname] field.

    2. A conditional operator. Can be either `=` or `!=` for single values, `IN` or `NOT IN` for lists of values.

    3. A value. Must be 1-63 characters long and match the regular expression `^[a-z0-9.-]{1,61}$`.

    Examples of a filter:
    * `message.hostname='node1.db.cloud.yandex.net'`;
    * `message.error_severity IN ("ERROR", "FATAL", "PANIC") AND message.hostname = "node1.db.cloud.yandex.net"`.
    """
    service_type: global___StreamClusterLogsRequest.ServiceType.ValueType
    """Type of the service to request logs about."""
    @property
    def column_filter(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Columns from log table to get in the response.
        If no columns are specified, entire log records are returned.
        """

    @property
    def from_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Start timestamp for the logs request."""

    @property
    def to_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """End timestamp for the logs request.

        If this field is not set, all existing logs are sent as well as the new ones as they appear.

        In essence it has `tail -f` semantics.
        """

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        column_filter: collections.abc.Iterable[builtins.str] | None = ...,
        from_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        to_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        record_token: builtins.str = ...,
        filter: builtins.str = ...,
        service_type: global___StreamClusterLogsRequest.ServiceType.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["from_time", b"from_time", "to_time", b"to_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "column_filter", b"column_filter", "filter", b"filter", "from_time", b"from_time", "record_token", b"record_token", "service_type", b"service_type", "to_time", b"to_time"]) -> None: ...

global___StreamClusterLogsRequest = StreamClusterLogsRequest

@typing.final
class ListClusterOperationsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the OpenSearch cluster resource to list operations for."""
    page_size: builtins.int
    """The maximum number of results per page to return.

    If the number of available results is larger than [page_size], the service returns
    a [ListClusterOperationsResponse.next_page_token] that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the [ListClusterOperationsResponse.next_page_token] returned by the previous list request."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListClusterOperationsRequest = ListClusterOperationsRequest

@typing.final
class ListClusterOperationsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests.

    If the number of results is larger than [ListClusterOperationsRequest.page_size], use the [next_page_token] as the value for the [ListClusterOperationsRequest.page_token] query parameter in the next list request.

    Each subsequent list request has its own [next_page_token] to continue paging through the results.
    """
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.operation.operation_pb2.Operation]:
        """List of Operation resources for the specified OpenSearch cluster."""

    def __init__(
        self,
        *,
        operations: collections.abc.Iterable[yandex.cloud.operation.operation_pb2.Operation] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "operations", b"operations"]) -> None: ...

global___ListClusterOperationsResponse = ListClusterOperationsResponse

@typing.final
class ListClusterHostsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the OpenSearch cluster.
    To get the OpenSearch cluster ID use a [ClusterService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return.

    If the number of available results is larger than [page_size], the service returns
    a [ListClusterHostsResponse.next_page_token] that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the [ListClusterHostsResponse.next_page_token]
    returned by the previous list request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListClusterHostsRequest = ListClusterHostsRequest

@typing.final
class ListClusterHostsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HOSTS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests.

    If the number of results is larger than [ListClusterHostsRequest.page_size], use the [next_page_token]
    as the value for the [ListClusterHostsRequest.page_token] query parameter in the next list request.

    Each subsequent list request has its own [next_page_token] to continue paging through the results.
    """
    @property
    def hosts(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.mdb.opensearch.v1.cluster_pb2.Host]:
        """Requested list of hosts for the cluster."""

    def __init__(
        self,
        *,
        hosts: collections.abc.Iterable[yandex.cloud.mdb.opensearch.v1.cluster_pb2.Host] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["hosts", b"hosts", "next_page_token", b"next_page_token"]) -> None: ...

global___ListClusterHostsResponse = ListClusterHostsResponse

@typing.final
class MoveClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    DESTINATION_FOLDER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the OpenSearch cluster to move."""
    destination_folder_id: builtins.str
    """ID of the destination folder."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        destination_folder_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "destination_folder_id", b"destination_folder_id"]) -> None: ...

global___MoveClusterRequest = MoveClusterRequest

@typing.final
class MoveClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    SOURCE_FOLDER_ID_FIELD_NUMBER: builtins.int
    DESTINATION_FOLDER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the OpenSearch cluster being moved."""
    source_folder_id: builtins.str
    """ID of the source folder."""
    destination_folder_id: builtins.str
    """ID of the destnation folder."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        source_folder_id: builtins.str = ...,
        destination_folder_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "destination_folder_id", b"destination_folder_id", "source_folder_id", b"source_folder_id"]) -> None: ...

global___MoveClusterMetadata = MoveClusterMetadata

@typing.final
class StartClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the OpenSearch cluster to start.
    To get the cluster ID, use a [ClusterService.List] request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___StartClusterRequest = StartClusterRequest

@typing.final
class StartClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the OpenSearch cluster being started."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___StartClusterMetadata = StartClusterMetadata

@typing.final
class StopClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the OpenSearch cluster to stop.
    To get the cluster ID, use a [ClusterService.List] request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___StopClusterRequest = StopClusterRequest

@typing.final
class StopClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the OpenSearch cluster being stopped."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___StopClusterMetadata = StopClusterMetadata

@typing.final
class ConfigCreateSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VERSION_FIELD_NUMBER: builtins.int
    ADMIN_PASSWORD_FIELD_NUMBER: builtins.int
    OPENSEARCH_SPEC_FIELD_NUMBER: builtins.int
    DASHBOARDS_SPEC_FIELD_NUMBER: builtins.int
    ACCESS_FIELD_NUMBER: builtins.int
    SNAPSHOT_MANAGEMENT_FIELD_NUMBER: builtins.int
    version: builtins.str
    """OpenSearch version.
    No formal validation, a list of supported versions should suffice.
    """
    admin_password: builtins.str
    """OpenSearch admin password."""
    @property
    def opensearch_spec(self) -> global___OpenSearchCreateSpec:
        """OpenSearch configuration."""

    @property
    def dashboards_spec(self) -> global___DashboardsCreateSpec:
        """Dashboards configuration."""

    @property
    def access(self) -> yandex.cloud.mdb.opensearch.v1.cluster_pb2.Access:
        """Access policy for external services."""

    @property
    def snapshot_management(self) -> yandex.cloud.mdb.opensearch.v1.backup_pb2.SnapshotManagement:
        """Snapshot management configuration"""

    def __init__(
        self,
        *,
        version: builtins.str = ...,
        admin_password: builtins.str = ...,
        opensearch_spec: global___OpenSearchCreateSpec | None = ...,
        dashboards_spec: global___DashboardsCreateSpec | None = ...,
        access: yandex.cloud.mdb.opensearch.v1.cluster_pb2.Access | None = ...,
        snapshot_management: yandex.cloud.mdb.opensearch.v1.backup_pb2.SnapshotManagement | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["access", b"access", "dashboards_spec", b"dashboards_spec", "opensearch_spec", b"opensearch_spec", "snapshot_management", b"snapshot_management"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["access", b"access", "admin_password", b"admin_password", "dashboards_spec", b"dashboards_spec", "opensearch_spec", b"opensearch_spec", "snapshot_management", b"snapshot_management", "version", b"version"]) -> None: ...

global___ConfigCreateSpec = ConfigCreateSpec

@typing.final
class KeystoreSetting(google.protobuf.message.Message):
    """Single keystore entry."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Keystore entry name."""
    value: builtins.str
    """Keystore entry value."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        value: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["name", b"name", "value", b"value"]) -> None: ...

global___KeystoreSetting = KeystoreSetting

@typing.final
class OpenSearchCreateSpec(google.protobuf.message.Message):
    """OpenSearch create-time configuration."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class NodeGroup(google.protobuf.message.Message):
        """Configuration of the host group."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NAME_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        HOSTS_COUNT_FIELD_NUMBER: builtins.int
        ZONE_IDS_FIELD_NUMBER: builtins.int
        SUBNET_IDS_FIELD_NUMBER: builtins.int
        ASSIGN_PUBLIC_IP_FIELD_NUMBER: builtins.int
        ROLES_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        name: builtins.str
        """Name of the group."""
        hosts_count: builtins.int
        """Number of hosts in the group."""
        assign_public_ip: builtins.bool
        """Determines whether a public IP is assigned to the hosts in the group."""
        @property
        def resources(self) -> yandex.cloud.mdb.opensearch.v1.cluster_pb2.Resources:
            """Resources allocated to the hosts."""

        @property
        def zone_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
            """IDs of the availability zones the hosts belong to."""

        @property
        def subnet_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
            """IDs of the subnets that the hosts belong to."""

        @property
        def roles(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[yandex.cloud.mdb.opensearch.v1.cluster_pb2.OpenSearch.GroupRole.ValueType]:
            """Roles of the hosts in the group."""

        @property
        def disk_size_autoscaling(self) -> yandex.cloud.mdb.opensearch.v1.cluster_pb2.DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            name: builtins.str = ...,
            resources: yandex.cloud.mdb.opensearch.v1.cluster_pb2.Resources | None = ...,
            hosts_count: builtins.int = ...,
            zone_ids: collections.abc.Iterable[builtins.str] | None = ...,
            subnet_ids: collections.abc.Iterable[builtins.str] | None = ...,
            assign_public_ip: builtins.bool = ...,
            roles: collections.abc.Iterable[yandex.cloud.mdb.opensearch.v1.cluster_pb2.OpenSearch.GroupRole.ValueType] | None = ...,
            disk_size_autoscaling: yandex.cloud.mdb.opensearch.v1.cluster_pb2.DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["assign_public_ip", b"assign_public_ip", "disk_size_autoscaling", b"disk_size_autoscaling", "hosts_count", b"hosts_count", "name", b"name", "resources", b"resources", "roles", b"roles", "subnet_ids", b"subnet_ids", "zone_ids", b"zone_ids"]) -> None: ...

    PLUGINS_FIELD_NUMBER: builtins.int
    NODE_GROUPS_FIELD_NUMBER: builtins.int
    OPENSEARCH_CONFIG_2_FIELD_NUMBER: builtins.int
    KEYSTORE_SETTINGS_FIELD_NUMBER: builtins.int
    @property
    def plugins(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Names of the cluster plugins."""

    @property
    def node_groups(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___OpenSearchCreateSpec.NodeGroup]:
        """OpenSearch type host groups of the cluster."""

    @property
    def opensearch_config_2(self) -> yandex.cloud.mdb.opensearch.v1.config.opensearch_pb2.OpenSearchConfig2: ...
    @property
    def keystore_settings(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___KeystoreSetting]:
        """Initial cluster keystore settings."""

    def __init__(
        self,
        *,
        plugins: collections.abc.Iterable[builtins.str] | None = ...,
        node_groups: collections.abc.Iterable[global___OpenSearchCreateSpec.NodeGroup] | None = ...,
        opensearch_config_2: yandex.cloud.mdb.opensearch.v1.config.opensearch_pb2.OpenSearchConfig2 | None = ...,
        keystore_settings: collections.abc.Iterable[global___KeystoreSetting] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["config", b"config", "opensearch_config_2", b"opensearch_config_2"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["config", b"config", "keystore_settings", b"keystore_settings", "node_groups", b"node_groups", "opensearch_config_2", b"opensearch_config_2", "plugins", b"plugins"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["config", b"config"]) -> typing.Literal["opensearch_config_2"] | None: ...

global___OpenSearchCreateSpec = OpenSearchCreateSpec

@typing.final
class DashboardsCreateSpec(google.protobuf.message.Message):
    """Dashboards create-time configuration."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class NodeGroup(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NAME_FIELD_NUMBER: builtins.int
        RESOURCES_FIELD_NUMBER: builtins.int
        HOSTS_COUNT_FIELD_NUMBER: builtins.int
        ZONE_IDS_FIELD_NUMBER: builtins.int
        SUBNET_IDS_FIELD_NUMBER: builtins.int
        ASSIGN_PUBLIC_IP_FIELD_NUMBER: builtins.int
        DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
        name: builtins.str
        """Name of the group."""
        hosts_count: builtins.int
        """Number of hosts in the group."""
        assign_public_ip: builtins.bool
        """Determines whether a public IP is assigned to the hosts in the group."""
        @property
        def resources(self) -> yandex.cloud.mdb.opensearch.v1.cluster_pb2.Resources:
            """Resources allocated to the hosts."""

        @property
        def zone_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
            """IDs of the availability zones the hosts belong to."""

        @property
        def subnet_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
            """IDs of the subnets that the hosts belong to."""

        @property
        def disk_size_autoscaling(self) -> yandex.cloud.mdb.opensearch.v1.cluster_pb2.DiskSizeAutoscaling:
            """Disk size autoscaling settings"""

        def __init__(
            self,
            *,
            name: builtins.str = ...,
            resources: yandex.cloud.mdb.opensearch.v1.cluster_pb2.Resources | None = ...,
            hosts_count: builtins.int = ...,
            zone_ids: collections.abc.Iterable[builtins.str] | None = ...,
            subnet_ids: collections.abc.Iterable[builtins.str] | None = ...,
            assign_public_ip: builtins.bool = ...,
            disk_size_autoscaling: yandex.cloud.mdb.opensearch.v1.cluster_pb2.DiskSizeAutoscaling | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["assign_public_ip", b"assign_public_ip", "disk_size_autoscaling", b"disk_size_autoscaling", "hosts_count", b"hosts_count", "name", b"name", "resources", b"resources", "subnet_ids", b"subnet_ids", "zone_ids", b"zone_ids"]) -> None: ...

    NODE_GROUPS_FIELD_NUMBER: builtins.int
    @property
    def node_groups(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DashboardsCreateSpec.NodeGroup]:
        """Dashboards type host groups of the cluster."""

    def __init__(
        self,
        *,
        node_groups: collections.abc.Iterable[global___DashboardsCreateSpec.NodeGroup] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["node_groups", b"node_groups"]) -> None: ...

global___DashboardsCreateSpec = DashboardsCreateSpec

@typing.final
class ConfigUpdateSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VERSION_FIELD_NUMBER: builtins.int
    ADMIN_PASSWORD_FIELD_NUMBER: builtins.int
    OPENSEARCH_SPEC_FIELD_NUMBER: builtins.int
    DASHBOARDS_SPEC_FIELD_NUMBER: builtins.int
    ACCESS_FIELD_NUMBER: builtins.int
    SNAPSHOT_MANAGEMENT_FIELD_NUMBER: builtins.int
    version: builtins.str
    """OpenSearch version.
    No formal validation, a list of supported versions should suffice.
    """
    admin_password: builtins.str
    """OpenSearch admin password."""
    @property
    def opensearch_spec(self) -> global___OpenSearchClusterUpdateSpec:
        """OpenSearch configuration."""

    @property
    def dashboards_spec(self) -> global___DashboardsClusterUpdateSpec:
        """Dashboards configuration."""

    @property
    def access(self) -> yandex.cloud.mdb.opensearch.v1.cluster_pb2.Access:
        """Access policy for external services."""

    @property
    def snapshot_management(self) -> yandex.cloud.mdb.opensearch.v1.backup_pb2.SnapshotManagement:
        """Snapshot management configuration"""

    def __init__(
        self,
        *,
        version: builtins.str = ...,
        admin_password: builtins.str = ...,
        opensearch_spec: global___OpenSearchClusterUpdateSpec | None = ...,
        dashboards_spec: global___DashboardsClusterUpdateSpec | None = ...,
        access: yandex.cloud.mdb.opensearch.v1.cluster_pb2.Access | None = ...,
        snapshot_management: yandex.cloud.mdb.opensearch.v1.backup_pb2.SnapshotManagement | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["access", b"access", "dashboards_spec", b"dashboards_spec", "opensearch_spec", b"opensearch_spec", "snapshot_management", b"snapshot_management"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["access", b"access", "admin_password", b"admin_password", "dashboards_spec", b"dashboards_spec", "opensearch_spec", b"opensearch_spec", "snapshot_management", b"snapshot_management", "version", b"version"]) -> None: ...

global___ConfigUpdateSpec = ConfigUpdateSpec

@typing.final
class OpenSearchClusterUpdateSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PLUGINS_FIELD_NUMBER: builtins.int
    OPENSEARCH_CONFIG_2_FIELD_NUMBER: builtins.int
    SET_KEYSTORE_SETTINGS_FIELD_NUMBER: builtins.int
    REMOVE_KEYSTORE_SETTINGS_FIELD_NUMBER: builtins.int
    @property
    def plugins(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Names of the cluster plugins."""

    @property
    def opensearch_config_2(self) -> yandex.cloud.mdb.opensearch.v1.config.opensearch_pb2.OpenSearchConfig2: ...
    @property
    def set_keystore_settings(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___KeystoreSetting]:
        """Keystore settings to add/replace. Old entries not listed here will be left unchanged."""

    @property
    def remove_keystore_settings(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Keystore entries names to remove."""

    def __init__(
        self,
        *,
        plugins: collections.abc.Iterable[builtins.str] | None = ...,
        opensearch_config_2: yandex.cloud.mdb.opensearch.v1.config.opensearch_pb2.OpenSearchConfig2 | None = ...,
        set_keystore_settings: collections.abc.Iterable[global___KeystoreSetting] | None = ...,
        remove_keystore_settings: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["config", b"config", "opensearch_config_2", b"opensearch_config_2"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["config", b"config", "opensearch_config_2", b"opensearch_config_2", "plugins", b"plugins", "remove_keystore_settings", b"remove_keystore_settings", "set_keystore_settings", b"set_keystore_settings"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["config", b"config"]) -> typing.Literal["opensearch_config_2"] | None: ...

global___OpenSearchClusterUpdateSpec = OpenSearchClusterUpdateSpec

@typing.final
class DashboardsClusterUpdateSpec(google.protobuf.message.Message):
    """Dashboards configuration."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DashboardsClusterUpdateSpec = DashboardsClusterUpdateSpec

@typing.final
class BackupClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the OpenSearch cluster to back up.

    To get the ID, use a [ClusterService.List] request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___BackupClusterRequest = BackupClusterRequest

@typing.final
class BackupClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the OpenSearch cluster being backed up."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___BackupClusterMetadata = BackupClusterMetadata

@typing.final
class DeleteBackupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    BACKUP_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """Required. ID of the OpenSearch cluster."""
    backup_id: builtins.str
    """Required. ID of the backup to delete."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        backup_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["backup_id", b"backup_id", "cluster_id", b"cluster_id"]) -> None: ...

global___DeleteBackupRequest = DeleteBackupRequest

@typing.final
class DeleteBackupMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    BACKUP_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the OpenSearch cluster."""
    backup_id: builtins.str
    """ID of the backup to delete."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        backup_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["backup_id", b"backup_id", "cluster_id", b"cluster_id"]) -> None: ...

global___DeleteBackupMetadata = DeleteBackupMetadata

@typing.final
class RestoreClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    BACKUP_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    ENVIRONMENT_FIELD_NUMBER: builtins.int
    CONFIG_SPEC_FIELD_NUMBER: builtins.int
    NETWORK_ID_FIELD_NUMBER: builtins.int
    SECURITY_GROUP_IDS_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    MAINTENANCE_WINDOW_FIELD_NUMBER: builtins.int
    DISK_ENCRYPTION_KEY_ID_FIELD_NUMBER: builtins.int
    backup_id: builtins.str
    """ID of the backup to create a new cluster from.

    To get the backup ID, use a [ClusterService.ListBackups] request.
    """
    name: builtins.str
    """Name of the new OpenSearch cluster to be created from the backup. The name must be unique within the folder."""
    description: builtins.str
    """Description of the new OpenSearch cluster to be created from the backup."""
    environment: yandex.cloud.mdb.opensearch.v1.cluster_pb2.Cluster.Environment.ValueType
    """Deployment environment of the new OpenSearch cluster to be created from the backup."""
    network_id: builtins.str
    """ID of the network to create the cluster in."""
    service_account_id: builtins.str
    """ID of the service account used to access Object Storage."""
    deletion_protection: builtins.bool
    """Determines whether the cluster is protected from being deleted."""
    folder_id: builtins.str
    """ID of the folder to create the OpenSearch cluster in.

    To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Custom labels for the new OpenSearch cluster to be created from the backup as `key:value` pairs. Maximum 64 per resource.
        For example, "project": "mvp" or "source": "dictionary".
        """

    @property
    def config_spec(self) -> global___ConfigCreateSpec:
        """Configuration for the new OpenSearch cluster to be created from the backup."""

    @property
    def security_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """User security groups."""

    @property
    def maintenance_window(self) -> yandex.cloud.mdb.opensearch.v1.maintenance_pb2.MaintenanceWindow:
        """Cluster maintenance window. Should be defined by either one of the two options."""

    @property
    def disk_encryption_key_id(self) -> google.protobuf.wrappers_pb2.StringValue:
        """ID of the key to encrypt cluster disks."""

    def __init__(
        self,
        *,
        backup_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        environment: yandex.cloud.mdb.opensearch.v1.cluster_pb2.Cluster.Environment.ValueType = ...,
        config_spec: global___ConfigCreateSpec | None = ...,
        network_id: builtins.str = ...,
        security_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
        service_account_id: builtins.str = ...,
        deletion_protection: builtins.bool = ...,
        folder_id: builtins.str = ...,
        maintenance_window: yandex.cloud.mdb.opensearch.v1.maintenance_pb2.MaintenanceWindow | None = ...,
        disk_encryption_key_id: google.protobuf.wrappers_pb2.StringValue | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["config_spec", b"config_spec", "disk_encryption_key_id", b"disk_encryption_key_id", "maintenance_window", b"maintenance_window"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["backup_id", b"backup_id", "config_spec", b"config_spec", "deletion_protection", b"deletion_protection", "description", b"description", "disk_encryption_key_id", b"disk_encryption_key_id", "environment", b"environment", "folder_id", b"folder_id", "labels", b"labels", "maintenance_window", b"maintenance_window", "name", b"name", "network_id", b"network_id", "security_group_ids", b"security_group_ids", "service_account_id", b"service_account_id"]) -> None: ...

global___RestoreClusterRequest = RestoreClusterRequest

@typing.final
class RestoreClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    BACKUP_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the new OpenSearch cluster being created from a backup."""
    backup_id: builtins.str
    """ID of the backup being used for creating a cluster."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        backup_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["backup_id", b"backup_id", "cluster_id", b"cluster_id"]) -> None: ...

global___RestoreClusterMetadata = RestoreClusterMetadata

@typing.final
class RescheduleMaintenanceRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _RescheduleType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _RescheduleTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[RescheduleMaintenanceRequest._RescheduleType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        RESCHEDULE_TYPE_UNSPECIFIED: RescheduleMaintenanceRequest._RescheduleType.ValueType  # 0
        """Time of the maintenance is not specified.."""
        IMMEDIATE: RescheduleMaintenanceRequest._RescheduleType.ValueType  # 1
        """Start the maintenance operation immediately."""
        NEXT_AVAILABLE_WINDOW: RescheduleMaintenanceRequest._RescheduleType.ValueType  # 2
        """Start the maintenance operation within the next available maintenance window."""
        SPECIFIC_TIME: RescheduleMaintenanceRequest._RescheduleType.ValueType  # 3
        """Start the maintenance operation at the specific time."""

    class RescheduleType(_RescheduleType, metaclass=_RescheduleTypeEnumTypeWrapper): ...
    RESCHEDULE_TYPE_UNSPECIFIED: RescheduleMaintenanceRequest.RescheduleType.ValueType  # 0
    """Time of the maintenance is not specified.."""
    IMMEDIATE: RescheduleMaintenanceRequest.RescheduleType.ValueType  # 1
    """Start the maintenance operation immediately."""
    NEXT_AVAILABLE_WINDOW: RescheduleMaintenanceRequest.RescheduleType.ValueType  # 2
    """Start the maintenance operation within the next available maintenance window."""
    SPECIFIC_TIME: RescheduleMaintenanceRequest.RescheduleType.ValueType  # 3
    """Start the maintenance operation at the specific time."""

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    RESCHEDULE_TYPE_FIELD_NUMBER: builtins.int
    DELAYED_UNTIL_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the OpenSearch cluster to reschedule the maintenance operation for.

    To get the ID, use a [ClusterService.List] request.
    """
    reschedule_type: global___RescheduleMaintenanceRequest.RescheduleType.ValueType
    """The type of the reschedule request."""
    @property
    def delayed_until(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time until which this maintenance operation should be delayed.
        The value should be ahead of the first time when the maintenance operation has been scheduled for no more than two weeks.
        The value can also point to a moment in the past if [reschedule_type.IMMEDIATE] reschedule type is selected.
        """

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        reschedule_type: global___RescheduleMaintenanceRequest.RescheduleType.ValueType = ...,
        delayed_until: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["delayed_until", b"delayed_until"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "delayed_until", b"delayed_until", "reschedule_type", b"reschedule_type"]) -> None: ...

global___RescheduleMaintenanceRequest = RescheduleMaintenanceRequest

@typing.final
class RescheduleMaintenanceMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    DELAYED_UNTIL_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the OpenSearch cluster where the reschedule is applied."""
    @property
    def delayed_until(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time until which this maintenance operation is to be delayed."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        delayed_until: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["delayed_until", b"delayed_until"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "delayed_until", b"delayed_until"]) -> None: ...

global___RescheduleMaintenanceMetadata = RescheduleMaintenanceMetadata

@typing.final
class ListClusterBackupsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the OpenSearch cluster.

    To get the ID, use a [ClusterService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than `page_size`, the service returns a [ListClusterBackupsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set `page_token` to the [ListClusterBackupsResponse.next_page_token]
    returned by the previous list request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListClusterBackupsRequest = ListClusterBackupsRequest

@typing.final
class ListClusterBackupsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BACKUPS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests.

    If the number of results is larger than [ListClustersRequest.page_size], use the [next_page_token] as the value
    for the [ListClustersRequest.page_token] parameter in the next list request.

    Each subsequent list request has its own [next_page_token] to continue paging through the results.
    """
    @property
    def backups(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.mdb.opensearch.v1.backup_pb2.Backup]:
        """List of the OpenSearch cluster backups."""

    def __init__(
        self,
        *,
        backups: collections.abc.Iterable[yandex.cloud.mdb.opensearch.v1.backup_pb2.Backup] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["backups", b"backups", "next_page_token", b"next_page_token"]) -> None: ...

global___ListClusterBackupsResponse = ListClusterBackupsResponse

@typing.final
class DeleteOpenSearchNodeGroupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the OpenSearch cluster to delete the OpenSearch type host group in.

    To get the ID, use a [ClusterService.List] request.
    """
    name: builtins.str
    """Name of the OpenSearch type host group to delete."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "name", b"name"]) -> None: ...

global___DeleteOpenSearchNodeGroupRequest = DeleteOpenSearchNodeGroupRequest

@typing.final
class UpdateOpenSearchNodeGroupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    NODE_GROUP_SPEC_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the OpenSearch cluster to update the OpenSearch type host group in.

    To get the ID, use a [ClusterService.List] request.
    """
    name: builtins.str
    """Name of the OpenSearch type host group to be updated."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which fields of the host group configuration should be updated."""

    @property
    def node_group_spec(self) -> global___OpenSearchNodeGroupUpdateSpec:
        """New configuration for the host group."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        name: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        node_group_spec: global___OpenSearchNodeGroupUpdateSpec | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["node_group_spec", b"node_group_spec", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "name", b"name", "node_group_spec", b"node_group_spec", "update_mask", b"update_mask"]) -> None: ...

global___UpdateOpenSearchNodeGroupRequest = UpdateOpenSearchNodeGroupRequest

@typing.final
class OpenSearchNodeGroupUpdateSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOURCES_FIELD_NUMBER: builtins.int
    HOSTS_COUNT_FIELD_NUMBER: builtins.int
    ROLES_FIELD_NUMBER: builtins.int
    ZONE_IDS_FIELD_NUMBER: builtins.int
    SUBNET_IDS_FIELD_NUMBER: builtins.int
    ASSIGN_PUBLIC_IP_FIELD_NUMBER: builtins.int
    DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
    hosts_count: builtins.int
    """Number of hosts in the group."""
    assign_public_ip: builtins.bool
    """Whether the hosts should get a public IP address."""
    @property
    def resources(self) -> yandex.cloud.mdb.opensearch.v1.cluster_pb2.Resources:
        """Resources allocated to the hosts."""

    @property
    def roles(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[yandex.cloud.mdb.opensearch.v1.cluster_pb2.OpenSearch.GroupRole.ValueType]:
        """Opensearch roles applicable to the node group."""

    @property
    def zone_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """IDs of the availability zones for hosts"""

    @property
    def subnet_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """IDs of the subnets for hosts"""

    @property
    def disk_size_autoscaling(self) -> yandex.cloud.mdb.opensearch.v1.cluster_pb2.DiskSizeAutoscaling:
        """Disk size autoscaling settings"""

    def __init__(
        self,
        *,
        resources: yandex.cloud.mdb.opensearch.v1.cluster_pb2.Resources | None = ...,
        hosts_count: builtins.int = ...,
        roles: collections.abc.Iterable[yandex.cloud.mdb.opensearch.v1.cluster_pb2.OpenSearch.GroupRole.ValueType] | None = ...,
        zone_ids: collections.abc.Iterable[builtins.str] | None = ...,
        subnet_ids: collections.abc.Iterable[builtins.str] | None = ...,
        assign_public_ip: builtins.bool = ...,
        disk_size_autoscaling: yandex.cloud.mdb.opensearch.v1.cluster_pb2.DiskSizeAutoscaling | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["assign_public_ip", b"assign_public_ip", "disk_size_autoscaling", b"disk_size_autoscaling", "hosts_count", b"hosts_count", "resources", b"resources", "roles", b"roles", "subnet_ids", b"subnet_ids", "zone_ids", b"zone_ids"]) -> None: ...

global___OpenSearchNodeGroupUpdateSpec = OpenSearchNodeGroupUpdateSpec

@typing.final
class AddOpenSearchNodeGroupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    NODE_GROUP_SPEC_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the OpenSearch cluster to create the OpenSearch type host group in.

    To get the ID, use a [ClusterService.List] request.
    """
    @property
    def node_group_spec(self) -> global___OpenSearchCreateSpec.NodeGroup:
        """Configuration of the new host group."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        node_group_spec: global___OpenSearchCreateSpec.NodeGroup | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["node_group_spec", b"node_group_spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "node_group_spec", b"node_group_spec"]) -> None: ...

global___AddOpenSearchNodeGroupRequest = AddOpenSearchNodeGroupRequest

@typing.final
class DeleteDashboardsNodeGroupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the OpenSearch cluster to delete the Dashboards type host group in.

    To get the ID, use a [ClusterService.List] request.
    """
    name: builtins.str
    """Name of the Dashboards type host group to delete."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "name", b"name"]) -> None: ...

global___DeleteDashboardsNodeGroupRequest = DeleteDashboardsNodeGroupRequest

@typing.final
class UpdateDashboardsNodeGroupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    NODE_GROUP_SPEC_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the OpenSearch cluster to update the Dashboards type host group in."""
    name: builtins.str
    """Name of the Dashboards type host group to be updated."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which fields of the host group configuration should be updated."""

    @property
    def node_group_spec(self) -> global___DashboardsNodeGroupUpdateSpec:
        """New configuration for the host group."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        name: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        node_group_spec: global___DashboardsNodeGroupUpdateSpec | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["node_group_spec", b"node_group_spec", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "name", b"name", "node_group_spec", b"node_group_spec", "update_mask", b"update_mask"]) -> None: ...

global___UpdateDashboardsNodeGroupRequest = UpdateDashboardsNodeGroupRequest

@typing.final
class DashboardsNodeGroupUpdateSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOURCES_FIELD_NUMBER: builtins.int
    HOSTS_COUNT_FIELD_NUMBER: builtins.int
    ZONE_IDS_FIELD_NUMBER: builtins.int
    SUBNET_IDS_FIELD_NUMBER: builtins.int
    ASSIGN_PUBLIC_IP_FIELD_NUMBER: builtins.int
    DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
    hosts_count: builtins.int
    """Number of hosts in the group."""
    assign_public_ip: builtins.bool
    """Whether the hosts should get a public IP address."""
    @property
    def resources(self) -> yandex.cloud.mdb.opensearch.v1.cluster_pb2.Resources:
        """Resources allocated to the hosts."""

    @property
    def zone_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """IDs of the availability zones for hosts"""

    @property
    def subnet_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """IDs of the subnets for hosts"""

    @property
    def disk_size_autoscaling(self) -> yandex.cloud.mdb.opensearch.v1.cluster_pb2.DiskSizeAutoscaling:
        """Disk size autoscaling settings"""

    def __init__(
        self,
        *,
        resources: yandex.cloud.mdb.opensearch.v1.cluster_pb2.Resources | None = ...,
        hosts_count: builtins.int = ...,
        zone_ids: collections.abc.Iterable[builtins.str] | None = ...,
        subnet_ids: collections.abc.Iterable[builtins.str] | None = ...,
        assign_public_ip: builtins.bool = ...,
        disk_size_autoscaling: yandex.cloud.mdb.opensearch.v1.cluster_pb2.DiskSizeAutoscaling | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["disk_size_autoscaling", b"disk_size_autoscaling", "resources", b"resources"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["assign_public_ip", b"assign_public_ip", "disk_size_autoscaling", b"disk_size_autoscaling", "hosts_count", b"hosts_count", "resources", b"resources", "subnet_ids", b"subnet_ids", "zone_ids", b"zone_ids"]) -> None: ...

global___DashboardsNodeGroupUpdateSpec = DashboardsNodeGroupUpdateSpec

@typing.final
class AddDashboardsNodeGroupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    NODE_GROUP_SPEC_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the OpenSearch cluster to create the Dashboards type host group in.

    To get the ID, use a [ClusterService.List] request.
    """
    @property
    def node_group_spec(self) -> global___DashboardsCreateSpec.NodeGroup:
        """Configuration of the new host group."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        node_group_spec: global___DashboardsCreateSpec.NodeGroup | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["node_group_spec", b"node_group_spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "node_group_spec", b"node_group_spec"]) -> None: ...

global___AddDashboardsNodeGroupRequest = AddDashboardsNodeGroupRequest

@typing.final
class AddNodeGroupMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the OpenSearch cluster where the host group is being created."""
    name: builtins.str
    """Name of the host group being created."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "name", b"name"]) -> None: ...

global___AddNodeGroupMetadata = AddNodeGroupMetadata

@typing.final
class UpdateNodeGroupMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the OpenSearch cluster where the host group is being updated."""
    name: builtins.str
    """Name of the host group being updated."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "name", b"name"]) -> None: ...

global___UpdateNodeGroupMetadata = UpdateNodeGroupMetadata

@typing.final
class DeleteNodeGroupMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the OpenSearch cluster where the host group is being deleted."""
    name: builtins.str
    """Name of the host group being deleted."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "name", b"name"]) -> None: ...

global___DeleteNodeGroupMetadata = DeleteNodeGroupMetadata

@typing.final
class GetAuthSettingsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """Required. ID of the OpenSearch cluster."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___GetAuthSettingsRequest = GetAuthSettingsRequest

@typing.final
class UpdateAuthSettingsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    SETTINGS_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """Required. ID of the OpenSearch cluster."""
    @property
    def settings(self) -> yandex.cloud.mdb.opensearch.v1.auth_pb2.AuthSettings:
        """Required. Auth settings."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        settings: yandex.cloud.mdb.opensearch.v1.auth_pb2.AuthSettings | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["settings", b"settings"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "settings", b"settings"]) -> None: ...

global___UpdateAuthSettingsRequest = UpdateAuthSettingsRequest

@typing.final
class UpdateAuthSettingsMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the OpenSearch cluster."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___UpdateAuthSettingsMetadata = UpdateAuthSettingsMetadata

@typing.final
class RestartOpenSearchRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    HOST_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """Required. ID of the OpenSearch cluster."""
    host: builtins.str
    """Required. Host to restart OpenSearch service on."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        host: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "host", b"host"]) -> None: ...

global___RestartOpenSearchRequest = RestartOpenSearchRequest

@typing.final
class RestartOpenSearchMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    HOST_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """Required. ID of the OpenSearch cluster."""
    host: builtins.str
    """Required. Host where OpenSearch will be restarted."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        host: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "host", b"host"]) -> None: ...

global___RestartOpenSearchMetadata = RestartOpenSearchMetadata

@typing.final
class SwitchMasterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    FROM_HOSTS_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """Required. ID of the OpenSearch cluster."""
    @property
    def from_hosts(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Hosts list which are forbidden to be masters after operation.
        If no hosts given, then current master will be switched.
        """

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        from_hosts: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "from_hosts", b"from_hosts"]) -> None: ...

global___SwitchMasterRequest = SwitchMasterRequest

@typing.final
class SwitchMasterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    FROM_HOSTS_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the OpenSearch cluster."""
    @property
    def from_hosts(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Host where masters will be expelled."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        from_hosts: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "from_hosts", b"from_hosts"]) -> None: ...

global___SwitchMasterMetadata = SwitchMasterMetadata
