"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import abc
import collections.abc
import grpc
import grpc.aio
import typing
import yandex.cloud.mdb.opensearch.v1.auth_pb2
import yandex.cloud.mdb.opensearch.v1.cluster_pb2
import yandex.cloud.mdb.opensearch.v1.cluster_service_pb2
import yandex.cloud.operation.operation_pb2

_T = typing.TypeVar("_T")

class _MaybeAsyncIterator(collections.abc.AsyncIterator[_T], collections.abc.Iterator[_T], metaclass=abc.ABCMeta): ...

class _ServicerContext(grpc.ServicerContext, grpc.aio.ServicerContext):  # type: ignore[misc, type-arg]
    ...

class ClusterServiceStub:
    """A set of methods for managing OpenSearch clusters."""

    def __init__(self, channel: typing.Union[grpc.Channel, grpc.aio.Channel]) -> None: ...
    Get: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.GetClusterRequest,
        yandex.cloud.mdb.opensearch.v1.cluster_pb2.Cluster,
    ]
    """Returns the specified OpenSearch cluster.

    To get the list of all available OpenSearch clusters, make a [List] request.
    """

    List: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.ListClustersRequest,
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.ListClustersResponse,
    ]
    """Retrieves the list of OpenSearch clusters that belong to the specified folder."""

    Create: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.CreateClusterRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Creates an OpenSearch cluster in the specified folder."""

    Update: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.UpdateClusterRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates the specified OpenSearch cluster."""

    Delete: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.DeleteClusterRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Deletes the specified OpenSearch cluster."""

    Backup: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.BackupClusterRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Creates a backup for the specified OpenSearch cluster."""

    DeleteBackup: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.DeleteBackupRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Delete backup for the specified OpenSearch cluster."""

    Restore: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.RestoreClusterRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Creates a new OpenSearch cluster using the specified backup."""

    RescheduleMaintenance: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.RescheduleMaintenanceRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Reschedules a planned maintenance operation."""

    ListBackups: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.ListClusterBackupsRequest,
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.ListClusterBackupsResponse,
    ]
    """Returns a list of available backups for the specified OpenSearch cluster."""

    Move: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.MoveClusterRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Moves the specified OpenSearch cluster to the specified folder."""

    Start: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.StartClusterRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Starts the specified OpenSearch cluster."""

    Stop: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.StopClusterRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Stops the specified OpenSearch cluster."""

    ListLogs: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.ListClusterLogsRequest,
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.ListClusterLogsResponse,
    ]
    """Retrieves logs for the specified OpenSearch cluster.
    For detailed description, see the [Logs](/yandex-mdb-guide/concepts/logs.html) section in the developer's guide.
    """

    StreamLogs: grpc.UnaryStreamMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.StreamClusterLogsRequest,
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.StreamLogRecord,
    ]
    """Same as ListLogs but using server-side streaming. Also allows for 'tail -f' semantics."""

    ListOperations: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.ListClusterOperationsRequest,
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.ListClusterOperationsResponse,
    ]
    """Retrieves the list of Operation resources for the specified cluster."""

    ListHosts: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.ListClusterHostsRequest,
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.ListClusterHostsResponse,
    ]
    """Retrieves a list of hosts for the specified cluster."""

    AddOpenSearchNodeGroup: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.AddOpenSearchNodeGroupRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Creates an OpenSearch type host group."""

    DeleteOpenSearchNodeGroup: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.DeleteOpenSearchNodeGroupRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Deletes an OpenSearch type host group."""

    UpdateOpenSearchNodeGroup: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.UpdateOpenSearchNodeGroupRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates an OpenSearch type host group."""

    AddDashboardsNodeGroup: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.AddDashboardsNodeGroupRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Creates a Dashboards type host group."""

    DeleteDashboardsNodeGroup: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.DeleteDashboardsNodeGroupRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Deletes a Dashboards type host group."""

    UpdateDashboardsNodeGroup: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.UpdateDashboardsNodeGroupRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates a Dashboards type host group."""

    GetAuthSettings: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.GetAuthSettingsRequest,
        yandex.cloud.mdb.opensearch.v1.auth_pb2.AuthSettings,
    ]
    """Retrieves auth settings for specified cluster."""

    UpdateAuthSettings: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.UpdateAuthSettingsRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates auth settings for specified cluster."""

    RestartOpenSearch: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.RestartOpenSearchRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Restarts OpenSearch on specified host."""

    SwitchMaster: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.SwitchMasterRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Switches current master or ensures that master not on specified hosts."""

class ClusterServiceAsyncStub:
    """A set of methods for managing OpenSearch clusters."""

    Get: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.GetClusterRequest,
        yandex.cloud.mdb.opensearch.v1.cluster_pb2.Cluster,
    ]
    """Returns the specified OpenSearch cluster.

    To get the list of all available OpenSearch clusters, make a [List] request.
    """

    List: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.ListClustersRequest,
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.ListClustersResponse,
    ]
    """Retrieves the list of OpenSearch clusters that belong to the specified folder."""

    Create: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.CreateClusterRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Creates an OpenSearch cluster in the specified folder."""

    Update: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.UpdateClusterRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates the specified OpenSearch cluster."""

    Delete: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.DeleteClusterRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Deletes the specified OpenSearch cluster."""

    Backup: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.BackupClusterRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Creates a backup for the specified OpenSearch cluster."""

    DeleteBackup: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.DeleteBackupRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Delete backup for the specified OpenSearch cluster."""

    Restore: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.RestoreClusterRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Creates a new OpenSearch cluster using the specified backup."""

    RescheduleMaintenance: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.RescheduleMaintenanceRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Reschedules a planned maintenance operation."""

    ListBackups: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.ListClusterBackupsRequest,
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.ListClusterBackupsResponse,
    ]
    """Returns a list of available backups for the specified OpenSearch cluster."""

    Move: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.MoveClusterRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Moves the specified OpenSearch cluster to the specified folder."""

    Start: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.StartClusterRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Starts the specified OpenSearch cluster."""

    Stop: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.StopClusterRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Stops the specified OpenSearch cluster."""

    ListLogs: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.ListClusterLogsRequest,
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.ListClusterLogsResponse,
    ]
    """Retrieves logs for the specified OpenSearch cluster.
    For detailed description, see the [Logs](/yandex-mdb-guide/concepts/logs.html) section in the developer's guide.
    """

    StreamLogs: grpc.aio.UnaryStreamMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.StreamClusterLogsRequest,
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.StreamLogRecord,
    ]
    """Same as ListLogs but using server-side streaming. Also allows for 'tail -f' semantics."""

    ListOperations: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.ListClusterOperationsRequest,
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.ListClusterOperationsResponse,
    ]
    """Retrieves the list of Operation resources for the specified cluster."""

    ListHosts: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.ListClusterHostsRequest,
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.ListClusterHostsResponse,
    ]
    """Retrieves a list of hosts for the specified cluster."""

    AddOpenSearchNodeGroup: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.AddOpenSearchNodeGroupRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Creates an OpenSearch type host group."""

    DeleteOpenSearchNodeGroup: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.DeleteOpenSearchNodeGroupRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Deletes an OpenSearch type host group."""

    UpdateOpenSearchNodeGroup: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.UpdateOpenSearchNodeGroupRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates an OpenSearch type host group."""

    AddDashboardsNodeGroup: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.AddDashboardsNodeGroupRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Creates a Dashboards type host group."""

    DeleteDashboardsNodeGroup: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.DeleteDashboardsNodeGroupRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Deletes a Dashboards type host group."""

    UpdateDashboardsNodeGroup: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.UpdateDashboardsNodeGroupRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates a Dashboards type host group."""

    GetAuthSettings: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.GetAuthSettingsRequest,
        yandex.cloud.mdb.opensearch.v1.auth_pb2.AuthSettings,
    ]
    """Retrieves auth settings for specified cluster."""

    UpdateAuthSettings: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.UpdateAuthSettingsRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates auth settings for specified cluster."""

    RestartOpenSearch: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.RestartOpenSearchRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Restarts OpenSearch on specified host."""

    SwitchMaster: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.SwitchMasterRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Switches current master or ensures that master not on specified hosts."""

class ClusterServiceServicer(metaclass=abc.ABCMeta):
    """A set of methods for managing OpenSearch clusters."""

    @abc.abstractmethod
    def Get(
        self,
        request: yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.GetClusterRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.mdb.opensearch.v1.cluster_pb2.Cluster, collections.abc.Awaitable[yandex.cloud.mdb.opensearch.v1.cluster_pb2.Cluster]]:
        """Returns the specified OpenSearch cluster.

        To get the list of all available OpenSearch clusters, make a [List] request.
        """

    @abc.abstractmethod
    def List(
        self,
        request: yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.ListClustersRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.ListClustersResponse, collections.abc.Awaitable[yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.ListClustersResponse]]:
        """Retrieves the list of OpenSearch clusters that belong to the specified folder."""

    @abc.abstractmethod
    def Create(
        self,
        request: yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.CreateClusterRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Creates an OpenSearch cluster in the specified folder."""

    @abc.abstractmethod
    def Update(
        self,
        request: yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.UpdateClusterRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Updates the specified OpenSearch cluster."""

    @abc.abstractmethod
    def Delete(
        self,
        request: yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.DeleteClusterRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Deletes the specified OpenSearch cluster."""

    @abc.abstractmethod
    def Backup(
        self,
        request: yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.BackupClusterRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Creates a backup for the specified OpenSearch cluster."""

    @abc.abstractmethod
    def DeleteBackup(
        self,
        request: yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.DeleteBackupRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Delete backup for the specified OpenSearch cluster."""

    @abc.abstractmethod
    def Restore(
        self,
        request: yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.RestoreClusterRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Creates a new OpenSearch cluster using the specified backup."""

    @abc.abstractmethod
    def RescheduleMaintenance(
        self,
        request: yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.RescheduleMaintenanceRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Reschedules a planned maintenance operation."""

    @abc.abstractmethod
    def ListBackups(
        self,
        request: yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.ListClusterBackupsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.ListClusterBackupsResponse, collections.abc.Awaitable[yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.ListClusterBackupsResponse]]:
        """Returns a list of available backups for the specified OpenSearch cluster."""

    @abc.abstractmethod
    def Move(
        self,
        request: yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.MoveClusterRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Moves the specified OpenSearch cluster to the specified folder."""

    @abc.abstractmethod
    def Start(
        self,
        request: yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.StartClusterRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Starts the specified OpenSearch cluster."""

    @abc.abstractmethod
    def Stop(
        self,
        request: yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.StopClusterRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Stops the specified OpenSearch cluster."""

    @abc.abstractmethod
    def ListLogs(
        self,
        request: yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.ListClusterLogsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.ListClusterLogsResponse, collections.abc.Awaitable[yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.ListClusterLogsResponse]]:
        """Retrieves logs for the specified OpenSearch cluster.
        For detailed description, see the [Logs](/yandex-mdb-guide/concepts/logs.html) section in the developer's guide.
        """

    @abc.abstractmethod
    def StreamLogs(
        self,
        request: yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.StreamClusterLogsRequest,
        context: _ServicerContext,
    ) -> typing.Union[collections.abc.Iterator[yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.StreamLogRecord], collections.abc.AsyncIterator[yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.StreamLogRecord]]:
        """Same as ListLogs but using server-side streaming. Also allows for 'tail -f' semantics."""

    @abc.abstractmethod
    def ListOperations(
        self,
        request: yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.ListClusterOperationsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.ListClusterOperationsResponse, collections.abc.Awaitable[yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.ListClusterOperationsResponse]]:
        """Retrieves the list of Operation resources for the specified cluster."""

    @abc.abstractmethod
    def ListHosts(
        self,
        request: yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.ListClusterHostsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.ListClusterHostsResponse, collections.abc.Awaitable[yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.ListClusterHostsResponse]]:
        """Retrieves a list of hosts for the specified cluster."""

    @abc.abstractmethod
    def AddOpenSearchNodeGroup(
        self,
        request: yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.AddOpenSearchNodeGroupRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Creates an OpenSearch type host group."""

    @abc.abstractmethod
    def DeleteOpenSearchNodeGroup(
        self,
        request: yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.DeleteOpenSearchNodeGroupRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Deletes an OpenSearch type host group."""

    @abc.abstractmethod
    def UpdateOpenSearchNodeGroup(
        self,
        request: yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.UpdateOpenSearchNodeGroupRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Updates an OpenSearch type host group."""

    @abc.abstractmethod
    def AddDashboardsNodeGroup(
        self,
        request: yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.AddDashboardsNodeGroupRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Creates a Dashboards type host group."""

    @abc.abstractmethod
    def DeleteDashboardsNodeGroup(
        self,
        request: yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.DeleteDashboardsNodeGroupRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Deletes a Dashboards type host group."""

    @abc.abstractmethod
    def UpdateDashboardsNodeGroup(
        self,
        request: yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.UpdateDashboardsNodeGroupRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Updates a Dashboards type host group."""

    @abc.abstractmethod
    def GetAuthSettings(
        self,
        request: yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.GetAuthSettingsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.mdb.opensearch.v1.auth_pb2.AuthSettings, collections.abc.Awaitable[yandex.cloud.mdb.opensearch.v1.auth_pb2.AuthSettings]]:
        """Retrieves auth settings for specified cluster."""

    @abc.abstractmethod
    def UpdateAuthSettings(
        self,
        request: yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.UpdateAuthSettingsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Updates auth settings for specified cluster."""

    @abc.abstractmethod
    def RestartOpenSearch(
        self,
        request: yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.RestartOpenSearchRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Restarts OpenSearch on specified host."""

    @abc.abstractmethod
    def SwitchMaster(
        self,
        request: yandex.cloud.mdb.opensearch.v1.cluster_service_pb2.SwitchMasterRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Switches current master or ensures that master not on specified hosts."""

def add_ClusterServiceServicer_to_server(servicer: ClusterServiceServicer, server: typing.Union[grpc.Server, grpc.aio.Server]) -> None: ...
