"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import google.protobuf.wrappers_pb2
import google.type.timeofday_pb2
import sys
import typing
import yandex.cloud.mdb.postgresql.v1.config.host10_1c_pb2
import yandex.cloud.mdb.postgresql.v1.config.host10_pb2
import yandex.cloud.mdb.postgresql.v1.config.host11_1c_pb2
import yandex.cloud.mdb.postgresql.v1.config.host11_pb2
import yandex.cloud.mdb.postgresql.v1.config.host12_1c_pb2
import yandex.cloud.mdb.postgresql.v1.config.host12_pb2
import yandex.cloud.mdb.postgresql.v1.config.host13_1c_pb2
import yandex.cloud.mdb.postgresql.v1.config.host13_pb2
import yandex.cloud.mdb.postgresql.v1.config.host14_1c_pb2
import yandex.cloud.mdb.postgresql.v1.config.host14_pb2
import yandex.cloud.mdb.postgresql.v1.config.host15_1c_pb2
import yandex.cloud.mdb.postgresql.v1.config.host15_pb2
import yandex.cloud.mdb.postgresql.v1.config.host16_1c_pb2
import yandex.cloud.mdb.postgresql.v1.config.host16_pb2
import yandex.cloud.mdb.postgresql.v1.config.host17_1c_pb2
import yandex.cloud.mdb.postgresql.v1.config.host17_pb2
import yandex.cloud.mdb.postgresql.v1.config.host9_6_pb2
import yandex.cloud.mdb.postgresql.v1.config.postgresql10_1c_pb2
import yandex.cloud.mdb.postgresql.v1.config.postgresql10_pb2
import yandex.cloud.mdb.postgresql.v1.config.postgresql11_1c_pb2
import yandex.cloud.mdb.postgresql.v1.config.postgresql11_pb2
import yandex.cloud.mdb.postgresql.v1.config.postgresql12_1c_pb2
import yandex.cloud.mdb.postgresql.v1.config.postgresql12_pb2
import yandex.cloud.mdb.postgresql.v1.config.postgresql13_1c_pb2
import yandex.cloud.mdb.postgresql.v1.config.postgresql13_pb2
import yandex.cloud.mdb.postgresql.v1.config.postgresql14_1c_pb2
import yandex.cloud.mdb.postgresql.v1.config.postgresql14_pb2
import yandex.cloud.mdb.postgresql.v1.config.postgresql15_1c_pb2
import yandex.cloud.mdb.postgresql.v1.config.postgresql15_pb2
import yandex.cloud.mdb.postgresql.v1.config.postgresql16_1c_pb2
import yandex.cloud.mdb.postgresql.v1.config.postgresql16_pb2
import yandex.cloud.mdb.postgresql.v1.config.postgresql17_1c_pb2
import yandex.cloud.mdb.postgresql.v1.config.postgresql17_pb2
import yandex.cloud.mdb.postgresql.v1.config.postgresql9_6_pb2
import yandex.cloud.mdb.postgresql.v1.maintenance_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Cluster(google.protobuf.message.Message):
    """A PostgreSQL Cluster resource. For more information, see
    the [Concepts](/docs/managed-postgresql/concepts) section of the documentation.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Environment:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EnvironmentEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Cluster._Environment.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        ENVIRONMENT_UNSPECIFIED: Cluster._Environment.ValueType  # 0
        PRODUCTION: Cluster._Environment.ValueType  # 1
        """Stable environment with a conservative update policy:
        only hotfixes are applied during regular maintenance.
        """
        PRESTABLE: Cluster._Environment.ValueType  # 2
        """Environment with more aggressive update policy: new versions
        are rolled out irrespective of backward compatibility.
        """

    class Environment(_Environment, metaclass=_EnvironmentEnumTypeWrapper): ...
    ENVIRONMENT_UNSPECIFIED: Cluster.Environment.ValueType  # 0
    PRODUCTION: Cluster.Environment.ValueType  # 1
    """Stable environment with a conservative update policy:
    only hotfixes are applied during regular maintenance.
    """
    PRESTABLE: Cluster.Environment.ValueType  # 2
    """Environment with more aggressive update policy: new versions
    are rolled out irrespective of backward compatibility.
    """

    class _Health:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _HealthEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Cluster._Health.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        HEALTH_UNKNOWN: Cluster._Health.ValueType  # 0
        """State of the cluster is unknown ([Host.health] for every host in the cluster is UNKNOWN)."""
        ALIVE: Cluster._Health.ValueType  # 1
        """Cluster is alive and well ([Host.health] for every host in the cluster is ALIVE)."""
        DEAD: Cluster._Health.ValueType  # 2
        """Cluster is inoperable ([Host.health] for every host in the cluster is DEAD)."""
        DEGRADED: Cluster._Health.ValueType  # 3
        """Cluster is working below capacity ([Host.health] for at least one host in the cluster is not ALIVE)."""

    class Health(_Health, metaclass=_HealthEnumTypeWrapper): ...
    HEALTH_UNKNOWN: Cluster.Health.ValueType  # 0
    """State of the cluster is unknown ([Host.health] for every host in the cluster is UNKNOWN)."""
    ALIVE: Cluster.Health.ValueType  # 1
    """Cluster is alive and well ([Host.health] for every host in the cluster is ALIVE)."""
    DEAD: Cluster.Health.ValueType  # 2
    """Cluster is inoperable ([Host.health] for every host in the cluster is DEAD)."""
    DEGRADED: Cluster.Health.ValueType  # 3
    """Cluster is working below capacity ([Host.health] for at least one host in the cluster is not ALIVE)."""

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Cluster._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNKNOWN: Cluster._Status.ValueType  # 0
        """Cluster state is unknown."""
        CREATING: Cluster._Status.ValueType  # 1
        """Cluster is being created."""
        RUNNING: Cluster._Status.ValueType  # 2
        """Cluster is running normally."""
        ERROR: Cluster._Status.ValueType  # 3
        """Cluster encountered a problem and cannot operate."""
        UPDATING: Cluster._Status.ValueType  # 4
        """Cluster is being updated."""
        STOPPING: Cluster._Status.ValueType  # 5
        """Cluster is stopping."""
        STOPPED: Cluster._Status.ValueType  # 6
        """Cluster stopped."""
        STARTING: Cluster._Status.ValueType  # 7
        """Cluster is starting."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNKNOWN: Cluster.Status.ValueType  # 0
    """Cluster state is unknown."""
    CREATING: Cluster.Status.ValueType  # 1
    """Cluster is being created."""
    RUNNING: Cluster.Status.ValueType  # 2
    """Cluster is running normally."""
    ERROR: Cluster.Status.ValueType  # 3
    """Cluster encountered a problem and cannot operate."""
    UPDATING: Cluster.Status.ValueType  # 4
    """Cluster is being updated."""
    STOPPING: Cluster.Status.ValueType  # 5
    """Cluster is stopping."""
    STOPPED: Cluster.Status.ValueType  # 6
    """Cluster stopped."""
    STARTING: Cluster.Status.ValueType  # 7
    """Cluster is starting."""

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    ENVIRONMENT_FIELD_NUMBER: builtins.int
    MONITORING_FIELD_NUMBER: builtins.int
    CONFIG_FIELD_NUMBER: builtins.int
    NETWORK_ID_FIELD_NUMBER: builtins.int
    HEALTH_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    MAINTENANCE_WINDOW_FIELD_NUMBER: builtins.int
    PLANNED_OPERATION_FIELD_NUMBER: builtins.int
    SECURITY_GROUP_IDS_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    HOST_GROUP_IDS_FIELD_NUMBER: builtins.int
    DISK_ENCRYPTION_KEY_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the PostgreSQL cluster.
    This ID is assigned by MDB at creation time.
    """
    folder_id: builtins.str
    """ID of the folder that the PostgreSQL cluster belongs to."""
    name: builtins.str
    """Name of the PostgreSQL cluster.
    The name is unique within the folder. 1-63 characters long.
    """
    description: builtins.str
    """Description of the PostgreSQL cluster. 0-256 characters long."""
    environment: global___Cluster.Environment.ValueType
    """Deployment environment of the PostgreSQL cluster."""
    network_id: builtins.str
    """ID of the network that the cluster belongs to."""
    health: global___Cluster.Health.ValueType
    """Aggregated cluster health."""
    status: global___Cluster.Status.ValueType
    """Current state of the cluster."""
    deletion_protection: builtins.bool
    """Deletion Protection inhibits deletion of the cluster"""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Custom labels for the PostgreSQL cluster as `` key:value `` pairs.
        Maximum 64 per resource.
        """

    @property
    def monitoring(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Monitoring]:
        """Description of monitoring systems relevant to the PostgreSQL cluster."""

    @property
    def config(self) -> global___ClusterConfig:
        """Configuration of the PostgreSQL cluster."""

    @property
    def maintenance_window(self) -> yandex.cloud.mdb.postgresql.v1.maintenance_pb2.MaintenanceWindow:
        """Maintenance window for the cluster."""

    @property
    def planned_operation(self) -> yandex.cloud.mdb.postgresql.v1.maintenance_pb2.MaintenanceOperation:
        """Planned maintenance operation to be started for the cluster within the nearest [maintenance_window]."""

    @property
    def security_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """User security groups"""

    @property
    def host_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Host groups hosting VMs of the cluster."""

    @property
    def disk_encryption_key_id(self) -> google.protobuf.wrappers_pb2.StringValue:
        """ID of the key to encrypt cluster disks."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        folder_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        environment: global___Cluster.Environment.ValueType = ...,
        monitoring: collections.abc.Iterable[global___Monitoring] | None = ...,
        config: global___ClusterConfig | None = ...,
        network_id: builtins.str = ...,
        health: global___Cluster.Health.ValueType = ...,
        status: global___Cluster.Status.ValueType = ...,
        maintenance_window: yandex.cloud.mdb.postgresql.v1.maintenance_pb2.MaintenanceWindow | None = ...,
        planned_operation: yandex.cloud.mdb.postgresql.v1.maintenance_pb2.MaintenanceOperation | None = ...,
        security_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
        deletion_protection: builtins.bool = ...,
        host_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
        disk_encryption_key_id: google.protobuf.wrappers_pb2.StringValue | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["config", b"config", "created_at", b"created_at", "disk_encryption_key_id", b"disk_encryption_key_id", "maintenance_window", b"maintenance_window", "planned_operation", b"planned_operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["config", b"config", "created_at", b"created_at", "deletion_protection", b"deletion_protection", "description", b"description", "disk_encryption_key_id", b"disk_encryption_key_id", "environment", b"environment", "folder_id", b"folder_id", "health", b"health", "host_group_ids", b"host_group_ids", "id", b"id", "labels", b"labels", "maintenance_window", b"maintenance_window", "monitoring", b"monitoring", "name", b"name", "network_id", b"network_id", "planned_operation", b"planned_operation", "security_group_ids", b"security_group_ids", "status", b"status"]) -> None: ...

global___Cluster = Cluster

@typing.final
class Monitoring(google.protobuf.message.Message):
    """Monitoring system."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LINK_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the monitoring system."""
    description: builtins.str
    """Description of the monitoring system."""
    link: builtins.str
    """Link to the monitoring system charts for the PostgreSQL cluster."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        description: builtins.str = ...,
        link: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "link", b"link", "name", b"name"]) -> None: ...

global___Monitoring = Monitoring

@typing.final
class ClusterConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VERSION_FIELD_NUMBER: builtins.int
    POSTGRESQL_CONFIG_9_6_FIELD_NUMBER: builtins.int
    POSTGRESQL_CONFIG_10_1C_FIELD_NUMBER: builtins.int
    POSTGRESQL_CONFIG_10_FIELD_NUMBER: builtins.int
    POSTGRESQL_CONFIG_11_FIELD_NUMBER: builtins.int
    POSTGRESQL_CONFIG_11_1C_FIELD_NUMBER: builtins.int
    POSTGRESQL_CONFIG_12_FIELD_NUMBER: builtins.int
    POSTGRESQL_CONFIG_12_1C_FIELD_NUMBER: builtins.int
    POSTGRESQL_CONFIG_13_FIELD_NUMBER: builtins.int
    POSTGRESQL_CONFIG_13_1C_FIELD_NUMBER: builtins.int
    POSTGRESQL_CONFIG_14_FIELD_NUMBER: builtins.int
    POSTGRESQL_CONFIG_14_1C_FIELD_NUMBER: builtins.int
    POSTGRESQL_CONFIG_15_FIELD_NUMBER: builtins.int
    POSTGRESQL_CONFIG_15_1C_FIELD_NUMBER: builtins.int
    POSTGRESQL_CONFIG_16_FIELD_NUMBER: builtins.int
    POSTGRESQL_CONFIG_16_1C_FIELD_NUMBER: builtins.int
    POSTGRESQL_CONFIG_17_FIELD_NUMBER: builtins.int
    POSTGRESQL_CONFIG_17_1C_FIELD_NUMBER: builtins.int
    POOLER_CONFIG_FIELD_NUMBER: builtins.int
    RESOURCES_FIELD_NUMBER: builtins.int
    AUTOFAILOVER_FIELD_NUMBER: builtins.int
    BACKUP_WINDOW_START_FIELD_NUMBER: builtins.int
    BACKUP_RETAIN_PERIOD_DAYS_FIELD_NUMBER: builtins.int
    ACCESS_FIELD_NUMBER: builtins.int
    PERFORMANCE_DIAGNOSTICS_FIELD_NUMBER: builtins.int
    DISK_SIZE_AUTOSCALING_FIELD_NUMBER: builtins.int
    version: builtins.str
    """Version of PostgreSQL server software."""
    @property
    def postgresql_config_9_6(self) -> yandex.cloud.mdb.postgresql.v1.config.postgresql9_6_pb2.PostgresqlConfigSet9_6:
        """Configuration of a PostgreSQL 9.6 server."""

    @property
    def postgresql_config_10_1c(self) -> yandex.cloud.mdb.postgresql.v1.config.postgresql10_1c_pb2.PostgresqlConfigSet10_1C:
        """Configuration of a PostgreSQL 10 1C server."""

    @property
    def postgresql_config_10(self) -> yandex.cloud.mdb.postgresql.v1.config.postgresql10_pb2.PostgresqlConfigSet10:
        """Configuration of a PostgreSQL 10 server."""

    @property
    def postgresql_config_11(self) -> yandex.cloud.mdb.postgresql.v1.config.postgresql11_pb2.PostgresqlConfigSet11:
        """Configuration of a PostgreSQL 11 server."""

    @property
    def postgresql_config_11_1c(self) -> yandex.cloud.mdb.postgresql.v1.config.postgresql11_1c_pb2.PostgresqlConfigSet11_1C:
        """Configuration of a PostgreSQL 11 1C server."""

    @property
    def postgresql_config_12(self) -> yandex.cloud.mdb.postgresql.v1.config.postgresql12_pb2.PostgresqlConfigSet12:
        """Configuration of a PostgreSQL 12 server."""

    @property
    def postgresql_config_12_1c(self) -> yandex.cloud.mdb.postgresql.v1.config.postgresql12_1c_pb2.PostgresqlConfigSet12_1C:
        """Configuration of a PostgreSQL 12 1C server."""

    @property
    def postgresql_config_13(self) -> yandex.cloud.mdb.postgresql.v1.config.postgresql13_pb2.PostgresqlConfigSet13:
        """Configuration of a PostgreSQL 13 server."""

    @property
    def postgresql_config_13_1c(self) -> yandex.cloud.mdb.postgresql.v1.config.postgresql13_1c_pb2.PostgresqlConfigSet13_1C:
        """Configuration of a PostgreSQL 13 1C server."""

    @property
    def postgresql_config_14(self) -> yandex.cloud.mdb.postgresql.v1.config.postgresql14_pb2.PostgresqlConfigSet14:
        """Configuration of a PostgreSQL 14 server."""

    @property
    def postgresql_config_14_1c(self) -> yandex.cloud.mdb.postgresql.v1.config.postgresql14_1c_pb2.PostgresqlConfigSet14_1C:
        """Configuration of a PostgreSQL 14 1C server."""

    @property
    def postgresql_config_15(self) -> yandex.cloud.mdb.postgresql.v1.config.postgresql15_pb2.PostgresqlConfigSet15:
        """Configuration of a PostgreSQL 15 server."""

    @property
    def postgresql_config_15_1c(self) -> yandex.cloud.mdb.postgresql.v1.config.postgresql15_1c_pb2.PostgresqlConfigSet15_1C:
        """Configuration of a PostgreSQL 15 1C server."""

    @property
    def postgresql_config_16(self) -> yandex.cloud.mdb.postgresql.v1.config.postgresql16_pb2.PostgresqlConfigSet16:
        """Configuration of a PostgreSQL 16 server."""

    @property
    def postgresql_config_16_1c(self) -> yandex.cloud.mdb.postgresql.v1.config.postgresql16_1c_pb2.PostgresqlConfigSet16_1C:
        """Configuration of a PostgreSQL 16 1C server."""

    @property
    def postgresql_config_17(self) -> yandex.cloud.mdb.postgresql.v1.config.postgresql17_pb2.PostgresqlConfigSet17:
        """Configuration of a PostgreSQL 17 server."""

    @property
    def postgresql_config_17_1c(self) -> yandex.cloud.mdb.postgresql.v1.config.postgresql17_1c_pb2.PostgresqlConfigSet17_1C:
        """Configuration of a PostgreSQL 17 1C server."""

    @property
    def pooler_config(self) -> global___ConnectionPoolerConfig:
        """Configuration of the connection pooler."""

    @property
    def resources(self) -> global___Resources:
        """Resources allocated to PostgreSQL hosts."""

    @property
    def autofailover(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Configuration setting which enables/disables autofailover in cluster."""

    @property
    def backup_window_start(self) -> google.type.timeofday_pb2.TimeOfDay:
        """Time to start the daily backup, in the UTC timezone."""

    @property
    def backup_retain_period_days(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Retention policy of automated backups."""

    @property
    def access(self) -> global___Access:
        """Access policy to DB"""

    @property
    def performance_diagnostics(self) -> global___PerformanceDiagnostics:
        """Configuration of the performance diagnostics service."""

    @property
    def disk_size_autoscaling(self) -> global___DiskSizeAutoscaling:
        """Disk size autoscaling"""

    def __init__(
        self,
        *,
        version: builtins.str = ...,
        postgresql_config_9_6: yandex.cloud.mdb.postgresql.v1.config.postgresql9_6_pb2.PostgresqlConfigSet9_6 | None = ...,
        postgresql_config_10_1c: yandex.cloud.mdb.postgresql.v1.config.postgresql10_1c_pb2.PostgresqlConfigSet10_1C | None = ...,
        postgresql_config_10: yandex.cloud.mdb.postgresql.v1.config.postgresql10_pb2.PostgresqlConfigSet10 | None = ...,
        postgresql_config_11: yandex.cloud.mdb.postgresql.v1.config.postgresql11_pb2.PostgresqlConfigSet11 | None = ...,
        postgresql_config_11_1c: yandex.cloud.mdb.postgresql.v1.config.postgresql11_1c_pb2.PostgresqlConfigSet11_1C | None = ...,
        postgresql_config_12: yandex.cloud.mdb.postgresql.v1.config.postgresql12_pb2.PostgresqlConfigSet12 | None = ...,
        postgresql_config_12_1c: yandex.cloud.mdb.postgresql.v1.config.postgresql12_1c_pb2.PostgresqlConfigSet12_1C | None = ...,
        postgresql_config_13: yandex.cloud.mdb.postgresql.v1.config.postgresql13_pb2.PostgresqlConfigSet13 | None = ...,
        postgresql_config_13_1c: yandex.cloud.mdb.postgresql.v1.config.postgresql13_1c_pb2.PostgresqlConfigSet13_1C | None = ...,
        postgresql_config_14: yandex.cloud.mdb.postgresql.v1.config.postgresql14_pb2.PostgresqlConfigSet14 | None = ...,
        postgresql_config_14_1c: yandex.cloud.mdb.postgresql.v1.config.postgresql14_1c_pb2.PostgresqlConfigSet14_1C | None = ...,
        postgresql_config_15: yandex.cloud.mdb.postgresql.v1.config.postgresql15_pb2.PostgresqlConfigSet15 | None = ...,
        postgresql_config_15_1c: yandex.cloud.mdb.postgresql.v1.config.postgresql15_1c_pb2.PostgresqlConfigSet15_1C | None = ...,
        postgresql_config_16: yandex.cloud.mdb.postgresql.v1.config.postgresql16_pb2.PostgresqlConfigSet16 | None = ...,
        postgresql_config_16_1c: yandex.cloud.mdb.postgresql.v1.config.postgresql16_1c_pb2.PostgresqlConfigSet16_1C | None = ...,
        postgresql_config_17: yandex.cloud.mdb.postgresql.v1.config.postgresql17_pb2.PostgresqlConfigSet17 | None = ...,
        postgresql_config_17_1c: yandex.cloud.mdb.postgresql.v1.config.postgresql17_1c_pb2.PostgresqlConfigSet17_1C | None = ...,
        pooler_config: global___ConnectionPoolerConfig | None = ...,
        resources: global___Resources | None = ...,
        autofailover: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        backup_window_start: google.type.timeofday_pb2.TimeOfDay | None = ...,
        backup_retain_period_days: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        access: global___Access | None = ...,
        performance_diagnostics: global___PerformanceDiagnostics | None = ...,
        disk_size_autoscaling: global___DiskSizeAutoscaling | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["access", b"access", "autofailover", b"autofailover", "backup_retain_period_days", b"backup_retain_period_days", "backup_window_start", b"backup_window_start", "disk_size_autoscaling", b"disk_size_autoscaling", "performance_diagnostics", b"performance_diagnostics", "pooler_config", b"pooler_config", "postgresql_config", b"postgresql_config", "postgresql_config_10", b"postgresql_config_10", "postgresql_config_10_1c", b"postgresql_config_10_1c", "postgresql_config_11", b"postgresql_config_11", "postgresql_config_11_1c", b"postgresql_config_11_1c", "postgresql_config_12", b"postgresql_config_12", "postgresql_config_12_1c", b"postgresql_config_12_1c", "postgresql_config_13", b"postgresql_config_13", "postgresql_config_13_1c", b"postgresql_config_13_1c", "postgresql_config_14", b"postgresql_config_14", "postgresql_config_14_1c", b"postgresql_config_14_1c", "postgresql_config_15", b"postgresql_config_15", "postgresql_config_15_1c", b"postgresql_config_15_1c", "postgresql_config_16", b"postgresql_config_16", "postgresql_config_16_1c", b"postgresql_config_16_1c", "postgresql_config_17", b"postgresql_config_17", "postgresql_config_17_1c", b"postgresql_config_17_1c", "postgresql_config_9_6", b"postgresql_config_9_6", "resources", b"resources"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["access", b"access", "autofailover", b"autofailover", "backup_retain_period_days", b"backup_retain_period_days", "backup_window_start", b"backup_window_start", "disk_size_autoscaling", b"disk_size_autoscaling", "performance_diagnostics", b"performance_diagnostics", "pooler_config", b"pooler_config", "postgresql_config", b"postgresql_config", "postgresql_config_10", b"postgresql_config_10", "postgresql_config_10_1c", b"postgresql_config_10_1c", "postgresql_config_11", b"postgresql_config_11", "postgresql_config_11_1c", b"postgresql_config_11_1c", "postgresql_config_12", b"postgresql_config_12", "postgresql_config_12_1c", b"postgresql_config_12_1c", "postgresql_config_13", b"postgresql_config_13", "postgresql_config_13_1c", b"postgresql_config_13_1c", "postgresql_config_14", b"postgresql_config_14", "postgresql_config_14_1c", b"postgresql_config_14_1c", "postgresql_config_15", b"postgresql_config_15", "postgresql_config_15_1c", b"postgresql_config_15_1c", "postgresql_config_16", b"postgresql_config_16", "postgresql_config_16_1c", b"postgresql_config_16_1c", "postgresql_config_17", b"postgresql_config_17", "postgresql_config_17_1c", b"postgresql_config_17_1c", "postgresql_config_9_6", b"postgresql_config_9_6", "resources", b"resources", "version", b"version"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["postgresql_config", b"postgresql_config"]) -> typing.Literal["postgresql_config_9_6", "postgresql_config_10_1c", "postgresql_config_10", "postgresql_config_11", "postgresql_config_11_1c", "postgresql_config_12", "postgresql_config_12_1c", "postgresql_config_13", "postgresql_config_13_1c", "postgresql_config_14", "postgresql_config_14_1c", "postgresql_config_15", "postgresql_config_15_1c", "postgresql_config_16", "postgresql_config_16_1c", "postgresql_config_17", "postgresql_config_17_1c"] | None: ...

global___ClusterConfig = ClusterConfig

@typing.final
class ConnectionPoolerConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _PoolingMode:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _PoolingModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ConnectionPoolerConfig._PoolingMode.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        POOLING_MODE_UNSPECIFIED: ConnectionPoolerConfig._PoolingMode.ValueType  # 0
        SESSION: ConnectionPoolerConfig._PoolingMode.ValueType  # 1
        """Session pooling mode."""
        TRANSACTION: ConnectionPoolerConfig._PoolingMode.ValueType  # 2
        """Transaction pooling mode."""
        STATEMENT: ConnectionPoolerConfig._PoolingMode.ValueType  # 3
        """Statement pooling mode."""

    class PoolingMode(_PoolingMode, metaclass=_PoolingModeEnumTypeWrapper): ...
    POOLING_MODE_UNSPECIFIED: ConnectionPoolerConfig.PoolingMode.ValueType  # 0
    SESSION: ConnectionPoolerConfig.PoolingMode.ValueType  # 1
    """Session pooling mode."""
    TRANSACTION: ConnectionPoolerConfig.PoolingMode.ValueType  # 2
    """Transaction pooling mode."""
    STATEMENT: ConnectionPoolerConfig.PoolingMode.ValueType  # 3
    """Statement pooling mode."""

    POOLING_MODE_FIELD_NUMBER: builtins.int
    POOL_DISCARD_FIELD_NUMBER: builtins.int
    pooling_mode: global___ConnectionPoolerConfig.PoolingMode.ValueType
    """Mode that the connection pooler is working in.
    See descriptions of all modes in the [documentation for PgBouncer](https://pgbouncer.github.io/usage).
    """
    @property
    def pool_discard(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Setting `server_reset_query_always` parameter in PgBouncer."""

    def __init__(
        self,
        *,
        pooling_mode: global___ConnectionPoolerConfig.PoolingMode.ValueType = ...,
        pool_discard: google.protobuf.wrappers_pb2.BoolValue | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["pool_discard", b"pool_discard"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["pool_discard", b"pool_discard", "pooling_mode", b"pooling_mode"]) -> None: ...

global___ConnectionPoolerConfig = ConnectionPoolerConfig

@typing.final
class Host(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Role:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _RoleEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Host._Role.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        ROLE_UNKNOWN: Host._Role.ValueType  # 0
        """Role of the host in the cluster is unknown. Default value."""
        MASTER: Host._Role.ValueType  # 1
        """Host is the master PostgreSQL server in the cluster."""
        REPLICA: Host._Role.ValueType  # 2
        """Host is a replica (standby) PostgreSQL server in the cluster."""

    class Role(_Role, metaclass=_RoleEnumTypeWrapper): ...
    ROLE_UNKNOWN: Host.Role.ValueType  # 0
    """Role of the host in the cluster is unknown. Default value."""
    MASTER: Host.Role.ValueType  # 1
    """Host is the master PostgreSQL server in the cluster."""
    REPLICA: Host.Role.ValueType  # 2
    """Host is a replica (standby) PostgreSQL server in the cluster."""

    class _ReplicaType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ReplicaTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Host._ReplicaType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        REPLICA_TYPE_UNKNOWN: Host._ReplicaType.ValueType  # 0
        """Replica type is unknown (we have no data) or it's master"""
        ASYNC: Host._ReplicaType.ValueType  # 1
        SYNC: Host._ReplicaType.ValueType  # 2
        QUORUM: Host._ReplicaType.ValueType  # 3

    class ReplicaType(_ReplicaType, metaclass=_ReplicaTypeEnumTypeWrapper): ...
    REPLICA_TYPE_UNKNOWN: Host.ReplicaType.ValueType  # 0
    """Replica type is unknown (we have no data) or it's master"""
    ASYNC: Host.ReplicaType.ValueType  # 1
    SYNC: Host.ReplicaType.ValueType  # 2
    QUORUM: Host.ReplicaType.ValueType  # 3

    class _Health:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _HealthEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Host._Health.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        HEALTH_UNKNOWN: Host._Health.ValueType  # 0
        """Health of the host is unknown. Default value."""
        ALIVE: Host._Health.ValueType  # 1
        """The host is performing all its functions normally."""
        DEAD: Host._Health.ValueType  # 2
        """The host is inoperable, and cannot perform any of its essential functions."""
        DEGRADED: Host._Health.ValueType  # 3
        """The host is degraded, and can perform only some of its essential functions."""
        READONLY: Host._Health.ValueType  # 4
        """The host is alive, but in read-only mode."""

    class Health(_Health, metaclass=_HealthEnumTypeWrapper): ...
    HEALTH_UNKNOWN: Host.Health.ValueType  # 0
    """Health of the host is unknown. Default value."""
    ALIVE: Host.Health.ValueType  # 1
    """The host is performing all its functions normally."""
    DEAD: Host.Health.ValueType  # 2
    """The host is inoperable, and cannot perform any of its essential functions."""
    DEGRADED: Host.Health.ValueType  # 3
    """The host is degraded, and can perform only some of its essential functions."""
    READONLY: Host.Health.ValueType  # 4
    """The host is alive, but in read-only mode."""

    NAME_FIELD_NUMBER: builtins.int
    CLUSTER_ID_FIELD_NUMBER: builtins.int
    ZONE_ID_FIELD_NUMBER: builtins.int
    RESOURCES_FIELD_NUMBER: builtins.int
    ROLE_FIELD_NUMBER: builtins.int
    HEALTH_FIELD_NUMBER: builtins.int
    SERVICES_FIELD_NUMBER: builtins.int
    SUBNET_ID_FIELD_NUMBER: builtins.int
    REPLICATION_SOURCE_FIELD_NUMBER: builtins.int
    PRIORITY_FIELD_NUMBER: builtins.int
    CONFIG_FIELD_NUMBER: builtins.int
    ASSIGN_PUBLIC_IP_FIELD_NUMBER: builtins.int
    REPLICA_TYPE_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the PostgreSQL host. The host name is assigned by MDB at creation time, and cannot be changed.
    1-63 characters long.

    The name is unique across all MDB hosts that exist on the platform, as it defines the FQDN of the host.
    """
    cluster_id: builtins.str
    """ID of the PostgreSQL host. The ID is assigned by MDB at creation time."""
    zone_id: builtins.str
    """ID of the availability zone where the PostgreSQL host resides."""
    role: global___Host.Role.ValueType
    """Role of the host in the cluster. If the field has default value, it is not returned in the response."""
    health: global___Host.Health.ValueType
    """Aggregated health of the host. If the field has default value, it is not returned in the response."""
    subnet_id: builtins.str
    """ID of the subnet that the host belongs to."""
    replication_source: builtins.str
    """Name of the host to be used as the replication source for cascading replication."""
    assign_public_ip: builtins.bool
    """Flag showing public IP assignment status to this host."""
    replica_type: global___Host.ReplicaType.ValueType
    @property
    def resources(self) -> global___Resources:
        """Resources allocated to the PostgreSQL host."""

    @property
    def services(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Service]:
        """Services provided by the host."""

    @property
    def priority(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Priority of the host as a replica. Higher value means higher priority.

        The host with the highest priority is the synchronous replica. All others are asynchronous.
        The synchronous replica replaces the master when needed.

        When a replica becomes the master, its priority is ignored.
        """

    @property
    def config(self) -> global___HostConfig:
        """Configuration of a PostgreSQL server for the host."""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        cluster_id: builtins.str = ...,
        zone_id: builtins.str = ...,
        resources: global___Resources | None = ...,
        role: global___Host.Role.ValueType = ...,
        health: global___Host.Health.ValueType = ...,
        services: collections.abc.Iterable[global___Service] | None = ...,
        subnet_id: builtins.str = ...,
        replication_source: builtins.str = ...,
        priority: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        config: global___HostConfig | None = ...,
        assign_public_ip: builtins.bool = ...,
        replica_type: global___Host.ReplicaType.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["config", b"config", "priority", b"priority", "resources", b"resources"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["assign_public_ip", b"assign_public_ip", "cluster_id", b"cluster_id", "config", b"config", "health", b"health", "name", b"name", "priority", b"priority", "replica_type", b"replica_type", "replication_source", b"replication_source", "resources", b"resources", "role", b"role", "services", b"services", "subnet_id", b"subnet_id", "zone_id", b"zone_id"]) -> None: ...

global___Host = Host

@typing.final
class HostConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POSTGRESQL_CONFIG_9_6_FIELD_NUMBER: builtins.int
    POSTGRESQL_CONFIG_10_1C_FIELD_NUMBER: builtins.int
    POSTGRESQL_CONFIG_10_FIELD_NUMBER: builtins.int
    POSTGRESQL_CONFIG_11_FIELD_NUMBER: builtins.int
    POSTGRESQL_CONFIG_11_1C_FIELD_NUMBER: builtins.int
    POSTGRESQL_CONFIG_12_FIELD_NUMBER: builtins.int
    POSTGRESQL_CONFIG_12_1C_FIELD_NUMBER: builtins.int
    POSTGRESQL_CONFIG_13_FIELD_NUMBER: builtins.int
    POSTGRESQL_CONFIG_13_1C_FIELD_NUMBER: builtins.int
    POSTGRESQL_CONFIG_14_FIELD_NUMBER: builtins.int
    POSTGRESQL_CONFIG_14_1C_FIELD_NUMBER: builtins.int
    POSTGRESQL_CONFIG_15_FIELD_NUMBER: builtins.int
    POSTGRESQL_CONFIG_15_1C_FIELD_NUMBER: builtins.int
    POSTGRESQL_CONFIG_16_FIELD_NUMBER: builtins.int
    POSTGRESQL_CONFIG_16_1C_FIELD_NUMBER: builtins.int
    POSTGRESQL_CONFIG_17_FIELD_NUMBER: builtins.int
    POSTGRESQL_CONFIG_17_1C_FIELD_NUMBER: builtins.int
    @property
    def postgresql_config_9_6(self) -> yandex.cloud.mdb.postgresql.v1.config.host9_6_pb2.PostgresqlHostConfig9_6:
        """Configuration for a host with PostgreSQL 9.6 server deployed."""

    @property
    def postgresql_config_10_1c(self) -> yandex.cloud.mdb.postgresql.v1.config.host10_1c_pb2.PostgresqlHostConfig10_1C:
        """Configuration for a host with PostgreSQL 10 1C server deployed."""

    @property
    def postgresql_config_10(self) -> yandex.cloud.mdb.postgresql.v1.config.host10_pb2.PostgresqlHostConfig10:
        """Configuration for a host with PostgreSQL 10 server deployed."""

    @property
    def postgresql_config_11(self) -> yandex.cloud.mdb.postgresql.v1.config.host11_pb2.PostgresqlHostConfig11:
        """Configuration for a host with PostgreSQL 11 server deployed."""

    @property
    def postgresql_config_11_1c(self) -> yandex.cloud.mdb.postgresql.v1.config.host11_1c_pb2.PostgresqlHostConfig11_1C:
        """Configuration for a host with PostgreSQL 11 1C server deployed."""

    @property
    def postgresql_config_12(self) -> yandex.cloud.mdb.postgresql.v1.config.host12_pb2.PostgresqlHostConfig12:
        """Configuration for a host with PostgreSQL 12 server deployed."""

    @property
    def postgresql_config_12_1c(self) -> yandex.cloud.mdb.postgresql.v1.config.host12_1c_pb2.PostgresqlHostConfig12_1C:
        """Configuration for a host with PostgreSQL 12 1C server deployed."""

    @property
    def postgresql_config_13(self) -> yandex.cloud.mdb.postgresql.v1.config.host13_pb2.PostgresqlHostConfig13:
        """Configuration for a host with PostgreSQL 13 server deployed."""

    @property
    def postgresql_config_13_1c(self) -> yandex.cloud.mdb.postgresql.v1.config.host13_1c_pb2.PostgresqlHostConfig13_1C:
        """Configuration for a host with PostgreSQL 13 1C server deployed."""

    @property
    def postgresql_config_14(self) -> yandex.cloud.mdb.postgresql.v1.config.host14_pb2.PostgresqlHostConfig14:
        """Configuration for a host with PostgreSQL 14 server deployed."""

    @property
    def postgresql_config_14_1c(self) -> yandex.cloud.mdb.postgresql.v1.config.host14_1c_pb2.PostgresqlHostConfig14_1C:
        """Configuration for a host with PostgreSQL 14 1C server deployed."""

    @property
    def postgresql_config_15(self) -> yandex.cloud.mdb.postgresql.v1.config.host15_pb2.PostgresqlHostConfig15:
        """Configuration for a host with PostgreSQL 15 server deployed."""

    @property
    def postgresql_config_15_1c(self) -> yandex.cloud.mdb.postgresql.v1.config.host15_1c_pb2.PostgresqlHostConfig15_1C:
        """Configuration for a host with PostgreSQL 15 1C server deployed."""

    @property
    def postgresql_config_16(self) -> yandex.cloud.mdb.postgresql.v1.config.host16_pb2.PostgresqlHostConfig16:
        """Configuration for a host with PostgreSQL 16 server deployed."""

    @property
    def postgresql_config_16_1c(self) -> yandex.cloud.mdb.postgresql.v1.config.host16_1c_pb2.PostgresqlHostConfig16_1C:
        """Configuration for a host with PostgreSQL 16 1C server deployed."""

    @property
    def postgresql_config_17(self) -> yandex.cloud.mdb.postgresql.v1.config.host17_pb2.PostgresqlHostConfig17:
        """Configuration for a host with PostgreSQL 17 server deployed."""

    @property
    def postgresql_config_17_1c(self) -> yandex.cloud.mdb.postgresql.v1.config.host17_1c_pb2.PostgresqlHostConfig17_1C:
        """Configuration for a host with PostgreSQL 17 1C server deployed."""

    def __init__(
        self,
        *,
        postgresql_config_9_6: yandex.cloud.mdb.postgresql.v1.config.host9_6_pb2.PostgresqlHostConfig9_6 | None = ...,
        postgresql_config_10_1c: yandex.cloud.mdb.postgresql.v1.config.host10_1c_pb2.PostgresqlHostConfig10_1C | None = ...,
        postgresql_config_10: yandex.cloud.mdb.postgresql.v1.config.host10_pb2.PostgresqlHostConfig10 | None = ...,
        postgresql_config_11: yandex.cloud.mdb.postgresql.v1.config.host11_pb2.PostgresqlHostConfig11 | None = ...,
        postgresql_config_11_1c: yandex.cloud.mdb.postgresql.v1.config.host11_1c_pb2.PostgresqlHostConfig11_1C | None = ...,
        postgresql_config_12: yandex.cloud.mdb.postgresql.v1.config.host12_pb2.PostgresqlHostConfig12 | None = ...,
        postgresql_config_12_1c: yandex.cloud.mdb.postgresql.v1.config.host12_1c_pb2.PostgresqlHostConfig12_1C | None = ...,
        postgresql_config_13: yandex.cloud.mdb.postgresql.v1.config.host13_pb2.PostgresqlHostConfig13 | None = ...,
        postgresql_config_13_1c: yandex.cloud.mdb.postgresql.v1.config.host13_1c_pb2.PostgresqlHostConfig13_1C | None = ...,
        postgresql_config_14: yandex.cloud.mdb.postgresql.v1.config.host14_pb2.PostgresqlHostConfig14 | None = ...,
        postgresql_config_14_1c: yandex.cloud.mdb.postgresql.v1.config.host14_1c_pb2.PostgresqlHostConfig14_1C | None = ...,
        postgresql_config_15: yandex.cloud.mdb.postgresql.v1.config.host15_pb2.PostgresqlHostConfig15 | None = ...,
        postgresql_config_15_1c: yandex.cloud.mdb.postgresql.v1.config.host15_1c_pb2.PostgresqlHostConfig15_1C | None = ...,
        postgresql_config_16: yandex.cloud.mdb.postgresql.v1.config.host16_pb2.PostgresqlHostConfig16 | None = ...,
        postgresql_config_16_1c: yandex.cloud.mdb.postgresql.v1.config.host16_1c_pb2.PostgresqlHostConfig16_1C | None = ...,
        postgresql_config_17: yandex.cloud.mdb.postgresql.v1.config.host17_pb2.PostgresqlHostConfig17 | None = ...,
        postgresql_config_17_1c: yandex.cloud.mdb.postgresql.v1.config.host17_1c_pb2.PostgresqlHostConfig17_1C | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["postgresql_config", b"postgresql_config", "postgresql_config_10", b"postgresql_config_10", "postgresql_config_10_1c", b"postgresql_config_10_1c", "postgresql_config_11", b"postgresql_config_11", "postgresql_config_11_1c", b"postgresql_config_11_1c", "postgresql_config_12", b"postgresql_config_12", "postgresql_config_12_1c", b"postgresql_config_12_1c", "postgresql_config_13", b"postgresql_config_13", "postgresql_config_13_1c", b"postgresql_config_13_1c", "postgresql_config_14", b"postgresql_config_14", "postgresql_config_14_1c", b"postgresql_config_14_1c", "postgresql_config_15", b"postgresql_config_15", "postgresql_config_15_1c", b"postgresql_config_15_1c", "postgresql_config_16", b"postgresql_config_16", "postgresql_config_16_1c", b"postgresql_config_16_1c", "postgresql_config_17", b"postgresql_config_17", "postgresql_config_17_1c", b"postgresql_config_17_1c", "postgresql_config_9_6", b"postgresql_config_9_6"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["postgresql_config", b"postgresql_config", "postgresql_config_10", b"postgresql_config_10", "postgresql_config_10_1c", b"postgresql_config_10_1c", "postgresql_config_11", b"postgresql_config_11", "postgresql_config_11_1c", b"postgresql_config_11_1c", "postgresql_config_12", b"postgresql_config_12", "postgresql_config_12_1c", b"postgresql_config_12_1c", "postgresql_config_13", b"postgresql_config_13", "postgresql_config_13_1c", b"postgresql_config_13_1c", "postgresql_config_14", b"postgresql_config_14", "postgresql_config_14_1c", b"postgresql_config_14_1c", "postgresql_config_15", b"postgresql_config_15", "postgresql_config_15_1c", b"postgresql_config_15_1c", "postgresql_config_16", b"postgresql_config_16", "postgresql_config_16_1c", b"postgresql_config_16_1c", "postgresql_config_17", b"postgresql_config_17", "postgresql_config_17_1c", b"postgresql_config_17_1c", "postgresql_config_9_6", b"postgresql_config_9_6"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["postgresql_config", b"postgresql_config"]) -> typing.Literal["postgresql_config_9_6", "postgresql_config_10_1c", "postgresql_config_10", "postgresql_config_11", "postgresql_config_11_1c", "postgresql_config_12", "postgresql_config_12_1c", "postgresql_config_13", "postgresql_config_13_1c", "postgresql_config_14", "postgresql_config_14_1c", "postgresql_config_15", "postgresql_config_15_1c", "postgresql_config_16", "postgresql_config_16_1c", "postgresql_config_17", "postgresql_config_17_1c"] | None: ...

global___HostConfig = HostConfig

@typing.final
class Service(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Type:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Service._Type.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        TYPE_UNSPECIFIED: Service._Type.ValueType  # 0
        """Service type of the host is unspecified. Default value."""
        POSTGRESQL: Service._Type.ValueType  # 1
        """The host is a PostgreSQL server."""
        POOLER: Service._Type.ValueType  # 2
        """The host is a PgBouncer server."""

    class Type(_Type, metaclass=_TypeEnumTypeWrapper): ...
    TYPE_UNSPECIFIED: Service.Type.ValueType  # 0
    """Service type of the host is unspecified. Default value."""
    POSTGRESQL: Service.Type.ValueType  # 1
    """The host is a PostgreSQL server."""
    POOLER: Service.Type.ValueType  # 2
    """The host is a PgBouncer server."""

    class _Health:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _HealthEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Service._Health.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        HEALTH_UNKNOWN: Service._Health.ValueType  # 0
        """Health of the server is unknown. Default value."""
        ALIVE: Service._Health.ValueType  # 1
        """The server is working normally."""
        DEAD: Service._Health.ValueType  # 2
        """The server is dead or unresponsive."""
        READONLY: Service._Health.ValueType  # 3
        """The server is in read-only mode."""

    class Health(_Health, metaclass=_HealthEnumTypeWrapper): ...
    HEALTH_UNKNOWN: Service.Health.ValueType  # 0
    """Health of the server is unknown. Default value."""
    ALIVE: Service.Health.ValueType  # 1
    """The server is working normally."""
    DEAD: Service.Health.ValueType  # 2
    """The server is dead or unresponsive."""
    READONLY: Service.Health.ValueType  # 3
    """The server is in read-only mode."""

    TYPE_FIELD_NUMBER: builtins.int
    HEALTH_FIELD_NUMBER: builtins.int
    type: global___Service.Type.ValueType
    """Type of the service provided by the host. If the field has default value, it is not returned in the response."""
    health: global___Service.Health.ValueType
    """Aggregated health of the service. If the field has default value, it is not returned in the response."""
    def __init__(
        self,
        *,
        type: global___Service.Type.ValueType = ...,
        health: global___Service.Health.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["health", b"health", "type", b"type"]) -> None: ...

global___Service = Service

@typing.final
class Resources(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOURCE_PRESET_ID_FIELD_NUMBER: builtins.int
    DISK_SIZE_FIELD_NUMBER: builtins.int
    DISK_TYPE_ID_FIELD_NUMBER: builtins.int
    resource_preset_id: builtins.str
    """ID of the preset for computational resources available to a host (CPU, memory etc.).
    All available presets are listed in the [documentation](/docs/managed-postgresql/concepts/instance-types).
    """
    disk_size: builtins.int
    """Volume of the storage available to a host, in bytes."""
    disk_type_id: builtins.str
    """Type of the storage environment for the host.
    Possible values:
    * network-hdd - network HDD drive,
    * network-ssd - network SSD drive,
    * local-ssd - local SSD storage.
    """
    def __init__(
        self,
        *,
        resource_preset_id: builtins.str = ...,
        disk_size: builtins.int = ...,
        disk_type_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["disk_size", b"disk_size", "disk_type_id", b"disk_type_id", "resource_preset_id", b"resource_preset_id"]) -> None: ...

global___Resources = Resources

@typing.final
class Access(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATA_LENS_FIELD_NUMBER: builtins.int
    WEB_SQL_FIELD_NUMBER: builtins.int
    SERVERLESS_FIELD_NUMBER: builtins.int
    DATA_TRANSFER_FIELD_NUMBER: builtins.int
    YANDEX_QUERY_FIELD_NUMBER: builtins.int
    data_lens: builtins.bool
    """Allow access for DataLens"""
    web_sql: builtins.bool
    """Allow SQL queries to the cluster databases from the management console.

    See [SQL queries in the management console](/docs/managed-postgresql/operations/web-sql-query) for more details.
    """
    serverless: builtins.bool
    """Allow access for Serverless"""
    data_transfer: builtins.bool
    """Allow access for DataTransfer."""
    yandex_query: builtins.bool
    """Allow access for YandexQuery."""
    def __init__(
        self,
        *,
        data_lens: builtins.bool = ...,
        web_sql: builtins.bool = ...,
        serverless: builtins.bool = ...,
        data_transfer: builtins.bool = ...,
        yandex_query: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["data_lens", b"data_lens", "data_transfer", b"data_transfer", "serverless", b"serverless", "web_sql", b"web_sql", "yandex_query", b"yandex_query"]) -> None: ...

global___Access = Access

@typing.final
class PerformanceDiagnostics(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENABLED_FIELD_NUMBER: builtins.int
    SESSIONS_SAMPLING_INTERVAL_FIELD_NUMBER: builtins.int
    STATEMENTS_SAMPLING_INTERVAL_FIELD_NUMBER: builtins.int
    enabled: builtins.bool
    """Configuration setting which enables/disables performance diagnostics service in cluster."""
    sessions_sampling_interval: builtins.int
    """Interval (in seconds) for pg_stat_activity sampling"""
    statements_sampling_interval: builtins.int
    """Interval (in seconds) for pg_stat_statements sampling"""
    def __init__(
        self,
        *,
        enabled: builtins.bool = ...,
        sessions_sampling_interval: builtins.int = ...,
        statements_sampling_interval: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["enabled", b"enabled", "sessions_sampling_interval", b"sessions_sampling_interval", "statements_sampling_interval", b"statements_sampling_interval"]) -> None: ...

global___PerformanceDiagnostics = PerformanceDiagnostics

@typing.final
class DiskSizeAutoscaling(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PLANNED_USAGE_THRESHOLD_FIELD_NUMBER: builtins.int
    EMERGENCY_USAGE_THRESHOLD_FIELD_NUMBER: builtins.int
    DISK_SIZE_LIMIT_FIELD_NUMBER: builtins.int
    planned_usage_threshold: builtins.int
    """Threshold of storage usage (in percent) that triggers automatic scaling of the storage during the maintenance window. Zero value means disabled threshold."""
    emergency_usage_threshold: builtins.int
    """Threshold of storage usage (in percent) that triggers immediate automatic scaling of the storage. Zero value means disabled threshold."""
    disk_size_limit: builtins.int
    """New storage size (in bytes) that is set when one of the thresholds is achieved."""
    def __init__(
        self,
        *,
        planned_usage_threshold: builtins.int = ...,
        emergency_usage_threshold: builtins.int = ...,
        disk_size_limit: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["disk_size_limit", b"disk_size_limit", "emergency_usage_threshold", b"emergency_usage_threshold", "planned_usage_threshold", b"planned_usage_threshold"]) -> None: ...

global___DiskSizeAutoscaling = DiskSizeAutoscaling
