"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing
import yandex.cloud.logging.v1.log_entry_pb2
import yandex.cloud.metastore.v1.maintenance_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Cluster(google.protobuf.message.Message):
    """Metastore Cluster."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Health:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _HealthEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Cluster._Health.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        HEALTH_UNKNOWN: Cluster._Health.ValueType  # 0
        """Cluster is in unknown state (we have no data)."""
        ALIVE: Cluster._Health.ValueType  # 1
        """Cluster is alive and operates properly."""
        DEAD: Cluster._Health.ValueType  # 2
        """Cluster is inoperable (it cannot perform any of its essential functions)."""
        DEGRADED: Cluster._Health.ValueType  # 3
        """Cluster is partially alive (it can perform some of its essential functions)."""

    class Health(_Health, metaclass=_HealthEnumTypeWrapper): ...
    HEALTH_UNKNOWN: Cluster.Health.ValueType  # 0
    """Cluster is in unknown state (we have no data)."""
    ALIVE: Cluster.Health.ValueType  # 1
    """Cluster is alive and operates properly."""
    DEAD: Cluster.Health.ValueType  # 2
    """Cluster is inoperable (it cannot perform any of its essential functions)."""
    DEGRADED: Cluster.Health.ValueType  # 3
    """Cluster is partially alive (it can perform some of its essential functions)."""

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Cluster._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNKNOWN: Cluster._Status.ValueType  # 0
        """Cluster state is unknown."""
        CREATING: Cluster._Status.ValueType  # 1
        """Cluster is being created."""
        RUNNING: Cluster._Status.ValueType  # 2
        """Cluster is running normally."""
        ERROR: Cluster._Status.ValueType  # 3
        """Cluster encountered a problem and cannot operate."""
        UPDATING: Cluster._Status.ValueType  # 4
        """Cluster is being updated."""
        STOPPING: Cluster._Status.ValueType  # 5
        """Cluster is stopping."""
        STOPPED: Cluster._Status.ValueType  # 6
        """Cluster stopped."""
        STARTING: Cluster._Status.ValueType  # 7
        """Cluster is starting."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNKNOWN: Cluster.Status.ValueType  # 0
    """Cluster state is unknown."""
    CREATING: Cluster.Status.ValueType  # 1
    """Cluster is being created."""
    RUNNING: Cluster.Status.ValueType  # 2
    """Cluster is running normally."""
    ERROR: Cluster.Status.ValueType  # 3
    """Cluster encountered a problem and cannot operate."""
    UPDATING: Cluster.Status.ValueType  # 4
    """Cluster is being updated."""
    STOPPING: Cluster.Status.ValueType  # 5
    """Cluster is stopping."""
    STOPPED: Cluster.Status.ValueType  # 6
    """Cluster stopped."""
    STARTING: Cluster.Status.ValueType  # 7
    """Cluster is starting."""

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    MONITORING_FIELD_NUMBER: builtins.int
    HEALTH_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    NETWORK_ID_FIELD_NUMBER: builtins.int
    ENDPOINT_IP_FIELD_NUMBER: builtins.int
    CLUSTER_CONFIG_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    LOGGING_FIELD_NUMBER: builtins.int
    NETWORK_FIELD_NUMBER: builtins.int
    MAINTENANCE_WINDOW_FIELD_NUMBER: builtins.int
    PLANNED_OPERATION_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Unique ID of the Metastore Cluster.
    This ID is assigned by Cloud in the process of creating a Trino cluster.
    """
    folder_id: builtins.str
    """ID of the folder that the Metastore Cluster belongs to."""
    name: builtins.str
    """Name of the Metastore Cluster.
    The name is unique within the folder.
    """
    description: builtins.str
    """Description of the Metastore Cluster."""
    health: global___Cluster.Health.ValueType
    """Aggregated cluster health."""
    status: global___Cluster.Status.ValueType
    """Cluster status."""
    deletion_protection: builtins.bool
    """Deletion Protection prevents deletion of the cluster."""
    version: builtins.str
    """Metastore server version."""
    network_id: builtins.str
    """Metastore network ID."""
    endpoint_ip: builtins.str
    """IP address of the Metastore server load balancer."""
    service_account_id: builtins.str
    """Service account used to access Cloud resources."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time the Metastore Cluster was created at."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Custom labels for the Metastore Cluster as `` key:value `` pairs."""

    @property
    def monitoring(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Monitoring]:
        """Monitoring systems relevant to the Metastore Cluster."""

    @property
    def cluster_config(self) -> global___ClusterConfig:
        """Configuration of the Metastore Cluster."""

    @property
    def logging(self) -> global___LoggingConfig:
        """Cloud logging configuration."""

    @property
    def network(self) -> global___NetworkConfig:
        """Network-related configuration options."""

    @property
    def maintenance_window(self) -> yandex.cloud.metastore.v1.maintenance_pb2.MaintenanceWindow:
        """Maintenance window."""

    @property
    def planned_operation(self) -> yandex.cloud.metastore.v1.maintenance_pb2.MaintenanceOperation:
        """Maintenance operation scheduled for the nearest maintenance window."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        folder_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        monitoring: collections.abc.Iterable[global___Monitoring] | None = ...,
        health: global___Cluster.Health.ValueType = ...,
        status: global___Cluster.Status.ValueType = ...,
        deletion_protection: builtins.bool = ...,
        version: builtins.str = ...,
        network_id: builtins.str = ...,
        endpoint_ip: builtins.str = ...,
        cluster_config: global___ClusterConfig | None = ...,
        service_account_id: builtins.str = ...,
        logging: global___LoggingConfig | None = ...,
        network: global___NetworkConfig | None = ...,
        maintenance_window: yandex.cloud.metastore.v1.maintenance_pb2.MaintenanceWindow | None = ...,
        planned_operation: yandex.cloud.metastore.v1.maintenance_pb2.MaintenanceOperation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["cluster_config", b"cluster_config", "created_at", b"created_at", "logging", b"logging", "maintenance_window", b"maintenance_window", "network", b"network", "planned_operation", b"planned_operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cluster_config", b"cluster_config", "created_at", b"created_at", "deletion_protection", b"deletion_protection", "description", b"description", "endpoint_ip", b"endpoint_ip", "folder_id", b"folder_id", "health", b"health", "id", b"id", "labels", b"labels", "logging", b"logging", "maintenance_window", b"maintenance_window", "monitoring", b"monitoring", "name", b"name", "network", b"network", "network_id", b"network_id", "planned_operation", b"planned_operation", "service_account_id", b"service_account_id", "status", b"status", "version", b"version"]) -> None: ...

global___Cluster = Cluster

@typing.final
class Monitoring(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LINK_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the monitoring system."""
    description: builtins.str
    """Description of the monitoring system."""
    link: builtins.str
    """Link to the monitoring system."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        description: builtins.str = ...,
        link: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "link", b"link", "name", b"name"]) -> None: ...

global___Monitoring = Monitoring

@typing.final
class ClusterConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOURCES_FIELD_NUMBER: builtins.int
    @property
    def resources(self) -> global___Resources:
        """Configuration for computational resources for Metastore server instances."""

    def __init__(
        self,
        *,
        resources: global___Resources | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["resources", b"resources"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["resources", b"resources"]) -> None: ...

global___ClusterConfig = ClusterConfig

@typing.final
class NetworkConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUBNET_IDS_FIELD_NUMBER: builtins.int
    SECURITY_GROUP_IDS_FIELD_NUMBER: builtins.int
    @property
    def subnet_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """IDs of VPC network subnets where instances of the cluster are attached."""

    @property
    def security_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """User security groups."""

    def __init__(
        self,
        *,
        subnet_ids: collections.abc.Iterable[builtins.str] | None = ...,
        security_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["security_group_ids", b"security_group_ids", "subnet_ids", b"subnet_ids"]) -> None: ...

global___NetworkConfig = NetworkConfig

@typing.final
class Resources(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOURCE_PRESET_ID_FIELD_NUMBER: builtins.int
    resource_preset_id: builtins.str
    """ID of the preset for computational resources allocated to an instance (e.g., CPU, memory, etc.)."""
    def __init__(
        self,
        *,
        resource_preset_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["resource_preset_id", b"resource_preset_id"]) -> None: ...

global___Resources = Resources

@typing.final
class LoggingConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENABLED_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    LOG_GROUP_ID_FIELD_NUMBER: builtins.int
    MIN_LEVEL_FIELD_NUMBER: builtins.int
    enabled: builtins.bool
    """Logs generated by the Metastore server are delivered to Cloud Logging."""
    folder_id: builtins.str
    """Logs will be written to the default log group of the specified folder."""
    log_group_id: builtins.str
    """Logs will be written to the log group specified by its ID."""
    min_level: yandex.cloud.logging.v1.log_entry_pb2.LogLevel.Level.ValueType
    """Minimum severity level for log entries.

    See [LogLevel.Level] for details.
    """
    def __init__(
        self,
        *,
        enabled: builtins.bool = ...,
        folder_id: builtins.str = ...,
        log_group_id: builtins.str = ...,
        min_level: yandex.cloud.logging.v1.log_entry_pb2.LogLevel.Level.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["destination", b"destination", "folder_id", b"folder_id", "log_group_id", b"log_group_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["destination", b"destination", "enabled", b"enabled", "folder_id", b"folder_id", "log_group_id", b"log_group_id", "min_level", b"min_level"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["destination", b"destination"]) -> typing.Literal["folder_id", "log_group_id"] | None: ...

global___LoggingConfig = LoggingConfig
