"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing
import yandex.cloud.operation.operation_pb2
import yandex.cloud.organizationmanager.v1.group_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetGroupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GROUP_ID_FIELD_NUMBER: builtins.int
    group_id: builtins.str
    """ID of the Group resource to return.
    To get the group ID, use a [GroupService.List] request.
    """
    def __init__(
        self,
        *,
        group_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["group_id", b"group_id"]) -> None: ...

global___GetGroupRequest = GetGroupRequest

@typing.final
class ResolveExternalGroupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUBJECT_CONTAINER_ID_FIELD_NUMBER: builtins.int
    EXTERNAL_ID_FIELD_NUMBER: builtins.int
    subject_container_id: builtins.str
    """Id of the subject container that external group belongs to
    To get subject container, use a [yandex.cloud.organizationmanager.v1.saml.FederationService.List] request
    or [yandex.cloud.organizationmanager.v1.idp.UserpoolService.List] request.
    """
    external_id: builtins.str
    """Id of the group from external system"""
    def __init__(
        self,
        *,
        subject_container_id: builtins.str = ...,
        external_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["external_id", b"external_id", "subject_container_id", b"subject_container_id"]) -> None: ...

global___ResolveExternalGroupRequest = ResolveExternalGroupRequest

@typing.final
class ListGroupsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ORGANIZATION_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    organization_id: builtins.str
    """ID of the organization to list groups in.
    To get the organization ID, use a [yandex.cloud.organizationmanager.v1.OrganizationService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size],
    the service returns a [ListGroupsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    Default value: 100.
    """
    page_token: builtins.str
    """Page token. Set [page_token]
    to the [ListGroupsResponse.next_page_token]
    returned by a previous list request to get the next page of results.
    """
    filter: builtins.str
    """A filter expression that filters resources listed in the response.
    The expression must specify:
    1. The field name. Currently you can use filtering only on the [Group.name] field.
    2. An `=` operator.
    3. The value in double quotes (`"`). Must be 3-63 characters long and match the regular expression `[a-z][-a-z0-9]{1,61}[a-z0-9]`.
    """
    def __init__(
        self,
        *,
        organization_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "organization_id", b"organization_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListGroupsRequest = ListGroupsRequest

@typing.final
class ListGroupsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GROUPS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is larger than [ListGroupsRequest.page_size], use
    the [next_page_token] as the value
    for the [ListGroupsRequest.page_token] query parameter
    in the next list request. Each subsequent list request will have its own
    [next_page_token] to continue paging through the results.
    """
    @property
    def groups(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.organizationmanager.v1.group_pb2.Group]:
        """List of Group resources."""

    def __init__(
        self,
        *,
        groups: collections.abc.Iterable[yandex.cloud.organizationmanager.v1.group_pb2.Group] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["groups", b"groups", "next_page_token", b"next_page_token"]) -> None: ...

global___ListGroupsResponse = ListGroupsResponse

@typing.final
class ListExternalGroupsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUBJECT_CONTAINER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    subject_container_id: builtins.str
    """Id of the subject container that external group belongs to.
    To get subject container, use a [yandex.cloud.organizationmanager.v1.saml.FederationService.List] request
    or [yandex.cloud.organizationmanager.v1.idp.UserpoolService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size],
    the service returns a [ListExternalGroupsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    Default value: 100.
    """
    page_token: builtins.str
    """Page token. Set [page_token]
    to the [ListExternalGroupsResponse.next_page_token]
    returned by a previous list external request to get the next page of results.
    """
    filter: builtins.str
    """A filter expression that filters resources listed in the response.
    The expression must specify:
    1. The fields name or id. Currently you can use filtering only on the [Group.name] or [Group.id] fields.
    2. An `=` operator.
    3. The value in double quotes (`"`). Must be 3-63 characters long and match the regular expression `[a-z][-a-z0-9]{1,61}[a-z0-9]`.
    """
    def __init__(
        self,
        *,
        subject_container_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "subject_container_id", b"subject_container_id"]) -> None: ...

global___ListExternalGroupsRequest = ListExternalGroupsRequest

@typing.final
class ListExternalGroupsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GROUPS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is larger than [ListExternalGroupsRequest.page_size], use
    the [next_page_token] as the value
    for the [ListExternalGroupsRequest.page_token] query parameter
    in the next list request. Each subsequent list request will have its own
    [next_page_token] to continue paging through the results.
    """
    @property
    def groups(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.organizationmanager.v1.group_pb2.Group]:
        """List of External group resources."""

    def __init__(
        self,
        *,
        groups: collections.abc.Iterable[yandex.cloud.organizationmanager.v1.group_pb2.Group] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["groups", b"groups", "next_page_token", b"next_page_token"]) -> None: ...

global___ListExternalGroupsResponse = ListExternalGroupsResponse

@typing.final
class CreateGroupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ORGANIZATION_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    organization_id: builtins.str
    """ID of the organization to create a group in.
    To get the organization ID, use a [yandex.cloud.organizationmanager.v1.OrganizationService.List] request.
    """
    name: builtins.str
    """Name of the group.
    The name must be unique within the organization.
    """
    description: builtins.str
    """Description of the group."""
    def __init__(
        self,
        *,
        organization_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "name", b"name", "organization_id", b"organization_id"]) -> None: ...

global___CreateGroupRequest = CreateGroupRequest

@typing.final
class CreateGroupMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GROUP_ID_FIELD_NUMBER: builtins.int
    group_id: builtins.str
    """ID of the group that is being created."""
    def __init__(
        self,
        *,
        group_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["group_id", b"group_id"]) -> None: ...

global___CreateGroupMetadata = CreateGroupMetadata

@typing.final
class CreateExternalGroupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ORGANIZATION_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    SUBJECT_CONTAINER_ID_FIELD_NUMBER: builtins.int
    EXTERNAL_ID_FIELD_NUMBER: builtins.int
    MAKE_EDITOR_FIELD_NUMBER: builtins.int
    organization_id: builtins.str
    """ID of the organization to create a group in.
    To get the organization ID, use a [yandex.cloud.organizationmanager.v1.OrganizationService.List] request.
    """
    name: builtins.str
    """Name of the group.
    The name must be unique within the organization.
    """
    description: builtins.str
    """Description of the group."""
    subject_container_id: builtins.str
    """Id of the subject container that external group belongs to.
    Combination of subject_container_id and external_id must be unique.
    To get subject container, use a [yandex.cloud.organizationmanager.v1.saml.FederationService.List] request
    or [yandex.cloud.organizationmanager.v1.idp.UserpoolService.List] request.
    """
    external_id: builtins.str
    """Id of the group from external system.
    Combination of subject_container_id and external_id must be unique
    """
    make_editor: builtins.bool
    """If true, then creator of group will be assigned to role that allows modification of group as external group."""
    def __init__(
        self,
        *,
        organization_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        subject_container_id: builtins.str = ...,
        external_id: builtins.str = ...,
        make_editor: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "external_id", b"external_id", "make_editor", b"make_editor", "name", b"name", "organization_id", b"organization_id", "subject_container_id", b"subject_container_id"]) -> None: ...

global___CreateExternalGroupRequest = CreateExternalGroupRequest

@typing.final
class CreateExternalGroupMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GROUP_ID_FIELD_NUMBER: builtins.int
    ORGANIZATION_ID_FIELD_NUMBER: builtins.int
    GROUP_NAME_FIELD_NUMBER: builtins.int
    SUBJECT_CONTAINER_ID_FIELD_NUMBER: builtins.int
    EXTERNAL_ID_FIELD_NUMBER: builtins.int
    MAKE_EDITOR_FIELD_NUMBER: builtins.int
    group_id: builtins.str
    """ID of the group that is being created."""
    organization_id: builtins.str
    """ID of the organization that the group belongs to."""
    group_name: builtins.str
    """Name of the group."""
    subject_container_id: builtins.str
    """Id of the subject container that created external group belongs to."""
    external_id: builtins.str
    """Id of the created group from external system."""
    make_editor: builtins.bool
    """If true, then creator of group was assigned to role that allows modification of group as external group."""
    def __init__(
        self,
        *,
        group_id: builtins.str = ...,
        organization_id: builtins.str = ...,
        group_name: builtins.str = ...,
        subject_container_id: builtins.str = ...,
        external_id: builtins.str = ...,
        make_editor: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["external_id", b"external_id", "group_id", b"group_id", "group_name", b"group_name", "make_editor", b"make_editor", "organization_id", b"organization_id", "subject_container_id", b"subject_container_id"]) -> None: ...

global___CreateExternalGroupMetadata = CreateExternalGroupMetadata

@typing.final
class UpdateGroupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GROUP_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    group_id: builtins.str
    """ID of the Group resource to update.
    To get the group ID, use a [GroupService.List] request.
    """
    name: builtins.str
    """Name of the group.
    The name must be unique within the organization.
    """
    description: builtins.str
    """Description of the group."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which fields of the Group resource are going to be updated."""

    def __init__(
        self,
        *,
        group_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "group_id", b"group_id", "name", b"name", "update_mask", b"update_mask"]) -> None: ...

global___UpdateGroupRequest = UpdateGroupRequest

@typing.final
class UpdateGroupMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GROUP_ID_FIELD_NUMBER: builtins.int
    group_id: builtins.str
    """ID of the Group resource that is being updated."""
    def __init__(
        self,
        *,
        group_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["group_id", b"group_id"]) -> None: ...

global___UpdateGroupMetadata = UpdateGroupMetadata

@typing.final
class ConvertToExternalGroupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GROUP_ID_FIELD_NUMBER: builtins.int
    SUBJECT_CONTAINER_ID_FIELD_NUMBER: builtins.int
    EXTERNAL_ID_FIELD_NUMBER: builtins.int
    MAKE_EDITOR_FIELD_NUMBER: builtins.int
    group_id: builtins.str
    """ID of the Group resource to convert to external.
    To get the group ID, use a [GroupService.List] request.
    """
    subject_container_id: builtins.str
    """Id of the subject container that external group belongs to.
    Combination of subject_container_id and external_id must be unique.
    To get subject container, use a [yandex.cloud.organizationmanager.v1.saml.FederationService.List] request
    or [yandex.cloud.organizationmanager.v1.idp.UserpoolService.List] request.
    """
    external_id: builtins.str
    """Id of the group from external system.
    Combination of subject_container_id and external_id must be unique
    """
    make_editor: builtins.bool
    """If true, then subject that performs conversion of group will be assigned to role that allows modification of group as external group."""
    def __init__(
        self,
        *,
        group_id: builtins.str = ...,
        subject_container_id: builtins.str = ...,
        external_id: builtins.str = ...,
        make_editor: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["external_id", b"external_id", "group_id", b"group_id", "make_editor", b"make_editor", "subject_container_id", b"subject_container_id"]) -> None: ...

global___ConvertToExternalGroupRequest = ConvertToExternalGroupRequest

@typing.final
class ConvertToExternalGroupMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GROUP_ID_FIELD_NUMBER: builtins.int
    SUBJECT_CONTAINER_ID_FIELD_NUMBER: builtins.int
    EXTERNAL_ID_FIELD_NUMBER: builtins.int
    MAKE_EDITOR_FIELD_NUMBER: builtins.int
    group_id: builtins.str
    """ID of the Group resource that is being converted to external."""
    subject_container_id: builtins.str
    """Id of the subject container that created external group belongs to."""
    external_id: builtins.str
    """Id of the created group from external system."""
    make_editor: builtins.bool
    """If true, then subject that performed conversion of group was assigned to role that allows modification of group as external group."""
    def __init__(
        self,
        *,
        group_id: builtins.str = ...,
        subject_container_id: builtins.str = ...,
        external_id: builtins.str = ...,
        make_editor: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["external_id", b"external_id", "group_id", b"group_id", "make_editor", b"make_editor", "subject_container_id", b"subject_container_id"]) -> None: ...

global___ConvertToExternalGroupMetadata = ConvertToExternalGroupMetadata

@typing.final
class ConvertAllToBasicGroupsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUBJECT_CONTAINER_ID_FIELD_NUMBER: builtins.int
    subject_container_id: builtins.str
    """Id of the subject container for which all external groups will be converted to basic (not external) groups.
    To get subject container, use a [yandex.cloud.organizationmanager.v1.saml.FederationService.List] request
    or [yandex.cloud.organizationmanager.v1.idp.UserpoolService.List] request.
    """
    def __init__(
        self,
        *,
        subject_container_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["subject_container_id", b"subject_container_id"]) -> None: ...

global___ConvertAllToBasicGroupsRequest = ConvertAllToBasicGroupsRequest

@typing.final
class ConvertAllToBasicGroupsMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUBJECT_CONTAINER_ID_FIELD_NUMBER: builtins.int
    subject_container_id: builtins.str
    """Id of the subject container for which all external groups were converted to basic (not external) groups"""
    def __init__(
        self,
        *,
        subject_container_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["subject_container_id", b"subject_container_id"]) -> None: ...

global___ConvertAllToBasicGroupsMetadata = ConvertAllToBasicGroupsMetadata

@typing.final
class DeleteGroupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GROUP_ID_FIELD_NUMBER: builtins.int
    group_id: builtins.str
    """ID of the group to delete.
    To get the group ID, use a [GroupService.List] request.
    """
    def __init__(
        self,
        *,
        group_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["group_id", b"group_id"]) -> None: ...

global___DeleteGroupRequest = DeleteGroupRequest

@typing.final
class DeleteGroupMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GROUP_ID_FIELD_NUMBER: builtins.int
    group_id: builtins.str
    """ID of the group that is being deleted."""
    def __init__(
        self,
        *,
        group_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["group_id", b"group_id"]) -> None: ...

global___DeleteGroupMetadata = DeleteGroupMetadata

@typing.final
class ListGroupOperationsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GROUP_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    group_id: builtins.str
    """ID of the Group resource to list operations for."""
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size], the service returns a [ListGroupOperationsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    Default value: 100.
    """
    page_token: builtins.str
    """Page token. Set [page_token]
    to the [ListGroupOperationsResponse.next_page_token]
    returned by a previous list request to get the next page of results.
    """
    def __init__(
        self,
        *,
        group_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["group_id", b"group_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListGroupOperationsRequest = ListGroupOperationsRequest

@typing.final
class ListGroupOperationsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is larger than [ListGroupOperationsRequest.page_size], use the [next_page_token] as the value
    for the [ListGroupOperationsRequest.page_token] query parameter in the next list request.
    Each subsequent list request will have its own [next_page_token] to continue paging through the results.
    """
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.operation.operation_pb2.Operation]:
        """List of operations for the specified group."""

    def __init__(
        self,
        *,
        operations: collections.abc.Iterable[yandex.cloud.operation.operation_pb2.Operation] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "operations", b"operations"]) -> None: ...

global___ListGroupOperationsResponse = ListGroupOperationsResponse

@typing.final
class ListGroupMembersRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GROUP_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    group_id: builtins.str
    """ID of the Group resource to list members for."""
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size], the service returns a [ListGroupMembersResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    Acceptable values are 0 to 1000, inclusive. Default value: 100.
    """
    page_token: builtins.str
    """Page token. Set [page_token]
    to the [ListGroupMembersResponse.next_page_token]
    returned by a previous list request to get the next page of results.
    """
    def __init__(
        self,
        *,
        group_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["group_id", b"group_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListGroupMembersRequest = ListGroupMembersRequest

@typing.final
class ListGroupMembersResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MEMBERS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is larger than [ListGroupMembersRequest.page_size], use the [next_page_token] as the value
    for the [ListGroupMembersRequest.page_token] query parameter in the next list request.
    Each subsequent list request will have its own [next_page_token] to continue paging through the results.
    """
    @property
    def members(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___GroupMember]:
        """List of members for the specified group."""

    def __init__(
        self,
        *,
        members: collections.abc.Iterable[global___GroupMember] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["members", b"members", "next_page_token", b"next_page_token"]) -> None: ...

global___ListGroupMembersResponse = ListGroupMembersResponse

@typing.final
class GroupMember(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUBJECT_ID_FIELD_NUMBER: builtins.int
    SUBJECT_TYPE_FIELD_NUMBER: builtins.int
    subject_id: builtins.str
    """ID of the subject."""
    subject_type: builtins.str
    """Type of the subject.

    It can contain one of the following values:
    * `userAccount`: An account on Yandex, added to Yandex Cloud.
    * `federatedUser`: A federated account. This type represents a user from an identity federation, like Active Directory.
    """
    def __init__(
        self,
        *,
        subject_id: builtins.str = ...,
        subject_type: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["subject_id", b"subject_id", "subject_type", b"subject_type"]) -> None: ...

global___GroupMember = GroupMember

@typing.final
class UpdateGroupMembersRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GROUP_ID_FIELD_NUMBER: builtins.int
    MEMBER_DELTAS_FIELD_NUMBER: builtins.int
    group_id: builtins.str
    """ID of the group to update.
    To get the group ID, use a [GroupService.List] request.
    """
    @property
    def member_deltas(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___MemberDelta]:
        """Updates to group members."""

    def __init__(
        self,
        *,
        group_id: builtins.str = ...,
        member_deltas: collections.abc.Iterable[global___MemberDelta] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["group_id", b"group_id", "member_deltas", b"member_deltas"]) -> None: ...

global___UpdateGroupMembersRequest = UpdateGroupMembersRequest

@typing.final
class UpdateGroupMembersMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GROUP_ID_FIELD_NUMBER: builtins.int
    group_id: builtins.str
    """ID of the group that is being updated."""
    def __init__(
        self,
        *,
        group_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["group_id", b"group_id"]) -> None: ...

global___UpdateGroupMembersMetadata = UpdateGroupMembersMetadata

@typing.final
class MemberDelta(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _MemberAction:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _MemberActionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[MemberDelta._MemberAction.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        MEMBER_ACTION_UNSPECIFIED: MemberDelta._MemberAction.ValueType  # 0
        ADD: MemberDelta._MemberAction.ValueType  # 1
        """Addition of a group member."""
        REMOVE: MemberDelta._MemberAction.ValueType  # 2
        """Removal of a group member."""

    class MemberAction(_MemberAction, metaclass=_MemberActionEnumTypeWrapper): ...
    MEMBER_ACTION_UNSPECIFIED: MemberDelta.MemberAction.ValueType  # 0
    ADD: MemberDelta.MemberAction.ValueType  # 1
    """Addition of a group member."""
    REMOVE: MemberDelta.MemberAction.ValueType  # 2
    """Removal of a group member."""

    ACTION_FIELD_NUMBER: builtins.int
    SUBJECT_ID_FIELD_NUMBER: builtins.int
    action: global___MemberDelta.MemberAction.ValueType
    """The action that is being performed on a group member."""
    subject_id: builtins.str
    """ID of the subject that is being added or removed from a group.

    Subject type can be one of following values:
    * `userAccount`: An account on Yandex, added to Yandex Cloud.
    * `federatedUser`: A federated account. This type represents a user from an identity federation, like Active Directory.
    """
    def __init__(
        self,
        *,
        action: global___MemberDelta.MemberAction.ValueType = ...,
        subject_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["action", b"action", "subject_id", b"subject_id"]) -> None: ...

global___MemberDelta = MemberDelta
