"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import google.protobuf.descriptor
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class User(google.protobuf.message.Message):
    """A user in the Identity Provider system.

    Users are created within a userpool and can authenticate to access cloud resources.
    Each user has a unique identifier, credentials, and profile information.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[User._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: User._Status.ValueType  # 0
        """The status is not specified."""
        CREATING: User._Status.ValueType  # 4
        """The user is in the process of being created."""
        ACTIVE: User._Status.ValueType  # 1
        """The user is active and can authenticate.
        Active users have full access to the system according to their permissions.
        """
        SUSPENDED: User._Status.ValueType  # 2
        """The user is suspended and cannot authenticate.
        Suspended users retain their data but cannot access the system.
        """
        DELETING: User._Status.ValueType  # 3
        """The user is in the process of being deleted.
        This is a transitional state before the user is completely removed from the system.
        """

    class Status(_Status, metaclass=_StatusEnumTypeWrapper):
        """Represents the current status of a user in the Identity Provider system."""

    STATUS_UNSPECIFIED: User.Status.ValueType  # 0
    """The status is not specified."""
    CREATING: User.Status.ValueType  # 4
    """The user is in the process of being created."""
    ACTIVE: User.Status.ValueType  # 1
    """The user is active and can authenticate.
    Active users have full access to the system according to their permissions.
    """
    SUSPENDED: User.Status.ValueType  # 2
    """The user is suspended and cannot authenticate.
    Suspended users retain their data but cannot access the system.
    """
    DELETING: User.Status.ValueType  # 3
    """The user is in the process of being deleted.
    This is a transitional state before the user is completely removed from the system.
    """

    ID_FIELD_NUMBER: builtins.int
    USERPOOL_ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    USERNAME_FIELD_NUMBER: builtins.int
    FULL_NAME_FIELD_NUMBER: builtins.int
    GIVEN_NAME_FIELD_NUMBER: builtins.int
    FAMILY_NAME_FIELD_NUMBER: builtins.int
    EMAIL_FIELD_NUMBER: builtins.int
    PHONE_NUMBER_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    UPDATED_AT_FIELD_NUMBER: builtins.int
    EXTERNAL_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Unique identifier of the user.
    This ID is generated automatically when the user is created.
    """
    userpool_id: builtins.str
    """ID of the userpool this user belongs to.
    To get the userpool ID, make a [UserpoolService.List] request.
    """
    status: global___User.Status.ValueType
    """Current status of the user.
    Determines whether the user can authenticate and access the system.
    """
    username: builtins.str
    """Username used for authentication.
    Usually in the format of an email address.
    """
    full_name: builtins.str
    """User's full name (display name).
    This is typically shown in the UI and used for identification purposes.
    """
    given_name: builtins.str
    """User's first name.
    Part of the user's profile information.
    """
    family_name: builtins.str
    """User's last name.
    Part of the user's profile information.
    """
    email: builtins.str
    """User's email address."""
    phone_number: builtins.str
    """User's phone number."""
    external_id: builtins.str
    """External identifier for federation with external identity systems.
    This ID can be used to link this user with an account in an external system.
    """
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp when the user was created."""

    @property
    def updated_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp when the user was last updated."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        userpool_id: builtins.str = ...,
        status: global___User.Status.ValueType = ...,
        username: builtins.str = ...,
        full_name: builtins.str = ...,
        given_name: builtins.str = ...,
        family_name: builtins.str = ...,
        email: builtins.str = ...,
        phone_number: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        updated_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        external_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at", "updated_at", b"updated_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["created_at", b"created_at", "email", b"email", "external_id", b"external_id", "family_name", b"family_name", "full_name", b"full_name", "given_name", b"given_name", "id", b"id", "phone_number", b"phone_number", "status", b"status", "updated_at", b"updated_at", "username", b"username", "userpool_id", b"userpool_id"]) -> None: ...

global___User = User
