"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import google.protobuf.wrappers_pb2
import sys
import typing
import yandex.cloud.organizationmanager.v1.idp.user_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetUserRequest(google.protobuf.message.Message):
    """Request to get a user by ID."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_ID_FIELD_NUMBER: builtins.int
    user_id: builtins.str
    """ID of the user to return."""
    def __init__(
        self,
        *,
        user_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["user_id", b"user_id"]) -> None: ...

global___GetUserRequest = GetUserRequest

@typing.final
class ListUsersRequest(google.protobuf.message.Message):
    """Request to list users in a userpool."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USERPOOL_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    userpool_id: builtins.str
    """ID of the userpool to list users in."""
    page_size: builtins.int
    """The maximum number of results per page to return."""
    page_token: builtins.str
    """Page token for pagination."""
    filter: builtins.str
    """A filter expression that filters resources listed in the response."""
    def __init__(
        self,
        *,
        userpool_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "userpool_id", b"userpool_id"]) -> None: ...

global___ListUsersRequest = ListUsersRequest

@typing.final
class ListUsersResponse(google.protobuf.message.Message):
    """Response message for [UserService.List]."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USERS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list."""
    @property
    def users(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.organizationmanager.v1.idp.user_pb2.User]:
        """List of users."""

    def __init__(
        self,
        *,
        users: collections.abc.Iterable[yandex.cloud.organizationmanager.v1.idp.user_pb2.User] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "users", b"users"]) -> None: ...

global___ListUsersResponse = ListUsersResponse

@typing.final
class CreateUserRequest(google.protobuf.message.Message):
    """Request to create a new user."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USERPOOL_ID_FIELD_NUMBER: builtins.int
    USERNAME_FIELD_NUMBER: builtins.int
    FULL_NAME_FIELD_NUMBER: builtins.int
    GIVEN_NAME_FIELD_NUMBER: builtins.int
    FAMILY_NAME_FIELD_NUMBER: builtins.int
    EMAIL_FIELD_NUMBER: builtins.int
    PHONE_NUMBER_FIELD_NUMBER: builtins.int
    PASSWORD_SPEC_FIELD_NUMBER: builtins.int
    PASSWORD_HASH_FIELD_NUMBER: builtins.int
    IS_ACTIVE_FIELD_NUMBER: builtins.int
    EXTERNAL_ID_FIELD_NUMBER: builtins.int
    userpool_id: builtins.str
    """ID of the userpool to create the user in."""
    username: builtins.str
    """Username for the new user."""
    full_name: builtins.str
    """Full name of the user."""
    given_name: builtins.str
    """First name of the user."""
    family_name: builtins.str
    """Last name of the user."""
    email: builtins.str
    """Email address of the user."""
    phone_number: builtins.str
    """Phone number of the user."""
    external_id: builtins.str
    """External identifier for the user."""
    @property
    def password_spec(self) -> global___PasswordSpec:
        """Password specification."""

    @property
    def password_hash(self) -> global___PasswordHash:
        """Password hash."""

    @property
    def is_active(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Whether the user is active. Default is true."""

    def __init__(
        self,
        *,
        userpool_id: builtins.str = ...,
        username: builtins.str = ...,
        full_name: builtins.str = ...,
        given_name: builtins.str = ...,
        family_name: builtins.str = ...,
        email: builtins.str = ...,
        phone_number: builtins.str = ...,
        password_spec: global___PasswordSpec | None = ...,
        password_hash: global___PasswordHash | None = ...,
        is_active: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        external_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["credentials", b"credentials", "is_active", b"is_active", "password_hash", b"password_hash", "password_spec", b"password_spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["credentials", b"credentials", "email", b"email", "external_id", b"external_id", "family_name", b"family_name", "full_name", b"full_name", "given_name", b"given_name", "is_active", b"is_active", "password_hash", b"password_hash", "password_spec", b"password_spec", "phone_number", b"phone_number", "username", b"username", "userpool_id", b"userpool_id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["credentials", b"credentials"]) -> typing.Literal["password_spec", "password_hash"] | None: ...

global___CreateUserRequest = CreateUserRequest

@typing.final
class CreateUserMetadata(google.protobuf.message.Message):
    """Metadata for the [UserService.Create] operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_ID_FIELD_NUMBER: builtins.int
    user_id: builtins.str
    """ID of the user that is being created."""
    def __init__(
        self,
        *,
        user_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["user_id", b"user_id"]) -> None: ...

global___CreateUserMetadata = CreateUserMetadata

@typing.final
class UpdateUserRequest(google.protobuf.message.Message):
    """Request to update an existing user."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    USERNAME_FIELD_NUMBER: builtins.int
    FULL_NAME_FIELD_NUMBER: builtins.int
    GIVEN_NAME_FIELD_NUMBER: builtins.int
    FAMILY_NAME_FIELD_NUMBER: builtins.int
    EMAIL_FIELD_NUMBER: builtins.int
    PHONE_NUMBER_FIELD_NUMBER: builtins.int
    user_id: builtins.str
    """ID of the user to update."""
    username: builtins.str
    """New username for the user."""
    full_name: builtins.str
    """New full name for the user."""
    given_name: builtins.str
    """New first name for the user."""
    family_name: builtins.str
    """New last name for the user."""
    email: builtins.str
    """New email address for the user."""
    phone_number: builtins.str
    """New phone number for the user."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which fields of the user are going to be updated."""

    def __init__(
        self,
        *,
        user_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        username: builtins.str = ...,
        full_name: builtins.str = ...,
        given_name: builtins.str = ...,
        family_name: builtins.str = ...,
        email: builtins.str = ...,
        phone_number: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["email", b"email", "family_name", b"family_name", "full_name", b"full_name", "given_name", b"given_name", "phone_number", b"phone_number", "update_mask", b"update_mask", "user_id", b"user_id", "username", b"username"]) -> None: ...

global___UpdateUserRequest = UpdateUserRequest

@typing.final
class UpdateUserMetadata(google.protobuf.message.Message):
    """Metadata for the [UserService.Update] operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_ID_FIELD_NUMBER: builtins.int
    user_id: builtins.str
    """ID of the user that is being updated."""
    def __init__(
        self,
        *,
        user_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["user_id", b"user_id"]) -> None: ...

global___UpdateUserMetadata = UpdateUserMetadata

@typing.final
class DeleteUserRequest(google.protobuf.message.Message):
    """Request to delete a user."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_ID_FIELD_NUMBER: builtins.int
    user_id: builtins.str
    """ID of the user to delete."""
    def __init__(
        self,
        *,
        user_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["user_id", b"user_id"]) -> None: ...

global___DeleteUserRequest = DeleteUserRequest

@typing.final
class DeleteUserMetadata(google.protobuf.message.Message):
    """Metadata for the [UserService.Delete] operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_ID_FIELD_NUMBER: builtins.int
    user_id: builtins.str
    """ID of the user that is being deleted."""
    def __init__(
        self,
        *,
        user_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["user_id", b"user_id"]) -> None: ...

global___DeleteUserMetadata = DeleteUserMetadata

@typing.final
class SuspendUserRequest(google.protobuf.message.Message):
    """Request to suspend a user."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_ID_FIELD_NUMBER: builtins.int
    REASON_FIELD_NUMBER: builtins.int
    user_id: builtins.str
    """ID of the user to suspend."""
    reason: builtins.str
    """Reason for suspending the user."""
    def __init__(
        self,
        *,
        user_id: builtins.str = ...,
        reason: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["reason", b"reason", "user_id", b"user_id"]) -> None: ...

global___SuspendUserRequest = SuspendUserRequest

@typing.final
class SuspendUserMetadata(google.protobuf.message.Message):
    """Metadata for the [UserService.Suspend] operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_ID_FIELD_NUMBER: builtins.int
    user_id: builtins.str
    """ID of the user that is being suspended."""
    def __init__(
        self,
        *,
        user_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["user_id", b"user_id"]) -> None: ...

global___SuspendUserMetadata = SuspendUserMetadata

@typing.final
class ReactivateUserRequest(google.protobuf.message.Message):
    """Request to reactivate a suspended user."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_ID_FIELD_NUMBER: builtins.int
    user_id: builtins.str
    """ID of the user to reactivate."""
    def __init__(
        self,
        *,
        user_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["user_id", b"user_id"]) -> None: ...

global___ReactivateUserRequest = ReactivateUserRequest

@typing.final
class ReactivateUserMetadata(google.protobuf.message.Message):
    """Metadata for the [UserService.Reactivate] operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_ID_FIELD_NUMBER: builtins.int
    user_id: builtins.str
    """ID of the user that is being reactivated."""
    def __init__(
        self,
        *,
        user_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["user_id", b"user_id"]) -> None: ...

global___ReactivateUserMetadata = ReactivateUserMetadata

@typing.final
class SetOwnPasswordRequest(google.protobuf.message.Message):
    """Request to set the authenticated user's password."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PASSWORD_SPEC_FIELD_NUMBER: builtins.int
    OLD_PASSWORD_FIELD_NUMBER: builtins.int
    old_password: builtins.str
    """Current password for verification."""
    @property
    def password_spec(self) -> global___PasswordSpec:
        """New password specification."""

    def __init__(
        self,
        *,
        password_spec: global___PasswordSpec | None = ...,
        old_password: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["password_spec", b"password_spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["old_password", b"old_password", "password_spec", b"password_spec"]) -> None: ...

global___SetOwnPasswordRequest = SetOwnPasswordRequest

@typing.final
class SetOwnPasswordMetadata(google.protobuf.message.Message):
    """Metadata for the [UserService.SetOwnPassword] operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_ID_FIELD_NUMBER: builtins.int
    user_id: builtins.str
    """ID of the user whose password is being changed."""
    def __init__(
        self,
        *,
        user_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["user_id", b"user_id"]) -> None: ...

global___SetOwnPasswordMetadata = SetOwnPasswordMetadata

@typing.final
class SetOwnPasswordResponse(google.protobuf.message.Message):
    """Response for the [UserService.SetOwnPassword] operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___SetOwnPasswordResponse = SetOwnPasswordResponse

@typing.final
class SetOthersPasswordRequest(google.protobuf.message.Message):
    """Request to set another user's password."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_ID_FIELD_NUMBER: builtins.int
    PASSWORD_SPEC_FIELD_NUMBER: builtins.int
    user_id: builtins.str
    """ID of the user whose password to set."""
    @property
    def password_spec(self) -> global___PasswordSpec:
        """New password specification."""

    def __init__(
        self,
        *,
        user_id: builtins.str = ...,
        password_spec: global___PasswordSpec | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["password_spec", b"password_spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["password_spec", b"password_spec", "user_id", b"user_id"]) -> None: ...

global___SetOthersPasswordRequest = SetOthersPasswordRequest

@typing.final
class SetOthersPasswordMetadata(google.protobuf.message.Message):
    """Metadata for the [UserService.SetOthersPassword] operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_ID_FIELD_NUMBER: builtins.int
    user_id: builtins.str
    """ID of the user whose password is being set."""
    def __init__(
        self,
        *,
        user_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["user_id", b"user_id"]) -> None: ...

global___SetOthersPasswordMetadata = SetOthersPasswordMetadata

@typing.final
class SetOthersPasswordResponse(google.protobuf.message.Message):
    """Response for the [UserService.SetOthersPassword] operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___SetOthersPasswordResponse = SetOthersPasswordResponse

@typing.final
class GeneratePasswordRequest(google.protobuf.message.Message):
    """Request to generate a new password."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___GeneratePasswordRequest = GeneratePasswordRequest

@typing.final
class GeneratePasswordResponse(google.protobuf.message.Message):
    """Response for the [UserService.GeneratePassword] operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PASSWORD_SPEC_FIELD_NUMBER: builtins.int
    @property
    def password_spec(self) -> global___PasswordSpec:
        """Generated password specification."""

    def __init__(
        self,
        *,
        password_spec: global___PasswordSpec | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["password_spec", b"password_spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["password_spec", b"password_spec"]) -> None: ...

global___GeneratePasswordResponse = GeneratePasswordResponse

@typing.final
class PasswordSpec(google.protobuf.message.Message):
    """Password specification."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PASSWORD_FIELD_NUMBER: builtins.int
    GENERATION_PROOF_FIELD_NUMBER: builtins.int
    password: builtins.str
    """The password string."""
    generation_proof: builtins.str
    """Proof that the password was generated by the system."""
    def __init__(
        self,
        *,
        password: builtins.str = ...,
        generation_proof: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["generation_proof", b"generation_proof", "password", b"password"]) -> None: ...

global___PasswordSpec = PasswordSpec

@typing.final
class PasswordMetadata(google.protobuf.message.Message):
    """Metadata about a user's password."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _PasswordType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _PasswordTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[PasswordMetadata._PasswordType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        PASSWORD_TYPE_UNSPECIFIED: PasswordMetadata._PasswordType.ValueType  # 0
        """The password type is not specified."""
        TEMPORARY: PasswordMetadata._PasswordType.ValueType  # 1
        """Temporary password that must be changed on first use."""
        PERMANENT: PasswordMetadata._PasswordType.ValueType  # 2
        """Permanent password."""

    class PasswordType(_PasswordType, metaclass=_PasswordTypeEnumTypeWrapper):
        """Types of passwords."""

    PASSWORD_TYPE_UNSPECIFIED: PasswordMetadata.PasswordType.ValueType  # 0
    """The password type is not specified."""
    TEMPORARY: PasswordMetadata.PasswordType.ValueType  # 1
    """Temporary password that must be changed on first use."""
    PERMANENT: PasswordMetadata.PasswordType.ValueType  # 2
    """Permanent password."""

    @typing.final
    class PasswordUsage(google.protobuf.message.Message):
        """Information about password usage."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        USED_AT_FIELD_NUMBER: builtins.int
        IP_ADDRESS_FIELD_NUMBER: builtins.int
        ip_address: builtins.str
        """IP address from which the password was used."""
        @property
        def used_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Timestamp when the password was last used."""

        def __init__(
            self,
            *,
            used_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            ip_address: builtins.str = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["used_at", b"used_at"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["ip_address", b"ip_address", "used_at", b"used_at"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    EXPIRES_AT_FIELD_NUMBER: builtins.int
    LAST_USAGE_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Unique identifier of the password."""
    type: global___PasswordMetadata.PasswordType.ValueType
    """Type of the password."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp when the password was created."""

    @property
    def expires_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp when the password expires."""

    @property
    def last_usage(self) -> global___PasswordMetadata.PasswordUsage:
        """Information about the last usage of the password."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        type: global___PasswordMetadata.PasswordType.ValueType = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        expires_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        last_usage: global___PasswordMetadata.PasswordUsage | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at", "expires_at", b"expires_at", "last_usage", b"last_usage"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["created_at", b"created_at", "expires_at", b"expires_at", "id", b"id", "last_usage", b"last_usage", "type", b"type"]) -> None: ...

global___PasswordMetadata = PasswordMetadata

@typing.final
class ConvertToExternalUserRequest(google.protobuf.message.Message):
    """Request to convert a user to use external authentication."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_ID_FIELD_NUMBER: builtins.int
    EXTERNAL_ID_FIELD_NUMBER: builtins.int
    user_id: builtins.str
    """ID of the user to convert."""
    external_id: builtins.str
    """External identifier to associate with the user."""
    def __init__(
        self,
        *,
        user_id: builtins.str = ...,
        external_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["external_id", b"external_id", "user_id", b"user_id"]) -> None: ...

global___ConvertToExternalUserRequest = ConvertToExternalUserRequest

@typing.final
class ConvertToExternalUserMetadata(google.protobuf.message.Message):
    """Metadata for the [UserService.ConvertToExternal] operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_ID_FIELD_NUMBER: builtins.int
    EXTERNAL_ID_FIELD_NUMBER: builtins.int
    user_id: builtins.str
    """ID of the user being converted."""
    external_id: builtins.str
    """External identifier being associated with the user."""
    def __init__(
        self,
        *,
        user_id: builtins.str = ...,
        external_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["external_id", b"external_id", "user_id", b"user_id"]) -> None: ...

global___ConvertToExternalUserMetadata = ConvertToExternalUserMetadata

@typing.final
class SetPasswordHashRequest(google.protobuf.message.Message):
    """Request to set a password hash for a user."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_ID_FIELD_NUMBER: builtins.int
    HASH_FIELD_NUMBER: builtins.int
    user_id: builtins.str
    """ID of the user to set the password hash for."""
    @property
    def hash(self) -> global___PasswordHash:
        """Password hash to set."""

    def __init__(
        self,
        *,
        user_id: builtins.str = ...,
        hash: global___PasswordHash | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["hash", b"hash"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["hash", b"hash", "user_id", b"user_id"]) -> None: ...

global___SetPasswordHashRequest = SetPasswordHashRequest

@typing.final
class SetPasswordHashMetadata(google.protobuf.message.Message):
    """Metadata for the [UserService.SetPasswordHash] operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_ID_FIELD_NUMBER: builtins.int
    user_id: builtins.str
    """ID of the user whose password hash is being set."""
    def __init__(
        self,
        *,
        user_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["user_id", b"user_id"]) -> None: ...

global___SetPasswordHashMetadata = SetPasswordHashMetadata

@typing.final
class PasswordHash(google.protobuf.message.Message):
    """Password hash information."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _PasswordHashType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _PasswordHashTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[PasswordHash._PasswordHashType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        PASSWORD_HASH_TYPE_UNSPECIFIED: PasswordHash._PasswordHashType.ValueType  # 0
        """The password hash type is not specified."""
        AD_MD4: PasswordHash._PasswordHashType.ValueType  # 1
        """Microsoft Active Directory MD4 hash."""

    class PasswordHashType(_PasswordHashType, metaclass=_PasswordHashTypeEnumTypeWrapper):
        """Types of password hashes."""

    PASSWORD_HASH_TYPE_UNSPECIFIED: PasswordHash.PasswordHashType.ValueType  # 0
    """The password hash type is not specified."""
    AD_MD4: PasswordHash.PasswordHashType.ValueType  # 1
    """Microsoft Active Directory MD4 hash."""

    PASSWORD_HASH_FIELD_NUMBER: builtins.int
    PASSWORD_HASH_TYPE_FIELD_NUMBER: builtins.int
    password_hash: builtins.str
    """The password hash string."""
    password_hash_type: global___PasswordHash.PasswordHashType.ValueType
    """Type of the password hash."""
    def __init__(
        self,
        *,
        password_hash: builtins.str = ...,
        password_hash_type: global___PasswordHash.PasswordHashType.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["password_hash", b"password_hash", "password_hash_type", b"password_hash_type"]) -> None: ...

global___PasswordHash = PasswordHash

@typing.final
class ResolveExternalIdsRequest(google.protobuf.message.Message):
    """Request to resolve external IDs to internal user IDs."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USERPOOL_ID_FIELD_NUMBER: builtins.int
    EXTERNAL_IDS_FIELD_NUMBER: builtins.int
    userpool_id: builtins.str
    """ID of the userpool to resolve external IDs in."""
    @property
    def external_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of external IDs to resolve."""

    def __init__(
        self,
        *,
        userpool_id: builtins.str = ...,
        external_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["external_ids", b"external_ids", "userpool_id", b"userpool_id"]) -> None: ...

global___ResolveExternalIdsRequest = ResolveExternalIdsRequest

@typing.final
class ResolvedUser(google.protobuf.message.Message):
    """Information about a resolved user."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_ID_FIELD_NUMBER: builtins.int
    EXTERNAL_ID_FIELD_NUMBER: builtins.int
    USERPOOL_ID_FIELD_NUMBER: builtins.int
    user_id: builtins.str
    """Internal user ID."""
    external_id: builtins.str
    """External identifier."""
    userpool_id: builtins.str
    """ID of the userpool the user belongs to."""
    def __init__(
        self,
        *,
        user_id: builtins.str = ...,
        external_id: builtins.str = ...,
        userpool_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["external_id", b"external_id", "user_id", b"user_id", "userpool_id", b"userpool_id"]) -> None: ...

global___ResolvedUser = ResolvedUser

@typing.final
class ResolveExternalIdsResponse(google.protobuf.message.Message):
    """Response for the [UserService.ResolveExternalIds] operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOLVED_USERS_FIELD_NUMBER: builtins.int
    @property
    def resolved_users(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ResolvedUser]:
        """List of resolved users."""

    def __init__(
        self,
        *,
        resolved_users: collections.abc.Iterable[global___ResolvedUser] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["resolved_users", b"resolved_users"]) -> None: ...

global___ResolveExternalIdsResponse = ResolveExternalIdsResponse
