"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.operation.operation_pb2
import yandex.cloud.organizationmanager.v1.idp.userpool_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetUserpoolRequest(google.protobuf.message.Message):
    """Request to get a userpool."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USERPOOL_ID_FIELD_NUMBER: builtins.int
    userpool_id: builtins.str
    """ID of the userpool to return.
    To get the userpool ID, make a [UserpoolService.List] request.
    """
    def __init__(
        self,
        *,
        userpool_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["userpool_id", b"userpool_id"]) -> None: ...

global___GetUserpoolRequest = GetUserpoolRequest

@typing.final
class ListUserpoolsRequest(google.protobuf.message.Message):
    """Request to list userpools."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ORGANIZATION_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    organization_id: builtins.str
    """ID of the organization to list userpools in."""
    page_size: builtins.int
    """The maximum number of results per page to return.
    If the number of available results is larger than [page_size],
    the service returns a [ListUserpoolsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token]
    to the [ListUserpoolsResponse.next_page_token]
    returned by a previous list request.
    """
    filter: builtins.str
    """A filter expression that filters resources listed in the response."""
    def __init__(
        self,
        *,
        organization_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "organization_id", b"organization_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListUserpoolsRequest = ListUserpoolsRequest

@typing.final
class ListUserpoolsResponse(google.protobuf.message.Message):
    """Response message for [UserpoolService.List]."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USERPOOLS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests.
    If the number of results is larger than [ListUserpoolsRequest.page_size],
    use the [next_page_token] as the value for the [ListUserpoolsRequest.page_token]
    query parameter in the next list request.
    """
    @property
    def userpools(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.organizationmanager.v1.idp.userpool_pb2.Userpool]:
        """List of userpools."""

    def __init__(
        self,
        *,
        userpools: collections.abc.Iterable[yandex.cloud.organizationmanager.v1.idp.userpool_pb2.Userpool] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "userpools", b"userpools"]) -> None: ...

global___ListUserpoolsResponse = ListUserpoolsResponse

@typing.final
class CreateUserpoolRequest(google.protobuf.message.Message):
    """Request to create a userpool."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ORGANIZATION_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    DEFAULT_SUBDOMAIN_FIELD_NUMBER: builtins.int
    USER_SETTINGS_FIELD_NUMBER: builtins.int
    PASSWORD_QUALITY_POLICY_FIELD_NUMBER: builtins.int
    PASSWORD_LIFETIME_POLICY_FIELD_NUMBER: builtins.int
    BRUTEFORCE_PROTECTION_POLICY_FIELD_NUMBER: builtins.int
    organization_id: builtins.str
    """ID of the organization to create a userpool in."""
    name: builtins.str
    """Name of the userpool.
    The name must be unique within the organization.
    """
    description: builtins.str
    """Description of the userpool."""
    default_subdomain: builtins.str
    """Default subdomain for the userpool."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as key:value pairs."""

    @property
    def user_settings(self) -> yandex.cloud.organizationmanager.v1.idp.userpool_pb2.UserSettings:
        """User settings for the userpool."""

    @property
    def password_quality_policy(self) -> yandex.cloud.organizationmanager.v1.idp.userpool_pb2.PasswordQualityPolicy:
        """Password quality policy for the userpool."""

    @property
    def password_lifetime_policy(self) -> yandex.cloud.organizationmanager.v1.idp.userpool_pb2.PasswordLifetimePolicy:
        """Password lifetime policy for the userpool."""

    @property
    def bruteforce_protection_policy(self) -> yandex.cloud.organizationmanager.v1.idp.userpool_pb2.BruteforceProtectionPolicy:
        """Bruteforce protection policy for the userpool."""

    def __init__(
        self,
        *,
        organization_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        default_subdomain: builtins.str = ...,
        user_settings: yandex.cloud.organizationmanager.v1.idp.userpool_pb2.UserSettings | None = ...,
        password_quality_policy: yandex.cloud.organizationmanager.v1.idp.userpool_pb2.PasswordQualityPolicy | None = ...,
        password_lifetime_policy: yandex.cloud.organizationmanager.v1.idp.userpool_pb2.PasswordLifetimePolicy | None = ...,
        bruteforce_protection_policy: yandex.cloud.organizationmanager.v1.idp.userpool_pb2.BruteforceProtectionPolicy | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["bruteforce_protection_policy", b"bruteforce_protection_policy", "password_lifetime_policy", b"password_lifetime_policy", "password_quality_policy", b"password_quality_policy", "user_settings", b"user_settings"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["bruteforce_protection_policy", b"bruteforce_protection_policy", "default_subdomain", b"default_subdomain", "description", b"description", "labels", b"labels", "name", b"name", "organization_id", b"organization_id", "password_lifetime_policy", b"password_lifetime_policy", "password_quality_policy", b"password_quality_policy", "user_settings", b"user_settings"]) -> None: ...

global___CreateUserpoolRequest = CreateUserpoolRequest

@typing.final
class CreateUserpoolMetadata(google.protobuf.message.Message):
    """Metadata for the [UserpoolService.Create] operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USERPOOL_ID_FIELD_NUMBER: builtins.int
    userpool_id: builtins.str
    """ID of the userpool that is being created."""
    def __init__(
        self,
        *,
        userpool_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["userpool_id", b"userpool_id"]) -> None: ...

global___CreateUserpoolMetadata = CreateUserpoolMetadata

@typing.final
class UpdateUserpoolRequest(google.protobuf.message.Message):
    """Request to update a userpool."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    USERPOOL_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    USER_SETTINGS_FIELD_NUMBER: builtins.int
    PASSWORD_QUALITY_POLICY_FIELD_NUMBER: builtins.int
    PASSWORD_LIFETIME_POLICY_FIELD_NUMBER: builtins.int
    BRUTEFORCE_PROTECTION_POLICY_FIELD_NUMBER: builtins.int
    userpool_id: builtins.str
    """ID of the userpool to update.
    To get the userpool ID, make a [UserpoolService.List] request.
    """
    name: builtins.str
    """Name of the userpool.
    The name must be unique within the organization.
    """
    description: builtins.str
    """Description of the userpool."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which fields of the userpool are going to be updated."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as key:value pairs."""

    @property
    def user_settings(self) -> yandex.cloud.organizationmanager.v1.idp.userpool_pb2.UserSettings:
        """User settings for the userpool."""

    @property
    def password_quality_policy(self) -> yandex.cloud.organizationmanager.v1.idp.userpool_pb2.PasswordQualityPolicy:
        """Password quality policy for the userpool."""

    @property
    def password_lifetime_policy(self) -> yandex.cloud.organizationmanager.v1.idp.userpool_pb2.PasswordLifetimePolicy:
        """Password lifetime policy for the userpool."""

    @property
    def bruteforce_protection_policy(self) -> yandex.cloud.organizationmanager.v1.idp.userpool_pb2.BruteforceProtectionPolicy:
        """Bruteforce protection policy for the userpool."""

    def __init__(
        self,
        *,
        userpool_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        user_settings: yandex.cloud.organizationmanager.v1.idp.userpool_pb2.UserSettings | None = ...,
        password_quality_policy: yandex.cloud.organizationmanager.v1.idp.userpool_pb2.PasswordQualityPolicy | None = ...,
        password_lifetime_policy: yandex.cloud.organizationmanager.v1.idp.userpool_pb2.PasswordLifetimePolicy | None = ...,
        bruteforce_protection_policy: yandex.cloud.organizationmanager.v1.idp.userpool_pb2.BruteforceProtectionPolicy | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["bruteforce_protection_policy", b"bruteforce_protection_policy", "password_lifetime_policy", b"password_lifetime_policy", "password_quality_policy", b"password_quality_policy", "update_mask", b"update_mask", "user_settings", b"user_settings"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["bruteforce_protection_policy", b"bruteforce_protection_policy", "description", b"description", "labels", b"labels", "name", b"name", "password_lifetime_policy", b"password_lifetime_policy", "password_quality_policy", b"password_quality_policy", "update_mask", b"update_mask", "user_settings", b"user_settings", "userpool_id", b"userpool_id"]) -> None: ...

global___UpdateUserpoolRequest = UpdateUserpoolRequest

@typing.final
class UpdateUserpoolMetadata(google.protobuf.message.Message):
    """Metadata for the [UserpoolService.Update] operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USERPOOL_ID_FIELD_NUMBER: builtins.int
    userpool_id: builtins.str
    """ID of the userpool that is being updated."""
    def __init__(
        self,
        *,
        userpool_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["userpool_id", b"userpool_id"]) -> None: ...

global___UpdateUserpoolMetadata = UpdateUserpoolMetadata

@typing.final
class DeleteUserpoolRequest(google.protobuf.message.Message):
    """Request to delete a userpool."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USERPOOL_ID_FIELD_NUMBER: builtins.int
    userpool_id: builtins.str
    """ID of the userpool to delete.
    To get the userpool ID, make a [UserpoolService.List] request.
    """
    def __init__(
        self,
        *,
        userpool_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["userpool_id", b"userpool_id"]) -> None: ...

global___DeleteUserpoolRequest = DeleteUserpoolRequest

@typing.final
class DeleteUserpoolMetadata(google.protobuf.message.Message):
    """Metadata for the [UserpoolService.Delete] operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USERPOOL_ID_FIELD_NUMBER: builtins.int
    userpool_id: builtins.str
    """ID of the userpool that is being deleted."""
    def __init__(
        self,
        *,
        userpool_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["userpool_id", b"userpool_id"]) -> None: ...

global___DeleteUserpoolMetadata = DeleteUserpoolMetadata

@typing.final
class GetUserpoolDomainRequest(google.protobuf.message.Message):
    """Request to get a domain for a userpool."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USERPOOL_ID_FIELD_NUMBER: builtins.int
    DOMAIN_FIELD_NUMBER: builtins.int
    userpool_id: builtins.str
    """ID of the userpool to get a domain for."""
    domain: builtins.str
    """Domain name."""
    def __init__(
        self,
        *,
        userpool_id: builtins.str = ...,
        domain: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["domain", b"domain", "userpool_id", b"userpool_id"]) -> None: ...

global___GetUserpoolDomainRequest = GetUserpoolDomainRequest

@typing.final
class ListUserpoolDomainsRequest(google.protobuf.message.Message):
    """Request to list domains for a userpool."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USERPOOL_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    userpool_id: builtins.str
    """ID of the userpool to list domains for."""
    page_size: builtins.int
    """The maximum number of results per page to return."""
    page_token: builtins.str
    """Page token for pagination."""
    filter: builtins.str
    """A filter expression that filters resources listed in the response."""
    def __init__(
        self,
        *,
        userpool_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "userpool_id", b"userpool_id"]) -> None: ...

global___ListUserpoolDomainsRequest = ListUserpoolDomainsRequest

@typing.final
class ListUserpoolDomainsResponse(google.protobuf.message.Message):
    """Response message for [UserpoolService.ListDomains]."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DOMAINS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list."""
    @property
    def domains(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.organizationmanager.v1.idp.userpool_pb2.Domain]:
        """List of domains."""

    def __init__(
        self,
        *,
        domains: collections.abc.Iterable[yandex.cloud.organizationmanager.v1.idp.userpool_pb2.Domain] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["domains", b"domains", "next_page_token", b"next_page_token"]) -> None: ...

global___ListUserpoolDomainsResponse = ListUserpoolDomainsResponse

@typing.final
class AddUserpoolDomainRequest(google.protobuf.message.Message):
    """Request to add a domain to a userpool."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USERPOOL_ID_FIELD_NUMBER: builtins.int
    DOMAIN_FIELD_NUMBER: builtins.int
    userpool_id: builtins.str
    """ID of the userpool to add a domain to."""
    domain: builtins.str
    """Domain name to add."""
    def __init__(
        self,
        *,
        userpool_id: builtins.str = ...,
        domain: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["domain", b"domain", "userpool_id", b"userpool_id"]) -> None: ...

global___AddUserpoolDomainRequest = AddUserpoolDomainRequest

@typing.final
class AddUserpoolDomainMetadata(google.protobuf.message.Message):
    """Metadata for the [UserpoolService.AddDomain] operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USERPOOL_ID_FIELD_NUMBER: builtins.int
    DOMAIN_FIELD_NUMBER: builtins.int
    userpool_id: builtins.str
    """ID of the userpool."""
    domain: builtins.str
    """Domain name being added."""
    def __init__(
        self,
        *,
        userpool_id: builtins.str = ...,
        domain: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["domain", b"domain", "userpool_id", b"userpool_id"]) -> None: ...

global___AddUserpoolDomainMetadata = AddUserpoolDomainMetadata

@typing.final
class ValidateUserpoolDomainRequest(google.protobuf.message.Message):
    """Request to validate a domain for a userpool."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USERPOOL_ID_FIELD_NUMBER: builtins.int
    DOMAIN_FIELD_NUMBER: builtins.int
    userpool_id: builtins.str
    """ID of the userpool to validate a domain for."""
    domain: builtins.str
    """Domain name to validate."""
    def __init__(
        self,
        *,
        userpool_id: builtins.str = ...,
        domain: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["domain", b"domain", "userpool_id", b"userpool_id"]) -> None: ...

global___ValidateUserpoolDomainRequest = ValidateUserpoolDomainRequest

@typing.final
class ValidateUserpoolDomainMetadata(google.protobuf.message.Message):
    """Metadata for the [UserpoolService.ValidateDomain] operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USERPOOL_ID_FIELD_NUMBER: builtins.int
    DOMAIN_FIELD_NUMBER: builtins.int
    userpool_id: builtins.str
    """ID of the userpool."""
    domain: builtins.str
    """Domain name being validated."""
    def __init__(
        self,
        *,
        userpool_id: builtins.str = ...,
        domain: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["domain", b"domain", "userpool_id", b"userpool_id"]) -> None: ...

global___ValidateUserpoolDomainMetadata = ValidateUserpoolDomainMetadata

@typing.final
class DeleteUserpoolDomainRequest(google.protobuf.message.Message):
    """Request to delete a domain from a userpool."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USERPOOL_ID_FIELD_NUMBER: builtins.int
    DOMAIN_FIELD_NUMBER: builtins.int
    userpool_id: builtins.str
    """ID of the userpool to delete a domain from."""
    domain: builtins.str
    """Domain name to delete."""
    def __init__(
        self,
        *,
        userpool_id: builtins.str = ...,
        domain: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["domain", b"domain", "userpool_id", b"userpool_id"]) -> None: ...

global___DeleteUserpoolDomainRequest = DeleteUserpoolDomainRequest

@typing.final
class DeleteUserpoolDomainMetadata(google.protobuf.message.Message):
    """Metadata for the [UserpoolService.DeleteDomain] operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USERPOOL_ID_FIELD_NUMBER: builtins.int
    DOMAIN_FIELD_NUMBER: builtins.int
    userpool_id: builtins.str
    """ID of the userpool."""
    domain: builtins.str
    """Domain name being deleted."""
    def __init__(
        self,
        *,
        userpool_id: builtins.str = ...,
        domain: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["domain", b"domain", "userpool_id", b"userpool_id"]) -> None: ...

global___DeleteUserpoolDomainMetadata = DeleteUserpoolDomainMetadata

@typing.final
class ListUserpoolOperationsRequest(google.protobuf.message.Message):
    """Request to list operations for a userpool."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USERPOOL_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    userpool_id: builtins.str
    """ID of the userpool to list operations for."""
    page_size: builtins.int
    """The maximum number of results per page to return."""
    page_token: builtins.str
    """Page token for pagination."""
    def __init__(
        self,
        *,
        userpool_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["page_size", b"page_size", "page_token", b"page_token", "userpool_id", b"userpool_id"]) -> None: ...

global___ListUserpoolOperationsRequest = ListUserpoolOperationsRequest

@typing.final
class ListUserpoolOperationsResponse(google.protobuf.message.Message):
    """Response message for [UserpoolService.ListOperations]."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list."""
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.operation.operation_pb2.Operation]:
        """List of operations."""

    def __init__(
        self,
        *,
        operations: collections.abc.Iterable[yandex.cloud.operation.operation_pb2.Operation] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "operations", b"operations"]) -> None: ...

global___ListUserpoolOperationsResponse = ListUserpoolOperationsResponse
