"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _BindingType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _BindingTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_BindingType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    BINDING_TYPE_UNSPECIFIED: _BindingType.ValueType  # 0
    POST: _BindingType.ValueType  # 1
    """HTTP POST binding."""
    REDIRECT: _BindingType.ValueType  # 2
    """HTTP redirect binding."""
    ARTIFACT: _BindingType.ValueType  # 3
    """HTTP artifact binding."""

class BindingType(_BindingType, metaclass=_BindingTypeEnumTypeWrapper): ...

BINDING_TYPE_UNSPECIFIED: BindingType.ValueType  # 0
POST: BindingType.ValueType  # 1
"""HTTP POST binding."""
REDIRECT: BindingType.ValueType  # 2
"""HTTP redirect binding."""
ARTIFACT: BindingType.ValueType  # 3
"""HTTP artifact binding."""
global___BindingType = BindingType

@typing.final
class Federation(google.protobuf.message.Message):
    """A federation.
    For more information, see [SAML-compatible identity federations](/docs/iam/concepts/federations).
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    ORGANIZATION_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    COOKIE_MAX_AGE_FIELD_NUMBER: builtins.int
    AUTO_CREATE_ACCOUNT_ON_LOGIN_FIELD_NUMBER: builtins.int
    ISSUER_FIELD_NUMBER: builtins.int
    SSO_BINDING_FIELD_NUMBER: builtins.int
    SSO_URL_FIELD_NUMBER: builtins.int
    SECURITY_SETTINGS_FIELD_NUMBER: builtins.int
    CASE_INSENSITIVE_NAME_IDS_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the federation."""
    organization_id: builtins.str
    """ID of the organization that the federation belongs to."""
    name: builtins.str
    """Name of the federation."""
    description: builtins.str
    """Description of the federation."""
    auto_create_account_on_login: builtins.bool
    """Add new users automatically on successful authentication.
    The user becomes member of the organization automatically,
    but you need to grant other roles to them.

    If the value is `false`, users who aren't added to the organization
    can't log in, even if they have authenticated on your server.
    """
    issuer: builtins.str
    """ID of the IdP server to be used for authentication.
    The IdP server also responds to IAM with this ID after the user authenticates.
    """
    sso_binding: global___BindingType.ValueType
    """Single sign-on endpoint binding type. Most Identity Providers support the `POST` binding type.

    SAML Binding is a mapping of a SAML protocol message onto standard messaging
    formats and/or communications protocols.
    """
    sso_url: builtins.str
    """Single sign-on endpoint URL.
    Specify the link to the IdP login page here.
    """
    case_insensitive_name_ids: builtins.bool
    """Use case insensitive Name IDs."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp."""

    @property
    def cookie_max_age(self) -> google.protobuf.duration_pb2.Duration:
        """Browser cookie lifetime in seconds.
        If the cookie is still valid, the management console
        authenticates the user immediately and redirects them to the home page.
        """

    @property
    def security_settings(self) -> global___FederationSecuritySettings:
        """Federation security settings."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `` key:value `` pairs. Maximum of 64 per resource."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        organization_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        cookie_max_age: google.protobuf.duration_pb2.Duration | None = ...,
        auto_create_account_on_login: builtins.bool = ...,
        issuer: builtins.str = ...,
        sso_binding: global___BindingType.ValueType = ...,
        sso_url: builtins.str = ...,
        security_settings: global___FederationSecuritySettings | None = ...,
        case_insensitive_name_ids: builtins.bool = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["cookie_max_age", b"cookie_max_age", "created_at", b"created_at", "security_settings", b"security_settings"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["auto_create_account_on_login", b"auto_create_account_on_login", "case_insensitive_name_ids", b"case_insensitive_name_ids", "cookie_max_age", b"cookie_max_age", "created_at", b"created_at", "description", b"description", "id", b"id", "issuer", b"issuer", "labels", b"labels", "name", b"name", "organization_id", b"organization_id", "security_settings", b"security_settings", "sso_binding", b"sso_binding", "sso_url", b"sso_url"]) -> None: ...

global___Federation = Federation

@typing.final
class FederationSecuritySettings(google.protobuf.message.Message):
    """Federation security settings."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENCRYPTED_ASSERTIONS_FIELD_NUMBER: builtins.int
    FORCE_AUTHN_FIELD_NUMBER: builtins.int
    encrypted_assertions: builtins.bool
    """Enable encrypted assertions."""
    force_authn: builtins.bool
    """Value parameter ForceAuthn in SAMLRequest."""
    def __init__(
        self,
        *,
        encrypted_assertions: builtins.bool = ...,
        force_authn: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["encrypted_assertions", b"encrypted_assertions", "force_authn", b"force_authn"]) -> None: ...

global___FederationSecuritySettings = FederationSecuritySettings

@typing.final
class Domain(google.protobuf.message.Message):
    """A domain."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Domain._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: Domain._Status.ValueType  # 0
        NEED_TO_VALIDATE: Domain._Status.ValueType  # 1
        """Domain requires ownership validation."""
        VALIDATING: Domain._Status.ValueType  # 2
        """Domain validation is in progress."""
        VALID: Domain._Status.ValueType  # 3
        """Domain has been successfully validated and is active."""
        INVALID: Domain._Status.ValueType  # 4
        """Domain validation failed (check status_code for details)."""
        DELETING: Domain._Status.ValueType  # 5
        """Domain is being deleted."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper):
        """Status of the domain."""

    STATUS_UNSPECIFIED: Domain.Status.ValueType  # 0
    NEED_TO_VALIDATE: Domain.Status.ValueType  # 1
    """Domain requires ownership validation."""
    VALIDATING: Domain.Status.ValueType  # 2
    """Domain validation is in progress."""
    VALID: Domain.Status.ValueType  # 3
    """Domain has been successfully validated and is active."""
    INVALID: Domain.Status.ValueType  # 4
    """Domain validation failed (check status_code for details)."""
    DELETING: Domain.Status.ValueType  # 5
    """Domain is being deleted."""

    DOMAIN_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    STATUS_CODE_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    VALIDATED_AT_FIELD_NUMBER: builtins.int
    CHALLENGES_FIELD_NUMBER: builtins.int
    domain: builtins.str
    """Domain name"""
    status: global___Domain.Status.ValueType
    """Current status of the domain."""
    status_code: builtins.str
    """Optional code providing details about validation errors."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp of domain creation."""

    @property
    def validated_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp when the domain was successfully validated.
        Not set if validation hasn't been completed.
        """

    @property
    def challenges(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DomainChallenge]:
        """List of challenges to confirm domain ownership."""

    def __init__(
        self,
        *,
        domain: builtins.str = ...,
        status: global___Domain.Status.ValueType = ...,
        status_code: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        validated_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        challenges: collections.abc.Iterable[global___DomainChallenge] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at", "validated_at", b"validated_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["challenges", b"challenges", "created_at", b"created_at", "domain", b"domain", "status", b"status", "status_code", b"status_code", "validated_at", b"validated_at"]) -> None: ...

global___Domain = Domain

@typing.final
class DomainChallenge(google.protobuf.message.Message):
    """A domain validation challenge."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Type:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[DomainChallenge._Type.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        TYPE_UNSPECIFIED: DomainChallenge._Type.ValueType  # 0
        DNS_TXT: DomainChallenge._Type.ValueType  # 1
        """DNS TXT record validation method."""

    class Type(_Type, metaclass=_TypeEnumTypeWrapper):
        """Type of validation challenge."""

    TYPE_UNSPECIFIED: DomainChallenge.Type.ValueType  # 0
    DNS_TXT: DomainChallenge.Type.ValueType  # 1
    """DNS TXT record validation method."""

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[DomainChallenge._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: DomainChallenge._Status.ValueType  # 0
        PENDING: DomainChallenge._Status.ValueType  # 1
        """Challenge is awaiting completion."""
        PROCESSING: DomainChallenge._Status.ValueType  # 2
        """Challenge verification is in progress."""
        VALID: DomainChallenge._Status.ValueType  # 3
        """Challenge has been completed successfully."""
        INVALID: DomainChallenge._Status.ValueType  # 4
        """Challenge verification failed."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper):
        """Status of the validation challenge."""

    STATUS_UNSPECIFIED: DomainChallenge.Status.ValueType  # 0
    PENDING: DomainChallenge.Status.ValueType  # 1
    """Challenge is awaiting completion."""
    PROCESSING: DomainChallenge.Status.ValueType  # 2
    """Challenge verification is in progress."""
    VALID: DomainChallenge.Status.ValueType  # 3
    """Challenge has been completed successfully."""
    INVALID: DomainChallenge.Status.ValueType  # 4
    """Challenge verification failed."""

    @typing.final
    class DnsRecord(google.protobuf.message.Message):
        """DNS record data for validation challenges."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _Type:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _TypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[DomainChallenge.DnsRecord._Type.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            TYPE_UNSPECIFIED: DomainChallenge.DnsRecord._Type.ValueType  # 0
            TXT: DomainChallenge.DnsRecord._Type.ValueType  # 1
            """TXT record type."""

        class Type(_Type, metaclass=_TypeEnumTypeWrapper):
            """Type of DNS record."""

        TYPE_UNSPECIFIED: DomainChallenge.DnsRecord.Type.ValueType  # 0
        TXT: DomainChallenge.DnsRecord.Type.ValueType  # 1
        """TXT record type."""

        NAME_FIELD_NUMBER: builtins.int
        TYPE_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        name: builtins.str
        """Fully qualified domain name for the record."""
        type: global___DomainChallenge.DnsRecord.Type.ValueType
        """DNS record type (always TXT for current implementation)."""
        value: builtins.str
        """Value to set in the DNS record for verification."""
        def __init__(
            self,
            *,
            name: builtins.str = ...,
            type: global___DomainChallenge.DnsRecord.Type.ValueType = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["name", b"name", "type", b"type", "value", b"value"]) -> None: ...

    CREATED_AT_FIELD_NUMBER: builtins.int
    UPDATED_AT_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    DNS_CHALLENGE_FIELD_NUMBER: builtins.int
    type: global___DomainChallenge.Type.ValueType
    """Type of the validation challenge."""
    status: global___DomainChallenge.Status.ValueType
    """Current status of the challenge."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp of challenge creation."""

    @property
    def updated_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp of the last challenge status update."""

    @property
    def dns_challenge(self) -> global___DomainChallenge.DnsRecord:
        """DNS record configuration for domain verification."""

    def __init__(
        self,
        *,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        updated_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        type: global___DomainChallenge.Type.ValueType = ...,
        status: global___DomainChallenge.Status.ValueType = ...,
        dns_challenge: global___DomainChallenge.DnsRecord | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["challenge", b"challenge", "created_at", b"created_at", "dns_challenge", b"dns_challenge", "updated_at", b"updated_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["challenge", b"challenge", "created_at", b"created_at", "dns_challenge", b"dns_challenge", "status", b"status", "type", b"type", "updated_at", b"updated_at"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["challenge", b"challenge"]) -> typing.Literal["dns_challenge"] | None: ...

global___DomainChallenge = DomainChallenge
