"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.operation.operation_pb2
import yandex.cloud.serverless.containers.v1.container_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetContainerRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINER_ID_FIELD_NUMBER: builtins.int
    container_id: builtins.str
    """ID of the container to return.

    To get a container ID make a [ContainerService.List] request.
    """
    def __init__(
        self,
        *,
        container_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["container_id", b"container_id"]) -> None: ...

global___GetContainerRequest = GetContainerRequest

@typing.final
class ListContainersRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to list containers in.

    To get a folder ID make a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than `pageSize`, the service returns a [ListContainersResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.

    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set `pageToken` to the
    [ListContainersResponse.next_page_token] returned by a previous list request.
    """
    filter: builtins.str
    """A filter expression that filters containers listed in the response.

    The expression must specify:
    1. The field name. Currently filtering can only be applied to the [Container.name] field.
    2. An `=` operator.
    3. The value in double quotes (`"`). Must be 3-63 characters long and match the regular expression `[a-z][-a-z0-9]{1,61}[a-z0-9]`.
    Example of a filter: `name="my-container"`.
    """
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "folder_id", b"folder_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListContainersRequest = ListContainersRequest

@typing.final
class ListContainersResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINERS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    the specified [ListContainersRequest.page_size], use `nextPageToken` as the value
    for the [ListContainersRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `nextPageToken` to continue paging through the results.
    """
    @property
    def containers(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.serverless.containers.v1.container_pb2.Container]:
        """List of containers in the specified folder."""

    def __init__(
        self,
        *,
        containers: collections.abc.Iterable[yandex.cloud.serverless.containers.v1.container_pb2.Container] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["containers", b"containers", "next_page_token", b"next_page_token"]) -> None: ...

global___ListContainersResponse = ListContainersResponse

@typing.final
class CreateContainerRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to create a container in.

    To get a folder ID make a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    name: builtins.str
    """Name of the container.
    The name must be unique within the folder.
    """
    description: builtins.str
    """Description of the container."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `key:value` pairs."""

    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "folder_id", b"folder_id", "labels", b"labels", "name", b"name"]) -> None: ...

global___CreateContainerRequest = CreateContainerRequest

@typing.final
class CreateContainerMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINER_ID_FIELD_NUMBER: builtins.int
    container_id: builtins.str
    """ID of the container that is being created."""
    def __init__(
        self,
        *,
        container_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["container_id", b"container_id"]) -> None: ...

global___CreateContainerMetadata = CreateContainerMetadata

@typing.final
class UpdateContainerRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    CONTAINER_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    container_id: builtins.str
    """ID of the container to update.

    To get a container ID make a [ContainerService.List] request.
    """
    name: builtins.str
    """New name for the container.
    The name must be unique within the folder.
    """
    description: builtins.str
    """New description for the container."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which attributes of the container should be updated."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Container labels as `key:value` pairs.

        Existing set of labels is completely replaced by the provided set, so if you just want
        to add or remove a label, request the current set of labels with a [ContainerService.Get] request.
        """

    def __init__(
        self,
        *,
        container_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["container_id", b"container_id", "description", b"description", "labels", b"labels", "name", b"name", "update_mask", b"update_mask"]) -> None: ...

global___UpdateContainerRequest = UpdateContainerRequest

@typing.final
class UpdateContainerMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINER_ID_FIELD_NUMBER: builtins.int
    container_id: builtins.str
    """ID of the container that is being updated."""
    def __init__(
        self,
        *,
        container_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["container_id", b"container_id"]) -> None: ...

global___UpdateContainerMetadata = UpdateContainerMetadata

@typing.final
class DeleteContainerRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINER_ID_FIELD_NUMBER: builtins.int
    container_id: builtins.str
    """ID of the container to delete.
    To get a container ID make a [ContainerService.List] request.
    """
    def __init__(
        self,
        *,
        container_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["container_id", b"container_id"]) -> None: ...

global___DeleteContainerRequest = DeleteContainerRequest

@typing.final
class DeleteContainerMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINER_ID_FIELD_NUMBER: builtins.int
    container_id: builtins.str
    """ID of the container that is being deleted."""
    def __init__(
        self,
        *,
        container_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["container_id", b"container_id"]) -> None: ...

global___DeleteContainerMetadata = DeleteContainerMetadata

@typing.final
class GetContainerRevisionRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINER_REVISION_ID_FIELD_NUMBER: builtins.int
    container_revision_id: builtins.str
    """ID of the revision to return.

    To get a revision ID make a [ContainerService.ListRevisions] request.
    """
    def __init__(
        self,
        *,
        container_revision_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["container_revision_id", b"container_revision_id"]) -> None: ...

global___GetContainerRevisionRequest = GetContainerRevisionRequest

@typing.final
class ListContainersRevisionsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    CONTAINER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to list container revisions for.
    To get a folder ID make a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    container_id: builtins.str
    """ID of the container to list revisions for.
    To get a container ID use a [ContainerService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available results
    is larger than `pageSize`, the service returns a [ListContainersRevisionsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.

    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set `pageToken` to the
    [ListContainersRevisionsResponse.next_page_token] returned by a previous list request.
    """
    filter: builtins.str
    """A filter expression that filters resources listed in the response.

    The expression must specify:
    1. The field name. Currently filtering can only be applied to the [Revision.status] and [Revision.runtime] fields.
    2. An `=` operator.
    3. The value in double quotes (`"`). Must be 3-63 characters long and match the regular expression `[a-z][-a-z0-9]{1,61}[a-z0-9]`.
    Example of a filter: `status="ACTIVE"`.
    """
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        container_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["container_id", b"container_id", "folder_id", b"folder_id", "id", b"id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["container_id", b"container_id", "filter", b"filter", "folder_id", b"folder_id", "id", b"id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["id", b"id"]) -> typing.Literal["folder_id", "container_id"] | None: ...

global___ListContainersRevisionsRequest = ListContainersRevisionsRequest

@typing.final
class ListContainersRevisionsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REVISIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    the specified [ListContainersRevisionsRequest.page_size], use `nextPageToken` as the value
    for the [ListContainersRevisionsRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `nextPageToken` to continue paging through the results.
    """
    @property
    def revisions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.serverless.containers.v1.container_pb2.Revision]:
        """List of revisions for the specified folder or container."""

    def __init__(
        self,
        *,
        revisions: collections.abc.Iterable[yandex.cloud.serverless.containers.v1.container_pb2.Revision] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "revisions", b"revisions"]) -> None: ...

global___ListContainersRevisionsResponse = ListContainersRevisionsResponse

@typing.final
class DeployContainerRevisionRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINER_ID_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    RESOURCES_FIELD_NUMBER: builtins.int
    EXECUTION_TIMEOUT_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    IMAGE_SPEC_FIELD_NUMBER: builtins.int
    CONCURRENCY_FIELD_NUMBER: builtins.int
    SECRETS_FIELD_NUMBER: builtins.int
    CONNECTIVITY_FIELD_NUMBER: builtins.int
    PROVISION_POLICY_FIELD_NUMBER: builtins.int
    SCALING_POLICY_FIELD_NUMBER: builtins.int
    LOG_OPTIONS_FIELD_NUMBER: builtins.int
    STORAGE_MOUNTS_FIELD_NUMBER: builtins.int
    MOUNTS_FIELD_NUMBER: builtins.int
    RUNTIME_FIELD_NUMBER: builtins.int
    METADATA_OPTIONS_FIELD_NUMBER: builtins.int
    ASYNC_INVOCATION_CONFIG_FIELD_NUMBER: builtins.int
    container_id: builtins.str
    """ID of the container to create a revision for.

    To get a container ID, make a [ContainerService.List] request.
    """
    description: builtins.str
    """Description of the revision."""
    service_account_id: builtins.str
    """ID of the service account to associate with the revision."""
    concurrency: builtins.int
    """The number of concurrent requests allowed per container instance.

    The default value is 1.
    """
    @property
    def resources(self) -> yandex.cloud.serverless.containers.v1.container_pb2.Resources:
        """Resources allocated to the revision."""

    @property
    def execution_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """Timeout for the execution of the revision.

        If the timeout is exceeded, Serverless Containers responds with a 504 HTTP code.
        """

    @property
    def image_spec(self) -> global___ImageSpec:
        """Image configuration for the revision."""

    @property
    def secrets(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.serverless.containers.v1.container_pb2.Secret]:
        """Yandex Lockbox secrets to be used by the revision."""

    @property
    def connectivity(self) -> yandex.cloud.serverless.containers.v1.container_pb2.Connectivity:
        """Network access. If specified the revision will be attached to specified network/subnet(s)."""

    @property
    def provision_policy(self) -> yandex.cloud.serverless.containers.v1.container_pb2.ProvisionPolicy:
        """Policy for provisioning instances of the revision.

        The policy is only applied when the revision is ACTIVE.
        """

    @property
    def scaling_policy(self) -> yandex.cloud.serverless.containers.v1.container_pb2.ScalingPolicy:
        """Policy for scaling instances of the revision."""

    @property
    def log_options(self) -> yandex.cloud.serverless.containers.v1.container_pb2.LogOptions:
        """Options for logging from the container."""

    @property
    def storage_mounts(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.serverless.containers.v1.container_pb2.StorageMount]:
        """S3 mounts to be used by the revision."""

    @property
    def mounts(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.serverless.containers.v1.container_pb2.Mount]:
        """Mounts to be used by the revision."""

    @property
    def runtime(self) -> yandex.cloud.serverless.containers.v1.container_pb2.Runtime:
        """The container's execution mode."""

    @property
    def metadata_options(self) -> yandex.cloud.serverless.containers.v1.container_pb2.MetadataOptions:
        """Metadata options for the revision."""

    @property
    def async_invocation_config(self) -> yandex.cloud.serverless.containers.v1.container_pb2.AsyncInvocationConfig:
        """Config for asynchronous invocations of the revision."""

    def __init__(
        self,
        *,
        container_id: builtins.str = ...,
        description: builtins.str = ...,
        resources: yandex.cloud.serverless.containers.v1.container_pb2.Resources | None = ...,
        execution_timeout: google.protobuf.duration_pb2.Duration | None = ...,
        service_account_id: builtins.str = ...,
        image_spec: global___ImageSpec | None = ...,
        concurrency: builtins.int = ...,
        secrets: collections.abc.Iterable[yandex.cloud.serverless.containers.v1.container_pb2.Secret] | None = ...,
        connectivity: yandex.cloud.serverless.containers.v1.container_pb2.Connectivity | None = ...,
        provision_policy: yandex.cloud.serverless.containers.v1.container_pb2.ProvisionPolicy | None = ...,
        scaling_policy: yandex.cloud.serverless.containers.v1.container_pb2.ScalingPolicy | None = ...,
        log_options: yandex.cloud.serverless.containers.v1.container_pb2.LogOptions | None = ...,
        storage_mounts: collections.abc.Iterable[yandex.cloud.serverless.containers.v1.container_pb2.StorageMount] | None = ...,
        mounts: collections.abc.Iterable[yandex.cloud.serverless.containers.v1.container_pb2.Mount] | None = ...,
        runtime: yandex.cloud.serverless.containers.v1.container_pb2.Runtime | None = ...,
        metadata_options: yandex.cloud.serverless.containers.v1.container_pb2.MetadataOptions | None = ...,
        async_invocation_config: yandex.cloud.serverless.containers.v1.container_pb2.AsyncInvocationConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["async_invocation_config", b"async_invocation_config", "connectivity", b"connectivity", "execution_timeout", b"execution_timeout", "image_spec", b"image_spec", "log_options", b"log_options", "metadata_options", b"metadata_options", "provision_policy", b"provision_policy", "resources", b"resources", "runtime", b"runtime", "scaling_policy", b"scaling_policy"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["async_invocation_config", b"async_invocation_config", "concurrency", b"concurrency", "connectivity", b"connectivity", "container_id", b"container_id", "description", b"description", "execution_timeout", b"execution_timeout", "image_spec", b"image_spec", "log_options", b"log_options", "metadata_options", b"metadata_options", "mounts", b"mounts", "provision_policy", b"provision_policy", "resources", b"resources", "runtime", b"runtime", "scaling_policy", b"scaling_policy", "secrets", b"secrets", "service_account_id", b"service_account_id", "storage_mounts", b"storage_mounts"]) -> None: ...

global___DeployContainerRevisionRequest = DeployContainerRevisionRequest

@typing.final
class ImageSpec(google.protobuf.message.Message):
    """Revision image specification."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class EnvironmentEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    IMAGE_URL_FIELD_NUMBER: builtins.int
    COMMAND_FIELD_NUMBER: builtins.int
    ARGS_FIELD_NUMBER: builtins.int
    ENVIRONMENT_FIELD_NUMBER: builtins.int
    WORKING_DIR_FIELD_NUMBER: builtins.int
    image_url: builtins.str
    """Image URL, that is used by the revision."""
    working_dir: builtins.str
    """Override for the image's WORKDIR."""
    @property
    def command(self) -> yandex.cloud.serverless.containers.v1.container_pb2.Command:
        """Override for the image's ENTRYPOINT."""

    @property
    def args(self) -> yandex.cloud.serverless.containers.v1.container_pb2.Args:
        """Override for the image's CMD."""

    @property
    def environment(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Additional environment for the container."""

    def __init__(
        self,
        *,
        image_url: builtins.str = ...,
        command: yandex.cloud.serverless.containers.v1.container_pb2.Command | None = ...,
        args: yandex.cloud.serverless.containers.v1.container_pb2.Args | None = ...,
        environment: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        working_dir: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["args", b"args", "command", b"command"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["args", b"args", "command", b"command", "environment", b"environment", "image_url", b"image_url", "working_dir", b"working_dir"]) -> None: ...

global___ImageSpec = ImageSpec

@typing.final
class DeployContainerRevisionMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINER_REVISION_ID_FIELD_NUMBER: builtins.int
    container_revision_id: builtins.str
    """ID of the revision that is being created."""
    def __init__(
        self,
        *,
        container_revision_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["container_revision_id", b"container_revision_id"]) -> None: ...

global___DeployContainerRevisionMetadata = DeployContainerRevisionMetadata

@typing.final
class RollbackContainerRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINER_ID_FIELD_NUMBER: builtins.int
    REVISION_ID_FIELD_NUMBER: builtins.int
    container_id: builtins.str
    """ID of the container to rollback to an old revision.

    To get a container ID, make a [ContainerService.List] request.
    """
    revision_id: builtins.str
    """ID of the revision to rollback to.

    To get a revision ID make a [ContainerService.ListRevisions] request.
    """
    def __init__(
        self,
        *,
        container_id: builtins.str = ...,
        revision_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["container_id", b"container_id", "revision_id", b"revision_id"]) -> None: ...

global___RollbackContainerRequest = RollbackContainerRequest

@typing.final
class RollbackContainerMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINER_ID_FIELD_NUMBER: builtins.int
    REVISION_ID_FIELD_NUMBER: builtins.int
    container_id: builtins.str
    """ID of the container that is being rolled back."""
    revision_id: builtins.str
    """ID of the revision that the container is being rolled back to."""
    def __init__(
        self,
        *,
        container_id: builtins.str = ...,
        revision_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["container_id", b"container_id", "revision_id", b"revision_id"]) -> None: ...

global___RollbackContainerMetadata = RollbackContainerMetadata

@typing.final
class ListContainerOperationsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    container_id: builtins.str
    """ID of the container to list operations for."""
    page_size: builtins.int
    """The maximum number of results per page that should be returned. If the number of available
    results is larger than `pageSize`, the service returns a [ListContainerOperationsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.

    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set `pageToken` to the
    [ListContainerOperationsResponse.next_page_token] returned by a previous list request.
    """
    filter: builtins.str
    """A filter expression that filters resources listed in the response.

    The expression must specify:
    1. The field name. Currently filtering can be applied to the [operation.Operation.done], [operation.Operation.created_by] field.
    2. An `=` operator.
    3. The value in double quotes (`"`). Must be 3-63 characters long and match the regular expression `[a-z][-a-z0-9]{1,61}[a-z0-9]`.
    Examples of a filter: `done=false`, `created_by='John.Doe'`.
    """
    def __init__(
        self,
        *,
        container_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["container_id", b"container_id", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListContainerOperationsRequest = ListContainerOperationsRequest

@typing.final
class ListContainerOperationsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    the specified [ListContainerOperationsRequest.page_size], use `nextPageToken` as the value
    for the [ListContainerOperationsRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `nextPageToken` to continue paging through the results.
    """
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.operation.operation_pb2.Operation]:
        """List of operations for the specified container."""

    def __init__(
        self,
        *,
        operations: collections.abc.Iterable[yandex.cloud.operation.operation_pb2.Operation] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "operations", b"operations"]) -> None: ...

global___ListContainerOperationsResponse = ListContainerOperationsResponse
