"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.operation.operation_pb2
import yandex.cloud.serverless.eventrouter.v1.bus_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetBusRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BUS_ID_FIELD_NUMBER: builtins.int
    bus_id: builtins.str
    """ID of the bus to get."""
    def __init__(
        self,
        *,
        bus_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["bus_id", b"bus_id"]) -> None: ...

global___GetBusRequest = GetBusRequest

@typing.final
class ListBusesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to list buses in."""
    page_size: builtins.int
    """Maximum number of buses to return."""
    page_token: builtins.str
    """Page token. To get the next page of results, set `page_token` to the
    [ListBusesResponse.next_page_token] returned by a previous list request.
    """
    filter: builtins.str
    """Supported fields for filter:
      name
      created_at
    """
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "folder_id", b"folder_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListBusesRequest = ListBusesRequest

@typing.final
class ListBusesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BUSES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list of buses."""
    @property
    def buses(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.serverless.eventrouter.v1.bus_pb2.Bus]:
        """List of buses."""

    def __init__(
        self,
        *,
        buses: collections.abc.Iterable[yandex.cloud.serverless.eventrouter.v1.bus_pb2.Bus] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["buses", b"buses", "next_page_token", b"next_page_token"]) -> None: ...

global___ListBusesResponse = ListBusesResponse

@typing.final
class CreateBusRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    LOGGING_ENABLED_FIELD_NUMBER: builtins.int
    LOG_OPTIONS_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to create a bus in."""
    name: builtins.str
    """Name of the bus."""
    description: builtins.str
    """Description of the bus."""
    deletion_protection: builtins.bool
    """Flag that disallow deletion of the bus."""
    logging_enabled: builtins.bool
    """Is logging from the bus enabled."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Labels for the bus."""

    @property
    def log_options(self) -> yandex.cloud.serverless.eventrouter.v1.bus_pb2.LogOptions:
        """Options for logging from the bus."""

    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        deletion_protection: builtins.bool = ...,
        logging_enabled: builtins.bool = ...,
        log_options: yandex.cloud.serverless.eventrouter.v1.bus_pb2.LogOptions | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["log_options", b"log_options"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["deletion_protection", b"deletion_protection", "description", b"description", "folder_id", b"folder_id", "labels", b"labels", "log_options", b"log_options", "logging_enabled", b"logging_enabled", "name", b"name"]) -> None: ...

global___CreateBusRequest = CreateBusRequest

@typing.final
class CreateBusMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BUS_ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    bus_id: builtins.str
    """ID of the bus that is being created."""
    folder_id: builtins.str
    """ID of the folder that the bus is being created in."""
    def __init__(
        self,
        *,
        bus_id: builtins.str = ...,
        folder_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["bus_id", b"bus_id", "folder_id", b"folder_id"]) -> None: ...

global___CreateBusMetadata = CreateBusMetadata

@typing.final
class UpdateBusRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    BUS_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    LOGGING_ENABLED_FIELD_NUMBER: builtins.int
    LOG_OPTIONS_FIELD_NUMBER: builtins.int
    bus_id: builtins.str
    """ID of the bus to update."""
    name: builtins.str
    """New name of the bus."""
    description: builtins.str
    """ New description of the bus."""
    deletion_protection: builtins.bool
    """New flag that disallow deletion of the bus."""
    logging_enabled: builtins.bool
    """Is logging from the bus enabled."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which fields of the bus are going to be updated."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """New labels of the bus."""

    @property
    def log_options(self) -> yandex.cloud.serverless.eventrouter.v1.bus_pb2.LogOptions:
        """New options for logging from the bus."""

    def __init__(
        self,
        *,
        bus_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        deletion_protection: builtins.bool = ...,
        logging_enabled: builtins.bool = ...,
        log_options: yandex.cloud.serverless.eventrouter.v1.bus_pb2.LogOptions | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["log_options", b"log_options", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["bus_id", b"bus_id", "deletion_protection", b"deletion_protection", "description", b"description", "labels", b"labels", "log_options", b"log_options", "logging_enabled", b"logging_enabled", "name", b"name", "update_mask", b"update_mask"]) -> None: ...

global___UpdateBusRequest = UpdateBusRequest

@typing.final
class UpdateBusMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BUS_ID_FIELD_NUMBER: builtins.int
    bus_id: builtins.str
    """ID of the bus that is being updated."""
    def __init__(
        self,
        *,
        bus_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["bus_id", b"bus_id"]) -> None: ...

global___UpdateBusMetadata = UpdateBusMetadata

@typing.final
class DeleteBusRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BUS_ID_FIELD_NUMBER: builtins.int
    bus_id: builtins.str
    """ID of the bus to delete."""
    def __init__(
        self,
        *,
        bus_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["bus_id", b"bus_id"]) -> None: ...

global___DeleteBusRequest = DeleteBusRequest

@typing.final
class DeleteBusMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BUS_ID_FIELD_NUMBER: builtins.int
    bus_id: builtins.str
    """ID of the bus that is being deleted."""
    def __init__(
        self,
        *,
        bus_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["bus_id", b"bus_id"]) -> None: ...

global___DeleteBusMetadata = DeleteBusMetadata

@typing.final
class ListBusOperationsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BUS_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    bus_id: builtins.str
    """ID of the bus to list operations for."""
    page_size: builtins.int
    """Maximum number of operations to return."""
    page_token: builtins.str
    """Page token. To get the next page of results, set `page_token` to the
    [ListBusesResponse.next_page_token] returned by a previous list request.
    """
    filter: builtins.str
    """Supported attributes for filter:
      description
      created_at
      modified_at
      created_by
      done
    """
    def __init__(
        self,
        *,
        bus_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["bus_id", b"bus_id", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListBusOperationsRequest = ListBusOperationsRequest

@typing.final
class ListBusOperationsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list of operations."""
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.operation.operation_pb2.Operation]:
        """List of operations for the specified bus."""

    def __init__(
        self,
        *,
        operations: collections.abc.Iterable[yandex.cloud.operation.operation_pb2.Operation] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "operations", b"operations"]) -> None: ...

global___ListBusOperationsResponse = ListBusOperationsResponse
