"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Connector(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Connector._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: Connector._Status.ValueType  # 0
        RUNNING: Connector._Status.ValueType  # 1
        STOPPED: Connector._Status.ValueType  # 2
        """disabled by user"""
        RESOURCE_NOT_FOUND: Connector._Status.ValueType  # 3
        """source does not exist"""
        PERMISSION_DENIED: Connector._Status.ValueType  # 4
        """service account does not have read permission on source"""
        SUBJECT_NOT_FOUND: Connector._Status.ValueType  # 5
        """service account not found"""
        DELETING: Connector._Status.ValueType  # 7
        """deletion in progress"""
        CREATING: Connector._Status.ValueType  # 8
        """creation in progress"""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper):
        """Status of the connector."""

    STATUS_UNSPECIFIED: Connector.Status.ValueType  # 0
    RUNNING: Connector.Status.ValueType  # 1
    STOPPED: Connector.Status.ValueType  # 2
    """disabled by user"""
    RESOURCE_NOT_FOUND: Connector.Status.ValueType  # 3
    """source does not exist"""
    PERMISSION_DENIED: Connector.Status.ValueType  # 4
    """service account does not have read permission on source"""
    SUBJECT_NOT_FOUND: Connector.Status.ValueType  # 5
    """service account not found"""
    DELETING: Connector.Status.ValueType  # 7
    """deletion in progress"""
    CREATING: Connector.Status.ValueType  # 8
    """creation in progress"""

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    BUS_ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    CLOUD_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    SOURCE_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the connector."""
    bus_id: builtins.str
    """ID of the bus that the connector belongs to."""
    folder_id: builtins.str
    """ID of the folder that the connector resides in."""
    cloud_id: builtins.str
    """ID of the cloud that the connector resides in."""
    name: builtins.str
    """Name of the connector."""
    description: builtins.str
    """Description of the connector."""
    deletion_protection: builtins.bool
    """Deletion protection."""
    status: global___Connector.Status.ValueType
    """Status of the connector."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `key:value` pairs."""

    @property
    def source(self) -> global___Source:
        """Source of the connector."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        bus_id: builtins.str = ...,
        folder_id: builtins.str = ...,
        cloud_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        source: global___Source | None = ...,
        deletion_protection: builtins.bool = ...,
        status: global___Connector.Status.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at", "source", b"source"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["bus_id", b"bus_id", "cloud_id", b"cloud_id", "created_at", b"created_at", "deletion_protection", b"deletion_protection", "description", b"description", "folder_id", b"folder_id", "id", b"id", "labels", b"labels", "name", b"name", "source", b"source", "status", b"status"]) -> None: ...

global___Connector = Connector

@typing.final
class Source(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATA_STREAM_FIELD_NUMBER: builtins.int
    MESSAGE_QUEUE_FIELD_NUMBER: builtins.int
    TIMER_FIELD_NUMBER: builtins.int
    EVENT_SERVICE_SOURCE_FIELD_NUMBER: builtins.int
    AUDIT_TRAILS_FIELD_NUMBER: builtins.int
    @property
    def data_stream(self) -> global___DataStream: ...
    @property
    def message_queue(self) -> global___MessageQueue: ...
    @property
    def timer(self) -> global___Timer: ...
    @property
    def event_service_source(self) -> global___EventServiceSource: ...
    @property
    def audit_trails(self) -> global___AuditTrails: ...
    def __init__(
        self,
        *,
        data_stream: global___DataStream | None = ...,
        message_queue: global___MessageQueue | None = ...,
        timer: global___Timer | None = ...,
        event_service_source: global___EventServiceSource | None = ...,
        audit_trails: global___AuditTrails | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["audit_trails", b"audit_trails", "data_stream", b"data_stream", "event_service_source", b"event_service_source", "message_queue", b"message_queue", "source", b"source", "timer", b"timer"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["audit_trails", b"audit_trails", "data_stream", b"data_stream", "event_service_source", b"event_service_source", "message_queue", b"message_queue", "source", b"source", "timer", b"timer"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["source", b"source"]) -> typing.Literal["data_stream", "message_queue", "timer", "event_service_source", "audit_trails"] | None: ...

global___Source = Source

@typing.final
class DataStream(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATABASE_FIELD_NUMBER: builtins.int
    STREAM_NAME_FIELD_NUMBER: builtins.int
    CONSUMER_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    database: builtins.str
    """Stream database. 
    example: /ru-central1/aoegtvhtp8ob********/cc8004q4lbo6********
    """
    stream_name: builtins.str
    """Stream name, absolute or relative."""
    consumer: builtins.str
    """Consumer name."""
    service_account_id: builtins.str
    """Service account which has read permission on the stream."""
    def __init__(
        self,
        *,
        database: builtins.str = ...,
        stream_name: builtins.str = ...,
        consumer: builtins.str = ...,
        service_account_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["consumer", b"consumer", "database", b"database", "service_account_id", b"service_account_id", "stream_name", b"stream_name"]) -> None: ...

global___DataStream = DataStream

@typing.final
class MessageQueue(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    QUEUE_ARN_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    VISIBILITY_TIMEOUT_FIELD_NUMBER: builtins.int
    BATCH_SIZE_FIELD_NUMBER: builtins.int
    POLLING_TIMEOUT_FIELD_NUMBER: builtins.int
    queue_arn: builtins.str
    """Queue ARN.
    Example: yrn:yc:ymq:ru-central1:aoe***:test
    """
    service_account_id: builtins.str
    """Service account which has read access to the queue."""
    batch_size: builtins.int
    """Batch size for polling."""
    @property
    def visibility_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """Queue visibility timeout override."""

    @property
    def polling_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """Queue polling timeout."""

    def __init__(
        self,
        *,
        queue_arn: builtins.str = ...,
        service_account_id: builtins.str = ...,
        visibility_timeout: google.protobuf.duration_pb2.Duration | None = ...,
        batch_size: builtins.int = ...,
        polling_timeout: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["polling_timeout", b"polling_timeout", "visibility_timeout", b"visibility_timeout"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["batch_size", b"batch_size", "polling_timeout", b"polling_timeout", "queue_arn", b"queue_arn", "service_account_id", b"service_account_id", "visibility_timeout", b"visibility_timeout"]) -> None: ...

global___MessageQueue = MessageQueue

@typing.final
class EventServiceSource(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___EventServiceSource = EventServiceSource

@typing.final
class Timer(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CRON_EXPRESSION_FIELD_NUMBER: builtins.int
    TIME_ZONE_FIELD_NUMBER: builtins.int
    PAYLOAD_FIELD_NUMBER: builtins.int
    cron_expression: builtins.str
    """cron expression, with second precision"""
    time_zone: builtins.str
    """time zone, e.g. Europe/Moscow"""
    payload: builtins.str
    """payload to send to target"""
    def __init__(
        self,
        *,
        cron_expression: builtins.str = ...,
        time_zone: builtins.str = ...,
        payload: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cron_expression", b"cron_expression", "payload", b"payload", "time_zone", b"time_zone"]) -> None: ...

global___Timer = Timer

@typing.final
class AuditTrails(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___AuditTrails = AuditTrails
