"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class UsedNetwork(google.protobuf.message.Message):
    """A VPC network used in serverless resources."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[UsedNetwork._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: UsedNetwork._Status.ValueType  # 0
        CREATING: UsedNetwork._Status.ValueType  # 1
        """Network is connecting to its first serverless resource."""
        ACTIVE: UsedNetwork._Status.ValueType  # 2
        """Network is already being used by some serverless resources."""
        OBSOLETE: UsedNetwork._Status.ValueType  # 3
        """Network is no longer used by any serverless resources.
        It will be cleaned-up after a while.
        """

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNSPECIFIED: UsedNetwork.Status.ValueType  # 0
    CREATING: UsedNetwork.Status.ValueType  # 1
    """Network is connecting to its first serverless resource."""
    ACTIVE: UsedNetwork.Status.ValueType  # 2
    """Network is already being used by some serverless resources."""
    OBSOLETE: UsedNetwork.Status.ValueType  # 3
    """Network is no longer used by any serverless resources.
    It will be cleaned-up after a while.
    """

    NETWORK_ID_FIELD_NUMBER: builtins.int
    CLOUD_ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    WILL_BE_CLEANED_UP_AT_FIELD_NUMBER: builtins.int
    CONNECTIONS_COUNT_FIELD_NUMBER: builtins.int
    network_id: builtins.str
    """ID of the VPC network."""
    cloud_id: builtins.str
    """ID of the cloud that the network belongs to."""
    folder_id: builtins.str
    """ID of the folder that the network belongs to."""
    status: global___UsedNetwork.Status.ValueType
    """Status of the network."""
    connections_count: builtins.int
    """Number of serverless resources connected to the network."""
    @property
    def will_be_cleaned_up_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Clean-up timestamp of the obsolete network."""

    def __init__(
        self,
        *,
        network_id: builtins.str = ...,
        cloud_id: builtins.str = ...,
        folder_id: builtins.str = ...,
        status: global___UsedNetwork.Status.ValueType = ...,
        will_be_cleaned_up_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        connections_count: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["will_be_cleaned_up_at", b"will_be_cleaned_up_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cloud_id", b"cloud_id", "connections_count", b"connections_count", "folder_id", b"folder_id", "network_id", b"network_id", "status", b"status", "will_be_cleaned_up_at", b"will_be_cleaned_up_at"]) -> None: ...

global___UsedNetwork = UsedNetwork

@typing.final
class GetUsedNetworkRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NETWORK_ID_FIELD_NUMBER: builtins.int
    network_id: builtins.str
    """ID of the network to return."""
    def __init__(
        self,
        *,
        network_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["network_id", b"network_id"]) -> None: ...

global___GetUsedNetworkRequest = GetUsedNetworkRequest

@typing.final
class ListUsedNetworksRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    CLOUD_ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than `pageSize`, the service returns a [ListUsedNetworksResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.

    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set `pageToken` to the
    [ListUsedNetworksResponse.next_page_token] returned by a previous list request.
    """
    cloud_id: builtins.str
    """ID of the cloud to list used networks in."""
    folder_id: builtins.str
    """ID of the folder to list used networks in."""
    def __init__(
        self,
        *,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        cloud_id: builtins.str = ...,
        folder_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["cloud_id", b"cloud_id", "folder_id", b"folder_id", "scope", b"scope"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cloud_id", b"cloud_id", "folder_id", b"folder_id", "page_size", b"page_size", "page_token", b"page_token", "scope", b"scope"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["scope", b"scope"]) -> typing.Literal["cloud_id", "folder_id"] | None: ...

global___ListUsedNetworksRequest = ListUsedNetworksRequest

@typing.final
class ListUsedNetworksResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NETWORKS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    the specified [ListUsedNetworksRequest.page_size], use `nextPageToken` as the value
    for the [ListUsedNetworksRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `nextPageToken` to continue paging through the results.
    """
    @property
    def networks(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___UsedNetwork]:
        """List of used networks in the specified scope."""

    def __init__(
        self,
        *,
        networks: collections.abc.Iterable[global___UsedNetwork] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["networks", b"networks", "next_page_token", b"next_page_token"]) -> None: ...

global___ListUsedNetworksResponse = ListUsedNetworksResponse

@typing.final
class ListConnectedResourcesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    NETWORK_ID_FIELD_NUMBER: builtins.int
    CLOUD_ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than `pageSize`, the service returns a [ListConnectedResourcesResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.

    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set `pageToken` to the
    [ListConnectedResourcesResponse.next_page_token] returned by a previous list request.
    """
    network_id: builtins.str
    """ID of the network to list serverless resources connected to it."""
    cloud_id: builtins.str
    """ID of the cloud to list serverless resources connected to any network from it."""
    folder_id: builtins.str
    """ID of the folder to list serverless resources connected to any network from it."""
    def __init__(
        self,
        *,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        network_id: builtins.str = ...,
        cloud_id: builtins.str = ...,
        folder_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["cloud_id", b"cloud_id", "folder_id", b"folder_id", "network_id", b"network_id", "network_scope", b"network_scope"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cloud_id", b"cloud_id", "folder_id", b"folder_id", "network_id", b"network_id", "network_scope", b"network_scope", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["network_scope", b"network_scope"]) -> typing.Literal["network_id", "cloud_id", "folder_id"] | None: ...

global___ListConnectedResourcesRequest = ListConnectedResourcesRequest

@typing.final
class ListConnectedResourcesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class ConnectedResource(google.protobuf.message.Message):
        """Serverless resource connected to VPC network."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NETWORK_ID_FIELD_NUMBER: builtins.int
        RESOURCE_TYPE_FIELD_NUMBER: builtins.int
        RESOURCE_ID_FIELD_NUMBER: builtins.int
        SUBRESOURCE_TYPE_FIELD_NUMBER: builtins.int
        SUBRESOURCE_ID_FIELD_NUMBER: builtins.int
        RESOURCE_CLOUD_ID_FIELD_NUMBER: builtins.int
        RESOURCE_FOLDER_ID_FIELD_NUMBER: builtins.int
        network_id: builtins.str
        """ID of the network to which the resource is connected."""
        resource_type: builtins.str
        """Type of the serverless resource."""
        resource_id: builtins.str
        """ID of the serverless resource."""
        subresource_type: builtins.str
        """Type of the serverless subresource."""
        subresource_id: builtins.str
        """ID of the serverless subresource."""
        resource_cloud_id: builtins.str
        """ID of the cloud that the resource belongs to."""
        resource_folder_id: builtins.str
        """ID of the folder thar the resource belongs to."""
        def __init__(
            self,
            *,
            network_id: builtins.str = ...,
            resource_type: builtins.str = ...,
            resource_id: builtins.str = ...,
            subresource_type: builtins.str = ...,
            subresource_id: builtins.str = ...,
            resource_cloud_id: builtins.str = ...,
            resource_folder_id: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["network_id", b"network_id", "resource_cloud_id", b"resource_cloud_id", "resource_folder_id", b"resource_folder_id", "resource_id", b"resource_id", "resource_type", b"resource_type", "subresource_id", b"subresource_id", "subresource_type", b"subresource_type"]) -> None: ...

    RESOURCES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    the specified [ListConnectedResourcesRequest.page_size], use `nextPageToken` as the value
    for the [ListConnectedResourcesRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `nextPageToken` to continue paging through the results.
    """
    @property
    def resources(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ListConnectedResourcesResponse.ConnectedResource]:
        """List of serverless resources connected to any network from the specified scope."""

    def __init__(
        self,
        *,
        resources: collections.abc.Iterable[global___ListConnectedResourcesResponse.ConnectedResource] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "resources", b"resources"]) -> None: ...

global___ListConnectedResourcesResponse = ListConnectedResourcesResponse

@typing.final
class TriggerUsedNetworkCleanupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NETWORK_ID_FIELD_NUMBER: builtins.int
    network_id: builtins.str
    """ID of the obsolete network to start the cleanup process for."""
    def __init__(
        self,
        *,
        network_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["network_id", b"network_id"]) -> None: ...

global___TriggerUsedNetworkCleanupRequest = TriggerUsedNetworkCleanupRequest

@typing.final
class TriggerUsedNetworkCleanupResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NETWORK_CLEANUP_TIME_FIELD_NUMBER: builtins.int
    @property
    def network_cleanup_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp when cleanup of the specified network will be started."""

    def __init__(
        self,
        *,
        network_cleanup_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["network_cleanup_time", b"network_cleanup_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["network_cleanup_time", b"network_cleanup_time"]) -> None: ...

global___TriggerUsedNetworkCleanupResponse = TriggerUsedNetworkCleanupResponse
