"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.operation.operation_pb2
import yandex.cloud.serverless.mdbproxy.v1.proxy_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetProxyRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROXY_ID_FIELD_NUMBER: builtins.int
    proxy_id: builtins.str
    """ID of the proxy to return.

    To get a proxy ID make a [ProxyService.List] request.
    """
    def __init__(
        self,
        *,
        proxy_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["proxy_id", b"proxy_id"]) -> None: ...

global___GetProxyRequest = GetProxyRequest

@typing.final
class ListProxyRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to list proxies in.

    To get a folder ID make a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than `pageSize`, the service returns a [ListProxyResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.

    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set `pageToken` to the
    [ListProxyResponse.next_page_token] returned by a previous list request.
    """
    filter: builtins.str
    """A filter expression that filters proxies listed in the response.

    The expression must specify:
    1. The field name. Currently filtering can only be applied to the [Proxy.name] field.
    2. An `=` operator.
    3. The value in double quotes (`"`). Must be 3-63 characters long and match the regular expression `[a-z][-a-z0-9]{1,61}[a-z0-9]`.
    Example of a filter: `name=my-proxy`.
    """
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "folder_id", b"folder_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListProxyRequest = ListProxyRequest

@typing.final
class ListProxyResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROXIES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    the specified [ListProxyRequest.page_size], use `nextPageToken` as the value
    for the [ListProxyRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `nextPageToken` to continue paging through the results.
    """
    @property
    def proxies(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.serverless.mdbproxy.v1.proxy_pb2.Proxy]:
        """List of proxies in the specified folder."""

    def __init__(
        self,
        *,
        proxies: collections.abc.Iterable[yandex.cloud.serverless.mdbproxy.v1.proxy_pb2.Proxy] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "proxies", b"proxies"]) -> None: ...

global___ListProxyResponse = ListProxyResponse

@typing.final
class CreateProxyRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    TARGET_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to create a proxy in.

    To get a folder ID make a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    name: builtins.str
    """Name of the proxy.
    The name must be unique within the folder.
    """
    description: builtins.str
    """Description of the proxy."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `key:value` pairs."""

    @property
    def target(self) -> yandex.cloud.serverless.mdbproxy.v1.proxy_pb2.Target:
        """Proxy target."""

    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        target: yandex.cloud.serverless.mdbproxy.v1.proxy_pb2.Target | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["target", b"target"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "folder_id", b"folder_id", "labels", b"labels", "name", b"name", "target", b"target"]) -> None: ...

global___CreateProxyRequest = CreateProxyRequest

@typing.final
class CreateProxyMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROXY_ID_FIELD_NUMBER: builtins.int
    proxy_id: builtins.str
    """ID of the proxy."""
    def __init__(
        self,
        *,
        proxy_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["proxy_id", b"proxy_id"]) -> None: ...

global___CreateProxyMetadata = CreateProxyMetadata

@typing.final
class UpdateProxyRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    PROXY_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    TARGET_FIELD_NUMBER: builtins.int
    proxy_id: builtins.str
    """ID of the proxy to update."""
    name: builtins.str
    """New name for the proxy.
    The name must be unique within the folder.
    """
    description: builtins.str
    """New description for the proxy."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which attributes of the proxy should be updated."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Proxy labels as `key:value` pairs."""

    @property
    def target(self) -> yandex.cloud.serverless.mdbproxy.v1.proxy_pb2.Target:
        """Proxy target."""

    def __init__(
        self,
        *,
        proxy_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        target: yandex.cloud.serverless.mdbproxy.v1.proxy_pb2.Target | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["target", b"target", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "labels", b"labels", "name", b"name", "proxy_id", b"proxy_id", "target", b"target", "update_mask", b"update_mask"]) -> None: ...

global___UpdateProxyRequest = UpdateProxyRequest

@typing.final
class UpdateProxyMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROXY_ID_FIELD_NUMBER: builtins.int
    proxy_id: builtins.str
    """ID of the proxy."""
    def __init__(
        self,
        *,
        proxy_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["proxy_id", b"proxy_id"]) -> None: ...

global___UpdateProxyMetadata = UpdateProxyMetadata

@typing.final
class DeleteProxyRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROXY_ID_FIELD_NUMBER: builtins.int
    proxy_id: builtins.str
    """ID of the proxy."""
    def __init__(
        self,
        *,
        proxy_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["proxy_id", b"proxy_id"]) -> None: ...

global___DeleteProxyRequest = DeleteProxyRequest

@typing.final
class DeleteProxyMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROXY_ID_FIELD_NUMBER: builtins.int
    proxy_id: builtins.str
    """ID of the proxy."""
    def __init__(
        self,
        *,
        proxy_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["proxy_id", b"proxy_id"]) -> None: ...

global___DeleteProxyMetadata = DeleteProxyMetadata

@typing.final
class ListProxyOperationsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROXY_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    proxy_id: builtins.str
    """ID of the proxy to list operations for."""
    page_size: builtins.int
    """The maximum number of results per page that should be returned. If the number of available
    results is larger than `pageSize`, the service returns a [ListProxyOperationsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.

    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set `pageToken` to the
    [ListProxyOperationsResponse.next_page_token] returned by a previous list request.
    """
    filter: builtins.str
    """A filter expression that filters resources listed in the response.

    The expression must specify:
    1. The field name. Currently filtering can be applied to the [operation.Operation.done], [operation.Operation.created_by] field.
    2. An `=` operator.
    3. The value in double quotes (`"`). Must be 3-63 characters long and match the regular expression `[a-z][-a-z0-9]{1,61}[a-z0-9]`.
    Examples of a filter: `done=false`, `created_by='John.Doe'`.
    """
    def __init__(
        self,
        *,
        proxy_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "proxy_id", b"proxy_id"]) -> None: ...

global___ListProxyOperationsRequest = ListProxyOperationsRequest

@typing.final
class ListProxyOperationsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    the specified [ListProxyOperationsRequest.page_size], use `nextPageToken` as the value
    for the [ListProxyOperationsRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `nextPageToken` to continue paging through the results.
    """
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.operation.operation_pb2.Operation]:
        """List of operations for the specified proxy."""

    def __init__(
        self,
        *,
        operations: collections.abc.Iterable[yandex.cloud.operation.operation_pb2.Operation] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "operations", b"operations"]) -> None: ...

global___ListProxyOperationsResponse = ListProxyOperationsResponse
