"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.operation.operation_pb2
import yandex.cloud.serverless.triggers.v1.trigger_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetTriggerRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRIGGER_ID_FIELD_NUMBER: builtins.int
    trigger_id: builtins.str
    """ID of the trigger to return.

    To get a trigger ID make a [TriggerService.List] request.
    """
    def __init__(
        self,
        *,
        trigger_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["trigger_id", b"trigger_id"]) -> None: ...

global___GetTriggerRequest = GetTriggerRequest

@typing.final
class ListTriggersRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to list triggers in.

    To get a folder ID use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than `pageSize`, the service returns a [ListTriggersResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.

    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set `pageToken` to the
    [ListTriggersResponse.next_page_token] returned by a previous list request.
    """
    filter: builtins.str
    """A filter expression that filters triggers listed in the response.

    The expression must specify:
    1. The field name. Currently filtering can only be applied to the [Trigger.name] field.
    2. An `=` operator.
    3. The value in double quotes (`"`). Must be 3-63 characters long and match the regular expression `[a-z][-a-z0-9]{1,61}[a-z0-9]`.
    Example of a filter: `name=my-trigger`.
    """
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "folder_id", b"folder_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListTriggersRequest = ListTriggersRequest

@typing.final
class ListTriggersResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRIGGERS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    the specified [ListTriggersRequest.page_size], use `nextPageToken` as the value
    for the [ListTriggersRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `nextPageToken` to continue paging through the results.
    """
    @property
    def triggers(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.serverless.triggers.v1.trigger_pb2.Trigger]:
        """List of triggers in the specified folder."""

    def __init__(
        self,
        *,
        triggers: collections.abc.Iterable[yandex.cloud.serverless.triggers.v1.trigger_pb2.Trigger] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "triggers", b"triggers"]) -> None: ...

global___ListTriggersResponse = ListTriggersResponse

@typing.final
class CreateTriggerRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    RULE_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to create a trigger in.

    To get a folder ID make a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    name: builtins.str
    """Name of the trigger.
    The name must be unique within the folder.
    """
    description: builtins.str
    """Description of the trigger."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `key:value` pairs."""

    @property
    def rule(self) -> yandex.cloud.serverless.triggers.v1.trigger_pb2.Trigger.Rule:
        """Trigger type."""

    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        rule: yandex.cloud.serverless.triggers.v1.trigger_pb2.Trigger.Rule | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["rule", b"rule"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "folder_id", b"folder_id", "labels", b"labels", "name", b"name", "rule", b"rule"]) -> None: ...

global___CreateTriggerRequest = CreateTriggerRequest

@typing.final
class CreateTriggerMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRIGGER_ID_FIELD_NUMBER: builtins.int
    trigger_id: builtins.str
    """ID of the trigger that is being created."""
    def __init__(
        self,
        *,
        trigger_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["trigger_id", b"trigger_id"]) -> None: ...

global___CreateTriggerMetadata = CreateTriggerMetadata

@typing.final
class UpdateTriggerRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    TRIGGER_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    RULE_FIELD_NUMBER: builtins.int
    trigger_id: builtins.str
    """ID of the trigger to update.

    To get a trigger ID make a [TriggerService.List] request.
    """
    name: builtins.str
    """New name for the trigger.
    The name must be unique within the folder.
    """
    description: builtins.str
    """New description of the trigger."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which attributes of the trigger should be updated."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Trigger labels as `key:value` pairs.

        Existing set of labels is completely replaced by the provided set, so if you just want
        to add or remove a label, request the current set of labels with a [TriggerService.Get] request.
        """

    @property
    def rule(self) -> yandex.cloud.serverless.triggers.v1.trigger_pb2.Trigger.Rule:
        """New parameters for trigger."""

    def __init__(
        self,
        *,
        trigger_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        rule: yandex.cloud.serverless.triggers.v1.trigger_pb2.Trigger.Rule | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["rule", b"rule", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "labels", b"labels", "name", b"name", "rule", b"rule", "trigger_id", b"trigger_id", "update_mask", b"update_mask"]) -> None: ...

global___UpdateTriggerRequest = UpdateTriggerRequest

@typing.final
class UpdateTriggerMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRIGGER_ID_FIELD_NUMBER: builtins.int
    trigger_id: builtins.str
    """ID of the trigger that is being updated."""
    def __init__(
        self,
        *,
        trigger_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["trigger_id", b"trigger_id"]) -> None: ...

global___UpdateTriggerMetadata = UpdateTriggerMetadata

@typing.final
class DeleteTriggerRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRIGGER_ID_FIELD_NUMBER: builtins.int
    trigger_id: builtins.str
    """ID of the trigger to delete.

    To get a trigger ID make a [TriggerService.List] request.
    """
    def __init__(
        self,
        *,
        trigger_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["trigger_id", b"trigger_id"]) -> None: ...

global___DeleteTriggerRequest = DeleteTriggerRequest

@typing.final
class DeleteTriggerMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRIGGER_ID_FIELD_NUMBER: builtins.int
    trigger_id: builtins.str
    """ID of the trigger that is being deleted."""
    def __init__(
        self,
        *,
        trigger_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["trigger_id", b"trigger_id"]) -> None: ...

global___DeleteTriggerMetadata = DeleteTriggerMetadata

@typing.final
class PauseTriggerRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRIGGER_ID_FIELD_NUMBER: builtins.int
    trigger_id: builtins.str
    """ID of the trigger to pause

    To get a trigger ID make a [TriggerService.List] request.
    """
    def __init__(
        self,
        *,
        trigger_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["trigger_id", b"trigger_id"]) -> None: ...

global___PauseTriggerRequest = PauseTriggerRequest

@typing.final
class PauseTriggerMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRIGGER_ID_FIELD_NUMBER: builtins.int
    trigger_id: builtins.str
    """ID of the trigger that is being paused."""
    def __init__(
        self,
        *,
        trigger_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["trigger_id", b"trigger_id"]) -> None: ...

global___PauseTriggerMetadata = PauseTriggerMetadata

@typing.final
class ResumeTriggerRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRIGGER_ID_FIELD_NUMBER: builtins.int
    trigger_id: builtins.str
    """ID of the trigger to pause

    To get a trigger ID make a [TriggerService.List] request.
    """
    def __init__(
        self,
        *,
        trigger_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["trigger_id", b"trigger_id"]) -> None: ...

global___ResumeTriggerRequest = ResumeTriggerRequest

@typing.final
class ResumeTriggerMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRIGGER_ID_FIELD_NUMBER: builtins.int
    trigger_id: builtins.str
    """ID of the trigger that is being paused."""
    def __init__(
        self,
        *,
        trigger_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["trigger_id", b"trigger_id"]) -> None: ...

global___ResumeTriggerMetadata = ResumeTriggerMetadata

@typing.final
class ListTriggerOperationsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRIGGER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    trigger_id: builtins.str
    """ID of the trigger to list operations for."""
    page_size: builtins.int
    """The maximum number of results per page that should be returned. If the number of available
    results is larger than `pageSize`, the service returns a [ListTriggerOperationsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.

    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set `pageToken` to the
    [ListTriggerOperationsResponse.next_page_token] returned by a previous list request.
    """
    filter: builtins.str
    """A filter expression that filters resources listed in the response.

    The expression must specify:
    1. The field name. Currently filtering can only be applied to the [Trigger.name] field.
    2. An `=` operator.
    3. The value in double quotes (`"`). Must be 3-63 characters long and match the regular expression `[a-z][-a-z0-9]{1,61}[a-z0-9]`.
    Example of a filter: `name=my-function`.
    """
    def __init__(
        self,
        *,
        trigger_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "trigger_id", b"trigger_id"]) -> None: ...

global___ListTriggerOperationsRequest = ListTriggerOperationsRequest

@typing.final
class ListTriggerOperationsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    the specified [ListTriggerOperationsRequest.page_size], use `nextPageToken` as the value
    for the [ListTriggerOperationsRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `nextPageToken` to continue paging through the results.
    """
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.operation.operation_pb2.Operation]:
        """List of operations for the specified trigger."""

    def __init__(
        self,
        *,
        operations: collections.abc.Iterable[yandex.cloud.operation.operation_pb2.Operation] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "operations", b"operations"]) -> None: ...

global___ListTriggerOperationsResponse = ListTriggerOperationsResponse
