"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class HistoryEntry(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[HistoryEntry._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: HistoryEntry._Status.ValueType  # 0
        SCHEDULED: HistoryEntry._Status.ValueType  # 1
        """Step execution is being scheduled."""
        STARTED: HistoryEntry._Status.ValueType  # 2
        """Step execution is started."""
        COMPLETED: HistoryEntry._Status.ValueType  # 3
        """Step execution is completed."""
        FAILED: HistoryEntry._Status.ValueType  # 4
        """Step execution is failed."""
        CANCEL_REQUESTED: HistoryEntry._Status.ValueType  # 5
        """Step execution is requested to be cancelled."""
        CANCELLED: HistoryEntry._Status.ValueType  # 6
        """Step execution is canceled."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNSPECIFIED: HistoryEntry.Status.ValueType  # 0
    SCHEDULED: HistoryEntry.Status.ValueType  # 1
    """Step execution is being scheduled."""
    STARTED: HistoryEntry.Status.ValueType  # 2
    """Step execution is started."""
    COMPLETED: HistoryEntry.Status.ValueType  # 3
    """Step execution is completed."""
    FAILED: HistoryEntry.Status.ValueType  # 4
    """Step execution is failed."""
    CANCEL_REQUESTED: HistoryEntry.Status.ValueType  # 5
    """Step execution is requested to be cancelled."""
    CANCELLED: HistoryEntry.Status.ValueType  # 6
    """Step execution is canceled."""

    @typing.final
    class FailedAttempt(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        STARTED_AT_FIELD_NUMBER: builtins.int
        DURATION_FIELD_NUMBER: builtins.int
        ERROR_FIELD_NUMBER: builtins.int
        @property
        def started_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Start timestamp for the attempt."""

        @property
        def duration(self) -> google.protobuf.duration_pb2.Duration:
            """Duration of the attempt."""

        @property
        def error(self) -> global___HistoryEntryError:
            """Error details."""

        def __init__(
            self,
            *,
            started_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            duration: google.protobuf.duration_pb2.Duration | None = ...,
            error: global___HistoryEntryError | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["duration", b"duration", "error", b"error", "started_at", b"started_at"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["duration", b"duration", "error", b"error", "started_at", b"started_at"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    TITLE_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    STARTED_AT_FIELD_NUMBER: builtins.int
    DURATION_FIELD_NUMBER: builtins.int
    INPUT_FIELD_NUMBER: builtins.int
    OUTPUT_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    ATTEMPTS_FIELD_NUMBER: builtins.int
    LAST_ERROR_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the Workflow step."""
    title: builtins.str
    """Title of the Workflow step."""
    description: builtins.str
    """Description of the Workflow step."""
    status: global___HistoryEntry.Status.ValueType
    """Status of the Workflow step."""
    type: builtins.str
    """Type of the Workflow step (for example, FunctionCall or HttpCall)."""
    attempts: builtins.int
    """Number of attempts (including all retries of unsuccessful attempts). Value "1" means there were no retries."""
    @property
    def started_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Start timestamp for the Workflow step."""

    @property
    def duration(self) -> google.protobuf.duration_pb2.Duration:
        """Duration of the Workflow step."""

    @property
    def input(self) -> global___HistoryEntryInput:
        """Input data for the Workflow step."""

    @property
    def output(self) -> global___HistoryEntryOutput:
        """Result of the Workflow step."""

    @property
    def error(self) -> global___HistoryEntryError:
        """Error details, in case Workflow step failed."""

    @property
    def last_error(self) -> global___HistoryEntryError:
        """Last received error details in case of retries."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        title: builtins.str = ...,
        description: builtins.str = ...,
        started_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        duration: google.protobuf.duration_pb2.Duration | None = ...,
        input: global___HistoryEntryInput | None = ...,
        output: global___HistoryEntryOutput | None = ...,
        error: global___HistoryEntryError | None = ...,
        status: global___HistoryEntry.Status.ValueType = ...,
        type: builtins.str = ...,
        attempts: builtins.int = ...,
        last_error: global___HistoryEntryError | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["duration", b"duration", "error", b"error", "input", b"input", "last_error", b"last_error", "output", b"output", "started_at", b"started_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["attempts", b"attempts", "description", b"description", "duration", b"duration", "error", b"error", "id", b"id", "input", b"input", "last_error", b"last_error", "output", b"output", "started_at", b"started_at", "status", b"status", "title", b"title", "type", b"type"]) -> None: ...

global___HistoryEntry = HistoryEntry

@typing.final
class HistoryEntryInput(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INPUT_JSON_FIELD_NUMBER: builtins.int
    input_json: builtins.str
    """JSON input data for the Workflow step."""
    def __init__(
        self,
        *,
        input_json: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["input", b"input", "input_json", b"input_json"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["input", b"input", "input_json", b"input_json"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["input", b"input"]) -> typing.Literal["input_json"] | None: ...

global___HistoryEntryInput = HistoryEntryInput

@typing.final
class HistoryEntryOutput(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OUTPUT_JSON_FIELD_NUMBER: builtins.int
    output_json: builtins.str
    """JSON result for the Workflow step."""
    def __init__(
        self,
        *,
        output_json: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["output", b"output", "output_json", b"output_json"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["output", b"output", "output_json", b"output_json"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["output", b"output"]) -> typing.Literal["output_json"] | None: ...

global___HistoryEntryOutput = HistoryEntryOutput

@typing.final
class HistoryEntryError(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MESSAGE_FIELD_NUMBER: builtins.int
    ERROR_CODE_FIELD_NUMBER: builtins.int
    message: builtins.str
    """Error message of the Workflow step."""
    error_code: builtins.str
    """Error code of the Workflow step."""
    def __init__(
        self,
        *,
        message: builtins.str = ...,
        error_code: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["error_code", b"error_code", "message", b"message"]) -> None: ...

global___HistoryEntryError = HistoryEntryError
