"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.operation.operation_pb2
import yandex.cloud.serverless.workflows.v1.workflow_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class CreateWorkflowRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    SPECIFICATION_FIELD_NUMBER: builtins.int
    LOG_OPTIONS_FIELD_NUMBER: builtins.int
    NETWORK_ID_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    EXPRESS_FIELD_NUMBER: builtins.int
    SCHEDULE_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to create Workflow in."""
    name: builtins.str
    """Name of Workflow.
    The name must be unique within the folder.
    """
    description: builtins.str
    """Description of Workflow."""
    network_id: builtins.str
    """ID of the VPC network Workflow will be executed in, in order to access private resources."""
    service_account_id: builtins.str
    """ID of the Service Account which will be used for resources access in Workflow execution."""
    express: builtins.bool
    """Express execution mode."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Workflow labels as `key:value` pairs."""

    @property
    def specification(self) -> yandex.cloud.serverless.workflows.v1.workflow_pb2.WorkflowSpecification:
        """Specification of Workflow"""

    @property
    def log_options(self) -> yandex.cloud.serverless.workflows.v1.workflow_pb2.LogOptions:
        """Options for logging from Workflow."""

    @property
    def schedule(self) -> yandex.cloud.serverless.workflows.v1.workflow_pb2.WorkflowSchedule:
        """Workflow schedule settings."""

    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        specification: yandex.cloud.serverless.workflows.v1.workflow_pb2.WorkflowSpecification | None = ...,
        log_options: yandex.cloud.serverless.workflows.v1.workflow_pb2.LogOptions | None = ...,
        network_id: builtins.str = ...,
        service_account_id: builtins.str = ...,
        express: builtins.bool = ...,
        schedule: yandex.cloud.serverless.workflows.v1.workflow_pb2.WorkflowSchedule | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["log_options", b"log_options", "schedule", b"schedule", "specification", b"specification"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "express", b"express", "folder_id", b"folder_id", "labels", b"labels", "log_options", b"log_options", "name", b"name", "network_id", b"network_id", "schedule", b"schedule", "service_account_id", b"service_account_id", "specification", b"specification"]) -> None: ...

global___CreateWorkflowRequest = CreateWorkflowRequest

@typing.final
class CreateWorkflowMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    WORKFLOW_ID_FIELD_NUMBER: builtins.int
    workflow_id: builtins.str
    """ID of the Workflow."""
    def __init__(
        self,
        *,
        workflow_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["workflow_id", b"workflow_id"]) -> None: ...

global___CreateWorkflowMetadata = CreateWorkflowMetadata

@typing.final
class UpdateWorkflowRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    WORKFLOW_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    SPECIFICATION_FIELD_NUMBER: builtins.int
    LOG_OPTIONS_FIELD_NUMBER: builtins.int
    NETWORK_ID_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    EXPRESS_FIELD_NUMBER: builtins.int
    SCHEDULE_FIELD_NUMBER: builtins.int
    workflow_id: builtins.str
    """ID of the Workflow."""
    name: builtins.str
    """Name of the Workflow. The name is unique within the folder."""
    description: builtins.str
    """Description of the Workflow."""
    network_id: builtins.str
    """ID of the VPC network Workflow will be executed in, in order to access private resources."""
    service_account_id: builtins.str
    """ID of the Service Account which will be used for resources access in Workflow execution."""
    express: builtins.bool
    """Express execution mode."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Workflow labels as `key:value` pairs."""

    @property
    def specification(self) -> yandex.cloud.serverless.workflows.v1.workflow_pb2.WorkflowSpecification:
        """Specification of the Workflow."""

    @property
    def log_options(self) -> yandex.cloud.serverless.workflows.v1.workflow_pb2.LogOptions:
        """Options for logging from the Workflow."""

    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which fields of the Workflow should be updated."""

    @property
    def schedule(self) -> yandex.cloud.serverless.workflows.v1.workflow_pb2.WorkflowSchedule:
        """Workflow schedule settings."""

    def __init__(
        self,
        *,
        workflow_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        specification: yandex.cloud.serverless.workflows.v1.workflow_pb2.WorkflowSpecification | None = ...,
        log_options: yandex.cloud.serverless.workflows.v1.workflow_pb2.LogOptions | None = ...,
        network_id: builtins.str = ...,
        service_account_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        express: builtins.bool = ...,
        schedule: yandex.cloud.serverless.workflows.v1.workflow_pb2.WorkflowSchedule | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["log_options", b"log_options", "schedule", b"schedule", "specification", b"specification", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "express", b"express", "labels", b"labels", "log_options", b"log_options", "name", b"name", "network_id", b"network_id", "schedule", b"schedule", "service_account_id", b"service_account_id", "specification", b"specification", "update_mask", b"update_mask", "workflow_id", b"workflow_id"]) -> None: ...

global___UpdateWorkflowRequest = UpdateWorkflowRequest

@typing.final
class UpdateWorkflowMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    WORKFLOW_ID_FIELD_NUMBER: builtins.int
    workflow_id: builtins.str
    """ID of the Workflow."""
    def __init__(
        self,
        *,
        workflow_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["workflow_id", b"workflow_id"]) -> None: ...

global___UpdateWorkflowMetadata = UpdateWorkflowMetadata

@typing.final
class GetWorkflowRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    WORKFLOW_ID_FIELD_NUMBER: builtins.int
    workflow_id: builtins.str
    """ID of the Workflow."""
    def __init__(
        self,
        *,
        workflow_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["workflow_id", b"workflow_id"]) -> None: ...

global___GetWorkflowRequest = GetWorkflowRequest

@typing.final
class GetWorkflowResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    WORKFLOW_FIELD_NUMBER: builtins.int
    @property
    def workflow(self) -> yandex.cloud.serverless.workflows.v1.workflow_pb2.Workflow:
        """Workflow properties."""

    def __init__(
        self,
        *,
        workflow: yandex.cloud.serverless.workflows.v1.workflow_pb2.Workflow | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["workflow", b"workflow"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["workflow", b"workflow"]) -> None: ...

global___GetWorkflowResponse = GetWorkflowResponse

@typing.final
class DeleteWorkflowRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    WORKFLOW_ID_FIELD_NUMBER: builtins.int
    workflow_id: builtins.str
    """ID of the Workflow."""
    def __init__(
        self,
        *,
        workflow_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["workflow_id", b"workflow_id"]) -> None: ...

global___DeleteWorkflowRequest = DeleteWorkflowRequest

@typing.final
class DeleteWorkflowMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    WORKFLOW_ID_FIELD_NUMBER: builtins.int
    workflow_id: builtins.str
    """ID of the Workflow."""
    def __init__(
        self,
        *,
        workflow_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["workflow_id", b"workflow_id"]) -> None: ...

global___DeleteWorkflowMetadata = DeleteWorkflowMetadata

@typing.final
class ListWorkflowsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to list Workflows in."""
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than `pageSize`, the service returns a [ListWorkflowsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.

    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set `pageToken` to the
    [ListWorkflowsResponse.next_page_token] returned by a previous list request.
    """
    filter: builtins.str
    """A filter expression that filters functions listed in the response.

    The expression must specify:
    1. The field name. Currently filtering can only be applied to following fields: name, created_at.
    2. An `=` operator.
    3. The value in double quotes (`"`). Must be 3-63 characters long and match the regular expression `[a-z]([-a-z0-9]{0,61}[a-z0-9])?`.
    Example of a filter: `name=my-workflow`.
    """
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "folder_id", b"folder_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListWorkflowsRequest = ListWorkflowsRequest

@typing.final
class ListWorkflowsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    WORKFLOWS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    the specified [ListWorkflowsRequest.page_size], use `next_page_token` as the value
    for the [ListWorkflowsRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `next_page_token` to continue paging through the results.
    """
    @property
    def workflows(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.serverless.workflows.v1.workflow_pb2.WorkflowPreview]:
        """List of Workflows."""

    def __init__(
        self,
        *,
        workflows: collections.abc.Iterable[yandex.cloud.serverless.workflows.v1.workflow_pb2.WorkflowPreview] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "workflows", b"workflows"]) -> None: ...

global___ListWorkflowsResponse = ListWorkflowsResponse

@typing.final
class ListOperationsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    WORKFLOW_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    workflow_id: builtins.str
    """ID of the Workflow to list operations for."""
    page_size: builtins.int
    """The maximum number of results per page that should be returned. If the number of available
    results is larger than `pageSize`, the service returns a [ListOperationsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.

    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set `pageToken` to the
    [ListOperationsResponse.next_page_token] returned by a previous list request.
    """
    filter: builtins.str
    """A filter expression that filters resources listed in the response.

    The expression must specify:
    1. The field name. Currently filtering can be applied to the [operation.Operation.done], [operation.Operation.created_by] field.
    2. An `=` operator.
    3. The value in double quotes (`"`). Must be 3-63 characters long and match the regular expression `[a-z][-a-z0-9]{1,61}[a-z0-9]`.
    Examples of a filter: `done=false`, `created_by='John.Doe'`.
    """
    def __init__(
        self,
        *,
        workflow_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "workflow_id", b"workflow_id"]) -> None: ...

global___ListOperationsRequest = ListOperationsRequest

@typing.final
class ListOperationsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    the specified [ListOperationsRequest.page_size], use `next_page_token` as the value
    for the [ListOperationsRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `next_page_token` to continue paging through the results.
    """
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.operation.operation_pb2.Operation]:
        """List of operations for the specified Workflow."""

    def __init__(
        self,
        *,
        operations: collections.abc.Iterable[yandex.cloud.operation.operation_pb2.Operation] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "operations", b"operations"]) -> None: ...

global___ListOperationsResponse = ListOperationsResponse
