"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing
import yandex.cloud.smartwebsecurity.v1.security_profile_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class AdvancedRateLimiterProfile(google.protobuf.message.Message):
    """A AdvancedRateLimiterProfile (ARL) resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    ADVANCED_RATE_LIMITER_RULES_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    CLOUD_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the ARL profile."""
    folder_id: builtins.str
    """ID of the folder that the ARL profile belongs to."""
    name: builtins.str
    """Name of the ARL profile. The name is unique within the folder. 1-50 characters long."""
    description: builtins.str
    """Optional description of the ARL profile."""
    cloud_id: builtins.str
    """ID of the cloud that the ARL profile belongs to."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Labels as `` key:value `` pairs. Maximum of 64 per resource."""

    @property
    def advanced_rate_limiter_rules(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AdvancedRateLimiterRule]:
        """List of rules."""

    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        folder_id: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        advanced_rate_limiter_rules: collections.abc.Iterable[global___AdvancedRateLimiterRule] | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        cloud_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["advanced_rate_limiter_rules", b"advanced_rate_limiter_rules", "cloud_id", b"cloud_id", "created_at", b"created_at", "description", b"description", "folder_id", b"folder_id", "id", b"id", "labels", b"labels", "name", b"name"]) -> None: ...

global___AdvancedRateLimiterProfile = AdvancedRateLimiterProfile

@typing.final
class AdvancedRateLimiterRule(google.protobuf.message.Message):
    """A AdvancedRateLimiterRule object, see [Rules](/docs/smartwebsecurity/concepts/arl#traffic-conditions)."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Action:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ActionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[AdvancedRateLimiterRule._Action.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        ACTION_UNSPECIFIED: AdvancedRateLimiterRule._Action.ValueType  # 0
        DENY: AdvancedRateLimiterRule._Action.ValueType  # 1
        """Deny request."""

    class Action(_Action, metaclass=_ActionEnumTypeWrapper):
        """Type of action to perform if this rule matched."""

    ACTION_UNSPECIFIED: AdvancedRateLimiterRule.Action.ValueType  # 0
    DENY: AdvancedRateLimiterRule.Action.ValueType  # 1
    """Deny request."""

    @typing.final
    class StaticQuota(google.protobuf.message.Message):
        """StaticQuota object."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ACTION_FIELD_NUMBER: builtins.int
        CONDITION_FIELD_NUMBER: builtins.int
        LIMIT_FIELD_NUMBER: builtins.int
        PERIOD_FIELD_NUMBER: builtins.int
        action: global___AdvancedRateLimiterRule.Action.ValueType
        """Action in case of exceeding this quota."""
        limit: builtins.int
        """Desired maximum number of requests per period.
        Enter an integer within the range of 1 and 9999999999999.
        """
        period: builtins.int
        """Period of time in seconds."""
        @property
        def condition(self) -> yandex.cloud.smartwebsecurity.v1.security_profile_pb2.Condition:
            """The condition for matching the quota."""

        def __init__(
            self,
            *,
            action: global___AdvancedRateLimiterRule.Action.ValueType = ...,
            condition: yandex.cloud.smartwebsecurity.v1.security_profile_pb2.Condition | None = ...,
            limit: builtins.int = ...,
            period: builtins.int = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["condition", b"condition"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["action", b"action", "condition", b"condition", "limit", b"limit", "period", b"period"]) -> None: ...

    @typing.final
    class DynamicQuota(google.protobuf.message.Message):
        """DynamicQuota object."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        @typing.final
        class Characteristic(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            @typing.final
            class SimpleCharacteristic(google.protobuf.message.Message):
                DESCRIPTOR: google.protobuf.descriptor.Descriptor

                class _Type:
                    ValueType = typing.NewType("ValueType", builtins.int)
                    V: typing_extensions.TypeAlias = ValueType

                class _TypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[AdvancedRateLimiterRule.DynamicQuota.Characteristic.SimpleCharacteristic._Type.ValueType], builtins.type):
                    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
                    TYPE_UNSPECIFIED: AdvancedRateLimiterRule.DynamicQuota.Characteristic.SimpleCharacteristic._Type.ValueType  # 0
                    REQUEST_PATH: AdvancedRateLimiterRule.DynamicQuota.Characteristic.SimpleCharacteristic._Type.ValueType  # 1
                    """HTTP Request path."""
                    HTTP_METHOD: AdvancedRateLimiterRule.DynamicQuota.Characteristic.SimpleCharacteristic._Type.ValueType  # 2
                    """HTTP Method."""
                    IP: AdvancedRateLimiterRule.DynamicQuota.Characteristic.SimpleCharacteristic._Type.ValueType  # 3
                    """IP address."""
                    GEO: AdvancedRateLimiterRule.DynamicQuota.Characteristic.SimpleCharacteristic._Type.ValueType  # 4
                    """Region."""
                    HOST: AdvancedRateLimiterRule.DynamicQuota.Characteristic.SimpleCharacteristic._Type.ValueType  # 5
                    """Host."""

                class Type(_Type, metaclass=_TypeEnumTypeWrapper):
                    """Type of simple characteristic."""

                TYPE_UNSPECIFIED: AdvancedRateLimiterRule.DynamicQuota.Characteristic.SimpleCharacteristic.Type.ValueType  # 0
                REQUEST_PATH: AdvancedRateLimiterRule.DynamicQuota.Characteristic.SimpleCharacteristic.Type.ValueType  # 1
                """HTTP Request path."""
                HTTP_METHOD: AdvancedRateLimiterRule.DynamicQuota.Characteristic.SimpleCharacteristic.Type.ValueType  # 2
                """HTTP Method."""
                IP: AdvancedRateLimiterRule.DynamicQuota.Characteristic.SimpleCharacteristic.Type.ValueType  # 3
                """IP address."""
                GEO: AdvancedRateLimiterRule.DynamicQuota.Characteristic.SimpleCharacteristic.Type.ValueType  # 4
                """Region."""
                HOST: AdvancedRateLimiterRule.DynamicQuota.Characteristic.SimpleCharacteristic.Type.ValueType  # 5
                """Host."""

                TYPE_FIELD_NUMBER: builtins.int
                type: global___AdvancedRateLimiterRule.DynamicQuota.Characteristic.SimpleCharacteristic.Type.ValueType
                """Type of simple characteristic."""
                def __init__(
                    self,
                    *,
                    type: global___AdvancedRateLimiterRule.DynamicQuota.Characteristic.SimpleCharacteristic.Type.ValueType = ...,
                ) -> None: ...
                def ClearField(self, field_name: typing.Literal["type", b"type"]) -> None: ...

            @typing.final
            class KeyCharacteristic(google.protobuf.message.Message):
                DESCRIPTOR: google.protobuf.descriptor.Descriptor

                class _Type:
                    ValueType = typing.NewType("ValueType", builtins.int)
                    V: typing_extensions.TypeAlias = ValueType

                class _TypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[AdvancedRateLimiterRule.DynamicQuota.Characteristic.KeyCharacteristic._Type.ValueType], builtins.type):
                    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
                    TYPE_UNSPECIFIED: AdvancedRateLimiterRule.DynamicQuota.Characteristic.KeyCharacteristic._Type.ValueType  # 0
                    COOKIE_KEY: AdvancedRateLimiterRule.DynamicQuota.Characteristic.KeyCharacteristic._Type.ValueType  # 1
                    """HTTP cookie key."""
                    HEADER_KEY: AdvancedRateLimiterRule.DynamicQuota.Characteristic.KeyCharacteristic._Type.ValueType  # 2
                    """HTTP header key."""
                    QUERY_KEY: AdvancedRateLimiterRule.DynamicQuota.Characteristic.KeyCharacteristic._Type.ValueType  # 3
                    """Query params key."""

                class Type(_Type, metaclass=_TypeEnumTypeWrapper):
                    """Type of key characteristic."""

                TYPE_UNSPECIFIED: AdvancedRateLimiterRule.DynamicQuota.Characteristic.KeyCharacteristic.Type.ValueType  # 0
                COOKIE_KEY: AdvancedRateLimiterRule.DynamicQuota.Characteristic.KeyCharacteristic.Type.ValueType  # 1
                """HTTP cookie key."""
                HEADER_KEY: AdvancedRateLimiterRule.DynamicQuota.Characteristic.KeyCharacteristic.Type.ValueType  # 2
                """HTTP header key."""
                QUERY_KEY: AdvancedRateLimiterRule.DynamicQuota.Characteristic.KeyCharacteristic.Type.ValueType  # 3
                """Query params key."""

                TYPE_FIELD_NUMBER: builtins.int
                VALUE_FIELD_NUMBER: builtins.int
                type: global___AdvancedRateLimiterRule.DynamicQuota.Characteristic.KeyCharacteristic.Type.ValueType
                """Type of key characteristic."""
                value: builtins.str
                """String value of the key."""
                def __init__(
                    self,
                    *,
                    type: global___AdvancedRateLimiterRule.DynamicQuota.Characteristic.KeyCharacteristic.Type.ValueType = ...,
                    value: builtins.str = ...,
                ) -> None: ...
                def ClearField(self, field_name: typing.Literal["type", b"type", "value", b"value"]) -> None: ...

            SIMPLE_CHARACTERISTIC_FIELD_NUMBER: builtins.int
            KEY_CHARACTERISTIC_FIELD_NUMBER: builtins.int
            CASE_INSENSITIVE_FIELD_NUMBER: builtins.int
            case_insensitive: builtins.bool
            """Determines case-sensitive or case-insensitive keys matching."""
            @property
            def simple_characteristic(self) -> global___AdvancedRateLimiterRule.DynamicQuota.Characteristic.SimpleCharacteristic:
                """Characteristic automatically based on the Request path, HTTP method, IP address, Region, and Host attributes.
                See [Rules](/docs/smartwebsecurity/concepts/arl#requests-counting) for more details.
                """

            @property
            def key_characteristic(self) -> global___AdvancedRateLimiterRule.DynamicQuota.Characteristic.KeyCharacteristic:
                """Characteristic based on key match in the Query params, HTTP header, and HTTP cookie attributes.
                See [Rules](/docs/smartwebsecurity/concepts/arl#requests-counting) for more details.
                """

            def __init__(
                self,
                *,
                simple_characteristic: global___AdvancedRateLimiterRule.DynamicQuota.Characteristic.SimpleCharacteristic | None = ...,
                key_characteristic: global___AdvancedRateLimiterRule.DynamicQuota.Characteristic.KeyCharacteristic | None = ...,
                case_insensitive: builtins.bool = ...,
            ) -> None: ...
            def HasField(self, field_name: typing.Literal["characteristic_specifier", b"characteristic_specifier", "key_characteristic", b"key_characteristic", "simple_characteristic", b"simple_characteristic"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing.Literal["case_insensitive", b"case_insensitive", "characteristic_specifier", b"characteristic_specifier", "key_characteristic", b"key_characteristic", "simple_characteristic", b"simple_characteristic"]) -> None: ...
            def WhichOneof(self, oneof_group: typing.Literal["characteristic_specifier", b"characteristic_specifier"]) -> typing.Literal["simple_characteristic", "key_characteristic"] | None: ...

        ACTION_FIELD_NUMBER: builtins.int
        CONDITION_FIELD_NUMBER: builtins.int
        LIMIT_FIELD_NUMBER: builtins.int
        PERIOD_FIELD_NUMBER: builtins.int
        CHARACTERISTICS_FIELD_NUMBER: builtins.int
        action: global___AdvancedRateLimiterRule.Action.ValueType
        """Action in case of exceeding this quota."""
        limit: builtins.int
        """Desired maximum number of requests per period.
        Enter an integer within the range of 1 and 9999999999999.
        """
        period: builtins.int
        """Period of time in seconds."""
        @property
        def condition(self) -> yandex.cloud.smartwebsecurity.v1.security_profile_pb2.Condition:
            """The condition for matching the quota."""

        @property
        def characteristics(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AdvancedRateLimiterRule.DynamicQuota.Characteristic]:
            """List of characteristics."""

        def __init__(
            self,
            *,
            action: global___AdvancedRateLimiterRule.Action.ValueType = ...,
            condition: yandex.cloud.smartwebsecurity.v1.security_profile_pb2.Condition | None = ...,
            limit: builtins.int = ...,
            period: builtins.int = ...,
            characteristics: collections.abc.Iterable[global___AdvancedRateLimiterRule.DynamicQuota.Characteristic] | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["condition", b"condition"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["action", b"action", "characteristics", b"characteristics", "condition", b"condition", "limit", b"limit", "period", b"period"]) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    PRIORITY_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    DRY_RUN_FIELD_NUMBER: builtins.int
    STATIC_QUOTA_FIELD_NUMBER: builtins.int
    DYNAMIC_QUOTA_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the rule. The name is unique within the ARL profile. 1-50 characters long."""
    priority: builtins.int
    """Determines the priority in case there are several matched rules.
    Enter an integer within the range of 1 and 999999.
    The rule priority must be unique within the entire ARL profile.
    A lower numeric value means a higher priority.
    """
    description: builtins.str
    """Optional description of the rule. 0-512 characters long."""
    dry_run: builtins.bool
    """This allows you to evaluate backend capabilities and find the optimum limit values.
    Requests will not be blocked in this mode.
    """
    @property
    def static_quota(self) -> global___AdvancedRateLimiterRule.StaticQuota:
        """Static quota. Counting each request individually."""

    @property
    def dynamic_quota(self) -> global___AdvancedRateLimiterRule.DynamicQuota:
        """Dynamic quota. Grouping requests by a certain attribute and limiting the number of groups."""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        priority: builtins.int = ...,
        description: builtins.str = ...,
        dry_run: builtins.bool = ...,
        static_quota: global___AdvancedRateLimiterRule.StaticQuota | None = ...,
        dynamic_quota: global___AdvancedRateLimiterRule.DynamicQuota | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["dynamic_quota", b"dynamic_quota", "rule_specifier", b"rule_specifier", "static_quota", b"static_quota"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "dry_run", b"dry_run", "dynamic_quota", b"dynamic_quota", "name", b"name", "priority", b"priority", "rule_specifier", b"rule_specifier", "static_quota", b"static_quota"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["rule_specifier", b"rule_specifier"]) -> typing.Literal["static_quota", "dynamic_quota"] | None: ...

global___AdvancedRateLimiterRule = AdvancedRateLimiterRule
