"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class SecurityProfile(google.protobuf.message.Message):
    """A SecurityProfile resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _DefaultAction:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _DefaultActionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[SecurityProfile._DefaultAction.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        DEFAULT_ACTION_UNSPECIFIED: SecurityProfile._DefaultAction.ValueType  # 0
        ALLOW: SecurityProfile._DefaultAction.ValueType  # 1
        """Pass request to service."""
        DENY: SecurityProfile._DefaultAction.ValueType  # 2
        """Deny request."""

    class DefaultAction(_DefaultAction, metaclass=_DefaultActionEnumTypeWrapper):
        """Action to perform if none of rules matched."""

    DEFAULT_ACTION_UNSPECIFIED: SecurityProfile.DefaultAction.ValueType  # 0
    ALLOW: SecurityProfile.DefaultAction.ValueType  # 1
    """Pass request to service."""
    DENY: SecurityProfile.DefaultAction.ValueType  # 2
    """Deny request."""

    @typing.final
    class AnalyzeRequestBody(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _Action:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _ActionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[SecurityProfile.AnalyzeRequestBody._Action.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            ACTION_UNSPECIFIED: SecurityProfile.AnalyzeRequestBody._Action.ValueType  # 0
            IGNORE: SecurityProfile.AnalyzeRequestBody._Action.ValueType  # 1
            """Ignore body."""
            DENY: SecurityProfile.AnalyzeRequestBody._Action.ValueType  # 2
            """Deny request."""

        class Action(_Action, metaclass=_ActionEnumTypeWrapper):
            """Action to perform if maximum size of body exceeded."""

        ACTION_UNSPECIFIED: SecurityProfile.AnalyzeRequestBody.Action.ValueType  # 0
        IGNORE: SecurityProfile.AnalyzeRequestBody.Action.ValueType  # 1
        """Ignore body."""
        DENY: SecurityProfile.AnalyzeRequestBody.Action.ValueType  # 2
        """Deny request."""

        SIZE_LIMIT_FIELD_NUMBER: builtins.int
        SIZE_LIMIT_ACTION_FIELD_NUMBER: builtins.int
        size_limit: builtins.int
        """Maximum size of body to pass to analyzer. In kilobytes."""
        size_limit_action: global___SecurityProfile.AnalyzeRequestBody.Action.ValueType
        """Action to perform if maximum size of body exceeded."""
        def __init__(
            self,
            *,
            size_limit: builtins.int = ...,
            size_limit_action: global___SecurityProfile.AnalyzeRequestBody.Action.ValueType = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["size_limit", b"size_limit", "size_limit_action", b"size_limit_action"]) -> None: ...

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    DEFAULT_ACTION_FIELD_NUMBER: builtins.int
    SECURITY_RULES_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    CLOUD_ID_FIELD_NUMBER: builtins.int
    CAPTCHA_ID_FIELD_NUMBER: builtins.int
    ADVANCED_RATE_LIMITER_PROFILE_ID_FIELD_NUMBER: builtins.int
    ANALYZE_REQUEST_BODY_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the security profile."""
    folder_id: builtins.str
    """ID of the folder that the security profile belongs to."""
    name: builtins.str
    """Name of the security profile. The name is unique within the folder. 1-50 characters long."""
    description: builtins.str
    """Optional description of the security profile."""
    default_action: global___SecurityProfile.DefaultAction.ValueType
    """Action to perform if none of rules matched."""
    cloud_id: builtins.str
    """ID of the cloud that the security profile belongs to."""
    captcha_id: builtins.str
    """Captcha ID to use with this security profile. Set empty to use default."""
    advanced_rate_limiter_profile_id: builtins.str
    """Advanced rate limiter profile ID to use with this security profile. Set empty to use default."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Labels as `` key:value `` pairs. Maximum of 64 per resource."""

    @property
    def security_rules(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SecurityRule]:
        """List of security rules."""

    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format."""

    @property
    def analyze_request_body(self) -> global___SecurityProfile.AnalyzeRequestBody:
        """Parameters for request body analyzer."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        folder_id: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        default_action: global___SecurityProfile.DefaultAction.ValueType = ...,
        security_rules: collections.abc.Iterable[global___SecurityRule] | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        cloud_id: builtins.str = ...,
        captcha_id: builtins.str = ...,
        advanced_rate_limiter_profile_id: builtins.str = ...,
        analyze_request_body: global___SecurityProfile.AnalyzeRequestBody | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["analyze_request_body", b"analyze_request_body", "created_at", b"created_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["advanced_rate_limiter_profile_id", b"advanced_rate_limiter_profile_id", "analyze_request_body", b"analyze_request_body", "captcha_id", b"captcha_id", "cloud_id", b"cloud_id", "created_at", b"created_at", "default_action", b"default_action", "description", b"description", "folder_id", b"folder_id", "id", b"id", "labels", b"labels", "name", b"name", "security_rules", b"security_rules"]) -> None: ...

global___SecurityProfile = SecurityProfile

@typing.final
class SecurityRule(google.protobuf.message.Message):
    """A SecurityRule object, see [Rules](/docs/smartwebsecurity/concepts/rules)."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class RuleCondition(google.protobuf.message.Message):
        """RuleCondition object."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _Action:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _ActionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[SecurityRule.RuleCondition._Action.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            ACTION_UNSPECIFIED: SecurityRule.RuleCondition._Action.ValueType  # 0
            ALLOW: SecurityRule.RuleCondition._Action.ValueType  # 1
            """Pass request to service."""
            DENY: SecurityRule.RuleCondition._Action.ValueType  # 2
            """Deny request."""

        class Action(_Action, metaclass=_ActionEnumTypeWrapper):
            """Type of action to perform if this rule matched."""

        ACTION_UNSPECIFIED: SecurityRule.RuleCondition.Action.ValueType  # 0
        ALLOW: SecurityRule.RuleCondition.Action.ValueType  # 1
        """Pass request to service."""
        DENY: SecurityRule.RuleCondition.Action.ValueType  # 2
        """Deny request."""

        ACTION_FIELD_NUMBER: builtins.int
        CONDITION_FIELD_NUMBER: builtins.int
        action: global___SecurityRule.RuleCondition.Action.ValueType
        """Action to perform if this rule matched."""
        @property
        def condition(self) -> global___Condition:
            """The condition for matching the rule."""

        def __init__(
            self,
            *,
            action: global___SecurityRule.RuleCondition.Action.ValueType = ...,
            condition: global___Condition | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["condition", b"condition"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["action", b"action", "condition", b"condition"]) -> None: ...

    @typing.final
    class SmartProtection(google.protobuf.message.Message):
        """SmartProtection object."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _Mode:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _ModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[SecurityRule.SmartProtection._Mode.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            MODE_UNSPECIFIED: SecurityRule.SmartProtection._Mode.ValueType  # 0
            FULL: SecurityRule.SmartProtection._Mode.ValueType  # 1
            """Full protection means that the traffic will be checked based on ML models and behavioral analysis,
            with suspicious requests being sent to SmartCaptcha.
            """
            API: SecurityRule.SmartProtection._Mode.ValueType  # 2
            """API protection means checking the traffic based on ML models and behavioral analysis without sending suspicious
            requests to SmartCaptcha. The suspicious requests will be blocked.
            """

        class Mode(_Mode, metaclass=_ModeEnumTypeWrapper):
            """Mode of protection."""

        MODE_UNSPECIFIED: SecurityRule.SmartProtection.Mode.ValueType  # 0
        FULL: SecurityRule.SmartProtection.Mode.ValueType  # 1
        """Full protection means that the traffic will be checked based on ML models and behavioral analysis,
        with suspicious requests being sent to SmartCaptcha.
        """
        API: SecurityRule.SmartProtection.Mode.ValueType  # 2
        """API protection means checking the traffic based on ML models and behavioral analysis without sending suspicious
        requests to SmartCaptcha. The suspicious requests will be blocked.
        """

        MODE_FIELD_NUMBER: builtins.int
        CONDITION_FIELD_NUMBER: builtins.int
        mode: global___SecurityRule.SmartProtection.Mode.ValueType
        """Mode of protection."""
        @property
        def condition(self) -> global___Condition:
            """The condition for matching the rule."""

        def __init__(
            self,
            *,
            mode: global___SecurityRule.SmartProtection.Mode.ValueType = ...,
            condition: global___Condition | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["condition", b"condition"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["condition", b"condition", "mode", b"mode"]) -> None: ...

    @typing.final
    class Waf(google.protobuf.message.Message):
        """Waf object."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _Mode:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _ModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[SecurityRule.Waf._Mode.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            MODE_UNSPECIFIED: SecurityRule.Waf._Mode.ValueType  # 0
            FULL: SecurityRule.Waf._Mode.ValueType  # 1
            """Full protection means that the traffic will be checked based on ML models and behavioral analysis,
            with suspicious requests being sent to SmartCaptcha.
            """
            API: SecurityRule.Waf._Mode.ValueType  # 2
            """API protection means checking the traffic based on ML models and behavioral analysis without sending suspicious
            requests to SmartCaptcha. The suspicious requests will be blocked.
            """

        class Mode(_Mode, metaclass=_ModeEnumTypeWrapper):
            """Mode of protection."""

        MODE_UNSPECIFIED: SecurityRule.Waf.Mode.ValueType  # 0
        FULL: SecurityRule.Waf.Mode.ValueType  # 1
        """Full protection means that the traffic will be checked based on ML models and behavioral analysis,
        with suspicious requests being sent to SmartCaptcha.
        """
        API: SecurityRule.Waf.Mode.ValueType  # 2
        """API protection means checking the traffic based on ML models and behavioral analysis without sending suspicious
        requests to SmartCaptcha. The suspicious requests will be blocked.
        """

        MODE_FIELD_NUMBER: builtins.int
        CONDITION_FIELD_NUMBER: builtins.int
        WAF_PROFILE_ID_FIELD_NUMBER: builtins.int
        mode: global___SecurityRule.Waf.Mode.ValueType
        """Mode of protection."""
        waf_profile_id: builtins.str
        """ID of WAF profile to use in this rule."""
        @property
        def condition(self) -> global___Condition:
            """The condition for matching the rule."""

        def __init__(
            self,
            *,
            mode: global___SecurityRule.Waf.Mode.ValueType = ...,
            condition: global___Condition | None = ...,
            waf_profile_id: builtins.str = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["condition", b"condition"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["condition", b"condition", "mode", b"mode", "waf_profile_id", b"waf_profile_id"]) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    PRIORITY_FIELD_NUMBER: builtins.int
    DRY_RUN_FIELD_NUMBER: builtins.int
    RULE_CONDITION_FIELD_NUMBER: builtins.int
    SMART_PROTECTION_FIELD_NUMBER: builtins.int
    WAF_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the rule. The name is unique within the security profile. 1-50 characters long."""
    priority: builtins.int
    """Determines the priority for checking the incoming traffic.
    Enter an integer within the range of 1 and 999999.
    The rule priority must be unique within the entire security profile.
    A lower numeric value means a higher priority.
    The default_action has the lowest priority.
    """
    dry_run: builtins.bool
    """This mode allows you to test your security profile or a single rule.
    For example, you can have the number of alarms for a specific rule displayed.
    Note: if this option is true, no real action affecting your traffic regarding this rule will be taken.
    """
    description: builtins.str
    """Optional description of the rule. 0-512 characters long."""
    @property
    def rule_condition(self) -> global___SecurityRule.RuleCondition:
        """Rule actions, see [Rule actions](/docs/smartwebsecurity/concepts/rules#rule-action)."""

    @property
    def smart_protection(self) -> global___SecurityRule.SmartProtection:
        """Smart Protection rule, see [Smart Protection rules](/docs/smartwebsecurity/concepts/rules#smart-protection-rules)."""

    @property
    def waf(self) -> global___SecurityRule.Waf:
        """Web Application Firewall (WAF) rule, see [WAF rules](/docs/smartwebsecurity/concepts/rules#waf-rules)."""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        priority: builtins.int = ...,
        dry_run: builtins.bool = ...,
        rule_condition: global___SecurityRule.RuleCondition | None = ...,
        smart_protection: global___SecurityRule.SmartProtection | None = ...,
        waf: global___SecurityRule.Waf | None = ...,
        description: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["rule_condition", b"rule_condition", "rule_specifier", b"rule_specifier", "smart_protection", b"smart_protection", "waf", b"waf"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "dry_run", b"dry_run", "name", b"name", "priority", b"priority", "rule_condition", b"rule_condition", "rule_specifier", b"rule_specifier", "smart_protection", b"smart_protection", "waf", b"waf"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["rule_specifier", b"rule_specifier"]) -> typing.Literal["rule_condition", "smart_protection", "waf"] | None: ...

global___SecurityRule = SecurityRule

@typing.final
class Condition(google.protobuf.message.Message):
    """Condition object. AND semantics implied.
    See [documentation](/docs/smartwebsecurity/concepts/conditions) for matchers description.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class StringMatcher(google.protobuf.message.Message):
        """StringMatcher object."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        EXACT_MATCH_FIELD_NUMBER: builtins.int
        EXACT_NOT_MATCH_FIELD_NUMBER: builtins.int
        PREFIX_MATCH_FIELD_NUMBER: builtins.int
        PREFIX_NOT_MATCH_FIELD_NUMBER: builtins.int
        PIRE_REGEX_MATCH_FIELD_NUMBER: builtins.int
        PIRE_REGEX_NOT_MATCH_FIELD_NUMBER: builtins.int
        exact_match: builtins.str
        exact_not_match: builtins.str
        prefix_match: builtins.str
        prefix_not_match: builtins.str
        pire_regex_match: builtins.str
        pire_regex_not_match: builtins.str
        def __init__(
            self,
            *,
            exact_match: builtins.str = ...,
            exact_not_match: builtins.str = ...,
            prefix_match: builtins.str = ...,
            prefix_not_match: builtins.str = ...,
            pire_regex_match: builtins.str = ...,
            pire_regex_not_match: builtins.str = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["exact_match", b"exact_match", "exact_not_match", b"exact_not_match", "match", b"match", "pire_regex_match", b"pire_regex_match", "pire_regex_not_match", b"pire_regex_not_match", "prefix_match", b"prefix_match", "prefix_not_match", b"prefix_not_match"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["exact_match", b"exact_match", "exact_not_match", b"exact_not_match", "match", b"match", "pire_regex_match", b"pire_regex_match", "pire_regex_not_match", b"pire_regex_not_match", "prefix_match", b"prefix_match", "prefix_not_match", b"prefix_not_match"]) -> None: ...
        def WhichOneof(self, oneof_group: typing.Literal["match", b"match"]) -> typing.Literal["exact_match", "exact_not_match", "prefix_match", "prefix_not_match", "pire_regex_match", "pire_regex_not_match"] | None: ...

    @typing.final
    class HttpMethodMatcher(google.protobuf.message.Message):
        """HttpMethodMatcher object."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        HTTP_METHODS_FIELD_NUMBER: builtins.int
        @property
        def http_methods(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Condition.StringMatcher]:
            """List of HTTP methods. OR semantics implied."""

        def __init__(
            self,
            *,
            http_methods: collections.abc.Iterable[global___Condition.StringMatcher] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["http_methods", b"http_methods"]) -> None: ...

    @typing.final
    class AuthorityMatcher(google.protobuf.message.Message):
        """AuthorityMatcher object."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        AUTHORITIES_FIELD_NUMBER: builtins.int
        @property
        def authorities(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Condition.StringMatcher]:
            """List of authorities. OR semantics implied."""

        def __init__(
            self,
            *,
            authorities: collections.abc.Iterable[global___Condition.StringMatcher] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["authorities", b"authorities"]) -> None: ...

    @typing.final
    class RequestUriMatcher(google.protobuf.message.Message):
        """RequestUriMatcher object. AND semantics implied."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        PATH_FIELD_NUMBER: builtins.int
        QUERIES_FIELD_NUMBER: builtins.int
        @property
        def path(self) -> global___Condition.StringMatcher:
            """Path of the URI [RFC3986](https://datatracker.ietf.org/doc/html/rfc3986#section-3.3)."""

        @property
        def queries(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Condition.QueryMatcher]:
            """List of query matchers. AND semantics implied."""

        def __init__(
            self,
            *,
            path: global___Condition.StringMatcher | None = ...,
            queries: collections.abc.Iterable[global___Condition.QueryMatcher] | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["path", b"path"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["path", b"path", "queries", b"queries"]) -> None: ...

    @typing.final
    class QueryMatcher(google.protobuf.message.Message):
        """QueryMatcher object."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        """Key of the query parameter."""
        @property
        def value(self) -> global___Condition.StringMatcher:
            """Value of the query parameter."""

        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___Condition.StringMatcher | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing.final
    class HeaderMatcher(google.protobuf.message.Message):
        """HeaderMatcher object."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NAME_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        name: builtins.str
        """Name of header (case insensitive)."""
        @property
        def value(self) -> global___Condition.StringMatcher:
            """Value of the header."""

        def __init__(
            self,
            *,
            name: builtins.str = ...,
            value: global___Condition.StringMatcher | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["name", b"name", "value", b"value"]) -> None: ...

    @typing.final
    class IpMatcher(google.protobuf.message.Message):
        """IpMatcher object. AND semantics implied."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        IP_RANGES_MATCH_FIELD_NUMBER: builtins.int
        IP_RANGES_NOT_MATCH_FIELD_NUMBER: builtins.int
        GEO_IP_MATCH_FIELD_NUMBER: builtins.int
        GEO_IP_NOT_MATCH_FIELD_NUMBER: builtins.int
        @property
        def ip_ranges_match(self) -> global___Condition.IpRangesMatcher: ...
        @property
        def ip_ranges_not_match(self) -> global___Condition.IpRangesMatcher: ...
        @property
        def geo_ip_match(self) -> global___Condition.GeoIpMatcher: ...
        @property
        def geo_ip_not_match(self) -> global___Condition.GeoIpMatcher: ...
        def __init__(
            self,
            *,
            ip_ranges_match: global___Condition.IpRangesMatcher | None = ...,
            ip_ranges_not_match: global___Condition.IpRangesMatcher | None = ...,
            geo_ip_match: global___Condition.GeoIpMatcher | None = ...,
            geo_ip_not_match: global___Condition.GeoIpMatcher | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["geo_ip_match", b"geo_ip_match", "geo_ip_not_match", b"geo_ip_not_match", "ip_ranges_match", b"ip_ranges_match", "ip_ranges_not_match", b"ip_ranges_not_match"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["geo_ip_match", b"geo_ip_match", "geo_ip_not_match", b"geo_ip_not_match", "ip_ranges_match", b"ip_ranges_match", "ip_ranges_not_match", b"ip_ranges_not_match"]) -> None: ...

    @typing.final
    class IpRangesMatcher(google.protobuf.message.Message):
        """IpRangesMatcher object."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        IP_RANGES_FIELD_NUMBER: builtins.int
        @property
        def ip_ranges(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
            """List of IP ranges. OR semantics implied.
            v4/v6 - allow, exact IP == /32 or /128 range
            """

        def __init__(
            self,
            *,
            ip_ranges: collections.abc.Iterable[builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["ip_ranges", b"ip_ranges"]) -> None: ...

    @typing.final
    class GeoIpMatcher(google.protobuf.message.Message):
        """GeoIpMatcher object."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        LOCATIONS_FIELD_NUMBER: builtins.int
        @property
        def locations(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
            """ISO 3166-1 alpha 2. OR semantics implied."""

        def __init__(
            self,
            *,
            locations: collections.abc.Iterable[builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["locations", b"locations"]) -> None: ...

    AUTHORITY_FIELD_NUMBER: builtins.int
    HTTP_METHOD_FIELD_NUMBER: builtins.int
    REQUEST_URI_FIELD_NUMBER: builtins.int
    HEADERS_FIELD_NUMBER: builtins.int
    SOURCE_IP_FIELD_NUMBER: builtins.int
    @property
    def authority(self) -> global___Condition.AuthorityMatcher:
        """Match authority (Host header)."""

    @property
    def http_method(self) -> global___Condition.HttpMethodMatcher:
        """Match HTTP method."""

    @property
    def request_uri(self) -> global___Condition.RequestUriMatcher:
        """Match Request URI."""

    @property
    def headers(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Condition.HeaderMatcher]:
        """Match HTTP headers."""

    @property
    def source_ip(self) -> global___Condition.IpMatcher:
        """Match IP."""

    def __init__(
        self,
        *,
        authority: global___Condition.AuthorityMatcher | None = ...,
        http_method: global___Condition.HttpMethodMatcher | None = ...,
        request_uri: global___Condition.RequestUriMatcher | None = ...,
        headers: collections.abc.Iterable[global___Condition.HeaderMatcher] | None = ...,
        source_ip: global___Condition.IpMatcher | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["authority", b"authority", "http_method", b"http_method", "request_uri", b"request_uri", "source_ip", b"source_ip"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["authority", b"authority", "headers", b"headers", "http_method", b"http_method", "request_uri", b"request_uri", "source_ip", b"source_ip"]) -> None: ...

global___Condition = Condition
