"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Job(google.protobuf.message.Message):
    """Spark job."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Job._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: Job._Status.ValueType  # 0
        PROVISIONING: Job._Status.ValueType  # 1
        """Job created and is waiting to acquire."""
        PENDING: Job._Status.ValueType  # 2
        """Job acquired and is waiting for execution."""
        RUNNING: Job._Status.ValueType  # 3
        """Job is running."""
        ERROR: Job._Status.ValueType  # 4
        """Job failed."""
        DONE: Job._Status.ValueType  # 5
        """Job finished."""
        CANCELLED: Job._Status.ValueType  # 6
        """Job cancelled."""
        CANCELLING: Job._Status.ValueType  # 7
        """Job is waiting for cancellation."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNSPECIFIED: Job.Status.ValueType  # 0
    PROVISIONING: Job.Status.ValueType  # 1
    """Job created and is waiting to acquire."""
    PENDING: Job.Status.ValueType  # 2
    """Job acquired and is waiting for execution."""
    RUNNING: Job.Status.ValueType  # 3
    """Job is running."""
    ERROR: Job.Status.ValueType  # 4
    """Job failed."""
    DONE: Job.Status.ValueType  # 5
    """Job finished."""
    CANCELLED: Job.Status.ValueType  # 6
    """Job cancelled."""
    CANCELLING: Job.Status.ValueType  # 7
    """Job is waiting for cancellation."""

    ID_FIELD_NUMBER: builtins.int
    CLUSTER_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    STARTED_AT_FIELD_NUMBER: builtins.int
    FINISHED_AT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    CREATED_BY_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    SPARK_JOB_FIELD_NUMBER: builtins.int
    PYSPARK_JOB_FIELD_NUMBER: builtins.int
    SPARK_CONNECT_JOB_FIELD_NUMBER: builtins.int
    UI_URL_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    CONNECT_URL_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Required. Unique ID of the Spark job.
    This ID is assigned by MDB in the process of creating Spark job.
    """
    cluster_id: builtins.str
    """Required. Unique ID of the Spark cluster."""
    name: builtins.str
    """Name of the Spark job."""
    created_by: builtins.str
    """The id of the user who created the job"""
    status: global___Job.Status.ValueType
    """Status."""
    ui_url: builtins.str
    """Spark UI Url."""
    service_account_id: builtins.str
    """Service account used to access Cloud resources."""
    connect_url: builtins.str
    """Spark Connect Url."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time when the Spark job was created."""

    @property
    def started_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time when the Spark job was started."""

    @property
    def finished_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time when the Spark job was finished."""

    @property
    def spark_job(self) -> global___SparkJob: ...
    @property
    def pyspark_job(self) -> global___PysparkJob: ...
    @property
    def spark_connect_job(self) -> global___SparkConnectJob: ...
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        cluster_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        started_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        finished_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        name: builtins.str = ...,
        created_by: builtins.str = ...,
        status: global___Job.Status.ValueType = ...,
        spark_job: global___SparkJob | None = ...,
        pyspark_job: global___PysparkJob | None = ...,
        spark_connect_job: global___SparkConnectJob | None = ...,
        ui_url: builtins.str = ...,
        service_account_id: builtins.str = ...,
        connect_url: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at", "finished_at", b"finished_at", "job_spec", b"job_spec", "pyspark_job", b"pyspark_job", "spark_connect_job", b"spark_connect_job", "spark_job", b"spark_job", "started_at", b"started_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "connect_url", b"connect_url", "created_at", b"created_at", "created_by", b"created_by", "finished_at", b"finished_at", "id", b"id", "job_spec", b"job_spec", "name", b"name", "pyspark_job", b"pyspark_job", "service_account_id", b"service_account_id", "spark_connect_job", b"spark_connect_job", "spark_job", b"spark_job", "started_at", b"started_at", "status", b"status", "ui_url", b"ui_url"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["job_spec", b"job_spec"]) -> typing.Literal["spark_job", "pyspark_job", "spark_connect_job"] | None: ...

global___Job = Job

@typing.final
class SparkJob(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class PropertiesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ARGS_FIELD_NUMBER: builtins.int
    JAR_FILE_URIS_FIELD_NUMBER: builtins.int
    FILE_URIS_FIELD_NUMBER: builtins.int
    ARCHIVE_URIS_FIELD_NUMBER: builtins.int
    PROPERTIES_FIELD_NUMBER: builtins.int
    MAIN_JAR_FILE_URI_FIELD_NUMBER: builtins.int
    MAIN_CLASS_FIELD_NUMBER: builtins.int
    PACKAGES_FIELD_NUMBER: builtins.int
    REPOSITORIES_FIELD_NUMBER: builtins.int
    EXCLUDE_PACKAGES_FIELD_NUMBER: builtins.int
    main_jar_file_uri: builtins.str
    """URI of the jar file containing the main class."""
    main_class: builtins.str
    """The name of the driver's main class."""
    @property
    def args(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Optional arguments to pass to the driver."""

    @property
    def jar_file_uris(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Jar file URIs to add to the CLASSPATHs of the Spark driver and tasks."""

    @property
    def file_uris(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """URIs of files to be copied to the working directory of Spark drivers and distributed tasks."""

    @property
    def archive_uris(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """URIs of archives to be extracted in the working directory of Spark drivers and tasks."""

    @property
    def properties(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """A mapping of property names to values, used to configure Spark."""

    @property
    def packages(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of maven coordinates of jars to include on the driver and executor classpaths."""

    @property
    def repositories(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of additional remote repositories to search for the maven coordinates given with --packages."""

    @property
    def exclude_packages(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of groupId:artifactId, to exclude while resolving the dependencies provided in --packages to avoid dependency conflicts."""

    def __init__(
        self,
        *,
        args: collections.abc.Iterable[builtins.str] | None = ...,
        jar_file_uris: collections.abc.Iterable[builtins.str] | None = ...,
        file_uris: collections.abc.Iterable[builtins.str] | None = ...,
        archive_uris: collections.abc.Iterable[builtins.str] | None = ...,
        properties: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        main_jar_file_uri: builtins.str = ...,
        main_class: builtins.str = ...,
        packages: collections.abc.Iterable[builtins.str] | None = ...,
        repositories: collections.abc.Iterable[builtins.str] | None = ...,
        exclude_packages: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["archive_uris", b"archive_uris", "args", b"args", "exclude_packages", b"exclude_packages", "file_uris", b"file_uris", "jar_file_uris", b"jar_file_uris", "main_class", b"main_class", "main_jar_file_uri", b"main_jar_file_uri", "packages", b"packages", "properties", b"properties", "repositories", b"repositories"]) -> None: ...

global___SparkJob = SparkJob

@typing.final
class SparkConnectJob(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class PropertiesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    JAR_FILE_URIS_FIELD_NUMBER: builtins.int
    FILE_URIS_FIELD_NUMBER: builtins.int
    ARCHIVE_URIS_FIELD_NUMBER: builtins.int
    PROPERTIES_FIELD_NUMBER: builtins.int
    PACKAGES_FIELD_NUMBER: builtins.int
    REPOSITORIES_FIELD_NUMBER: builtins.int
    EXCLUDE_PACKAGES_FIELD_NUMBER: builtins.int
    @property
    def jar_file_uris(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Jar file URIs to add to the CLASSPATHs of the Spark driver and tasks."""

    @property
    def file_uris(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """URIs of files to be copied to the working directory of Spark drivers and distributed tasks."""

    @property
    def archive_uris(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """URIs of archives to be extracted in the working directory of Spark drivers and tasks."""

    @property
    def properties(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """A mapping of property names to values, used to configure Spark."""

    @property
    def packages(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of maven coordinates of jars to include on the driver and executor classpaths."""

    @property
    def repositories(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of additional remote repositories to search for the maven coordinates given with --packages."""

    @property
    def exclude_packages(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of groupId:artifactId, to exclude while resolving the dependencies provided in --packages to avoid dependency conflicts."""

    def __init__(
        self,
        *,
        jar_file_uris: collections.abc.Iterable[builtins.str] | None = ...,
        file_uris: collections.abc.Iterable[builtins.str] | None = ...,
        archive_uris: collections.abc.Iterable[builtins.str] | None = ...,
        properties: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        packages: collections.abc.Iterable[builtins.str] | None = ...,
        repositories: collections.abc.Iterable[builtins.str] | None = ...,
        exclude_packages: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["archive_uris", b"archive_uris", "exclude_packages", b"exclude_packages", "file_uris", b"file_uris", "jar_file_uris", b"jar_file_uris", "packages", b"packages", "properties", b"properties", "repositories", b"repositories"]) -> None: ...

global___SparkConnectJob = SparkConnectJob

@typing.final
class PysparkJob(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class PropertiesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ARGS_FIELD_NUMBER: builtins.int
    JAR_FILE_URIS_FIELD_NUMBER: builtins.int
    FILE_URIS_FIELD_NUMBER: builtins.int
    ARCHIVE_URIS_FIELD_NUMBER: builtins.int
    PROPERTIES_FIELD_NUMBER: builtins.int
    MAIN_PYTHON_FILE_URI_FIELD_NUMBER: builtins.int
    PYTHON_FILE_URIS_FIELD_NUMBER: builtins.int
    PACKAGES_FIELD_NUMBER: builtins.int
    REPOSITORIES_FIELD_NUMBER: builtins.int
    EXCLUDE_PACKAGES_FIELD_NUMBER: builtins.int
    main_python_file_uri: builtins.str
    """URI of the main Python file to use as the driver. Must be a .py file."""
    @property
    def args(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Optional arguments to pass to the driver."""

    @property
    def jar_file_uris(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Jar file URIs to add to the CLASSPATHs of the Spark driver and tasks."""

    @property
    def file_uris(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """URIs of files to be copied to the working directory of Spark drivers and distributed tasks."""

    @property
    def archive_uris(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """URIs of archives to be extracted in the working directory of Spark drivers and tasks."""

    @property
    def properties(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """A mapping of property names to values, used to configure Spark."""

    @property
    def python_file_uris(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """URIs of Python files to pass to the PySpark framework."""

    @property
    def packages(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of maven coordinates of jars to include on the driver and executor classpaths."""

    @property
    def repositories(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of additional remote repositories to search for the maven coordinates given with --packages."""

    @property
    def exclude_packages(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of groupId:artifactId, to exclude while resolving the dependencies provided in --packages to avoid dependency conflicts."""

    def __init__(
        self,
        *,
        args: collections.abc.Iterable[builtins.str] | None = ...,
        jar_file_uris: collections.abc.Iterable[builtins.str] | None = ...,
        file_uris: collections.abc.Iterable[builtins.str] | None = ...,
        archive_uris: collections.abc.Iterable[builtins.str] | None = ...,
        properties: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        main_python_file_uri: builtins.str = ...,
        python_file_uris: collections.abc.Iterable[builtins.str] | None = ...,
        packages: collections.abc.Iterable[builtins.str] | None = ...,
        repositories: collections.abc.Iterable[builtins.str] | None = ...,
        exclude_packages: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["archive_uris", b"archive_uris", "args", b"args", "exclude_packages", b"exclude_packages", "file_uris", b"file_uris", "jar_file_uris", b"jar_file_uris", "main_python_file_uri", b"main_python_file_uri", "packages", b"packages", "properties", b"properties", "python_file_uris", b"python_file_uris", "repositories", b"repositories"]) -> None: ...

global___PysparkJob = PysparkJob
