"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import typing

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Connector(google.protobuf.message.Message):
    """Connector configuration. Exactly one connector type must be specified."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HIVE_FIELD_NUMBER: builtins.int
    ICEBERG_FIELD_NUMBER: builtins.int
    DELTA_LAKE_FIELD_NUMBER: builtins.int
    POSTGRESQL_FIELD_NUMBER: builtins.int
    CLICKHOUSE_FIELD_NUMBER: builtins.int
    TPCH_FIELD_NUMBER: builtins.int
    TPCDS_FIELD_NUMBER: builtins.int
    ORACLE_FIELD_NUMBER: builtins.int
    SQLSERVER_FIELD_NUMBER: builtins.int
    @property
    def hive(self) -> global___HiveConnector:
        """Hive connector configuration."""

    @property
    def iceberg(self) -> global___IcebergConnector:
        """Iceberg connector configuration."""

    @property
    def delta_lake(self) -> global___DeltaLakeConnector:
        """Delta Lake connector configuration."""

    @property
    def postgresql(self) -> global___PostgresqlConnector:
        """PostgreSQL connector configuration."""

    @property
    def clickhouse(self) -> global___ClickhouseConnector:
        """ClickHouse connector configuration."""

    @property
    def tpch(self) -> global___TPCHConnector:
        """TPC-H connector for synthetic benchmarking."""

    @property
    def tpcds(self) -> global___TPCDSConnector:
        """TPC-DS connector for synthetic benchmarking."""

    @property
    def oracle(self) -> global___OracleConnector:
        """Oracle connector configuration for connecting to Oracle Database instances."""

    @property
    def sqlserver(self) -> global___SQLServerConnector:
        """SQLServer connector configuration for connecting to SQLServer Database instances."""

    def __init__(
        self,
        *,
        hive: global___HiveConnector | None = ...,
        iceberg: global___IcebergConnector | None = ...,
        delta_lake: global___DeltaLakeConnector | None = ...,
        postgresql: global___PostgresqlConnector | None = ...,
        clickhouse: global___ClickhouseConnector | None = ...,
        tpch: global___TPCHConnector | None = ...,
        tpcds: global___TPCDSConnector | None = ...,
        oracle: global___OracleConnector | None = ...,
        sqlserver: global___SQLServerConnector | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["clickhouse", b"clickhouse", "delta_lake", b"delta_lake", "hive", b"hive", "iceberg", b"iceberg", "oracle", b"oracle", "postgresql", b"postgresql", "sqlserver", b"sqlserver", "tpcds", b"tpcds", "tpch", b"tpch", "type", b"type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["clickhouse", b"clickhouse", "delta_lake", b"delta_lake", "hive", b"hive", "iceberg", b"iceberg", "oracle", b"oracle", "postgresql", b"postgresql", "sqlserver", b"sqlserver", "tpcds", b"tpcds", "tpch", b"tpch", "type", b"type"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["type", b"type"]) -> typing.Literal["hive", "iceberg", "delta_lake", "postgresql", "clickhouse", "tpch", "tpcds", "oracle", "sqlserver"] | None: ...

global___Connector = Connector

@typing.final
class Catalog(google.protobuf.message.Message):
    """Catalog is a logical Trino catalog backed by a specific connector."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    CONNECTOR_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the catalog."""
    name: builtins.str
    """Name of the catalog."""
    description: builtins.str
    """Description of the catalog."""
    @property
    def connector(self) -> global___Connector:
        """Connector backing this catalog."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Labels associated with the catalog."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
        connector: global___Connector | None = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["connector", b"connector"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["connector", b"connector", "description", b"description", "id", b"id", "labels", b"labels", "name", b"name"]) -> None: ...

global___Catalog = Catalog

@typing.final
class CatalogSpec(google.protobuf.message.Message):
    """CatalogSpec defines the desired state of a new catalog."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    CONNECTOR_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the catalog.
    Must be unique within a Trino cluster.
    """
    description: builtins.str
    """Description of the catalog."""
    @property
    def connector(self) -> global___Connector:
        """Connector backing this catalog."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Labels associated with the catalog."""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        connector: global___Connector | None = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["connector", b"connector"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["connector", b"connector", "description", b"description", "labels", b"labels", "name", b"name"]) -> None: ...

global___CatalogSpec = CatalogSpec

@typing.final
class CatalogUpdateSpec(google.protobuf.message.Message):
    """CatalogUpdateSpec defines changes to an existing catalog.
    Fields are optional and only provided fields will be updated.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    CONNECTOR_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """New name of the catalog."""
    description: builtins.str
    """Description of the catalog."""
    @property
    def connector(self) -> global___Connector:
        """Updated connector configuration.
        If specified, replaces the existing connector.
        """

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Labels associated with the catalog."""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        connector: global___Connector | None = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["connector", b"connector"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["connector", b"connector", "description", b"description", "labels", b"labels", "name", b"name"]) -> None: ...

global___CatalogUpdateSpec = CatalogUpdateSpec

@typing.final
class Metastore(google.protobuf.message.Message):
    """Metastore configuration."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class HiveMetastore(google.protobuf.message.Message):
        """Configuration of Hive's metastore type."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        URI_FIELD_NUMBER: builtins.int
        uri: builtins.str
        """URI or cluster ID of the Hive Metastore."""
        def __init__(
            self,
            *,
            uri: builtins.str = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["connection", b"connection", "uri", b"uri"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["connection", b"connection", "uri", b"uri"]) -> None: ...
        def WhichOneof(self, oneof_group: typing.Literal["connection", b"connection"]) -> typing.Literal["uri"] | None: ...

    HIVE_FIELD_NUMBER: builtins.int
    @property
    def hive(self) -> global___Metastore.HiveMetastore: ...
    def __init__(
        self,
        *,
        hive: global___Metastore.HiveMetastore | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["hive", b"hive", "type", b"type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["hive", b"hive", "type", b"type"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["type", b"type"]) -> typing.Literal["hive"] | None: ...

global___Metastore = Metastore

@typing.final
class FileSystem(google.protobuf.message.Message):
    """Configuration of file system used by a connector."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class S3FileSystem(google.protobuf.message.Message):
        """Describes YandexCloud native S3 file system.
        Currently does not require configuration.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        def __init__(
            self,
        ) -> None: ...

    @typing.final
    class ExternalS3FileSystem(google.protobuf.message.Message):
        """Describes External S3 compatible file system."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        AWS_ACCESS_KEY_FIELD_NUMBER: builtins.int
        AWS_SECRET_KEY_FIELD_NUMBER: builtins.int
        AWS_ENDPOINT_FIELD_NUMBER: builtins.int
        AWS_REGION_FIELD_NUMBER: builtins.int
        aws_access_key: builtins.str
        aws_secret_key: builtins.str
        aws_endpoint: builtins.str
        aws_region: builtins.str
        def __init__(
            self,
            *,
            aws_access_key: builtins.str = ...,
            aws_secret_key: builtins.str = ...,
            aws_endpoint: builtins.str = ...,
            aws_region: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["aws_access_key", b"aws_access_key", "aws_endpoint", b"aws_endpoint", "aws_region", b"aws_region", "aws_secret_key", b"aws_secret_key"]) -> None: ...

    S3_FIELD_NUMBER: builtins.int
    EXTERNAL_S3_FIELD_NUMBER: builtins.int
    @property
    def s3(self) -> global___FileSystem.S3FileSystem: ...
    @property
    def external_s3(self) -> global___FileSystem.ExternalS3FileSystem: ...
    def __init__(
        self,
        *,
        s3: global___FileSystem.S3FileSystem | None = ...,
        external_s3: global___FileSystem.ExternalS3FileSystem | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["external_s3", b"external_s3", "s3", b"s3", "type", b"type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["external_s3", b"external_s3", "s3", b"s3", "type", b"type"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["type", b"type"]) -> typing.Literal["s3", "external_s3"] | None: ...

global___FileSystem = FileSystem

@typing.final
class HiveConnector(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class AdditionalPropertiesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    METASTORE_FIELD_NUMBER: builtins.int
    FILESYSTEM_FIELD_NUMBER: builtins.int
    ADDITIONAL_PROPERTIES_FIELD_NUMBER: builtins.int
    @property
    def metastore(self) -> global___Metastore:
        """Metastore configuration."""

    @property
    def filesystem(self) -> global___FileSystem:
        """File system configuration."""

    @property
    def additional_properties(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Additional properties."""

    def __init__(
        self,
        *,
        metastore: global___Metastore | None = ...,
        filesystem: global___FileSystem | None = ...,
        additional_properties: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["filesystem", b"filesystem", "metastore", b"metastore"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["additional_properties", b"additional_properties", "filesystem", b"filesystem", "metastore", b"metastore"]) -> None: ...

global___HiveConnector = HiveConnector

@typing.final
class IcebergConnector(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class AdditionalPropertiesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    METASTORE_FIELD_NUMBER: builtins.int
    FILESYSTEM_FIELD_NUMBER: builtins.int
    ADDITIONAL_PROPERTIES_FIELD_NUMBER: builtins.int
    @property
    def metastore(self) -> global___Metastore:
        """Metastore configuration."""

    @property
    def filesystem(self) -> global___FileSystem:
        """File system configuration."""

    @property
    def additional_properties(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Additional properties."""

    def __init__(
        self,
        *,
        metastore: global___Metastore | None = ...,
        filesystem: global___FileSystem | None = ...,
        additional_properties: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["filesystem", b"filesystem", "metastore", b"metastore"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["additional_properties", b"additional_properties", "filesystem", b"filesystem", "metastore", b"metastore"]) -> None: ...

global___IcebergConnector = IcebergConnector

@typing.final
class DeltaLakeConnector(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class AdditionalPropertiesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    METASTORE_FIELD_NUMBER: builtins.int
    FILESYSTEM_FIELD_NUMBER: builtins.int
    ADDITIONAL_PROPERTIES_FIELD_NUMBER: builtins.int
    @property
    def metastore(self) -> global___Metastore:
        """Metastore configuration."""

    @property
    def filesystem(self) -> global___FileSystem:
        """File system configuration."""

    @property
    def additional_properties(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Additional properties."""

    def __init__(
        self,
        *,
        metastore: global___Metastore | None = ...,
        filesystem: global___FileSystem | None = ...,
        additional_properties: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["filesystem", b"filesystem", "metastore", b"metastore"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["additional_properties", b"additional_properties", "filesystem", b"filesystem", "metastore", b"metastore"]) -> None: ...

global___DeltaLakeConnector = DeltaLakeConnector

@typing.final
class PostgresqlConnection(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class OnPremise(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONNECTION_URL_FIELD_NUMBER: builtins.int
        USER_NAME_FIELD_NUMBER: builtins.int
        PASSWORD_FIELD_NUMBER: builtins.int
        connection_url: builtins.str
        """Connection to the Postgresql."""
        user_name: builtins.str
        """Name of the Postgresql user."""
        password: builtins.str
        """Password of the Postgresql user."""
        def __init__(
            self,
            *,
            connection_url: builtins.str = ...,
            user_name: builtins.str = ...,
            password: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["connection_url", b"connection_url", "password", b"password", "user_name", b"user_name"]) -> None: ...

    @typing.final
    class ConnectionManager(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        @typing.final
        class ConnectionPropertiesEntry(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            KEY_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            key: builtins.str
            value: builtins.str
            def __init__(
                self,
                *,
                key: builtins.str = ...,
                value: builtins.str = ...,
            ) -> None: ...
            def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

        CONNECTION_ID_FIELD_NUMBER: builtins.int
        DATABASE_FIELD_NUMBER: builtins.int
        CONNECTION_PROPERTIES_FIELD_NUMBER: builtins.int
        connection_id: builtins.str
        """Connection ID."""
        database: builtins.str
        """Database."""
        @property
        def connection_properties(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
            """Additional connection properties."""

        def __init__(
            self,
            *,
            connection_id: builtins.str = ...,
            database: builtins.str = ...,
            connection_properties: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["connection_id", b"connection_id", "connection_properties", b"connection_properties", "database", b"database"]) -> None: ...

    ON_PREMISE_FIELD_NUMBER: builtins.int
    CONNECTION_MANAGER_FIELD_NUMBER: builtins.int
    @property
    def on_premise(self) -> global___PostgresqlConnection.OnPremise: ...
    @property
    def connection_manager(self) -> global___PostgresqlConnection.ConnectionManager: ...
    def __init__(
        self,
        *,
        on_premise: global___PostgresqlConnection.OnPremise | None = ...,
        connection_manager: global___PostgresqlConnection.ConnectionManager | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["connection_manager", b"connection_manager", "on_premise", b"on_premise", "type", b"type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["connection_manager", b"connection_manager", "on_premise", b"on_premise", "type", b"type"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["type", b"type"]) -> typing.Literal["on_premise", "connection_manager"] | None: ...

global___PostgresqlConnection = PostgresqlConnection

@typing.final
class PostgresqlConnector(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class AdditionalPropertiesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    CONNECTION_FIELD_NUMBER: builtins.int
    ADDITIONAL_PROPERTIES_FIELD_NUMBER: builtins.int
    @property
    def connection(self) -> global___PostgresqlConnection:
        """Connection configuration."""

    @property
    def additional_properties(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Additional properties."""

    def __init__(
        self,
        *,
        connection: global___PostgresqlConnection | None = ...,
        additional_properties: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["connection", b"connection"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["additional_properties", b"additional_properties", "connection", b"connection"]) -> None: ...

global___PostgresqlConnector = PostgresqlConnector

@typing.final
class ClickhouseConnection(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class OnPremise(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONNECTION_URL_FIELD_NUMBER: builtins.int
        USER_NAME_FIELD_NUMBER: builtins.int
        PASSWORD_FIELD_NUMBER: builtins.int
        connection_url: builtins.str
        """Connection to the Clickhouse."""
        user_name: builtins.str
        """Name of the Clickhouse user."""
        password: builtins.str
        """Password of the Clickhouse user."""
        def __init__(
            self,
            *,
            connection_url: builtins.str = ...,
            user_name: builtins.str = ...,
            password: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["connection_url", b"connection_url", "password", b"password", "user_name", b"user_name"]) -> None: ...

    @typing.final
    class ConnectionManager(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        @typing.final
        class ConnectionPropertiesEntry(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            KEY_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            key: builtins.str
            value: builtins.str
            def __init__(
                self,
                *,
                key: builtins.str = ...,
                value: builtins.str = ...,
            ) -> None: ...
            def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

        CONNECTION_ID_FIELD_NUMBER: builtins.int
        DATABASE_FIELD_NUMBER: builtins.int
        CONNECTION_PROPERTIES_FIELD_NUMBER: builtins.int
        connection_id: builtins.str
        """Connection ID."""
        database: builtins.str
        """Database."""
        @property
        def connection_properties(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
            """Additional connection properties."""

        def __init__(
            self,
            *,
            connection_id: builtins.str = ...,
            database: builtins.str = ...,
            connection_properties: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["connection_id", b"connection_id", "connection_properties", b"connection_properties", "database", b"database"]) -> None: ...

    ON_PREMISE_FIELD_NUMBER: builtins.int
    CONNECTION_MANAGER_FIELD_NUMBER: builtins.int
    @property
    def on_premise(self) -> global___ClickhouseConnection.OnPremise: ...
    @property
    def connection_manager(self) -> global___ClickhouseConnection.ConnectionManager: ...
    def __init__(
        self,
        *,
        on_premise: global___ClickhouseConnection.OnPremise | None = ...,
        connection_manager: global___ClickhouseConnection.ConnectionManager | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["connection_manager", b"connection_manager", "on_premise", b"on_premise", "type", b"type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["connection_manager", b"connection_manager", "on_premise", b"on_premise", "type", b"type"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["type", b"type"]) -> typing.Literal["on_premise", "connection_manager"] | None: ...

global___ClickhouseConnection = ClickhouseConnection

@typing.final
class ClickhouseConnector(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class AdditionalPropertiesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    CONNECTION_FIELD_NUMBER: builtins.int
    ADDITIONAL_PROPERTIES_FIELD_NUMBER: builtins.int
    @property
    def connection(self) -> global___ClickhouseConnection:
        """Connection configuration."""

    @property
    def additional_properties(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Additional properties."""

    def __init__(
        self,
        *,
        connection: global___ClickhouseConnection | None = ...,
        additional_properties: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["connection", b"connection"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["additional_properties", b"additional_properties", "connection", b"connection"]) -> None: ...

global___ClickhouseConnector = ClickhouseConnector

@typing.final
class TPCHConnector(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class AdditionalPropertiesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ADDITIONAL_PROPERTIES_FIELD_NUMBER: builtins.int
    @property
    def additional_properties(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Additional properties."""

    def __init__(
        self,
        *,
        additional_properties: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["additional_properties", b"additional_properties"]) -> None: ...

global___TPCHConnector = TPCHConnector

@typing.final
class TPCDSConnector(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class AdditionalPropertiesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ADDITIONAL_PROPERTIES_FIELD_NUMBER: builtins.int
    @property
    def additional_properties(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Additional properties."""

    def __init__(
        self,
        *,
        additional_properties: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["additional_properties", b"additional_properties"]) -> None: ...

global___TPCDSConnector = TPCDSConnector

@typing.final
class OracleConnection(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class OnPremise(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONNECTION_URL_FIELD_NUMBER: builtins.int
        USER_NAME_FIELD_NUMBER: builtins.int
        PASSWORD_FIELD_NUMBER: builtins.int
        connection_url: builtins.str
        """Connection to the Oracle."""
        user_name: builtins.str
        """Name of the Oracle user."""
        password: builtins.str
        """Password of the Oracle user."""
        def __init__(
            self,
            *,
            connection_url: builtins.str = ...,
            user_name: builtins.str = ...,
            password: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["connection_url", b"connection_url", "password", b"password", "user_name", b"user_name"]) -> None: ...

    ON_PREMISE_FIELD_NUMBER: builtins.int
    @property
    def on_premise(self) -> global___OracleConnection.OnPremise: ...
    def __init__(
        self,
        *,
        on_premise: global___OracleConnection.OnPremise | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["on_premise", b"on_premise", "type", b"type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["on_premise", b"on_premise", "type", b"type"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["type", b"type"]) -> typing.Literal["on_premise"] | None: ...

global___OracleConnection = OracleConnection

@typing.final
class OracleConnector(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class AdditionalPropertiesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    CONNECTION_FIELD_NUMBER: builtins.int
    ADDITIONAL_PROPERTIES_FIELD_NUMBER: builtins.int
    @property
    def connection(self) -> global___OracleConnection:
        """Connection configuration."""

    @property
    def additional_properties(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Additional properties."""

    def __init__(
        self,
        *,
        connection: global___OracleConnection | None = ...,
        additional_properties: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["connection", b"connection"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["additional_properties", b"additional_properties", "connection", b"connection"]) -> None: ...

global___OracleConnector = OracleConnector

@typing.final
class SQLServerConnection(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class OnPremise(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONNECTION_URL_FIELD_NUMBER: builtins.int
        USER_NAME_FIELD_NUMBER: builtins.int
        PASSWORD_FIELD_NUMBER: builtins.int
        connection_url: builtins.str
        """Connection to the SQLServer."""
        user_name: builtins.str
        """Name of the SQLServer user."""
        password: builtins.str
        """Password of the SQLServer user."""
        def __init__(
            self,
            *,
            connection_url: builtins.str = ...,
            user_name: builtins.str = ...,
            password: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["connection_url", b"connection_url", "password", b"password", "user_name", b"user_name"]) -> None: ...

    ON_PREMISE_FIELD_NUMBER: builtins.int
    @property
    def on_premise(self) -> global___SQLServerConnection.OnPremise: ...
    def __init__(
        self,
        *,
        on_premise: global___SQLServerConnection.OnPremise | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["on_premise", b"on_premise", "type", b"type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["on_premise", b"on_premise", "type", b"type"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["type", b"type"]) -> typing.Literal["on_premise"] | None: ...

global___SQLServerConnection = SQLServerConnection

@typing.final
class SQLServerConnector(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class AdditionalPropertiesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    CONNECTION_FIELD_NUMBER: builtins.int
    ADDITIONAL_PROPERTIES_FIELD_NUMBER: builtins.int
    @property
    def connection(self) -> global___SQLServerConnection:
        """Connection configuration."""

    @property
    def additional_properties(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Additional properties."""

    def __init__(
        self,
        *,
        connection: global___SQLServerConnection | None = ...,
        additional_properties: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["connection", b"connection"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["additional_properties", b"additional_properties", "connection", b"connection"]) -> None: ...

global___SQLServerConnector = SQLServerConnector
