"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing
import yandex.cloud.logging.v1.log_entry_pb2
import yandex.cloud.trino.v1.access_control_pb2
import yandex.cloud.trino.v1.maintenance_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _Health:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _HealthEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Health.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    HEALTH_UNKNOWN: _Health.ValueType  # 0
    """Object is in unknown state (we have no data)"""
    ALIVE: _Health.ValueType  # 1
    """Object is alive and well (all hosts are alive)"""
    DEAD: _Health.ValueType  # 2
    """Object is inoperable (it cannot perform any of its essential functions)"""
    DEGRADED: _Health.ValueType  # 3
    """Object is partially alive (it can perform some of its essential functions)"""

class Health(_Health, metaclass=_HealthEnumTypeWrapper): ...

HEALTH_UNKNOWN: Health.ValueType  # 0
"""Object is in unknown state (we have no data)"""
ALIVE: Health.ValueType  # 1
"""Object is alive and well (all hosts are alive)"""
DEAD: Health.ValueType  # 2
"""Object is inoperable (it cannot perform any of its essential functions)"""
DEGRADED: Health.ValueType  # 3
"""Object is partially alive (it can perform some of its essential functions)"""
global___Health = Health

@typing.final
class Cluster(google.protobuf.message.Message):
    """Trino cluster."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Cluster._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNKNOWN: Cluster._Status.ValueType  # 0
        """Cluster state is unknown."""
        CREATING: Cluster._Status.ValueType  # 1
        """Cluster is being created."""
        RUNNING: Cluster._Status.ValueType  # 2
        """Cluster is running normally."""
        ERROR: Cluster._Status.ValueType  # 3
        """Cluster encountered a problem and cannot operate."""
        STOPPING: Cluster._Status.ValueType  # 4
        """Cluster is stopping."""
        STOPPED: Cluster._Status.ValueType  # 5
        """Cluster is stopped."""
        STARTING: Cluster._Status.ValueType  # 6
        """Cluster is starting."""
        UPDATING: Cluster._Status.ValueType  # 7
        """Cluster is being updated."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNKNOWN: Cluster.Status.ValueType  # 0
    """Cluster state is unknown."""
    CREATING: Cluster.Status.ValueType  # 1
    """Cluster is being created."""
    RUNNING: Cluster.Status.ValueType  # 2
    """Cluster is running normally."""
    ERROR: Cluster.Status.ValueType  # 3
    """Cluster encountered a problem and cannot operate."""
    STOPPING: Cluster.Status.ValueType  # 4
    """Cluster is stopping."""
    STOPPED: Cluster.Status.ValueType  # 5
    """Cluster is stopped."""
    STARTING: Cluster.Status.ValueType  # 6
    """Cluster is starting."""
    UPDATING: Cluster.Status.ValueType  # 7
    """Cluster is being updated."""

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    MONITORING_FIELD_NUMBER: builtins.int
    TRINO_FIELD_NUMBER: builtins.int
    HEALTH_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    NETWORK_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    LOGGING_FIELD_NUMBER: builtins.int
    COORDINATOR_URL_FIELD_NUMBER: builtins.int
    MAINTENANCE_WINDOW_FIELD_NUMBER: builtins.int
    PLANNED_OPERATION_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Unique ID of the Trino cluster.
    This ID is assigned by Cloud in the process of creating a Trino cluster.
    """
    folder_id: builtins.str
    """ID of the folder that the Trino cluster belongs to."""
    name: builtins.str
    """Name of the Trino cluster.
    The name is unique within the folder. 1-64 characters long.
    """
    description: builtins.str
    """Description of the Trino cluster. 0-256 characters long."""
    health: global___Health.ValueType
    """Aggregated cluster health."""
    status: global___Cluster.Status.ValueType
    """Cluster status."""
    deletion_protection: builtins.bool
    """Deletion Protection inhibits deletion of the cluster."""
    service_account_id: builtins.str
    """Service account used to access Cloud resources."""
    coordinator_url: builtins.str
    """Address of Trino Coordinator."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time when the Trino cluster was created."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `key:value` pairs. Maximum of 64 per resource."""

    @property
    def monitoring(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Monitoring]:
        """Monitoring systems relevant to the Trino cluster."""

    @property
    def trino(self) -> global___TrinoConfig:
        """Configuration of the Trino cluster."""

    @property
    def network(self) -> global___NetworkConfig:
        """Network related configuration options."""

    @property
    def logging(self) -> global___LoggingConfig:
        """Cloud logging configuration."""

    @property
    def maintenance_window(self) -> yandex.cloud.trino.v1.maintenance_pb2.MaintenanceWindow:
        """Window of maintenance operations."""

    @property
    def planned_operation(self) -> yandex.cloud.trino.v1.maintenance_pb2.MaintenanceOperation:
        """Maintenance operation planned at nearest maintenance_window."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        folder_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        monitoring: collections.abc.Iterable[global___Monitoring] | None = ...,
        trino: global___TrinoConfig | None = ...,
        health: global___Health.ValueType = ...,
        status: global___Cluster.Status.ValueType = ...,
        network: global___NetworkConfig | None = ...,
        deletion_protection: builtins.bool = ...,
        service_account_id: builtins.str = ...,
        logging: global___LoggingConfig | None = ...,
        coordinator_url: builtins.str = ...,
        maintenance_window: yandex.cloud.trino.v1.maintenance_pb2.MaintenanceWindow | None = ...,
        planned_operation: yandex.cloud.trino.v1.maintenance_pb2.MaintenanceOperation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at", "logging", b"logging", "maintenance_window", b"maintenance_window", "network", b"network", "planned_operation", b"planned_operation", "trino", b"trino"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["coordinator_url", b"coordinator_url", "created_at", b"created_at", "deletion_protection", b"deletion_protection", "description", b"description", "folder_id", b"folder_id", "health", b"health", "id", b"id", "labels", b"labels", "logging", b"logging", "maintenance_window", b"maintenance_window", "monitoring", b"monitoring", "name", b"name", "network", b"network", "planned_operation", b"planned_operation", "service_account_id", b"service_account_id", "status", b"status", "trino", b"trino"]) -> None: ...

global___Cluster = Cluster

@typing.final
class Monitoring(google.protobuf.message.Message):
    """Monitoring system."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LINK_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the monitoring system."""
    description: builtins.str
    """Description of the monitoring system."""
    link: builtins.str
    """Link to the monitoring system."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        description: builtins.str = ...,
        link: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "link", b"link", "name", b"name"]) -> None: ...

global___Monitoring = Monitoring

@typing.final
class LoggingConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENABLED_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    LOG_GROUP_ID_FIELD_NUMBER: builtins.int
    MIN_LEVEL_FIELD_NUMBER: builtins.int
    enabled: builtins.bool
    """Logs generated by the Trino components are delivered to Cloud Logging."""
    folder_id: builtins.str
    """Logs should be written to default log group for specified folder."""
    log_group_id: builtins.str
    """Logs should be written to log group resolved by ID."""
    min_level: yandex.cloud.logging.v1.log_entry_pb2.LogLevel.Level.ValueType
    """Minimum log entry level.

    See [LogLevel.Level] for details.
    """
    def __init__(
        self,
        *,
        enabled: builtins.bool = ...,
        folder_id: builtins.str = ...,
        log_group_id: builtins.str = ...,
        min_level: yandex.cloud.logging.v1.log_entry_pb2.LogLevel.Level.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["destination", b"destination", "folder_id", b"folder_id", "log_group_id", b"log_group_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["destination", b"destination", "enabled", b"enabled", "folder_id", b"folder_id", "log_group_id", b"log_group_id", "min_level", b"min_level"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["destination", b"destination"]) -> typing.Literal["folder_id", "log_group_id"] | None: ...

global___LoggingConfig = LoggingConfig

@typing.final
class NetworkConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUBNET_IDS_FIELD_NUMBER: builtins.int
    SECURITY_GROUP_IDS_FIELD_NUMBER: builtins.int
    @property
    def subnet_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """IDs of VPC network subnets where instances of the cluster are attached."""

    @property
    def security_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """User security groups."""

    def __init__(
        self,
        *,
        subnet_ids: collections.abc.Iterable[builtins.str] | None = ...,
        security_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["security_group_ids", b"security_group_ids", "subnet_ids", b"subnet_ids"]) -> None: ...

global___NetworkConfig = NetworkConfig

@typing.final
class TrinoConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COORDINATOR_CONFIG_FIELD_NUMBER: builtins.int
    WORKER_CONFIG_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    RETRY_POLICY_FIELD_NUMBER: builtins.int
    ACCESS_CONTROL_FIELD_NUMBER: builtins.int
    version: builtins.str
    """Version of Trino."""
    @property
    def coordinator_config(self) -> global___CoordinatorConfig:
        """Configuration for the coordinator, specifying computational resources and other settings."""

    @property
    def worker_config(self) -> global___WorkerConfig:
        """Configuration for worker nodes, including scaling policy and computational resources."""

    @property
    def retry_policy(self) -> global___RetryPolicyConfig:
        """Configuration for retry policy, specifying the spooling storage destination and other settings."""

    @property
    def access_control(self) -> yandex.cloud.trino.v1.access_control_pb2.AccessControlConfig:
        """Configuration for access control, specifying the fine-grained rules of accesses."""

    def __init__(
        self,
        *,
        coordinator_config: global___CoordinatorConfig | None = ...,
        worker_config: global___WorkerConfig | None = ...,
        version: builtins.str = ...,
        retry_policy: global___RetryPolicyConfig | None = ...,
        access_control: yandex.cloud.trino.v1.access_control_pb2.AccessControlConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["access_control", b"access_control", "coordinator_config", b"coordinator_config", "retry_policy", b"retry_policy", "worker_config", b"worker_config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["access_control", b"access_control", "coordinator_config", b"coordinator_config", "retry_policy", b"retry_policy", "version", b"version", "worker_config", b"worker_config"]) -> None: ...

global___TrinoConfig = TrinoConfig

@typing.final
class CoordinatorConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOURCES_FIELD_NUMBER: builtins.int
    @property
    def resources(self) -> global___Resources:
        """Configuration for computational resources assigned to the coordinator instance."""

    def __init__(
        self,
        *,
        resources: global___Resources | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["resources", b"resources"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["resources", b"resources"]) -> None: ...

global___CoordinatorConfig = CoordinatorConfig

@typing.final
class WorkerConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class WorkerScalePolicy(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        FIXED_SCALE_FIELD_NUMBER: builtins.int
        AUTO_SCALE_FIELD_NUMBER: builtins.int
        @property
        def fixed_scale(self) -> global___FixedScalePolicy:
            """A fixed scaling policy that specifies a fixed number of worker instances."""

        @property
        def auto_scale(self) -> global___AutoScalePolicy:
            """A scaling policy that dynamically adjusts the number of worker instances
            based on the cluster's workload. The system automatically increases or
            decreases the number of instances within the defined range.
            """

        def __init__(
            self,
            *,
            fixed_scale: global___FixedScalePolicy | None = ...,
            auto_scale: global___AutoScalePolicy | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["auto_scale", b"auto_scale", "fixed_scale", b"fixed_scale", "scale_type", b"scale_type"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["auto_scale", b"auto_scale", "fixed_scale", b"fixed_scale", "scale_type", b"scale_type"]) -> None: ...
        def WhichOneof(self, oneof_group: typing.Literal["scale_type", b"scale_type"]) -> typing.Literal["fixed_scale", "auto_scale"] | None: ...

    RESOURCES_FIELD_NUMBER: builtins.int
    SCALE_POLICY_FIELD_NUMBER: builtins.int
    @property
    def resources(self) -> global___Resources:
        """Configuration for computational resources for worker instances."""

    @property
    def scale_policy(self) -> global___WorkerConfig.WorkerScalePolicy:
        """Configuration for scaling policy for worker instances."""

    def __init__(
        self,
        *,
        resources: global___Resources | None = ...,
        scale_policy: global___WorkerConfig.WorkerScalePolicy | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["resources", b"resources", "scale_policy", b"scale_policy"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["resources", b"resources", "scale_policy", b"scale_policy"]) -> None: ...

global___WorkerConfig = WorkerConfig

@typing.final
class RetryPolicyConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _RetryPolicy:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _RetryPolicyEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[RetryPolicyConfig._RetryPolicy.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        RETRY_POLICY_UNSPECIFIED: RetryPolicyConfig._RetryPolicy.ValueType  # 0
        QUERY: RetryPolicyConfig._RetryPolicy.ValueType  # 1
        TASK: RetryPolicyConfig._RetryPolicy.ValueType  # 2

    class RetryPolicy(_RetryPolicy, metaclass=_RetryPolicyEnumTypeWrapper): ...
    RETRY_POLICY_UNSPECIFIED: RetryPolicyConfig.RetryPolicy.ValueType  # 0
    QUERY: RetryPolicyConfig.RetryPolicy.ValueType  # 1
    TASK: RetryPolicyConfig.RetryPolicy.ValueType  # 2

    @typing.final
    class AdditionalPropertiesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    POLICY_FIELD_NUMBER: builtins.int
    EXCHANGE_MANAGER_FIELD_NUMBER: builtins.int
    ADDITIONAL_PROPERTIES_FIELD_NUMBER: builtins.int
    policy: global___RetryPolicyConfig.RetryPolicy.ValueType
    """Retry policy level."""
    @property
    def exchange_manager(self) -> global___ExchangeManagerConfig:
        """Configuration for exchange manager."""

    @property
    def additional_properties(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Additional properties."""

    def __init__(
        self,
        *,
        policy: global___RetryPolicyConfig.RetryPolicy.ValueType = ...,
        exchange_manager: global___ExchangeManagerConfig | None = ...,
        additional_properties: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["exchange_manager", b"exchange_manager"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["additional_properties", b"additional_properties", "exchange_manager", b"exchange_manager", "policy", b"policy"]) -> None: ...

global___RetryPolicyConfig = RetryPolicyConfig

@typing.final
class ExchangeManagerStorage(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class ServiceS3(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        def __init__(
            self,
        ) -> None: ...

    SERVICE_S3_FIELD_NUMBER: builtins.int
    @property
    def service_s3(self) -> global___ExchangeManagerStorage.ServiceS3:
        """Use service side s3 bucket for exchange manager."""

    def __init__(
        self,
        *,
        service_s3: global___ExchangeManagerStorage.ServiceS3 | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["service_s3", b"service_s3", "type", b"type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["service_s3", b"service_s3", "type", b"type"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["type", b"type"]) -> typing.Literal["service_s3"] | None: ...

global___ExchangeManagerStorage = ExchangeManagerStorage

@typing.final
class ExchangeManagerConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class AdditionalPropertiesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ADDITIONAL_PROPERTIES_FIELD_NUMBER: builtins.int
    STORAGE_FIELD_NUMBER: builtins.int
    @property
    def additional_properties(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Additional properties."""

    @property
    def storage(self) -> global___ExchangeManagerStorage: ...
    def __init__(
        self,
        *,
        additional_properties: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        storage: global___ExchangeManagerStorage | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["storage", b"storage"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["additional_properties", b"additional_properties", "storage", b"storage"]) -> None: ...

global___ExchangeManagerConfig = ExchangeManagerConfig

@typing.final
class Resources(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOURCE_PRESET_ID_FIELD_NUMBER: builtins.int
    resource_preset_id: builtins.str
    """ID of the preset for computational resources allocated to a instance (e.g., CPU, memory, etc.)."""
    def __init__(
        self,
        *,
        resource_preset_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["resource_preset_id", b"resource_preset_id"]) -> None: ...

global___Resources = Resources

@typing.final
class FixedScalePolicy(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COUNT_FIELD_NUMBER: builtins.int
    count: builtins.int
    """Specifies the number of worker instances."""
    def __init__(
        self,
        *,
        count: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["count", b"count"]) -> None: ...

global___FixedScalePolicy = FixedScalePolicy

@typing.final
class AutoScalePolicy(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MIN_COUNT_FIELD_NUMBER: builtins.int
    MAX_COUNT_FIELD_NUMBER: builtins.int
    min_count: builtins.int
    max_count: builtins.int
    def __init__(
        self,
        *,
        min_count: builtins.int = ...,
        max_count: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["max_count", b"max_count", "min_count", b"min_count"]) -> None: ...

global___AutoScalePolicy = AutoScalePolicy
