"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.operation.operation_pb2
import yandex.cloud.trino.v1.access_control_pb2
import yandex.cloud.trino.v1.catalog_pb2
import yandex.cloud.trino.v1.cluster_pb2
import yandex.cloud.trino.v1.maintenance_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Trino Cluster resource to return."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___GetClusterRequest = GetClusterRequest

@typing.final
class ListClustersRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to list Trino clusters in."""
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size], the service returns a [ListClustersResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the [ListClustersResponse.next_page_token]
    returned by the previous list request.
    """
    filter: builtins.str
    """A filter expression that filters resources listed in the response.
    The expression must specify:
    1. The field name. Currently you can only use filtering with the [Cluster.name] field.
    2. An `=` operator.
    3. The value in double quotes (`"`). Must be 1-63 characters long and match the regular expression `[a-zA-Z0-9_-]+`.
    """
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "folder_id", b"folder_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListClustersRequest = ListClustersRequest

@typing.final
class ListClustersResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTERS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is larger than [ListClustersRequest.page_size], use the [next_page_token] as the value
    for the [ListClustersRequest.page_token] parameter in the next list request. Each subsequent
    list request will have its own [next_page_token] to continue paging through the results.
    """
    @property
    def clusters(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.trino.v1.cluster_pb2.Cluster]:
        """List of Trino Cluster resources."""

    def __init__(
        self,
        *,
        clusters: collections.abc.Iterable[yandex.cloud.trino.v1.cluster_pb2.Cluster] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clusters", b"clusters", "next_page_token", b"next_page_token"]) -> None: ...

global___ListClustersResponse = ListClustersResponse

@typing.final
class CreateClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    TRINO_FIELD_NUMBER: builtins.int
    NETWORK_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    LOGGING_FIELD_NUMBER: builtins.int
    MAINTENANCE_WINDOW_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to create Trino cluster in."""
    name: builtins.str
    """Name of the Trino cluster. The name must be unique within the folder."""
    description: builtins.str
    """Description of the Trino cluster."""
    deletion_protection: builtins.bool
    """Deletion Protection inhibits deletion of the cluster."""
    service_account_id: builtins.str
    """Service account used to access Cloud resources."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Custom labels for the Trino cluster as `` key:value `` pairs.
        For example: {"env": "prod"}.
        """

    @property
    def trino(self) -> global___TrinoConfigSpec:
        """Configuration of Trino components."""

    @property
    def network(self) -> yandex.cloud.trino.v1.cluster_pb2.NetworkConfig:
        """Network related configuration options."""

    @property
    def logging(self) -> yandex.cloud.trino.v1.cluster_pb2.LoggingConfig:
        """Cloud logging configuration."""

    @property
    def maintenance_window(self) -> yandex.cloud.trino.v1.maintenance_pb2.MaintenanceWindow:
        """Window of maintenance operations."""

    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        trino: global___TrinoConfigSpec | None = ...,
        network: yandex.cloud.trino.v1.cluster_pb2.NetworkConfig | None = ...,
        deletion_protection: builtins.bool = ...,
        service_account_id: builtins.str = ...,
        logging: yandex.cloud.trino.v1.cluster_pb2.LoggingConfig | None = ...,
        maintenance_window: yandex.cloud.trino.v1.maintenance_pb2.MaintenanceWindow | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["logging", b"logging", "maintenance_window", b"maintenance_window", "network", b"network", "trino", b"trino"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["deletion_protection", b"deletion_protection", "description", b"description", "folder_id", b"folder_id", "labels", b"labels", "logging", b"logging", "maintenance_window", b"maintenance_window", "name", b"name", "network", b"network", "service_account_id", b"service_account_id", "trino", b"trino"]) -> None: ...

global___CreateClusterRequest = CreateClusterRequest

@typing.final
class TrinoConfigSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CATALOGS_FIELD_NUMBER: builtins.int
    COORDINATOR_CONFIG_FIELD_NUMBER: builtins.int
    WORKER_CONFIG_FIELD_NUMBER: builtins.int
    RETRY_POLICY_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    ACCESS_CONTROL_FIELD_NUMBER: builtins.int
    version: builtins.str
    """Trino version.
    Format: "Number".
    """
    @property
    def catalogs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.trino.v1.catalog_pb2.CatalogSpec]:
        """List of catalogs that enable integration with various data sources.
        Each catalog defines a connection to an external data source that Trino can query.
        """

    @property
    def coordinator_config(self) -> yandex.cloud.trino.v1.cluster_pb2.CoordinatorConfig:
        """Configuration for the coordinator, specifying computational resources and other settings."""

    @property
    def worker_config(self) -> yandex.cloud.trino.v1.cluster_pb2.WorkerConfig:
        """Configuration for worker nodes, including scaling policy and computational resources."""

    @property
    def retry_policy(self) -> yandex.cloud.trino.v1.cluster_pb2.RetryPolicyConfig:
        """Configuration for retry policy, specifying the spooling storage destination and other settings."""

    @property
    def access_control(self) -> yandex.cloud.trino.v1.access_control_pb2.AccessControlConfig:
        """Configuration for access control, specifying the fine-grained access rules."""

    def __init__(
        self,
        *,
        catalogs: collections.abc.Iterable[yandex.cloud.trino.v1.catalog_pb2.CatalogSpec] | None = ...,
        coordinator_config: yandex.cloud.trino.v1.cluster_pb2.CoordinatorConfig | None = ...,
        worker_config: yandex.cloud.trino.v1.cluster_pb2.WorkerConfig | None = ...,
        retry_policy: yandex.cloud.trino.v1.cluster_pb2.RetryPolicyConfig | None = ...,
        version: builtins.str = ...,
        access_control: yandex.cloud.trino.v1.access_control_pb2.AccessControlConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["access_control", b"access_control", "coordinator_config", b"coordinator_config", "retry_policy", b"retry_policy", "worker_config", b"worker_config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["access_control", b"access_control", "catalogs", b"catalogs", "coordinator_config", b"coordinator_config", "retry_policy", b"retry_policy", "version", b"version", "worker_config", b"worker_config"]) -> None: ...

global___TrinoConfigSpec = TrinoConfigSpec

@typing.final
class CreateClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Trino cluster that is being created."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___CreateClusterMetadata = CreateClusterMetadata

@typing.final
class UpdateCoordinatorConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOURCES_FIELD_NUMBER: builtins.int
    @property
    def resources(self) -> yandex.cloud.trino.v1.cluster_pb2.Resources:
        """Configuration for computational resources assigned to the coordinator instance."""

    def __init__(
        self,
        *,
        resources: yandex.cloud.trino.v1.cluster_pb2.Resources | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["resources", b"resources"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["resources", b"resources"]) -> None: ...

global___UpdateCoordinatorConfig = UpdateCoordinatorConfig

@typing.final
class UpdateWorkerConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class WorkerScalePolicy(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        FIXED_SCALE_FIELD_NUMBER: builtins.int
        AUTO_SCALE_FIELD_NUMBER: builtins.int
        @property
        def fixed_scale(self) -> yandex.cloud.trino.v1.cluster_pb2.FixedScalePolicy:
            """A fixed scaling policy that specifies a fixed number of worker instances."""

        @property
        def auto_scale(self) -> yandex.cloud.trino.v1.cluster_pb2.AutoScalePolicy:
            """A scaling policy that dynamically adjusts the number of worker instances
            based on the cluster's workload. The system automatically increases or
            decreases the number of instances within the defined range.
            """

        def __init__(
            self,
            *,
            fixed_scale: yandex.cloud.trino.v1.cluster_pb2.FixedScalePolicy | None = ...,
            auto_scale: yandex.cloud.trino.v1.cluster_pb2.AutoScalePolicy | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["auto_scale", b"auto_scale", "fixed_scale", b"fixed_scale", "scale_type", b"scale_type"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["auto_scale", b"auto_scale", "fixed_scale", b"fixed_scale", "scale_type", b"scale_type"]) -> None: ...
        def WhichOneof(self, oneof_group: typing.Literal["scale_type", b"scale_type"]) -> typing.Literal["fixed_scale", "auto_scale"] | None: ...

    RESOURCES_FIELD_NUMBER: builtins.int
    SCALE_POLICY_FIELD_NUMBER: builtins.int
    @property
    def resources(self) -> yandex.cloud.trino.v1.cluster_pb2.Resources:
        """Configuration for computational resources for worker instances."""

    @property
    def scale_policy(self) -> global___UpdateWorkerConfig.WorkerScalePolicy:
        """Configuration for scaling policy for worker instances."""

    def __init__(
        self,
        *,
        resources: yandex.cloud.trino.v1.cluster_pb2.Resources | None = ...,
        scale_policy: global___UpdateWorkerConfig.WorkerScalePolicy | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["resources", b"resources", "scale_policy", b"scale_policy"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["resources", b"resources", "scale_policy", b"scale_policy"]) -> None: ...

global___UpdateWorkerConfig = UpdateWorkerConfig

@typing.final
class UpdateTrinoConfigSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COORDINATOR_CONFIG_FIELD_NUMBER: builtins.int
    WORKER_CONFIG_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    RETRY_POLICY_FIELD_NUMBER: builtins.int
    ACCESS_CONTROL_FIELD_NUMBER: builtins.int
    version: builtins.str
    """Trino version.
    Format: "Number".
    """
    @property
    def coordinator_config(self) -> global___UpdateCoordinatorConfig:
        """Configuration for the coordinator, specifying computational resources and other settings."""

    @property
    def worker_config(self) -> global___UpdateWorkerConfig:
        """Configuration for worker nodes, including scaling policy and computational resources."""

    @property
    def retry_policy(self) -> yandex.cloud.trino.v1.cluster_pb2.RetryPolicyConfig:
        """Configuration for retry policy, specifying the spooling storage destination and other settings."""

    @property
    def access_control(self) -> yandex.cloud.trino.v1.access_control_pb2.AccessControlConfig:
        """Configuration for access control, specifying the fine-grained access rules."""

    def __init__(
        self,
        *,
        coordinator_config: global___UpdateCoordinatorConfig | None = ...,
        worker_config: global___UpdateWorkerConfig | None = ...,
        version: builtins.str = ...,
        retry_policy: yandex.cloud.trino.v1.cluster_pb2.RetryPolicyConfig | None = ...,
        access_control: yandex.cloud.trino.v1.access_control_pb2.AccessControlConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["access_control", b"access_control", "coordinator_config", b"coordinator_config", "retry_policy", b"retry_policy", "worker_config", b"worker_config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["access_control", b"access_control", "coordinator_config", b"coordinator_config", "retry_policy", b"retry_policy", "version", b"version", "worker_config", b"worker_config"]) -> None: ...

global___UpdateTrinoConfigSpec = UpdateTrinoConfigSpec

@typing.final
class UpdateNetworkConfigSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SECURITY_GROUP_IDS_FIELD_NUMBER: builtins.int
    @property
    def security_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """User security groups."""

    def __init__(
        self,
        *,
        security_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["security_group_ids", b"security_group_ids"]) -> None: ...

global___UpdateNetworkConfigSpec = UpdateNetworkConfigSpec

@typing.final
class UpdateClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    TRINO_FIELD_NUMBER: builtins.int
    NETWORK_SPEC_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    LOGGING_FIELD_NUMBER: builtins.int
    MAINTENANCE_WINDOW_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Trino cluster."""
    name: builtins.str
    """Name of the Trino cluster. The name must be unique within the folder."""
    description: builtins.str
    """Description of the Trino cluster."""
    deletion_protection: builtins.bool
    """Deletion Protection inhibits deletion of the cluster."""
    service_account_id: builtins.str
    """Service account used to access Cloud resources."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask: ...
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Custom labels for the Trino cluster as `` key:value `` pairs.
        For example: {"env": "prod"}.
        """

    @property
    def trino(self) -> global___UpdateTrinoConfigSpec:
        """Configuration of Trino components."""

    @property
    def network_spec(self) -> global___UpdateNetworkConfigSpec:
        """Network related configuration options."""

    @property
    def logging(self) -> yandex.cloud.trino.v1.cluster_pb2.LoggingConfig:
        """Cloud logging configuration."""

    @property
    def maintenance_window(self) -> yandex.cloud.trino.v1.maintenance_pb2.MaintenanceWindow:
        """Window of maintenance operations."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        deletion_protection: builtins.bool = ...,
        trino: global___UpdateTrinoConfigSpec | None = ...,
        network_spec: global___UpdateNetworkConfigSpec | None = ...,
        service_account_id: builtins.str = ...,
        logging: yandex.cloud.trino.v1.cluster_pb2.LoggingConfig | None = ...,
        maintenance_window: yandex.cloud.trino.v1.maintenance_pb2.MaintenanceWindow | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["logging", b"logging", "maintenance_window", b"maintenance_window", "network_spec", b"network_spec", "trino", b"trino", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "deletion_protection", b"deletion_protection", "description", b"description", "labels", b"labels", "logging", b"logging", "maintenance_window", b"maintenance_window", "name", b"name", "network_spec", b"network_spec", "service_account_id", b"service_account_id", "trino", b"trino", "update_mask", b"update_mask"]) -> None: ...

global___UpdateClusterRequest = UpdateClusterRequest

@typing.final
class UpdateClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Trino cluster that is being updated."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___UpdateClusterMetadata = UpdateClusterMetadata

@typing.final
class DeleteClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Trino cluster that is being deleted."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___DeleteClusterRequest = DeleteClusterRequest

@typing.final
class DeleteClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the deleting Trino cluster."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___DeleteClusterMetadata = DeleteClusterMetadata

@typing.final
class StartClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Trino cluster that is being started."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___StartClusterRequest = StartClusterRequest

@typing.final
class StartClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Trino cluster."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___StartClusterMetadata = StartClusterMetadata

@typing.final
class StopClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Trino cluster that is being stopped."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___StopClusterRequest = StopClusterRequest

@typing.final
class StopClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Trino cluster."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___StopClusterMetadata = StopClusterMetadata

@typing.final
class ListClusterOperationsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Trino Cluster resource to list operations for."""
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size], the service returns a [ListClusterOperationsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token.  To get the next page of results, set [page_token] to the [ListClusterOperationsResponse.next_page_token]
    returned by the previous list request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListClusterOperationsRequest = ListClusterOperationsRequest

@typing.final
class ListClusterOperationsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is larger than [ListClusterOperationsRequest.page_size], use the [next_page_token] as the value
    for the [ListClusterOperationsRequest.page_token] query parameter in the next list request.
    Each subsequent list request will have its own [next_page_token] to continue paging through the results.
    """
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.operation.operation_pb2.Operation]:
        """List of Operation resources for the specified Trino cluster."""

    def __init__(
        self,
        *,
        operations: collections.abc.Iterable[yandex.cloud.operation.operation_pb2.Operation] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "operations", b"operations"]) -> None: ...

global___ListClusterOperationsResponse = ListClusterOperationsResponse
