"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.timestamp_pb2
import typing
import yandex.cloud.video.v1.episode_pb2
import yandex.cloud.video.v1.manifest_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetEpisodeRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EPISODE_ID_FIELD_NUMBER: builtins.int
    episode_id: builtins.str
    """ID of the episode to retrieve."""
    def __init__(
        self,
        *,
        episode_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["episode_id", b"episode_id"]) -> None: ...

global___GetEpisodeRequest = GetEpisodeRequest

@typing.final
class ListEpisodesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STREAM_ID_FIELD_NUMBER: builtins.int
    LINE_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    stream_id: builtins.str
    """ID of the stream containing the episodes to list."""
    line_id: builtins.str
    """ID of the stream line containing the episodes to list."""
    page_size: builtins.int
    """The maximum number of episodes to return per page."""
    page_token: builtins.str
    """Page token for retrieving the next page of results.
    This token is obtained from the next_page_token field in the previous ListEpisodesResponse.
    """
    order_by: builtins.str
    """Specifies the ordering of results.
    Format is "<field> <order>" (e.g., "createdAt desc").
    Default: "id asc".
    Supported fields: ["id", "createdAt", "updatedAt"].
    Both snake_case and camelCase field names are supported.
    """
    filter: builtins.str
    """Filter expression to narrow down the list of returned episodes.
    Expressions consist of terms connected by logical operators.
    Values containing spaces or quotes must be enclosed in quotes (`'` or `"`)
    with inner quotes being backslash-escaped.

    Supported logical operators: ["AND", "OR"].
    Supported comparison operators: ["=", "!=", ":"] where ":" enables substring matching.
    Parentheses can be used to group logical expressions.

    Example: `title:'highlight' AND id='episode-1'`

    Filterable fields: ["id", "title"].
    Both snake_case and camelCase field names are supported.
    """
    def __init__(
        self,
        *,
        stream_id: builtins.str = ...,
        line_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        order_by: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["line_id", b"line_id", "parent_id", b"parent_id", "stream_id", b"stream_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "line_id", b"line_id", "order_by", b"order_by", "page_size", b"page_size", "page_token", b"page_token", "parent_id", b"parent_id", "stream_id", b"stream_id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["parent_id", b"parent_id"]) -> typing.Literal["stream_id", "line_id"] | None: ...

global___ListEpisodesRequest = ListEpisodesRequest

@typing.final
class ListEpisodesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EPISODES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for retrieving the next page of results.
    Empty if there are no more results available.
    """
    @property
    def episodes(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.video.v1.episode_pb2.Episode]:
        """List of episodes matching the request criteria.
        May be empty if no episodes match the criteria or if the parent resource has no episodes.
        """

    def __init__(
        self,
        *,
        episodes: collections.abc.Iterable[yandex.cloud.video.v1.episode_pb2.Episode] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["episodes", b"episodes", "next_page_token", b"next_page_token"]) -> None: ...

global___ListEpisodesResponse = ListEpisodesResponse

@typing.final
class BatchGetEpisodesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_ID_FIELD_NUMBER: builtins.int
    EPISODE_IDS_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    """ID of the channel containing the episodes to retrieve."""
    @property
    def episode_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of episode IDs to retrieve."""

    def __init__(
        self,
        *,
        channel_id: builtins.str = ...,
        episode_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "episode_ids", b"episode_ids"]) -> None: ...

global___BatchGetEpisodesRequest = BatchGetEpisodesRequest

@typing.final
class BatchGetEpisodesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EPISODES_FIELD_NUMBER: builtins.int
    @property
    def episodes(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.video.v1.episode_pb2.Episode]:
        """List of episodes matching the requested IDs."""

    def __init__(
        self,
        *,
        episodes: collections.abc.Iterable[yandex.cloud.video.v1.episode_pb2.Episode] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["episodes", b"episodes"]) -> None: ...

global___BatchGetEpisodesResponse = BatchGetEpisodesResponse

@typing.final
class CreateEpisodeRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STREAM_ID_FIELD_NUMBER: builtins.int
    LINE_ID_FIELD_NUMBER: builtins.int
    TITLE_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    THUMBNAIL_ID_FIELD_NUMBER: builtins.int
    START_TIME_FIELD_NUMBER: builtins.int
    FINISH_TIME_FIELD_NUMBER: builtins.int
    DVR_SECONDS_FIELD_NUMBER: builtins.int
    STYLE_PRESET_ID_FIELD_NUMBER: builtins.int
    PUBLIC_ACCESS_FIELD_NUMBER: builtins.int
    SIGN_URL_ACCESS_FIELD_NUMBER: builtins.int
    stream_id: builtins.str
    """ID of the stream."""
    line_id: builtins.str
    """ID of the line."""
    title: builtins.str
    """Episode title."""
    description: builtins.str
    """Episode description."""
    thumbnail_id: builtins.str
    """ID of the thumbnail."""
    dvr_seconds: builtins.int
    """Enables episode DVR mode.
    Determines how many last seconds of the stream are available.

    Possible values:
     * `0`: infinite dvr size, the full length of the stream allowed to display
     * `>0`: size of dvr window in seconds, the minimum value is 30s
    """
    style_preset_id: builtins.str
    """ID of the style preset."""
    @property
    def start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Episode start time."""

    @property
    def finish_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Episode finish time."""

    @property
    def public_access(self) -> global___EpisodePublicAccessParams:
        """Episode is publicly available."""

    @property
    def sign_url_access(self) -> global___EpisodeSignURLAccessParams:
        """Access to the episode is restricted by temporarily signed links."""

    def __init__(
        self,
        *,
        stream_id: builtins.str = ...,
        line_id: builtins.str = ...,
        title: builtins.str = ...,
        description: builtins.str = ...,
        thumbnail_id: builtins.str = ...,
        start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        finish_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        dvr_seconds: builtins.int = ...,
        style_preset_id: builtins.str = ...,
        public_access: global___EpisodePublicAccessParams | None = ...,
        sign_url_access: global___EpisodeSignURLAccessParams | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["access_rights", b"access_rights", "finish_time", b"finish_time", "line_id", b"line_id", "parent_id", b"parent_id", "public_access", b"public_access", "sign_url_access", b"sign_url_access", "start_time", b"start_time", "stream_id", b"stream_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["access_rights", b"access_rights", "description", b"description", "dvr_seconds", b"dvr_seconds", "finish_time", b"finish_time", "line_id", b"line_id", "parent_id", b"parent_id", "public_access", b"public_access", "sign_url_access", b"sign_url_access", "start_time", b"start_time", "stream_id", b"stream_id", "style_preset_id", b"style_preset_id", "thumbnail_id", b"thumbnail_id", "title", b"title"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["access_rights", b"access_rights"]) -> typing.Literal["public_access", "sign_url_access"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["parent_id", b"parent_id"]) -> typing.Literal["stream_id", "line_id"] | None: ...

global___CreateEpisodeRequest = CreateEpisodeRequest

@typing.final
class EpisodePublicAccessParams(google.protobuf.message.Message):
    """Parameters for episode public access rights."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___EpisodePublicAccessParams = EpisodePublicAccessParams

@typing.final
class EpisodeSignURLAccessParams(google.protobuf.message.Message):
    """Parameters for episode access restrictions based on temporary signed links."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___EpisodeSignURLAccessParams = EpisodeSignURLAccessParams

@typing.final
class CreateEpisodeMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EPISODE_ID_FIELD_NUMBER: builtins.int
    episode_id: builtins.str
    """ID of the episode being created."""
    def __init__(
        self,
        *,
        episode_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["episode_id", b"episode_id"]) -> None: ...

global___CreateEpisodeMetadata = CreateEpisodeMetadata

@typing.final
class UpdateEpisodeRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EPISODE_ID_FIELD_NUMBER: builtins.int
    FIELD_MASK_FIELD_NUMBER: builtins.int
    TITLE_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    THUMBNAIL_ID_FIELD_NUMBER: builtins.int
    START_TIME_FIELD_NUMBER: builtins.int
    FINISH_TIME_FIELD_NUMBER: builtins.int
    DVR_SECONDS_FIELD_NUMBER: builtins.int
    STYLE_PRESET_ID_FIELD_NUMBER: builtins.int
    PUBLIC_ACCESS_FIELD_NUMBER: builtins.int
    SIGN_URL_ACCESS_FIELD_NUMBER: builtins.int
    episode_id: builtins.str
    """ID of the episode."""
    title: builtins.str
    """Episode title."""
    description: builtins.str
    """Episode description."""
    thumbnail_id: builtins.str
    """ID of the thumbnail."""
    dvr_seconds: builtins.int
    """Enables episode DVR mode.
    Determines how many last seconds of the stream are available.

    Possible values:
     * `0`: infinite dvr size, the full length of the stream allowed to display
     * `>0`: size of dvr window in seconds, the minimum value is 30s
    """
    style_preset_id: builtins.str
    """New ID of the style preset to be applied to the episode player."""
    @property
    def field_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask specifying which fields of the episode should be updated.
        Only fields specified in this mask will be modified;
        all other fields will retain their current values.
        This allows for partial updates.
        """

    @property
    def start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Episode start time."""

    @property
    def finish_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Episode finish time."""

    @property
    def public_access(self) -> global___EpisodePublicAccessParams:
        """Episode is publicly available."""

    @property
    def sign_url_access(self) -> global___EpisodeSignURLAccessParams:
        """Access to the episode is restricted by temporarily signed links."""

    def __init__(
        self,
        *,
        episode_id: builtins.str = ...,
        field_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        title: builtins.str = ...,
        description: builtins.str = ...,
        thumbnail_id: builtins.str = ...,
        start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        finish_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        dvr_seconds: builtins.int = ...,
        style_preset_id: builtins.str = ...,
        public_access: global___EpisodePublicAccessParams | None = ...,
        sign_url_access: global___EpisodeSignURLAccessParams | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["access_rights", b"access_rights", "field_mask", b"field_mask", "finish_time", b"finish_time", "public_access", b"public_access", "sign_url_access", b"sign_url_access", "start_time", b"start_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["access_rights", b"access_rights", "description", b"description", "dvr_seconds", b"dvr_seconds", "episode_id", b"episode_id", "field_mask", b"field_mask", "finish_time", b"finish_time", "public_access", b"public_access", "sign_url_access", b"sign_url_access", "start_time", b"start_time", "style_preset_id", b"style_preset_id", "thumbnail_id", b"thumbnail_id", "title", b"title"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["access_rights", b"access_rights"]) -> typing.Literal["public_access", "sign_url_access"] | None: ...

global___UpdateEpisodeRequest = UpdateEpisodeRequest

@typing.final
class UpdateEpisodeMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EPISODE_ID_FIELD_NUMBER: builtins.int
    episode_id: builtins.str
    """ID of the episode being updated."""
    def __init__(
        self,
        *,
        episode_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["episode_id", b"episode_id"]) -> None: ...

global___UpdateEpisodeMetadata = UpdateEpisodeMetadata

@typing.final
class DeleteEpisodeRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EPISODE_ID_FIELD_NUMBER: builtins.int
    episode_id: builtins.str
    """ID of the episode to delete."""
    def __init__(
        self,
        *,
        episode_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["episode_id", b"episode_id"]) -> None: ...

global___DeleteEpisodeRequest = DeleteEpisodeRequest

@typing.final
class DeleteEpisodeMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EPISODE_ID_FIELD_NUMBER: builtins.int
    episode_id: builtins.str
    """ID of the episode being deleted.
    This identifier can be used to track the episode deletion operation.
    """
    def __init__(
        self,
        *,
        episode_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["episode_id", b"episode_id"]) -> None: ...

global___DeleteEpisodeMetadata = DeleteEpisodeMetadata

@typing.final
class BatchDeleteEpisodesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STREAM_ID_FIELD_NUMBER: builtins.int
    LINE_ID_FIELD_NUMBER: builtins.int
    EPISODE_IDS_FIELD_NUMBER: builtins.int
    stream_id: builtins.str
    """ID of the stream containing the episodes to delete."""
    line_id: builtins.str
    """ID of the stream line containing the episodes to delete."""
    @property
    def episode_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of episode IDs to delete.
        All episodes must exist and be linked to the specified parent resource.
        """

    def __init__(
        self,
        *,
        stream_id: builtins.str = ...,
        line_id: builtins.str = ...,
        episode_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["id", b"id", "line_id", b"line_id", "stream_id", b"stream_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["episode_ids", b"episode_ids", "id", b"id", "line_id", b"line_id", "stream_id", b"stream_id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["id", b"id"]) -> typing.Literal["stream_id", "line_id"] | None: ...

global___BatchDeleteEpisodesRequest = BatchDeleteEpisodesRequest

@typing.final
class BatchDeleteEpisodesMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EPISODE_IDS_FIELD_NUMBER: builtins.int
    @property
    def episode_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of episode IDs being deleted.
        This list can be used to track which episodes are included
        in the batch deletion operation.
        """

    def __init__(
        self,
        *,
        episode_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["episode_ids", b"episode_ids"]) -> None: ...

global___BatchDeleteEpisodesMetadata = BatchDeleteEpisodesMetadata

@typing.final
class PerformEpisodeActionRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EPISODE_ID_FIELD_NUMBER: builtins.int
    PUBLISH_FIELD_NUMBER: builtins.int
    UNPUBLISH_FIELD_NUMBER: builtins.int
    episode_id: builtins.str
    """ID of the episode on which to perform the action."""
    @property
    def publish(self) -> global___PublishEpisodeAction:
        """Publish the episode, making it available for watching.
        Changes the episode's visibility status to PUBLISHED.
        """

    @property
    def unpublish(self) -> global___UnpublishEpisodeAction:
        """Unpublish the episode, making it unavailable for watching.
        Changes the episode's visibility status to UNPUBLISHED.
        """

    def __init__(
        self,
        *,
        episode_id: builtins.str = ...,
        publish: global___PublishEpisodeAction | None = ...,
        unpublish: global___UnpublishEpisodeAction | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["action", b"action", "publish", b"publish", "unpublish", b"unpublish"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["action", b"action", "episode_id", b"episode_id", "publish", b"publish", "unpublish", b"unpublish"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["action", b"action"]) -> typing.Literal["publish", "unpublish"] | None: ...

global___PerformEpisodeActionRequest = PerformEpisodeActionRequest

@typing.final
class PublishEpisodeAction(google.protobuf.message.Message):
    """Parameters for the publish action."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___PublishEpisodeAction = PublishEpisodeAction

@typing.final
class UnpublishEpisodeAction(google.protobuf.message.Message):
    """Parameters for the unpublish action."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___UnpublishEpisodeAction = UnpublishEpisodeAction

@typing.final
class PerformEpisodeActionMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EPISODE_ID_FIELD_NUMBER: builtins.int
    episode_id: builtins.str
    """ID of the episode on which the action is being performed.
    This identifier can be used to track the action operation
    and to verify that the action is being applied to the correct episode.
    """
    def __init__(
        self,
        *,
        episode_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["episode_id", b"episode_id"]) -> None: ...

global___PerformEpisodeActionMetadata = PerformEpisodeActionMetadata

@typing.final
class GetEpisodePlayerURLRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EPISODE_ID_FIELD_NUMBER: builtins.int
    PARAMS_FIELD_NUMBER: builtins.int
    SIGNED_URL_EXPIRATION_DURATION_FIELD_NUMBER: builtins.int
    episode_id: builtins.str
    """ID of the episode for which to generate a player URL."""
    @property
    def params(self) -> global___EpisodePlayerParams:
        """Optional player parameters to customize the playback experience.
        These parameters control initial player state such as mute, autoplay, and visibility of interface controls.
        """

    @property
    def signed_url_expiration_duration(self) -> google.protobuf.duration_pb2.Duration:
        """For episodes with signed URL access, specifies how long the generated URL will be valid.
        If not provided, a default expiration duration will be used.
        """

    def __init__(
        self,
        *,
        episode_id: builtins.str = ...,
        params: global___EpisodePlayerParams | None = ...,
        signed_url_expiration_duration: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["params", b"params", "signed_url_expiration_duration", b"signed_url_expiration_duration"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["episode_id", b"episode_id", "params", b"params", "signed_url_expiration_duration", b"signed_url_expiration_duration"]) -> None: ...

global___GetEpisodePlayerURLRequest = GetEpisodePlayerURLRequest

@typing.final
class EpisodePlayerParams(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MUTE_FIELD_NUMBER: builtins.int
    AUTOPLAY_FIELD_NUMBER: builtins.int
    HIDDEN_FIELD_NUMBER: builtins.int
    mute: builtins.bool
    """If true, the player will start with audio muted.
    Users can unmute the audio manually after playback starts.
    """
    autoplay: builtins.bool
    """If true, the episode will start playing automatically when the player loads.
    This may be subject to browser autoplay policies that restrict autoplay with sound.
    """
    hidden: builtins.bool
    """If true, the player interface controls will be hidden initially.
    Users can typically reveal the controls by moving the mouse over the player.
    """
    def __init__(
        self,
        *,
        mute: builtins.bool = ...,
        autoplay: builtins.bool = ...,
        hidden: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["autoplay", b"autoplay", "hidden", b"hidden", "mute", b"mute"]) -> None: ...

global___EpisodePlayerParams = EpisodePlayerParams

@typing.final
class GetEpisodePlayerURLResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PLAYER_URL_FIELD_NUMBER: builtins.int
    HTML_FIELD_NUMBER: builtins.int
    player_url: builtins.str
    """Direct URL to the episode player.
    This URL can be used to access the episode in a web browser
    or shared with users who have appropriate permissions.
    """
    html: builtins.str
    """HTML embed code in iframe format that can be inserted into web pages.
    This code allows the episode to be embedded directly in third-party websites.
    """
    def __init__(
        self,
        *,
        player_url: builtins.str = ...,
        html: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["html", b"html", "player_url", b"player_url"]) -> None: ...

global___GetEpisodePlayerURLResponse = GetEpisodePlayerURLResponse

@typing.final
class GetEpisodeManifestsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EPISODE_ID_FIELD_NUMBER: builtins.int
    episode_id: builtins.str
    """ID of the episode for which to retrieve manifest URLs."""
    def __init__(
        self,
        *,
        episode_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["episode_id", b"episode_id"]) -> None: ...

global___GetEpisodeManifestsRequest = GetEpisodeManifestsRequest

@typing.final
class GetEpisodeManifestsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MANIFESTS_FIELD_NUMBER: builtins.int
    @property
    def manifests(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.video.v1.manifest_pb2.Manifest]:
        """List of manifests available for the episode.
        Different manifests may represent different streaming formats (e.g., HLS, DASH)
        """

    def __init__(
        self,
        *,
        manifests: collections.abc.Iterable[yandex.cloud.video.v1.manifest_pb2.Manifest] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["manifests", b"manifests"]) -> None: ...

global___GetEpisodeManifestsResponse = GetEpisodeManifestsResponse
