"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import abc
import collections.abc
import grpc
import grpc.aio
import typing
import yandex.cloud.operation.operation_pb2
import yandex.cloud.video.v1.episode_pb2
import yandex.cloud.video.v1.episode_service_pb2

_T = typing.TypeVar("_T")

class _MaybeAsyncIterator(collections.abc.AsyncIterator[_T], collections.abc.Iterator[_T], metaclass=abc.ABCMeta): ...

class _ServicerContext(grpc.ServicerContext, grpc.aio.ServicerContext):  # type: ignore[misc, type-arg]
    ...

class EpisodeServiceStub:
    """Episode management service.
    Provides methods for creating, retrieving, updating, and deleting episodes,
    which represent specific time segments of streams
    that can be individually accessed, managed, and published.
    """

    def __init__(self, channel: typing.Union[grpc.Channel, grpc.aio.Channel]) -> None: ...
    Get: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.episode_service_pb2.GetEpisodeRequest,
        yandex.cloud.video.v1.episode_pb2.Episode,
    ]
    """Retrieves detailed information about a specific episode by its ID.
    Returns all episode metadata, status, and related information.
    """

    List: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.episode_service_pb2.ListEpisodesRequest,
        yandex.cloud.video.v1.episode_service_pb2.ListEpisodesResponse,
    ]
    """Lists all episodes associated with a specific stream or stream line with pagination support.
    Results can be filtered and sorted using the provided parameters.
    """

    BatchGet: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.episode_service_pb2.BatchGetEpisodesRequest,
        yandex.cloud.video.v1.episode_service_pb2.BatchGetEpisodesResponse,
    ]
    """Retrieves multiple episodes by their IDs in a specific channel in a single request.
    This is more efficient than making multiple Get requests when retrieving several episodes.
    """

    Create: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.episode_service_pb2.CreateEpisodeRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Creates a new episode associated with a stream or stream line.
    Episodes can be configured with various settings including title, description,
    time boundaries, and access rights.
    """

    Update: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.episode_service_pb2.UpdateEpisodeRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates an existing episode's metadata and settings.
    Only fields specified in the field_mask will be updated.
    """

    Delete: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.episode_service_pb2.DeleteEpisodeRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Deletes a specific episode by its ID."""

    BatchDelete: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.episode_service_pb2.BatchDeleteEpisodesRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Deletes multiple episodes associated with a specific stream or stream line in a single request.
    This is more efficient than making multiple Delete requests when removing several episodes.
    """

    PerformAction: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.episode_service_pb2.PerformEpisodeActionRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Performs a specific action on an episode, such as publishing or unpublishing."""

    GetPlayerURL: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.episode_service_pb2.GetEpisodePlayerURLRequest,
        yandex.cloud.video.v1.episode_service_pb2.GetEpisodePlayerURLResponse,
    ]
    """Generates a player URL for watching the episode.
    The URL can include player parameters such as autoplay, mute, and visibility of interface controls.
    For episodes with signed URL access, an expiration duration can be specified.
    """

    GetManifests: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.episode_service_pb2.GetEpisodeManifestsRequest,
        yandex.cloud.video.v1.episode_service_pb2.GetEpisodeManifestsResponse,
    ]
    """Retrieves the manifest URLs for the episode's media content.
    Manifests provide players with necessary information
    for streaming the content with different quality levels and formats.
    """

class EpisodeServiceAsyncStub:
    """Episode management service.
    Provides methods for creating, retrieving, updating, and deleting episodes,
    which represent specific time segments of streams
    that can be individually accessed, managed, and published.
    """

    Get: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.episode_service_pb2.GetEpisodeRequest,
        yandex.cloud.video.v1.episode_pb2.Episode,
    ]
    """Retrieves detailed information about a specific episode by its ID.
    Returns all episode metadata, status, and related information.
    """

    List: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.episode_service_pb2.ListEpisodesRequest,
        yandex.cloud.video.v1.episode_service_pb2.ListEpisodesResponse,
    ]
    """Lists all episodes associated with a specific stream or stream line with pagination support.
    Results can be filtered and sorted using the provided parameters.
    """

    BatchGet: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.episode_service_pb2.BatchGetEpisodesRequest,
        yandex.cloud.video.v1.episode_service_pb2.BatchGetEpisodesResponse,
    ]
    """Retrieves multiple episodes by their IDs in a specific channel in a single request.
    This is more efficient than making multiple Get requests when retrieving several episodes.
    """

    Create: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.episode_service_pb2.CreateEpisodeRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Creates a new episode associated with a stream or stream line.
    Episodes can be configured with various settings including title, description,
    time boundaries, and access rights.
    """

    Update: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.episode_service_pb2.UpdateEpisodeRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates an existing episode's metadata and settings.
    Only fields specified in the field_mask will be updated.
    """

    Delete: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.episode_service_pb2.DeleteEpisodeRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Deletes a specific episode by its ID."""

    BatchDelete: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.episode_service_pb2.BatchDeleteEpisodesRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Deletes multiple episodes associated with a specific stream or stream line in a single request.
    This is more efficient than making multiple Delete requests when removing several episodes.
    """

    PerformAction: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.episode_service_pb2.PerformEpisodeActionRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Performs a specific action on an episode, such as publishing or unpublishing."""

    GetPlayerURL: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.episode_service_pb2.GetEpisodePlayerURLRequest,
        yandex.cloud.video.v1.episode_service_pb2.GetEpisodePlayerURLResponse,
    ]
    """Generates a player URL for watching the episode.
    The URL can include player parameters such as autoplay, mute, and visibility of interface controls.
    For episodes with signed URL access, an expiration duration can be specified.
    """

    GetManifests: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.episode_service_pb2.GetEpisodeManifestsRequest,
        yandex.cloud.video.v1.episode_service_pb2.GetEpisodeManifestsResponse,
    ]
    """Retrieves the manifest URLs for the episode's media content.
    Manifests provide players with necessary information
    for streaming the content with different quality levels and formats.
    """

class EpisodeServiceServicer(metaclass=abc.ABCMeta):
    """Episode management service.
    Provides methods for creating, retrieving, updating, and deleting episodes,
    which represent specific time segments of streams
    that can be individually accessed, managed, and published.
    """

    @abc.abstractmethod
    def Get(
        self,
        request: yandex.cloud.video.v1.episode_service_pb2.GetEpisodeRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.video.v1.episode_pb2.Episode, collections.abc.Awaitable[yandex.cloud.video.v1.episode_pb2.Episode]]:
        """Retrieves detailed information about a specific episode by its ID.
        Returns all episode metadata, status, and related information.
        """

    @abc.abstractmethod
    def List(
        self,
        request: yandex.cloud.video.v1.episode_service_pb2.ListEpisodesRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.video.v1.episode_service_pb2.ListEpisodesResponse, collections.abc.Awaitable[yandex.cloud.video.v1.episode_service_pb2.ListEpisodesResponse]]:
        """Lists all episodes associated with a specific stream or stream line with pagination support.
        Results can be filtered and sorted using the provided parameters.
        """

    @abc.abstractmethod
    def BatchGet(
        self,
        request: yandex.cloud.video.v1.episode_service_pb2.BatchGetEpisodesRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.video.v1.episode_service_pb2.BatchGetEpisodesResponse, collections.abc.Awaitable[yandex.cloud.video.v1.episode_service_pb2.BatchGetEpisodesResponse]]:
        """Retrieves multiple episodes by their IDs in a specific channel in a single request.
        This is more efficient than making multiple Get requests when retrieving several episodes.
        """

    @abc.abstractmethod
    def Create(
        self,
        request: yandex.cloud.video.v1.episode_service_pb2.CreateEpisodeRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Creates a new episode associated with a stream or stream line.
        Episodes can be configured with various settings including title, description,
        time boundaries, and access rights.
        """

    @abc.abstractmethod
    def Update(
        self,
        request: yandex.cloud.video.v1.episode_service_pb2.UpdateEpisodeRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Updates an existing episode's metadata and settings.
        Only fields specified in the field_mask will be updated.
        """

    @abc.abstractmethod
    def Delete(
        self,
        request: yandex.cloud.video.v1.episode_service_pb2.DeleteEpisodeRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Deletes a specific episode by its ID."""

    @abc.abstractmethod
    def BatchDelete(
        self,
        request: yandex.cloud.video.v1.episode_service_pb2.BatchDeleteEpisodesRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Deletes multiple episodes associated with a specific stream or stream line in a single request.
        This is more efficient than making multiple Delete requests when removing several episodes.
        """

    @abc.abstractmethod
    def PerformAction(
        self,
        request: yandex.cloud.video.v1.episode_service_pb2.PerformEpisodeActionRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Performs a specific action on an episode, such as publishing or unpublishing."""

    @abc.abstractmethod
    def GetPlayerURL(
        self,
        request: yandex.cloud.video.v1.episode_service_pb2.GetEpisodePlayerURLRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.video.v1.episode_service_pb2.GetEpisodePlayerURLResponse, collections.abc.Awaitable[yandex.cloud.video.v1.episode_service_pb2.GetEpisodePlayerURLResponse]]:
        """Generates a player URL for watching the episode.
        The URL can include player parameters such as autoplay, mute, and visibility of interface controls.
        For episodes with signed URL access, an expiration duration can be specified.
        """

    @abc.abstractmethod
    def GetManifests(
        self,
        request: yandex.cloud.video.v1.episode_service_pb2.GetEpisodeManifestsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.video.v1.episode_service_pb2.GetEpisodeManifestsResponse, collections.abc.Awaitable[yandex.cloud.video.v1.episode_service_pb2.GetEpisodeManifestsResponse]]:
        """Retrieves the manifest URLs for the episode's media content.
        Manifests provide players with necessary information
        for streaming the content with different quality levels and formats.
        """

def add_EpisodeServiceServicer_to_server(servicer: EpisodeServiceServicer, server: typing.Union[grpc.Server, grpc.aio.Server]) -> None: ...
