"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import google.protobuf.wrappers_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Stream(google.protobuf.message.Message):
    """Entity representing a live video stream.
    A stream is a real-time video broadcast linked to a specific stream line.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _StreamStatus:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StreamStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Stream._StreamStatus.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STREAM_STATUS_UNSPECIFIED: Stream._StreamStatus.ValueType  # 0
        """The stream status is not specified."""
        OFFLINE: Stream._StreamStatus.ValueType  # 1
        """The stream is offline and not broadcasting."""
        PREPARING: Stream._StreamStatus.ValueType  # 2
        """The system is preparing the infrastructure for receiving the video signal."""
        READY: Stream._StreamStatus.ValueType  # 3
        """The infrastructure is ready to launch the stream."""
        ONAIR: Stream._StreamStatus.ValueType  # 4
        """The stream is currently broadcasting live."""
        FINISHED: Stream._StreamStatus.ValueType  # 5
        """The stream has completed and is no longer broadcasting."""

    class StreamStatus(_StreamStatus, metaclass=_StreamStatusEnumTypeWrapper):
        """Current status of the stream."""

    STREAM_STATUS_UNSPECIFIED: Stream.StreamStatus.ValueType  # 0
    """The stream status is not specified."""
    OFFLINE: Stream.StreamStatus.ValueType  # 1
    """The stream is offline and not broadcasting."""
    PREPARING: Stream.StreamStatus.ValueType  # 2
    """The system is preparing the infrastructure for receiving the video signal."""
    READY: Stream.StreamStatus.ValueType  # 3
    """The infrastructure is ready to launch the stream."""
    ONAIR: Stream.StreamStatus.ValueType  # 4
    """The stream is currently broadcasting live."""
    FINISHED: Stream.StreamStatus.ValueType  # 5
    """The stream has completed and is no longer broadcasting."""

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    LINE_ID_FIELD_NUMBER: builtins.int
    TITLE_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    THUMBNAIL_ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    START_TIME_FIELD_NUMBER: builtins.int
    PUBLISH_TIME_FIELD_NUMBER: builtins.int
    FINISH_TIME_FIELD_NUMBER: builtins.int
    AUTO_PUBLISH_FIELD_NUMBER: builtins.int
    ON_DEMAND_FIELD_NUMBER: builtins.int
    SCHEDULE_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    UPDATED_AT_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Unique identifier of the stream."""
    channel_id: builtins.str
    """Identifier of the channel where the stream is created and managed."""
    line_id: builtins.str
    """Identifier of the stream line to which this stream is linked."""
    title: builtins.str
    """Title of the stream displayed in interfaces and players."""
    description: builtins.str
    """Detailed description of the stream content and context."""
    thumbnail_id: builtins.str
    """Identifier of the thumbnail image used to represent the stream visually."""
    status: global___Stream.StreamStatus.ValueType
    """Current status of the stream."""
    @property
    def start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp when the stream was initiated."""

    @property
    def publish_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp when the stream was published (switched to ONAIR status)."""

    @property
    def finish_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp when the stream was completed."""

    @property
    def auto_publish(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Controls automatic publishing of the stream when it's ready.
        When set to true, automatically switches status from READY to ONAIR.
        """

    @property
    def on_demand(self) -> global___OnDemand:
        """On-demand stream starts immediately when a video signal appears."""

    @property
    def schedule(self) -> global___Schedule:
        """Scheduled stream starts and finishes at specified time."""

    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp when the stream was initially created in the system."""

    @property
    def updated_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp of the last modification to the stream or its metadata."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Custom user-defined labels as `key:value` pairs.
        Maximum 64 labels per stream.
        Used for organization, filtering, and metadata purposes.
        Labels can be used for organization, filtering, and metadata purposes.
        """

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        channel_id: builtins.str = ...,
        line_id: builtins.str = ...,
        title: builtins.str = ...,
        description: builtins.str = ...,
        thumbnail_id: builtins.str = ...,
        status: global___Stream.StreamStatus.ValueType = ...,
        start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        publish_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        finish_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        auto_publish: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        on_demand: global___OnDemand | None = ...,
        schedule: global___Schedule | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        updated_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["auto_publish", b"auto_publish", "created_at", b"created_at", "finish_time", b"finish_time", "on_demand", b"on_demand", "publish_time", b"publish_time", "schedule", b"schedule", "start_time", b"start_time", "stream_type", b"stream_type", "updated_at", b"updated_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["auto_publish", b"auto_publish", "channel_id", b"channel_id", "created_at", b"created_at", "description", b"description", "finish_time", b"finish_time", "id", b"id", "labels", b"labels", "line_id", b"line_id", "on_demand", b"on_demand", "publish_time", b"publish_time", "schedule", b"schedule", "start_time", b"start_time", "status", b"status", "stream_type", b"stream_type", "thumbnail_id", b"thumbnail_id", "title", b"title", "updated_at", b"updated_at"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["stream_type", b"stream_type"]) -> typing.Literal["on_demand", "schedule"] | None: ...

global___Stream = Stream

@typing.final
class OnDemand(google.protobuf.message.Message):
    """Represents an on-demand stream type.
    This type of stream must be started and finished explicitly by the user.
    It begins broadcasting immediately when a video signal is detected.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___OnDemand = OnDemand

@typing.final
class Schedule(google.protobuf.message.Message):
    """Represents a scheduled stream type.
    This type of stream starts and finishes automatically at specified time.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    START_TIME_FIELD_NUMBER: builtins.int
    FINISH_TIME_FIELD_NUMBER: builtins.int
    @property
    def start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Scheduled time when the stream should automatically start."""

    @property
    def finish_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Scheduled time when the stream should automatically finish."""

    def __init__(
        self,
        *,
        start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        finish_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["finish_time", b"finish_time", "start_time", b"start_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["finish_time", b"finish_time", "start_time", b"start_time"]) -> None: ...

global___Schedule = Schedule
