"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import abc
import collections.abc
import grpc
import grpc.aio
import typing
import yandex.cloud.operation.operation_pb2
import yandex.cloud.video.v1.stream_pb2
import yandex.cloud.video.v1.stream_service_pb2

_T = typing.TypeVar("_T")

class _MaybeAsyncIterator(collections.abc.AsyncIterator[_T], collections.abc.Iterator[_T], metaclass=abc.ABCMeta): ...

class _ServicerContext(grpc.ServicerContext, grpc.aio.ServicerContext):  # type: ignore[misc, type-arg]
    ...

class StreamServiceStub:
    """Stream management service.
    Provides methods for creating, retrieving, updating, and deleting live streams,
    as well as managing stream-related operations
    such as publishing, stopping, and generating playback URLs.
    """

    def __init__(self, channel: typing.Union[grpc.Channel, grpc.aio.Channel]) -> None: ...
    Get: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.stream_service_pb2.GetStreamRequest,
        yandex.cloud.video.v1.stream_pb2.Stream,
    ]
    """Retrieves detailed information about a specific stream by its ID.
    Returns all stream metadata, status, and related information.
    """

    List: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.stream_service_pb2.ListStreamsRequest,
        yandex.cloud.video.v1.stream_service_pb2.ListStreamsResponse,
    ]
    """Lists all streams in a specific channel with pagination support.
    Results can be filtered and sorted using the provided parameters.
    """

    BatchGet: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.stream_service_pb2.BatchGetStreamsRequest,
        yandex.cloud.video.v1.stream_service_pb2.BatchGetStreamsResponse,
    ]
    """Retrieves multiple streams by their IDs in a specific channel in a single request.
    This is more efficient than making multiple Get requests when retrieving several streams.
    """

    Create: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.stream_service_pb2.CreateStreamRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Creates a new stream in the specified channel.
    Streams can be created as on-demand (starting when a signal appears)
    or scheduled (starting and finishing at specified time).
    """

    Update: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.stream_service_pb2.UpdateStreamRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates an existing stream's metadata and settings.
    Only fields specified in the field_mask will be updated.
    """

    Delete: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.stream_service_pb2.DeleteStreamRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Deletes a specific stream by its ID."""

    BatchDelete: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.stream_service_pb2.BatchDeleteStreamsRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Deletes multiple streams in a specific channel in a single request.
    This is more efficient than making multiple Delete requests when removing several streams.
    """

    PerformAction: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.stream_service_pb2.PerformStreamActionRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Performs a specific action on a stream, such as publishing or stopping.
    Actions change the stream's state without modifying its content or metadata.
    """

class StreamServiceAsyncStub:
    """Stream management service.
    Provides methods for creating, retrieving, updating, and deleting live streams,
    as well as managing stream-related operations
    such as publishing, stopping, and generating playback URLs.
    """

    Get: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.stream_service_pb2.GetStreamRequest,
        yandex.cloud.video.v1.stream_pb2.Stream,
    ]
    """Retrieves detailed information about a specific stream by its ID.
    Returns all stream metadata, status, and related information.
    """

    List: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.stream_service_pb2.ListStreamsRequest,
        yandex.cloud.video.v1.stream_service_pb2.ListStreamsResponse,
    ]
    """Lists all streams in a specific channel with pagination support.
    Results can be filtered and sorted using the provided parameters.
    """

    BatchGet: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.stream_service_pb2.BatchGetStreamsRequest,
        yandex.cloud.video.v1.stream_service_pb2.BatchGetStreamsResponse,
    ]
    """Retrieves multiple streams by their IDs in a specific channel in a single request.
    This is more efficient than making multiple Get requests when retrieving several streams.
    """

    Create: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.stream_service_pb2.CreateStreamRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Creates a new stream in the specified channel.
    Streams can be created as on-demand (starting when a signal appears)
    or scheduled (starting and finishing at specified time).
    """

    Update: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.stream_service_pb2.UpdateStreamRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates an existing stream's metadata and settings.
    Only fields specified in the field_mask will be updated.
    """

    Delete: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.stream_service_pb2.DeleteStreamRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Deletes a specific stream by its ID."""

    BatchDelete: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.stream_service_pb2.BatchDeleteStreamsRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Deletes multiple streams in a specific channel in a single request.
    This is more efficient than making multiple Delete requests when removing several streams.
    """

    PerformAction: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.stream_service_pb2.PerformStreamActionRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Performs a specific action on a stream, such as publishing or stopping.
    Actions change the stream's state without modifying its content or metadata.
    """

class StreamServiceServicer(metaclass=abc.ABCMeta):
    """Stream management service.
    Provides methods for creating, retrieving, updating, and deleting live streams,
    as well as managing stream-related operations
    such as publishing, stopping, and generating playback URLs.
    """

    @abc.abstractmethod
    def Get(
        self,
        request: yandex.cloud.video.v1.stream_service_pb2.GetStreamRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.video.v1.stream_pb2.Stream, collections.abc.Awaitable[yandex.cloud.video.v1.stream_pb2.Stream]]:
        """Retrieves detailed information about a specific stream by its ID.
        Returns all stream metadata, status, and related information.
        """

    @abc.abstractmethod
    def List(
        self,
        request: yandex.cloud.video.v1.stream_service_pb2.ListStreamsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.video.v1.stream_service_pb2.ListStreamsResponse, collections.abc.Awaitable[yandex.cloud.video.v1.stream_service_pb2.ListStreamsResponse]]:
        """Lists all streams in a specific channel with pagination support.
        Results can be filtered and sorted using the provided parameters.
        """

    @abc.abstractmethod
    def BatchGet(
        self,
        request: yandex.cloud.video.v1.stream_service_pb2.BatchGetStreamsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.video.v1.stream_service_pb2.BatchGetStreamsResponse, collections.abc.Awaitable[yandex.cloud.video.v1.stream_service_pb2.BatchGetStreamsResponse]]:
        """Retrieves multiple streams by their IDs in a specific channel in a single request.
        This is more efficient than making multiple Get requests when retrieving several streams.
        """

    @abc.abstractmethod
    def Create(
        self,
        request: yandex.cloud.video.v1.stream_service_pb2.CreateStreamRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Creates a new stream in the specified channel.
        Streams can be created as on-demand (starting when a signal appears)
        or scheduled (starting and finishing at specified time).
        """

    @abc.abstractmethod
    def Update(
        self,
        request: yandex.cloud.video.v1.stream_service_pb2.UpdateStreamRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Updates an existing stream's metadata and settings.
        Only fields specified in the field_mask will be updated.
        """

    @abc.abstractmethod
    def Delete(
        self,
        request: yandex.cloud.video.v1.stream_service_pb2.DeleteStreamRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Deletes a specific stream by its ID."""

    @abc.abstractmethod
    def BatchDelete(
        self,
        request: yandex.cloud.video.v1.stream_service_pb2.BatchDeleteStreamsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Deletes multiple streams in a specific channel in a single request.
        This is more efficient than making multiple Delete requests when removing several streams.
        """

    @abc.abstractmethod
    def PerformAction(
        self,
        request: yandex.cloud.video.v1.stream_service_pb2.PerformStreamActionRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Performs a specific action on a stream, such as publishing or stopping.
        Actions change the stream's state without modifying its content or metadata.
        """

def add_StreamServiceServicer_to_server(servicer: StreamServiceServicer, server: typing.Union[grpc.Server, grpc.aio.Server]) -> None: ...
