"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class StylePreset(google.protobuf.message.Message):
    """Entity representing a collection of visual styling settings for content presentation.
    Style presets define the appearance of players, widgets, and other UI elements
    to ensure consistent branding and user experience.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _WidgetLocation:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _WidgetLocationEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[StylePreset._WidgetLocation.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        WIDGET_LOCATION_UNSPECIFIED: StylePreset._WidgetLocation.ValueType  # 0
        """The widget location is not specified."""
        RIGHT: StylePreset._WidgetLocation.ValueType  # 1
        """Position the widget to the right of the player."""
        BOTTOM: StylePreset._WidgetLocation.ValueType  # 2
        """Position the widget below the player."""

    class WidgetLocation(_WidgetLocation, metaclass=_WidgetLocationEnumTypeWrapper):
        """Widget position relative to the player."""

    WIDGET_LOCATION_UNSPECIFIED: StylePreset.WidgetLocation.ValueType  # 0
    """The widget location is not specified."""
    RIGHT: StylePreset.WidgetLocation.ValueType  # 1
    """Position the widget to the right of the player."""
    BOTTOM: StylePreset.WidgetLocation.ValueType  # 2
    """Position the widget below the player."""

    ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    TITLE_FIELD_NUMBER: builtins.int
    BACKGROUND_COLOR_FIELD_NUMBER: builtins.int
    WIDGET_TEXT_COLOR_PRIMARY_FIELD_NUMBER: builtins.int
    WIDGET_TEXT_COLOR_SECONDARY_FIELD_NUMBER: builtins.int
    WIDGET_ACCENT_COLOR_FIELD_NUMBER: builtins.int
    WIDGET_BLOCK_GAP_FIELD_NUMBER: builtins.int
    WIDGET_BLOCK_SEPARATOR_COLOR_FIELD_NUMBER: builtins.int
    PLAYER_BORDER_RADIUS_FIELD_NUMBER: builtins.int
    PLAYER_COLOR_FIELD_NUMBER: builtins.int
    PLAYLIST_SELECTED_ITEM_BACKGROUND_COLOR_FIELD_NUMBER: builtins.int
    PLAYLIST_ITEM_BORDER_RADIUS_FIELD_NUMBER: builtins.int
    PLAYLIST_ITEM_GAP_FIELD_NUMBER: builtins.int
    PLAYLIST_LOCATION_FIELD_NUMBER: builtins.int
    RIGHT_WIDGETS_FIELD_NUMBER: builtins.int
    BOTTOM_WIDGETS_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    UPDATED_AT_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Unique identifier of the style preset."""
    channel_id: builtins.str
    """Identifier of the channel where this style preset is created and managed."""
    title: builtins.str
    """Display name of the style preset shown in interfaces."""
    background_color: builtins.str
    """Background color for the player page in hexadecimal format (e.g., "#FFFFFF")."""
    widget_text_color_primary: builtins.str
    """Primary text color for widgets in hexadecimal format."""
    widget_text_color_secondary: builtins.str
    """Secondary text color for widgets in hexadecimal format."""
    widget_accent_color: builtins.str
    """Accent color for interactive elements in widgets in hexadecimal format."""
    widget_block_gap: builtins.int
    """Vertical spacing between widget blocks in pixels."""
    widget_block_separator_color: builtins.str
    """Color of separator lines between widget blocks in hexadecimal format."""
    player_border_radius: builtins.int
    """Corner radius of the player container in pixels."""
    player_color: builtins.str
    """Primary color for player controls in hexadecimal format."""
    playlist_selected_item_background_color: builtins.str
    """Background color for the currently selected item in playlists in hexadecimal format."""
    playlist_item_border_radius: builtins.int
    """Corner radius of playlist items in pixels."""
    playlist_item_gap: builtins.int
    """Spacing between playlist items in pixels."""
    playlist_location: global___StylePreset.WidgetLocation.ValueType
    """Position of the playlist widget relative to the player."""
    @property
    def right_widgets(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Widget]:
        """List of widgets to display to the right of the player."""

    @property
    def bottom_widgets(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Widget]:
        """List of widgets to display below the player."""

    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp when the style preset was initially created in the system."""

    @property
    def updated_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp of the last modification to the style preset or its metadata."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        channel_id: builtins.str = ...,
        title: builtins.str = ...,
        background_color: builtins.str = ...,
        widget_text_color_primary: builtins.str = ...,
        widget_text_color_secondary: builtins.str = ...,
        widget_accent_color: builtins.str = ...,
        widget_block_gap: builtins.int = ...,
        widget_block_separator_color: builtins.str = ...,
        player_border_radius: builtins.int = ...,
        player_color: builtins.str = ...,
        playlist_selected_item_background_color: builtins.str = ...,
        playlist_item_border_radius: builtins.int = ...,
        playlist_item_gap: builtins.int = ...,
        playlist_location: global___StylePreset.WidgetLocation.ValueType = ...,
        right_widgets: collections.abc.Iterable[global___Widget] | None = ...,
        bottom_widgets: collections.abc.Iterable[global___Widget] | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        updated_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at", "updated_at", b"updated_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["background_color", b"background_color", "bottom_widgets", b"bottom_widgets", "channel_id", b"channel_id", "created_at", b"created_at", "id", b"id", "player_border_radius", b"player_border_radius", "player_color", b"player_color", "playlist_item_border_radius", b"playlist_item_border_radius", "playlist_item_gap", b"playlist_item_gap", "playlist_location", b"playlist_location", "playlist_selected_item_background_color", b"playlist_selected_item_background_color", "right_widgets", b"right_widgets", "title", b"title", "updated_at", b"updated_at", "widget_accent_color", b"widget_accent_color", "widget_block_gap", b"widget_block_gap", "widget_block_separator_color", b"widget_block_separator_color", "widget_text_color_primary", b"widget_text_color_primary", "widget_text_color_secondary", b"widget_text_color_secondary"]) -> None: ...

global___StylePreset = StylePreset

@typing.final
class Widget(google.protobuf.message.Message):
    """Represents a UI component that displays additional content or functionality.
    Widgets can be positioned in different locations around the player.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class Summarization(google.protobuf.message.Message):
        """Widget that presents an automatically generated summary of the video content.
        This helps viewers quickly understand the main points without watching the entire video.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        def __init__(
            self,
        ) -> None: ...

    @typing.final
    class Description(google.protobuf.message.Message):
        """Widget that displays the full description text for the video.
        This can include details about the content, creators, and other relevant information.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        def __init__(
            self,
        ) -> None: ...

    SUMMARIZATION_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    @property
    def summarization(self) -> global___Widget.Summarization:
        """Widget that displays video content summarization."""

    @property
    def description(self) -> global___Widget.Description:
        """Widget that displays detailed video description."""

    def __init__(
        self,
        *,
        summarization: global___Widget.Summarization | None = ...,
        description: global___Widget.Description | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["description", b"description", "summarization", b"summarization", "widget", b"widget"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "summarization", b"summarization", "widget", b"widget"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["widget", b"widget"]) -> typing.Literal["summarization", "description"] | None: ...

global___Widget = Widget
