"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing
import yandex.cloud.video.v1.thumbnail_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetThumbnailRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    THUMBNAIL_ID_FIELD_NUMBER: builtins.int
    thumbnail_id: builtins.str
    """ID of the thumbnail to retrieve.
    Must be a valid thumbnail identifier string.
    """
    def __init__(
        self,
        *,
        thumbnail_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["thumbnail_id", b"thumbnail_id"]) -> None: ...

global___GetThumbnailRequest = GetThumbnailRequest

@typing.final
class ListThumbnailRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_ID_FIELD_NUMBER: builtins.int
    EPISODE_ID_FIELD_NUMBER: builtins.int
    VIDEO_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    """[Deprecated] ID of the channel."""
    episode_id: builtins.str
    """ID of the episode containing the thumbnails to list."""
    video_id: builtins.str
    """ID of the video containing the thumbnails to list."""
    page_size: builtins.int
    """The maximum number of thumbnails to return per page."""
    page_token: builtins.str
    """Page token for retrieving the next page of results.
    This token is obtained from the next_page_token field in the previous ListThumbnailResponse.
    """
    def __init__(
        self,
        *,
        channel_id: builtins.str = ...,
        episode_id: builtins.str = ...,
        video_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["episode_id", b"episode_id", "parent_id", b"parent_id", "video_id", b"video_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "episode_id", b"episode_id", "page_size", b"page_size", "page_token", b"page_token", "parent_id", b"parent_id", "video_id", b"video_id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["parent_id", b"parent_id"]) -> typing.Literal["episode_id", "video_id"] | None: ...

global___ListThumbnailRequest = ListThumbnailRequest

@typing.final
class ListThumbnailResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    THUMBNAILS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for retrieving the next page of results.
    Empty if there are no more results available.
    """
    @property
    def thumbnails(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.video.v1.thumbnail_pb2.Thumbnail]:
        """List of thumbnails matching the request criteria.
        May be empty if no thumbnails match the criteria or if the parent resource has no thumbnails.
        """

    def __init__(
        self,
        *,
        thumbnails: collections.abc.Iterable[yandex.cloud.video.v1.thumbnail_pb2.Thumbnail] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "thumbnails", b"thumbnails"]) -> None: ...

global___ListThumbnailResponse = ListThumbnailResponse

@typing.final
class CreateThumbnailRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_ID_FIELD_NUMBER: builtins.int
    EPISODE_ID_FIELD_NUMBER: builtins.int
    VIDEO_ID_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    """[Deprecated] ID of the channel."""
    episode_id: builtins.str
    """ID of the episode to associate the thumbnail with."""
    video_id: builtins.str
    """ID of the video to associate the thumbnail with."""
    def __init__(
        self,
        *,
        channel_id: builtins.str = ...,
        episode_id: builtins.str = ...,
        video_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["episode_id", b"episode_id", "parent_id", b"parent_id", "video_id", b"video_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "episode_id", b"episode_id", "parent_id", b"parent_id", "video_id", b"video_id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["parent_id", b"parent_id"]) -> typing.Literal["episode_id", "video_id"] | None: ...

global___CreateThumbnailRequest = CreateThumbnailRequest

@typing.final
class CreateThumbnailMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    THUMBNAIL_ID_FIELD_NUMBER: builtins.int
    thumbnail_id: builtins.str
    """ID of the thumbnail being created."""
    def __init__(
        self,
        *,
        thumbnail_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["thumbnail_id", b"thumbnail_id"]) -> None: ...

global___CreateThumbnailMetadata = CreateThumbnailMetadata

@typing.final
class BatchGenerateDownloadURLsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_ID_FIELD_NUMBER: builtins.int
    THUMBNAIL_IDS_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    """ID of the channel containing the thumbnails."""
    @property
    def thumbnail_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of thumbnail IDs for which to generate download URLs."""

    def __init__(
        self,
        *,
        channel_id: builtins.str = ...,
        thumbnail_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "thumbnail_ids", b"thumbnail_ids"]) -> None: ...

global___BatchGenerateDownloadURLsRequest = BatchGenerateDownloadURLsRequest

@typing.final
class BatchGenerateDownloadURLsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DOWNLOAD_URLS_FIELD_NUMBER: builtins.int
    @property
    def download_urls(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ThumbnailDownloadURL]:
        """List of download URLs for the requested thumbnails.
        Each entry contains URLs for both the original image and various scaled versions.
        """

    def __init__(
        self,
        *,
        download_urls: collections.abc.Iterable[global___ThumbnailDownloadURL] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["download_urls", b"download_urls"]) -> None: ...

global___BatchGenerateDownloadURLsResponse = BatchGenerateDownloadURLsResponse

@typing.final
class ThumbnailDownloadURL(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _ImageFormat:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ImageFormatEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ThumbnailDownloadURL._ImageFormat.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        IMAGE_FORMAT_UNSPECIFIED: ThumbnailDownloadURL._ImageFormat.ValueType  # 0
        """The image format is not specified."""
        JPEG: ThumbnailDownloadURL._ImageFormat.ValueType  # 1
        """JPEG image format.
        Provides good compression with some quality loss.
        Widely supported across all platforms and browsers.
        """
        WEBP: ThumbnailDownloadURL._ImageFormat.ValueType  # 2
        """WebP image format.
        Provides better compression than JPEG with similar quality.
        May not be supported on all platforms and older browsers.
        """

    class ImageFormat(_ImageFormat, metaclass=_ImageFormatEnumTypeWrapper):
        """Image format of a thumbnail."""

    IMAGE_FORMAT_UNSPECIFIED: ThumbnailDownloadURL.ImageFormat.ValueType  # 0
    """The image format is not specified."""
    JPEG: ThumbnailDownloadURL.ImageFormat.ValueType  # 1
    """JPEG image format.
    Provides good compression with some quality loss.
    Widely supported across all platforms and browsers.
    """
    WEBP: ThumbnailDownloadURL.ImageFormat.ValueType  # 2
    """WebP image format.
    Provides better compression than JPEG with similar quality.
    May not be supported on all platforms and older browsers.
    """

    @typing.final
    class ScaledURL(google.protobuf.message.Message):
        """Represents a URL for a specific scaled version of a thumbnail image."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        URL_FIELD_NUMBER: builtins.int
        MAX_WIDTH_FIELD_NUMBER: builtins.int
        MAX_HEIGHT_FIELD_NUMBER: builtins.int
        IMAGE_FORMAT_FIELD_NUMBER: builtins.int
        url: builtins.str
        """URL for downloading this scaled version of the thumbnail."""
        max_width: builtins.int
        """Maximum width in pixels of the scaled image.
        The actual width may be smaller to maintain the aspect ratio.
        """
        max_height: builtins.int
        """Maximum height in pixels of the scaled image.
        The actual height may be smaller to maintain the aspect ratio.
        """
        image_format: global___ThumbnailDownloadURL.ImageFormat.ValueType
        """Format of the scaled image (JPEG, WebP, etc.).
        Different formats offer different trade-offs between quality and file size.
        """
        def __init__(
            self,
            *,
            url: builtins.str = ...,
            max_width: builtins.int = ...,
            max_height: builtins.int = ...,
            image_format: global___ThumbnailDownloadURL.ImageFormat.ValueType = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["image_format", b"image_format", "max_height", b"max_height", "max_width", b"max_width", "url", b"url"]) -> None: ...

    THUMBNAIL_ID_FIELD_NUMBER: builtins.int
    ORIGINAL_URL_FIELD_NUMBER: builtins.int
    SCALED_URLS_FIELD_NUMBER: builtins.int
    thumbnail_id: builtins.str
    """ID of the thumbnail for which download URLs are provided."""
    original_url: builtins.str
    """URL for downloading the original, unmodified thumbnail image.
    This provides access to the image at its original resolution and format.
    """
    @property
    def scaled_urls(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ThumbnailDownloadURL.ScaledURL]:
        """List of URLs for downloading scaled versions of the thumbnail.
        Different scaled versions are optimized for different display sizes and purposes.
        """

    def __init__(
        self,
        *,
        thumbnail_id: builtins.str = ...,
        original_url: builtins.str = ...,
        scaled_urls: collections.abc.Iterable[global___ThumbnailDownloadURL.ScaledURL] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["original_url", b"original_url", "scaled_urls", b"scaled_urls", "thumbnail_id", b"thumbnail_id"]) -> None: ...

global___ThumbnailDownloadURL = ThumbnailDownloadURL

@typing.final
class GenerateThumbnailUploadURLRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    THUMBNAIL_ID_FIELD_NUMBER: builtins.int
    thumbnail_id: builtins.str
    """ID of the thumbnail for which to generate an upload URL.
    The thumbnail record must already exist, typically created using the Create method.
    """
    def __init__(
        self,
        *,
        thumbnail_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["thumbnail_id", b"thumbnail_id"]) -> None: ...

global___GenerateThumbnailUploadURLRequest = GenerateThumbnailUploadURLRequest

@typing.final
class GenerateThumbnailUploadURLResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UPLOAD_URL_FIELD_NUMBER: builtins.int
    upload_url: builtins.str
    """Pre-signed URL for uploading the thumbnail image.
    This URL can be used with an HTTP PUT request to upload the image file.
    The URL has a limited validity period and will expire after a certain time.
    """
    def __init__(
        self,
        *,
        upload_url: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["upload_url", b"upload_url"]) -> None: ...

global___GenerateThumbnailUploadURLResponse = GenerateThumbnailUploadURLResponse

@typing.final
class DeleteThumbnailRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    THUMBNAIL_ID_FIELD_NUMBER: builtins.int
    thumbnail_id: builtins.str
    """ID of the thumbnail to delete."""
    def __init__(
        self,
        *,
        thumbnail_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["thumbnail_id", b"thumbnail_id"]) -> None: ...

global___DeleteThumbnailRequest = DeleteThumbnailRequest

@typing.final
class DeleteThumbnailMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    THUMBNAIL_ID_FIELD_NUMBER: builtins.int
    thumbnail_id: builtins.str
    """ID of the thumbnail being deleted.
    This identifier can be used to track the thumbnail deletion operation.
    """
    def __init__(
        self,
        *,
        thumbnail_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["thumbnail_id", b"thumbnail_id"]) -> None: ...

global___DeleteThumbnailMetadata = DeleteThumbnailMetadata
