"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import google.protobuf.wrappers_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _AutoTranscode:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _AutoTranscodeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_AutoTranscode.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    AUTO_TRANSCODE_UNSPECIFIED: _AutoTranscode.ValueType  # 0
    """The auto-transcoding setting is not specified."""
    ENABLE: _AutoTranscode.ValueType  # 1
    """Automatically start transcoding after the video upload is complete."""
    DISABLE: _AutoTranscode.ValueType  # 2
    """Do not automatically transcode; requires manual initiation via the Transcode() method."""

class AutoTranscode(_AutoTranscode, metaclass=_AutoTranscodeEnumTypeWrapper):
    """Enum controlling whether videos are automatically transcoded after upload."""

AUTO_TRANSCODE_UNSPECIFIED: AutoTranscode.ValueType  # 0
"""The auto-transcoding setting is not specified."""
ENABLE: AutoTranscode.ValueType  # 1
"""Automatically start transcoding after the video upload is complete."""
DISABLE: AutoTranscode.ValueType  # 2
"""Do not automatically transcode; requires manual initiation via the Transcode() method."""
global___AutoTranscode = AutoTranscode

@typing.final
class Video(google.protobuf.message.Message):
    """Main entity representing a video in the platform."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _VideoStatus:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _VideoStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Video._VideoStatus.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        VIDEO_STATUS_UNSPECIFIED: Video._VideoStatus.ValueType  # 0
        """The video status is not specified."""
        WAIT_UPLOADING: Video._VideoStatus.ValueType  # 1
        """The video upload is in progress, waiting for all bytes to be received."""
        UPLOADED: Video._VideoStatus.ValueType  # 2
        """The video has been fully uploaded and is ready for transcoding."""
        PROCESSING: Video._VideoStatus.ValueType  # 4
        """The video is currently being processed."""
        READY: Video._VideoStatus.ValueType  # 5
        """The video has been successfully processed and is ready for watching."""
        ERROR: Video._VideoStatus.ValueType  # 7
        """An error occurred during video processing."""

    class VideoStatus(_VideoStatus, metaclass=_VideoStatusEnumTypeWrapper):
        """Current processing status of the video."""

    VIDEO_STATUS_UNSPECIFIED: Video.VideoStatus.ValueType  # 0
    """The video status is not specified."""
    WAIT_UPLOADING: Video.VideoStatus.ValueType  # 1
    """The video upload is in progress, waiting for all bytes to be received."""
    UPLOADED: Video.VideoStatus.ValueType  # 2
    """The video has been fully uploaded and is ready for transcoding."""
    PROCESSING: Video.VideoStatus.ValueType  # 4
    """The video is currently being processed."""
    READY: Video.VideoStatus.ValueType  # 5
    """The video has been successfully processed and is ready for watching."""
    ERROR: Video.VideoStatus.ValueType  # 7
    """An error occurred during video processing."""

    class _VisibilityStatus:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _VisibilityStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Video._VisibilityStatus.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        VISIBILITY_STATUS_UNSPECIFIED: Video._VisibilityStatus.ValueType  # 0
        """The visibility status is not specified."""
        PUBLISHED: Video._VisibilityStatus.ValueType  # 1
        """The video is publicly available, subject to its access permission settings."""
        UNPUBLISHED: Video._VisibilityStatus.ValueType  # 2
        """The video is available only to administrators."""

    class VisibilityStatus(_VisibilityStatus, metaclass=_VisibilityStatusEnumTypeWrapper):
        """Visibility status of the video."""

    VISIBILITY_STATUS_UNSPECIFIED: Video.VisibilityStatus.ValueType  # 0
    """The visibility status is not specified."""
    PUBLISHED: Video.VisibilityStatus.ValueType  # 1
    """The video is publicly available, subject to its access permission settings."""
    UNPUBLISHED: Video.VisibilityStatus.ValueType  # 2
    """The video is available only to administrators."""

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    TITLE_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    THUMBNAIL_ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    ERROR_MESSAGE_FIELD_NUMBER: builtins.int
    VISIBILITY_STATUS_FIELD_NUMBER: builtins.int
    DURATION_FIELD_NUMBER: builtins.int
    AUTO_TRANSCODE_FIELD_NUMBER: builtins.int
    STYLE_PRESET_ID_FIELD_NUMBER: builtins.int
    ENABLE_AD_FIELD_NUMBER: builtins.int
    SUBTITLE_IDS_FIELD_NUMBER: builtins.int
    FEATURES_FIELD_NUMBER: builtins.int
    TUSD_FIELD_NUMBER: builtins.int
    PUBLIC_ACCESS_FIELD_NUMBER: builtins.int
    SIGN_URL_ACCESS_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    UPDATED_AT_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Unique identifier of the video."""
    channel_id: builtins.str
    """Identifier of the channel where the video is created and managed."""
    title: builtins.str
    """Title of the video displayed to users in interfaces and players."""
    description: builtins.str
    """Detailed description of the video content and context."""
    thumbnail_id: builtins.str
    """Identifier of the thumbnail image used to represent the video visually."""
    status: global___Video.VideoStatus.ValueType
    """Current processing status of the video."""
    error_message: builtins.str
    """Error message describing the reason for video processing failure, if any."""
    visibility_status: global___Video.VisibilityStatus.ValueType
    """Current visibility status controlling whether the video is publicly available."""
    auto_transcode: global___AutoTranscode.ValueType
    """Auto-transcoding setting that controls the video processing workflow.
    Set ENABLE to automatically initiate transcoding after upload,
    or DISABLE for manual initiation via the Transcode() method.
    """
    style_preset_id: builtins.str
    """Identifier of the style preset applied to the video during processing."""
    @property
    def duration(self) -> google.protobuf.duration_pb2.Duration:
        """Total duration of the video.
        Optional, may be empty until the transcoding result is ready.
        """

    @property
    def enable_ad(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Controls the ability to display advertisements for this video.
        Default: true.
        Set explicitly to false to disable advertisements for a specific video.
        """

    @property
    def subtitle_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of identifiers defining the active subtitles available for the video."""

    @property
    def features(self) -> global___VideoFeatures:
        """Additional video processing features and their results, such as summarization."""

    @property
    def tusd(self) -> global___VideoTUSDSource:
        """Upload video using the TUS (Tus Resumable Upload Protocol) protocol.
        @see https://tus.io/
        """

    @property
    def public_access(self) -> global___VideoPublicAccessRights:
        """Allows unrestricted public access to the video via direct link.
        No additional authorization or access control is applied.
        """

    @property
    def sign_url_access(self) -> global___VideoSignURLAccessRights:
        """Restricts video access using URL signatures for secure time-limited access."""

    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp when the video was initially created in the system."""

    @property
    def updated_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp of the last modification to the video or its metadata."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Custom user-defined labels as `key:value` pairs.
        Maximum 64 labels per video.
        Labels can be used for organization, filtering, and metadata purposes.
        """

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        channel_id: builtins.str = ...,
        title: builtins.str = ...,
        description: builtins.str = ...,
        thumbnail_id: builtins.str = ...,
        status: global___Video.VideoStatus.ValueType = ...,
        error_message: builtins.str = ...,
        visibility_status: global___Video.VisibilityStatus.ValueType = ...,
        duration: google.protobuf.duration_pb2.Duration | None = ...,
        auto_transcode: global___AutoTranscode.ValueType = ...,
        style_preset_id: builtins.str = ...,
        enable_ad: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        subtitle_ids: collections.abc.Iterable[builtins.str] | None = ...,
        features: global___VideoFeatures | None = ...,
        tusd: global___VideoTUSDSource | None = ...,
        public_access: global___VideoPublicAccessRights | None = ...,
        sign_url_access: global___VideoSignURLAccessRights | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        updated_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["access_rights", b"access_rights", "created_at", b"created_at", "duration", b"duration", "enable_ad", b"enable_ad", "features", b"features", "public_access", b"public_access", "sign_url_access", b"sign_url_access", "source", b"source", "tusd", b"tusd", "updated_at", b"updated_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["access_rights", b"access_rights", "auto_transcode", b"auto_transcode", "channel_id", b"channel_id", "created_at", b"created_at", "description", b"description", "duration", b"duration", "enable_ad", b"enable_ad", "error_message", b"error_message", "features", b"features", "id", b"id", "labels", b"labels", "public_access", b"public_access", "sign_url_access", b"sign_url_access", "source", b"source", "status", b"status", "style_preset_id", b"style_preset_id", "subtitle_ids", b"subtitle_ids", "thumbnail_id", b"thumbnail_id", "title", b"title", "tusd", b"tusd", "updated_at", b"updated_at", "visibility_status", b"visibility_status"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["access_rights", b"access_rights"]) -> typing.Literal["public_access", "sign_url_access"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["source", b"source"]) -> typing.Literal["tusd"] | None: ...

global___Video = Video

@typing.final
class VideoTUSDSource(google.protobuf.message.Message):
    """Represents a video upload source using the TUS (Tus Resumable Upload Protocol) protocol.
    This is a push-based upload method where the client pushes data to the server.
    @see https://tus.io/
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    URL_FIELD_NUMBER: builtins.int
    FILE_SIZE_FIELD_NUMBER: builtins.int
    url: builtins.str
    """URL endpoint for uploading the video via the TUS protocol."""
    file_size: builtins.int
    """Total size of the uploaded file, in bytes."""
    def __init__(
        self,
        *,
        url: builtins.str = ...,
        file_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["file_size", b"file_size", "url", b"url"]) -> None: ...

global___VideoTUSDSource = VideoTUSDSource

@typing.final
class VideoPublicAccessRights(google.protobuf.message.Message):
    """Represents public access rights for a video.
    When this access type is set, the video is publicly accessible via direct link.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___VideoPublicAccessRights = VideoPublicAccessRights

@typing.final
class VideoSignURLAccessRights(google.protobuf.message.Message):
    """Represents access rights controlled by URL signatures.
    When this access type is set, the video is accessible only via properly signed temporary link.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___VideoSignURLAccessRights = VideoSignURLAccessRights

@typing.final
class VideoFeatures(google.protobuf.message.Message):
    """Contains additional processing features and their results for the video."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _FeatureResult:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _FeatureResultEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[VideoFeatures._FeatureResult.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        FEATURE_RESULT_UNSPECIFIED: VideoFeatures._FeatureResult.ValueType  # 0
        """The feature result status is not specified."""
        NOT_REQUESTED: VideoFeatures._FeatureResult.ValueType  # 1
        """The feature processing has not been requested."""
        PROCESSING: VideoFeatures._FeatureResult.ValueType  # 2
        """The feature is currently being processed."""
        SUCCESS: VideoFeatures._FeatureResult.ValueType  # 3
        """The feature processing has completed successfully."""
        FAILED: VideoFeatures._FeatureResult.ValueType  # 4
        """The feature processing has failed."""

    class FeatureResult(_FeatureResult, metaclass=_FeatureResultEnumTypeWrapper):
        """Status of a feature processing request."""

    FEATURE_RESULT_UNSPECIFIED: VideoFeatures.FeatureResult.ValueType  # 0
    """The feature result status is not specified."""
    NOT_REQUESTED: VideoFeatures.FeatureResult.ValueType  # 1
    """The feature processing has not been requested."""
    PROCESSING: VideoFeatures.FeatureResult.ValueType  # 2
    """The feature is currently being processed."""
    SUCCESS: VideoFeatures.FeatureResult.ValueType  # 3
    """The feature processing has completed successfully."""
    FAILED: VideoFeatures.FeatureResult.ValueType  # 4
    """The feature processing has failed."""

    @typing.final
    class Summary(google.protobuf.message.Message):
        """Contains the results of video summarization."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        @typing.final
        class SummaryURL(google.protobuf.message.Message):
            """Contains a URL to a summarization result for a specific audio track."""

            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            URL_FIELD_NUMBER: builtins.int
            TRACK_INDEX_FIELD_NUMBER: builtins.int
            SRC_LANG_FIELD_NUMBER: builtins.int
            url: builtins.str
            """URL to the summarization result file."""
            track_index: builtins.int
            """Input audio track index (one-based) that was summarized."""
            src_lang: builtins.str
            """Source track language represented as a three-letter code according to ISO 639-2/T."""
            def __init__(
                self,
                *,
                url: builtins.str = ...,
                track_index: builtins.int = ...,
                src_lang: builtins.str = ...,
            ) -> None: ...
            def ClearField(self, field_name: typing.Literal["src_lang", b"src_lang", "track_index", b"track_index", "url", b"url"]) -> None: ...

        RESULT_FIELD_NUMBER: builtins.int
        URLS_FIELD_NUMBER: builtins.int
        result: global___VideoFeatures.FeatureResult.ValueType
        """Current status of the summarization process."""
        @property
        def urls(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___VideoFeatures.Summary.SummaryURL]:
            """List of URLs to summarization results for different audio tracks."""

        def __init__(
            self,
            *,
            result: global___VideoFeatures.FeatureResult.ValueType = ...,
            urls: collections.abc.Iterable[global___VideoFeatures.Summary.SummaryURL] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["result", b"result", "urls", b"urls"]) -> None: ...

    SUMMARY_FIELD_NUMBER: builtins.int
    @property
    def summary(self) -> global___VideoFeatures.Summary:
        """Results of the video content summarization process."""

    def __init__(
        self,
        *,
        summary: global___VideoFeatures.Summary | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["summary", b"summary"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["summary", b"summary"]) -> None: ...

global___VideoFeatures = VideoFeatures
