"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class SecurityGroup(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[SecurityGroup._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: SecurityGroup._Status.ValueType  # 0
        CREATING: SecurityGroup._Status.ValueType  # 1
        """Security group is being created."""
        ACTIVE: SecurityGroup._Status.ValueType  # 2
        """Security is active and it's rules are applied to the network interfaces."""
        UPDATING: SecurityGroup._Status.ValueType  # 3
        """Security group is updating. Updating is a long operation because we must update all instances in SG."""
        DELETING: SecurityGroup._Status.ValueType  # 4
        """Instance is being deleted."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNSPECIFIED: SecurityGroup.Status.ValueType  # 0
    CREATING: SecurityGroup.Status.ValueType  # 1
    """Security group is being created."""
    ACTIVE: SecurityGroup.Status.ValueType  # 2
    """Security is active and it's rules are applied to the network interfaces."""
    UPDATING: SecurityGroup.Status.ValueType  # 3
    """Security group is updating. Updating is a long operation because we must update all instances in SG."""
    DELETING: SecurityGroup.Status.ValueType  # 4
    """Instance is being deleted."""

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    NETWORK_ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    RULES_FIELD_NUMBER: builtins.int
    DEFAULT_FOR_NETWORK_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the security group."""
    folder_id: builtins.str
    """ID of the folder that the security group belongs to."""
    name: builtins.str
    """Name of the security group. 
    The name must be unique within the folder. 
    Value must match the regular expression ``\\|[a-zA-Z]([-_a-zA-Z0-9]{0,61}[a-zA-Z0-9])?``.
    """
    description: builtins.str
    """Description of the security group. 0-256 characters long."""
    network_id: builtins.str
    """ID of the network that the security group belongs to."""
    status: global___SecurityGroup.Status.ValueType
    """Security group status."""
    default_for_network: builtins.bool
    """Flag that indicates that the security group is the default for the network."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `key:value` pairs. 
        No more than 64 per resource.
        The maximum string length in characters for each value is 63. 
        Each value must match the regular expression `[-_./\\\\@0-9a-z]*`. 
        The string length in characters for each key must be 1-63. 
        Each key must match the regular expression `[a-z][-_./\\\\@0-9a-z]*`.
        """

    @property
    def rules(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SecurityGroupRule]:
        """List of the security group rules."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        folder_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        network_id: builtins.str = ...,
        status: global___SecurityGroup.Status.ValueType = ...,
        rules: collections.abc.Iterable[global___SecurityGroupRule] | None = ...,
        default_for_network: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["created_at", b"created_at", "default_for_network", b"default_for_network", "description", b"description", "folder_id", b"folder_id", "id", b"id", "labels", b"labels", "name", b"name", "network_id", b"network_id", "rules", b"rules", "status", b"status"]) -> None: ...

global___SecurityGroup = SecurityGroup

@typing.final
class SecurityGroupRule(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Direction:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _DirectionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[SecurityGroupRule._Direction.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        DIRECTION_UNSPECIFIED: SecurityGroupRule._Direction.ValueType  # 0
        INGRESS: SecurityGroupRule._Direction.ValueType  # 1
        """Allows ingress traffic."""
        EGRESS: SecurityGroupRule._Direction.ValueType  # 2
        """Allows egress traffic."""

    class Direction(_Direction, metaclass=_DirectionEnumTypeWrapper): ...
    DIRECTION_UNSPECIFIED: SecurityGroupRule.Direction.ValueType  # 0
    INGRESS: SecurityGroupRule.Direction.ValueType  # 1
    """Allows ingress traffic."""
    EGRESS: SecurityGroupRule.Direction.ValueType  # 2
    """Allows egress traffic."""

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    DIRECTION_FIELD_NUMBER: builtins.int
    PORTS_FIELD_NUMBER: builtins.int
    PROTOCOL_NAME_FIELD_NUMBER: builtins.int
    PROTOCOL_NUMBER_FIELD_NUMBER: builtins.int
    CIDR_BLOCKS_FIELD_NUMBER: builtins.int
    SECURITY_GROUP_ID_FIELD_NUMBER: builtins.int
    PREDEFINED_TARGET_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the rule.
    generated by api server after rule creation
    """
    description: builtins.str
    """Description of the rule. 0-256 characters long."""
    direction: global___SecurityGroupRule.Direction.ValueType
    """The direction of network traffic allowed by this rule."""
    protocol_name: builtins.str
    """Protocol name. Null value means any protocol.
    Values from [IANA](https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml).
    """
    protocol_number: builtins.int
    """Protocol number from [IANA protocol numbers](https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml)."""
    security_group_id: builtins.str
    """ID of the security group to add rule to."""
    predefined_target: builtins.str
    """Predefined target. See [security groups rules](/docs/vpc/concepts/security-groups#security-groups-rules) for more information."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `` key:value `` pairs. Maximum of 64 per resource."""

    @property
    def ports(self) -> global___PortRange:
        """The range of ports that allow traffic to pass through. Null value means any."""

    @property
    def cidr_blocks(self) -> global___CidrBlocks:
        """CIDR blocks to allow to recieve or send traffic."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        direction: global___SecurityGroupRule.Direction.ValueType = ...,
        ports: global___PortRange | None = ...,
        protocol_name: builtins.str = ...,
        protocol_number: builtins.int = ...,
        cidr_blocks: global___CidrBlocks | None = ...,
        security_group_id: builtins.str = ...,
        predefined_target: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["cidr_blocks", b"cidr_blocks", "ports", b"ports", "predefined_target", b"predefined_target", "security_group_id", b"security_group_id", "target", b"target"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cidr_blocks", b"cidr_blocks", "description", b"description", "direction", b"direction", "id", b"id", "labels", b"labels", "ports", b"ports", "predefined_target", b"predefined_target", "protocol_name", b"protocol_name", "protocol_number", b"protocol_number", "security_group_id", b"security_group_id", "target", b"target"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["target", b"target"]) -> typing.Literal["cidr_blocks", "security_group_id", "predefined_target"] | None: ...

global___SecurityGroupRule = SecurityGroupRule

@typing.final
class PortRange(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FROM_PORT_FIELD_NUMBER: builtins.int
    TO_PORT_FIELD_NUMBER: builtins.int
    from_port: builtins.int
    """The lowest port in the range."""
    to_port: builtins.int
    """The highest port in the range."""
    def __init__(
        self,
        *,
        from_port: builtins.int = ...,
        to_port: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["from_port", b"from_port", "to_port", b"to_port"]) -> None: ...

global___PortRange = PortRange

@typing.final
class CidrBlocks(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    V4_CIDR_BLOCKS_FIELD_NUMBER: builtins.int
    V6_CIDR_BLOCKS_FIELD_NUMBER: builtins.int
    @property
    def v4_cidr_blocks(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """IPv4 CIDR blocks to allow traffic to."""

    @property
    def v6_cidr_blocks(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """IPv6 CIDR blocks to allow traffic to."""

    def __init__(
        self,
        *,
        v4_cidr_blocks: collections.abc.Iterable[builtins.str] | None = ...,
        v6_cidr_blocks: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["v4_cidr_blocks", b"v4_cidr_blocks", "v6_cidr_blocks", b"v6_cidr_blocks"]) -> None: ...

global___CidrBlocks = CidrBlocks
