## Making packages

### Adjust version number

```
emacs setup.py iocbio/gel/const.py
```

### Adjust Changelog

Create a section for new version. Move Unreleased section to the new version 
section as appropriate.

### Commit the changes

```
git status
git add setup.py iocbio/gel/const.py CHANGELOG.md
git commit -m "bump version"
git push origin main
```

### Creating requirements file for automatic installation

To create `requirements.txt` first install Gel software in a new
virtual environment and make sure that the software works as it
should.  Then use `pip` to create `requirements.txt`:

```
python -m venv install-test
install-test/bin/pip install .
install-test/bin/pip freeze | sort | grep -v iocbio > requirements.txt
```

After that, `requirements.txt` should not contain `iocbio.gel`. Update the file in the repository.

### Updating available ZeroC Ice wheels information

List of available ZeroC Ice wheels is kept at `packaging/zeroc-ice/zeroc-ice-wheels.json`. To update the list, 
run

```
python3 scripts/generate_zerocice.py
```

### PyPi

For making source package, run

```
python3 setup.py sdist
```

For upload to PyPI:

```
twine upload dist/iocbio.gel-1.0.0.tar.gz
```

### Make release at Gitlab

Go to https://gitlab.com/iocbio/gel/tags and make a new release
with Changelog section used to describe the release.


### Windows executable

Windows executable as generated by PyInstaller through Gitlab CI. After completion, add link to the release notes.