from setuptools import setup

with open("README.md", "r") as fh:
    long_description = fh.read()

setup(
    name="iocbio.gel",
    version="1.1.1",
    description="IOCBio Gel",
    long_description=long_description,
    long_description_content_type="text/markdown",
    author="IOCBio team",
    author_email="iocbio@sysbio.ioc.ee",
    license="GPLv3",
    url="https://iocbio.gitlab.io/gel",
    packages=[
        "iocbio.gel",
        "iocbio.gel.application",
        "iocbio.gel.application.application_state",
        "iocbio.gel.application.image",
        "iocbio.gel.application.thread",
        "iocbio.gel.command",
        "iocbio.gel.db",
        "iocbio.gel.db.alembic",
        "iocbio.gel.db.alembic.versions",
        "iocbio.gel.db.connection_parameters",
        "iocbio.gel.domain",
        "iocbio.gel.gui",
        "iocbio.gel.gui.dialogs",
        "iocbio.gel.gui.dialogs.database_connection_settings",
        "iocbio.gel.gui.dialogs.image_source_settings",
        "iocbio.gel.gui.contexts",
        "iocbio.gel.gui.resources",
        "iocbio.gel.gui.models",
        "iocbio.gel.gui.models.items",
        "iocbio.gel.gui.views",
        "iocbio.gel.gui.views.delegates",
        "iocbio.gel.gui.widgets",
        "iocbio.gel.gui.widgets.analysis_steps",
        "iocbio.gel.gui.widgets.analysis_steps.intensity",
        "iocbio.gel.gui.widgets.analysis_steps.background",
        "iocbio.gel.gui.widgets.toolbars",
        "iocbio.gel.gui.windows",
        "iocbio.gel.repository",
    ],
    entry_points={"gui_scripts": ["iocbio-gel = iocbio.gel.app:main"]},
    package_data={
        "iocbio.gel.db.alembic": ["*.ini", "*.mako"],
        "iocbio.gel.db.alembic.versions": ["*.sql"],
        "iocbio.gel": ["*.ini"],
    },
    install_requires=[
        "sqlalchemy~=1.4.46",
        "PySide6~=6.9",
        "dependency_injector",
        "scikit-image~=0.24.0",
        "qimage2ndarray~=1.10.0",
        "zeroc-ice",
        "omero-py~=5.13.1",
        "alembic~=1.8.1",
        "pyqtgraph~=0.13.7",
        "shiboken6~=6.9",
        "psycopg2-binary",
        "keyring",
        "sqlparse~=0.4.3",
        "XlsxWriter~=3.0.8",
    ],
    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Intended Audience :: Science/Research",
        "License :: OSI Approved :: GNU General Public License v3 or later (GPLv3+)",
        "Programming Language :: Python :: 3",
        "Topic :: Scientific/Engineering",
    ],
)
