"""Initial migration

Revision ID: 680a75a754e2
Revises: 
Create Date: 2024-01-03 21:56:37.275382

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
import sqlmodel.sql.sqltypes


# revision identifiers, used by Alembic.
revision: str = '680a75a754e2'
down_revision: Union[str, None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('journal',
    sa.Column('title', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
    sa.Column('publisher', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
    sa.Column('recent_paper_count', sa.Integer(), nullable=False),
    sa.Column('feed', sa.Boolean(), nullable=False),
    sa.Column('feed_created', sa.DateTime(), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('issn',
    sa.Column('type', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
    sa.Column('value', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('journal_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['journal_id'], ['journal.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('value')
    )
    op.create_table('paper',
    sa.Column('title', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
    sa.Column('subtitle', sqlmodel.sql.sqltypes.AutoString(), nullable=True),
    sa.Column('short_title', sqlmodel.sql.sqltypes.AutoString(), nullable=True),
    sa.Column('author', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
    sa.Column('type', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
    sa.Column('abstract', sqlmodel.sql.sqltypes.AutoString(), nullable=True),
    sa.Column('publisher', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
    sa.Column('edition_number', sqlmodel.sql.sqltypes.AutoString(), nullable=True),
    sa.Column('issue', sqlmodel.sql.sqltypes.AutoString(), nullable=True),
    sa.Column('volume', sqlmodel.sql.sqltypes.AutoString(), nullable=True),
    sa.Column('page', sqlmodel.sql.sqltypes.AutoString(), nullable=True),
    sa.Column('created', sa.DateTime(), nullable=False),
    sa.Column('indexed', sa.DateTime(), nullable=False),
    sa.Column('posted', sa.DateTime(), nullable=True),
    sa.Column('published', sa.DateTime(), nullable=False),
    sa.Column('deposited', sa.DateTime(), nullable=False),
    sa.Column('issued', sa.DateTime(), nullable=True),
    sa.Column('accepted', sa.DateTime(), nullable=True),
    sa.Column('content_created', sa.DateTime(), nullable=True),
    sa.Column('content_updated', sa.DateTime(), nullable=True),
    sa.Column('published_print', sa.DateTime(), nullable=True),
    sa.Column('published_online', sa.DateTime(), nullable=True),
    sa.Column('group_title', sqlmodel.sql.sqltypes.AutoString(), nullable=True),
    sa.Column('reference_count', sa.Integer(), nullable=True),
    sa.Column('references_count', sa.Integer(), nullable=True),
    sa.Column('subject', sqlmodel.sql.sqltypes.AutoString(), nullable=True),
    sa.Column('url', sqlmodel.sql.sqltypes.AutoString(), nullable=True),
    sa.Column('source', sqlmodel.sql.sqltypes.AutoString(), nullable=True),
    sa.Column('unpaywall', sqlmodel.sql.sqltypes.AutoString(), nullable=True),
    sa.Column('scihub', sqlmodel.sql.sqltypes.AutoString(), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('doi', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
    sa.Column('journal_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['journal_id'], ['journal.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_paper_doi'), 'paper', ['doi'], unique=True)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_paper_doi'), table_name='paper')
    op.drop_table('paper')
    op.drop_table('issn')
    op.drop_table('journal')
    # ### end Alembic commands ###
