# This file is automatically generated. Do not modify it manually!
from functools import lru_cache

from .config import cond, Number, getMudim, getDiffeps
from .OneLoop import B0fin, B0del
from .T134 import T134fin


@lru_cache(maxsize=150)
def T1111134(m1: Number, m2: Number, m3: Number, m4: Number, m5: Number, m6: Number, m7, mudim = None) -> Number:
	""" Computes the UV-finite part of the T1111134 integral.

	Args:
		m1: internal mass
		m2: internal mass
		m3: internal mass
		m4: internal mass
		m5: internal mass
		m6: internal mass
		m7: internal mass
		mudim: squared renormalization scale (if `None`, the global value is used)

	Returns:
		finite part of the T1111134 integral.
	"""

	try:

		if mudim is None:
			mudim = getMudim()

		# rescale masses for better numerical stability
		mass_scale = max([m1, m2, m3, m4, m5, m6, m7])
		if mass_scale <= getDiffeps():
			return 0
		m1 /= mass_scale
		m2 /= mass_scale
		m3 /= mass_scale
		m4 /= mass_scale
		m5 /= mass_scale
		m6 /= mass_scale
		m7 /= mass_scale
		mudim /= mass_scale**2
		m1, m2, m3, m4, m5 = sorted([m1, m2, m3, m4, m5])
		
		

		m1sq = m1**2
		m2sq = m2**2
		m3sq = m3**2
		m4sq = m4**2
		m5sq = m5**2
		m6sq = m6**2
		m7sq = m7**2

		def eval_1():
			return 0
		def eval_2():
			return T134fin(m5,0,0,mudim)/m5**8
		def eval_3():
			return (71 - 105*B0fin(0,0,m6sq,mudim))/(22050.*m6**6)
		def eval_4():
			return -((m4sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*T134fin(m4,0,0,mudim))/m4**8)
		def eval_5():
			return (-m6**10 + 47*m6**6*m7**4 + 47*m6**4*m7**6 + 14*m6sq*m7**8 - m7**10 + 14*m6**8*m7sq + 6*m6sq*m7sq*(m6**6 + 4*m6sq*m7**4 + m7**6 + 4*m6**4*m7sq)*B0del(0,0,m6sq,mudim) + 6*m6sq*m7sq*(m6**6 + 4*m6sq*m7**4 + m7**6 + 4*m6**4*m7sq)*B0del(0,0,m7sq,mudim) - m6**10*B0fin(0,0,m6sq,mudim) + 31*m6**6*m7**4*B0fin(0,0,m6sq,mudim) + 45*m6**4*m7**6*B0fin(0,0,m6sq,mudim) - 15*m6**8*m7sq*B0fin(0,0,m6sq,mudim) + 45*m6**6*m7**4*B0fin(0,0,m7sq,mudim) + 31*m6**4*m7**6*B0fin(0,0,m7sq,mudim) - 15*m6sq*m7**8*B0fin(0,0,m7sq,mudim) - m7**10*B0fin(0,0,m7sq,mudim) + 24*m6**6*m7**4*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim) + 24*m6**4*m7**6*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim) + 6*m6sq*m7**8*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim) + 6*m6**8*m7sq*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim) - 36*m6**4*m7**4*T134fin(m7,m6,0,mudim) - 12*m6sq*m7**6*T134fin(m7,m6,0,mudim) - 12*m6**6*m7sq*T134fin(m7,m6,0,mudim))/(6.*(m6sq - m7sq)**8)
		def eval_6():
			return (m5**6*T134fin(m4,0,0,mudim) - m4**6*T134fin(m5,0,0,mudim))/(m4**8*m5**6 - m4**6*m5**8)
		def eval_7():
			return -0.5*(7*m4sq + 10*m4sq*B0del(0,0,m4sq,mudim) + 8*m4sq*B0fin(0,0,m4sq,mudim) + 5*m4sq*B0fin(0,0,m4sq,mudim)**2 - 2*T134fin(m4,0,0,mudim))/m4**8
		def eval_8():
			return -0.5*(7*m4sq + 10*m4sq*B0del(0,0,m4sq,mudim) + 8*m4sq*B0fin(0,0,m4sq,mudim) + 5*m4sq*B0fin(0,0,m4sq,mudim)**2 - 2*T134fin(m4,0,0,mudim))/m4**8
		def eval_9():
			return 5/(2.*m3**6) + (3*B0fin(0,0,m3sq,mudim))/m3**6 + T134fin(m3,0,0,mudim)/m3**8
		def eval_10():
			return (-31*m5**6 + 2700*m5sq*m6**4 - 1800*m6**6 - 550*m5**4*m6sq + 900*m6**4*(m5sq - 2*m6sq)*B0del(0,0,m6sq,mudim) + 30*(m5**6 - 90*m5sq*m6**4 - 60*m6**6 + 10*m5**4*m6sq)*B0fin(0,0,m6sq,mudim) + 450*m6**4*(m5sq - 2*m6sq)*B0fin(0,0,m6sq,mudim)**2 + 900*m6**4*T134fin(m6,m6,m5,mudim))/(900.*m5**8*m6**4)
		def eval_11():
			return (2*m3**4*(m3sq - m4sq)*m4sq*B0fin(0,0,m4sq,mudim) + m4**6*T134fin(m3,0,0,mudim) + m3**4*((m3sq - m4sq)*m4sq + (m3sq - 2*m4sq)*T134fin(m4,0,0,mudim)))/(m3**4*m4**6*(m3sq - m4sq)**2)
		def eval_12():
			return ((-2*m3**4*m5**4 + 2*m3sq*m5**6)*B0fin(0,0,m3sq,mudim) + (-2*m3sq*m5**4 + m5**6)*T134fin(m3,0,0,mudim) + m3sq*(-(m3sq*m5**4) + m5**6 + m3**4*T134fin(m5,0,0,mudim)))/(m3**6*m5**4*(m3sq - m5sq)**2)
		def eval_13():
			return (m5**6*m6**8 - 3*m5**4*m6**10 - 6*m5sq*m6**12 - 10*m5**6*m6**4*m7**4 + 6*m5**4*m6**6*m7**4 + 6*m5sq*m6**8*m7**4 + 6*m5**4*m6**4*m7**6 - 24*m5sq*m6**6*m7**6 - 20*m5**6*m6sq*m7**6 + m5**6*m7**8 + 6*m5sq*m6**4*m7**8 - 3*m5**4*m6sq*m7**8 - 3*m5**4*m7**10 + 12*m5sq*m6sq*m7**10 - 6*m5sq*m7**12 - 20*m5**6*m6**6*m7sq - 3*m5**4*m6**8*m7sq + 12*m5sq*m6**10*m7sq - 6*m5sq*m6sq*m7sq*(2*(m6sq - m7sq)**4 + m5sq*(m6sq - m7sq)**2*(m6sq + m7sq) + m5**4*(m6sq + m7sq)**2)*B0del(0,0,m6sq,mudim) - 6*m5sq*m6sq*m7sq*(2*(m6sq - m7sq)**4 + m5sq*(m6sq - m7sq)**2*(m6sq + m7sq) + m5**4*(m6sq + m7sq)**2)*B0del(0,0,m7sq,mudim) + 2*m5**6*m6**8*B0fin(0,0,m6sq,mudim) + 6*m5**4*m6**10*B0fin(0,0,m6sq,mudim) - 12*m5sq*m6**12*B0fin(0,0,m6sq,mudim) - 30*m5**6*m6**4*m7**4*B0fin(0,0,m6sq,mudim) + 42*m5**4*m6**6*m7**4*B0fin(0,0,m6sq,mudim) - 72*m5sq*m6**8*m7**4*B0fin(0,0,m6sq,mudim) - 18*m5**4*m6**4*m7**6*B0fin(0,0,m6sq,mudim) + 48*m5sq*m6**6*m7**6*B0fin(0,0,m6sq,mudim) - 12*m5sq*m6**4*m7**8*B0fin(0,0,m6sq,mudim) + 4*m5**6*m6**6*m7sq*B0fin(0,0,m6sq,mudim) - 30*m5**4*m6**8*m7sq*B0fin(0,0,m6sq,mudim) + 48*m5sq*m6**10*m7sq*B0fin(0,0,m6sq,mudim) - 30*m5**6*m6**4*m7**4*B0fin(0,0,m7sq,mudim) - 18*m5**4*m6**6*m7**4*B0fin(0,0,m7sq,mudim) - 12*m5sq*m6**8*m7**4*B0fin(0,0,m7sq,mudim) + 42*m5**4*m6**4*m7**6*B0fin(0,0,m7sq,mudim) + 48*m5sq*m6**6*m7**6*B0fin(0,0,m7sq,mudim) + 4*m5**6*m6sq*m7**6*B0fin(0,0,m7sq,mudim) + 2*m5**6*m7**8*B0fin(0,0,m7sq,mudim) - 72*m5sq*m6**4*m7**8*B0fin(0,0,m7sq,mudim) - 30*m5**4*m6sq*m7**8*B0fin(0,0,m7sq,mudim) + 6*m5**4*m7**10*B0fin(0,0,m7sq,mudim) + 48*m5sq*m6sq*m7**10*B0fin(0,0,m7sq,mudim) - 12*m5sq*m7**12*B0fin(0,0,m7sq,mudim) - 12*m5**6*m6**4*m7**4*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim) + 6*m5**4*m6**6*m7**4*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim) + 48*m5sq*m6**8*m7**4*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim) + 6*m5**4*m6**4*m7**6*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim) - 72*m5sq*m6**6*m7**6*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim) - 6*m5**6*m6sq*m7**6*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim) + 48*m5sq*m6**4*m7**8*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim) - 6*m5**4*m6sq*m7**8*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim) - 12*m5sq*m6sq*m7**10*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim) - 6*m5**6*m6**6*m7sq*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim) - 6*m5**4*m6**8*m7sq*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim) - 12*m5sq*m6**10*m7sq*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim) + 6*m5sq*m6**10*T134fin(m7,m6,0,mudim) - 6*m6**12*T134fin(m7,m6,0,mudim) - 24*m5**4*m6**4*m7**4*T134fin(m7,m6,0,mudim) + 12*m5sq*m6**6*m7**4*T134fin(m7,m6,0,mudim) - 90*m6**8*m7**4*T134fin(m7,m6,0,mudim) + 12*m5**6*m6sq*m7**4*T134fin(m7,m6,0,mudim) + 12*m5sq*m6**4*m7**6*T134fin(m7,m6,0,mudim) + 120*m6**6*m7**6*T134fin(m7,m6,0,mudim) + 12*m5**4*m6sq*m7**6*T134fin(m7,m6,0,mudim) - 90*m6**4*m7**8*T134fin(m7,m6,0,mudim) - 18*m5sq*m6sq*m7**8*T134fin(m7,m6,0,mudim) + 6*m5sq*m7**10*T134fin(m7,m6,0,mudim) + 36*m6sq*m7**10*T134fin(m7,m6,0,mudim) - 6*m7**12*T134fin(m7,m6,0,mudim) + 12*m5**6*m6**4*m7sq*T134fin(m7,m6,0,mudim) + 12*m5**4*m6**6*m7sq*T134fin(m7,m6,0,mudim) - 18*m5sq*m6**8*m7sq*T134fin(m7,m6,0,mudim) + 36*m6**10*m7sq*T134fin(m7,m6,0,mudim) + 6*m6**12*T134fin(m7,m6,m5,mudim) + 90*m6**8*m7**4*T134fin(m7,m6,m5,mudim) - 120*m6**6*m7**6*T134fin(m7,m6,m5,mudim) + 90*m6**4*m7**8*T134fin(m7,m6,m5,mudim) - 36*m6sq*m7**10*T134fin(m7,m6,m5,mudim) + 6*m7**12*T134fin(m7,m6,m5,mudim) - 36*m6**10*m7sq*T134fin(m7,m6,m5,mudim))/(6.*m5**8*(m6sq - m7sq)**6)
		def eval_14():
			return T134fin(m3,0,0,mudim)/(m3**4*(m3sq - m4sq)*(m3sq - m5sq)) + T134fin(m4,0,0,mudim)/(m4**4*(-m3sq + m4sq)*(m4sq - m5sq)) + T134fin(m5,0,0,mudim)/(m5**4*(-m3sq + m5sq)*(-m4sq + m5sq))
		def eval_15():
			return -0.05555555555555555*(-11*m4**6 - 540*m4sq*m6**4 + 360*m6**6 + 170*m4**4*m6sq + 36*m4sq*m6**4*B0del(0,0,m4sq,mudim) + 36*m6sq*(m4**4 + 10*m6**4 - 6*m4sq*m6sq)*B0del(0,0,m6sq,mudim) - 108*m4sq*m6**4*B0fin(0,0,m4sq,mudim) + 36*m4**4*m6sq*B0fin(0,0,m4sq,mudim) + 6*m4**6*B0fin(0,0,m6sq,mudim) + 360*m4sq*m6**4*B0fin(0,0,m6sq,mudim) + 360*m6**6*B0fin(0,0,m6sq,mudim) - 132*m4**4*m6sq*B0fin(0,0,m6sq,mudim) + 36*m4sq*m6**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) - 126*m4sq*m6**4*B0fin(0,0,m6sq,mudim)**2 + 180*m6**6*B0fin(0,0,m6sq,mudim)**2 + 18*m4**4*m6sq*B0fin(0,0,m6sq,mudim)**2 - 180*m6**4*T134fin(m6,m6,m4,mudim) + 36*m4sq*m6sq*T134fin(m6,m6,m4,mudim))/(m4**8*m6**2*(m4sq - 4*m6sq))
		def eval_16():
			return (11*m4**6*m5**4 - 11*m4**4*m5**6 + 36*m4**6*m6**4 - 36*m5**6*m6**4 + 54*m4sq*m5**6*m6sq - 54*m4**6*m5sq*m6sq - 18*m6sq*(-(m4sq*m5**6) + m4**6*(m5sq - 2*m6sq) + 2*m5**6*m6sq)*B0del(0,0,m6sq,mudim) - 6*(-(m4**4*m5**6) + 6*m5**6*m6**4 + 9*m4sq*m5**6*m6sq + m4**6*(m5**4 - 6*m6**4 - 9*m5sq*m6sq))*B0fin(0,0,m6sq,mudim) + 9*m6sq*(m4sq*m5**6 - m4**6*(m5sq - 2*m6sq) - 2*m5**6*m6sq)*B0fin(0,0,m6sq,mudim)**2 + 18*m5**6*m6sq*T134fin(m6,m6,m4,mudim) - 18*m4**6*m6sq*T134fin(m6,m6,m5,mudim))/(18.*m4**6*m5**6*(m4sq - m5sq)*m6**2)
		def eval_17():
			return (m4**4*m6**4*(m6sq + m7sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq)) + m4**4*m7**4*(m6sq + m7sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq)) - m4**4*m6sq*(m6sq - m7sq)**4*B0del(0,0,m4sq,mudim) - m4**4*(m6sq - m7sq)**4*m7sq*B0del(0,0,m4sq,mudim) - m4**4*m6sq*(m6sq - m7sq)**4*B0del(0,0,m6sq,mudim) + m4sq*m6sq*(m6sq - m7sq)**5*B0del(0,0,m6sq,mudim) + 2*m4sq*m6sq*(m6sq - m7sq)**2*m7sq*(2*m4**4 + 3*(m6sq - m7sq)**2 - 4*m4sq*(m6sq + m7sq))*B0del(0,0,m6sq,mudim) + m4**4*m6sq*m7sq*(m6sq + m7sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))*B0del(0,0,m6sq,mudim) - m4**4*(m6sq - m7sq)**4*m7sq*B0del(0,0,m7sq,mudim) + m4sq*m7sq*(-m6sq + m7sq)**5*B0del(0,0,m7sq,mudim) + 2*m4sq*m6sq*(m6sq - m7sq)**2*m7sq*(2*m4**4 + 3*(m6sq - m7sq)**2 - 4*m4sq*(m6sq + m7sq))*B0del(0,0,m7sq,mudim) + m4sq*m6sq*(m6sq - m7sq)**5*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)) + m4sq*m7sq*(-m6sq + m7sq)**5*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)) + m4**4*m6sq*(m6sq - m7sq)**4*B0fin(0,0,m4sq,mudim) + m4**4*(m6sq - m7sq)**4*m7sq*B0fin(0,0,m4sq,mudim) + m4**4*m6sq*(m6sq - m7sq)**4*B0fin(0,0,m6sq,mudim) - m4sq*m6sq*(m6sq - m7sq)**5*B0fin(0,0,m6sq,mudim) - 2*m4sq*m6sq*(m6sq - m7sq)**2*m7sq*(2*m4**4 + 3*(m6sq - m7sq)**2 - 4*m4sq*(m6sq + m7sq))*B0fin(0,0,m6sq,mudim) + m4**4*m6sq*m7sq*(m6sq + m7sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))*B0fin(0,0,m6sq,mudim) - m4**4*m6sq*(m6sq - m7sq)**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) + m4sq*m6sq*(m6sq - m7sq)**5*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) + m4**4*m6sq*m7sq*(m6sq + m7sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))*(B0del(0,0,m7sq,mudim) - B0fin(0,0,m7sq,mudim)) + m4**4*(m6sq - m7sq)**4*m7sq*B0fin(0,0,m7sq,mudim) + m4sq*(m6sq - m7sq)**5*m7sq*B0fin(0,0,m7sq,mudim) - 2*m4sq*m6sq*(m6sq - m7sq)**2*m7sq*(2*m4**4 + 3*(m6sq - m7sq)**2 - 4*m4sq*(m6sq + m7sq))*B0fin(0,0,m7sq,mudim) + 2*m4**4*m6sq*m7sq*(m6sq + m7sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))*B0fin(0,0,m7sq,mudim) - m4**4*(m6sq - m7sq)**4*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) + m4sq*m7sq*(-m6sq + m7sq)**5*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) + 2*m4sq*m6sq*(m6sq - m7sq)**2*m7sq*(2*m4**4 + 3*(m6sq - m7sq)**2 - 4*m4sq*(m6sq + m7sq))*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim) + m4**4*m6sq*m7sq*(m6sq + m7sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim) + 2*m4**4*m6sq*m7sq*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))*((m6sq + m7sq)/2. + m6sq*B0fin(0,0,m6sq,mudim) + m7sq*B0fin(0,0,m7sq,mudim)) + 4*m4sq*(m6sq - m7sq)**2*(m6sq + m7sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))*((m6sq + m7sq)/2. + m6sq*B0fin(0,0,m6sq,mudim) + m7sq*B0fin(0,0,m7sq,mudim)) - (m4**4*m6**4*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))*(m6sq + m7sq + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/2. - (m4**4*m7**4*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))*(m6sq + m7sq + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/2. - m4sq*(m4sq - m6sq - m7sq)*(m6sq - m7sq)**4*(m4sq + m6sq + m7sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)) + 3*(m6sq - m7sq)**4*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))*T134fin(m7,m6,0,mudim) - 2*m4**4*m6sq*m7sq*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))*T134fin(m7,m6,0,mudim) - 2*m4sq*(m6sq - m7sq)**2*(m6sq + m7sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))*T134fin(m7,m6,0,mudim) + m4sq*(m4sq - m6sq - m7sq)*(m6sq - m7sq)**4*T134fin(m7,m6,m4,mudim) - 3*(m6sq - m7sq)**4*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))*T134fin(m7,m6,m4,mudim))/(m4**8*(m6sq - m7sq)**4*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq)))
		def eval_18():
			return (m6**4*(m6sq + m7sq))/(m4**2*m5**2*(m6sq - m7sq)**4) + (m7**4*(m6sq + m7sq))/(m4**2*m5**2*(m6sq - m7sq)**4) + (2*(m4sq + m5sq)*m6sq*m7sq*B0del(0,0,m6sq,mudim))/(m4**4*m5**4*(m6sq - m7sq)**2) + (m6sq*m7sq*(m6sq + m7sq)*B0del(0,0,m6sq,mudim))/(m4**2*m5**2*(m6sq - m7sq)**4) + (2*(m4sq + m5sq)*m6sq*m7sq*B0del(0,0,m7sq,mudim))/(m4**4*m5**4*(m6sq - m7sq)**2) - (2*(m4sq + m5sq)*m6sq*m7sq*B0fin(0,0,m6sq,mudim))/(m4**4*m5**4*(m6sq - m7sq)**2) + (m6sq*m7sq*(m6sq + m7sq)*B0fin(0,0,m6sq,mudim))/(m4**2*m5**2*(m6sq - m7sq)**4) + (m6sq*m7sq*(m6sq + m7sq)*(B0del(0,0,m7sq,mudim) - B0fin(0,0,m7sq,mudim)))/(m4**2*m5**2*(m6sq - m7sq)**4) - (2*(m4sq + m5sq)*m6sq*m7sq*B0fin(0,0,m7sq,mudim))/(m4**4*m5**4*(m6sq - m7sq)**2) + (2*m6sq*m7sq*(m6sq + m7sq)*B0fin(0,0,m7sq,mudim))/(m4**2*m5**2*(m6sq - m7sq)**4) + (2*(m4sq + m5sq)*m6sq*m7sq*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/(m4**4*m5**4*(m6sq - m7sq)**2) + (m6sq*m7sq*(m6sq + m7sq)*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/(m4**2*m5**2*(m6sq - m7sq)**4) - (m6**4*(m6sq + m7sq + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(2.*m4**2*m5**2*(m6sq - m7sq)**4) - (m7**4*(m6sq + m7sq + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(2.*m4**2*m5**2*(m6sq - m7sq)**4) + (m6sq*m7sq*(m6sq + m7sq + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m4**2*m5**2*(m6sq - m7sq)**4) + ((m4sq + m5sq)*(m6sq + m7sq)*(m6sq + m7sq + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m4**4*m5**4*(m6sq - m7sq)**2) + T134fin(m7,m6,0,mudim)/(m4**2*m5**6) + T134fin(m7,m6,0,mudim)/(m4**4*m5**4) + T134fin(m7,m6,0,mudim)/(m4**6*m5**2) - (2*m6sq*m7sq*T134fin(m7,m6,0,mudim))/(m4**2*m5**2*(m6sq - m7sq)**4) - ((m4sq + m5sq)*(m6sq + m7sq)*T134fin(m7,m6,0,mudim))/(m4**4*m5**4*(m6sq - m7sq)**2) + T134fin(m7,m6,m4,mudim)/(m4**8 - m4**6*m5sq) + T134fin(m7,m6,m5,mudim)/(-(m4sq*m5**6) + m5**8)
		def eval_19():
			return (11*m3**6 + 196*m3sq*m6**4 - 120*m6**6 - 84*m3**4*m6sq + 4*(-7*m3sq*m6**4 + 2*m3**4*m6sq)*B0del(0,0,m3sq,mudim) + 2*(m3**6 + 40*m3sq*m6**4 - 60*m6**6 - 10*m3**4*m6sq)*B0del(0,0,m6sq,mudim) + 6*m3**6*B0fin(0,0,m3sq,mudim) + 76*m3sq*m6**4*B0fin(0,0,m3sq,mudim) - 42*m3**4*m6sq*B0fin(0,0,m3sq,mudim) - 6*m3**6*B0fin(0,0,m6sq,mudim) - 56*m3sq*m6**4*B0fin(0,0,m6sq,mudim) - 120*m6**6*B0fin(0,0,m6sq,mudim) + 46*m3**4*m6sq*B0fin(0,0,m6sq,mudim) - 28*m3sq*m6**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) + 8*m3**4*m6sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) + m3**6*B0fin(0,0,m6sq,mudim)**2 + 54*m3sq*m6**4*B0fin(0,0,m6sq,mudim)**2 - 60*m6**6*B0fin(0,0,m6sq,mudim)**2 - 14*m3**4*m6sq*B0fin(0,0,m6sq,mudim)**2 + 2*m3**4*T134fin(m6,m6,m3,mudim) + 60*m6**4*T134fin(m6,m6,m3,mudim) - 24*m3sq*m6sq*T134fin(m6,m6,m3,mudim))/(2.*m3**8*(m3sq - 4*m6sq)**2)
		def eval_20():
			return (-2*m6sq*(m4sq*B0del(0,0,m4sq,mudim) + (m4sq - 2*m6sq)*B0del(0,0,m6sq,mudim) - m4sq*B0fin(0,0,m4sq,mudim) - m4sq*B0fin(0,0,m6sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + m4sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) - m6sq*B0fin(0,0,m6sq,mudim)**2))/(m4**6*(-m3sq + m4sq)*(m4sq - 4*m6sq)) + (6*m3sq*m4sq - 8*m3sq*m6sq - 4*m4sq*m6sq + 2*(m3sq*(m4sq - 4*m6sq) - 2*m4sq*m6sq)*B0del(0,0,m6sq,mudim) - 2*(2*m4sq*m6sq + m3sq*(3*m4sq + 4*m6sq))*B0fin(0,0,m6sq,mudim) + (m3sq*(m4sq - 4*m6sq) - 2*m4sq*m6sq)*B0fin(0,0,m6sq,mudim)**2)/(2.*m3**4*m4**6) + T134fin(m6,m6,m3,mudim)/(m3**4*(m3sq - m4sq)**2) + ((m3sq - m4sq)*(m4sq - 2*m6sq)*(m4sq + 2*m6sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 4*m6sq*B0fin(0,0,m6sq,mudim)) + (-2*m4**4 + m3sq*(m4sq - 6*m6sq) + 10*m4sq*m6sq)*T134fin(m6,m6,m4,mudim))/(m4**6*(m3sq - m4sq)**2*(m4sq - 4*m6sq))
		def eval_21():
			return (-2*m6sq*(m3sq*B0del(0,0,m3sq,mudim) + (m3sq - 2*m6sq)*B0del(0,0,m6sq,mudim) - m3sq*B0fin(0,0,m3sq,mudim) - m3sq*B0fin(0,0,m6sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + m3sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) - m6sq*B0fin(0,0,m6sq,mudim)**2))/(m3**6*(m3sq - m5sq)*(m3sq - 4*m6sq)) + (6*m3sq*m5sq - 4*m3sq*m6sq - 8*m5sq*m6sq + 2*(m3sq*(m5sq - 2*m6sq) - 4*m5sq*m6sq)*B0del(0,0,m6sq,mudim) - 2*(4*m5sq*m6sq + m3sq*(3*m5sq + 2*m6sq))*B0fin(0,0,m6sq,mudim) + (m3sq*(m5sq - 2*m6sq) - 4*m5sq*m6sq)*B0fin(0,0,m6sq,mudim)**2)/(2.*m3**6*m5**4) + (-((m3sq - m5sq)*(m3sq - 2*m6sq)*(m3sq + 2*m6sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 4*m6sq*B0fin(0,0,m6sq,mudim))) + (-2*m3**4 - 6*m5sq*m6sq + m3sq*(m5sq + 10*m6sq))*T134fin(m6,m6,m3,mudim))/(m3**6*(m3sq - m5sq)**2*(m3sq - 4*m6sq)) + T134fin(m6,m6,m5,mudim)/(m5**4*(m3sq - m5sq)**2)
		def eval_22():
			return (6*m3sq*m4sq*m5sq - 4*m3sq*m4sq*m6sq - 4*m3sq*m5sq*m6sq - 4*m4sq*m5sq*m6sq + 2*(-2*m4sq*m5sq*m6sq + m3sq*(m4sq*(m5sq - 2*m6sq) - 2*m5sq*m6sq))*B0del(0,0,m6sq,mudim) - 2*(2*m4sq*m5sq*m6sq + m3sq*(2*m5sq*m6sq + m4sq*(3*m5sq + 2*m6sq)))*B0fin(0,0,m6sq,mudim) + (-2*m4sq*m5sq*m6sq + m3sq*(m4sq*(m5sq - 2*m6sq) - 2*m5sq*m6sq))*B0fin(0,0,m6sq,mudim)**2)/(2.*m3**4*m4**4*m5**4) + T134fin(m6,m6,m3,mudim)/(m3**4*(m3sq - m4sq)*(m3sq - m5sq)) + T134fin(m6,m6,m4,mudim)/(m4**4*(-m3sq + m4sq)*(m4sq - m5sq)) + T134fin(m6,m6,m5,mudim)/(m5**4*(-m3sq + m5sq)*(-m4sq + m5sq))
		def eval_23():
			return -0.013888888888888888*(1 + 12*B0fin(0,0,m1sq,mudim))/m1**6
		def eval_24():
			return -0.013888888888888888*(1 + 12*B0fin(0,0,m1sq,mudim))/m1**6
		def eval_25():
			return (m1**6 + 27*m1sq*m2**4 - 37*m2**6 - 15*m1**4*m2sq - 12*m2**4*(m1sq + m2sq)*B0del(0,0,m2sq,mudim) - 4*(m1**6 + 6*m1sq*m2**4 + 5*m2**6 - 6*m1**4*m2sq)*B0fin(0,0,m2sq,mudim) - 6*m2**4*(m1sq + m2sq)*B0fin(0,0,m2sq,mudim)**2 + 12*m2**4*T134fin(m2,m1,0,mudim))/(12.*(-(m1sq*m2) + m2**3)**4)
		def eval_26():
			return (m1**6 + 27*m1sq*m2**4 - 37*m2**6 - 15*m1**4*m2sq - 12*m2**4*(m1sq + m2sq)*B0del(0,0,m2sq,mudim) - 4*(m1**6 + 6*m1sq*m2**4 + 5*m2**6 - 6*m1**4*m2sq)*B0fin(0,0,m2sq,mudim) - 6*m2**4*(m1sq + m2sq)*B0fin(0,0,m2sq,mudim)**2 + 12*m2**4*T134fin(m2,m1,0,mudim))/(12.*(-(m1sq*m2) + m2**3)**4)
		def eval_27():
			return (m1**4 + 6*m3**4 - 3*m1sq*m3sq - m3**4*B0del(0,0,m1sq,mudim) + (3*m3**4 + 2*m1sq*m3sq)*B0del(0,0,m3sq,mudim) + m3**4*B0fin(0,0,m1sq,mudim) - 2*m1sq*m3sq*B0fin(0,0,m1sq,mudim) - m1**4*B0fin(0,0,m3sq,mudim) + 6*m3**4*B0fin(0,0,m3sq,mudim) - m3**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 2*m3**4*B0fin(0,0,m3sq,mudim)**2 + m1sq*m3sq*B0fin(0,0,m3sq,mudim)**2 - 2*m3sq*T134fin(m3,m1,0,mudim))/(m3**2*(m1sq - m3sq)**4)
		def eval_28():
			return (m1**4 + 6*m3**4 - 3*m1sq*m3sq - m3**4*B0del(0,0,m1sq,mudim) + (3*m3**4 + 2*m1sq*m3sq)*B0del(0,0,m3sq,mudim) + m3**4*B0fin(0,0,m1sq,mudim) - 2*m1sq*m3sq*B0fin(0,0,m1sq,mudim) - m1**4*B0fin(0,0,m3sq,mudim) + 6*m3**4*B0fin(0,0,m3sq,mudim) - m3**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 2*m3**4*B0fin(0,0,m3sq,mudim)**2 + m1sq*m3sq*B0fin(0,0,m3sq,mudim)**2 - 2*m3sq*T134fin(m3,m1,0,mudim))/(m3**2*(m1sq - m3sq)**4)
		def eval_29():
			return -0.5*(-5*m1**4 - m4**4 + 10*m1sq*m4sq - 4*m1sq*m4sq*B0del(0,0,m1sq,mudim) + 2*(m1**4 + 3*m1sq*m4sq)*B0del(0,0,m4sq,mudim) - 6*m1**4*B0fin(0,0,m1sq,mudim) + m4**4*B0fin(0,0,m1sq,mudim) + m1sq*m4sq*B0fin(0,0,m1sq,mudim) - 2*m1**4*B0fin(0,0,m4sq,mudim) + m4**4*B0fin(0,0,m4sq,mudim) + 9*m1sq*m4sq*B0fin(0,0,m4sq,mudim) - 4*m1sq*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + m1**4*B0fin(0,0,m4sq,mudim)**2 + 5*m1sq*m4sq*B0fin(0,0,m4sq,mudim)**2 - 2*m1sq*T134fin(m4,m1,0,mudim))/(m1**2*(m1 - m4)**4*(m1 + m4)**4)
		def eval_30():
			return -0.5*(-5*m1**4 - m4**4 + 10*m1sq*m4sq - 4*m1sq*m4sq*B0del(0,0,m1sq,mudim) + 2*(m1**4 + 3*m1sq*m4sq)*B0del(0,0,m4sq,mudim) - 6*m1**4*B0fin(0,0,m1sq,mudim) + m4**4*B0fin(0,0,m1sq,mudim) + m1sq*m4sq*B0fin(0,0,m1sq,mudim) - 2*m1**4*B0fin(0,0,m4sq,mudim) + m4**4*B0fin(0,0,m4sq,mudim) + 9*m1sq*m4sq*B0fin(0,0,m4sq,mudim) - 4*m1sq*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + m1**4*B0fin(0,0,m4sq,mudim)**2 + 5*m1sq*m4sq*B0fin(0,0,m4sq,mudim)**2 - 2*m1sq*T134fin(m4,m1,0,mudim))/(m1**2*(m1 - m4)**4*(m1 + m4)**4)
		def eval_31():
			return -0.5*(-m1**4 - 5*m3**4 + 10*m1sq*m3sq + 2*(m3**4 + 3*m1sq*m3sq)*B0del(0,0,m1sq,mudim) - 4*m1sq*m3sq*B0del(0,0,m3sq,mudim) + m1**4*B0fin(0,0,m1sq,mudim) - 2*m3**4*B0fin(0,0,m1sq,mudim) + 9*m1sq*m3sq*B0fin(0,0,m1sq,mudim) + m3**4*B0fin(0,0,m1sq,mudim)**2 + 5*m1sq*m3sq*B0fin(0,0,m1sq,mudim)**2 + m1**4*B0fin(0,0,m3sq,mudim) - 6*m3**4*B0fin(0,0,m3sq,mudim) + m1sq*m3sq*B0fin(0,0,m3sq,mudim) - 4*m1sq*m3sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 2*m3sq*T134fin(m3,m1,0,mudim))/((m1 - m3)**4*m3**2*(m1 + m3)**4)
		def eval_32():
			return -0.5*(-m1**4 - 5*m3**4 + 10*m1sq*m3sq + 2*(m3**4 + 3*m1sq*m3sq)*B0del(0,0,m1sq,mudim) - 4*m1sq*m3sq*B0del(0,0,m3sq,mudim) + m1**4*B0fin(0,0,m1sq,mudim) - 2*m3**4*B0fin(0,0,m1sq,mudim) + 9*m1sq*m3sq*B0fin(0,0,m1sq,mudim) + m3**4*B0fin(0,0,m1sq,mudim)**2 + 5*m1sq*m3sq*B0fin(0,0,m1sq,mudim)**2 + m1**4*B0fin(0,0,m3sq,mudim) - 6*m3**4*B0fin(0,0,m3sq,mudim) + m1sq*m3sq*B0fin(0,0,m3sq,mudim) - 4*m1sq*m3sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 2*m3sq*T134fin(m3,m1,0,mudim))/((m1 - m3)**4*m3**2*(m1 + m3)**4)
		def eval_33():
			return (6*m1**4 + m4**4 - 3*m1sq*m4sq + (3*m1**4 + 2*m1sq*m4sq)*B0del(0,0,m1sq,mudim) - m1**4*B0del(0,0,m4sq,mudim) + 6*m1**4*B0fin(0,0,m1sq,mudim) - m4**4*B0fin(0,0,m1sq,mudim) + 2*m1**4*B0fin(0,0,m1sq,mudim)**2 + m1sq*m4sq*B0fin(0,0,m1sq,mudim)**2 + m1**4*B0fin(0,0,m4sq,mudim) - 2*m1sq*m4sq*B0fin(0,0,m4sq,mudim) - m1**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 2*m1sq*T134fin(m4,m1,0,mudim))/(m1**2*(m1sq - m4sq)**4)
		def eval_34():
			return (6*m1**4 + m4**4 - 3*m1sq*m4sq + (3*m1**4 + 2*m1sq*m4sq)*B0del(0,0,m1sq,mudim) - m1**4*B0del(0,0,m4sq,mudim) + 6*m1**4*B0fin(0,0,m1sq,mudim) - m4**4*B0fin(0,0,m1sq,mudim) + 2*m1**4*B0fin(0,0,m1sq,mudim)**2 + m1sq*m4sq*B0fin(0,0,m1sq,mudim)**2 + m1**4*B0fin(0,0,m4sq,mudim) - 2*m1sq*m4sq*B0fin(0,0,m4sq,mudim) - m1**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 2*m1sq*T134fin(m4,m1,0,mudim))/(m1**2*(m1sq - m4sq)**4)
		def eval_35():
			return (-37*m1**6 - 15*m1sq*m5**4 + m5**6 + 27*m1**4*m5sq - 12*m1**4*(m1sq + m5sq)*B0del(0,0,m1sq,mudim) - 4*(5*m1**6 - 6*m1sq*m5**4 + m5**6 + 6*m1**4*m5sq)*B0fin(0,0,m1sq,mudim) - 6*m1**4*(m1sq + m5sq)*B0fin(0,0,m1sq,mudim)**2 + 12*m1**4*T134fin(m5,m1,0,mudim))/(12.*(m1**3 - m1*m5sq)**4)
		def eval_36():
			return (-37*m1**6 - 15*m1sq*m5**4 + m5**6 + 27*m1**4*m5sq - 12*m1**4*(m1sq + m5sq)*B0del(0,0,m1sq,mudim) - 4*(5*m1**6 - 6*m1sq*m5**4 + m5**6 + 6*m1**4*m5sq)*B0fin(0,0,m1sq,mudim) - 6*m1**4*(m1sq + m5sq)*B0fin(0,0,m1sq,mudim)**2 + 12*m1**4*T134fin(m5,m1,0,mudim))/(12.*(m1**3 - m1*m5sq)**4)
		def eval_37():
			return (2*(m1sq - m2sq)*m3sq*(m1**4*(m2sq + m3sq) + m3sq*(m2**4 + 4*m3**4 - 3*m2sq*m3sq) + m1sq*(m2**4 - 3*m3**4 - 2*m2sq*m3sq))*B0del(0,0,m3sq,mudim) - 2*(2*m2**6*m3**4 - 7*m2**4*m3**6 + 7*m2sq*m3**8 - m1**4*(m2**6 - 7*m3**6) + m1sq*(m2**6 - 7*m3**6)*m3sq + m1**6*(m2**4 - 2*m3**4 - m2sq*m3sq))*B0fin(0,0,m3sq,mudim) + (m1sq - m2sq)*m3sq*(m1**4*(m2sq + m3sq) + m3sq*(m2**4 + 4*m3**4 - 3*m2sq*m3sq) + m1sq*(m2**4 - 3*m3**4 - 2*m2sq*m3sq))*B0fin(0,0,m3sq,mudim)**2 + 2*((m1sq - m2sq)*(3*m2**4*m3**4 - 8*m2sq*m3**6 + 7*m3**8 - 2*m1sq*m3sq*(m2**4 + 4*m3**4 - 3*m2sq*m3sq) + m1**4*(m2**4 + 3*m3**4 - 2*m2sq*m3sq)) + (m2sq - m3sq)**3*m3sq*T134fin(m3,m1,0,mudim) + m3sq*(-m1sq + m3sq)**3*T134fin(m3,m2,0,mudim)))/(2.*(m1sq - m2sq)*m3**2*(m1sq - m3sq)**3*(m2sq - m3sq)**3)
		def eval_38():
			return (2*(m1sq - m2sq)*m3sq*(m1**4*(m2sq + m3sq) + m3sq*(m2**4 + 4*m3**4 - 3*m2sq*m3sq) + m1sq*(m2**4 - 3*m3**4 - 2*m2sq*m3sq))*B0del(0,0,m3sq,mudim) - 2*(2*m2**6*m3**4 - 7*m2**4*m3**6 + 7*m2sq*m3**8 - m1**4*(m2**6 - 7*m3**6) + m1sq*(m2**6 - 7*m3**6)*m3sq + m1**6*(m2**4 - 2*m3**4 - m2sq*m3sq))*B0fin(0,0,m3sq,mudim) + (m1sq - m2sq)*m3sq*(m1**4*(m2sq + m3sq) + m3sq*(m2**4 + 4*m3**4 - 3*m2sq*m3sq) + m1sq*(m2**4 - 3*m3**4 - 2*m2sq*m3sq))*B0fin(0,0,m3sq,mudim)**2 + 2*((m1sq - m2sq)*(3*m2**4*m3**4 - 8*m2sq*m3**6 + 7*m3**8 - 2*m1sq*m3sq*(m2**4 + 4*m3**4 - 3*m2sq*m3sq) + m1**4*(m2**4 + 3*m3**4 - 2*m2sq*m3sq)) + (m2sq - m3sq)**3*m3sq*T134fin(m3,m1,0,mudim) + m3sq*(-m1sq + m3sq)**3*T134fin(m3,m2,0,mudim)))/(2.*(m1sq - m2sq)*m3**2*(m1sq - m3sq)**3*(m2sq - m3sq)**3)
		def eval_39():
			return -((m4**4*(B0del(0,0,m2sq,mudim) + B0del(0,0,m4sq,mudim) - B0fin(0,0,m2sq,mudim) - B0fin(0,0,m4sq,mudim) + B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim)))/((m1sq - m2sq)*(m2sq - m4sq)**4)) + (m2sq*m4sq*(B0del(0,0,m2sq,mudim) + B0del(0,0,m4sq,mudim) - B0fin(0,0,m2sq,mudim) - B0fin(0,0,m4sq,mudim) + B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim)))/((m1sq - m2sq)*(m2sq - m4sq)**4) + (4*(2*m1sq + m2sq - 3*m4sq)*m4sq + 2*((m2sq - 5*m4sq)*m4sq + m1sq*(m2sq + 3*m4sq))*B0del(0,0,m4sq,mudim) - 2*(7*m4**4 + m1sq*(m2sq - 5*m4sq) - 3*m2sq*m4sq)*B0fin(0,0,m4sq,mudim) + ((m2sq - 5*m4sq)*m4sq + m1sq*(m2sq + 3*m4sq))*B0fin(0,0,m4sq,mudim)**2)/(2.*(m1sq - m4sq)**2*(-m2sq + m4sq)**3) + T134fin(m4,m1,0,mudim)/((m1sq - m2sq)**2*(m1sq - m4sq)**2) + ((m1sq - m2sq)*(m2sq + m4sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim)) + (m1sq - 2*m2sq + m4sq)*T134fin(m4,m2,0,mudim))/((m1sq - m2sq)**2*(m2sq - m4sq)**3)
		def eval_40():
			return -((m4**4*(B0del(0,0,m2sq,mudim) + B0del(0,0,m4sq,mudim) - B0fin(0,0,m2sq,mudim) - B0fin(0,0,m4sq,mudim) + B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim)))/((m1sq - m2sq)*(m2sq - m4sq)**4)) + (m2sq*m4sq*(B0del(0,0,m2sq,mudim) + B0del(0,0,m4sq,mudim) - B0fin(0,0,m2sq,mudim) - B0fin(0,0,m4sq,mudim) + B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim)))/((m1sq - m2sq)*(m2sq - m4sq)**4) + (4*(2*m1sq + m2sq - 3*m4sq)*m4sq + 2*((m2sq - 5*m4sq)*m4sq + m1sq*(m2sq + 3*m4sq))*B0del(0,0,m4sq,mudim) - 2*(7*m4**4 + m1sq*(m2sq - 5*m4sq) - 3*m2sq*m4sq)*B0fin(0,0,m4sq,mudim) + ((m2sq - 5*m4sq)*m4sq + m1sq*(m2sq + 3*m4sq))*B0fin(0,0,m4sq,mudim)**2)/(2.*(m1sq - m4sq)**2*(-m2sq + m4sq)**3) + T134fin(m4,m1,0,mudim)/((m1sq - m2sq)**2*(m1sq - m4sq)**2) + ((m1sq - m2sq)*(m2sq + m4sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim)) + (m1sq - 2*m2sq + m4sq)*T134fin(m4,m2,0,mudim))/((m1sq - m2sq)**2*(m2sq - m4sq)**3)
		def eval_41():
			return (4*m2sq*(2*m1sq - 3*m2sq + m4sq) + 2*(-5*m2**4 + m2sq*m4sq + m1sq*(3*m2sq + m4sq))*B0del(0,0,m2sq,mudim) + 2*(-7*m2**4 + m1sq*(5*m2sq - m4sq) + 3*m2sq*m4sq)*B0fin(0,0,m2sq,mudim) + (-5*m2**4 + m2sq*m4sq + m1sq*(3*m2sq + m4sq))*B0fin(0,0,m2sq,mudim)**2)/(2.*(m1sq - m2sq)**2*(m2sq - m4sq)**3) + (m2sq*m4sq*(B0del(0,0,m2sq,mudim) + B0del(0,0,m4sq,mudim) - B0fin(0,0,m2sq,mudim) - B0fin(0,0,m4sq,mudim) + B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim)))/((m1sq - m4sq)*(m2sq - m4sq)**4) + (m2**4*(B0del(0,0,m2sq,mudim) + B0del(0,0,m4sq,mudim) - B0fin(0,0,m2sq,mudim) - B0fin(0,0,m4sq,mudim) + B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim)))/((m2sq - m4sq)**4*(-m1sq + m4sq)) + T134fin(m2,m1,0,mudim)/((m1sq - m2sq)**2*(m1sq - m4sq)**2) + ((m1sq - m4sq)*(m2sq + m4sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim)) + (m1sq + m2sq - 2*m4sq)*T134fin(m4,m2,0,mudim))/((m1sq - m4sq)**2*(-m2sq + m4sq)**3)
		def eval_42():
			return (4*m2sq*(2*m1sq - 3*m2sq + m4sq) + 2*(-5*m2**4 + m2sq*m4sq + m1sq*(3*m2sq + m4sq))*B0del(0,0,m2sq,mudim) + 2*(-7*m2**4 + m1sq*(5*m2sq - m4sq) + 3*m2sq*m4sq)*B0fin(0,0,m2sq,mudim) + (-5*m2**4 + m2sq*m4sq + m1sq*(3*m2sq + m4sq))*B0fin(0,0,m2sq,mudim)**2)/(2.*(m1sq - m2sq)**2*(m2sq - m4sq)**3) + (m2sq*m4sq*(B0del(0,0,m2sq,mudim) + B0del(0,0,m4sq,mudim) - B0fin(0,0,m2sq,mudim) - B0fin(0,0,m4sq,mudim) + B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim)))/((m1sq - m4sq)*(m2sq - m4sq)**4) + (m2**4*(B0del(0,0,m2sq,mudim) + B0del(0,0,m4sq,mudim) - B0fin(0,0,m2sq,mudim) - B0fin(0,0,m4sq,mudim) + B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim)))/((m2sq - m4sq)**4*(-m1sq + m4sq)) + T134fin(m2,m1,0,mudim)/((m1sq - m2sq)**2*(m1sq - m4sq)**2) + ((m1sq - m4sq)*(m2sq + m4sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim)) + (m1sq + m2sq - 2*m4sq)*T134fin(m4,m2,0,mudim))/((m1sq - m4sq)**2*(-m2sq + m4sq)**3)
		def eval_43():
			return (2*m2sq*(m1sq - m5sq)*(m1**4*(m2sq + m5sq) + m2sq*(4*m2**4 + m5**4 - 3*m2sq*m5sq) + m1sq*(-3*m2**4 + m5**4 - 2*m2sq*m5sq))*B0del(0,0,m2sq,mudim) + 2*(7*m2**6*m5**4 - 2*m2**4*m5**6 + m1**4*(-7*m2**6 + m5**6) + m1sq*(7*m2**8 - m2sq*m5**6) - 7*m2**8*m5sq + m1**6*(2*m2**4 - m5**4 + m2sq*m5sq))*B0fin(0,0,m2sq,mudim) + m2sq*(m1sq - m5sq)*(m1**4*(m2sq + m5sq) + m2sq*(4*m2**4 + m5**4 - 3*m2sq*m5sq) + m1sq*(-3*m2**4 + m5**4 - 2*m2sq*m5sq))*B0fin(0,0,m2sq,mudim)**2 + 2*((m1sq - m5sq)*(7*m2**8 + 3*m2**4*m5**4 - 8*m2**6*m5sq - 2*m1sq*m2sq*(4*m2**4 + m5**4 - 3*m2sq*m5sq) + m1**4*(3*m2**4 + m5**4 - 2*m2sq*m5sq)) - m2sq*(m2sq - m5sq)**3*T134fin(m2,m1,0,mudim) + m2sq*(-m1sq + m2sq)**3*T134fin(m5,m2,0,mudim)))/(2.*m2**2*(-m1sq + m2sq)**3*(m1sq - m5sq)*(m2sq - m5sq)**3)
		def eval_44():
			return (2*m2sq*(m1sq - m5sq)*(m1**4*(m2sq + m5sq) + m2sq*(4*m2**4 + m5**4 - 3*m2sq*m5sq) + m1sq*(-3*m2**4 + m5**4 - 2*m2sq*m5sq))*B0del(0,0,m2sq,mudim) + 2*(7*m2**6*m5**4 - 2*m2**4*m5**6 + m1**4*(-7*m2**6 + m5**6) + m1sq*(7*m2**8 - m2sq*m5**6) - 7*m2**8*m5sq + m1**6*(2*m2**4 - m5**4 + m2sq*m5sq))*B0fin(0,0,m2sq,mudim) + m2sq*(m1sq - m5sq)*(m1**4*(m2sq + m5sq) + m2sq*(4*m2**4 + m5**4 - 3*m2sq*m5sq) + m1sq*(-3*m2**4 + m5**4 - 2*m2sq*m5sq))*B0fin(0,0,m2sq,mudim)**2 + 2*((m1sq - m5sq)*(7*m2**8 + 3*m2**4*m5**4 - 8*m2**6*m5sq - 2*m1sq*m2sq*(4*m2**4 + m5**4 - 3*m2sq*m5sq) + m1**4*(3*m2**4 + m5**4 - 2*m2sq*m5sq)) - m2sq*(m2sq - m5sq)**3*T134fin(m2,m1,0,mudim) + m2sq*(-m1sq + m2sq)**3*T134fin(m5,m2,0,mudim)))/(2.*m2**2*(-m1sq + m2sq)**3*(m1sq - m5sq)*(m2sq - m5sq)**3)
		def eval_45():
			return (m4**4*(B0del(0,0,m1sq,mudim) + B0del(0,0,m4sq,mudim) - B0fin(0,0,m1sq,mudim) - B0fin(0,0,m4sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim)))/((m1sq - m3sq)*(m1sq - m4sq)**4) - (m1sq*m4sq*(B0del(0,0,m1sq,mudim) + B0del(0,0,m4sq,mudim) - B0fin(0,0,m1sq,mudim) - B0fin(0,0,m4sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim)))/((m1sq - m3sq)*(m1sq - m4sq)**4) + (4*m4sq*(-m1sq - 2*m3sq + 3*m4sq) - 2*(-5*m4**4 + 3*m3sq*m4sq + m1sq*(m3sq + m4sq))*B0del(0,0,m4sq,mudim) + 2*(7*m4**4 + m1sq*(m3sq - 3*m4sq) - 5*m3sq*m4sq)*B0fin(0,0,m4sq,mudim) - (-5*m4**4 + 3*m3sq*m4sq + m1sq*(m3sq + m4sq))*B0fin(0,0,m4sq,mudim)**2)/(2.*(m1sq - m4sq)**3*(m3sq - m4sq)**2) + (-((m1sq - m3sq)*(m1sq + m4sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim))) + (-2*m1sq + m3sq + m4sq)*T134fin(m4,m1,0,mudim))/((m1sq - m3sq)**2*(m1sq - m4sq)**3) + T134fin(m4,m3,0,mudim)/((m1sq - m3sq)**2*(m3sq - m4sq)**2)
		def eval_46():
			return (m4**4*(B0del(0,0,m1sq,mudim) + B0del(0,0,m4sq,mudim) - B0fin(0,0,m1sq,mudim) - B0fin(0,0,m4sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim)))/((m1sq - m3sq)*(m1sq - m4sq)**4) - (m1sq*m4sq*(B0del(0,0,m1sq,mudim) + B0del(0,0,m4sq,mudim) - B0fin(0,0,m1sq,mudim) - B0fin(0,0,m4sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim)))/((m1sq - m3sq)*(m1sq - m4sq)**4) + (4*m4sq*(-m1sq - 2*m3sq + 3*m4sq) - 2*(-5*m4**4 + 3*m3sq*m4sq + m1sq*(m3sq + m4sq))*B0del(0,0,m4sq,mudim) + 2*(7*m4**4 + m1sq*(m3sq - 3*m4sq) - 5*m3sq*m4sq)*B0fin(0,0,m4sq,mudim) - (-5*m4**4 + 3*m3sq*m4sq + m1sq*(m3sq + m4sq))*B0fin(0,0,m4sq,mudim)**2)/(2.*(m1sq - m4sq)**3*(m3sq - m4sq)**2) + (-((m1sq - m3sq)*(m1sq + m4sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim))) + (-2*m1sq + m3sq + m4sq)*T134fin(m4,m1,0,mudim))/((m1sq - m3sq)**2*(m1sq - m4sq)**3) + T134fin(m4,m3,0,mudim)/((m1sq - m3sq)**2*(m3sq - m4sq)**2)
		def eval_47():
			return (m3**4*(B0del(0,0,m1sq,mudim) + B0del(0,0,m3sq,mudim) - B0fin(0,0,m1sq,mudim) - B0fin(0,0,m3sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim)))/((m1sq - m3sq)**4*(m1sq - m5sq)) - (m1sq*m3sq*(B0del(0,0,m1sq,mudim) + B0del(0,0,m3sq,mudim) - B0fin(0,0,m1sq,mudim) - B0fin(0,0,m3sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim)))/((m1sq - m3sq)**4*(m1sq - m5sq)) + (4*m3sq*(-m1sq + 3*m3sq - 2*m5sq) - 2*(-5*m3**4 + 3*m3sq*m5sq + m1sq*(m3sq + m5sq))*B0del(0,0,m3sq,mudim) + 2*(7*m3**4 - 5*m3sq*m5sq + m1sq*(-3*m3sq + m5sq))*B0fin(0,0,m3sq,mudim) - (-5*m3**4 + 3*m3sq*m5sq + m1sq*(m3sq + m5sq))*B0fin(0,0,m3sq,mudim)**2)/(2.*(m1sq - m3sq)**3*(m3sq - m5sq)**2) + (-((m1sq - m5sq)*(m1sq + m3sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim))) + (-2*m1sq + m3sq + m5sq)*T134fin(m3,m1,0,mudim))/((m1sq - m3sq)**3*(m1sq - m5sq)**2) + T134fin(m5,m3,0,mudim)/((m1sq - m5sq)**2*(m3sq - m5sq)**2)
		def eval_48():
			return (m3**4*(B0del(0,0,m1sq,mudim) + B0del(0,0,m3sq,mudim) - B0fin(0,0,m1sq,mudim) - B0fin(0,0,m3sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim)))/((m1sq - m3sq)**4*(m1sq - m5sq)) - (m1sq*m3sq*(B0del(0,0,m1sq,mudim) + B0del(0,0,m3sq,mudim) - B0fin(0,0,m1sq,mudim) - B0fin(0,0,m3sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim)))/((m1sq - m3sq)**4*(m1sq - m5sq)) + (4*m3sq*(-m1sq + 3*m3sq - 2*m5sq) - 2*(-5*m3**4 + 3*m3sq*m5sq + m1sq*(m3sq + m5sq))*B0del(0,0,m3sq,mudim) + 2*(7*m3**4 - 5*m3sq*m5sq + m1sq*(-3*m3sq + m5sq))*B0fin(0,0,m3sq,mudim) - (-5*m3**4 + 3*m3sq*m5sq + m1sq*(m3sq + m5sq))*B0fin(0,0,m3sq,mudim)**2)/(2.*(m1sq - m3sq)**3*(m3sq - m5sq)**2) + (-((m1sq - m5sq)*(m1sq + m3sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim))) + (-2*m1sq + m3sq + m5sq)*T134fin(m3,m1,0,mudim))/((m1sq - m3sq)**3*(m1sq - m5sq)**2) + T134fin(m5,m3,0,mudim)/((m1sq - m5sq)**2*(m3sq - m5sq)**2)
		def eval_49():
			return (4*m1sq*(-3*m1sq + 2*m3sq + m4sq) + 2*(-5*m1**4 + m3sq*m4sq + m1sq*(3*m3sq + m4sq))*B0del(0,0,m1sq,mudim) - 2*(7*m1**4 + m3sq*m4sq - m1sq*(5*m3sq + 3*m4sq))*B0fin(0,0,m1sq,mudim) + (-5*m1**4 + m3sq*m4sq + m1sq*(3*m3sq + m4sq))*B0fin(0,0,m1sq,mudim)**2)/(2.*(m1sq - m3sq)**2*(m1sq - m4sq)**3) + (m1**4*(B0del(0,0,m1sq,mudim) + B0del(0,0,m4sq,mudim) - B0fin(0,0,m1sq,mudim) - B0fin(0,0,m4sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim)))/((m1sq - m4sq)**4*(-m3sq + m4sq)) - (m1sq*m4sq*(B0del(0,0,m1sq,mudim) + B0del(0,0,m4sq,mudim) - B0fin(0,0,m1sq,mudim) - B0fin(0,0,m4sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim)))/((m1sq - m4sq)**4*(-m3sq + m4sq)) + T134fin(m3,m1,0,mudim)/((m1sq - m3sq)**2*(m3sq - m4sq)**2) - ((m3sq - m4sq)*(m1sq + m4sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim)) + (m1sq + m3sq - 2*m4sq)*T134fin(m4,m1,0,mudim))/((m1sq - m4sq)**3*(m3sq - m4sq)**2)
		def eval_50():
			return (4*m1sq*(-3*m1sq + 2*m3sq + m4sq) + 2*(-5*m1**4 + m3sq*m4sq + m1sq*(3*m3sq + m4sq))*B0del(0,0,m1sq,mudim) - 2*(7*m1**4 + m3sq*m4sq - m1sq*(5*m3sq + 3*m4sq))*B0fin(0,0,m1sq,mudim) + (-5*m1**4 + m3sq*m4sq + m1sq*(3*m3sq + m4sq))*B0fin(0,0,m1sq,mudim)**2)/(2.*(m1sq - m3sq)**2*(m1sq - m4sq)**3) + (m1**4*(B0del(0,0,m1sq,mudim) + B0del(0,0,m4sq,mudim) - B0fin(0,0,m1sq,mudim) - B0fin(0,0,m4sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim)))/((m1sq - m4sq)**4*(-m3sq + m4sq)) - (m1sq*m4sq*(B0del(0,0,m1sq,mudim) + B0del(0,0,m4sq,mudim) - B0fin(0,0,m1sq,mudim) - B0fin(0,0,m4sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim)))/((m1sq - m4sq)**4*(-m3sq + m4sq)) + T134fin(m3,m1,0,mudim)/((m1sq - m3sq)**2*(m3sq - m4sq)**2) - ((m3sq - m4sq)*(m1sq + m4sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim)) + (m1sq + m3sq - 2*m4sq)*T134fin(m4,m1,0,mudim))/((m1sq - m4sq)**3*(m3sq - m4sq)**2)
		def eval_51():
			return (4*m1sq*(-3*m1sq + m3sq + 2*m5sq) + 2*(-5*m1**4 + m3sq*m5sq + m1sq*(m3sq + 3*m5sq))*B0del(0,0,m1sq,mudim) - 2*(7*m1**4 + m3sq*m5sq - m1sq*(3*m3sq + 5*m5sq))*B0fin(0,0,m1sq,mudim) + (-5*m1**4 + m3sq*m5sq + m1sq*(m3sq + 3*m5sq))*B0fin(0,0,m1sq,mudim)**2)/(2.*(m1sq - m3sq)**3*(m1sq - m5sq)**2) + (m1**4*(B0del(0,0,m1sq,mudim) + B0del(0,0,m3sq,mudim) - B0fin(0,0,m1sq,mudim) - B0fin(0,0,m3sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim)))/((m1sq - m3sq)**4*(m3sq - m5sq)) - (m1sq*m3sq*(B0del(0,0,m1sq,mudim) + B0del(0,0,m3sq,mudim) - B0fin(0,0,m1sq,mudim) - B0fin(0,0,m3sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim)))/((m1sq - m3sq)**4*(m3sq - m5sq)) + ((m3sq - m5sq)*(m1sq + m3sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim)) - (m1sq - 2*m3sq + m5sq)*T134fin(m3,m1,0,mudim))/((m1sq - m3sq)**3*(m3sq - m5sq)**2) + T134fin(m5,m1,0,mudim)/((m1sq - m5sq)**2*(m3sq - m5sq)**2)
		def eval_52():
			return (4*m1sq*(-3*m1sq + m3sq + 2*m5sq) + 2*(-5*m1**4 + m3sq*m5sq + m1sq*(m3sq + 3*m5sq))*B0del(0,0,m1sq,mudim) - 2*(7*m1**4 + m3sq*m5sq - m1sq*(3*m3sq + 5*m5sq))*B0fin(0,0,m1sq,mudim) + (-5*m1**4 + m3sq*m5sq + m1sq*(m3sq + 3*m5sq))*B0fin(0,0,m1sq,mudim)**2)/(2.*(m1sq - m3sq)**3*(m1sq - m5sq)**2) + (m1**4*(B0del(0,0,m1sq,mudim) + B0del(0,0,m3sq,mudim) - B0fin(0,0,m1sq,mudim) - B0fin(0,0,m3sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim)))/((m1sq - m3sq)**4*(m3sq - m5sq)) - (m1sq*m3sq*(B0del(0,0,m1sq,mudim) + B0del(0,0,m3sq,mudim) - B0fin(0,0,m1sq,mudim) - B0fin(0,0,m3sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim)))/((m1sq - m3sq)**4*(m3sq - m5sq)) + ((m3sq - m5sq)*(m1sq + m3sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim)) - (m1sq - 2*m3sq + m5sq)*T134fin(m3,m1,0,mudim))/((m1sq - m3sq)**3*(m3sq - m5sq)**2) + T134fin(m5,m1,0,mudim)/((m1sq - m5sq)**2*(m3sq - m5sq)**2)
		def eval_53():
			return (2*m1sq*(m4sq - m5sq)*(4*m1**6 + m1sq*(m4sq - m5sq)**2 - 3*m1**4*(m4sq + m5sq) + m4sq*m5sq*(m4sq + m5sq))*B0del(0,0,m1sq,mudim) + 2*(-(m4**6*m5**4) + m4**4*m5**6 - 7*m1**6*(m4**4 - m5**4) + 2*m1**4*(m4**6 - m5**6) + 7*m1**8*(m4sq - m5sq) + m1sq*m4sq*(m4**4 - m5**4)*m5sq)*B0fin(0,0,m1sq,mudim) + m1sq*(m4sq - m5sq)*(4*m1**6 + m1sq*(m4sq - m5sq)**2 - 3*m1**4*(m4sq + m5sq) + m4sq*m5sq*(m4sq + m5sq))*B0fin(0,0,m1sq,mudim)**2 + 2*((m4sq - m5sq)*(7*m1**8 + m4**4*m5**4 - 8*m1**6*(m4sq + m5sq) - 2*m1sq*m4sq*m5sq*(m4sq + m5sq) + 3*m1**4*(m4sq + m5sq)**2) - m1sq*(m1sq - m5sq)**3*T134fin(m4,m1,0,mudim) + m1sq*(m1sq - m4sq)**3*T134fin(m5,m1,0,mudim)))/(2.*m1**2*(m1sq - m4sq)**3*(m1sq - m5sq)**3*(m4sq - m5sq))
		def eval_54():
			return (2*m1sq*(m4sq - m5sq)*(4*m1**6 + m1sq*(m4sq - m5sq)**2 - 3*m1**4*(m4sq + m5sq) + m4sq*m5sq*(m4sq + m5sq))*B0del(0,0,m1sq,mudim) + 2*(-(m4**6*m5**4) + m4**4*m5**6 - 7*m1**6*(m4**4 - m5**4) + 2*m1**4*(m4**6 - m5**6) + 7*m1**8*(m4sq - m5sq) + m1sq*m4sq*(m4**4 - m5**4)*m5sq)*B0fin(0,0,m1sq,mudim) + m1sq*(m4sq - m5sq)*(4*m1**6 + m1sq*(m4sq - m5sq)**2 - 3*m1**4*(m4sq + m5sq) + m4sq*m5sq*(m4sq + m5sq))*B0fin(0,0,m1sq,mudim)**2 + 2*((m4sq - m5sq)*(7*m1**8 + m4**4*m5**4 - 8*m1**6*(m4sq + m5sq) - 2*m1sq*m4sq*m5sq*(m4sq + m5sq) + 3*m1**4*(m4sq + m5sq)**2) - m1sq*(m1sq - m5sq)**3*T134fin(m4,m1,0,mudim) + m1sq*(m1sq - m4sq)**3*T134fin(m5,m1,0,mudim)))/(2.*m1**2*(m1sq - m4sq)**3*(m1sq - m5sq)**3*(m4sq - m5sq))
		def eval_55():
			return -0.5*(4*m4sq*(3*m4**4 + m2sq*(m3sq - 2*m4sq) + m1sq*(m2sq + m3sq - 2*m4sq) - 2*m3sq*m4sq) + 2*(-3*m3sq*m4**4 + 5*m4**6 + m2sq*(m3sq - 3*m4sq)*m4sq + m1sq*((m3sq - 3*m4sq)*m4sq + m2sq*(m3sq + m4sq)))*B0del(0,0,m4sq,mudim) - 2*(5*m3sq*m4**4 - 7*m4**6 + m2sq*(5*m4**4 - 3*m3sq*m4sq) + m1sq*(5*m4**4 + m2sq*(m3sq - 3*m4sq) - 3*m3sq*m4sq))*B0fin(0,0,m4sq,mudim) + (-3*m3sq*m4**4 + 5*m4**6 + m2sq*(m3sq - 3*m4sq)*m4sq + m1sq*((m3sq - 3*m4sq)*m4sq + m2sq*(m3sq + m4sq)))*B0fin(0,0,m4sq,mudim)**2)/((m1sq - m4sq)**2*(m2sq - m4sq)**2*(m3sq - m4sq)**2) + T134fin(m4,m1,0,mudim)/((m1sq - m2sq)*(m1sq - m3sq)*(m1sq - m4sq)**2) - T134fin(m4,m2,0,mudim)/((m1sq - m2sq)*(m2sq - m3sq)*(m2sq - m4sq)**2) - T134fin(m4,m3,0,mudim)/((m1sq - m3sq)*(-m2sq + m3sq)*(m3sq - m4sq)**2)
		def eval_56():
			return -0.5*(4*m4sq*(3*m4**4 + m2sq*(m3sq - 2*m4sq) + m1sq*(m2sq + m3sq - 2*m4sq) - 2*m3sq*m4sq) + 2*(-3*m3sq*m4**4 + 5*m4**6 + m2sq*(m3sq - 3*m4sq)*m4sq + m1sq*((m3sq - 3*m4sq)*m4sq + m2sq*(m3sq + m4sq)))*B0del(0,0,m4sq,mudim) - 2*(5*m3sq*m4**4 - 7*m4**6 + m2sq*(5*m4**4 - 3*m3sq*m4sq) + m1sq*(5*m4**4 + m2sq*(m3sq - 3*m4sq) - 3*m3sq*m4sq))*B0fin(0,0,m4sq,mudim) + (-3*m3sq*m4**4 + 5*m4**6 + m2sq*(m3sq - 3*m4sq)*m4sq + m1sq*((m3sq - 3*m4sq)*m4sq + m2sq*(m3sq + m4sq)))*B0fin(0,0,m4sq,mudim)**2)/((m1sq - m4sq)**2*(m2sq - m4sq)**2*(m3sq - m4sq)**2) + T134fin(m4,m1,0,mudim)/((m1sq - m2sq)*(m1sq - m3sq)*(m1sq - m4sq)**2) - T134fin(m4,m2,0,mudim)/((m1sq - m2sq)*(m2sq - m3sq)*(m2sq - m4sq)**2) - T134fin(m4,m3,0,mudim)/((m1sq - m3sq)*(-m2sq + m3sq)*(m3sq - m4sq)**2)
		def eval_57():
			return -0.5*(4*m3sq*(3*m3**4 - 2*m3sq*m5sq + m2sq*(-2*m3sq + m5sq) + m1sq*(m2sq - 2*m3sq + m5sq)) + 2*(5*m3**6 - 3*m3**4*m5sq + m2sq*(-3*m3**4 + m3sq*m5sq) + m1sq*(-3*m3**4 + m3sq*m5sq + m2sq*(m3sq + m5sq)))*B0del(0,0,m3sq,mudim) + 2*(7*m3**6 - 5*m3**4*m5sq + m2sq*(-5*m3**4 + 3*m3sq*m5sq) + m1sq*(-5*m3**4 + m2sq*(3*m3sq - m5sq) + 3*m3sq*m5sq))*B0fin(0,0,m3sq,mudim) + (5*m3**6 - 3*m3**4*m5sq + m2sq*(-3*m3**4 + m3sq*m5sq) + m1sq*(-3*m3**4 + m3sq*m5sq + m2sq*(m3sq + m5sq)))*B0fin(0,0,m3sq,mudim)**2)/((m1sq - m3sq)**2*(m2sq - m3sq)**2*(m3sq - m5sq)**2) + T134fin(m3,m1,0,mudim)/((m1sq - m2sq)*(m1sq - m3sq)**2*(m1sq - m5sq)) - T134fin(m3,m2,0,mudim)/((m1sq - m2sq)*(m2sq - m3sq)**2*(m2sq - m5sq)) - T134fin(m5,m3,0,mudim)/((m1sq - m5sq)*(m3sq - m5sq)**2*(-m2sq + m5sq))
		def eval_58():
			return -0.5*(4*m3sq*(3*m3**4 - 2*m3sq*m5sq + m2sq*(-2*m3sq + m5sq) + m1sq*(m2sq - 2*m3sq + m5sq)) + 2*(5*m3**6 - 3*m3**4*m5sq + m2sq*(-3*m3**4 + m3sq*m5sq) + m1sq*(-3*m3**4 + m3sq*m5sq + m2sq*(m3sq + m5sq)))*B0del(0,0,m3sq,mudim) + 2*(7*m3**6 - 5*m3**4*m5sq + m2sq*(-5*m3**4 + 3*m3sq*m5sq) + m1sq*(-5*m3**4 + m2sq*(3*m3sq - m5sq) + 3*m3sq*m5sq))*B0fin(0,0,m3sq,mudim) + (5*m3**6 - 3*m3**4*m5sq + m2sq*(-3*m3**4 + m3sq*m5sq) + m1sq*(-3*m3**4 + m3sq*m5sq + m2sq*(m3sq + m5sq)))*B0fin(0,0,m3sq,mudim)**2)/((m1sq - m3sq)**2*(m2sq - m3sq)**2*(m3sq - m5sq)**2) + T134fin(m3,m1,0,mudim)/((m1sq - m2sq)*(m1sq - m3sq)**2*(m1sq - m5sq)) - T134fin(m3,m2,0,mudim)/((m1sq - m2sq)*(m2sq - m3sq)**2*(m2sq - m5sq)) - T134fin(m5,m3,0,mudim)/((m1sq - m5sq)*(m3sq - m5sq)**2*(-m2sq + m5sq))
		def eval_59():
			return (-4*m2sq*(3*m2**4 + m4sq*m5sq - 2*m2sq*(m4sq + m5sq) + m1sq*(-2*m2sq + m4sq + m5sq)) + 2*(-5*m2**6 - m2sq*m4sq*m5sq + 3*m2**4*(m4sq + m5sq) + m1sq*(3*m2**4 - m4sq*m5sq - m2sq*(m4sq + m5sq)))*B0del(0,0,m2sq,mudim) + 2*(-7*m2**6 - 3*m2sq*m4sq*m5sq + 5*m2**4*(m4sq + m5sq) + m1sq*(5*m2**4 + m4sq*m5sq - 3*m2sq*(m4sq + m5sq)))*B0fin(0,0,m2sq,mudim) + (-5*m2**6 - m2sq*m4sq*m5sq + 3*m2**4*(m4sq + m5sq) + m1sq*(3*m2**4 - m4sq*m5sq - m2sq*(m4sq + m5sq)))*B0fin(0,0,m2sq,mudim)**2)/(2.*(m1sq - m2sq)**2*(m2sq - m4sq)**2*(m2sq - m5sq)**2) + T134fin(m2,m1,0,mudim)/((m1sq - m2sq)**2*(m1sq - m4sq)*(m1sq - m5sq)) - T134fin(m4,m2,0,mudim)/((m1sq - m4sq)*(m2sq - m4sq)**2*(m4sq - m5sq)) - T134fin(m5,m2,0,mudim)/((m1sq - m5sq)*(m2sq - m5sq)**2*(-m4sq + m5sq))
		def eval_60():
			return (-4*m2sq*(3*m2**4 + m4sq*m5sq - 2*m2sq*(m4sq + m5sq) + m1sq*(-2*m2sq + m4sq + m5sq)) + 2*(-5*m2**6 - m2sq*m4sq*m5sq + 3*m2**4*(m4sq + m5sq) + m1sq*(3*m2**4 - m4sq*m5sq - m2sq*(m4sq + m5sq)))*B0del(0,0,m2sq,mudim) + 2*(-7*m2**6 - 3*m2sq*m4sq*m5sq + 5*m2**4*(m4sq + m5sq) + m1sq*(5*m2**4 + m4sq*m5sq - 3*m2sq*(m4sq + m5sq)))*B0fin(0,0,m2sq,mudim) + (-5*m2**6 - m2sq*m4sq*m5sq + 3*m2**4*(m4sq + m5sq) + m1sq*(3*m2**4 - m4sq*m5sq - m2sq*(m4sq + m5sq)))*B0fin(0,0,m2sq,mudim)**2)/(2.*(m1sq - m2sq)**2*(m2sq - m4sq)**2*(m2sq - m5sq)**2) + T134fin(m2,m1,0,mudim)/((m1sq - m2sq)**2*(m1sq - m4sq)*(m1sq - m5sq)) - T134fin(m4,m2,0,mudim)/((m1sq - m4sq)*(m2sq - m4sq)**2*(m4sq - m5sq)) - T134fin(m5,m2,0,mudim)/((m1sq - m5sq)*(m2sq - m5sq)**2*(-m4sq + m5sq))
		def eval_61():
			return -0.5*(4*m1sq*(3*m1**4 + m4sq*m5sq + m3sq*(m4sq + m5sq) - 2*m1sq*(m3sq + m4sq + m5sq)) + 2*(5*m1**6 + m3sq*m4sq*m5sq - 3*m1**4*(m3sq + m4sq + m5sq) + m1sq*(m4sq*m5sq + m3sq*(m4sq + m5sq)))*B0del(0,0,m1sq,mudim) + 2*(7*m1**6 - m3sq*m4sq*m5sq - 5*m1**4*(m3sq + m4sq + m5sq) + 3*m1sq*(m4sq*m5sq + m3sq*(m4sq + m5sq)))*B0fin(0,0,m1sq,mudim) + (5*m1**6 + m3sq*m4sq*m5sq - 3*m1**4*(m3sq + m4sq + m5sq) + m1sq*(m4sq*m5sq + m3sq*(m4sq + m5sq)))*B0fin(0,0,m1sq,mudim)**2)/((m1sq - m3sq)**2*(m1sq - m4sq)**2*(m1sq - m5sq)**2) + T134fin(m3,m1,0,mudim)/((m1sq - m3sq)**2*(m3sq - m4sq)*(m3sq - m5sq)) + T134fin(m4,m1,0,mudim)/((m1sq - m4sq)**2*(-m3sq + m4sq)*(m4sq - m5sq)) + T134fin(m5,m1,0,mudim)/((m1sq - m5sq)**2*(-m3sq + m5sq)*(-m4sq + m5sq))
		def eval_62():
			return -0.5*(4*m1sq*(3*m1**4 + m4sq*m5sq + m3sq*(m4sq + m5sq) - 2*m1sq*(m3sq + m4sq + m5sq)) + 2*(5*m1**6 + m3sq*m4sq*m5sq - 3*m1**4*(m3sq + m4sq + m5sq) + m1sq*(m4sq*m5sq + m3sq*(m4sq + m5sq)))*B0del(0,0,m1sq,mudim) + 2*(7*m1**6 - m3sq*m4sq*m5sq - 5*m1**4*(m3sq + m4sq + m5sq) + 3*m1sq*(m4sq*m5sq + m3sq*(m4sq + m5sq)))*B0fin(0,0,m1sq,mudim) + (5*m1**6 + m3sq*m4sq*m5sq - 3*m1**4*(m3sq + m4sq + m5sq) + m1sq*(m4sq*m5sq + m3sq*(m4sq + m5sq)))*B0fin(0,0,m1sq,mudim)**2)/((m1sq - m3sq)**2*(m1sq - m4sq)**2*(m1sq - m5sq)**2) + T134fin(m3,m1,0,mudim)/((m1sq - m3sq)**2*(m3sq - m4sq)*(m3sq - m5sq)) + T134fin(m4,m1,0,mudim)/((m1sq - m4sq)**2*(-m3sq + m4sq)*(m4sq - m5sq)) + T134fin(m5,m1,0,mudim)/((m1sq - m5sq)**2*(-m3sq + m5sq)*(-m4sq + m5sq))
		def eval_63():
			return (-4*m1**16 - 79*m1**12*m6**4 + 131*m1**10*m6**6 - 135*m1**8*m6**8 + 89*m1**6*m6**10 - 37*m1**4*m6**12 + 9*m1sq*m6**14 - m6**16 + 27*m1**14*m6sq - 79*m1**12*m7**4 - 170*m1**8*m6**4*m7**4 + 114*m1**6*m6**6*m7**4 + 5*m1**4*m6**8*m7**4 + 81*m1sq*m6**10*m7**4 - 28*m6**12*m7**4 + 173*m1**10*m6sq*m7**4 + 131*m1**10*m7**6 + 114*m1**6*m6**4*m7**6 - 100*m1**4*m6**6*m7**6 - 45*m1sq*m6**8*m7**6 + 56*m6**10*m7**6 - 204*m1**8*m6sq*m7**6 - 135*m1**8*m7**8 + 5*m1**4*m6**4*m7**8 - 45*m1sq*m6**6*m7**8 - 70*m6**8*m7**8 + 37*m1**6*m6sq*m7**8 + 89*m1**6*m7**10 + 81*m1sq*m6**4*m7**10 + 56*m6**6*m7**10 + 82*m1**4*m6sq*m7**10 - 37*m1**4*m7**12 - 28*m6**4*m7**12 - 45*m1sq*m6sq*m7**12 + 9*m1sq*m7**14 + 8*m6sq*m7**14 - m7**16 + 27*m1**14*m7sq + 173*m1**10*m6**4*m7sq - 204*m1**8*m6**6*m7sq + 37*m1**6*m6**8*m7sq + 82*m1**4*m6**10*m7sq - 45*m1sq*m6**12*m7sq + 8*m6**14*m7sq - 78*m1**12*m6sq*m7sq + 48*m1**8*m6sq*m7sq*(m1**4 + m6**4 + m7**4 + 3*m6sq*m7sq - 2*m1sq*(m6sq + m7sq))*B0del(0,0,m1sq,mudim) + 48*m1**6*m6**4*m7sq*(m1**4 + m6**4 + m7**4 + 3*m6sq*m7sq - 2*m1sq*(m6sq + m7sq))*B0del(0,0,m6sq,mudim) - 96*m1**8*m6**4*m7**4*B0del(0,0,m7sq,mudim) + 48*m1**6*m6**6*m7**4*B0del(0,0,m7sq,mudim) + 48*m1**10*m6sq*m7**4*B0del(0,0,m7sq,mudim) + 144*m1**6*m6**4*m7**6*B0del(0,0,m7sq,mudim) - 96*m1**8*m6sq*m7**6*B0del(0,0,m7sq,mudim) + 48*m1**6*m6sq*m7**8*B0del(0,0,m7sq,mudim) - 4*m1**16*B0fin(0,0,m1sq,mudim) - 76*m1**12*m6**4*B0fin(0,0,m1sq,mudim) + 132*m1**10*m6**6*B0fin(0,0,m1sq,mudim) - 150*m1**8*m6**8*B0fin(0,0,m1sq,mudim) + 114*m1**6*m6**10*B0fin(0,0,m1sq,mudim) - 56*m1**4*m6**12*B0fin(0,0,m1sq,mudim) + 16*m1sq*m6**14*B0fin(0,0,m1sq,mudim) - 2*m6**16*B0fin(0,0,m1sq,mudim) + 26*m1**14*m6sq*B0fin(0,0,m1sq,mudim) - 76*m1**12*m7**4*B0fin(0,0,m1sq,mudim) - 44*m1**8*m6**4*m7**4*B0fin(0,0,m1sq,mudim) - 88*m1**6*m6**6*m7**4*B0fin(0,0,m1sq,mudim) - 72*m1**4*m6**8*m7**4*B0fin(0,0,m1sq,mudim) + 144*m1sq*m6**10*m7**4*B0fin(0,0,m1sq,mudim) - 56*m6**12*m7**4*B0fin(0,0,m1sq,mudim) + 240*m1**10*m6sq*m7**4*B0fin(0,0,m1sq,mudim) + 132*m1**10*m7**6*B0fin(0,0,m1sq,mudim) - 88*m1**6*m6**4*m7**6*B0fin(0,0,m1sq,mudim) - 32*m1**4*m6**6*m7**6*B0fin(0,0,m1sq,mudim) - 80*m1sq*m6**8*m7**6*B0fin(0,0,m1sq,mudim) + 112*m6**10*m7**6*B0fin(0,0,m1sq,mudim) - 204*m1**8*m6sq*m7**6*B0fin(0,0,m1sq,mudim) - 150*m1**8*m7**8*B0fin(0,0,m1sq,mudim) - 72*m1**4*m6**4*m7**8*B0fin(0,0,m1sq,mudim) - 80*m1sq*m6**6*m7**8*B0fin(0,0,m1sq,mudim) - 140*m6**8*m7**8*B0fin(0,0,m1sq,mudim) - 26*m1**6*m6sq*m7**8*B0fin(0,0,m1sq,mudim) + 114*m1**6*m7**10*B0fin(0,0,m1sq,mudim) + 144*m1sq*m6**4*m7**10*B0fin(0,0,m1sq,mudim) + 112*m6**6*m7**10*B0fin(0,0,m1sq,mudim) + 144*m1**4*m6sq*m7**10*B0fin(0,0,m1sq,mudim) - 56*m1**4*m7**12*B0fin(0,0,m1sq,mudim) - 56*m6**4*m7**12*B0fin(0,0,m1sq,mudim) - 80*m1sq*m6sq*m7**12*B0fin(0,0,m1sq,mudim) + 16*m1sq*m7**14*B0fin(0,0,m1sq,mudim) + 16*m6sq*m7**14*B0fin(0,0,m1sq,mudim) - 2*m7**16*B0fin(0,0,m1sq,mudim) + 26*m1**14*m7sq*B0fin(0,0,m1sq,mudim) + 240*m1**10*m6**4*m7sq*B0fin(0,0,m1sq,mudim) - 204*m1**8*m6**6*m7sq*B0fin(0,0,m1sq,mudim) - 26*m1**6*m6**8*m7sq*B0fin(0,0,m1sq,mudim) + 144*m1**4*m6**10*m7sq*B0fin(0,0,m1sq,mudim) - 80*m1sq*m6**12*m7sq*B0fin(0,0,m1sq,mudim) + 16*m6**14*m7sq*B0fin(0,0,m1sq,mudim) - 116*m1**12*m6sq*m7sq*B0fin(0,0,m1sq,mudim) - 36*m1**12*m6**4*B0fin(0,0,m6sq,mudim) + 92*m1**10*m6**6*B0fin(0,0,m6sq,mudim) - 130*m1**8*m6**8*B0fin(0,0,m6sq,mudim) + 110*m1**6*m6**10*B0fin(0,0,m6sq,mudim) - 56*m1**4*m6**12*B0fin(0,0,m6sq,mudim) + 16*m1sq*m6**14*B0fin(0,0,m6sq,mudim) - 2*m6**16*B0fin(0,0,m6sq,mudim) + 6*m1**14*m6sq*B0fin(0,0,m6sq,mudim) - 74*m1**8*m6**4*m7**4*B0fin(0,0,m6sq,mudim) + 112*m1**6*m6**6*m7**4*B0fin(0,0,m6sq,mudim) + 60*m1**4*m6**8*m7**4*B0fin(0,0,m6sq,mudim) + 70*m1sq*m6**10*m7**4*B0fin(0,0,m6sq,mudim) - 42*m6**12*m7**4*B0fin(0,0,m6sq,mudim) - 78*m1**10*m6sq*m7**4*B0fin(0,0,m6sq,mudim) + 104*m1**6*m6**4*m7**6*B0fin(0,0,m6sq,mudim) - 16*m1**4*m6**6*m7**6*B0fin(0,0,m6sq,mudim) + 20*m1sq*m6**8*m7**6*B0fin(0,0,m6sq,mudim) + 70*m6**10*m7**6*B0fin(0,0,m6sq,mudim) + 174*m1**8*m6sq*m7**6*B0fin(0,0,m6sq,mudim) - 132*m1**4*m6**4*m7**8*B0fin(0,0,m6sq,mudim) - 100*m1sq*m6**6*m7**8*B0fin(0,0,m6sq,mudim) - 70*m6**8*m7**8*B0fin(0,0,m6sq,mudim) - 166*m1**6*m6sq*m7**8*B0fin(0,0,m6sq,mudim) + 74*m1sq*m6**4*m7**10*B0fin(0,0,m6sq,mudim) + 42*m6**6*m7**10*B0fin(0,0,m6sq,mudim) + 78*m1**4*m6sq*m7**10*B0fin(0,0,m6sq,mudim) - 14*m6**4*m7**12*B0fin(0,0,m6sq,mudim) - 18*m1sq*m6sq*m7**12*B0fin(0,0,m6sq,mudim) + 2*m6sq*m7**14*B0fin(0,0,m6sq,mudim) + 78*m1**10*m6**4*m7sq*B0fin(0,0,m6sq,mudim) - 178*m1**8*m6**6*m7sq*B0fin(0,0,m6sq,mudim) + 80*m1**6*m6**8*m7sq*B0fin(0,0,m6sq,mudim) + 66*m1**4*m6**10*m7sq*B0fin(0,0,m6sq,mudim) - 62*m1sq*m6**12*m7sq*B0fin(0,0,m6sq,mudim) + 14*m6**14*m7sq*B0fin(0,0,m6sq,mudim) + 2*m1**12*m6sq*m7sq*B0fin(0,0,m6sq,mudim) + 72*m1**8*m6**4*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 48*m1**6*m6**6*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 72*m1**10*m6sq*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 48*m1**6*m6**4*m7**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 72*m1**8*m6sq*m7**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 24*m1**6*m6sq*m7**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 24*m1**10*m6**4*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 24*m1**8*m6**6*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 24*m1**6*m6**8*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 24*m1**12*m6sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 36*m1**12*m7**4*B0fin(0,0,m7sq,mudim) - 74*m1**8*m6**4*m7**4*B0fin(0,0,m7sq,mudim) + 104*m1**6*m6**6*m7**4*B0fin(0,0,m7sq,mudim) - 132*m1**4*m6**8*m7**4*B0fin(0,0,m7sq,mudim) + 74*m1sq*m6**10*m7**4*B0fin(0,0,m7sq,mudim) - 14*m6**12*m7**4*B0fin(0,0,m7sq,mudim) + 78*m1**10*m6sq*m7**4*B0fin(0,0,m7sq,mudim) + 92*m1**10*m7**6*B0fin(0,0,m7sq,mudim) + 112*m1**6*m6**4*m7**6*B0fin(0,0,m7sq,mudim) - 16*m1**4*m6**6*m7**6*B0fin(0,0,m7sq,mudim) - 100*m1sq*m6**8*m7**6*B0fin(0,0,m7sq,mudim) + 42*m6**10*m7**6*B0fin(0,0,m7sq,mudim) - 178*m1**8*m6sq*m7**6*B0fin(0,0,m7sq,mudim) - 130*m1**8*m7**8*B0fin(0,0,m7sq,mudim) + 60*m1**4*m6**4*m7**8*B0fin(0,0,m7sq,mudim) + 20*m1sq*m6**6*m7**8*B0fin(0,0,m7sq,mudim) - 70*m6**8*m7**8*B0fin(0,0,m7sq,mudim) + 80*m1**6*m6sq*m7**8*B0fin(0,0,m7sq,mudim) + 110*m1**6*m7**10*B0fin(0,0,m7sq,mudim) + 70*m1sq*m6**4*m7**10*B0fin(0,0,m7sq,mudim) + 70*m6**6*m7**10*B0fin(0,0,m7sq,mudim) + 66*m1**4*m6sq*m7**10*B0fin(0,0,m7sq,mudim) - 56*m1**4*m7**12*B0fin(0,0,m7sq,mudim) - 42*m6**4*m7**12*B0fin(0,0,m7sq,mudim) - 62*m1sq*m6sq*m7**12*B0fin(0,0,m7sq,mudim) + 16*m1sq*m7**14*B0fin(0,0,m7sq,mudim) + 14*m6sq*m7**14*B0fin(0,0,m7sq,mudim) - 2*m7**16*B0fin(0,0,m7sq,mudim) + 6*m1**14*m7sq*B0fin(0,0,m7sq,mudim) - 78*m1**10*m6**4*m7sq*B0fin(0,0,m7sq,mudim) + 174*m1**8*m6**6*m7sq*B0fin(0,0,m7sq,mudim) - 166*m1**6*m6**8*m7sq*B0fin(0,0,m7sq,mudim) + 78*m1**4*m6**10*m7sq*B0fin(0,0,m7sq,mudim) - 18*m1sq*m6**12*m7sq*B0fin(0,0,m7sq,mudim) + 2*m6**14*m7sq*B0fin(0,0,m7sq,mudim) + 2*m1**12*m6sq*m7sq*B0fin(0,0,m7sq,mudim) + 72*m1**8*m6**4*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 48*m1**6*m6**6*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 24*m1**10*m6sq*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) + 48*m1**6*m6**4*m7**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 24*m1**8*m6sq*m7**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) + 24*m1**6*m6sq*m7**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 72*m1**10*m6**4*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) + 72*m1**8*m6**6*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 24*m1**6*m6**8*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) + 24*m1**12*m6sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 168*m1**8*m6**4*m7**4*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim) + 96*m1**6*m6**6*m7**4*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim) + 72*m1**10*m6sq*m7**4*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim) + 96*m1**6*m6**4*m7**6*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim) - 72*m1**8*m6sq*m7**6*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim) + 24*m1**6*m6sq*m7**8*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim) + 72*m1**10*m6**4*m7sq*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim) - 72*m1**8*m6**6*m7sq*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim) + 24*m1**6*m6**8*m7sq*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim) - 24*m1**12*m6sq*m7sq*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim) - 144*m1**6*m6**4*m7**4*T134fin(m7,m6,m1,mudim) + 96*m1**8*m6sq*m7**4*T134fin(m7,m6,m1,mudim) - 48*m1**6*m6sq*m7**6*T134fin(m7,m6,m1,mudim) + 96*m1**8*m6**4*m7sq*T134fin(m7,m6,m1,mudim) - 48*m1**6*m6**6*m7sq*T134fin(m7,m6,m1,mudim) - 48*m1**10*m6sq*m7sq*T134fin(m7,m6,m1,mudim))/(24.*m1**6*(m1 + m6 - m7)**4*(m1 - m6 + m7)**4*(-m1 + m6 + m7)**4*(m1 + m6 + m7)**4)
		def eval_64():
			return ((10*m2**4*(-m1sq + m2sq)**3*m6**4)/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (12*(m1sq - m2sq)**3*m2sq*m6**6)/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (3*m2**6*(m1sq - m2sq)**3*m6sq)/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (10*m2**4*(-m1sq + m2sq)**3*m7**4)/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (32*(m1sq - m2sq)**3*m6**4*m7**4)/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (12*(m1sq - m2sq)**3*m2sq*m6sq*m7**4)/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (12*(m1sq - m2sq)**3*m2sq*m7**6)/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) - (21*(-(m1sq*m2) + m2**3)**2*m6**4)/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (9*m2**4*(m1sq - m2sq)**2*m6sq)/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (21*(-(m1sq*m2) + m2**3)**2*m7**4)/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (6*(m1sq - m2sq)**3*m6**6*(m6sq - m7sq))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) - (6*(m1sq - m2sq)**3*m6sq*m7**4*(m6sq - m7sq))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (6*(m1sq - m2sq)**3*m7**6*(m6sq - m7sq))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (15*(m1sq - m2sq)**2*m6**4*(m6sq - m7sq))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + ((m1sq - m2sq)**3*m6**4*(m6sq - m7sq)**3)/(m2**2*(m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + ((-m1sq + m2sq)**3*m7**4*(m6sq - m7sq)**3)/(m2**2*(m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) - (3*(m1sq - m2sq)**2*m6sq*(m6sq - m7sq)**3)/(m2**2*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (3*m2**6*(m1sq - m2sq)**3*m7sq)/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (12*(m1sq - m2sq)**3*m2sq*m6**4*m7sq)/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (24*m2**4*(-m1sq + m2sq)**3*m6sq*m7sq)/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (9*m2**4*(m1sq - m2sq)**2*m7sq)/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (6*(m1sq - m2sq)**2*m2sq*m6sq*m7sq)/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (12*(m1sq - m2sq)**2*m6sq*(m2sq - m6sq - m7sq)*m7sq)/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (6*(m1sq - m2sq)**3*m6**4*(m6sq - m7sq)*m7sq)/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (3*(m1sq - m2sq)**2*(m6sq - m7sq)**3*m7sq)/(m2**2*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (15*(m1sq - m2sq)**2*m7**4*(-m6sq + m7sq))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (6*m2**4*(m1sq - m2sq)**2*(m2sq + m6sq + m7sq))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (6*(m1sq - m2sq)**2*m6**4*(m2sq + m6sq + m7sq))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (6*(m1sq - m2sq)**2*m7**4*(m2sq + m6sq + m7sq))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (12*(m1sq - m2sq)**2*m6sq*m7sq*(m2sq + m6sq + m7sq))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (24*(m1sq - m2sq)**3*m6sq*(m2sq - m6sq - m7sq)*m7sq*(m2sq + m6sq + m7sq))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (12*(-(m1sq*m2) + m2**3)**2*(m6sq + m7sq)*(m2sq + m6sq + m7sq))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (12*m2sq*(-m1sq + m2sq)**3*m6sq*m7**4*B0del(0,0,m2sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (12*m2sq*(-m1sq + m2sq)**3*m6**4*m7sq*B0del(0,0,m2sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (12*m2**4*(m1sq - m2sq)**3*m6sq*m7sq*B0del(0,0,m2sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) - (12*(m1sq - m2sq)**2*m2sq*m6sq*m7sq*B0del(0,0,m2sq,mudim))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (6*(m1sq - m2sq)*m2sq*m6sq*B0del(0,0,m2sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + (6*(m1sq - m2sq)*m2sq*m7sq*B0del(0,0,m2sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) - (12*(m1sq - m2sq)**3*m6**4*m7**4*B0del(0,0,m6sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (12*m2sq*(-m1sq + m2sq)**3*m6sq*m7**4*B0del(0,0,m6sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) - (6*(m1sq - m2sq)**3*m6sq*m7**6*B0del(0,0,m6sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) - (6*(m1sq - m2sq)**3*m6sq*m7**4*(m6sq - m7sq)*B0del(0,0,m6sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) - (6*(m1sq - m2sq)**3*m6**6*m7sq*B0del(0,0,m6sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) - (6*(m1sq - m2sq)**2*m2sq*m6sq*m7sq*B0del(0,0,m6sq,mudim))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (6*(m1sq - m2sq)**2*m6sq*(m2sq - m6sq - m7sq)*m7sq*B0del(0,0,m6sq,mudim))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (6*(m1sq - m2sq)**3*m6**4*(m6sq - m7sq)*m7sq*B0del(0,0,m6sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) - (6*(m1sq - m2sq)**2*m6sq*(m6sq - m7sq)*m7sq*B0del(0,0,m6sq,mudim))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (12*(m1sq - m2sq)**3*m2sq*m6sq*m7sq*(m6sq + m7sq)*B0del(0,0,m6sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (6*(m1sq - m2sq)*m2sq*m6sq*B0del(0,0,m6sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) - (6*(m1sq - m2sq)*m6sq*(m6sq - m7sq)*B0del(0,0,m6sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) - (12*(m1sq - m2sq)*m6sq*m7sq*B0del(0,0,m6sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) - (12*(m1sq - m2sq)**3*m6**4*m7**4*B0del(0,0,m7sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) - (6*(m1sq - m2sq)**3*m6sq*m7**6*B0del(0,0,m7sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (6*(m1sq - m2sq)**3*m6sq*m7**4*(m6sq - m7sq)*B0del(0,0,m7sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (12*m2sq*(-m1sq + m2sq)**3*m6**4*m7sq*B0del(0,0,m7sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) - (6*(m1sq - m2sq)**3*m6**6*m7sq*B0del(0,0,m7sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) - (6*(m1sq - m2sq)**2*m2sq*m6sq*m7sq*B0del(0,0,m7sq,mudim))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (6*(m1sq - m2sq)**2*m6sq*(m2sq - m6sq - m7sq)*m7sq*B0del(0,0,m7sq,mudim))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (6*(m1sq - m2sq)**3*m6**4*(m6sq - m7sq)*m7sq*B0del(0,0,m7sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (6*(m1sq - m2sq)**2*m6sq*(m6sq - m7sq)*m7sq*B0del(0,0,m7sq,mudim))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (12*(m1sq - m2sq)**3*m2sq*m6sq*m7sq*(m6sq + m7sq)*B0del(0,0,m7sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (6*(m1sq - m2sq)*m2sq*m7sq*B0del(0,0,m7sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) - (12*(m1sq - m2sq)*m6sq*m7sq*B0del(0,0,m7sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + (6*(m1sq - m2sq)*(m6sq - m7sq)*m7sq*B0del(0,0,m7sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) - (6*(m1sq - m2sq)*m6sq*(m6sq - m7sq)*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + (6*(m1sq - m2sq)*(m6sq - m7sq)*m7sq*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + (15*m2**4*(-m1sq + m2sq)**3*m6**4*B0fin(0,0,m2sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (22*(m1sq - m2sq)**3*m2sq*m6**6*B0fin(0,0,m2sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (4*m2**6*(m1sq - m2sq)**3*m6sq*B0fin(0,0,m2sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (15*m2**4*(-m1sq + m2sq)**3*m7**4*B0fin(0,0,m2sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (14*(m1sq - m2sq)**3*m2sq*m6sq*m7**4*B0fin(0,0,m2sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (22*(m1sq - m2sq)**3*m2sq*m7**6*B0fin(0,0,m2sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (21*(-(m1sq*m2) + m2**3)**2*m6**4*B0fin(0,0,m2sq,mudim))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (9*m2**4*(m1sq - m2sq)**2*m6sq*B0fin(0,0,m2sq,mudim))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (21*(-(m1sq*m2) + m2**3)**2*m7**4*B0fin(0,0,m2sq,mudim))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (16*(m1sq - m2sq)**3*m6**6*(m6sq - m7sq)*B0fin(0,0,m2sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (12*(m1sq - m2sq)**3*m6sq*m7**4*(m6sq - m7sq)*B0fin(0,0,m2sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (16*(m1sq - m2sq)**3*m7**6*(m6sq - m7sq)*B0fin(0,0,m2sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) - (15*(m1sq - m2sq)**2*m6**4*(m6sq - m7sq)*B0fin(0,0,m2sq,mudim))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (15*(m1sq - m2sq)**2*m7**4*(m6sq - m7sq)*B0fin(0,0,m2sq,mudim))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (6*(m1sq - m2sq)**3*m6**4*(m6sq - m7sq)**3*B0fin(0,0,m2sq,mudim))/(m2**2*(m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (6*(-m1sq + m2sq)**3*m7**4*(m6sq - m7sq)**3*B0fin(0,0,m2sq,mudim))/(m2**2*(m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (3*(m1sq - m2sq)**2*m6sq*(m6sq - m7sq)**3*B0fin(0,0,m2sq,mudim))/(m2**2*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + ((-m1sq + m2sq)**3*m6sq*(m6sq - m7sq)**5*B0fin(0,0,m2sq,mudim))/(m2**4*(m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (4*m2**6*(m1sq - m2sq)**3*m7sq*B0fin(0,0,m2sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (14*(m1sq - m2sq)**3*m2sq*m6**4*m7sq*B0fin(0,0,m2sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (10*m2**4*(-m1sq + m2sq)**3*m6sq*m7sq*B0fin(0,0,m2sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) - (9*m2**4*(m1sq - m2sq)**2*m7sq*B0fin(0,0,m2sq,mudim))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (18*(m1sq - m2sq)**2*m2sq*m6sq*m7sq*B0fin(0,0,m2sq,mudim))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (12*(m1sq - m2sq)**3*m6**4*(m6sq - m7sq)*m7sq*B0fin(0,0,m2sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + ((m1sq - m2sq)**3*(m6sq - m7sq)**5*m7sq*B0fin(0,0,m2sq,mudim))/(m2**4*(m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (3*(m1sq - m2sq)**2*m7sq*(-m6sq + m7sq)**3*B0fin(0,0,m2sq,mudim))/(m2**2*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (6*m2sq*(-m1sq + m2sq)*m6sq*B0fin(0,0,m2sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + (6*m2sq*(-m1sq + m2sq)*m7sq*B0fin(0,0,m2sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + (15*m2**4*(-m1sq + m2sq)**3*m6**4*B0fin(0,0,m6sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (22*(m1sq - m2sq)**3*m2sq*m6**6*B0fin(0,0,m6sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (4*m2**6*(m1sq - m2sq)**3*m6sq*B0fin(0,0,m6sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) - (36*(m1sq - m2sq)**3*m6**4*m7**4*B0fin(0,0,m6sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (8*m2sq*(-m1sq + m2sq)**3*m6sq*m7**4*B0fin(0,0,m6sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) - (2*(m1sq - m2sq)**3*m6sq*m7**6*B0fin(0,0,m6sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (21*(-(m1sq*m2) + m2**3)**2*m6**4*B0fin(0,0,m6sq,mudim))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (9*m2**4*(m1sq - m2sq)**2*m6sq*B0fin(0,0,m6sq,mudim))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (16*(m1sq - m2sq)**3*m6**6*(m6sq - m7sq)*B0fin(0,0,m6sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) - (16*(m1sq - m2sq)**3*m6sq*m7**4*(m6sq - m7sq)*B0fin(0,0,m6sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) - (15*(m1sq - m2sq)**2*m6**4*(m6sq - m7sq)*B0fin(0,0,m6sq,mudim))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (6*(m1sq - m2sq)**3*m6**4*(m6sq - m7sq)**3*B0fin(0,0,m6sq,mudim))/(m2**2*(m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (3*(m1sq - m2sq)**2*m6sq*(m6sq - m7sq)**3*B0fin(0,0,m6sq,mudim))/(m2**2*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + ((-m1sq + m2sq)**3*m6sq*(m6sq - m7sq)**5*B0fin(0,0,m6sq,mudim))/(m2**4*(m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (22*(m1sq - m2sq)**3*m2sq*m6**4*m7sq*B0fin(0,0,m6sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) - (2*(m1sq - m2sq)**3*m6**6*m7sq*B0fin(0,0,m6sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (7*m2**4*(-m1sq + m2sq)**3*m6sq*m7sq*B0fin(0,0,m6sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (9*(m1sq - m2sq)**2*m2sq*m6sq*m7sq*B0fin(0,0,m6sq,mudim))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (6*(m1sq - m2sq)**2*m6sq*(m2sq - m6sq - m7sq)*m7sq*B0fin(0,0,m6sq,mudim))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (28*(m1sq - m2sq)**3*m6**4*(m6sq - m7sq)*m7sq*B0fin(0,0,m6sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) - (3*(m1sq - m2sq)**2*m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m6sq,mudim))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (8*(m1sq - m2sq)**3*m6sq*(m6sq - m7sq)**3*m7sq*B0fin(0,0,m6sq,mudim))/(m2**2*(m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (4*(m1sq - m2sq)**3*m2sq*m6sq*m7sq*(m6sq + m7sq)*B0fin(0,0,m6sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (6*m2sq*(-m1sq + m2sq)*m6sq*B0fin(0,0,m6sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + (6*(m1sq - m2sq)*m6sq*(m6sq - m7sq)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + (12*(m1sq - m2sq)*m6sq*m7sq*B0fin(0,0,m6sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + (12*m2sq*(-m1sq + m2sq)**3*m6sq*m7**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) - (6*(m1sq - m2sq)**3*m6sq*m7**4*(m6sq - m7sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (6*m2**4*(m1sq - m2sq)**3*m6sq*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) - (6*(m1sq - m2sq)**2*m2sq*m6sq*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (6*(m1sq - m2sq)**3*m6**4*(m6sq - m7sq)*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) - (6*(m1sq - m2sq)**2*m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (6*(m1sq - m2sq)*m2sq*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) - (6*(m1sq - m2sq)*m6sq*(m6sq - m7sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + (15*m2**4*(-m1sq + m2sq)**3*m7**4*B0fin(0,0,m7sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) - (36*(m1sq - m2sq)**3*m6**4*m7**4*B0fin(0,0,m7sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (22*(m1sq - m2sq)**3*m2sq*m6sq*m7**4*B0fin(0,0,m7sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (22*(m1sq - m2sq)**3*m2sq*m7**6*B0fin(0,0,m7sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) - (2*(m1sq - m2sq)**3*m6sq*m7**6*B0fin(0,0,m7sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (21*(-(m1sq*m2) + m2**3)**2*m7**4*B0fin(0,0,m7sq,mudim))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (28*(m1sq - m2sq)**3*m6sq*m7**4*(m6sq - m7sq)*B0fin(0,0,m7sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (16*(m1sq - m2sq)**3*m7**6*(m6sq - m7sq)*B0fin(0,0,m7sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (15*(m1sq - m2sq)**2*m7**4*(m6sq - m7sq)*B0fin(0,0,m7sq,mudim))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (6*(-m1sq + m2sq)**3*m7**4*(m6sq - m7sq)**3*B0fin(0,0,m7sq,mudim))/(m2**2*(m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (4*m2**6*(m1sq - m2sq)**3*m7sq*B0fin(0,0,m7sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (8*m2sq*(-m1sq + m2sq)**3*m6**4*m7sq*B0fin(0,0,m7sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) - (2*(m1sq - m2sq)**3*m6**6*m7sq*B0fin(0,0,m7sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (7*m2**4*(-m1sq + m2sq)**3*m6sq*m7sq*B0fin(0,0,m7sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) - (9*m2**4*(m1sq - m2sq)**2*m7sq*B0fin(0,0,m7sq,mudim))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (9*(m1sq - m2sq)**2*m2sq*m6sq*m7sq*B0fin(0,0,m7sq,mudim))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (6*(m1sq - m2sq)**2*m6sq*(m2sq - m6sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (16*(m1sq - m2sq)**3*m6**4*(m6sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (3*(m1sq - m2sq)**2*m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (8*(-m1sq + m2sq)**3*m6sq*(m6sq - m7sq)**3*m7sq*B0fin(0,0,m7sq,mudim))/(m2**2*(m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + ((m1sq - m2sq)**3*(m6sq - m7sq)**5*m7sq*B0fin(0,0,m7sq,mudim))/(m2**4*(m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (3*(m1sq - m2sq)**2*m7sq*(-m6sq + m7sq)**3*B0fin(0,0,m7sq,mudim))/(m2**2*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (4*(m1sq - m2sq)**3*m2sq*m6sq*m7sq*(m6sq + m7sq)*B0fin(0,0,m7sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (6*m2sq*(-m1sq + m2sq)*m7sq*B0fin(0,0,m7sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + (12*(m1sq - m2sq)*m6sq*m7sq*B0fin(0,0,m7sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + (6*(m1sq - m2sq)*m7sq*(-m6sq + m7sq)*B0fin(0,0,m7sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + (6*(m1sq - m2sq)**3*m6sq*m7**4*(m6sq - m7sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (12*m2sq*(-m1sq + m2sq)**3*m6**4*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (6*m2**4*(m1sq - m2sq)**3*m6sq*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) - (6*(m1sq - m2sq)**2*m2sq*m6sq*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (6*(m1sq - m2sq)**3*m6**4*(m6sq - m7sq)*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (6*(m1sq - m2sq)**2*m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (6*(m1sq - m2sq)*m2sq*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + (6*(m1sq - m2sq)*(m6sq - m7sq)*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) - (12*(m1sq - m2sq)**3*m6**4*m7**4*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) - (6*(m1sq - m2sq)**3*m6sq*m7**6*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) - (6*(m1sq - m2sq)**3*m6**6*m7sq*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (6*m2**4*(-m1sq + m2sq)**3*m6sq*m7sq*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (6*(m1sq - m2sq)**2*m6sq*(m2sq - m6sq - m7sq)*m7sq*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (12*(m1sq - m2sq)**3*m2sq*m6sq*m7sq*(m6sq + m7sq)*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) - (12*(m1sq - m2sq)*m6sq*m7sq*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + (3*m2**4*(m1sq - m2sq)**2*(m2sq + m6sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (3*(m1sq - m2sq)**2*m6**4*(m2sq + m6sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (3*(m1sq - m2sq)**2*m7**4*(m2sq + m6sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (m2**4*(-m1sq + m2sq)**3*(m2sq - m6sq - m7sq)*(m2sq + m6sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) - ((m1sq - m2sq)**3*m6**4*(m2sq - m6sq - m7sq)*(m2sq + m6sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) - ((m1sq - m2sq)**3*m7**4*(m2sq - m6sq - m7sq)*(m2sq + m6sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) - (6*(m1sq - m2sq)**2*m6sq*m7sq*(m2sq + m6sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (2*(m1sq - m2sq)**3*m6sq*(m2sq - m6sq - m7sq)*m7sq*(m2sq + m6sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) - (6*(-(m1sq*m2) + m2**3)**2*(m6sq + m7sq)*(m2sq + m6sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (2*m2sq*(-m1sq + m2sq)**3*(m2sq - m6sq - m7sq)*(m6sq + m7sq)*(m2sq + m6sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (6*(m1sq - m2sq)*(m2sq - m6sq - m7sq)*(m2sq + m6sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + 6*T134fin(m7,m6,m1,mudim) - 6*T134fin(m7,m6,m2,mudim) + (12*(m1sq - m2sq)**2*m6sq*m7sq*T134fin(m7,m6,m2,mudim))/((m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (12*(m1sq - m2sq)**3*m6sq*(m2sq - m6sq - m7sq)*m7sq*T134fin(m7,m6,m2,mudim))/((m2 - m6 - m7)**3*(m2 + m6 - m7)**3*(m2 - m6 + m7)**3*(m2 + m6 + m7)**3) + (6*(m1sq - m2sq)*(m2sq - m6sq - m7sq)*T134fin(m7,m6,m2,mudim))/(4*m6sq*m7sq - (-m2sq + m6sq + m7sq)**2))/(6.*(m1sq - m2sq)**4)
		def eval_65():
			return ((7*m1sq*m3sq*m6**4)/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (7*m3**4*m6**4)/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (3*m3**6*m6sq)/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (3*m1sq*m3**4*m6sq)/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (7*m1sq*m3sq*m7**4)/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (7*m3**4*m7**4)/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (5*m3sq*m6**4*(m6sq - m7sq))/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (5*m1sq*m6**4*(m6sq - m7sq))/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (5*m1sq*m7**4*(m6sq - m7sq))/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (5*m3sq*m7**4*(m6sq - m7sq))/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (m6sq*(m6sq - m7sq)**3)/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) - (m1sq*m6sq*(m6sq - m7sq)**3)/(m3**2*(-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (3*m3**6*m7sq)/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (3*m1sq*m3**4*m7sq)/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (2*m1sq*m3sq*m6sq*m7sq)/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (2*m3**4*m6sq*m7sq)/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + ((m6sq - m7sq)**3*m7sq)/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (m1sq*(m6sq - m7sq)**3*m7sq)/(m3**2*(-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) - (4*m6sq*m7sq*(-m3sq + m6sq + m7sq))/((m1sq - m3sq)**2*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (2*m3**4*(m3sq + m6sq + m7sq))/((m1sq - m3sq)**2*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (2*m6**4*(m3sq + m6sq + m7sq))/((m1sq - m3sq)**2*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (2*m7**4*(m3sq + m6sq + m7sq))/((m1sq - m3sq)**2*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (4*m6sq*m7sq*(m3sq + m6sq + m7sq))/((m1sq - m3sq)**2*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) - (4*m3sq*(m6sq + m7sq)*(m3sq + m6sq + m7sq))/((m1sq - m3sq)**2*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) - (2*m1sq*m6sq*B0del(0,0,m1sq,mudim))/((m1sq - m3sq)**3*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (2*m1sq*m7sq*B0del(0,0,m1sq,mudim))/((m1sq - m3sq)**3*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (8*m3**4*m6**4*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (4*m3**6*m6sq*B0del(0,0,m3sq,mudim))/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (8*m3**4*m7**4*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (4*m3sq*m6**4*(m6sq - m7sq)*B0del(0,0,m3sq,mudim))/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (4*m3sq*m7**4*(m6sq - m7sq)*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (4*m3**6*m7sq*B0del(0,0,m3sq,mudim))/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (12*m3**4*m6sq*m7sq*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (4*m1sq*m3sq*m6sq*m7sq*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (8*m3**4*m6**4*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (4*m3**6*m6sq*B0del(0,0,m6sq,mudim))/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (4*m3sq*m6**4*(m6sq - m7sq)*B0del(0,0,m6sq,mudim))/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (6*m3**4*m6sq*m7sq*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (2*m1sq*m3sq*m6sq*m7sq*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (2*m1sq*m6sq*(m6sq - m7sq)*m7sq*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (2*m3sq*m6sq*(m6sq - m7sq)*m7sq*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (2*m6sq*m7sq*(-m3sq + m6sq + m7sq)*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) - (2*m1sq*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)**3*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (2*m6sq*(m6sq - m7sq)*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)**3*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (4*m6sq*m7sq*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)**3*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (4*m6sq*(m6sq - m7sq)*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)**3*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + (8*m6sq*m7sq*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)**3*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + (8*m3**4*m7**4*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (4*m3sq*m7**4*(m6sq - m7sq)*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (4*m3**6*m7sq*B0del(0,0,m7sq,mudim))/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (6*m3**4*m6sq*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (2*m1sq*m3sq*m6sq*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (2*m1sq*m6sq*(m6sq - m7sq)*m7sq*B0del(0,0,m7sq,mudim))/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (2*m3sq*m6sq*(m6sq - m7sq)*m7sq*B0del(0,0,m7sq,mudim))/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (2*m6sq*m7sq*(-m3sq + m6sq + m7sq)*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) - (2*m1sq*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)**3*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (4*m6sq*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)**3*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (2*m7sq*(-m6sq + m7sq)*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)**3*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (8*m6sq*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)**3*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + (4*m7sq*(-m6sq + m7sq)*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)**3*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + (2*m6sq*(m6sq - m7sq)*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/((m1sq - m3sq)**3*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (2*m7sq*(-m6sq + m7sq)*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/((m1sq - m3sq)**3*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (2*m1sq*m6sq*B0fin(0,0,m1sq,mudim))/((m1sq - m3sq)**3*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (2*m1sq*m7sq*B0fin(0,0,m1sq,mudim))/((m1sq - m3sq)**3*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (4*m6sq*(m6sq - m7sq)*(B0del(0,0,m3sq,mudim) - B0fin(0,0,m3sq,mudim)))/((m1sq - m3sq)**3*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + (4*m7sq*(-m6sq + m7sq)*(B0del(0,0,m3sq,mudim) - B0fin(0,0,m3sq,mudim)))/((m1sq - m3sq)**3*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + (m3**4*m6**4*B0fin(0,0,m3sq,mudim))/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (7*m1sq*m3sq*m6**4*B0fin(0,0,m3sq,mudim))/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (3*m1sq*m3**4*m6sq*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (m3**6*m6sq*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (m3**4*m7**4*B0fin(0,0,m3sq,mudim))/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (7*m1sq*m3sq*m7**4*B0fin(0,0,m3sq,mudim))/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (5*m1sq*m6**4*(m6sq - m7sq)*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (m3sq*m6**4*(m6sq - m7sq)*B0fin(0,0,m3sq,mudim))/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (m3sq*m7**4*(m6sq - m7sq)*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (5*m1sq*m7**4*(m6sq - m7sq)*B0fin(0,0,m3sq,mudim))/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (m6sq*(m6sq - m7sq)**3*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (m1sq*m6sq*(m6sq - m7sq)**3*B0fin(0,0,m3sq,mudim))/(m3**2*(-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (3*m1sq*m3**4*m7sq*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (m3**6*m7sq*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (10*m3**4*m6sq*m7sq*B0fin(0,0,m3sq,mudim))/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (6*m1sq*m3sq*m6sq*m7sq*B0fin(0,0,m3sq,mudim))/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + ((m6sq - m7sq)**3*m7sq*B0fin(0,0,m3sq,mudim))/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (m1sq*m7sq*(-m6sq + m7sq)**3*B0fin(0,0,m3sq,mudim))/(m3**2*(-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (m3**4*m6**4*B0fin(0,0,m6sq,mudim))/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (7*m1sq*m3sq*m6**4*B0fin(0,0,m6sq,mudim))/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (3*m1sq*m3**4*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (m3**6*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (5*m1sq*m6**4*(m6sq - m7sq)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (m3sq*m6**4*(m6sq - m7sq)*B0fin(0,0,m6sq,mudim))/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (m6sq*(m6sq - m7sq)**3*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (m1sq*m6sq*(m6sq - m7sq)**3*B0fin(0,0,m6sq,mudim))/(m3**2*(-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (5*m3**4*m6sq*m7sq*B0fin(0,0,m6sq,mudim))/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (3*m1sq*m3sq*m6sq*m7sq*B0fin(0,0,m6sq,mudim))/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (m1sq*m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (5*m3sq*m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m6sq,mudim))/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (2*m6sq*m7sq*(-m3sq + m6sq + m7sq)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (2*m1sq*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**3*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (2*m6sq*(m6sq - m7sq)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**3*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (4*m6sq*m7sq*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**3*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (4*m6sq*(m6sq - m7sq)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**3*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) - (8*m6sq*m7sq*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**3*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) - (2*m1sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**3*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (2*m6sq*(m6sq - m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**3*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (8*m3**4*m6**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (4*m3**6*m6sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim))/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (4*m3sq*m6**4*(m6sq - m7sq)*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim))/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (6*m3**4*m6sq*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (2*m1sq*m3sq*m6sq*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (2*m1sq*m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (2*m3sq*m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (4*m6sq*(m6sq - m7sq)*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**3*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + (m3**4*m7**4*B0fin(0,0,m7sq,mudim))/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (7*m1sq*m3sq*m7**4*B0fin(0,0,m7sq,mudim))/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (m3sq*m7**4*(m6sq - m7sq)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (5*m1sq*m7**4*(m6sq - m7sq)*B0fin(0,0,m7sq,mudim))/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (3*m1sq*m3**4*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (m3**6*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (5*m3**4*m6sq*m7sq*B0fin(0,0,m7sq,mudim))/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (3*m1sq*m3sq*m6sq*m7sq*B0fin(0,0,m7sq,mudim))/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (5*m3sq*m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (m1sq*m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim))/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + ((m6sq - m7sq)**3*m7sq*B0fin(0,0,m7sq,mudim))/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (m1sq*m7sq*(-m6sq + m7sq)**3*B0fin(0,0,m7sq,mudim))/(m3**2*(-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (2*m6sq*m7sq*(-m3sq + m6sq + m7sq)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (2*m1sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**3*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (4*m6sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**3*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (2*(m6sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**3*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (8*m6sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**3*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + (4*(m6sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**3*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) - (2*m1sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**3*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (2*m7sq*(-m6sq + m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**3*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (8*m3**4*m7**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (4*m3sq*m7**4*(m6sq - m7sq)*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (4*m3**6*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim))/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (6*m3**4*m6sq*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (2*m1sq*m3sq*m6sq*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (2*m1sq*m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim))/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (2*m3sq*m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim))/((-m1sq + m3sq)**3*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (4*m7sq*(-m6sq + m7sq)*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**3*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + (2*m6sq*m7sq*(-m3sq + m6sq + m7sq)*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (4*m6sq*m7sq*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**3*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (8*m6sq*m7sq*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**3*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) - (2*(m1sq - m6sq - m7sq)*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)**3*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (m3**4*(m3sq + m6sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)**2*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) - (m6**4*(m3sq + m6sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)**2*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) - (m7**4*(m3sq + m6sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)**2*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (2*m6sq*m7sq*(m3sq + m6sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)**2*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (2*m3sq*(m6sq + m7sq)*(m3sq + m6sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)**2*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) - (4*(m3sq - m6sq - m7sq)*(m3sq + m6sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)**3*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) - (6*T134fin(m7,m6,m1,mudim))/(m1sq - m3sq)**4 + (2*(m1sq - m6sq - m7sq)*T134fin(m7,m6,m1,mudim))/((m1sq - m3sq)**3*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (6*T134fin(m7,m6,m3,mudim))/(m1sq - m3sq)**4 - (4*m6sq*m7sq*T134fin(m7,m6,m3,mudim))/((m1sq - m3sq)**2*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (4*(m3sq - m6sq - m7sq)*T134fin(m7,m6,m3,mudim))/((m1sq - m3sq)**3*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))))/2.
		def eval_66():
			return ((7*m1**4*(m1sq - m4sq)*m6**4)/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (7*m1sq*(m1sq - m4sq)*m4sq*m6**4)/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (3*m1**6*(m1sq - m4sq)*m6sq)/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (3*m1**4*(m1sq - m4sq)*m4sq*m6sq)/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (7*m1**4*(m1sq - m4sq)*m7**4)/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (7*m1sq*(m1sq - m4sq)*m4sq*m7**4)/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*m1sq*(m1sq - m4sq)*m6sq*m7**4)/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (5*m1sq*(m1sq - m4sq)*m7**6)/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (5*m1sq*(m1sq - m4sq)*m6**4*(m6sq - m7sq))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (5*(m1sq - m4sq)*m4sq*m6**4*(m6sq - m7sq))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (5*m4sq*(-m1sq + m4sq)*m7**4*(m6sq - m7sq))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + ((m1sq - m4sq)*m6sq*(m6sq - m7sq)**3)/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (m4sq*(-m1sq + m4sq)*m6sq*(m6sq - m7sq)**3)/(m1**2*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (3*m1**6*(m1sq - m4sq)*m7sq)/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (3*m1**4*(m1sq - m4sq)*m4sq*m7sq)/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (3*m1sq*(m1sq - m4sq)*m6**4*m7sq)/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*m1**4*(m1sq - m4sq)*m6sq*m7sq)/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (2*m1sq*(m1sq - m4sq)*m4sq*m6sq*m7sq)/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (4*(m1sq - m4sq)**2*m6sq*(m1sq - m6sq - m7sq)*m7sq)/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (3*m1sq*(m1sq - m4sq)*m6sq*(m6sq - m7sq)*m7sq)/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + ((m1sq - m4sq)*m4sq*(m6sq - m7sq)**3*m7sq)/(m1**2*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + ((m1sq - m4sq)*m7sq*(-m6sq + m7sq)**3)/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*m1**4*(m1sq - m4sq)**2*(m1sq + m6sq + m7sq))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*(m1sq - m4sq)**2*m6**4*(m1sq + m6sq + m7sq))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*(m1sq - m4sq)**2*m7**4*(m1sq + m6sq + m7sq))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (4*(m1sq - m4sq)**2*m6sq*m7sq*(m1sq + m6sq + m7sq))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (4*(m1**3 - m1*m4sq)**2*(m6sq + m7sq)*(m1sq + m6sq + m7sq))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (8*m1**4*(m1sq - m4sq)*m6**4*B0del(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (4*m1**6*(m1sq - m4sq)*m6sq*B0del(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (8*m1**4*(m1sq - m4sq)*m7**4*B0del(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (6*m1sq*(m1sq - m4sq)*m6sq*m7**4*B0del(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (4*m1sq*(m1sq - m4sq)*m7**6*B0del(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (4*m1sq*(m1sq - m4sq)*m6**4*(m6sq - m7sq)*B0del(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (4*m1**6*(m1sq - m4sq)*m7sq*B0del(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*m1sq*(m1sq - m4sq)*m6**4*m7sq*B0del(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (12*m1**4*(m1sq - m4sq)*m6sq*m7sq*B0del(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (4*m1sq*(m1sq - m4sq)*m4sq*m6sq*m7sq*B0del(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (2*m1sq*(m1sq - m4sq)*m6sq*(m6sq - m7sq)*m7sq*B0del(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*(m1sq - m4sq)*m4sq*m6sq*B0del(0,0,m4sq,mudim))/(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq)) + (2*(m1sq - m4sq)*m4sq*m7sq*B0del(0,0,m4sq,mudim))/(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq)) - (8*m1**4*(m1sq - m4sq)*m6**4*B0del(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (4*m1**6*(m1sq - m4sq)*m6sq*B0del(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (4*m1sq*(m1sq - m4sq)*m6**4*(m6sq - m7sq)*B0del(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (6*m1**4*(m1sq - m4sq)*m6sq*m7sq*B0del(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (2*m1sq*(m1sq - m4sq)*m4sq*m6sq*m7sq*B0del(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (2*(m1sq - m4sq)**2*m6sq*(m1sq - m6sq - m7sq)*m7sq*B0del(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (2*m1sq*(m1sq - m4sq)*m6sq*(m6sq - m7sq)*m7sq*B0del(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*m4sq*(-m1sq + m4sq)*m6sq*(m6sq - m7sq)*m7sq*B0del(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (4*(m1sq - m4sq)*m6sq*(m6sq - m7sq)*B0del(0,0,m6sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) - (8*(m1sq - m4sq)*m6sq*m7sq*B0del(0,0,m6sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (2*(m1sq - m4sq)*m4sq*m6sq*B0del(0,0,m6sq,mudim))/(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq)) - (2*(m1sq - m4sq)*m6sq*(m6sq - m7sq)*B0del(0,0,m6sq,mudim))/(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq)) - (4*(m1sq - m4sq)*m6sq*m7sq*B0del(0,0,m6sq,mudim))/(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq)) - (8*m1**4*(m1sq - m4sq)*m7**4*B0del(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (6*m1sq*(m1sq - m4sq)*m6sq*m7**4*B0del(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (4*m1sq*(m1sq - m4sq)*m7**6*B0del(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (4*m1**6*(m1sq - m4sq)*m7sq*B0del(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*m1sq*(m1sq - m4sq)*m6**4*m7sq*B0del(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (6*m1**4*(m1sq - m4sq)*m6sq*m7sq*B0del(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (2*m1sq*(m1sq - m4sq)*m4sq*m6sq*m7sq*B0del(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (2*(m1sq - m4sq)**2*m6sq*(m1sq - m6sq - m7sq)*m7sq*B0del(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*(m1sq - m4sq)*m4sq*m6sq*(m6sq - m7sq)*m7sq*B0del(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (8*(m1sq - m4sq)*m6sq*m7sq*B0del(0,0,m7sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (4*(m1sq - m4sq)*(m6sq - m7sq)*m7sq*B0del(0,0,m7sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (2*(m1sq - m4sq)*m4sq*m7sq*B0del(0,0,m7sq,mudim))/(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq)) - (4*(m1sq - m4sq)*m6sq*m7sq*B0del(0,0,m7sq,mudim))/(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq)) + (2*(m1sq - m4sq)*(m6sq - m7sq)*m7sq*B0del(0,0,m7sq,mudim))/(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq)) - (4*(m1sq - m4sq)*m6sq*(m6sq - m7sq)*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (4*(m1sq - m4sq)*(m6sq - m7sq)*m7sq*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (m1**4*(m1sq - m4sq)*m6**4*B0fin(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (7*m1sq*(m1sq - m4sq)*m4sq*m6**4*B0fin(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (m1**6*(m1sq - m4sq)*m6sq*B0fin(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (3*m1**4*(m1sq - m4sq)*m4sq*m6sq*B0fin(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (m1**4*(m1sq - m4sq)*m7**4*B0fin(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (7*m1sq*(m1sq - m4sq)*m4sq*m7**4*B0fin(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (4*m1sq*(m1sq - m4sq)*m6sq*m7**4*B0fin(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (m1sq*(m1sq - m4sq)*m7**6*B0fin(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (m1sq*(m1sq - m4sq)*m6**4*(m6sq - m7sq)*B0fin(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (5*m4sq*(-m1sq + m4sq)*m6**4*(m6sq - m7sq)*B0fin(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (5*(m1sq - m4sq)*m4sq*m7**4*(m6sq - m7sq)*B0fin(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - ((m1sq - m4sq)*m6sq*(m6sq - m7sq)**3*B0fin(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + ((m1sq - m4sq)*m4sq*m6sq*(m6sq - m7sq)**3*B0fin(0,0,m1sq,mudim))/(m1**2*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (m1**6*(m1sq - m4sq)*m7sq*B0fin(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (3*m1**4*(m1sq - m4sq)*m4sq*m7sq*B0fin(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (5*m1sq*(m1sq - m4sq)*m6**4*m7sq*B0fin(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (10*m1**4*(m1sq - m4sq)*m6sq*m7sq*B0fin(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (6*m1sq*(m1sq - m4sq)*m4sq*m6sq*m7sq*B0fin(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (5*m1sq*(m1sq - m4sq)*m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + ((m1sq - m4sq)*(m6sq - m7sq)**3*m7sq*B0fin(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - ((m1sq - m4sq)*m4sq*(m6sq - m7sq)**3*m7sq*B0fin(0,0,m1sq,mudim))/(m1**2*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (2*(m1sq - m4sq)*m6sq*(m6sq - m7sq)*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq)) + (2*(m1sq - m4sq)*(m6sq - m7sq)*m7sq*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq)) + (2*m4sq*(-m1sq + m4sq)*m6sq*B0fin(0,0,m4sq,mudim))/(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq)) + (2*m4sq*(-m1sq + m4sq)*m7sq*B0fin(0,0,m4sq,mudim))/(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq)) + (m1**4*(m1sq - m4sq)*m6**4*B0fin(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (7*m1sq*(m1sq - m4sq)*m4sq*m6**4*B0fin(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (m1**6*(m1sq - m4sq)*m6sq*B0fin(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (3*m1**4*(m1sq - m4sq)*m4sq*m6sq*B0fin(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (m1sq*(m1sq - m4sq)*m6**4*(m6sq - m7sq)*B0fin(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (5*m4sq*(-m1sq + m4sq)*m6**4*(m6sq - m7sq)*B0fin(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - ((m1sq - m4sq)*m6sq*(m6sq - m7sq)**3*B0fin(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + ((m1sq - m4sq)*m4sq*m6sq*(m6sq - m7sq)**3*B0fin(0,0,m6sq,mudim))/(m1**2*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (5*m1**4*(m1sq - m4sq)*m6sq*m7sq*B0fin(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (3*m1sq*(m1sq - m4sq)*m4sq*m6sq*m7sq*B0fin(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (2*(m1sq - m4sq)**2*m6sq*(m1sq - m6sq - m7sq)*m7sq*B0fin(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (5*m1sq*(m1sq - m4sq)*m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (m4sq*(-m1sq + m4sq)*m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (4*(m1sq - m4sq)*m6sq*(m6sq - m7sq)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (8*(m1sq - m4sq)*m6sq*m7sq*B0fin(0,0,m6sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (2*m4sq*(-m1sq + m4sq)*m6sq*B0fin(0,0,m6sq,mudim))/(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq)) + (2*(m1sq - m4sq)*m6sq*(m6sq - m7sq)*B0fin(0,0,m6sq,mudim))/(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq)) + (4*(m1sq - m4sq)*m6sq*m7sq*B0fin(0,0,m6sq,mudim))/(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq)) - (8*m1**4*(m1sq - m4sq)*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (4*m1**6*(m1sq - m4sq)*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (4*m1sq*(m1sq - m4sq)*m6**4*(m6sq - m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (6*m1**4*(m1sq - m4sq)*m6sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (2*m1sq*(m1sq - m4sq)*m4sq*m6sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (2*m1sq*(m1sq - m4sq)*m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*m4sq*(-m1sq + m4sq)*m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (4*(m1sq - m4sq)*m6sq*(m6sq - m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (2*(m1sq - m4sq)*m4sq*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq)) - (2*(m1sq - m4sq)*m6sq*(m6sq - m7sq)*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq)) + (m1**4*(m1sq - m4sq)*m7**4*B0fin(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (7*m1sq*(m1sq - m4sq)*m4sq*m7**4*B0fin(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (4*m1sq*(m1sq - m4sq)*m6sq*m7**4*B0fin(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (m1sq*(m1sq - m4sq)*m7**6*B0fin(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (5*(m1sq - m4sq)*m4sq*m7**4*(m6sq - m7sq)*B0fin(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (m1**6*(m1sq - m4sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (3*m1**4*(m1sq - m4sq)*m4sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (5*m1sq*(m1sq - m4sq)*m6**4*m7sq*B0fin(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (5*m1**4*(m1sq - m4sq)*m6sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (3*m1sq*(m1sq - m4sq)*m4sq*m6sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (2*(m1sq - m4sq)**2*m6sq*(m1sq - m6sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + ((m1sq - m4sq)*m4sq*m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + ((m1sq - m4sq)*(m6sq - m7sq)**3*m7sq*B0fin(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - ((m1sq - m4sq)*m4sq*(m6sq - m7sq)**3*m7sq*B0fin(0,0,m7sq,mudim))/(m1**2*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (8*(m1sq - m4sq)*m6sq*m7sq*B0fin(0,0,m7sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (4*(m1sq - m4sq)*m7sq*(-m6sq + m7sq)*B0fin(0,0,m7sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (2*m4sq*(-m1sq + m4sq)*m7sq*B0fin(0,0,m7sq,mudim))/(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq)) + (4*(m1sq - m4sq)*m6sq*m7sq*B0fin(0,0,m7sq,mudim))/(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq)) + (2*(m1sq - m4sq)*m7sq*(-m6sq + m7sq)*B0fin(0,0,m7sq,mudim))/(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq)) - (8*m1**4*(m1sq - m4sq)*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (6*m1sq*(m1sq - m4sq)*m6sq*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (4*m1sq*(m1sq - m4sq)*m7**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (4*m1**6*(m1sq - m4sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*m1sq*(m1sq - m4sq)*m6**4*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (6*m1**4*(m1sq - m4sq)*m6sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (2*m1sq*(m1sq - m4sq)*m4sq*m6sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*(m1sq - m4sq)*m4sq*m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (4*(m1sq - m4sq)*(m6sq - m7sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (2*(m1sq - m4sq)*m4sq*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq)) + (2*(m1sq - m4sq)*(m6sq - m7sq)*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq)) - (2*(m1sq - m4sq)**2*m6sq*(m1sq - m6sq - m7sq)*m7sq*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (8*(m1sq - m4sq)*m6sq*m7sq*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) - (4*(m1sq - m4sq)*m6sq*m7sq*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq)) - (m1**4*(m1sq - m4sq)**2*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - ((m1sq - m4sq)**2*m6**4*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - ((m1sq - m4sq)**2*m7**4*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*(m1sq - m4sq)**2*m6sq*m7sq*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*(m1**3 - m1*m4sq)**2*(m6sq + m7sq)*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (4*(m1sq - m4sq)*(m1sq - m6sq - m7sq)*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (2*(m1sq - m4sq)*(m4sq - m6sq - m7sq)*(m4sq + m6sq + m7sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq)) + 6*T134fin(m7,m6,m1,mudim) - (4*(m1sq - m4sq)**2*m6sq*m7sq*T134fin(m7,m6,m1,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (4*(m1sq - m4sq)*(m1sq - m6sq - m7sq)*T134fin(m7,m6,m1,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) - 6*T134fin(m7,m6,m4,mudim) + (2*(m1sq - m4sq)*(m4sq - m6sq - m7sq)*T134fin(m7,m6,m4,mudim))/(4*m6sq*m7sq - (-m4sq + m6sq + m7sq)**2))/(2.*(m1sq - m4sq)**4)
		def eval_67():
			return ((10*m1**4*(m1sq - m5sq)**3*m6**4)/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (12*m1sq*(m1sq - m5sq)**3*m6**6)/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (3*m1**6*(m1sq - m5sq)**3*m6sq)/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (10*m1**4*(m1sq - m5sq)**3*m7**4)/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (32*(m1sq - m5sq)**3*m6**4*m7**4)/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (12*m1sq*(m1sq - m5sq)**3*m6sq*m7**4)/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (12*m1sq*(m1sq - m5sq)**3*m7**6)/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (21*(m1**3 - m1*m5sq)**2*m6**4)/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (9*m1**4*(m1sq - m5sq)**2*m6sq)/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (21*(m1**3 - m1*m5sq)**2*m7**4)/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (6*(m1sq - m5sq)**3*m6**6*(m6sq - m7sq))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (6*(m1sq - m5sq)**3*m6sq*m7**4*(m6sq - m7sq))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (15*(m1sq - m5sq)**2*m6**4*(m6sq - m7sq))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - ((m1sq - m5sq)**3*m6**4*(m6sq - m7sq)**3)/(m1**2*(m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + ((m1sq - m5sq)**3*m7**4*(m6sq - m7sq)**3)/(m1**2*(m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (3*(m1sq - m5sq)**2*m6sq*(m6sq - m7sq)**3)/(m1**2*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (3*m1**6*(m1sq - m5sq)**3*m7sq)/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (12*m1sq*(m1sq - m5sq)**3*m6**4*m7sq)/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (24*m1**4*(m1sq - m5sq)**3*m6sq*m7sq)/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (9*m1**4*(m1sq - m5sq)**2*m7sq)/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (6*m1sq*(m1sq - m5sq)**2*m6sq*m7sq)/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (12*(m1sq - m5sq)**2*m6sq*(m1sq - m6sq - m7sq)*m7sq)/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (6*(m1sq - m5sq)**3*m6**4*(m6sq - m7sq)*m7sq)/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (3*(m1sq - m5sq)**2*(m6sq - m7sq)**3*m7sq)/(m1**2*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (6*(m1sq - m5sq)**3*m7**6*(-m6sq + m7sq))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (15*(m1sq - m5sq)**2*m7**4*(-m6sq + m7sq))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (6*m1**4*(m1sq - m5sq)**2*(m1sq + m6sq + m7sq))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (6*(m1sq - m5sq)**2*m6**4*(m1sq + m6sq + m7sq))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (6*(m1sq - m5sq)**2*m7**4*(m1sq + m6sq + m7sq))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (12*(m1sq - m5sq)**2*m6sq*m7sq*(m1sq + m6sq + m7sq))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (24*(m1sq - m5sq)**3*m6sq*(m1sq - m6sq - m7sq)*m7sq*(m1sq + m6sq + m7sq))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (12*(m1**3 - m1*m5sq)**2*(m6sq + m7sq)*(m1sq + m6sq + m7sq))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (12*m1sq*(m1sq - m5sq)**3*m6sq*m7**4*B0del(0,0,m1sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (12*m1sq*(m1sq - m5sq)**3*m6**4*m7sq*B0del(0,0,m1sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (12*m1**4*(m1sq - m5sq)**3*m6sq*m7sq*B0del(0,0,m1sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (12*m1sq*(m1sq - m5sq)**2*m6sq*m7sq*B0del(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (6*m1sq*(m1sq - m5sq)*m6sq*B0del(0,0,m1sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) - (6*m1sq*(m1sq - m5sq)*m7sq*B0del(0,0,m1sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (12*(m1sq - m5sq)**3*m6**4*m7**4*B0del(0,0,m6sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (12*m1sq*(m1sq - m5sq)**3*m6sq*m7**4*B0del(0,0,m6sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (6*(m1sq - m5sq)**3*m6sq*m7**6*B0del(0,0,m6sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (6*(m1sq - m5sq)**3*m6sq*m7**4*(m6sq - m7sq)*B0del(0,0,m6sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (6*(m1sq - m5sq)**3*m6**6*m7sq*B0del(0,0,m6sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (6*m1sq*(m1sq - m5sq)**2*m6sq*m7sq*B0del(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (6*(m1sq - m5sq)**2*m6sq*(m1sq - m6sq - m7sq)*m7sq*B0del(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (6*(m1sq - m5sq)**3*m6**4*(m6sq - m7sq)*m7sq*B0del(0,0,m6sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (6*(m1sq - m5sq)**2*m6sq*(m6sq - m7sq)*m7sq*B0del(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (12*m1sq*(m1sq - m5sq)**3*m6sq*m7sq*(m6sq + m7sq)*B0del(0,0,m6sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (6*m1sq*(m1sq - m5sq)*m6sq*B0del(0,0,m6sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (6*(m1sq - m5sq)*m6sq*(m6sq - m7sq)*B0del(0,0,m6sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (12*(m1sq - m5sq)*m6sq*m7sq*B0del(0,0,m6sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (12*(m1sq - m5sq)**3*m6**4*m7**4*B0del(0,0,m7sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (6*(m1sq - m5sq)**3*m6sq*m7**6*B0del(0,0,m7sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (6*(m1sq - m5sq)**3*m6sq*m7**4*(m6sq - m7sq)*B0del(0,0,m7sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (12*m1sq*(m1sq - m5sq)**3*m6**4*m7sq*B0del(0,0,m7sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (6*(m1sq - m5sq)**3*m6**6*m7sq*B0del(0,0,m7sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (6*m1sq*(m1sq - m5sq)**2*m6sq*m7sq*B0del(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (6*(m1sq - m5sq)**2*m6sq*(m1sq - m6sq - m7sq)*m7sq*B0del(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (6*(m1sq - m5sq)**3*m6**4*(m6sq - m7sq)*m7sq*B0del(0,0,m7sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (6*(m1sq - m5sq)**2*m6sq*(m6sq - m7sq)*m7sq*B0del(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (12*m1sq*(m1sq - m5sq)**3*m6sq*m7sq*(m6sq + m7sq)*B0del(0,0,m7sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (6*m1sq*(m1sq - m5sq)*m7sq*B0del(0,0,m7sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (12*(m1sq - m5sq)*m6sq*m7sq*B0del(0,0,m7sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (6*(m1sq - m5sq)*m7sq*(-m6sq + m7sq)*B0del(0,0,m7sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (6*(m1sq - m5sq)*m6sq*(m6sq - m7sq)*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (6*(m1sq - m5sq)*m7sq*(-m6sq + m7sq)*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (15*m1**4*(m1sq - m5sq)**3*m6**4*B0fin(0,0,m1sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (22*m1sq*(m1sq - m5sq)**3*m6**6*B0fin(0,0,m1sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (4*m1**6*(m1sq - m5sq)**3*m6sq*B0fin(0,0,m1sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (15*m1**4*(m1sq - m5sq)**3*m7**4*B0fin(0,0,m1sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (14*m1sq*(m1sq - m5sq)**3*m6sq*m7**4*B0fin(0,0,m1sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (22*m1sq*(m1sq - m5sq)**3*m7**6*B0fin(0,0,m1sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (21*(m1**3 - m1*m5sq)**2*m6**4*B0fin(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (9*m1**4*(m1sq - m5sq)**2*m6sq*B0fin(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (21*(m1**3 - m1*m5sq)**2*m7**4*B0fin(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (16*(m1sq - m5sq)**3*m6**6*(m6sq - m7sq)*B0fin(0,0,m1sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (12*(m1sq - m5sq)**3*m6sq*m7**4*(m6sq - m7sq)*B0fin(0,0,m1sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (15*(m1sq - m5sq)**2*m6**4*(m6sq - m7sq)*B0fin(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (15*(m1sq - m5sq)**2*m7**4*(m6sq - m7sq)*B0fin(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (6*(m1sq - m5sq)**3*m6**4*(m6sq - m7sq)**3*B0fin(0,0,m1sq,mudim))/(m1**2*(m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (6*(m1sq - m5sq)**3*m7**4*(m6sq - m7sq)**3*B0fin(0,0,m1sq,mudim))/(m1**2*(m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (3*(m1sq - m5sq)**2*m6sq*(m6sq - m7sq)**3*B0fin(0,0,m1sq,mudim))/(m1**2*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + ((m1sq - m5sq)**3*m6sq*(m6sq - m7sq)**5*B0fin(0,0,m1sq,mudim))/(m1**4*(m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (4*m1**6*(m1sq - m5sq)**3*m7sq*B0fin(0,0,m1sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (14*m1sq*(m1sq - m5sq)**3*m6**4*m7sq*B0fin(0,0,m1sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (10*m1**4*(m1sq - m5sq)**3*m6sq*m7sq*B0fin(0,0,m1sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (9*m1**4*(m1sq - m5sq)**2*m7sq*B0fin(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (18*m1sq*(m1sq - m5sq)**2*m6sq*m7sq*B0fin(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (12*(m1sq - m5sq)**3*m6**4*(m6sq - m7sq)*m7sq*B0fin(0,0,m1sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (16*(m1sq - m5sq)**3*m7**6*(-m6sq + m7sq)*B0fin(0,0,m1sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (3*(m1sq - m5sq)**2*m7sq*(-m6sq + m7sq)**3*B0fin(0,0,m1sq,mudim))/(m1**2*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + ((m1sq - m5sq)**3*m7sq*(-m6sq + m7sq)**5*B0fin(0,0,m1sq,mudim))/(m1**4*(m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (6*m1sq*(m1sq - m5sq)*m6sq*B0fin(0,0,m1sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (6*m1sq*(m1sq - m5sq)*m7sq*B0fin(0,0,m1sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (15*m1**4*(m1sq - m5sq)**3*m6**4*B0fin(0,0,m6sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (22*m1sq*(m1sq - m5sq)**3*m6**6*B0fin(0,0,m6sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (4*m1**6*(m1sq - m5sq)**3*m6sq*B0fin(0,0,m6sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (36*(m1sq - m5sq)**3*m6**4*m7**4*B0fin(0,0,m6sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (8*m1sq*(m1sq - m5sq)**3*m6sq*m7**4*B0fin(0,0,m6sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (2*(m1sq - m5sq)**3*m6sq*m7**6*B0fin(0,0,m6sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (21*(m1**3 - m1*m5sq)**2*m6**4*B0fin(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (9*m1**4*(m1sq - m5sq)**2*m6sq*B0fin(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (16*(m1sq - m5sq)**3*m6**6*(m6sq - m7sq)*B0fin(0,0,m6sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (16*(m1sq - m5sq)**3*m6sq*m7**4*(m6sq - m7sq)*B0fin(0,0,m6sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (15*(m1sq - m5sq)**2*m6**4*(m6sq - m7sq)*B0fin(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (6*(m1sq - m5sq)**3*m6**4*(m6sq - m7sq)**3*B0fin(0,0,m6sq,mudim))/(m1**2*(m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (3*(m1sq - m5sq)**2*m6sq*(m6sq - m7sq)**3*B0fin(0,0,m6sq,mudim))/(m1**2*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + ((m1sq - m5sq)**3*m6sq*(m6sq - m7sq)**5*B0fin(0,0,m6sq,mudim))/(m1**4*(m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (22*m1sq*(m1sq - m5sq)**3*m6**4*m7sq*B0fin(0,0,m6sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (2*(m1sq - m5sq)**3*m6**6*m7sq*B0fin(0,0,m6sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (7*m1**4*(m1sq - m5sq)**3*m6sq*m7sq*B0fin(0,0,m6sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (9*m1sq*(m1sq - m5sq)**2*m6sq*m7sq*B0fin(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (6*(m1sq - m5sq)**2*m6sq*(m1sq - m6sq - m7sq)*m7sq*B0fin(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (28*(m1sq - m5sq)**3*m6**4*(m6sq - m7sq)*m7sq*B0fin(0,0,m6sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (3*(m1sq - m5sq)**2*m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (8*(m1sq - m5sq)**3*m6sq*(m6sq - m7sq)**3*m7sq*B0fin(0,0,m6sq,mudim))/(m1**2*(m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (4*m1sq*(m1sq - m5sq)**3*m6sq*m7sq*(m6sq + m7sq)*B0fin(0,0,m6sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (6*m1sq*(m1sq - m5sq)*m6sq*B0fin(0,0,m6sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) - (6*(m1sq - m5sq)*m6sq*(m6sq - m7sq)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) - (12*(m1sq - m5sq)*m6sq*m7sq*B0fin(0,0,m6sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (12*m1sq*(m1sq - m5sq)**3*m6sq*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (6*(m1sq - m5sq)**3*m6sq*m7**4*(m6sq - m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (6*m1**4*(m1sq - m5sq)**3*m6sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (6*m1sq*(m1sq - m5sq)**2*m6sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (6*(m1sq - m5sq)**3*m6**4*(m6sq - m7sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (6*(m1sq - m5sq)**2*m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (6*m1sq*(m1sq - m5sq)*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (6*(m1sq - m5sq)*m6sq*(m6sq - m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (15*m1**4*(m1sq - m5sq)**3*m7**4*B0fin(0,0,m7sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (36*(m1sq - m5sq)**3*m6**4*m7**4*B0fin(0,0,m7sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (22*m1sq*(m1sq - m5sq)**3*m6sq*m7**4*B0fin(0,0,m7sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (22*m1sq*(m1sq - m5sq)**3*m7**6*B0fin(0,0,m7sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (2*(m1sq - m5sq)**3*m6sq*m7**6*B0fin(0,0,m7sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (21*(m1**3 - m1*m5sq)**2*m7**4*B0fin(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (28*(m1sq - m5sq)**3*m6sq*m7**4*(m6sq - m7sq)*B0fin(0,0,m7sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (15*(m1sq - m5sq)**2*m7**4*(m6sq - m7sq)*B0fin(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (6*(m1sq - m5sq)**3*m7**4*(m6sq - m7sq)**3*B0fin(0,0,m7sq,mudim))/(m1**2*(m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (4*m1**6*(m1sq - m5sq)**3*m7sq*B0fin(0,0,m7sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (8*m1sq*(m1sq - m5sq)**3*m6**4*m7sq*B0fin(0,0,m7sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (2*(m1sq - m5sq)**3*m6**6*m7sq*B0fin(0,0,m7sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (7*m1**4*(m1sq - m5sq)**3*m6sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (9*m1**4*(m1sq - m5sq)**2*m7sq*B0fin(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (9*m1sq*(m1sq - m5sq)**2*m6sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (6*(m1sq - m5sq)**2*m6sq*(m1sq - m6sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (16*(m1sq - m5sq)**3*m6**4*(m6sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (3*(m1sq - m5sq)**2*m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (8*(m1sq - m5sq)**3*m6sq*(m6sq - m7sq)**3*m7sq*B0fin(0,0,m7sq,mudim))/(m1**2*(m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (16*(m1sq - m5sq)**3*m7**6*(-m6sq + m7sq)*B0fin(0,0,m7sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (3*(m1sq - m5sq)**2*m7sq*(-m6sq + m7sq)**3*B0fin(0,0,m7sq,mudim))/(m1**2*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + ((m1sq - m5sq)**3*m7sq*(-m6sq + m7sq)**5*B0fin(0,0,m7sq,mudim))/(m1**4*(m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (4*m1sq*(m1sq - m5sq)**3*m6sq*m7sq*(m6sq + m7sq)*B0fin(0,0,m7sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (6*m1sq*(m1sq - m5sq)*m7sq*B0fin(0,0,m7sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) - (12*(m1sq - m5sq)*m6sq*m7sq*B0fin(0,0,m7sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (6*(m1sq - m5sq)*(m6sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) - (6*(m1sq - m5sq)**3*m6sq*m7**4*(m6sq - m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (12*m1sq*(m1sq - m5sq)**3*m6**4*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (6*m1**4*(m1sq - m5sq)**3*m6sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (6*m1sq*(m1sq - m5sq)**2*m6sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (6*(m1sq - m5sq)**3*m6**4*(m6sq - m7sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (6*(m1sq - m5sq)**2*m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (6*m1sq*(m1sq - m5sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (6*(m1sq - m5sq)*m7sq*(-m6sq + m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (12*(m1sq - m5sq)**3*m6**4*m7**4*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (6*(m1sq - m5sq)**3*m6sq*m7**6*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (6*(m1sq - m5sq)**3*m6**6*m7sq*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (6*m1**4*(m1sq - m5sq)**3*m6sq*m7sq*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (6*(m1sq - m5sq)**2*m6sq*(m1sq - m6sq - m7sq)*m7sq*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (12*m1sq*(m1sq - m5sq)**3*m6sq*m7sq*(m6sq + m7sq)*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (12*(m1sq - m5sq)*m6sq*m7sq*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (3*m1**4*(m1sq - m5sq)**2*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (3*(m1sq - m5sq)**2*m6**4*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (3*(m1sq - m5sq)**2*m7**4*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (m1**4*(m1sq - m5sq)**3*(m1sq - m6sq - m7sq)*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + ((m1sq - m5sq)**3*m6**4*(m1sq - m6sq - m7sq)*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + ((m1sq - m5sq)**3*m7**4*(m1sq - m6sq - m7sq)*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (6*(m1sq - m5sq)**2*m6sq*m7sq*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*(m1sq - m5sq)**3*m6sq*(m1sq - m6sq - m7sq)*m7sq*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (6*(m1**3 - m1*m5sq)**2*(m6sq + m7sq)*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (2*m1sq*(m1sq - m5sq)**3*(m1sq - m6sq - m7sq)*(m6sq + m7sq)*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) - (6*(m1sq - m5sq)*(m1sq - m6sq - m7sq)*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) - 6*T134fin(m7,m6,m1,mudim) + (12*(m1sq - m5sq)**2*m6sq*m7sq*T134fin(m7,m6,m1,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (12*(m1sq - m5sq)**3*m6sq*(m1sq - m6sq - m7sq)*m7sq*T134fin(m7,m6,m1,mudim))/((m1 - m6 - m7)**3*(m1 + m6 - m7)**3*(m1 - m6 + m7)**3*(m1 + m6 + m7)**3) + (6*(m1sq - m5sq)*(m1sq - m6sq - m7sq)*T134fin(m7,m6,m1,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + 6*T134fin(m7,m6,m5,mudim))/(6.*(m1sq - m5sq)**4)
		def eval_68():
			return ((7*m3sq*m6**4)/((m1sq - m3sq)*(m2sq - m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (3*m3**4*m6sq)/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (7*m3sq*m7**4)/((m1sq - m3sq)*(m2sq - m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (5*m6**4*(m6sq - m7sq))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (5*m7**4*(m6sq - m7sq))/((m1sq - m3sq)*(m2sq - m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (m6sq*(m6sq - m7sq)**3)/(m3**2*(m1sq - m3sq)*(m2sq - m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (3*m3**4*m7sq)/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (2*m3sq*m6sq*m7sq)/((m1sq - m3sq)*(m2sq - m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (m7sq*(-m6sq + m7sq)**3)/(m3**2*(-m1sq + m3sq)*(-m2sq + m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (4*m6sq*m7sq*(-m3sq + m6sq + m7sq))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) - (2*m3**4*(m3sq + m6sq + m7sq))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) - (2*m6**4*(m3sq + m6sq + m7sq))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) - (2*m7**4*(m3sq + m6sq + m7sq))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) - (4*m6sq*m7sq*(m3sq + m6sq + m7sq))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (4*m3sq*(m6sq + m7sq)*(m3sq + m6sq + m7sq))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (4*m3sq*m6sq*m7sq*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)*(m2sq - m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (2*(m1sq + m2sq - 2*m3sq)*m3sq*m6sq*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)**2*(m2sq - m3sq)**2*(4*m6sq*m7sq - (-m3sq + m6sq + m7sq)**2)) + (2*(m1sq + m2sq - 2*m3sq)*m3sq*m7sq*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)**2*(m2sq - m3sq)**2*(4*m6sq*m7sq - (-m3sq + m6sq + m7sq)**2)) + (2*m3sq*m6sq*m7sq*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)*(m2sq - m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (2*m6sq*(m6sq - m7sq)*m7sq*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)*(m2sq - m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) - (2*m6sq*m7sq*(-m3sq + m6sq + m7sq)*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (2*(m1sq + m2sq - 2*m3sq)*m6sq*(m6sq - m7sq)*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m2sq - m3sq)**2*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + (2*(m1sq + m2sq - 2*m3sq)*m3sq*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m2sq - m3sq)**2*(4*m6sq*m7sq - (-m3sq + m6sq + m7sq)**2)) - (4*(m1sq + m2sq - 2*m3sq)*m6sq*m7sq*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m2sq - m3sq)**2*(4*m6sq*m7sq - (-m3sq + m6sq + m7sq)**2)) + (2*m3sq*m6sq*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)*(m2sq - m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (2*m6sq*(m6sq - m7sq)*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) - (2*m6sq*m7sq*(-m3sq + m6sq + m7sq)*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (2*(m1sq + m2sq - 2*m3sq)*m7sq*(-m6sq + m7sq)*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m2sq - m3sq)**2*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + (2*(m1sq + m2sq - 2*m3sq)*m3sq*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m2sq - m3sq)**2*(4*m6sq*m7sq - (-m3sq + m6sq + m7sq)**2)) - (4*(m1sq + m2sq - 2*m3sq)*m6sq*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m2sq - m3sq)**2*(4*m6sq*m7sq - (-m3sq + m6sq + m7sq)**2)) + (2*(m1sq + m2sq - 2*m3sq)*m6sq*(m6sq - m7sq)*(B0del(0,0,m3sq,mudim) - B0fin(0,0,m3sq,mudim)))/((m1sq - m3sq)**2*(m2sq - m3sq)**2*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + (2*(m1sq + m2sq - 2*m3sq)*m7sq*(-m6sq + m7sq)*(B0del(0,0,m3sq,mudim) - B0fin(0,0,m3sq,mudim)))/((m1sq - m3sq)**2*(m2sq - m3sq)**2*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + (7*m3sq*m6**4*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (3*m3**4*m6sq*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(m2sq - m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (7*m3sq*m7**4*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (5*m6**4*(m6sq - m7sq)*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(m2sq - m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (5*m7**4*(m6sq - m7sq)*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) - (m6sq*(m6sq - m7sq)**3*B0fin(0,0,m3sq,mudim))/(m3**2*(m1sq - m3sq)*(m2sq - m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (3*m3**4*m7sq*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(m2sq - m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (6*m3sq*m6sq*m7sq*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + ((m6sq - m7sq)**3*m7sq*B0fin(0,0,m3sq,mudim))/(m3**2*(m1sq - m3sq)*(m2sq - m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) - (2*(m1sq + m2sq - 2*m3sq)*m3sq*m6sq*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)**2*(m2sq - m3sq)**2*(4*m6sq*m7sq - (-m3sq + m6sq + m7sq)**2)) - (2*(m1sq + m2sq - 2*m3sq)*m3sq*m7sq*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)**2*(m2sq - m3sq)**2*(4*m6sq*m7sq - (-m3sq + m6sq + m7sq)**2)) + (7*m3sq*m6**4*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (3*m3**4*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(m2sq - m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (5*m6**4*(m6sq - m7sq)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(m2sq - m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) - (m6sq*(m6sq - m7sq)**3*B0fin(0,0,m6sq,mudim))/(m3**2*(m1sq - m3sq)*(m2sq - m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (3*m3sq*m6sq*m7sq*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(m2sq - m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) - (2*m6sq*m7sq*(-m3sq + m6sq + m7sq)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) - (2*(m1sq + m2sq - 2*m3sq)*m6sq*(m6sq - m7sq)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m2sq - m3sq)**2*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) - (2*(m1sq + m2sq - 2*m3sq)*m3sq*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m2sq - m3sq)**2*(4*m6sq*m7sq - (-m3sq + m6sq + m7sq)**2)) + (4*(m1sq + m2sq - 2*m3sq)*m6sq*m7sq*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m2sq - m3sq)**2*(4*m6sq*m7sq - (-m3sq + m6sq + m7sq)**2)) + (2*m3sq*m6sq*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(m2sq - m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (2*m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(m2sq - m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (2*(m1sq + m2sq - 2*m3sq)*m6sq*(m6sq - m7sq)*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m2sq - m3sq)**2*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + (2*(m1sq + m2sq - 2*m3sq)*m3sq*m6sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m2sq - m3sq)**2*(4*m6sq*m7sq - (-m3sq + m6sq + m7sq)**2)) + (7*m3sq*m7**4*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (5*m7**4*(m6sq - m7sq)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (3*m3**4*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(m2sq - m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (3*m3sq*m6sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + ((m6sq - m7sq)**3*m7sq*B0fin(0,0,m7sq,mudim))/(m3**2*(m1sq - m3sq)*(m2sq - m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) - (2*m6sq*m7sq*(-m3sq + m6sq + m7sq)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (2*(m1sq + m2sq - 2*m3sq)*(m6sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m2sq - m3sq)**2*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) - (2*(m1sq + m2sq - 2*m3sq)*m3sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m2sq - m3sq)**2*(4*m6sq*m7sq - (-m3sq + m6sq + m7sq)**2)) + (4*(m1sq + m2sq - 2*m3sq)*m6sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m2sq - m3sq)**2*(4*m6sq*m7sq - (-m3sq + m6sq + m7sq)**2)) + (2*m3sq*m6sq*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(m2sq - m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (2*m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (2*(m1sq + m2sq - 2*m3sq)*m7sq*(-m6sq + m7sq)*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m2sq - m3sq)**2*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + (2*(m1sq + m2sq - 2*m3sq)*m3sq*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m2sq - m3sq)**2*(4*m6sq*m7sq - (-m3sq + m6sq + m7sq)**2)) - (2*m6sq*m7sq*(-m3sq + m6sq + m7sq)*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) - (4*(m1sq + m2sq - 2*m3sq)*m6sq*m7sq*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m2sq - m3sq)**2*(4*m6sq*m7sq - (-m3sq + m6sq + m7sq)**2)) + (m3**4*(m3sq + m6sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (m6**4*(m3sq + m6sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (m7**4*(m3sq + m6sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) - (2*m6sq*m7sq*(m3sq + m6sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) - (2*m3sq*(m6sq + m7sq)*(m3sq + m6sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) - (2*(m1sq + m2sq - 2*m3sq)*(m3sq - m6sq - m7sq)*(m3sq + m6sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)**2*(m2sq - m3sq)**2*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + (2*T134fin(m7,m6,m1,mudim))/((m1sq - m2sq)*(m1sq - m3sq)**3) - (2*T134fin(m7,m6,m2,mudim))/((m1sq - m2sq)*(m2sq - m3sq)**3) - (2*T134fin(m7,m6,m3,mudim))/((m1sq - m2sq)*(m1sq - m3sq)**3) + (2*T134fin(m7,m6,m3,mudim))/((m1sq - m2sq)*(m2sq - m3sq)**3) + (4*m6sq*m7sq*T134fin(m7,m6,m3,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m6 - m7)**2*(m3 - m6 + m7)**2*(-m3 + m6 + m7)**2*(m3 + m6 + m7)**2) + (2*(m1sq + m2sq - 2*m3sq)*(m3sq - m6sq - m7sq)*T134fin(m7,m6,m3,mudim))/((m1sq - m3sq)**2*(m2sq - m3sq)**2*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))))/2.
		def eval_69():
			return (m2sq*m6sq*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)**2*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + (m2sq*m7sq*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)**2*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + (m4sq*m6sq*B0del(0,0,m4sq,mudim))/((m1sq - m4sq)*(m2sq - m4sq)**2*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (m4sq*m7sq*B0del(0,0,m4sq,mudim))/((m1sq - m4sq)*(m2sq - m4sq)**2*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (m2sq*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)**2*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) - (m6sq*(m6sq - m7sq)*B0del(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)**2*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + (m4sq*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m4sq)*(m2sq - m4sq)**2*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) - (m6sq*(m6sq - m7sq)*B0del(0,0,m6sq,mudim))/((m1sq - m4sq)*(m2sq - m4sq)**2*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (2*m6sq*m7sq*(-((m1sq - m2sq)*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + (m1sq - m4sq)*(4*m6sq*m7sq - (-m4sq + m6sq + m7sq)**2))*B0del(0,0,m6sq,mudim))/((m1sq - m2sq)*(m1sq - m4sq)*(m2sq - m4sq)**2*(4*m6sq*m7sq - (-m2sq + m6sq + m7sq)**2)*(4*m6sq*m7sq - (-m4sq + m6sq + m7sq)**2)) + (m2sq*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)**2*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + ((m6sq - m7sq)*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)**2*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + (m4sq*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m4sq)*(m2sq - m4sq)**2*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + ((m6sq - m7sq)*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m4sq)*(m2sq - m4sq)**2*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (2*m6sq*m7sq*(-((m1sq - m2sq)*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + (m1sq - m4sq)*(4*m6sq*m7sq - (-m4sq + m6sq + m7sq)**2))*B0del(0,0,m7sq,mudim))/((m1sq - m2sq)*(m1sq - m4sq)*(m2sq - m4sq)**2*(4*m6sq*m7sq - (-m2sq + m6sq + m7sq)**2)*(4*m6sq*m7sq - (-m4sq + m6sq + m7sq)**2)) - (m6sq*(m6sq - m7sq)*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)))/((m1sq - m2sq)*(m2sq - m4sq)**2*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + ((m6sq - m7sq)*m7sq*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)))/((m1sq - m2sq)*(m2sq - m4sq)**2*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) - (m2sq*m6sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)**2*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) - (m2sq*m7sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)**2*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) - (m6sq*(m6sq - m7sq)*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/((m1sq - m4sq)*(m2sq - m4sq)**2*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + ((m6sq - m7sq)*m7sq*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/((m1sq - m4sq)*(m2sq - m4sq)**2*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) - (m4sq*m6sq*B0fin(0,0,m4sq,mudim))/((m1sq - m4sq)*(m2sq - m4sq)**2*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) - (m4sq*m7sq*B0fin(0,0,m4sq,mudim))/((m1sq - m4sq)*(m2sq - m4sq)**2*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) - (m2sq*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)**2*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + (m6sq*(m6sq - m7sq)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)**2*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) - (m4sq*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m4sq)*(m2sq - m4sq)**2*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (m6sq*(m6sq - m7sq)*B0fin(0,0,m6sq,mudim))/((m1sq - m4sq)*(m2sq - m4sq)**2*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) - (2*m6sq*m7sq*(-((m1sq - m2sq)*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + (m1sq - m4sq)*(4*m6sq*m7sq - (-m4sq + m6sq + m7sq)**2))*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m1sq - m4sq)*(m2sq - m4sq)**2*(4*m6sq*m7sq - (-m2sq + m6sq + m7sq)**2)*(4*m6sq*m7sq - (-m4sq + m6sq + m7sq)**2)) + (m2sq*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)**2*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) - (m6sq*(m6sq - m7sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)**2*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + (m4sq*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m4sq)*(m2sq - m4sq)**2*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) - (m6sq*(m6sq - m7sq)*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m4sq)*(m2sq - m4sq)**2*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) - (m2sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)**2*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + (m7sq*(-m6sq + m7sq)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)**2*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) - (m4sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m4sq)*(m2sq - m4sq)**2*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (m7sq*(-m6sq + m7sq)*B0fin(0,0,m7sq,mudim))/((m1sq - m4sq)*(m2sq - m4sq)**2*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) - (2*m6sq*m7sq*(-((m1sq - m2sq)*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + (m1sq - m4sq)*(4*m6sq*m7sq - (-m4sq + m6sq + m7sq)**2))*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m1sq - m4sq)*(m2sq - m4sq)**2*(4*m6sq*m7sq - (-m2sq + m6sq + m7sq)**2)*(4*m6sq*m7sq - (-m4sq + m6sq + m7sq)**2)) + (m2sq*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)**2*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + ((m6sq - m7sq)*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)**2*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + (m4sq*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m4sq)*(m2sq - m4sq)**2*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + ((m6sq - m7sq)*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m4sq)*(m2sq - m4sq)**2*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (2*m6sq*m7sq*(-((m1sq - m2sq)*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + (m1sq - m4sq)*(4*m6sq*m7sq - (-m4sq + m6sq + m7sq)**2))*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m1sq - m4sq)*(m2sq - m4sq)**2*(4*m6sq*m7sq - (-m2sq + m6sq + m7sq)**2)*(4*m6sq*m7sq - (-m4sq + m6sq + m7sq)**2)) + ((m2sq - m6sq - m7sq)*(m2sq + m6sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)*(m2sq - m4sq)**2*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) - (m2sq*m4**4*(m4sq + m6sq + m7sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m4sq)**2*(m2sq - m4sq)**3*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (m1sq*m4**4*(m4sq + m6sq + m7sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m4sq)**2*(-m2sq + m4sq)**3*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) - (m4**6*(m4sq + m6sq + m7sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m4sq)**2*(-m2sq + m4sq)**3*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) - (m1sq*m2sq*(m4sq - m6sq - m7sq)*(m4sq + m6sq + m7sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m4sq)**2*(-m2sq + m4sq)**3*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (m2sq*m4sq*(m6sq + m7sq)*(m4sq + m6sq + m7sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m4sq)**2*(m2sq - m4sq)**3*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (m4**4*(m6sq + m7sq)*(m4sq + m6sq + m7sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m4sq)**2*(-m2sq + m4sq)**3*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) - (m1sq*m4sq*(m6sq + m7sq)*(m4sq + m6sq + m7sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m4sq)**2*(-m2sq + m4sq)**3*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + T134fin(m7,m6,m1,mudim)/((m1sq - m2sq)**2*(m1sq - m4sq)**2) + (2*T134fin(m7,m6,m2,mudim))/((m1sq - m2sq)*(m2sq - m4sq)**3) - (m2sq*T134fin(m7,m6,m2,mudim))/((m1sq - m2sq)**2*(m2sq - m4sq)**3) + (m4sq*T134fin(m7,m6,m2,mudim))/((m1sq - m2sq)**2*(m2sq - m4sq)**3) + ((m2sq - m6sq - m7sq)*T134fin(m7,m6,m2,mudim))/((m1sq - m2sq)*(m2sq - m4sq)**2*(4*m6sq*m7sq - (-m2sq + m6sq + m7sq)**2)) + (m1sq*m4**4*T134fin(m7,m6,m4,mudim))/((m1sq - m4sq)**2*(-m2sq + m4sq)**3*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) - (2*m4**6*T134fin(m7,m6,m4,mudim))/((m1sq - m4sq)**2*(-m2sq + m4sq)**3*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (m1sq*m2sq*(m4sq - m6sq - m7sq)*T134fin(m7,m6,m4,mudim))/((m1sq - m4sq)**2*(-m2sq + m4sq)**3*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (2*m1sq*(m6sq - m7sq)**2*T134fin(m7,m6,m4,mudim))/((m1sq - m4sq)**2*(-m2sq + m4sq)**3*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (m2sq*(m6sq - m7sq)**2*T134fin(m7,m6,m4,mudim))/((m1sq - m4sq)**2*(-m2sq + m4sq)**3*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) - (3*m4sq*(m6sq - m7sq)**2*T134fin(m7,m6,m4,mudim))/((m1sq - m4sq)**2*(-m2sq + m4sq)**3*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (m2sq*m4sq*(m6sq + m7sq)*T134fin(m7,m6,m4,mudim))/((m1sq - m4sq)**2*(m2sq - m4sq)**3*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (5*m4**4*(m6sq + m7sq)*T134fin(m7,m6,m4,mudim))/((m1sq - m4sq)**2*(-m2sq + m4sq)**3*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) - (3*m1sq*m4sq*(m6sq + m7sq)*T134fin(m7,m6,m4,mudim))/((m1sq - m4sq)**2*(-m2sq + m4sq)**3*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq)))
		def eval_70():
			return ((-7*m2sq*m6**4)/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (3*m2**4*m6sq)/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (7*m2sq*m7**4)/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (5*m6**4*(m6sq - m7sq))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (m6sq*(m6sq - m7sq)**3)/(m2**2*(-m1sq + m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (3*m2**4*m7sq)/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (2*m2sq*m6sq*m7sq)/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + ((m6sq - m7sq)**3*m7sq)/(m2**2*(m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (5*m7**4*(-m6sq + m7sq))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (4*m6sq*m7sq*(-m2sq + m6sq + m7sq))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (2*m2**4*(m2sq + m6sq + m7sq))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (2*m6**4*(m2sq + m6sq + m7sq))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (2*m7**4*(m2sq + m6sq + m7sq))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (4*m6sq*m7sq*(m2sq + m6sq + m7sq))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (4*m2sq*(m6sq + m7sq)*(m2sq + m6sq + m7sq))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (4*m2sq*m6sq*m7sq*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (2*m2sq*(m1sq - 2*m2sq + m5sq)*m6sq*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)**2*(m2sq - m5sq)**2*(4*m6sq*m7sq - (-m2sq + m6sq + m7sq)**2)) + (2*m2sq*(m1sq - 2*m2sq + m5sq)*m7sq*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)**2*(m2sq - m5sq)**2*(4*m6sq*m7sq - (-m2sq + m6sq + m7sq)**2)) - (2*m2sq*m6sq*m7sq*B0del(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (2*m6sq*(m6sq - m7sq)*m7sq*B0del(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (2*m6sq*m7sq*(-m2sq + m6sq + m7sq)*B0del(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (2*(m1sq - 2*m2sq + m5sq)*m6sq*(m6sq - m7sq)*B0del(0,0,m6sq,mudim))/((m1sq - m2sq)**2*(m2sq - m5sq)**2*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + (2*m2sq*(m1sq - 2*m2sq + m5sq)*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m2sq)**2*(m2sq - m5sq)**2*(4*m6sq*m7sq - (-m2sq + m6sq + m7sq)**2)) - (4*(m1sq - 2*m2sq + m5sq)*m6sq*m7sq*B0del(0,0,m6sq,mudim))/((m1sq - m2sq)**2*(m2sq - m5sq)**2*(4*m6sq*m7sq - (-m2sq + m6sq + m7sq)**2)) - (2*m2sq*m6sq*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (2*m6sq*(m6sq - m7sq)*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (2*m6sq*m7sq*(-m2sq + m6sq + m7sq)*B0del(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (2*(m1sq - 2*m2sq + m5sq)*m7sq*(-m6sq + m7sq)*B0del(0,0,m7sq,mudim))/((m1sq - m2sq)**2*(m2sq - m5sq)**2*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + (2*m2sq*(m1sq - 2*m2sq + m5sq)*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m2sq)**2*(m2sq - m5sq)**2*(4*m6sq*m7sq - (-m2sq + m6sq + m7sq)**2)) - (4*(m1sq - 2*m2sq + m5sq)*m6sq*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m2sq)**2*(m2sq - m5sq)**2*(4*m6sq*m7sq - (-m2sq + m6sq + m7sq)**2)) + (2*(m1sq - 2*m2sq + m5sq)*m6sq*(m6sq - m7sq)*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)))/((m1sq - m2sq)**2*(m2sq - m5sq)**2*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + (2*(m1sq - 2*m2sq + m5sq)*m7sq*(-m6sq + m7sq)*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)))/((m1sq - m2sq)**2*(m2sq - m5sq)**2*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + (7*m2sq*m6**4*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (3*m2**4*m6sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (7*m2sq*m7**4*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (5*m6**4*(m6sq - m7sq)*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (5*m7**4*(m6sq - m7sq)*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (m6sq*(m6sq - m7sq)**3*B0fin(0,0,m2sq,mudim))/(m2**2*(m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (3*m2**4*m7sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (6*m2sq*m6sq*m7sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + ((m6sq - m7sq)**3*m7sq*B0fin(0,0,m2sq,mudim))/(m2**2*(-m1sq + m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (2*m2sq*(m1sq - 2*m2sq + m5sq)*m6sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)**2*(m2sq - m5sq)**2*(4*m6sq*m7sq - (-m2sq + m6sq + m7sq)**2)) - (2*m2sq*(m1sq - 2*m2sq + m5sq)*m7sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)**2*(m2sq - m5sq)**2*(4*m6sq*m7sq - (-m2sq + m6sq + m7sq)**2)) + (7*m2sq*m6**4*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (3*m2**4*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (5*m6**4*(m6sq - m7sq)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (m6sq*(m6sq - m7sq)**3*B0fin(0,0,m6sq,mudim))/(m2**2*(m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (3*m2sq*m6sq*m7sq*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (2*m6sq*m7sq*(-m2sq + m6sq + m7sq)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (2*(m1sq - 2*m2sq + m5sq)*m6sq*(m6sq - m7sq)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)**2*(m2sq - m5sq)**2*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) - (2*m2sq*(m1sq - 2*m2sq + m5sq)*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)**2*(m2sq - m5sq)**2*(4*m6sq*m7sq - (-m2sq + m6sq + m7sq)**2)) + (4*(m1sq - 2*m2sq + m5sq)*m6sq*m7sq*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)**2*(m2sq - m5sq)**2*(4*m6sq*m7sq - (-m2sq + m6sq + m7sq)**2)) - (2*m2sq*m6sq*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (2*m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (2*(m1sq - 2*m2sq + m5sq)*m6sq*(m6sq - m7sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)**2*(m2sq - m5sq)**2*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + (2*m2sq*(m1sq - 2*m2sq + m5sq)*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)**2*(m2sq - m5sq)**2*(4*m6sq*m7sq - (-m2sq + m6sq + m7sq)**2)) + (7*m2sq*m7**4*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (5*m7**4*(m6sq - m7sq)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (3*m2**4*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (3*m2sq*m6sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + ((m6sq - m7sq)**3*m7sq*B0fin(0,0,m7sq,mudim))/(m2**2*(-m1sq + m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (2*m6sq*m7sq*(-m2sq + m6sq + m7sq)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (2*(m1sq - 2*m2sq + m5sq)*(m6sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)**2*(m2sq - m5sq)**2*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) - (2*m2sq*(m1sq - 2*m2sq + m5sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)**2*(m2sq - m5sq)**2*(4*m6sq*m7sq - (-m2sq + m6sq + m7sq)**2)) + (4*(m1sq - 2*m2sq + m5sq)*m6sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)**2*(m2sq - m5sq)**2*(4*m6sq*m7sq - (-m2sq + m6sq + m7sq)**2)) - (2*m2sq*m6sq*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (2*m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (2*(m1sq - 2*m2sq + m5sq)*m7sq*(-m6sq + m7sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)**2*(m2sq - m5sq)**2*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + (2*m2sq*(m1sq - 2*m2sq + m5sq)*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)**2*(m2sq - m5sq)**2*(4*m6sq*m7sq - (-m2sq + m6sq + m7sq)**2)) - (2*m6sq*m7sq*(-m2sq + m6sq + m7sq)*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (4*(m1sq - 2*m2sq + m5sq)*m6sq*m7sq*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)**2*(m2sq - m5sq)**2*(4*m6sq*m7sq - (-m2sq + m6sq + m7sq)**2)) + (m2**4*(m2sq + m6sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (m6**4*(m2sq + m6sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (m7**4*(m2sq + m6sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (2*m6sq*m7sq*(m2sq + m6sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (2*m2sq*(m6sq + m7sq)*(m2sq + m6sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) - (2*(m1sq - 2*m2sq + m5sq)*(m2sq - m6sq - m7sq)*(m2sq + m6sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)**2*(m2sq - m5sq)**2*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + (2*T134fin(m7,m6,m1,mudim))/((m1sq - m2sq)**3*(m1sq - m5sq)) - (2*T134fin(m7,m6,m2,mudim))/((m1sq - m2sq)*(m2sq - m5sq)**3) + (2*T134fin(m7,m6,m2,mudim))/((m1sq - m2sq)**2*(m2sq - m5sq)**2) - (2*T134fin(m7,m6,m2,mudim))/((m1sq - m2sq)**3*(m2sq - m5sq)) + (4*m6sq*m7sq*T134fin(m7,m6,m2,mudim))/((m1sq - m2sq)*(m2sq - m5sq)*(m2 + m6 - m7)**2*(m2 - m6 + m7)**2*(-m2 + m6 + m7)**2*(m2 + m6 + m7)**2) + (2*(m1sq - 2*m2sq + m5sq)*(m2sq - m6sq - m7sq)*T134fin(m7,m6,m2,mudim))/((m1sq - m2sq)**2*(m2sq - m5sq)**2*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) - (2*T134fin(m7,m6,m5,mudim))/((m1sq - m5sq)*(-m2sq + m5sq)**3))/2.
		def eval_71():
			return -((m1sq*m6sq*B0del(0,0,m1sq,mudim))/((m1sq - m3sq)*(m1sq - m4sq)**2*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)))) - (m1sq*m7sq*B0del(0,0,m1sq,mudim))/((m1sq - m3sq)*(m1sq - m4sq)**2*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (m4sq*m6sq*B0del(0,0,m4sq,mudim))/((m1sq - m4sq)**2*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) - (m4sq*m7sq*B0del(0,0,m4sq,mudim))/((m1sq - m4sq)**2*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) - (m1sq*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)*(m1sq - m4sq)**2*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (m6sq*(m6sq - m7sq)*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)*(m1sq - m4sq)**2*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (m4sq*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m4sq)**2*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (m6sq*(m6sq - m7sq)*B0del(0,0,m6sq,mudim))/((m1sq - m4sq)**2*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (2*m6sq*m7sq*(-((m1sq - m3sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (m3sq - m4sq)*(4*m6sq*m7sq - (-m4sq + m6sq + m7sq)**2))*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)*(m1sq - m4sq)**2*(m3sq - m4sq)*(4*m6sq*m7sq - (-m1sq + m6sq + m7sq)**2)*(4*m6sq*m7sq - (-m4sq + m6sq + m7sq)**2)) - (m1sq*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)*(m1sq - m4sq)**2*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (m7sq*(-m6sq + m7sq)*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)*(m1sq - m4sq)**2*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (m4sq*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m4sq)**2*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (m7sq*(-m6sq + m7sq)*B0del(0,0,m7sq,mudim))/((m1sq - m4sq)**2*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (2*m6sq*m7sq*(-((m1sq - m3sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (m3sq - m4sq)*(4*m6sq*m7sq - (-m4sq + m6sq + m7sq)**2))*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)*(m1sq - m4sq)**2*(m3sq - m4sq)*(4*m6sq*m7sq - (-m1sq + m6sq + m7sq)**2)*(4*m6sq*m7sq - (-m4sq + m6sq + m7sq)**2)) + (m6sq*(m6sq - m7sq)*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/((m1sq - m3sq)*(m1sq - m4sq)**2*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (m7sq*(-m6sq + m7sq)*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/((m1sq - m3sq)*(m1sq - m4sq)**2*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (m1sq*m6sq*B0fin(0,0,m1sq,mudim))/((m1sq - m3sq)*(m1sq - m4sq)**2*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (m1sq*m7sq*B0fin(0,0,m1sq,mudim))/((m1sq - m3sq)*(m1sq - m4sq)**2*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (m6sq*(m6sq - m7sq)*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/((m1sq - m4sq)**2*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (m7sq*(-m6sq + m7sq)*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/((m1sq - m4sq)**2*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (m4sq*m6sq*B0fin(0,0,m4sq,mudim))/((m1sq - m4sq)**2*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (m4sq*m7sq*B0fin(0,0,m4sq,mudim))/((m1sq - m4sq)**2*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (m1sq*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(m1sq - m4sq)**2*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (m6sq*(m6sq - m7sq)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(m1sq - m4sq)**2*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (m4sq*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m4sq)**2*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) - (m6sq*(m6sq - m7sq)*B0fin(0,0,m6sq,mudim))/((m1sq - m4sq)**2*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) - (2*m6sq*m7sq*(-((m1sq - m3sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (m3sq - m4sq)*(4*m6sq*m7sq - (-m4sq + m6sq + m7sq)**2))*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(m1sq - m4sq)**2*(m3sq - m4sq)*(4*m6sq*m7sq - (-m1sq + m6sq + m7sq)**2)*(4*m6sq*m7sq - (-m4sq + m6sq + m7sq)**2)) - (m1sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(m1sq - m4sq)**2*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (m6sq*(m6sq - m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(m1sq - m4sq)**2*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (m4sq*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m4sq)**2*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (m6sq*(m6sq - m7sq)*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m4sq)**2*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (m1sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(m1sq - m4sq)**2*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + ((m6sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(m1sq - m4sq)**2*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (m4sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m4sq)**2*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + ((m6sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m4sq)**2*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) - (2*m6sq*m7sq*(-((m1sq - m3sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (m3sq - m4sq)*(4*m6sq*m7sq - (-m4sq + m6sq + m7sq)**2))*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(m1sq - m4sq)**2*(m3sq - m4sq)*(4*m6sq*m7sq - (-m1sq + m6sq + m7sq)**2)*(4*m6sq*m7sq - (-m4sq + m6sq + m7sq)**2)) - (m1sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(m1sq - m4sq)**2*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (m7sq*(-m6sq + m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(m1sq - m4sq)**2*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (m4sq*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m4sq)**2*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (m7sq*(-m6sq + m7sq)*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m4sq)**2*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (2*m6sq*m7sq*(-((m1sq - m3sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (m3sq - m4sq)*(4*m6sq*m7sq - (-m4sq + m6sq + m7sq)**2))*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(m1sq - m4sq)**2*(m3sq - m4sq)*(4*m6sq*m7sq - (-m1sq + m6sq + m7sq)**2)*(4*m6sq*m7sq - (-m4sq + m6sq + m7sq)**2)) - ((m1sq - m6sq - m7sq)*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)*(m1sq - m4sq)**2*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (m1sq*m4**4*(m4sq + m6sq + m7sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m4sq)**3*(m3sq - m4sq)**2*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (m4**6*(m4sq + m6sq + m7sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m4sq)**3*(m3sq - m4sq)**2*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (m3sq*m4**4*(m4sq + m6sq + m7sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m3sq - m4sq)**2*(-m1sq + m4sq)**3*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (m1sq*m3sq*(m4sq - m6sq - m7sq)*(m4sq + m6sq + m7sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m4sq)**3*(m3sq - m4sq)**2*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) - (m4**4*(m6sq + m7sq)*(m4sq + m6sq + m7sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m4sq)**3*(m3sq - m4sq)**2*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (m1sq*m4sq*(m6sq + m7sq)*(m4sq + m6sq + m7sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m4sq)**3*(m3sq - m4sq)**2*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) - (m3sq*m4sq*(m6sq + m7sq)*(m4sq + m6sq + m7sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m3sq - m4sq)**2*(-m1sq + m4sq)**3*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) - (3*m1sq*T134fin(m7,m6,m1,mudim))/((m1sq - m3sq)**2*(m1sq - m4sq)**3) + (2*m3sq*T134fin(m7,m6,m1,mudim))/((m1sq - m3sq)**2*(m1sq - m4sq)**3) + (m4sq*T134fin(m7,m6,m1,mudim))/((m1sq - m3sq)**2*(m1sq - m4sq)**3) + ((m1sq - m6sq - m7sq)*T134fin(m7,m6,m1,mudim))/((m1sq - m3sq)*(m1sq - m4sq)**2*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + T134fin(m7,m6,m3,mudim)/((m1sq - m3sq)**2*(m3sq - m4sq)**2) + (2*m4**6*T134fin(m7,m6,m4,mudim))/((m1sq - m4sq)**3*(m3sq - m4sq)**2*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (m3sq*m4**4*T134fin(m7,m6,m4,mudim))/((m3sq - m4sq)**2*(-m1sq + m4sq)**3*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) - (m1sq*m3sq*(m4sq - m6sq - m7sq)*T134fin(m7,m6,m4,mudim))/((m1sq - m4sq)**3*(m3sq - m4sq)**2*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) - (m1sq*(m6sq - m7sq)**2*T134fin(m7,m6,m4,mudim))/((m1sq - m4sq)**3*(m3sq - m4sq)**2*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) - (2*m3sq*(m6sq - m7sq)**2*T134fin(m7,m6,m4,mudim))/((m1sq - m4sq)**3*(m3sq - m4sq)**2*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (3*m4sq*(m6sq - m7sq)**2*T134fin(m7,m6,m4,mudim))/((m1sq - m4sq)**3*(m3sq - m4sq)**2*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) - (5*m4**4*(m6sq + m7sq)*T134fin(m7,m6,m4,mudim))/((m1sq - m4sq)**3*(m3sq - m4sq)**2*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (m1sq*m4sq*(m6sq + m7sq)*T134fin(m7,m6,m4,mudim))/((m1sq - m4sq)**3*(m3sq - m4sq)**2*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (3*m3sq*m4sq*(m6sq + m7sq)*T134fin(m7,m6,m4,mudim))/((m1sq - m4sq)**3*(m3sq - m4sq)**2*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq)))
		def eval_72():
			return -((m1sq*m6sq*B0del(0,0,m1sq,mudim))/((m1sq - m3sq)**2*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)))) - (m1sq*m7sq*B0del(0,0,m1sq,mudim))/((m1sq - m3sq)**2*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (m3sq*m6sq*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)**2*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) - (m3sq*m7sq*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)**2*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) - (m1sq*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (m6sq*(m6sq - m7sq)*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (m3sq*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + (m6sq*(m6sq - m7sq)*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + (2*m6sq*m7sq*(-(1/((m1sq - m5sq)*(4*m6sq*m7sq - (-m1sq + m6sq + m7sq)**2))) - 1/((m3sq - m5sq)*(4*m6sq*m7sq - (-m3sq + m6sq + m7sq)**2)))*B0del(0,0,m6sq,mudim))/(m1sq - m3sq)**2 - (m1sq*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (m7sq*(-m6sq + m7sq)*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (m3sq*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + (m7sq*(-m6sq + m7sq)*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + (2*m6sq*m7sq*(-(1/((m1sq - m5sq)*(4*m6sq*m7sq - (-m1sq + m6sq + m7sq)**2))) - 1/((m3sq - m5sq)*(4*m6sq*m7sq - (-m3sq + m6sq + m7sq)**2)))*B0del(0,0,m7sq,mudim))/(m1sq - m3sq)**2 + (m6sq*(m6sq - m7sq)*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/((m1sq - m3sq)**2*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (m7sq*(-m6sq + m7sq)*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/((m1sq - m3sq)**2*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (m1sq*m6sq*B0fin(0,0,m1sq,mudim))/((m1sq - m3sq)**2*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (m1sq*m7sq*B0fin(0,0,m1sq,mudim))/((m1sq - m3sq)**2*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (m6sq*(m6sq - m7sq)*(B0del(0,0,m3sq,mudim) - B0fin(0,0,m3sq,mudim)))/((m1sq - m3sq)**2*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + (m7sq*(-m6sq + m7sq)*(B0del(0,0,m3sq,mudim) - B0fin(0,0,m3sq,mudim)))/((m1sq - m3sq)**2*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + (m3sq*m6sq*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)**2*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + (m3sq*m7sq*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)**2*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + (m1sq*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (m6sq*(m6sq - m7sq)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (m3sq*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) - (m6sq*(m6sq - m7sq)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + (2*m6sq*m7sq*(1/((m1sq - m5sq)*(4*m6sq*m7sq - (-m1sq + m6sq + m7sq)**2)) + 1/((m3sq - m5sq)*(4*m6sq*m7sq - (-m3sq + m6sq + m7sq)**2)))*B0fin(0,0,m6sq,mudim))/(m1sq - m3sq)**2 - (m1sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (m6sq*(m6sq - m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (m3sq*m6sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + (m6sq*(m6sq - m7sq)*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + (m1sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + ((m6sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (m3sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + ((m6sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + (2*m6sq*m7sq*(1/((m1sq - m5sq)*(4*m6sq*m7sq - (-m1sq + m6sq + m7sq)**2)) + 1/((m3sq - m5sq)*(4*m6sq*m7sq - (-m3sq + m6sq + m7sq)**2)))*B0fin(0,0,m7sq,mudim))/(m1sq - m3sq)**2 - (m1sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (m7sq*(-m6sq + m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (m3sq*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + (m7sq*(-m6sq + m7sq)*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + (2*m6sq*m7sq*(-(1/((m1sq - m5sq)*(4*m6sq*m7sq - (-m1sq + m6sq + m7sq)**2))) - 1/((m3sq - m5sq)*(4*m6sq*m7sq - (-m3sq + m6sq + m7sq)**2)))*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/(m1sq - m3sq)**2 - ((m1sq - m6sq - m7sq)*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)**2*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - ((m3sq - m6sq - m7sq)*(m3sq + m6sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)**2*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) - (3*m1sq*T134fin(m7,m6,m1,mudim))/((m1sq - m3sq)**3*(m1sq - m5sq)**2) + (m3sq*T134fin(m7,m6,m1,mudim))/((m1sq - m3sq)**3*(m1sq - m5sq)**2) + (2*m5sq*T134fin(m7,m6,m1,mudim))/((m1sq - m3sq)**3*(m1sq - m5sq)**2) + ((m1sq - m6sq - m7sq)*T134fin(m7,m6,m1,mudim))/((m1sq - m3sq)**2*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (m1sq*T134fin(m7,m6,m3,mudim))/((m1sq - m3sq)**3*(m3sq - m5sq)**2) + (m3sq*T134fin(m7,m6,m3,mudim))/((m1sq - m3sq)**3*(m3sq - m5sq)**2) + (2*T134fin(m7,m6,m3,mudim))/((m1sq - m3sq)**3*(m3sq - m5sq)) + ((m3sq - m6sq - m7sq)*T134fin(m7,m6,m3,mudim))/((m1sq - m3sq)**2*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + T134fin(m7,m6,m5,mudim)/((m1sq - m5sq)**2*(m3sq - m5sq)**2)
		def eval_73():
			return ((7*m1sq*m6**4)/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (3*m1**4*m6sq)/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (7*m1sq*m7**4)/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (5*m6**4*(m6sq - m7sq))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (5*m7**4*(m6sq - m7sq))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (m6sq*(m6sq - m7sq)**3)/(m1**2*(m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (3*m1**4*m7sq)/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*m1sq*m6sq*m7sq)/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (m7sq*(-m6sq + m7sq)**3)/(m1**2*(m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (4*m6sq*m7sq*(-m1sq + m6sq + m7sq))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*m1**4*(m1sq + m6sq + m7sq))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*m6**4*(m1sq + m6sq + m7sq))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*m7**4*(m1sq + m6sq + m7sq))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (4*m6sq*m7sq*(m1sq + m6sq + m7sq))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (4*m1sq*(m6sq + m7sq)*(m1sq + m6sq + m7sq))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (4*m1sq*m6sq*m7sq*B0del(0,0,m1sq,mudim))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (2*m1sq*(2*m1sq - m4sq - m5sq)*m6sq*B0del(0,0,m1sq,mudim))/((m1sq - m4sq)**2*(m1sq - m5sq)**2*(4*m6sq*m7sq - (-m1sq + m6sq + m7sq)**2)) - (2*m1sq*(2*m1sq - m4sq - m5sq)*m7sq*B0del(0,0,m1sq,mudim))/((m1sq - m4sq)**2*(m1sq - m5sq)**2*(4*m6sq*m7sq - (-m1sq + m6sq + m7sq)**2)) + (2*m1sq*m6sq*m7sq*B0del(0,0,m6sq,mudim))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*m6sq*(m6sq - m7sq)*m7sq*B0del(0,0,m6sq,mudim))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*m6sq*m7sq*(-m1sq + m6sq + m7sq)*B0del(0,0,m6sq,mudim))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (2*(2*m1sq - m4sq - m5sq)*m6sq*(m6sq - m7sq)*B0del(0,0,m6sq,mudim))/((m1sq - m4sq)**2*(m1sq - m5sq)**2*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (2*m1sq*(2*m1sq - m4sq - m5sq)*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m4sq)**2*(m1sq - m5sq)**2*(4*m6sq*m7sq - (-m1sq + m6sq + m7sq)**2)) + (4*(2*m1sq - m4sq - m5sq)*m6sq*m7sq*B0del(0,0,m6sq,mudim))/((m1sq - m4sq)**2*(m1sq - m5sq)**2*(4*m6sq*m7sq - (-m1sq + m6sq + m7sq)**2)) + (2*m1sq*m6sq*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (2*m6sq*(m6sq - m7sq)*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*m6sq*m7sq*(-m1sq + m6sq + m7sq)*B0del(0,0,m7sq,mudim))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*(2*m1sq - m4sq - m5sq)*(m6sq - m7sq)*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m4sq)**2*(m1sq - m5sq)**2*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (2*m1sq*(2*m1sq - m4sq - m5sq)*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m4sq)**2*(m1sq - m5sq)**2*(4*m6sq*m7sq - (-m1sq + m6sq + m7sq)**2)) + (4*(2*m1sq - m4sq - m5sq)*m6sq*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m4sq)**2*(m1sq - m5sq)**2*(4*m6sq*m7sq - (-m1sq + m6sq + m7sq)**2)) - (2*(2*m1sq - m4sq - m5sq)*m6sq*(m6sq - m7sq)*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/((m1sq - m4sq)**2*(m1sq - m5sq)**2*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (2*(2*m1sq - m4sq - m5sq)*(m6sq - m7sq)*m7sq*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/((m1sq - m4sq)**2*(m1sq - m5sq)**2*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (7*m1sq*m6**4*B0fin(0,0,m1sq,mudim))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (3*m1**4*m6sq*B0fin(0,0,m1sq,mudim))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (7*m1sq*m7**4*B0fin(0,0,m1sq,mudim))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (5*m6**4*(m6sq - m7sq)*B0fin(0,0,m1sq,mudim))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (m6sq*(m6sq - m7sq)**3*B0fin(0,0,m1sq,mudim))/(m1**2*(m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (3*m1**4*m7sq*B0fin(0,0,m1sq,mudim))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (6*m1sq*m6sq*m7sq*B0fin(0,0,m1sq,mudim))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + ((m6sq - m7sq)**3*m7sq*B0fin(0,0,m1sq,mudim))/(m1**2*(m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (5*m7**4*(-m6sq + m7sq)*B0fin(0,0,m1sq,mudim))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*m1sq*(2*m1sq - m4sq - m5sq)*m6sq*B0fin(0,0,m1sq,mudim))/((m1sq - m4sq)**2*(m1sq - m5sq)**2*(4*m6sq*m7sq - (-m1sq + m6sq + m7sq)**2)) + (2*m1sq*(2*m1sq - m4sq - m5sq)*m7sq*B0fin(0,0,m1sq,mudim))/((m1sq - m4sq)**2*(m1sq - m5sq)**2*(4*m6sq*m7sq - (-m1sq + m6sq + m7sq)**2)) - (7*m1sq*m6**4*B0fin(0,0,m6sq,mudim))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (3*m1**4*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (5*m6**4*(m6sq - m7sq)*B0fin(0,0,m6sq,mudim))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (m6sq*(m6sq - m7sq)**3*B0fin(0,0,m6sq,mudim))/(m1**2*(m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (3*m1sq*m6sq*m7sq*B0fin(0,0,m6sq,mudim))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m6sq,mudim))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*m6sq*m7sq*(-m1sq + m6sq + m7sq)*B0fin(0,0,m6sq,mudim))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*(2*m1sq - m4sq - m5sq)*m6sq*(m6sq - m7sq)*B0fin(0,0,m6sq,mudim))/((m1sq - m4sq)**2*(m1sq - m5sq)**2*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (2*m1sq*(2*m1sq - m4sq - m5sq)*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m4sq)**2*(m1sq - m5sq)**2*(4*m6sq*m7sq - (-m1sq + m6sq + m7sq)**2)) - (4*(2*m1sq - m4sq - m5sq)*m6sq*m7sq*B0fin(0,0,m6sq,mudim))/((m1sq - m4sq)**2*(m1sq - m5sq)**2*(4*m6sq*m7sq - (-m1sq + m6sq + m7sq)**2)) + (2*m1sq*m6sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (2*(2*m1sq - m4sq - m5sq)*m6sq*(m6sq - m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m4sq)**2*(m1sq - m5sq)**2*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (2*m1sq*(2*m1sq - m4sq - m5sq)*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m4sq)**2*(m1sq - m5sq)**2*(4*m6sq*m7sq - (-m1sq + m6sq + m7sq)**2)) - (7*m1sq*m7**4*B0fin(0,0,m7sq,mudim))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (3*m1**4*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (3*m1sq*m6sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + ((m6sq - m7sq)**3*m7sq*B0fin(0,0,m7sq,mudim))/(m1**2*(m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (5*m7**4*(-m6sq + m7sq)*B0fin(0,0,m7sq,mudim))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*m6sq*m7sq*(-m1sq + m6sq + m7sq)*B0fin(0,0,m7sq,mudim))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*(2*m1sq - m4sq - m5sq)*m7sq*(-m6sq + m7sq)*B0fin(0,0,m7sq,mudim))/((m1sq - m4sq)**2*(m1sq - m5sq)**2*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (2*m1sq*(2*m1sq - m4sq - m5sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m4sq)**2*(m1sq - m5sq)**2*(4*m6sq*m7sq - (-m1sq + m6sq + m7sq)**2)) - (4*(2*m1sq - m4sq - m5sq)*m6sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m4sq)**2*(m1sq - m5sq)**2*(4*m6sq*m7sq - (-m1sq + m6sq + m7sq)**2)) + (2*m1sq*m6sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (2*m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*(2*m1sq - m4sq - m5sq)*(m6sq - m7sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m4sq)**2*(m1sq - m5sq)**2*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (2*m1sq*(2*m1sq - m4sq - m5sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m4sq)**2*(m1sq - m5sq)**2*(4*m6sq*m7sq - (-m1sq + m6sq + m7sq)**2)) + (2*m6sq*m7sq*(-m1sq + m6sq + m7sq)*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (4*(2*m1sq - m4sq - m5sq)*m6sq*m7sq*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m4sq)**2*(m1sq - m5sq)**2*(4*m6sq*m7sq - (-m1sq + m6sq + m7sq)**2)) - (m1**4*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (m6**4*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (m7**4*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*m6sq*m7sq*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*m1sq*(m6sq + m7sq)*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*(2*m1sq - m4sq - m5sq)*(m1sq - m6sq - m7sq)*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m4sq)**2*(m1sq - m5sq)**2*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (2*T134fin(m7,m6,m1,mudim))/((m1sq - m4sq)*(m1sq - m5sq)**3) + (2*T134fin(m7,m6,m1,mudim))/((m1sq - m4sq)**2*(m1sq - m5sq)**2) + (2*T134fin(m7,m6,m1,mudim))/((m1sq - m4sq)**3*(m1sq - m5sq)) - (4*m6sq*m7sq*T134fin(m7,m6,m1,mudim))/((m1sq - m4sq)*(m1sq - m5sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (2*(2*m1sq - m4sq - m5sq)*(m1sq - m6sq - m7sq)*T134fin(m7,m6,m1,mudim))/((m1sq - m4sq)**2*(m1sq - m5sq)**2*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (2*T134fin(m7,m6,m4,mudim))/((m1sq - m4sq)**3*(m4sq - m5sq)) - (2*T134fin(m7,m6,m5,mudim))/((m1sq - m5sq)**3*(-m4sq + m5sq)))/2.
		def eval_74():
			return (m4sq*m6sq*B0del(0,0,m4sq,mudim))/((m1sq - m4sq)*(-m2sq + m4sq)*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (m4sq*m7sq*B0del(0,0,m4sq,mudim))/((m1sq - m4sq)*(-m2sq + m4sq)*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (m4sq*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m4sq)*(-m2sq + m4sq)*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) - (m6sq*(m6sq - m7sq)*B0del(0,0,m6sq,mudim))/((m1sq - m4sq)*(-m2sq + m4sq)*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) - (2*m6sq*m7sq*B0del(0,0,m6sq,mudim))/((m1sq - m4sq)*(-m2sq + m4sq)*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (m4sq*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m4sq)*(-m2sq + m4sq)*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) - (2*m6sq*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m4sq)*(-m2sq + m4sq)*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + ((m6sq - m7sq)*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m4sq)*(-m2sq + m4sq)*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) - (m6sq*(m6sq - m7sq)*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/((m1sq - m4sq)*(-m2sq + m4sq)*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + ((m6sq - m7sq)*m7sq*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/((m1sq - m4sq)*(-m2sq + m4sq)*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) - (m4sq*m6sq*B0fin(0,0,m4sq,mudim))/((m1sq - m4sq)*(-m2sq + m4sq)*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) - (m4sq*m7sq*B0fin(0,0,m4sq,mudim))/((m1sq - m4sq)*(-m2sq + m4sq)*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) - (m4sq*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m4sq)*(-m2sq + m4sq)*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (m6sq*(m6sq - m7sq)*B0fin(0,0,m6sq,mudim))/((m1sq - m4sq)*(-m2sq + m4sq)*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (2*m6sq*m7sq*B0fin(0,0,m6sq,mudim))/((m1sq - m4sq)*(-m2sq + m4sq)*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (m4sq*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m4sq)*(-m2sq + m4sq)*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) - (m6sq*(m6sq - m7sq)*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m4sq)*(-m2sq + m4sq)*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) - (m4sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m4sq)*(-m2sq + m4sq)*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (2*m6sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m4sq)*(-m2sq + m4sq)*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (m7sq*(-m6sq + m7sq)*B0fin(0,0,m7sq,mudim))/((m1sq - m4sq)*(-m2sq + m4sq)*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + (m4sq*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m4sq)*(-m2sq + m4sq)*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + ((m6sq - m7sq)*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m4sq)*(-m2sq + m4sq)*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) - (2*m6sq*m7sq*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m4sq)*(-m2sq + m4sq)*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + ((m4sq - m6sq - m7sq)*(m4sq + m6sq + m7sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m4sq)*(-m2sq + m4sq)*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq))) + T134fin(m7,m6,m1,mudim)/((m1sq - m2sq)*(m1sq - m3sq)*(m1sq - m4sq)**2) - T134fin(m7,m6,m2,mudim)/((m1sq - m2sq)*(m2sq - m3sq)*(m2sq - m4sq)**2) - T134fin(m7,m6,m3,mudim)/((m1sq - m3sq)*(-m2sq + m3sq)*(m3sq - m4sq)**2) - T134fin(m7,m6,m4,mudim)/((m1sq - m2sq)*(m1sq - m3sq)*(m1sq - m4sq)**2) + T134fin(m7,m6,m4,mudim)/((m1sq - m2sq)*(m2sq - m3sq)*(m2sq - m4sq)**2) + T134fin(m7,m6,m4,mudim)/((m1sq - m2sq)*(m1sq - m3sq)*(m3sq - m4sq)**2) - T134fin(m7,m6,m4,mudim)/((m1sq - m2sq)*(m2sq - m3sq)*(m3sq - m4sq)**2) - ((m4sq - m6sq - m7sq)*T134fin(m7,m6,m4,mudim))/((m1sq - m4sq)*(-m2sq + m4sq)*(-m3sq + m4sq)*(m4**4 + (m6sq - m7sq)**2 - 2*m4sq*(m6sq + m7sq)))
		def eval_75():
			return (m3sq*m6sq*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + (m3sq*m7sq*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + (m3sq*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) - (m6sq*(m6sq - m7sq)*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) - (2*m6sq*m7sq*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + (m3sq*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) - (2*m6sq*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + ((m6sq - m7sq)*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) - (m6sq*(m6sq - m7sq)*(B0del(0,0,m3sq,mudim) - B0fin(0,0,m3sq,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + ((m6sq - m7sq)*m7sq*(B0del(0,0,m3sq,mudim) - B0fin(0,0,m3sq,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) - (m3sq*m6sq*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) - (m3sq*m7sq*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) - (m3sq*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + (m6sq*(m6sq - m7sq)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + (2*m6sq*m7sq*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + (m3sq*m6sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) - (m6sq*(m6sq - m7sq)*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) - (m3sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + (2*m6sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + (m7sq*(-m6sq + m7sq)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + (m3sq*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + ((m6sq - m7sq)*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) - (2*m6sq*m7sq*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + ((m3sq - m6sq - m7sq)*(m3sq + m6sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) + T134fin(m7,m6,m1,mudim)/((m1sq - m2sq)*(m1sq - m3sq)**2*(m1sq - m5sq)) - T134fin(m7,m6,m2,mudim)/((m1sq - m2sq)*(m2sq - m3sq)**2*(m2sq - m5sq)) + T134fin(m7,m6,m3,mudim)/((m1sq - m2sq)*(m1sq - m3sq)*(m3sq - m5sq)**2) - T134fin(m7,m6,m3,mudim)/((m1sq - m2sq)*(m2sq - m3sq)*(m3sq - m5sq)**2) - T134fin(m7,m6,m3,mudim)/((m1sq - m2sq)*(m1sq - m3sq)**2*(m3sq - m5sq)) + T134fin(m7,m6,m3,mudim)/((m1sq - m2sq)*(m2sq - m3sq)**2*(m3sq - m5sq)) - ((m3sq - m6sq - m7sq)*T134fin(m7,m6,m3,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3sq - m5sq)*(m3**4 + (m6sq - m7sq)**2 - 2*m3sq*(m6sq + m7sq))) - T134fin(m7,m6,m5,mudim)/((m1sq - m5sq)*(m3sq - m5sq)**2*(-m2sq + m5sq))
		def eval_76():
			return (m2sq*m6sq*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2sq - m5sq)*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + (m2sq*m7sq*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2sq - m5sq)*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + (m2sq*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2sq - m5sq)*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) - (m6sq*(m6sq - m7sq)*B0del(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2sq - m5sq)*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) - (2*m6sq*m7sq*B0del(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2sq - m5sq)*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + (m2sq*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2sq - m5sq)*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) - (2*m6sq*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2sq - m5sq)*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + ((m6sq - m7sq)*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2sq - m5sq)*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) - (m6sq*(m6sq - m7sq)*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)))/((m1sq - m2sq)*(m2sq - m4sq)*(m2sq - m5sq)*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + ((m6sq - m7sq)*m7sq*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)))/((m1sq - m2sq)*(m2sq - m4sq)*(m2sq - m5sq)*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) - (m2sq*m6sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2sq - m5sq)*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) - (m2sq*m7sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2sq - m5sq)*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) - (m2sq*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2sq - m5sq)*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + (m6sq*(m6sq - m7sq)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2sq - m5sq)*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + (2*m6sq*m7sq*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2sq - m5sq)*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + (m2sq*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2sq - m5sq)*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) - (m6sq*(m6sq - m7sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2sq - m5sq)*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) - (m2sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2sq - m5sq)*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + (2*m6sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2sq - m5sq)*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + (m7sq*(-m6sq + m7sq)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2sq - m5sq)*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + (m2sq*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2sq - m5sq)*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + ((m6sq - m7sq)*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2sq - m5sq)*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) - (2*m6sq*m7sq*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2sq - m5sq)*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + ((m2sq - m6sq - m7sq)*(m2sq + m6sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)*(m2sq - m4sq)*(m2sq - m5sq)*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + T134fin(m7,m6,m1,mudim)/((m1sq - m2sq)**2*(m1sq - m4sq)*(m1sq - m5sq)) + T134fin(m7,m6,m2,mudim)/((m1sq - m2sq)*(m2sq - m4sq)*(m2sq - m5sq)**2) + T134fin(m7,m6,m2,mudim)/((m1sq - m2sq)*(m2sq - m4sq)**2*(m2sq - m5sq)) - T134fin(m7,m6,m2,mudim)/((m1sq - m2sq)**2*(m2sq - m4sq)*(m2sq - m5sq)) + ((m2sq - m6sq - m7sq)*T134fin(m7,m6,m2,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2sq - m5sq)*(4*m6sq*m7sq - (-m2sq + m6sq + m7sq)**2)) - T134fin(m7,m6,m4,mudim)/((m1sq - m4sq)*(m2sq - m4sq)**2*(m4sq - m5sq)) - T134fin(m7,m6,m5,mudim)/((m1sq - m5sq)*(m2sq - m5sq)**2*(-m4sq + m5sq))
		def eval_77():
			return -((m1sq*m6sq*B0del(0,0,m1sq,mudim))/((m1sq - m3sq)*(m1sq - m4sq)*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)))) - (m1sq*m7sq*B0del(0,0,m1sq,mudim))/((m1sq - m3sq)*(m1sq - m4sq)*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (m1sq*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)*(m1sq - m4sq)*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (m6sq*(m6sq - m7sq)*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)*(m1sq - m4sq)*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (2*m6sq*m7sq*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)*(m1sq - m4sq)*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (m1sq*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)*(m1sq - m4sq)*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (2*m6sq*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)*(m1sq - m4sq)*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (m7sq*(-m6sq + m7sq)*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)*(m1sq - m4sq)*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (m6sq*(m6sq - m7sq)*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/((m1sq - m3sq)*(m1sq - m4sq)*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (m7sq*(-m6sq + m7sq)*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/((m1sq - m3sq)*(m1sq - m4sq)*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (m1sq*m6sq*B0fin(0,0,m1sq,mudim))/((m1sq - m3sq)*(m1sq - m4sq)*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (m1sq*m7sq*B0fin(0,0,m1sq,mudim))/((m1sq - m3sq)*(m1sq - m4sq)*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (m1sq*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(m1sq - m4sq)*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (m6sq*(m6sq - m7sq)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(m1sq - m4sq)*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (2*m6sq*m7sq*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(m1sq - m4sq)*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (m1sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(m1sq - m4sq)*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (m6sq*(m6sq - m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(m1sq - m4sq)*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (m1sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(m1sq - m4sq)*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (2*m6sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(m1sq - m4sq)*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + ((m6sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(m1sq - m4sq)*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (m1sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(m1sq - m4sq)*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (m7sq*(-m6sq + m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(m1sq - m4sq)*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (2*m6sq*m7sq*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(m1sq - m4sq)*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - ((m1sq - m6sq - m7sq)*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)*(m1sq - m4sq)*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - T134fin(m7,m6,m1,mudim)/((m1sq - m3sq)*(m1sq - m4sq)*(m1sq - m5sq)**2) - T134fin(m7,m6,m1,mudim)/((m1sq - m3sq)*(m1sq - m4sq)**2*(m1sq - m5sq)) - T134fin(m7,m6,m1,mudim)/((m1sq - m3sq)**2*(m1sq - m4sq)*(m1sq - m5sq)) + ((m1sq - m6sq - m7sq)*T134fin(m7,m6,m1,mudim))/((m1sq - m3sq)*(m1sq - m4sq)*(m1sq - m5sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + T134fin(m7,m6,m3,mudim)/((m1sq - m3sq)**2*(m3sq - m4sq)*(m3sq - m5sq)) + T134fin(m7,m6,m4,mudim)/((m1sq - m4sq)**2*(-m3sq + m4sq)*(m4sq - m5sq)) + T134fin(m7,m6,m5,mudim)/((m1sq - m5sq)**2*(-m3sq + m5sq)*(-m4sq + m5sq))
		def eval_78():
			return T134fin(m7,m6,m1,mudim)/((m1sq - m2sq)*(m1sq - m3sq)*(m1sq - m4sq)*(m1sq - m5sq)) - T134fin(m7,m6,m2,mudim)/((m1sq - m2sq)*(m2sq - m3sq)*(m2sq - m4sq)*(m2sq - m5sq)) - T134fin(m7,m6,m3,mudim)/((m1sq - m3sq)*(-m2sq + m3sq)*(m3sq - m4sq)*(m3sq - m5sq)) - T134fin(m7,m6,m4,mudim)/((m1sq - m4sq)*(-m2sq + m4sq)*(-m3sq + m4sq)*(m4sq - m5sq)) - T134fin(m7,m6,m5,mudim)/((m1sq - m5sq)*(-m2sq + m5sq)*(-m3sq + m5sq)*(-m4sq + m5sq))

		cond_m1_0 = cond(m1, 0)
		cond_m2_0 = cond(m2, 0)
		cond_m3_0 = cond(m3, 0)
		cond_m4_0 = cond(m4, 0)
		cond_m5_0 = cond(m5, 0)
		cond_m6_0 = cond(m6, 0)
		cond_m7_0 = cond(m7, 0)
		cond_m7_m6 = cond(m7, m6)
		cond_m7_m5 = cond(m7, m5)
		cond_m6_m5 = cond(m6, m5)
		cond_m7_m4 = cond(m7, m4)
		cond_m6_m4 = cond(m6, m4)
		cond_m5_m4 = cond(m5, m4)
		cond_m7_m3 = cond(m7, m3)
		cond_m6_m3 = cond(m6, m3)
		cond_m5_m3 = cond(m5, m3)
		cond_m4_m3 = cond(m4, m3)
		cond_m7_m2 = cond(m7, m2)
		cond_m6_m2 = cond(m6, m2)
		cond_m5_m2 = cond(m5, m2)
		cond_m4_m2 = cond(m4, m2)
		cond_m3_m2 = cond(m3, m2)
		cond_m7_m1 = cond(m7, m1)
		cond_m6_m1 = cond(m6, m1)
		cond_m5_m1 = cond(m5, m1)
		cond_m4_m1 = cond(m4, m1)
		cond_m3_m1 = cond(m3, m1)
		cond_m2_m1 = cond(m2, m1)

		conditions = [
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_1()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_5()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_5()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_2()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_2()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_2()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_2()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_2()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_m6, lambda: eval_3()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_m5, lambda: eval_13()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_m5 and cond_m7_0, lambda: eval_13()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_m4, lambda: eval_13()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_m4 and cond_m7_0, lambda: eval_13()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_0 and cond_m7_0, lambda: eval_4()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_13()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_13()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_4()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_4()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_13()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_13()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_4()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_4()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_4()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_13()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_13()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_4()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_4()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_4()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_4()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0, lambda: eval_5()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_0, lambda: eval_13()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m7_0, lambda: eval_13()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_0, lambda: eval_13()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m7_0, lambda: eval_13()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m6_0 and cond_m7_0, lambda: eval_6()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_13()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_13()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_6()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_6()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_13()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_13()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_6()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_6()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_6()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_13()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_13()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_6()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_6()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_6()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_6()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_10()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_10()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m4, lambda: eval_7()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_0, lambda: eval_8()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_10()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_7()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_8()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_7()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_8()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_9()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_10()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_7()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_8()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_7()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_8()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_9()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_7()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_8()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_9()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_9()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_10()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_7()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_8()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_7()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_8()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_9()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_7()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_8()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_9()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_9()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_7()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_8()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_9()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_9()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_9()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m7_m6, lambda: eval_10()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m7_m6, lambda: eval_10()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m6_0 and cond_m7_m5, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m6_m5 and cond_m7_0, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m7_m6, lambda: eval_10()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m6_0 and cond_m7_m5, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m6_m5 and cond_m7_0, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m6_0 and cond_m7_m4, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m6_m4 and cond_m7_0, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m6_0 and cond_m7_0, lambda: eval_11()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_m6, lambda: eval_10()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_m5, lambda: eval_18()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m6_m5 and cond_m7_0, lambda: eval_18()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_m4, lambda: eval_18()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m6_m4 and cond_m7_0, lambda: eval_18()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m6_0 and cond_m7_0, lambda: eval_11()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_18()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_18()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_11()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_11()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_m5, lambda: eval_13()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m7_m5, lambda: eval_13()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_m4, lambda: eval_13()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m7_m4, lambda: eval_13()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_0, lambda: eval_17()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m7_0, lambda: eval_17()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m6_0 and cond_m7_m4, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m6_m4 and cond_m7_0, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_m3, lambda: eval_13()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m7_m3, lambda: eval_13()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_0, lambda: eval_17()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m7_0, lambda: eval_17()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m6_0 and cond_m7_m3, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m6_m3 and cond_m7_0, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_0, lambda: eval_17()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m7_0, lambda: eval_17()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m6_0 and cond_m7_0, lambda: eval_12()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_12()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m2, lambda: eval_13()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_m2, lambda: eval_13()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_0, lambda: eval_17()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m7_0, lambda: eval_17()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_m2, lambda: eval_18()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m6_m2 and cond_m7_0, lambda: eval_18()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_0, lambda: eval_17()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m7_0, lambda: eval_17()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m6_0 and cond_m7_0, lambda: eval_12()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_18()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_18()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_12()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_17()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_17()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_12()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_12()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_18()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_18()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_12()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_12()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_m6, lambda: eval_10()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_m5, lambda: eval_18()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_m5 and cond_m7_0, lambda: eval_18()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_m4, lambda: eval_18()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_m4 and cond_m7_0, lambda: eval_18()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_0 and cond_m7_0, lambda: eval_11()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_18()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_18()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_11()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_11()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_18()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_18()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_11()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_11()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_11()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_13()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_m1, lambda: eval_13()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_17()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m7_0, lambda: eval_17()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_m1, lambda: eval_18()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_m1 and cond_m7_0, lambda: eval_18()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_17()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m7_0, lambda: eval_17()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m6_0 and cond_m7_0, lambda: eval_12()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_18()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_18()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_12()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_17()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_17()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_12()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_12()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_18()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_18()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_12()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_12()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_17()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_17()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_12()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_12()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_12()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_18()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_18()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_12()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_12()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_12()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0, lambda: eval_13()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_0, lambda: eval_13()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m6_0, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m7_0, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_0, lambda: eval_13()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m6_0, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m7_0, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m6_0, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m7_0, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m6_0 and cond_m7_0, lambda: eval_14()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_0, lambda: eval_13()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m6_0, lambda: eval_18()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m7_0, lambda: eval_18()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m6_0, lambda: eval_18()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m7_0, lambda: eval_18()),
			(cond_m1_0 and cond_m3_0 and cond_m6_0 and cond_m7_0, lambda: eval_14()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_18()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_18()),
			(cond_m1_0 and cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_14()),
			(cond_m1_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_14()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0, lambda: eval_13()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_0, lambda: eval_18()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m7_0, lambda: eval_18()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_0, lambda: eval_18()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m7_0, lambda: eval_18()),
			(cond_m2_0 and cond_m3_0 and cond_m6_0 and cond_m7_0, lambda: eval_14()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_18()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_18()),
			(cond_m2_0 and cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_14()),
			(cond_m2_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_14()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_18()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_18()),
			(cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_14()),
			(cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_14()),
			(cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_14()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m4, lambda: eval_15()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_15()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_15()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_27()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_28()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_15()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_15()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_27()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_28()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_15()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_27()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_28()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_27()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_28()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_64()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_15()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_15()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_27()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_28()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_15()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_27()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_28()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_27()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_28()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_64()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_15()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_27()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_28()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_27()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_28()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_64()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_27()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_28()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_64()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_64()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_16()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_16()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_16()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m4, lambda: eval_45()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_0, lambda: eval_46()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_16()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_16()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m4, lambda: eval_45()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_0, lambda: eval_46()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_16()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_45()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_46()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_45()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_46()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_68()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m7_m6, lambda: eval_15()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m6_m4 and cond_m7_m5, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m6_m5 and cond_m7_m4, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m7_m6, lambda: eval_15()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m6_m3 and cond_m7_m5, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m3, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m7_m6, lambda: eval_15()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m6_0 and cond_m7_m5, lambda: eval_72()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m6_m5 and cond_m7_0, lambda: eval_72()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m4, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m3, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m4, lambda: eval_72()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m6_m4 and cond_m7_0, lambda: eval_72()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m3, lambda: eval_71()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m6_m3 and cond_m7_0, lambda: eval_71()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m7_m6, lambda: eval_15()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m6_m2 and cond_m7_m5, lambda: eval_18()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m2, lambda: eval_18()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m7_m6, lambda: eval_15()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m6_0 and cond_m7_m5, lambda: eval_72()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m6_m5 and cond_m7_0, lambda: eval_72()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m4, lambda: eval_18()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m2, lambda: eval_18()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m4, lambda: eval_72()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m6_m4 and cond_m7_0, lambda: eval_72()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m2, lambda: eval_71()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m2 and cond_m7_0, lambda: eval_71()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m7_m6, lambda: eval_15()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m6_0 and cond_m7_m5, lambda: eval_72()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m6_m5 and cond_m7_0, lambda: eval_72()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m4, lambda: eval_72()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m6_m4 and cond_m7_0, lambda: eval_72()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m6_0 and cond_m7_0, lambda: eval_69()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m3, lambda: eval_18()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m2, lambda: eval_18()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m3, lambda: eval_72()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m3 and cond_m7_0, lambda: eval_72()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m2, lambda: eval_71()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m2 and cond_m7_0, lambda: eval_71()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_72()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_72()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_69()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_71()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_71()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_69()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m4, lambda: eval_17()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m7_m4, lambda: eval_17()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_16()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m3, lambda: eval_17()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m7_m3, lambda: eval_17()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_16()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m3, lambda: eval_17()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m7_m3, lambda: eval_17()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_0, lambda: eval_65()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m7_0, lambda: eval_65()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_47()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_48()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_16()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_47()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_48()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m2, lambda: eval_17()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m7_m2, lambda: eval_17()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_16()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m2, lambda: eval_17()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m7_m2, lambda: eval_17()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_0, lambda: eval_65()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m7_0, lambda: eval_65()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_47()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_48()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_16()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_47()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_48()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_m2, lambda: eval_17()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m7_m2, lambda: eval_17()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_0, lambda: eval_65()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m7_0, lambda: eval_65()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m6_0 and cond_m7_m2, lambda: eval_47()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m6_m2 and cond_m7_0, lambda: eval_48()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_0, lambda: eval_65()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m7_0, lambda: eval_65()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m6_0 and cond_m7_0, lambda: eval_70()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_47()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_48()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_70()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_16()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_47()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_48()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_47()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_48()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_70()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_16()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_16()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m4, lambda: eval_45()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_0, lambda: eval_46()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_16()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_45()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_46()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_45()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_46()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_68()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_16()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_45()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_46()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_45()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_46()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_68()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_45()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_46()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_68()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_68()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m7_m6, lambda: eval_15()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_m1 and cond_m7_m5, lambda: eval_18()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m1, lambda: eval_18()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m7_m6, lambda: eval_15()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m6_0 and cond_m7_m5, lambda: eval_72()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m6_m5 and cond_m7_0, lambda: eval_72()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m4, lambda: eval_18()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m1, lambda: eval_18()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m4, lambda: eval_72()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m6_m4 and cond_m7_0, lambda: eval_72()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m1, lambda: eval_71()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m1 and cond_m7_0, lambda: eval_71()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m7_m6, lambda: eval_15()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m6_0 and cond_m7_m5, lambda: eval_72()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m6_m5 and cond_m7_0, lambda: eval_72()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m4, lambda: eval_72()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m6_m4 and cond_m7_0, lambda: eval_72()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4 and cond_m6_0 and cond_m7_0, lambda: eval_69()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m3, lambda: eval_18()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m1, lambda: eval_18()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m3, lambda: eval_72()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m3 and cond_m7_0, lambda: eval_72()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m1, lambda: eval_71()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m1 and cond_m7_0, lambda: eval_71()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_72()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_72()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_69()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_71()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_71()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_69()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_m6, lambda: eval_15()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_m5, lambda: eval_72()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m6_m5 and cond_m7_0, lambda: eval_72()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_m4, lambda: eval_72()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m6_m4 and cond_m7_0, lambda: eval_72()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4 and cond_m6_0 and cond_m7_0, lambda: eval_69()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_72()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_72()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_69()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_69()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_18()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_18()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_72()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_72()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_71()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_71()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_72()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_72()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_69()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_71()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_71()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_69()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_72()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_72()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_69()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_69()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_71()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_71()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_69()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_69()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_17()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m7_m1, lambda: eval_17()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_16()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_17()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m7_m1, lambda: eval_17()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_65()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m7_0, lambda: eval_65()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_47()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_48()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_16()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_47()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_48()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_17()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m7_m1, lambda: eval_17()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_65()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m7_0, lambda: eval_65()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m6_0 and cond_m7_m1, lambda: eval_47()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m6_m1 and cond_m7_0, lambda: eval_48()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_65()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m7_0, lambda: eval_65()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m6_0 and cond_m7_0, lambda: eval_70()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_47()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_48()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_70()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_16()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_47()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_48()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_47()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_48()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_17()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_m1, lambda: eval_17()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_65()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m7_0, lambda: eval_65()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_m1, lambda: eval_47()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m6_m1 and cond_m7_0, lambda: eval_48()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_65()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m7_0, lambda: eval_65()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m6_0 and cond_m7_0, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_47()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_48()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_65()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_65()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_70()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_47()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_48()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_70()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_70()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_16()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_47()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_48()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_47()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_48()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_70()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_47()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_48()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_70()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_70()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m7_m6, lambda: eval_16()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m7_m6, lambda: eval_16()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m7_m6, lambda: eval_16()),
			(cond_m1_0 and cond_m2_0 and cond_m6_0 and cond_m7_m5, lambda: eval_77()),
			(cond_m1_0 and cond_m2_0 and cond_m6_m5 and cond_m7_0, lambda: eval_77()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m7_m6, lambda: eval_16()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m7_m6, lambda: eval_16()),
			(cond_m1_0 and cond_m3_0 and cond_m6_0 and cond_m7_m5, lambda: eval_77()),
			(cond_m1_0 and cond_m3_0 and cond_m6_m5 and cond_m7_0, lambda: eval_77()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m7_m6, lambda: eval_16()),
			(cond_m1_0 and cond_m4_0 and cond_m6_0 and cond_m7_m5, lambda: eval_77()),
			(cond_m1_0 and cond_m4_0 and cond_m6_m5 and cond_m7_0, lambda: eval_77()),
			(cond_m1_0 and cond_m5_0 and cond_m6_0 and cond_m7_m4, lambda: eval_77()),
			(cond_m1_0 and cond_m5_0 and cond_m6_m4 and cond_m7_0, lambda: eval_77()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_0 and cond_m7_0, lambda: eval_74()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m6_m5, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m7_m5, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m6_m5, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m7_m5, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m6_m4, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m7_m4, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m6_0, lambda: eval_71()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m7_0, lambda: eval_71()),
			(cond_m1_0 and cond_m2_0 and cond_m6_0 and cond_m7_m4, lambda: eval_77()),
			(cond_m1_0 and cond_m2_0 and cond_m6_m4 and cond_m7_0, lambda: eval_77()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m6_m5, lambda: eval_18()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m7_m5, lambda: eval_18()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m6_m4, lambda: eval_18()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m7_m4, lambda: eval_18()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m6_0, lambda: eval_71()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m7_0, lambda: eval_71()),
			(cond_m1_0 and cond_m3_0 and cond_m6_0 and cond_m7_m4, lambda: eval_77()),
			(cond_m1_0 and cond_m3_0 and cond_m6_m4 and cond_m7_0, lambda: eval_77()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m6_m3, lambda: eval_18()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m7_m3, lambda: eval_18()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m6_0, lambda: eval_71()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m7_0, lambda: eval_71()),
			(cond_m1_0 and cond_m4_0 and cond_m6_0 and cond_m7_m3, lambda: eval_77()),
			(cond_m1_0 and cond_m4_0 and cond_m6_m3 and cond_m7_0, lambda: eval_77()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m6_0, lambda: eval_71()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m7_0, lambda: eval_71()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_0 and cond_m7_0, lambda: eval_75()),
			(cond_m1_0 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_77()),
			(cond_m1_0 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_77()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_75()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_m4, lambda: eval_17()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m6_m4, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m7_m4, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_m3, lambda: eval_17()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m6_m3, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m7_m3, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_0, lambda: eval_17()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m6_0, lambda: eval_72()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m7_0, lambda: eval_72()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m6_m3, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m7_m3, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m6_0, lambda: eval_72()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m7_0, lambda: eval_72()),
			(cond_m1_0 and cond_m2_0 and cond_m6_0 and cond_m7_m3, lambda: eval_77()),
			(cond_m1_0 and cond_m2_0 and cond_m6_m3 and cond_m7_0, lambda: eval_77()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_m2, lambda: eval_17()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m6_m2, lambda: eval_18()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m7_m2, lambda: eval_18()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_0, lambda: eval_17()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m6_0, lambda: eval_72()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m7_0, lambda: eval_72()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m6_m2, lambda: eval_18()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m7_m2, lambda: eval_18()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m6_0, lambda: eval_72()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m7_0, lambda: eval_72()),
			(cond_m1_0 and cond_m3_0 and cond_m6_0 and cond_m7_m2, lambda: eval_77()),
			(cond_m1_0 and cond_m3_0 and cond_m6_m2 and cond_m7_0, lambda: eval_77()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_0, lambda: eval_17()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m6_0, lambda: eval_72()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m7_0, lambda: eval_72()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m6_0, lambda: eval_72()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m7_0, lambda: eval_72()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_0 and cond_m7_0, lambda: eval_76()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m6_m2, lambda: eval_18()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m7_m2, lambda: eval_18()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m6_0, lambda: eval_72()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m7_0, lambda: eval_72()),
			(cond_m1_0 and cond_m4_0 and cond_m6_0 and cond_m7_m2, lambda: eval_77()),
			(cond_m1_0 and cond_m4_0 and cond_m6_m2 and cond_m7_0, lambda: eval_77()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m6_0, lambda: eval_72()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m7_0, lambda: eval_72()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_0 and cond_m7_0, lambda: eval_76()),
			(cond_m1_0 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_77()),
			(cond_m1_0 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_77()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_76()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m7_m6, lambda: eval_16()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m7_m6, lambda: eval_16()),
			(cond_m2_0 and cond_m3_0 and cond_m6_0 and cond_m7_m5, lambda: eval_77()),
			(cond_m2_0 and cond_m3_0 and cond_m6_m5 and cond_m7_0, lambda: eval_77()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m7_m6, lambda: eval_16()),
			(cond_m2_0 and cond_m4_0 and cond_m6_0 and cond_m7_m5, lambda: eval_77()),
			(cond_m2_0 and cond_m4_0 and cond_m6_m5 and cond_m7_0, lambda: eval_77()),
			(cond_m2_0 and cond_m5_0 and cond_m6_0 and cond_m7_m4, lambda: eval_77()),
			(cond_m2_0 and cond_m5_0 and cond_m6_m4 and cond_m7_0, lambda: eval_77()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_0 and cond_m7_0, lambda: eval_74()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_m5, lambda: eval_18()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m7_m5, lambda: eval_18()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_m4, lambda: eval_18()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m7_m4, lambda: eval_18()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_0, lambda: eval_71()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m7_0, lambda: eval_71()),
			(cond_m2_0 and cond_m3_0 and cond_m6_0 and cond_m7_m4, lambda: eval_77()),
			(cond_m2_0 and cond_m3_0 and cond_m6_m4 and cond_m7_0, lambda: eval_77()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_m3, lambda: eval_18()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m7_m3, lambda: eval_18()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_0, lambda: eval_71()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m7_0, lambda: eval_71()),
			(cond_m2_0 and cond_m4_0 and cond_m6_0 and cond_m7_m3, lambda: eval_77()),
			(cond_m2_0 and cond_m4_0 and cond_m6_m3 and cond_m7_0, lambda: eval_77()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_0, lambda: eval_71()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m7_0, lambda: eval_71()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_0 and cond_m7_0, lambda: eval_75()),
			(cond_m2_0 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_77()),
			(cond_m2_0 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_77()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_75()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_m6, lambda: eval_16()),
			(cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_m5, lambda: eval_77()),
			(cond_m3_0 and cond_m4_0 and cond_m6_m5 and cond_m7_0, lambda: eval_77()),
			(cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_m4, lambda: eval_77()),
			(cond_m3_0 and cond_m5_0 and cond_m6_m4 and cond_m7_0, lambda: eval_77()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_0 and cond_m7_0, lambda: eval_74()),
			(cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_77()),
			(cond_m4_0 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_77()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_74()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_74()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m2, lambda: eval_18()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_m2, lambda: eval_18()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_0, lambda: eval_71()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m7_0, lambda: eval_71()),
			(cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_m2, lambda: eval_77()),
			(cond_m3_0 and cond_m4_0 and cond_m6_m2 and cond_m7_0, lambda: eval_77()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_0, lambda: eval_71()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m7_0, lambda: eval_71()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_0 and cond_m7_0, lambda: eval_75()),
			(cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_77()),
			(cond_m3_0 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_77()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_75()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_71()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_71()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_75()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_75()),
			(cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_77()),
			(cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_77()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_75()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_75()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_m1, lambda: eval_17()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_m1, lambda: eval_18()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m7_m1, lambda: eval_18()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_0, lambda: eval_17()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m6_0, lambda: eval_72()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m7_0, lambda: eval_72()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_m1, lambda: eval_18()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m7_m1, lambda: eval_18()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m6_0, lambda: eval_72()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m7_0, lambda: eval_72()),
			(cond_m2_0 and cond_m3_0 and cond_m6_0 and cond_m7_m1, lambda: eval_77()),
			(cond_m2_0 and cond_m3_0 and cond_m6_m1 and cond_m7_0, lambda: eval_77()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_0, lambda: eval_17()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m6_0, lambda: eval_72()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m7_0, lambda: eval_72()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m6_0, lambda: eval_72()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m7_0, lambda: eval_72()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_0 and cond_m7_0, lambda: eval_76()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_18()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m7_m1, lambda: eval_18()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_72()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m7_0, lambda: eval_72()),
			(cond_m2_0 and cond_m4_0 and cond_m6_0 and cond_m7_m1, lambda: eval_77()),
			(cond_m2_0 and cond_m4_0 and cond_m6_m1 and cond_m7_0, lambda: eval_77()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_72()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m7_0, lambda: eval_72()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_0 and cond_m7_0, lambda: eval_76()),
			(cond_m2_0 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_77()),
			(cond_m2_0 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_77()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_76()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_0, lambda: eval_17()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m6_0, lambda: eval_72()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m7_0, lambda: eval_72()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m6_0, lambda: eval_72()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m7_0, lambda: eval_72()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_0 and cond_m7_0, lambda: eval_76()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_72()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_72()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_76()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_18()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_m1, lambda: eval_18()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_72()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m7_0, lambda: eval_72()),
			(cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_m1, lambda: eval_77()),
			(cond_m3_0 and cond_m4_0 and cond_m6_m1 and cond_m7_0, lambda: eval_77()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_72()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m7_0, lambda: eval_72()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_0 and cond_m7_0, lambda: eval_76()),
			(cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_77()),
			(cond_m3_0 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_77()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_76()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_72()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_72()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_76()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_76()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_76()),
			(cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_77()),
			(cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_77()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_76()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_76()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m6_0, lambda: eval_77()),
			(cond_m1_0 and cond_m2_0 and cond_m7_0, lambda: eval_77()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0, lambda: eval_18()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0, lambda: eval_18()),
			(cond_m1_0 and cond_m3_0 and cond_m6_0, lambda: eval_77()),
			(cond_m1_0 and cond_m3_0 and cond_m7_0, lambda: eval_77()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0, lambda: eval_18()),
			(cond_m1_0 and cond_m4_0 and cond_m6_0, lambda: eval_77()),
			(cond_m1_0 and cond_m4_0 and cond_m7_0, lambda: eval_77()),
			(cond_m1_0 and cond_m5_0 and cond_m6_0, lambda: eval_77()),
			(cond_m1_0 and cond_m5_0 and cond_m7_0, lambda: eval_77()),
			(cond_m1_0 and cond_m6_0 and cond_m7_0, lambda: eval_78()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0, lambda: eval_18()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0, lambda: eval_18()),
			(cond_m2_0 and cond_m3_0 and cond_m6_0, lambda: eval_77()),
			(cond_m2_0 and cond_m3_0 and cond_m7_0, lambda: eval_77()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0, lambda: eval_18()),
			(cond_m2_0 and cond_m4_0 and cond_m6_0, lambda: eval_77()),
			(cond_m2_0 and cond_m4_0 and cond_m7_0, lambda: eval_77()),
			(cond_m2_0 and cond_m5_0 and cond_m6_0, lambda: eval_77()),
			(cond_m2_0 and cond_m5_0 and cond_m7_0, lambda: eval_77()),
			(cond_m2_0 and cond_m6_0 and cond_m7_0, lambda: eval_78()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0, lambda: eval_18()),
			(cond_m3_0 and cond_m4_0 and cond_m6_0, lambda: eval_77()),
			(cond_m3_0 and cond_m4_0 and cond_m7_0, lambda: eval_77()),
			(cond_m3_0 and cond_m5_0 and cond_m6_0, lambda: eval_77()),
			(cond_m3_0 and cond_m5_0 and cond_m7_0, lambda: eval_77()),
			(cond_m3_0 and cond_m6_0 and cond_m7_0, lambda: eval_78()),
			(cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_77()),
			(cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_77()),
			(cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_78()),
			(cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_78()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_19()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_19()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_19()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_19()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_25()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_26()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_19()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_19()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_19()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_25()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_26()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_19()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_19()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_25()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_26()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_19()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_25()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_26()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_25()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_26()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_63()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m4, lambda: eval_20()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m4, lambda: eval_20()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_20()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_20()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_37()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_38()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m6_m5 and cond_m7_m5, lambda: eval_21()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m6_m4 and cond_m7_m4, lambda: eval_21()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m6_m3 and cond_m7_m4, lambda: eval_71()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m3, lambda: eval_71()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m6_m5 and cond_m7_m5, lambda: eval_21()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m6_m4 and cond_m7_m4, lambda: eval_21()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m2 and cond_m7_m4, lambda: eval_71()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m2, lambda: eval_71()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_21()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_21()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m6_0 and cond_m7_m4, lambda: eval_39()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m6_m4 and cond_m7_0, lambda: eval_40()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m3 and cond_m7_m3, lambda: eval_21()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m2 and cond_m7_m3, lambda: eval_71()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m2, lambda: eval_71()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_21()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_39()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_40()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m2 and cond_m7_m3, lambda: eval_71()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m3 and cond_m7_m2, lambda: eval_71()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m6_0 and cond_m7_m3, lambda: eval_39()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m6_m3 and cond_m7_0, lambda: eval_40()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_0 and cond_m7_m2, lambda: eval_68()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m2 and cond_m7_0, lambda: eval_68()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m7_m6, lambda: eval_19()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m6_m3 and cond_m7_m5, lambda: eval_72()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m6_m5 and cond_m7_m3, lambda: eval_72()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m4, lambda: eval_72()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m6_m4 and cond_m7_m3, lambda: eval_72()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m6_m3 and cond_m7_m3, lambda: eval_20()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m7_m6, lambda: eval_19()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m6_m2 and cond_m7_m5, lambda: eval_72()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m6_m5 and cond_m7_m2, lambda: eval_72()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m4, lambda: eval_72()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m6_m4 and cond_m7_m2, lambda: eval_72()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m2 and cond_m7_m2, lambda: eval_20()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m7_m6, lambda: eval_19()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m6_m2 and cond_m7_m5, lambda: eval_72()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m6_m5 and cond_m7_m2, lambda: eval_72()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m7_m6, lambda: eval_19()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m6_0 and cond_m7_m5, lambda: eval_70()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m6_m5 and cond_m7_0, lambda: eval_70()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m4, lambda: eval_72()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m6_m4 and cond_m7_m2, lambda: eval_72()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m4, lambda: eval_70()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m6_m4 and cond_m7_0, lambda: eval_70()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m6_0 and cond_m7_m2, lambda: eval_41()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m6_m2 and cond_m7_0, lambda: eval_42()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m3, lambda: eval_72()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m3 and cond_m7_m2, lambda: eval_72()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m2 and cond_m7_m2, lambda: eval_20()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m3, lambda: eval_72()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m3 and cond_m7_m2, lambda: eval_72()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m3, lambda: eval_70()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m3 and cond_m7_0, lambda: eval_70()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m6_0 and cond_m7_m2, lambda: eval_41()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m6_m2 and cond_m7_0, lambda: eval_42()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_20()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_41()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_42()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3, lambda: eval_65()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m7_m3, lambda: eval_65()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_21()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_21()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2, lambda: eval_65()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m7_m2, lambda: eval_65()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_21()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_21()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_m2, lambda: eval_65()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m7_m2, lambda: eval_65()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_21()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_m2, lambda: eval_65()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m7_m2, lambda: eval_65()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_0, lambda: eval_64()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m7_0, lambda: eval_64()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_43()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_44()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_21()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_43()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_44()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_21()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_21()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_43()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_44()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m4, lambda: eval_20()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_20()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_20()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_37()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_38()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_20()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_20()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_37()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_38()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_20()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_37()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_38()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_37()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_38()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_64()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m6_m5 and cond_m7_m5, lambda: eval_21()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m6_m4 and cond_m7_m4, lambda: eval_21()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m1 and cond_m7_m4, lambda: eval_71()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m1, lambda: eval_71()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_21()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_21()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4 and cond_m6_0 and cond_m7_m4, lambda: eval_39()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4 and cond_m6_m4 and cond_m7_0, lambda: eval_40()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m3 and cond_m7_m3, lambda: eval_21()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m1 and cond_m7_m3, lambda: eval_71()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m1, lambda: eval_71()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_21()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_39()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_40()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m1 and cond_m7_m3, lambda: eval_71()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m3 and cond_m7_m1, lambda: eval_71()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1 and cond_m6_0 and cond_m7_m3, lambda: eval_39()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1 and cond_m6_m3 and cond_m7_0, lambda: eval_40()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_0 and cond_m7_m1, lambda: eval_68()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m1 and cond_m7_0, lambda: eval_68()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_21()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_21()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m4, lambda: eval_39()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_0, lambda: eval_40()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_21()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_39()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_40()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_39()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_40()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_65()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_21()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_71()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_71()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_21()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_39()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_40()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_71()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_71()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_39()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_40()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_68()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_68()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_21()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_39()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_40()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_39()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_40()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_65()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_71()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_71()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_39()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_40()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_68()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_68()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_39()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_40()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_65()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_68()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_68()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_65()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m7_m6, lambda: eval_19()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m6_m1 and cond_m7_m5, lambda: eval_72()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m6_m5 and cond_m7_m1, lambda: eval_72()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m4, lambda: eval_72()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m6_m4 and cond_m7_m1, lambda: eval_72()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m1 and cond_m7_m1, lambda: eval_20()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m7_m6, lambda: eval_19()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m6_m1 and cond_m7_m5, lambda: eval_72()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m6_m5 and cond_m7_m1, lambda: eval_72()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m7_m6, lambda: eval_19()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m6_0 and cond_m7_m5, lambda: eval_70()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m6_m5 and cond_m7_0, lambda: eval_70()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m4, lambda: eval_72()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m6_m4 and cond_m7_m1, lambda: eval_72()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m4, lambda: eval_70()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1 and cond_m6_m4 and cond_m7_0, lambda: eval_70()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4 and cond_m6_0 and cond_m7_m1, lambda: eval_41()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4 and cond_m6_m1 and cond_m7_0, lambda: eval_42()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m3, lambda: eval_72()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m3 and cond_m7_m1, lambda: eval_72()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m1 and cond_m7_m1, lambda: eval_20()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m3, lambda: eval_72()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m3 and cond_m7_m1, lambda: eval_72()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m3, lambda: eval_70()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m3 and cond_m7_0, lambda: eval_70()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3 and cond_m6_0 and cond_m7_m1, lambda: eval_41()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3 and cond_m6_m1 and cond_m7_0, lambda: eval_42()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_20()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_41()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_42()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m7_m6, lambda: eval_19()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m6_m1 and cond_m7_m5, lambda: eval_72()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m1, lambda: eval_72()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m7_m6, lambda: eval_19()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m6_0 and cond_m7_m5, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m6_m5 and cond_m7_0, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m4, lambda: eval_72()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m1, lambda: eval_72()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m4, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1 and cond_m6_m4 and cond_m7_0, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m1, lambda: eval_41()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4 and cond_m6_m1 and cond_m7_0, lambda: eval_42()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m7_m6, lambda: eval_19()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m6_0 and cond_m7_m5, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m6_m5 and cond_m7_0, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m4, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0 and cond_m6_m4 and cond_m7_0, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4 and cond_m6_0 and cond_m7_0, lambda: eval_66()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m3, lambda: eval_72()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m1, lambda: eval_72()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m3, lambda: eval_70()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m3 and cond_m7_0, lambda: eval_70()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m1, lambda: eval_41()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3 and cond_m6_m1 and cond_m7_0, lambda: eval_42()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_70()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_70()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_66()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_41()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_42()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_66()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_72()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_72()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_20()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_72()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_72()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_70()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_70()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_41()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_42()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_20()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_41()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_42()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_72()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_72()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_70()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_70()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_41()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_42()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_70()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_70()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_66()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_41()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_42()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_66()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_20()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_41()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_42()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_41()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_42()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_66()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_65()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m7_m1, lambda: eval_65()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_21()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_21()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_65()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m7_m1, lambda: eval_65()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_21()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_65()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m7_m1, lambda: eval_65()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_64()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m7_0, lambda: eval_64()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_43()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_44()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_21()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_43()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_44()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_21()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_21()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_43()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_44()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_65()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m7_m1, lambda: eval_65()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_21()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_65()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m7_m1, lambda: eval_65()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_64()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m7_0, lambda: eval_64()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_43()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_44()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_21()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_43()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_44()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_65()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m7_m1, lambda: eval_65()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_64()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m7_0, lambda: eval_64()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m6_0 and cond_m7_m1, lambda: eval_43()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m6_m1 and cond_m7_0, lambda: eval_44()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_64()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m7_0, lambda: eval_64()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m6_0 and cond_m7_0, lambda: eval_67()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_43()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_44()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_67()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_21()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_43()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_44()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_43()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_44()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_67()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_21()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_21()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_43()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_44()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_21()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_43()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_44()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_43()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_44()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_67()),
			(cond_m1_0 and cond_m2_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_22()),
			(cond_m1_0 and cond_m3_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_22()),
			(cond_m1_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_22()),
			(cond_m1_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_22()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m4, lambda: eval_55()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_0, lambda: eval_56()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m7_m6, lambda: eval_20()),
			(cond_m1_0 and cond_m2_0 and cond_m6_m4 and cond_m7_m5, lambda: eval_77()),
			(cond_m1_0 and cond_m2_0 and cond_m6_m5 and cond_m7_m4, lambda: eval_77()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m7_m6, lambda: eval_20()),
			(cond_m1_0 and cond_m3_0 and cond_m6_m4 and cond_m7_m5, lambda: eval_77()),
			(cond_m1_0 and cond_m3_0 and cond_m6_m5 and cond_m7_m4, lambda: eval_77()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m7_m6, lambda: eval_20()),
			(cond_m1_0 and cond_m4_0 and cond_m6_m3 and cond_m7_m5, lambda: eval_77()),
			(cond_m1_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m3, lambda: eval_77()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m7_m6, lambda: eval_20()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_0 and cond_m7_m5, lambda: eval_75()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_m5 and cond_m7_0, lambda: eval_75()),
			(cond_m1_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m4, lambda: eval_77()),
			(cond_m1_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m3, lambda: eval_77()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m4, lambda: eval_75()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_m4 and cond_m7_0, lambda: eval_75()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m3, lambda: eval_74()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_m3 and cond_m7_0, lambda: eval_74()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m6_m4, lambda: eval_71()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m7_m4, lambda: eval_71()),
			(cond_m1_0 and cond_m2_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_22()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m4, lambda: eval_71()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m7_m4, lambda: eval_71()),
			(cond_m1_0 and cond_m3_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_22()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m3, lambda: eval_71()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m7_m3, lambda: eval_71()),
			(cond_m1_0 and cond_m4_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_22()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m3, lambda: eval_71()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m7_m3, lambda: eval_71()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_0, lambda: eval_68()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m7_0, lambda: eval_68()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_57()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_58()),
			(cond_m1_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_22()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_57()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_58()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m7_m6, lambda: eval_21()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m7_m6, lambda: eval_21()),
			(cond_m1_0 and cond_m2_0 and cond_m6_m3 and cond_m7_m5, lambda: eval_77()),
			(cond_m1_0 and cond_m2_0 and cond_m6_m5 and cond_m7_m3, lambda: eval_77()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m7_m6, lambda: eval_21()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m7_m6, lambda: eval_21()),
			(cond_m1_0 and cond_m3_0 and cond_m6_m2 and cond_m7_m5, lambda: eval_77()),
			(cond_m1_0 and cond_m3_0 and cond_m6_m5 and cond_m7_m2, lambda: eval_77()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m7_m6, lambda: eval_21()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m7_m6, lambda: eval_21()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_0 and cond_m7_m5, lambda: eval_76()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_m5 and cond_m7_0, lambda: eval_76()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m7_m6, lambda: eval_21()),
			(cond_m1_0 and cond_m4_0 and cond_m6_m2 and cond_m7_m5, lambda: eval_77()),
			(cond_m1_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m2, lambda: eval_77()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m7_m6, lambda: eval_21()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_0 and cond_m7_m5, lambda: eval_76()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_m5 and cond_m7_0, lambda: eval_76()),
			(cond_m1_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m4, lambda: eval_77()),
			(cond_m1_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m2, lambda: eval_77()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m4, lambda: eval_76()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_m4 and cond_m7_0, lambda: eval_76()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m2, lambda: eval_74()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_m2 and cond_m7_0, lambda: eval_74()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m6_m5, lambda: eval_72()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m7_m5, lambda: eval_72()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m6_m4, lambda: eval_72()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m7_m4, lambda: eval_72()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m6_m3, lambda: eval_71()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m7_m3, lambda: eval_71()),
			(cond_m1_0 and cond_m2_0 and cond_m6_m3 and cond_m7_m4, lambda: eval_77()),
			(cond_m1_0 and cond_m2_0 and cond_m6_m4 and cond_m7_m3, lambda: eval_77()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m6_m5, lambda: eval_72()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m7_m5, lambda: eval_72()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m6_m4, lambda: eval_72()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m7_m4, lambda: eval_72()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m2, lambda: eval_71()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m7_m2, lambda: eval_71()),
			(cond_m1_0 and cond_m3_0 and cond_m6_m2 and cond_m7_m4, lambda: eval_77()),
			(cond_m1_0 and cond_m3_0 and cond_m6_m4 and cond_m7_m2, lambda: eval_77()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m6_m5, lambda: eval_72()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m7_m5, lambda: eval_72()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m6_m4, lambda: eval_72()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m7_m4, lambda: eval_72()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m6_0, lambda: eval_69()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m7_0, lambda: eval_69()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_0 and cond_m7_m4, lambda: eval_76()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_m4 and cond_m7_0, lambda: eval_76()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m3, lambda: eval_72()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m7_m3, lambda: eval_72()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m2, lambda: eval_71()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m7_m2, lambda: eval_71()),
			(cond_m1_0 and cond_m4_0 and cond_m6_m2 and cond_m7_m3, lambda: eval_77()),
			(cond_m1_0 and cond_m4_0 and cond_m6_m3 and cond_m7_m2, lambda: eval_77()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m3, lambda: eval_72()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m7_m3, lambda: eval_72()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m6_0, lambda: eval_69()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m7_0, lambda: eval_69()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_0 and cond_m7_m3, lambda: eval_76()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_m3 and cond_m7_0, lambda: eval_76()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m2, lambda: eval_71()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m7_m2, lambda: eval_71()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m6_0, lambda: eval_69()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m7_0, lambda: eval_69()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_0 and cond_m7_m2, lambda: eval_75()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_m2 and cond_m7_0, lambda: eval_75()),
			(cond_m1_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m3, lambda: eval_77()),
			(cond_m1_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m2, lambda: eval_77()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m3, lambda: eval_76()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_m3 and cond_m7_0, lambda: eval_76()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m2, lambda: eval_75()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_m2 and cond_m7_0, lambda: eval_75()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_m3, lambda: eval_65()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m6_m3, lambda: eval_72()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m7_m3, lambda: eval_72()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m6_m3, lambda: eval_72()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m7_m3, lambda: eval_72()),
			(cond_m1_0 and cond_m2_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_22()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_m2, lambda: eval_65()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m6_m2, lambda: eval_72()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m7_m2, lambda: eval_72()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m6_m2, lambda: eval_72()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m7_m2, lambda: eval_72()),
			(cond_m1_0 and cond_m3_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_22()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_m2, lambda: eval_65()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m6_m2, lambda: eval_72()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m7_m2, lambda: eval_72()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_0, lambda: eval_65()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m6_0, lambda: eval_70()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m7_0, lambda: eval_70()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m6_m2, lambda: eval_72()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m7_m2, lambda: eval_72()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m6_0, lambda: eval_70()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m7_0, lambda: eval_70()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_59()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_60()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m2, lambda: eval_72()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m7_m2, lambda: eval_72()),
			(cond_m1_0 and cond_m4_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_22()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m2, lambda: eval_72()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m7_m2, lambda: eval_72()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_0, lambda: eval_70()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m7_0, lambda: eval_70()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_59()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_60()),
			(cond_m1_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_22()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_59()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_60()),
			(cond_m2_0 and cond_m3_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_22()),
			(cond_m2_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_22()),
			(cond_m2_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_22()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m4, lambda: eval_55()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_0, lambda: eval_56()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m7_m6, lambda: eval_20()),
			(cond_m2_0 and cond_m3_0 and cond_m6_m4 and cond_m7_m5, lambda: eval_77()),
			(cond_m2_0 and cond_m3_0 and cond_m6_m5 and cond_m7_m4, lambda: eval_77()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m7_m6, lambda: eval_20()),
			(cond_m2_0 and cond_m4_0 and cond_m6_m3 and cond_m7_m5, lambda: eval_77()),
			(cond_m2_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m3, lambda: eval_77()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m7_m6, lambda: eval_20()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_0 and cond_m7_m5, lambda: eval_75()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_m5 and cond_m7_0, lambda: eval_75()),
			(cond_m2_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m4, lambda: eval_77()),
			(cond_m2_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m3, lambda: eval_77()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m4, lambda: eval_75()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_m4 and cond_m7_0, lambda: eval_75()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m3, lambda: eval_74()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_m3 and cond_m7_0, lambda: eval_74()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m4, lambda: eval_71()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m7_m4, lambda: eval_71()),
			(cond_m2_0 and cond_m3_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_22()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m3, lambda: eval_71()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m7_m3, lambda: eval_71()),
			(cond_m2_0 and cond_m4_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_22()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m3, lambda: eval_71()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m7_m3, lambda: eval_71()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_0, lambda: eval_68()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m7_0, lambda: eval_68()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_57()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_58()),
			(cond_m2_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_22()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_57()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_58()),
			(cond_m3_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_22()),
			(cond_m3_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_22()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m4, lambda: eval_55()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_0, lambda: eval_56()),
			(cond_m4_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_22()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_55()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_56()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_55()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_56()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_68()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m7_m6, lambda: eval_20()),
			(cond_m3_0 and cond_m4_0 and cond_m6_m2 and cond_m7_m5, lambda: eval_77()),
			(cond_m3_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m2, lambda: eval_77()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m7_m6, lambda: eval_20()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_0 and cond_m7_m5, lambda: eval_75()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_m5 and cond_m7_0, lambda: eval_75()),
			(cond_m3_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m4, lambda: eval_77()),
			(cond_m3_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m2, lambda: eval_77()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m4, lambda: eval_75()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_m4 and cond_m7_0, lambda: eval_75()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m2, lambda: eval_74()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_m2 and cond_m7_0, lambda: eval_74()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m7_m6, lambda: eval_20()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_0 and cond_m7_m5, lambda: eval_75()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_m5 and cond_m7_0, lambda: eval_75()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m4, lambda: eval_75()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_m4 and cond_m7_0, lambda: eval_75()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_0 and cond_m7_0, lambda: eval_69()),
			(cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m3, lambda: eval_77()),
			(cond_m4_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m2, lambda: eval_77()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m3, lambda: eval_75()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_m3 and cond_m7_0, lambda: eval_75()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m2, lambda: eval_74()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_m2 and cond_m7_0, lambda: eval_74()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_75()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_75()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_69()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_74()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_74()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_69()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m2, lambda: eval_71()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m7_m2, lambda: eval_71()),
			(cond_m3_0 and cond_m4_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_22()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m2, lambda: eval_71()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m7_m2, lambda: eval_71()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_0, lambda: eval_68()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m7_0, lambda: eval_68()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_57()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_58()),
			(cond_m3_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_22()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_57()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_58()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_m2, lambda: eval_71()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m7_m2, lambda: eval_71()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_0, lambda: eval_68()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m7_0, lambda: eval_68()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_0 and cond_m7_m2, lambda: eval_57()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_m2 and cond_m7_0, lambda: eval_58()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_0, lambda: eval_68()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m7_0, lambda: eval_68()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_0 and cond_m7_0, lambda: eval_70()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_57()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_58()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_70()),
			(cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_22()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_57()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_58()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_57()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_58()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_70()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m7_m6, lambda: eval_21()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m7_m6, lambda: eval_21()),
			(cond_m2_0 and cond_m3_0 and cond_m6_m1 and cond_m7_m5, lambda: eval_77()),
			(cond_m2_0 and cond_m3_0 and cond_m6_m5 and cond_m7_m1, lambda: eval_77()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m7_m6, lambda: eval_21()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m7_m6, lambda: eval_21()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_0 and cond_m7_m5, lambda: eval_76()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_m5 and cond_m7_0, lambda: eval_76()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m7_m6, lambda: eval_21()),
			(cond_m2_0 and cond_m4_0 and cond_m6_m1 and cond_m7_m5, lambda: eval_77()),
			(cond_m2_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m1, lambda: eval_77()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m7_m6, lambda: eval_21()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_0 and cond_m7_m5, lambda: eval_76()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_m5 and cond_m7_0, lambda: eval_76()),
			(cond_m2_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m4, lambda: eval_77()),
			(cond_m2_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m1, lambda: eval_77()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m4, lambda: eval_76()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_m4 and cond_m7_0, lambda: eval_76()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m1, lambda: eval_74()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_m1 and cond_m7_0, lambda: eval_74()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m7_m6, lambda: eval_21()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m7_m6, lambda: eval_21()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_0 and cond_m7_m5, lambda: eval_76()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_m5 and cond_m7_0, lambda: eval_76()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m6_m5, lambda: eval_72()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m7_m5, lambda: eval_72()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m6_m4, lambda: eval_72()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m7_m4, lambda: eval_72()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m1, lambda: eval_71()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m7_m1, lambda: eval_71()),
			(cond_m2_0 and cond_m3_0 and cond_m6_m1 and cond_m7_m4, lambda: eval_77()),
			(cond_m2_0 and cond_m3_0 and cond_m6_m4 and cond_m7_m1, lambda: eval_77()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m6_m5, lambda: eval_72()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m7_m5, lambda: eval_72()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m6_m4, lambda: eval_72()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m7_m4, lambda: eval_72()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4 and cond_m6_0, lambda: eval_69()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4 and cond_m7_0, lambda: eval_69()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_0 and cond_m7_m4, lambda: eval_76()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_m4 and cond_m7_0, lambda: eval_76()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m3, lambda: eval_72()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m7_m3, lambda: eval_72()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m1, lambda: eval_71()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m7_m1, lambda: eval_71()),
			(cond_m2_0 and cond_m4_0 and cond_m6_m1 and cond_m7_m3, lambda: eval_77()),
			(cond_m2_0 and cond_m4_0 and cond_m6_m3 and cond_m7_m1, lambda: eval_77()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m3, lambda: eval_72()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m7_m3, lambda: eval_72()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3 and cond_m6_0, lambda: eval_69()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3 and cond_m7_0, lambda: eval_69()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_0 and cond_m7_m3, lambda: eval_76()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_m3 and cond_m7_0, lambda: eval_76()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m1, lambda: eval_71()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m7_m1, lambda: eval_71()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1 and cond_m6_0, lambda: eval_69()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1 and cond_m7_0, lambda: eval_69()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_0 and cond_m7_m1, lambda: eval_75()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_m1 and cond_m7_0, lambda: eval_75()),
			(cond_m2_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m3, lambda: eval_77()),
			(cond_m2_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m1, lambda: eval_77()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m3, lambda: eval_76()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_m3 and cond_m7_0, lambda: eval_76()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m1, lambda: eval_75()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_m1 and cond_m7_0, lambda: eval_75()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m6_m5, lambda: eval_72()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m7_m5, lambda: eval_72()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m6_m4, lambda: eval_72()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m7_m4, lambda: eval_72()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4 and cond_m6_0, lambda: eval_69()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4 and cond_m7_0, lambda: eval_69()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_0 and cond_m7_m4, lambda: eval_76()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_m4 and cond_m7_0, lambda: eval_76()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m7_m6, lambda: eval_21()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_0 and cond_m7_m5, lambda: eval_76()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_m5 and cond_m7_0, lambda: eval_76()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m7_m6, lambda: eval_21()),
			(cond_m3_0 and cond_m4_0 and cond_m6_m1 and cond_m7_m5, lambda: eval_77()),
			(cond_m3_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m1, lambda: eval_77()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m7_m6, lambda: eval_21()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_0 and cond_m7_m5, lambda: eval_76()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_m5 and cond_m7_0, lambda: eval_76()),
			(cond_m3_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m4, lambda: eval_77()),
			(cond_m3_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m1, lambda: eval_77()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m4, lambda: eval_76()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_m4 and cond_m7_0, lambda: eval_76()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m1, lambda: eval_74()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_m1 and cond_m7_0, lambda: eval_74()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m7_m6, lambda: eval_21()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_0 and cond_m7_m5, lambda: eval_76()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_m5 and cond_m7_0, lambda: eval_76()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m4, lambda: eval_76()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_m4 and cond_m7_0, lambda: eval_76()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_0 and cond_m7_0, lambda: eval_71()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m4, lambda: eval_76()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_m4 and cond_m7_0, lambda: eval_76()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_0 and cond_m7_0, lambda: eval_71()),
			(cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m3, lambda: eval_77()),
			(cond_m4_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m1, lambda: eval_77()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m3, lambda: eval_76()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_m3 and cond_m7_0, lambda: eval_76()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m1, lambda: eval_74()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_m1 and cond_m7_0, lambda: eval_74()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_76()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_76()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_71()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_74()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_74()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_71()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m3, lambda: eval_72()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m7_m3, lambda: eval_72()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3 and cond_m6_0, lambda: eval_69()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3 and cond_m7_0, lambda: eval_69()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_0 and cond_m7_m3, lambda: eval_76()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_m3 and cond_m7_0, lambda: eval_76()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0 and cond_m6_0, lambda: eval_69()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0 and cond_m7_0, lambda: eval_69()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m2, lambda: eval_72()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m7_m2, lambda: eval_72()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m1, lambda: eval_71()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m7_m1, lambda: eval_71()),
			(cond_m3_0 and cond_m4_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_77()),
			(cond_m3_0 and cond_m4_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_77()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m2, lambda: eval_72()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m7_m2, lambda: eval_72()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2 and cond_m6_0, lambda: eval_69()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2 and cond_m7_0, lambda: eval_69()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_76()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_76()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m1, lambda: eval_71()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m7_m1, lambda: eval_71()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1 and cond_m6_0, lambda: eval_69()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1 and cond_m7_0, lambda: eval_69()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_75()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_75()),
			(cond_m3_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_77()),
			(cond_m3_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_77()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_76()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_76()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_75()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_75()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m2, lambda: eval_72()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m7_m2, lambda: eval_72()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2 and cond_m6_0, lambda: eval_69()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2 and cond_m7_0, lambda: eval_69()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_0 and cond_m7_m2, lambda: eval_76()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_m2 and cond_m7_0, lambda: eval_76()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0 and cond_m6_0, lambda: eval_69()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0 and cond_m7_0, lambda: eval_69()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_71()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m7_m1, lambda: eval_71()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_69()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1 and cond_m7_0, lambda: eval_69()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_0 and cond_m7_m1, lambda: eval_75()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_m1 and cond_m7_0, lambda: eval_75()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_69()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0 and cond_m7_0, lambda: eval_69()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_0 and cond_m7_0, lambda: eval_72()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_76()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_76()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_72()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_0 and cond_m7_0, lambda: eval_72()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_76()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_76()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_72()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_0 and cond_m7_0, lambda: eval_72()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_75()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_75()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_72()),
			(cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_77()),
			(cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_77()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_76()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_76()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_75()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_75()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_76()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_76()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_72()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_75()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_75()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_72()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_m1, lambda: eval_65()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m6_m1, lambda: eval_72()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m7_m1, lambda: eval_72()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_72()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m7_m1, lambda: eval_72()),
			(cond_m2_0 and cond_m3_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_22()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_m1, lambda: eval_65()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m6_m1, lambda: eval_72()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m7_m1, lambda: eval_72()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_0, lambda: eval_65()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m6_0, lambda: eval_70()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m7_0, lambda: eval_70()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_72()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m7_m1, lambda: eval_72()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_70()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1 and cond_m7_0, lambda: eval_70()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_59()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_60()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_72()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m7_m1, lambda: eval_72()),
			(cond_m2_0 and cond_m4_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_22()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_72()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m7_m1, lambda: eval_72()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_70()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1 and cond_m7_0, lambda: eval_70()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_59()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_60()),
			(cond_m2_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_22()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_59()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_60()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_m1, lambda: eval_65()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m6_m1, lambda: eval_72()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m7_m1, lambda: eval_72()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_0, lambda: eval_65()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m6_0, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m7_0, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m6_m1, lambda: eval_72()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m7_m1, lambda: eval_72()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1 and cond_m6_0, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1 and cond_m7_0, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_0 and cond_m7_m1, lambda: eval_59()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_m1 and cond_m7_0, lambda: eval_60()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_0, lambda: eval_65()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m6_0, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m7_0, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0 and cond_m6_0, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0 and cond_m7_0, lambda: eval_70()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_72()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m7_m1, lambda: eval_72()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_70()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1 and cond_m7_0, lambda: eval_70()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_0 and cond_m7_m1, lambda: eval_59()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_m1 and cond_m7_0, lambda: eval_60()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_70()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0 and cond_m7_0, lambda: eval_70()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_72()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m7_m1, lambda: eval_72()),
			(cond_m3_0 and cond_m4_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_22()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_72()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m7_m1, lambda: eval_72()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_70()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m7_0, lambda: eval_70()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_59()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_60()),
			(cond_m3_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_22()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_59()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_60()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_72()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m7_m1, lambda: eval_72()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_70()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m7_0, lambda: eval_70()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_0 and cond_m7_m1, lambda: eval_59()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_m1 and cond_m7_0, lambda: eval_60()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_70()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m7_0, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_0 and cond_m7_0, lambda: eval_73()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_0 and cond_m7_0, lambda: eval_73()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_59()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_60()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_73()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_0 and cond_m7_0, lambda: eval_73()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_59()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_60()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_73()),
			(cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_22()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_59()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_60()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_59()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_60()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_73()),
			(cond_m1_0 and cond_m2_0 and cond_m7_m6, lambda: eval_22()),
			(cond_m1_0 and cond_m3_0 and cond_m7_m6, lambda: eval_22()),
			(cond_m1_0 and cond_m4_0 and cond_m7_m6, lambda: eval_22()),
			(cond_m1_0 and cond_m5_0 and cond_m7_m6, lambda: eval_22()),
			(cond_m1_0 and cond_m6_0 and cond_m7_m5, lambda: eval_78()),
			(cond_m1_0 and cond_m6_m5 and cond_m7_0, lambda: eval_78()),
			(cond_m1_0 and cond_m2_0 and cond_m6_m5, lambda: eval_77()),
			(cond_m1_0 and cond_m2_0 and cond_m7_m5, lambda: eval_77()),
			(cond_m1_0 and cond_m3_0 and cond_m6_m5, lambda: eval_77()),
			(cond_m1_0 and cond_m3_0 and cond_m7_m5, lambda: eval_77()),
			(cond_m1_0 and cond_m4_0 and cond_m6_m5, lambda: eval_77()),
			(cond_m1_0 and cond_m4_0 and cond_m7_m5, lambda: eval_77()),
			(cond_m1_0 and cond_m5_0 and cond_m6_m4, lambda: eval_77()),
			(cond_m1_0 and cond_m5_0 and cond_m7_m4, lambda: eval_77()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_0, lambda: eval_74()),
			(cond_m1_0 and cond_m5_m4 and cond_m7_0, lambda: eval_74()),
			(cond_m1_0 and cond_m6_0 and cond_m7_m4, lambda: eval_78()),
			(cond_m1_0 and cond_m6_m4 and cond_m7_0, lambda: eval_78()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4, lambda: eval_71()),
			(cond_m1_0 and cond_m2_0 and cond_m6_m4, lambda: eval_77()),
			(cond_m1_0 and cond_m2_0 and cond_m7_m4, lambda: eval_77()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4, lambda: eval_71()),
			(cond_m1_0 and cond_m3_0 and cond_m6_m4, lambda: eval_77()),
			(cond_m1_0 and cond_m3_0 and cond_m7_m4, lambda: eval_77()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3, lambda: eval_71()),
			(cond_m1_0 and cond_m4_0 and cond_m6_m3, lambda: eval_77()),
			(cond_m1_0 and cond_m4_0 and cond_m7_m3, lambda: eval_77()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0, lambda: eval_71()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_0, lambda: eval_75()),
			(cond_m1_0 and cond_m4_m3 and cond_m7_0, lambda: eval_75()),
			(cond_m1_0 and cond_m5_0 and cond_m6_m3, lambda: eval_77()),
			(cond_m1_0 and cond_m5_0 and cond_m7_m3, lambda: eval_77()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_0, lambda: eval_75()),
			(cond_m1_0 and cond_m5_m3 and cond_m7_0, lambda: eval_75()),
			(cond_m1_0 and cond_m6_0 and cond_m7_m3, lambda: eval_78()),
			(cond_m1_0 and cond_m6_m3 and cond_m7_0, lambda: eval_78()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3, lambda: eval_72()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3, lambda: eval_72()),
			(cond_m1_0 and cond_m2_0 and cond_m6_m3, lambda: eval_77()),
			(cond_m1_0 and cond_m2_0 and cond_m7_m3, lambda: eval_77()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2, lambda: eval_72()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2, lambda: eval_72()),
			(cond_m1_0 and cond_m3_0 and cond_m6_m2, lambda: eval_77()),
			(cond_m1_0 and cond_m3_0 and cond_m7_m2, lambda: eval_77()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0, lambda: eval_72()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0, lambda: eval_72()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_0, lambda: eval_76()),
			(cond_m1_0 and cond_m3_m2 and cond_m7_0, lambda: eval_76()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2, lambda: eval_72()),
			(cond_m1_0 and cond_m4_0 and cond_m6_m2, lambda: eval_77()),
			(cond_m1_0 and cond_m4_0 and cond_m7_m2, lambda: eval_77()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0, lambda: eval_72()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_0, lambda: eval_76()),
			(cond_m1_0 and cond_m4_m2 and cond_m7_0, lambda: eval_76()),
			(cond_m1_0 and cond_m5_0 and cond_m6_m2, lambda: eval_77()),
			(cond_m1_0 and cond_m5_0 and cond_m7_m2, lambda: eval_77()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_0, lambda: eval_76()),
			(cond_m1_0 and cond_m5_m2 and cond_m7_0, lambda: eval_76()),
			(cond_m1_0 and cond_m6_0 and cond_m7_m2, lambda: eval_78()),
			(cond_m1_0 and cond_m6_m2 and cond_m7_0, lambda: eval_78()),
			(cond_m2_0 and cond_m3_0 and cond_m7_m6, lambda: eval_22()),
			(cond_m2_0 and cond_m4_0 and cond_m7_m6, lambda: eval_22()),
			(cond_m2_0 and cond_m5_0 and cond_m7_m6, lambda: eval_22()),
			(cond_m2_0 and cond_m6_0 and cond_m7_m5, lambda: eval_78()),
			(cond_m2_0 and cond_m6_m5 and cond_m7_0, lambda: eval_78()),
			(cond_m2_0 and cond_m3_0 and cond_m6_m5, lambda: eval_77()),
			(cond_m2_0 and cond_m3_0 and cond_m7_m5, lambda: eval_77()),
			(cond_m2_0 and cond_m4_0 and cond_m6_m5, lambda: eval_77()),
			(cond_m2_0 and cond_m4_0 and cond_m7_m5, lambda: eval_77()),
			(cond_m2_0 and cond_m5_0 and cond_m6_m4, lambda: eval_77()),
			(cond_m2_0 and cond_m5_0 and cond_m7_m4, lambda: eval_77()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_0, lambda: eval_74()),
			(cond_m2_0 and cond_m5_m4 and cond_m7_0, lambda: eval_74()),
			(cond_m2_0 and cond_m6_0 and cond_m7_m4, lambda: eval_78()),
			(cond_m2_0 and cond_m6_m4 and cond_m7_0, lambda: eval_78()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4, lambda: eval_71()),
			(cond_m2_0 and cond_m3_0 and cond_m6_m4, lambda: eval_77()),
			(cond_m2_0 and cond_m3_0 and cond_m7_m4, lambda: eval_77()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3, lambda: eval_71()),
			(cond_m2_0 and cond_m4_0 and cond_m6_m3, lambda: eval_77()),
			(cond_m2_0 and cond_m4_0 and cond_m7_m3, lambda: eval_77()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0, lambda: eval_71()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_0, lambda: eval_75()),
			(cond_m2_0 and cond_m4_m3 and cond_m7_0, lambda: eval_75()),
			(cond_m2_0 and cond_m5_0 and cond_m6_m3, lambda: eval_77()),
			(cond_m2_0 and cond_m5_0 and cond_m7_m3, lambda: eval_77()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_0, lambda: eval_75()),
			(cond_m2_0 and cond_m5_m3 and cond_m7_0, lambda: eval_75()),
			(cond_m2_0 and cond_m6_0 and cond_m7_m3, lambda: eval_78()),
			(cond_m2_0 and cond_m6_m3 and cond_m7_0, lambda: eval_78()),
			(cond_m3_0 and cond_m4_0 and cond_m7_m6, lambda: eval_22()),
			(cond_m3_0 and cond_m5_0 and cond_m7_m6, lambda: eval_22()),
			(cond_m3_0 and cond_m6_0 and cond_m7_m5, lambda: eval_78()),
			(cond_m3_0 and cond_m6_m5 and cond_m7_0, lambda: eval_78()),
			(cond_m3_0 and cond_m4_0 and cond_m6_m5, lambda: eval_77()),
			(cond_m3_0 and cond_m4_0 and cond_m7_m5, lambda: eval_77()),
			(cond_m3_0 and cond_m5_0 and cond_m6_m4, lambda: eval_77()),
			(cond_m3_0 and cond_m5_0 and cond_m7_m4, lambda: eval_77()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_0, lambda: eval_74()),
			(cond_m3_0 and cond_m5_m4 and cond_m7_0, lambda: eval_74()),
			(cond_m3_0 and cond_m6_0 and cond_m7_m4, lambda: eval_78()),
			(cond_m3_0 and cond_m6_m4 and cond_m7_0, lambda: eval_78()),
			(cond_m4_0 and cond_m5_0 and cond_m7_m6, lambda: eval_22()),
			(cond_m4_0 and cond_m6_0 and cond_m7_m5, lambda: eval_78()),
			(cond_m4_0 and cond_m6_m5 and cond_m7_0, lambda: eval_78()),
			(cond_m5_0 and cond_m6_0 and cond_m7_m4, lambda: eval_78()),
			(cond_m5_0 and cond_m6_m4 and cond_m7_0, lambda: eval_78()),
			(cond_m5_m4 and cond_m6_0 and cond_m7_0, lambda: eval_74()),
			(cond_m4_0 and cond_m5_0 and cond_m6_m3, lambda: eval_77()),
			(cond_m4_0 and cond_m5_0 and cond_m7_m3, lambda: eval_77()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_0, lambda: eval_74()),
			(cond_m4_0 and cond_m5_m3 and cond_m7_0, lambda: eval_74()),
			(cond_m4_0 and cond_m6_0 and cond_m7_m3, lambda: eval_78()),
			(cond_m4_0 and cond_m6_m3 and cond_m7_0, lambda: eval_78()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_0, lambda: eval_74()),
			(cond_m4_m3 and cond_m5_0 and cond_m7_0, lambda: eval_74()),
			(cond_m4_m3 and cond_m6_0 and cond_m7_0, lambda: eval_75()),
			(cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_78()),
			(cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_78()),
			(cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_75()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2, lambda: eval_71()),
			(cond_m3_0 and cond_m4_0 and cond_m6_m2, lambda: eval_77()),
			(cond_m3_0 and cond_m4_0 and cond_m7_m2, lambda: eval_77()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0, lambda: eval_71()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_0, lambda: eval_75()),
			(cond_m3_0 and cond_m4_m2 and cond_m7_0, lambda: eval_75()),
			(cond_m3_0 and cond_m5_0 and cond_m6_m2, lambda: eval_77()),
			(cond_m3_0 and cond_m5_0 and cond_m7_m2, lambda: eval_77()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_0, lambda: eval_75()),
			(cond_m3_0 and cond_m5_m2 and cond_m7_0, lambda: eval_75()),
			(cond_m3_0 and cond_m6_0 and cond_m7_m2, lambda: eval_78()),
			(cond_m3_0 and cond_m6_m2 and cond_m7_0, lambda: eval_78()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0, lambda: eval_71()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_0, lambda: eval_75()),
			(cond_m3_m2 and cond_m4_0 and cond_m7_0, lambda: eval_75()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_0, lambda: eval_75()),
			(cond_m3_m2 and cond_m5_0 and cond_m7_0, lambda: eval_75()),
			(cond_m4_0 and cond_m5_0 and cond_m6_m2, lambda: eval_77()),
			(cond_m4_0 and cond_m5_0 and cond_m7_m2, lambda: eval_77()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_0, lambda: eval_75()),
			(cond_m4_0 and cond_m5_m2 and cond_m7_0, lambda: eval_75()),
			(cond_m4_0 and cond_m6_0 and cond_m7_m2, lambda: eval_78()),
			(cond_m4_0 and cond_m6_m2 and cond_m7_0, lambda: eval_78()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_0, lambda: eval_75()),
			(cond_m4_m2 and cond_m5_0 and cond_m7_0, lambda: eval_75()),
			(cond_m3_m2 and cond_m6_0 and cond_m7_0, lambda: eval_76()),
			(cond_m4_m2 and cond_m6_0 and cond_m7_0, lambda: eval_76()),
			(cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_78()),
			(cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_78()),
			(cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_76()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1, lambda: eval_72()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1, lambda: eval_72()),
			(cond_m2_0 and cond_m3_0 and cond_m6_m1, lambda: eval_77()),
			(cond_m2_0 and cond_m3_0 and cond_m7_m1, lambda: eval_77()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0, lambda: eval_72()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0, lambda: eval_72()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_0, lambda: eval_76()),
			(cond_m2_0 and cond_m3_m1 and cond_m7_0, lambda: eval_76()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1, lambda: eval_72()),
			(cond_m2_0 and cond_m4_0 and cond_m6_m1, lambda: eval_77()),
			(cond_m2_0 and cond_m4_0 and cond_m7_m1, lambda: eval_77()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0, lambda: eval_72()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_0, lambda: eval_76()),
			(cond_m2_0 and cond_m4_m1 and cond_m7_0, lambda: eval_76()),
			(cond_m2_0 and cond_m5_0 and cond_m6_m1, lambda: eval_77()),
			(cond_m2_0 and cond_m5_0 and cond_m7_m1, lambda: eval_77()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_0, lambda: eval_76()),
			(cond_m2_0 and cond_m5_m1 and cond_m7_0, lambda: eval_76()),
			(cond_m2_0 and cond_m6_0 and cond_m7_m1, lambda: eval_78()),
			(cond_m2_0 and cond_m6_m1 and cond_m7_0, lambda: eval_78()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0, lambda: eval_72()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0, lambda: eval_72()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_0, lambda: eval_76()),
			(cond_m2_m1 and cond_m3_0 and cond_m7_0, lambda: eval_76()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0, lambda: eval_72()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_0, lambda: eval_76()),
			(cond_m2_m1 and cond_m4_0 and cond_m7_0, lambda: eval_76()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1, lambda: eval_72()),
			(cond_m3_0 and cond_m4_0 and cond_m6_m1, lambda: eval_77()),
			(cond_m3_0 and cond_m4_0 and cond_m7_m1, lambda: eval_77()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0, lambda: eval_72()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_0, lambda: eval_76()),
			(cond_m3_0 and cond_m4_m1 and cond_m7_0, lambda: eval_76()),
			(cond_m3_0 and cond_m5_0 and cond_m6_m1, lambda: eval_77()),
			(cond_m3_0 and cond_m5_0 and cond_m7_m1, lambda: eval_77()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_0, lambda: eval_76()),
			(cond_m3_0 and cond_m5_m1 and cond_m7_0, lambda: eval_76()),
			(cond_m3_0 and cond_m6_0 and cond_m7_m1, lambda: eval_78()),
			(cond_m3_0 and cond_m6_m1 and cond_m7_0, lambda: eval_78()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0, lambda: eval_72()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_0, lambda: eval_76()),
			(cond_m3_m1 and cond_m4_0 and cond_m7_0, lambda: eval_76()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_0, lambda: eval_76()),
			(cond_m2_m1 and cond_m5_0 and cond_m7_0, lambda: eval_76()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_0, lambda: eval_76()),
			(cond_m3_m1 and cond_m5_0 and cond_m7_0, lambda: eval_76()),
			(cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_77()),
			(cond_m4_0 and cond_m5_0 and cond_m7_m1, lambda: eval_77()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_76()),
			(cond_m4_0 and cond_m5_m1 and cond_m7_0, lambda: eval_76()),
			(cond_m4_0 and cond_m6_0 and cond_m7_m1, lambda: eval_78()),
			(cond_m4_0 and cond_m6_m1 and cond_m7_0, lambda: eval_78()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_76()),
			(cond_m4_m1 and cond_m5_0 and cond_m7_0, lambda: eval_76()),
			(cond_m2_m1 and cond_m6_0 and cond_m7_0, lambda: eval_77()),
			(cond_m3_m1 and cond_m6_0 and cond_m7_0, lambda: eval_77()),
			(cond_m4_m1 and cond_m6_0 and cond_m7_0, lambda: eval_77()),
			(cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_78()),
			(cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_78()),
			(cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_77()),
			(cond_m1_0 and cond_m2_0, lambda: eval_77()),
			(cond_m1_0 and cond_m3_0, lambda: eval_77()),
			(cond_m1_0 and cond_m4_0, lambda: eval_77()),
			(cond_m1_0 and cond_m5_0, lambda: eval_77()),
			(cond_m1_0 and cond_m6_0, lambda: eval_78()),
			(cond_m1_0 and cond_m7_0, lambda: eval_78()),
			(cond_m2_0 and cond_m3_0, lambda: eval_77()),
			(cond_m2_0 and cond_m4_0, lambda: eval_77()),
			(cond_m2_0 and cond_m5_0, lambda: eval_77()),
			(cond_m2_0 and cond_m6_0, lambda: eval_78()),
			(cond_m2_0 and cond_m7_0, lambda: eval_78()),
			(cond_m3_0 and cond_m4_0, lambda: eval_77()),
			(cond_m3_0 and cond_m5_0, lambda: eval_77()),
			(cond_m3_0 and cond_m6_0, lambda: eval_78()),
			(cond_m3_0 and cond_m7_0, lambda: eval_78()),
			(cond_m4_0 and cond_m5_0, lambda: eval_77()),
			(cond_m4_0 and cond_m6_0, lambda: eval_78()),
			(cond_m4_0 and cond_m7_0, lambda: eval_78()),
			(cond_m5_0 and cond_m6_0, lambda: eval_78()),
			(cond_m5_0 and cond_m7_0, lambda: eval_78()),
			(cond_m6_0 and cond_m7_0, lambda: eval_78()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_64()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_64()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_64()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_64()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_64()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_23()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_24()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_68()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m6_m4 and cond_m7_m4, lambda: eval_69()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_69()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m6_m3 and cond_m7_m3, lambda: eval_69()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m2 and cond_m7_m3, lambda: eval_68()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3 and cond_m7_m2, lambda: eval_68()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m6_m5 and cond_m7_m5, lambda: eval_70()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m6_m4 and cond_m7_m4, lambda: eval_70()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m6_m2 and cond_m7_m4, lambda: eval_69()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m6_m4 and cond_m7_m2, lambda: eval_69()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m3 and cond_m7_m3, lambda: eval_70()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m6_m2 and cond_m7_m3, lambda: eval_69()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m6_m3 and cond_m7_m2, lambda: eval_69()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m6_m2 and cond_m7_m3, lambda: eval_69()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m6_m3 and cond_m7_m2, lambda: eval_69()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m2 and cond_m7_m2, lambda: eval_68()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m7_m6, lambda: eval_64()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m6_m2 and cond_m7_m5, lambda: eval_70()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m6_m5 and cond_m7_m2, lambda: eval_70()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_m4, lambda: eval_70()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m6_m4 and cond_m7_m2, lambda: eval_70()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m6_m2 and cond_m7_m2, lambda: eval_69()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_m3, lambda: eval_70()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m3 and cond_m7_m2, lambda: eval_70()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m6_m2 and cond_m7_m2, lambda: eval_69()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_69()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2, lambda: eval_64()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m7_m2, lambda: eval_64()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_70()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_70()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_70()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_68()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_68()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_68()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_68()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_25()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_26()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4 and cond_m6_m4 and cond_m7_m4, lambda: eval_69()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_69()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1 and cond_m6_m3 and cond_m7_m3, lambda: eval_69()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m1 and cond_m7_m3, lambda: eval_68()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3 and cond_m7_m1, lambda: eval_68()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m4, lambda: eval_69()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_69()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_69()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_27()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_28()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_69()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_69()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_68()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_68()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_69()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_69()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_27()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_28()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_69()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_68()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_68()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_69()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_27()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_28()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_68()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_68()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_27()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_28()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_64()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_64()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m6_m5 and cond_m7_m5, lambda: eval_70()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1 and cond_m6_m4 and cond_m7_m4, lambda: eval_70()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4 and cond_m6_m1 and cond_m7_m4, lambda: eval_69()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4 and cond_m6_m4 and cond_m7_m1, lambda: eval_69()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m3 and cond_m7_m3, lambda: eval_70()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3 and cond_m6_m1 and cond_m7_m3, lambda: eval_69()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3 and cond_m6_m3 and cond_m7_m1, lambda: eval_69()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1 and cond_m6_m1 and cond_m7_m3, lambda: eval_69()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1 and cond_m6_m3 and cond_m7_m1, lambda: eval_69()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m1 and cond_m7_m1, lambda: eval_68()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m6_m5 and cond_m7_m5, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1 and cond_m6_m4 and cond_m7_m4, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4 and cond_m6_m1 and cond_m7_m4, lambda: eval_69()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m1, lambda: eval_69()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4 and cond_m6_0 and cond_m7_m4, lambda: eval_29()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4 and cond_m6_m4 and cond_m7_0, lambda: eval_30()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m3 and cond_m7_m3, lambda: eval_70()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3 and cond_m6_m1 and cond_m7_m3, lambda: eval_69()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m1, lambda: eval_69()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_70()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_29()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_30()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0 and cond_m6_m1 and cond_m7_m3, lambda: eval_69()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0 and cond_m6_m3 and cond_m7_m1, lambda: eval_69()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1 and cond_m6_0 and cond_m7_m3, lambda: eval_29()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1 and cond_m6_m3 and cond_m7_0, lambda: eval_30()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3 and cond_m6_0 and cond_m7_m1, lambda: eval_31()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3 and cond_m6_m1 and cond_m7_0, lambda: eval_32()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_70()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_69()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_69()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_69()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_69()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_68()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_70()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_69()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_69()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_70()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_29()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_30()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_69()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_69()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_29()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_30()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_31()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_32()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_69()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_69()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_68()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_69()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_69()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_29()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_30()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_31()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_32()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_68()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_31()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_32()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m7_m6, lambda: eval_64()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m6_m1 and cond_m7_m5, lambda: eval_70()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m6_m5 and cond_m7_m1, lambda: eval_70()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m4, lambda: eval_70()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1 and cond_m6_m4 and cond_m7_m1, lambda: eval_70()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4 and cond_m6_m1 and cond_m7_m1, lambda: eval_69()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m3, lambda: eval_70()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m3 and cond_m7_m1, lambda: eval_70()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3 and cond_m6_m1 and cond_m7_m1, lambda: eval_69()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_69()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m7_m6, lambda: eval_64()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m6_m1 and cond_m7_m5, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m6_m5 and cond_m7_m1, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m4, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1 and cond_m6_m4 and cond_m7_m1, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4 and cond_m6_m1 and cond_m7_m1, lambda: eval_69()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m7_m6, lambda: eval_64()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m6_m1 and cond_m7_m5, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m6_m5 and cond_m7_m1, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m7_m6, lambda: eval_64()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m6_0 and cond_m7_m5, lambda: eval_67()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m6_m5 and cond_m7_0, lambda: eval_67()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m4, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0 and cond_m6_m4 and cond_m7_m1, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m4, lambda: eval_67()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1 and cond_m6_m4 and cond_m7_0, lambda: eval_67()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4 and cond_m6_0 and cond_m7_m1, lambda: eval_33()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4 and cond_m6_m1 and cond_m7_0, lambda: eval_34()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m3, lambda: eval_70()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m3 and cond_m7_m1, lambda: eval_70()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3 and cond_m6_m1 and cond_m7_m1, lambda: eval_69()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m3, lambda: eval_70()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m3 and cond_m7_m1, lambda: eval_70()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m3, lambda: eval_67()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m3 and cond_m7_0, lambda: eval_67()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3 and cond_m6_0 and cond_m7_m1, lambda: eval_33()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3 and cond_m6_m1 and cond_m7_0, lambda: eval_34()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_69()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_33()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_34()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_70()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_70()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_69()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_69()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_70()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_70()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_69()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_70()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_70()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_67()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_67()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_33()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_34()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_69()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_33()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_34()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_69()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_69()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_33()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_34()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_64()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m7_m1, lambda: eval_64()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_70()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_70()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_64()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m7_m1, lambda: eval_64()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_64()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m7_m1, lambda: eval_64()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_64()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m7_m1, lambda: eval_64()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_63()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m7_0, lambda: eval_63()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_35()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_36()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_35()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_36()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_70()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_70()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_35()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_36()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_70()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_70()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_70()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_35()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_36()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m4, lambda: eval_74()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_m5 and cond_m7_m5, lambda: eval_75()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_m4 and cond_m7_m4, lambda: eval_75()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_m3 and cond_m7_m4, lambda: eval_74()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m3, lambda: eval_74()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m7_m6, lambda: eval_68()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_m3 and cond_m7_m5, lambda: eval_75()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_m5 and cond_m7_m3, lambda: eval_75()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m4, lambda: eval_75()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_m4 and cond_m7_m3, lambda: eval_75()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_m3 and cond_m7_m3, lambda: eval_74()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3, lambda: eval_68()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m7_m3, lambda: eval_68()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_75()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_75()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_m5 and cond_m7_m5, lambda: eval_76()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_m5 and cond_m7_m5, lambda: eval_76()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_m4 and cond_m7_m4, lambda: eval_76()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_m2 and cond_m7_m4, lambda: eval_74()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m2, lambda: eval_74()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m7_m6, lambda: eval_69()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_m4 and cond_m7_m5, lambda: eval_76()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_m5 and cond_m7_m4, lambda: eval_76()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m7_m6, lambda: eval_69()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_m3 and cond_m7_m5, lambda: eval_76()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_m5 and cond_m7_m3, lambda: eval_76()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m7_m6, lambda: eval_69()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_m2 and cond_m7_m5, lambda: eval_75()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_m5 and cond_m7_m2, lambda: eval_75()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_m3 and cond_m7_m4, lambda: eval_76()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_m4 and cond_m7_m3, lambda: eval_76()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_m2 and cond_m7_m4, lambda: eval_75()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_m4 and cond_m7_m2, lambda: eval_75()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_m2 and cond_m7_m3, lambda: eval_74()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_m3 and cond_m7_m2, lambda: eval_74()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m6_m4, lambda: eval_69()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m7_m4, lambda: eval_69()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_m4 and cond_m7_m4, lambda: eval_76()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m6_m3, lambda: eval_69()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m7_m3, lambda: eval_69()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_m3 and cond_m7_m3, lambda: eval_76()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m6_m3, lambda: eval_69()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m7_m3, lambda: eval_69()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m2, lambda: eval_68()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m7_m2, lambda: eval_68()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_m2 and cond_m7_m3, lambda: eval_75()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_m3 and cond_m7_m2, lambda: eval_75()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_m3 and cond_m7_m3, lambda: eval_76()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_m2 and cond_m7_m3, lambda: eval_75()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m2, lambda: eval_75()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m7_m6, lambda: eval_70()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m7_m6, lambda: eval_70()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_m2 and cond_m7_m5, lambda: eval_76()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_m5 and cond_m7_m2, lambda: eval_76()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m7_m6, lambda: eval_70()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_m2 and cond_m7_m5, lambda: eval_76()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_m5 and cond_m7_m2, lambda: eval_76()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m4, lambda: eval_76()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_m4 and cond_m7_m2, lambda: eval_76()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_m2 and cond_m7_m2, lambda: eval_74()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m6_m5, lambda: eval_70()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m7_m5, lambda: eval_70()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m6_m4, lambda: eval_70()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m7_m4, lambda: eval_70()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m6_m2, lambda: eval_69()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m7_m2, lambda: eval_69()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_m2 and cond_m7_m4, lambda: eval_76()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_m4 and cond_m7_m2, lambda: eval_76()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m3, lambda: eval_70()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m7_m3, lambda: eval_70()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m6_m2, lambda: eval_69()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m7_m2, lambda: eval_69()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_m2 and cond_m7_m3, lambda: eval_76()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_m3 and cond_m7_m2, lambda: eval_76()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m6_m2, lambda: eval_69()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m7_m2, lambda: eval_69()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_m2 and cond_m7_m2, lambda: eval_75()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m3, lambda: eval_76()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_m3 and cond_m7_m2, lambda: eval_76()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_m2 and cond_m7_m2, lambda: eval_75()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_m2, lambda: eval_64()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m6_m2, lambda: eval_70()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m7_m2, lambda: eval_70()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m6_m2, lambda: eval_70()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m7_m2, lambda: eval_70()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_76()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2, lambda: eval_70()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m7_m2, lambda: eval_70()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_76()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_76()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m4, lambda: eval_74()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_m5 and cond_m7_m5, lambda: eval_75()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_m4 and cond_m7_m4, lambda: eval_75()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_m3 and cond_m7_m4, lambda: eval_74()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m3, lambda: eval_74()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m7_m6, lambda: eval_68()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_m3 and cond_m7_m5, lambda: eval_75()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_m5 and cond_m7_m3, lambda: eval_75()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m4, lambda: eval_75()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_m4 and cond_m7_m3, lambda: eval_75()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_m3 and cond_m7_m3, lambda: eval_74()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3, lambda: eval_68()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m7_m3, lambda: eval_68()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_75()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_75()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m4, lambda: eval_74()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_74()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_74()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_37()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_38()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_m5 and cond_m7_m5, lambda: eval_75()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_m4 and cond_m7_m4, lambda: eval_75()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_m2 and cond_m7_m4, lambda: eval_74()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m2, lambda: eval_74()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_75()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_75()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_0 and cond_m7_m4, lambda: eval_39()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_m4 and cond_m7_0, lambda: eval_40()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_m3 and cond_m7_m3, lambda: eval_75()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_m2 and cond_m7_m3, lambda: eval_74()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m2, lambda: eval_74()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_75()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_39()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_40()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_m2 and cond_m7_m3, lambda: eval_74()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_m3 and cond_m7_m2, lambda: eval_74()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_0 and cond_m7_m3, lambda: eval_39()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_m3 and cond_m7_0, lambda: eval_40()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_0 and cond_m7_m2, lambda: eval_68()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_m2 and cond_m7_0, lambda: eval_68()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m7_m6, lambda: eval_68()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_m2 and cond_m7_m5, lambda: eval_75()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_m5 and cond_m7_m2, lambda: eval_75()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m4, lambda: eval_75()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_m4 and cond_m7_m2, lambda: eval_75()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_m2 and cond_m7_m2, lambda: eval_74()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m7_m6, lambda: eval_68()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_m2 and cond_m7_m5, lambda: eval_75()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_m5 and cond_m7_m2, lambda: eval_75()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m7_m6, lambda: eval_68()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_0 and cond_m7_m5, lambda: eval_70()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_m5 and cond_m7_0, lambda: eval_70()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m4, lambda: eval_75()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_m4 and cond_m7_m2, lambda: eval_75()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m4, lambda: eval_70()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_m4 and cond_m7_0, lambda: eval_70()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_0 and cond_m7_m2, lambda: eval_41()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_m2 and cond_m7_0, lambda: eval_42()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m3, lambda: eval_75()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_m3 and cond_m7_m2, lambda: eval_75()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_m2 and cond_m7_m2, lambda: eval_74()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m3, lambda: eval_75()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_m3 and cond_m7_m2, lambda: eval_75()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m3, lambda: eval_70()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_m3 and cond_m7_0, lambda: eval_70()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_0 and cond_m7_m2, lambda: eval_41()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_m2 and cond_m7_0, lambda: eval_42()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_74()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_41()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_42()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2, lambda: eval_68()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m7_m2, lambda: eval_68()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_75()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_75()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_m2, lambda: eval_68()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m7_m2, lambda: eval_68()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_75()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_m2, lambda: eval_68()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m7_m2, lambda: eval_68()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_0, lambda: eval_64()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m7_0, lambda: eval_64()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_43()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_44()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_75()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_43()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_44()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_75()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_75()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_43()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_44()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_m5 and cond_m7_m5, lambda: eval_76()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_m5 and cond_m7_m5, lambda: eval_76()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_m4 and cond_m7_m4, lambda: eval_76()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_m1 and cond_m7_m4, lambda: eval_74()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m1, lambda: eval_74()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_76()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4 and cond_m7_m6, lambda: eval_69()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_m4 and cond_m7_m5, lambda: eval_76()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_m5 and cond_m7_m4, lambda: eval_76()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3 and cond_m7_m6, lambda: eval_69()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_m3 and cond_m7_m5, lambda: eval_76()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_m5 and cond_m7_m3, lambda: eval_76()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1 and cond_m7_m6, lambda: eval_69()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_m1 and cond_m7_m5, lambda: eval_75()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_m5 and cond_m7_m1, lambda: eval_75()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_m3 and cond_m7_m4, lambda: eval_76()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_m4 and cond_m7_m3, lambda: eval_76()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_m1 and cond_m7_m4, lambda: eval_75()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_m4 and cond_m7_m1, lambda: eval_75()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_m1 and cond_m7_m3, lambda: eval_74()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_m3 and cond_m7_m1, lambda: eval_74()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4 and cond_m7_m6, lambda: eval_69()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_m4 and cond_m7_m5, lambda: eval_76()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_m5 and cond_m7_m4, lambda: eval_76()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4 and cond_m6_m4, lambda: eval_69()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4 and cond_m7_m4, lambda: eval_69()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_m4 and cond_m7_m4, lambda: eval_76()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3 and cond_m6_m3, lambda: eval_69()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3 and cond_m7_m3, lambda: eval_69()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_m3 and cond_m7_m3, lambda: eval_76()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1 and cond_m6_m3, lambda: eval_69()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1 and cond_m7_m3, lambda: eval_69()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m1, lambda: eval_68()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m7_m1, lambda: eval_68()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_m1 and cond_m7_m3, lambda: eval_75()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_m3 and cond_m7_m1, lambda: eval_75()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_m3 and cond_m7_m3, lambda: eval_76()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_m1 and cond_m7_m3, lambda: eval_75()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m1, lambda: eval_75()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4 and cond_m6_m4, lambda: eval_69()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4 and cond_m7_m4, lambda: eval_69()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_76()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_76()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_m5 and cond_m7_m5, lambda: eval_76()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_m4 and cond_m7_m4, lambda: eval_76()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_m1 and cond_m7_m4, lambda: eval_74()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m1, lambda: eval_74()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_76()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_76()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_0 and cond_m7_m4, lambda: eval_45()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_m4 and cond_m7_0, lambda: eval_46()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_76()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_0 and cond_m7_m4, lambda: eval_45()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_m4 and cond_m7_0, lambda: eval_46()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_m3 and cond_m7_m3, lambda: eval_76()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_m1 and cond_m7_m3, lambda: eval_74()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m1, lambda: eval_74()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_76()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_45()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_46()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_m1 and cond_m7_m3, lambda: eval_74()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_m3 and cond_m7_m1, lambda: eval_74()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_0 and cond_m7_m3, lambda: eval_45()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_m3 and cond_m7_0, lambda: eval_46()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_0 and cond_m7_m1, lambda: eval_68()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_m1 and cond_m7_0, lambda: eval_68()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3 and cond_m7_m6, lambda: eval_69()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_m3 and cond_m7_m5, lambda: eval_76()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_m5 and cond_m7_m3, lambda: eval_76()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0 and cond_m7_m6, lambda: eval_69()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2 and cond_m7_m6, lambda: eval_69()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_m2 and cond_m7_m5, lambda: eval_76()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_m5 and cond_m7_m2, lambda: eval_76()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1 and cond_m7_m6, lambda: eval_69()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_m1 and cond_m7_m5, lambda: eval_75()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_m5 and cond_m7_m1, lambda: eval_75()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_m2 and cond_m7_m4, lambda: eval_76()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_m4 and cond_m7_m2, lambda: eval_76()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_m1 and cond_m7_m4, lambda: eval_75()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_m4 and cond_m7_m1, lambda: eval_75()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_m1 and cond_m7_m2, lambda: eval_74()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_m2 and cond_m7_m1, lambda: eval_74()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2 and cond_m7_m6, lambda: eval_69()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_m2 and cond_m7_m5, lambda: eval_76()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_m5 and cond_m7_m2, lambda: eval_76()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0 and cond_m7_m6, lambda: eval_69()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1 and cond_m7_m6, lambda: eval_69()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_m1 and cond_m7_m5, lambda: eval_75()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_m5 and cond_m7_m1, lambda: eval_75()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0 and cond_m7_m6, lambda: eval_69()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_0 and cond_m7_m5, lambda: eval_72()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_m5 and cond_m7_0, lambda: eval_72()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_m3 and cond_m7_m4, lambda: eval_76()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_m4 and cond_m7_m3, lambda: eval_76()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_0 and cond_m7_m4, lambda: eval_72()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_m4 and cond_m7_0, lambda: eval_72()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_0 and cond_m7_m3, lambda: eval_71()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_m3 and cond_m7_0, lambda: eval_71()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_0 and cond_m7_m5, lambda: eval_72()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_m5 and cond_m7_0, lambda: eval_72()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_m2 and cond_m7_m4, lambda: eval_76()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_m4 and cond_m7_m2, lambda: eval_76()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_0 and cond_m7_m4, lambda: eval_72()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_m4 and cond_m7_0, lambda: eval_72()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_0 and cond_m7_m2, lambda: eval_71()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_m2 and cond_m7_0, lambda: eval_71()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_0 and cond_m7_m5, lambda: eval_72()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_m5 and cond_m7_0, lambda: eval_72()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_m1 and cond_m7_m4, lambda: eval_75()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_m4 and cond_m7_m1, lambda: eval_75()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_0 and cond_m7_m4, lambda: eval_72()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_m4 and cond_m7_0, lambda: eval_72()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_0 and cond_m7_m1, lambda: eval_69()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_m1 and cond_m7_0, lambda: eval_69()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_m2 and cond_m7_m3, lambda: eval_76()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_m3 and cond_m7_m2, lambda: eval_76()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_m1 and cond_m7_m3, lambda: eval_75()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_m3 and cond_m7_m1, lambda: eval_75()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_m1 and cond_m7_m2, lambda: eval_74()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_m2 and cond_m7_m1, lambda: eval_74()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_m2 and cond_m7_m3, lambda: eval_76()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_m3 and cond_m7_m2, lambda: eval_76()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_0 and cond_m7_m3, lambda: eval_72()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_m3 and cond_m7_0, lambda: eval_72()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_0 and cond_m7_m2, lambda: eval_71()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_m2 and cond_m7_0, lambda: eval_71()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_m1 and cond_m7_m3, lambda: eval_75()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_m3 and cond_m7_m1, lambda: eval_75()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_0 and cond_m7_m3, lambda: eval_72()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_m3 and cond_m7_0, lambda: eval_72()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_0 and cond_m7_m1, lambda: eval_69()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_m1 and cond_m7_0, lambda: eval_69()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_74()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_74()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_71()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_71()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_69()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_69()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3 and cond_m6_m3, lambda: eval_69()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3 and cond_m7_m3, lambda: eval_69()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_76()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0 and cond_m6_m3, lambda: eval_69()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0 and cond_m7_m3, lambda: eval_69()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3 and cond_m6_0, lambda: eval_65()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2 and cond_m6_m2, lambda: eval_69()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2 and cond_m7_m2, lambda: eval_69()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_76()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1 and cond_m6_m2, lambda: eval_69()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1 and cond_m7_m2, lambda: eval_69()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m1, lambda: eval_68()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m7_m1, lambda: eval_68()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_75()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_75()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_76()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_75()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_75()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2 and cond_m6_m2, lambda: eval_69()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2 and cond_m7_m2, lambda: eval_69()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_76()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0 and cond_m6_m2, lambda: eval_69()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0 and cond_m7_m2, lambda: eval_69()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2 and cond_m6_0, lambda: eval_65()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1 and cond_m6_m2, lambda: eval_69()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1 and cond_m7_m2, lambda: eval_69()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_m1, lambda: eval_68()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m7_m1, lambda: eval_68()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_75()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_75()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0 and cond_m6_m2, lambda: eval_69()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0 and cond_m7_m2, lambda: eval_69()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2 and cond_m6_0, lambda: eval_65()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_m1, lambda: eval_68()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m7_m1, lambda: eval_68()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1 and cond_m6_0, lambda: eval_65()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3 and cond_m7_0, lambda: eval_65()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_47()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_48()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_76()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_47()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_48()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2 and cond_m7_0, lambda: eval_65()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_47()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_48()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_76()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_47()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_48()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2 and cond_m7_0, lambda: eval_65()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_47()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_48()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1 and cond_m7_0, lambda: eval_65()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_70()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_70()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_75()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_75()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_47()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_48()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_70()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_70()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_76()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_75()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_75()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_76()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_47()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_48()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_75()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_75()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_47()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_48()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_70()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_70()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m7_m6, lambda: eval_70()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1 and cond_m7_m6, lambda: eval_70()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_m1 and cond_m7_m5, lambda: eval_76()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_m5 and cond_m7_m1, lambda: eval_76()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1 and cond_m7_m6, lambda: eval_70()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_m1 and cond_m7_m5, lambda: eval_76()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_m5 and cond_m7_m1, lambda: eval_76()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m4, lambda: eval_76()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_m4 and cond_m7_m1, lambda: eval_76()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_m1 and cond_m7_m1, lambda: eval_74()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m7_m6, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1 and cond_m7_m6, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_m1 and cond_m7_m5, lambda: eval_76()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_m5 and cond_m7_m1, lambda: eval_76()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m7_m6, lambda: eval_70()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m6_m5, lambda: eval_70()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m7_m5, lambda: eval_70()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1 and cond_m6_m4, lambda: eval_70()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1 and cond_m7_m4, lambda: eval_70()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4 and cond_m6_m1, lambda: eval_69()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4 and cond_m7_m1, lambda: eval_69()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_m1 and cond_m7_m4, lambda: eval_76()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_m4 and cond_m7_m1, lambda: eval_76()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m3, lambda: eval_70()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1 and cond_m7_m3, lambda: eval_70()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3 and cond_m6_m1, lambda: eval_69()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3 and cond_m7_m1, lambda: eval_69()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_m1 and cond_m7_m3, lambda: eval_76()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_m3 and cond_m7_m1, lambda: eval_76()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1 and cond_m6_m1, lambda: eval_69()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1 and cond_m7_m1, lambda: eval_69()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_m1 and cond_m7_m1, lambda: eval_75()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m3, lambda: eval_76()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_m3 and cond_m7_m1, lambda: eval_76()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_m1 and cond_m7_m1, lambda: eval_75()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m6_m5, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m7_m5, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1 and cond_m6_m4, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1 and cond_m7_m4, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4 and cond_m6_m1, lambda: eval_69()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4 and cond_m7_m1, lambda: eval_69()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_m1 and cond_m7_m4, lambda: eval_76()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_m4 and cond_m7_m1, lambda: eval_76()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m6_m5, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m7_m5, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0 and cond_m7_m6, lambda: eval_70()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1 and cond_m7_m6, lambda: eval_70()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_m1 and cond_m7_m5, lambda: eval_76()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_m5 and cond_m7_m1, lambda: eval_76()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0 and cond_m7_m6, lambda: eval_70()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m7_m6, lambda: eval_70()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_m1 and cond_m7_m5, lambda: eval_76()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_m5 and cond_m7_m1, lambda: eval_76()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m4, lambda: eval_76()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_m4 and cond_m7_m1, lambda: eval_76()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_m1 and cond_m7_m1, lambda: eval_74()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m7_m6, lambda: eval_70()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_m1 and cond_m7_m5, lambda: eval_76()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_m5 and cond_m7_m1, lambda: eval_76()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m7_m6, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_0 and cond_m7_m5, lambda: eval_73()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_m5 and cond_m7_0, lambda: eval_73()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_0 and cond_m7_m5, lambda: eval_73()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_m5 and cond_m7_0, lambda: eval_73()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m4, lambda: eval_76()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_m4 and cond_m7_m1, lambda: eval_76()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m4, lambda: eval_73()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_m4 and cond_m7_0, lambda: eval_73()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_0 and cond_m7_m1, lambda: eval_49()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_m1 and cond_m7_0, lambda: eval_50()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_0 and cond_m7_m5, lambda: eval_73()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_m5 and cond_m7_0, lambda: eval_73()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m4, lambda: eval_76()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_m4 and cond_m7_m1, lambda: eval_76()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m4, lambda: eval_73()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_m4 and cond_m7_0, lambda: eval_73()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_0 and cond_m7_m1, lambda: eval_49()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_m1 and cond_m7_0, lambda: eval_50()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m3, lambda: eval_76()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_m3 and cond_m7_m1, lambda: eval_76()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_m1 and cond_m7_m1, lambda: eval_74()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m3, lambda: eval_76()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_m3 and cond_m7_m1, lambda: eval_76()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m3, lambda: eval_73()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_m3 and cond_m7_0, lambda: eval_73()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_0 and cond_m7_m1, lambda: eval_49()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_m1 and cond_m7_0, lambda: eval_50()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_74()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_49()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_50()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0 and cond_m6_m4, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0 and cond_m7_m4, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4 and cond_m6_0, lambda: eval_66()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m3, lambda: eval_70()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1 and cond_m7_m3, lambda: eval_70()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3 and cond_m6_m1, lambda: eval_69()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3 and cond_m7_m1, lambda: eval_69()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_m1 and cond_m7_m3, lambda: eval_76()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_m3 and cond_m7_m1, lambda: eval_76()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m3, lambda: eval_70()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0 and cond_m7_m3, lambda: eval_70()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3 and cond_m6_0, lambda: eval_66()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0 and cond_m6_m1, lambda: eval_69()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0 and cond_m7_m1, lambda: eval_69()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1 and cond_m6_0, lambda: eval_66()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m2, lambda: eval_70()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m7_m2, lambda: eval_70()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2 and cond_m6_m1, lambda: eval_69()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2 and cond_m7_m1, lambda: eval_69()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_76()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_76()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1 and cond_m6_m1, lambda: eval_69()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1 and cond_m7_m1, lambda: eval_69()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_75()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_76()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_76()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_75()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m2, lambda: eval_70()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m7_m2, lambda: eval_70()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2 and cond_m6_m1, lambda: eval_69()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2 and cond_m7_m1, lambda: eval_69()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_76()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_76()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m2, lambda: eval_70()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m7_m2, lambda: eval_70()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2 and cond_m6_0, lambda: eval_66()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0 and cond_m6_m1, lambda: eval_69()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0 and cond_m7_m1, lambda: eval_69()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1 and cond_m6_0, lambda: eval_66()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_69()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1 and cond_m7_m1, lambda: eval_69()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_75()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_69()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0 and cond_m7_m1, lambda: eval_69()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_66()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4 and cond_m7_0, lambda: eval_66()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_0 and cond_m7_m4, lambda: eval_73()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_m4 and cond_m7_0, lambda: eval_73()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3 and cond_m7_0, lambda: eval_66()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_0 and cond_m7_m3, lambda: eval_73()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_m3 and cond_m7_0, lambda: eval_73()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1 and cond_m7_0, lambda: eval_66()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_0 and cond_m7_m1, lambda: eval_51()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_m1 and cond_m7_0, lambda: eval_52()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m3, lambda: eval_76()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_m3 and cond_m7_m1, lambda: eval_76()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m3, lambda: eval_73()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_m3 and cond_m7_0, lambda: eval_73()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_0 and cond_m7_m1, lambda: eval_51()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_m1 and cond_m7_0, lambda: eval_52()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2 and cond_m7_0, lambda: eval_66()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_73()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_73()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1 and cond_m7_0, lambda: eval_66()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_51()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_52()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_76()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_76()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_73()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_73()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_51()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_52()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1 and cond_m7_0, lambda: eval_66()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_51()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_52()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_75()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_51()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_52()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_76()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_76()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_75()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_76()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_76()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_73()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_73()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_51()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_52()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_75()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_51()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_52()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1, lambda: eval_64()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m6_m1, lambda: eval_70()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m7_m1, lambda: eval_70()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_70()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1 and cond_m7_m1, lambda: eval_70()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_76()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_70()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1 and cond_m7_m1, lambda: eval_70()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_76()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_76()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_m1, lambda: eval_64()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m6_m1, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m7_m1, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1 and cond_m7_m1, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_76()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_m1, lambda: eval_64()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m6_m1, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m7_m1, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_0, lambda: eval_64()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m6_0, lambda: eval_67()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0 and cond_m7_m1, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_67()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_70()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1 and cond_m7_m1, lambda: eval_70()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_76()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_70()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0 and cond_m7_m1, lambda: eval_70()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_67()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_70()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m7_m1, lambda: eval_70()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_76()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_76()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_70()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m7_m1, lambda: eval_70()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_76()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_70()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m7_m1, lambda: eval_70()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_67()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m7_0, lambda: eval_67()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1 and cond_m7_0, lambda: eval_67()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_53()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_54()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1 and cond_m7_0, lambda: eval_67()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_53()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_54()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_76()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_53()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_54()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m7_0, lambda: eval_67()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_53()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_54()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_76()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_53()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_54()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_76()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_76()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_53()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_54()),
			(cond_m1_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_78()),
			(cond_m1_0 and cond_m5_m4 and cond_m7_m6, lambda: eval_74()),
			(cond_m1_0 and cond_m6_m4 and cond_m7_m5, lambda: eval_78()),
			(cond_m1_0 and cond_m6_m5 and cond_m7_m4, lambda: eval_78()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_m4, lambda: eval_74()),
			(cond_m1_0 and cond_m5_m4 and cond_m7_m4, lambda: eval_74()),
			(cond_m1_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_78()),
			(cond_m1_0 and cond_m4_m3 and cond_m7_m6, lambda: eval_75()),
			(cond_m1_0 and cond_m5_m3 and cond_m7_m6, lambda: eval_75()),
			(cond_m1_0 and cond_m6_m3 and cond_m7_m5, lambda: eval_78()),
			(cond_m1_0 and cond_m6_m5 and cond_m7_m3, lambda: eval_78()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_m5, lambda: eval_75()),
			(cond_m1_0 and cond_m4_m3 and cond_m7_m5, lambda: eval_75()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_m4, lambda: eval_75()),
			(cond_m1_0 and cond_m5_m3 and cond_m7_m4, lambda: eval_75()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_m3, lambda: eval_74()),
			(cond_m1_0 and cond_m5_m4 and cond_m7_m3, lambda: eval_74()),
			(cond_m1_0 and cond_m6_m3 and cond_m7_m4, lambda: eval_78()),
			(cond_m1_0 and cond_m6_m4 and cond_m7_m3, lambda: eval_78()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3, lambda: eval_68()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_m3, lambda: eval_75()),
			(cond_m1_0 and cond_m4_m3 and cond_m7_m3, lambda: eval_75()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_m3, lambda: eval_75()),
			(cond_m1_0 and cond_m5_m3 and cond_m7_m3, lambda: eval_75()),
			(cond_m1_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_78()),
			(cond_m1_0 and cond_m3_m2 and cond_m7_m6, lambda: eval_76()),
			(cond_m1_0 and cond_m4_m2 and cond_m7_m6, lambda: eval_76()),
			(cond_m1_0 and cond_m5_m2 and cond_m7_m6, lambda: eval_76()),
			(cond_m1_0 and cond_m6_m2 and cond_m7_m5, lambda: eval_78()),
			(cond_m1_0 and cond_m6_m5 and cond_m7_m2, lambda: eval_78()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_m5, lambda: eval_76()),
			(cond_m1_0 and cond_m3_m2 and cond_m7_m5, lambda: eval_76()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_m5, lambda: eval_76()),
			(cond_m1_0 and cond_m4_m2 and cond_m7_m5, lambda: eval_76()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_m4, lambda: eval_76()),
			(cond_m1_0 and cond_m5_m2 and cond_m7_m4, lambda: eval_76()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_m2, lambda: eval_74()),
			(cond_m1_0 and cond_m5_m4 and cond_m7_m2, lambda: eval_74()),
			(cond_m1_0 and cond_m6_m2 and cond_m7_m4, lambda: eval_78()),
			(cond_m1_0 and cond_m6_m4 and cond_m7_m2, lambda: eval_78()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4, lambda: eval_69()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_m4, lambda: eval_76()),
			(cond_m1_0 and cond_m3_m2 and cond_m7_m4, lambda: eval_76()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3, lambda: eval_69()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_m3, lambda: eval_76()),
			(cond_m1_0 and cond_m4_m2 and cond_m7_m3, lambda: eval_76()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2, lambda: eval_69()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_m2, lambda: eval_75()),
			(cond_m1_0 and cond_m4_m3 and cond_m7_m2, lambda: eval_75()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_m3, lambda: eval_76()),
			(cond_m1_0 and cond_m5_m2 and cond_m7_m3, lambda: eval_76()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_m2, lambda: eval_75()),
			(cond_m1_0 and cond_m5_m3 and cond_m7_m2, lambda: eval_75()),
			(cond_m1_0 and cond_m6_m2 and cond_m7_m3, lambda: eval_78()),
			(cond_m1_0 and cond_m6_m3 and cond_m7_m2, lambda: eval_78()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2, lambda: eval_70()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2, lambda: eval_70()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_m2, lambda: eval_76()),
			(cond_m1_0 and cond_m3_m2 and cond_m7_m2, lambda: eval_76()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2, lambda: eval_70()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_m2, lambda: eval_76()),
			(cond_m1_0 and cond_m4_m2 and cond_m7_m2, lambda: eval_76()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_m2, lambda: eval_76()),
			(cond_m1_0 and cond_m5_m2 and cond_m7_m2, lambda: eval_76()),
			(cond_m1_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_78()),
			(cond_m2_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_78()),
			(cond_m2_0 and cond_m5_m4 and cond_m7_m6, lambda: eval_74()),
			(cond_m2_0 and cond_m6_m4 and cond_m7_m5, lambda: eval_78()),
			(cond_m2_0 and cond_m6_m5 and cond_m7_m4, lambda: eval_78()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_m4, lambda: eval_74()),
			(cond_m2_0 and cond_m5_m4 and cond_m7_m4, lambda: eval_74()),
			(cond_m2_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_78()),
			(cond_m2_0 and cond_m4_m3 and cond_m7_m6, lambda: eval_75()),
			(cond_m2_0 and cond_m5_m3 and cond_m7_m6, lambda: eval_75()),
			(cond_m2_0 and cond_m6_m3 and cond_m7_m5, lambda: eval_78()),
			(cond_m2_0 and cond_m6_m5 and cond_m7_m3, lambda: eval_78()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_m5, lambda: eval_75()),
			(cond_m2_0 and cond_m4_m3 and cond_m7_m5, lambda: eval_75()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_m4, lambda: eval_75()),
			(cond_m2_0 and cond_m5_m3 and cond_m7_m4, lambda: eval_75()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_m3, lambda: eval_74()),
			(cond_m2_0 and cond_m5_m4 and cond_m7_m3, lambda: eval_74()),
			(cond_m2_0 and cond_m6_m3 and cond_m7_m4, lambda: eval_78()),
			(cond_m2_0 and cond_m6_m4 and cond_m7_m3, lambda: eval_78()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3, lambda: eval_68()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_m3, lambda: eval_75()),
			(cond_m2_0 and cond_m4_m3 and cond_m7_m3, lambda: eval_75()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_m3, lambda: eval_75()),
			(cond_m2_0 and cond_m5_m3 and cond_m7_m3, lambda: eval_75()),
			(cond_m2_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_78()),
			(cond_m3_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_78()),
			(cond_m3_0 and cond_m5_m4 and cond_m7_m6, lambda: eval_74()),
			(cond_m3_0 and cond_m6_m4 and cond_m7_m5, lambda: eval_78()),
			(cond_m3_0 and cond_m6_m5 and cond_m7_m4, lambda: eval_78()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_m4, lambda: eval_74()),
			(cond_m3_0 and cond_m5_m4 and cond_m7_m4, lambda: eval_74()),
			(cond_m3_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_78()),
			(cond_m4_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_78()),
			(cond_m5_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_78()),
			(cond_m5_m4 and cond_m6_0 and cond_m7_m4, lambda: eval_55()),
			(cond_m5_m4 and cond_m6_m4 and cond_m7_0, lambda: eval_56()),
			(cond_m4_0 and cond_m5_m3 and cond_m7_m6, lambda: eval_74()),
			(cond_m4_0 and cond_m6_m3 and cond_m7_m5, lambda: eval_78()),
			(cond_m4_0 and cond_m6_m5 and cond_m7_m3, lambda: eval_78()),
			(cond_m4_m3 and cond_m5_0 and cond_m7_m6, lambda: eval_74()),
			(cond_m4_m3 and cond_m6_0 and cond_m7_m5, lambda: eval_75()),
			(cond_m4_m3 and cond_m6_m5 and cond_m7_0, lambda: eval_75()),
			(cond_m5_0 and cond_m6_m3 and cond_m7_m4, lambda: eval_78()),
			(cond_m5_0 and cond_m6_m4 and cond_m7_m3, lambda: eval_78()),
			(cond_m5_m3 and cond_m6_0 and cond_m7_m4, lambda: eval_75()),
			(cond_m5_m3 and cond_m6_m4 and cond_m7_0, lambda: eval_75()),
			(cond_m5_m4 and cond_m6_0 and cond_m7_m3, lambda: eval_74()),
			(cond_m5_m4 and cond_m6_m3 and cond_m7_0, lambda: eval_74()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_m3, lambda: eval_74()),
			(cond_m4_0 and cond_m5_m3 and cond_m7_m3, lambda: eval_74()),
			(cond_m4_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_78()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_m3, lambda: eval_74()),
			(cond_m4_m3 and cond_m5_0 and cond_m7_m3, lambda: eval_74()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_0, lambda: eval_68()),
			(cond_m4_m3 and cond_m5_m3 and cond_m7_0, lambda: eval_68()),
			(cond_m4_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_57()),
			(cond_m4_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_58()),
			(cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_78()),
			(cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_57()),
			(cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_58()),
			(cond_m3_0 and cond_m4_m2 and cond_m7_m6, lambda: eval_75()),
			(cond_m3_0 and cond_m5_m2 and cond_m7_m6, lambda: eval_75()),
			(cond_m3_0 and cond_m6_m2 and cond_m7_m5, lambda: eval_78()),
			(cond_m3_0 and cond_m6_m5 and cond_m7_m2, lambda: eval_78()),
			(cond_m3_m2 and cond_m4_0 and cond_m7_m6, lambda: eval_75()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_m5, lambda: eval_75()),
			(cond_m3_0 and cond_m4_m2 and cond_m7_m5, lambda: eval_75()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_m4, lambda: eval_75()),
			(cond_m3_0 and cond_m5_m2 and cond_m7_m4, lambda: eval_75()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_m2, lambda: eval_74()),
			(cond_m3_0 and cond_m5_m4 and cond_m7_m2, lambda: eval_74()),
			(cond_m3_0 and cond_m6_m2 and cond_m7_m4, lambda: eval_78()),
			(cond_m3_0 and cond_m6_m4 and cond_m7_m2, lambda: eval_78()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_m5, lambda: eval_75()),
			(cond_m3_m2 and cond_m4_0 and cond_m7_m5, lambda: eval_75()),
			(cond_m3_m2 and cond_m5_0 and cond_m7_m6, lambda: eval_75()),
			(cond_m4_0 and cond_m5_m2 and cond_m7_m6, lambda: eval_75()),
			(cond_m4_0 and cond_m6_m2 and cond_m7_m5, lambda: eval_78()),
			(cond_m4_0 and cond_m6_m5 and cond_m7_m2, lambda: eval_78()),
			(cond_m4_m2 and cond_m5_0 and cond_m7_m6, lambda: eval_75()),
			(cond_m3_m2 and cond_m6_0 and cond_m7_m5, lambda: eval_76()),
			(cond_m3_m2 and cond_m6_m5 and cond_m7_0, lambda: eval_76()),
			(cond_m4_m2 and cond_m6_0 and cond_m7_m5, lambda: eval_76()),
			(cond_m4_m2 and cond_m6_m5 and cond_m7_0, lambda: eval_76()),
			(cond_m5_0 and cond_m6_m2 and cond_m7_m4, lambda: eval_78()),
			(cond_m5_0 and cond_m6_m4 and cond_m7_m2, lambda: eval_78()),
			(cond_m5_m2 and cond_m6_0 and cond_m7_m4, lambda: eval_76()),
			(cond_m5_m2 and cond_m6_m4 and cond_m7_0, lambda: eval_76()),
			(cond_m5_m4 and cond_m6_0 and cond_m7_m2, lambda: eval_74()),
			(cond_m5_m4 and cond_m6_m2 and cond_m7_0, lambda: eval_74()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_m4, lambda: eval_75()),
			(cond_m3_m2 and cond_m5_0 and cond_m7_m4, lambda: eval_75()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_0, lambda: eval_69()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_m3, lambda: eval_75()),
			(cond_m4_0 and cond_m5_m2 and cond_m7_m3, lambda: eval_75()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_m2, lambda: eval_74()),
			(cond_m4_0 and cond_m5_m3 and cond_m7_m2, lambda: eval_74()),
			(cond_m4_0 and cond_m6_m2 and cond_m7_m3, lambda: eval_78()),
			(cond_m4_0 and cond_m6_m3 and cond_m7_m2, lambda: eval_78()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_m3, lambda: eval_75()),
			(cond_m4_m2 and cond_m5_0 and cond_m7_m3, lambda: eval_75()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_0, lambda: eval_69()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_m2, lambda: eval_74()),
			(cond_m4_m3 and cond_m5_0 and cond_m7_m2, lambda: eval_74()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_0, lambda: eval_69()),
			(cond_m3_m2 and cond_m5_m4 and cond_m7_0, lambda: eval_69()),
			(cond_m3_m2 and cond_m6_0 and cond_m7_m4, lambda: eval_76()),
			(cond_m3_m2 and cond_m6_m4 and cond_m7_0, lambda: eval_76()),
			(cond_m4_m2 and cond_m5_m3 and cond_m7_0, lambda: eval_69()),
			(cond_m4_m2 and cond_m6_0 and cond_m7_m3, lambda: eval_76()),
			(cond_m4_m2 and cond_m6_m3 and cond_m7_0, lambda: eval_76()),
			(cond_m4_m3 and cond_m5_m2 and cond_m7_0, lambda: eval_69()),
			(cond_m4_m3 and cond_m6_0 and cond_m7_m2, lambda: eval_75()),
			(cond_m4_m3 and cond_m6_m2 and cond_m7_0, lambda: eval_75()),
			(cond_m5_0 and cond_m6_m2 and cond_m7_m3, lambda: eval_78()),
			(cond_m5_0 and cond_m6_m3 and cond_m7_m2, lambda: eval_78()),
			(cond_m5_m2 and cond_m6_0 and cond_m7_m3, lambda: eval_76()),
			(cond_m5_m2 and cond_m6_m3 and cond_m7_0, lambda: eval_76()),
			(cond_m5_m3 and cond_m6_0 and cond_m7_m2, lambda: eval_75()),
			(cond_m5_m3 and cond_m6_m2 and cond_m7_0, lambda: eval_75()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2, lambda: eval_68()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_m2, lambda: eval_75()),
			(cond_m3_0 and cond_m4_m2 and cond_m7_m2, lambda: eval_75()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_m2, lambda: eval_75()),
			(cond_m3_0 and cond_m5_m2 and cond_m7_m2, lambda: eval_75()),
			(cond_m3_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_78()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2, lambda: eval_68()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_m2, lambda: eval_75()),
			(cond_m3_m2 and cond_m4_0 and cond_m7_m2, lambda: eval_75()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0, lambda: eval_68()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_0, lambda: eval_70()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_m2, lambda: eval_75()),
			(cond_m3_m2 and cond_m5_0 and cond_m7_m2, lambda: eval_75()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_0, lambda: eval_70()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_m2, lambda: eval_75()),
			(cond_m4_0 and cond_m5_m2 and cond_m7_m2, lambda: eval_75()),
			(cond_m4_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_78()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_m2, lambda: eval_75()),
			(cond_m4_m2 and cond_m5_0 and cond_m7_m2, lambda: eval_75()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_0, lambda: eval_70()),
			(cond_m3_m2 and cond_m4_m2 and cond_m7_0, lambda: eval_70()),
			(cond_m3_m2 and cond_m5_m2 and cond_m7_0, lambda: eval_70()),
			(cond_m3_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_59()),
			(cond_m3_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_60()),
			(cond_m4_m2 and cond_m5_m2 and cond_m7_0, lambda: eval_70()),
			(cond_m4_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_59()),
			(cond_m4_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_60()),
			(cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_78()),
			(cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_59()),
			(cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_60()),
			(cond_m2_0 and cond_m3_m1 and cond_m7_m6, lambda: eval_76()),
			(cond_m2_0 and cond_m4_m1 and cond_m7_m6, lambda: eval_76()),
			(cond_m2_0 and cond_m5_m1 and cond_m7_m6, lambda: eval_76()),
			(cond_m2_0 and cond_m6_m1 and cond_m7_m5, lambda: eval_78()),
			(cond_m2_0 and cond_m6_m5 and cond_m7_m1, lambda: eval_78()),
			(cond_m2_m1 and cond_m3_0 and cond_m7_m6, lambda: eval_76()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_m5, lambda: eval_76()),
			(cond_m2_0 and cond_m3_m1 and cond_m7_m5, lambda: eval_76()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_m5, lambda: eval_76()),
			(cond_m2_0 and cond_m4_m1 and cond_m7_m5, lambda: eval_76()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_m4, lambda: eval_76()),
			(cond_m2_0 and cond_m5_m1 and cond_m7_m4, lambda: eval_76()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_m1, lambda: eval_74()),
			(cond_m2_0 and cond_m5_m4 and cond_m7_m1, lambda: eval_74()),
			(cond_m2_0 and cond_m6_m1 and cond_m7_m4, lambda: eval_78()),
			(cond_m2_0 and cond_m6_m4 and cond_m7_m1, lambda: eval_78()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_m5, lambda: eval_76()),
			(cond_m2_m1 and cond_m3_0 and cond_m7_m5, lambda: eval_76()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4, lambda: eval_69()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_m4, lambda: eval_76()),
			(cond_m2_0 and cond_m3_m1 and cond_m7_m4, lambda: eval_76()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3, lambda: eval_69()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_m3, lambda: eval_76()),
			(cond_m2_0 and cond_m4_m1 and cond_m7_m3, lambda: eval_76()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1, lambda: eval_69()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_m1, lambda: eval_75()),
			(cond_m2_0 and cond_m4_m3 and cond_m7_m1, lambda: eval_75()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_m3, lambda: eval_76()),
			(cond_m2_0 and cond_m5_m1 and cond_m7_m3, lambda: eval_76()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_m1, lambda: eval_75()),
			(cond_m2_0 and cond_m5_m3 and cond_m7_m1, lambda: eval_75()),
			(cond_m2_0 and cond_m6_m1 and cond_m7_m3, lambda: eval_78()),
			(cond_m2_0 and cond_m6_m3 and cond_m7_m1, lambda: eval_78()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4, lambda: eval_69()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_m4, lambda: eval_76()),
			(cond_m2_m1 and cond_m3_0 and cond_m7_m4, lambda: eval_76()),
			(cond_m2_m1 and cond_m4_0 and cond_m7_m6, lambda: eval_76()),
			(cond_m3_0 and cond_m4_m1 and cond_m7_m6, lambda: eval_76()),
			(cond_m3_0 and cond_m5_m1 and cond_m7_m6, lambda: eval_76()),
			(cond_m3_0 and cond_m6_m1 and cond_m7_m5, lambda: eval_78()),
			(cond_m3_0 and cond_m6_m5 and cond_m7_m1, lambda: eval_78()),
			(cond_m3_m1 and cond_m4_0 and cond_m7_m6, lambda: eval_76()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_m5, lambda: eval_76()),
			(cond_m2_m1 and cond_m4_0 and cond_m7_m5, lambda: eval_76()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_m5, lambda: eval_76()),
			(cond_m3_0 and cond_m4_m1 and cond_m7_m5, lambda: eval_76()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_m4, lambda: eval_76()),
			(cond_m3_0 and cond_m5_m1 and cond_m7_m4, lambda: eval_76()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_m1, lambda: eval_74()),
			(cond_m3_0 and cond_m5_m4 and cond_m7_m1, lambda: eval_74()),
			(cond_m3_0 and cond_m6_m1 and cond_m7_m4, lambda: eval_78()),
			(cond_m3_0 and cond_m6_m4 and cond_m7_m1, lambda: eval_78()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_m5, lambda: eval_76()),
			(cond_m3_m1 and cond_m4_0 and cond_m7_m5, lambda: eval_76()),
			(cond_m2_m1 and cond_m5_0 and cond_m7_m6, lambda: eval_76()),
			(cond_m3_m1 and cond_m5_0 and cond_m7_m6, lambda: eval_76()),
			(cond_m4_0 and cond_m5_m1 and cond_m7_m6, lambda: eval_76()),
			(cond_m4_0 and cond_m6_m1 and cond_m7_m5, lambda: eval_78()),
			(cond_m4_0 and cond_m6_m5 and cond_m7_m1, lambda: eval_78()),
			(cond_m4_m1 and cond_m5_0 and cond_m7_m6, lambda: eval_76()),
			(cond_m2_m1 and cond_m6_0 and cond_m7_m5, lambda: eval_77()),
			(cond_m2_m1 and cond_m6_m5 and cond_m7_0, lambda: eval_77()),
			(cond_m3_m1 and cond_m6_0 and cond_m7_m5, lambda: eval_77()),
			(cond_m3_m1 and cond_m6_m5 and cond_m7_0, lambda: eval_77()),
			(cond_m4_m1 and cond_m6_0 and cond_m7_m5, lambda: eval_77()),
			(cond_m4_m1 and cond_m6_m5 and cond_m7_0, lambda: eval_77()),
			(cond_m5_0 and cond_m6_m1 and cond_m7_m4, lambda: eval_78()),
			(cond_m5_0 and cond_m6_m4 and cond_m7_m1, lambda: eval_78()),
			(cond_m5_m1 and cond_m6_0 and cond_m7_m4, lambda: eval_77()),
			(cond_m5_m1 and cond_m6_m4 and cond_m7_0, lambda: eval_77()),
			(cond_m5_m4 and cond_m6_0 and cond_m7_m1, lambda: eval_74()),
			(cond_m5_m4 and cond_m6_m1 and cond_m7_0, lambda: eval_74()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_m4, lambda: eval_76()),
			(cond_m2_m1 and cond_m5_0 and cond_m7_m4, lambda: eval_76()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_0, lambda: eval_71()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_m4, lambda: eval_76()),
			(cond_m3_m1 and cond_m5_0 and cond_m7_m4, lambda: eval_76()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_0, lambda: eval_71()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_m3, lambda: eval_76()),
			(cond_m4_0 and cond_m5_m1 and cond_m7_m3, lambda: eval_76()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_m1, lambda: eval_74()),
			(cond_m4_0 and cond_m5_m3 and cond_m7_m1, lambda: eval_74()),
			(cond_m4_0 and cond_m6_m1 and cond_m7_m3, lambda: eval_78()),
			(cond_m4_0 and cond_m6_m3 and cond_m7_m1, lambda: eval_78()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_m3, lambda: eval_76()),
			(cond_m4_m1 and cond_m5_0 and cond_m7_m3, lambda: eval_76()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_0, lambda: eval_71()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_m1, lambda: eval_74()),
			(cond_m4_m3 and cond_m5_0 and cond_m7_m1, lambda: eval_74()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_0, lambda: eval_71()),
			(cond_m2_m1 and cond_m5_m4 and cond_m7_0, lambda: eval_71()),
			(cond_m2_m1 and cond_m6_0 and cond_m7_m4, lambda: eval_77()),
			(cond_m2_m1 and cond_m6_m4 and cond_m7_0, lambda: eval_77()),
			(cond_m3_m1 and cond_m5_m4 and cond_m7_0, lambda: eval_71()),
			(cond_m3_m1 and cond_m6_0 and cond_m7_m4, lambda: eval_77()),
			(cond_m3_m1 and cond_m6_m4 and cond_m7_0, lambda: eval_77()),
			(cond_m4_m1 and cond_m5_m3 and cond_m7_0, lambda: eval_71()),
			(cond_m4_m1 and cond_m6_0 and cond_m7_m3, lambda: eval_77()),
			(cond_m4_m1 and cond_m6_m3 and cond_m7_0, lambda: eval_77()),
			(cond_m4_m3 and cond_m5_m1 and cond_m7_0, lambda: eval_71()),
			(cond_m4_m3 and cond_m6_0 and cond_m7_m1, lambda: eval_75()),
			(cond_m4_m3 and cond_m6_m1 and cond_m7_0, lambda: eval_75()),
			(cond_m5_0 and cond_m6_m1 and cond_m7_m3, lambda: eval_78()),
			(cond_m5_0 and cond_m6_m3 and cond_m7_m1, lambda: eval_78()),
			(cond_m5_m1 and cond_m6_0 and cond_m7_m3, lambda: eval_77()),
			(cond_m5_m1 and cond_m6_m3 and cond_m7_0, lambda: eval_77()),
			(cond_m5_m3 and cond_m6_0 and cond_m7_m1, lambda: eval_75()),
			(cond_m5_m3 and cond_m6_m1 and cond_m7_0, lambda: eval_75()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3, lambda: eval_69()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_m3, lambda: eval_76()),
			(cond_m2_m1 and cond_m4_0 and cond_m7_m3, lambda: eval_76()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0, lambda: eval_69()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2, lambda: eval_69()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_m2, lambda: eval_76()),
			(cond_m3_0 and cond_m4_m1 and cond_m7_m2, lambda: eval_76()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1, lambda: eval_69()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_m1, lambda: eval_75()),
			(cond_m3_0 and cond_m4_m2 and cond_m7_m1, lambda: eval_75()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_m2, lambda: eval_76()),
			(cond_m3_0 and cond_m5_m1 and cond_m7_m2, lambda: eval_76()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_m1, lambda: eval_75()),
			(cond_m3_0 and cond_m5_m2 and cond_m7_m1, lambda: eval_75()),
			(cond_m3_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_78()),
			(cond_m3_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_78()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2, lambda: eval_69()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_m2, lambda: eval_76()),
			(cond_m3_m1 and cond_m4_0 and cond_m7_m2, lambda: eval_76()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0, lambda: eval_69()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1, lambda: eval_69()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_m1, lambda: eval_75()),
			(cond_m3_m2 and cond_m4_0 and cond_m7_m1, lambda: eval_75()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0, lambda: eval_69()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_0, lambda: eval_72()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_m3, lambda: eval_76()),
			(cond_m2_m1 and cond_m5_0 and cond_m7_m3, lambda: eval_76()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_0, lambda: eval_72()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_0, lambda: eval_72()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_m2, lambda: eval_76()),
			(cond_m3_m1 and cond_m5_0 and cond_m7_m2, lambda: eval_76()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_0, lambda: eval_72()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_0, lambda: eval_72()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_m1, lambda: eval_75()),
			(cond_m3_m2 and cond_m5_0 and cond_m7_m1, lambda: eval_75()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_0, lambda: eval_72()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_m2, lambda: eval_76()),
			(cond_m4_0 and cond_m5_m1 and cond_m7_m2, lambda: eval_76()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_m1, lambda: eval_75()),
			(cond_m4_0 and cond_m5_m2 and cond_m7_m1, lambda: eval_75()),
			(cond_m4_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_78()),
			(cond_m4_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_78()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_m2, lambda: eval_76()),
			(cond_m4_m1 and cond_m5_0 and cond_m7_m2, lambda: eval_76()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_0, lambda: eval_72()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_m1, lambda: eval_75()),
			(cond_m4_m2 and cond_m5_0 and cond_m7_m1, lambda: eval_75()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_0, lambda: eval_72()),
			(cond_m2_m1 and cond_m4_m3 and cond_m7_0, lambda: eval_72()),
			(cond_m2_m1 and cond_m5_m3 and cond_m7_0, lambda: eval_72()),
			(cond_m2_m1 and cond_m6_0 and cond_m7_m3, lambda: eval_77()),
			(cond_m2_m1 and cond_m6_m3 and cond_m7_0, lambda: eval_77()),
			(cond_m3_m1 and cond_m4_m2 and cond_m7_0, lambda: eval_72()),
			(cond_m3_m1 and cond_m5_m2 and cond_m7_0, lambda: eval_72()),
			(cond_m3_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_77()),
			(cond_m3_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_77()),
			(cond_m3_m2 and cond_m4_m1 and cond_m7_0, lambda: eval_72()),
			(cond_m3_m2 and cond_m5_m1 and cond_m7_0, lambda: eval_72()),
			(cond_m3_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_76()),
			(cond_m3_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_76()),
			(cond_m4_m1 and cond_m5_m2 and cond_m7_0, lambda: eval_72()),
			(cond_m4_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_77()),
			(cond_m4_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_77()),
			(cond_m4_m2 and cond_m5_m1 and cond_m7_0, lambda: eval_72()),
			(cond_m4_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_76()),
			(cond_m4_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_76()),
			(cond_m5_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_78()),
			(cond_m5_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_78()),
			(cond_m5_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_77()),
			(cond_m5_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_77()),
			(cond_m5_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_76()),
			(cond_m5_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_76()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1, lambda: eval_70()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1, lambda: eval_70()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_m1, lambda: eval_76()),
			(cond_m2_0 and cond_m3_m1 and cond_m7_m1, lambda: eval_76()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1, lambda: eval_70()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_m1, lambda: eval_76()),
			(cond_m2_0 and cond_m4_m1 and cond_m7_m1, lambda: eval_76()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_76()),
			(cond_m2_0 and cond_m5_m1 and cond_m7_m1, lambda: eval_76()),
			(cond_m2_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_78()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_m1, lambda: eval_76()),
			(cond_m2_m1 and cond_m3_0 and cond_m7_m1, lambda: eval_76()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0, lambda: eval_70()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1, lambda: eval_70()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_m1, lambda: eval_76()),
			(cond_m2_m1 and cond_m4_0 and cond_m7_m1, lambda: eval_76()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0, lambda: eval_70()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1, lambda: eval_70()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_m1, lambda: eval_76()),
			(cond_m3_0 and cond_m4_m1 and cond_m7_m1, lambda: eval_76()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_76()),
			(cond_m3_0 and cond_m5_m1 and cond_m7_m1, lambda: eval_76()),
			(cond_m3_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_78()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1, lambda: eval_70()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_m1, lambda: eval_76()),
			(cond_m3_m1 and cond_m4_0 and cond_m7_m1, lambda: eval_76()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_0, lambda: eval_73()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_0, lambda: eval_73()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_76()),
			(cond_m2_m1 and cond_m5_0 and cond_m7_m1, lambda: eval_76()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_73()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_0, lambda: eval_73()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_76()),
			(cond_m3_m1 and cond_m5_0 and cond_m7_m1, lambda: eval_76()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_73()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_76()),
			(cond_m4_0 and cond_m5_m1 and cond_m7_m1, lambda: eval_76()),
			(cond_m4_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_78()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_76()),
			(cond_m4_m1 and cond_m5_0 and cond_m7_m1, lambda: eval_76()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_73()),
			(cond_m2_m1 and cond_m3_m1 and cond_m7_0, lambda: eval_73()),
			(cond_m2_m1 and cond_m4_m1 and cond_m7_0, lambda: eval_73()),
			(cond_m2_m1 and cond_m5_m1 and cond_m7_0, lambda: eval_73()),
			(cond_m2_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_61()),
			(cond_m2_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_62()),
			(cond_m3_m1 and cond_m4_m1 and cond_m7_0, lambda: eval_73()),
			(cond_m3_m1 and cond_m5_m1 and cond_m7_0, lambda: eval_73()),
			(cond_m3_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_61()),
			(cond_m3_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_62()),
			(cond_m4_m1 and cond_m5_m1 and cond_m7_0, lambda: eval_73()),
			(cond_m4_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_61()),
			(cond_m4_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_62()),
			(cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_78()),
			(cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_61()),
			(cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_62()),
			(cond_m1_0 and cond_m7_m6, lambda: eval_78()),
			(cond_m1_0 and cond_m6_m5, lambda: eval_78()),
			(cond_m1_0 and cond_m7_m5, lambda: eval_78()),
			(cond_m1_0 and cond_m5_m4, lambda: eval_74()),
			(cond_m1_0 and cond_m6_m4, lambda: eval_78()),
			(cond_m1_0 and cond_m7_m4, lambda: eval_78()),
			(cond_m1_0 and cond_m4_m3, lambda: eval_75()),
			(cond_m1_0 and cond_m5_m3, lambda: eval_75()),
			(cond_m1_0 and cond_m6_m3, lambda: eval_78()),
			(cond_m1_0 and cond_m7_m3, lambda: eval_78()),
			(cond_m1_0 and cond_m3_m2, lambda: eval_76()),
			(cond_m1_0 and cond_m4_m2, lambda: eval_76()),
			(cond_m1_0 and cond_m5_m2, lambda: eval_76()),
			(cond_m1_0 and cond_m6_m2, lambda: eval_78()),
			(cond_m1_0 and cond_m7_m2, lambda: eval_78()),
			(cond_m2_0 and cond_m7_m6, lambda: eval_78()),
			(cond_m2_0 and cond_m6_m5, lambda: eval_78()),
			(cond_m2_0 and cond_m7_m5, lambda: eval_78()),
			(cond_m2_0 and cond_m5_m4, lambda: eval_74()),
			(cond_m2_0 and cond_m6_m4, lambda: eval_78()),
			(cond_m2_0 and cond_m7_m4, lambda: eval_78()),
			(cond_m2_0 and cond_m4_m3, lambda: eval_75()),
			(cond_m2_0 and cond_m5_m3, lambda: eval_75()),
			(cond_m2_0 and cond_m6_m3, lambda: eval_78()),
			(cond_m2_0 and cond_m7_m3, lambda: eval_78()),
			(cond_m3_0 and cond_m7_m6, lambda: eval_78()),
			(cond_m3_0 and cond_m6_m5, lambda: eval_78()),
			(cond_m3_0 and cond_m7_m5, lambda: eval_78()),
			(cond_m3_0 and cond_m5_m4, lambda: eval_74()),
			(cond_m3_0 and cond_m6_m4, lambda: eval_78()),
			(cond_m3_0 and cond_m7_m4, lambda: eval_78()),
			(cond_m4_0 and cond_m7_m6, lambda: eval_78()),
			(cond_m4_0 and cond_m6_m5, lambda: eval_78()),
			(cond_m4_0 and cond_m7_m5, lambda: eval_78()),
			(cond_m5_0 and cond_m7_m6, lambda: eval_78()),
			(cond_m6_0 and cond_m7_m5, lambda: eval_78()),
			(cond_m6_m5 and cond_m7_0, lambda: eval_78()),
			(cond_m5_0 and cond_m6_m4, lambda: eval_78()),
			(cond_m5_0 and cond_m7_m4, lambda: eval_78()),
			(cond_m5_m4 and cond_m6_0, lambda: eval_74()),
			(cond_m5_m4 and cond_m7_0, lambda: eval_74()),
			(cond_m6_0 and cond_m7_m4, lambda: eval_78()),
			(cond_m6_m4 and cond_m7_0, lambda: eval_78()),
			(cond_m4_0 and cond_m5_m3, lambda: eval_74()),
			(cond_m4_0 and cond_m6_m3, lambda: eval_78()),
			(cond_m4_0 and cond_m7_m3, lambda: eval_78()),
			(cond_m4_m3 and cond_m5_0, lambda: eval_74()),
			(cond_m4_m3 and cond_m6_0, lambda: eval_75()),
			(cond_m5_0 and cond_m6_m3, lambda: eval_78()),
			(cond_m5_0 and cond_m7_m3, lambda: eval_78()),
			(cond_m5_m3 and cond_m6_0, lambda: eval_75()),
			(cond_m4_m3 and cond_m7_0, lambda: eval_75()),
			(cond_m5_m3 and cond_m7_0, lambda: eval_75()),
			(cond_m6_0 and cond_m7_m3, lambda: eval_78()),
			(cond_m6_m3 and cond_m7_0, lambda: eval_78()),
			(cond_m3_0 and cond_m4_m2, lambda: eval_75()),
			(cond_m3_0 and cond_m5_m2, lambda: eval_75()),
			(cond_m3_0 and cond_m6_m2, lambda: eval_78()),
			(cond_m3_0 and cond_m7_m2, lambda: eval_78()),
			(cond_m3_m2 and cond_m4_0, lambda: eval_75()),
			(cond_m3_m2 and cond_m5_0, lambda: eval_75()),
			(cond_m4_0 and cond_m5_m2, lambda: eval_75()),
			(cond_m4_0 and cond_m6_m2, lambda: eval_78()),
			(cond_m4_0 and cond_m7_m2, lambda: eval_78()),
			(cond_m4_m2 and cond_m5_0, lambda: eval_75()),
			(cond_m3_m2 and cond_m6_0, lambda: eval_76()),
			(cond_m4_m2 and cond_m6_0, lambda: eval_76()),
			(cond_m5_0 and cond_m6_m2, lambda: eval_78()),
			(cond_m5_0 and cond_m7_m2, lambda: eval_78()),
			(cond_m5_m2 and cond_m6_0, lambda: eval_76()),
			(cond_m3_m2 and cond_m7_0, lambda: eval_76()),
			(cond_m4_m2 and cond_m7_0, lambda: eval_76()),
			(cond_m5_m2 and cond_m7_0, lambda: eval_76()),
			(cond_m6_0 and cond_m7_m2, lambda: eval_78()),
			(cond_m6_m2 and cond_m7_0, lambda: eval_78()),
			(cond_m2_0 and cond_m3_m1, lambda: eval_76()),
			(cond_m2_0 and cond_m4_m1, lambda: eval_76()),
			(cond_m2_0 and cond_m5_m1, lambda: eval_76()),
			(cond_m2_0 and cond_m6_m1, lambda: eval_78()),
			(cond_m2_0 and cond_m7_m1, lambda: eval_78()),
			(cond_m2_m1 and cond_m3_0, lambda: eval_76()),
			(cond_m2_m1 and cond_m4_0, lambda: eval_76()),
			(cond_m3_0 and cond_m4_m1, lambda: eval_76()),
			(cond_m3_0 and cond_m5_m1, lambda: eval_76()),
			(cond_m3_0 and cond_m6_m1, lambda: eval_78()),
			(cond_m3_0 and cond_m7_m1, lambda: eval_78()),
			(cond_m3_m1 and cond_m4_0, lambda: eval_76()),
			(cond_m2_m1 and cond_m5_0, lambda: eval_76()),
			(cond_m3_m1 and cond_m5_0, lambda: eval_76()),
			(cond_m4_0 and cond_m5_m1, lambda: eval_76()),
			(cond_m4_0 and cond_m6_m1, lambda: eval_78()),
			(cond_m4_0 and cond_m7_m1, lambda: eval_78()),
			(cond_m4_m1 and cond_m5_0, lambda: eval_76()),
			(cond_m2_m1 and cond_m6_0, lambda: eval_77()),
			(cond_m3_m1 and cond_m6_0, lambda: eval_77()),
			(cond_m4_m1 and cond_m6_0, lambda: eval_77()),
			(cond_m5_0 and cond_m6_m1, lambda: eval_78()),
			(cond_m5_0 and cond_m7_m1, lambda: eval_78()),
			(cond_m5_m1 and cond_m6_0, lambda: eval_77()),
			(cond_m2_m1 and cond_m7_0, lambda: eval_77()),
			(cond_m3_m1 and cond_m7_0, lambda: eval_77()),
			(cond_m4_m1 and cond_m7_0, lambda: eval_77()),
			(cond_m5_m1 and cond_m7_0, lambda: eval_77()),
			(cond_m6_0 and cond_m7_m1, lambda: eval_78()),
			(cond_m6_m1 and cond_m7_0, lambda: eval_78()),
			(cond_m1_0, lambda: eval_78()),
			(cond_m2_0, lambda: eval_78()),
			(cond_m3_0, lambda: eval_78()),
			(cond_m4_0, lambda: eval_78()),
			(cond_m5_0, lambda: eval_78()),
			(cond_m6_0, lambda: eval_78()),
			(cond_m7_0, lambda: eval_78()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_63()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_64()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_65()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_65()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_65()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_65()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_64()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_64()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4 and cond_m6_m4 and cond_m7_m4, lambda: eval_66()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_66()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1 and cond_m6_m3 and cond_m7_m3, lambda: eval_66()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3 and cond_m6_m1 and cond_m7_m3, lambda: eval_65()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3 and cond_m7_m1, lambda: eval_65()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_66()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_66()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_65()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_65()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_66()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_65()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_65()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_65()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_65()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_64()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m6_m5 and cond_m7_m5, lambda: eval_67()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1 and cond_m6_m4 and cond_m7_m4, lambda: eval_67()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4 and cond_m6_m1 and cond_m7_m4, lambda: eval_66()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4 and cond_m6_m4 and cond_m7_m1, lambda: eval_66()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m3 and cond_m7_m3, lambda: eval_67()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3 and cond_m6_m1 and cond_m7_m3, lambda: eval_66()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3 and cond_m6_m3 and cond_m7_m1, lambda: eval_66()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1 and cond_m6_m1 and cond_m7_m3, lambda: eval_66()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1 and cond_m6_m3 and cond_m7_m1, lambda: eval_66()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3 and cond_m6_m1 and cond_m7_m1, lambda: eval_65()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_67()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_66()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_66()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_66()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_66()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_65()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_66()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_66()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_65()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_65()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m7_m6, lambda: eval_63()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m6_m1 and cond_m7_m5, lambda: eval_67()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m6_m5 and cond_m7_m1, lambda: eval_67()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m4, lambda: eval_67()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1 and cond_m6_m4 and cond_m7_m1, lambda: eval_67()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4 and cond_m6_m1 and cond_m7_m1, lambda: eval_66()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m3, lambda: eval_67()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m3 and cond_m7_m1, lambda: eval_67()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3 and cond_m6_m1 and cond_m7_m1, lambda: eval_66()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_66()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_67()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_67()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_66()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_66()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_66()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_63()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m7_m1, lambda: eval_63()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_67()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_67()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_67()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_67()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_68()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_m4 and cond_m7_m4, lambda: eval_69()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_69()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_m3 and cond_m7_m3, lambda: eval_69()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_m2 and cond_m7_m3, lambda: eval_68()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_m3 and cond_m7_m2, lambda: eval_68()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_m5 and cond_m7_m5, lambda: eval_70()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_m4 and cond_m7_m4, lambda: eval_70()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_m2 and cond_m7_m4, lambda: eval_69()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_m4 and cond_m7_m2, lambda: eval_69()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_m3 and cond_m7_m3, lambda: eval_70()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_m2 and cond_m7_m3, lambda: eval_69()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_m3 and cond_m7_m2, lambda: eval_69()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_m2 and cond_m7_m3, lambda: eval_69()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_m3 and cond_m7_m2, lambda: eval_69()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_m2 and cond_m7_m2, lambda: eval_68()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m7_m6, lambda: eval_64()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_m2 and cond_m7_m5, lambda: eval_70()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_m5 and cond_m7_m2, lambda: eval_70()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_m4, lambda: eval_70()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_m4 and cond_m7_m2, lambda: eval_70()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_m2 and cond_m7_m2, lambda: eval_69()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_m3, lambda: eval_70()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_m3 and cond_m7_m2, lambda: eval_70()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_m2 and cond_m7_m2, lambda: eval_69()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_69()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2, lambda: eval_64()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m7_m2, lambda: eval_64()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_70()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_70()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_70()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_m4 and cond_m7_m4, lambda: eval_71()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_m4 and cond_m7_m4, lambda: eval_71()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_71()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_m3 and cond_m7_m3, lambda: eval_71()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_m1 and cond_m7_m3, lambda: eval_68()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_m3 and cond_m7_m1, lambda: eval_68()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_m5 and cond_m7_m5, lambda: eval_72()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_m4 and cond_m7_m4, lambda: eval_72()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_m3 and cond_m7_m4, lambda: eval_71()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_m4 and cond_m7_m3, lambda: eval_71()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_m5 and cond_m7_m5, lambda: eval_72()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_m4 and cond_m7_m4, lambda: eval_72()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_m2 and cond_m7_m4, lambda: eval_71()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_m4 and cond_m7_m2, lambda: eval_71()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_m5 and cond_m7_m5, lambda: eval_72()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_m4 and cond_m7_m4, lambda: eval_72()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_m1 and cond_m7_m4, lambda: eval_69()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_m4 and cond_m7_m1, lambda: eval_69()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_m3 and cond_m7_m3, lambda: eval_72()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_m2 and cond_m7_m3, lambda: eval_71()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_m3 and cond_m7_m2, lambda: eval_71()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_m3 and cond_m7_m3, lambda: eval_72()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_m1 and cond_m7_m3, lambda: eval_69()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_m3 and cond_m7_m1, lambda: eval_69()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_m2 and cond_m7_m3, lambda: eval_71()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_m3 and cond_m7_m2, lambda: eval_71()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_m1 and cond_m7_m3, lambda: eval_69()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_m3 and cond_m7_m1, lambda: eval_69()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_m1 and cond_m7_m2, lambda: eval_68()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_m2 and cond_m7_m1, lambda: eval_68()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3 and cond_m7_m6, lambda: eval_65()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_m3 and cond_m7_m5, lambda: eval_72()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_m5 and cond_m7_m3, lambda: eval_72()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_m3 and cond_m7_m4, lambda: eval_72()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_m4 and cond_m7_m3, lambda: eval_72()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_m3 and cond_m7_m3, lambda: eval_71()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2 and cond_m7_m6, lambda: eval_65()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_m2 and cond_m7_m5, lambda: eval_72()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_m5 and cond_m7_m2, lambda: eval_72()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_m2 and cond_m7_m4, lambda: eval_72()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_m4 and cond_m7_m2, lambda: eval_72()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_m2 and cond_m7_m2, lambda: eval_71()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2 and cond_m7_m6, lambda: eval_65()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_m2 and cond_m7_m5, lambda: eval_72()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_m5 and cond_m7_m2, lambda: eval_72()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1 and cond_m7_m6, lambda: eval_65()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_m1 and cond_m7_m5, lambda: eval_70()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_m5 and cond_m7_m1, lambda: eval_70()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_m2 and cond_m7_m4, lambda: eval_72()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_m4 and cond_m7_m2, lambda: eval_72()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_m1 and cond_m7_m4, lambda: eval_70()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_m4 and cond_m7_m1, lambda: eval_70()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_m1 and cond_m7_m2, lambda: eval_69()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_m2 and cond_m7_m1, lambda: eval_69()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_m2 and cond_m7_m3, lambda: eval_72()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_m3 and cond_m7_m2, lambda: eval_72()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_m2 and cond_m7_m2, lambda: eval_71()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_m2 and cond_m7_m3, lambda: eval_72()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_m3 and cond_m7_m2, lambda: eval_72()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_m1 and cond_m7_m3, lambda: eval_70()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_m3 and cond_m7_m1, lambda: eval_70()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_m1 and cond_m7_m2, lambda: eval_69()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_m2 and cond_m7_m1, lambda: eval_69()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_71()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_69()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_69()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3, lambda: eval_65()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3 and cond_m7_m3, lambda: eval_65()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_72()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_72()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2, lambda: eval_65()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2 and cond_m7_m2, lambda: eval_65()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_72()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_72()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2 and cond_m6_m2, lambda: eval_65()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2 and cond_m7_m2, lambda: eval_65()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_72()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1 and cond_m6_m2, lambda: eval_65()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1 and cond_m7_m2, lambda: eval_65()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_m1, lambda: eval_64()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m7_m1, lambda: eval_64()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_70()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_70()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_72()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_70()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_70()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_72()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_72()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_70()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_m5 and cond_m7_m5, lambda: eval_73()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_m5 and cond_m7_m5, lambda: eval_73()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_m4 and cond_m7_m4, lambda: eval_73()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_m1 and cond_m7_m4, lambda: eval_71()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_m4 and cond_m7_m1, lambda: eval_71()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_m5 and cond_m7_m5, lambda: eval_73()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_m4 and cond_m7_m4, lambda: eval_73()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_m1 and cond_m7_m4, lambda: eval_71()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_m4 and cond_m7_m1, lambda: eval_71()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_m3 and cond_m7_m3, lambda: eval_73()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_m1 and cond_m7_m3, lambda: eval_71()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_m3 and cond_m7_m1, lambda: eval_71()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_m1 and cond_m7_m3, lambda: eval_71()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_m3 and cond_m7_m1, lambda: eval_71()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_m1 and cond_m7_m1, lambda: eval_68()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4 and cond_m7_m6, lambda: eval_66()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_m4 and cond_m7_m5, lambda: eval_73()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_m5 and cond_m7_m4, lambda: eval_73()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3 and cond_m7_m6, lambda: eval_66()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_m3 and cond_m7_m5, lambda: eval_73()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_m5 and cond_m7_m3, lambda: eval_73()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1 and cond_m7_m6, lambda: eval_66()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_m1 and cond_m7_m5, lambda: eval_72()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_m5 and cond_m7_m1, lambda: eval_72()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_m3 and cond_m7_m4, lambda: eval_73()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_m4 and cond_m7_m3, lambda: eval_73()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_m1 and cond_m7_m4, lambda: eval_72()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_m4 and cond_m7_m1, lambda: eval_72()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_m1 and cond_m7_m3, lambda: eval_71()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_m3 and cond_m7_m1, lambda: eval_71()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2 and cond_m7_m6, lambda: eval_66()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_m2 and cond_m7_m5, lambda: eval_73()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_m5 and cond_m7_m2, lambda: eval_73()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1 and cond_m7_m6, lambda: eval_66()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_m1 and cond_m7_m5, lambda: eval_72()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_m5 and cond_m7_m1, lambda: eval_72()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_m2 and cond_m7_m4, lambda: eval_73()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_m4 and cond_m7_m2, lambda: eval_73()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_m1 and cond_m7_m4, lambda: eval_72()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_m4 and cond_m7_m1, lambda: eval_72()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_m1 and cond_m7_m2, lambda: eval_71()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_m2 and cond_m7_m1, lambda: eval_71()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1 and cond_m7_m6, lambda: eval_66()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_m1 and cond_m7_m5, lambda: eval_72()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_m5 and cond_m7_m1, lambda: eval_72()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_m1 and cond_m7_m4, lambda: eval_72()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_m4 and cond_m7_m1, lambda: eval_72()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_m1 and cond_m7_m1, lambda: eval_69()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_m2 and cond_m7_m3, lambda: eval_73()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_m3 and cond_m7_m2, lambda: eval_73()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_m1 and cond_m7_m3, lambda: eval_72()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_m3 and cond_m7_m1, lambda: eval_72()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_m1 and cond_m7_m2, lambda: eval_71()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_m2 and cond_m7_m1, lambda: eval_71()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_m1 and cond_m7_m3, lambda: eval_72()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_m3 and cond_m7_m1, lambda: eval_72()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_m1 and cond_m7_m1, lambda: eval_69()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_71()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_71()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_69()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4 and cond_m6_m4, lambda: eval_66()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4 and cond_m7_m4, lambda: eval_66()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_m4 and cond_m7_m4, lambda: eval_73()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3 and cond_m6_m3, lambda: eval_66()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3 and cond_m7_m3, lambda: eval_66()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_m3 and cond_m7_m3, lambda: eval_73()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1 and cond_m6_m3, lambda: eval_66()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1 and cond_m7_m3, lambda: eval_66()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3 and cond_m6_m1, lambda: eval_65()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3 and cond_m7_m1, lambda: eval_65()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_m1 and cond_m7_m3, lambda: eval_72()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_m3 and cond_m7_m1, lambda: eval_72()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_m3 and cond_m7_m3, lambda: eval_73()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_m1 and cond_m7_m3, lambda: eval_72()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_m3 and cond_m7_m1, lambda: eval_72()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2 and cond_m6_m2, lambda: eval_66()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2 and cond_m7_m2, lambda: eval_66()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_73()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1 and cond_m6_m2, lambda: eval_66()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1 and cond_m7_m2, lambda: eval_66()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2 and cond_m6_m1, lambda: eval_65()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2 and cond_m7_m1, lambda: eval_65()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_72()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_72()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_73()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_72()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_72()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1 and cond_m6_m2, lambda: eval_66()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1 and cond_m7_m2, lambda: eval_66()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2 and cond_m6_m1, lambda: eval_65()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2 and cond_m7_m1, lambda: eval_65()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_72()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_72()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1 and cond_m6_m1, lambda: eval_65()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1 and cond_m7_m1, lambda: eval_65()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_70()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_72()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_72()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_70()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_73()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_72()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_72()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_72()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_72()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m7_m6, lambda: eval_67()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1 and cond_m7_m6, lambda: eval_67()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_m1 and cond_m7_m5, lambda: eval_73()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_m5 and cond_m7_m1, lambda: eval_73()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1 and cond_m7_m6, lambda: eval_67()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_m1 and cond_m7_m5, lambda: eval_73()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_m5 and cond_m7_m1, lambda: eval_73()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m4, lambda: eval_73()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_m4 and cond_m7_m1, lambda: eval_73()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_m1 and cond_m7_m1, lambda: eval_71()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m7_m6, lambda: eval_67()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_m1 and cond_m7_m5, lambda: eval_73()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_m5 and cond_m7_m1, lambda: eval_73()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m4, lambda: eval_73()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_m4 and cond_m7_m1, lambda: eval_73()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_m1 and cond_m7_m1, lambda: eval_71()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m3, lambda: eval_73()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_m3 and cond_m7_m1, lambda: eval_73()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_m1 and cond_m7_m1, lambda: eval_71()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_71()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m6_m5, lambda: eval_67()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m7_m5, lambda: eval_67()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1 and cond_m6_m4, lambda: eval_67()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1 and cond_m7_m4, lambda: eval_67()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4 and cond_m6_m1, lambda: eval_66()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4 and cond_m7_m1, lambda: eval_66()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_m1 and cond_m7_m4, lambda: eval_73()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_m4 and cond_m7_m1, lambda: eval_73()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m3, lambda: eval_67()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1 and cond_m7_m3, lambda: eval_67()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3 and cond_m6_m1, lambda: eval_66()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3 and cond_m7_m1, lambda: eval_66()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_m1 and cond_m7_m3, lambda: eval_73()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_m3 and cond_m7_m1, lambda: eval_73()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1 and cond_m6_m1, lambda: eval_66()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1 and cond_m7_m1, lambda: eval_66()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_m1 and cond_m7_m1, lambda: eval_72()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m3, lambda: eval_73()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_m3 and cond_m7_m1, lambda: eval_73()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_m1 and cond_m7_m1, lambda: eval_72()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m2, lambda: eval_67()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m7_m2, lambda: eval_67()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2 and cond_m6_m1, lambda: eval_66()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2 and cond_m7_m1, lambda: eval_66()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_73()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_73()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1 and cond_m6_m1, lambda: eval_66()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1 and cond_m7_m1, lambda: eval_66()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_72()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_73()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_73()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_72()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_66()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1 and cond_m7_m1, lambda: eval_66()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_72()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_72()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_73()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_73()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_72()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_72()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1, lambda: eval_63()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m6_m1, lambda: eval_67()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m7_m1, lambda: eval_67()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_67()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1 and cond_m7_m1, lambda: eval_67()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_73()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_67()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1 and cond_m7_m1, lambda: eval_67()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_73()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_73()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_67()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m7_m1, lambda: eval_67()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_73()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_73()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_73()),
			(cond_m5_m4 and cond_m6_m4 and cond_m7_m4, lambda: eval_74()),
			(cond_m4_m3 and cond_m6_m5 and cond_m7_m5, lambda: eval_75()),
			(cond_m5_m3 and cond_m6_m4 and cond_m7_m4, lambda: eval_75()),
			(cond_m5_m4 and cond_m6_m3 and cond_m7_m4, lambda: eval_74()),
			(cond_m5_m4 and cond_m6_m4 and cond_m7_m3, lambda: eval_74()),
			(cond_m4_m3 and cond_m5_m3 and cond_m7_m6, lambda: eval_68()),
			(cond_m4_m3 and cond_m6_m3 and cond_m7_m5, lambda: eval_75()),
			(cond_m4_m3 and cond_m6_m5 and cond_m7_m3, lambda: eval_75()),
			(cond_m5_m3 and cond_m6_m3 and cond_m7_m4, lambda: eval_75()),
			(cond_m5_m3 and cond_m6_m4 and cond_m7_m3, lambda: eval_75()),
			(cond_m5_m4 and cond_m6_m3 and cond_m7_m3, lambda: eval_74()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_m3, lambda: eval_68()),
			(cond_m4_m3 and cond_m5_m3 and cond_m7_m3, lambda: eval_68()),
			(cond_m4_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_75()),
			(cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_75()),
			(cond_m3_m2 and cond_m6_m5 and cond_m7_m5, lambda: eval_76()),
			(cond_m4_m2 and cond_m6_m5 and cond_m7_m5, lambda: eval_76()),
			(cond_m5_m2 and cond_m6_m4 and cond_m7_m4, lambda: eval_76()),
			(cond_m5_m4 and cond_m6_m2 and cond_m7_m4, lambda: eval_74()),
			(cond_m5_m4 and cond_m6_m4 and cond_m7_m2, lambda: eval_74()),
			(cond_m3_m2 and cond_m5_m4 and cond_m7_m6, lambda: eval_69()),
			(cond_m3_m2 and cond_m6_m4 and cond_m7_m5, lambda: eval_76()),
			(cond_m3_m2 and cond_m6_m5 and cond_m7_m4, lambda: eval_76()),
			(cond_m4_m2 and cond_m5_m3 and cond_m7_m6, lambda: eval_69()),
			(cond_m4_m2 and cond_m6_m3 and cond_m7_m5, lambda: eval_76()),
			(cond_m4_m2 and cond_m6_m5 and cond_m7_m3, lambda: eval_76()),
			(cond_m4_m3 and cond_m5_m2 and cond_m7_m6, lambda: eval_69()),
			(cond_m4_m3 and cond_m6_m2 and cond_m7_m5, lambda: eval_75()),
			(cond_m4_m3 and cond_m6_m5 and cond_m7_m2, lambda: eval_75()),
			(cond_m5_m2 and cond_m6_m3 and cond_m7_m4, lambda: eval_76()),
			(cond_m5_m2 and cond_m6_m4 and cond_m7_m3, lambda: eval_76()),
			(cond_m5_m3 and cond_m6_m2 and cond_m7_m4, lambda: eval_75()),
			(cond_m5_m3 and cond_m6_m4 and cond_m7_m2, lambda: eval_75()),
			(cond_m5_m4 and cond_m6_m2 and cond_m7_m3, lambda: eval_74()),
			(cond_m5_m4 and cond_m6_m3 and cond_m7_m2, lambda: eval_74()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_m4, lambda: eval_69()),
			(cond_m3_m2 and cond_m5_m4 and cond_m7_m4, lambda: eval_69()),
			(cond_m3_m2 and cond_m6_m4 and cond_m7_m4, lambda: eval_76()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_m3, lambda: eval_69()),
			(cond_m4_m2 and cond_m5_m3 and cond_m7_m3, lambda: eval_69()),
			(cond_m4_m2 and cond_m6_m3 and cond_m7_m3, lambda: eval_76()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_m3, lambda: eval_69()),
			(cond_m4_m3 and cond_m5_m2 and cond_m7_m3, lambda: eval_69()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_m2, lambda: eval_68()),
			(cond_m4_m3 and cond_m5_m3 and cond_m7_m2, lambda: eval_68()),
			(cond_m4_m3 and cond_m6_m2 and cond_m7_m3, lambda: eval_75()),
			(cond_m4_m3 and cond_m6_m3 and cond_m7_m2, lambda: eval_75()),
			(cond_m5_m2 and cond_m6_m3 and cond_m7_m3, lambda: eval_76()),
			(cond_m5_m3 and cond_m6_m2 and cond_m7_m3, lambda: eval_75()),
			(cond_m5_m3 and cond_m6_m3 and cond_m7_m2, lambda: eval_75()),
			(cond_m3_m2 and cond_m4_m2 and cond_m7_m6, lambda: eval_70()),
			(cond_m3_m2 and cond_m5_m2 and cond_m7_m6, lambda: eval_70()),
			(cond_m3_m2 and cond_m6_m2 and cond_m7_m5, lambda: eval_76()),
			(cond_m3_m2 and cond_m6_m5 and cond_m7_m2, lambda: eval_76()),
			(cond_m4_m2 and cond_m5_m2 and cond_m7_m6, lambda: eval_70()),
			(cond_m4_m2 and cond_m6_m2 and cond_m7_m5, lambda: eval_76()),
			(cond_m4_m2 and cond_m6_m5 and cond_m7_m2, lambda: eval_76()),
			(cond_m5_m2 and cond_m6_m2 and cond_m7_m4, lambda: eval_76()),
			(cond_m5_m2 and cond_m6_m4 and cond_m7_m2, lambda: eval_76()),
			(cond_m5_m4 and cond_m6_m2 and cond_m7_m2, lambda: eval_74()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_m5, lambda: eval_70()),
			(cond_m3_m2 and cond_m4_m2 and cond_m7_m5, lambda: eval_70()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_m4, lambda: eval_70()),
			(cond_m3_m2 and cond_m5_m2 and cond_m7_m4, lambda: eval_70()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_m2, lambda: eval_69()),
			(cond_m3_m2 and cond_m5_m4 and cond_m7_m2, lambda: eval_69()),
			(cond_m3_m2 and cond_m6_m2 and cond_m7_m4, lambda: eval_76()),
			(cond_m3_m2 and cond_m6_m4 and cond_m7_m2, lambda: eval_76()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_m3, lambda: eval_70()),
			(cond_m4_m2 and cond_m5_m2 and cond_m7_m3, lambda: eval_70()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_m2, lambda: eval_69()),
			(cond_m4_m2 and cond_m5_m3 and cond_m7_m2, lambda: eval_69()),
			(cond_m4_m2 and cond_m6_m2 and cond_m7_m3, lambda: eval_76()),
			(cond_m4_m2 and cond_m6_m3 and cond_m7_m2, lambda: eval_76()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_m2, lambda: eval_69()),
			(cond_m4_m3 and cond_m5_m2 and cond_m7_m2, lambda: eval_69()),
			(cond_m4_m3 and cond_m6_m2 and cond_m7_m2, lambda: eval_75()),
			(cond_m5_m2 and cond_m6_m2 and cond_m7_m3, lambda: eval_76()),
			(cond_m5_m2 and cond_m6_m3 and cond_m7_m2, lambda: eval_76()),
			(cond_m5_m3 and cond_m6_m2 and cond_m7_m2, lambda: eval_75()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2, lambda: eval_64()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_m2, lambda: eval_70()),
			(cond_m3_m2 and cond_m4_m2 and cond_m7_m2, lambda: eval_70()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_m2, lambda: eval_70()),
			(cond_m3_m2 and cond_m5_m2 and cond_m7_m2, lambda: eval_70()),
			(cond_m3_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_76()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_m2, lambda: eval_70()),
			(cond_m4_m2 and cond_m5_m2 and cond_m7_m2, lambda: eval_70()),
			(cond_m4_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_76()),
			(cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_76()),
			(cond_m2_m1 and cond_m6_m5 and cond_m7_m5, lambda: eval_77()),
			(cond_m3_m1 and cond_m6_m5 and cond_m7_m5, lambda: eval_77()),
			(cond_m4_m1 and cond_m6_m5 and cond_m7_m5, lambda: eval_77()),
			(cond_m5_m1 and cond_m6_m4 and cond_m7_m4, lambda: eval_77()),
			(cond_m5_m4 and cond_m6_m1 and cond_m7_m4, lambda: eval_74()),
			(cond_m5_m4 and cond_m6_m4 and cond_m7_m1, lambda: eval_74()),
			(cond_m2_m1 and cond_m5_m4 and cond_m7_m6, lambda: eval_71()),
			(cond_m2_m1 and cond_m6_m4 and cond_m7_m5, lambda: eval_77()),
			(cond_m2_m1 and cond_m6_m5 and cond_m7_m4, lambda: eval_77()),
			(cond_m3_m1 and cond_m5_m4 and cond_m7_m6, lambda: eval_71()),
			(cond_m3_m1 and cond_m6_m4 and cond_m7_m5, lambda: eval_77()),
			(cond_m3_m1 and cond_m6_m5 and cond_m7_m4, lambda: eval_77()),
			(cond_m4_m1 and cond_m5_m3 and cond_m7_m6, lambda: eval_71()),
			(cond_m4_m1 and cond_m6_m3 and cond_m7_m5, lambda: eval_77()),
			(cond_m4_m1 and cond_m6_m5 and cond_m7_m3, lambda: eval_77()),
			(cond_m4_m3 and cond_m5_m1 and cond_m7_m6, lambda: eval_71()),
			(cond_m4_m3 and cond_m6_m1 and cond_m7_m5, lambda: eval_75()),
			(cond_m4_m3 and cond_m6_m5 and cond_m7_m1, lambda: eval_75()),
			(cond_m5_m1 and cond_m6_m3 and cond_m7_m4, lambda: eval_77()),
			(cond_m5_m1 and cond_m6_m4 and cond_m7_m3, lambda: eval_77()),
			(cond_m5_m3 and cond_m6_m1 and cond_m7_m4, lambda: eval_75()),
			(cond_m5_m3 and cond_m6_m4 and cond_m7_m1, lambda: eval_75()),
			(cond_m5_m4 and cond_m6_m1 and cond_m7_m3, lambda: eval_74()),
			(cond_m5_m4 and cond_m6_m3 and cond_m7_m1, lambda: eval_74()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_m4, lambda: eval_71()),
			(cond_m2_m1 and cond_m5_m4 and cond_m7_m4, lambda: eval_71()),
			(cond_m2_m1 and cond_m6_m4 and cond_m7_m4, lambda: eval_77()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_m4, lambda: eval_71()),
			(cond_m3_m1 and cond_m5_m4 and cond_m7_m4, lambda: eval_71()),
			(cond_m3_m1 and cond_m6_m4 and cond_m7_m4, lambda: eval_77()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_m3, lambda: eval_71()),
			(cond_m4_m1 and cond_m5_m3 and cond_m7_m3, lambda: eval_71()),
			(cond_m4_m1 and cond_m6_m3 and cond_m7_m3, lambda: eval_77()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_m3, lambda: eval_71()),
			(cond_m4_m3 and cond_m5_m1 and cond_m7_m3, lambda: eval_71()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_m1, lambda: eval_68()),
			(cond_m4_m3 and cond_m5_m3 and cond_m7_m1, lambda: eval_68()),
			(cond_m4_m3 and cond_m6_m1 and cond_m7_m3, lambda: eval_75()),
			(cond_m4_m3 and cond_m6_m3 and cond_m7_m1, lambda: eval_75()),
			(cond_m5_m1 and cond_m6_m3 and cond_m7_m3, lambda: eval_77()),
			(cond_m5_m3 and cond_m6_m1 and cond_m7_m3, lambda: eval_75()),
			(cond_m5_m3 and cond_m6_m3 and cond_m7_m1, lambda: eval_75()),
			(cond_m2_m1 and cond_m4_m3 and cond_m7_m6, lambda: eval_72()),
			(cond_m2_m1 and cond_m5_m3 and cond_m7_m6, lambda: eval_72()),
			(cond_m2_m1 and cond_m6_m3 and cond_m7_m5, lambda: eval_77()),
			(cond_m2_m1 and cond_m6_m5 and cond_m7_m3, lambda: eval_77()),
			(cond_m3_m1 and cond_m4_m2 and cond_m7_m6, lambda: eval_72()),
			(cond_m3_m1 and cond_m5_m2 and cond_m7_m6, lambda: eval_72()),
			(cond_m3_m1 and cond_m6_m2 and cond_m7_m5, lambda: eval_77()),
			(cond_m3_m1 and cond_m6_m5 and cond_m7_m2, lambda: eval_77()),
			(cond_m3_m2 and cond_m4_m1 and cond_m7_m6, lambda: eval_72()),
			(cond_m3_m2 and cond_m5_m1 and cond_m7_m6, lambda: eval_72()),
			(cond_m3_m2 and cond_m6_m1 and cond_m7_m5, lambda: eval_76()),
			(cond_m3_m2 and cond_m6_m5 and cond_m7_m1, lambda: eval_76()),
			(cond_m4_m1 and cond_m5_m2 and cond_m7_m6, lambda: eval_72()),
			(cond_m4_m1 and cond_m6_m2 and cond_m7_m5, lambda: eval_77()),
			(cond_m4_m1 and cond_m6_m5 and cond_m7_m2, lambda: eval_77()),
			(cond_m4_m2 and cond_m5_m1 and cond_m7_m6, lambda: eval_72()),
			(cond_m4_m2 and cond_m6_m1 and cond_m7_m5, lambda: eval_76()),
			(cond_m4_m2 and cond_m6_m5 and cond_m7_m1, lambda: eval_76()),
			(cond_m5_m1 and cond_m6_m2 and cond_m7_m4, lambda: eval_77()),
			(cond_m5_m1 and cond_m6_m4 and cond_m7_m2, lambda: eval_77()),
			(cond_m5_m2 and cond_m6_m1 and cond_m7_m4, lambda: eval_76()),
			(cond_m5_m2 and cond_m6_m4 and cond_m7_m1, lambda: eval_76()),
			(cond_m5_m4 and cond_m6_m1 and cond_m7_m2, lambda: eval_74()),
			(cond_m5_m4 and cond_m6_m2 and cond_m7_m1, lambda: eval_74()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_m5, lambda: eval_72()),
			(cond_m2_m1 and cond_m4_m3 and cond_m7_m5, lambda: eval_72()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_m4, lambda: eval_72()),
			(cond_m2_m1 and cond_m5_m3 and cond_m7_m4, lambda: eval_72()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_m3, lambda: eval_71()),
			(cond_m2_m1 and cond_m5_m4 and cond_m7_m3, lambda: eval_71()),
			(cond_m2_m1 and cond_m6_m3 and cond_m7_m4, lambda: eval_77()),
			(cond_m2_m1 and cond_m6_m4 and cond_m7_m3, lambda: eval_77()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_m5, lambda: eval_72()),
			(cond_m3_m1 and cond_m4_m2 and cond_m7_m5, lambda: eval_72()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_m4, lambda: eval_72()),
			(cond_m3_m1 and cond_m5_m2 and cond_m7_m4, lambda: eval_72()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_m2, lambda: eval_71()),
			(cond_m3_m1 and cond_m5_m4 and cond_m7_m2, lambda: eval_71()),
			(cond_m3_m1 and cond_m6_m2 and cond_m7_m4, lambda: eval_77()),
			(cond_m3_m1 and cond_m6_m4 and cond_m7_m2, lambda: eval_77()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_m5, lambda: eval_72()),
			(cond_m3_m2 and cond_m4_m1 and cond_m7_m5, lambda: eval_72()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_m4, lambda: eval_72()),
			(cond_m3_m2 and cond_m5_m1 and cond_m7_m4, lambda: eval_72()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_m1, lambda: eval_69()),
			(cond_m3_m2 and cond_m5_m4 and cond_m7_m1, lambda: eval_69()),
			(cond_m3_m2 and cond_m6_m1 and cond_m7_m4, lambda: eval_76()),
			(cond_m3_m2 and cond_m6_m4 and cond_m7_m1, lambda: eval_76()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_m3, lambda: eval_72()),
			(cond_m4_m1 and cond_m5_m2 and cond_m7_m3, lambda: eval_72()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_m2, lambda: eval_71()),
			(cond_m4_m1 and cond_m5_m3 and cond_m7_m2, lambda: eval_71()),
			(cond_m4_m1 and cond_m6_m2 and cond_m7_m3, lambda: eval_77()),
			(cond_m4_m1 and cond_m6_m3 and cond_m7_m2, lambda: eval_77()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_m3, lambda: eval_72()),
			(cond_m4_m2 and cond_m5_m1 and cond_m7_m3, lambda: eval_72()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_m1, lambda: eval_69()),
			(cond_m4_m2 and cond_m5_m3 and cond_m7_m1, lambda: eval_69()),
			(cond_m4_m2 and cond_m6_m1 and cond_m7_m3, lambda: eval_76()),
			(cond_m4_m2 and cond_m6_m3 and cond_m7_m1, lambda: eval_76()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_m2, lambda: eval_71()),
			(cond_m4_m3 and cond_m5_m1 and cond_m7_m2, lambda: eval_71()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_m1, lambda: eval_69()),
			(cond_m4_m3 and cond_m5_m2 and cond_m7_m1, lambda: eval_69()),
			(cond_m4_m3 and cond_m6_m1 and cond_m7_m2, lambda: eval_75()),
			(cond_m4_m3 and cond_m6_m2 and cond_m7_m1, lambda: eval_75()),
			(cond_m5_m1 and cond_m6_m2 and cond_m7_m3, lambda: eval_77()),
			(cond_m5_m1 and cond_m6_m3 and cond_m7_m2, lambda: eval_77()),
			(cond_m5_m2 and cond_m6_m1 and cond_m7_m3, lambda: eval_76()),
			(cond_m5_m2 and cond_m6_m3 and cond_m7_m1, lambda: eval_76()),
			(cond_m5_m3 and cond_m6_m1 and cond_m7_m2, lambda: eval_75()),
			(cond_m5_m3 and cond_m6_m2 and cond_m7_m1, lambda: eval_75()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3, lambda: eval_65()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_m3, lambda: eval_72()),
			(cond_m2_m1 and cond_m4_m3 and cond_m7_m3, lambda: eval_72()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_m3, lambda: eval_72()),
			(cond_m2_m1 and cond_m5_m3 and cond_m7_m3, lambda: eval_72()),
			(cond_m2_m1 and cond_m6_m3 and cond_m7_m3, lambda: eval_77()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2, lambda: eval_65()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_m2, lambda: eval_72()),
			(cond_m3_m1 and cond_m4_m2 and cond_m7_m2, lambda: eval_72()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_m2, lambda: eval_72()),
			(cond_m3_m1 and cond_m5_m2 and cond_m7_m2, lambda: eval_72()),
			(cond_m3_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_77()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2, lambda: eval_65()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_m2, lambda: eval_72()),
			(cond_m3_m2 and cond_m4_m1 and cond_m7_m2, lambda: eval_72()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1, lambda: eval_65()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_m1, lambda: eval_70()),
			(cond_m3_m2 and cond_m4_m2 and cond_m7_m1, lambda: eval_70()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_m2, lambda: eval_72()),
			(cond_m3_m2 and cond_m5_m1 and cond_m7_m2, lambda: eval_72()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_m1, lambda: eval_70()),
			(cond_m3_m2 and cond_m5_m2 and cond_m7_m1, lambda: eval_70()),
			(cond_m3_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_76()),
			(cond_m3_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_76()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_m2, lambda: eval_72()),
			(cond_m4_m1 and cond_m5_m2 and cond_m7_m2, lambda: eval_72()),
			(cond_m4_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_77()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_m2, lambda: eval_72()),
			(cond_m4_m2 and cond_m5_m1 and cond_m7_m2, lambda: eval_72()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_m1, lambda: eval_70()),
			(cond_m4_m2 and cond_m5_m2 and cond_m7_m1, lambda: eval_70()),
			(cond_m4_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_76()),
			(cond_m4_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_76()),
			(cond_m5_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_77()),
			(cond_m5_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_76()),
			(cond_m5_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_76()),
			(cond_m2_m1 and cond_m3_m1 and cond_m7_m6, lambda: eval_73()),
			(cond_m2_m1 and cond_m4_m1 and cond_m7_m6, lambda: eval_73()),
			(cond_m2_m1 and cond_m5_m1 and cond_m7_m6, lambda: eval_73()),
			(cond_m2_m1 and cond_m6_m1 and cond_m7_m5, lambda: eval_77()),
			(cond_m2_m1 and cond_m6_m5 and cond_m7_m1, lambda: eval_77()),
			(cond_m3_m1 and cond_m4_m1 and cond_m7_m6, lambda: eval_73()),
			(cond_m3_m1 and cond_m5_m1 and cond_m7_m6, lambda: eval_73()),
			(cond_m3_m1 and cond_m6_m1 and cond_m7_m5, lambda: eval_77()),
			(cond_m3_m1 and cond_m6_m5 and cond_m7_m1, lambda: eval_77()),
			(cond_m4_m1 and cond_m5_m1 and cond_m7_m6, lambda: eval_73()),
			(cond_m4_m1 and cond_m6_m1 and cond_m7_m5, lambda: eval_77()),
			(cond_m4_m1 and cond_m6_m5 and cond_m7_m1, lambda: eval_77()),
			(cond_m5_m1 and cond_m6_m1 and cond_m7_m4, lambda: eval_77()),
			(cond_m5_m1 and cond_m6_m4 and cond_m7_m1, lambda: eval_77()),
			(cond_m5_m4 and cond_m6_m1 and cond_m7_m1, lambda: eval_74()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_m5, lambda: eval_73()),
			(cond_m2_m1 and cond_m3_m1 and cond_m7_m5, lambda: eval_73()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_m5, lambda: eval_73()),
			(cond_m2_m1 and cond_m4_m1 and cond_m7_m5, lambda: eval_73()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_m4, lambda: eval_73()),
			(cond_m2_m1 and cond_m5_m1 and cond_m7_m4, lambda: eval_73()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_m1, lambda: eval_71()),
			(cond_m2_m1 and cond_m5_m4 and cond_m7_m1, lambda: eval_71()),
			(cond_m2_m1 and cond_m6_m1 and cond_m7_m4, lambda: eval_77()),
			(cond_m2_m1 and cond_m6_m4 and cond_m7_m1, lambda: eval_77()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_m5, lambda: eval_73()),
			(cond_m3_m1 and cond_m4_m1 and cond_m7_m5, lambda: eval_73()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_m4, lambda: eval_73()),
			(cond_m3_m1 and cond_m5_m1 and cond_m7_m4, lambda: eval_73()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_m1, lambda: eval_71()),
			(cond_m3_m1 and cond_m5_m4 and cond_m7_m1, lambda: eval_71()),
			(cond_m3_m1 and cond_m6_m1 and cond_m7_m4, lambda: eval_77()),
			(cond_m3_m1 and cond_m6_m4 and cond_m7_m1, lambda: eval_77()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_m3, lambda: eval_73()),
			(cond_m4_m1 and cond_m5_m1 and cond_m7_m3, lambda: eval_73()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_m1, lambda: eval_71()),
			(cond_m4_m1 and cond_m5_m3 and cond_m7_m1, lambda: eval_71()),
			(cond_m4_m1 and cond_m6_m1 and cond_m7_m3, lambda: eval_77()),
			(cond_m4_m1 and cond_m6_m3 and cond_m7_m1, lambda: eval_77()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_m1, lambda: eval_71()),
			(cond_m4_m3 and cond_m5_m1 and cond_m7_m1, lambda: eval_71()),
			(cond_m4_m3 and cond_m6_m1 and cond_m7_m1, lambda: eval_75()),
			(cond_m5_m1 and cond_m6_m1 and cond_m7_m3, lambda: eval_77()),
			(cond_m5_m1 and cond_m6_m3 and cond_m7_m1, lambda: eval_77()),
			(cond_m5_m3 and cond_m6_m1 and cond_m7_m1, lambda: eval_75()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4, lambda: eval_66()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_m4, lambda: eval_73()),
			(cond_m2_m1 and cond_m3_m1 and cond_m7_m4, lambda: eval_73()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3, lambda: eval_66()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_m3, lambda: eval_73()),
			(cond_m2_m1 and cond_m4_m1 and cond_m7_m3, lambda: eval_73()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1, lambda: eval_66()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_m1, lambda: eval_72()),
			(cond_m2_m1 and cond_m4_m3 and cond_m7_m1, lambda: eval_72()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_m3, lambda: eval_73()),
			(cond_m2_m1 and cond_m5_m1 and cond_m7_m3, lambda: eval_73()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_m1, lambda: eval_72()),
			(cond_m2_m1 and cond_m5_m3 and cond_m7_m1, lambda: eval_72()),
			(cond_m2_m1 and cond_m6_m1 and cond_m7_m3, lambda: eval_77()),
			(cond_m2_m1 and cond_m6_m3 and cond_m7_m1, lambda: eval_77()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2, lambda: eval_66()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_m2, lambda: eval_73()),
			(cond_m3_m1 and cond_m4_m1 and cond_m7_m2, lambda: eval_73()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1, lambda: eval_66()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_m1, lambda: eval_72()),
			(cond_m3_m1 and cond_m4_m2 and cond_m7_m1, lambda: eval_72()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_m2, lambda: eval_73()),
			(cond_m3_m1 and cond_m5_m1 and cond_m7_m2, lambda: eval_73()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_m1, lambda: eval_72()),
			(cond_m3_m1 and cond_m5_m2 and cond_m7_m1, lambda: eval_72()),
			(cond_m3_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_77()),
			(cond_m3_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_77()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1, lambda: eval_66()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_m1, lambda: eval_72()),
			(cond_m3_m2 and cond_m4_m1 and cond_m7_m1, lambda: eval_72()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_m1, lambda: eval_72()),
			(cond_m3_m2 and cond_m5_m1 and cond_m7_m1, lambda: eval_72()),
			(cond_m3_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_76()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_m2, lambda: eval_73()),
			(cond_m4_m1 and cond_m5_m1 and cond_m7_m2, lambda: eval_73()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_m1, lambda: eval_72()),
			(cond_m4_m1 and cond_m5_m2 and cond_m7_m1, lambda: eval_72()),
			(cond_m4_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_77()),
			(cond_m4_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_77()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_m1, lambda: eval_72()),
			(cond_m4_m2 and cond_m5_m1 and cond_m7_m1, lambda: eval_72()),
			(cond_m4_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_76()),
			(cond_m5_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_77()),
			(cond_m5_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_77()),
			(cond_m5_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_76()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1, lambda: eval_67()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1, lambda: eval_67()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_m1, lambda: eval_73()),
			(cond_m2_m1 and cond_m3_m1 and cond_m7_m1, lambda: eval_73()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1, lambda: eval_67()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_m1, lambda: eval_73()),
			(cond_m2_m1 and cond_m4_m1 and cond_m7_m1, lambda: eval_73()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_73()),
			(cond_m2_m1 and cond_m5_m1 and cond_m7_m1, lambda: eval_73()),
			(cond_m2_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_77()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1, lambda: eval_67()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_m1, lambda: eval_73()),
			(cond_m3_m1 and cond_m4_m1 and cond_m7_m1, lambda: eval_73()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_73()),
			(cond_m3_m1 and cond_m5_m1 and cond_m7_m1, lambda: eval_73()),
			(cond_m3_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_77()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_73()),
			(cond_m4_m1 and cond_m5_m1 and cond_m7_m1, lambda: eval_73()),
			(cond_m4_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_77()),
			(cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_77()),
			(cond_m6_m5 and cond_m7_m5, lambda: eval_78()),
			(cond_m5_m4 and cond_m7_m6, lambda: eval_74()),
			(cond_m6_m4 and cond_m7_m5, lambda: eval_78()),
			(cond_m6_m5 and cond_m7_m4, lambda: eval_78()),
			(cond_m5_m4 and cond_m6_m4, lambda: eval_74()),
			(cond_m5_m4 and cond_m7_m4, lambda: eval_74()),
			(cond_m6_m4 and cond_m7_m4, lambda: eval_78()),
			(cond_m4_m3 and cond_m7_m6, lambda: eval_75()),
			(cond_m5_m3 and cond_m7_m6, lambda: eval_75()),
			(cond_m6_m3 and cond_m7_m5, lambda: eval_78()),
			(cond_m6_m5 and cond_m7_m3, lambda: eval_78()),
			(cond_m4_m3 and cond_m6_m5, lambda: eval_75()),
			(cond_m4_m3 and cond_m7_m5, lambda: eval_75()),
			(cond_m5_m3 and cond_m6_m4, lambda: eval_75()),
			(cond_m5_m3 and cond_m7_m4, lambda: eval_75()),
			(cond_m5_m4 and cond_m6_m3, lambda: eval_74()),
			(cond_m5_m4 and cond_m7_m3, lambda: eval_74()),
			(cond_m6_m3 and cond_m7_m4, lambda: eval_78()),
			(cond_m6_m4 and cond_m7_m3, lambda: eval_78()),
			(cond_m4_m3 and cond_m5_m3, lambda: eval_68()),
			(cond_m4_m3 and cond_m6_m3, lambda: eval_75()),
			(cond_m4_m3 and cond_m7_m3, lambda: eval_75()),
			(cond_m5_m3 and cond_m6_m3, lambda: eval_75()),
			(cond_m5_m3 and cond_m7_m3, lambda: eval_75()),
			(cond_m6_m3 and cond_m7_m3, lambda: eval_78()),
			(cond_m3_m2 and cond_m7_m6, lambda: eval_76()),
			(cond_m4_m2 and cond_m7_m6, lambda: eval_76()),
			(cond_m5_m2 and cond_m7_m6, lambda: eval_76()),
			(cond_m6_m2 and cond_m7_m5, lambda: eval_78()),
			(cond_m6_m5 and cond_m7_m2, lambda: eval_78()),
			(cond_m3_m2 and cond_m6_m5, lambda: eval_76()),
			(cond_m3_m2 and cond_m7_m5, lambda: eval_76()),
			(cond_m4_m2 and cond_m6_m5, lambda: eval_76()),
			(cond_m4_m2 and cond_m7_m5, lambda: eval_76()),
			(cond_m5_m2 and cond_m6_m4, lambda: eval_76()),
			(cond_m5_m2 and cond_m7_m4, lambda: eval_76()),
			(cond_m5_m4 and cond_m6_m2, lambda: eval_74()),
			(cond_m5_m4 and cond_m7_m2, lambda: eval_74()),
			(cond_m6_m2 and cond_m7_m4, lambda: eval_78()),
			(cond_m6_m4 and cond_m7_m2, lambda: eval_78()),
			(cond_m3_m2 and cond_m5_m4, lambda: eval_69()),
			(cond_m3_m2 and cond_m6_m4, lambda: eval_76()),
			(cond_m3_m2 and cond_m7_m4, lambda: eval_76()),
			(cond_m4_m2 and cond_m5_m3, lambda: eval_69()),
			(cond_m4_m2 and cond_m6_m3, lambda: eval_76()),
			(cond_m4_m2 and cond_m7_m3, lambda: eval_76()),
			(cond_m4_m3 and cond_m5_m2, lambda: eval_69()),
			(cond_m4_m3 and cond_m6_m2, lambda: eval_75()),
			(cond_m4_m3 and cond_m7_m2, lambda: eval_75()),
			(cond_m5_m2 and cond_m6_m3, lambda: eval_76()),
			(cond_m5_m2 and cond_m7_m3, lambda: eval_76()),
			(cond_m5_m3 and cond_m6_m2, lambda: eval_75()),
			(cond_m5_m3 and cond_m7_m2, lambda: eval_75()),
			(cond_m6_m2 and cond_m7_m3, lambda: eval_78()),
			(cond_m6_m3 and cond_m7_m2, lambda: eval_78()),
			(cond_m3_m2 and cond_m4_m2, lambda: eval_70()),
			(cond_m3_m2 and cond_m5_m2, lambda: eval_70()),
			(cond_m3_m2 and cond_m6_m2, lambda: eval_76()),
			(cond_m3_m2 and cond_m7_m2, lambda: eval_76()),
			(cond_m4_m2 and cond_m5_m2, lambda: eval_70()),
			(cond_m4_m2 and cond_m6_m2, lambda: eval_76()),
			(cond_m4_m2 and cond_m7_m2, lambda: eval_76()),
			(cond_m5_m2 and cond_m6_m2, lambda: eval_76()),
			(cond_m5_m2 and cond_m7_m2, lambda: eval_76()),
			(cond_m6_m2 and cond_m7_m2, lambda: eval_78()),
			(cond_m2_m1 and cond_m7_m6, lambda: eval_77()),
			(cond_m3_m1 and cond_m7_m6, lambda: eval_77()),
			(cond_m4_m1 and cond_m7_m6, lambda: eval_77()),
			(cond_m5_m1 and cond_m7_m6, lambda: eval_77()),
			(cond_m6_m1 and cond_m7_m5, lambda: eval_78()),
			(cond_m6_m5 and cond_m7_m1, lambda: eval_78()),
			(cond_m2_m1 and cond_m6_m5, lambda: eval_77()),
			(cond_m2_m1 and cond_m7_m5, lambda: eval_77()),
			(cond_m3_m1 and cond_m6_m5, lambda: eval_77()),
			(cond_m3_m1 and cond_m7_m5, lambda: eval_77()),
			(cond_m4_m1 and cond_m6_m5, lambda: eval_77()),
			(cond_m4_m1 and cond_m7_m5, lambda: eval_77()),
			(cond_m5_m1 and cond_m6_m4, lambda: eval_77()),
			(cond_m5_m1 and cond_m7_m4, lambda: eval_77()),
			(cond_m5_m4 and cond_m6_m1, lambda: eval_74()),
			(cond_m5_m4 and cond_m7_m1, lambda: eval_74()),
			(cond_m6_m1 and cond_m7_m4, lambda: eval_78()),
			(cond_m6_m4 and cond_m7_m1, lambda: eval_78()),
			(cond_m2_m1 and cond_m5_m4, lambda: eval_71()),
			(cond_m2_m1 and cond_m6_m4, lambda: eval_77()),
			(cond_m2_m1 and cond_m7_m4, lambda: eval_77()),
			(cond_m3_m1 and cond_m5_m4, lambda: eval_71()),
			(cond_m3_m1 and cond_m6_m4, lambda: eval_77()),
			(cond_m3_m1 and cond_m7_m4, lambda: eval_77()),
			(cond_m4_m1 and cond_m5_m3, lambda: eval_71()),
			(cond_m4_m1 and cond_m6_m3, lambda: eval_77()),
			(cond_m4_m1 and cond_m7_m3, lambda: eval_77()),
			(cond_m4_m3 and cond_m5_m1, lambda: eval_71()),
			(cond_m4_m3 and cond_m6_m1, lambda: eval_75()),
			(cond_m4_m3 and cond_m7_m1, lambda: eval_75()),
			(cond_m5_m1 and cond_m6_m3, lambda: eval_77()),
			(cond_m5_m1 and cond_m7_m3, lambda: eval_77()),
			(cond_m5_m3 and cond_m6_m1, lambda: eval_75()),
			(cond_m5_m3 and cond_m7_m1, lambda: eval_75()),
			(cond_m6_m1 and cond_m7_m3, lambda: eval_78()),
			(cond_m6_m3 and cond_m7_m1, lambda: eval_78()),
			(cond_m2_m1 and cond_m4_m3, lambda: eval_72()),
			(cond_m2_m1 and cond_m5_m3, lambda: eval_72()),
			(cond_m2_m1 and cond_m6_m3, lambda: eval_77()),
			(cond_m2_m1 and cond_m7_m3, lambda: eval_77()),
			(cond_m3_m1 and cond_m4_m2, lambda: eval_72()),
			(cond_m3_m1 and cond_m5_m2, lambda: eval_72()),
			(cond_m3_m1 and cond_m6_m2, lambda: eval_77()),
			(cond_m3_m1 and cond_m7_m2, lambda: eval_77()),
			(cond_m3_m2 and cond_m4_m1, lambda: eval_72()),
			(cond_m3_m2 and cond_m5_m1, lambda: eval_72()),
			(cond_m3_m2 and cond_m6_m1, lambda: eval_76()),
			(cond_m3_m2 and cond_m7_m1, lambda: eval_76()),
			(cond_m4_m1 and cond_m5_m2, lambda: eval_72()),
			(cond_m4_m1 and cond_m6_m2, lambda: eval_77()),
			(cond_m4_m1 and cond_m7_m2, lambda: eval_77()),
			(cond_m4_m2 and cond_m5_m1, lambda: eval_72()),
			(cond_m4_m2 and cond_m6_m1, lambda: eval_76()),
			(cond_m4_m2 and cond_m7_m1, lambda: eval_76()),
			(cond_m5_m1 and cond_m6_m2, lambda: eval_77()),
			(cond_m5_m1 and cond_m7_m2, lambda: eval_77()),
			(cond_m5_m2 and cond_m6_m1, lambda: eval_76()),
			(cond_m5_m2 and cond_m7_m1, lambda: eval_76()),
			(cond_m6_m1 and cond_m7_m2, lambda: eval_78()),
			(cond_m6_m2 and cond_m7_m1, lambda: eval_78()),
			(cond_m2_m1 and cond_m3_m1, lambda: eval_73()),
			(cond_m2_m1 and cond_m4_m1, lambda: eval_73()),
			(cond_m2_m1 and cond_m5_m1, lambda: eval_73()),
			(cond_m2_m1 and cond_m6_m1, lambda: eval_77()),
			(cond_m2_m1 and cond_m7_m1, lambda: eval_77()),
			(cond_m3_m1 and cond_m4_m1, lambda: eval_73()),
			(cond_m3_m1 and cond_m5_m1, lambda: eval_73()),
			(cond_m3_m1 and cond_m6_m1, lambda: eval_77()),
			(cond_m3_m1 and cond_m7_m1, lambda: eval_77()),
			(cond_m4_m1 and cond_m5_m1, lambda: eval_73()),
			(cond_m4_m1 and cond_m6_m1, lambda: eval_77()),
			(cond_m4_m1 and cond_m7_m1, lambda: eval_77()),
			(cond_m5_m1 and cond_m6_m1, lambda: eval_77()),
			(cond_m5_m1 and cond_m7_m1, lambda: eval_77()),
			(cond_m6_m1 and cond_m7_m1, lambda: eval_78()),
			(cond_m7_m6, lambda: eval_78()),
			(cond_m6_m5, lambda: eval_78()),
			(cond_m7_m5, lambda: eval_78()),
			(cond_m5_m4, lambda: eval_74()),
			(cond_m6_m4, lambda: eval_78()),
			(cond_m7_m4, lambda: eval_78()),
			(cond_m4_m3, lambda: eval_75()),
			(cond_m5_m3, lambda: eval_75()),
			(cond_m6_m3, lambda: eval_78()),
			(cond_m7_m3, lambda: eval_78()),
			(cond_m3_m2, lambda: eval_76()),
			(cond_m4_m2, lambda: eval_76()),
			(cond_m5_m2, lambda: eval_76()),
			(cond_m6_m2, lambda: eval_78()),
			(cond_m7_m2, lambda: eval_78()),
			(cond_m2_m1, lambda: eval_77()),
			(cond_m3_m1, lambda: eval_77()),
			(cond_m4_m1, lambda: eval_77()),
			(cond_m5_m1, lambda: eval_77()),
			(cond_m6_m1, lambda: eval_78()),
			(cond_m7_m1, lambda: eval_78()),
			(True, lambda: eval_78())
		]

		for condition,action in conditions:
			if condition:
				res = action()
				return res * mass_scale**(-6.)

	except Exception as e:
		raise Exception(f"There was an error when evaluating the T1111134 integral with masses {m1}, {m2}, {m3}, {m4}, {m5}, {m6}, {m7} from {e}")