# This file is automatically generated. Do not modify it manually!
from functools import lru_cache

from .config import cond, Number, getMudim, getDiffeps
from .OneLoop import B0fin, B0del
from .T134 import T134fin


@lru_cache(maxsize=150)
def T111134(m1: Number, m2: Number, m3: Number, m4: Number, m5: Number, m6, mudim = None) -> Number:
	""" Computes the UV-finite part of the T111134 integral.

	Args:
		m1: internal mass
		m2: internal mass
		m3: internal mass
		m4: internal mass
		m5: internal mass
		m6: internal mass
		mudim: squared renormalization scale (if `None`, the global value is used)

	Returns:
		finite part of the T111134 integral.
	"""

	try:

		if mudim is None:
			mudim = getMudim()

		# rescale masses for better numerical stability
		mass_scale = max([m1, m2, m3, m4, m5, m6])
		if mass_scale <= getDiffeps():
			return 0
		m1 /= mass_scale
		m2 /= mass_scale
		m3 /= mass_scale
		m4 /= mass_scale
		m5 /= mass_scale
		m6 /= mass_scale
		mudim /= mass_scale**2
		m1, m2, m3, m4 = sorted([m1, m2, m3, m4])
		
		

		m1sq = m1**2
		m2sq = m2**2
		m3sq = m3**2
		m4sq = m4**2
		m5sq = m5**2
		m6sq = m6**2

		def eval_1():
			return 0
		def eval_2():
			return T134fin(m4,0,0,mudim)/m4**6
		def eval_3():
			return (31 - 30*B0fin(0,0,m5sq,mudim))/(900.*m5**4)
		def eval_4():
			return -((m3sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + T134fin(m3,0,0,mudim))/m3**6)
		def eval_5():
			return -0.16666666666666666*(m5**8 - 10*m5**4*m6**4 - 20*m5sq*m6**6 + m6**8 - 20*m5**6*m6sq - 6*m5sq*m6sq*(m5sq + m6sq)**2*B0del(0,0,m5sq,mudim) - 6*m5sq*m6sq*(m5sq + m6sq)**2*B0del(0,0,m6sq,mudim) + 2*m5**8*B0fin(0,0,m5sq,mudim) - 30*m5**4*m6**4*B0fin(0,0,m5sq,mudim) + 4*m5**6*m6sq*B0fin(0,0,m5sq,mudim) - 30*m5**4*m6**4*B0fin(0,0,m6sq,mudim) + 4*m5sq*m6**6*B0fin(0,0,m6sq,mudim) + 2*m6**8*B0fin(0,0,m6sq,mudim) - 12*m5**4*m6**4*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) - 6*m5sq*m6**6*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) - 6*m5**6*m6sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) + 12*m5sq*m6**4*T134fin(m6,m5,0,mudim) + 12*m5**4*m6sq*T134fin(m6,m5,0,mudim))/(m5sq - m6sq)**6
		def eval_6():
			return (m4**4*T134fin(m3,0,0,mudim) - m3**4*T134fin(m4,0,0,mudim))/(m3**6*m4**4 - m3**4*m4**6)
		def eval_7():
			return (-11*m4**4 - 36*m5**4 + 54*m4sq*m5sq + 18*(m4sq - 2*m5sq)*m5sq*B0del(0,0,m5sq,mudim) + 6*(m4**4 - 6*m5**4 - 9*m4sq*m5sq)*B0fin(0,0,m5sq,mudim) + 9*(m4sq - 2*m5sq)*m5sq*B0fin(0,0,m5sq,mudim)**2 + 18*m5sq*T134fin(m5,m5,m4,mudim))/(18.*m4**6*m5**2)
		def eval_8():
			return -0.5*(m4**4*m5**6 + 2*m4sq*m5**8 - 4*m4sq*m5**4*m6**4 + 3*m4**4*m5sq*m6**4 + m4**4*m6**6 + 2*m4sq*m6**8 + 3*m4**4*m5**4*m6sq + 2*m4sq*m5sq*m6sq*(2*(m5sq - m6sq)**2 + m4sq*(m5sq + m6sq))*B0del(0,0,m5sq,mudim) + 2*m4sq*m5sq*m6sq*(2*(m5sq - m6sq)**2 + m4sq*(m5sq + m6sq))*B0del(0,0,m6sq,mudim) - 2*m4**4*m5**6*B0fin(0,0,m5sq,mudim) + 4*m4sq*m5**8*B0fin(0,0,m5sq,mudim) + 4*m4sq*m5**4*m6**4*B0fin(0,0,m5sq,mudim) + 6*m4**4*m5**4*m6sq*B0fin(0,0,m5sq,mudim) - 8*m4sq*m5**6*m6sq*B0fin(0,0,m5sq,mudim) + 4*m4sq*m5**4*m6**4*B0fin(0,0,m6sq,mudim) + 6*m4**4*m5sq*m6**4*B0fin(0,0,m6sq,mudim) - 2*m4**4*m6**6*B0fin(0,0,m6sq,mudim) - 8*m4sq*m5sq*m6**6*B0fin(0,0,m6sq,mudim) + 4*m4sq*m6**8*B0fin(0,0,m6sq,mudim) - 8*m4sq*m5**4*m6**4*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m4**4*m5sq*m6**4*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) + 4*m4sq*m5sq*m6**6*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m4**4*m5**4*m6sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) + 4*m4sq*m5**6*m6sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m4sq*m5**6*T134fin(m6,m5,0,mudim) + 2*m5**8*T134fin(m6,m5,0,mudim) + 12*m5**4*m6**4*T134fin(m6,m5,0,mudim) + 2*m4sq*m5sq*m6**4*T134fin(m6,m5,0,mudim) - 2*m4sq*m6**6*T134fin(m6,m5,0,mudim) - 8*m5sq*m6**6*T134fin(m6,m5,0,mudim) + 2*m6**8*T134fin(m6,m5,0,mudim) + 2*m4sq*m5**4*m6sq*T134fin(m6,m5,0,mudim) - 8*m5**6*m6sq*T134fin(m6,m5,0,mudim) - 4*m4**4*m5sq*m6sq*T134fin(m6,m5,0,mudim) - 2*m5**8*T134fin(m6,m5,m4,mudim) - 12*m5**4*m6**4*T134fin(m6,m5,m4,mudim) + 8*m5sq*m6**6*T134fin(m6,m5,m4,mudim) - 2*m6**8*T134fin(m6,m5,m4,mudim) + 8*m5**6*m6sq*T134fin(m6,m5,m4,mudim))/(m4**6*(m5sq - m6sq)**4)
		def eval_9():
			return -0.5*(8*m3**4 + 24*m5**4 - 32*m3sq*m5sq + 4*m3sq*m5sq*B0del(0,0,m3sq,mudim) + 2*(m3**4 + 12*m5**4 - 6*m3sq*m5sq)*B0del(0,0,m5sq,mudim) + 4*m3**4*B0fin(0,0,m3sq,mudim) - 12*m3sq*m5sq*B0fin(0,0,m3sq,mudim) - 6*m3**4*B0fin(0,0,m5sq,mudim) + 24*m5**4*B0fin(0,0,m5sq,mudim) + 20*m3sq*m5sq*B0fin(0,0,m5sq,mudim) + 4*m3sq*m5sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + m3**4*B0fin(0,0,m5sq,mudim)**2 + 12*m5**4*B0fin(0,0,m5sq,mudim)**2 - 8*m3sq*m5sq*B0fin(0,0,m5sq,mudim)**2 + 2*m3sq*T134fin(m5,m5,m3,mudim) - 12*m5sq*T134fin(m5,m5,m3,mudim))/(m3**6*(m3sq - 4*m5sq))
		def eval_10():
			return (6*m3sq*m4**4 - 6*m3**4*m4sq + 4*m3**4*m5sq - 4*m4**4*m5sq + (2*m3sq*m4**4 - 2*m3**4*(m4sq - 2*m5sq) - 4*m4**4*m5sq)*B0del(0,0,m5sq,mudim) + (-6*m3sq*m4**4 - 4*m4**4*m5sq + m3**4*(6*m4sq + 4*m5sq))*B0fin(0,0,m5sq,mudim) + (m3sq*m4**4 - m3**4*(m4sq - 2*m5sq) - 2*m4**4*m5sq)*B0fin(0,0,m5sq,mudim)**2 + 2*m4**4*T134fin(m5,m5,m3,mudim) - 2*m3**4*T134fin(m5,m5,m4,mudim))/(2.*m3**4*m4**4*(m3sq - m4sq))
		def eval_11():
			return (-1 + 4*B0fin(0,0,m1sq,mudim))/(12.*m1**4)
		def eval_12():
			return (-1 + 4*B0fin(0,0,m1sq,mudim))/(12.*m1**4)
		def eval_13():
			return (2*m2sq*(m1sq + m2sq)*B0del(0,0,m2sq,mudim) + (-2*m1**4 + 4*m2**4 + 2*m1sq*m2sq)*B0fin(0,0,m2sq,mudim) + m2sq*(m1sq + m2sq)*B0fin(0,0,m2sq,mudim)**2 + 2*(m1**4 + 3*m2**4 - 2*m1sq*m2sq - m2sq*T134fin(m2,m1,0,mudim)))/(2.*m2**2*(-m1sq + m2sq)**3)
		def eval_14():
			return (2*m2sq*(m1sq + m2sq)*B0del(0,0,m2sq,mudim) + (-2*m1**4 + 4*m2**4 + 2*m1sq*m2sq)*B0fin(0,0,m2sq,mudim) + m2sq*(m1sq + m2sq)*B0fin(0,0,m2sq,mudim)**2 + 2*(m1**4 + 3*m2**4 - 2*m1sq*m2sq - m2sq*T134fin(m2,m1,0,mudim)))/(2.*m2**2*(-m1sq + m2sq)**3)
		def eval_15():
			return (-2*m1sq + 6*m3sq - 2*m3sq*B0del(0,0,m1sq,mudim) + 2*(m1sq + 2*m3sq)*B0del(0,0,m3sq,mudim) - 4*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m1sq,mudim) - 2*m1sq*B0fin(0,0,m3sq,mudim) + 8*m3sq*B0fin(0,0,m3sq,mudim) - 2*m3sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + m1sq*B0fin(0,0,m3sq,mudim)**2 + 3*m3sq*B0fin(0,0,m3sq,mudim)**2 - 2*T134fin(m3,m1,0,mudim))/(2.*(m1sq - m3sq)**3)
		def eval_16():
			return (-2*m1sq + 6*m3sq - 2*m3sq*B0del(0,0,m1sq,mudim) + 2*(m1sq + 2*m3sq)*B0del(0,0,m3sq,mudim) - 4*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m1sq,mudim) - 2*m1sq*B0fin(0,0,m3sq,mudim) + 8*m3sq*B0fin(0,0,m3sq,mudim) - 2*m3sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + m1sq*B0fin(0,0,m3sq,mudim)**2 + 3*m3sq*B0fin(0,0,m3sq,mudim)**2 - 2*T134fin(m3,m1,0,mudim))/(2.*(m1sq - m3sq)**3)
		def eval_17():
			return (-6*m1sq + 2*m3sq - 2*(2*m1sq + m3sq)*B0del(0,0,m1sq,mudim) + 2*m1sq*B0del(0,0,m3sq,mudim) - 8*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m1sq,mudim) - 3*m1sq*B0fin(0,0,m1sq,mudim)**2 - m3sq*B0fin(0,0,m1sq,mudim)**2 - 2*m1sq*B0fin(0,0,m3sq,mudim) + 4*m3sq*B0fin(0,0,m3sq,mudim) + 2*m1sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 2*T134fin(m3,m1,0,mudim))/(2.*(m1sq - m3sq)**3)
		def eval_18():
			return (-6*m1sq + 2*m3sq - 2*(2*m1sq + m3sq)*B0del(0,0,m1sq,mudim) + 2*m1sq*B0del(0,0,m3sq,mudim) - 8*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m1sq,mudim) - 3*m1sq*B0fin(0,0,m1sq,mudim)**2 - m3sq*B0fin(0,0,m1sq,mudim)**2 - 2*m1sq*B0fin(0,0,m3sq,mudim) + 4*m3sq*B0fin(0,0,m3sq,mudim) + 2*m1sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 2*T134fin(m3,m1,0,mudim))/(2.*(m1sq - m3sq)**3)
		def eval_19():
			return (2*m1sq*(m1sq + m4sq)*B0del(0,0,m1sq,mudim) + 2*(2*m1**4 - m4**4 + m1sq*m4sq)*B0fin(0,0,m1sq,mudim) + m1sq*(m1sq + m4sq)*B0fin(0,0,m1sq,mudim)**2 + 2*(3*m1**4 + m4**4 - 2*m1sq*m4sq - m1sq*T134fin(m4,m1,0,mudim)))/(2.*m1**2*(m1sq - m4sq)**3)
		def eval_20():
			return (2*m1sq*(m1sq + m4sq)*B0del(0,0,m1sq,mudim) + 2*(2*m1**4 - m4**4 + m1sq*m4sq)*B0fin(0,0,m1sq,mudim) + m1sq*(m1sq + m4sq)*B0fin(0,0,m1sq,mudim)**2 + 2*(3*m1**4 + m4**4 - 2*m1sq*m4sq - m1sq*T134fin(m4,m1,0,mudim)))/(2.*m1**2*(m1sq - m4sq)**3)
		def eval_21():
			return (4*(m1sq - m2sq)*(m1sq + m2sq - 2*m3sq)*m3sq + 2*(m1sq - m2sq)*((m2sq - 3*m3sq)*m3sq + m1sq*(m2sq + m3sq))*B0del(0,0,m3sq,mudim) - 2*(m1sq - m2sq)*(5*m3**4 + m1sq*(m2sq - 3*m3sq) - 3*m2sq*m3sq)*B0fin(0,0,m3sq,mudim) + (m1sq - m2sq)*((m2sq - 3*m3sq)*m3sq + m1sq*(m2sq + m3sq))*B0fin(0,0,m3sq,mudim)**2 + 2*(m2sq - m3sq)**2*T134fin(m3,m1,0,mudim) - 2*(m1sq - m3sq)**2*T134fin(m3,m2,0,mudim))/(2.*(m1sq - m2sq)*(m1sq - m3sq)**2*(m2sq - m3sq)**2)
		def eval_22():
			return (4*(m1sq - m2sq)*(m1sq + m2sq - 2*m3sq)*m3sq + 2*(m1sq - m2sq)*((m2sq - 3*m3sq)*m3sq + m1sq*(m2sq + m3sq))*B0del(0,0,m3sq,mudim) - 2*(m1sq - m2sq)*(5*m3**4 + m1sq*(m2sq - 3*m3sq) - 3*m2sq*m3sq)*B0fin(0,0,m3sq,mudim) + (m1sq - m2sq)*((m2sq - 3*m3sq)*m3sq + m1sq*(m2sq + m3sq))*B0fin(0,0,m3sq,mudim)**2 + 2*(m2sq - m3sq)**2*T134fin(m3,m1,0,mudim) - 2*(m1sq - m3sq)**2*T134fin(m3,m2,0,mudim))/(2.*(m1sq - m2sq)*(m1sq - m3sq)**2*(m2sq - m3sq)**2)
		def eval_23():
			return (4*m2sq*(m1sq - m4sq)*(m1sq - 2*m2sq + m4sq) + 2*(m1sq - m4sq)*(-3*m2**4 + m2sq*m4sq + m1sq*(m2sq + m4sq))*B0del(0,0,m2sq,mudim) - 2*(m1sq - m4sq)*(5*m2**4 - 3*m2sq*m4sq + m1sq*(-3*m2sq + m4sq))*B0fin(0,0,m2sq,mudim) + (m1sq - m4sq)*(-3*m2**4 + m2sq*m4sq + m1sq*(m2sq + m4sq))*B0fin(0,0,m2sq,mudim)**2 + 2*(m2sq - m4sq)**2*T134fin(m2,m1,0,mudim) - 2*(m1sq - m2sq)**2*T134fin(m4,m2,0,mudim))/(2.*(m1sq - m2sq)**2*(m1sq - m4sq)*(m2sq - m4sq)**2)
		def eval_24():
			return (4*m2sq*(m1sq - m4sq)*(m1sq - 2*m2sq + m4sq) + 2*(m1sq - m4sq)*(-3*m2**4 + m2sq*m4sq + m1sq*(m2sq + m4sq))*B0del(0,0,m2sq,mudim) - 2*(m1sq - m4sq)*(5*m2**4 - 3*m2sq*m4sq + m1sq*(-3*m2sq + m4sq))*B0fin(0,0,m2sq,mudim) + (m1sq - m4sq)*(-3*m2**4 + m2sq*m4sq + m1sq*(m2sq + m4sq))*B0fin(0,0,m2sq,mudim)**2 + 2*(m2sq - m4sq)**2*T134fin(m2,m1,0,mudim) - 2*(m1sq - m2sq)**2*T134fin(m4,m2,0,mudim))/(2.*(m1sq - m2sq)**2*(m1sq - m4sq)*(m2sq - m4sq)**2)
		def eval_25():
			return (4*m1sq*m3**4 - 8*m1**4*m3sq - 4*m1sq*m4**4 + 8*m1**4*m4sq + 2*(m3sq - m4sq)*(-3*m1**4 + m3sq*m4sq + m1sq*(m3sq + m4sq))*B0del(0,0,m1sq,mudim) - 2*(m3sq - m4sq)*(5*m1**4 + m3sq*m4sq - 3*m1sq*(m3sq + m4sq))*B0fin(0,0,m1sq,mudim) + (m3sq - m4sq)*(-3*m1**4 + m3sq*m4sq + m1sq*(m3sq + m4sq))*B0fin(0,0,m1sq,mudim)**2 + 2*m1**4*T134fin(m3,m1,0,mudim) + 2*m4**4*T134fin(m3,m1,0,mudim) - 4*m1sq*m4sq*T134fin(m3,m1,0,mudim) - 2*m1**4*T134fin(m4,m1,0,mudim) - 2*m3**4*T134fin(m4,m1,0,mudim) + 4*m1sq*m3sq*T134fin(m4,m1,0,mudim))/(2.*(m1sq - m3sq)**2*(m1sq - m4sq)**2*(m3sq - m4sq))
		def eval_26():
			return (4*m1sq*m3**4 - 8*m1**4*m3sq - 4*m1sq*m4**4 + 8*m1**4*m4sq + 2*(m3sq - m4sq)*(-3*m1**4 + m3sq*m4sq + m1sq*(m3sq + m4sq))*B0del(0,0,m1sq,mudim) - 2*(m3sq - m4sq)*(5*m1**4 + m3sq*m4sq - 3*m1sq*(m3sq + m4sq))*B0fin(0,0,m1sq,mudim) + (m3sq - m4sq)*(-3*m1**4 + m3sq*m4sq + m1sq*(m3sq + m4sq))*B0fin(0,0,m1sq,mudim)**2 + 2*m1**4*T134fin(m3,m1,0,mudim) + 2*m4**4*T134fin(m3,m1,0,mudim) - 4*m1sq*m4sq*T134fin(m3,m1,0,mudim) - 2*m1**4*T134fin(m4,m1,0,mudim) - 2*m3**4*T134fin(m4,m1,0,mudim) + 4*m1sq*m3sq*T134fin(m4,m1,0,mudim))/(2.*(m1sq - m3sq)**2*(m1sq - m4sq)**2*(m3sq - m4sq))
		def eval_27():
			return (m1**12 + 10*m1**8*m5**4 - 10*m1**6*m5**6 + 5*m1**4*m5**8 - m1sq*m5**10 - 5*m1**10*m5sq + 10*m1**8*m6**4 + 22*m1**4*m5**4*m6**4 - 2*m1sq*m5**6*m6**4 - 6*m1**6*m5sq*m6**4 - 10*m1**6*m6**6 - 2*m1sq*m5**4*m6**6 + 8*m1**4*m5sq*m6**6 + 5*m1**4*m6**8 + 3*m1sq*m5sq*m6**8 - m1sq*m6**10 - 5*m1**10*m6sq - 6*m1**6*m5**4*m6sq + 8*m1**4*m5**6*m6sq + 3*m1sq*m5**8*m6sq - 12*m1**6*m5sq*(m1sq - m5sq - m6sq)*m6sq*B0del(0,0,m1sq,mudim) - 12*m1**4*m5**4*(m1sq - m5sq - m6sq)*m6sq*B0del(0,0,m5sq,mudim) + 12*m1**4*m5**4*m6**4*B0del(0,0,m6sq,mudim) - 12*m1**6*m5sq*m6**4*B0del(0,0,m6sq,mudim) + 12*m1**4*m5sq*m6**6*B0del(0,0,m6sq,mudim) + 2*m1**12*B0fin(0,0,m1sq,mudim) + 21*m1**8*m5**4*B0fin(0,0,m1sq,mudim) - 24*m1**6*m5**6*B0fin(0,0,m1sq,mudim) + 16*m1**4*m5**8*B0fin(0,0,m1sq,mudim) - 6*m1sq*m5**10*B0fin(0,0,m1sq,mudim) + m5**12*B0fin(0,0,m1sq,mudim) - 10*m1**10*m5sq*B0fin(0,0,m1sq,mudim) + 21*m1**8*m6**4*B0fin(0,0,m1sq,mudim) - 24*m1**4*m5**4*m6**4*B0fin(0,0,m1sq,mudim) - 12*m1sq*m5**6*m6**4*B0fin(0,0,m1sq,mudim) + 15*m5**8*m6**4*B0fin(0,0,m1sq,mudim) - 20*m1**6*m5sq*m6**4*B0fin(0,0,m1sq,mudim) - 24*m1**6*m6**6*B0fin(0,0,m1sq,mudim) - 12*m1sq*m5**4*m6**6*B0fin(0,0,m1sq,mudim) - 20*m5**6*m6**6*B0fin(0,0,m1sq,mudim) - 4*m1**4*m5sq*m6**6*B0fin(0,0,m1sq,mudim) + 16*m1**4*m6**8*B0fin(0,0,m1sq,mudim) + 15*m5**4*m6**8*B0fin(0,0,m1sq,mudim) + 18*m1sq*m5sq*m6**8*B0fin(0,0,m1sq,mudim) - 6*m1sq*m6**10*B0fin(0,0,m1sq,mudim) - 6*m5sq*m6**10*B0fin(0,0,m1sq,mudim) + m6**12*B0fin(0,0,m1sq,mudim) - 10*m1**10*m6sq*B0fin(0,0,m1sq,mudim) - 20*m1**6*m5**4*m6sq*B0fin(0,0,m1sq,mudim) - 4*m1**4*m5**6*m6sq*B0fin(0,0,m1sq,mudim) + 18*m1sq*m5**8*m6sq*B0fin(0,0,m1sq,mudim) - 6*m5**10*m6sq*B0fin(0,0,m1sq,mudim) + 22*m1**8*m5sq*m6sq*B0fin(0,0,m1sq,mudim) + 9*m1**8*m5**4*B0fin(0,0,m5sq,mudim) - 16*m1**6*m5**6*B0fin(0,0,m5sq,mudim) + 14*m1**4*m5**8*B0fin(0,0,m5sq,mudim) - 6*m1sq*m5**10*B0fin(0,0,m5sq,mudim) + m5**12*B0fin(0,0,m5sq,mudim) - 2*m1**10*m5sq*B0fin(0,0,m5sq,mudim) + 18*m1**4*m5**4*m6**4*B0fin(0,0,m5sq,mudim) + 6*m1sq*m5**6*m6**4*B0fin(0,0,m5sq,mudim) + 10*m5**8*m6**4*B0fin(0,0,m5sq,mudim) + 10*m1**6*m5sq*m6**4*B0fin(0,0,m5sq,mudim) - 18*m1sq*m5**4*m6**6*B0fin(0,0,m5sq,mudim) - 10*m5**6*m6**6*B0fin(0,0,m5sq,mudim) - 16*m1**4*m5sq*m6**6*B0fin(0,0,m5sq,mudim) + 5*m5**4*m6**8*B0fin(0,0,m5sq,mudim) + 8*m1sq*m5sq*m6**8*B0fin(0,0,m5sq,mudim) - m5sq*m6**10*B0fin(0,0,m5sq,mudim) - 14*m1**6*m5**4*m6sq*B0fin(0,0,m5sq,mudim) + 8*m1**4*m5**6*m6sq*B0fin(0,0,m5sq,mudim) + 10*m1sq*m5**8*m6sq*B0fin(0,0,m5sq,mudim) - 5*m5**10*m6sq*B0fin(0,0,m5sq,mudim) + m1**8*m5sq*m6sq*B0fin(0,0,m5sq,mudim) + 12*m1**6*m5sq*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 6*m1**4*m5sq*m6**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 6*m1**4*m5**6*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 6*m1**8*m5sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 9*m1**8*m6**4*B0fin(0,0,m6sq,mudim) + 18*m1**4*m5**4*m6**4*B0fin(0,0,m6sq,mudim) - 18*m1sq*m5**6*m6**4*B0fin(0,0,m6sq,mudim) + 5*m5**8*m6**4*B0fin(0,0,m6sq,mudim) - 14*m1**6*m5sq*m6**4*B0fin(0,0,m6sq,mudim) - 16*m1**6*m6**6*B0fin(0,0,m6sq,mudim) + 6*m1sq*m5**4*m6**6*B0fin(0,0,m6sq,mudim) - 10*m5**6*m6**6*B0fin(0,0,m6sq,mudim) + 8*m1**4*m5sq*m6**6*B0fin(0,0,m6sq,mudim) + 14*m1**4*m6**8*B0fin(0,0,m6sq,mudim) + 10*m5**4*m6**8*B0fin(0,0,m6sq,mudim) + 10*m1sq*m5sq*m6**8*B0fin(0,0,m6sq,mudim) - 6*m1sq*m6**10*B0fin(0,0,m6sq,mudim) - 5*m5sq*m6**10*B0fin(0,0,m6sq,mudim) + m6**12*B0fin(0,0,m6sq,mudim) - 2*m1**10*m6sq*B0fin(0,0,m6sq,mudim) + 10*m1**6*m5**4*m6sq*B0fin(0,0,m6sq,mudim) - 16*m1**4*m5**6*m6sq*B0fin(0,0,m6sq,mudim) + 8*m1sq*m5**8*m6sq*B0fin(0,0,m6sq,mudim) - m5**10*m6sq*B0fin(0,0,m6sq,mudim) + m1**8*m5sq*m6sq*B0fin(0,0,m6sq,mudim) + 6*m1**4*m5sq*m6**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 12*m1**6*m5**4*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 6*m1**4*m5**6*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 6*m1**8*m5sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 12*m1**4*m5**4*m6**4*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) - 12*m1**6*m5sq*m6**4*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) + 6*m1**4*m5sq*m6**6*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) - 12*m1**6*m5**4*m6sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) + 6*m1**4*m5**6*m6sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) + 6*m1**8*m5sq*m6sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) - 12*m1**4*m5sq*m6**4*T134fin(m6,m5,m1,mudim) - 12*m1**4*m5**4*m6sq*T134fin(m6,m5,m1,mudim) + 12*m1**6*m5sq*m6sq*T134fin(m6,m5,m1,mudim))/(6.*m1**4*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3)
		def eval_28():
			return -0.5*(-(m1**4*m2**8) + 4*m1sq*m2**10 - 3*m2**12 - 6*m1**4*m2**4*m5**4 + 12*m1sq*m2**6*m5**4 - 6*m2**8*m5**4 - 4*m1sq*m2**4*m5**6 + 4*m1**4*m2sq*m5**6 - m1**4*m5**8 + m2**4*m5**8 + 4*m1**4*m2**6*m5sq - 12*m1sq*m2**8*m5sq + 8*m2**10*m5sq - 6*m1**4*m2**4*m6**4 + 12*m1sq*m2**6*m6**4 - 6*m2**8*m6**4 - 6*m1**4*m5**4*m6**4 - 10*m2**4*m5**4*m6**4 + 16*m1sq*m2sq*m5**4*m6**4 + 28*m1sq*m2**4*m5sq*m6**4 - 20*m2**6*m5sq*m6**4 - 8*m1**4*m2sq*m5sq*m6**4 - 4*m1sq*m2**4*m6**6 + 4*m1**4*m2sq*m6**6 + 4*m1**4*m5sq*m6**6 + 4*m2**4*m5sq*m6**6 - 8*m1sq*m2sq*m5sq*m6**6 - m1**4*m6**8 + m2**4*m6**8 + 4*m1**4*m2**6*m6sq - 12*m1sq*m2**8*m6sq + 8*m2**10*m6sq + 28*m1sq*m2**4*m5**4*m6sq - 20*m2**6*m5**4*m6sq - 8*m1**4*m2sq*m5**4*m6sq + 4*m1**4*m5**6*m6sq + 4*m2**4*m5**6*m6sq - 8*m1sq*m2sq*m5**6*m6sq - 8*m1**4*m2**4*m5sq*m6sq + 8*m1sq*m2**6*m5sq*m6sq - 2*(m1sq - m2sq)*m2sq*(3*m2**4*(m5**4 + m6**4) + (m5sq - m6sq)**4 - m2**6*(m5sq + m6sq) + m2sq*(-3*m5**6 - 3*m6**6 + 3*m5**4*m6sq + m5sq*(3*m6**4 + 2*m1sq*m6sq)))*B0del(0,0,m2sq,mudim) - 2*m2sq*(-m1sq + m2sq)*m5sq*(m2**6 - m5**6 - m6**6 + m5**4*m6sq - 3*m2**4*(m5sq + m6sq) + m5sq*(m6**4 - 2*m1sq*m6sq) + m2sq*(3*m5**4 + 3*m6**4 + 4*m5sq*m6sq))*B0del(0,0,m5sq,mudim) - 6*m1sq*m2**6*m6**4*B0del(0,0,m6sq,mudim) + 6*m2**8*m6**4*B0del(0,0,m6sq,mudim) - 2*m2**4*m5**4*m6**4*B0del(0,0,m6sq,mudim) + 2*m1sq*m2sq*m5**4*m6**4*B0del(0,0,m6sq,mudim) + 12*m1sq*m2**4*m5sq*m6**4*B0del(0,0,m6sq,mudim) - 8*m2**6*m5sq*m6**4*B0del(0,0,m6sq,mudim) - 4*m1**4*m2sq*m5sq*m6**4*B0del(0,0,m6sq,mudim) + 6*m1sq*m2**4*m6**6*B0del(0,0,m6sq,mudim) - 6*m2**6*m6**6*B0del(0,0,m6sq,mudim) - 2*m2**4*m5sq*m6**6*B0del(0,0,m6sq,mudim) + 2*m1sq*m2sq*m5sq*m6**6*B0del(0,0,m6sq,mudim) + 2*m2**4*m6**8*B0del(0,0,m6sq,mudim) - 2*m1sq*m2sq*m6**8*B0del(0,0,m6sq,mudim) + 2*m1sq*m2**8*m6sq*B0del(0,0,m6sq,mudim) - 2*m2**10*m6sq*B0del(0,0,m6sq,mudim) + 6*m1sq*m2**4*m5**4*m6sq*B0del(0,0,m6sq,mudim) - 6*m2**6*m5**4*m6sq*B0del(0,0,m6sq,mudim) + 2*m2**4*m5**6*m6sq*B0del(0,0,m6sq,mudim) - 2*m1sq*m2sq*m5**6*m6sq*B0del(0,0,m6sq,mudim) - 6*m1sq*m2**6*m5sq*m6sq*B0del(0,0,m6sq,mudim) + 6*m2**8*m5sq*m6sq*B0del(0,0,m6sq,mudim) + 2*m1**4*m2**8*B0fin(0,0,m2sq,mudim) - 2*m2**12*B0fin(0,0,m2sq,mudim) + 9*m1**4*m2**4*m5**4*B0fin(0,0,m2sq,mudim) - 9*m2**8*m5**4*B0fin(0,0,m2sq,mudim) + 5*m2**6*m5**6*B0fin(0,0,m2sq,mudim) - 5*m1**4*m2sq*m5**6*B0fin(0,0,m2sq,mudim) + m1**4*m5**8*B0fin(0,0,m2sq,mudim) - m2**4*m5**8*B0fin(0,0,m2sq,mudim) - 7*m1**4*m2**6*m5sq*B0fin(0,0,m2sq,mudim) + 7*m2**10*m5sq*B0fin(0,0,m2sq,mudim) + 9*m1**4*m2**4*m6**4*B0fin(0,0,m2sq,mudim) - 9*m2**8*m6**4*B0fin(0,0,m2sq,mudim) + 6*m1**4*m5**4*m6**4*B0fin(0,0,m2sq,mudim) - 6*m2**4*m5**4*m6**4*B0fin(0,0,m2sq,mudim) - 5*m2**6*m5sq*m6**4*B0fin(0,0,m2sq,mudim) + 5*m1**4*m2sq*m5sq*m6**4*B0fin(0,0,m2sq,mudim) + 5*m2**6*m6**6*B0fin(0,0,m2sq,mudim) - 5*m1**4*m2sq*m6**6*B0fin(0,0,m2sq,mudim) - 4*m1**4*m5sq*m6**6*B0fin(0,0,m2sq,mudim) + 4*m2**4*m5sq*m6**6*B0fin(0,0,m2sq,mudim) + m1**4*m6**8*B0fin(0,0,m2sq,mudim) - m2**4*m6**8*B0fin(0,0,m2sq,mudim) - 7*m1**4*m2**6*m6sq*B0fin(0,0,m2sq,mudim) + 7*m2**10*m6sq*B0fin(0,0,m2sq,mudim) - 5*m2**6*m5**4*m6sq*B0fin(0,0,m2sq,mudim) + 5*m1**4*m2sq*m5**4*m6sq*B0fin(0,0,m2sq,mudim) - 4*m1**4*m5**6*m6sq*B0fin(0,0,m2sq,mudim) + 4*m2**4*m5**6*m6sq*B0fin(0,0,m2sq,mudim) + 2*m1**4*m2**4*m5sq*m6sq*B0fin(0,0,m2sq,mudim) + 8*m1sq*m2**6*m5sq*m6sq*B0fin(0,0,m2sq,mudim) - 10*m2**8*m5sq*m6sq*B0fin(0,0,m2sq,mudim) + 3*m1**4*m2**4*m5**4*B0fin(0,0,m5sq,mudim) - 12*m1sq*m2**6*m5**4*B0fin(0,0,m5sq,mudim) + 9*m2**8*m5**4*B0fin(0,0,m5sq,mudim) + 12*m1sq*m2**4*m5**6*B0fin(0,0,m5sq,mudim) - 9*m2**6*m5**6*B0fin(0,0,m5sq,mudim) - 3*m1**4*m2sq*m5**6*B0fin(0,0,m5sq,mudim) + m1**4*m5**8*B0fin(0,0,m5sq,mudim) + 3*m2**4*m5**8*B0fin(0,0,m5sq,mudim) - 4*m1sq*m2sq*m5**8*B0fin(0,0,m5sq,mudim) - m1**4*m2**6*m5sq*B0fin(0,0,m5sq,mudim) + 4*m1sq*m2**8*m5sq*B0fin(0,0,m5sq,mudim) - 3*m2**10*m5sq*B0fin(0,0,m5sq,mudim) + 3*m1**4*m5**4*m6**4*B0fin(0,0,m5sq,mudim) + m2**4*m5**4*m6**4*B0fin(0,0,m5sq,mudim) - 4*m1sq*m2sq*m5**4*m6**4*B0fin(0,0,m5sq,mudim) + 4*m1sq*m2**4*m5sq*m6**4*B0fin(0,0,m5sq,mudim) - 5*m2**6*m5sq*m6**4*B0fin(0,0,m5sq,mudim) + m1**4*m2sq*m5sq*m6**4*B0fin(0,0,m5sq,mudim) - m1**4*m5sq*m6**6*B0fin(0,0,m5sq,mudim) + m2**4*m5sq*m6**6*B0fin(0,0,m5sq,mudim) + 8*m1sq*m2**4*m5**4*m6sq*B0fin(0,0,m5sq,mudim) - 6*m2**6*m5**4*m6sq*B0fin(0,0,m5sq,mudim) - 2*m1**4*m2sq*m5**4*m6sq*B0fin(0,0,m5sq,mudim) - 3*m1**4*m5**6*m6sq*B0fin(0,0,m5sq,mudim) - 5*m2**4*m5**6*m6sq*B0fin(0,0,m5sq,mudim) + 8*m1sq*m2sq*m5**6*m6sq*B0fin(0,0,m5sq,mudim) + m1**4*m2**4*m5sq*m6sq*B0fin(0,0,m5sq,mudim) - 8*m1sq*m2**6*m5sq*m6sq*B0fin(0,0,m5sq,mudim) + 7*m2**8*m5sq*m6sq*B0fin(0,0,m5sq,mudim) - 6*m1sq*m2**6*m5**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 6*m2**8*m5**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 6*m1sq*m2**4*m5**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 6*m2**6*m5**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m2**4*m5**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m1sq*m2sq*m5**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m1sq*m2**8*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m2**10*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 6*m2**4*m5**4*m6**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 6*m1sq*m2sq*m5**4*m6**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 6*m1sq*m2**4*m5sq*m6**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 4*m2**6*m5sq*m6**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m1**4*m2sq*m5sq*m6**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m2**4*m5sq*m6**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m1sq*m2sq*m5sq*m6**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m2**6*m5**4*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m1**4*m2sq*m5**4*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 6*m2**4*m5**6*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 6*m1sq*m2sq*m5**6*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m1**4*m2**4*m5sq*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m1sq*m2**6*m5sq*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 3*m1**4*m2**4*m6**4*B0fin(0,0,m6sq,mudim) - 12*m1sq*m2**6*m6**4*B0fin(0,0,m6sq,mudim) + 9*m2**8*m6**4*B0fin(0,0,m6sq,mudim) + 3*m1**4*m5**4*m6**4*B0fin(0,0,m6sq,mudim) + m2**4*m5**4*m6**4*B0fin(0,0,m6sq,mudim) - 4*m1sq*m2sq*m5**4*m6**4*B0fin(0,0,m6sq,mudim) + 8*m1sq*m2**4*m5sq*m6**4*B0fin(0,0,m6sq,mudim) - 6*m2**6*m5sq*m6**4*B0fin(0,0,m6sq,mudim) - 2*m1**4*m2sq*m5sq*m6**4*B0fin(0,0,m6sq,mudim) + 12*m1sq*m2**4*m6**6*B0fin(0,0,m6sq,mudim) - 9*m2**6*m6**6*B0fin(0,0,m6sq,mudim) - 3*m1**4*m2sq*m6**6*B0fin(0,0,m6sq,mudim) - 3*m1**4*m5sq*m6**6*B0fin(0,0,m6sq,mudim) - 5*m2**4*m5sq*m6**6*B0fin(0,0,m6sq,mudim) + 8*m1sq*m2sq*m5sq*m6**6*B0fin(0,0,m6sq,mudim) + m1**4*m6**8*B0fin(0,0,m6sq,mudim) + 3*m2**4*m6**8*B0fin(0,0,m6sq,mudim) - 4*m1sq*m2sq*m6**8*B0fin(0,0,m6sq,mudim) - m1**4*m2**6*m6sq*B0fin(0,0,m6sq,mudim) + 4*m1sq*m2**8*m6sq*B0fin(0,0,m6sq,mudim) - 3*m2**10*m6sq*B0fin(0,0,m6sq,mudim) + 4*m1sq*m2**4*m5**4*m6sq*B0fin(0,0,m6sq,mudim) - 5*m2**6*m5**4*m6sq*B0fin(0,0,m6sq,mudim) + m1**4*m2sq*m5**4*m6sq*B0fin(0,0,m6sq,mudim) - m1**4*m5**6*m6sq*B0fin(0,0,m6sq,mudim) + m2**4*m5**6*m6sq*B0fin(0,0,m6sq,mudim) + m1**4*m2**4*m5sq*m6sq*B0fin(0,0,m6sq,mudim) - 8*m1sq*m2**6*m5sq*m6sq*B0fin(0,0,m6sq,mudim) + 7*m2**8*m5sq*m6sq*B0fin(0,0,m6sq,mudim) - 6*m1sq*m2**6*m6**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) + 6*m2**8*m6**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) + 6*m2**4*m5**4*m6**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) - 6*m1sq*m2sq*m5**4*m6**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m2**6*m5sq*m6**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m1**4*m2sq*m5sq*m6**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) + 6*m1sq*m2**4*m6**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) - 6*m2**6*m6**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) - 6*m2**4*m5sq*m6**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) + 6*m1sq*m2sq*m5sq*m6**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m2**4*m6**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m1sq*m2sq*m6**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m1sq*m2**8*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m2**10*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) - 6*m1sq*m2**4*m5**4*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) + 4*m2**6*m5**4*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m1**4*m2sq*m5**4*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m2**4*m5**6*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m1sq*m2sq*m5**6*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m1**4*m2**4*m5sq*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m1sq*m2**6*m5sq*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) - 8*m2**4*m5**4*m6**4*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) + 8*m1sq*m2sq*m5**4*m6**4*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) + 12*m1sq*m2**4*m5sq*m6**4*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) - 10*m2**6*m5sq*m6**4*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m1**4*m2sq*m5sq*m6**4*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) + 4*m2**4*m5sq*m6**6*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m1sq*m2sq*m5sq*m6**6*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) + 12*m1sq*m2**4*m5**4*m6sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) - 10*m2**6*m5**4*m6sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m1**4*m2sq*m5**4*m6sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) + 4*m2**4*m5**6*m6sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m1sq*m2sq*m5**6*m6sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m1**4*m2**4*m5sq*m6sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) - 8*m1sq*m2**6*m5sq*m6sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) + 6*m2**8*m5sq*m6sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m2**10*T134fin(m6,m5,m1,mudim) + 12*m2**6*m5**4*T134fin(m6,m5,m1,mudim) - 8*m2**4*m5**6*T134fin(m6,m5,m1,mudim) + 2*m2sq*m5**8*T134fin(m6,m5,m1,mudim) - 8*m2**8*m5sq*T134fin(m6,m5,m1,mudim) + 12*m2**6*m6**4*T134fin(m6,m5,m1,mudim) + 12*m2sq*m5**4*m6**4*T134fin(m6,m5,m1,mudim) + 8*m2**4*m5sq*m6**4*T134fin(m6,m5,m1,mudim) - 8*m2**4*m6**6*T134fin(m6,m5,m1,mudim) - 8*m2sq*m5sq*m6**6*T134fin(m6,m5,m1,mudim) + 2*m2sq*m6**8*T134fin(m6,m5,m1,mudim) - 8*m2**8*m6sq*T134fin(m6,m5,m1,mudim) + 8*m2**4*m5**4*m6sq*T134fin(m6,m5,m1,mudim) - 8*m2sq*m5**6*m6sq*T134fin(m6,m5,m1,mudim) + 8*m2**6*m5sq*m6sq*T134fin(m6,m5,m1,mudim) - 2*m1sq*m2**8*T134fin(m6,m5,m2,mudim) - 6*m1sq*m2**4*m5**4*T134fin(m6,m5,m2,mudim) - 6*m2**6*m5**4*T134fin(m6,m5,m2,mudim) + 6*m2**4*m5**6*T134fin(m6,m5,m2,mudim) + 2*m1sq*m2sq*m5**6*T134fin(m6,m5,m2,mudim) - 2*m2sq*m5**8*T134fin(m6,m5,m2,mudim) + 6*m1sq*m2**6*m5sq*T134fin(m6,m5,m2,mudim) + 2*m2**8*m5sq*T134fin(m6,m5,m2,mudim) - 6*m1sq*m2**4*m6**4*T134fin(m6,m5,m2,mudim) - 6*m2**6*m6**4*T134fin(m6,m5,m2,mudim) - 12*m2sq*m5**4*m6**4*T134fin(m6,m5,m2,mudim) - 6*m2**4*m5sq*m6**4*T134fin(m6,m5,m2,mudim) - 2*m1sq*m2sq*m5sq*m6**4*T134fin(m6,m5,m2,mudim) + 6*m2**4*m6**6*T134fin(m6,m5,m2,mudim) + 2*m1sq*m2sq*m6**6*T134fin(m6,m5,m2,mudim) + 8*m2sq*m5sq*m6**6*T134fin(m6,m5,m2,mudim) - 2*m2sq*m6**8*T134fin(m6,m5,m2,mudim) + 6*m1sq*m2**6*m6sq*T134fin(m6,m5,m2,mudim) + 2*m2**8*m6sq*T134fin(m6,m5,m2,mudim) - 6*m2**4*m5**4*m6sq*T134fin(m6,m5,m2,mudim) - 2*m1sq*m2sq*m5**4*m6sq*T134fin(m6,m5,m2,mudim) + 8*m2sq*m5**6*m6sq*T134fin(m6,m5,m2,mudim) - 12*m1sq*m2**4*m5sq*m6sq*T134fin(m6,m5,m2,mudim) + 4*m1**4*m2sq*m5sq*m6sq*T134fin(m6,m5,m2,mudim))/(m2**2*(-m1sq + m2sq)**3*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2)
		def eval_29():
			return (-((m1sq*(m1sq - m3sq)*m5sq*B0del(0,0,m1sq,mudim))/(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) - (m1sq*(m1sq - m3sq)*m6sq*B0del(0,0,m1sq,mudim))/(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq)) + (m3sq*(-m1sq + m3sq)*m5sq*B0del(0,0,m3sq,mudim))/(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq)) + (m3sq*(-m1sq + m3sq)*m6sq*B0del(0,0,m3sq,mudim))/(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq)) - (m1sq*(m1sq - m3sq)*m5sq*B0del(0,0,m5sq,mudim))/(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq)) + ((m1sq - m3sq)*m5sq*(m5sq - m6sq)*B0del(0,0,m5sq,mudim))/(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq)) + (m3sq*(-m1sq + m3sq)*m5sq*B0del(0,0,m5sq,mudim))/(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq)) + ((m1sq - m3sq)*m5sq*(m5sq - m6sq)*B0del(0,0,m5sq,mudim))/(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq)) - (2*(m1sq - m3sq)*m5sq*m6sq*(8*m5sq*m6sq - (-m1sq + m5sq + m6sq)**2 - (-m3sq + m5sq + m6sq)**2)*B0del(0,0,m5sq,mudim))/((4*m5sq*m6sq - (-m1sq + m5sq + m6sq)**2)*(4*m5sq*m6sq - (-m3sq + m5sq + m6sq)**2)) - (m1sq*(m1sq - m3sq)*m6sq*B0del(0,0,m6sq,mudim))/(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq)) + ((m1sq - m3sq)*m6sq*(-m5sq + m6sq)*B0del(0,0,m6sq,mudim))/(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq)) + (m3sq*(-m1sq + m3sq)*m6sq*B0del(0,0,m6sq,mudim))/(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq)) + ((m1sq - m3sq)*m6sq*(-m5sq + m6sq)*B0del(0,0,m6sq,mudim))/(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq)) - (2*(m1sq - m3sq)*m5sq*m6sq*(8*m5sq*m6sq - (-m1sq + m5sq + m6sq)**2 - (-m3sq + m5sq + m6sq)**2)*B0del(0,0,m6sq,mudim))/((4*m5sq*m6sq - (-m1sq + m5sq + m6sq)**2)*(4*m5sq*m6sq - (-m3sq + m5sq + m6sq)**2)) + ((m1sq - m3sq)*m5sq*(m5sq - m6sq)*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq)) + ((m1sq - m3sq)*m6sq*(-m5sq + m6sq)*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq)) + (m1sq*(m1sq - m3sq)*m5sq*B0fin(0,0,m1sq,mudim))/(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq)) + (m1sq*(m1sq - m3sq)*m6sq*B0fin(0,0,m1sq,mudim))/(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq)) + ((m1sq - m3sq)*m5sq*(m5sq - m6sq)*(B0del(0,0,m3sq,mudim) - B0fin(0,0,m3sq,mudim)))/(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq)) + ((m1sq - m3sq)*m6sq*(-m5sq + m6sq)*(B0del(0,0,m3sq,mudim) - B0fin(0,0,m3sq,mudim)))/(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq)) - (m3sq*(-m1sq + m3sq)*m5sq*B0fin(0,0,m3sq,mudim))/(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq)) - (m3sq*(-m1sq + m3sq)*m6sq*B0fin(0,0,m3sq,mudim))/(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq)) + (m1sq*(m1sq - m3sq)*m5sq*B0fin(0,0,m5sq,mudim))/(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq)) - ((m1sq - m3sq)*m5sq*(m5sq - m6sq)*B0fin(0,0,m5sq,mudim))/(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq)) - (m3sq*(-m1sq + m3sq)*m5sq*B0fin(0,0,m5sq,mudim))/(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq)) - ((m1sq - m3sq)*m5sq*(m5sq - m6sq)*B0fin(0,0,m5sq,mudim))/(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq)) + (2*(m1sq - m3sq)*m5sq*m6sq*(8*m5sq*m6sq - (-m1sq + m5sq + m6sq)**2 - (-m3sq + m5sq + m6sq)**2)*B0fin(0,0,m5sq,mudim))/((4*m5sq*m6sq - (-m1sq + m5sq + m6sq)**2)*(4*m5sq*m6sq - (-m3sq + m5sq + m6sq)**2)) - (m1sq*(m1sq - m3sq)*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq)) + ((m1sq - m3sq)*m5sq*(m5sq - m6sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq)) + (m3sq*(-m1sq + m3sq)*m5sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim))/(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq)) + ((m1sq - m3sq)*m5sq*(m5sq - m6sq)*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim))/(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq)) + (m1sq*(m1sq - m3sq)*m6sq*B0fin(0,0,m6sq,mudim))/(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq)) + ((m1sq - m3sq)*(m5sq - m6sq)*m6sq*B0fin(0,0,m6sq,mudim))/(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq)) - (m3sq*(-m1sq + m3sq)*m6sq*B0fin(0,0,m6sq,mudim))/(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq)) + ((m1sq - m3sq)*(m5sq - m6sq)*m6sq*B0fin(0,0,m6sq,mudim))/(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq)) + (2*(m1sq - m3sq)*m5sq*m6sq*(8*m5sq*m6sq - (-m1sq + m5sq + m6sq)**2 - (-m3sq + m5sq + m6sq)**2)*B0fin(0,0,m6sq,mudim))/((4*m5sq*m6sq - (-m1sq + m5sq + m6sq)**2)*(4*m5sq*m6sq - (-m3sq + m5sq + m6sq)**2)) - (m1sq*(m1sq - m3sq)*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq)) + ((m1sq - m3sq)*m6sq*(-m5sq + m6sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq)) + (m3sq*(-m1sq + m3sq)*m6sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim))/(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq)) + ((m1sq - m3sq)*m6sq*(-m5sq + m6sq)*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim))/(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq)) - (2*(m1sq - m3sq)*m5sq*m6sq*(8*m5sq*m6sq - (-m1sq + m5sq + m6sq)**2 - (-m3sq + m5sq + m6sq)**2)*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim))/((4*m5sq*m6sq - (-m1sq + m5sq + m6sq)**2)*(4*m5sq*m6sq - (-m3sq + m5sq + m6sq)**2)) - ((m1sq - m3sq)*(m1sq - m5sq - m6sq)*(m1sq + m5sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq)) - ((m1sq - m3sq)*(m3sq - m5sq - m6sq)*(m3sq + m5sq + m6sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq)) - 2*T134fin(m6,m5,m1,mudim) + ((m1sq - m3sq)*(m1sq - m5sq - m6sq)*T134fin(m6,m5,m1,mudim))/(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq)) + 2*T134fin(m6,m5,m3,mudim) + ((m1sq - m3sq)*(m3sq - m5sq - m6sq)*T134fin(m6,m5,m3,mudim))/(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq)))/(m1sq - m3sq)**3
		def eval_30():
			return -0.5*(-3*m1**12 - m1**8*m4**4 + 4*m1**10*m4sq - 6*m1**8*m5**4 - 6*m1**4*m4**4*m5**4 + 12*m1**6*m4sq*m5**4 + 4*m1sq*m4**4*m5**6 - 4*m1**4*m4sq*m5**6 + m1**4*m5**8 - m4**4*m5**8 + 8*m1**10*m5sq + 4*m1**6*m4**4*m5sq - 12*m1**8*m4sq*m5sq - 6*m1**8*m6**4 - 6*m1**4*m4**4*m6**4 + 12*m1**6*m4sq*m6**4 - 10*m1**4*m5**4*m6**4 - 6*m4**4*m5**4*m6**4 + 16*m1sq*m4sq*m5**4*m6**4 - 20*m1**6*m5sq*m6**4 - 8*m1sq*m4**4*m5sq*m6**4 + 28*m1**4*m4sq*m5sq*m6**4 + 4*m1sq*m4**4*m6**6 - 4*m1**4*m4sq*m6**6 + 4*m1**4*m5sq*m6**6 + 4*m4**4*m5sq*m6**6 - 8*m1sq*m4sq*m5sq*m6**6 + m1**4*m6**8 - m4**4*m6**8 + 8*m1**10*m6sq + 4*m1**6*m4**4*m6sq - 12*m1**8*m4sq*m6sq - 20*m1**6*m5**4*m6sq - 8*m1sq*m4**4*m5**4*m6sq + 28*m1**4*m4sq*m5**4*m6sq + 4*m1**4*m5**6*m6sq + 4*m4**4*m5**6*m6sq - 8*m1sq*m4sq*m5**6*m6sq - 8*m1**4*m4**4*m5sq*m6sq + 8*m1**6*m4sq*m5sq*m6sq - 2*m1sq*(m1sq - m4sq)*(-3*m1**4*(m5**4 + m6**4) - (m5sq - m6sq)**4 + m1**6*(m5sq + m6sq) + m1sq*(3*m5**6 + 3*m6**6 - 3*m5**4*m6sq - m5sq*(3*m6**4 + 2*m4sq*m6sq)))*B0del(0,0,m1sq,mudim) - 2*m1sq*(m1sq - m4sq)*m5sq*(m1**6 - m5**6 - m6**6 + m5**4*m6sq - 3*m1**4*(m5sq + m6sq) + m5sq*(m6**4 - 2*m4sq*m6sq) + m1sq*(3*m5**4 + 3*m6**4 + 4*m5sq*m6sq))*B0del(0,0,m5sq,mudim) + 6*m1**8*m6**4*B0del(0,0,m6sq,mudim) - 6*m1**6*m4sq*m6**4*B0del(0,0,m6sq,mudim) - 2*m1**4*m5**4*m6**4*B0del(0,0,m6sq,mudim) + 2*m1sq*m4sq*m5**4*m6**4*B0del(0,0,m6sq,mudim) - 8*m1**6*m5sq*m6**4*B0del(0,0,m6sq,mudim) - 4*m1sq*m4**4*m5sq*m6**4*B0del(0,0,m6sq,mudim) + 12*m1**4*m4sq*m5sq*m6**4*B0del(0,0,m6sq,mudim) - 6*m1**6*m6**6*B0del(0,0,m6sq,mudim) + 6*m1**4*m4sq*m6**6*B0del(0,0,m6sq,mudim) - 2*m1**4*m5sq*m6**6*B0del(0,0,m6sq,mudim) + 2*m1sq*m4sq*m5sq*m6**6*B0del(0,0,m6sq,mudim) + 2*m1**4*m6**8*B0del(0,0,m6sq,mudim) - 2*m1sq*m4sq*m6**8*B0del(0,0,m6sq,mudim) - 2*m1**10*m6sq*B0del(0,0,m6sq,mudim) + 2*m1**8*m4sq*m6sq*B0del(0,0,m6sq,mudim) - 6*m1**6*m5**4*m6sq*B0del(0,0,m6sq,mudim) + 6*m1**4*m4sq*m5**4*m6sq*B0del(0,0,m6sq,mudim) + 2*m1**4*m5**6*m6sq*B0del(0,0,m6sq,mudim) - 2*m1sq*m4sq*m5**6*m6sq*B0del(0,0,m6sq,mudim) + 6*m1**8*m5sq*m6sq*B0del(0,0,m6sq,mudim) - 6*m1**6*m4sq*m5sq*m6sq*B0del(0,0,m6sq,mudim) - 2*m1**12*B0fin(0,0,m1sq,mudim) + 2*m1**8*m4**4*B0fin(0,0,m1sq,mudim) - 9*m1**8*m5**4*B0fin(0,0,m1sq,mudim) + 9*m1**4*m4**4*m5**4*B0fin(0,0,m1sq,mudim) + 5*m1**6*m5**6*B0fin(0,0,m1sq,mudim) - 5*m1sq*m4**4*m5**6*B0fin(0,0,m1sq,mudim) - m1**4*m5**8*B0fin(0,0,m1sq,mudim) + m4**4*m5**8*B0fin(0,0,m1sq,mudim) + 7*m1**10*m5sq*B0fin(0,0,m1sq,mudim) - 7*m1**6*m4**4*m5sq*B0fin(0,0,m1sq,mudim) - 9*m1**8*m6**4*B0fin(0,0,m1sq,mudim) + 9*m1**4*m4**4*m6**4*B0fin(0,0,m1sq,mudim) - 6*m1**4*m5**4*m6**4*B0fin(0,0,m1sq,mudim) + 6*m4**4*m5**4*m6**4*B0fin(0,0,m1sq,mudim) - 5*m1**6*m5sq*m6**4*B0fin(0,0,m1sq,mudim) + 5*m1sq*m4**4*m5sq*m6**4*B0fin(0,0,m1sq,mudim) + 5*m1**6*m6**6*B0fin(0,0,m1sq,mudim) - 5*m1sq*m4**4*m6**6*B0fin(0,0,m1sq,mudim) + 4*m1**4*m5sq*m6**6*B0fin(0,0,m1sq,mudim) - 4*m4**4*m5sq*m6**6*B0fin(0,0,m1sq,mudim) - m1**4*m6**8*B0fin(0,0,m1sq,mudim) + m4**4*m6**8*B0fin(0,0,m1sq,mudim) + 7*m1**10*m6sq*B0fin(0,0,m1sq,mudim) - 7*m1**6*m4**4*m6sq*B0fin(0,0,m1sq,mudim) - 5*m1**6*m5**4*m6sq*B0fin(0,0,m1sq,mudim) + 5*m1sq*m4**4*m5**4*m6sq*B0fin(0,0,m1sq,mudim) + 4*m1**4*m5**6*m6sq*B0fin(0,0,m1sq,mudim) - 4*m4**4*m5**6*m6sq*B0fin(0,0,m1sq,mudim) - 10*m1**8*m5sq*m6sq*B0fin(0,0,m1sq,mudim) + 2*m1**4*m4**4*m5sq*m6sq*B0fin(0,0,m1sq,mudim) + 8*m1**6*m4sq*m5sq*m6sq*B0fin(0,0,m1sq,mudim) + 9*m1**8*m5**4*B0fin(0,0,m5sq,mudim) + 3*m1**4*m4**4*m5**4*B0fin(0,0,m5sq,mudim) - 12*m1**6*m4sq*m5**4*B0fin(0,0,m5sq,mudim) - 9*m1**6*m5**6*B0fin(0,0,m5sq,mudim) - 3*m1sq*m4**4*m5**6*B0fin(0,0,m5sq,mudim) + 12*m1**4*m4sq*m5**6*B0fin(0,0,m5sq,mudim) + 3*m1**4*m5**8*B0fin(0,0,m5sq,mudim) + m4**4*m5**8*B0fin(0,0,m5sq,mudim) - 4*m1sq*m4sq*m5**8*B0fin(0,0,m5sq,mudim) - 3*m1**10*m5sq*B0fin(0,0,m5sq,mudim) - m1**6*m4**4*m5sq*B0fin(0,0,m5sq,mudim) + 4*m1**8*m4sq*m5sq*B0fin(0,0,m5sq,mudim) + m1**4*m5**4*m6**4*B0fin(0,0,m5sq,mudim) + 3*m4**4*m5**4*m6**4*B0fin(0,0,m5sq,mudim) - 4*m1sq*m4sq*m5**4*m6**4*B0fin(0,0,m5sq,mudim) - 5*m1**6*m5sq*m6**4*B0fin(0,0,m5sq,mudim) + m1sq*m4**4*m5sq*m6**4*B0fin(0,0,m5sq,mudim) + 4*m1**4*m4sq*m5sq*m6**4*B0fin(0,0,m5sq,mudim) + m1**4*m5sq*m6**6*B0fin(0,0,m5sq,mudim) - m4**4*m5sq*m6**6*B0fin(0,0,m5sq,mudim) - 6*m1**6*m5**4*m6sq*B0fin(0,0,m5sq,mudim) - 2*m1sq*m4**4*m5**4*m6sq*B0fin(0,0,m5sq,mudim) + 8*m1**4*m4sq*m5**4*m6sq*B0fin(0,0,m5sq,mudim) - 5*m1**4*m5**6*m6sq*B0fin(0,0,m5sq,mudim) - 3*m4**4*m5**6*m6sq*B0fin(0,0,m5sq,mudim) + 8*m1sq*m4sq*m5**6*m6sq*B0fin(0,0,m5sq,mudim) + 7*m1**8*m5sq*m6sq*B0fin(0,0,m5sq,mudim) + m1**4*m4**4*m5sq*m6sq*B0fin(0,0,m5sq,mudim) - 8*m1**6*m4sq*m5sq*m6sq*B0fin(0,0,m5sq,mudim) + 6*m1**8*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 6*m1**6*m4sq*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 6*m1**6*m5**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 6*m1**4*m4sq*m5**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m1**4*m5**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m1sq*m4sq*m5**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m1**10*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m1**8*m4sq*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 6*m1**4*m5**4*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 6*m1sq*m4sq*m5**4*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 4*m1**6*m5sq*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m1sq*m4**4*m5sq*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 6*m1**4*m4sq*m5sq*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m1**4*m5sq*m6**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m1sq*m4sq*m5sq*m6**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m1**6*m5**4*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m1sq*m4**4*m5**4*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 6*m1**4*m5**6*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 6*m1sq*m4sq*m5**6*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m1**4*m4**4*m5sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m1**6*m4sq*m5sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 9*m1**8*m6**4*B0fin(0,0,m6sq,mudim) + 3*m1**4*m4**4*m6**4*B0fin(0,0,m6sq,mudim) - 12*m1**6*m4sq*m6**4*B0fin(0,0,m6sq,mudim) + m1**4*m5**4*m6**4*B0fin(0,0,m6sq,mudim) + 3*m4**4*m5**4*m6**4*B0fin(0,0,m6sq,mudim) - 4*m1sq*m4sq*m5**4*m6**4*B0fin(0,0,m6sq,mudim) - 6*m1**6*m5sq*m6**4*B0fin(0,0,m6sq,mudim) - 2*m1sq*m4**4*m5sq*m6**4*B0fin(0,0,m6sq,mudim) + 8*m1**4*m4sq*m5sq*m6**4*B0fin(0,0,m6sq,mudim) - 9*m1**6*m6**6*B0fin(0,0,m6sq,mudim) - 3*m1sq*m4**4*m6**6*B0fin(0,0,m6sq,mudim) + 12*m1**4*m4sq*m6**6*B0fin(0,0,m6sq,mudim) - 5*m1**4*m5sq*m6**6*B0fin(0,0,m6sq,mudim) - 3*m4**4*m5sq*m6**6*B0fin(0,0,m6sq,mudim) + 8*m1sq*m4sq*m5sq*m6**6*B0fin(0,0,m6sq,mudim) + 3*m1**4*m6**8*B0fin(0,0,m6sq,mudim) + m4**4*m6**8*B0fin(0,0,m6sq,mudim) - 4*m1sq*m4sq*m6**8*B0fin(0,0,m6sq,mudim) - 3*m1**10*m6sq*B0fin(0,0,m6sq,mudim) - m1**6*m4**4*m6sq*B0fin(0,0,m6sq,mudim) + 4*m1**8*m4sq*m6sq*B0fin(0,0,m6sq,mudim) - 5*m1**6*m5**4*m6sq*B0fin(0,0,m6sq,mudim) + m1sq*m4**4*m5**4*m6sq*B0fin(0,0,m6sq,mudim) + 4*m1**4*m4sq*m5**4*m6sq*B0fin(0,0,m6sq,mudim) + m1**4*m5**6*m6sq*B0fin(0,0,m6sq,mudim) - m4**4*m5**6*m6sq*B0fin(0,0,m6sq,mudim) + 7*m1**8*m5sq*m6sq*B0fin(0,0,m6sq,mudim) + m1**4*m4**4*m5sq*m6sq*B0fin(0,0,m6sq,mudim) - 8*m1**6*m4sq*m5sq*m6sq*B0fin(0,0,m6sq,mudim) + 6*m1**8*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 6*m1**6*m4sq*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 6*m1**4*m5**4*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 6*m1sq*m4sq*m5**4*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m1**6*m5sq*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m1sq*m4**4*m5sq*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 6*m1**6*m6**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 6*m1**4*m4sq*m6**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 6*m1**4*m5sq*m6**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 6*m1sq*m4sq*m5sq*m6**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m1**4*m6**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m1sq*m4sq*m6**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m1**10*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m1**8*m4sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 4*m1**6*m5**4*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m1sq*m4**4*m5**4*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 6*m1**4*m4sq*m5**4*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m1**4*m5**6*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m1sq*m4sq*m5**6*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m1**4*m4**4*m5sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m1**6*m4sq*m5sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 8*m1**4*m5**4*m6**4*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) + 8*m1sq*m4sq*m5**4*m6**4*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) - 10*m1**6*m5sq*m6**4*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m1sq*m4**4*m5sq*m6**4*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) + 12*m1**4*m4sq*m5sq*m6**4*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) + 4*m1**4*m5sq*m6**6*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m1sq*m4sq*m5sq*m6**6*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) - 10*m1**6*m5**4*m6sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m1sq*m4**4*m5**4*m6sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) + 12*m1**4*m4sq*m5**4*m6sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) + 4*m1**4*m5**6*m6sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m1sq*m4sq*m5**6*m6sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) + 6*m1**8*m5sq*m6sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m1**4*m4**4*m5sq*m6sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) - 8*m1**6*m4sq*m5sq*m6sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m1**8*m4sq*T134fin(m6,m5,m1,mudim) - 6*m1**6*m5**4*T134fin(m6,m5,m1,mudim) - 6*m1**4*m4sq*m5**4*T134fin(m6,m5,m1,mudim) + 6*m1**4*m5**6*T134fin(m6,m5,m1,mudim) + 2*m1sq*m4sq*m5**6*T134fin(m6,m5,m1,mudim) - 2*m1sq*m5**8*T134fin(m6,m5,m1,mudim) + 2*m1**8*m5sq*T134fin(m6,m5,m1,mudim) + 6*m1**6*m4sq*m5sq*T134fin(m6,m5,m1,mudim) - 6*m1**6*m6**4*T134fin(m6,m5,m1,mudim) - 6*m1**4*m4sq*m6**4*T134fin(m6,m5,m1,mudim) - 12*m1sq*m5**4*m6**4*T134fin(m6,m5,m1,mudim) - 6*m1**4*m5sq*m6**4*T134fin(m6,m5,m1,mudim) - 2*m1sq*m4sq*m5sq*m6**4*T134fin(m6,m5,m1,mudim) + 6*m1**4*m6**6*T134fin(m6,m5,m1,mudim) + 2*m1sq*m4sq*m6**6*T134fin(m6,m5,m1,mudim) + 8*m1sq*m5sq*m6**6*T134fin(m6,m5,m1,mudim) - 2*m1sq*m6**8*T134fin(m6,m5,m1,mudim) + 2*m1**8*m6sq*T134fin(m6,m5,m1,mudim) + 6*m1**6*m4sq*m6sq*T134fin(m6,m5,m1,mudim) - 6*m1**4*m5**4*m6sq*T134fin(m6,m5,m1,mudim) - 2*m1sq*m4sq*m5**4*m6sq*T134fin(m6,m5,m1,mudim) + 8*m1sq*m5**6*m6sq*T134fin(m6,m5,m1,mudim) + 4*m1sq*m4**4*m5sq*m6sq*T134fin(m6,m5,m1,mudim) - 12*m1**4*m4sq*m5sq*m6sq*T134fin(m6,m5,m1,mudim) + 2*m1**10*T134fin(m6,m5,m4,mudim) + 12*m1**6*m5**4*T134fin(m6,m5,m4,mudim) - 8*m1**4*m5**6*T134fin(m6,m5,m4,mudim) + 2*m1sq*m5**8*T134fin(m6,m5,m4,mudim) - 8*m1**8*m5sq*T134fin(m6,m5,m4,mudim) + 12*m1**6*m6**4*T134fin(m6,m5,m4,mudim) + 12*m1sq*m5**4*m6**4*T134fin(m6,m5,m4,mudim) + 8*m1**4*m5sq*m6**4*T134fin(m6,m5,m4,mudim) - 8*m1**4*m6**6*T134fin(m6,m5,m4,mudim) - 8*m1sq*m5sq*m6**6*T134fin(m6,m5,m4,mudim) + 2*m1sq*m6**8*T134fin(m6,m5,m4,mudim) - 8*m1**8*m6sq*T134fin(m6,m5,m4,mudim) + 8*m1**4*m5**4*m6sq*T134fin(m6,m5,m4,mudim) - 8*m1sq*m5**6*m6sq*T134fin(m6,m5,m4,mudim) + 8*m1**6*m5sq*m6sq*T134fin(m6,m5,m4,mudim))/(m1**2*(m1sq - m4sq)**3*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2)
		def eval_31():
			return (-((m1sq - m2sq)*(m1sq - m3sq)*(m2sq - m3sq)*m3sq*m5sq*B0del(0,0,m3sq,mudim)) - (m1sq - m2sq)*(m1sq - m3sq)*(m2sq - m3sq)*m3sq*m6sq*B0del(0,0,m3sq,mudim) - (m1sq - m2sq)*(m1sq - m3sq)*(m2sq - m3sq)*m3sq*m5sq*B0del(0,0,m5sq,mudim) + (m1sq - m2sq)*(m1sq - m3sq)*(m2sq - m3sq)*m5sq*(m5sq - m6sq)*B0del(0,0,m5sq,mudim) + 2*(m1sq - m2sq)*(m1sq - m3sq)*(m2sq - m3sq)*m5sq*m6sq*B0del(0,0,m5sq,mudim) - (m1sq - m2sq)*(m1sq - m3sq)*(m2sq - m3sq)*m3sq*m6sq*B0del(0,0,m6sq,mudim) + 2*(m1sq - m2sq)*(m1sq - m3sq)*(m2sq - m3sq)*m5sq*m6sq*B0del(0,0,m6sq,mudim) + (m1sq - m2sq)*(m1sq - m3sq)*(m2sq - m3sq)*m6sq*(-m5sq + m6sq)*B0del(0,0,m6sq,mudim) + (m1sq - m2sq)*(m1sq - m3sq)*(m2sq - m3sq)*m5sq*(m5sq - m6sq)*(B0del(0,0,m3sq,mudim) - B0fin(0,0,m3sq,mudim)) + (m1sq - m2sq)*(m1sq - m3sq)*(m2sq - m3sq)*m6sq*(-m5sq + m6sq)*(B0del(0,0,m3sq,mudim) - B0fin(0,0,m3sq,mudim)) + (m1sq - m2sq)*(m1sq - m3sq)*(m2sq - m3sq)*m3sq*m5sq*B0fin(0,0,m3sq,mudim) + (m1sq - m2sq)*(m1sq - m3sq)*(m2sq - m3sq)*m3sq*m6sq*B0fin(0,0,m3sq,mudim) + (m1sq - m2sq)*(m1sq - m3sq)*(m2sq - m3sq)*m3sq*m5sq*B0fin(0,0,m5sq,mudim) - (m1sq - m2sq)*(m1sq - m3sq)*(m2sq - m3sq)*m5sq*(m5sq - m6sq)*B0fin(0,0,m5sq,mudim) - 2*(m1sq - m2sq)*(m1sq - m3sq)*(m2sq - m3sq)*m5sq*m6sq*B0fin(0,0,m5sq,mudim) - (m1sq - m2sq)*(m1sq - m3sq)*(m2sq - m3sq)*m3sq*m5sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + (m1sq - m2sq)*(m1sq - m3sq)*(m2sq - m3sq)*m5sq*(m5sq - m6sq)*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + (m1sq - m2sq)*(m1sq - m3sq)*(m2sq - m3sq)*m3sq*m6sq*B0fin(0,0,m6sq,mudim) - 2*(m1sq - m2sq)*(m1sq - m3sq)*(m2sq - m3sq)*m5sq*m6sq*B0fin(0,0,m6sq,mudim) + (m1sq - m2sq)*(m1sq - m3sq)*(m2sq - m3sq)*(m5sq - m6sq)*m6sq*B0fin(0,0,m6sq,mudim) - (m1sq - m2sq)*(m1sq - m3sq)*(m2sq - m3sq)*m3sq*m6sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) + (m1sq - m2sq)*(m1sq - m3sq)*(m2sq - m3sq)*m6sq*(-m5sq + m6sq)*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*(m1sq - m2sq)*(m1sq - m3sq)*(m2sq - m3sq)*m5sq*m6sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) - (m1sq - m2sq)*(m1sq - m3sq)*(m2sq - m3sq)*(m3sq - m5sq - m6sq)*(m3sq + m5sq + m6sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)) + (m2sq - m3sq)**2*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))*T134fin(m6,m5,m1,mudim) - (m1sq - m3sq)**2*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))*T134fin(m6,m5,m2,mudim) + (m1sq - m2sq)*(m1sq - m3sq)*(m2sq - m3sq)*(m3sq - m5sq - m6sq)*T134fin(m6,m5,m3,mudim) + (m1sq - m3sq)**2*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))*T134fin(m6,m5,m3,mudim) - (m2sq - m3sq)**2*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))*T134fin(m6,m5,m3,mudim))/((m1sq - m2sq)*(m1sq - m3sq)**2*(m2sq - m3sq)**2*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq)))
		def eval_32():
			return (m2sq*m5sq*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) + (m2sq*m6sq*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) + (m2sq*m5sq*B0del(0,0,m5sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) - (m5sq*(m5sq - m6sq)*B0del(0,0,m5sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) - (2*m5sq*m6sq*B0del(0,0,m5sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) + (m2sq*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) - (2*m5sq*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) + ((m5sq - m6sq)*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) - (m5sq*(m5sq - m6sq)*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)))/((m1sq - m2sq)*(m2sq - m4sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) + ((m5sq - m6sq)*m6sq*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)))/((m1sq - m2sq)*(m2sq - m4sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) - (m2sq*m5sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) - (m2sq*m6sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) - (m2sq*m5sq*B0fin(0,0,m5sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) + (m5sq*(m5sq - m6sq)*B0fin(0,0,m5sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) + (2*m5sq*m6sq*B0fin(0,0,m5sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) + (m2sq*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) - (m5sq*(m5sq - m6sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) - (m2sq*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) + (2*m5sq*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) + (m6sq*(-m5sq + m6sq)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) + (m2sq*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) + ((m5sq - m6sq)*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) - (2*m5sq*m6sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) + ((m2sq - m5sq - m6sq)*(m2sq + m5sq + m6sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m1sq - m2sq)*(m2sq - m4sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) + T134fin(m6,m5,m1,mudim)/((m1sq - m2sq)**2*(m1sq - m4sq)) + (m1sq*T134fin(m6,m5,m2,mudim))/((m1sq - m2sq)**2*(m2sq - m4sq)**2) - (2*m2sq*T134fin(m6,m5,m2,mudim))/((m1sq - m2sq)**2*(m2sq - m4sq)**2) + (m4sq*T134fin(m6,m5,m2,mudim))/((m1sq - m2sq)**2*(m2sq - m4sq)**2) + ((m2sq - m5sq - m6sq)*T134fin(m6,m5,m2,mudim))/((m1sq - m2sq)*(m2sq - m4sq)*(4*m5sq*m6sq - (-m2sq + m5sq + m6sq)**2)) - T134fin(m6,m5,m4,mudim)/((m1sq - m4sq)*(m2sq - m4sq)**2)
		def eval_33():
			return (-(m1sq*(m1sq - m3sq)*(m1sq - m4sq)*(m3sq - m4sq)*m5sq*B0del(0,0,m1sq,mudim)) - m1sq*(m1sq - m3sq)*(m1sq - m4sq)*(m3sq - m4sq)*m6sq*B0del(0,0,m1sq,mudim) - m1sq*(m1sq - m3sq)*(m1sq - m4sq)*(m3sq - m4sq)*m5sq*B0del(0,0,m5sq,mudim) + (m1sq - m3sq)*(m1sq - m4sq)*(m3sq - m4sq)*m5sq*(m5sq - m6sq)*B0del(0,0,m5sq,mudim) + 2*(m1sq - m3sq)*(m1sq - m4sq)*(m3sq - m4sq)*m5sq*m6sq*B0del(0,0,m5sq,mudim) - m1sq*(m1sq - m3sq)*(m1sq - m4sq)*(m3sq - m4sq)*m6sq*B0del(0,0,m6sq,mudim) + 2*(m1sq - m3sq)*(m1sq - m4sq)*(m3sq - m4sq)*m5sq*m6sq*B0del(0,0,m6sq,mudim) + (m1sq - m3sq)*(m1sq - m4sq)*(m3sq - m4sq)*m6sq*(-m5sq + m6sq)*B0del(0,0,m6sq,mudim) + (m1sq - m3sq)*(m1sq - m4sq)*(m3sq - m4sq)*m5sq*(m5sq - m6sq)*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)) + (m1sq - m3sq)*(m1sq - m4sq)*(m3sq - m4sq)*m6sq*(-m5sq + m6sq)*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)) + m1sq*(m1sq - m3sq)*(m1sq - m4sq)*(m3sq - m4sq)*m5sq*B0fin(0,0,m1sq,mudim) + m1sq*(m1sq - m3sq)*(m1sq - m4sq)*(m3sq - m4sq)*m6sq*B0fin(0,0,m1sq,mudim) + m1sq*(m1sq - m3sq)*(m1sq - m4sq)*(m3sq - m4sq)*m5sq*B0fin(0,0,m5sq,mudim) - (m1sq - m3sq)*(m1sq - m4sq)*(m3sq - m4sq)*m5sq*(m5sq - m6sq)*B0fin(0,0,m5sq,mudim) - 2*(m1sq - m3sq)*(m1sq - m4sq)*(m3sq - m4sq)*m5sq*m6sq*B0fin(0,0,m5sq,mudim) - m1sq*(m1sq - m3sq)*(m1sq - m4sq)*(m3sq - m4sq)*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + (m1sq - m3sq)*(m1sq - m4sq)*(m3sq - m4sq)*m5sq*(m5sq - m6sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + m1sq*(m1sq - m3sq)*(m1sq - m4sq)*(m3sq - m4sq)*m6sq*B0fin(0,0,m6sq,mudim) - 2*(m1sq - m3sq)*(m1sq - m4sq)*(m3sq - m4sq)*m5sq*m6sq*B0fin(0,0,m6sq,mudim) + (m1sq - m3sq)*(m1sq - m4sq)*(m3sq - m4sq)*(m5sq - m6sq)*m6sq*B0fin(0,0,m6sq,mudim) - m1sq*(m1sq - m3sq)*(m1sq - m4sq)*(m3sq - m4sq)*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + (m1sq - m3sq)*(m1sq - m4sq)*(m3sq - m4sq)*m6sq*(-m5sq + m6sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*(m1sq - m3sq)*(m1sq - m4sq)*(m3sq - m4sq)*m5sq*m6sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) - (m1sq - m3sq)*(m1sq - m4sq)*(m3sq - m4sq)*(m1sq - m5sq - m6sq)*(m1sq + m5sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)) + (m1sq - m3sq)*(m1sq - m4sq)*(m3sq - m4sq)*(m1sq - m5sq - m6sq)*T134fin(m6,m5,m1,mudim) - 2*m1sq*(m3sq - m4sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*T134fin(m6,m5,m1,mudim) + m3sq*(m3sq - m4sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*T134fin(m6,m5,m1,mudim) + (m3sq - m4sq)*m4sq*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*T134fin(m6,m5,m1,mudim) + (m1sq - m4sq)**2*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*T134fin(m6,m5,m3,mudim) - (m1sq - m3sq)**2*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*T134fin(m6,m5,m4,mudim))/((m1sq - m3sq)**2*(m1sq - m4sq)**2*(m3sq - m4sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq)))
		def eval_34():
			return T134fin(m6,m5,m1,mudim)/((m1sq - m2sq)*(m1sq - m3sq)*(m1sq - m4sq)) - T134fin(m6,m5,m2,mudim)/((m1sq - m2sq)*(m2sq - m3sq)*(m2sq - m4sq)) - T134fin(m6,m5,m3,mudim)/((m1sq - m3sq)*(-m2sq + m3sq)*(m3sq - m4sq)) - T134fin(m6,m5,m4,mudim)/((m1sq - m4sq)*(-m2sq + m4sq)*(-m3sq + m4sq))

		cond_m1_0 = cond(m1, 0)
		cond_m2_0 = cond(m2, 0)
		cond_m3_0 = cond(m3, 0)
		cond_m4_0 = cond(m4, 0)
		cond_m5_0 = cond(m5, 0)
		cond_m6_0 = cond(m6, 0)
		cond_m6_m5 = cond(m6, m5)
		cond_m6_m4 = cond(m6, m4)
		cond_m5_m4 = cond(m5, m4)
		cond_m6_m3 = cond(m6, m3)
		cond_m5_m3 = cond(m5, m3)
		cond_m4_m3 = cond(m4, m3)
		cond_m6_m2 = cond(m6, m2)
		cond_m5_m2 = cond(m5, m2)
		cond_m4_m2 = cond(m4, m2)
		cond_m3_m2 = cond(m3, m2)
		cond_m6_m1 = cond(m6, m1)
		cond_m5_m1 = cond(m5, m1)
		cond_m4_m1 = cond(m4, m1)
		cond_m3_m1 = cond(m3, m1)
		cond_m2_m1 = cond(m2, m1)

		conditions = [
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_1()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0, lambda: eval_5()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_0, lambda: eval_5()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_0, lambda: eval_2()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_2()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_2()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_2()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_m5, lambda: eval_3()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_m4, lambda: eval_8()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_0, lambda: eval_8()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_m3, lambda: eval_8()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_0, lambda: eval_8()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_0, lambda: eval_4()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m2, lambda: eval_8()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_0, lambda: eval_8()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_0, lambda: eval_4()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_4()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_8()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_8()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_4()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_4()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_4()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0, lambda: eval_5()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_0, lambda: eval_8()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m6_0, lambda: eval_8()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_0, lambda: eval_8()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m6_0, lambda: eval_8()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m6_0, lambda: eval_6()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_0, lambda: eval_8()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m6_0, lambda: eval_8()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m6_0, lambda: eval_6()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_6()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0, lambda: eval_8()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_0, lambda: eval_8()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_0, lambda: eval_6()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_6()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_6()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m4, lambda: eval_7()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m3, lambda: eval_7()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m3, lambda: eval_15()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_0, lambda: eval_16()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m2, lambda: eval_7()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m2, lambda: eval_15()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_0, lambda: eval_16()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_m2, lambda: eval_15()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_0, lambda: eval_16()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_0, lambda: eval_28()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_7()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_15()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_16()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_15()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_16()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_28()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_15()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_16()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_28()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_28()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m6_m5, lambda: eval_7()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m6_m5, lambda: eval_7()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m6_m4, lambda: eval_33()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m6_0, lambda: eval_33()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m6_m5, lambda: eval_7()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m6_m4, lambda: eval_33()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m6_0, lambda: eval_33()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m6_m3, lambda: eval_33()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m6_0, lambda: eval_33()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m6_0, lambda: eval_31()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_m4, lambda: eval_8()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m6_m4, lambda: eval_8()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_m3, lambda: eval_8()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m6_m3, lambda: eval_8()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_0, lambda: eval_29()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m6_0, lambda: eval_29()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m6_m3, lambda: eval_33()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m6_0, lambda: eval_33()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_m2, lambda: eval_8()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m6_m2, lambda: eval_8()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_0, lambda: eval_29()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m6_0, lambda: eval_29()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m6_m2, lambda: eval_33()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m6_0, lambda: eval_33()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_0, lambda: eval_29()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m6_0, lambda: eval_29()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m6_0, lambda: eval_32()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m6_m2, lambda: eval_33()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m6_0, lambda: eval_33()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m6_0, lambda: eval_32()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_m5, lambda: eval_7()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_m4, lambda: eval_33()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_0, lambda: eval_33()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_m3, lambda: eval_33()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_0, lambda: eval_33()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_0, lambda: eval_31()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m2, lambda: eval_33()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_0, lambda: eval_33()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_0, lambda: eval_31()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_31()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_m1, lambda: eval_8()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_m1, lambda: eval_8()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_0, lambda: eval_29()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m6_0, lambda: eval_29()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_m1, lambda: eval_33()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m6_0, lambda: eval_33()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_0, lambda: eval_29()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m6_0, lambda: eval_29()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m6_0, lambda: eval_32()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_33()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_33()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_32()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_0, lambda: eval_29()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m6_0, lambda: eval_29()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m6_0, lambda: eval_32()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_32()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_33()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_33()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_32()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_32()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0, lambda: eval_8()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0, lambda: eval_8()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0, lambda: eval_33()),
			(cond_m1_0 and cond_m2_0 and cond_m6_0, lambda: eval_33()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0, lambda: eval_8()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0, lambda: eval_33()),
			(cond_m1_0 and cond_m3_0 and cond_m6_0, lambda: eval_33()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0, lambda: eval_33()),
			(cond_m1_0 and cond_m4_0 and cond_m6_0, lambda: eval_33()),
			(cond_m1_0 and cond_m5_0 and cond_m6_0, lambda: eval_34()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0, lambda: eval_8()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0, lambda: eval_33()),
			(cond_m2_0 and cond_m3_0 and cond_m6_0, lambda: eval_33()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0, lambda: eval_33()),
			(cond_m2_0 and cond_m4_0 and cond_m6_0, lambda: eval_33()),
			(cond_m2_0 and cond_m5_0 and cond_m6_0, lambda: eval_34()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0, lambda: eval_33()),
			(cond_m3_0 and cond_m4_0 and cond_m6_0, lambda: eval_33()),
			(cond_m3_0 and cond_m5_0 and cond_m6_0, lambda: eval_34()),
			(cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_34()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3, lambda: eval_9()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2, lambda: eval_9()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_m2, lambda: eval_9()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_m2, lambda: eval_13()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_0, lambda: eval_14()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_9()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_9()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_13()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_14()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_9()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_13()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_14()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_13()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_14()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_27()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m6_m4, lambda: eval_10()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m4, lambda: eval_10()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m3, lambda: eval_10()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m3, lambda: eval_21()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_0, lambda: eval_22()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m6_m5, lambda: eval_9()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m6_m4, lambda: eval_33()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m6_m3, lambda: eval_33()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m6_m5, lambda: eval_9()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m6_m4, lambda: eval_33()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m2, lambda: eval_33()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m6_m5, lambda: eval_9()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m6_m4, lambda: eval_32()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m6_0, lambda: eval_32()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m3, lambda: eval_33()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m2, lambda: eval_33()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m3, lambda: eval_32()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m6_0, lambda: eval_32()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m2, lambda: eval_31()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m6_0, lambda: eval_31()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_m3, lambda: eval_29()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m6_m3, lambda: eval_29()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m6_m3, lambda: eval_10()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_m2, lambda: eval_29()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m6_m2, lambda: eval_29()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m6_m2, lambda: eval_10()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_m2, lambda: eval_29()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m6_m2, lambda: eval_29()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_0, lambda: eval_28()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m6_0, lambda: eval_28()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m6_m2, lambda: eval_23()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m6_0, lambda: eval_24()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m2, lambda: eval_10()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m2, lambda: eval_23()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_0, lambda: eval_24()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m4, lambda: eval_10()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m3, lambda: eval_10()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m3, lambda: eval_21()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_0, lambda: eval_22()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m2, lambda: eval_10()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m2, lambda: eval_21()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_0, lambda: eval_22()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_m2, lambda: eval_21()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_0, lambda: eval_22()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_0, lambda: eval_28()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m6_m5, lambda: eval_9()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m6_m4, lambda: eval_33()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m1, lambda: eval_33()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m6_m5, lambda: eval_9()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m6_m4, lambda: eval_32()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4 and cond_m6_0, lambda: eval_32()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m3, lambda: eval_33()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m1, lambda: eval_33()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m3, lambda: eval_32()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3 and cond_m6_0, lambda: eval_32()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m1, lambda: eval_31()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1 and cond_m6_0, lambda: eval_31()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m6_m5, lambda: eval_9()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m6_m4, lambda: eval_32()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4 and cond_m6_0, lambda: eval_32()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m3, lambda: eval_32()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3 and cond_m6_0, lambda: eval_32()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0 and cond_m6_0, lambda: eval_29()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m2, lambda: eval_33()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m1, lambda: eval_33()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m2, lambda: eval_32()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2 and cond_m6_0, lambda: eval_32()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m1, lambda: eval_31()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1 and cond_m6_0, lambda: eval_31()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m2, lambda: eval_32()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2 and cond_m6_0, lambda: eval_32()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0 and cond_m6_0, lambda: eval_29()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_31()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_31()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_29()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_m1, lambda: eval_29()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m6_m1, lambda: eval_29()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_10()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_m1, lambda: eval_29()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m6_m1, lambda: eval_29()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_0, lambda: eval_28()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m6_0, lambda: eval_28()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_23()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_24()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_10()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_23()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_24()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_m1, lambda: eval_29()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m6_m1, lambda: eval_29()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_0, lambda: eval_28()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m6_0, lambda: eval_28()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m6_m1, lambda: eval_23()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1 and cond_m6_0, lambda: eval_24()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_0, lambda: eval_28()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m6_0, lambda: eval_28()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0 and cond_m6_0, lambda: eval_30()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_23()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_24()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_30()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_10()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_23()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_24()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_23()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_24()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_30()),
			(cond_m1_0 and cond_m2_0 and cond_m6_m5, lambda: eval_10()),
			(cond_m1_0 and cond_m3_0 and cond_m6_m5, lambda: eval_10()),
			(cond_m1_0 and cond_m4_0 and cond_m6_m5, lambda: eval_10()),
			(cond_m1_0 and cond_m5_0 and cond_m6_m4, lambda: eval_34()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_0, lambda: eval_34()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4, lambda: eval_33()),
			(cond_m1_0 and cond_m2_0 and cond_m6_m4, lambda: eval_33()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4, lambda: eval_33()),
			(cond_m1_0 and cond_m3_0 and cond_m6_m4, lambda: eval_33()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3, lambda: eval_33()),
			(cond_m1_0 and cond_m4_0 and cond_m6_m3, lambda: eval_33()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0, lambda: eval_31()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_0, lambda: eval_31()),
			(cond_m1_0 and cond_m5_0 and cond_m6_m3, lambda: eval_34()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_0, lambda: eval_34()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3, lambda: eval_29()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3, lambda: eval_33()),
			(cond_m1_0 and cond_m2_0 and cond_m6_m3, lambda: eval_33()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2, lambda: eval_29()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2, lambda: eval_33()),
			(cond_m1_0 and cond_m3_0 and cond_m6_m2, lambda: eval_33()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0, lambda: eval_29()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0, lambda: eval_32()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_0, lambda: eval_32()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2, lambda: eval_33()),
			(cond_m1_0 and cond_m4_0 and cond_m6_m2, lambda: eval_33()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0, lambda: eval_32()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_0, lambda: eval_32()),
			(cond_m1_0 and cond_m5_0 and cond_m6_m2, lambda: eval_34()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_0, lambda: eval_34()),
			(cond_m2_0 and cond_m3_0 and cond_m6_m5, lambda: eval_10()),
			(cond_m2_0 and cond_m4_0 and cond_m6_m5, lambda: eval_10()),
			(cond_m2_0 and cond_m5_0 and cond_m6_m4, lambda: eval_34()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_0, lambda: eval_34()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4, lambda: eval_33()),
			(cond_m2_0 and cond_m3_0 and cond_m6_m4, lambda: eval_33()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3, lambda: eval_33()),
			(cond_m2_0 and cond_m4_0 and cond_m6_m3, lambda: eval_33()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0, lambda: eval_31()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_0, lambda: eval_31()),
			(cond_m2_0 and cond_m5_0 and cond_m6_m3, lambda: eval_34()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_0, lambda: eval_34()),
			(cond_m3_0 and cond_m4_0 and cond_m6_m5, lambda: eval_10()),
			(cond_m3_0 and cond_m5_0 and cond_m6_m4, lambda: eval_34()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_0, lambda: eval_34()),
			(cond_m4_0 and cond_m5_0 and cond_m6_m3, lambda: eval_34()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_0, lambda: eval_34()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_0, lambda: eval_31()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2, lambda: eval_33()),
			(cond_m3_0 and cond_m4_0 and cond_m6_m2, lambda: eval_33()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0, lambda: eval_31()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_0, lambda: eval_31()),
			(cond_m3_0 and cond_m5_0 and cond_m6_m2, lambda: eval_34()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_0, lambda: eval_34()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0, lambda: eval_31()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_0, lambda: eval_31()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_0, lambda: eval_32()),
			(cond_m4_0 and cond_m5_0 and cond_m6_m2, lambda: eval_34()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_0, lambda: eval_34()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_0, lambda: eval_32()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1, lambda: eval_29()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1, lambda: eval_33()),
			(cond_m2_0 and cond_m3_0 and cond_m6_m1, lambda: eval_33()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0, lambda: eval_29()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0, lambda: eval_32()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_0, lambda: eval_32()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1, lambda: eval_33()),
			(cond_m2_0 and cond_m4_0 and cond_m6_m1, lambda: eval_33()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0, lambda: eval_32()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_0, lambda: eval_32()),
			(cond_m2_0 and cond_m5_0 and cond_m6_m1, lambda: eval_34()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_0, lambda: eval_34()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0, lambda: eval_29()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0, lambda: eval_32()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_0, lambda: eval_32()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0, lambda: eval_32()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_0, lambda: eval_32()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1, lambda: eval_33()),
			(cond_m3_0 and cond_m4_0 and cond_m6_m1, lambda: eval_33()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0, lambda: eval_32()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_0, lambda: eval_32()),
			(cond_m3_0 and cond_m5_0 and cond_m6_m1, lambda: eval_34()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_0, lambda: eval_34()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0, lambda: eval_32()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_0, lambda: eval_32()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_0, lambda: eval_33()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_0, lambda: eval_33()),
			(cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_34()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_34()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_33()),
			(cond_m1_0 and cond_m2_0, lambda: eval_33()),
			(cond_m1_0 and cond_m3_0, lambda: eval_33()),
			(cond_m1_0 and cond_m4_0, lambda: eval_33()),
			(cond_m1_0 and cond_m5_0, lambda: eval_34()),
			(cond_m1_0 and cond_m6_0, lambda: eval_34()),
			(cond_m2_0 and cond_m3_0, lambda: eval_33()),
			(cond_m2_0 and cond_m4_0, lambda: eval_33()),
			(cond_m2_0 and cond_m5_0, lambda: eval_34()),
			(cond_m2_0 and cond_m6_0, lambda: eval_34()),
			(cond_m3_0 and cond_m4_0, lambda: eval_33()),
			(cond_m3_0 and cond_m5_0, lambda: eval_34()),
			(cond_m3_0 and cond_m6_0, lambda: eval_34()),
			(cond_m4_0 and cond_m5_0, lambda: eval_34()),
			(cond_m4_0 and cond_m6_0, lambda: eval_34()),
			(cond_m5_0 and cond_m6_0, lambda: eval_34()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2, lambda: eval_28()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_28()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_28()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_28()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_11()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_12()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3, lambda: eval_31()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m6_m4, lambda: eval_32()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m6_m3, lambda: eval_32()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m6_m3, lambda: eval_31()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m2, lambda: eval_31()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m6_m5, lambda: eval_28()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m6_m4, lambda: eval_32()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m6_m2, lambda: eval_32()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m3, lambda: eval_32()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m6_m2, lambda: eval_32()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m6_m2, lambda: eval_31()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_m2, lambda: eval_28()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m6_m2, lambda: eval_28()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m6_m2, lambda: eval_32()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2, lambda: eval_32()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3, lambda: eval_31()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2, lambda: eval_31()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_m2, lambda: eval_31()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_m2, lambda: eval_13()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_0, lambda: eval_14()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4 and cond_m6_m4, lambda: eval_32()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3 and cond_m6_m3, lambda: eval_32()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1 and cond_m6_m3, lambda: eval_31()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m1, lambda: eval_31()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4 and cond_m6_m4, lambda: eval_32()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3 and cond_m6_m3, lambda: eval_32()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0 and cond_m6_m3, lambda: eval_15()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3 and cond_m6_0, lambda: eval_16()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2 and cond_m6_m2, lambda: eval_32()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1 and cond_m6_m2, lambda: eval_31()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m1, lambda: eval_31()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2 and cond_m6_m2, lambda: eval_32()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0 and cond_m6_m2, lambda: eval_15()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2 and cond_m6_0, lambda: eval_16()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1 and cond_m6_m2, lambda: eval_31()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_m1, lambda: eval_31()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0 and cond_m6_m2, lambda: eval_15()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2 and cond_m6_0, lambda: eval_16()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_m1, lambda: eval_28()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1 and cond_m6_0, lambda: eval_28()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m6_m5, lambda: eval_28()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1 and cond_m6_m4, lambda: eval_32()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4 and cond_m6_m1, lambda: eval_32()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m3, lambda: eval_32()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3 and cond_m6_m1, lambda: eval_32()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1 and cond_m6_m1, lambda: eval_31()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m6_m5, lambda: eval_28()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1 and cond_m6_m4, lambda: eval_32()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4 and cond_m6_m1, lambda: eval_32()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m6_m5, lambda: eval_28()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0 and cond_m6_m4, lambda: eval_30()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4 and cond_m6_0, lambda: eval_30()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m3, lambda: eval_32()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3 and cond_m6_m1, lambda: eval_32()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m3, lambda: eval_30()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3 and cond_m6_0, lambda: eval_30()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0 and cond_m6_m1, lambda: eval_17()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1 and cond_m6_0, lambda: eval_18()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m2, lambda: eval_32()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2 and cond_m6_m1, lambda: eval_32()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1 and cond_m6_m1, lambda: eval_31()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m2, lambda: eval_32()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2 and cond_m6_m1, lambda: eval_32()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m2, lambda: eval_30()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2 and cond_m6_0, lambda: eval_30()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0 and cond_m6_m1, lambda: eval_17()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1 and cond_m6_0, lambda: eval_18()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_31()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_17()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_18()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1, lambda: eval_28()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m6_m1, lambda: eval_28()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_32()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_32()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_m1, lambda: eval_28()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m6_m1, lambda: eval_28()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_32()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_m1, lambda: eval_28()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m6_m1, lambda: eval_28()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_0, lambda: eval_27()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m6_0, lambda: eval_27()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_19()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_20()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_32()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_19()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_20()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_32()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_32()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_19()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_20()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_m4, lambda: eval_34()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_m5, lambda: eval_31()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_m4, lambda: eval_34()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_m3, lambda: eval_34()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3, lambda: eval_31()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_m3, lambda: eval_31()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_m3, lambda: eval_34()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_m5, lambda: eval_32()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_m5, lambda: eval_32()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_m4, lambda: eval_34()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_m2, lambda: eval_34()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4, lambda: eval_32()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_m4, lambda: eval_32()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3, lambda: eval_32()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_m3, lambda: eval_32()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2, lambda: eval_31()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_m2, lambda: eval_31()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_m3, lambda: eval_34()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_m2, lambda: eval_34()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2, lambda: eval_28()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2, lambda: eval_32()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_m2, lambda: eval_32()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2, lambda: eval_32()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_m2, lambda: eval_32()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_m2, lambda: eval_34()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_m4, lambda: eval_34()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_m5, lambda: eval_31()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_m4, lambda: eval_34()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_m3, lambda: eval_34()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3, lambda: eval_31()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_m3, lambda: eval_31()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_m3, lambda: eval_34()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_m4, lambda: eval_34()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_m3, lambda: eval_34()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_m3, lambda: eval_21()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_0, lambda: eval_22()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_m5, lambda: eval_31()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_m4, lambda: eval_34()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_m2, lambda: eval_34()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_m5, lambda: eval_31()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_m4, lambda: eval_32()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_0, lambda: eval_32()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_m3, lambda: eval_34()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_m2, lambda: eval_34()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_m3, lambda: eval_32()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_0, lambda: eval_32()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_m2, lambda: eval_31()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_0, lambda: eval_31()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2, lambda: eval_31()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_m2, lambda: eval_31()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_m2, lambda: eval_34()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2, lambda: eval_31()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_m2, lambda: eval_31()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0, lambda: eval_28()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_0, lambda: eval_28()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_m2, lambda: eval_23()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_0, lambda: eval_24()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_m2, lambda: eval_34()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_m2, lambda: eval_23()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_0, lambda: eval_24()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_m5, lambda: eval_32()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_m5, lambda: eval_32()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_m4, lambda: eval_34()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_m1, lambda: eval_34()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_m5, lambda: eval_32()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4, lambda: eval_32()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_m4, lambda: eval_32()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3, lambda: eval_32()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_m3, lambda: eval_32()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1, lambda: eval_31()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_m1, lambda: eval_31()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_m3, lambda: eval_34()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_m1, lambda: eval_34()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4, lambda: eval_32()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_m4, lambda: eval_32()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_m5, lambda: eval_32()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_m5, lambda: eval_32()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_m4, lambda: eval_34()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_m1, lambda: eval_34()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_m5, lambda: eval_32()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_m4, lambda: eval_33()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_0, lambda: eval_33()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_m4, lambda: eval_33()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_0, lambda: eval_33()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_m3, lambda: eval_34()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_m1, lambda: eval_34()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_m3, lambda: eval_33()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_0, lambda: eval_33()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_m1, lambda: eval_31()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_0, lambda: eval_31()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3, lambda: eval_32()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_m3, lambda: eval_32()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0, lambda: eval_29()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2, lambda: eval_32()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_m2, lambda: eval_32()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1, lambda: eval_31()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_m1, lambda: eval_31()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_m2, lambda: eval_34()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_m1, lambda: eval_34()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2, lambda: eval_32()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_m2, lambda: eval_32()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0, lambda: eval_29()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1, lambda: eval_31()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_m1, lambda: eval_31()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0, lambda: eval_29()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_0, lambda: eval_29()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_m3, lambda: eval_33()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_0, lambda: eval_33()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_0, lambda: eval_29()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_m2, lambda: eval_33()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_0, lambda: eval_33()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_0, lambda: eval_29()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_m1, lambda: eval_32()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_0, lambda: eval_32()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_m2, lambda: eval_34()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_m1, lambda: eval_34()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_m2, lambda: eval_33()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_0, lambda: eval_33()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_m1, lambda: eval_32()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_0, lambda: eval_32()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1, lambda: eval_28()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1, lambda: eval_32()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_m1, lambda: eval_32()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1, lambda: eval_32()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_m1, lambda: eval_32()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_34()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1, lambda: eval_28()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1, lambda: eval_32()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_m1, lambda: eval_32()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0, lambda: eval_28()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0, lambda: eval_30()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1, lambda: eval_32()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_m1, lambda: eval_32()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0, lambda: eval_30()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1, lambda: eval_32()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_m1, lambda: eval_32()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_34()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1, lambda: eval_32()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_m1, lambda: eval_32()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0, lambda: eval_30()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_0, lambda: eval_30()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_0, lambda: eval_30()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_25()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_26()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_0, lambda: eval_30()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_25()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_26()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_34()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_25()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_26()),
			(cond_m1_0 and cond_m6_m5, lambda: eval_34()),
			(cond_m1_0 and cond_m5_m4, lambda: eval_34()),
			(cond_m1_0 and cond_m6_m4, lambda: eval_34()),
			(cond_m1_0 and cond_m4_m3, lambda: eval_31()),
			(cond_m1_0 and cond_m5_m3, lambda: eval_34()),
			(cond_m1_0 and cond_m6_m3, lambda: eval_34()),
			(cond_m1_0 and cond_m3_m2, lambda: eval_32()),
			(cond_m1_0 and cond_m4_m2, lambda: eval_32()),
			(cond_m1_0 and cond_m5_m2, lambda: eval_34()),
			(cond_m1_0 and cond_m6_m2, lambda: eval_34()),
			(cond_m2_0 and cond_m6_m5, lambda: eval_34()),
			(cond_m2_0 and cond_m5_m4, lambda: eval_34()),
			(cond_m2_0 and cond_m6_m4, lambda: eval_34()),
			(cond_m2_0 and cond_m4_m3, lambda: eval_31()),
			(cond_m2_0 and cond_m5_m3, lambda: eval_34()),
			(cond_m2_0 and cond_m6_m3, lambda: eval_34()),
			(cond_m3_0 and cond_m6_m5, lambda: eval_34()),
			(cond_m3_0 and cond_m5_m4, lambda: eval_34()),
			(cond_m3_0 and cond_m6_m4, lambda: eval_34()),
			(cond_m4_0 and cond_m6_m5, lambda: eval_34()),
			(cond_m5_0 and cond_m6_m4, lambda: eval_34()),
			(cond_m5_m4 and cond_m6_0, lambda: eval_34()),
			(cond_m4_0 and cond_m5_m3, lambda: eval_34()),
			(cond_m4_0 and cond_m6_m3, lambda: eval_34()),
			(cond_m4_m3 and cond_m5_0, lambda: eval_31()),
			(cond_m4_m3 and cond_m6_0, lambda: eval_31()),
			(cond_m5_0 and cond_m6_m3, lambda: eval_34()),
			(cond_m5_m3 and cond_m6_0, lambda: eval_34()),
			(cond_m3_0 and cond_m4_m2, lambda: eval_31()),
			(cond_m3_0 and cond_m5_m2, lambda: eval_34()),
			(cond_m3_0 and cond_m6_m2, lambda: eval_34()),
			(cond_m3_m2 and cond_m4_0, lambda: eval_31()),
			(cond_m3_m2 and cond_m5_0, lambda: eval_32()),
			(cond_m4_0 and cond_m5_m2, lambda: eval_34()),
			(cond_m4_0 and cond_m6_m2, lambda: eval_34()),
			(cond_m4_m2 and cond_m5_0, lambda: eval_32()),
			(cond_m3_m2 and cond_m6_0, lambda: eval_32()),
			(cond_m4_m2 and cond_m6_0, lambda: eval_32()),
			(cond_m5_0 and cond_m6_m2, lambda: eval_34()),
			(cond_m5_m2 and cond_m6_0, lambda: eval_34()),
			(cond_m2_0 and cond_m3_m1, lambda: eval_32()),
			(cond_m2_0 and cond_m4_m1, lambda: eval_32()),
			(cond_m2_0 and cond_m5_m1, lambda: eval_34()),
			(cond_m2_0 and cond_m6_m1, lambda: eval_34()),
			(cond_m2_m1 and cond_m3_0, lambda: eval_32()),
			(cond_m2_m1 and cond_m4_0, lambda: eval_32()),
			(cond_m3_0 and cond_m4_m1, lambda: eval_32()),
			(cond_m3_0 and cond_m5_m1, lambda: eval_34()),
			(cond_m3_0 and cond_m6_m1, lambda: eval_34()),
			(cond_m3_m1 and cond_m4_0, lambda: eval_32()),
			(cond_m2_m1 and cond_m5_0, lambda: eval_33()),
			(cond_m3_m1 and cond_m5_0, lambda: eval_33()),
			(cond_m4_0 and cond_m5_m1, lambda: eval_34()),
			(cond_m4_0 and cond_m6_m1, lambda: eval_34()),
			(cond_m4_m1 and cond_m5_0, lambda: eval_33()),
			(cond_m2_m1 and cond_m6_0, lambda: eval_33()),
			(cond_m3_m1 and cond_m6_0, lambda: eval_33()),
			(cond_m4_m1 and cond_m6_0, lambda: eval_33()),
			(cond_m5_0 and cond_m6_m1, lambda: eval_34()),
			(cond_m5_m1 and cond_m6_0, lambda: eval_34()),
			(cond_m1_0, lambda: eval_34()),
			(cond_m2_0, lambda: eval_34()),
			(cond_m3_0, lambda: eval_34()),
			(cond_m4_0, lambda: eval_34()),
			(cond_m5_0, lambda: eval_34()),
			(cond_m6_0, lambda: eval_34()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_27()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2, lambda: eval_28()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3, lambda: eval_29()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2, lambda: eval_29()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2 and cond_m6_m2, lambda: eval_29()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1 and cond_m6_m2, lambda: eval_28()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_m1, lambda: eval_28()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4 and cond_m6_m4, lambda: eval_30()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3 and cond_m6_m3, lambda: eval_30()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1 and cond_m6_m3, lambda: eval_29()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3 and cond_m6_m1, lambda: eval_29()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2 and cond_m6_m2, lambda: eval_30()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1 and cond_m6_m2, lambda: eval_29()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2 and cond_m6_m1, lambda: eval_29()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1 and cond_m6_m2, lambda: eval_29()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2 and cond_m6_m1, lambda: eval_29()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1 and cond_m6_m1, lambda: eval_28()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m6_m5, lambda: eval_27()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1 and cond_m6_m4, lambda: eval_30()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4 and cond_m6_m1, lambda: eval_30()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m3, lambda: eval_30()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3 and cond_m6_m1, lambda: eval_30()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1 and cond_m6_m1, lambda: eval_29()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m2, lambda: eval_30()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2 and cond_m6_m1, lambda: eval_30()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1 and cond_m6_m1, lambda: eval_29()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_29()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1, lambda: eval_27()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m6_m1, lambda: eval_27()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_30()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_30()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_30()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_m3, lambda: eval_31()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_m4, lambda: eval_32()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_m3, lambda: eval_32()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_m3, lambda: eval_31()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_m2, lambda: eval_31()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_m5, lambda: eval_28()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_m4, lambda: eval_32()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_m2, lambda: eval_32()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_m3, lambda: eval_32()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_m2, lambda: eval_32()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_m2, lambda: eval_31()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2, lambda: eval_28()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_m2, lambda: eval_28()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_m2, lambda: eval_32()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_m2, lambda: eval_32()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_m4, lambda: eval_33()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_m4, lambda: eval_33()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_m3, lambda: eval_33()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_m3, lambda: eval_31()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_m1, lambda: eval_31()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_m5, lambda: eval_29()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_m4, lambda: eval_33()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_m3, lambda: eval_33()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_m5, lambda: eval_29()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_m4, lambda: eval_33()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_m2, lambda: eval_33()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_m5, lambda: eval_29()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_m4, lambda: eval_32()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_m1, lambda: eval_32()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_m3, lambda: eval_33()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_m2, lambda: eval_33()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_m3, lambda: eval_32()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_m1, lambda: eval_32()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_m2, lambda: eval_31()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_m1, lambda: eval_31()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3, lambda: eval_29()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_m3, lambda: eval_29()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_m3, lambda: eval_33()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2, lambda: eval_29()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_m2, lambda: eval_29()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_m2, lambda: eval_33()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2, lambda: eval_29()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_m2, lambda: eval_29()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1, lambda: eval_28()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_m1, lambda: eval_28()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_m2, lambda: eval_32()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_m1, lambda: eval_32()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_m2, lambda: eval_33()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_m2, lambda: eval_32()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_m1, lambda: eval_32()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_m5, lambda: eval_30()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_m5, lambda: eval_30()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_m4, lambda: eval_33()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_m1, lambda: eval_33()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_m5, lambda: eval_30()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_m4, lambda: eval_33()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_m1, lambda: eval_33()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_m3, lambda: eval_33()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_m1, lambda: eval_33()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_m1, lambda: eval_31()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4, lambda: eval_30()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_m4, lambda: eval_30()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3, lambda: eval_30()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_m3, lambda: eval_30()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1, lambda: eval_29()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_m1, lambda: eval_29()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_m3, lambda: eval_33()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_m1, lambda: eval_33()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2, lambda: eval_30()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_m2, lambda: eval_30()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1, lambda: eval_29()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_m1, lambda: eval_29()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_m2, lambda: eval_33()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_m1, lambda: eval_33()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1, lambda: eval_29()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_m1, lambda: eval_29()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_m1, lambda: eval_32()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_m2, lambda: eval_33()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_m1, lambda: eval_33()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_m1, lambda: eval_32()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1, lambda: eval_27()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1, lambda: eval_30()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_m1, lambda: eval_30()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1, lambda: eval_30()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_m1, lambda: eval_30()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_33()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1, lambda: eval_30()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_m1, lambda: eval_30()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_33()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_33()),
			(cond_m5_m4 and cond_m6_m4, lambda: eval_34()),
			(cond_m4_m3 and cond_m6_m5, lambda: eval_31()),
			(cond_m5_m3 and cond_m6_m4, lambda: eval_34()),
			(cond_m5_m4 and cond_m6_m3, lambda: eval_34()),
			(cond_m4_m3 and cond_m5_m3, lambda: eval_31()),
			(cond_m4_m3 and cond_m6_m3, lambda: eval_31()),
			(cond_m5_m3 and cond_m6_m3, lambda: eval_34()),
			(cond_m3_m2 and cond_m6_m5, lambda: eval_32()),
			(cond_m4_m2 and cond_m6_m5, lambda: eval_32()),
			(cond_m5_m2 and cond_m6_m4, lambda: eval_34()),
			(cond_m5_m4 and cond_m6_m2, lambda: eval_34()),
			(cond_m3_m2 and cond_m5_m4, lambda: eval_32()),
			(cond_m3_m2 and cond_m6_m4, lambda: eval_32()),
			(cond_m4_m2 and cond_m5_m3, lambda: eval_32()),
			(cond_m4_m2 and cond_m6_m3, lambda: eval_32()),
			(cond_m4_m3 and cond_m5_m2, lambda: eval_31()),
			(cond_m4_m3 and cond_m6_m2, lambda: eval_31()),
			(cond_m5_m2 and cond_m6_m3, lambda: eval_34()),
			(cond_m5_m3 and cond_m6_m2, lambda: eval_34()),
			(cond_m3_m2 and cond_m4_m2, lambda: eval_28()),
			(cond_m3_m2 and cond_m5_m2, lambda: eval_32()),
			(cond_m3_m2 and cond_m6_m2, lambda: eval_32()),
			(cond_m4_m2 and cond_m5_m2, lambda: eval_32()),
			(cond_m4_m2 and cond_m6_m2, lambda: eval_32()),
			(cond_m5_m2 and cond_m6_m2, lambda: eval_34()),
			(cond_m2_m1 and cond_m6_m5, lambda: eval_33()),
			(cond_m3_m1 and cond_m6_m5, lambda: eval_33()),
			(cond_m4_m1 and cond_m6_m5, lambda: eval_33()),
			(cond_m5_m1 and cond_m6_m4, lambda: eval_34()),
			(cond_m5_m4 and cond_m6_m1, lambda: eval_34()),
			(cond_m2_m1 and cond_m5_m4, lambda: eval_33()),
			(cond_m2_m1 and cond_m6_m4, lambda: eval_33()),
			(cond_m3_m1 and cond_m5_m4, lambda: eval_33()),
			(cond_m3_m1 and cond_m6_m4, lambda: eval_33()),
			(cond_m4_m1 and cond_m5_m3, lambda: eval_33()),
			(cond_m4_m1 and cond_m6_m3, lambda: eval_33()),
			(cond_m4_m3 and cond_m5_m1, lambda: eval_31()),
			(cond_m4_m3 and cond_m6_m1, lambda: eval_31()),
			(cond_m5_m1 and cond_m6_m3, lambda: eval_34()),
			(cond_m5_m3 and cond_m6_m1, lambda: eval_34()),
			(cond_m2_m1 and cond_m4_m3, lambda: eval_29()),
			(cond_m2_m1 and cond_m5_m3, lambda: eval_33()),
			(cond_m2_m1 and cond_m6_m3, lambda: eval_33()),
			(cond_m3_m1 and cond_m4_m2, lambda: eval_29()),
			(cond_m3_m1 and cond_m5_m2, lambda: eval_33()),
			(cond_m3_m1 and cond_m6_m2, lambda: eval_33()),
			(cond_m3_m2 and cond_m4_m1, lambda: eval_29()),
			(cond_m3_m2 and cond_m5_m1, lambda: eval_32()),
			(cond_m3_m2 and cond_m6_m1, lambda: eval_32()),
			(cond_m4_m1 and cond_m5_m2, lambda: eval_33()),
			(cond_m4_m1 and cond_m6_m2, lambda: eval_33()),
			(cond_m4_m2 and cond_m5_m1, lambda: eval_32()),
			(cond_m4_m2 and cond_m6_m1, lambda: eval_32()),
			(cond_m5_m1 and cond_m6_m2, lambda: eval_34()),
			(cond_m5_m2 and cond_m6_m1, lambda: eval_34()),
			(cond_m2_m1 and cond_m3_m1, lambda: eval_30()),
			(cond_m2_m1 and cond_m4_m1, lambda: eval_30()),
			(cond_m2_m1 and cond_m5_m1, lambda: eval_33()),
			(cond_m2_m1 and cond_m6_m1, lambda: eval_33()),
			(cond_m3_m1 and cond_m4_m1, lambda: eval_30()),
			(cond_m3_m1 and cond_m5_m1, lambda: eval_33()),
			(cond_m3_m1 and cond_m6_m1, lambda: eval_33()),
			(cond_m4_m1 and cond_m5_m1, lambda: eval_33()),
			(cond_m4_m1 and cond_m6_m1, lambda: eval_33()),
			(cond_m5_m1 and cond_m6_m1, lambda: eval_34()),
			(cond_m6_m5, lambda: eval_34()),
			(cond_m5_m4, lambda: eval_34()),
			(cond_m6_m4, lambda: eval_34()),
			(cond_m4_m3, lambda: eval_31()),
			(cond_m5_m3, lambda: eval_34()),
			(cond_m6_m3, lambda: eval_34()),
			(cond_m3_m2, lambda: eval_32()),
			(cond_m4_m2, lambda: eval_32()),
			(cond_m5_m2, lambda: eval_34()),
			(cond_m6_m2, lambda: eval_34()),
			(cond_m2_m1, lambda: eval_33()),
			(cond_m3_m1, lambda: eval_33()),
			(cond_m4_m1, lambda: eval_33()),
			(cond_m5_m1, lambda: eval_34()),
			(cond_m6_m1, lambda: eval_34()),
			(True, lambda: eval_34())
		]

		for condition,action in conditions:
			if condition:
				res = action()
				return res * mass_scale**(-4.)

	except Exception as e:
		raise Exception(f"There was an error when evaluating the T111134 integral with masses {m1}, {m2}, {m3}, {m4}, {m5}, {m6} from {e}")