# This file is automatically generated. Do not modify it manually!
from functools import lru_cache

from .config import cond, Number, getMudim, getDiffeps
from .OneLoop import B0fin, B0del
from .T134 import T134fin


@lru_cache(maxsize=150)
def T1113334(m1: Number, m2: Number, m3: Number, m4: Number, m5: Number, m6: Number, m7, mudim = None) -> Number:
	""" Computes the UV-finite part of the T1113334 integral.

	Args:
		m1: internal mass
		m2: internal mass
		m3: internal mass
		m4: internal mass
		m5: internal mass
		m6: internal mass
		m7: internal mass
		mudim: squared renormalization scale (if `None`, the global value is used)

	Returns:
		finite part of the T1113334 integral.
	"""

	try:

		if mudim is None:
			mudim = getMudim()

		# rescale masses for better numerical stability
		mass_scale = max([m1, m2, m3, m4, m5, m6, m7])
		if mass_scale <= getDiffeps():
			return 0
		m1 /= mass_scale
		m2 /= mass_scale
		m3 /= mass_scale
		m4 /= mass_scale
		m5 /= mass_scale
		m6 /= mass_scale
		m7 /= mass_scale
		mudim /= mass_scale**2
		m1, m2, m3 = sorted([m1, m2, m3])
		m4, m5, m6 = sorted([m4, m5, m6])
		

		m1sq = m1**2
		m2sq = m2**2
		m3sq = m3**2
		m4sq = m4**2
		m5sq = m5**2
		m6sq = m6**2
		m7sq = m7**2

		def eval_1():
			return 0
		def eval_2():
			return (9*m7sq - 5*m7sq*B0fin(0,0,m7sq,mudim) - 6*T134fin(m7,0,0,mudim))/m7**8
		def eval_3():
			return (1 - 2*B0fin(0,0,m6sq,mudim))/(2.*m6**6)
		def eval_4():
			return (1 - 2*B0fin(0,0,m3sq,mudim))/(2.*m3**6)
		def eval_5():
			return (2*B0fin(0,0,m5sq,mudim))/m5**6
		def eval_6():
			return (2*B0fin(0,0,m2sq,mudim))/m2**6
		def eval_7():
			return -((m5**4 - m6**4 + 2*m6**4*B0fin(0,0,m5sq,mudim) - 2*m5**4*B0fin(0,0,m6sq,mudim))/(2*m5**6*m6**4 - 2*m5**4*m6**6))
		def eval_8():
			return -((m3sq*m6**4 + m3**4*m6sq + 2*m3sq*m6**4*B0fin(0,0,m3sq,mudim) + 2*m3**4*m6sq*B0fin(0,0,m6sq,mudim) - m6**4*T134fin(m3,0,0,mudim) + m3sq*m6sq*T134fin(m3,0,0,mudim) - m3**4*T134fin(m6,0,0,mudim) + m3sq*m6sq*T134fin(m6,0,0,mudim) - m3sq*m6sq*T134fin(m6,m3,0,mudim))/(m3**6*m6**6))
		def eval_9():
			return -((m2**4 - m3**4 + 2*m3**4*B0fin(0,0,m2sq,mudim) - 2*m2**4*B0fin(0,0,m3sq,mudim))/(2*m2**6*m3**4 - 2*m2**4*m3**6))
		def eval_10():
			return (7*m3sq - 2*m3sq*B0del(0,0,m3sq,mudim) - 4*m3sq*B0fin(0,0,m3sq,mudim) - m3sq*B0fin(0,0,m3sq,mudim)**2 - 3*T134fin(m3,0,0,mudim) + T134fin(m3,m3,m3,mudim))/m3**8
		def eval_11():
			return -0.5*(-2 + 2*B0del(0,0,m3sq,mudim) + 2*B0fin(0,0,m3sq,mudim) + B0fin(0,0,m3sq,mudim)**2)/m3**6
		def eval_12():
			return -0.5*(-2 + 2*B0del(0,0,m2sq,mudim) + 2*B0fin(0,0,m2sq,mudim) + B0fin(0,0,m2sq,mudim)**2)/m2**6
		def eval_13():
			return ((-4*m3sq*(B0del(0,0,m3sq,mudim) + B0del(0,0,m6sq,mudim) - B0fin(0,0,m3sq,mudim) - B0fin(0,0,m6sq,mudim) + B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim)))/(m3sq - m6sq)**2 + (6*m3sq - 4*m6sq + 2*(m3sq - 2*m6sq)*B0del(0,0,m6sq,mudim) - 2*(3*m3sq + 2*m6sq)*B0fin(0,0,m6sq,mudim) + (m3sq - 2*m6sq)*B0fin(0,0,m6sq,mudim)**2)/m6**4 + (2*(m6**4 + 4*m3sq*m6sq + 2*(m6**4 + 2*m3sq*m6sq)*B0fin(0,0,m6sq,mudim) - 3*m3sq*T134fin(m6,0,0,mudim)))/m6**6 + (2*(-(m6sq*(m3sq + m6sq)*(m3sq + m6sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim))) - (m3**4 - 3*m3sq*m6sq)*T134fin(m6,m3,0,mudim)))/(m6**4*(m3sq - m6sq)**2) + (2*T134fin(m6,m6,m3,mudim))/m6**4)/(2.*m3**4)
		def eval_14():
			return (2*m3**4*m5sq + m3sq*m5**4*B0del(0,0,m3sq,mudim) + m3sq*m5**4*B0del(0,0,m5sq,mudim) + m3sq*m5**4*B0fin(0,0,m3sq,mudim) + m3sq*m5**4*B0fin(0,0,m5sq,mudim) + m3sq*m5**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) - m5**4*T134fin(m3,0,0,mudim) + m3sq*m5sq*T134fin(m3,0,0,mudim) - m3**4*T134fin(m5,0,0,mudim) + m3sq*m5sq*T134fin(m5,0,0,mudim) - m3sq*m5sq*T134fin(m5,m3,0,mudim))/(m3**6*m5**6 - m3**4*m5**8)
		def eval_15():
			return ((-4*m3sq + 6*m6sq + (-4*m3sq + 2*m6sq)*B0del(0,0,m3sq,mudim) - 2*(2*m3sq + 3*m6sq)*B0fin(0,0,m3sq,mudim) + (-2*m3sq + m6sq)*B0fin(0,0,m3sq,mudim)**2)/m3**4 - (4*m6sq*(B0del(0,0,m3sq,mudim) + B0del(0,0,m6sq,mudim) - B0fin(0,0,m3sq,mudim) - B0fin(0,0,m6sq,mudim) + B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim)))/(m3sq - m6sq)**2 + (2*(m3**4 + 4*m3sq*m6sq + 2*(m3**4 + 2*m3sq*m6sq)*B0fin(0,0,m3sq,mudim) - 3*m6sq*T134fin(m3,0,0,mudim)))/m3**6 + (2*(-(m3sq*(m3sq + m6sq)*(m3sq + m6sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim))) + (-m6**4 + 3*m3sq*m6sq)*T134fin(m6,m3,0,mudim)))/(m3**4*(m3sq - m6sq)**2) + (2*T134fin(m6,m3,m3,mudim))/m3**4)/(2.*m6**4)
		def eval_16():
			return -((2*m2sq*m6**4 + m2**4*m6sq*B0del(0,0,m2sq,mudim) + m2**4*m6sq*B0del(0,0,m6sq,mudim) + m2**4*m6sq*B0fin(0,0,m2sq,mudim) + m2**4*m6sq*B0fin(0,0,m6sq,mudim) + m2**4*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) - m6**4*T134fin(m2,0,0,mudim) + m2sq*m6sq*T134fin(m2,0,0,mudim) - m2**4*T134fin(m6,0,0,mudim) + m2sq*m6sq*T134fin(m6,0,0,mudim) - m2sq*m6sq*T134fin(m6,m2,0,mudim))/(m2**8*m6**4 - m2**6*m6**6))
		def eval_17():
			return (2*m3sq*m6sq*(m3sq - m7sq)**2*(m6sq - m7sq)**2*m7sq - 2*m3sq*m7**6*(m6**3 - m6*m7sq)**2*B0del(0,0,m3sq,mudim) - 2*m6sq*m7**6*(m3**3 - m3*m7sq)**2*B0del(0,0,m6sq,mudim) - 2*m6sq*m7**6*(m3**3 - m3*m7sq)**2*B0del(0,0,m7sq,mudim) - 2*m3sq*m7**6*(m6**3 - m6*m7sq)**2*B0del(0,0,m7sq,mudim) + 2*m3sq*m7**6*(m6**3 - m6*m7sq)**2*B0fin(0,0,m3sq,mudim) + 2*m6sq*m7**6*(m3**3 - m3*m7sq)**2*B0fin(0,0,m6sq,mudim) + 2*m6sq*m7**6*(m3**3 - m3*m7sq)**2*B0fin(0,0,m7sq,mudim) + 2*m3sq*m7**6*(m6**3 - m6*m7sq)**2*B0fin(0,0,m7sq,mudim) - 2*m3sq*m7**6*(m6**3 - m6*m7sq)**2*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim) - 2*m6sq*m7**6*(m3**3 - m3*m7sq)**2*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim) + m3sq*m7**4*(m3sq - m7sq)**2*(m6sq - m7sq)**2*(1 + 2*B0fin(0,0,m7sq,mudim)) + m6sq*m7**4*(m3sq - m7sq)**2*(m6sq - m7sq)**2*(1 + 2*B0fin(0,0,m7sq,mudim)) + m3sq*m6sq*(m3sq - m7sq)**2*(m6sq - m7sq)**2*m7sq*(1 + 2*B0fin(0,0,m7sq,mudim)) - m3sq*m6sq*m7**4*(m6sq - m7sq)**2*(m3sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)) - m7**6*(m6**3 - m6*m7sq)**2*(m3sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)) - m7**4*(m6sq + m7sq)*(m3**3 - m3*m7sq)**2*(m6sq + m7sq + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)) - 2*m3sq*m6sq*(m3sq - m7sq)**2*(m6sq - m7sq)**2*T134fin(m7,0,0,mudim) + m7**4*(m3sq - m7sq)**2*(m6sq - m7sq)**2*T134fin(m7,0,0,mudim) - m3sq*(m3sq - m7sq)**2*(m6sq - m7sq)**2*m7sq*T134fin(m7,0,0,mudim) - m6sq*(m3sq - m7sq)**2*(m6sq - m7sq)**2*m7sq*T134fin(m7,0,0,mudim) - m3**4*m7**4*(m6sq - m7sq)**2*T134fin(m7,m3,0,mudim) + m3sq*m6sq*m7**4*(m6sq - m7sq)**2*T134fin(m7,m3,0,mudim) + 2*m3sq*m7**6*(m6sq - m7sq)**2*T134fin(m7,m3,0,mudim) - m7**8*(m6sq - m7sq)**2*T134fin(m7,m3,0,mudim) + m7**6*(m6**3 - m6*m7sq)**2*T134fin(m7,m3,0,mudim) - m7**4*(m3sq - m7sq)**2*(m6sq - m7sq)**2*T134fin(m7,m6,0,mudim) + m7**4*(m6sq + m7sq)*(m3**3 - m3*m7sq)**2*T134fin(m7,m6,0,mudim) + m7**4*(m3sq - m7sq)**2*(m6sq - m7sq)**2*T134fin(m7,m6,m3,mudim))/(m3**4*m6**4*m7**4*(m3sq - m7sq)**2*(m6sq - m7sq)**2)
		def eval_18():
			return (-(m3sq*m5sq*m6**4) + m3sq*m5**4*m6sq - 2*m3sq*m5sq*m6**4*B0fin(0,0,m5sq,mudim) + 2*m3sq*m5**4*m6sq*B0fin(0,0,m6sq,mudim) - m5sq*m6**4*T134fin(m3,0,0,mudim) + m5**4*m6sq*T134fin(m3,0,0,mudim) + m3sq*m6**4*T134fin(m5,0,0,mudim) - m5sq*m6**4*T134fin(m5,0,0,mudim) + m5sq*m6**4*T134fin(m5,m3,0,mudim) - m3sq*m5**4*T134fin(m6,0,0,mudim) + m5**4*m6sq*T134fin(m6,0,0,mudim) - m5**4*m6sq*T134fin(m6,m3,0,mudim))/(m3**4*m5**4*m6**4*(m5sq - m6sq))
		def eval_19():
			return (-(m2sq*m3**4*m6sq) + m2**4*m3sq*m6sq - 2*m2sq*m3**4*m6sq*B0fin(0,0,m2sq,mudim) + 2*m2**4*m3sq*m6sq*B0fin(0,0,m3sq,mudim) - m2sq*m3**4*T134fin(m2,0,0,mudim) + m3**4*m6sq*T134fin(m2,0,0,mudim) + m2**4*m3sq*T134fin(m3,0,0,mudim) - m2**4*m6sq*T134fin(m3,0,0,mudim) - m2sq*m3**4*T134fin(m6,0,0,mudim) + m2**4*m3sq*T134fin(m6,0,0,mudim) + m2sq*m3**4*T134fin(m6,m2,0,mudim) - m2**4*m3sq*T134fin(m6,m3,0,mudim))/(m2**4*m3**4*(m2sq - m3sq)*m6**4)
		def eval_20():
			return (11 - 30*B0fin(0,0,m4sq,mudim))/(300.*m4**6)
		def eval_21():
			return (1 + B0fin(0,0,m3sq,mudim))/m3**6
		def eval_22():
			return (11 - 30*B0fin(0,0,m1sq,mudim))/(300.*m1**6)
		def eval_23():
			return (1 + B0fin(0,0,m1sq,mudim))/m1**6
		def eval_24():
			return (5*m4**10 + 156*m4**6*m5**4 - 128*m4**4*m5**6 + 167*m4sq*m5**8 - 9*m5**10 - 47*m4**8*m5sq + 36*m4sq*m5**6*(m4sq + m5sq)*B0del(0,0,m4sq,mudim) + 36*m4sq*m5**6*(m4sq + m5sq)*B0del(0,0,m5sq,mudim) - 36*m4**6*m5**4*B0fin(0,0,m4sq,mudim) + 108*m4**4*m5**6*B0fin(0,0,m4sq,mudim) - 6*m4**10*B0fin(0,0,m5sq,mudim) - 108*m4**6*m5**4*B0fin(0,0,m5sq,mudim) + 132*m4**4*m5**6*B0fin(0,0,m5sq,mudim) + 30*m4sq*m5**8*B0fin(0,0,m5sq,mudim) - 18*m5**10*B0fin(0,0,m5sq,mudim) + 42*m4**8*m5sq*B0fin(0,0,m5sq,mudim) + 36*m4**4*m5**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) + 36*m4sq*m5**8*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) - 72*m4sq*m5**6*T134fin(m5,m4,0,mudim))/(36.*m5**4*(m4sq - m5sq)**6)
		def eval_25():
			return -0.05555555555555555*(-11*m4**8 + 78*m4**4*m6**4 + 116*m4sq*m6**6 + 61*m6**8 + 44*m4**6*m6sq + 18*(3*m4**4*m6**4 + 4*m4sq*m6**6 + m6**8)*B0del(0,0,m4sq,mudim) + 18*(3*m4**4*m6**4 + 4*m4sq*m6**6 + m6**8)*B0del(0,0,m6sq,mudim) + 54*m4**4*m6**4*B0fin(0,0,m4sq,mudim) + 144*m4sq*m6**6*B0fin(0,0,m4sq,mudim) - 18*m6**8*B0fin(0,0,m4sq,mudim) - 36*m4**6*m6sq*B0fin(0,0,m4sq,mudim) + 6*m4**8*B0fin(0,0,m6sq,mudim) + 54*m4**4*m6**4*B0fin(0,0,m6sq,mudim) + 156*m4sq*m6**6*B0fin(0,0,m6sq,mudim) - 48*m6**8*B0fin(0,0,m6sq,mudim) - 24*m4**6*m6sq*B0fin(0,0,m6sq,mudim) + 54*m4**4*m6**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) + 72*m4sq*m6**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) + 18*m6**8*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) - 108*m4sq*m6**4*T134fin(m6,m4,0,mudim) - 36*m6**6*T134fin(m6,m4,0,mudim))/(m6**2*(m4sq - m6sq)**6)
		def eval_26():
			return (((m4sq - m5sq)**4*(11 - 6*B0fin(0,0,m4sq,mudim)))/m4**2 - 18*m4sq*(4*m5sq*(m4sq + m5sq) + (m4**4 + 3*m5**4 + 4*m4sq*m5sq)*B0del(0,0,m4sq,mudim) + 2*(3*m5**4 + 7*m4sq*m5sq)*B0fin(0,0,m4sq,mudim) + (m4**4 + 3*m5**4 + 4*m4sq*m5sq)*(B0del(0,0,m5sq,mudim) - B0fin(0,0,m5sq,mudim)) + (6*m5**4 + 14*m4sq*m5sq + (m4**4 + 3*m5**4 + 4*m4sq*m5sq)*B0fin(0,0,m4sq,mudim))*(-1 + B0fin(0,0,m5sq,mudim))) + 36*(m4sq*(m4**4 + m5**4)*B0fin(0,0,m4sq,mudim) + (m4**4 + m5**4)*m5sq*B0fin(0,0,m5sq,mudim) + m4sq*(-2*m4**4 - 5*m5**4 - 7*m4sq*m5sq + (m4sq + 3*m5sq)*T134fin(m5,m4,0,mudim))))/(18.*(m4sq - m5sq)**6)
		def eval_27():
			return (-2*m4**8 + 25*m4**4*m7**4 + 9*m4sq*m7**6 + m7**8 + 15*m4**6*m7sq + 6*m4sq*m7sq*(m4sq + m7sq)**2*B0del(0,0,m4sq,mudim) + 6*m4sq*m7sq*(m4sq + m7sq)**2*B0del(0,0,m7sq,mudim) - 2*m4**8*B0fin(0,0,m4sq,mudim) + 33*m4**4*m7**4*B0fin(0,0,m4sq,mudim) + 3*m4sq*m7**6*B0fin(0,0,m4sq,mudim) - m7**8*B0fin(0,0,m4sq,mudim) - 9*m4**6*m7sq*B0fin(0,0,m4sq,mudim) + 27*m4**4*m7**4*B0fin(0,0,m7sq,mudim) - 7*m4sq*m7**6*B0fin(0,0,m7sq,mudim) - m7**8*B0fin(0,0,m7sq,mudim) + 5*m4**6*m7sq*B0fin(0,0,m7sq,mudim) + 12*m4**4*m7**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) + 6*m4sq*m7**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) + 6*m4**6*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) - 12*m4sq*m7**4*T134fin(m7,m4,0,mudim) - 12*m4**4*m7sq*T134fin(m7,m4,0,mudim))/(2.*m4**2*(m4sq - m7sq)**6)
		def eval_28():
			return (((m4sq - m6sq)**4*(-27*m4sq + 5*m6sq + 6*(3*m4sq - m6sq)*B0fin(0,0,m4sq,mudim)))/m4**4 + 36*m4sq*m6sq*(m4sq + m6sq)*(-2 + B0del(0,0,m4sq,mudim) + B0del(0,0,m6sq,mudim) + B0fin(0,0,m4sq,mudim) + B0fin(0,0,m6sq,mudim) + B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim)) + 18*(m4**6 + 7*m4sq*m6**4 + m6**6 + 7*m4**4*m6sq - 2*(m4**3 - m4*m6sq)**2*B0fin(0,0,m4sq,mudim) - 2*(-(m4sq*m6) + m6**3)**2*B0fin(0,0,m6sq,mudim) - 4*m4sq*m6sq*T134fin(m6,m4,0,mudim)))/(36.*(m4sq - m6sq)**6)
		def eval_29():
			return (5*m1**10 + 156*m1**6*m2**4 - 128*m1**4*m2**6 + 167*m1sq*m2**8 - 9*m2**10 - 47*m1**8*m2sq + 36*m1sq*m2**6*(m1sq + m2sq)*B0del(0,0,m1sq,mudim) + 36*m1sq*m2**6*(m1sq + m2sq)*B0del(0,0,m2sq,mudim) - 36*m1**6*m2**4*B0fin(0,0,m1sq,mudim) + 108*m1**4*m2**6*B0fin(0,0,m1sq,mudim) - 6*m1**10*B0fin(0,0,m2sq,mudim) - 108*m1**6*m2**4*B0fin(0,0,m2sq,mudim) + 132*m1**4*m2**6*B0fin(0,0,m2sq,mudim) + 30*m1sq*m2**8*B0fin(0,0,m2sq,mudim) - 18*m2**10*B0fin(0,0,m2sq,mudim) + 42*m1**8*m2sq*B0fin(0,0,m2sq,mudim) + 36*m1**4*m2**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 36*m1sq*m2**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 72*m1sq*m2**6*T134fin(m2,m1,0,mudim))/(36.*m2**4*(m1sq - m2sq)**6)
		def eval_30():
			return -0.5*(4*m1**4*m2sq + 2*m1sq*m2sq*(m1sq + m2sq)*B0del(0,0,m2sq,mudim) + 4*m1sq*m2**4*B0fin(0,0,m1sq,mudim) + 2*m1sq*m2**4*B0fin(0,0,m2sq,mudim) - 2*m1**4*m2sq*B0fin(0,0,m2sq,mudim) + m1sq*m2**4*B0fin(0,0,m2sq,mudim)**2 + m1**4*m2sq*B0fin(0,0,m2sq,mudim)**2 - 2*m2**4*T134fin(m1,0,0,mudim) + 2*m1sq*m2sq*T134fin(m1,0,0,mudim) - 2*m1**4*T134fin(m2,0,0,mudim) + 2*m1sq*m2sq*T134fin(m2,0,0,mudim) - 2*m1sq*m2sq*T134fin(m2,m1,0,mudim))/(m2**6*(m1**3 - m1*m2sq)**2)
		def eval_31():
			return -0.05555555555555555*(-11*m1**8 + 78*m1**4*m3**4 + 116*m1sq*m3**6 + 61*m3**8 + 44*m1**6*m3sq + 18*(3*m1**4*m3**4 + 4*m1sq*m3**6 + m3**8)*B0del(0,0,m1sq,mudim) + 18*(3*m1**4*m3**4 + 4*m1sq*m3**6 + m3**8)*B0del(0,0,m3sq,mudim) + 54*m1**4*m3**4*B0fin(0,0,m1sq,mudim) + 144*m1sq*m3**6*B0fin(0,0,m1sq,mudim) - 18*m3**8*B0fin(0,0,m1sq,mudim) - 36*m1**6*m3sq*B0fin(0,0,m1sq,mudim) + 6*m1**8*B0fin(0,0,m3sq,mudim) + 54*m1**4*m3**4*B0fin(0,0,m3sq,mudim) + 156*m1sq*m3**6*B0fin(0,0,m3sq,mudim) - 48*m3**8*B0fin(0,0,m3sq,mudim) - 24*m1**6*m3sq*B0fin(0,0,m3sq,mudim) + 54*m1**4*m3**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 72*m1sq*m3**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 18*m3**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 108*m1sq*m3**4*T134fin(m3,m1,0,mudim) - 36*m3**6*T134fin(m3,m1,0,mudim))/(m3**2*(m1sq - m3sq)**6)
		def eval_32():
			return (((m1sq - m2sq)**4*(11 - 6*B0fin(0,0,m1sq,mudim)))/m1**2 - 18*m1sq*(4*m2sq*(m1sq + m2sq) + (m1**4 + 3*m2**4 + 4*m1sq*m2sq)*B0del(0,0,m1sq,mudim) + 2*(3*m2**4 + 7*m1sq*m2sq)*B0fin(0,0,m1sq,mudim) + (m1**4 + 3*m2**4 + 4*m1sq*m2sq)*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)) + (6*m2**4 + 14*m1sq*m2sq + (m1**4 + 3*m2**4 + 4*m1sq*m2sq)*B0fin(0,0,m1sq,mudim))*(-1 + B0fin(0,0,m2sq,mudim))) + 36*(m1sq*(m1**4 + m2**4)*B0fin(0,0,m1sq,mudim) + (m1**4 + m2**4)*m2sq*B0fin(0,0,m2sq,mudim) + m1sq*(-2*m1**4 - 5*m2**4 - 7*m1sq*m2sq + (m1sq + 3*m2sq)*T134fin(m2,m1,0,mudim))))/(18.*(m1sq - m2sq)**6)
		def eval_33():
			return (-2*m3sq*m6sq*(m3sq + m6sq)*B0del(0,0,m3sq,mudim) + (2*m3sq*m6**4 - 2*m3**4*m6sq)*B0fin(0,0,m3sq,mudim) - m3sq*m6sq*(m3sq + m6sq)*B0fin(0,0,m3sq,mudim)**2 - 4*m3**4*m6sq*B0fin(0,0,m6sq,mudim) + 2*(m6**4 - m3sq*m6sq)*T134fin(m3,0,0,mudim) + 2*m3sq*(-2*m6**4 + (m3sq - m6sq)*T134fin(m6,0,0,mudim) + m6sq*T134fin(m6,m3,0,mudim)))/(2.*m3**6*m6**2*(m3sq - m6sq)**2)
		def eval_34():
			return (-2*m1**8 + 25*m1**4*m7**4 + 9*m1sq*m7**6 + m7**8 + 15*m1**6*m7sq + 6*m1sq*m7sq*(m1sq + m7sq)**2*B0del(0,0,m1sq,mudim) + 6*m1sq*m7sq*(m1sq + m7sq)**2*B0del(0,0,m7sq,mudim) - 2*m1**8*B0fin(0,0,m1sq,mudim) + 33*m1**4*m7**4*B0fin(0,0,m1sq,mudim) + 3*m1sq*m7**6*B0fin(0,0,m1sq,mudim) - m7**8*B0fin(0,0,m1sq,mudim) - 9*m1**6*m7sq*B0fin(0,0,m1sq,mudim) + 27*m1**4*m7**4*B0fin(0,0,m7sq,mudim) - 7*m1sq*m7**6*B0fin(0,0,m7sq,mudim) - m7**8*B0fin(0,0,m7sq,mudim) + 5*m1**6*m7sq*B0fin(0,0,m7sq,mudim) + 12*m1**4*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) + 6*m1sq*m7**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) + 6*m1**6*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 12*m1sq*m7**4*T134fin(m7,m1,0,mudim) - 12*m1**4*m7sq*T134fin(m7,m1,0,mudim))/(2.*m1**2*(m1sq - m7sq)**6)
		def eval_35():
			return (((m1sq - m3sq)**4*(-27*m1sq + 5*m3sq + 6*(3*m1sq - m3sq)*B0fin(0,0,m1sq,mudim)))/m1**4 + 36*m1sq*m3sq*(m1sq + m3sq)*(-2 + B0del(0,0,m1sq,mudim) + B0del(0,0,m3sq,mudim) + B0fin(0,0,m1sq,mudim) + B0fin(0,0,m3sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim)) + 18*(m1**6 + 7*m1sq*m3**4 + m3**6 + 7*m1**4*m3sq - 2*(m1**3 - m1*m3sq)**2*B0fin(0,0,m1sq,mudim) - 2*(-(m1sq*m3) + m3**3)**2*B0fin(0,0,m3sq,mudim) - 4*m1sq*m3sq*T134fin(m3,m1,0,mudim)))/(36.*(m1sq - m3sq)**6)
		def eval_36():
			return (-2*m1sq*m3sq*(m1sq + m3sq)*B0del(0,0,m1sq,mudim) + (2*m1sq*m3**4 - 2*m1**4*m3sq)*B0fin(0,0,m1sq,mudim) - m1sq*m3sq*(m1sq + m3sq)*B0fin(0,0,m1sq,mudim)**2 - 4*m1**4*m3sq*B0fin(0,0,m3sq,mudim) + 2*(m3**4 - m1sq*m3sq)*T134fin(m1,0,0,mudim) + 2*m1sq*(-2*m3**4 + (m1sq - m3sq)*T134fin(m3,0,0,mudim) + m3sq*T134fin(m3,m1,0,mudim)))/(2.*m1**6*m3**2*(m1sq - m3sq)**2)
		def eval_37():
			return (18*m4sq*m6**4*(m5sq - m6sq)**5*(m4sq + m6sq)*(B0del(0,0,m4sq,mudim) + 2*B0fin(0,0,m4sq,mudim)) + 18*m5sq*m6**4*(-m4sq + m6sq)**5*(m5sq + m6sq)*(B0del(0,0,m5sq,mudim) + 2*B0fin(0,0,m5sq,mudim)) + (m4sq - m5sq)*(m4sq - m6sq)**4*(m5sq - m6sq)**4*(8 - 3*B0fin(0,0,m6sq,mudim)) + 3*((m4sq - m5sq)*(m4sq - m6sq)**4*(m5sq - m6sq)**4 + 6*m4sq*m6**4*(m4sq + m6sq)*(-m5sq + m6sq)**5*(2 + B0fin(0,0,m4sq,mudim)) + 6*m5sq*m6**4*(m4sq - m6sq)**5*(m5sq + m6sq)*(2 + B0fin(0,0,m5sq,mudim)))*(1 - B0fin(0,0,m6sq,mudim)) + 18*m6**4*(m4sq*(m5sq - m6sq)**5*(m4sq + m6sq) - m5sq*(m4sq - m6sq)**5*(m5sq + m6sq))*(B0del(0,0,m6sq,mudim) - B0fin(0,0,m6sq,mudim)) + 9*(m5sq - m6sq)**5*m6sq*(2*(m4sq + m6sq)**3 - (m4sq - m6sq)**2*(m4sq + m6sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)) - 4*m4sq*m6sq*T134fin(m6,m4,0,mudim)) - 9*(m4sq - m6sq)**5*m6sq*(2*(m5sq + m6sq)**3 - (m5sq - m6sq)**2*(m5sq + m6sq + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)) - 4*m5sq*m6sq*T134fin(m6,m5,0,mudim)))/(18.*(m4sq - m5sq)*m6**2*(m4sq - m6sq)**5*(m5sq - m6sq)**5)
		def eval_38():
			return ((m4sq*m7sq*(m4sq + m7sq)*B0del(0,0,m4sq,mudim))/(m4sq - m7sq)**4 + (m4**6/(m4sq - m7sq)**4 + (3*m4sq*m7**4)/(m4sq - m7sq)**4 + m7**6/(m4sq - m7sq)**4 - (m4sq*m5**6)/(m5sq - m7sq)**5 - (5*m5**4*m7**4)/(m5sq - m7sq)**5 + (5*m4sq*m5sq*m7**4)/(m5sq - m7sq)**5 + (7*m4sq*m7**6)/(m5sq - m7sq)**5 - (m5sq*m7**6)/(m5sq - m7sq)**5 + m7**8/(m5sq - m7sq)**5 + (4*m5sq*m7**4)/(m5sq - m7sq)**4 + (3*m4**4*m7sq)/(m4sq - m7sq)**4 + (13*m4sq*m5**4*m7sq)/(m5sq - m7sq)**5 - (19*m5**6*m7sq)/(m5sq - m7sq)**5 + (4*m5**4*m7sq)/(m5sq - m7sq)**4 + (2*m7sq*(m5sq + m7sq)*(-3*m5**4 + m4sq*(2*m5sq + m7sq))*B0del(0,0,m5sq,mudim))/(m5sq - m7sq)**5 - (2*(m4sq - m5sq)*m7sq*(3*m5sq*m7**8*(m5sq + m7sq) - m4**6*(m5**6 + 11*m5sq*m7**4 + 4*m7**6 + 8*m5**4*m7sq) - m4sq*m7sq*(m5**8 + 22*m5**4*m7**4 + m5sq*m7**6 + 5*m7**8 - 5*m5**6*m7sq) + m4**4*(-m5**8 + 13*m5**4*m7**4 + 14*m5sq*m7**6 + 6*m7**8 + 4*m5**6*m7sq) + m4**8*(2*m5**4 + m7**4 + 3*m5sq*m7sq))*B0del(0,0,m7sq,mudim))/((m4sq - m7sq)**4*(-m5sq + m7sq)**5) - (2*m4**6*B0fin(0,0,m4sq,mudim))/(m4sq - m7sq)**4 + (6*m4**4*m7sq*B0fin(0,0,m4sq,mudim))/(m4sq - m7sq)**4 - (2*m4sq*m5**6*B0fin(0,0,m5sq,mudim))/(m5sq - m7sq)**5 + (4*m5**8*B0fin(0,0,m5sq,mudim))/(m5sq - m7sq)**5 - (10*m5**4*m7**4*B0fin(0,0,m5sq,mudim))/(m5sq - m7sq)**5 + (16*m4sq*m5sq*m7**4*B0fin(0,0,m5sq,mudim))/(m5sq - m7sq)**5 - (2*m5sq*m7**4*B0fin(0,0,m5sq,mudim))/(m5sq - m7sq)**4 - (6*m5**6*m7sq*B0fin(0,0,m5sq,mudim))/(m5sq - m7sq)**5 - (2*m5**4*m7sq*B0fin(0,0,m5sq,mudim))/(m5sq - m7sq)**4 + (2*m4sq*m7**6*B0fin(0,0,m5sq,mudim))/(-m5sq + m7sq)**5 + (6*m4sq*m7**4*B0fin(0,0,m7sq,mudim))/(m4sq - m7sq)**4 - (2*m7**6*B0fin(0,0,m7sq,mudim))/(m4sq - m7sq)**4 - (20*m5**4*m7**4*B0fin(0,0,m7sq,mudim))/(m5sq - m7sq)**5 + (14*m4sq*m5sq*m7**4*B0fin(0,0,m7sq,mudim))/(m5sq - m7sq)**5 + (10*m5sq*m7**6*B0fin(0,0,m7sq,mudim))/(m5sq - m7sq)**5 - (2*m5sq*m7**4*B0fin(0,0,m7sq,mudim))/(m5sq - m7sq)**4 + (2*m4sq*m5**4*m7sq*B0fin(0,0,m7sq,mudim))/(m5sq - m7sq)**5 - (2*m5**4*m7sq*B0fin(0,0,m7sq,mudim))/(m5sq - m7sq)**4 + (4*m4sq*m7**6*B0fin(0,0,m7sq,mudim))/(-m5sq + m7sq)**5 + (2*m7**8*B0fin(0,0,m7sq,mudim))/(-m5sq + m7sq)**5 + (2*m4sq*m7**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/(m4sq - m7sq)**4 + (2*m4**4*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/(m4sq - m7sq)**4 - (6*m5**4*m7**4*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/(m5sq - m7sq)**5 + (6*m4sq*m5sq*m7**4*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/(m5sq - m7sq)**5 + (2*m4sq*m7**6*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/(m5sq - m7sq)**5 - (2*m5sq*m7**6*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/(m5sq - m7sq)**5 - (2*m5sq*m7**4*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/(m5sq - m7sq)**4 + (4*m4sq*m5**4*m7sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/(m5sq - m7sq)**5 - (4*m5**6*m7sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/(m5sq - m7sq)**5 - (2*m5**4*m7sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/(m5sq - m7sq)**4 - (4*m4sq*m7sq*T134fin(m7,m4,0,mudim))/(m4sq - m7sq)**4 + (12*m5**4*m7sq*T134fin(m7,m5,0,mudim))/(m5sq - m7sq)**5 - (8*m4sq*m5sq*m7sq*T134fin(m7,m5,0,mudim))/(m5sq - m7sq)**5 + (4*m4sq*m7**4*T134fin(m7,m5,0,mudim))/(-m5sq + m7sq)**5)/2.)/(m4sq - m5sq)**2
		def eval_39():
			return (18*m4sq*m5**4*(m4sq + m5sq)*(m5sq - m6sq)**5*(B0del(0,0,m4sq,mudim) + 2*B0fin(0,0,m4sq,mudim)) - 3*(m5sq - m6sq)**4*((m4sq - m5sq)**4*(m4sq - m6sq) + 6*m4sq*m5**4*(m4sq + m5sq)*(m5sq - m6sq)*(2 + B0fin(0,0,m4sq,mudim)))*(1 - B0fin(0,0,m5sq,mudim)) + 18*m4sq*m5**4*(m4sq + m5sq)*(m5sq - m6sq)**5*(B0del(0,0,m5sq,mudim) - B0fin(0,0,m5sq,mudim)) + (m4sq - m5sq)**4*(m4sq - m6sq)*(m5sq - m6sq)**4*(-8 + 3*B0fin(0,0,m5sq,mudim)) - 18*m5**4*(-m4sq + m5sq)**5*m6sq*(m5sq + m6sq)*(-2 + B0del(0,0,m5sq,mudim) + B0del(0,0,m6sq,mudim) + B0fin(0,0,m5sq,mudim) + B0fin(0,0,m6sq,mudim) + B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim)) + 9*m5sq*(m5sq - m6sq)**5*(2*(m4sq + m5sq)**3 - (m4sq - m5sq)**2*(m4sq + m5sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim)) - 4*m4sq*m5sq*T134fin(m5,m4,0,mudim)) + 9*(m4sq - m5sq)**5*m5sq*(2*(m5sq + m6sq)**3 - (m5sq - m6sq)**2*(m5sq + m6sq + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)) - 4*m5sq*m6sq*T134fin(m6,m5,0,mudim)))/(18.*m5**2*(m4sq - m5sq)**5*(m4sq - m6sq)*(m5sq - m6sq)**5)
		def eval_40():
			return ((m7sq*(m4sq + m7sq)*(-3*m4**4 + 2*m4sq*m6sq + m6sq*m7sq)*B0del(0,0,m4sq,mudim))/(m4sq - m7sq)**5 + (-((m4**6*m6sq)/(m4sq - m7sq)**5) - (5*m4**4*m7**4)/(m4sq - m7sq)**5 + (5*m4sq*m6sq*m7**4)/(m4sq - m7sq)**5 - (m4sq*m7**6)/(m4sq - m7sq)**5 + (7*m6sq*m7**6)/(m4sq - m7sq)**5 + m7**8/(m4sq - m7sq)**5 + (4*m4sq*m7**4)/(m4sq - m7sq)**4 + m6**6/(m6sq - m7sq)**4 + (3*m6sq*m7**4)/(m6sq - m7sq)**4 + m7**6/(m6sq - m7sq)**4 - (19*m4**6*m7sq)/(m4sq - m7sq)**5 + (13*m4**4*m6sq*m7sq)/(m4sq - m7sq)**5 + (4*m4**4*m7sq)/(m4sq - m7sq)**4 + (3*m6**4*m7sq)/(m6sq - m7sq)**4 + (2*m6sq*m7sq*(m6sq + m7sq)*B0del(0,0,m6sq,mudim))/(m6sq - m7sq)**4 + (2*(m4sq - m6sq)*m7sq*(m4**8*m6sq*(m6sq + m7sq) + m4**6*(m6**6 - 5*m6sq*m7**4 - 4*m6**4*m7sq) - m6sq*m7**4*(m6**6 + 6*m6sq*m7**4 - 5*m7**6 - 4*m6**4*m7sq) + m4**4*(-2*m6**8 - 13*m6**4*m7**4 + 22*m6sq*m7**6 - 3*m7**8 + 8*m6**6*m7sq) + m4sq*(11*m6**6*m7**4 - 14*m6**4*m7**6 + m6sq*m7**8 - 3*m7**10 - 3*m6**8*m7sq))*B0del(0,0,m7sq,mudim))/((m4sq - m7sq)**5*(m6sq - m7sq)**4) + (4*m4**8*B0fin(0,0,m4sq,mudim))/(m4sq - m7sq)**5 - (2*m4**6*m6sq*B0fin(0,0,m4sq,mudim))/(m4sq - m7sq)**5 - (10*m4**4*m7**4*B0fin(0,0,m4sq,mudim))/(m4sq - m7sq)**5 + (16*m4sq*m6sq*m7**4*B0fin(0,0,m4sq,mudim))/(m4sq - m7sq)**5 - (2*m4sq*m7**4*B0fin(0,0,m4sq,mudim))/(m4sq - m7sq)**4 - (6*m4**6*m7sq*B0fin(0,0,m4sq,mudim))/(m4sq - m7sq)**5 - (2*m4**4*m7sq*B0fin(0,0,m4sq,mudim))/(m4sq - m7sq)**4 + (2*m6sq*m7**6*B0fin(0,0,m4sq,mudim))/(-m4sq + m7sq)**5 - (2*m6**6*B0fin(0,0,m6sq,mudim))/(m6sq - m7sq)**4 + (6*m6**4*m7sq*B0fin(0,0,m6sq,mudim))/(m6sq - m7sq)**4 - (20*m4**4*m7**4*B0fin(0,0,m7sq,mudim))/(m4sq - m7sq)**5 + (14*m4sq*m6sq*m7**4*B0fin(0,0,m7sq,mudim))/(m4sq - m7sq)**5 + (10*m4sq*m7**6*B0fin(0,0,m7sq,mudim))/(m4sq - m7sq)**5 - (2*m4sq*m7**4*B0fin(0,0,m7sq,mudim))/(m4sq - m7sq)**4 + (6*m6sq*m7**4*B0fin(0,0,m7sq,mudim))/(m6sq - m7sq)**4 - (2*m7**6*B0fin(0,0,m7sq,mudim))/(m6sq - m7sq)**4 + (2*m4**4*m6sq*m7sq*B0fin(0,0,m7sq,mudim))/(m4sq - m7sq)**5 - (2*m4**4*m7sq*B0fin(0,0,m7sq,mudim))/(m4sq - m7sq)**4 + (4*m6sq*m7**6*B0fin(0,0,m7sq,mudim))/(-m4sq + m7sq)**5 + (2*m7**8*B0fin(0,0,m7sq,mudim))/(-m4sq + m7sq)**5 - (6*m4**4*m7**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/(m4sq - m7sq)**5 + (6*m4sq*m6sq*m7**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/(m4sq - m7sq)**5 - (2*m4sq*m7**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/(m4sq - m7sq)**5 + (2*m6sq*m7**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/(m4sq - m7sq)**5 - (2*m4sq*m7**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/(m4sq - m7sq)**4 - (4*m4**6*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/(m4sq - m7sq)**5 + (4*m4**4*m6sq*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/(m4sq - m7sq)**5 - (2*m4**4*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/(m4sq - m7sq)**4 + (2*m6sq*m7**4*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/(m6sq - m7sq)**4 + (2*m6**4*m7sq*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/(m6sq - m7sq)**4 + (12*m4**4*m7sq*T134fin(m7,m4,0,mudim))/(m4sq - m7sq)**5 - (8*m4sq*m6sq*m7sq*T134fin(m7,m4,0,mudim))/(m4sq - m7sq)**5 + (4*m6sq*m7**4*T134fin(m7,m4,0,mudim))/(-m4sq + m7sq)**5 - (4*m6sq*m7sq*T134fin(m7,m6,0,mudim))/(m6sq - m7sq)**4)/2.)/(m4sq - m6sq)**2
		def eval_41():
			return ((11 - 6*B0fin(0,0,m4sq,mudim))/(m4**2*(m4sq - m5sq)*(m4sq - m6sq)) - (18*m4sq*m5sq*(m4sq + m5sq)*(-2 + B0del(0,0,m4sq,mudim) + B0del(0,0,m5sq,mudim) + B0fin(0,0,m4sq,mudim) + B0fin(0,0,m5sq,mudim) + B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim)))/((m4sq - m5sq)**5*(m5sq - m6sq)) - (18*m4sq*m6sq*(m4sq + m6sq)*(-2 + B0del(0,0,m4sq,mudim) + B0del(0,0,m6sq,mudim) + B0fin(0,0,m4sq,mudim) + B0fin(0,0,m6sq,mudim) + B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim)))/((m4sq - m6sq)**5*(-m5sq + m6sq)) - (9*(m4**6 + 7*m4sq*m5**4 + m5**6 + 7*m4**4*m5sq - 2*(m4**3 - m4*m5sq)**2*B0fin(0,0,m4sq,mudim) - 2*(-(m4sq*m5) + m5**3)**2*B0fin(0,0,m5sq,mudim) - 4*m4sq*m5sq*T134fin(m5,m4,0,mudim)))/((m4sq - m5sq)**5*(m5sq - m6sq)) - (9*(m4**6 + 7*m4sq*m6**4 + m6**6 + 7*m4**4*m6sq - 2*(m4**3 - m4*m6sq)**2*B0fin(0,0,m4sq,mudim) - 2*(-(m4sq*m6) + m6**3)**2*B0fin(0,0,m6sq,mudim) - 4*m4sq*m6sq*T134fin(m6,m4,0,mudim)))/((m4sq - m6sq)**5*(-m5sq + m6sq)))/18.
		def eval_42():
			return (18*m1sq*m3**4*(m2sq - m3sq)**5*(m1sq + m3sq)*(B0del(0,0,m1sq,mudim) + 2*B0fin(0,0,m1sq,mudim)) + 18*m2sq*m3**4*(-m1sq + m3sq)**5*(m2sq + m3sq)*(B0del(0,0,m2sq,mudim) + 2*B0fin(0,0,m2sq,mudim)) + (m1sq - m2sq)*(m1sq - m3sq)**4*(m2sq - m3sq)**4*(8 - 3*B0fin(0,0,m3sq,mudim)) + 3*((m1sq - m2sq)*(m1sq - m3sq)**4*(m2sq - m3sq)**4 + 6*m1sq*m3**4*(m1sq + m3sq)*(-m2sq + m3sq)**5*(2 + B0fin(0,0,m1sq,mudim)) + 6*m2sq*m3**4*(m1sq - m3sq)**5*(m2sq + m3sq)*(2 + B0fin(0,0,m2sq,mudim)))*(1 - B0fin(0,0,m3sq,mudim)) + 18*m3**4*(m1sq*(m2sq - m3sq)**5*(m1sq + m3sq) - m2sq*(m1sq - m3sq)**5*(m2sq + m3sq))*(B0del(0,0,m3sq,mudim) - B0fin(0,0,m3sq,mudim)) + 9*(m2sq - m3sq)**5*m3sq*(2*(m1sq + m3sq)**3 - (m1sq - m3sq)**2*(m1sq + m3sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim)) - 4*m1sq*m3sq*T134fin(m3,m1,0,mudim)) - 9*(m1sq - m3sq)**5*m3sq*(2*(m2sq + m3sq)**3 - (m2sq - m3sq)**2*(m2sq + m3sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim)) - 4*m2sq*m3sq*T134fin(m3,m2,0,mudim)))/(18.*(m1sq - m2sq)*m3**2*(m1sq - m3sq)**5*(m2sq - m3sq)**5)
		def eval_43():
			return ((m1sq*m7sq*(m1sq + m7sq)*B0del(0,0,m1sq,mudim))/(m1sq - m7sq)**4 + (m1**6/(m1sq - m7sq)**4 + (3*m1sq*m7**4)/(m1sq - m7sq)**4 + m7**6/(m1sq - m7sq)**4 - (m1sq*m2**6)/(m2sq - m7sq)**5 - (5*m2**4*m7**4)/(m2sq - m7sq)**5 + (5*m1sq*m2sq*m7**4)/(m2sq - m7sq)**5 + (7*m1sq*m7**6)/(m2sq - m7sq)**5 - (m2sq*m7**6)/(m2sq - m7sq)**5 + m7**8/(m2sq - m7sq)**5 + (4*m2sq*m7**4)/(m2sq - m7sq)**4 + (3*m1**4*m7sq)/(m1sq - m7sq)**4 + (13*m1sq*m2**4*m7sq)/(m2sq - m7sq)**5 - (19*m2**6*m7sq)/(m2sq - m7sq)**5 + (4*m2**4*m7sq)/(m2sq - m7sq)**4 + (2*m7sq*(m2sq + m7sq)*(-3*m2**4 + m1sq*(2*m2sq + m7sq))*B0del(0,0,m2sq,mudim))/(m2sq - m7sq)**5 - (2*(m1sq - m2sq)*m7sq*(3*m2sq*m7**8*(m2sq + m7sq) - m1**6*(m2**6 + 11*m2sq*m7**4 + 4*m7**6 + 8*m2**4*m7sq) - m1sq*m7sq*(m2**8 + 22*m2**4*m7**4 + m2sq*m7**6 + 5*m7**8 - 5*m2**6*m7sq) + m1**4*(-m2**8 + 13*m2**4*m7**4 + 14*m2sq*m7**6 + 6*m7**8 + 4*m2**6*m7sq) + m1**8*(2*m2**4 + m7**4 + 3*m2sq*m7sq))*B0del(0,0,m7sq,mudim))/((m1sq - m7sq)**4*(-m2sq + m7sq)**5) - (2*m1**6*B0fin(0,0,m1sq,mudim))/(m1sq - m7sq)**4 + (6*m1**4*m7sq*B0fin(0,0,m1sq,mudim))/(m1sq - m7sq)**4 - (2*m1sq*m2**6*B0fin(0,0,m2sq,mudim))/(m2sq - m7sq)**5 + (4*m2**8*B0fin(0,0,m2sq,mudim))/(m2sq - m7sq)**5 - (10*m2**4*m7**4*B0fin(0,0,m2sq,mudim))/(m2sq - m7sq)**5 + (16*m1sq*m2sq*m7**4*B0fin(0,0,m2sq,mudim))/(m2sq - m7sq)**5 - (2*m2sq*m7**4*B0fin(0,0,m2sq,mudim))/(m2sq - m7sq)**4 - (6*m2**6*m7sq*B0fin(0,0,m2sq,mudim))/(m2sq - m7sq)**5 - (2*m2**4*m7sq*B0fin(0,0,m2sq,mudim))/(m2sq - m7sq)**4 + (2*m1sq*m7**6*B0fin(0,0,m2sq,mudim))/(-m2sq + m7sq)**5 + (6*m1sq*m7**4*B0fin(0,0,m7sq,mudim))/(m1sq - m7sq)**4 - (2*m7**6*B0fin(0,0,m7sq,mudim))/(m1sq - m7sq)**4 - (20*m2**4*m7**4*B0fin(0,0,m7sq,mudim))/(m2sq - m7sq)**5 + (14*m1sq*m2sq*m7**4*B0fin(0,0,m7sq,mudim))/(m2sq - m7sq)**5 + (10*m2sq*m7**6*B0fin(0,0,m7sq,mudim))/(m2sq - m7sq)**5 - (2*m2sq*m7**4*B0fin(0,0,m7sq,mudim))/(m2sq - m7sq)**4 + (2*m1sq*m2**4*m7sq*B0fin(0,0,m7sq,mudim))/(m2sq - m7sq)**5 - (2*m2**4*m7sq*B0fin(0,0,m7sq,mudim))/(m2sq - m7sq)**4 + (4*m1sq*m7**6*B0fin(0,0,m7sq,mudim))/(-m2sq + m7sq)**5 + (2*m7**8*B0fin(0,0,m7sq,mudim))/(-m2sq + m7sq)**5 + (2*m1sq*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/(m1sq - m7sq)**4 + (2*m1**4*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/(m1sq - m7sq)**4 - (6*m2**4*m7**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/(m2sq - m7sq)**5 + (6*m1sq*m2sq*m7**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/(m2sq - m7sq)**5 + (2*m1sq*m7**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/(m2sq - m7sq)**5 - (2*m2sq*m7**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/(m2sq - m7sq)**5 - (2*m2sq*m7**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/(m2sq - m7sq)**4 + (4*m1sq*m2**4*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/(m2sq - m7sq)**5 - (4*m2**6*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/(m2sq - m7sq)**5 - (2*m2**4*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/(m2sq - m7sq)**4 - (4*m1sq*m7sq*T134fin(m7,m1,0,mudim))/(m1sq - m7sq)**4 + (12*m2**4*m7sq*T134fin(m7,m2,0,mudim))/(m2sq - m7sq)**5 - (8*m1sq*m2sq*m7sq*T134fin(m7,m2,0,mudim))/(m2sq - m7sq)**5 + (4*m1sq*m7**4*T134fin(m7,m2,0,mudim))/(-m2sq + m7sq)**5)/2.)/(m1sq - m2sq)**2
		def eval_44():
			return (18*m1sq*m2**4*(m1sq + m2sq)*(m2sq - m3sq)**5*(B0del(0,0,m1sq,mudim) + 2*B0fin(0,0,m1sq,mudim)) - 3*(m2sq - m3sq)**4*((m1sq - m2sq)**4*(m1sq - m3sq) + 6*m1sq*m2**4*(m1sq + m2sq)*(m2sq - m3sq)*(2 + B0fin(0,0,m1sq,mudim)))*(1 - B0fin(0,0,m2sq,mudim)) + 18*m1sq*m2**4*(m1sq + m2sq)*(m2sq - m3sq)**5*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)) + (m1sq - m2sq)**4*(m1sq - m3sq)*(m2sq - m3sq)**4*(-8 + 3*B0fin(0,0,m2sq,mudim)) - 18*m2**4*(-m1sq + m2sq)**5*m3sq*(m2sq + m3sq)*(-2 + B0del(0,0,m2sq,mudim) + B0del(0,0,m3sq,mudim) + B0fin(0,0,m2sq,mudim) + B0fin(0,0,m3sq,mudim) + B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim)) + 9*m2sq*(m2sq - m3sq)**5*(2*(m1sq + m2sq)**3 - (m1sq - m2sq)**2*(m1sq + m2sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim)) - 4*m1sq*m2sq*T134fin(m2,m1,0,mudim)) + 9*(m1sq - m2sq)**5*m2sq*(2*(m2sq + m3sq)**3 - (m2sq - m3sq)**2*(m2sq + m3sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim)) - 4*m2sq*m3sq*T134fin(m3,m2,0,mudim)))/(18.*m2**2*(m1sq - m2sq)**5*(m1sq - m3sq)*(m2sq - m3sq)**5)
		def eval_45():
			return ((m7sq*(m1sq + m7sq)*(-3*m1**4 + 2*m1sq*m3sq + m3sq*m7sq)*B0del(0,0,m1sq,mudim))/(m1sq - m7sq)**5 + (-((m1**6*m3sq)/(m1sq - m7sq)**5) - (5*m1**4*m7**4)/(m1sq - m7sq)**5 + (5*m1sq*m3sq*m7**4)/(m1sq - m7sq)**5 - (m1sq*m7**6)/(m1sq - m7sq)**5 + (7*m3sq*m7**6)/(m1sq - m7sq)**5 + m7**8/(m1sq - m7sq)**5 + (4*m1sq*m7**4)/(m1sq - m7sq)**4 + m3**6/(m3sq - m7sq)**4 + (3*m3sq*m7**4)/(m3sq - m7sq)**4 + m7**6/(m3sq - m7sq)**4 - (19*m1**6*m7sq)/(m1sq - m7sq)**5 + (13*m1**4*m3sq*m7sq)/(m1sq - m7sq)**5 + (4*m1**4*m7sq)/(m1sq - m7sq)**4 + (3*m3**4*m7sq)/(m3sq - m7sq)**4 + (2*m3sq*m7sq*(m3sq + m7sq)*B0del(0,0,m3sq,mudim))/(m3sq - m7sq)**4 + (2*(m1sq - m3sq)*m7sq*(m1**8*m3sq*(m3sq + m7sq) + m1**6*(m3**6 - 5*m3sq*m7**4 - 4*m3**4*m7sq) - m3sq*m7**4*(m3**6 + 6*m3sq*m7**4 - 5*m7**6 - 4*m3**4*m7sq) + m1**4*(-2*m3**8 - 13*m3**4*m7**4 + 22*m3sq*m7**6 - 3*m7**8 + 8*m3**6*m7sq) + m1sq*(11*m3**6*m7**4 - 14*m3**4*m7**6 + m3sq*m7**8 - 3*m7**10 - 3*m3**8*m7sq))*B0del(0,0,m7sq,mudim))/((m1sq - m7sq)**5*(m3sq - m7sq)**4) + (4*m1**8*B0fin(0,0,m1sq,mudim))/(m1sq - m7sq)**5 - (2*m1**6*m3sq*B0fin(0,0,m1sq,mudim))/(m1sq - m7sq)**5 - (10*m1**4*m7**4*B0fin(0,0,m1sq,mudim))/(m1sq - m7sq)**5 + (16*m1sq*m3sq*m7**4*B0fin(0,0,m1sq,mudim))/(m1sq - m7sq)**5 - (2*m1sq*m7**4*B0fin(0,0,m1sq,mudim))/(m1sq - m7sq)**4 - (6*m1**6*m7sq*B0fin(0,0,m1sq,mudim))/(m1sq - m7sq)**5 - (2*m1**4*m7sq*B0fin(0,0,m1sq,mudim))/(m1sq - m7sq)**4 + (2*m3sq*m7**6*B0fin(0,0,m1sq,mudim))/(-m1sq + m7sq)**5 - (2*m3**6*B0fin(0,0,m3sq,mudim))/(m3sq - m7sq)**4 + (6*m3**4*m7sq*B0fin(0,0,m3sq,mudim))/(m3sq - m7sq)**4 - (20*m1**4*m7**4*B0fin(0,0,m7sq,mudim))/(m1sq - m7sq)**5 + (14*m1sq*m3sq*m7**4*B0fin(0,0,m7sq,mudim))/(m1sq - m7sq)**5 + (10*m1sq*m7**6*B0fin(0,0,m7sq,mudim))/(m1sq - m7sq)**5 - (2*m1sq*m7**4*B0fin(0,0,m7sq,mudim))/(m1sq - m7sq)**4 + (6*m3sq*m7**4*B0fin(0,0,m7sq,mudim))/(m3sq - m7sq)**4 - (2*m7**6*B0fin(0,0,m7sq,mudim))/(m3sq - m7sq)**4 + (2*m1**4*m3sq*m7sq*B0fin(0,0,m7sq,mudim))/(m1sq - m7sq)**5 - (2*m1**4*m7sq*B0fin(0,0,m7sq,mudim))/(m1sq - m7sq)**4 + (4*m3sq*m7**6*B0fin(0,0,m7sq,mudim))/(-m1sq + m7sq)**5 + (2*m7**8*B0fin(0,0,m7sq,mudim))/(-m1sq + m7sq)**5 - (6*m1**4*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/(m1sq - m7sq)**5 + (6*m1sq*m3sq*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/(m1sq - m7sq)**5 - (2*m1sq*m7**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/(m1sq - m7sq)**5 + (2*m3sq*m7**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/(m1sq - m7sq)**5 - (2*m1sq*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/(m1sq - m7sq)**4 - (4*m1**6*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/(m1sq - m7sq)**5 + (4*m1**4*m3sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/(m1sq - m7sq)**5 - (2*m1**4*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/(m1sq - m7sq)**4 + (2*m3sq*m7**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim))/(m3sq - m7sq)**4 + (2*m3**4*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim))/(m3sq - m7sq)**4 + (12*m1**4*m7sq*T134fin(m7,m1,0,mudim))/(m1sq - m7sq)**5 - (8*m1sq*m3sq*m7sq*T134fin(m7,m1,0,mudim))/(m1sq - m7sq)**5 + (4*m3sq*m7**4*T134fin(m7,m1,0,mudim))/(-m1sq + m7sq)**5 - (4*m3sq*m7sq*T134fin(m7,m3,0,mudim))/(m3sq - m7sq)**4)/2.)/(m1sq - m3sq)**2
		def eval_46():
			return ((11 - 6*B0fin(0,0,m1sq,mudim))/(m1**2*(m1sq - m2sq)*(m1sq - m3sq)) - (18*m1sq*m2sq*(m1sq + m2sq)*(-2 + B0del(0,0,m1sq,mudim) + B0del(0,0,m2sq,mudim) + B0fin(0,0,m1sq,mudim) + B0fin(0,0,m2sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim)))/((m1sq - m2sq)**5*(m2sq - m3sq)) - (18*m1sq*m3sq*(m1sq + m3sq)*(-2 + B0del(0,0,m1sq,mudim) + B0del(0,0,m3sq,mudim) + B0fin(0,0,m1sq,mudim) + B0fin(0,0,m3sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim)))/((m1sq - m3sq)**5*(-m2sq + m3sq)) - (9*(m1**6 + 7*m1sq*m2**4 + m2**6 + 7*m1**4*m2sq - 2*(m1**3 - m1*m2sq)**2*B0fin(0,0,m1sq,mudim) - 2*(-(m1sq*m2) + m2**3)**2*B0fin(0,0,m2sq,mudim) - 4*m1sq*m2sq*T134fin(m2,m1,0,mudim)))/((m1sq - m2sq)**5*(m2sq - m3sq)) - (9*(m1**6 + 7*m1sq*m3**4 + m3**6 + 7*m1**4*m3sq - 2*(m1**3 - m1*m3sq)**2*B0fin(0,0,m1sq,mudim) - 2*(-(m1sq*m3) + m3**3)**2*B0fin(0,0,m3sq,mudim) - 4*m1sq*m3sq*T134fin(m3,m1,0,mudim)))/((m1sq - m3sq)**5*(-m2sq + m3sq)))/18.
		def eval_47():
			return (m4**4*(m5sq - m6sq)*(m5sq - m7sq)**4*(m6sq - m7sq)**4*(m4sq + m7sq) + (m5sq - m6sq)*m7**4*(m5sq - m7sq)**4*(m6sq - m7sq)**4*(m4sq + m7sq) - m5**4*(m4sq - m6sq)*(m4sq - m7sq)**4*(m6sq - m7sq)**4*(m5sq + m7sq) - (m4sq - m6sq)*m7**4*(m4sq - m7sq)**4*(m6sq - m7sq)**4*(m5sq + m7sq) + (m4sq - m5sq)*m6**4*(m4sq - m7sq)**4*(m5sq - m7sq)**4*(m6sq + m7sq) + (m4sq - m5sq)*m7**4*(m4sq - m7sq)**4*(m5sq - m7sq)**4*(m6sq + m7sq) + m4sq*(m5sq - m6sq)*(m5sq - m7sq)**4*(m6sq - m7sq)**4*m7sq*(m4sq + m7sq)*B0del(0,0,m4sq,mudim) - m5sq*(m4sq - m6sq)*(m4sq - m7sq)**4*(m6sq - m7sq)**4*m7sq*(m5sq + m7sq)*B0del(0,0,m5sq,mudim) + (m4sq - m5sq)*m6sq*(m4sq - m7sq)**4*(m5sq - m7sq)**4*m7sq*(m6sq + m7sq)*B0del(0,0,m6sq,mudim) + m4sq*(m5sq - m6sq)*(m5sq - m7sq)**4*(m6sq - m7sq)**4*m7sq*(m4sq + m7sq)*B0fin(0,0,m4sq,mudim) - m5sq*(m4sq - m6sq)*(m4sq - m7sq)**4*(m6sq - m7sq)**4*m7sq*(m5sq + m7sq)*B0fin(0,0,m5sq,mudim) + (m4sq - m5sq)*m6sq*(m4sq - m7sq)**4*(m5sq - m7sq)**4*m7sq*(m6sq + m7sq)*B0fin(0,0,m6sq,mudim) + m4sq*(m5sq - m6sq)*(m5sq - m7sq)**4*(m6sq - m7sq)**4*m7sq*(m4sq + m7sq)*(B0del(0,0,m7sq,mudim) - B0fin(0,0,m7sq,mudim)) - m5sq*(m4sq - m6sq)*(m4sq - m7sq)**4*(m6sq - m7sq)**4*m7sq*(m5sq + m7sq)*(B0del(0,0,m7sq,mudim) - B0fin(0,0,m7sq,mudim)) + (m4sq - m5sq)*m6sq*(m4sq - m7sq)**4*(m5sq - m7sq)**4*m7sq*(m6sq + m7sq)*(B0del(0,0,m7sq,mudim) - B0fin(0,0,m7sq,mudim)) + 2*m4sq*(m5sq - m6sq)*(m5sq - m7sq)**4*(m6sq - m7sq)**4*m7sq*(m4sq + m7sq)*B0fin(0,0,m7sq,mudim) - 2*m5sq*(m4sq - m6sq)*(m4sq - m7sq)**4*(m6sq - m7sq)**4*m7sq*(m5sq + m7sq)*B0fin(0,0,m7sq,mudim) + 2*(m4sq - m5sq)*m6sq*(m4sq - m7sq)**4*(m5sq - m7sq)**4*m7sq*(m6sq + m7sq)*B0fin(0,0,m7sq,mudim) + m4sq*(m5sq - m6sq)*(m5sq - m7sq)**4*(m6sq - m7sq)**4*m7sq*(m4sq + m7sq)*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) - m5sq*(m4sq - m6sq)*(m4sq - m7sq)**4*(m6sq - m7sq)**4*m7sq*(m5sq + m7sq)*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim) + (m4sq - m5sq)*m6sq*(m4sq - m7sq)**4*(m5sq - m7sq)**4*m7sq*(m6sq + m7sq)*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim) - (m4**4*(m5sq - m6sq)*(m5sq - m7sq)**4*(m6sq - m7sq)**4*(m4sq + m7sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/2. - ((m5sq - m6sq)*m7**4*(m5sq - m7sq)**4*(m6sq - m7sq)**4*(m4sq + m7sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/2. + m4sq*(m5sq - m6sq)*(m5sq - m7sq)**4*(m6sq - m7sq)**4*m7sq*(m4sq + m7sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)) + (m5**4*(m4sq - m6sq)*(m4sq - m7sq)**4*(m6sq - m7sq)**4*(m5sq + m7sq + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/2. + ((m4sq - m6sq)*m7**4*(m4sq - m7sq)**4*(m6sq - m7sq)**4*(m5sq + m7sq + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/2. - m5sq*(m4sq - m6sq)*(m4sq - m7sq)**4*(m6sq - m7sq)**4*m7sq*(m5sq + m7sq + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)) - ((m4sq - m5sq)*m6**4*(m4sq - m7sq)**4*(m5sq - m7sq)**4*(m6sq + m7sq + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/2. - ((m4sq - m5sq)*m7**4*(m4sq - m7sq)**4*(m5sq - m7sq)**4*(m6sq + m7sq + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/2. + (m4sq - m5sq)*m6sq*(m4sq - m7sq)**4*(m5sq - m7sq)**4*m7sq*(m6sq + m7sq + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)) - 2*m4sq*(m5sq - m6sq)*(m5sq - m7sq)**4*(m6sq - m7sq)**4*m7sq*T134fin(m7,m4,0,mudim) + 2*m5sq*(m4sq - m6sq)*(m4sq - m7sq)**4*(m6sq - m7sq)**4*m7sq*T134fin(m7,m5,0,mudim) - 2*(m4sq - m5sq)*m6sq*(m4sq - m7sq)**4*(m5sq - m7sq)**4*m7sq*T134fin(m7,m6,0,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(m5sq - m6sq)*(m4sq - m7sq)**4*(m5sq - m7sq)**4*(m6sq - m7sq)**4)
		def eval_48():
			return (m1**4*(m2sq - m3sq)*(m2sq - m7sq)**4*(m3sq - m7sq)**4*(m1sq + m7sq) + (m2sq - m3sq)*m7**4*(m2sq - m7sq)**4*(m3sq - m7sq)**4*(m1sq + m7sq) - m2**4*(m1sq - m3sq)*(m1sq - m7sq)**4*(m3sq - m7sq)**4*(m2sq + m7sq) - (m1sq - m3sq)*m7**4*(m1sq - m7sq)**4*(m3sq - m7sq)**4*(m2sq + m7sq) + (m1sq - m2sq)*m3**4*(m1sq - m7sq)**4*(m2sq - m7sq)**4*(m3sq + m7sq) + (m1sq - m2sq)*m7**4*(m1sq - m7sq)**4*(m2sq - m7sq)**4*(m3sq + m7sq) + m1sq*(m2sq - m3sq)*(m2sq - m7sq)**4*(m3sq - m7sq)**4*m7sq*(m1sq + m7sq)*B0del(0,0,m1sq,mudim) - m2sq*(m1sq - m3sq)*(m1sq - m7sq)**4*(m3sq - m7sq)**4*m7sq*(m2sq + m7sq)*B0del(0,0,m2sq,mudim) + (m1sq - m2sq)*m3sq*(m1sq - m7sq)**4*(m2sq - m7sq)**4*m7sq*(m3sq + m7sq)*B0del(0,0,m3sq,mudim) + m1sq*(m2sq - m3sq)*(m2sq - m7sq)**4*(m3sq - m7sq)**4*m7sq*(m1sq + m7sq)*B0fin(0,0,m1sq,mudim) - m2sq*(m1sq - m3sq)*(m1sq - m7sq)**4*(m3sq - m7sq)**4*m7sq*(m2sq + m7sq)*B0fin(0,0,m2sq,mudim) + (m1sq - m2sq)*m3sq*(m1sq - m7sq)**4*(m2sq - m7sq)**4*m7sq*(m3sq + m7sq)*B0fin(0,0,m3sq,mudim) + m1sq*(m2sq - m3sq)*(m2sq - m7sq)**4*(m3sq - m7sq)**4*m7sq*(m1sq + m7sq)*(B0del(0,0,m7sq,mudim) - B0fin(0,0,m7sq,mudim)) - m2sq*(m1sq - m3sq)*(m1sq - m7sq)**4*(m3sq - m7sq)**4*m7sq*(m2sq + m7sq)*(B0del(0,0,m7sq,mudim) - B0fin(0,0,m7sq,mudim)) + (m1sq - m2sq)*m3sq*(m1sq - m7sq)**4*(m2sq - m7sq)**4*m7sq*(m3sq + m7sq)*(B0del(0,0,m7sq,mudim) - B0fin(0,0,m7sq,mudim)) + 2*m1sq*(m2sq - m3sq)*(m2sq - m7sq)**4*(m3sq - m7sq)**4*m7sq*(m1sq + m7sq)*B0fin(0,0,m7sq,mudim) - 2*m2sq*(m1sq - m3sq)*(m1sq - m7sq)**4*(m3sq - m7sq)**4*m7sq*(m2sq + m7sq)*B0fin(0,0,m7sq,mudim) + 2*(m1sq - m2sq)*m3sq*(m1sq - m7sq)**4*(m2sq - m7sq)**4*m7sq*(m3sq + m7sq)*B0fin(0,0,m7sq,mudim) + m1sq*(m2sq - m3sq)*(m2sq - m7sq)**4*(m3sq - m7sq)**4*m7sq*(m1sq + m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - m2sq*(m1sq - m3sq)*(m1sq - m7sq)**4*(m3sq - m7sq)**4*m7sq*(m2sq + m7sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) + (m1sq - m2sq)*m3sq*(m1sq - m7sq)**4*(m2sq - m7sq)**4*m7sq*(m3sq + m7sq)*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim) - (m1**4*(m2sq - m3sq)*(m2sq - m7sq)**4*(m3sq - m7sq)**4*(m1sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/2. - ((m2sq - m3sq)*m7**4*(m2sq - m7sq)**4*(m3sq - m7sq)**4*(m1sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/2. + m1sq*(m2sq - m3sq)*(m2sq - m7sq)**4*(m3sq - m7sq)**4*m7sq*(m1sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)) + (m2**4*(m1sq - m3sq)*(m1sq - m7sq)**4*(m3sq - m7sq)**4*(m2sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/2. + ((m1sq - m3sq)*m7**4*(m1sq - m7sq)**4*(m3sq - m7sq)**4*(m2sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/2. - m2sq*(m1sq - m3sq)*(m1sq - m7sq)**4*(m3sq - m7sq)**4*m7sq*(m2sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)) - ((m1sq - m2sq)*m3**4*(m1sq - m7sq)**4*(m2sq - m7sq)**4*(m3sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/2. - ((m1sq - m2sq)*m7**4*(m1sq - m7sq)**4*(m2sq - m7sq)**4*(m3sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/2. + (m1sq - m2sq)*m3sq*(m1sq - m7sq)**4*(m2sq - m7sq)**4*m7sq*(m3sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)) - 2*m1sq*(m2sq - m3sq)*(m2sq - m7sq)**4*(m3sq - m7sq)**4*m7sq*T134fin(m7,m1,0,mudim) + 2*m2sq*(m1sq - m3sq)*(m1sq - m7sq)**4*(m3sq - m7sq)**4*m7sq*T134fin(m7,m2,0,mudim) - 2*(m1sq - m2sq)*m3sq*(m1sq - m7sq)**4*(m2sq - m7sq)**4*m7sq*T134fin(m7,m3,0,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m2sq - m3sq)*(m1sq - m7sq)**4*(m2sq - m7sq)**4*(m3sq - m7sq)**4)
		def eval_49():
			return -0.1111111111111111*(24*m2sq + 24*m2sq*B0del(0,0,m2sq,mudim) + 24*m2sq*B0fin(0,0,m2sq,mudim) + 12*m2sq*B0fin(0,0,m2sq,mudim)**2 - 9*T134fin(m2,0,0,mudim) - 5*T134fin(m2,m2,m2,mudim))/m2**8
		def eval_50():
			return -0.03125*(8 + B0del(0,0,m1sq,mudim))/m1**6
		def eval_51():
			return (-7*m3**8 + 32*m3**4*m4**4 - 216*m3sq*m4**6 + 144*m4**8 + 38*m3**6*m4sq + 72*m3sq*m4**6*B0del(0,0,m3sq,mudim) + 144*m4**8*B0del(0,0,m4sq,mudim) + 108*m3**4*m4**4*B0fin(0,0,m3sq,mudim) - 72*m3sq*m4**6*B0fin(0,0,m3sq,mudim) - 18*m3**6*m4sq*B0fin(0,0,m3sq,mudim) + 12*m3**8*B0fin(0,0,m4sq,mudim) + 84*m3**4*m4**4*B0fin(0,0,m4sq,mudim) + 144*m3sq*m4**6*B0fin(0,0,m4sq,mudim) + 144*m4**8*B0fin(0,0,m4sq,mudim) - 78*m3**6*m4sq*B0fin(0,0,m4sq,mudim) + 72*m3sq*m4**6*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) - 36*m3sq*m4**6*B0fin(0,0,m4sq,mudim)**2 + 72*m4**8*B0fin(0,0,m4sq,mudim)**2 - 72*m4**6*T134fin(m4,m4,m3,mudim))/(36.*m3**6*m4**4*(m3sq - 4*m4sq)**2)
		def eval_52():
			return (-2*m1sq*m2**4 + 2*m2**6 + 4*m1**4*m2sq + 2*m1sq*m2**4*B0del(0,0,m1sq,mudim) + 2*m1**4*m2sq*B0del(0,0,m2sq,mudim) + 2*m1sq*m2**4*B0fin(0,0,m1sq,mudim) + 2*m1**4*m2sq*B0fin(0,0,m2sq,mudim) + 2*m1sq*m2**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - m1sq*m2**4*B0fin(0,0,m2sq,mudim)**2 + m1**4*m2sq*B0fin(0,0,m2sq,mudim)**2 - 2*m2**4*T134fin(m1,0,0,mudim) + 2*m1sq*m2sq*T134fin(m1,0,0,mudim) - 2*m1**4*T134fin(m2,0,0,mudim) + 2*m1sq*m2sq*T134fin(m2,0,0,mudim) - 2*m1sq*m2sq*T134fin(m2,m1,0,mudim))/(2.*m2**6*(m1sq - m2sq)**3)
		def eval_53():
			return -0.5*(2*m1sq*m3**4 + 2*m1**4*m3sq + 2*m1sq*m3**4*B0del(0,0,m1sq,mudim) + 2*m1**4*m3sq*B0del(0,0,m3sq,mudim) + 4*m1sq*m3**4*B0fin(0,0,m1sq,mudim) - 2*m1**4*m3sq*B0fin(0,0,m1sq,mudim) - 2*m1sq*m3**4*B0fin(0,0,m3sq,mudim) + 4*m1**4*m3sq*B0fin(0,0,m3sq,mudim) + 2*m1sq*m3**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - m1sq*m3**4*B0fin(0,0,m3sq,mudim)**2 + m1**4*m3sq*B0fin(0,0,m3sq,mudim)**2 - 2*m3**4*T134fin(m1,0,0,mudim) + 2*m1sq*m3sq*T134fin(m1,0,0,mudim) - 2*m1**4*T134fin(m3,0,0,mudim) + 2*m1sq*m3sq*T134fin(m3,0,0,mudim) - 2*m1sq*m3sq*T134fin(m3,m1,0,mudim))/(m1**2*(m1 - m3)**3*m3**4*(m1 + m3)**3)
		def eval_54():
			return (2*m1sq*m2**4 + 2*m1**4*m2sq + 2*m1sq*m2**4*B0del(0,0,m1sq,mudim) + 2*m1**4*m2sq*B0del(0,0,m2sq,mudim) + 2*m1sq*m2**4*B0fin(0,0,m1sq,mudim) + 2*m1sq*m2**4*B0fin(0,0,m1sq,mudim)**2 + 2*m1**4*m2sq*B0fin(0,0,m2sq,mudim) - 2*m1sq*m2**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + m1sq*m2**4*B0fin(0,0,m2sq,mudim)**2 + m1**4*m2sq*B0fin(0,0,m2sq,mudim)**2 - 2*m2**4*T134fin(m1,0,0,mudim) + 2*m1sq*m2sq*T134fin(m1,0,0,mudim) - 2*m1**4*T134fin(m2,0,0,mudim) + 2*m1sq*m2sq*T134fin(m2,0,0,mudim) - 2*m1sq*m2sq*T134fin(m2,m1,0,mudim))/(2.*m1**2*m2**4*(m1sq - m2sq)**3)
		def eval_55():
			return (2*m1sq*m2**4 + 2*m1**4*m2sq + 2*m1sq*m2**4*B0del(0,0,m1sq,mudim) + 2*m1**4*m2sq*B0del(0,0,m2sq,mudim) + 4*m1sq*m2**4*B0fin(0,0,m1sq,mudim) - 2*m1**4*m2sq*B0fin(0,0,m1sq,mudim) + m1sq*m2**4*B0fin(0,0,m1sq,mudim)**2 - m1**4*m2sq*B0fin(0,0,m1sq,mudim)**2 - 2*m1sq*m2**4*B0fin(0,0,m2sq,mudim) + 4*m1**4*m2sq*B0fin(0,0,m2sq,mudim) + 2*m1**4*m2sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 2*m2**4*T134fin(m1,0,0,mudim) + 2*m1sq*m2sq*T134fin(m1,0,0,mudim) - 2*m1**4*T134fin(m2,0,0,mudim) + 2*m1sq*m2sq*T134fin(m2,0,0,mudim) - 2*m1sq*m2sq*T134fin(m2,m1,0,mudim))/(2.*m1**4*(m1 - m2)**3*m2**2*(m1 + m2)**3)
		def eval_56():
			return (144*m1**8 + 32*m1**4*m6**4 + 38*m1sq*m6**6 - 7*m6**8 - 216*m1**6*m6sq + 144*m1**8*B0del(0,0,m1sq,mudim) + 72*m1**6*m6sq*B0del(0,0,m6sq,mudim) + 144*m1**8*B0fin(0,0,m1sq,mudim) + 84*m1**4*m6**4*B0fin(0,0,m1sq,mudim) - 78*m1sq*m6**6*B0fin(0,0,m1sq,mudim) + 12*m6**8*B0fin(0,0,m1sq,mudim) + 144*m1**6*m6sq*B0fin(0,0,m1sq,mudim) + 72*m1**8*B0fin(0,0,m1sq,mudim)**2 - 36*m1**6*m6sq*B0fin(0,0,m1sq,mudim)**2 + 108*m1**4*m6**4*B0fin(0,0,m6sq,mudim) - 18*m1sq*m6**6*B0fin(0,0,m6sq,mudim) - 72*m1**6*m6sq*B0fin(0,0,m6sq,mudim) + 72*m1**6*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 72*m1**6*T134fin(m6,m1,m1,mudim))/(36.*m1**4*m6**6*(-4*m1sq + m6sq)**2)
		def eval_57():
			return (m1sq - m6sq + m1sq*B0fin(0,0,m1sq,mudim) - m1sq*B0fin(0,0,m6sq,mudim))/(2.*m1**4*(m1 - m6)**2*(m1 + m6)**2)
		def eval_58():
			return -0.5*(2*m1**6 + 4*m1sq*m3**4 - 2*m1**4*m3sq + 2*m1sq*m3**4*B0del(0,0,m1sq,mudim) + 2*m1**4*m3sq*B0del(0,0,m3sq,mudim) + 2*m1sq*m3**4*B0fin(0,0,m1sq,mudim) + m1sq*m3**4*B0fin(0,0,m1sq,mudim)**2 - m1**4*m3sq*B0fin(0,0,m1sq,mudim)**2 + 2*m1**4*m3sq*B0fin(0,0,m3sq,mudim) + 2*m1**4*m3sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 2*m3**4*T134fin(m1,0,0,mudim) + 2*m1sq*m3sq*T134fin(m1,0,0,mudim) - 2*m1**4*T134fin(m3,0,0,mudim) + 2*m1sq*m3sq*T134fin(m3,0,0,mudim) - 2*m1sq*m3sq*T134fin(m3,m1,0,mudim))/(m1**6*(m1sq - m3sq)**3)
		def eval_59():
			return ((4*m3sq*(m3sq - m5sq)*B0del(0,0,m3sq,mudim))/((m3sq - 4*m5sq)*(-m4sq + m5sq)) - (2*(m3**6 + 8*m3sq*m5**4 + m3**4*(m4sq - 7*m5sq) + 2*m5**4*(m4sq - m5sq))*(B0del(0,0,m5sq,mudim) - B0fin(0,0,m5sq,mudim)))/((m3sq - 4*m5sq)*(m4sq - m5sq)**2) + (m3sq*(16*m5**4 - 4*m3sq*(m4sq + m5sq) + m5**4*(2 - (2*m3sq)/m5**2 + (2*m4sq)/m5**2 - (4*(m3sq - m5sq)*(-m4sq + m5sq))/(m3**4 - 4*m3sq*m5sq))*B0del(0,0,m5sq,mudim) + 2*(4*m5**4 + m3sq*(m4sq + m5sq))*B0fin(0,0,m5sq,mudim)))/(m5**2*(m4sq - m5sq)**2) - (2*(-1 + B0fin(0,0,m5sq,mudim))*(-(m3sq*(m3sq - 4*m5sq)*(4*m5**4 + m3sq*(m4sq + m5sq))) + 2*m3sq*(m3sq - m5sq)*(m4sq - m5sq)*m5sq*B0fin(0,0,m3sq,mudim) + m5sq*(m3**6 + 2*m5**4*(m4sq - m5sq) + 2*m3sq*m5sq*(m4sq + 3*m5sq) - m3**4*(m4sq + 5*m5sq))*B0fin(0,0,m5sq,mudim)))/((-(m4sq*m5) + m5**3)**2*(m3sq - 4*m5sq)) + (4*m5sq*(-(m3sq*(m4sq - m5sq)**3*B0del(0,0,m3sq,mudim)) - 2*m4sq*(m3**6 - 4*m3**4*m5sq)*B0del(0,0,m4sq,mudim) - m5sq*(-m4sq + m5sq)**3*B0del(0,0,m5sq,mudim) - (m3sq*(m4sq - m5sq)**3 + m5sq*(-m4sq + m5sq)**3 + 2*m4sq*(m3**6 - 4*m3**4*m5sq))*(B0del(0,0,m5sq,mudim) - B0fin(0,0,m5sq,mudim)) - (-1 + B0fin(0,0,m5sq,mudim))*(m3sq*(m4sq - m5sq)**3*B0fin(0,0,m3sq,mudim) + 2*m4sq*(m3**6 - 4*m3**4*m5sq)*B0fin(0,0,m4sq,mudim) + m5sq*(-m4sq + m5sq)**3*B0fin(0,0,m5sq,mudim))))/((m3sq - 4*m5sq)*(m4sq - m5sq)**4) + (4*m3sq*(-(m3sq*(m4sq + m5sq)*(m4sq + m5sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim))) + (-(m4sq - m5sq)**2 + m3sq*(m4sq + m5sq))*T134fin(m5,m4,0,mudim)))/(m4sq - m5sq)**4 + (4*m3sq*T134fin(m5,m4,m3,mudim))/(m4sq - m5sq)**2 - (4*m3sq*((m4sq - m5sq)*(m3sq + 2*m5sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 4*m5sq*B0fin(0,0,m5sq,mudim)) + (m3sq - m4sq - 3*m5sq)*T134fin(m5,m5,m3,mudim)))/((m3sq - 4*m5sq)*(m4sq - m5sq)**2))/(4.*m3**6)
		def eval_60():
			return (4*m3sq*(m4sq + m6sq)**2 + 2*(m4**4 + m6**4 + 2*m3sq*m6sq - 2*m4sq*m6sq)*(m4sq + m6sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)) + (m4sq - m6sq)**2*(6*m3sq - 4*m6sq + 2*(m3sq - 2*m6sq)*B0del(0,0,m6sq,mudim) - 2*(3*m3sq + 2*m6sq)*B0fin(0,0,m6sq,mudim) + (m3sq - 2*m6sq)*B0fin(0,0,m6sq,mudim)**2) + (2*m3sq*(m4sq - m6sq)*((m3sq - m6sq)*(m4sq - m6sq)**2*B0del(0,0,m3sq,mudim) + m6sq*(-m4**4 + m6**4 - m3sq*m6sq + 4*m4sq*m6sq)*B0del(0,0,m6sq,mudim) + m4sq*(6*m6**4 + m3sq*(m4sq - 2*m6sq) - 2*m4sq*m6sq)*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)) + (-1 + B0fin(0,0,m4sq,mudim))*((m3sq - m6sq)*(m4sq - m6sq)**2*B0fin(0,0,m3sq,mudim) + m6sq*(-m4**4 + m6**4 - m3sq*m6sq + 4*m4sq*m6sq)*B0fin(0,0,m6sq,mudim))))/(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq)) + (2*m3sq*(m4sq*(m4sq - m6sq)**3*((m4sq - 2*m6sq)*B0fin(0,0,m3sq,mudim) + m4sq*B0fin(0,0,m4sq,mudim) - 2*m6sq*B0fin(0,0,m6sq,mudim)) + m4sq*m6sq*(-4*m4sq*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq)) - (m4**6 + 3*m4sq*m6**4 + m6**6 - 5*m4**4*m6sq + m3**4*(3*m4sq + m6sq) - m3sq*(5*m4**4 + 2*m6**4 + 9*m4sq*m6sq))*B0fin(0,0,m4sq,mudim) - (m4**6 + 3*m4sq*m6**4 + m6**6 - 5*m4**4*m6sq + m3**4*(3*m4sq + m6sq) - m3sq*(5*m4**4 + 2*m6**4 + 9*m4sq*m6sq))*B0fin(0,0,m6sq,mudim)) - m6sq*(m4sq*(-m4**6 - 3*m4sq*m6**4 - m6**6 + 5*m4**4*m6sq - m3**4*(3*m4sq + m6sq) + m3sq*(5*m4**4 + 2*m6**4 + 9*m4sq*m6sq))*B0del(0,0,m4sq,mudim) + m4sq*(-m4**6 - 3*m4sq*m6**4 - m6**6 + 5*m4**4*m6sq - m3**4*(3*m4sq + m6sq) + m3sq*(5*m4**4 + 2*m6**4 + 9*m4sq*m6sq))*B0del(0,0,m6sq,mudim) - 4*m4**4*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*B0fin(0,0,m4sq,mudim) + (-4*m4**4*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq)) - m4sq*(m4**6 + 3*m4sq*m6**4 + m6**6 - 5*m4**4*m6sq + m3**4*(3*m4sq + m6sq) - m3sq*(5*m4**4 + 2*m6**4 + 9*m4sq*m6sq))*B0fin(0,0,m4sq,mudim))*B0fin(0,0,m6sq,mudim)) - m4sq*(m4sq - m6sq)**3*((m4sq - 2*m6sq)*B0del(0,0,m3sq,mudim) + m4sq*B0del(0,0,m4sq,mudim) - 2*m6sq*B0del(0,0,m6sq,mudim) + B0fin(0,0,m3sq,mudim)*(m4sq*B0fin(0,0,m4sq,mudim) - 2*m6sq*B0fin(0,0,m6sq,mudim)))))/(m4**2*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) - 2*m3sq*(m4sq + 3*m6sq)*T134fin(m6,m4,0,mudim) + (2*(m4sq - m6sq)**2*(2*(m4sq - m6sq)*(m3sq - m4sq + m6sq)*((m3sq + m4sq + m6sq)/2. + m3sq*B0fin(0,0,m3sq,mudim) + m4sq*B0fin(0,0,m4sq,mudim) + m6sq*B0fin(0,0,m6sq,mudim)) - m3sq*(m3sq - m4sq - 3*m6sq)*T134fin(m6,m4,m3,mudim)))/(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq)) + 2*(m4sq - m6sq)**2*T134fin(m6,m6,m3,mudim))/(2.*m3**4*(m4sq - m6sq)**4)
		def eval_61():
			return (4*m3sq*(m4sq + m5sq)**2 + (m4sq - m5sq)**2*(6*m3sq - 4*m4sq + 2*(m3sq - 2*m4sq)*B0del(0,0,m4sq,mudim) - 2*(3*m3sq + 2*m4sq)*B0fin(0,0,m4sq,mudim) + (m3sq - 2*m4sq)*B0fin(0,0,m4sq,mudim)**2) + (2*m3sq*(m4sq - m5sq)*(-((m3sq - m4sq)*(m4sq - m5sq)**2*B0del(0,0,m3sq,mudim)) + m4sq*(-m4**4 + m3sq*m4sq + m5**4 - 4*m4sq*m5sq)*B0del(0,0,m4sq,mudim) + m5sq*(-6*m4**4 + m3sq*(2*m4sq - m5sq) + 2*m4sq*m5sq)*(B0del(0,0,m5sq,mudim) - B0fin(0,0,m5sq,mudim)) + (-((m3sq - m4sq)*(m4sq - m5sq)**2*B0fin(0,0,m3sq,mudim)) + m4sq*(-m4**4 + m3sq*m4sq + m5**4 - 4*m4sq*m5sq)*B0fin(0,0,m4sq,mudim))*(-1 + B0fin(0,0,m5sq,mudim))))/(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq)) + 2*(2*m3sq*m4sq + (m4sq - m5sq)**2)*(m4sq + m5sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim)) + (2*m3sq*((-m4sq + m5sq)**3*((-2*m4sq + m5sq)*B0fin(0,0,m3sq,mudim) - 2*m4sq*B0fin(0,0,m4sq,mudim) + m5sq*B0fin(0,0,m5sq,mudim)) - m4sq*(4*m5sq*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq)) + (m4**6 - 5*m4sq*m5**4 + m5**6 + 3*m4**4*m5sq + m3**4*(m4sq + 3*m5sq) - m3sq*(2*m4**4 + 5*m5**4 + 9*m4sq*m5sq))*B0fin(0,0,m4sq,mudim) + (m4**6 - 5*m4sq*m5**4 + m5**6 + 3*m4**4*m5sq + m3**4*(m4sq + 3*m5sq) - m3sq*(2*m4**4 + 5*m5**4 + 9*m4sq*m5sq))*B0fin(0,0,m5sq,mudim)) + m4sq*((m4**6 - 5*m4sq*m5**4 + m5**6 + 3*m4**4*m5sq + m3**4*(m4sq + 3*m5sq) - m3sq*(2*m4**4 + 5*m5**4 + 9*m4sq*m5sq))*B0del(0,0,m4sq,mudim) + (m4**6 - 5*m4sq*m5**4 + m5**6 + 3*m4**4*m5sq + m3**4*(m4sq + 3*m5sq) - m3sq*(2*m4**4 + 5*m5**4 + 9*m4sq*m5sq))*B0del(0,0,m5sq,mudim) + 4*m5sq*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))*B0fin(0,0,m4sq,mudim) + (4*m5sq*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq)) + (m4**6 - 5*m4sq*m5**4 + m5**6 + 3*m4**4*m5sq + m3**4*(m4sq + 3*m5sq) - m3sq*(2*m4**4 + 5*m5**4 + 9*m4sq*m5sq))*B0fin(0,0,m4sq,mudim))*B0fin(0,0,m5sq,mudim)) + (-m4sq + m5sq)**3*((2*m4sq - m5sq)*B0del(0,0,m3sq,mudim) + 2*m4sq*B0del(0,0,m4sq,mudim) - m5sq*B0del(0,0,m5sq,mudim) + B0fin(0,0,m3sq,mudim)*(2*m4sq*B0fin(0,0,m4sq,mudim) - m5sq*B0fin(0,0,m5sq,mudim)))))/(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq)) + 2*(m4sq - m5sq)**2*T134fin(m4,m4,m3,mudim) - 2*m3sq*(3*m4sq + m5sq)*T134fin(m5,m4,0,mudim) - (2*(m4sq - m5sq)**2*((m4sq - m5sq)*(m3sq + m4sq - m5sq)*(m3sq + m4sq + m5sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim)) + m3sq*(m3sq - 3*m4sq - m5sq)*T134fin(m5,m4,m3,mudim)))/(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq)))/(2.*m3**4*(m4sq - m5sq)**4)
		def eval_62():
			return (m3**8*m4**6 - 4*m3**6*m4**8 + 6*m3**4*m4**10 - 4*m3sq*m4**12 + m4**14 + 32*m3**6*m4**4*m7**4 - 28*m3**4*m4**6*m7**4 - 36*m3sq*m4**8*m7**4 + 21*m4**10*m7**4 - m3**8*m4sq*m7**4 - m3**8*m7**6 - 52*m3**4*m4**4*m7**6 - 8*m3sq*m4**6*m7**6 - 35*m4**8*m7**6 + 8*m3**6*m4sq*m7**6 + 4*m3**6*m7**8 + 4*m3sq*m4**4*m7**8 + 35*m4**6*m7**8 - 10*m3**4*m4sq*m7**8 - 6*m3**4*m7**10 - 21*m4**4*m7**10 + 4*m3sq*m4sq*m7**10 + 4*m3sq*m7**12 + 7*m4sq*m7**12 - m7**14 - 7*m3**8*m4**4*m7sq + 24*m3**6*m4**6*m7sq - 38*m3**4*m4**8*m7sq + 36*m3sq*m4**10*m7sq - 7*m4**12*m7sq + 4*m3sq*m4sq*(m4sq - m7sq)**4*m7sq*B0del(0,0,m3sq,mudim) - 2*m4sq*m7sq*(-4*m3sq*(m4**4 - m7**4)**2 - (m4sq - m7sq)**5 + m3**8*(m4sq + m7sq) - 4*m3**6*(m4sq + m7sq)**2 + 2*m3**4*(3*m4**6 + 5*m4sq*m7**4 + 3*m7**6 + 5*m4**4*m7sq))*B0del(0,0,m4sq,mudim) + 16*m3**6*m4**4*m7**4*B0del(0,0,m7sq,mudim) - 20*m3**4*m4**6*m7**4*B0del(0,0,m7sq,mudim) + 10*m4**10*m7**4*B0del(0,0,m7sq,mudim) - 2*m3**8*m4sq*m7**4*B0del(0,0,m7sq,mudim) - 20*m3**4*m4**4*m7**6*B0del(0,0,m7sq,mudim) - 16*m3sq*m4**6*m7**6*B0del(0,0,m7sq,mudim) - 20*m4**8*m7**6*B0del(0,0,m7sq,mudim) + 8*m3**6*m4sq*m7**6*B0del(0,0,m7sq,mudim) + 20*m4**6*m7**8*B0del(0,0,m7sq,mudim) - 12*m3**4*m4sq*m7**8*B0del(0,0,m7sq,mudim) - 10*m4**4*m7**10*B0del(0,0,m7sq,mudim) + 8*m3sq*m4sq*m7**10*B0del(0,0,m7sq,mudim) + 2*m4sq*m7**12*B0del(0,0,m7sq,mudim) - 2*m3**8*m4**4*m7sq*B0del(0,0,m7sq,mudim) + 8*m3**6*m4**6*m7sq*B0del(0,0,m7sq,mudim) - 12*m3**4*m4**8*m7sq*B0del(0,0,m7sq,mudim) + 8*m3sq*m4**10*m7sq*B0del(0,0,m7sq,mudim) - 2*m4**12*m7sq*B0del(0,0,m7sq,mudim) - m3**6*m4**8*B0fin(0,0,m3sq,mudim) + 3*m3**4*m4**10*B0fin(0,0,m3sq,mudim) - 3*m3sq*m4**12*B0fin(0,0,m3sq,mudim) + m4**14*B0fin(0,0,m3sq,mudim) - 6*m3**6*m4**4*m7**4*B0fin(0,0,m3sq,mudim) + 6*m3**4*m4**6*m7**4*B0fin(0,0,m3sq,mudim) - 29*m3sq*m4**8*m7**4*B0fin(0,0,m3sq,mudim) + 9*m4**10*m7**4*B0fin(0,0,m3sq,mudim) + 6*m3**4*m4**4*m7**6*B0fin(0,0,m3sq,mudim) + 36*m3sq*m4**6*m7**6*B0fin(0,0,m3sq,mudim) - 5*m4**8*m7**6*B0fin(0,0,m3sq,mudim) + 4*m3**6*m4sq*m7**6*B0fin(0,0,m3sq,mudim) - m3**6*m7**8*B0fin(0,0,m3sq,mudim) - 29*m3sq*m4**4*m7**8*B0fin(0,0,m3sq,mudim) - 5*m4**6*m7**8*B0fin(0,0,m3sq,mudim) - 9*m3**4*m4sq*m7**8*B0fin(0,0,m3sq,mudim) + 3*m3**4*m7**10*B0fin(0,0,m3sq,mudim) + 9*m4**4*m7**10*B0fin(0,0,m3sq,mudim) + 14*m3sq*m4sq*m7**10*B0fin(0,0,m3sq,mudim) - 3*m3sq*m7**12*B0fin(0,0,m3sq,mudim) - 5*m4sq*m7**12*B0fin(0,0,m3sq,mudim) + m7**14*B0fin(0,0,m3sq,mudim) + 4*m3**6*m4**6*m7sq*B0fin(0,0,m3sq,mudim) - 9*m3**4*m4**8*m7sq*B0fin(0,0,m3sq,mudim) + 14*m3sq*m4**10*m7sq*B0fin(0,0,m3sq,mudim) - 5*m4**12*m7sq*B0fin(0,0,m3sq,mudim) + 2*m3**8*m4**6*B0fin(0,0,m4sq,mudim) - 7*m3**6*m4**8*B0fin(0,0,m4sq,mudim) + 9*m3**4*m4**10*B0fin(0,0,m4sq,mudim) - 5*m3sq*m4**12*B0fin(0,0,m4sq,mudim) + m4**14*B0fin(0,0,m4sq,mudim) + 31*m3**6*m4**4*m7**4*B0fin(0,0,m4sq,mudim) - 18*m3**4*m4**6*m7**4*B0fin(0,0,m4sq,mudim) + 10*m3sq*m4**8*m7**4*B0fin(0,0,m4sq,mudim) + 9*m4**10*m7**4*B0fin(0,0,m4sq,mudim) - 4*m3**8*m4sq*m7**4*B0fin(0,0,m4sq,mudim) + m3**8*m7**6*B0fin(0,0,m4sq,mudim) - 40*m3**4*m4**4*m7**6*B0fin(0,0,m4sq,mudim) - 46*m3sq*m4**6*m7**6*B0fin(0,0,m4sq,mudim) - 5*m4**8*m7**6*B0fin(0,0,m4sq,mudim) + 11*m3**6*m4sq*m7**6*B0fin(0,0,m4sq,mudim) - 4*m3**6*m7**8*B0fin(0,0,m4sq,mudim) + 15*m3sq*m4**4*m7**8*B0fin(0,0,m4sq,mudim) - 5*m4**6*m7**8*B0fin(0,0,m4sq,mudim) - 15*m3**4*m4sq*m7**8*B0fin(0,0,m4sq,mudim) + 6*m3**4*m7**10*B0fin(0,0,m4sq,mudim) + 9*m4**4*m7**10*B0fin(0,0,m4sq,mudim) + 13*m3sq*m4sq*m7**10*B0fin(0,0,m4sq,mudim) - 4*m3sq*m7**12*B0fin(0,0,m4sq,mudim) - 5*m4sq*m7**12*B0fin(0,0,m4sq,mudim) + m7**14*B0fin(0,0,m4sq,mudim) - 3*m3**8*m4**4*m7sq*B0fin(0,0,m4sq,mudim) + m3**6*m4**6*m7sq*B0fin(0,0,m4sq,mudim) - 6*m3**4*m4**8*m7sq*B0fin(0,0,m4sq,mudim) + 17*m3sq*m4**10*m7sq*B0fin(0,0,m4sq,mudim) - 5*m4**12*m7sq*B0fin(0,0,m4sq,mudim) - 8*m3sq*m4**8*m7**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) - 10*m4**10*m7**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + 12*m3sq*m4**6*m7**6*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + 20*m4**8*m7**6*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) - 8*m3sq*m4**4*m7**8*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) - 20*m4**6*m7**8*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + 10*m4**4*m7**10*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + 2*m3sq*m4sq*m7**10*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) - 2*m4sq*m7**12*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + 2*m3sq*m4**10*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + 2*m4**12*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + 23*m3**6*m4**4*m7**4*B0fin(0,0,m7sq,mudim) - 36*m3**4*m4**6*m7**4*B0fin(0,0,m7sq,mudim) + 11*m3sq*m4**8*m7**4*B0fin(0,0,m7sq,mudim) - 2*m3**8*m4sq*m7**4*B0fin(0,0,m7sq,mudim) + m3**8*m7**6*B0fin(0,0,m7sq,mudim) - 14*m3**4*m4**4*m7**6*B0fin(0,0,m7sq,mudim) - 30*m3sq*m4**6*m7**6*B0fin(0,0,m7sq,mudim) + m3**6*m4sq*m7**6*B0fin(0,0,m7sq,mudim) - 3*m3**6*m7**8*B0fin(0,0,m7sq,mudim) + 6*m3sq*m4**4*m7**8*B0fin(0,0,m7sq,mudim) - 4*m3**4*m4sq*m7**8*B0fin(0,0,m7sq,mudim) + 3*m3**4*m7**10*B0fin(0,0,m7sq,mudim) + 9*m3sq*m4sq*m7**10*B0fin(0,0,m7sq,mudim) - m3sq*m7**12*B0fin(0,0,m7sq,mudim) - 3*m3**8*m4**4*m7sq*B0fin(0,0,m7sq,mudim) + 11*m3**6*m4**6*m7sq*B0fin(0,0,m7sq,mudim) - 13*m3**4*m4**8*m7sq*B0fin(0,0,m7sq,mudim) + 5*m3sq*m4**10*m7sq*B0fin(0,0,m7sq,mudim) - 8*m3sq*m4**8*m7**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim) + 10*m4**10*m7**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim) + 12*m3sq*m4**6*m7**6*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim) - 20*m4**8*m7**6*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim) - 8*m3sq*m4**4*m7**8*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim) + 20*m4**6*m7**8*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim) - 10*m4**4*m7**10*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim) + 2*m3sq*m4sq*m7**10*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim) + 2*m4sq*m7**12*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim) + 2*m3sq*m4**10*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim) - 2*m4**12*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim) + 16*m3**6*m4**4*m7**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) - 20*m3**4*m4**6*m7**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) + 8*m3sq*m4**8*m7**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) - 2*m3**8*m4sq*m7**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) - 20*m3**4*m4**4*m7**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) - 28*m3sq*m4**6*m7**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) + 8*m3**6*m4sq*m7**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) + 8*m3sq*m4**4*m7**8*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) - 12*m3**4*m4sq*m7**8*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) + 6*m3sq*m4sq*m7**10*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) - 2*m3**8*m4**4*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) + 8*m3**6*m4**6*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) - 12*m3**4*m4**8*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) + 6*m3sq*m4**10*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) + 16*m3**4*m4**4*m7**4*T134fin(m7,m4,0,mudim) + 16*m3sq*m4**6*m7**4*T134fin(m7,m4,0,mudim) - 16*m4**8*m7**4*T134fin(m7,m4,0,mudim) - 16*m3**6*m4sq*m7**4*T134fin(m7,m4,0,mudim) + 16*m3sq*m4**4*m7**6*T134fin(m7,m4,0,mudim) + 24*m4**6*m7**6*T134fin(m7,m4,0,mudim) + 24*m3**4*m4sq*m7**6*T134fin(m7,m4,0,mudim) - 16*m4**4*m7**8*T134fin(m7,m4,0,mudim) - 16*m3sq*m4sq*m7**8*T134fin(m7,m4,0,mudim) + 4*m4sq*m7**10*T134fin(m7,m4,0,mudim) - 16*m3**6*m4**4*m7sq*T134fin(m7,m4,0,mudim) + 24*m3**4*m4**6*m7sq*T134fin(m7,m4,0,mudim) - 16*m3sq*m4**8*m7sq*T134fin(m7,m4,0,mudim) + 4*m4**10*m7sq*T134fin(m7,m4,0,mudim) + 4*m3**8*m4sq*m7sq*T134fin(m7,m4,0,mudim) + 16*m4**8*m7**4*T134fin(m7,m4,m3,mudim) - 24*m4**6*m7**6*T134fin(m7,m4,m3,mudim) + 16*m4**4*m7**8*T134fin(m7,m4,m3,mudim) - 4*m4sq*m7**10*T134fin(m7,m4,m3,mudim) - 4*m4**10*m7sq*T134fin(m7,m4,m3,mudim))/(2.*m3**2*m4**2*(m4 - m7)**4*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(m4 + m7)**4*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2)
		def eval_63():
			return (((m4sq - m6sq)**2*(4*m3sq*(m3sq - m4sq)*(m4sq - m6sq)*B0del(0,0,m3sq,mudim) - 2*(m3**6 - 2*m4**6 + 2*m4**4*m6sq + 2*m3sq*m4sq*(3*m4sq + m6sq) - m3**4*(5*m4sq + m6sq))*B0del(0,0,m4sq,mudim) - 2*(m3**6 + 8*m3sq*m4**4 - 2*m4**6 + 2*m4**4*m6sq + m3**4*(-7*m4sq + m6sq))*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)) + (2*m3sq*(m3sq - 4*m4sq)*(8*m4**4 - 2*m3sq*(m4sq + m6sq) + (4*m4**4 + m3sq*(m4sq + m6sq))*B0fin(0,0,m4sq,mudim)))/m4**2 + (2*(-1 + B0fin(0,0,m4sq,mudim))*(m3sq*(m3sq - 4*m4sq)*(4*m4**4 + m3sq*(m4sq + m6sq)) + 2*m3sq*(m3sq - m4sq)*m4sq*(m4sq - m6sq)*B0fin(0,0,m3sq,mudim) + m4sq*(-m3**6 + 2*m4**4*(m4sq - m6sq) - 2*m3sq*m4sq*(3*m4sq + m6sq) + m3**4*(5*m4sq + m6sq))*B0fin(0,0,m4sq,mudim)))/m4**2))/(m3sq - 4*m4sq) - 4*m3**4*(m4sq + m6sq)*(m4sq + m6sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)) + (4*m4sq*(m3sq*(m4sq - m6sq)**3*B0del(0,0,m3sq,mudim) - m4sq*(m4sq - m6sq)**3*B0del(0,0,m4sq,mudim) - 2*m3**4*(m3sq - 4*m4sq)*m6sq*B0del(0,0,m6sq,mudim) + (m3sq*(m4sq - m6sq)**3 - m4sq*(m4sq - m6sq)**3 - 2*m3**4*(m3sq - 4*m4sq)*m6sq)*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)) + (-1 + B0fin(0,0,m4sq,mudim))*(m3sq*(m4sq - m6sq)**3*B0fin(0,0,m3sq,mudim) - m4sq*(m4sq - m6sq)**3*B0fin(0,0,m4sq,mudim) - 2*m3**4*(m3sq - 4*m4sq)*m6sq*B0fin(0,0,m6sq,mudim))))/(m3sq - 4*m4sq) + (4*m3sq*(m4sq - m6sq)**2*((m4sq - m6sq)*(m3sq + 2*m4sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 4*m4sq*B0fin(0,0,m4sq,mudim)) - (m3sq - 3*m4sq - m6sq)*T134fin(m4,m4,m3,mudim)))/(m3sq - 4*m4sq) + 4*m3sq*(-(m4sq - m6sq)**2 + m3sq*(m4sq + m6sq))*T134fin(m6,m4,0,mudim) + 4*m3sq*(m4sq - m6sq)**2*T134fin(m6,m4,m3,mudim))/(4.*m3**6*(m4sq - m6sq)**4)
		def eval_64():
			return (2*m1**4*m3**4 - 2*m2**4*m3**4 + 2*m1sq*m3**6 - 2*m2sq*m3**6 + 6*m1sq*m2**4*m3sq - 6*m1**4*m2sq*m3sq + 2*m1sq*(m2sq - m3sq)**2*m3sq*B0del(0,0,m1sq,mudim) - 2*m2sq*(m1sq - m3sq)**2*m3sq*B0del(0,0,m2sq,mudim) + 2*m1**4*m3**4*B0del(0,0,m3sq,mudim) - 2*m2**4*m3**4*B0del(0,0,m3sq,mudim) + 4*m1sq*m2**4*m3sq*B0del(0,0,m3sq,mudim) - 4*m1**4*m2sq*m3sq*B0del(0,0,m3sq,mudim) - 4*m1sq*m2sq*m3**4*B0fin(0,0,m1sq,mudim) + 2*m1sq*m3**6*B0fin(0,0,m1sq,mudim) + 2*m1sq*m2**4*m3sq*B0fin(0,0,m1sq,mudim) + 4*m1sq*m2sq*m3**4*B0fin(0,0,m2sq,mudim) - 2*m2sq*m3**6*B0fin(0,0,m2sq,mudim) - 2*m1**4*m2sq*m3sq*B0fin(0,0,m2sq,mudim) + 2*m1**4*m3**4*B0fin(0,0,m3sq,mudim) - 2*m2**4*m3**4*B0fin(0,0,m3sq,mudim) + 4*m1sq*m2**4*m3sq*B0fin(0,0,m3sq,mudim) - 4*m1**4*m2sq*m3sq*B0fin(0,0,m3sq,mudim) - 4*m1sq*m2sq*m3**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 2*m1sq*m3**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 2*m1sq*m2**4*m3sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 4*m1sq*m2sq*m3**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) - 2*m2sq*m3**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) - 2*m1**4*m2sq*m3sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) + m1**4*m3**4*B0fin(0,0,m3sq,mudim)**2 - m2**4*m3**4*B0fin(0,0,m3sq,mudim)**2 - m1sq*m3**6*B0fin(0,0,m3sq,mudim)**2 + m2sq*m3**6*B0fin(0,0,m3sq,mudim)**2 + m1sq*m2**4*m3sq*B0fin(0,0,m3sq,mudim)**2 - m1**4*m2sq*m3sq*B0fin(0,0,m3sq,mudim)**2 + 2*m1sq*m2**4*T134fin(m1,0,0,mudim) + 2*m1sq*m3**4*T134fin(m1,0,0,mudim) + 4*m2sq*m3**4*T134fin(m1,0,0,mudim) - 2*m3**6*T134fin(m1,0,0,mudim) - 2*m2**4*m3sq*T134fin(m1,0,0,mudim) - 4*m1sq*m2sq*m3sq*T134fin(m1,0,0,mudim) - 2*m1**4*m2sq*T134fin(m2,0,0,mudim) - 4*m1sq*m3**4*T134fin(m2,0,0,mudim) - 2*m2sq*m3**4*T134fin(m2,0,0,mudim) + 2*m3**6*T134fin(m2,0,0,mudim) + 2*m1**4*m3sq*T134fin(m2,0,0,mudim) + 4*m1sq*m2sq*m3sq*T134fin(m2,0,0,mudim) - 2*m1sq*m2**4*T134fin(m3,0,0,mudim) + 2*m1**4*m2sq*T134fin(m3,0,0,mudim) + 2*m1sq*m3**4*T134fin(m3,0,0,mudim) - 2*m2sq*m3**4*T134fin(m3,0,0,mudim) - 2*m1**4*m3sq*T134fin(m3,0,0,mudim) + 2*m2**4*m3sq*T134fin(m3,0,0,mudim) - 2*m1sq*m2**4*T134fin(m3,m1,0,mudim) - 2*m1sq*m3**4*T134fin(m3,m1,0,mudim) + 4*m1sq*m2sq*m3sq*T134fin(m3,m1,0,mudim) + 2*m1**4*m2sq*T134fin(m3,m2,0,mudim) + 2*m2sq*m3**4*T134fin(m3,m2,0,mudim) - 4*m1sq*m2sq*m3sq*T134fin(m3,m2,0,mudim))/(2.*(m1sq - m2sq)*m3**4*(m1sq - m3sq)**2*(m2sq - m3sq)**2)
		def eval_65():
			return (-4*(m1sq + m2sq)*m6**4*(m1sq + m2sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim)) + (m1sq - m2sq)**2*((-4*(m1sq - m2sq)*(m2sq - m6sq)*m6sq*B0del(0,0,m6sq,mudim))/(4*m2sq - m6sq) + (2*(-2*m2**6 - 7*m2sq*m6**4 + m6**6 + m1sq*(2*m2**4 + m6**4) + 8*m2**4*m6sq)*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)))/(4*m2sq - m6sq) + m6sq*(16*m2sq - 4*m6sq - (4*m1sq*m6sq)/m2**2 + m2sq*(2 + (2*m1sq)/m2**2 - (2*m6sq)/m2**2 + (4*(m1sq - m2sq)*(m2sq - m6sq))/(-m6**4 + 4*m2sq*m6sq))*B0del(0,0,m2sq,mudim) + (2*(4*m2**4 + m1sq*m6sq + m2sq*m6sq)*B0fin(0,0,m2sq,mudim))/m2**2) + m6sq*(-1 + B0fin(0,0,m2sq,mudim))*(2*(4*m2sq + m6sq + (m1sq*m6sq)/m2**2) + m2sq*(2 + (2*m1sq)/m2**2 - (2*m6sq)/m2**2 + (4*(m1sq - m2sq)*(m2sq - m6sq))/(-m6**4 + 4*m2sq*m6sq))*B0fin(0,0,m2sq,mudim) - (4*(m1sq - m2sq)*(m2sq - m6sq)*B0fin(0,0,m6sq,mudim))/(4*m2sq - m6sq))) + (4*m2sq*(m1sq*(-8*m2sq*m6**4 + 2*m6**6)*B0del(0,0,m1sq,mudim) + (m1sq - m2sq)**3*(-(m2sq*B0del(0,0,m2sq,mudim)) + m6sq*B0del(0,0,m6sq,mudim)) + (m1sq*(-8*m2sq*m6**4 + 2*m6**6) + (m1sq - m2sq)**3*(-m2sq + m6sq))*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)) + (-1 + B0fin(0,0,m2sq,mudim))*(m1sq*(-8*m2sq*m6**4 + 2*m6**6)*B0fin(0,0,m1sq,mudim) + (m1sq - m2sq)**3*(-(m2sq*B0fin(0,0,m2sq,mudim)) + m6sq*B0fin(0,0,m6sq,mudim)))))/(4*m2sq - m6sq) + 4*m6sq*(-m1**4 - m2**4 + m2sq*m6sq + m1sq*(2*m2sq + m6sq))*T134fin(m2,m1,0,mudim) + 4*(m1sq - m2sq)**2*m6sq*T134fin(m6,m2,m1,mudim) + (4*(m1sq - m2sq)**2*m6sq*((m1sq - m2sq)*(2*m2sq + m6sq + 4*m2sq*B0fin(0,0,m2sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)) + (-m1sq - 3*m2sq + m6sq)*T134fin(m6,m2,m2,mudim)))/(4*m2sq - m6sq))/(4.*(m1sq - m2sq)**4*m6**6)
		def eval_66():
			return (2*m2**4*m6**4 + 2*m1sq*m2sq*m6**4 - 6*m1sq*m2**4*m6sq + 2*m2**6*m6sq + 2*(m2**4*m6**4 + m1sq*(m2sq*m6**4 - 2*m2**4*m6sq))*B0del(0,0,m2sq,mudim) + 2*m2**4*(-m1sq + m2sq)*m6sq*B0del(0,0,m6sq,mudim) + 2*m2**4*m6**4*B0fin(0,0,m2sq,mudim) + 2*m1sq*m2sq*m6**4*B0fin(0,0,m2sq,mudim) - 4*m1sq*m2**4*m6sq*B0fin(0,0,m2sq,mudim) + m2**4*m6**4*B0fin(0,0,m2sq,mudim)**2 + m1sq*m2sq*m6**4*B0fin(0,0,m2sq,mudim)**2 - m1sq*m2**4*m6sq*B0fin(0,0,m2sq,mudim)**2 - m2**6*m6sq*B0fin(0,0,m2sq,mudim)**2 - 2*m1sq*m2**4*m6sq*B0fin(0,0,m6sq,mudim) + 2*m2**6*m6sq*B0fin(0,0,m6sq,mudim) - 2*m1sq*m2**4*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m2**6*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m2**6*T134fin(m1,0,0,mudim) + 2*m2sq*m6**4*T134fin(m1,0,0,mudim) - 4*m2**4*m6sq*T134fin(m1,0,0,mudim) - 2*m1sq*m2**4*T134fin(m2,0,0,mudim) - 2*m1sq*m6**4*T134fin(m2,0,0,mudim) + 4*m1sq*m2sq*m6sq*T134fin(m2,0,0,mudim) - 2*m2sq*m6**4*T134fin(m2,m1,0,mudim) + 2*m2**4*m6sq*T134fin(m2,m1,0,mudim) - 2*m2**6*T134fin(m6,m1,0,mudim) + 2*m2**4*m6sq*T134fin(m6,m1,0,mudim) + 2*m1sq*m2**4*T134fin(m6,m2,0,mudim) - 2*m2**4*m6sq*T134fin(m6,m2,0,mudim))/(2.*m2**4*(m1sq - m2sq)**2*m6**2*(m2sq - m6sq)**2)
		def eval_67():
			return (2*m1**4*m2sq*(m2sq - m3sq)**3*B0del(0,0,m1sq,mudim) + 2*(m1sq - m2sq)**3*m2sq*m3**4*B0del(0,0,m3sq,mudim) + m2sq*(2*(m1sq - m2sq)**3*m3**4 + (m1sq - m2sq)**2*(m1sq - m3sq)*(m2sq - m3sq)**2 + 2*m1**4*(m2sq - m3sq)**3)*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)) + (m1sq - m2sq)**2*m2sq*(m1sq - m3sq)*(m2sq - m3sq)**2*(8 + B0del(0,0,m2sq,mudim) + 4*B0fin(0,0,m2sq,mudim)) - m2sq*(1 - B0fin(0,0,m2sq,mudim))*(2*m1**4*(m2sq - m3sq)**3*B0fin(0,0,m1sq,mudim) + (m1sq - m2sq)**2*(m1sq - m3sq)*(m2sq - m3sq)**2*(4 + B0fin(0,0,m2sq,mudim)) + 2*(m1sq - m2sq)**3*m3**4*B0fin(0,0,m3sq,mudim)) - 2*m2**4*(m1sq*(m2sq - m3sq)**3*B0del(0,0,m1sq,mudim) + (m1sq - m2sq)**3*m3sq*B0del(0,0,m3sq,mudim) + (m1sq*(m2sq - m3sq)**3 + (m1sq - m2sq)**3*m3sq)*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)) + (-1 + B0fin(0,0,m2sq,mudim))*(m1sq*(m2sq - m3sq)**3*B0fin(0,0,m1sq,mudim) + (m1sq - m2sq)**3*m3sq*B0fin(0,0,m3sq,mudim))) + 2*(m1sq - m2sq)**2*(m2sq - m3sq)**3*T134fin(m1,0,0,mudim) - 2*(m1sq - m2sq)**2*(m1sq - m3sq)*(m2sq - m3sq)**2*T134fin(m2,0,0,mudim) + 2*(m1sq - m2sq)*(m2sq - m3sq)**3*(m2**4 + m1sq*m2sq + 2*m1sq*m2sq*B0fin(0,0,m1sq,mudim) + 2*m2**4*B0fin(0,0,m2sq,mudim) - m1sq*T134fin(m2,m1,0,mudim)) + 2*(m1sq - m2sq)**3*(m2sq - m3sq)**2*T134fin(m3,0,0,mudim) - 2*(m1sq - m2sq)**3*(m2sq - m3sq)*(m2**4 + m2sq*m3sq + 2*m2**4*B0fin(0,0,m2sq,mudim) + 2*m2sq*m3sq*B0fin(0,0,m3sq,mudim) - m3sq*T134fin(m3,m2,0,mudim)))/(2.*m2**4*(m1sq - m2sq)**3*(m1sq - m3sq)*(m2sq - m3sq)**3)
		def eval_68():
			return (4*(m1sq + m3sq)**2*m6sq + 2*(m1**4 + m3**4 - 2*m1sq*m3sq + 2*m3sq*m6sq)*(m1sq + m3sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim)) + (m1sq - m3sq)**2*(-4*m3sq + 6*m6sq + (-4*m3sq + 2*m6sq)*B0del(0,0,m3sq,mudim) - 2*(2*m3sq + 3*m6sq)*B0fin(0,0,m3sq,mudim) + (-2*m3sq + m6sq)*B0fin(0,0,m3sq,mudim)**2) + (2*(m1sq - m3sq)*m6sq*(m3sq*(-m1**4 + m3**4 + 4*m1sq*m3sq - m3sq*m6sq)*B0del(0,0,m3sq,mudim) - (m1sq - m3sq)**2*(m3sq - m6sq)*B0del(0,0,m6sq,mudim) + m1sq*(6*m3**4 - 2*m3sq*m6sq + m1sq*(-2*m3sq + m6sq))*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)) + (-1 + B0fin(0,0,m1sq,mudim))*(m3sq*(-m1**4 + m3**4 + 4*m1sq*m3sq - m3sq*m6sq)*B0fin(0,0,m3sq,mudim) - (m1sq - m3sq)**2*(m3sq - m6sq)*B0fin(0,0,m6sq,mudim))))/(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq)) + (2*m6sq*(-((m1**8 - 4*m1**6*m3sq - m3**4*(m3sq - m6sq)**2 + m1sq*(-4*m3**6 - 3*m3sq*m6**4 + 9*m3**4*m6sq) + m1**4*(8*m3**4 + 5*m3sq*m6sq))*B0del(0,0,m1sq,mudim)) - m1sq*(m1sq - m3sq)**3*B0del(0,0,m6sq,mudim) + (m1**8 - 4*m1**6*m3sq - m3**4*(m3sq - m6sq)**2 + m1sq*(-4*m3**6 - 3*m3sq*m6**4 + 9*m3**4*m6sq) + m1**4*(8*m3**4 + 5*m3sq*m6sq))*B0fin(0,0,m1sq,mudim) + m3sq*((m1**6 - 5*m1**4*(m3sq + m6sq) + (m3**3 - m3*m6sq)**2 + 3*m1sq*(m3**4 + m6**4 - 3*m3sq*m6sq))*B0del(0,0,m3sq,mudim) + 4*m1sq*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))*B0fin(0,0,m3sq,mudim)) + m3sq*(-4*m1sq*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq)) - (m1**6 - 5*m1**4*(m3sq + m6sq) + (m3**3 - m3*m6sq)**2 + 3*m1sq*(m3**4 + m6**4 - 3*m3sq*m6sq))*B0fin(0,0,m3sq,mudim)) + m1sq*(m1sq - m3sq)**3*B0fin(0,0,m6sq,mudim) + 2*m3sq*(-m1sq + m3sq)**3*(B0fin(0,0,m3sq,mudim) + B0fin(0,0,m6sq,mudim)) - 2*m3sq*(-m1sq + m3sq)**3*(B0del(0,0,m3sq,mudim) + B0del(0,0,m6sq,mudim) + B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim)) - B0fin(0,0,m1sq,mudim)*(-(m3sq*(m1**6 - 5*m1**4*(m3sq + m6sq) + (m3**3 - m3*m6sq)**2 + 3*m1sq*(m3**4 + m6**4 - 3*m3sq*m6sq))*B0fin(0,0,m3sq,mudim)) + m1sq*(-4*m3sq*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq)) + (m1sq - m3sq)**3*B0fin(0,0,m6sq,mudim)))))/(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq)) - 2*(m1sq + 3*m3sq)*m6sq*T134fin(m3,m1,0,mudim) + (2*(m1sq - m3sq)**2*(-((m1sq - m3sq)*(m1sq - m3sq - m6sq)*(m1sq + m3sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim))) + (m1sq + 3*m3sq - m6sq)*m6sq*T134fin(m6,m3,m1,mudim)))/(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq)) + 2*(m1sq - m3sq)**2*T134fin(m6,m3,m3,mudim))/(2.*(m1sq - m3sq)**4*m6**4)
		def eval_69():
			return (4*(m1sq + m2sq)**2*m6sq + (m1sq - m2sq)**2*(-4*m1sq + 6*m6sq + (-4*m1sq + 2*m6sq)*B0del(0,0,m1sq,mudim) - 2*(2*m1sq + 3*m6sq)*B0fin(0,0,m1sq,mudim) + (-2*m1sq + m6sq)*B0fin(0,0,m1sq,mudim)**2) + 2*(m1**4 + m2**4 - 2*m1sq*(m2sq - m6sq))*(m1sq + m2sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim)) + (2*(m1sq - m2sq)*m6sq*(m1sq*(-m1**4 + m2**4 + m1sq*(-4*m2sq + m6sq))*B0del(0,0,m1sq,mudim) + (m1sq - m2sq)**2*(m1sq - m6sq)*B0del(0,0,m6sq,mudim) + m2sq*(-6*m1**4 - m2sq*m6sq + 2*m1sq*(m2sq + m6sq))*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)) + (-1 + B0fin(0,0,m2sq,mudim))*(m1sq*(-m1**4 + m2**4 + m1sq*(-4*m2sq + m6sq))*B0fin(0,0,m1sq,mudim) + (m1sq - m2sq)**2*(m1sq - m6sq)*B0fin(0,0,m6sq,mudim))))/(m1**4 + (m2sq - m6sq)**2 - 2*m1sq*(m2sq + m6sq)) + (2*m6sq*(m1sq*(-m1**6 + 3*m2**6 + 3*m2sq*m6**4 + m1**4*(9*m2sq - 2*m6sq) - 5*m2**4*m6sq + m1sq*(-11*m2**4 + m6**4 - 9*m2sq*m6sq))*B0del(0,0,m1sq,mudim) - m1sq*(-m1**6 + 3*m2**6 + 3*m2sq*m6**4 + m1**4*(9*m2sq - 2*m6sq) - 5*m2**4*m6sq + m1sq*(-11*m2**4 + m6**4 - 9*m2sq*m6sq))*B0fin(0,0,m1sq,mudim) + m1sq*((m1**6 + m2**6 + 3*m2sq*m6**4 + m1**4*(3*m2sq - 2*m6sq) - 5*m2**4*m6sq + m1sq*(-5*m2**4 + m6**4 - 9*m2sq*m6sq))*B0del(0,0,m2sq,mudim) + 2*(-m1sq + m2sq)**3*B0del(0,0,m6sq,mudim) + 4*m2sq*(m1**4 + (m2sq - m6sq)**2 - 2*m1sq*(m2sq + m6sq))*B0fin(0,0,m2sq,mudim)) + m2sq*(-m1sq + m2sq)**3*(B0fin(0,0,m2sq,mudim) + B0fin(0,0,m6sq,mudim)) - m1sq*(4*m2sq*(m1**4 + (m2sq - m6sq)**2 - 2*m1sq*(m2sq + m6sq)) + (m1**6 + m2**6 + 3*m2sq*m6**4 + m1**4*(3*m2sq - 2*m6sq) - 5*m2**4*m6sq + m1sq*(-5*m2**4 + m6**4 - 9*m2sq*m6sq))*B0fin(0,0,m2sq,mudim) - 2*(m1sq - m2sq)**3*B0fin(0,0,m6sq,mudim)) + m1sq*B0fin(0,0,m1sq,mudim)*(4*m2sq*(m1**4 + (m2sq - m6sq)**2 - 2*m1sq*(m2sq + m6sq)) + (m1**6 + m2**6 + 3*m2sq*m6**4 + m1**4*(3*m2sq - 2*m6sq) - 5*m2**4*m6sq + m1sq*(-5*m2**4 + m6**4 - 9*m2sq*m6sq))*B0fin(0,0,m2sq,mudim) - 2*(m1sq - m2sq)**3*B0fin(0,0,m6sq,mudim)) + (m1sq - m2sq)**3*m2sq*(B0del(0,0,m2sq,mudim) + B0del(0,0,m6sq,mudim) + B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))))/(m1**4 + (m2sq - m6sq)**2 - 2*m1sq*(m2sq + m6sq)) - 2*(3*m1sq + m2sq)*m6sq*T134fin(m2,m1,0,mudim) + 2*(m1sq - m2sq)**2*T134fin(m6,m1,m1,mudim) + (2*(m1sq - m2sq)**2*(-((m1sq - m2sq)*(m1sq - m2sq + m6sq)*(m1sq + m2sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim))) + (3*m1sq + m2sq - m6sq)*m6sq*T134fin(m6,m2,m1,mudim)))/(m1**4 + (m2sq - m6sq)**2 - 2*m1sq*(m2sq + m6sq)))/(2.*(m1sq - m2sq)**4*m6**4)
		def eval_70():
			return (m1**14 + 6*m1**10*m6**4 - 4*m1**8*m6**6 + m1**6*m6**8 - 4*m1**12*m6sq + 21*m1**10*m7**4 - 28*m1**6*m6**4*m7**4 + 32*m1**4*m6**6*m7**4 - m1sq*m6**8*m7**4 - 36*m1**8*m6sq*m7**4 - 35*m1**8*m7**6 - 52*m1**4*m6**4*m7**6 + 8*m1sq*m6**6*m7**6 - m6**8*m7**6 - 8*m1**6*m6sq*m7**6 + 35*m1**6*m7**8 - 10*m1sq*m6**4*m7**8 + 4*m6**6*m7**8 + 4*m1**4*m6sq*m7**8 - 21*m1**4*m7**10 - 6*m6**4*m7**10 + 4*m1sq*m6sq*m7**10 + 7*m1sq*m7**12 + 4*m6sq*m7**12 - m7**14 - 7*m1**12*m7sq - 38*m1**8*m6**4*m7sq + 24*m1**6*m6**6*m7sq - 7*m1**4*m6**8*m7sq + 36*m1**10*m6sq*m7sq + 2*m1sq*m7sq*(m1**10 + m1**6*(-6*m6**4 + 10*m7**4) + m1**8*(4*m6sq - 5*m7sq) - (m6sq - m7sq)**4*m7sq + 2*m1**4*(2*m6**6 - 4*m6sq*m7**4 - 5*m7**6 - 5*m6**4*m7sq) - m1sq*(m6**8 + 10*m6**4*m7**4 - 5*m7**8 - 8*m6**6*m7sq))*B0del(0,0,m1sq,mudim) + 4*m1sq*m6sq*(m1sq - m7sq)**4*m7sq*B0del(0,0,m6sq,mudim) + 10*m1**10*m7**4*B0del(0,0,m7sq,mudim) - 20*m1**6*m6**4*m7**4*B0del(0,0,m7sq,mudim) + 16*m1**4*m6**6*m7**4*B0del(0,0,m7sq,mudim) - 2*m1sq*m6**8*m7**4*B0del(0,0,m7sq,mudim) - 20*m1**8*m7**6*B0del(0,0,m7sq,mudim) - 20*m1**4*m6**4*m7**6*B0del(0,0,m7sq,mudim) + 8*m1sq*m6**6*m7**6*B0del(0,0,m7sq,mudim) - 16*m1**6*m6sq*m7**6*B0del(0,0,m7sq,mudim) + 20*m1**6*m7**8*B0del(0,0,m7sq,mudim) - 12*m1sq*m6**4*m7**8*B0del(0,0,m7sq,mudim) - 10*m1**4*m7**10*B0del(0,0,m7sq,mudim) + 8*m1sq*m6sq*m7**10*B0del(0,0,m7sq,mudim) + 2*m1sq*m7**12*B0del(0,0,m7sq,mudim) - 2*m1**12*m7sq*B0del(0,0,m7sq,mudim) - 12*m1**8*m6**4*m7sq*B0del(0,0,m7sq,mudim) + 8*m1**6*m6**6*m7sq*B0del(0,0,m7sq,mudim) - 2*m1**4*m6**8*m7sq*B0del(0,0,m7sq,mudim) + 8*m1**10*m6sq*m7sq*B0del(0,0,m7sq,mudim) + m1**14*B0fin(0,0,m1sq,mudim) + 9*m1**10*m6**4*B0fin(0,0,m1sq,mudim) - 7*m1**8*m6**6*B0fin(0,0,m1sq,mudim) + 2*m1**6*m6**8*B0fin(0,0,m1sq,mudim) - 5*m1**12*m6sq*B0fin(0,0,m1sq,mudim) + 9*m1**10*m7**4*B0fin(0,0,m1sq,mudim) - 18*m1**6*m6**4*m7**4*B0fin(0,0,m1sq,mudim) + 31*m1**4*m6**6*m7**4*B0fin(0,0,m1sq,mudim) - 4*m1sq*m6**8*m7**4*B0fin(0,0,m1sq,mudim) + 10*m1**8*m6sq*m7**4*B0fin(0,0,m1sq,mudim) - 5*m1**8*m7**6*B0fin(0,0,m1sq,mudim) - 40*m1**4*m6**4*m7**6*B0fin(0,0,m1sq,mudim) + 11*m1sq*m6**6*m7**6*B0fin(0,0,m1sq,mudim) + m6**8*m7**6*B0fin(0,0,m1sq,mudim) - 46*m1**6*m6sq*m7**6*B0fin(0,0,m1sq,mudim) - 5*m1**6*m7**8*B0fin(0,0,m1sq,mudim) - 15*m1sq*m6**4*m7**8*B0fin(0,0,m1sq,mudim) - 4*m6**6*m7**8*B0fin(0,0,m1sq,mudim) + 15*m1**4*m6sq*m7**8*B0fin(0,0,m1sq,mudim) + 9*m1**4*m7**10*B0fin(0,0,m1sq,mudim) + 6*m6**4*m7**10*B0fin(0,0,m1sq,mudim) + 13*m1sq*m6sq*m7**10*B0fin(0,0,m1sq,mudim) - 5*m1sq*m7**12*B0fin(0,0,m1sq,mudim) - 4*m6sq*m7**12*B0fin(0,0,m1sq,mudim) + m7**14*B0fin(0,0,m1sq,mudim) - 5*m1**12*m7sq*B0fin(0,0,m1sq,mudim) - 6*m1**8*m6**4*m7sq*B0fin(0,0,m1sq,mudim) + m1**6*m6**6*m7sq*B0fin(0,0,m1sq,mudim) - 3*m1**4*m6**8*m7sq*B0fin(0,0,m1sq,mudim) + 17*m1**10*m6sq*m7sq*B0fin(0,0,m1sq,mudim) + m1**14*B0fin(0,0,m6sq,mudim) + 3*m1**10*m6**4*B0fin(0,0,m6sq,mudim) - m1**8*m6**6*B0fin(0,0,m6sq,mudim) - 3*m1**12*m6sq*B0fin(0,0,m6sq,mudim) + 9*m1**10*m7**4*B0fin(0,0,m6sq,mudim) + 6*m1**6*m6**4*m7**4*B0fin(0,0,m6sq,mudim) - 6*m1**4*m6**6*m7**4*B0fin(0,0,m6sq,mudim) - 29*m1**8*m6sq*m7**4*B0fin(0,0,m6sq,mudim) - 5*m1**8*m7**6*B0fin(0,0,m6sq,mudim) + 6*m1**4*m6**4*m7**6*B0fin(0,0,m6sq,mudim) + 4*m1sq*m6**6*m7**6*B0fin(0,0,m6sq,mudim) + 36*m1**6*m6sq*m7**6*B0fin(0,0,m6sq,mudim) - 5*m1**6*m7**8*B0fin(0,0,m6sq,mudim) - 9*m1sq*m6**4*m7**8*B0fin(0,0,m6sq,mudim) - m6**6*m7**8*B0fin(0,0,m6sq,mudim) - 29*m1**4*m6sq*m7**8*B0fin(0,0,m6sq,mudim) + 9*m1**4*m7**10*B0fin(0,0,m6sq,mudim) + 3*m6**4*m7**10*B0fin(0,0,m6sq,mudim) + 14*m1sq*m6sq*m7**10*B0fin(0,0,m6sq,mudim) - 5*m1sq*m7**12*B0fin(0,0,m6sq,mudim) - 3*m6sq*m7**12*B0fin(0,0,m6sq,mudim) + m7**14*B0fin(0,0,m6sq,mudim) - 5*m1**12*m7sq*B0fin(0,0,m6sq,mudim) - 9*m1**8*m6**4*m7sq*B0fin(0,0,m6sq,mudim) + 4*m1**6*m6**6*m7sq*B0fin(0,0,m6sq,mudim) + 14*m1**10*m6sq*m7sq*B0fin(0,0,m6sq,mudim) - 10*m1**10*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 8*m1**8*m6sq*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 20*m1**8*m7**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 12*m1**6*m6sq*m7**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 20*m1**6*m7**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 8*m1**4*m6sq*m7**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 10*m1**4*m7**10*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m1sq*m6sq*m7**10*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m1sq*m7**12*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m1**12*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m1**10*m6sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 36*m1**6*m6**4*m7**4*B0fin(0,0,m7sq,mudim) + 23*m1**4*m6**6*m7**4*B0fin(0,0,m7sq,mudim) - 2*m1sq*m6**8*m7**4*B0fin(0,0,m7sq,mudim) + 11*m1**8*m6sq*m7**4*B0fin(0,0,m7sq,mudim) - 14*m1**4*m6**4*m7**6*B0fin(0,0,m7sq,mudim) + m1sq*m6**6*m7**6*B0fin(0,0,m7sq,mudim) + m6**8*m7**6*B0fin(0,0,m7sq,mudim) - 30*m1**6*m6sq*m7**6*B0fin(0,0,m7sq,mudim) - 4*m1sq*m6**4*m7**8*B0fin(0,0,m7sq,mudim) - 3*m6**6*m7**8*B0fin(0,0,m7sq,mudim) + 6*m1**4*m6sq*m7**8*B0fin(0,0,m7sq,mudim) + 3*m6**4*m7**10*B0fin(0,0,m7sq,mudim) + 9*m1sq*m6sq*m7**10*B0fin(0,0,m7sq,mudim) - m6sq*m7**12*B0fin(0,0,m7sq,mudim) - 13*m1**8*m6**4*m7sq*B0fin(0,0,m7sq,mudim) + 11*m1**6*m6**6*m7sq*B0fin(0,0,m7sq,mudim) - 3*m1**4*m6**8*m7sq*B0fin(0,0,m7sq,mudim) + 5*m1**10*m6sq*m7sq*B0fin(0,0,m7sq,mudim) - 20*m1**6*m6**4*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) + 16*m1**4*m6**6*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 2*m1sq*m6**8*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) + 8*m1**8*m6sq*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 20*m1**4*m6**4*m7**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) + 8*m1sq*m6**6*m7**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 28*m1**6*m6sq*m7**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 12*m1sq*m6**4*m7**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) + 8*m1**4*m6sq*m7**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) + 6*m1sq*m6sq*m7**10*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 12*m1**8*m6**4*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) + 8*m1**6*m6**6*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 2*m1**4*m6**8*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) + 6*m1**10*m6sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) + 10*m1**10*m7**4*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim) - 8*m1**8*m6sq*m7**4*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim) - 20*m1**8*m7**6*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim) + 12*m1**6*m6sq*m7**6*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim) + 20*m1**6*m7**8*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim) - 8*m1**4*m6sq*m7**8*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim) - 10*m1**4*m7**10*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim) + 2*m1sq*m6sq*m7**10*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim) + 2*m1sq*m7**12*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim) - 2*m1**12*m7sq*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim) + 2*m1**10*m6sq*m7sq*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim) - 16*m1**8*m7**4*T134fin(m7,m1,0,mudim) + 16*m1**4*m6**4*m7**4*T134fin(m7,m1,0,mudim) - 16*m1sq*m6**6*m7**4*T134fin(m7,m1,0,mudim) + 16*m1**6*m6sq*m7**4*T134fin(m7,m1,0,mudim) + 24*m1**6*m7**6*T134fin(m7,m1,0,mudim) + 24*m1sq*m6**4*m7**6*T134fin(m7,m1,0,mudim) + 16*m1**4*m6sq*m7**6*T134fin(m7,m1,0,mudim) - 16*m1**4*m7**8*T134fin(m7,m1,0,mudim) - 16*m1sq*m6sq*m7**8*T134fin(m7,m1,0,mudim) + 4*m1sq*m7**10*T134fin(m7,m1,0,mudim) + 4*m1**10*m7sq*T134fin(m7,m1,0,mudim) + 24*m1**6*m6**4*m7sq*T134fin(m7,m1,0,mudim) - 16*m1**4*m6**6*m7sq*T134fin(m7,m1,0,mudim) + 4*m1sq*m6**8*m7sq*T134fin(m7,m1,0,mudim) - 16*m1**8*m6sq*m7sq*T134fin(m7,m1,0,mudim) + 16*m1**8*m7**4*T134fin(m7,m6,m1,mudim) - 24*m1**6*m7**6*T134fin(m7,m6,m1,mudim) + 16*m1**4*m7**8*T134fin(m7,m6,m1,mudim) - 4*m1sq*m7**10*T134fin(m7,m6,m1,mudim) - 4*m1**10*m7sq*T134fin(m7,m6,m1,mudim))/(2.*m1**2*m6**2*(m1 - m7)**4*(m1 + m6 - m7)**2*(m1 + m7)**4*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2)
		def eval_71():
			return (-4*(m1sq + m3sq)*m6**4*(m1sq + m3sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim)) + (4*m1sq*(m1sq*(m1sq - m3sq)**3*B0del(0,0,m1sq,mudim) + m3sq*(-8*m1sq*m6**4 + 2*m6**6)*B0del(0,0,m3sq,mudim) - (m1sq - m3sq)**3*m6sq*B0del(0,0,m6sq,mudim) + (m1sq*(m1sq - m3sq)**3 + m3sq*(-8*m1sq*m6**4 + 2*m6**6) - (m1sq - m3sq)**3*m6sq)*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)) + (-1 + B0fin(0,0,m1sq,mudim))*(m1sq*(m1sq - m3sq)**3*B0fin(0,0,m1sq,mudim) + m3sq*(-8*m1sq*m6**4 + 2*m6**6)*B0fin(0,0,m3sq,mudim) - (m1sq - m3sq)**3*m6sq*B0fin(0,0,m6sq,mudim))))/(4*m1sq - m6sq) + ((m1sq - m3sq)**2*(4*(m1sq - m3sq)*(m1sq - m6sq)*m6sq*B0del(0,0,m6sq,mudim) - 2*(2*m1**6 + 7*m1sq*m6**4 - m6**4*(m3sq + m6sq) - 2*m1**4*(m3sq + 4*m6sq))*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)) + (-2*(2*m1**8 + m1sq*m6**4*(m3sq - m6sq) - 2*m1**6*(m3sq + 3*m6sq) + m1**4*(5*m6**4 - 2*m3sq*m6sq))*B0del(0,0,m1sq,mudim) + 2*(4*m1sq - m6sq)*m6sq*(8*m1**4 - 2*m1sq*m6sq - 2*m3sq*m6sq + (4*m1**4 + m1sq*m6sq + m3sq*m6sq)*B0fin(0,0,m1sq,mudim)))/m1**2 - (2*(-1 + B0fin(0,0,m1sq,mudim))*((2*m1**8 + m1sq*m6**4*(m3sq - m6sq) - 2*m1**6*(m3sq + 3*m6sq) + m1**4*(5*m6**4 - 2*m3sq*m6sq))*B0fin(0,0,m1sq,mudim) + m6sq*(-16*m1**6 + m3sq*m6**4 + m1sq*(m6**4 - 4*m3sq*m6sq) - 2*m1sq*(m1sq - m3sq)*(m1sq - m6sq)*B0fin(0,0,m6sq,mudim))))/m1**2))/(4*m1sq - m6sq) + 4*m6sq*(-m1**4 - m3**4 + m3sq*m6sq + m1sq*(2*m3sq + m6sq))*T134fin(m3,m1,0,mudim) + (4*(m1sq - m3sq)**2*m6sq*(-((m1sq - m3sq)*(2*m1sq + m6sq + 4*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim))) + (-3*m1sq - m3sq + m6sq)*T134fin(m6,m1,m1,mudim)))/(4*m1sq - m6sq) + 4*(m1sq - m3sq)**2*m6sq*T134fin(m6,m3,m1,mudim))/(4.*(m1sq - m3sq)**4*m6**6)
		def eval_72():
			return (2*m1**4*m6**4 + 2*m1sq*m3sq*m6**4 + 2*m1**6*m6sq - 6*m1**4*m3sq*m6sq + (2*m1sq*m3sq*m6**4 + m1**4*(2*m6**4 - 4*m3sq*m6sq))*B0del(0,0,m1sq,mudim) + 2*m1**4*(m1sq - m3sq)*m6sq*B0del(0,0,m6sq,mudim) + 2*m1**4*m6**4*B0fin(0,0,m1sq,mudim) + 2*m1sq*m3sq*m6**4*B0fin(0,0,m1sq,mudim) - 4*m1**4*m3sq*m6sq*B0fin(0,0,m1sq,mudim) + m1**4*m6**4*B0fin(0,0,m1sq,mudim)**2 + m1sq*m3sq*m6**4*B0fin(0,0,m1sq,mudim)**2 - m1**6*m6sq*B0fin(0,0,m1sq,mudim)**2 - m1**4*m3sq*m6sq*B0fin(0,0,m1sq,mudim)**2 + 2*m1**6*m6sq*B0fin(0,0,m6sq,mudim) - 2*m1**4*m3sq*m6sq*B0fin(0,0,m6sq,mudim) + 2*m1**6*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m1**4*m3sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m1**4*m3sq*T134fin(m1,0,0,mudim) - 2*m3sq*m6**4*T134fin(m1,0,0,mudim) + 4*m1sq*m3sq*m6sq*T134fin(m1,0,0,mudim) + 2*m1**6*T134fin(m3,0,0,mudim) + 2*m1sq*m6**4*T134fin(m3,0,0,mudim) - 4*m1**4*m6sq*T134fin(m3,0,0,mudim) - 2*m1sq*m6**4*T134fin(m3,m1,0,mudim) + 2*m1**4*m6sq*T134fin(m3,m1,0,mudim) + 2*m1**4*m3sq*T134fin(m6,m1,0,mudim) - 2*m1**4*m6sq*T134fin(m6,m1,0,mudim) - 2*m1**6*T134fin(m6,m3,0,mudim) + 2*m1**4*m6sq*T134fin(m6,m3,0,mudim))/(2.*m1**4*(m1sq - m3sq)**2*m6**2*(m1sq - m6sq)**2)
		def eval_73():
			return (-2*m1sq*(m2**4*(m1sq - m3sq)**3*B0del(0,0,m2sq,mudim) - (m1sq - m2sq)**3*m3**4*B0del(0,0,m3sq,mudim)) - m1sq*(m2sq - m3sq)*(m1**8 + 3*m2**4*m3**4 + m1**4*(m2sq - m3sq)**2 - 2*m1sq*m2sq*m3sq*(m2sq + m3sq))*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)) - m1sq*(m1sq - m2sq)**2*(m1sq - m3sq)**2*(m2sq - m3sq)*(8 + B0del(0,0,m1sq,mudim) + 4*B0fin(0,0,m1sq,mudim)) + m1sq*(1 - B0fin(0,0,m1sq,mudim))*((m1sq - m2sq)**2*(m1sq - m3sq)**2*(m2sq - m3sq)*(4 + B0fin(0,0,m1sq,mudim)) + 2*(m2**4*(m1sq - m3sq)**3*B0fin(0,0,m2sq,mudim) - (m1sq - m2sq)**3*m3**4*B0fin(0,0,m3sq,mudim))) + 2*m1**4*(m2sq*(m1sq - m3sq)**3*B0del(0,0,m2sq,mudim) - (m1sq - m2sq)**3*m3sq*B0del(0,0,m3sq,mudim) + (m2sq*(m1sq - m3sq)**3 - (m1sq - m2sq)**3*m3sq)*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)) + (-1 + B0fin(0,0,m1sq,mudim))*(m2sq*(m1sq - m3sq)**3*B0fin(0,0,m2sq,mudim) - (m1sq - m2sq)**3*m3sq*B0fin(0,0,m3sq,mudim))) + 2*(m1sq - m2sq)**2*(m1sq - m3sq)**2*(m2sq - m3sq)*T134fin(m1,0,0,mudim) - 2*(m1sq - m2sq)**2*(m1sq - m3sq)**3*T134fin(m2,0,0,mudim) + 2*(m1sq - m2sq)*(m1sq - m3sq)**3*(m1**4 + m1sq*m2sq + 2*m1**4*B0fin(0,0,m1sq,mudim) + 2*m1sq*m2sq*B0fin(0,0,m2sq,mudim) - m2sq*T134fin(m2,m1,0,mudim)) + 2*(m1sq - m2sq)**3*(m1sq - m3sq)**2*T134fin(m3,0,0,mudim) - 2*(m1sq - m2sq)**3*(m1sq - m3sq)*(m1**4 + m1sq*m3sq + 2*m1**4*B0fin(0,0,m1sq,mudim) + 2*m1sq*m3sq*B0fin(0,0,m3sq,mudim) - m3sq*T134fin(m3,m1,0,mudim)))/(2.*m1**4*(m1sq - m2sq)**3*(m1sq - m3sq)**3*(m2sq - m3sq))
		def eval_74():
			return (4*m3sq*m6sq*(-(m4sq*(m5sq - m6sq)**3*B0del(0,0,m4sq,mudim)) + m5sq*(m4sq - m6sq)**3*B0del(0,0,m5sq,mudim) + (m5sq*(m4sq - m6sq)**3 - m4sq*(m5sq - m6sq)**3)*B0del(0,0,m6sq,mudim) + m4sq*(m5sq - m6sq)**3*B0fin(0,0,m4sq,mudim) - m5sq*(m4sq - m6sq)**3*B0fin(0,0,m5sq,mudim) + (-(m5sq*(m4sq - m6sq)**3) + m4sq*(m5sq - m6sq)**3 - m4sq*(m5sq - m6sq)**3*B0fin(0,0,m4sq,mudim) + m5sq*(m4sq - m6sq)**3*B0fin(0,0,m5sq,mudim))*B0fin(0,0,m6sq,mudim)) + (m4sq - m5sq)*(m4sq - m6sq)**2*(m5sq - m6sq)**2*(6*m3sq - 4*m6sq + 2*(m3sq - 2*m6sq)*B0del(0,0,m6sq,mudim) - 2*(3*m3sq + 2*m6sq)*B0fin(0,0,m6sq,mudim) + (m3sq - 2*m6sq)*B0fin(0,0,m6sq,mudim)**2) - 2*(m5sq - m6sq)**3*(m3sq*(m4sq + m6sq)*(m4sq + m6sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)) - (-(m4sq - m6sq)**2 + m3sq*(m4sq + m6sq))*T134fin(m6,m4,0,mudim)) + 2*(m4sq - m6sq)**2*(m5sq - m6sq)**3*T134fin(m6,m4,m3,mudim) + 2*(m4sq - m6sq)**3*(m3sq*(m5sq + m6sq)*(m5sq + m6sq + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)) + ((m5sq - m6sq)**2 - m3sq*(m5sq + m6sq))*T134fin(m6,m5,0,mudim)) - 2*(m4sq - m6sq)**3*(m5sq - m6sq)**2*T134fin(m6,m5,m3,mudim) + 2*(m4sq - m5sq)*(m4sq - m6sq)**2*(m5sq - m6sq)**2*T134fin(m6,m6,m3,mudim))/(2.*m3**4*(m4sq - m5sq)*(m4sq - m6sq)**3*(m5sq - m6sq)**3)
		def eval_75():
			return ((4*m3sq*(m4sq - m5sq)*m5sq*m7sq)/(m5sq - m7sq)**3 + (2*m3sq*m5**4*(m5sq + m7sq))/(m5sq - m7sq)**3 - (2*m3sq*m4sq*m5sq*(m5sq + m7sq))/(m5sq - m7sq)**3 + (2*m3sq*m5sq*m7sq*(m5sq + m7sq))/(m5sq - m7sq)**3 + (2*m3sq*m4sq*m7sq*(m5sq + m7sq))/(-m5sq + m7sq)**3 + (m3sq*(m4sq - m5sq)*m5sq*B0del(0,0,m3sq,mudim))/(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq)) - (2*m3sq*(m4sq - m5sq)*m7sq*B0del(0,0,m3sq,mudim))/(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq)) + (m3sq*(m4sq - m5sq)*(-m3sq + m7sq)*B0del(0,0,m3sq,mudim))/(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq)) - (2*m3sq*m4sq*m7sq*B0del(0,0,m4sq,mudim))/(m4sq - m7sq)**2 - (m3sq*(m4sq - m5sq)*m7**4*B0del(0,0,m5sq,mudim))/(m5sq - m7sq)**3 + (m3sq*m5sq*(-m4sq + m5sq)*m7sq*B0del(0,0,m5sq,mudim))/(m5sq - m7sq)**3 + (2*m3sq*m5sq*m7sq*B0del(0,0,m5sq,mudim))/(m5sq - m7sq)**2 + (m5sq*(-m4sq + m5sq)*m7sq*B0del(0,0,m5sq,mudim))/(m5sq - m7sq)**2 + (m3sq*(m4sq - m5sq)*m5sq*B0del(0,0,m5sq,mudim))/(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq)) + ((m4sq - m5sq)*m5sq*m7sq*B0del(0,0,m5sq,mudim))/(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq)) - (m3sq*(m4sq - m5sq)*m7**4*B0del(0,0,m7sq,mudim))/(m5sq - m7sq)**3 - (2*m3sq*m4sq*m7sq*B0del(0,0,m7sq,mudim))/(m4sq - m7sq)**2 + (m3sq*m5sq*(-m4sq + m5sq)*m7sq*B0del(0,0,m7sq,mudim))/(m5sq - m7sq)**3 + (2*m3sq*m5sq*m7sq*B0del(0,0,m7sq,mudim))/(m5sq - m7sq)**2 + (m5sq*(-m4sq + m5sq)*m7sq*B0del(0,0,m7sq,mudim))/(m5sq - m7sq)**2 - (2*m3sq*(m4sq - m5sq)*m7sq*B0del(0,0,m7sq,mudim))/(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq)) + ((m4sq - m5sq)*m5sq*m7sq*B0del(0,0,m7sq,mudim))/(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq)) + (m3sq*(m4sq - m5sq)*m7sq*(m5**4 - m7**4 + m3sq*m7sq - 4*m5sq*m7sq)*B0del(0,0,m7sq,mudim))/((m5sq - m7sq)**2*(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq))) + (m3sq*m5sq*(-m4sq + m5sq)*B0fin(0,0,m3sq,mudim))/(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq)) + (m3sq*(m4sq - m5sq)*(m3sq - m7sq)*B0fin(0,0,m3sq,mudim))/(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq)) + (2*m3sq*(m4sq - m5sq)*m7sq*B0fin(0,0,m3sq,mudim))/(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq)) + (2*m3sq*m4sq*m7sq*B0fin(0,0,m4sq,mudim))/(m4sq - m7sq)**2 + (m3sq*(m4sq - m5sq)*(-m3sq + m7sq)*(B0del(0,0,m5sq,mudim) - B0fin(0,0,m5sq,mudim)))/(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq)) + (m3sq*(m4sq - m5sq)*m7sq*(m5**4 - m7**4 + m3sq*m7sq - 4*m5sq*m7sq)*(B0del(0,0,m5sq,mudim) - B0fin(0,0,m5sq,mudim)))/((m5sq - m7sq)**2*(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq))) + (m3sq*(m4sq - m5sq)*m7**4*B0fin(0,0,m5sq,mudim))/(m5sq - m7sq)**3 + (3*m3sq*m5sq*(-m4sq + m5sq)*m7sq*B0fin(0,0,m5sq,mudim))/(m5sq - m7sq)**3 - (2*m3sq*m5sq*m7sq*B0fin(0,0,m5sq,mudim))/(m5sq - m7sq)**2 - (m5sq*(-m4sq + m5sq)*m7sq*B0fin(0,0,m5sq,mudim))/(m5sq - m7sq)**2 + (m3sq*m5sq*(-m4sq + m5sq)*B0fin(0,0,m5sq,mudim))/(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq)) + (m5sq*(-m4sq + m5sq)*m7sq*B0fin(0,0,m5sq,mudim))/(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq)) + (m3sq*(m4sq - m5sq)*m5sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim))/(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq)) + (m3sq*(m4sq - m5sq)*(-m3sq + m7sq)*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim))/(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq)) + (m3sq*(m4sq - m5sq)*m7**4*B0fin(0,0,m7sq,mudim))/(m5sq - m7sq)**3 + (2*m3sq*m4sq*m7sq*B0fin(0,0,m7sq,mudim))/(m4sq - m7sq)**2 + (3*m3sq*m5sq*(-m4sq + m5sq)*m7sq*B0fin(0,0,m7sq,mudim))/(m5sq - m7sq)**3 - (2*m3sq*m5sq*m7sq*B0fin(0,0,m7sq,mudim))/(m5sq - m7sq)**2 - (m5sq*(-m4sq + m5sq)*m7sq*B0fin(0,0,m7sq,mudim))/(m5sq - m7sq)**2 + (2*m3sq*(m4sq - m5sq)*m7sq*B0fin(0,0,m7sq,mudim))/(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq)) + (m5sq*(-m4sq + m5sq)*m7sq*B0fin(0,0,m7sq,mudim))/(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq)) - (m3sq*(m4sq - m5sq)*m7sq*(m5**4 - m7**4 + m3sq*m7sq - 4*m5sq*m7sq)*B0fin(0,0,m7sq,mudim))/((m5sq - m7sq)**2*(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq))) - (2*m3sq*(m4sq - m5sq)*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim))/(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq)) - (2*m3sq*m4sq*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/(m4sq - m7sq)**2 - (m3sq*(m4sq - m5sq)*m7**4*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/(m5sq - m7sq)**3 + (m3sq*m5sq*(-m4sq + m5sq)*m7sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/(m5sq - m7sq)**3 + (2*m3sq*m5sq*m7sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/(m5sq - m7sq)**2 + (m5sq*(-m4sq + m5sq)*m7sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/(m5sq - m7sq)**2 + ((m4sq - m5sq)*m5sq*m7sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq)) + (m3sq*(m4sq - m5sq)*m7sq*(m5**4 - m7**4 + m3sq*m7sq - 4*m5sq*m7sq)*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/((m5sq - m7sq)**2*(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq))) - (m3sq*(m4sq + m7sq)*(m4sq + m7sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m4sq - m7sq)**2 + (m3sq*m4sq*m5sq*(m5sq + m7sq + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m5sq - m7sq)**3 - (m4sq*(m5sq + m7sq + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m5sq - m7sq) + (m5sq*(m5sq + m7sq + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m5sq - m7sq) + (m3sq*m5sq*m7sq*(m5sq + m7sq + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m5sq - m7sq)**3 + (m3sq*m7**4*(m5sq + m7sq + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(-m5sq + m7sq)**3 + (m3sq*m4sq*m7sq*(m5sq + m7sq + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(-m5sq + m7sq)**3 + ((m4sq - m5sq)*(-m3sq + m5sq - m7sq)*(m3sq + m5sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq)) - T134fin(m7,m4,0,mudim) + (m3sq*(m4sq + m7sq)*T134fin(m7,m4,0,mudim))/(m4sq - m7sq)**2 + T134fin(m7,m4,m3,mudim) - (m3sq*m5**4*T134fin(m7,m5,0,mudim))/(m5sq - m7sq)**3 + (m3sq*m7**4*T134fin(m7,m5,0,mudim))/(m5sq - m7sq)**3 + (m4sq*T134fin(m7,m5,0,mudim))/(m5sq - m7sq) + (2*m3sq*m4sq*m7sq*T134fin(m7,m5,0,mudim))/(m5sq - m7sq)**3 - (2*m3sq*m5sq*m7sq*T134fin(m7,m5,0,mudim))/(m5sq - m7sq)**3 + (m7sq*T134fin(m7,m5,0,mudim))/(-m5sq + m7sq) - T134fin(m7,m5,m3,mudim) + ((m4sq - m5sq)*(-m3sq + m5sq - m7sq)*T134fin(m7,m5,m3,mudim))/(4*m3sq*m7sq - (m3sq - m5sq + m7sq)**2))/(m3**4*(m4sq - m5sq)**2)
		def eval_76():
			return ((m4sq - m5sq)**2*(m4sq - m6sq)*(m5sq - m6sq)**2*(-6*m3sq + 4*m5sq - 2*(m3sq - 2*m5sq)*B0del(0,0,m5sq,mudim) + (6*m3sq + 4*m5sq)*B0fin(0,0,m5sq,mudim) - (m3sq - 2*m5sq)*B0fin(0,0,m5sq,mudim)**2) - 4*m3sq*m5sq*(m4sq*(m5sq - m6sq)**3*B0del(0,0,m4sq,mudim) + (m4sq - m5sq)**3*m6sq*B0del(0,0,m6sq,mudim) + (m4sq*(m5sq - m6sq)**3 + (m4sq - m5sq)**3*m6sq)*(B0del(0,0,m5sq,mudim) - B0fin(0,0,m5sq,mudim)) + (-1 + B0fin(0,0,m5sq,mudim))*(m4sq*(m5sq - m6sq)**3*B0fin(0,0,m4sq,mudim) + (m4sq - m5sq)**3*m6sq*B0fin(0,0,m6sq,mudim))) - 2*(m5sq - m6sq)**3*(m3sq*(m4sq + m5sq)*(m4sq + m5sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim)) - (-(m4sq - m5sq)**2 + m3sq*(m4sq + m5sq))*T134fin(m5,m4,0,mudim)) + 2*(m4sq - m5sq)**2*(m5sq - m6sq)**3*T134fin(m5,m4,m3,mudim) - 2*(m4sq - m5sq)**2*(m4sq - m6sq)*(m5sq - m6sq)**2*T134fin(m5,m5,m3,mudim) - 2*(m4sq - m5sq)**3*(m3sq*(m5sq + m6sq)*(m5sq + m6sq + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)) + ((m5sq - m6sq)**2 - m3sq*(m5sq + m6sq))*T134fin(m6,m5,0,mudim)) + 2*(m4sq - m5sq)**3*(m5sq - m6sq)**2*T134fin(m6,m5,m3,mudim))/(2.*m3**4*(m4sq - m5sq)**3*(m4sq - m6sq)*(m5sq - m6sq)**3)
		def eval_77():
			return ((-4*m3sq*m4sq*(m4sq - m6sq)*m7sq)/(m4sq - m7sq)**3 + (2*m3sq*m4**4*(m4sq + m7sq))/(m4sq - m7sq)**3 - (2*m3sq*m4sq*m6sq*(m4sq + m7sq))/(m4sq - m7sq)**3 + (2*m3sq*m4sq*m7sq*(m4sq + m7sq))/(m4sq - m7sq)**3 + (2*m3sq*m6sq*m7sq*(m4sq + m7sq))/(-m4sq + m7sq)**3 + (m3sq*m4sq*(-m4sq + m6sq)*B0del(0,0,m3sq,mudim))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) + (m3sq*(m4sq - m6sq)*(m3sq - m7sq)*B0del(0,0,m3sq,mudim))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) + (2*m3sq*(m4sq - m6sq)*m7sq*B0del(0,0,m3sq,mudim))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) + (m3sq*(m4sq - m6sq)*m7**4*B0del(0,0,m4sq,mudim))/(m4sq - m7sq)**3 + (m3sq*m4sq*(m4sq - m6sq)*m7sq*B0del(0,0,m4sq,mudim))/(m4sq - m7sq)**3 + (2*m3sq*m4sq*m7sq*B0del(0,0,m4sq,mudim))/(m4sq - m7sq)**2 + (m4sq*(m4sq - m6sq)*m7sq*B0del(0,0,m4sq,mudim))/(m4sq - m7sq)**2 + (m3sq*m4sq*(-m4sq + m6sq)*B0del(0,0,m4sq,mudim))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) + (m4sq*(-m4sq + m6sq)*m7sq*B0del(0,0,m4sq,mudim))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) - (2*m3sq*m6sq*m7sq*B0del(0,0,m6sq,mudim))/(m6sq - m7sq)**2 + (m3sq*(m4sq - m6sq)*m7**4*B0del(0,0,m7sq,mudim))/(m4sq - m7sq)**3 + (m3sq*m4sq*(m4sq - m6sq)*m7sq*B0del(0,0,m7sq,mudim))/(m4sq - m7sq)**3 + (2*m3sq*m4sq*m7sq*B0del(0,0,m7sq,mudim))/(m4sq - m7sq)**2 + (m4sq*(m4sq - m6sq)*m7sq*B0del(0,0,m7sq,mudim))/(m4sq - m7sq)**2 - (2*m3sq*m6sq*m7sq*B0del(0,0,m7sq,mudim))/(m6sq - m7sq)**2 + (2*m3sq*(m4sq - m6sq)*m7sq*B0del(0,0,m7sq,mudim))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) + (m4sq*(-m4sq + m6sq)*m7sq*B0del(0,0,m7sq,mudim))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) + (m3sq*(m4sq - m6sq)*m7sq*(-m4**4 + m7**4 - m3sq*m7sq + 4*m4sq*m7sq)*B0del(0,0,m7sq,mudim))/((m4sq - m7sq)**2*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m3sq*m4sq*(m4sq - m6sq)*B0fin(0,0,m3sq,mudim))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) - (m3sq*(m4sq - m6sq)*(m3sq - m7sq)*B0fin(0,0,m3sq,mudim))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) - (2*m3sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m3sq,mudim))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) + (m3sq*(m4sq - m6sq)*(m3sq - m7sq)*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) + (m3sq*(m4sq - m6sq)*m7sq*(-m4**4 + m7**4 - m3sq*m7sq + 4*m4sq*m7sq)*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/((m4sq - m7sq)**2*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (m3sq*(m4sq - m6sq)*m7**4*B0fin(0,0,m4sq,mudim))/(m4sq - m7sq)**3 + (3*m3sq*m4sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m4sq,mudim))/(m4sq - m7sq)**3 - (2*m3sq*m4sq*m7sq*B0fin(0,0,m4sq,mudim))/(m4sq - m7sq)**2 - (m4sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m4sq,mudim))/(m4sq - m7sq)**2 + (m3sq*m4sq*(m4sq - m6sq)*B0fin(0,0,m4sq,mudim))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) + (m4sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m4sq,mudim))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) + (m3sq*m4sq*(-m4sq + m6sq)*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) + (m3sq*(m4sq - m6sq)*(m3sq - m7sq)*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) + (2*m3sq*m6sq*m7sq*B0fin(0,0,m6sq,mudim))/(m6sq - m7sq)**2 - (m3sq*(m4sq - m6sq)*m7**4*B0fin(0,0,m7sq,mudim))/(m4sq - m7sq)**3 + (3*m3sq*m4sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m7sq,mudim))/(m4sq - m7sq)**3 - (2*m3sq*m4sq*m7sq*B0fin(0,0,m7sq,mudim))/(m4sq - m7sq)**2 - (m4sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m7sq,mudim))/(m4sq - m7sq)**2 + (2*m3sq*m6sq*m7sq*B0fin(0,0,m7sq,mudim))/(m6sq - m7sq)**2 - (2*m3sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m7sq,mudim))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) + (m4sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m7sq,mudim))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) + (m3sq*(m4sq - m6sq)*m7sq*(m4**4 - m7**4 + m3sq*m7sq - 4*m4sq*m7sq)*B0fin(0,0,m7sq,mudim))/((m4sq - m7sq)**2*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (2*m3sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) + (m3sq*(m4sq - m6sq)*m7**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/(m4sq - m7sq)**3 + (m3sq*m4sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/(m4sq - m7sq)**3 + (2*m3sq*m4sq*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/(m4sq - m7sq)**2 + (m4sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/(m4sq - m7sq)**2 + (m4sq*(-m4sq + m6sq)*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) + (m3sq*(m4sq - m6sq)*m7sq*(-m4**4 + m7**4 - m3sq*m7sq + 4*m4sq*m7sq)*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m4sq - m7sq)**2*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (2*m3sq*m6sq*m7sq*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/(m6sq - m7sq)**2 + (m3sq*m4sq*m6sq*(m4sq + m7sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m4sq - m7sq)**3 + (m4sq*(m4sq + m7sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m4sq - m7sq) - (m6sq*(m4sq + m7sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m4sq - m7sq) + (m3sq*m4sq*m7sq*(m4sq + m7sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m4sq - m7sq)**3 + (m3sq*m7**4*(m4sq + m7sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(-m4sq + m7sq)**3 + (m3sq*m6sq*m7sq*(m4sq + m7sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(-m4sq + m7sq)**3 - ((m4sq - m6sq)*(-m3sq + m4sq - m7sq)*(m3sq + m4sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) - (m3sq*(m6sq + m7sq)*(m6sq + m7sq + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m6sq - m7sq)**2 - (m3sq*m4**4*T134fin(m7,m4,0,mudim))/(m4sq - m7sq)**3 + (m3sq*m7**4*T134fin(m7,m4,0,mudim))/(m4sq - m7sq)**3 + (m6sq*T134fin(m7,m4,0,mudim))/(m4sq - m7sq) - (2*m3sq*m4sq*m7sq*T134fin(m7,m4,0,mudim))/(m4sq - m7sq)**3 + (2*m3sq*m6sq*m7sq*T134fin(m7,m4,0,mudim))/(m4sq - m7sq)**3 + (m7sq*T134fin(m7,m4,0,mudim))/(-m4sq + m7sq) - T134fin(m7,m4,m3,mudim) + ((m4sq - m6sq)*(-m3sq + m4sq - m7sq)*T134fin(m7,m4,m3,mudim))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) - T134fin(m7,m6,0,mudim) + (m3sq*(m6sq + m7sq)*T134fin(m7,m6,0,mudim))/(m6sq - m7sq)**2 + T134fin(m7,m6,m3,mudim))/(m3**4*(m4sq - m6sq)**2)
		def eval_78():
			return ((m4sq - m5sq)**2*(m4sq - m6sq)**2*(m5sq - m6sq)*(6*m3sq - 4*m4sq + 2*(m3sq - 2*m4sq)*B0del(0,0,m4sq,mudim) - 2*(3*m3sq + 2*m4sq)*B0fin(0,0,m4sq,mudim) + (m3sq - 2*m4sq)*B0fin(0,0,m4sq,mudim)**2) + 4*m3sq*m4sq*(m5sq*(m4sq - m6sq)**3*B0del(0,0,m5sq,mudim) - (m4sq - m5sq)**3*m6sq*B0del(0,0,m6sq,mudim) + (m5sq*(m4sq - m6sq)**3 - (m4sq - m5sq)**3*m6sq)*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)) + (-1 + B0fin(0,0,m4sq,mudim))*(m5sq*(m4sq - m6sq)**3*B0fin(0,0,m5sq,mudim) - (m4sq - m5sq)**3*m6sq*B0fin(0,0,m6sq,mudim))) + 2*(m4sq - m5sq)**2*(m4sq - m6sq)**2*(m5sq - m6sq)*T134fin(m4,m4,m3,mudim) + 2*(m4sq - m6sq)**3*(m3sq*(m4sq + m5sq)*(m4sq + m5sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim)) + ((m4sq - m5sq)**2 - m3sq*(m4sq + m5sq))*T134fin(m5,m4,0,mudim)) - 2*(m4sq - m5sq)**2*(m4sq - m6sq)**3*T134fin(m5,m4,m3,mudim) - 2*(m4sq - m5sq)**3*(m3sq*(m4sq + m6sq)*(m4sq + m6sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)) + ((m4sq - m6sq)**2 - m3sq*(m4sq + m6sq))*T134fin(m6,m4,0,mudim)) + 2*(m4sq - m5sq)**3*(m4sq - m6sq)**2*T134fin(m6,m4,m3,mudim))/(2.*m3**4*(m4sq - m5sq)**3*(m4sq - m6sq)**3*(m5sq - m6sq))
		def eval_79():
			return (4*m3sq*m6sq*(-(m1sq*(m2sq - m3sq)**3*B0del(0,0,m1sq,mudim)) + m2sq*(m1sq - m3sq)**3*B0del(0,0,m2sq,mudim) + (m2sq*(m1sq - m3sq)**3 - m1sq*(m2sq - m3sq)**3)*B0del(0,0,m3sq,mudim) + m1sq*(m2sq - m3sq)**3*B0fin(0,0,m1sq,mudim) - m2sq*(m1sq - m3sq)**3*B0fin(0,0,m2sq,mudim) + (-(m2sq*(m1sq - m3sq)**3) + m1sq*(m2sq - m3sq)**3 - m1sq*(m2sq - m3sq)**3*B0fin(0,0,m1sq,mudim) + m2sq*(m1sq - m3sq)**3*B0fin(0,0,m2sq,mudim))*B0fin(0,0,m3sq,mudim)) - (m1sq - m2sq)*(m1sq - m3sq)**2*(m2sq - m3sq)**2*(4*m3sq - 6*m6sq + (4*m3sq - 2*m6sq)*B0del(0,0,m3sq,mudim) + (4*m3sq + 6*m6sq)*B0fin(0,0,m3sq,mudim) + (2*m3sq - m6sq)*B0fin(0,0,m3sq,mudim)**2) + 2*(m2sq - m3sq)**3*(-((m1sq + m3sq)*m6sq*(m1sq + m3sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim))) + (-m1**4 - m3**4 + m3sq*m6sq + m1sq*(2*m3sq + m6sq))*T134fin(m3,m1,0,mudim)) + 2*(m1sq - m3sq)**3*((m2sq + m3sq)*m6sq*(m2sq + m3sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim)) + (m2**4 + m3**4 - m3sq*m6sq - m2sq*(2*m3sq + m6sq))*T134fin(m3,m2,0,mudim)) + 2*(m1sq - m3sq)**2*(m2sq - m3sq)**3*T134fin(m6,m3,m1,mudim) - 2*(m1sq - m3sq)**3*(m2sq - m3sq)**2*T134fin(m6,m3,m2,mudim) + 2*(m1sq - m2sq)*(m1sq - m3sq)**2*(m2sq - m3sq)**2*T134fin(m6,m3,m3,mudim))/(2.*(m1sq - m2sq)*(m1sq - m3sq)**3*(m2sq - m3sq)**3*m6**4)
		def eval_80():
			return ((4*(m1sq - m2sq)*m2sq*m6sq*m7sq)/(m2sq - m7sq)**3 + (2*m2**4*m6sq*(m2sq + m7sq))/(m2sq - m7sq)**3 - (2*m1sq*m2sq*m6sq*(m2sq + m7sq))/(m2sq - m7sq)**3 + (2*m2sq*m6sq*m7sq*(m2sq + m7sq))/(m2sq - m7sq)**3 + (2*m1sq*m6sq*m7sq*(m2sq + m7sq))/(-m2sq + m7sq)**3 - (2*m1sq*m6sq*m7sq*B0del(0,0,m1sq,mudim))/(m1sq - m7sq)**2 - ((m1sq - m2sq)*m6sq*m7**4*B0del(0,0,m2sq,mudim))/(m2sq - m7sq)**3 + (m2sq*(-m1sq + m2sq)*m6sq*m7sq*B0del(0,0,m2sq,mudim))/(m2sq - m7sq)**3 + (m2sq*(-m1sq + m2sq)*m7sq*B0del(0,0,m2sq,mudim))/(m2sq - m7sq)**2 + (2*m2sq*m6sq*m7sq*B0del(0,0,m2sq,mudim))/(m2sq - m7sq)**2 + ((m1sq - m2sq)*m2sq*m6sq*B0del(0,0,m2sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + ((m1sq - m2sq)*m2sq*m7sq*B0del(0,0,m2sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + ((m1sq - m2sq)*m2sq*m6sq*B0del(0,0,m6sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) - (2*(m1sq - m2sq)*m6sq*m7sq*B0del(0,0,m6sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + ((m1sq - m2sq)*m6sq*(-m6sq + m7sq)*B0del(0,0,m6sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) - ((m1sq - m2sq)*m6sq*m7**4*B0del(0,0,m7sq,mudim))/(m2sq - m7sq)**3 - (2*m1sq*m6sq*m7sq*B0del(0,0,m7sq,mudim))/(m1sq - m7sq)**2 + (m2sq*(-m1sq + m2sq)*m6sq*m7sq*B0del(0,0,m7sq,mudim))/(m2sq - m7sq)**3 + (m2sq*(-m1sq + m2sq)*m7sq*B0del(0,0,m7sq,mudim))/(m2sq - m7sq)**2 + (2*m2sq*m6sq*m7sq*B0del(0,0,m7sq,mudim))/(m2sq - m7sq)**2 + ((m1sq - m2sq)*m2sq*m7sq*B0del(0,0,m7sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) - (2*(m1sq - m2sq)*m6sq*m7sq*B0del(0,0,m7sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + ((m1sq - m2sq)*m6sq*m7sq*(m2**4 - m7**4 - 4*m2sq*m7sq + m6sq*m7sq)*B0del(0,0,m7sq,mudim))/((m2sq - m7sq)**2*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + (2*m1sq*m6sq*m7sq*B0fin(0,0,m1sq,mudim))/(m1sq - m7sq)**2 + ((m1sq - m2sq)*m6sq*(-m6sq + m7sq)*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + ((m1sq - m2sq)*m6sq*m7sq*(m2**4 - m7**4 - 4*m2sq*m7sq + m6sq*m7sq)*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)))/((m2sq - m7sq)**2*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + ((m1sq - m2sq)*m6sq*m7**4*B0fin(0,0,m2sq,mudim))/(m2sq - m7sq)**3 + (3*m2sq*(-m1sq + m2sq)*m6sq*m7sq*B0fin(0,0,m2sq,mudim))/(m2sq - m7sq)**3 - (m2sq*(-m1sq + m2sq)*m7sq*B0fin(0,0,m2sq,mudim))/(m2sq - m7sq)**2 - (2*m2sq*m6sq*m7sq*B0fin(0,0,m2sq,mudim))/(m2sq - m7sq)**2 + (m2sq*(-m1sq + m2sq)*m6sq*B0fin(0,0,m2sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + (m2sq*(-m1sq + m2sq)*m7sq*B0fin(0,0,m2sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + (m2sq*(-m1sq + m2sq)*m6sq*B0fin(0,0,m6sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + ((m1sq - m2sq)*m6sq*(m6sq - m7sq)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + (2*(m1sq - m2sq)*m6sq*m7sq*B0fin(0,0,m6sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + ((m1sq - m2sq)*m2sq*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + ((m1sq - m2sq)*m6sq*(-m6sq + m7sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + ((m1sq - m2sq)*m6sq*m7**4*B0fin(0,0,m7sq,mudim))/(m2sq - m7sq)**3 + (2*m1sq*m6sq*m7sq*B0fin(0,0,m7sq,mudim))/(m1sq - m7sq)**2 + (3*m2sq*(-m1sq + m2sq)*m6sq*m7sq*B0fin(0,0,m7sq,mudim))/(m2sq - m7sq)**3 - (m2sq*(-m1sq + m2sq)*m7sq*B0fin(0,0,m7sq,mudim))/(m2sq - m7sq)**2 - (2*m2sq*m6sq*m7sq*B0fin(0,0,m7sq,mudim))/(m2sq - m7sq)**2 + (m2sq*(-m1sq + m2sq)*m7sq*B0fin(0,0,m7sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + (2*(m1sq - m2sq)*m6sq*m7sq*B0fin(0,0,m7sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) - ((m1sq - m2sq)*m6sq*m7sq*(m2**4 - m7**4 - 4*m2sq*m7sq + m6sq*m7sq)*B0fin(0,0,m7sq,mudim))/((m2sq - m7sq)**2*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) - (2*m1sq*m6sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/(m1sq - m7sq)**2 - ((m1sq - m2sq)*m6sq*m7**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/(m2sq - m7sq)**3 + (m2sq*(-m1sq + m2sq)*m6sq*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/(m2sq - m7sq)**3 + (m2sq*(-m1sq + m2sq)*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/(m2sq - m7sq)**2 + (2*m2sq*m6sq*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/(m2sq - m7sq)**2 + ((m1sq - m2sq)*m2sq*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + ((m1sq - m2sq)*m6sq*m7sq*(m2**4 - m7**4 - 4*m2sq*m7sq + m6sq*m7sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2sq - m7sq)**2*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) - (2*(m1sq - m2sq)*m6sq*m7sq*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) - (m1sq*m6sq*(m1sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m1sq - m7sq)**2 - (m6sq*m7sq*(m1sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m1sq - m7sq)**2 - (m1sq*m2**4*(m2sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m2sq - m7sq)**3 + (m2**6*(m2sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m2sq - m7sq)**3 + (m1sq*m2sq*m6sq*(m2sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m2sq - m7sq)**3 + (m2sq*m7**4*(m2sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m2sq - m7sq)**3 - (2*m2**4*m7sq*(m2sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m2sq - m7sq)**3 + (2*m1sq*m2sq*m7sq*(m2sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m2sq - m7sq)**3 + (m2sq*m6sq*m7sq*(m2sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m2sq - m7sq)**3 + (m1sq*m7**4*(m2sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(-m2sq + m7sq)**3 + (m6sq*m7**4*(m2sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(-m2sq + m7sq)**3 + (m1sq*m6sq*m7sq*(m2sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(-m2sq + m7sq)**3 + ((m1sq - m2sq)*(m2sq - m6sq - m7sq)*(m2sq + m6sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) - (m1**4*T134fin(m7,m1,0,mudim))/(m1sq - m7sq)**2 + (m1sq*m6sq*T134fin(m7,m1,0,mudim))/(m1sq - m7sq)**2 - (m7**4*T134fin(m7,m1,0,mudim))/(m1sq - m7sq)**2 + (2*m1sq*m7sq*T134fin(m7,m1,0,mudim))/(m1sq - m7sq)**2 + (m6sq*m7sq*T134fin(m7,m1,0,mudim))/(m1sq - m7sq)**2 + (m1sq*m2**4*T134fin(m7,m2,0,mudim))/(m2sq - m7sq)**3 - (m2**4*m6sq*T134fin(m7,m2,0,mudim))/(m2sq - m7sq)**3 + (m1sq*m7**4*T134fin(m7,m2,0,mudim))/(m2sq - m7sq)**3 + (2*m2sq*m7**4*T134fin(m7,m2,0,mudim))/(m2sq - m7sq)**3 + (m6sq*m7**4*T134fin(m7,m2,0,mudim))/(m2sq - m7sq)**3 - (m2**4*m7sq*T134fin(m7,m2,0,mudim))/(m2sq - m7sq)**3 - (2*m1sq*m2sq*m7sq*T134fin(m7,m2,0,mudim))/(m2sq - m7sq)**3 + (2*m1sq*m6sq*m7sq*T134fin(m7,m2,0,mudim))/(m2sq - m7sq)**3 - (2*m2sq*m6sq*m7sq*T134fin(m7,m2,0,mudim))/(m2sq - m7sq)**3 + (m7**6*T134fin(m7,m2,0,mudim))/(-m2sq + m7sq)**3 + T134fin(m7,m6,m1,mudim) - T134fin(m7,m6,m2,mudim) + ((m1sq - m2sq)*(m2sq - m6sq - m7sq)*T134fin(m7,m6,m2,mudim))/(4*m6sq*m7sq - (-m2sq + m6sq + m7sq)**2))/((m1sq - m2sq)**2*m6**4)
		def eval_81():
			return ((m1sq - m2sq)**2*(m1sq - m3sq)*(m2sq - m3sq)**2*(4*m2sq - 6*m6sq + (4*m2sq - 2*m6sq)*B0del(0,0,m2sq,mudim) + (4*m2sq + 6*m6sq)*B0fin(0,0,m2sq,mudim) + (2*m2sq - m6sq)*B0fin(0,0,m2sq,mudim)**2) - 4*m2sq*m6sq*(m1sq*(m2sq - m3sq)**3*B0del(0,0,m1sq,mudim) + (m1sq - m2sq)**3*m3sq*B0del(0,0,m3sq,mudim) + (m1sq*(m2sq - m3sq)**3 + (m1sq - m2sq)**3*m3sq)*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)) + (-1 + B0fin(0,0,m2sq,mudim))*(m1sq*(m2sq - m3sq)**3*B0fin(0,0,m1sq,mudim) + (m1sq - m2sq)**3*m3sq*B0fin(0,0,m3sq,mudim))) + 2*(m2sq - m3sq)**3*(-((m1sq + m2sq)*m6sq*(m1sq + m2sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim))) + (-m1**4 - m2**4 + m2sq*m6sq + m1sq*(2*m2sq + m6sq))*T134fin(m2,m1,0,mudim)) - 2*(m1sq - m2sq)**3*((m2sq + m3sq)*m6sq*(m2sq + m3sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim)) + (m2**4 + m3**4 - m3sq*m6sq - m2sq*(2*m3sq + m6sq))*T134fin(m3,m2,0,mudim)) + 2*(m1sq - m2sq)**2*(m2sq - m3sq)**3*T134fin(m6,m2,m1,mudim) - 2*(m1sq - m2sq)**2*(m1sq - m3sq)*(m2sq - m3sq)**2*T134fin(m6,m2,m2,mudim) + 2*(m1sq - m2sq)**3*(m2sq - m3sq)**2*T134fin(m6,m3,m2,mudim))/(2.*(m1sq - m2sq)**3*(m1sq - m3sq)*(m2sq - m3sq)**3*m6**4)
		def eval_82():
			return ((-4*m1sq*(m1sq - m3sq)*m6sq*m7sq)/(m1sq - m7sq)**3 + (2*m1**4*m6sq*(m1sq + m7sq))/(m1sq - m7sq)**3 - (2*m1sq*m3sq*m6sq*(m1sq + m7sq))/(m1sq - m7sq)**3 + (2*m1sq*m6sq*m7sq*(m1sq + m7sq))/(m1sq - m7sq)**3 + (2*m3sq*m6sq*m7sq*(m1sq + m7sq))/(-m1sq + m7sq)**3 + ((m1sq - m3sq)*m6sq*m7**4*B0del(0,0,m1sq,mudim))/(m1sq - m7sq)**3 + (m1sq*(m1sq - m3sq)*m6sq*m7sq*B0del(0,0,m1sq,mudim))/(m1sq - m7sq)**3 + (m1sq*(m1sq - m3sq)*m7sq*B0del(0,0,m1sq,mudim))/(m1sq - m7sq)**2 + (2*m1sq*m6sq*m7sq*B0del(0,0,m1sq,mudim))/(m1sq - m7sq)**2 + (m1sq*(-m1sq + m3sq)*m6sq*B0del(0,0,m1sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (m1sq*(-m1sq + m3sq)*m7sq*B0del(0,0,m1sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) - (2*m3sq*m6sq*m7sq*B0del(0,0,m3sq,mudim))/(m3sq - m7sq)**2 + (m1sq*(-m1sq + m3sq)*m6sq*B0del(0,0,m6sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + ((m1sq - m3sq)*m6sq*(m6sq - m7sq)*B0del(0,0,m6sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (2*(m1sq - m3sq)*m6sq*m7sq*B0del(0,0,m6sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + ((m1sq - m3sq)*m6sq*m7**4*B0del(0,0,m7sq,mudim))/(m1sq - m7sq)**3 + (m1sq*(m1sq - m3sq)*m6sq*m7sq*B0del(0,0,m7sq,mudim))/(m1sq - m7sq)**3 + (m1sq*(m1sq - m3sq)*m7sq*B0del(0,0,m7sq,mudim))/(m1sq - m7sq)**2 + (2*m1sq*m6sq*m7sq*B0del(0,0,m7sq,mudim))/(m1sq - m7sq)**2 - (2*m3sq*m6sq*m7sq*B0del(0,0,m7sq,mudim))/(m3sq - m7sq)**2 + (m1sq*(-m1sq + m3sq)*m7sq*B0del(0,0,m7sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (2*(m1sq - m3sq)*m6sq*m7sq*B0del(0,0,m7sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + ((m1sq - m3sq)*m6sq*m7sq*(-m1**4 + m7**4 + 4*m1sq*m7sq - m6sq*m7sq)*B0del(0,0,m7sq,mudim))/((m1sq - m7sq)**2*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + ((m1sq - m3sq)*m6sq*(m6sq - m7sq)*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + ((m1sq - m3sq)*m6sq*m7sq*(-m1**4 + m7**4 + 4*m1sq*m7sq - m6sq*m7sq)*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/((m1sq - m7sq)**2*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - ((m1sq - m3sq)*m6sq*m7**4*B0fin(0,0,m1sq,mudim))/(m1sq - m7sq)**3 + (3*m1sq*(m1sq - m3sq)*m6sq*m7sq*B0fin(0,0,m1sq,mudim))/(m1sq - m7sq)**3 - (m1sq*(m1sq - m3sq)*m7sq*B0fin(0,0,m1sq,mudim))/(m1sq - m7sq)**2 - (2*m1sq*m6sq*m7sq*B0fin(0,0,m1sq,mudim))/(m1sq - m7sq)**2 + (m1sq*(m1sq - m3sq)*m6sq*B0fin(0,0,m1sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (m1sq*(m1sq - m3sq)*m7sq*B0fin(0,0,m1sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (2*m3sq*m6sq*m7sq*B0fin(0,0,m3sq,mudim))/(m3sq - m7sq)**2 + (m1sq*(m1sq - m3sq)*m6sq*B0fin(0,0,m6sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) - ((m1sq - m3sq)*m6sq*(m6sq - m7sq)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) - (2*(m1sq - m3sq)*m6sq*m7sq*B0fin(0,0,m6sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (m1sq*(-m1sq + m3sq)*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + ((m1sq - m3sq)*m6sq*(m6sq - m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) - ((m1sq - m3sq)*m6sq*m7**4*B0fin(0,0,m7sq,mudim))/(m1sq - m7sq)**3 + (3*m1sq*(m1sq - m3sq)*m6sq*m7sq*B0fin(0,0,m7sq,mudim))/(m1sq - m7sq)**3 - (m1sq*(m1sq - m3sq)*m7sq*B0fin(0,0,m7sq,mudim))/(m1sq - m7sq)**2 - (2*m1sq*m6sq*m7sq*B0fin(0,0,m7sq,mudim))/(m1sq - m7sq)**2 + (2*m3sq*m6sq*m7sq*B0fin(0,0,m7sq,mudim))/(m3sq - m7sq)**2 + (m1sq*(m1sq - m3sq)*m7sq*B0fin(0,0,m7sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) - (2*(m1sq - m3sq)*m6sq*m7sq*B0fin(0,0,m7sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + ((m1sq - m3sq)*m6sq*m7sq*(m1**4 - m7**4 - 4*m1sq*m7sq + m6sq*m7sq)*B0fin(0,0,m7sq,mudim))/((m1sq - m7sq)**2*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + ((m1sq - m3sq)*m6sq*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/(m1sq - m7sq)**3 + (m1sq*(m1sq - m3sq)*m6sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/(m1sq - m7sq)**3 + (m1sq*(m1sq - m3sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/(m1sq - m7sq)**2 + (2*m1sq*m6sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/(m1sq - m7sq)**2 + (m1sq*(-m1sq + m3sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + ((m1sq - m3sq)*m6sq*m7sq*(-m1**4 + m7**4 + 4*m1sq*m7sq - m6sq*m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m7sq)**2*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (2*m3sq*m6sq*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim))/(m3sq - m7sq)**2 + (2*(m1sq - m3sq)*m6sq*m7sq*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (m1**6*(m1sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m1sq - m7sq)**3 - (m1**4*m3sq*(m1sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m1sq - m7sq)**3 + (m1sq*m3sq*m6sq*(m1sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m1sq - m7sq)**3 + (m1sq*m7**4*(m1sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m1sq - m7sq)**3 - (2*m1**4*m7sq*(m1sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m1sq - m7sq)**3 + (2*m1sq*m3sq*m7sq*(m1sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m1sq - m7sq)**3 + (m1sq*m6sq*m7sq*(m1sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m1sq - m7sq)**3 + (m3sq*m7**4*(m1sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(-m1sq + m7sq)**3 + (m6sq*m7**4*(m1sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(-m1sq + m7sq)**3 + (m3sq*m6sq*m7sq*(m1sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(-m1sq + m7sq)**3 - (m3sq*m6sq*(m3sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m3sq - m7sq)**2 - (m6sq*m7sq*(m3sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m3sq - m7sq)**2 - ((m1sq - m3sq)*(m1sq - m6sq - m7sq)*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (m1**4*m3sq*T134fin(m7,m1,0,mudim))/(m1sq - m7sq)**3 - (m1**4*m6sq*T134fin(m7,m1,0,mudim))/(m1sq - m7sq)**3 + (2*m1sq*m7**4*T134fin(m7,m1,0,mudim))/(m1sq - m7sq)**3 + (m3sq*m7**4*T134fin(m7,m1,0,mudim))/(m1sq - m7sq)**3 + (m6sq*m7**4*T134fin(m7,m1,0,mudim))/(m1sq - m7sq)**3 - (m1**4*m7sq*T134fin(m7,m1,0,mudim))/(m1sq - m7sq)**3 - (2*m1sq*m3sq*m7sq*T134fin(m7,m1,0,mudim))/(m1sq - m7sq)**3 - (2*m1sq*m6sq*m7sq*T134fin(m7,m1,0,mudim))/(m1sq - m7sq)**3 + (2*m3sq*m6sq*m7sq*T134fin(m7,m1,0,mudim))/(m1sq - m7sq)**3 + (m7**6*T134fin(m7,m1,0,mudim))/(-m1sq + m7sq)**3 - (m3**4*T134fin(m7,m3,0,mudim))/(m3sq - m7sq)**2 + (m3sq*m6sq*T134fin(m7,m3,0,mudim))/(m3sq - m7sq)**2 - (m7**4*T134fin(m7,m3,0,mudim))/(m3sq - m7sq)**2 + (2*m3sq*m7sq*T134fin(m7,m3,0,mudim))/(m3sq - m7sq)**2 + (m6sq*m7sq*T134fin(m7,m3,0,mudim))/(m3sq - m7sq)**2 - T134fin(m7,m6,m1,mudim) + ((m1sq - m3sq)*(m1sq - m6sq - m7sq)*T134fin(m7,m6,m1,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + T134fin(m7,m6,m3,mudim))/((m1sq - m3sq)**2*m6**4)
		def eval_83():
			return (-((m1sq - m2sq)**2*(m1sq - m3sq)**2*(m2sq - m3sq)*(4*m1sq - 6*m6sq + (4*m1sq - 2*m6sq)*B0del(0,0,m1sq,mudim) + (4*m1sq + 6*m6sq)*B0fin(0,0,m1sq,mudim) + (2*m1sq - m6sq)*B0fin(0,0,m1sq,mudim)**2)) + 4*m1sq*m6sq*(m2sq*(m1sq - m3sq)**3*B0del(0,0,m2sq,mudim) - (m1sq - m2sq)**3*m3sq*B0del(0,0,m3sq,mudim) + (m2sq*(m1sq - m3sq)**3 - (m1sq - m2sq)**3*m3sq)*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)) + (-1 + B0fin(0,0,m1sq,mudim))*(m2sq*(m1sq - m3sq)**3*B0fin(0,0,m2sq,mudim) - (m1sq - m2sq)**3*m3sq*B0fin(0,0,m3sq,mudim))) + 2*(m1sq - m3sq)**3*((m1sq + m2sq)*m6sq*(m1sq + m2sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim)) + (m1**4 + m2**4 - m2sq*m6sq - m1sq*(2*m2sq + m6sq))*T134fin(m2,m1,0,mudim)) - 2*(m1sq - m2sq)**3*((m1sq + m3sq)*m6sq*(m1sq + m3sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim)) + (m1**4 + m3**4 - m3sq*m6sq - m1sq*(2*m3sq + m6sq))*T134fin(m3,m1,0,mudim)) + 2*(m1sq - m2sq)**2*(m1sq - m3sq)**2*(m2sq - m3sq)*T134fin(m6,m1,m1,mudim) - 2*(m1sq - m2sq)**2*(m1sq - m3sq)**3*T134fin(m6,m2,m1,mudim) + 2*(m1sq - m2sq)**3*(m1sq - m3sq)**2*T134fin(m6,m3,m1,mudim))/(2.*(m1sq - m2sq)**3*(m1sq - m3sq)**3*(m2sq - m3sq)*m6**4)
		def eval_84():
			return (-32 + 3*B0del(0,0,m1sq,mudim)*(2 + B0fin(0,0,m1sq,mudim)))/(384.*m1**6)
		def eval_85():
			return ((m1sq - m2sq)**2*B0del(0,0,m2sq,mudim) - 8*(m1**4 - m2**4 + 2*m1sq*m2sq*B0fin(0,0,m1sq,mudim) - 2*m1sq*m2sq*B0fin(0,0,m2sq,mudim)))/(32.*(m1 - m2)**3*m2**4*(m1 + m2)**3)
		def eval_86():
			return (2*m2**8 + 68*m2**4*m4**4 - 96*m2sq*m4**6 + 48*m4**8 - 22*m2**6*m4sq - 12*m2sq*m4**4*(m2sq - 2*m4sq)*B0del(0,0,m2sq,mudim) - 24*m4**6*(m2sq - 2*m4sq)*B0del(0,0,m4sq,mudim) + m2**8*B0fin(0,0,m2sq,mudim) + 16*m2**4*m4**4*B0fin(0,0,m2sq,mudim) - 24*m2sq*m4**6*B0fin(0,0,m2sq,mudim) - 8*m2**6*m4sq*B0fin(0,0,m2sq,mudim) - m2**8*B0fin(0,0,m4sq,mudim) - 28*m2**4*m4**4*B0fin(0,0,m4sq,mudim) + 24*m2sq*m4**6*B0fin(0,0,m4sq,mudim) + 48*m4**8*B0fin(0,0,m4sq,mudim) + 8*m2**6*m4sq*B0fin(0,0,m4sq,mudim) - 12*m2**4*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 24*m2sq*m4**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 6*m2**4*m4**4*B0fin(0,0,m4sq,mudim)**2 - 24*m2sq*m4**6*B0fin(0,0,m4sq,mudim)**2 + 24*m4**8*B0fin(0,0,m4sq,mudim)**2 + 12*m2sq*m4**4*T134fin(m4,m4,m2,mudim) - 24*m4**6*T134fin(m4,m4,m2,mudim))/(2.*m2**6*m4**2*(m2sq - 4*m4sq)**3)
		def eval_87():
			return (2*(m1sq - m3sq) + (m1sq + m3sq)*B0fin(0,0,m1sq,mudim) - (m1sq + m3sq)*B0fin(0,0,m3sq,mudim))/(2.*(m1 - m3)**3*m3**2*(m1 + m3)**3)
		def eval_88():
			return (-(m1sq - m2sq)**2 + m1sq*m2sq*B0fin(0,0,m1sq,mudim)**2 - 2*m1sq*m2sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + m1sq*m2sq*B0fin(0,0,m2sq,mudim)**2)/(m2**2*(m1sq - m2sq)**4)
		def eval_89():
			return -0.5*((B0fin(0,0,m1sq,mudim) - B0fin(0,0,m3sq,mudim))*(2*(m1sq - m3sq) + (m1sq + m3sq)*B0fin(0,0,m1sq,mudim) - (m1sq + m3sq)*B0fin(0,0,m3sq,mudim)))/((m1 - m3)**4*(m1 + m3)**4)
		def eval_90():
			return -0.5*((B0fin(0,0,m1sq,mudim) - B0fin(0,0,m2sq,mudim))*(2*(m1sq - m2sq) + (m1sq + m2sq)*B0fin(0,0,m1sq,mudim) - (m1sq + m2sq)*B0fin(0,0,m2sq,mudim)))/((m1 - m2)**4*(m1 + m2)**4)
		def eval_91():
			return (-48*m1**8 - 68*m1**4*m5**4 + 22*m1sq*m5**6 - 2*m5**8 + 96*m1**6*m5sq + 24*m1**6*(-2*m1sq + m5sq)*B0del(0,0,m1sq,mudim) + 12*m1**4*m5sq*(-2*m1sq + m5sq)*B0del(0,0,m5sq,mudim) - 48*m1**8*B0fin(0,0,m1sq,mudim) + 28*m1**4*m5**4*B0fin(0,0,m1sq,mudim) - 8*m1sq*m5**6*B0fin(0,0,m1sq,mudim) + m5**8*B0fin(0,0,m1sq,mudim) - 24*m1**6*m5sq*B0fin(0,0,m1sq,mudim) - 24*m1**8*B0fin(0,0,m1sq,mudim)**2 - 6*m1**4*m5**4*B0fin(0,0,m1sq,mudim)**2 + 24*m1**6*m5sq*B0fin(0,0,m1sq,mudim)**2 - 16*m1**4*m5**4*B0fin(0,0,m5sq,mudim) + 8*m1sq*m5**6*B0fin(0,0,m5sq,mudim) - m5**8*B0fin(0,0,m5sq,mudim) + 24*m1**6*m5sq*B0fin(0,0,m5sq,mudim) + 12*m1**4*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 24*m1**6*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 24*m1**6*T134fin(m5,m1,m1,mudim) - 12*m1**4*m5sq*T134fin(m5,m1,m1,mudim))/(2.*m1**2*m5**6*(4*m1sq - m5sq)**3)
		def eval_92():
			return (2*(m1sq - m5sq) + (m1sq + m5sq)*B0fin(0,0,m1sq,mudim) - (m1sq + m5sq)*B0fin(0,0,m5sq,mudim))/(2.*m1**2*(m1 - m5)**3*(m1 + m5)**3)
		def eval_93():
			return (2*(m1sq - m2sq) + (m1sq + m2sq)*B0fin(0,0,m1sq,mudim) - (m1sq + m2sq)*B0fin(0,0,m2sq,mudim))/(2.*m1**2*(m1 - m2)**3*(m1 + m2)**3)
		def eval_94():
			return -0.03125*((m1sq - m6sq)**2*B0del(0,0,m1sq,mudim) + 8*(m1**4 - m6**4 + 2*m1sq*m6sq*B0fin(0,0,m1sq,mudim) - 2*m1sq*m6sq*B0fin(0,0,m6sq,mudim)))/(m1**4*(m1 - m6)**3*(m1 + m6)**3)
		def eval_95():
			return -0.03125*((m1sq - m3sq)**2*B0del(0,0,m1sq,mudim) + 8*(m1**4 - m3**4 + 2*m1sq*m3sq*B0fin(0,0,m1sq,mudim) - 2*m1sq*m3sq*B0fin(0,0,m3sq,mudim)))/(m1**4*(m1 - m3)**3*(m1 + m3)**3)
		def eval_96():
			return ((2*(6 + 2*B0del(0,0,m4sq,mudim) - 6*B0fin(0,0,m4sq,mudim) + B0fin(0,0,m4sq,mudim)**2))/(m2**2*m3**2*m4**2) + (2*(m4sq*(m2**6*(m3**8 - 48*m3**4*m4**4 + 192*m3sq*m4**6 + 128*m4**8) + 24*m2sq*m3**4*m4**4*(m3sq - 4*m4sq)**2 + 16*m3**4*m4**6*(m3sq - 4*m4sq)**2 - m2**8*(m3**6 + 24*m3sq*m4**4 + 16*m4**6 - 8*m3**4*m4sq) - 8*m2**4*m4sq*(m3**8 + 48*m3sq*m4**6 + 32*m4**8 - 6*m3**6*m4sq))*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)) + (-1 + B0fin(0,0,m4sq,mudim))*(16*m2sq*m3**4*m4**6*(m3sq - 4*m4sq)**2*B0fin(0,0,m2sq,mudim) - 16*m2**4*m3sq*m4**6*(m2sq - 4*m4sq)**2*B0fin(0,0,m3sq,mudim) - (m2sq - m3sq)*m4sq*(-2*m2sq*m3sq*(12*m4**4*(m3sq - 4*m4sq)**2 - 2*m2sq*(-38*m3sq*m4**4 + 48*m4**6 + 5*m3**4*m4sq) + m2**4*(m3**4 + 12*m4**4 - 10*m3sq*m4sq)) + (16*m4**6*(m3**3 - 4*m3*m4sq)**2 + m2**6*(m3**6 + 8*m3sq*m4**4 + 16*m4**6 - 8*m3**4*m4sq) - 8*m2**4*m4sq*(m3**6 + 6*m3sq*m4**4 + 16*m4**6 - 7*m3**4*m4sq) + 8*m2sq*m4**4*(m3**6 + 32*m4**6 - 6*m3**4*m4sq))*B0fin(0,0,m4sq,mudim))) + m4sq*(2*m2sq*m3**4*(m3sq - 4*m4sq)**2*(8*m4**4*B0del(0,0,m2sq,mudim) - 2*(m2**4 + 8*m4**4 - 8*m2sq*m4sq)*B0fin(0,0,m2sq,mudim)) - 2*m2**4*m3sq*(m2sq - 4*m4sq)**2*(8*m4**4*B0del(0,0,m3sq,mudim) - 2*(m3**4 + 8*m4**4 - 8*m3sq*m4sq)*B0fin(0,0,m3sq,mudim)) + (m2sq - m3sq)*(-((16*m4**6*(m3**3 - 4*m3*m4sq)**2 + m2**6*(m3**6 + 8*m3sq*m4**4 + 16*m4**6 - 8*m3**4*m4sq) - 8*m2**4*m4sq*(m3**6 + 6*m3sq*m4**4 + 16*m4**6 - 7*m3**4*m4sq) + 8*m2sq*m4**4*(m3**6 + 32*m4**6 - 6*m3**4*m4sq))*B0del(0,0,m4sq,mudim)) - 2*m2sq*m3sq*(4*m4**4*(m3sq - 4*m4sq)**2 + m2sq*(36*m3sq*m4**4 - 32*m4**6 - 6*m3**4*m4sq) + m2**4*(m3**4 + 4*m4**4 - 6*m3sq*m4sq))*B0fin(0,0,m4sq,mudim)))))/(m2**4*m3**4*(m2sq - m3sq)*(m2 - 2*m4)**2*(m3 - 2*m4)**2*m4**4*(m2 + 2*m4)**2*(m3 + 2*m4)**2) + (8*(2*m2sq*(m2sq + 2*m4sq) - (m2sq - 4*m4sq)*(m2sq + 2*m4sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 4*m4sq*B0fin(0,0,m4sq,mudim)) - 4*m4sq*T134fin(m4,m4,m2,mudim)))/(m2**4*(m2sq - m3sq)*(m2sq - 4*m4sq)**2) + (8*(2*m3sq*(m3sq + 2*m4sq) - (m3sq - 4*m4sq)*(m3sq + 2*m4sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 4*m4sq*B0fin(0,0,m4sq,mudim)) - 4*m4sq*T134fin(m4,m4,m3,mudim)))/(m3**4*(-m2sq + m3sq)*(m3sq - 4*m4sq)**2))/16.
		def eval_97():
			return -0.5*(m1sq*(m2sq - m3sq)**2*B0fin(0,0,m1sq,mudim) - m2sq*(m1sq - m3sq)**2*B0fin(0,0,m2sq,mudim) + (m1sq - m2sq)*((m1sq - m3sq)*(-m2sq + m3sq) + (m1sq*m2sq - m3**4)*B0fin(0,0,m3sq,mudim)))/((m1sq - m2sq)*(m1 - m3)**2*(m2 - m3)**2*m3**2*(m1 + m3)**2*(m2 + m3)**2)
		def eval_98():
			return -0.5*(2*m1sq*m2**4 + 2*m1**4*m2sq + 2*m1sq*m3**4 + 2*m2sq*m3**4 + 2*m1**4*m3sq + 2*m2**4*m3sq - 12*m1sq*m2sq*m3sq + 2*m1sq*(m2sq - m3sq)**2*B0del(0,0,m1sq,mudim) + 2*m2sq*(m1sq - m3sq)**2*B0del(0,0,m2sq,mudim) + 2*m1**4*m3sq*B0del(0,0,m3sq,mudim) + 2*m2**4*m3sq*B0del(0,0,m3sq,mudim) - 4*m1sq*m2sq*m3sq*B0del(0,0,m3sq,mudim) + 2*m1sq*m2**4*B0fin(0,0,m1sq,mudim) + 2*m1sq*m3**4*B0fin(0,0,m1sq,mudim) - 4*m1sq*m2sq*m3sq*B0fin(0,0,m1sq,mudim) + 2*m1**4*m2sq*B0fin(0,0,m2sq,mudim) + 2*m2sq*m3**4*B0fin(0,0,m2sq,mudim) - 4*m1sq*m2sq*m3sq*B0fin(0,0,m2sq,mudim) + 2*m1**4*m2sq*B0fin(0,0,m2sq,mudim)**2 + 2*m2sq*m3**4*B0fin(0,0,m2sq,mudim)**2 - 4*m1sq*m2sq*m3sq*B0fin(0,0,m2sq,mudim)**2 + 2*m1**4*m3sq*B0fin(0,0,m3sq,mudim) + 2*m2**4*m3sq*B0fin(0,0,m3sq,mudim) - 4*m1sq*m2sq*m3sq*B0fin(0,0,m3sq,mudim) + 2*m1sq*m2**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 2*m1sq*m3**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 4*m1sq*m2sq*m3sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 2*m1**4*m2sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) - 2*m2sq*m3**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) + 4*m1sq*m2sq*m3sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) - m1sq*m2**4*B0fin(0,0,m3sq,mudim)**2 + m1**4*m2sq*B0fin(0,0,m3sq,mudim)**2 - m1sq*m3**4*B0fin(0,0,m3sq,mudim)**2 + m2sq*m3**4*B0fin(0,0,m3sq,mudim)**2 + m1**4*m3sq*B0fin(0,0,m3sq,mudim)**2 + m2**4*m3sq*B0fin(0,0,m3sq,mudim)**2 - 2*m1sq*m2sq*m3sq*B0fin(0,0,m3sq,mudim)**2 - 2*m1sq*m2sq*T134fin(m2,m1,0,mudim) - 2*m3**4*T134fin(m2,m1,0,mudim) + 2*m1sq*m3sq*T134fin(m2,m1,0,mudim) + 2*m2sq*m3sq*T134fin(m2,m1,0,mudim) - 2*m2**4*T134fin(m3,m1,0,mudim) + 2*m1sq*m2sq*T134fin(m3,m1,0,mudim) - 2*m1sq*m3sq*T134fin(m3,m1,0,mudim) + 2*m2sq*m3sq*T134fin(m3,m1,0,mudim) - 2*m1**4*T134fin(m3,m2,0,mudim) + 2*m1sq*m2sq*T134fin(m3,m2,0,mudim) + 2*m1sq*m3sq*T134fin(m3,m2,0,mudim) - 2*m2sq*m3sq*T134fin(m3,m2,0,mudim))/((m1sq - m2sq)*(m1sq - m3sq)**2*(m2sq - m3sq)**3)
		def eval_99():
			return -0.5*(8*m1**6*m2**4 + 8*m1**4*m2**6 - 40*m1sq*m2**8 + 24*m2**10 - 2*m1**6*m5**4 + 58*m1sq*m2**4*m5**4 + 102*m2**6*m5**4 + 34*m1**4*m2sq*m5**4 - 24*m2**4*m5**6 - 24*m1sq*m2sq*m5**6 + 2*m1sq*m5**8 + 2*m2sq*m5**8 - 72*m1**4*m2**4*m5sq - 80*m1sq*m2**6*m5sq - 104*m2**8*m5sq - 2*m1sq*(m1sq + m2sq - m5sq)*m5sq*(-4*m2sq + m5sq)**2*B0del(0,0,m1sq,mudim) + 2*m2sq*(12*m2**8 + 40*m2**4*m5**4 - 11*m2sq*m5**6 + m5**8 + m1**6*(4*m2sq - 2*m5sq) - 42*m2**6*m5sq - m1sq*(20*m2**6 - 20*m2sq*m5**4 + 3*m5**6 + 46*m2**4*m5sq) + m1**4*(4*m2**4 + 4*m5**4 - 6*m2sq*m5sq))*B0del(0,0,m2sq,mudim) - 2*m1**6*m5**4*B0del(0,0,m5sq,mudim) - 30*m1sq*m2**4*m5**4*B0del(0,0,m5sq,mudim) + 22*m2**6*m5**4*B0del(0,0,m5sq,mudim) + 10*m1**4*m2sq*m5**4*B0del(0,0,m5sq,mudim) + 2*m1**4*m5**6*B0del(0,0,m5sq,mudim) - 2*m2**4*m5**6*B0del(0,0,m5sq,mudim) - 28*m1**4*m2**4*m5sq*B0del(0,0,m5sq,mudim) + 44*m1sq*m2**6*m5sq*B0del(0,0,m5sq,mudim) - 20*m2**8*m5sq*B0del(0,0,m5sq,mudim) + 4*m1**6*m2sq*m5sq*B0del(0,0,m5sq,mudim) + 48*m1sq*m2**4*m5**4*B0fin(0,0,m1sq,mudim) + 16*m1**4*m2sq*m5**4*B0fin(0,0,m1sq,mudim) - 2*m1**4*m5**6*B0fin(0,0,m1sq,mudim) - 18*m1sq*m2sq*m5**6*B0fin(0,0,m1sq,mudim) + 2*m1sq*m5**8*B0fin(0,0,m1sq,mudim) - 32*m1**4*m2**4*m5sq*B0fin(0,0,m1sq,mudim) - 32*m1sq*m2**6*m5sq*B0fin(0,0,m1sq,mudim) + 8*m1**6*m2**4*B0fin(0,0,m2sq,mudim) + 8*m1**4*m2**6*B0fin(0,0,m2sq,mudim) - 40*m1sq*m2**8*B0fin(0,0,m2sq,mudim) + 24*m2**10*B0fin(0,0,m2sq,mudim) - 2*m1**6*m5**4*B0fin(0,0,m2sq,mudim) + 34*m1sq*m2**4*m5**4*B0fin(0,0,m2sq,mudim) + 98*m2**6*m5**4*B0fin(0,0,m2sq,mudim) - 2*m1**4*m2sq*m5**4*B0fin(0,0,m2sq,mudim) + 4*m1**4*m5**6*B0fin(0,0,m2sq,mudim) - 34*m2**4*m5**6*B0fin(0,0,m2sq,mudim) + 2*m1sq*m2sq*m5**6*B0fin(0,0,m2sq,mudim) - 2*m1sq*m5**8*B0fin(0,0,m2sq,mudim) + 4*m2sq*m5**8*B0fin(0,0,m2sq,mudim) - 36*m1**4*m2**4*m5sq*B0fin(0,0,m2sq,mudim) - 68*m1sq*m2**6*m5sq*B0fin(0,0,m2sq,mudim) - 92*m2**8*m5sq*B0fin(0,0,m2sq,mudim) + 4*m1**6*m2sq*m5sq*B0fin(0,0,m2sq,mudim) + 32*m1sq*m2**4*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 4*m1sq*m2sq*m5**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 64*m1sq*m2**6*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 4*m1**6*m2**4*B0fin(0,0,m2sq,mudim)**2 + 4*m1**4*m2**6*B0fin(0,0,m2sq,mudim)**2 - 20*m1sq*m2**8*B0fin(0,0,m2sq,mudim)**2 + 12*m2**10*B0fin(0,0,m2sq,mudim)**2 + m1**6*m5**4*B0fin(0,0,m2sq,mudim)**2 + 27*m1sq*m2**4*m5**4*B0fin(0,0,m2sq,mudim)**2 + 29*m2**6*m5**4*B0fin(0,0,m2sq,mudim)**2 + 7*m1**4*m2sq*m5**4*B0fin(0,0,m2sq,mudim)**2 - 2*m1**4*m5**6*B0fin(0,0,m2sq,mudim)**2 - 10*m2**4*m5**6*B0fin(0,0,m2sq,mudim)**2 - 8*m1sq*m2sq*m5**6*B0fin(0,0,m2sq,mudim)**2 + m1sq*m5**8*B0fin(0,0,m2sq,mudim)**2 + m2sq*m5**8*B0fin(0,0,m2sq,mudim)**2 - 8*m1**4*m2**4*m5sq*B0fin(0,0,m2sq,mudim)**2 - 20*m1sq*m2**6*m5sq*B0fin(0,0,m2sq,mudim)**2 - 32*m2**8*m5sq*B0fin(0,0,m2sq,mudim)**2 - 4*m1**6*m2sq*m5sq*B0fin(0,0,m2sq,mudim)**2 - 24*m1sq*m2**4*m5**4*B0fin(0,0,m5sq,mudim) + 4*m2**6*m5**4*B0fin(0,0,m5sq,mudim) + 20*m1**4*m2sq*m5**4*B0fin(0,0,m5sq,mudim) - 2*m1**4*m5**6*B0fin(0,0,m5sq,mudim) + 10*m2**4*m5**6*B0fin(0,0,m5sq,mudim) - 8*m1sq*m2sq*m5**6*B0fin(0,0,m5sq,mudim) + 2*m1sq*m5**8*B0fin(0,0,m5sq,mudim) - 2*m2sq*m5**8*B0fin(0,0,m5sq,mudim) - 4*m1**4*m2**4*m5sq*B0fin(0,0,m5sq,mudim) + 20*m1sq*m2**6*m5sq*B0fin(0,0,m5sq,mudim) - 12*m2**8*m5sq*B0fin(0,0,m5sq,mudim) - 4*m1**6*m2sq*m5sq*B0fin(0,0,m5sq,mudim) + 16*m1sq*m2**4*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 16*m1**4*m2sq*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m1**4*m5**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 14*m1sq*m2sq*m5**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m1sq*m5**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 32*m1**4*m2**4*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 32*m1sq*m2**6*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m1**6*m5**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 46*m1sq*m2**4*m5**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 22*m2**6*m5**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 6*m1**4*m2sq*m5**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 4*m1**4*m5**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m2**4*m5**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 14*m1sq*m2sq*m5**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m1sq*m5**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 4*m1**4*m2**4*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 12*m1sq*m2**6*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 20*m2**8*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 4*m1**6*m2sq*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 32*m1**4*m2**4*T134fin(m2,m1,0,mudim) + 64*m1sq*m2**6*T134fin(m2,m1,0,mudim) - 32*m2**8*T134fin(m2,m1,0,mudim) - 2*m1**4*m5**4*T134fin(m2,m1,0,mudim) - 66*m2**4*m5**4*T134fin(m2,m1,0,mudim) - 28*m1sq*m2sq*m5**4*T134fin(m2,m1,0,mudim) + 4*m1sq*m5**6*T134fin(m2,m1,0,mudim) + 20*m2sq*m5**6*T134fin(m2,m1,0,mudim) - 2*m5**8*T134fin(m2,m1,0,mudim) + 32*m1sq*m2**4*m5sq*T134fin(m2,m1,0,mudim) + 80*m2**6*m5sq*T134fin(m2,m1,0,mudim) + 16*m1**4*m2sq*m5sq*T134fin(m2,m1,0,mudim) + 32*m1**4*m2**4*T134fin(m5,m2,m1,mudim) - 64*m1sq*m2**6*T134fin(m5,m2,m1,mudim) + 32*m2**8*T134fin(m5,m2,m1,mudim) + 2*m1**4*m5**4*T134fin(m5,m2,m1,mudim) + 18*m2**4*m5**4*T134fin(m5,m2,m1,mudim) + 12*m1sq*m2sq*m5**4*T134fin(m5,m2,m1,mudim) - 2*m1sq*m5**6*T134fin(m5,m2,m1,mudim) - 2*m2sq*m5**6*T134fin(m5,m2,m1,mudim) - 48*m2**6*m5sq*T134fin(m5,m2,m1,mudim) - 16*m1**4*m2sq*m5sq*T134fin(m5,m2,m1,mudim) - 4*m1**4*m2**4*T134fin(m5,m2,m2,mudim) + 20*m1sq*m2**6*T134fin(m5,m2,m2,mudim) - 12*m2**8*T134fin(m5,m2,m2,mudim) - 4*m1**6*m2sq*T134fin(m5,m2,m2,mudim) - 4*m1**4*m5**4*T134fin(m5,m2,m2,mudim) - 16*m2**4*m5**4*T134fin(m5,m2,m2,mudim) - 12*m1sq*m2sq*m5**4*T134fin(m5,m2,m2,mudim) + 2*m1sq*m5**6*T134fin(m5,m2,m2,mudim) + 2*m2sq*m5**6*T134fin(m5,m2,m2,mudim) + 2*m1**6*m5sq*T134fin(m5,m2,m2,mudim) + 30*m1sq*m2**4*m5sq*T134fin(m5,m2,m2,mudim) + 26*m2**6*m5sq*T134fin(m5,m2,m2,mudim) + 6*m1**4*m2sq*m5sq*T134fin(m5,m2,m2,mudim))/((m1sq - m2sq)**2*m5**4*(-2*m2 + m5)**2*(2*m2 + m5)**2*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq)))
		def eval_100():
			return -0.5*(2*m1sq*m2**4 + 2*m1**4*m2sq + 2*m1sq*m5**4 + 2*m2sq*m5**4 + 2*m1**4*m5sq + 2*m2**4*m5sq - 12*m1sq*m2sq*m5sq + 2*m1sq*(m2sq - m5sq)**2*B0del(0,0,m1sq,mudim) + 2*m2sq*(m1sq - m5sq)**2*B0del(0,0,m2sq,mudim) + 2*m1**4*m5sq*B0del(0,0,m5sq,mudim) + 2*m2**4*m5sq*B0del(0,0,m5sq,mudim) - 4*m1sq*m2sq*m5sq*B0del(0,0,m5sq,mudim) + 2*m1sq*m2**4*B0fin(0,0,m1sq,mudim) + 2*m1sq*m5**4*B0fin(0,0,m1sq,mudim) - 4*m1sq*m2sq*m5sq*B0fin(0,0,m1sq,mudim) + 2*m1sq*m2**4*B0fin(0,0,m2sq,mudim) - 2*m1sq*m5**4*B0fin(0,0,m2sq,mudim) + 4*m2sq*m5**4*B0fin(0,0,m2sq,mudim) + 2*m1**4*m5sq*B0fin(0,0,m2sq,mudim) - 2*m2**4*m5sq*B0fin(0,0,m2sq,mudim) - 4*m1sq*m2sq*m5sq*B0fin(0,0,m2sq,mudim) + m1sq*m2**4*B0fin(0,0,m2sq,mudim)**2 + m1**4*m2sq*B0fin(0,0,m2sq,mudim)**2 + m1sq*m5**4*B0fin(0,0,m2sq,mudim)**2 + m2sq*m5**4*B0fin(0,0,m2sq,mudim)**2 - m1**4*m5sq*B0fin(0,0,m2sq,mudim)**2 - m2**4*m5sq*B0fin(0,0,m2sq,mudim)**2 - 2*m1sq*m2sq*m5sq*B0fin(0,0,m2sq,mudim)**2 - 2*m1sq*m2**4*B0fin(0,0,m5sq,mudim) + 2*m1**4*m2sq*B0fin(0,0,m5sq,mudim) + 2*m1sq*m5**4*B0fin(0,0,m5sq,mudim) - 2*m2sq*m5**4*B0fin(0,0,m5sq,mudim) + 4*m2**4*m5sq*B0fin(0,0,m5sq,mudim) - 4*m1sq*m2sq*m5sq*B0fin(0,0,m5sq,mudim) + 2*m1sq*m2**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m1sq*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 4*m1sq*m2sq*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m1sq*m2**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m1sq*m5**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m1**4*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m2**4*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m1sq*m2sq*T134fin(m2,m1,0,mudim) - 2*m5**4*T134fin(m2,m1,0,mudim) + 2*m1sq*m5sq*T134fin(m2,m1,0,mudim) + 2*m2sq*m5sq*T134fin(m2,m1,0,mudim) - 2*m2**4*T134fin(m5,m1,0,mudim) + 2*m1sq*m2sq*T134fin(m5,m1,0,mudim) - 2*m1sq*m5sq*T134fin(m5,m1,0,mudim) + 2*m2sq*m5sq*T134fin(m5,m1,0,mudim) - 2*m1**4*T134fin(m5,m2,0,mudim) + 2*m1sq*m2sq*T134fin(m5,m2,0,mudim) + 2*m1sq*m5sq*T134fin(m5,m2,0,mudim) - 2*m2sq*m5sq*T134fin(m5,m2,0,mudim))/((m1sq - m2sq)**2*(m2 - m5)**3*(m2 + m5)**3*(m1sq - m5sq))
		def eval_101():
			return -0.5*(4*m1**4*m2**4 - 2*m1sq*m2**6 + 2*m2**8 + 2*m1**4*m6**4 + 4*m2**4*m6**4 - 2*m1sq*m2sq*m6**4 - 4*m1sq*m2**4*m6sq - 2*m2**6*m6sq - 2*m1**4*m2sq*m6sq + 2*m1sq*m2sq*(m2sq - m6sq)**2*B0del(0,0,m1sq,mudim) + 2*m2**4*(m1sq - m6sq)**2*B0del(0,0,m2sq,mudim) - 4*m1sq*m2**4*m6sq*B0del(0,0,m6sq,mudim) + 2*m2**6*m6sq*B0del(0,0,m6sq,mudim) + 2*m1**4*m2sq*m6sq*B0del(0,0,m6sq,mudim) + 2*m1sq*m2**6*B0fin(0,0,m1sq,mudim) + 2*m1sq*m2sq*m6**4*B0fin(0,0,m1sq,mudim) - 4*m1sq*m2**4*m6sq*B0fin(0,0,m1sq,mudim) + 2*m1**4*m2**4*B0fin(0,0,m2sq,mudim) + 2*m2**4*m6**4*B0fin(0,0,m2sq,mudim) - 4*m1sq*m2**4*m6sq*B0fin(0,0,m2sq,mudim) + 2*m1sq*m2**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 2*m1sq*m2sq*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 4*m1sq*m2**4*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + m1**4*m2**4*B0fin(0,0,m2sq,mudim)**2 - m1sq*m2**6*B0fin(0,0,m2sq,mudim)**2 + m2**4*m6**4*B0fin(0,0,m2sq,mudim)**2 - m1sq*m2sq*m6**4*B0fin(0,0,m2sq,mudim)**2 + 2*m1sq*m2**4*m6sq*B0fin(0,0,m2sq,mudim)**2 - m2**6*m6sq*B0fin(0,0,m2sq,mudim)**2 - m1**4*m2sq*m6sq*B0fin(0,0,m2sq,mudim)**2 - 4*m1sq*m2**4*m6sq*B0fin(0,0,m6sq,mudim) + 2*m2**6*m6sq*B0fin(0,0,m6sq,mudim) + 2*m1**4*m2sq*m6sq*B0fin(0,0,m6sq,mudim) - 4*m1sq*m2**4*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m2**6*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m1**4*m2sq*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m1sq*m2**4*T134fin(m2,m1,0,mudim) - 2*m2sq*m6**4*T134fin(m2,m1,0,mudim) + 2*m2**4*m6sq*T134fin(m2,m1,0,mudim) + 2*m1sq*m2sq*m6sq*T134fin(m2,m1,0,mudim) + 2*m1sq*m2**4*T134fin(m6,m1,0,mudim) - 2*m2**6*T134fin(m6,m1,0,mudim) + 2*m2**4*m6sq*T134fin(m6,m1,0,mudim) - 2*m1sq*m2sq*m6sq*T134fin(m6,m1,0,mudim) + 2*m1sq*m2**4*T134fin(m6,m2,0,mudim) - 2*m1**4*m2sq*T134fin(m6,m2,0,mudim) - 2*m2**4*m6sq*T134fin(m6,m2,0,mudim) + 2*m1sq*m2sq*m6sq*T134fin(m6,m2,0,mudim))/(m2**2*(-m1sq + m2sq)**3*(m2sq - m6sq)**3)
		def eval_102():
			return -0.5*(m1sq*(m2sq - m3sq)**2*B0fin(0,0,m1sq,mudim) + (m1sq - m3sq)*(-m2**4 + m1sq*m3sq)*B0fin(0,0,m2sq,mudim) + (m1sq - m2sq)*((m1sq - m3sq)*(m2sq - m3sq) + (-m1sq + m2sq)*m3sq*B0fin(0,0,m3sq,mudim)))/((m1 - m2)**2*m2**2*(m1 + m2)**2*(m2 - m3)**2*(m2 + m3)**2*(m1sq - m3sq))
		def eval_103():
			return ((4*m2**4*(m4sq*B0del(0,0,m4sq,mudim) - m5sq*B0del(0,0,m5sq,mudim) + (m4sq - m5sq)*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)) + (-1 + B0fin(0,0,m2sq,mudim))*(m4sq*B0fin(0,0,m4sq,mudim) - m5sq*B0fin(0,0,m5sq,mudim))))/((m4sq - m5sq)*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))) + (2*(m5sq*(2*m5**4*(m4sq - m5sq) - m2**4*(m4sq + m5sq) + 2*m2sq*m5sq*(m4sq + 3*m5sq))*B0del(0,0,m5sq,mudim) + 2*m2sq*m5sq*(-m2sq + m5sq)*(-m4sq + m5sq)*(B0del(0,0,m2sq,mudim) - 2*B0fin(0,0,m2sq,mudim)) + 2*(m4sq - m5sq)*m5sq*(m2**4 - 2*m5**4 - 2*m2sq*m5sq)*B0fin(0,0,m5sq,mudim) + (8*m2sq*m5**6 + 2*m5**6*(m4sq - m5sq) + m2**4*(m4sq - 3*m5sq)*m5sq)*(2 + B0del(0,0,m5sq,mudim) + B0fin(0,0,m5sq,mudim)) + m5sq*(1 + B0fin(0,0,m5sq,mudim))*(-2*(m2**4 + 2*m5**4)*(m4sq - m5sq) + 2*m2sq*(m2sq - m5sq)*(m4sq - m5sq)*B0fin(0,0,m2sq,mudim) - (-2*m4sq*m5**4 + 2*m5**6 + m2**4*(m4sq + m5sq) - 2*m2sq*m5sq*(m4sq + 3*m5sq))*B0fin(0,0,m5sq,mudim))))/((-(m4sq*m5) + m5**3)**2*(m2sq - 4*m5sq)) - (2*(2*m2**6*(m4sq - m5sq)*m5sq*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq)) + m2sq*m5sq*(8*m5**4*(m4sq - m5sq)**3 - 2*m2**8*m5sq + 2*m2**6*m5sq*(m4sq + 7*m5sq) + m2sq*(18*m4**4*m5**4 - 50*m4sq*m5**6 + 38*m5**8 - 6*m4**6*m5sq) + 8*m2**4*m5sq*(m4**4 - 3*m5**4 - 2*m4sq*m5sq))*B0del(0,0,m5sq,mudim) + 2*m2sq*m5**4*(m2**8 + 4*m5sq*(-m4sq + m5sq)**3 - m2**6*(m4sq + 7*m5sq) + m2sq*(3*m4**6 + 25*m4sq*m5**4 - 19*m5**6 - 9*m4**4*m5sq) - 4*m2**4*(m4**4 - 3*m5**4 - 2*m4sq*m5sq))*B0fin(0,0,m2sq,mudim) + m5sq*(m2sq*(8*m5**4*(m4sq - m5sq)**3 - 2*m2**8*m5sq + 2*m2**6*m5sq*(m4sq + 7*m5sq) + m2sq*(18*m4**4*m5**4 - 50*m4sq*m5**6 + 38*m5**8 - 6*m4**6*m5sq) + 8*m2**4*m5sq*(m4**4 - 3*m5**4 - 2*m4sq*m5sq))*B0del(0,0,m2sq,mudim) - 2*m2**6*(m4sq - m5sq)*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))*B0fin(0,0,m2sq,mudim)) - 2*m2**6*m4sq*(m2sq - 4*m5sq)**2*m5sq*(B0fin(0,0,m2sq,mudim) + B0fin(0,0,m4sq,mudim)) + 2*m2**6*m4sq*(m2sq - 4*m5sq)**2*m5sq*(B0del(0,0,m2sq,mudim) + B0del(0,0,m4sq,mudim) + B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim)) - m2sq*m5sq*(8*m5**4*(m4sq - m5sq)**3 - 2*m2**8*m5sq + 2*m2**6*m5sq*(m4sq + 7*m5sq) + m2sq*(18*m4**4*m5**4 - 50*m4sq*m5**6 + 38*m5**8 - 6*m4**6*m5sq) + 8*m2**4*m5sq*(m4**4 - 3*m5**4 - 2*m4sq*m5sq))*B0fin(0,0,m5sq,mudim) + m5sq*(-2*m2**6*(m4sq - m5sq)*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq)) - 2*m2sq*m5sq*(m2**8 + 4*m5sq*(-m4sq + m5sq)**3 - m2**6*(m4sq + 7*m5sq) + m2sq*(3*m4**6 + 25*m4sq*m5**4 - 19*m5**6 - 9*m4**4*m5sq) - 4*m2**4*(m4**4 - 3*m5**4 - 2*m4sq*m5sq))*B0fin(0,0,m2sq,mudim))*B0fin(0,0,m5sq,mudim) + 4*m2**4*m4sq*m5**4*(m2sq - 4*m5sq)**2*(B0fin(0,0,m4sq,mudim) + B0fin(0,0,m5sq,mudim)) + 2*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))*(4*m2sq*m5**6*(-m4sq + m5sq) - 2*m5**4*(-4*m4sq*m5**4 + 4*m5**6 + m2**4*(m4sq + m5sq) - m2sq*m5sq*(m4sq + 7*m5sq))*B0fin(0,0,m5sq,mudim)) - 4*m2**4*m4sq*m5**4*(m2sq - 4*m5sq)**2*(B0del(0,0,m4sq,mudim) + B0del(0,0,m5sq,mudim) + B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim)) - 2*m5**4*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))*(8*m2sq*(m5**4 - m4sq*m5sq)*B0fin(0,0,m5sq,mudim) + (4*m5**4*(m4sq - m5sq) - m2**4*(m4sq + m5sq) + m2sq*m5sq*(m4sq + 7*m5sq))*(2*B0del(0,0,m5sq,mudim) + B0fin(0,0,m5sq,mudim)**2))))/(m5**2*(m2sq - 4*m5sq)**2*(m4sq - m5sq)**2*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))) + (4*m2sq*T134fin(m5,m4,0,mudim))/(m4sq - m5sq)**2 + (4*m2sq*(-((2*m2**4 - 2*m2sq*(m4sq + m5sq))*((m2sq + m4sq + m5sq)/2. + m2sq*B0fin(0,0,m2sq,mudim) + m4sq*B0fin(0,0,m4sq,mudim) + m5sq*B0fin(0,0,m5sq,mudim))) - ((m4sq - m5sq)**2 - m2sq*(m4sq + m5sq))*T134fin(m5,m4,m2,mudim)))/((m4sq - m5sq)**2*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))) + (4*m2sq*(2*(m2**4 - 4*m5**4)*(m4sq - m5sq) + (m2**4 + 8*m5**4 - 6*m2sq*m5sq)*(m2sq + 2*m5sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 4*m5sq*B0fin(0,0,m5sq,mudim)) + (-(m2sq*(m4sq + m5sq)) + 2*m5sq*(m4sq + 3*m5sq))*T134fin(m5,m5,m2,mudim)))/((m2 - 2*m5)**2*(m2 + 2*m5)**2*(m4sq - m5sq)**2))/(4.*m2**6)
		def eval_104():
			return ((2*(m4sq*(-2*m4**6 + 2*m4**4*m6sq - m2**4*(m4sq + m6sq) + 2*m2sq*m4sq*(3*m4sq + m6sq))*B0del(0,0,m4sq,mudim) + 2*m2sq*m4sq*(-m2sq + m4sq)*(m4sq - m6sq)*(B0del(0,0,m2sq,mudim) - 2*B0fin(0,0,m2sq,mudim)) + 2*m4sq*(-m2**4 + 2*m4**4 + 2*m2sq*m4sq)*(m4sq - m6sq)*B0fin(0,0,m4sq,mudim) - (-8*m2sq*m4**6 + 2*m4**6*(m4sq - m6sq) + m2**4*(3*m4**4 - m4sq*m6sq))*(2 + B0del(0,0,m4sq,mudim) + B0fin(0,0,m4sq,mudim)) + m4sq*(1 + B0fin(0,0,m4sq,mudim))*(2*(m2**4 + 2*m4**4)*(m4sq - m6sq) - 2*m2sq*(m2sq - m4sq)*(m4sq - m6sq)*B0fin(0,0,m2sq,mudim) - (2*m4**4*(m4sq - m6sq) + m2**4*(m4sq + m6sq) - 2*m2sq*m4sq*(3*m4sq + m6sq))*B0fin(0,0,m4sq,mudim))))/((m2sq - 4*m4sq)*(m4**3 - m4*m6sq)**2) + (4*m2**4*(m4sq*B0del(0,0,m4sq,mudim) - m6sq*B0del(0,0,m6sq,mudim) + (m4sq - m6sq)*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)) + (-1 + B0fin(0,0,m2sq,mudim))*(m4sq*B0fin(0,0,m4sq,mudim) - m6sq*B0fin(0,0,m6sq,mudim))))/((m4sq - m6sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))) + (2*(2*m2**6*m4sq*(m4sq - m6sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq)) + m2sq*m4sq*(2*m2**8*m4sq + 8*m4**4*(m4sq - m6sq)**3 - 2*m2**6*m4sq*(7*m4sq + m6sq) + 8*m2**4*(3*m4**6 - m4sq*m6**4 + 2*m4**4*m6sq) + m2sq*(-38*m4**8 - 18*m4**4*m6**4 + 6*m4sq*m6**6 + 50*m4**6*m6sq))*B0del(0,0,m4sq,mudim) - 2*m2sq*m4**4*(m2**8 + 4*m4sq*(m4sq - m6sq)**3 - m2**6*(7*m4sq + m6sq) + m2sq*(-19*m4**6 - 9*m4sq*m6**4 + 3*m6**6 + 25*m4**4*m6sq) + 4*m2**4*(3*m4**4 - m6**4 + 2*m4sq*m6sq))*B0fin(0,0,m2sq,mudim) + m4sq*(m2sq*(2*m2**8*m4sq + 8*m4**4*(m4sq - m6sq)**3 - 2*m2**6*m4sq*(7*m4sq + m6sq) + 8*m2**4*(3*m4**6 - m4sq*m6**4 + 2*m4**4*m6sq) + m2sq*(-38*m4**8 - 18*m4**4*m6**4 + 6*m4sq*m6**6 + 50*m4**6*m6sq))*B0del(0,0,m2sq,mudim) - 2*m2**6*(m4sq - m6sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*B0fin(0,0,m2sq,mudim)) - m2sq*m4sq*(2*m2**8*m4sq + 8*m4**4*(m4sq - m6sq)**3 - 2*m2**6*m4sq*(7*m4sq + m6sq) + 8*m2**4*(3*m4**6 - m4sq*m6**4 + 2*m4**4*m6sq) + m2sq*(-38*m4**8 - 18*m4**4*m6**4 + 6*m4sq*m6**6 + 50*m4**6*m6sq))*B0fin(0,0,m4sq,mudim) + m4sq*(-2*m2**6*(m4sq - m6sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq)) + 2*m2sq*m4sq*(m2**8 + 4*m4sq*(m4sq - m6sq)**3 - m2**6*(7*m4sq + m6sq) + m2sq*(-19*m4**6 - 9*m4sq*m6**4 + 3*m6**6 + 25*m4**4*m6sq) + 4*m2**4*(3*m4**4 - m6**4 + 2*m4sq*m6sq))*B0fin(0,0,m2sq,mudim))*B0fin(0,0,m4sq,mudim) + 2*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(4*m2sq*m4**6*(-m4sq + m6sq) + 2*(4*m4**8*(m4sq - m6sq) + m2**4*m4**4*(m4sq + m6sq) - m2sq*m4**6*(7*m4sq + m6sq))*B0fin(0,0,m4sq,mudim)) - 2*m4**4*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(-8*m2sq*(m4**4 - m4sq*m6sq)*B0fin(0,0,m4sq,mudim) + (4*m4**4*(m4sq - m6sq) + m2**4*(m4sq + m6sq) - m2sq*m4sq*(7*m4sq + m6sq))*(2*B0del(0,0,m4sq,mudim) + B0fin(0,0,m4sq,mudim)**2)) + 2*m2**6*(m2sq - 4*m4sq)**2*m4sq*m6sq*(B0fin(0,0,m2sq,mudim) + B0fin(0,0,m6sq,mudim)) - 4*m2**4*m4**4*(m2sq - 4*m4sq)**2*m6sq*(B0fin(0,0,m4sq,mudim) + B0fin(0,0,m6sq,mudim)) - 2*m2**6*(m2sq - 4*m4sq)**2*m4sq*m6sq*(B0del(0,0,m2sq,mudim) + B0del(0,0,m6sq,mudim) + B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim)) + 4*m2**4*m4**4*(m2sq - 4*m4sq)**2*m6sq*(B0del(0,0,m4sq,mudim) + B0del(0,0,m6sq,mudim) + B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))))/(m4**2*(m2sq - 4*m4sq)**2*(m4sq - m6sq)**2*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))) + (4*m2sq*(-2*(m2**4 - 4*m4**4)*(m4sq - m6sq) + (m2**4 + 8*m4**4 - 6*m2sq*m4sq)*(m2sq + 2*m4sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 4*m4sq*B0fin(0,0,m4sq,mudim)) + (-(m2sq*(m4sq + m6sq)) + 2*m4sq*(3*m4sq + m6sq))*T134fin(m4,m4,m2,mudim)))/((m2 - 2*m4)**2*(m2 + 2*m4)**2*(m4sq - m6sq)**2) + (4*m2sq*T134fin(m6,m4,0,mudim))/(m4sq - m6sq)**2 + (4*m2sq*(-((2*m2**4 - 2*m2sq*(m4sq + m6sq))*((m2sq + m4sq + m6sq)/2. + m2sq*B0fin(0,0,m2sq,mudim) + m4sq*B0fin(0,0,m4sq,mudim) + m6sq*B0fin(0,0,m6sq,mudim))) - ((m4sq - m6sq)**2 - m2sq*(m4sq + m6sq))*T134fin(m6,m4,m2,mudim)))/((m4sq - m6sq)**2*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))))/(4.*m2**6)
		def eval_105():
			return (2*m1sq*m2**4 + 2*m1**4*m2sq + 2*m1sq*m3**4 + 2*m2sq*m3**4 + 2*m1**4*m3sq + 2*m2**4*m3sq - 12*m1sq*m2sq*m3sq + 2*m1sq*(m2sq - m3sq)**2*B0del(0,0,m1sq,mudim) + 2*m2sq*(m1sq - m3sq)**2*B0del(0,0,m2sq,mudim) + 2*m1**4*m3sq*B0del(0,0,m3sq,mudim) + 2*m2**4*m3sq*B0del(0,0,m3sq,mudim) - 4*m1sq*m2sq*m3sq*B0del(0,0,m3sq,mudim) + 2*m1sq*m2**4*B0fin(0,0,m1sq,mudim) + 2*m1sq*m3**4*B0fin(0,0,m1sq,mudim) - 4*m1sq*m2sq*m3sq*B0fin(0,0,m1sq,mudim) + 2*m1sq*m2**4*B0fin(0,0,m1sq,mudim)**2 + 2*m1sq*m3**4*B0fin(0,0,m1sq,mudim)**2 - 4*m1sq*m2sq*m3sq*B0fin(0,0,m1sq,mudim)**2 + 2*m1**4*m2sq*B0fin(0,0,m2sq,mudim) + 2*m2sq*m3**4*B0fin(0,0,m2sq,mudim) - 4*m1sq*m2sq*m3sq*B0fin(0,0,m2sq,mudim) + 2*m1**4*m3sq*B0fin(0,0,m3sq,mudim) + 2*m2**4*m3sq*B0fin(0,0,m3sq,mudim) - 4*m1sq*m2sq*m3sq*B0fin(0,0,m3sq,mudim) - 2*m1sq*m2**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 2*m1sq*m3**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 4*m1sq*m2sq*m3sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 2*m1**4*m2sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) + 2*m2sq*m3**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) - 4*m1sq*m2sq*m3sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) + m1sq*m2**4*B0fin(0,0,m3sq,mudim)**2 - m1**4*m2sq*B0fin(0,0,m3sq,mudim)**2 + m1sq*m3**4*B0fin(0,0,m3sq,mudim)**2 - m2sq*m3**4*B0fin(0,0,m3sq,mudim)**2 + m1**4*m3sq*B0fin(0,0,m3sq,mudim)**2 + m2**4*m3sq*B0fin(0,0,m3sq,mudim)**2 - 2*m1sq*m2sq*m3sq*B0fin(0,0,m3sq,mudim)**2 - 2*m1sq*m2sq*T134fin(m2,m1,0,mudim) - 2*m3**4*T134fin(m2,m1,0,mudim) + 2*m1sq*m3sq*T134fin(m2,m1,0,mudim) + 2*m2sq*m3sq*T134fin(m2,m1,0,mudim) - 2*m2**4*T134fin(m3,m1,0,mudim) + 2*m1sq*m2sq*T134fin(m3,m1,0,mudim) - 2*m1sq*m3sq*T134fin(m3,m1,0,mudim) + 2*m2sq*m3sq*T134fin(m3,m1,0,mudim) - 2*m1**4*T134fin(m3,m2,0,mudim) + 2*m1sq*m2sq*T134fin(m3,m2,0,mudim) + 2*m1sq*m3sq*T134fin(m3,m2,0,mudim) - 2*m2sq*m3sq*T134fin(m3,m2,0,mudim))/(2.*(m1sq - m2sq)*(m1sq - m3sq)**3*(m2sq - m3sq)**2)
		def eval_106():
			return -0.5*(2*m1sq*m3**4 + 2*m1**4*m3sq + 2*m1sq*m6**4 + 2*m3sq*m6**4 + 2*m1**4*m6sq + 2*m3**4*m6sq - 12*m1sq*m3sq*m6sq + 2*m1sq*(m3sq - m6sq)**2*B0del(0,0,m1sq,mudim) + 2*m3sq*(m1sq - m6sq)**2*B0del(0,0,m3sq,mudim) + 2*m1**4*m6sq*B0del(0,0,m6sq,mudim) + 2*m3**4*m6sq*B0del(0,0,m6sq,mudim) - 4*m1sq*m3sq*m6sq*B0del(0,0,m6sq,mudim) + 4*m1sq*m3**4*B0fin(0,0,m1sq,mudim) - 2*m1**4*m3sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*m6**4*B0fin(0,0,m1sq,mudim) + 2*m1**4*m6sq*B0fin(0,0,m1sq,mudim) - 2*m3**4*m6sq*B0fin(0,0,m1sq,mudim) - 4*m1sq*m3sq*m6sq*B0fin(0,0,m1sq,mudim) - 2*m1sq*m3**4*B0fin(0,0,m3sq,mudim) + 4*m1**4*m3sq*B0fin(0,0,m3sq,mudim) + 2*m1sq*m6**4*B0fin(0,0,m3sq,mudim) - 2*m1**4*m6sq*B0fin(0,0,m3sq,mudim) + 2*m3**4*m6sq*B0fin(0,0,m3sq,mudim) - 4*m1sq*m3sq*m6sq*B0fin(0,0,m3sq,mudim) + 2*m1sq*m3**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 2*m1sq*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 2*m1**4*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 2*m3**4*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - m1sq*m3**4*B0fin(0,0,m3sq,mudim)**2 + m1**4*m3sq*B0fin(0,0,m3sq,mudim)**2 - m1sq*m6**4*B0fin(0,0,m3sq,mudim)**2 + m3sq*m6**4*B0fin(0,0,m3sq,mudim)**2 + m1**4*m6sq*B0fin(0,0,m3sq,mudim)**2 + m3**4*m6sq*B0fin(0,0,m3sq,mudim)**2 - 2*m1sq*m3sq*m6sq*B0fin(0,0,m3sq,mudim)**2 + 2*m1**4*m6sq*B0fin(0,0,m6sq,mudim) + 2*m3**4*m6sq*B0fin(0,0,m6sq,mudim) - 4*m1sq*m3sq*m6sq*B0fin(0,0,m6sq,mudim) + 2*m1**4*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m3**4*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m1sq*m3sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m1sq*m3sq*T134fin(m3,m1,0,mudim) - 2*m6**4*T134fin(m3,m1,0,mudim) + 2*m1sq*m6sq*T134fin(m3,m1,0,mudim) + 2*m3sq*m6sq*T134fin(m3,m1,0,mudim) - 2*m3**4*T134fin(m6,m1,0,mudim) + 2*m1sq*m3sq*T134fin(m6,m1,0,mudim) - 2*m1sq*m6sq*T134fin(m6,m1,0,mudim) + 2*m3sq*m6sq*T134fin(m6,m1,0,mudim) - 2*m1**4*T134fin(m6,m3,0,mudim) + 2*m1sq*m3sq*T134fin(m6,m3,0,mudim) + 2*m1sq*m6sq*T134fin(m6,m3,0,mudim) - 2*m3sq*m6sq*T134fin(m6,m3,0,mudim))/((m1 - m3)**3*(m1 + m3)**3*(m1sq - m6sq)*(m3sq - m6sq)**2)
		def eval_107():
			return (2*m1sq*m2**4 + 2*m1**4*m2sq + 2*m1sq*m6**4 + 2*m2sq*m6**4 + 2*m1**4*m6sq + 2*m2**4*m6sq - 12*m1sq*m2sq*m6sq + 2*m1sq*(m2sq - m6sq)**2*B0del(0,0,m1sq,mudim) + 2*m2sq*(m1sq - m6sq)**2*B0del(0,0,m2sq,mudim) + 2*m1**4*m6sq*B0del(0,0,m6sq,mudim) + 2*m2**4*m6sq*B0del(0,0,m6sq,mudim) - 4*m1sq*m2sq*m6sq*B0del(0,0,m6sq,mudim) + 2*m1sq*m2**4*B0fin(0,0,m1sq,mudim) + 2*m1sq*m6**4*B0fin(0,0,m1sq,mudim) - 4*m1sq*m2sq*m6sq*B0fin(0,0,m1sq,mudim) + 2*m1sq*m2**4*B0fin(0,0,m1sq,mudim)**2 + 2*m1sq*m6**4*B0fin(0,0,m1sq,mudim)**2 - 4*m1sq*m2sq*m6sq*B0fin(0,0,m1sq,mudim)**2 + 2*m1**4*m2sq*B0fin(0,0,m2sq,mudim) + 2*m2sq*m6**4*B0fin(0,0,m2sq,mudim) - 4*m1sq*m2sq*m6sq*B0fin(0,0,m2sq,mudim) - 2*m1sq*m2**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 2*m1sq*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 4*m1sq*m2sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + m1sq*m2**4*B0fin(0,0,m2sq,mudim)**2 + m1**4*m2sq*B0fin(0,0,m2sq,mudim)**2 + m1sq*m6**4*B0fin(0,0,m2sq,mudim)**2 + m2sq*m6**4*B0fin(0,0,m2sq,mudim)**2 - m1**4*m6sq*B0fin(0,0,m2sq,mudim)**2 - m2**4*m6sq*B0fin(0,0,m2sq,mudim)**2 - 2*m1sq*m2sq*m6sq*B0fin(0,0,m2sq,mudim)**2 + 2*m1**4*m6sq*B0fin(0,0,m6sq,mudim) + 2*m2**4*m6sq*B0fin(0,0,m6sq,mudim) - 4*m1sq*m2sq*m6sq*B0fin(0,0,m6sq,mudim) + 2*m1**4*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m2**4*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m1sq*m2sq*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m1sq*m2sq*T134fin(m2,m1,0,mudim) - 2*m6**4*T134fin(m2,m1,0,mudim) + 2*m1sq*m6sq*T134fin(m2,m1,0,mudim) + 2*m2sq*m6sq*T134fin(m2,m1,0,mudim) - 2*m2**4*T134fin(m6,m1,0,mudim) + 2*m1sq*m2sq*T134fin(m6,m1,0,mudim) - 2*m1sq*m6sq*T134fin(m6,m1,0,mudim) + 2*m2sq*m6sq*T134fin(m6,m1,0,mudim) - 2*m1**4*T134fin(m6,m2,0,mudim) + 2*m1sq*m2sq*T134fin(m6,m2,0,mudim) + 2*m1sq*m6sq*T134fin(m6,m2,0,mudim) - 2*m2sq*m6sq*T134fin(m6,m2,0,mudim))/(2.*(m1sq - m2sq)**3*(m1sq - m6sq)*(m2sq - m6sq)**2)
		def eval_108():
			return (2*m1sq*m2**4 + 2*m1**4*m2sq + 2*m1sq*m3**4 + 2*m2sq*m3**4 + 2*m1**4*m3sq + 2*m2**4*m3sq - 12*m1sq*m2sq*m3sq + 2*m1sq*(m2sq - m3sq)**2*B0del(0,0,m1sq,mudim) + 2*m2sq*(m1sq - m3sq)**2*B0del(0,0,m2sq,mudim) + 2*m1**4*m3sq*B0del(0,0,m3sq,mudim) + 2*m2**4*m3sq*B0del(0,0,m3sq,mudim) - 4*m1sq*m2sq*m3sq*B0del(0,0,m3sq,mudim) + 2*m1sq*m2**4*B0fin(0,0,m1sq,mudim) + 2*m1sq*m3**4*B0fin(0,0,m1sq,mudim) - 4*m1sq*m2sq*m3sq*B0fin(0,0,m1sq,mudim) + 2*m1sq*m2**4*B0fin(0,0,m1sq,mudim)**2 + 2*m1sq*m3**4*B0fin(0,0,m1sq,mudim)**2 - 4*m1sq*m2sq*m3sq*B0fin(0,0,m1sq,mudim)**2 + 2*m1**4*m2sq*B0fin(0,0,m2sq,mudim) + 2*m2sq*m3**4*B0fin(0,0,m2sq,mudim) - 4*m1sq*m2sq*m3sq*B0fin(0,0,m2sq,mudim) - 2*m1sq*m2**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 2*m1sq*m3**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 4*m1sq*m2sq*m3sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + m1sq*m2**4*B0fin(0,0,m2sq,mudim)**2 + m1**4*m2sq*B0fin(0,0,m2sq,mudim)**2 + m1sq*m3**4*B0fin(0,0,m2sq,mudim)**2 + m2sq*m3**4*B0fin(0,0,m2sq,mudim)**2 - m1**4*m3sq*B0fin(0,0,m2sq,mudim)**2 - m2**4*m3sq*B0fin(0,0,m2sq,mudim)**2 - 2*m1sq*m2sq*m3sq*B0fin(0,0,m2sq,mudim)**2 + 2*m1**4*m3sq*B0fin(0,0,m3sq,mudim) + 2*m2**4*m3sq*B0fin(0,0,m3sq,mudim) - 4*m1sq*m2sq*m3sq*B0fin(0,0,m3sq,mudim) + 2*m1**4*m3sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) + 2*m2**4*m3sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) - 4*m1sq*m2sq*m3sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) - 2*m1sq*m2sq*T134fin(m2,m1,0,mudim) - 2*m3**4*T134fin(m2,m1,0,mudim) + 2*m1sq*m3sq*T134fin(m2,m1,0,mudim) + 2*m2sq*m3sq*T134fin(m2,m1,0,mudim) - 2*m2**4*T134fin(m3,m1,0,mudim) + 2*m1sq*m2sq*T134fin(m3,m1,0,mudim) - 2*m1sq*m3sq*T134fin(m3,m1,0,mudim) + 2*m2sq*m3sq*T134fin(m3,m1,0,mudim) - 2*m1**4*T134fin(m3,m2,0,mudim) + 2*m1sq*m2sq*T134fin(m3,m2,0,mudim) + 2*m1sq*m3sq*T134fin(m3,m2,0,mudim) - 2*m2sq*m3sq*T134fin(m3,m2,0,mudim))/(2.*(m1sq - m2sq)**3*(m1sq - m3sq)*(m2sq - m3sq)**2)
		def eval_109():
			return ((-2*(m1sq - m3sq)*(m1sq - m5sq)*m5sq*B0del(0,0,m5sq,mudim))/(4*m1sq - m5sq) + m1sq*m5sq*(-8 + (-1 - m3sq/m1**2 + (2*(m1sq - m3sq)*(m1sq - m5sq))/(-m5**4 + 4*m1sq*m5sq))*B0del(0,0,m1sq,mudim) - 4*B0fin(0,0,m1sq,mudim)) + ((2*m1**6 + 3*m1sq*m5**4 - m3sq*m5**4 - 2*m1**4*(m3sq + 4*m5sq))*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/(4*m1sq - m5sq) + (2*(m1sq - m3sq)*m5**4*(m1sq*B0del(0,0,m1sq,mudim) - m3sq*B0del(0,0,m3sq,mudim) + (m1sq - m3sq)*(B0del(0,0,m5sq,mudim) - B0fin(0,0,m5sq,mudim)) + (m1sq*B0fin(0,0,m1sq,mudim) - m3sq*B0fin(0,0,m3sq,mudim))*(-1 + B0fin(0,0,m5sq,mudim))))/(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq)) - ((-1 + B0fin(0,0,m1sq,mudim))*((2*m1**6 + m3sq*m5**4 - 2*m1**4*(m3sq + 3*m5sq) + m1sq*(m5**4 - 2*m3sq*m5sq))*B0fin(0,0,m1sq,mudim) + 2*m5sq*(-8*m1**4 + 2*m1sq*m5sq - (m1sq - m3sq)*(m1sq - m5sq)*B0fin(0,0,m5sq,mudim))))/(-4*m1sq + m5sq) + (2*m1sq*(m1sq - m3sq)*m5**6*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq)) + 2*m1**4*m5sq*(4*m1**8 - 4*m3**4*m5**4 - m3sq*m5**6 + m5**8 + 3*m3**6*m5sq - m1**6*(12*m3sq + 19*m5sq) - m1sq*(4*m3**6 - 8*m3sq*m5**4 + 7*m5**6 + 9*m3**4*m5sq) + m1**4*(12*m3**4 + 12*m5**4 + 25*m3sq*m5sq))*B0del(0,0,m1sq,mudim) + m1sq*m5sq*(8*m1**10 - 2*m1**8*(12*m3sq + 19*m5sq) - 2*m1**4*(4*m3**6 - 8*m3sq*m5**4 + 7*m5**6 + 9*m3**4*m5sq) + 2*m1sq*(-4*m3**4*m5**4 - m3sq*m5**6 + m5**8 + 3*m3**6*m5sq) + m1**6*(24*m3**4 + 24*m5**4 + 50*m3sq*m5sq))*B0del(0,0,m5sq,mudim) - 2*m1sq*(m1sq - m3sq)*m5**6*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*B0fin(0,0,m1sq,mudim) - 2*m1**4*m5sq*(4*m1**8 - 4*m3**4*m5**4 - m3sq*m5**6 + m5**8 + 3*m3**6*m5sq - m1**6*(12*m3sq + 19*m5sq) - m1sq*(4*m3**6 - 8*m3sq*m5**4 + 7*m5**6 + 9*m3**4*m5sq) + m1**4*(12*m3**4 + 12*m5**4 + 25*m3sq*m5sq))*B0fin(0,0,m1sq,mudim) + 2*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(4*m1**6*(-m1sq + m3sq)*m5sq + 2*m1**4*(4*m1**6 + m3sq*m5**4 - m1**4*(4*m3sq + 7*m5sq) + m1sq*(m5**4 - m3sq*m5sq))*B0fin(0,0,m1sq,mudim)) - 2*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(-8*m1**6*(m1sq - m3sq)*m5sq*B0fin(0,0,m1sq,mudim) + m1**4*(4*m1**6 + m3sq*m5**4 - m1**4*(4*m3sq + 7*m5sq) + m1sq*(m5**4 - m3sq*m5sq))*(2*B0del(0,0,m1sq,mudim) + B0fin(0,0,m1sq,mudim)**2)) - 4*m1sq*m3sq*m5**4*(-4*m1**3 + m1*m5sq)**2*(B0fin(0,0,m1sq,mudim) + B0fin(0,0,m3sq,mudim)) + 4*m1sq*m3sq*m5**4*(-4*m1**3 + m1*m5sq)**2*(B0del(0,0,m1sq,mudim) + B0del(0,0,m3sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim)) - m1sq*m5sq*(8*m1**10 - 2*m1**8*(12*m3sq + 19*m5sq) - 2*m1**4*(4*m3**6 - 8*m3sq*m5**4 + 7*m5**6 + 9*m3**4*m5sq) + 2*m1sq*(-4*m3**4*m5**4 - m3sq*m5**6 + m5**8 + 3*m3**6*m5sq) + m1**6*(24*m3**4 + 24*m5**4 + 50*m3sq*m5sq))*B0fin(0,0,m5sq,mudim) + m5sq*(-2*m1sq*(m1sq - m3sq)*m5**4*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq)) + 2*m1**4*(4*m1**8 - 4*m3**4*m5**4 - m3sq*m5**6 + m5**8 + 3*m3**6*m5sq - m1**6*(12*m3sq + 19*m5sq) - m1sq*(4*m3**6 - 8*m3sq*m5**4 + 7*m5**6 + 9*m3**4*m5sq) + m1**4*(12*m3**4 + 12*m5**4 + 25*m3sq*m5sq))*B0fin(0,0,m1sq,mudim))*B0fin(0,0,m5sq,mudim) + 2*m3sq*m5**6*(-4*m1**3 + m1*m5sq)**2*(B0fin(0,0,m3sq,mudim) + B0fin(0,0,m5sq,mudim)) - 2*m3sq*m5**6*(-4*m1**3 + m1*m5sq)**2*(B0del(0,0,m3sq,mudim) + B0del(0,0,m5sq,mudim) + B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim)))/((-4*m1**3 + m1*m5sq)**2*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) + 2*m5sq*T134fin(m3,m1,0,mudim) + (2*m5sq*(2*(m1sq - m3sq)*(4*m1**4 - m5**4) + (8*m1**4 + m5**4 - 6*m1sq*m5sq)*(2*m1sq + m5sq + 4*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim)) + (6*m1**4 + m1sq*(2*m3sq - m5sq) - m3sq*m5sq)*T134fin(m5,m1,m1,mudim)))/(-4*m1sq + m5sq)**2 + (2*(2*m5**4*(m1sq + m3sq - m5sq)*((m1sq + m3sq + m5sq)/2. + m1sq*B0fin(0,0,m1sq,mudim) + m3sq*B0fin(0,0,m3sq,mudim) + m5sq*B0fin(0,0,m5sq,mudim)) + m5sq*(-m1**4 - m3**4 + m3sq*m5sq + m1sq*(2*m3sq + m5sq))*T134fin(m5,m3,m1,mudim)))/(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq)))/(2.*(m1sq - m3sq)**2*m5**6)
		def eval_110():
			return -0.5*(2*m1sq*m3**4 + 2*m1**4*m3sq + 2*m1sq*m5**4 + 2*m3sq*m5**4 + 2*m1**4*m5sq + 2*m3**4*m5sq - 12*m1sq*m3sq*m5sq + 2*m1sq*(m3sq - m5sq)**2*B0del(0,0,m1sq,mudim) + 2*m3sq*(m1sq - m5sq)**2*B0del(0,0,m3sq,mudim) + 2*m1**4*m5sq*B0del(0,0,m5sq,mudim) + 2*m3**4*m5sq*B0del(0,0,m5sq,mudim) - 4*m1sq*m3sq*m5sq*B0del(0,0,m5sq,mudim) + 2*m1**4*m3sq*B0fin(0,0,m1sq,mudim) + 4*m1sq*m5**4*B0fin(0,0,m1sq,mudim) - 2*m3sq*m5**4*B0fin(0,0,m1sq,mudim) - 2*m1**4*m5sq*B0fin(0,0,m1sq,mudim) + 2*m3**4*m5sq*B0fin(0,0,m1sq,mudim) - 4*m1sq*m3sq*m5sq*B0fin(0,0,m1sq,mudim) + m1sq*m3**4*B0fin(0,0,m1sq,mudim)**2 + m1**4*m3sq*B0fin(0,0,m1sq,mudim)**2 + m1sq*m5**4*B0fin(0,0,m1sq,mudim)**2 + m3sq*m5**4*B0fin(0,0,m1sq,mudim)**2 - m1**4*m5sq*B0fin(0,0,m1sq,mudim)**2 - m3**4*m5sq*B0fin(0,0,m1sq,mudim)**2 - 2*m1sq*m3sq*m5sq*B0fin(0,0,m1sq,mudim)**2 + 2*m1**4*m3sq*B0fin(0,0,m3sq,mudim) + 2*m3sq*m5**4*B0fin(0,0,m3sq,mudim) - 4*m1sq*m3sq*m5sq*B0fin(0,0,m3sq,mudim) + 2*m1sq*m3**4*B0fin(0,0,m5sq,mudim) - 2*m1**4*m3sq*B0fin(0,0,m5sq,mudim) - 2*m1sq*m5**4*B0fin(0,0,m5sq,mudim) + 2*m3sq*m5**4*B0fin(0,0,m5sq,mudim) + 4*m1**4*m5sq*B0fin(0,0,m5sq,mudim) - 4*m1sq*m3sq*m5sq*B0fin(0,0,m5sq,mudim) - 2*m1**4*m3sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m3sq*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m1**4*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m3**4*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m1**4*m3sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m3sq*m5**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) - 4*m1sq*m3sq*m5sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m1sq*m3sq*T134fin(m3,m1,0,mudim) - 2*m5**4*T134fin(m3,m1,0,mudim) + 2*m1sq*m5sq*T134fin(m3,m1,0,mudim) + 2*m3sq*m5sq*T134fin(m3,m1,0,mudim) - 2*m3**4*T134fin(m5,m1,0,mudim) + 2*m1sq*m3sq*T134fin(m5,m1,0,mudim) - 2*m1sq*m5sq*T134fin(m5,m1,0,mudim) + 2*m3sq*m5sq*T134fin(m5,m1,0,mudim) - 2*m1**4*T134fin(m5,m3,0,mudim) + 2*m1sq*m3sq*T134fin(m5,m3,0,mudim) + 2*m1sq*m5sq*T134fin(m5,m3,0,mudim) - 2*m3sq*m5sq*T134fin(m5,m3,0,mudim))/((m1sq - m3sq)**2*(m1 - m5)**3*(m1 + m5)**3*(m3sq - m5sq))
		def eval_111():
			return (2*m1sq*m2**4 + 2*m1**4*m2sq + 2*m1sq*m6**4 + 2*m2sq*m6**4 + 2*m1**4*m6sq + 2*m2**4*m6sq - 12*m1sq*m2sq*m6sq + 2*m1sq*(m2sq - m6sq)**2*B0del(0,0,m1sq,mudim) + 2*m2sq*(m1sq - m6sq)**2*B0del(0,0,m2sq,mudim) + 2*m1**4*m6sq*B0del(0,0,m6sq,mudim) + 2*m2**4*m6sq*B0del(0,0,m6sq,mudim) - 4*m1sq*m2sq*m6sq*B0del(0,0,m6sq,mudim) + 4*m1sq*m2**4*B0fin(0,0,m1sq,mudim) - 2*m1**4*m2sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*m6**4*B0fin(0,0,m1sq,mudim) + 2*m1**4*m6sq*B0fin(0,0,m1sq,mudim) - 2*m2**4*m6sq*B0fin(0,0,m1sq,mudim) - 4*m1sq*m2sq*m6sq*B0fin(0,0,m1sq,mudim) + m1sq*m2**4*B0fin(0,0,m1sq,mudim)**2 - m1**4*m2sq*B0fin(0,0,m1sq,mudim)**2 + m1sq*m6**4*B0fin(0,0,m1sq,mudim)**2 - m2sq*m6**4*B0fin(0,0,m1sq,mudim)**2 + m1**4*m6sq*B0fin(0,0,m1sq,mudim)**2 + m2**4*m6sq*B0fin(0,0,m1sq,mudim)**2 - 2*m1sq*m2sq*m6sq*B0fin(0,0,m1sq,mudim)**2 - 2*m1sq*m2**4*B0fin(0,0,m2sq,mudim) + 4*m1**4*m2sq*B0fin(0,0,m2sq,mudim) + 2*m1sq*m6**4*B0fin(0,0,m2sq,mudim) - 2*m1**4*m6sq*B0fin(0,0,m2sq,mudim) + 2*m2**4*m6sq*B0fin(0,0,m2sq,mudim) - 4*m1sq*m2sq*m6sq*B0fin(0,0,m2sq,mudim) + 2*m1**4*m2sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 2*m2sq*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 2*m1**4*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 2*m2**4*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 2*m1**4*m6sq*B0fin(0,0,m6sq,mudim) + 2*m2**4*m6sq*B0fin(0,0,m6sq,mudim) - 4*m1sq*m2sq*m6sq*B0fin(0,0,m6sq,mudim) + 2*m1**4*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m2**4*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m1sq*m2sq*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m1sq*m2sq*T134fin(m2,m1,0,mudim) - 2*m6**4*T134fin(m2,m1,0,mudim) + 2*m1sq*m6sq*T134fin(m2,m1,0,mudim) + 2*m2sq*m6sq*T134fin(m2,m1,0,mudim) - 2*m2**4*T134fin(m6,m1,0,mudim) + 2*m1sq*m2sq*T134fin(m6,m1,0,mudim) - 2*m1sq*m6sq*T134fin(m6,m1,0,mudim) + 2*m2sq*m6sq*T134fin(m6,m1,0,mudim) - 2*m1**4*T134fin(m6,m2,0,mudim) + 2*m1sq*m2sq*T134fin(m6,m2,0,mudim) + 2*m1sq*m6sq*T134fin(m6,m2,0,mudim) - 2*m2sq*m6sq*T134fin(m6,m2,0,mudim))/(2.*(m1 - m2)**3*(m1 + m2)**3*(m1sq - m6sq)**2*(m2sq - m6sq))
		def eval_112():
			return ((2*(6 + 2*B0del(0,0,m1sq,mudim) - 6*B0fin(0,0,m1sq,mudim) + B0fin(0,0,m1sq,mudim)**2))/(m1**2*m5**2*m6**2) + (2*((-(m5**8*m6**6) + m5**6*m6**8 - 256*m1**10*(m5**4 - m6**4) + 8*m1sq*m5**4*m6**4*(m5**4 - m6**4) + 128*m1**8*(m5sq - m6sq)**3 - 24*m1**4*m5sq*m6sq*(m5**6 - 2*m5sq*m6**4 - m6**6 + 2*m5**4*m6sq) - 16*m1**6*(m5**8 + 12*m5sq*m6**6 - m6**8 - 12*m5**6*m6sq))*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)) + (m5sq - m6sq)*(-((m5**6*m6**6 - 128*m1**8*(m5**4 + m6**4) + 256*m1**10*(m5sq + m6sq) - 8*m1sq*m5**4*m6**4*(m5sq + m6sq) + 16*m1**6*(m5**6 - 3*m5sq*m6**4 + m6**6 - 3*m5**4*m6sq) + 8*m1**4*m5sq*m6sq*(m5**4 + m6**4 + 7*m5sq*m6sq))*B0del(0,0,m1sq,mudim)) - 2*m5sq*m6sq*(64*m1**8 + m5**4*m6**4 - 32*m1**6*(m5sq + m6sq) - 6*m1sq*m5sq*m6sq*(m5sq + m6sq) + 4*m1**4*(m5**4 + m6**4 + 9*m5sq*m6sq))*B0fin(0,0,m1sq,mudim)) + (-1 + B0fin(0,0,m1sq,mudim))*((m5sq - m6sq)*(-2*m5sq*m6sq*(64*m1**8 + m5**4*m6**4 - 32*m1**6*(m5sq + m6sq) - 6*m1sq*m5sq*m6sq*(m5sq + m6sq) + 4*m1**4*(m5**4 + m6**4 + 9*m5sq*m6sq)) - (m5**6*m6**6 - 128*m1**8*(m5**4 + m6**4) + 256*m1**10*(m5sq + m6sq) - 8*m1sq*m5**4*m6**4*(m5sq + m6sq) + 16*m1**6*(m5**6 - 3*m5sq*m6**4 + m6**6 - 3*m5**4*m6sq) + 8*m1**4*m5sq*m6sq*(m5**4 + m6**4 + 7*m5sq*m6sq))*B0fin(0,0,m1sq,mudim)) - 4*m5sq*m6**4*(-4*m1sq + m6sq)**2*(8*m1**4 + m5**4 - 8*m1sq*m5sq - 4*m1**4*B0fin(0,0,m5sq,mudim)) + 4*m5**4*(-4*m1sq + m5sq)**2*m6sq*(8*m1**4 + m6**4 - 8*m1sq*m6sq - 4*m1**4*B0fin(0,0,m6sq,mudim))) - 2*(m5sq*m6**4*(-4*m1sq + m6sq)**2*(-8*m1**4*B0del(0,0,m5sq,mudim) + 2*(8*m1**4 + m5**4 - 8*m1sq*m5sq)*B0fin(0,0,m5sq,mudim)) + m5**4*(-4*m1sq + m5sq)**2*m6sq*(8*m1**4*B0del(0,0,m6sq,mudim) - 2*(8*m1**4 + m6**4 - 8*m1sq*m6sq)*B0fin(0,0,m6sq,mudim)))))/(m1**2*m5**4*(-2*m1 + m5)**2*(2*m1 + m5)**2*m6**4*(-2*m1 + m6)**2*(2*m1 + m6)**2*(m5sq - m6sq)) + (8*(8*m1**4 + m5**4 + 6*m1sq*m5sq + 4*(4*m1**4 - m1sq*m5sq)*B0fin(0,0,m1sq,mudim) + (-2*m5**4 + 8*m1sq*m5sq)*B0fin(0,0,m5sq,mudim) - 4*m1sq*T134fin(m5,m1,m1,mudim)))/(m5**4*(-4*m1sq + m5sq)**2*(m5sq - m6sq)) + (8*(8*m1**4 + m6**4 + 6*m1sq*m6sq + 4*(4*m1**4 - m1sq*m6sq)*B0fin(0,0,m1sq,mudim) + (-2*m6**4 + 8*m1sq*m6sq)*B0fin(0,0,m6sq,mudim) - 4*m1sq*T134fin(m6,m1,m1,mudim)))/(m6**4*(-4*m1sq + m6sq)**2*(-m5sq + m6sq)))/16.
		def eval_113():
			return ((m5sq - m6sq)*(m1**4 - m5sq*m6sq)*B0fin(0,0,m1sq,mudim) - m5sq*(m1sq - m6sq)**2*B0fin(0,0,m5sq,mudim) + (m1sq - m5sq)*((m1sq - m6sq)*(m5sq - m6sq) + (m1sq - m5sq)*m6sq*B0fin(0,0,m6sq,mudim)))/(2.*m1**2*(m1 - m5)**2*(m1 + m5)**2*(m1 - m6)**2*(m1 + m6)**2*(m5sq - m6sq))
		def eval_114():
			return -0.5*(2*m1**8 + 4*m1**4*m3**4 - 2*m1**6*m3sq + 4*m1**4*m6**4 + 2*m3**4*m6**4 - 2*m1sq*m3sq*m6**4 - 2*m1**6*m6sq - 2*m1sq*m3**4*m6sq - 4*m1**4*m3sq*m6sq + 2*m1**4*(m3sq - m6sq)**2*B0del(0,0,m1sq,mudim) + 2*m1sq*m3sq*(m1sq - m6sq)**2*B0del(0,0,m3sq,mudim) + 2*m1**6*m6sq*B0del(0,0,m6sq,mudim) + 2*m1sq*m3**4*m6sq*B0del(0,0,m6sq,mudim) - 4*m1**4*m3sq*m6sq*B0del(0,0,m6sq,mudim) + 2*m1**4*m3**4*B0fin(0,0,m1sq,mudim) + 2*m1**4*m6**4*B0fin(0,0,m1sq,mudim) - 4*m1**4*m3sq*m6sq*B0fin(0,0,m1sq,mudim) + m1**4*m3**4*B0fin(0,0,m1sq,mudim)**2 - m1**6*m3sq*B0fin(0,0,m1sq,mudim)**2 + m1**4*m6**4*B0fin(0,0,m1sq,mudim)**2 - m1sq*m3sq*m6**4*B0fin(0,0,m1sq,mudim)**2 - m1**6*m6sq*B0fin(0,0,m1sq,mudim)**2 - m1sq*m3**4*m6sq*B0fin(0,0,m1sq,mudim)**2 + 2*m1**4*m3sq*m6sq*B0fin(0,0,m1sq,mudim)**2 + 2*m1**6*m3sq*B0fin(0,0,m3sq,mudim) + 2*m1sq*m3sq*m6**4*B0fin(0,0,m3sq,mudim) - 4*m1**4*m3sq*m6sq*B0fin(0,0,m3sq,mudim) + 2*m1**6*m3sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 2*m1sq*m3sq*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 4*m1**4*m3sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 2*m1**6*m6sq*B0fin(0,0,m6sq,mudim) + 2*m1sq*m3**4*m6sq*B0fin(0,0,m6sq,mudim) - 4*m1**4*m3sq*m6sq*B0fin(0,0,m6sq,mudim) + 2*m1**6*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m1sq*m3**4*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m1**4*m3sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m1**4*m3sq*T134fin(m3,m1,0,mudim) - 2*m1sq*m6**4*T134fin(m3,m1,0,mudim) + 2*m1**4*m6sq*T134fin(m3,m1,0,mudim) + 2*m1sq*m3sq*m6sq*T134fin(m3,m1,0,mudim) - 2*m1sq*m3**4*T134fin(m6,m1,0,mudim) + 2*m1**4*m3sq*T134fin(m6,m1,0,mudim) - 2*m1**4*m6sq*T134fin(m6,m1,0,mudim) + 2*m1sq*m3sq*m6sq*T134fin(m6,m1,0,mudim) - 2*m1**6*T134fin(m6,m3,0,mudim) + 2*m1**4*m3sq*T134fin(m6,m3,0,mudim) + 2*m1**4*m6sq*T134fin(m6,m3,0,mudim) - 2*m1sq*m3sq*m6sq*T134fin(m6,m3,0,mudim))/(m1**2*(m1sq - m3sq)**3*(m1sq - m6sq)**3)
		def eval_115():
			return ((m2sq - m3sq)*(m1**4 - m2sq*m3sq)*B0fin(0,0,m1sq,mudim) - m2sq*(m1sq - m3sq)**2*B0fin(0,0,m2sq,mudim) + (m1sq - m2sq)*((m1sq - m3sq)*(m2sq - m3sq) + (m1sq - m2sq)*m3sq*B0fin(0,0,m3sq,mudim)))/(2.*m1**2*(m1 - m2)**2*(m1 + m2)**2*(m1 - m3)**2*(m1 + m3)**2*(m2sq - m3sq))
		def eval_116():
			return (-2*m2sq*m3**4*m4sq + 2*m2**4*m3sq*m4sq + 12*m2**4*m5**4 - 12*m3**4*m5**4 - 16*m2sq*m4sq*m5**4 + 16*m3sq*m4sq*m5**4 - 48*m2sq*m5**6 + 48*m3sq*m5**6 + 6*m2sq*m3**4*m5sq - 6*m2**4*m3sq*m5sq + 4*m2**4*m4sq*m5sq - 4*m3**4*m4sq*m5sq + 2*m2sq*m3sq*(m3sq - 4*m5sq)*(-m4sq + m5sq)*B0del(0,0,m2sq,mudim) + 2*m2sq*m3sq*(m2sq - 4*m5sq)*(m4sq - m5sq)*B0del(0,0,m3sq,mudim) + 12*m2**4*m5**4*B0del(0,0,m5sq,mudim) - 12*m3**4*m5**4*B0del(0,0,m5sq,mudim) - 16*m2sq*m4sq*m5**4*B0del(0,0,m5sq,mudim) + 16*m3sq*m4sq*m5**4*B0del(0,0,m5sq,mudim) - 48*m2sq*m5**6*B0del(0,0,m5sq,mudim) + 48*m3sq*m5**6*B0del(0,0,m5sq,mudim) + 4*m2sq*m3**4*m5sq*B0del(0,0,m5sq,mudim) - 4*m2**4*m3sq*m5sq*B0del(0,0,m5sq,mudim) + 4*m2**4*m4sq*m5sq*B0del(0,0,m5sq,mudim) - 4*m3**4*m4sq*m5sq*B0del(0,0,m5sq,mudim) - 2*m2sq*m3**4*m4sq*B0fin(0,0,m2sq,mudim) - 8*m2sq*m3sq*m5**4*B0fin(0,0,m2sq,mudim) + 2*m2sq*m3**4*m5sq*B0fin(0,0,m2sq,mudim) + 8*m2sq*m3sq*m4sq*m5sq*B0fin(0,0,m2sq,mudim) + 2*m2**4*m3sq*m4sq*B0fin(0,0,m3sq,mudim) + 8*m2sq*m3sq*m5**4*B0fin(0,0,m3sq,mudim) - 2*m2**4*m3sq*m5sq*B0fin(0,0,m3sq,mudim) - 8*m2sq*m3sq*m4sq*m5sq*B0fin(0,0,m3sq,mudim) + 12*m2**4*m5**4*B0fin(0,0,m5sq,mudim) - 12*m3**4*m5**4*B0fin(0,0,m5sq,mudim) - 16*m2sq*m4sq*m5**4*B0fin(0,0,m5sq,mudim) + 16*m3sq*m4sq*m5**4*B0fin(0,0,m5sq,mudim) - 48*m2sq*m5**6*B0fin(0,0,m5sq,mudim) + 48*m3sq*m5**6*B0fin(0,0,m5sq,mudim) + 4*m2sq*m3**4*m5sq*B0fin(0,0,m5sq,mudim) - 4*m2**4*m3sq*m5sq*B0fin(0,0,m5sq,mudim) + 4*m2**4*m4sq*m5sq*B0fin(0,0,m5sq,mudim) - 4*m3**4*m4sq*m5sq*B0fin(0,0,m5sq,mudim) - 2*m2sq*m3**4*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 8*m2sq*m3sq*m5**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m2sq*m3**4*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 8*m2sq*m3sq*m4sq*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m2**4*m3sq*m4sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + 8*m2sq*m3sq*m5**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m2**4*m3sq*m5sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) - 8*m2sq*m3sq*m4sq*m5sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + m2sq*m3**4*m4sq*B0fin(0,0,m5sq,mudim)**2 - m2**4*m3sq*m4sq*B0fin(0,0,m5sq,mudim)**2 + 6*m2**4*m5**4*B0fin(0,0,m5sq,mudim)**2 - 6*m3**4*m5**4*B0fin(0,0,m5sq,mudim)**2 - 8*m2sq*m4sq*m5**4*B0fin(0,0,m5sq,mudim)**2 + 8*m3sq*m4sq*m5**4*B0fin(0,0,m5sq,mudim)**2 - 24*m2sq*m5**6*B0fin(0,0,m5sq,mudim)**2 + 24*m3sq*m5**6*B0fin(0,0,m5sq,mudim)**2 + m2sq*m3**4*m5sq*B0fin(0,0,m5sq,mudim)**2 - m2**4*m3sq*m5sq*B0fin(0,0,m5sq,mudim)**2 + 2*m2**4*m4sq*m5sq*B0fin(0,0,m5sq,mudim)**2 - 2*m3**4*m4sq*m5sq*B0fin(0,0,m5sq,mudim)**2 - 2*m2sq*m3**4*T134fin(m5,m4,0,mudim) + 2*m2**4*m3sq*T134fin(m5,m4,0,mudim) + 32*m2sq*m5**4*T134fin(m5,m4,0,mudim) - 32*m3sq*m5**4*T134fin(m5,m4,0,mudim) - 8*m2**4*m5sq*T134fin(m5,m4,0,mudim) + 8*m3**4*m5sq*T134fin(m5,m4,0,mudim) + 2*m2sq*m3**4*T134fin(m5,m4,m2,mudim) + 32*m3sq*m5**4*T134fin(m5,m4,m2,mudim) - 8*m3**4*m5sq*T134fin(m5,m4,m2,mudim) - 8*m2sq*m3sq*m5sq*T134fin(m5,m4,m2,mudim) - 2*m2**4*m3sq*T134fin(m5,m4,m3,mudim) - 32*m2sq*m5**4*T134fin(m5,m4,m3,mudim) + 8*m2**4*m5sq*T134fin(m5,m4,m3,mudim) + 8*m2sq*m3sq*m5sq*T134fin(m5,m4,m3,mudim) - 2*m2sq*m3**4*T134fin(m5,m5,m2,mudim) + 2*m3**4*m4sq*T134fin(m5,m5,m2,mudim) - 24*m3sq*m5**4*T134fin(m5,m5,m2,mudim) + 6*m3**4*m5sq*T134fin(m5,m5,m2,mudim) + 8*m2sq*m3sq*m5sq*T134fin(m5,m5,m2,mudim) - 8*m3sq*m4sq*m5sq*T134fin(m5,m5,m2,mudim) + 2*m2**4*m3sq*T134fin(m5,m5,m3,mudim) - 2*m2**4*m4sq*T134fin(m5,m5,m3,mudim) + 24*m2sq*m5**4*T134fin(m5,m5,m3,mudim) - 6*m2**4*m5sq*T134fin(m5,m5,m3,mudim) - 8*m2sq*m3sq*m5sq*T134fin(m5,m5,m3,mudim) + 8*m2sq*m4sq*m5sq*T134fin(m5,m5,m3,mudim))/(2.*m2**2*m3**2*(m2sq - m3sq)*(m2sq - 4*m5sq)*(m3sq - 4*m5sq)*(m4sq - m5sq)**2)
		def eval_117():
			return ((-8*m4sq)/(m2**2*m3**2) + (2*(m2sq - m4sq)*(m4sq - m6sq)*B0del(0,0,m2sq,mudim))/(m2**2*(m2sq - m3sq)*(m2sq - 4*m4sq)) + (2*(m3sq - m4sq)*(m4sq - m6sq)*B0del(0,0,m3sq,mudim))/(m3**2*(-m2sq + m3sq)*(m3sq - 4*m4sq)) + m4sq*(-2/(m2**2*m3**2) + (m4sq - m6sq)/(m2**2*m3**2*m4**2) + (2*(-m2sq + m4sq)*(m4sq - m6sq))/(m2**4*(m2sq - m3sq)*(m2sq - 4*m4sq)) + (2*(-m3sq + m4sq)*(m4sq - m6sq))/(m3**4*(-m2sq + m3sq)*(m3sq - 4*m4sq)))*B0del(0,0,m4sq,mudim) - ((m2**4*(-8*m3sq*m4**4 + 2*m4**4*(m4sq - m6sq) + m3**4*(3*m4sq - m6sq)) + 2*m3sq*m4**4*(m3sq - 4*m4sq)*(m4sq - m6sq) - 2*m2sq*m4**4*(m3sq - 4*m4sq)*(4*m3sq - m4sq + m6sq))*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/(m2**4*m3**4*(m2sq - 4*m4sq)*(m3sq - 4*m4sq)) - (4*m4sq*B0fin(0,0,m4sq,mudim))/(m2**2*m3**2) + (-1 + B0fin(0,0,m4sq,mudim))*((-4*m4sq)/(m2**2*m3**2) + (2*(m2sq - m4sq)*(m4sq - m6sq)*B0fin(0,0,m2sq,mudim))/(m2**2*(m2sq - m3sq)*(m2sq - 4*m4sq)) + (2*(m3sq - m4sq)*(m4sq - m6sq)*B0fin(0,0,m3sq,mudim))/(m3**2*(-m2sq + m3sq)*(m3sq - 4*m4sq)) + m4sq*(-2/(m2**2*m3**2) + (m4sq - m6sq)/(m2**2*m3**2*m4**2) + (2*(-m2sq + m4sq)*(m4sq - m6sq))/(m2**4*(m2sq - m3sq)*(m2sq - 4*m4sq)) + (2*(-m3sq + m4sq)*(m4sq - m6sq))/(m3**4*(-m2sq + m3sq)*(m3sq - 4*m4sq)))*B0fin(0,0,m4sq,mudim)) + (2*m4sq*(m4sq - m6sq)*(m2sq*m3**4*(m3sq - 4*m4sq)*B0del(0,0,m2sq,mudim) - m2**4*m3sq*(m2sq - 4*m4sq)*B0del(0,0,m3sq,mudim) + m4sq*(m2**6 - m3**6 - 4*m2**4*m4sq + 4*m3**4*m4sq)*B0del(0,0,m4sq,mudim) + (4*m3**4*m4**4 - m3**6*m4sq + 4*m2**4*(m3sq - m4sq)*m4sq + m2**6*(-m3sq + m4sq) + m2sq*(m3**6 - 4*m3**4*m4sq))*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)) + (-1 + B0fin(0,0,m4sq,mudim))*(m2sq*m3**4*(m3sq - 4*m4sq)*B0fin(0,0,m2sq,mudim) - m2**4*m3sq*(m2sq - 4*m4sq)*B0fin(0,0,m3sq,mudim) + m4sq*(m2**6 - m3**6 - 4*m2**4*m4sq + 4*m3**4*m4sq)*B0fin(0,0,m4sq,mudim))))/(m2**4*m3**4*(m2sq - m3sq)*(m2sq - 4*m4sq)*(m3sq - 4*m4sq)) + (2*((m4sq - m6sq)*(m2sq + 2*m4sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 4*m4sq*B0fin(0,0,m4sq,mudim)) - (m2sq - 3*m4sq - m6sq)*T134fin(m4,m4,m2,mudim)))/(m2**2*(m2sq - m3sq)*(m2sq - 4*m4sq)) + (2*((m4sq - m6sq)*(m3sq + 2*m4sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 4*m4sq*B0fin(0,0,m4sq,mudim)) - (m3sq - 3*m4sq - m6sq)*T134fin(m4,m4,m3,mudim)))/(m3**2*(-m2sq + m3sq)*(m3sq - 4*m4sq)) + (2*T134fin(m6,m4,0,mudim))/(m2**2*m3**2) + (2*T134fin(m6,m4,m2,mudim))/(m2**4 - m2sq*m3sq) + (2*T134fin(m6,m4,m3,mudim))/(m3**4 - m2sq*m3sq))/(2.*(m4sq - m6sq)**2)
		def eval_118():
			return -0.5*(-2*m1**4*(m2sq - m3sq)**3*(m3sq - m6sq)*B0del(0,0,m1sq,mudim) + 2*m2**4*(m1sq - m3sq)**3*(m3sq - m6sq)*B0del(0,0,m2sq,mudim) + (2*m2**4*(m1sq - m3sq)**3*(m3sq - m6sq) - 2*m1**4*(m2sq - m3sq)**3*(m3sq - m6sq) + (m1sq - m2sq)*(m1sq - m3sq)**2*(m2sq - m3sq)**2*(m3sq + m6sq))*(B0del(0,0,m3sq,mudim) - B0fin(0,0,m3sq,mudim)) - 2*m3sq*(m3sq - m6sq)*(-(m1sq*(m2sq - m3sq)**3*B0del(0,0,m1sq,mudim)) + m2sq*(m1sq - m3sq)**3*B0del(0,0,m2sq,mudim) + (m2sq*(m1sq - m3sq)**3 - m1sq*(m2sq - m3sq)**3)*B0del(0,0,m3sq,mudim) + m1sq*(m2sq - m3sq)**3*B0fin(0,0,m1sq,mudim) - m2sq*(m1sq - m3sq)**3*B0fin(0,0,m2sq,mudim) + (-(m2sq*(m1sq - m3sq)**3) + m1sq*(m2sq - m3sq)**3 - m1sq*(m2sq - m3sq)**3*B0fin(0,0,m1sq,mudim) + m2sq*(m1sq - m3sq)**3*B0fin(0,0,m2sq,mudim))*B0fin(0,0,m3sq,mudim)) + (m1sq - m2sq)*(m1sq - m3sq)**2*(m2sq - m3sq)**2*((m3sq + m6sq)*B0del(0,0,m3sq,mudim) + 4*m3sq*(2 + B0fin(0,0,m3sq,mudim))) + (1 - B0fin(0,0,m3sq,mudim))*(2*m1**4*(m2sq - m3sq)**3*(m3sq - m6sq)*B0fin(0,0,m1sq,mudim) - 2*m2**4*(m1sq - m3sq)**3*(m3sq - m6sq)*B0fin(0,0,m2sq,mudim) - (m1sq - m2sq)*(m1sq - m3sq)**2*(m2sq - m3sq)**2*(4*m3sq + (m3sq + m6sq)*B0fin(0,0,m3sq,mudim))) + 2*(m1sq - m3sq)*(m2sq - m3sq)**3*(-((m3sq - m6sq)*(m1sq + m3sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim))) + (m1sq - m6sq)*T134fin(m3,m1,0,mudim)) - 2*(m1sq - m3sq)**3*(m2sq - m3sq)*(-((m3sq - m6sq)*(m2sq + m3sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim))) + (m2sq - m6sq)*T134fin(m3,m2,0,mudim)) + 2*(m1sq - m3sq)**2*(-m2sq + m3sq)**3*T134fin(m6,m1,0,mudim) + 2*(m1sq - m3sq)**3*(m2sq - m3sq)**2*T134fin(m6,m2,0,mudim) - 2*(m1sq - m2sq)*(m1sq - m3sq)**2*(m2sq - m3sq)**2*T134fin(m6,m3,0,mudim))/((m1sq - m2sq)*(m1sq - m3sq)**3*(m2sq - m3sq)**3*(m3sq - m6sq)**2)
		def eval_119():
			return (12*m2**4*m5**4 + 4*m1sq*m2sq*m5**4 - 16*m1sq*m2**4*m5sq - 48*m2**6*m5sq - 12*m2**4*m6**4 - 4*m1sq*m2sq*m6**4 - 2*m1sq*m5sq*m6**4 + 6*m2sq*m5sq*m6**4 + 16*m1sq*m2**4*m6sq + 48*m2**6*m6sq + 2*m1sq*m5**4*m6sq - 6*m2sq*m5**4*m6sq - 4*m2sq*(m5sq - m6sq)*(12*m2**4 + m1sq*(4*m2sq - m5sq - m6sq) + m5sq*m6sq - 3*m2sq*(m5sq + m6sq))*B0del(0,0,m2sq,mudim) + 2*(m1sq - m2sq)*m5sq*(4*m2sq - m6sq)*m6sq*B0del(0,0,m5sq,mudim) + 2*m1sq*m5**4*m6sq*B0del(0,0,m6sq,mudim) - 2*m2sq*m5**4*m6sq*B0del(0,0,m6sq,mudim) + 8*m2**4*m5sq*m6sq*B0del(0,0,m6sq,mudim) - 8*m1sq*m2sq*m5sq*m6sq*B0del(0,0,m6sq,mudim) + 12*m2**4*m5**4*B0fin(0,0,m2sq,mudim) + 4*m1sq*m2sq*m5**4*B0fin(0,0,m2sq,mudim) - 16*m1sq*m2**4*m5sq*B0fin(0,0,m2sq,mudim) - 48*m2**6*m5sq*B0fin(0,0,m2sq,mudim) - 12*m2**4*m6**4*B0fin(0,0,m2sq,mudim) - 4*m1sq*m2sq*m6**4*B0fin(0,0,m2sq,mudim) + 4*m2sq*m5sq*m6**4*B0fin(0,0,m2sq,mudim) + 16*m1sq*m2**4*m6sq*B0fin(0,0,m2sq,mudim) + 48*m2**6*m6sq*B0fin(0,0,m2sq,mudim) - 4*m2sq*m5**4*m6sq*B0fin(0,0,m2sq,mudim) + 6*m2**4*m5**4*B0fin(0,0,m2sq,mudim)**2 + 2*m1sq*m2sq*m5**4*B0fin(0,0,m2sq,mudim)**2 - 8*m1sq*m2**4*m5sq*B0fin(0,0,m2sq,mudim)**2 - 24*m2**6*m5sq*B0fin(0,0,m2sq,mudim)**2 - 6*m2**4*m6**4*B0fin(0,0,m2sq,mudim)**2 - 2*m1sq*m2sq*m6**4*B0fin(0,0,m2sq,mudim)**2 + m1sq*m5sq*m6**4*B0fin(0,0,m2sq,mudim)**2 + m2sq*m5sq*m6**4*B0fin(0,0,m2sq,mudim)**2 + 8*m1sq*m2**4*m6sq*B0fin(0,0,m2sq,mudim)**2 + 24*m2**6*m6sq*B0fin(0,0,m2sq,mudim)**2 - m1sq*m5**4*m6sq*B0fin(0,0,m2sq,mudim)**2 - m2sq*m5**4*m6sq*B0fin(0,0,m2sq,mudim)**2 - 2*m1sq*m5sq*m6**4*B0fin(0,0,m5sq,mudim) + 2*m2sq*m5sq*m6**4*B0fin(0,0,m5sq,mudim) - 8*m2**4*m5sq*m6sq*B0fin(0,0,m5sq,mudim) + 8*m1sq*m2sq*m5sq*m6sq*B0fin(0,0,m5sq,mudim) - 2*m1sq*m5sq*m6**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m2sq*m5sq*m6**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 8*m2**4*m5sq*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 8*m1sq*m2sq*m5sq*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m1sq*m5**4*m6sq*B0fin(0,0,m6sq,mudim) - 2*m2sq*m5**4*m6sq*B0fin(0,0,m6sq,mudim) + 8*m2**4*m5sq*m6sq*B0fin(0,0,m6sq,mudim) - 8*m1sq*m2sq*m5sq*m6sq*B0fin(0,0,m6sq,mudim) + 2*m1sq*m5**4*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m2sq*m5**4*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) + 8*m2**4*m5sq*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) - 8*m1sq*m2sq*m5sq*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) - 8*m2sq*m5**4*T134fin(m2,m1,0,mudim) + 32*m2**4*m5sq*T134fin(m2,m1,0,mudim) + 8*m2sq*m6**4*T134fin(m2,m1,0,mudim) - 2*m5sq*m6**4*T134fin(m2,m1,0,mudim) - 32*m2**4*m6sq*T134fin(m2,m1,0,mudim) + 2*m5**4*m6sq*T134fin(m2,m1,0,mudim) - 8*m2sq*m6**4*T134fin(m5,m2,m1,mudim) + 2*m5sq*m6**4*T134fin(m5,m2,m1,mudim) + 32*m2**4*m6sq*T134fin(m5,m2,m1,mudim) - 8*m2sq*m5sq*m6sq*T134fin(m5,m2,m1,mudim) + 2*m1sq*m6**4*T134fin(m5,m2,m2,mudim) + 6*m2sq*m6**4*T134fin(m5,m2,m2,mudim) - 2*m5sq*m6**4*T134fin(m5,m2,m2,mudim) - 24*m2**4*m6sq*T134fin(m5,m2,m2,mudim) - 8*m1sq*m2sq*m6sq*T134fin(m5,m2,m2,mudim) + 8*m2sq*m5sq*m6sq*T134fin(m5,m2,m2,mudim) + 8*m2sq*m5**4*T134fin(m6,m2,m1,mudim) - 32*m2**4*m5sq*T134fin(m6,m2,m1,mudim) - 2*m5**4*m6sq*T134fin(m6,m2,m1,mudim) + 8*m2sq*m5sq*m6sq*T134fin(m6,m2,m1,mudim) - 2*m1sq*m5**4*T134fin(m6,m2,m2,mudim) - 6*m2sq*m5**4*T134fin(m6,m2,m2,mudim) + 24*m2**4*m5sq*T134fin(m6,m2,m2,mudim) + 8*m1sq*m2sq*m5sq*T134fin(m6,m2,m2,mudim) + 2*m5**4*m6sq*T134fin(m6,m2,m2,mudim) - 8*m2sq*m5sq*m6sq*T134fin(m6,m2,m2,mudim))/(2.*(m1sq - m2sq)**2*m5**2*(4*m2sq - m5sq)*m6**2*(4*m2sq - m6sq)*(m5sq - m6sq))
		def eval_120():
			return -0.5*(-2*(m1sq - m2sq)*m5**4*(m2sq - m6sq)**3*B0del(0,0,m5sq,mudim) + 2*(m1sq - m2sq)*(m2sq - m5sq)**3*m6**4*B0del(0,0,m6sq,mudim) + (2*(m1sq - m2sq)*(m2sq - m5sq)**3*m6**4 - 2*(m1sq - m2sq)*m5**4*(m2sq - m6sq)**3 + (m1sq + m2sq)*(m2sq - m5sq)**2*(m2sq - m6sq)**2*(m5sq - m6sq))*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)) + (m2sq - m5sq)**2*(m2sq - m6sq)**2*(m5sq - m6sq)*((m1sq + m2sq)*B0del(0,0,m2sq,mudim) + 4*m2sq*(2 + B0fin(0,0,m2sq,mudim))) - (1 - B0fin(0,0,m2sq,mudim))*((m2sq - m5sq)**2*(m2sq - m6sq)**2*(m5sq - m6sq)*(4*m2sq + (m1sq + m2sq)*B0fin(0,0,m2sq,mudim)) - 2*(m1sq - m2sq)*m5**4*(m2sq - m6sq)**3*B0fin(0,0,m5sq,mudim) + 2*(m1sq - m2sq)*(m2sq - m5sq)**3*m6**4*B0fin(0,0,m6sq,mudim)) + 2*(m1sq - m2sq)*m2sq*(m5sq*(m2sq - m6sq)**3*B0del(0,0,m5sq,mudim) - (m2sq - m5sq)**3*m6sq*B0del(0,0,m6sq,mudim) + (m5sq*(m2sq - m6sq)**3 - (m2sq - m5sq)**3*m6sq)*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)) + (-1 + B0fin(0,0,m2sq,mudim))*(m5sq*(m2sq - m6sq)**3*B0fin(0,0,m5sq,mudim) - (m2sq - m5sq)**3*m6sq*B0fin(0,0,m6sq,mudim))) - 2*(m2sq - m5sq)**2*(m2sq - m6sq)**2*(m5sq - m6sq)*T134fin(m2,m1,0,mudim) + 2*(m2sq - m5sq)**2*(m2sq - m6sq)**3*T134fin(m5,m1,0,mudim) + 2*(m2sq - m5sq)*(m2sq - m6sq)**3*((m1sq - m2sq)*(m2sq + m5sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim)) + (-m1sq + m5sq)*T134fin(m5,m2,0,mudim)) - 2*(m2sq - m5sq)**3*(m2sq - m6sq)**2*T134fin(m6,m1,0,mudim) - 2*(m2sq - m5sq)**3*(m2sq - m6sq)*((m1sq - m2sq)*(m2sq + m6sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)) + (-m1sq + m6sq)*T134fin(m6,m2,0,mudim)))/((m1sq - m2sq)**2*(m2sq - m5sq)**3*(m2sq - m6sq)**3*(m5sq - m6sq))
		def eval_121():
			return (2*m1**4*(m2sq - m3sq)**3*(m2sq - m6sq)*B0del(0,0,m1sq,mudim) + 2*(m1sq - m2sq)**3*m3**4*(m2sq - m6sq)*B0del(0,0,m3sq,mudim) + (2*(m1sq - m2sq)**3*m3**4*(m2sq - m6sq) + 2*m1**4*(m2sq - m3sq)**3*(m2sq - m6sq) + (m1sq - m2sq)**2*(m1sq - m3sq)*(m2sq - m3sq)**2*(m2sq + m6sq))*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)) + (m1sq - m2sq)**2*(m1sq - m3sq)*(m2sq - m3sq)**2*((m2sq + m6sq)*B0del(0,0,m2sq,mudim) + 4*m2sq*(2 + B0fin(0,0,m2sq,mudim))) - (1 - B0fin(0,0,m2sq,mudim))*(2*m1**4*(m2sq - m3sq)**3*(m2sq - m6sq)*B0fin(0,0,m1sq,mudim) + (m1sq - m2sq)**2*(m1sq - m3sq)*(m2sq - m3sq)**2*(4*m2sq + (m2sq + m6sq)*B0fin(0,0,m2sq,mudim)) + 2*(m1sq - m2sq)**3*m3**4*(m2sq - m6sq)*B0fin(0,0,m3sq,mudim)) - 2*m2sq*(m2sq - m6sq)*(m1sq*(m2sq - m3sq)**3*B0del(0,0,m1sq,mudim) + (m1sq - m2sq)**3*m3sq*B0del(0,0,m3sq,mudim) + (m1sq*(m2sq - m3sq)**3 + (m1sq - m2sq)**3*m3sq)*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)) + (-1 + B0fin(0,0,m2sq,mudim))*(m1sq*(m2sq - m3sq)**3*B0fin(0,0,m1sq,mudim) + (m1sq - m2sq)**3*m3sq*B0fin(0,0,m3sq,mudim))) - 2*(m1sq - m2sq)*(m2sq - m3sq)**3*(-((m2sq - m6sq)*(m1sq + m2sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim))) + (m1sq - m6sq)*T134fin(m2,m1,0,mudim)) + 2*(m1sq - m2sq)**3*(m2sq - m3sq)*(-((m2sq - m6sq)*(m2sq + m3sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim))) + (m3sq - m6sq)*T134fin(m3,m2,0,mudim)) + 2*(m1sq - m2sq)**2*(m2sq - m3sq)**3*T134fin(m6,m1,0,mudim) - 2*(m1sq - m2sq)**2*(m1sq - m3sq)*(m2sq - m3sq)**2*T134fin(m6,m2,0,mudim) + 2*(m1sq - m2sq)**3*(m2sq - m3sq)**2*T134fin(m6,m3,0,mudim))/(2.*(m1sq - m2sq)**3*(m1sq - m3sq)*(m2sq - m3sq)**3*(m2sq - m6sq)**2)
		def eval_122():
			return -0.5*(-12*m1**4*m5**4 - 4*m1sq*m3sq*m5**4 + 48*m1**6*m5sq + 16*m1**4*m3sq*m5sq + 12*m1**4*m6**4 + 4*m1sq*m3sq*m6**4 - 6*m1sq*m5sq*m6**4 + 2*m3sq*m5sq*m6**4 - 48*m1**6*m6sq - 16*m1**4*m3sq*m6sq + 6*m1sq*m5**4*m6sq - 2*m3sq*m5**4*m6sq + 4*m1sq*(m5sq - m6sq)*(12*m1**4 + m5sq*m6sq - m3sq*(m5sq + m6sq) + m1sq*(4*m3sq - 3*(m5sq + m6sq)))*B0del(0,0,m1sq,mudim) + 2*(m1sq - m3sq)*m5sq*(4*m1sq - m6sq)*m6sq*B0del(0,0,m5sq,mudim) + 2*m1sq*m5**4*m6sq*B0del(0,0,m6sq,mudim) - 2*m3sq*m5**4*m6sq*B0del(0,0,m6sq,mudim) - 8*m1**4*m5sq*m6sq*B0del(0,0,m6sq,mudim) + 8*m1sq*m3sq*m5sq*m6sq*B0del(0,0,m6sq,mudim) - 12*m1**4*m5**4*B0fin(0,0,m1sq,mudim) - 4*m1sq*m3sq*m5**4*B0fin(0,0,m1sq,mudim) + 48*m1**6*m5sq*B0fin(0,0,m1sq,mudim) + 16*m1**4*m3sq*m5sq*B0fin(0,0,m1sq,mudim) + 12*m1**4*m6**4*B0fin(0,0,m1sq,mudim) + 4*m1sq*m3sq*m6**4*B0fin(0,0,m1sq,mudim) - 4*m1sq*m5sq*m6**4*B0fin(0,0,m1sq,mudim) - 48*m1**6*m6sq*B0fin(0,0,m1sq,mudim) - 16*m1**4*m3sq*m6sq*B0fin(0,0,m1sq,mudim) + 4*m1sq*m5**4*m6sq*B0fin(0,0,m1sq,mudim) - 6*m1**4*m5**4*B0fin(0,0,m1sq,mudim)**2 - 2*m1sq*m3sq*m5**4*B0fin(0,0,m1sq,mudim)**2 + 24*m1**6*m5sq*B0fin(0,0,m1sq,mudim)**2 + 8*m1**4*m3sq*m5sq*B0fin(0,0,m1sq,mudim)**2 + 6*m1**4*m6**4*B0fin(0,0,m1sq,mudim)**2 + 2*m1sq*m3sq*m6**4*B0fin(0,0,m1sq,mudim)**2 - m1sq*m5sq*m6**4*B0fin(0,0,m1sq,mudim)**2 - m3sq*m5sq*m6**4*B0fin(0,0,m1sq,mudim)**2 - 24*m1**6*m6sq*B0fin(0,0,m1sq,mudim)**2 - 8*m1**4*m3sq*m6sq*B0fin(0,0,m1sq,mudim)**2 + m1sq*m5**4*m6sq*B0fin(0,0,m1sq,mudim)**2 + m3sq*m5**4*m6sq*B0fin(0,0,m1sq,mudim)**2 - 2*m1sq*m5sq*m6**4*B0fin(0,0,m5sq,mudim) + 2*m3sq*m5sq*m6**4*B0fin(0,0,m5sq,mudim) + 8*m1**4*m5sq*m6sq*B0fin(0,0,m5sq,mudim) - 8*m1sq*m3sq*m5sq*m6sq*B0fin(0,0,m5sq,mudim) - 2*m1sq*m5sq*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m3sq*m5sq*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 8*m1**4*m5sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 8*m1sq*m3sq*m5sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m1sq*m5**4*m6sq*B0fin(0,0,m6sq,mudim) - 2*m3sq*m5**4*m6sq*B0fin(0,0,m6sq,mudim) - 8*m1**4*m5sq*m6sq*B0fin(0,0,m6sq,mudim) + 8*m1sq*m3sq*m5sq*m6sq*B0fin(0,0,m6sq,mudim) + 2*m1sq*m5**4*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m3sq*m5**4*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 8*m1**4*m5sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 8*m1sq*m3sq*m5sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 8*m1sq*m5**4*T134fin(m3,m1,0,mudim) - 32*m1**4*m5sq*T134fin(m3,m1,0,mudim) - 8*m1sq*m6**4*T134fin(m3,m1,0,mudim) + 2*m5sq*m6**4*T134fin(m3,m1,0,mudim) + 32*m1**4*m6sq*T134fin(m3,m1,0,mudim) - 2*m5**4*m6sq*T134fin(m3,m1,0,mudim) - 6*m1sq*m6**4*T134fin(m5,m1,m1,mudim) - 2*m3sq*m6**4*T134fin(m5,m1,m1,mudim) + 2*m5sq*m6**4*T134fin(m5,m1,m1,mudim) + 24*m1**4*m6sq*T134fin(m5,m1,m1,mudim) + 8*m1sq*m3sq*m6sq*T134fin(m5,m1,m1,mudim) - 8*m1sq*m5sq*m6sq*T134fin(m5,m1,m1,mudim) + 8*m1sq*m6**4*T134fin(m5,m3,m1,mudim) - 2*m5sq*m6**4*T134fin(m5,m3,m1,mudim) - 32*m1**4*m6sq*T134fin(m5,m3,m1,mudim) + 8*m1sq*m5sq*m6sq*T134fin(m5,m3,m1,mudim) + 6*m1sq*m5**4*T134fin(m6,m1,m1,mudim) + 2*m3sq*m5**4*T134fin(m6,m1,m1,mudim) - 24*m1**4*m5sq*T134fin(m6,m1,m1,mudim) - 8*m1sq*m3sq*m5sq*T134fin(m6,m1,m1,mudim) - 2*m5**4*m6sq*T134fin(m6,m1,m1,mudim) + 8*m1sq*m5sq*m6sq*T134fin(m6,m1,m1,mudim) - 8*m1sq*m5**4*T134fin(m6,m3,m1,mudim) + 32*m1**4*m5sq*T134fin(m6,m3,m1,mudim) + 2*m5**4*m6sq*T134fin(m6,m3,m1,mudim) - 8*m1sq*m5sq*m6sq*T134fin(m6,m3,m1,mudim))/((m1sq - m3sq)**2*m5**2*(4*m1sq - m5sq)*m6**2*(4*m1sq - m6sq)*(m5sq - m6sq))
		def eval_123():
			return (-2*(m1sq - m3sq)*m5**4*(m1sq - m6sq)**3*B0del(0,0,m5sq,mudim) + 2*(m1sq - m3sq)*(m1sq - m5sq)**3*m6**4*B0del(0,0,m6sq,mudim) + (2*(m1sq - m3sq)*(m1sq - m5sq)**3*m6**4 - 2*(m1sq - m3sq)*m5**4*(m1sq - m6sq)**3 - (m1sq + m3sq)*(m1sq - m5sq)**2*(m1sq - m6sq)**2*(m5sq - m6sq))*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)) - (m1sq - m5sq)**2*(m1sq - m6sq)**2*(m5sq - m6sq)*((m1sq + m3sq)*B0del(0,0,m1sq,mudim) + 4*m1sq*(2 + B0fin(0,0,m1sq,mudim))) + (1 - B0fin(0,0,m1sq,mudim))*((m1sq - m5sq)**2*(m1sq - m6sq)**2*(m5sq - m6sq)*(4*m1sq + (m1sq + m3sq)*B0fin(0,0,m1sq,mudim)) + 2*(m1sq - m3sq)*m5**4*(m1sq - m6sq)**3*B0fin(0,0,m5sq,mudim) - 2*(m1sq - m3sq)*(m1sq - m5sq)**3*m6**4*B0fin(0,0,m6sq,mudim)) + 2*m1sq*(m1sq - m3sq)*(m5sq*(m1sq - m6sq)**3*B0del(0,0,m5sq,mudim) - (m1sq - m5sq)**3*m6sq*B0del(0,0,m6sq,mudim) + (m5sq*(m1sq - m6sq)**3 - (m1sq - m5sq)**3*m6sq)*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)) + (-1 + B0fin(0,0,m1sq,mudim))*(m5sq*(m1sq - m6sq)**3*B0fin(0,0,m5sq,mudim) - (m1sq - m5sq)**3*m6sq*B0fin(0,0,m6sq,mudim))) + 2*(m1sq - m5sq)**2*(m1sq - m6sq)**2*(m5sq - m6sq)*T134fin(m3,m1,0,mudim) - 2*(m1sq - m5sq)*(m1sq - m6sq)**3*(-((m1sq - m3sq)*(m1sq + m5sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim))) + (-m3sq + m5sq)*T134fin(m5,m1,0,mudim)) - 2*(m1sq - m5sq)**2*(m1sq - m6sq)**3*T134fin(m5,m3,0,mudim) + 2*(m1sq - m5sq)**3*(m1sq - m6sq)*(-((m1sq - m3sq)*(m1sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim))) + (-m3sq + m6sq)*T134fin(m6,m1,0,mudim)) + 2*(m1sq - m5sq)**3*(m1sq - m6sq)**2*T134fin(m6,m3,0,mudim))/(2.*(m1sq - m3sq)**2*(m1sq - m5sq)**3*(m1sq - m6sq)**3*(m5sq - m6sq))
		def eval_124():
			return (-2*m2**4*(m1sq - m3sq)**3*(m1sq - m6sq)*B0del(0,0,m2sq,mudim) + 2*(m1sq - m2sq)**3*m3**4*(m1sq - m6sq)*B0del(0,0,m3sq,mudim) + (2*(m1sq - m2sq)**3*m3**4*(m1sq - m6sq) - 2*m2**4*(m1sq - m3sq)**3*(m1sq - m6sq) - (m1sq - m2sq)**2*(m1sq - m3sq)**2*(m2sq - m3sq)*(m1sq + m6sq))*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)) - (m1sq - m2sq)**2*(m1sq - m3sq)**2*(m2sq - m3sq)*((m1sq + m6sq)*B0del(0,0,m1sq,mudim) + 4*m1sq*(2 + B0fin(0,0,m1sq,mudim))) + (1 - B0fin(0,0,m1sq,mudim))*((m1sq - m2sq)**2*(m1sq - m3sq)**2*(m2sq - m3sq)*(4*m1sq + (m1sq + m6sq)*B0fin(0,0,m1sq,mudim)) + 2*m2**4*(m1sq - m3sq)**3*(m1sq - m6sq)*B0fin(0,0,m2sq,mudim) - 2*(m1sq - m2sq)**3*m3**4*(m1sq - m6sq)*B0fin(0,0,m3sq,mudim)) + 2*m1sq*(m1sq - m6sq)*(m2sq*(m1sq - m3sq)**3*B0del(0,0,m2sq,mudim) - (m1sq - m2sq)**3*m3sq*B0del(0,0,m3sq,mudim) + (m2sq*(m1sq - m3sq)**3 - (m1sq - m2sq)**3*m3sq)*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)) + (-1 + B0fin(0,0,m1sq,mudim))*(m2sq*(m1sq - m3sq)**3*B0fin(0,0,m2sq,mudim) - (m1sq - m2sq)**3*m3sq*B0fin(0,0,m3sq,mudim))) - 2*(m1sq - m2sq)*(m1sq - m3sq)**3*(-((m1sq - m6sq)*(m1sq + m2sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim))) + (m2sq - m6sq)*T134fin(m2,m1,0,mudim)) + 2*(m1sq - m2sq)**3*(m1sq - m3sq)*(-((m1sq - m6sq)*(m1sq + m3sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim))) + (m3sq - m6sq)*T134fin(m3,m1,0,mudim)) + 2*(m1sq - m2sq)**2*(m1sq - m3sq)**2*(m2sq - m3sq)*T134fin(m6,m1,0,mudim) - 2*(m1sq - m2sq)**2*(m1sq - m3sq)**3*T134fin(m6,m2,0,mudim) + 2*(m1sq - m2sq)**3*(m1sq - m3sq)**2*T134fin(m6,m3,0,mudim))/(2.*(m1sq - m2sq)**3*(m1sq - m3sq)**3*(m2sq - m3sq)*(m1sq - m6sq)**2)
		def eval_125():
			return (-m1**14 - 9*m1**10*m4**4 + 5*m1**8*m4**6 + 5*m1**6*m4**8 - 9*m1**4*m4**10 + 5*m1sq*m4**12 - m4**14 + 5*m1**12*m4sq - 9*m1**10*m7**4 - 2*m1**6*m4**4*m7**4 - 2*m1**4*m4**6*m7**4 + 59*m1sq*m4**8*m7**4 - 9*m4**10*m7**4 + 59*m1**8*m4sq*m7**4 + 5*m1**8*m7**6 - 2*m1**4*m4**4*m7**6 - 124*m1sq*m4**6*m7**6 + 5*m4**8*m7**6 - 124*m1**6*m4sq*m7**6 + 5*m1**6*m7**8 + 59*m1sq*m4**4*m7**8 + 5*m4**6*m7**8 + 59*m1**4*m4sq*m7**8 - 9*m1**4*m7**10 - 9*m4**4*m7**10 - 2*m1sq*m4sq*m7**10 + 5*m1sq*m7**12 + 5*m4sq*m7**12 - m7**14 + 5*m1**12*m7sq + 59*m1**8*m4**4*m7sq - 124*m1**6*m4**6*m7sq + 59*m1**4*m4**8*m7sq - 2*m1sq*m4**10*m7sq + 5*m4**12*m7sq - 2*m1**10*m4sq*m7sq + 24*m1**4*m4sq*m7sq*(m1**6 - m1**4*(m4sq + m7sq) + (m4sq - m7sq)**2*(m4sq + m7sq) - m1sq*(m4**4 + m7**4 - 4*m4sq*m7sq))*B0del(0,0,m1sq,mudim) + 24*m1sq*m4**4*m7sq*(m1**6 - m1**4*(m4sq + m7sq) + (m4sq - m7sq)**2*(m4sq + m7sq) - m1sq*(m4**4 + m7**4 - 4*m4sq*m7sq))*B0del(0,0,m4sq,mudim) - 24*m1**6*m4**4*m7**4*B0del(0,0,m7sq,mudim) - 24*m1**4*m4**6*m7**4*B0del(0,0,m7sq,mudim) + 24*m1sq*m4**8*m7**4*B0del(0,0,m7sq,mudim) + 24*m1**8*m4sq*m7**4*B0del(0,0,m7sq,mudim) + 96*m1**4*m4**4*m7**6*B0del(0,0,m7sq,mudim) - 24*m1sq*m4**6*m7**6*B0del(0,0,m7sq,mudim) - 24*m1**6*m4sq*m7**6*B0del(0,0,m7sq,mudim) - 24*m1sq*m4**4*m7**8*B0del(0,0,m7sq,mudim) - 24*m1**4*m4sq*m7**8*B0del(0,0,m7sq,mudim) + 24*m1sq*m4sq*m7**10*B0del(0,0,m7sq,mudim) + 10*m1**10*m4**4*B0fin(0,0,m1sq,mudim) - 20*m1**8*m4**6*B0fin(0,0,m1sq,mudim) + 20*m1**6*m4**8*B0fin(0,0,m1sq,mudim) - 10*m1**4*m4**10*B0fin(0,0,m1sq,mudim) + 2*m1sq*m4**12*B0fin(0,0,m1sq,mudim) - 2*m1**12*m4sq*B0fin(0,0,m1sq,mudim) + 10*m1**10*m7**4*B0fin(0,0,m1sq,mudim) + 64*m1**6*m4**4*m7**4*B0fin(0,0,m1sq,mudim) - 8*m1**4*m4**6*m7**4*B0fin(0,0,m1sq,mudim) - 66*m1sq*m4**8*m7**4*B0fin(0,0,m1sq,mudim) + 48*m1**8*m4sq*m7**4*B0fin(0,0,m1sq,mudim) - 20*m1**8*m7**6*B0fin(0,0,m1sq,mudim) - 8*m1**4*m4**4*m7**6*B0fin(0,0,m1sq,mudim) + 104*m1sq*m4**6*m7**6*B0fin(0,0,m1sq,mudim) - 76*m1**6*m4sq*m7**6*B0fin(0,0,m1sq,mudim) + 20*m1**6*m7**8*B0fin(0,0,m1sq,mudim) - 66*m1sq*m4**4*m7**8*B0fin(0,0,m1sq,mudim) + 18*m1**4*m4sq*m7**8*B0fin(0,0,m1sq,mudim) - 10*m1**4*m7**10*B0fin(0,0,m1sq,mudim) + 12*m1sq*m4sq*m7**10*B0fin(0,0,m1sq,mudim) + 2*m1sq*m7**12*B0fin(0,0,m1sq,mudim) - 2*m1**12*m7sq*B0fin(0,0,m1sq,mudim) + 48*m1**8*m4**4*m7sq*B0fin(0,0,m1sq,mudim) - 76*m1**6*m4**6*m7sq*B0fin(0,0,m1sq,mudim) + 18*m1**4*m4**8*m7sq*B0fin(0,0,m1sq,mudim) + 12*m1sq*m4**10*m7sq*B0fin(0,0,m1sq,mudim) - 10*m1**10*m4**4*B0fin(0,0,m4sq,mudim) + 20*m1**8*m4**6*B0fin(0,0,m4sq,mudim) - 20*m1**6*m4**8*B0fin(0,0,m4sq,mudim) + 10*m1**4*m4**10*B0fin(0,0,m4sq,mudim) - 2*m1sq*m4**12*B0fin(0,0,m4sq,mudim) + 2*m1**12*m4sq*B0fin(0,0,m4sq,mudim) - 8*m1**6*m4**4*m7**4*B0fin(0,0,m4sq,mudim) + 64*m1**4*m4**6*m7**4*B0fin(0,0,m4sq,mudim) + 48*m1sq*m4**8*m7**4*B0fin(0,0,m4sq,mudim) + 10*m4**10*m7**4*B0fin(0,0,m4sq,mudim) - 66*m1**8*m4sq*m7**4*B0fin(0,0,m4sq,mudim) - 8*m1**4*m4**4*m7**6*B0fin(0,0,m4sq,mudim) - 76*m1sq*m4**6*m7**6*B0fin(0,0,m4sq,mudim) - 20*m4**8*m7**6*B0fin(0,0,m4sq,mudim) + 104*m1**6*m4sq*m7**6*B0fin(0,0,m4sq,mudim) + 18*m1sq*m4**4*m7**8*B0fin(0,0,m4sq,mudim) + 20*m4**6*m7**8*B0fin(0,0,m4sq,mudim) - 66*m1**4*m4sq*m7**8*B0fin(0,0,m4sq,mudim) - 10*m4**4*m7**10*B0fin(0,0,m4sq,mudim) + 12*m1sq*m4sq*m7**10*B0fin(0,0,m4sq,mudim) + 2*m4sq*m7**12*B0fin(0,0,m4sq,mudim) + 18*m1**8*m4**4*m7sq*B0fin(0,0,m4sq,mudim) - 76*m1**6*m4**6*m7sq*B0fin(0,0,m4sq,mudim) + 48*m1**4*m4**8*m7sq*B0fin(0,0,m4sq,mudim) - 2*m4**12*m7sq*B0fin(0,0,m4sq,mudim) + 12*m1**10*m4sq*m7sq*B0fin(0,0,m4sq,mudim) + 48*m1**6*m4**4*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 48*m1**4*m4**6*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 24*m1sq*m4**8*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 24*m1**8*m4sq*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 72*m1**4*m4**4*m7**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 24*m1sq*m4**4*m7**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 24*m1**4*m4sq*m7**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 12*m1sq*m4sq*m7**10*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 24*m1**6*m4**6*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 12*m1sq*m4**10*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 12*m1**10*m4sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 10*m1**10*m7**4*B0fin(0,0,m7sq,mudim) - 8*m1**6*m4**4*m7**4*B0fin(0,0,m7sq,mudim) - 8*m1**4*m4**6*m7**4*B0fin(0,0,m7sq,mudim) + 18*m1sq*m4**8*m7**4*B0fin(0,0,m7sq,mudim) - 10*m4**10*m7**4*B0fin(0,0,m7sq,mudim) + 18*m1**8*m4sq*m7**4*B0fin(0,0,m7sq,mudim) + 20*m1**8*m7**6*B0fin(0,0,m7sq,mudim) + 64*m1**4*m4**4*m7**6*B0fin(0,0,m7sq,mudim) - 76*m1sq*m4**6*m7**6*B0fin(0,0,m7sq,mudim) + 20*m4**8*m7**6*B0fin(0,0,m7sq,mudim) - 76*m1**6*m4sq*m7**6*B0fin(0,0,m7sq,mudim) - 20*m1**6*m7**8*B0fin(0,0,m7sq,mudim) + 48*m1sq*m4**4*m7**8*B0fin(0,0,m7sq,mudim) - 20*m4**6*m7**8*B0fin(0,0,m7sq,mudim) + 48*m1**4*m4sq*m7**8*B0fin(0,0,m7sq,mudim) + 10*m1**4*m7**10*B0fin(0,0,m7sq,mudim) + 10*m4**4*m7**10*B0fin(0,0,m7sq,mudim) - 2*m1sq*m7**12*B0fin(0,0,m7sq,mudim) - 2*m4sq*m7**12*B0fin(0,0,m7sq,mudim) + 2*m1**12*m7sq*B0fin(0,0,m7sq,mudim) - 66*m1**8*m4**4*m7sq*B0fin(0,0,m7sq,mudim) + 104*m1**6*m4**6*m7sq*B0fin(0,0,m7sq,mudim) - 66*m1**4*m4**8*m7sq*B0fin(0,0,m7sq,mudim) + 12*m1sq*m4**10*m7sq*B0fin(0,0,m7sq,mudim) + 2*m4**12*m7sq*B0fin(0,0,m7sq,mudim) + 12*m1**10*m4sq*m7sq*B0fin(0,0,m7sq,mudim) + 48*m1**6*m4**4*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 72*m1**4*m4**6*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) + 24*m1sq*m4**8*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) + 48*m1**4*m4**4*m7**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 24*m1**6*m4sq*m7**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 24*m1sq*m4**4*m7**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) + 12*m1sq*m4sq*m7**10*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 24*m1**8*m4**4*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) + 24*m1**4*m4**8*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 12*m1sq*m4**10*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) + 12*m1**10*m4sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 72*m1**6*m4**4*m7**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) + 48*m1**4*m4**6*m7**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) + 24*m1**8*m4sq*m7**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) + 48*m1**4*m4**4*m7**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) - 24*m1sq*m4**6*m7**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) - 24*m1**4*m4sq*m7**8*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) + 12*m1sq*m4sq*m7**10*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) + 24*m1**8*m4**4*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) - 24*m1**4*m4**8*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) + 12*m1sq*m4**10*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) - 12*m1**10*m4sq*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) - 96*m1**4*m4**4*m7**4*T134fin(m7,m4,m1,mudim) + 24*m1sq*m4**6*m7**4*T134fin(m7,m4,m1,mudim) + 24*m1**6*m4sq*m7**4*T134fin(m7,m4,m1,mudim) + 24*m1sq*m4**4*m7**6*T134fin(m7,m4,m1,mudim) + 24*m1**4*m4sq*m7**6*T134fin(m7,m4,m1,mudim) - 24*m1sq*m4sq*m7**8*T134fin(m7,m4,m1,mudim) + 24*m1**6*m4**4*m7sq*T134fin(m7,m4,m1,mudim) + 24*m1**4*m4**6*m7sq*T134fin(m7,m4,m1,mudim) - 24*m1sq*m4**8*m7sq*T134fin(m7,m4,m1,mudim) - 24*m1**8*m4sq*m7sq*T134fin(m7,m4,m1,mudim))/(4.*m1**2*m4**2*(m1 + m4 - m7)**4*(m1 - m4 + m7)**4*(-m1 + m4 + m7)**4*(m1 + m4 + m7)**4)
		def eval_126():
			return (m1**8/(m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (3*m1sq*m4**4)/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (7*m1**4*m4sq)/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (5*m1sq*m7**4)/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (6*m1**4*m7**4)/(m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (4*m1sq*m7**6)/(m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (6*m2**8*(m1sq - m2sq))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (m2**10*(-m1sq + m2sq))/(m4**2*(m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (10*m2**4*(m1sq - m2sq)*m4**4)/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (12*m2**6*(-m1sq + m2sq)*m4sq)/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (2*m2**4*(m1sq - m2sq)*m7**4)/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (10*m2**6*(-m1sq + m2sq)*m7**4)/(m4**2*(m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (20*(m1sq - m2sq)*m2sq*m4sq*m7**4)/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (12*m2sq*(-m1sq + m2sq)*m7**6)/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (10*m2**4*(m1sq - m2sq)*m7**6)/(m4**2*(m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (4*(m1sq - m2sq)*m2sq*m7**8)/(m4**2*(m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) - m2**8/(m4**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (3*m2sq*m4**4)/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (7*m2**4*m4sq)/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (5*m2sq*m7**4)/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (6*m2**4*m7**4)/(m4**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (4*m2sq*m7**6)/(m4**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (3*m2sq*(-m1sq + m2sq)*m4**4*(m4sq - m7sq))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (13*m2sq*(-m1sq + m2sq)*m7**4*(m4sq - m7sq))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (9*(m1sq - m2sq)*m2sq*m7**6*(m4sq - m7sq))/(m4**2*(m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (6*(m1sq - m2sq)*m7**4*(m4sq - m7sq)**2)/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) - ((m1sq - m2sq)*m7**6*(m4sq - m7sq)**2)/(m4**2*(m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (5*m1**4*m7sq)/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (m1**6*m7sq)/(m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m1sq*m4sq*m7sq)/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (18*m2**6*(-m1sq + m2sq)*m7sq)/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (5*m2**8*(m1sq - m2sq)*m7sq)/(m4**2*(m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (4*(m1sq - m2sq)*m2sq*m4**4*m7sq)/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (2*m2**4*(-m1sq + m2sq)*m4sq*m7sq)/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) - (5*m2**4*m7sq)/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (m2**6*m7sq)/(m4**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (2*m2sq*m4sq*m7sq)/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (7*(m1sq - m2sq)*m2sq*m4sq*(m4sq - m7sq)*m7sq)/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) - ((m1sq - m2sq)*m4sq*(m4sq - m7sq)**2*m7sq)/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (2*(m1sq - m2sq)*(m4sq - m7sq)**3*m7sq)/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + ((-(m4sq*m7) + m7**3)**2*(-3*m4sq + m7sq))/(m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - ((-(m4sq*m7) + m7**3)**2*(-3*m4sq + m7sq))/(m4**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (2*(m1sq - m2sq)*m7**4*(-m4sq + m7sq)**3)/(m4**2*(m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) - (4*m1sq*m7sq*(m1sq - m4sq + m7sq))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (4*m2sq*m7sq*(m2sq - m4sq + m7sq))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (2*m1**4*(m1sq + m4sq + m7sq))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (4*m1sq*m4sq*(m1sq + m4sq + m7sq))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*(m4sq - m7sq)**2*(m1sq + m4sq + m7sq))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (4*m1sq*m7sq*(m1sq + m4sq + m7sq))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (8*m2sq*(-m1sq + m2sq)*m7**4*(m2sq + m4sq + m7sq))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) - (2*m2**4*(m2sq + m4sq + m7sq))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (4*m2sq*m4sq*(m2sq + m4sq + m7sq))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (8*(m1sq - m2sq)*(-(m4sq*m7) + m7**3)**2*(m2sq + m4sq + m7sq))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) - (2*(m4sq - m7sq)**2*(m2sq + m4sq + m7sq))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (16*m2**4*(m1sq - m2sq)*m7sq*(m2sq + m4sq + m7sq))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (8*m2sq*(-m1sq + m2sq)*m4sq*m7sq*(m2sq + m4sq + m7sq))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) - (4*m2sq*m7sq*(m2sq + m4sq + m7sq))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (m1**6*(5*m4sq + 3*m7sq))/(m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m2**6*(5*m4sq + 3*m7sq))/(m4**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (2*m1sq*m7**4*B0del(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m1**4*m7sq*B0del(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m1sq*m4sq*m7sq*B0del(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m1sq*m7sq*(m1sq - m4sq + m7sq)*B0del(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (4*m2**4*(-m1sq + m2sq)*m7**4*B0del(0,0,m2sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (2*m2sq*m7**4*B0del(0,0,m2sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (4*(m1sq - m2sq)*m2sq*m7**4*(m4sq - m7sq)*B0del(0,0,m2sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (8*m2**6*(m1sq - m2sq)*m7sq*B0del(0,0,m2sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (4*m2**4*(-m1sq + m2sq)*m4sq*m7sq*B0del(0,0,m2sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) - (2*m2**4*m7sq*B0del(0,0,m2sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (2*m2sq*m4sq*m7sq*B0del(0,0,m2sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (4*m2sq*(-m1sq + m2sq)*m4sq*(m4sq - m7sq)*m7sq*B0del(0,0,m2sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) - (2*m2sq*m7sq*(m2sq - m4sq + m7sq)*B0del(0,0,m2sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (8*m2sq*(-m1sq + m2sq)*m4sq*m7**4*B0del(0,0,m4sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) - (2*(m1sq - m2sq)*m7**4*(m4sq - m7sq)**2*B0del(0,0,m4sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (4*m1sq*m4sq*m7sq*B0del(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (8*m2**4*(m1sq - m2sq)*m4sq*m7sq*B0del(0,0,m4sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) - (4*m2sq*m4sq*m7sq*B0del(0,0,m4sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (4*m2sq*(-m1sq + m2sq)*m4sq*(m4sq - m7sq)*m7sq*B0del(0,0,m4sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) - (2*(m1sq - m2sq)*m4sq*(m4sq - m7sq)**2*m7sq*B0del(0,0,m4sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (2*(m1sq - m2sq)*m7sq*(-m4sq + m7sq)**3*B0del(0,0,m4sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (2*m1sq*m7**4*B0del(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (8*m2**4*(m1sq - m2sq)*m7**4*B0del(0,0,m7sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (8*m2sq*(-m1sq + m2sq)*m4sq*m7**4*B0del(0,0,m7sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) - (2*m2sq*m7**4*B0del(0,0,m7sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (4*(m1sq - m2sq)*m2sq*m7**4*(m4sq - m7sq)*B0del(0,0,m7sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) - (2*(m1sq - m2sq)*m7**4*(m4sq - m7sq)**2*B0del(0,0,m7sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) - (2*m1**4*m7sq*B0del(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m1sq*m4sq*m7sq*B0del(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m2**4*m7sq*B0del(0,0,m7sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (2*m2sq*m4sq*m7sq*B0del(0,0,m7sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (2*(m1sq - m2sq)*m4sq*(m4sq - m7sq)**2*m7sq*B0del(0,0,m7sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (2*(m1sq - m2sq)*(m4sq - m7sq)**3*m7sq*B0del(0,0,m7sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (2*m1sq*m7sq*(m1sq - m4sq + m7sq)*B0del(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (2*m2sq*m7sq*(m2sq - m4sq + m7sq)*B0del(0,0,m7sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (m1**8*B0fin(0,0,m1sq,mudim))/(m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (3*m1sq*m4**4*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (7*m1**4*m4sq*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (m1sq*m7**4*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (3*m1**4*m7**4*B0fin(0,0,m1sq,mudim))/(m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m1sq*m7**6*B0fin(0,0,m1sq,mudim))/(m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (4*m1**4*m7sq*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (3*m1sq*m4sq*m7sq*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m1sq*m7sq*(m1sq - m4sq + m7sq)*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m1**6*(5*m4sq + 3*m7sq)*B0fin(0,0,m1sq,mudim))/(m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m2**8*(m1sq - m2sq)*B0fin(0,0,m2sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (2*m2**6*(-m1sq + m2sq)*m4sq*B0fin(0,0,m2sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (8*m2**4*(m1sq - m2sq)*m7**4*B0fin(0,0,m2sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (4*m2**6*(m1sq - m2sq)*m7**4*B0fin(0,0,m2sq,mudim))/(m4**2*(m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (6*m2**4*(-m1sq + m2sq)*m7**6*B0fin(0,0,m2sq,mudim))/(m4**2*(m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (m2**8*B0fin(0,0,m2sq,mudim))/(m4**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (3*m2sq*m4**4*B0fin(0,0,m2sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (7*m2**4*m4sq*B0fin(0,0,m2sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (m2sq*m7**4*B0fin(0,0,m2sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (3*m2**4*m7**4*B0fin(0,0,m2sq,mudim))/(m4**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (m2sq*m7**6*B0fin(0,0,m2sq,mudim))/(m4**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (2*(m1sq - m2sq)*m2sq*m4**4*(m4sq - m7sq)*B0fin(0,0,m2sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (14*(m1sq - m2sq)*m2sq*m7**4*(m4sq - m7sq)*B0fin(0,0,m2sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (4*m2sq*(-m1sq + m2sq)*m7**6*(m4sq - m7sq)*B0fin(0,0,m2sq,mudim))/(m4**2*(m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) - ((m1sq - m2sq)*m4sq*(m4sq - m7sq)**3*B0fin(0,0,m2sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + ((m1sq - m2sq)*m7**4*(m4sq - m7sq)**3*B0fin(0,0,m2sq,mudim))/(m4**2*(m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (6*m2**6*(m1sq - m2sq)*m7sq*B0fin(0,0,m2sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (m2**8*(-m1sq + m2sq)*m7sq*B0fin(0,0,m2sq,mudim))/(m4**2*(m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (6*m2**4*(m1sq - m2sq)*m4sq*m7sq*B0fin(0,0,m2sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (4*m2**4*m7sq*B0fin(0,0,m2sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (3*m2sq*m4sq*m7sq*B0fin(0,0,m2sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (12*m2sq*(-m1sq + m2sq)*m4sq*(m4sq - m7sq)*m7sq*B0fin(0,0,m2sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) - (2*m2sq*m7sq*(m2sq - m4sq + m7sq)*B0fin(0,0,m2sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (m2**6*(5*m4sq + 3*m7sq)*B0fin(0,0,m2sq,mudim))/(m4**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (m1**8*B0fin(0,0,m4sq,mudim))/(m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (3*m1sq*m4**4*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (7*m1**4*m4sq*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (5*m1sq*m7**4*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (6*m1**4*m7**4*B0fin(0,0,m4sq,mudim))/(m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (4*m1sq*m7**6*B0fin(0,0,m4sq,mudim))/(m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m2**8*(m1sq - m2sq)*B0fin(0,0,m4sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (2*m2**6*(-m1sq + m2sq)*m4sq*B0fin(0,0,m4sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (12*m2**4*(-m1sq + m2sq)*m7**4*B0fin(0,0,m4sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (28*m2sq*(-m1sq + m2sq)*m4sq*m7**4*B0fin(0,0,m4sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (12*(m1sq - m2sq)*m2sq*m7**6*B0fin(0,0,m4sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (4*m2sq*(-m1sq + m2sq)*m7**8*B0fin(0,0,m4sq,mudim))/(m4**2*(m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (m2**8*B0fin(0,0,m4sq,mudim))/(m4**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (3*m2sq*m4**4*B0fin(0,0,m4sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (7*m2**4*m4sq*B0fin(0,0,m4sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (5*m2sq*m7**4*B0fin(0,0,m4sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (6*m2**4*m7**4*B0fin(0,0,m4sq,mudim))/(m4**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (4*m2sq*m7**6*B0fin(0,0,m4sq,mudim))/(m4**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (2*(m1sq - m2sq)*m2sq*m4**4*(m4sq - m7sq)*B0fin(0,0,m4sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (6*m2sq*(-m1sq + m2sq)*m7**4*(m4sq - m7sq)*B0fin(0,0,m4sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (4*m2sq*(-m1sq + m2sq)*m7**6*(m4sq - m7sq)*B0fin(0,0,m4sq,mudim))/(m4**2*(m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) - (4*(m1sq - m2sq)*m7**4*(m4sq - m7sq)**2*B0fin(0,0,m4sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + ((m1sq - m2sq)*m7**6*(m4sq - m7sq)**2*B0fin(0,0,m4sq,mudim))/(m4**2*(m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) - ((m1sq - m2sq)*m4sq*(m4sq - m7sq)**3*B0fin(0,0,m4sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + ((m1sq - m2sq)*m7**4*(m4sq - m7sq)**3*B0fin(0,0,m4sq,mudim))/(m4**2*(m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) - (5*m1**4*m7sq*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m1**6*m7sq*B0fin(0,0,m4sq,mudim))/(m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (6*m1sq*m4sq*m7sq*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m2**6*(m1sq - m2sq)*m7sq*B0fin(0,0,m4sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (12*(m1sq - m2sq)*m2sq*m4**4*m7sq*B0fin(0,0,m4sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (8*m2**4*(m1sq - m2sq)*m4sq*m7sq*B0fin(0,0,m4sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (5*m2**4*m7sq*B0fin(0,0,m4sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (m2**6*m7sq*B0fin(0,0,m4sq,mudim))/(m4**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (6*m2sq*m4sq*m7sq*B0fin(0,0,m4sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (20*m2sq*(-m1sq + m2sq)*m4sq*(m4sq - m7sq)*m7sq*B0fin(0,0,m4sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) - (5*(m1sq - m2sq)*m4sq*(m4sq - m7sq)**2*m7sq*B0fin(0,0,m4sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (2*(m1sq - m2sq)*(m4sq - m7sq)**3*m7sq*B0fin(0,0,m4sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) - ((-(m4sq*m7) + m7**3)**2*(-3*m4sq + m7sq)*B0fin(0,0,m4sq,mudim))/(m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + ((-(m4sq*m7) + m7**3)**2*(-3*m4sq + m7sq)*B0fin(0,0,m4sq,mudim))/(m4**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (m1**6*(5*m4sq + 3*m7sq)*B0fin(0,0,m4sq,mudim))/(m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (m2**6*(5*m4sq + 3*m7sq)*B0fin(0,0,m4sq,mudim))/(m4**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (2*m1sq*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m1**4*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m1sq*m4sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (6*m2**4*(-m1sq + m2sq)*m7**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (2*m2sq*m7**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (4*m2**6*(m1sq - m2sq)*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (2*m2**4*(m1sq - m2sq)*m4sq*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) - (2*m2**4*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (2*m2sq*m4sq*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (4*m2sq*(-m1sq + m2sq)*m4sq*(m4sq - m7sq)*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (2*(m1sq - m2sq)*m7sq*(-m4sq + m7sq)**3*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) - (4*m1sq*m7**4*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (3*m1**4*m7**4*B0fin(0,0,m7sq,mudim))/(m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (3*m1sq*m7**6*B0fin(0,0,m7sq,mudim))/(m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (8*m2**4*(m1sq - m2sq)*m7**4*B0fin(0,0,m7sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (4*m2**6*(-m1sq + m2sq)*m7**4*B0fin(0,0,m7sq,mudim))/(m4**2*(m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (28*m2sq*(-m1sq + m2sq)*m4sq*m7**4*B0fin(0,0,m7sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (12*(m1sq - m2sq)*m2sq*m7**6*B0fin(0,0,m7sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (6*m2**4*(m1sq - m2sq)*m7**6*B0fin(0,0,m7sq,mudim))/(m4**2*(m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (4*m2sq*(-m1sq + m2sq)*m7**8*B0fin(0,0,m7sq,mudim))/(m4**2*(m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (4*m2sq*m7**4*B0fin(0,0,m7sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (3*m2**4*m7**4*B0fin(0,0,m7sq,mudim))/(m4**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (3*m2sq*m7**6*B0fin(0,0,m7sq,mudim))/(m4**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (20*(m1sq - m2sq)*m2sq*m7**4*(m4sq - m7sq)*B0fin(0,0,m7sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) - (4*(m1sq - m2sq)*m7**4*(m4sq - m7sq)**2*B0fin(0,0,m7sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + ((m1sq - m2sq)*m7**6*(m4sq - m7sq)**2*B0fin(0,0,m7sq,mudim))/(m4**2*(m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) - (m1**4*m7sq*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m1**6*m7sq*B0fin(0,0,m7sq,mudim))/(m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (3*m1sq*m4sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (4*m2**6*(m1sq - m2sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (m2**8*(m1sq - m2sq)*m7sq*B0fin(0,0,m7sq,mudim))/(m4**2*(m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (12*(m1sq - m2sq)*m2sq*m4**4*m7sq*B0fin(0,0,m7sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (18*m2**4*(-m1sq + m2sq)*m4sq*m7sq*B0fin(0,0,m7sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (m2**4*m7sq*B0fin(0,0,m7sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (m2**6*m7sq*B0fin(0,0,m7sq,mudim))/(m4**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (3*m2sq*m4sq*m7sq*B0fin(0,0,m7sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (8*(m1sq - m2sq)*m2sq*m4sq*(m4sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) - (5*(m1sq - m2sq)*m4sq*(m4sq - m7sq)**2*m7sq*B0fin(0,0,m7sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) - ((-(m4sq*m7) + m7**3)**2*(-3*m4sq + m7sq)*B0fin(0,0,m7sq,mudim))/(m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + ((-(m4sq*m7) + m7**3)**2*(-3*m4sq + m7sq)*B0fin(0,0,m7sq,mudim))/(m4**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (2*(m1sq - m2sq)*m7sq*(-m4sq + m7sq)**3*B0fin(0,0,m7sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (2*m1sq*m7sq*(m1sq - m4sq + m7sq)*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (2*m2sq*m7sq*(m2sq - m4sq + m7sq)*B0fin(0,0,m7sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (2*m1sq*m7sq*(m1sq - m4sq + m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m2**4*(m1sq - m2sq)*m7**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (4*(m1sq - m2sq)*m2sq*m7**4*(m4sq - m7sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (4*m2**6*(m1sq - m2sq)*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (6*m2**4*(-m1sq + m2sq)*m4sq*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (2*(m1sq - m2sq)*(m4sq - m7sq)**3*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) - (2*m2sq*m7sq*(m2sq - m4sq + m7sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (2*m1sq*m7**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (6*m2**4*(m1sq - m2sq)*m7**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (8*m2sq*(-m1sq + m2sq)*m4sq*m7**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) - (2*m2sq*m7**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (2*(m1sq - m2sq)*m7**4*(m4sq - m7sq)**2*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) - (2*m1**4*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m1sq*m4sq*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (4*m2**6*(-m1sq + m2sq)*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (6*m2**4*(m1sq - m2sq)*m4sq*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (2*m2**4*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (2*m2sq*m4sq*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (2*(m1sq - m2sq)*m4sq*(m4sq - m7sq)**2*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) - (m1**4*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m1sq*m4sq*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - ((m4sq - m7sq)**2*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m1sq*m7sq*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m2**6*(-m1sq + m2sq)*(m2sq + m4sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (3*m2sq*(-m1sq + m2sq)*m4**4*(m2sq + m4sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) - (3*m2**4*(-m1sq + m2sq)*m4sq*(m2sq + m4sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) - (m2sq*(-m1sq + m2sq)*m7**4*(m2sq + m4sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (m2**4*(m2sq + m4sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (2*m2sq*m4sq*(m2sq + m4sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + ((m1sq - m2sq)*(-(m4sq*m7) + m7**3)**2*(m2sq + m4sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + ((m4sq - m7sq)**2*(m2sq + m4sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (m2**4*(-m1sq + m2sq)*m7sq*(m2sq + m4sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) - (2*m2sq*(-m1sq + m2sq)*m4sq*m7sq*(m2sq + m4sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) - (2*m2sq*m7sq*(m2sq + m4sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + ((m1sq - m2sq)*(m4**3 - m4*m7sq)**2*(m2sq + m4sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) - (4*m1sq*m7sq*T134fin(m7,m4,m1,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (4*(m1sq - m2sq)*m2sq*m7**4*T134fin(m7,m4,m2,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (4*(m1sq - m2sq)*(-(m4sq*m7) + m7**3)**2*T134fin(m7,m4,m2,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (8*m2**4*(-m1sq + m2sq)*m7sq*T134fin(m7,m4,m2,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (4*(m1sq - m2sq)*m2sq*m4sq*m7sq*T134fin(m7,m4,m2,mudim))/((m2 - m4 - m7)**3*(m2 + m4 - m7)**3*(m2 - m4 + m7)**3*(m2 + m4 + m7)**3) + (4*m2sq*m7sq*T134fin(m7,m4,m2,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2))/(2.*(m1sq - m2sq)**2)
		def eval_127():
			return ((-6*m1**8*(m1sq - m3sq))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (m1**10*(m1sq - m3sq))/(m4**2*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (10*m1**4*(m1sq - m3sq)*m4**4)/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (12*m1**6*(m1sq - m3sq)*m4sq)/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (2*m1**4*(m1sq - m3sq)*m7**4)/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (10*m1**6*(m1sq - m3sq)*m7**4)/(m4**2*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (20*m1sq*(m1sq - m3sq)*m4sq*m7**4)/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (12*m1sq*(m1sq - m3sq)*m7**6)/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (10*m1**4*(m1sq - m3sq)*m7**6)/(m4**2*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (4*m1sq*(m1sq - m3sq)*m7**8)/(m4**2*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - m1**8/(m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (3*m1sq*m4**4)/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (7*m1**4*m4sq)/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (5*m1sq*m7**4)/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (6*m1**4*m7**4)/(m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (4*m1sq*m7**6)/(m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + m3**8/(m4**2*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (3*m3sq*m4**4)/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (7*m3**4*m4sq)/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (5*m3sq*m7**4)/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (6*m3**4*m7**4)/(m4**2*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (4*m3sq*m7**6)/(m4**2*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (3*m1sq*(m1sq - m3sq)*m4**4*(m4sq - m7sq))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (13*m1sq*(m1sq - m3sq)*m7**4*(m4sq - m7sq))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (6*(m1sq - m3sq)*m7**4*(m4sq - m7sq)**2)/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + ((m1sq - m3sq)*m7**6*(m4sq - m7sq)**2)/(m4**2*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (2*(m1sq - m3sq)*m7**4*(m4sq - m7sq)**3)/(m4**2*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (18*m1**6*(m1sq - m3sq)*m7sq)/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (5*m1**8*(m1sq - m3sq)*m7sq)/(m4**2*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (4*m1sq*(m1sq - m3sq)*m4**4*m7sq)/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (2*m1**4*(m1sq - m3sq)*m4sq*m7sq)/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (5*m1**4*m7sq)/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m1**6*m7sq)/(m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (2*m1sq*m4sq*m7sq)/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (5*m3**4*m7sq)/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (m3**6*m7sq)/(m4**2*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (2*m3sq*m4sq*m7sq)/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (7*m1sq*(m1sq - m3sq)*m4sq*(m4sq - m7sq)*m7sq)/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + ((m1sq - m3sq)*m4sq*(m4sq - m7sq)**2*m7sq)/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - ((-(m4sq*m7) + m7**3)**2*(-3*m4sq + m7sq))/(m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + ((-(m4sq*m7) + m7**3)**2*(-3*m4sq + m7sq))/(m4**2*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (9*m1sq*(m1sq - m3sq)*m7**6*(-m4sq + m7sq))/(m4**2*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (2*(m1sq - m3sq)*m7sq*(-m4sq + m7sq)**3)/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (4*m1sq*m7sq*(m1sq - m4sq + m7sq))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (4*m3sq*m7sq*(m3sq - m4sq + m7sq))/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (8*m1sq*(m1sq - m3sq)*m7**4*(m1sq + m4sq + m7sq))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (2*m1**4*(m1sq + m4sq + m7sq))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (4*m1sq*m4sq*(m1sq + m4sq + m7sq))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (8*(m1sq - m3sq)*(-(m4sq*m7) + m7**3)**2*(m1sq + m4sq + m7sq))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (2*(m4sq - m7sq)**2*(m1sq + m4sq + m7sq))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (16*m1**4*(m1sq - m3sq)*m7sq*(m1sq + m4sq + m7sq))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (8*m1sq*(m1sq - m3sq)*m4sq*m7sq*(m1sq + m4sq + m7sq))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (4*m1sq*m7sq*(m1sq + m4sq + m7sq))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m3**4*(m3sq + m4sq + m7sq))/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (4*m3sq*m4sq*(m3sq + m4sq + m7sq))/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (2*(m4sq - m7sq)**2*(m3sq + m4sq + m7sq))/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (4*m3sq*m7sq*(m3sq + m4sq + m7sq))/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (m1**6*(5*m4sq + 3*m7sq))/(m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (m3**6*(5*m4sq + 3*m7sq))/(m4**2*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (4*m1**4*(m1sq - m3sq)*m7**4*B0del(0,0,m1sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (2*m1sq*m7**4*B0del(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (8*m1**6*(m1sq - m3sq)*m7sq*B0del(0,0,m1sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (4*m1**4*(m1sq - m3sq)*m4sq*m7sq*B0del(0,0,m1sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (2*m1**4*m7sq*B0del(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (2*m1sq*m4sq*m7sq*B0del(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (4*m1sq*(m1sq - m3sq)*m4sq*(m4sq - m7sq)*m7sq*B0del(0,0,m1sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (4*m1sq*(m1sq - m3sq)*m7**4*(-m4sq + m7sq)*B0del(0,0,m1sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (2*m1sq*m7sq*(m1sq - m4sq + m7sq)*B0del(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (2*m3sq*m7**4*B0del(0,0,m3sq,mudim))/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (2*m3**4*m7sq*B0del(0,0,m3sq,mudim))/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (2*m3sq*m4sq*m7sq*B0del(0,0,m3sq,mudim))/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (2*m3sq*m7sq*(m3sq - m4sq + m7sq)*B0del(0,0,m3sq,mudim))/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (8*m1sq*(m1sq - m3sq)*m4sq*m7**4*B0del(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (2*(m1sq - m3sq)*m7**4*(m4sq - m7sq)**2*B0del(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (8*m1**4*(m1sq - m3sq)*m4sq*m7sq*B0del(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (4*m1sq*m4sq*m7sq*B0del(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (4*m3sq*m4sq*m7sq*B0del(0,0,m4sq,mudim))/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (4*m1sq*(m1sq - m3sq)*m4sq*(m4sq - m7sq)*m7sq*B0del(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (2*(m1sq - m3sq)*m4sq*(m4sq - m7sq)**2*m7sq*B0del(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (2*(m1sq - m3sq)*(m4sq - m7sq)**3*m7sq*B0del(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (8*m1**4*(m1sq - m3sq)*m7**4*B0del(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (8*m1sq*(m1sq - m3sq)*m4sq*m7**4*B0del(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (2*m1sq*m7**4*B0del(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m3sq*m7**4*B0del(0,0,m7sq,mudim))/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (2*(m1sq - m3sq)*m7**4*(m4sq - m7sq)**2*B0del(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (2*m1**4*m7sq*B0del(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (2*m1sq*m4sq*m7sq*B0del(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (2*m3**4*m7sq*B0del(0,0,m7sq,mudim))/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (2*m3sq*m4sq*m7sq*B0del(0,0,m7sq,mudim))/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (2*(m1sq - m3sq)*m4sq*(m4sq - m7sq)**2*m7sq*B0del(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (4*m1sq*(m1sq - m3sq)*m7**4*(-m4sq + m7sq)*B0del(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (2*(m1sq - m3sq)*m7sq*(-m4sq + m7sq)**3*B0del(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (2*m1sq*m7sq*(m1sq - m4sq + m7sq)*B0del(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m3sq*m7sq*(m3sq - m4sq + m7sq)*B0del(0,0,m7sq,mudim))/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (m1**8*(m1sq - m3sq)*B0fin(0,0,m1sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (2*m1**6*(m1sq - m3sq)*m4sq*B0fin(0,0,m1sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (8*m1**4*(m1sq - m3sq)*m7**4*B0fin(0,0,m1sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (4*m1**6*(m1sq - m3sq)*m7**4*B0fin(0,0,m1sq,mudim))/(m4**2*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (6*m1**4*(m1sq - m3sq)*m7**6*B0fin(0,0,m1sq,mudim))/(m4**2*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (m1**8*B0fin(0,0,m1sq,mudim))/(m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (3*m1sq*m4**4*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (7*m1**4*m4sq*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m1sq*m7**4*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (3*m1**4*m7**4*B0fin(0,0,m1sq,mudim))/(m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (m1sq*m7**6*B0fin(0,0,m1sq,mudim))/(m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (2*m1sq*(m1sq - m3sq)*m4**4*(m4sq - m7sq)*B0fin(0,0,m1sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (4*m1sq*(m1sq - m3sq)*m7**6*(m4sq - m7sq)*B0fin(0,0,m1sq,mudim))/(m4**2*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + ((m1sq - m3sq)*m4sq*(m4sq - m7sq)**3*B0fin(0,0,m1sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (6*m1**6*(m1sq - m3sq)*m7sq*B0fin(0,0,m1sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (m1**8*(m1sq - m3sq)*m7sq*B0fin(0,0,m1sq,mudim))/(m4**2*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (6*m1**4*(m1sq - m3sq)*m4sq*m7sq*B0fin(0,0,m1sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (4*m1**4*m7sq*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (3*m1sq*m4sq*m7sq*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (12*m1sq*(m1sq - m3sq)*m4sq*(m4sq - m7sq)*m7sq*B0fin(0,0,m1sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (14*m1sq*(m1sq - m3sq)*m7**4*(-m4sq + m7sq)*B0fin(0,0,m1sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + ((m1sq - m3sq)*m7**4*(-m4sq + m7sq)**3*B0fin(0,0,m1sq,mudim))/(m4**2*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (2*m1sq*m7sq*(m1sq - m4sq + m7sq)*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (m1**6*(5*m4sq + 3*m7sq)*B0fin(0,0,m1sq,mudim))/(m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (m3**8*B0fin(0,0,m3sq,mudim))/(m4**2*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (3*m3sq*m4**4*B0fin(0,0,m3sq,mudim))/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (7*m3**4*m4sq*B0fin(0,0,m3sq,mudim))/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (m3sq*m7**4*B0fin(0,0,m3sq,mudim))/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (3*m3**4*m7**4*B0fin(0,0,m3sq,mudim))/(m4**2*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (m3sq*m7**6*B0fin(0,0,m3sq,mudim))/(m4**2*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (4*m3**4*m7sq*B0fin(0,0,m3sq,mudim))/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (3*m3sq*m4sq*m7sq*B0fin(0,0,m3sq,mudim))/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (2*m3sq*m7sq*(m3sq - m4sq + m7sq)*B0fin(0,0,m3sq,mudim))/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (m3**6*(5*m4sq + 3*m7sq)*B0fin(0,0,m3sq,mudim))/(m4**2*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (m1**8*(m1sq - m3sq)*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (2*m1**6*(m1sq - m3sq)*m4sq*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (12*m1**4*(m1sq - m3sq)*m7**4*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (28*m1sq*(m1sq - m3sq)*m4sq*m7**4*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (12*m1sq*(m1sq - m3sq)*m7**6*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (4*m1sq*(m1sq - m3sq)*m7**8*B0fin(0,0,m4sq,mudim))/(m4**2*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (m1**8*B0fin(0,0,m4sq,mudim))/(m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (3*m1sq*m4**4*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (7*m1**4*m4sq*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (5*m1sq*m7**4*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (6*m1**4*m7**4*B0fin(0,0,m4sq,mudim))/(m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (4*m1sq*m7**6*B0fin(0,0,m4sq,mudim))/(m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (m3**8*B0fin(0,0,m4sq,mudim))/(m4**2*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (3*m3sq*m4**4*B0fin(0,0,m4sq,mudim))/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (7*m3**4*m4sq*B0fin(0,0,m4sq,mudim))/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (5*m3sq*m7**4*B0fin(0,0,m4sq,mudim))/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (6*m3**4*m7**4*B0fin(0,0,m4sq,mudim))/(m4**2*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (4*m3sq*m7**6*B0fin(0,0,m4sq,mudim))/(m4**2*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (2*m1sq*(m1sq - m3sq)*m4**4*(m4sq - m7sq)*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (6*m1sq*(m1sq - m3sq)*m7**4*(m4sq - m7sq)*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (4*m1sq*(m1sq - m3sq)*m7**6*(m4sq - m7sq)*B0fin(0,0,m4sq,mudim))/(m4**2*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (4*(m1sq - m3sq)*m7**4*(m4sq - m7sq)**2*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - ((m1sq - m3sq)*m7**6*(m4sq - m7sq)**2*B0fin(0,0,m4sq,mudim))/(m4**2*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + ((m1sq - m3sq)*m4sq*(m4sq - m7sq)**3*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (2*m1**6*(m1sq - m3sq)*m7sq*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (12*m1sq*(m1sq - m3sq)*m4**4*m7sq*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (8*m1**4*(m1sq - m3sq)*m4sq*m7sq*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (5*m1**4*m7sq*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (m1**6*m7sq*B0fin(0,0,m4sq,mudim))/(m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (6*m1sq*m4sq*m7sq*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (5*m3**4*m7sq*B0fin(0,0,m4sq,mudim))/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (m3**6*m7sq*B0fin(0,0,m4sq,mudim))/(m4**2*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (6*m3sq*m4sq*m7sq*B0fin(0,0,m4sq,mudim))/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (20*m1sq*(m1sq - m3sq)*m4sq*(m4sq - m7sq)*m7sq*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (5*(m1sq - m3sq)*m4sq*(m4sq - m7sq)**2*m7sq*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + ((-(m4sq*m7) + m7**3)**2*(-3*m4sq + m7sq)*B0fin(0,0,m4sq,mudim))/(m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - ((-(m4sq*m7) + m7**3)**2*(-3*m4sq + m7sq)*B0fin(0,0,m4sq,mudim))/(m4**2*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + ((m1sq - m3sq)*m7**4*(-m4sq + m7sq)**3*B0fin(0,0,m4sq,mudim))/(m4**2*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (2*(m1sq - m3sq)*m7sq*(-m4sq + m7sq)**3*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (m1**6*(5*m4sq + 3*m7sq)*B0fin(0,0,m4sq,mudim))/(m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m3**6*(5*m4sq + 3*m7sq)*B0fin(0,0,m4sq,mudim))/(m4**2*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (6*m1**4*(m1sq - m3sq)*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (2*m1sq*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (4*m1**6*(m1sq - m3sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (2*m1**4*(m1sq - m3sq)*m4sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (2*m1**4*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (2*m1sq*m4sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (4*m1sq*(m1sq - m3sq)*m4sq*(m4sq - m7sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (2*(m1sq - m3sq)*(m4sq - m7sq)**3*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (2*m3sq*m7**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim))/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (2*m3**4*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim))/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (2*m3sq*m4sq*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim))/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (8*m1**4*(m1sq - m3sq)*m7**4*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (4*m1**6*(m1sq - m3sq)*m7**4*B0fin(0,0,m7sq,mudim))/(m4**2*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (28*m1sq*(m1sq - m3sq)*m4sq*m7**4*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (12*m1sq*(m1sq - m3sq)*m7**6*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (6*m1**4*(m1sq - m3sq)*m7**6*B0fin(0,0,m7sq,mudim))/(m4**2*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (4*m1sq*(m1sq - m3sq)*m7**8*B0fin(0,0,m7sq,mudim))/(m4**2*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (4*m1sq*m7**4*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (3*m1**4*m7**4*B0fin(0,0,m7sq,mudim))/(m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (3*m1sq*m7**6*B0fin(0,0,m7sq,mudim))/(m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (4*m3sq*m7**4*B0fin(0,0,m7sq,mudim))/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (3*m3**4*m7**4*B0fin(0,0,m7sq,mudim))/(m4**2*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (3*m3sq*m7**6*B0fin(0,0,m7sq,mudim))/(m4**2*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (4*(m1sq - m3sq)*m7**4*(m4sq - m7sq)**2*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - ((m1sq - m3sq)*m7**6*(m4sq - m7sq)**2*B0fin(0,0,m7sq,mudim))/(m4**2*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (4*m1**6*(m1sq - m3sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (m1**8*(m1sq - m3sq)*m7sq*B0fin(0,0,m7sq,mudim))/(m4**2*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (12*m1sq*(m1sq - m3sq)*m4**4*m7sq*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (18*m1**4*(m1sq - m3sq)*m4sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (m1**4*m7sq*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (m1**6*m7sq*B0fin(0,0,m7sq,mudim))/(m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (3*m1sq*m4sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (m3**4*m7sq*B0fin(0,0,m7sq,mudim))/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (m3**6*m7sq*B0fin(0,0,m7sq,mudim))/(m4**2*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (3*m3sq*m4sq*m7sq*B0fin(0,0,m7sq,mudim))/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (8*m1sq*(m1sq - m3sq)*m4sq*(m4sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (5*(m1sq - m3sq)*m4sq*(m4sq - m7sq)**2*m7sq*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (2*(m1sq - m3sq)*(m4sq - m7sq)**3*m7sq*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + ((-(m4sq*m7) + m7**3)**2*(-3*m4sq + m7sq)*B0fin(0,0,m7sq,mudim))/(m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - ((-(m4sq*m7) + m7**3)**2*(-3*m4sq + m7sq)*B0fin(0,0,m7sq,mudim))/(m4**2*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (20*m1sq*(m1sq - m3sq)*m7**4*(-m4sq + m7sq)*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (2*m1sq*m7sq*(m1sq - m4sq + m7sq)*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m3sq*m7sq*(m3sq - m4sq + m7sq)*B0fin(0,0,m7sq,mudim))/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (2*m1**4*(m1sq - m3sq)*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (4*m1**6*(m1sq - m3sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (6*m1**4*(m1sq - m3sq)*m4sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (4*m1sq*(m1sq - m3sq)*m7**4*(-m4sq + m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (2*(m1sq - m3sq)*m7sq*(-m4sq + m7sq)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (2*m1sq*m7sq*(m1sq - m4sq + m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m3sq*m7sq*(m3sq - m4sq + m7sq)*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim))/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (6*m1**4*(m1sq - m3sq)*m7**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (8*m1sq*(m1sq - m3sq)*m4sq*m7**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (2*m1sq*m7**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m3sq*m7**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (2*(m1sq - m3sq)*m7**4*(m4sq - m7sq)**2*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (4*m1**6*(m1sq - m3sq)*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (6*m1**4*(m1sq - m3sq)*m4sq*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (2*m1**4*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (2*m1sq*m4sq*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (2*m3**4*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (2*m3sq*m4sq*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (2*(m1sq - m3sq)*m4sq*(m4sq - m7sq)**2*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (m1**6*(m1sq - m3sq)*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (3*m1sq*(m1sq - m3sq)*m4**4*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (3*m1**4*(m1sq - m3sq)*m4sq*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (m1sq*(m1sq - m3sq)*m7**4*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (m1**4*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (2*m1sq*m4sq*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - ((m1sq - m3sq)*(-(m4sq*m7) + m7**3)**2*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + ((m4sq - m7sq)**2*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m1**4*(m1sq - m3sq)*m7sq*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (2*m1sq*(m1sq - m3sq)*m4sq*m7sq*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (2*m1sq*m7sq*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - ((m1sq - m3sq)*(m4**3 - m4*m7sq)**2*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (m3**4*(m3sq + m4sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (2*m3sq*m4sq*(m3sq + m4sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - ((m4sq - m7sq)**2*(m3sq + m4sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (2*m3sq*m7sq*(m3sq + m4sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (4*m1sq*(m1sq - m3sq)*m7**4*T134fin(m7,m4,m1,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (4*(m1sq - m3sq)*(-(m4sq*m7) + m7**3)**2*T134fin(m7,m4,m1,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (8*m1**4*(m1sq - m3sq)*m7sq*T134fin(m7,m4,m1,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (4*m1sq*(m1sq - m3sq)*m4sq*m7sq*T134fin(m7,m4,m1,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (4*m1sq*m7sq*T134fin(m7,m4,m1,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (4*m3sq*m7sq*T134fin(m7,m4,m3,mudim))/((m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2))/(2.*(m1sq - m3sq)**2)
		def eval_128():
			return ((7*m1sq*m4**4)/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (3*m1**4*m4sq)/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (7*m1sq*m7**4)/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (10*m1**4*m5**4*(m4sq - m5sq))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (12*m1sq*m5**6*(-m4sq + m5sq))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (3*m1**6*m5sq*(-m4sq + m5sq))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) - (2*m1sq*(m4sq - m5sq)*m7**6)/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) - (7*m1sq*m5**4)/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (3*m1**4*m5sq)/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (7*m1sq*m7**4)/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (5*m7**4*(m4sq - m7sq))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m4sq*(m4sq - m7sq)**3)/(m1**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (16*m5sq*(-m4sq + m5sq)*m7**4*(m5sq - m7sq))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (5*m5**4*(m5sq - m7sq))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (6*m5**4*(m4sq - m5sq)*(m5sq - m7sq)**2)/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) - (m5sq*(m5sq - m7sq)**3)/(m1**2*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (m5sq*(-m4sq + m5sq)*(m5sq - m7sq)**4)/(m1**2*(m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) - (3*m1**4*m7sq)/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m1sq*m4sq*m7sq)/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m1**6*(m4sq - m5sq)*m7sq)/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (14*m1**4*(m4sq - m5sq)*m5sq*m7sq)/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (2*m1sq*m5**4*(-m4sq + m5sq)*m7sq)/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (3*m1**4*m7sq)/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (2*m1sq*m5sq*m7sq)/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (6*m5sq*(-m4sq + m5sq)*(m5sq - m7sq)**2*m7sq)/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + ((m5sq - m7sq)**3*m7sq)/(m1**2*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + ((m4sq - m5sq)*(m5sq - m7sq)**4*m7sq)/(m1**2*(m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (m7sq*(-m4sq + m7sq)**3)/(m1**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (4*m4sq*m7sq*(-m1sq + m4sq + m7sq))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m1**4*(m1sq + m4sq + m7sq))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m4**4*(m1sq + m4sq + m7sq))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m7**4*(m1sq + m4sq + m7sq))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (4*m4sq*m7sq*(m1sq + m4sq + m7sq))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (4*m1sq*(m4sq + m7sq)*(m1sq + m4sq + m7sq))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (5*m7**4*(-m5sq + m7sq))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (4*m5sq*m7sq*(-m1sq + m5sq + m7sq))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (16*m1sq*(m4sq - m5sq)*m7**4*(m1sq + m5sq + m7sq))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) - (2*m1**4*(m1sq + m5sq + m7sq))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (2*m5**4*(m1sq + m5sq + m7sq))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (2*m7**4*(m1sq + m5sq + m7sq))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (8*(m4sq - m5sq)*m7**4*(m5sq - m7sq)*(m1sq + m5sq + m7sq))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) - (8*m1**4*(m4sq - m5sq)*m7sq*(m1sq + m5sq + m7sq))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (8*m1sq*m5sq*(-m4sq + m5sq)*m7sq*(m1sq + m5sq + m7sq))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) - (4*m5sq*m7sq*(m1sq + m5sq + m7sq))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (16*(m4sq - m5sq)*m5sq*(m5sq - m7sq)*m7sq*(m1sq + m5sq + m7sq))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (4*m1sq*(m5sq + m7sq)*(m1sq + m5sq + m7sq))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (-5*m4**6 + 5*m4**4*m7sq)/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (8*m1**4*(m4sq - m5sq)*m7**4*B0del(0,0,m1sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (4*m1sq*m5sq*(-m4sq + m5sq)*m7**4*B0del(0,0,m1sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) - (4*m1sq*(m4sq - m5sq)*m7**6*B0del(0,0,m1sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (4*m1sq*m4sq*m7sq*B0del(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (4*m1**6*(m4sq - m5sq)*m7sq*B0del(0,0,m1sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (8*m1sq*m5**4*(m4sq - m5sq)*m7sq*B0del(0,0,m1sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (4*m1**4*m5sq*(-m4sq + m5sq)*m7sq*B0del(0,0,m1sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) - (4*m1sq*m5sq*m7sq*B0del(0,0,m1sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (2*m1sq*m4sq*m7sq*B0del(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m4sq*(m4sq - m7sq)*m7sq*B0del(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m4sq*m7sq*(-m1sq + m4sq + m7sq)*B0del(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (8*m1sq*(m4sq - m5sq)*m5sq*m7**4*B0del(0,0,m5sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (6*(m4sq - m5sq)*m5sq*m7**4*(m5sq - m7sq)*B0del(0,0,m5sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (2*(m4sq - m5sq)*m7**6*(m5sq - m7sq)*B0del(0,0,m5sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (2*(m4sq - m5sq)*m7**4*(m5sq - m7sq)**2*B0del(0,0,m5sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (4*m1sq*m5**4*(-m4sq + m5sq)*m7sq*B0del(0,0,m5sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (4*m1**4*m5sq*(-m4sq + m5sq)*m7sq*B0del(0,0,m5sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) - (2*m1sq*m5sq*m7sq*B0del(0,0,m5sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (4*m5**4*(m4sq - m5sq)*(m5sq - m7sq)*m7sq*B0del(0,0,m5sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) - (2*m5sq*(m5sq - m7sq)*m7sq*B0del(0,0,m5sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (4*(m4sq - m5sq)*m5sq*(m5sq - m7sq)**2*m7sq*B0del(0,0,m5sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) - (2*m5sq*m7sq*(-m1sq + m5sq + m7sq)*B0del(0,0,m5sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (4*m1**4*(m4sq - m5sq)*m7**4*B0del(0,0,m7sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (4*m1sq*m5sq*(-m4sq + m5sq)*m7**4*B0del(0,0,m7sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (8*m1sq*(m4sq - m5sq)*m7**6*B0del(0,0,m7sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (6*(m4sq - m5sq)*m5sq*m7**4*(m5sq - m7sq)*B0del(0,0,m7sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (2*(m4sq - m5sq)*m7**6*(m5sq - m7sq)*B0del(0,0,m7sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) - (2*(m4sq - m5sq)*m7**4*(m5sq - m7sq)**2*B0del(0,0,m7sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (2*m1sq*m4sq*m7sq*B0del(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (2*m1sq*m5sq*m7sq*B0del(0,0,m7sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (2*m4sq*(m4sq - m7sq)*m7sq*B0del(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (4*m5**4*(m4sq - m5sq)*(m5sq - m7sq)*m7sq*B0del(0,0,m7sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (2*m5sq*(m5sq - m7sq)*m7sq*B0del(0,0,m7sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (4*m5sq*(-m4sq + m5sq)*(m5sq - m7sq)**2*m7sq*B0del(0,0,m7sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (2*m4sq*m7sq*(-m1sq + m4sq + m7sq)*B0del(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (2*m5sq*m7sq*(-m1sq + m5sq + m7sq)*B0del(0,0,m7sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (7*m1sq*m4**4*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (3*m1**4*m4sq*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (7*m1sq*m7**4*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (m1**8*(m4sq - m5sq)*B0fin(0,0,m1sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (2*m1**6*(m4sq - m5sq)*m5sq*B0fin(0,0,m1sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (2*m1sq*m5**6*(-m4sq + m5sq)*B0fin(0,0,m1sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) - (2*m1**4*(m4sq - m5sq)*m7**4*B0fin(0,0,m1sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (14*m1sq*m5sq*(-m4sq + m5sq)*m7**4*B0fin(0,0,m1sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (8*m1sq*(m4sq - m5sq)*m7**6*B0fin(0,0,m1sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (7*m1sq*m5**4*B0fin(0,0,m1sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (3*m1**4*m5sq*B0fin(0,0,m1sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (7*m1sq*m7**4*B0fin(0,0,m1sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (5*m4**4*(m4sq - m7sq)*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (m4sq*(m4sq - m7sq)**3*B0fin(0,0,m1sq,mudim))/(m1**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (5*m5**4*(m5sq - m7sq)*B0fin(0,0,m1sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (5*m7**4*(m5sq - m7sq)*B0fin(0,0,m1sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (m5**4*(m4sq - m5sq)*(m5sq - m7sq)**2*B0fin(0,0,m1sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) - (5*(m4sq - m5sq)*m7**4*(m5sq - m7sq)**2*B0fin(0,0,m1sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (m5sq*(m5sq - m7sq)**3*B0fin(0,0,m1sq,mudim))/(m1**2*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (3*m1**4*m7sq*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (6*m1sq*m4sq*m7sq*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (8*m1sq*m5**4*(m4sq - m5sq)*m7sq*B0fin(0,0,m1sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (10*m1**4*m5sq*(-m4sq + m5sq)*m7sq*B0fin(0,0,m1sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) - (3*m1**4*m7sq*B0fin(0,0,m1sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (6*m1sq*m5sq*m7sq*B0fin(0,0,m1sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + ((m4sq - m7sq)**3*m7sq*B0fin(0,0,m1sq,mudim))/(m1**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (4*(m4sq - m5sq)*m5sq*(m5sq - m7sq)**2*m7sq*B0fin(0,0,m1sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (5*m7**4*(-m4sq + m7sq)*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m7sq*(-m5sq + m7sq)**3*B0fin(0,0,m1sq,mudim))/(m1**2*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (7*m1sq*m4**4*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (3*m1**4*m4sq*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (5*m4**4*(m4sq - m7sq)*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (m4sq*(m4sq - m7sq)**3*B0fin(0,0,m4sq,mudim))/(m1**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (3*m1sq*m4sq*m7sq*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m4sq*(m4sq - m7sq)*m7sq*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m4sq*m7sq*(-m1sq + m4sq + m7sq)*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m1sq*m4sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m4sq*(m4sq - m7sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (m1**8*(m4sq - m5sq)*B0fin(0,0,m5sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (2*m1**6*(m4sq - m5sq)*m5sq*B0fin(0,0,m5sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (2*m1sq*m5**6*(-m4sq + m5sq)*B0fin(0,0,m5sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) - (2*m1**4*(m4sq - m5sq)*m7**4*B0fin(0,0,m5sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (26*m1sq*(m4sq - m5sq)*m5sq*m7**4*B0fin(0,0,m5sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) - (2*m1sq*(m4sq - m5sq)*m7**6*B0fin(0,0,m5sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (7*m1sq*m5**4*B0fin(0,0,m5sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (3*m1**4*m5sq*B0fin(0,0,m5sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (18*(m4sq - m5sq)*m5sq*m7**4*(m5sq - m7sq)*B0fin(0,0,m5sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) - (2*(m4sq - m5sq)*m7**6*(m5sq - m7sq)*B0fin(0,0,m5sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) - (5*m5**4*(m5sq - m7sq)*B0fin(0,0,m5sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (m5**4*(m4sq - m5sq)*(m5sq - m7sq)**2*B0fin(0,0,m5sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + ((m4sq - m5sq)*m7**4*(m5sq - m7sq)**2*B0fin(0,0,m5sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (m5sq*(m5sq - m7sq)**3*B0fin(0,0,m5sq,mudim))/(m1**2*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (3*m1**6*(m4sq - m5sq)*m7sq*B0fin(0,0,m5sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (6*m1sq*m5**4*(m4sq - m5sq)*m7sq*B0fin(0,0,m5sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (14*m1**4*m5sq*(-m4sq + m5sq)*m7sq*B0fin(0,0,m5sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (3*m1sq*m5sq*m7sq*B0fin(0,0,m5sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (4*m5**4*(m4sq - m5sq)*(m5sq - m7sq)*m7sq*B0fin(0,0,m5sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) - (m5sq*(m5sq - m7sq)*m7sq*B0fin(0,0,m5sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (4*(m4sq - m5sq)*m5sq*(m5sq - m7sq)**2*m7sq*B0fin(0,0,m5sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) - ((m4sq - m5sq)*(m5sq - m7sq)**4*m7sq*B0fin(0,0,m5sq,mudim))/(m1**2*(m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) - (2*m5sq*m7sq*(-m1sq + m5sq + m7sq)*B0fin(0,0,m5sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (6*m1**4*(m4sq - m5sq)*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (4*m1sq*(m4sq - m5sq)*m5sq*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) - (6*m1sq*(m4sq - m5sq)*m7**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (2*(m4sq - m5sq)*m7**4*(m5sq - m7sq)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) - (2*m1**6*(m4sq - m5sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (2*m1sq*m5**4*(m4sq - m5sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (4*m1**4*m5sq*(-m4sq + m5sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) - (2*m1sq*m5sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (2*m5sq*(m5sq - m7sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (4*(m4sq - m5sq)*m5sq*(m5sq - m7sq)**2*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) - (7*m1sq*m7**4*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (12*m1**4*(m4sq - m5sq)*m7**4*B0fin(0,0,m7sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (16*m1sq*m5sq*(-m4sq + m5sq)*m7**4*B0fin(0,0,m7sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) - (2*m1sq*(m4sq - m5sq)*m7**6*B0fin(0,0,m7sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (7*m1sq*m7**4*B0fin(0,0,m7sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (18*(m4sq - m5sq)*m5sq*m7**4*(m5sq - m7sq)*B0fin(0,0,m7sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) - (2*(m4sq - m5sq)*m7**6*(m5sq - m7sq)*B0fin(0,0,m7sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (5*m7**4*(m5sq - m7sq)*B0fin(0,0,m7sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (6*(m4sq - m5sq)*m7**4*(m5sq - m7sq)**2*B0fin(0,0,m7sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (3*m1**4*m7sq*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (3*m1sq*m4sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (7*m1**6*(m4sq - m5sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (20*m1**4*(m4sq - m5sq)*m5sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (18*m1sq*m5**4*(-m4sq + m5sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) - (3*m1**4*m7sq*B0fin(0,0,m7sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (3*m1sq*m5sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (m4sq*(m4sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + ((m4sq - m7sq)**3*m7sq*B0fin(0,0,m7sq,mudim))/(m1**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (4*m5**4*(m4sq - m5sq)*(m5sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (m5sq*(m5sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + ((m4sq - m5sq)*(m5sq - m7sq)**4*m7sq*B0fin(0,0,m7sq,mudim))/(m1**2*(m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (5*m7**4*(-m4sq + m7sq)*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m4sq*m7sq*(-m1sq + m4sq + m7sq)*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m7sq*(-m5sq + m7sq)**3*B0fin(0,0,m7sq,mudim))/(m1**2*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (2*m5sq*m7sq*(-m1sq + m5sq + m7sq)*B0fin(0,0,m7sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (2*m1**4*(m4sq - m5sq)*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (8*m1sq*m5sq*(-m4sq + m5sq)*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (2*m1sq*(m4sq - m5sq)*m7**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) - (2*(m4sq - m5sq)*m7**4*(m5sq - m7sq)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (2*m1sq*m4sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (2*m1**6*(m4sq - m5sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (6*m1sq*m5**4*(m4sq - m5sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) - (2*m1sq*m5sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (2*m4sq*(m4sq - m7sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m5sq*(m5sq - m7sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (4*m5sq*(-m4sq + m5sq)*(m5sq - m7sq)**2*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (2*m4sq*m7sq*(-m1sq + m4sq + m7sq)*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (6*m1**4*(m4sq - m5sq)*m7**4*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (4*m1sq*(m4sq - m5sq)*m5sq*m7**4*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (6*m1sq*(m4sq - m5sq)*m7**6*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (6*(m4sq - m5sq)*m5sq*m7**4*(m5sq - m7sq)*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (2*(m4sq - m5sq)*m7**6*(m5sq - m7sq)*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (2*m1**6*(m4sq - m5sq)*m7sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (6*m1sq*m5**4*(-m4sq + m5sq)*m7sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (4*m5**4*(m4sq - m5sq)*(m5sq - m7sq)*m7sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) - (2*m5sq*m7sq*(-m1sq + m5sq + m7sq)*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (m1**4*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (m4**4*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (m7**4*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m4sq*m7sq*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m1sq*(m4sq + m7sq)*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m1**6*(m4sq - m5sq)*(m1sq + m5sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) - (3*m1sq*m5**4*(-m4sq + m5sq)*(m1sq + m5sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (3*m1**4*m5sq*(-m4sq + m5sq)*(m1sq + m5sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) - (m1sq*(m4sq - m5sq)*m7**4*(m1sq + m5sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (m1**4*(m1sq + m5sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (m5**4*(m1sq + m5sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (m7**4*(m1sq + m5sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (m5**4*(-m4sq + m5sq)*(m5sq - m7sq)*(m1sq + m5sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) - ((m4sq - m5sq)*m7**4*(m5sq - m7sq)*(m1sq + m5sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) - (m1**4*(m4sq - m5sq)*m7sq*(m1sq + m5sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) - (2*m1sq*m5sq*(-m4sq + m5sq)*m7sq*(m1sq + m5sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) - (2*m5sq*m7sq*(m1sq + m5sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (2*m5sq*(-m4sq + m5sq)*(m5sq - m7sq)*m7sq*(m1sq + m5sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) - (2*m1sq*(m5sq + m7sq)*(m1sq + m5sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (4*m4sq*m7sq*T134fin(m7,m4,m1,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (8*m1sq*(m4sq - m5sq)*m7**4*T134fin(m7,m5,m1,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) - (4*(m4sq - m5sq)*m7**4*(m5sq - m7sq)*T134fin(m7,m5,m1,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (4*m1**4*(m4sq - m5sq)*m7sq*T134fin(m7,m5,m1,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (4*m1sq*(m4sq - m5sq)*m5sq*m7sq*T134fin(m7,m5,m1,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3) + (4*m5sq*m7sq*T134fin(m7,m5,m1,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (8*m5sq*(-m4sq + m5sq)*(m5sq - m7sq)*m7sq*T134fin(m7,m5,m1,mudim))/((m1 - m5 - m7)**3*(m1 + m5 - m7)**3*(m1 - m5 + m7)**3*(m1 + m5 + m7)**3))/(2.*(m4sq - m5sq)**2)
		def eval_129():
			return ((-10*m1**4*m4**4*(m4sq - m6sq))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (12*m1sq*m4**6*(m4sq - m6sq))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (3*m1**6*m4sq*(m4sq - m6sq))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (2*m1sq*(m4sq - m6sq)*m7**6)/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (7*m1sq*m4**4)/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (3*m1**4*m4sq)/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (7*m1sq*m7**4)/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (7*m1sq*m6**4)/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (3*m1**4*m6sq)/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (7*m1sq*m7**4)/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (16*m4sq*(m4sq - m6sq)*m7**4*(m4sq - m7sq))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (5*m4**4*(m4sq - m7sq))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (6*m4**4*(m4sq - m6sq)*(m4sq - m7sq)**2)/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (m4sq*(m4sq - m7sq)**3)/(m1**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m4sq*(m4sq - m6sq)*(m4sq - m7sq)**4)/(m1**2*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (5*m7**4*(m6sq - m7sq))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (m6sq*(m6sq - m7sq)**3)/(m1**2*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (m1**6*(m4sq - m6sq)*m7sq)/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (2*m1sq*m4**4*(m4sq - m6sq)*m7sq)/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (14*m1**4*m4sq*(m4sq - m6sq)*m7sq)/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (3*m1**4*m7sq)/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (2*m1sq*m4sq*m7sq)/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (3*m1**4*m7sq)/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*m1sq*m6sq*m7sq)/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (6*m4sq*(m4sq - m6sq)*(m4sq - m7sq)**2*m7sq)/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + ((m4sq - m7sq)**3*m7sq)/(m1**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - ((m4sq - m6sq)*(m4sq - m7sq)**4*m7sq)/(m1**2*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (5*m7**4*(-m4sq + m7sq))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (4*m4sq*m7sq*(-m1sq + m4sq + m7sq))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (16*m1sq*(m4sq - m6sq)*m7**4*(m1sq + m4sq + m7sq))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (2*m1**4*(m1sq + m4sq + m7sq))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (2*m4**4*(m1sq + m4sq + m7sq))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (2*m7**4*(m1sq + m4sq + m7sq))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (8*(m4sq - m6sq)*m7**4*(m4sq - m7sq)*(m1sq + m4sq + m7sq))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (8*m1**4*(m4sq - m6sq)*m7sq*(m1sq + m4sq + m7sq))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (8*m1sq*m4sq*(m4sq - m6sq)*m7sq*(m1sq + m4sq + m7sq))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (4*m4sq*m7sq*(m1sq + m4sq + m7sq))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (16*m4sq*(m4sq - m6sq)*(m4sq - m7sq)*m7sq*(m1sq + m4sq + m7sq))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (4*m1sq*(m4sq + m7sq)*(m1sq + m4sq + m7sq))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m7sq*(-m6sq + m7sq)**3)/(m1**2*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (4*m6sq*m7sq*(-m1sq + m6sq + m7sq))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*m1**4*(m1sq + m6sq + m7sq))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*m6**4*(m1sq + m6sq + m7sq))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*m7**4*(m1sq + m6sq + m7sq))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (4*m6sq*m7sq*(m1sq + m6sq + m7sq))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (4*m1sq*(m6sq + m7sq)*(m1sq + m6sq + m7sq))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (-5*m6**6 + 5*m6**4*m7sq)/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (8*m1**4*(m4sq - m6sq)*m7**4*B0del(0,0,m1sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (4*m1sq*m4sq*(m4sq - m6sq)*m7**4*B0del(0,0,m1sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (4*m1sq*(m4sq - m6sq)*m7**6*B0del(0,0,m1sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (4*m1**6*(m4sq - m6sq)*m7sq*B0del(0,0,m1sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (8*m1sq*m4**4*(m4sq - m6sq)*m7sq*B0del(0,0,m1sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (4*m1**4*m4sq*(m4sq - m6sq)*m7sq*B0del(0,0,m1sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (4*m1sq*m4sq*m7sq*B0del(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (4*m1sq*m6sq*m7sq*B0del(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (8*m1sq*m4sq*(m4sq - m6sq)*m7**4*B0del(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (6*m4sq*(m4sq - m6sq)*m7**4*(m4sq - m7sq)*B0del(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (2*(m4sq - m6sq)*m7**6*(m4sq - m7sq)*B0del(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (2*(m4sq - m6sq)*m7**4*(m4sq - m7sq)**2*B0del(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (4*m1sq*m4**4*(m4sq - m6sq)*m7sq*B0del(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (4*m1**4*m4sq*(m4sq - m6sq)*m7sq*B0del(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (2*m1sq*m4sq*m7sq*B0del(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (4*m4**4*(m4sq - m6sq)*(m4sq - m7sq)*m7sq*B0del(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (2*m4sq*(m4sq - m7sq)*m7sq*B0del(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (4*m4sq*(m4sq - m6sq)*(m4sq - m7sq)**2*m7sq*B0del(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (2*m4sq*m7sq*(-m1sq + m4sq + m7sq)*B0del(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m1sq*m6sq*m7sq*B0del(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*m6sq*(m6sq - m7sq)*m7sq*B0del(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*m6sq*m7sq*(-m1sq + m6sq + m7sq)*B0del(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (4*m1**4*(m4sq - m6sq)*m7**4*B0del(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (4*m1sq*m4sq*(m4sq - m6sq)*m7**4*B0del(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (8*m1sq*(m4sq - m6sq)*m7**6*B0del(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (6*m4sq*(m4sq - m6sq)*m7**4*(m4sq - m7sq)*B0del(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (2*(m4sq - m6sq)*m7**6*(m4sq - m7sq)*B0del(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (2*(m4sq - m6sq)*m7**4*(m4sq - m7sq)**2*B0del(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (2*m1sq*m4sq*m7sq*B0del(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m1sq*m6sq*m7sq*B0del(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (4*m4**4*(m4sq - m6sq)*(m4sq - m7sq)*m7sq*B0del(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (2*m4sq*(m4sq - m7sq)*m7sq*B0del(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (4*m4sq*(m4sq - m6sq)*(m4sq - m7sq)**2*m7sq*B0del(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (2*m6sq*(m6sq - m7sq)*m7sq*B0del(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (2*m4sq*m7sq*(-m1sq + m4sq + m7sq)*B0del(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m6sq*m7sq*(-m1sq + m6sq + m7sq)*B0del(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (m1**8*(m4sq - m6sq)*B0fin(0,0,m1sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (2*m1sq*m4**6*(m4sq - m6sq)*B0fin(0,0,m1sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (2*m1**6*m4sq*(m4sq - m6sq)*B0fin(0,0,m1sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (2*m1**4*(m4sq - m6sq)*m7**4*B0fin(0,0,m1sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (14*m1sq*m4sq*(m4sq - m6sq)*m7**4*B0fin(0,0,m1sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (8*m1sq*(m4sq - m6sq)*m7**6*B0fin(0,0,m1sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (7*m1sq*m4**4*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (3*m1**4*m4sq*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (7*m1sq*m7**4*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (7*m1sq*m6**4*B0fin(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (3*m1**4*m6sq*B0fin(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (7*m1sq*m7**4*B0fin(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (5*m4**4*(m4sq - m7sq)*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (5*m7**4*(m4sq - m7sq)*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (m4**4*(m4sq - m6sq)*(m4sq - m7sq)**2*B0fin(0,0,m1sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (5*(m4sq - m6sq)*m7**4*(m4sq - m7sq)**2*B0fin(0,0,m1sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (m4sq*(m4sq - m7sq)**3*B0fin(0,0,m1sq,mudim))/(m1**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (5*m6**4*(m6sq - m7sq)*B0fin(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (m6sq*(m6sq - m7sq)**3*B0fin(0,0,m1sq,mudim))/(m1**2*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (8*m1sq*m4**4*(m4sq - m6sq)*m7sq*B0fin(0,0,m1sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (10*m1**4*m4sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m1sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (3*m1**4*m7sq*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (6*m1sq*m4sq*m7sq*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (3*m1**4*m7sq*B0fin(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (6*m1sq*m6sq*m7sq*B0fin(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (4*m4sq*(m4sq - m6sq)*(m4sq - m7sq)**2*m7sq*B0fin(0,0,m1sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + ((m6sq - m7sq)**3*m7sq*B0fin(0,0,m1sq,mudim))/(m1**2*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (m7sq*(-m4sq + m7sq)**3*B0fin(0,0,m1sq,mudim))/(m1**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (5*m7**4*(-m6sq + m7sq)*B0fin(0,0,m1sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (m1**8*(m4sq - m6sq)*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (2*m1sq*m4**6*(m4sq - m6sq)*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (2*m1**6*m4sq*(m4sq - m6sq)*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (2*m1**4*(m4sq - m6sq)*m7**4*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (26*m1sq*m4sq*(m4sq - m6sq)*m7**4*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (2*m1sq*(m4sq - m6sq)*m7**6*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (7*m1sq*m4**4*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (3*m1**4*m4sq*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (18*m4sq*(m4sq - m6sq)*m7**4*(m4sq - m7sq)*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (2*(m4sq - m6sq)*m7**6*(m4sq - m7sq)*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (5*m4**4*(m4sq - m7sq)*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (m4**4*(m4sq - m6sq)*(m4sq - m7sq)**2*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - ((m4sq - m6sq)*m7**4*(m4sq - m7sq)**2*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (m4sq*(m4sq - m7sq)**3*B0fin(0,0,m4sq,mudim))/(m1**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (3*m1**6*(m4sq - m6sq)*m7sq*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (6*m1sq*m4**4*(m4sq - m6sq)*m7sq*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (14*m1**4*m4sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (3*m1sq*m4sq*m7sq*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (4*m4**4*(m4sq - m6sq)*(m4sq - m7sq)*m7sq*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (m4sq*(m4sq - m7sq)*m7sq*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (4*m4sq*(m4sq - m6sq)*(m4sq - m7sq)**2*m7sq*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + ((m4sq - m6sq)*(m4sq - m7sq)**4*m7sq*B0fin(0,0,m4sq,mudim))/(m1**2*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (2*m4sq*m7sq*(-m1sq + m4sq + m7sq)*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (6*m1**4*(m4sq - m6sq)*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (4*m1sq*m4sq*(m4sq - m6sq)*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (6*m1sq*(m4sq - m6sq)*m7**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (2*(m4sq - m6sq)*m7**4*(m4sq - m7sq)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (2*m1**6*(m4sq - m6sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (2*m1sq*m4**4*(m4sq - m6sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (4*m1**4*m4sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (2*m1sq*m4sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (2*m4sq*(m4sq - m7sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (4*m4sq*(m4sq - m6sq)*(m4sq - m7sq)**2*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (7*m1sq*m6**4*B0fin(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (3*m1**4*m6sq*B0fin(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (5*m6**4*(m6sq - m7sq)*B0fin(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (m6sq*(m6sq - m7sq)**3*B0fin(0,0,m6sq,mudim))/(m1**2*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (3*m1sq*m6sq*m7sq*B0fin(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*m6sq*m7sq*(-m1sq + m6sq + m7sq)*B0fin(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*m1sq*m6sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (12*m1**4*(m4sq - m6sq)*m7**4*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (16*m1sq*m4sq*(m4sq - m6sq)*m7**4*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (2*m1sq*(m4sq - m6sq)*m7**6*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (7*m1sq*m7**4*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (7*m1sq*m7**4*B0fin(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (18*m4sq*(m4sq - m6sq)*m7**4*(m4sq - m7sq)*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (2*(m4sq - m6sq)*m7**6*(m4sq - m7sq)*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (5*m7**4*(m4sq - m7sq)*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (6*(m4sq - m6sq)*m7**4*(m4sq - m7sq)**2*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (7*m1**6*(m4sq - m6sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (18*m1sq*m4**4*(m4sq - m6sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (20*m1**4*m4sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (3*m1**4*m7sq*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (3*m1sq*m4sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (3*m1**4*m7sq*B0fin(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (3*m1sq*m6sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (4*m4**4*(m4sq - m6sq)*(m4sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (m4sq*(m4sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - ((m4sq - m6sq)*(m4sq - m7sq)**4*m7sq*B0fin(0,0,m7sq,mudim))/(m1**2*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + ((m6sq - m7sq)**3*m7sq*B0fin(0,0,m7sq,mudim))/(m1**2*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (m7sq*(-m4sq + m7sq)**3*B0fin(0,0,m7sq,mudim))/(m1**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (2*m4sq*m7sq*(-m1sq + m4sq + m7sq)*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (5*m7**4*(-m6sq + m7sq)*B0fin(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*m6sq*m7sq*(-m1sq + m6sq + m7sq)*B0fin(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (2*m1**4*(m4sq - m6sq)*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (8*m1sq*m4sq*(m4sq - m6sq)*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (2*m1sq*(m4sq - m6sq)*m7**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (2*(m4sq - m6sq)*m7**4*(m4sq - m7sq)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (2*m1**6*(m4sq - m6sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (6*m1sq*m4**4*(m4sq - m6sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (2*m1sq*m4sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m1sq*m6sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*m4sq*(m4sq - m7sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (4*m4sq*(m4sq - m6sq)*(m4sq - m7sq)**2*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (2*m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (6*m1**4*(m4sq - m6sq)*m7**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (4*m1sq*m4sq*(m4sq - m6sq)*m7**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (6*m1sq*(m4sq - m6sq)*m7**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (6*m4sq*(m4sq - m6sq)*m7**4*(m4sq - m7sq)*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (2*(m4sq - m6sq)*m7**6*(m4sq - m7sq)*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (2*m1**6*(m4sq - m6sq)*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (6*m1sq*m4**4*(m4sq - m6sq)*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (4*m4**4*(m4sq - m6sq)*(m4sq - m7sq)*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (2*m4sq*m7sq*(-m1sq + m4sq + m7sq)*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m6sq*m7sq*(-m1sq + m6sq + m7sq)*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (m1**6*(m4sq - m6sq)*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (3*m1sq*m4**4*(m4sq - m6sq)*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (3*m1**4*m4sq*(m4sq - m6sq)*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (m1sq*(m4sq - m6sq)*m7**4*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (m1**4*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m4**4*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m7**4*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m4**4*(m4sq - m6sq)*(m4sq - m7sq)*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + ((m4sq - m6sq)*m7**4*(m4sq - m7sq)*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (m1**4*(m4sq - m6sq)*m7sq*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (2*m1sq*m4sq*(m4sq - m6sq)*m7sq*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (2*m4sq*m7sq*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m4sq*(m4sq - m6sq)*(m4sq - m7sq)*m7sq*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (2*m1sq*(m4sq + m7sq)*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (m1**4*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (m6**4*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (m7**4*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*m6sq*m7sq*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*m1sq*(m6sq + m7sq)*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (8*m1sq*(m4sq - m6sq)*m7**4*T134fin(m7,m4,m1,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (4*(m4sq - m6sq)*m7**4*(m4sq - m7sq)*T134fin(m7,m4,m1,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (4*m1**4*(m4sq - m6sq)*m7sq*T134fin(m7,m4,m1,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (4*m1sq*m4sq*(m4sq - m6sq)*m7sq*T134fin(m7,m4,m1,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) + (4*m4sq*m7sq*T134fin(m7,m4,m1,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (8*m4sq*(m4sq - m6sq)*(m4sq - m7sq)*m7sq*T134fin(m7,m4,m1,mudim))/((m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3) - (4*m6sq*m7sq*T134fin(m7,m6,m1,mudim))/((m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2))/(2.*(m4sq - m6sq)**2)
		def eval_130():
			return ((-4*m1**6)/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + m1**8/((m1sq - m2sq)*(m1sq - m3sq)*m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (4*m1sq*m4**4)/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + m4**6/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (6*m1**4*m4sq)/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (8*m1sq*m7**4)/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (6*m1**4*m7**4)/((m1sq - m2sq)*(m1sq - m3sq)*m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (6*m4sq*m7**4)/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (4*m7**6)/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (4*m1sq*m7**6)/((m1sq - m2sq)*(m1sq - m3sq)*m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + m7**8/((m1sq - m2sq)*(m1sq - m3sq)*m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (4*m2**6)/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - m2**8/((m1sq - m2sq)*(m2sq - m3sq)*m4**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (4*m2sq*m4**4)/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - m4**6/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (6*m2**4*m4sq)/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (8*m2sq*m7**4)/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (6*m2**4*m7**4)/((m1sq - m2sq)*(m2sq - m3sq)*m4**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (6*m4sq*m7**4)/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (4*m7**6)/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (4*m2sq*m7**6)/((m1sq - m2sq)*(m2sq - m3sq)*m4**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - m7**8/((m1sq - m2sq)*(m2sq - m3sq)*m4**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (4*m3**6)/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - m3**8/((m1sq - m3sq)*(-m2sq + m3sq)*m4**2*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (4*m3sq*m4**4)/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - m4**6/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (6*m3**4*m4sq)/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (8*m3sq*m7**4)/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (6*m3**4*m7**4)/((m1sq - m3sq)*(-m2sq + m3sq)*m4**2*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (6*m4sq*m7**4)/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (4*m7**6)/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (4*m3sq*m7**6)/((m1sq - m3sq)*(-m2sq + m3sq)*m4**2*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - m7**8/((m1sq - m3sq)*(-m2sq + m3sq)*m4**2*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (8*m1**4*m7sq)/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (4*m1**6*m7sq)/((m1sq - m2sq)*(m1sq - m3sq)*m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (4*m4**4*m7sq)/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (8*m1sq*m4sq*m7sq)/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (8*m2**4*m7sq)/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (4*m2**6*m7sq)/((m1sq - m2sq)*(m2sq - m3sq)*m4**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (4*m4**4*m7sq)/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (8*m2sq*m4sq*m7sq)/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (8*m3**4*m7sq)/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (4*m3**6*m7sq)/((m1sq - m3sq)*(-m2sq + m3sq)*m4**2*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (4*m4**4*m7sq)/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (8*m3sq*m4sq*m7sq)/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (4*m1**4*m7sq*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (4*m2**4*m7sq*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (4*m3**4*m7sq*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (4*m1sq*m4sq*m7sq*B0del(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (4*m2sq*m4sq*m7sq*B0del(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (4*m3sq*m4sq*m7sq*B0del(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (4*m1sq*m7**4*B0del(0,0,m7sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (4*m2sq*m7**4*B0del(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (4*m3sq*m7**4*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (3*m1**6*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (m1**8*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m1sq*m4**4*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (3*m1**4*m4sq*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (m1sq*m7**4*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (3*m1**4*m7**4*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m1sq*m7**6*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m1**4*m7sq*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (3*m1**6*m7sq*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (m1sq*m4sq*m7sq*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (3*m2**6*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (m2**8*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*m4**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (m2sq*m4**4*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (3*m2**4*m4sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (m2sq*m7**4*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (3*m2**4*m7**4*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*m4**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (m2sq*m7**6*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*m4**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (2*m2**4*m7sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (3*m2**6*m7sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*m4**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (m2sq*m4sq*m7sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (3*m3**6*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (m3**8*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*m4**2*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (m3sq*m4**4*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (3*m3**4*m4sq*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (m3sq*m7**4*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (3*m3**4*m7**4*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*m4**2*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (m3sq*m7**6*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*m4**2*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (2*m3**4*m7sq*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (3*m3**6*m7sq*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*m4**2*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (m3sq*m4sq*m7sq*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (5*m1**6*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (m1**8*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (7*m1sq*m4**4*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (2*m4**6*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (9*m1**4*m4sq*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (5*m1sq*m7**4*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (6*m1**4*m7**4*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (9*m4sq*m7**4*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (5*m7**6*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (4*m1sq*m7**6*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (m7**8*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (5*m2**6*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (m2**8*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*m4**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (7*m2sq*m4**4*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (2*m4**6*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (9*m2**4*m4sq*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (5*m2sq*m7**4*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (6*m2**4*m7**4*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*m4**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (9*m4sq*m7**4*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (5*m7**6*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (4*m2sq*m7**6*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*m4**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (m7**8*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*m4**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (5*m3**6*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (m3**8*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*m4**2*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (7*m3sq*m4**4*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (2*m4**6*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (9*m3**4*m4sq*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (5*m3sq*m7**4*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (6*m3**4*m7**4*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*m4**2*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (9*m4sq*m7**4*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (5*m7**6*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (4*m3sq*m7**6*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*m4**2*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (m7**8*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*m4**2*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (5*m1**4*m7sq*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (4*m1**6*m7sq*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (7*m4**4*m7sq*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (2*m1sq*m4sq*m7sq*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (5*m2**4*m7sq*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (4*m2**6*m7sq*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*m4**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (7*m4**4*m7sq*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (2*m2sq*m4sq*m7sq*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (5*m3**4*m7sq*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (4*m3**6*m7sq*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*m4**2*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (7*m4**4*m7sq*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (2*m3sq*m4sq*m7sq*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (2*m1sq*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m1**4*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m1sq*m4sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m2sq*m7**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (2*m2**4*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (2*m2sq*m4sq*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (2*m3sq*m7**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (2*m3**4*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (2*m3sq*m4sq*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (2*m1sq*m7**4*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (3*m1**4*m7**4*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (3*m4sq*m7**4*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (3*m7**6*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (3*m1sq*m7**6*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (m7**8*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (2*m2sq*m7**4*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (3*m2**4*m7**4*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*m4**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (3*m4sq*m7**4*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (3*m7**6*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (3*m2sq*m7**6*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*m4**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (m7**8*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*m4**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (2*m3sq*m7**4*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (3*m3**4*m7**4*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*m4**2*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (3*m4sq*m7**4*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (3*m7**6*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (3*m3sq*m7**6*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*m4**2*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (m7**8*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*m4**2*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (m1**4*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m1**6*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*m4**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m4**4*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (m1sq*m4sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m2**4*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (m2**6*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*m4**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (m4**4*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (m2sq*m4sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (m3**4*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (m3**6*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*m4**2*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (m4**4*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (m3sq*m4sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (2*m1sq*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m1**4*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (2*m1sq*m4sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (2*m2sq*m7**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (2*m2**4*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (2*m2sq*m4sq*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (2*m3sq*m7**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (2*m3**4*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (2*m3sq*m4sq*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) + (2*m1sq*m7**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (2*m2sq*m7**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (2*m3sq*m7**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (2*m1**4*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m1sq*m4sq*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m2**4*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (2*m2sq*m4sq*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (2*m3**4*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (2*m3sq*m4sq*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2) - (4*m1sq*m7sq*T134fin(m7,m4,m1,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (4*m2sq*m7sq*T134fin(m7,m4,m2,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (4*m3sq*m7sq*T134fin(m7,m4,m3,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m7)**2*(m3 - m4 + m7)**2*(-m3 + m4 + m7)**2*(m3 + m4 + m7)**2))/2.
		def eval_131():
			return ((m2**6*(m1sq - m2sq)*(m4sq - m5sq))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) - ((m1sq - m2sq)*m2sq*m5**4*(m4sq - m5sq))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) - (m2**4*(m1sq - m2sq)*(m4sq - m5sq)*m5sq)/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + (3*(m1sq - m2sq)*m2sq*(m4sq - m5sq)*m7**4)/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + (m2**4*(m1sq - m2sq)*(m4sq - m5sq)*m7sq)/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + (2*(m1sq - m2sq)*m2sq*(m4sq - m5sq)*m5sq*m7sq)/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + (4*(m1sq - m2sq)*(m4sq - m5sq)*m5sq*(m5sq - m7sq)*m7sq)/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) - ((m1sq - m2sq)*(m4sq - m5sq)*(m5sq - m7sq)**2*m7sq)/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + (4*m2sq*(-m1sq + m2sq)*(m4sq - m5sq)*m7sq*(m5sq + m7sq))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + (2*m2**4*(-m1sq + m2sq)*(m4sq - m5sq)*(m2sq + m5sq + m7sq))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + (4*(m1sq - m2sq)*m2sq*(m4sq - m5sq)*m5sq*(m2sq + m5sq + m7sq))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + (2*(m1sq - m2sq)*m5**4*(-m4sq + m5sq)*(m2sq + m5sq + m7sq))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + (2*(m1sq - m2sq)*(m4sq - m5sq)*m7**4*(m2sq + m5sq + m7sq))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + ((m1sq - m2sq)*(m4sq - m5sq)*(m5**3 - m5*m7sq)**2)/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + (m1sq*(m4sq - m5sq)*m5sq*B0del(0,0,m1sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) - (2*m1sq*(m4sq - m5sq)*m7sq*B0del(0,0,m1sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + (m1sq*(m4sq - m5sq)*(-m1sq + m7sq)*B0del(0,0,m1sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + (2*(m1sq - m2sq)*m2sq*(m4sq - m5sq)*m7**4*B0del(0,0,m2sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + (2*m2**4*(-m1sq + m2sq)*(m4sq - m5sq)*m7sq*B0del(0,0,m2sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) - (2*(m1sq - m2sq)*m2sq*(m4sq - m5sq)*m5sq*m7sq*B0del(0,0,m2sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + ((m1sq - m2sq)*m2sq*m4sq*B0del(0,0,m2sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + ((m1sq - m2sq)*m2sq*m7sq*B0del(0,0,m2sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + (m2sq*(-m1sq + m2sq)*m5sq*B0del(0,0,m2sq,mudim))/(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)) + (m2sq*m5sq*(-m4sq + m5sq)*B0del(0,0,m2sq,mudim))/(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)) + (m2sq*(m4sq - m5sq)*(m2sq - m7sq)*B0del(0,0,m2sq,mudim))/(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)) + (m2sq*(-m1sq + m2sq)*m7sq*B0del(0,0,m2sq,mudim))/(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)) + (2*m2sq*(m4sq - m5sq)*m7sq*B0del(0,0,m2sq,mudim))/(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)) + ((m1sq - m2sq)*m2sq*m4sq*B0del(0,0,m4sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) - (2*(m1sq - m2sq)*m4sq*m7sq*B0del(0,0,m4sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + ((m1sq - m2sq)*m4sq*(-m4sq + m7sq)*B0del(0,0,m4sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) - ((m1sq - m2sq)*(m4sq - m5sq)*m7**4*(m5sq - m7sq)*B0del(0,0,m5sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) - (2*(m1sq - m2sq)*m2sq*(m4sq - m5sq)*m5sq*m7sq*B0del(0,0,m5sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + ((m1sq - m2sq)*m5sq*(-m4sq + m5sq)*(m5sq - m7sq)*m7sq*B0del(0,0,m5sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) - ((m1sq - m2sq)*(m4sq - m5sq)*(m5sq - m7sq)**2*m7sq*B0del(0,0,m5sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + (m1sq*(m4sq - m5sq)*m5sq*B0del(0,0,m5sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + ((m4sq - m5sq)*m5sq*m7sq*B0del(0,0,m5sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + (m2sq*(-m1sq + m2sq)*m5sq*B0del(0,0,m5sq,mudim))/(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)) + (m2sq*m5sq*(-m4sq + m5sq)*B0del(0,0,m5sq,mudim))/(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)) + ((m1sq - m2sq)*m5sq*(m5sq - m7sq)*B0del(0,0,m5sq,mudim))/(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)) + (2*(m1sq - m2sq)*m5sq*m7sq*B0del(0,0,m5sq,mudim))/(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)) + (m5sq*(-m4sq + m5sq)*m7sq*B0del(0,0,m5sq,mudim))/(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)) + (2*m2sq*(-m1sq + m2sq)*(m4sq - m5sq)*m7**4*B0del(0,0,m7sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) - ((m1sq - m2sq)*(m4sq - m5sq)*m7**4*(m5sq - m7sq)*B0del(0,0,m7sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + ((m1sq - m2sq)*m5sq*(-m4sq + m5sq)*(m5sq - m7sq)*m7sq*B0del(0,0,m7sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + ((m1sq - m2sq)*(m4sq - m5sq)*(m5sq - m7sq)**2*m7sq*B0del(0,0,m7sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + ((m1sq - m2sq)*m2sq*m7sq*B0del(0,0,m7sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) - (2*(m1sq - m2sq)*m4sq*m7sq*B0del(0,0,m7sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) - (2*m1sq*(m4sq - m5sq)*m7sq*B0del(0,0,m7sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + ((m4sq - m5sq)*m5sq*m7sq*B0del(0,0,m7sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + (m2sq*(-m1sq + m2sq)*m7sq*B0del(0,0,m7sq,mudim))/(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)) + (2*m2sq*(m4sq - m5sq)*m7sq*B0del(0,0,m7sq,mudim))/(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)) + (2*(m1sq - m2sq)*m5sq*m7sq*B0del(0,0,m7sq,mudim))/(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)) + (m5sq*(-m4sq + m5sq)*m7sq*B0del(0,0,m7sq,mudim))/(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)) + ((m1sq - m2sq)*(m4sq - m5sq)*m7sq*(m2**4 - 4*m2sq*m7sq + (m4sq - m7sq)*(-m5sq + m7sq))*B0del(0,0,m7sq,mudim))/((m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) - ((m1sq - m2sq)*(m4sq - m5sq)*m7sq*(-m5**4 + m7**4 + m1sq*(m2sq - m7sq) - m2sq*m7sq + 4*m5sq*m7sq)*B0del(0,0,m7sq,mudim))/((m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + (m1sq*m5sq*(-m4sq + m5sq)*B0fin(0,0,m1sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + (m1sq*(m4sq - m5sq)*(m1sq - m7sq)*B0fin(0,0,m1sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + (2*m1sq*(m4sq - m5sq)*m7sq*B0fin(0,0,m1sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + ((m1sq - m2sq)*m4sq*(-m4sq + m7sq)*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + ((m1sq - m2sq)*m5sq*(m5sq - m7sq)*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)))/(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)) + ((m1sq - m2sq)*(m4sq - m5sq)*m7sq*(m2**4 - 4*m2sq*m7sq + (m4sq - m7sq)*(-m5sq + m7sq))*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)))/((m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + (m2**6*(-m1sq + m2sq)*(m4sq - m5sq)*B0fin(0,0,m2sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + ((m1sq - m2sq)*m2sq*m5**4*(m4sq - m5sq)*B0fin(0,0,m2sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + (m2**4*(m1sq - m2sq)*(m4sq - m5sq)*m5sq*B0fin(0,0,m2sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + (5*m2sq*(-m1sq + m2sq)*(m4sq - m5sq)*m7**4*B0fin(0,0,m2sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + (m2**4*(m1sq - m2sq)*(m4sq - m5sq)*m7sq*B0fin(0,0,m2sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) - (4*(m1sq - m2sq)*m2sq*(m4sq - m5sq)*m5sq*m7sq*B0fin(0,0,m2sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + ((m1sq - m2sq)*(m4sq - m5sq)*(m5sq - m7sq)**2*m7sq*B0fin(0,0,m2sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + (4*(m1sq - m2sq)*m2sq*(m4sq - m5sq)*m7sq*(m5sq + m7sq)*B0fin(0,0,m2sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + ((m1sq - m2sq)*(-m4sq + m5sq)*(m5**3 - m5*m7sq)**2*B0fin(0,0,m2sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + (m2sq*(-m1sq + m2sq)*m4sq*B0fin(0,0,m2sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + (m2sq*(-m1sq + m2sq)*m7sq*B0fin(0,0,m2sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + ((m1sq - m2sq)*m2sq*m5sq*B0fin(0,0,m2sq,mudim))/(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)) + (m2sq*(m4sq - m5sq)*m5sq*B0fin(0,0,m2sq,mudim))/(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)) - (m2sq*(m4sq - m5sq)*(m2sq - m7sq)*B0fin(0,0,m2sq,mudim))/(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)) - (m2sq*(-m1sq + m2sq)*m7sq*B0fin(0,0,m2sq,mudim))/(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)) - (2*m2sq*(m4sq - m5sq)*m7sq*B0fin(0,0,m2sq,mudim))/(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)) + (m2sq*(-m1sq + m2sq)*m4sq*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + ((m1sq - m2sq)*m4sq*(m4sq - m7sq)*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + (2*(m1sq - m2sq)*m4sq*m7sq*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + ((m1sq - m2sq)*m2sq*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + ((m1sq - m2sq)*m4sq*(-m4sq + m7sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + (m1sq*(m4sq - m5sq)*(-m1sq + m7sq)*(B0del(0,0,m5sq,mudim) - B0fin(0,0,m5sq,mudim)))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + (m2sq*(m4sq - m5sq)*(m2sq - m7sq)*(B0del(0,0,m5sq,mudim) - B0fin(0,0,m5sq,mudim)))/(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)) - ((m1sq - m2sq)*(m4sq - m5sq)*m7sq*(-m5**4 + m7**4 + m1sq*(m2sq - m7sq) - m2sq*m7sq + 4*m5sq*m7sq)*(B0del(0,0,m5sq,mudim) - B0fin(0,0,m5sq,mudim)))/((m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + (m2**6*(-m1sq + m2sq)*(m4sq - m5sq)*B0fin(0,0,m5sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + ((m1sq - m2sq)*m2sq*m5**4*(m4sq - m5sq)*B0fin(0,0,m5sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + (m2**4*(m1sq - m2sq)*(m4sq - m5sq)*m5sq*B0fin(0,0,m5sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + (3*m2sq*(-m1sq + m2sq)*(m4sq - m5sq)*m7**4*B0fin(0,0,m5sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + ((m1sq - m2sq)*(m4sq - m5sq)*m7**4*(m5sq - m7sq)*B0fin(0,0,m5sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + (3*m2**4*(m1sq - m2sq)*(m4sq - m5sq)*m7sq*B0fin(0,0,m5sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + (3*(m1sq - m2sq)*m5sq*(-m4sq + m5sq)*(m5sq - m7sq)*m7sq*B0fin(0,0,m5sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + (2*(m1sq - m2sq)*(m4sq - m5sq)*(m5sq - m7sq)**2*m7sq*B0fin(0,0,m5sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + ((m1sq - m2sq)*(-m4sq + m5sq)*(m5**3 - m5*m7sq)**2*B0fin(0,0,m5sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + (m1sq*m5sq*(-m4sq + m5sq)*B0fin(0,0,m5sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + (m5sq*(-m4sq + m5sq)*m7sq*B0fin(0,0,m5sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + ((m1sq - m2sq)*m2sq*m5sq*B0fin(0,0,m5sq,mudim))/(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)) + (m2sq*(m4sq - m5sq)*m5sq*B0fin(0,0,m5sq,mudim))/(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)) - ((m1sq - m2sq)*m5sq*(m5sq - m7sq)*B0fin(0,0,m5sq,mudim))/(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)) - (2*(m1sq - m2sq)*m5sq*m7sq*B0fin(0,0,m5sq,mudim))/(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)) - (m5sq*(-m4sq + m5sq)*m7sq*B0fin(0,0,m5sq,mudim))/(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)) + (m1sq*(m4sq - m5sq)*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + (m1sq*(m4sq - m5sq)*(-m1sq + m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + (2*(m1sq - m2sq)*m2sq*(m4sq - m5sq)*m7**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + (m2**4*(-m1sq + m2sq)*(m4sq - m5sq)*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) - (2*(m1sq - m2sq)*m2sq*(m4sq - m5sq)*m5sq*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) - ((m1sq - m2sq)*(m4sq - m5sq)*(m5sq - m7sq)**2*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + (m2sq*(-m1sq + m2sq)*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim))/(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)) + (m2sq*m5sq*(-m4sq + m5sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim))/(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)) + (m2sq*(m4sq - m5sq)*(m2sq - m7sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim))/(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)) + ((m1sq - m2sq)*m5sq*(m5sq - m7sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim))/(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)) + (2*(m1sq - m2sq)*m2sq*(m4sq - m5sq)*m7**4*B0fin(0,0,m7sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + ((m1sq - m2sq)*(m4sq - m5sq)*m7**4*(m5sq - m7sq)*B0fin(0,0,m7sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + (4*m2**4*(-m1sq + m2sq)*(m4sq - m5sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + (4*(m1sq - m2sq)*m2sq*(m4sq - m5sq)*m5sq*m7sq*B0fin(0,0,m7sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + (3*(m1sq - m2sq)*m5sq*(-m4sq + m5sq)*(m5sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) - ((m1sq - m2sq)*(m4sq - m5sq)*(m5sq - m7sq)**2*m7sq*B0fin(0,0,m7sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + (4*(m1sq - m2sq)*m2sq*(m4sq - m5sq)*m7sq*(m5sq + m7sq)*B0fin(0,0,m7sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + (m2sq*(-m1sq + m2sq)*m7sq*B0fin(0,0,m7sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + (2*(m1sq - m2sq)*m4sq*m7sq*B0fin(0,0,m7sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + (2*m1sq*(m4sq - m5sq)*m7sq*B0fin(0,0,m7sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + (m5sq*(-m4sq + m5sq)*m7sq*B0fin(0,0,m7sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) - (m2sq*(-m1sq + m2sq)*m7sq*B0fin(0,0,m7sq,mudim))/(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)) - (2*m2sq*(m4sq - m5sq)*m7sq*B0fin(0,0,m7sq,mudim))/(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)) - (2*(m1sq - m2sq)*m5sq*m7sq*B0fin(0,0,m7sq,mudim))/(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)) - (m5sq*(-m4sq + m5sq)*m7sq*B0fin(0,0,m7sq,mudim))/(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)) - ((m1sq - m2sq)*(m4sq - m5sq)*m7sq*(m2**4 - 4*m2sq*m7sq + (m4sq - m7sq)*(-m5sq + m7sq))*B0fin(0,0,m7sq,mudim))/((m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + ((m1sq - m2sq)*(m4sq - m5sq)*m7sq*(-m5**4 + m7**4 + m1sq*(m2sq - m7sq) - m2sq*m7sq + 4*m5sq*m7sq)*B0fin(0,0,m7sq,mudim))/((m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) - (2*m1sq*(m4sq - m5sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + (m2**4*(-m1sq + m2sq)*(m4sq - m5sq)*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + ((m1sq - m2sq)*(m4sq - m5sq)*(m5sq - m7sq)**2*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + ((m1sq - m2sq)*m2sq*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + (m2sq*(-m1sq + m2sq)*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)) + (2*m2sq*(m4sq - m5sq)*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)) + ((m1sq - m2sq)*(m4sq - m5sq)*m7sq*(m2**4 - 4*m2sq*m7sq + (m4sq - m7sq)*(-m5sq + m7sq))*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) - (2*(m1sq - m2sq)*m4sq*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + (2*m2sq*(-m1sq + m2sq)*(m4sq - m5sq)*m7**4*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) - ((m1sq - m2sq)*(m4sq - m5sq)*m7**4*(m5sq - m7sq)*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + (m2**4*(m1sq - m2sq)*(m4sq - m5sq)*m7sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + ((m1sq - m2sq)*m5sq*(-m4sq + m5sq)*(m5sq - m7sq)*m7sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + ((m4sq - m5sq)*m5sq*m7sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + (2*(m1sq - m2sq)*m5sq*m7sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)) + (m5sq*(-m4sq + m5sq)*m7sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)) - ((m1sq - m2sq)*(m4sq - m5sq)*m7sq*(-m5**4 + m7**4 + m1sq*(m2sq - m7sq) - m2sq*m7sq + 4*m5sq*m7sq)*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + ((m1sq - m2sq)*(m2sq - m4sq - m7sq)*(m2sq + m4sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + ((m4sq - m5sq)*(-m1sq + m5sq - m7sq)*(m1sq + m5sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) - (m2**4*(-m1sq + m2sq)*(m4sq - m5sq)*(m2sq + m5sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) - ((m1sq - m2sq)*m5**4*(-m4sq + m5sq)*(m2sq + m5sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) - (2*m2sq*(-m1sq + m2sq)*m5sq*(-m4sq + m5sq)*(m2sq + m5sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + ((m1sq - m2sq)*(m4sq - m5sq)*m7**4*(m2sq + m5sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + (2*m2sq*(-m1sq + m2sq)*(m4sq - m5sq)*m7sq*(m2sq + m5sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + (2*(m1sq - m2sq)*m5sq*(-m4sq + m5sq)*m7sq*(m2sq + m5sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) - ((m1sq - m2sq)*(m2sq - m5sq - m7sq)*(m2sq + m5sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)) - ((m4sq - m5sq)*(-m2sq + m5sq - m7sq)*(m2sq + m5sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)) + T134fin(m7,m4,m1,mudim) - T134fin(m7,m4,m2,mudim) + ((m1sq - m2sq)*(m2sq - m4sq - m7sq)*T134fin(m7,m4,m2,mudim))/(4*m4sq*m7sq - (-m2sq + m4sq + m7sq)**2) - T134fin(m7,m5,m1,mudim) + ((m4sq - m5sq)*(-m1sq + m5sq - m7sq)*T134fin(m7,m5,m1,mudim))/(4*m1sq*m7sq - (m1sq - m5sq + m7sq)**2) + T134fin(m7,m5,m2,mudim) + (2*(-m1sq + m2sq)*(m4sq - m5sq)*m7**4*T134fin(m7,m5,m2,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) - (2*m2sq*(-m1sq + m2sq)*(m4sq - m5sq)*m7sq*T134fin(m7,m5,m2,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) - (2*(-m1sq + m2sq)*(m4sq - m5sq)*m5sq*m7sq*T134fin(m7,m5,m2,mudim))/((m2 + m5 - m7)**2*(m2 - m5 + m7)**2*(-m2 + m5 + m7)**2*(m2 + m5 + m7)**2) + ((m1sq - m2sq)*(m2sq - m5sq - m7sq)*T134fin(m7,m5,m2,mudim))/(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)) + ((m4sq - m5sq)*(-m2sq + m5sq - m7sq)*T134fin(m7,m5,m2,mudim))/(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)))/((m1sq - m2sq)**2*(m4sq - m5sq)**2)
		def eval_132():
			return ((m2**6*(-m1sq + m2sq)*(m4sq - m6sq))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (m2sq*(-m1sq + m2sq)*m4**4*(m4sq - m6sq))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (m2**4*(-m1sq + m2sq)*m4sq*(m4sq - m6sq))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (3*m2sq*(-m1sq + m2sq)*(m4sq - m6sq)*m7**4)/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (m2**4*(-m1sq + m2sq)*(m4sq - m6sq)*m7sq)/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (2*m2sq*(-m1sq + m2sq)*m4sq*(m4sq - m6sq)*m7sq)/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (4*(-m1sq + m2sq)*m4sq*(m4sq - m6sq)*(m4sq - m7sq)*m7sq)/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + ((m1sq - m2sq)*(m4sq - m6sq)*(m4sq - m7sq)**2*m7sq)/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (4*m2sq*(-m1sq + m2sq)*(m4sq - m6sq)*m7sq*(m4sq + m7sq))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (2*m2**4*(m1sq - m2sq)*(m4sq - m6sq)*(m2sq + m4sq + m7sq))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (2*(m1sq - m2sq)*m4**4*(m4sq - m6sq)*(m2sq + m4sq + m7sq))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (4*m2sq*(-m1sq + m2sq)*m4sq*(m4sq - m6sq)*(m2sq + m4sq + m7sq))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (2*(m1sq - m2sq)*(m4sq - m6sq)*m7**4*(m2sq + m4sq + m7sq))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + ((-m1sq + m2sq)*(m4sq - m6sq)*(m4**3 - m4*m7sq)**2)/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (m1sq*m4sq*(m4sq - m6sq)*B0del(0,0,m1sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (m1sq*(m4sq - m6sq)*(m1sq - m7sq)*B0del(0,0,m1sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (2*m1sq*(m4sq - m6sq)*m7sq*B0del(0,0,m1sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (2*m2sq*(-m1sq + m2sq)*(m4sq - m6sq)*m7**4*B0del(0,0,m2sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (2*m2**4*(-m1sq + m2sq)*(m4sq - m6sq)*m7sq*B0del(0,0,m2sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (2*m2sq*(-m1sq + m2sq)*m4sq*(m4sq - m6sq)*m7sq*B0del(0,0,m2sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (m2sq*(-m1sq + m2sq)*m4sq*B0del(0,0,m2sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + (m2sq*m4sq*(m4sq - m6sq)*B0del(0,0,m2sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + (m2sq*(-m1sq + m2sq)*m7sq*B0del(0,0,m2sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) - (2*m2sq*(m4sq - m6sq)*m7sq*B0del(0,0,m2sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + (m2sq*(m4sq - m6sq)*(-m2sq + m7sq)*B0del(0,0,m2sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + ((m1sq - m2sq)*m2sq*m6sq*B0del(0,0,m2sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + ((m1sq - m2sq)*m2sq*m7sq*B0del(0,0,m2sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + ((m1sq - m2sq)*(m4sq - m6sq)*m7**4*(m4sq - m7sq)*B0del(0,0,m4sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (2*m2sq*(-m1sq + m2sq)*m4sq*(m4sq - m6sq)*m7sq*B0del(0,0,m4sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + ((m1sq - m2sq)*m4sq*(m4sq - m6sq)*(m4sq - m7sq)*m7sq*B0del(0,0,m4sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + ((m1sq - m2sq)*(m4sq - m6sq)*(m4sq - m7sq)**2*m7sq*B0del(0,0,m4sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (m1sq*m4sq*(m4sq - m6sq)*B0del(0,0,m4sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (m4sq*(-m4sq + m6sq)*m7sq*B0del(0,0,m4sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (m2sq*(-m1sq + m2sq)*m4sq*B0del(0,0,m4sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + (m2sq*m4sq*(m4sq - m6sq)*B0del(0,0,m4sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + ((m1sq - m2sq)*m4sq*(m4sq - m7sq)*B0del(0,0,m4sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + (2*(m1sq - m2sq)*m4sq*m7sq*B0del(0,0,m4sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + (m4sq*(m4sq - m6sq)*m7sq*B0del(0,0,m4sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + ((m1sq - m2sq)*m2sq*m6sq*B0del(0,0,m6sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) - (2*(m1sq - m2sq)*m6sq*m7sq*B0del(0,0,m6sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + ((m1sq - m2sq)*m6sq*(-m6sq + m7sq)*B0del(0,0,m6sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) - (2*m2sq*(-m1sq + m2sq)*(m4sq - m6sq)*m7**4*B0del(0,0,m7sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + ((m1sq - m2sq)*(m4sq - m6sq)*m7**4*(m4sq - m7sq)*B0del(0,0,m7sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + ((m1sq - m2sq)*m4sq*(m4sq - m6sq)*(m4sq - m7sq)*m7sq*B0del(0,0,m7sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + ((-m1sq + m2sq)*(m4sq - m6sq)*(m4sq - m7sq)**2*m7sq*B0del(0,0,m7sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (2*m1sq*(m4sq - m6sq)*m7sq*B0del(0,0,m7sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (m4sq*(-m4sq + m6sq)*m7sq*B0del(0,0,m7sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (m2sq*(-m1sq + m2sq)*m7sq*B0del(0,0,m7sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + (2*(m1sq - m2sq)*m4sq*m7sq*B0del(0,0,m7sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) - (2*m2sq*(m4sq - m6sq)*m7sq*B0del(0,0,m7sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + (m4sq*(m4sq - m6sq)*m7sq*B0del(0,0,m7sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + ((m1sq - m2sq)*(m4sq - m6sq)*m7sq*(-m4**4 + m7**4 + m1sq*(m2sq - m7sq) - m2sq*m7sq + 4*m4sq*m7sq)*B0del(0,0,m7sq,mudim))/((m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) + ((m1sq - m2sq)*m2sq*m7sq*B0del(0,0,m7sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) - (2*(m1sq - m2sq)*m6sq*m7sq*B0del(0,0,m7sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + ((m1sq - m2sq)*(m4sq - m6sq)*m7sq*(-m2**4 + (m4sq - m7sq)*(m6sq - m7sq) + 4*m2sq*m7sq)*B0del(0,0,m7sq,mudim))/((m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + (m1sq*m4sq*(m4sq - m6sq)*B0fin(0,0,m1sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) - (m1sq*(m4sq - m6sq)*(m1sq - m7sq)*B0fin(0,0,m1sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) - (2*m1sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m1sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + ((m1sq - m2sq)*m4sq*(m4sq - m7sq)*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + ((m1sq - m2sq)*m6sq*(-m6sq + m7sq)*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + ((m1sq - m2sq)*(m4sq - m6sq)*m7sq*(-m2**4 + (m4sq - m7sq)*(m6sq - m7sq) + 4*m2sq*m7sq)*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)))/((m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) - (m2**6*(-m1sq + m2sq)*(m4sq - m6sq)*B0fin(0,0,m2sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (m2sq*(-m1sq + m2sq)*m4**4*(m4sq - m6sq)*B0fin(0,0,m2sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (m2**4*(-m1sq + m2sq)*m4sq*(m4sq - m6sq)*B0fin(0,0,m2sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (5*m2sq*(-m1sq + m2sq)*(m4sq - m6sq)*m7**4*B0fin(0,0,m2sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (m2**4*(-m1sq + m2sq)*(m4sq - m6sq)*m7sq*B0fin(0,0,m2sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (4*m2sq*(-m1sq + m2sq)*m4sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m2sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + ((-m1sq + m2sq)*(m4sq - m6sq)*(m4sq - m7sq)**2*m7sq*B0fin(0,0,m2sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (4*m2sq*(-m1sq + m2sq)*(m4sq - m6sq)*m7sq*(m4sq + m7sq)*B0fin(0,0,m2sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + ((m1sq - m2sq)*(m4sq - m6sq)*(m4**3 - m4*m7sq)**2*B0fin(0,0,m2sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + ((m1sq - m2sq)*m2sq*m4sq*B0fin(0,0,m2sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) - (m2sq*m4sq*(m4sq - m6sq)*B0fin(0,0,m2sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + (m2sq*(m4sq - m6sq)*(m2sq - m7sq)*B0fin(0,0,m2sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) - (m2sq*(-m1sq + m2sq)*m7sq*B0fin(0,0,m2sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + (2*m2sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m2sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + (m2sq*(-m1sq + m2sq)*m6sq*B0fin(0,0,m2sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + (m2sq*(-m1sq + m2sq)*m7sq*B0fin(0,0,m2sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + (m1sq*(m4sq - m6sq)*(m1sq - m7sq)*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (m2sq*(m4sq - m6sq)*(-m2sq + m7sq)*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + ((m1sq - m2sq)*(m4sq - m6sq)*m7sq*(-m4**4 + m7**4 + m1sq*(m2sq - m7sq) - m2sq*m7sq + 4*m4sq*m7sq)*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/((m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) - (m2**6*(-m1sq + m2sq)*(m4sq - m6sq)*B0fin(0,0,m4sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (m2sq*(-m1sq + m2sq)*m4**4*(m4sq - m6sq)*B0fin(0,0,m4sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (m2**4*(-m1sq + m2sq)*m4sq*(m4sq - m6sq)*B0fin(0,0,m4sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (3*m2sq*(-m1sq + m2sq)*(m4sq - m6sq)*m7**4*B0fin(0,0,m4sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + ((-m1sq + m2sq)*(m4sq - m6sq)*m7**4*(m4sq - m7sq)*B0fin(0,0,m4sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (3*m2**4*(-m1sq + m2sq)*(m4sq - m6sq)*m7sq*B0fin(0,0,m4sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (3*(m1sq - m2sq)*m4sq*(m4sq - m6sq)*(m4sq - m7sq)*m7sq*B0fin(0,0,m4sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (2*(-m1sq + m2sq)*(m4sq - m6sq)*(m4sq - m7sq)**2*m7sq*B0fin(0,0,m4sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + ((m1sq - m2sq)*(m4sq - m6sq)*(m4**3 - m4*m7sq)**2*B0fin(0,0,m4sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (m1sq*m4sq*(m4sq - m6sq)*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (m4sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + ((m1sq - m2sq)*m2sq*m4sq*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) - (m2sq*m4sq*(m4sq - m6sq)*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) - ((m1sq - m2sq)*m4sq*(m4sq - m7sq)*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) - (2*(m1sq - m2sq)*m4sq*m7sq*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) - (m4sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) - (m1sq*m4sq*(m4sq - m6sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (m1sq*(m4sq - m6sq)*(m1sq - m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (2*m2sq*(-m1sq + m2sq)*(m4sq - m6sq)*m7**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (m2**4*(-m1sq + m2sq)*(m4sq - m6sq)*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (2*m2sq*(-m1sq + m2sq)*m4sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + ((m1sq - m2sq)*(m4sq - m6sq)*(m4sq - m7sq)**2*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (m2sq*(-m1sq + m2sq)*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + (m2sq*m4sq*(m4sq - m6sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + ((m1sq - m2sq)*m4sq*(m4sq - m7sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + (m2sq*(m4sq - m6sq)*(-m2sq + m7sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + (m2sq*(-m1sq + m2sq)*m6sq*B0fin(0,0,m6sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + ((m1sq - m2sq)*m6sq*(m6sq - m7sq)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + (2*(m1sq - m2sq)*m6sq*m7sq*B0fin(0,0,m6sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + ((m1sq - m2sq)*m2sq*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + ((m1sq - m2sq)*m6sq*(-m6sq + m7sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + (2*m2sq*(-m1sq + m2sq)*(m4sq - m6sq)*m7**4*B0fin(0,0,m7sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + ((-m1sq + m2sq)*(m4sq - m6sq)*m7**4*(m4sq - m7sq)*B0fin(0,0,m7sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (4*m2**4*(-m1sq + m2sq)*(m4sq - m6sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (4*m2sq*(-m1sq + m2sq)*m4sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (3*(m1sq - m2sq)*m4sq*(m4sq - m6sq)*(m4sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + ((m1sq - m2sq)*(m4sq - m6sq)*(m4sq - m7sq)**2*m7sq*B0fin(0,0,m7sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (4*m2sq*(-m1sq + m2sq)*(m4sq - m6sq)*m7sq*(m4sq + m7sq)*B0fin(0,0,m7sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (2*m1sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m7sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (m4sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m7sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) - (m2sq*(-m1sq + m2sq)*m7sq*B0fin(0,0,m7sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) - (2*(m1sq - m2sq)*m4sq*m7sq*B0fin(0,0,m7sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + (2*m2sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m7sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) - (m4sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m7sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) - ((m1sq - m2sq)*(m4sq - m6sq)*m7sq*(-m4**4 + m7**4 + m1sq*(m2sq - m7sq) - m2sq*m7sq + 4*m4sq*m7sq)*B0fin(0,0,m7sq,mudim))/((m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) + (m2sq*(-m1sq + m2sq)*m7sq*B0fin(0,0,m7sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + (2*(m1sq - m2sq)*m6sq*m7sq*B0fin(0,0,m7sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + ((m1sq - m2sq)*(m4sq - m6sq)*m7sq*(m2**4 - 4*m2sq*m7sq + (m4sq - m7sq)*(-m6sq + m7sq))*B0fin(0,0,m7sq,mudim))/((m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + (2*m1sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) - (m2**4*(-m1sq + m2sq)*(m4sq - m6sq)*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + ((-m1sq + m2sq)*(m4sq - m6sq)*(m4sq - m7sq)**2*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (m2sq*(-m1sq + m2sq)*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) - (2*m2sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + ((m1sq - m2sq)*m2sq*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) + ((m1sq - m2sq)*(m4sq - m6sq)*m7sq*(-m2**4 + (m4sq - m7sq)*(m6sq - m7sq) + 4*m2sq*m7sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) - (2*m2sq*(-m1sq + m2sq)*(m4sq - m6sq)*m7**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + ((m1sq - m2sq)*(m4sq - m6sq)*m7**4*(m4sq - m7sq)*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (m2**4*(-m1sq + m2sq)*(m4sq - m6sq)*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + ((m1sq - m2sq)*m4sq*(m4sq - m6sq)*(m4sq - m7sq)*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (m4sq*(-m4sq + m6sq)*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (2*(m1sq - m2sq)*m4sq*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + (m4sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + ((m1sq - m2sq)*(m4sq - m6sq)*m7sq*(-m4**4 + m7**4 + m1sq*(m2sq - m7sq) - m2sq*m7sq + 4*m4sq*m7sq)*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) - (2*(m1sq - m2sq)*m6sq*m7sq*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) - ((m4sq - m6sq)*(-m1sq + m4sq - m7sq)*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (m2**4*(-m1sq + m2sq)*(m4sq - m6sq)*(m2sq + m4sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - ((m1sq - m2sq)*m4**4*(m4sq - m6sq)*(m2sq + m4sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (2*m2sq*(-m1sq + m2sq)*m4sq*(m4sq - m6sq)*(m2sq + m4sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - ((m1sq - m2sq)*(m4sq - m6sq)*m7**4*(m2sq + m4sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (2*m2sq*(-m1sq + m2sq)*(m4sq - m6sq)*m7sq*(m2sq + m4sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (2*(m1sq - m2sq)*m4sq*(m4sq - m6sq)*m7sq*(m2sq + m4sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - ((m1sq - m2sq)*(m2sq - m4sq - m7sq)*(m2sq + m4sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + ((m4sq - m6sq)*(-m2sq + m4sq - m7sq)*(m2sq + m4sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + ((m1sq - m2sq)*(m2sq - m6sq - m7sq)*(m2sq + m6sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq)) - T134fin(m7,m4,m1,mudim) + ((m4sq - m6sq)*(-m1sq + m4sq - m7sq)*T134fin(m7,m4,m1,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + T134fin(m7,m4,m2,mudim) + (2*(m1sq - m2sq)*(m4sq - m6sq)*m7**4*T134fin(m7,m4,m2,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + (2*m2sq*(-m1sq + m2sq)*(m4sq - m6sq)*m7sq*T134fin(m7,m4,m2,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) - (2*(m1sq - m2sq)*m4sq*(m4sq - m6sq)*m7sq*T134fin(m7,m4,m2,mudim))/((m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2) + ((m4sq - m6sq)*(-m2sq + m4sq - m7sq)*T134fin(m7,m4,m2,mudim))/(4*m2sq*m7sq - (m2sq - m4sq + m7sq)**2) + ((m1sq - m2sq)*(m2sq - m4sq - m7sq)*T134fin(m7,m4,m2,mudim))/(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq)) + T134fin(m7,m6,m1,mudim) - T134fin(m7,m6,m2,mudim) + ((m1sq - m2sq)*(m2sq - m6sq - m7sq)*T134fin(m7,m6,m2,mudim))/(4*m6sq*m7sq - (-m2sq + m6sq + m7sq)**2))/((m1sq - m2sq)**2*(m4sq - m6sq)**2)
		def eval_133():
			return ((m1**6*(m1sq - m3sq)*(-m4sq + m5sq))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (m1sq*(m1sq - m3sq)*m5**4*(-m4sq + m5sq))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (m1**4*(m1sq - m3sq)*m5sq*(-m4sq + m5sq))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (3*m1sq*(m1sq - m3sq)*(-m4sq + m5sq)*m7**4)/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (m1**4*(m1sq - m3sq)*(m4sq - m5sq)*m7sq)/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (2*m1sq*(m1sq - m3sq)*m5sq*(-m4sq + m5sq)*m7sq)/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (4*(m1sq - m3sq)*m5sq*(-m4sq + m5sq)*(m5sq - m7sq)*m7sq)/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + ((m1sq - m3sq)*(m4sq - m5sq)*(m5sq - m7sq)**2*m7sq)/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (4*m1sq*(m1sq - m3sq)*(m4sq - m5sq)*m7sq*(m5sq + m7sq))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (2*m1**4*(m1sq - m3sq)*(m4sq - m5sq)*(m1sq + m5sq + m7sq))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (2*(m1sq - m3sq)*m5**4*(m4sq - m5sq)*(m1sq + m5sq + m7sq))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (4*m1sq*(m1sq - m3sq)*m5sq*(-m4sq + m5sq)*(m1sq + m5sq + m7sq))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (2*(m1sq - m3sq)*(m4sq - m5sq)*m7**4*(m1sq + m5sq + m7sq))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + ((m1sq - m3sq)*(-m4sq + m5sq)*(m5**3 - m5*m7sq)**2)/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (2*m1sq*(m1sq - m3sq)*(-m4sq + m5sq)*m7**4*B0del(0,0,m1sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (2*m1**4*(m1sq - m3sq)*(m4sq - m5sq)*m7sq*B0del(0,0,m1sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (2*m1sq*(m1sq - m3sq)*m5sq*(-m4sq + m5sq)*m7sq*B0del(0,0,m1sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (m1sq*(m1sq - m3sq)*m4sq*B0del(0,0,m1sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (m1sq*(-m1sq + m3sq)*m7sq*B0del(0,0,m1sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (m1sq*(m1sq - m3sq)*m5sq*B0del(0,0,m1sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + (m1sq*m5sq*(-m4sq + m5sq)*B0del(0,0,m1sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + (m1sq*(m4sq - m5sq)*(m1sq - m7sq)*B0del(0,0,m1sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + (m1sq*(m1sq - m3sq)*m7sq*B0del(0,0,m1sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + (2*m1sq*(m4sq - m5sq)*m7sq*B0del(0,0,m1sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + (m3sq*(m4sq - m5sq)*m5sq*B0del(0,0,m3sq,mudim))/(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq)) - (2*m3sq*(m4sq - m5sq)*m7sq*B0del(0,0,m3sq,mudim))/(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq)) + (m3sq*(m4sq - m5sq)*(-m3sq + m7sq)*B0del(0,0,m3sq,mudim))/(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq)) - (m1sq*(m1sq - m3sq)*m4sq*B0del(0,0,m4sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + ((m1sq - m3sq)*m4sq*(m4sq - m7sq)*B0del(0,0,m4sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (2*(m1sq - m3sq)*m4sq*m7sq*B0del(0,0,m4sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + ((m1sq - m3sq)*(m4sq - m5sq)*m7**4*(m5sq - m7sq)*B0del(0,0,m5sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (2*m1sq*(m1sq - m3sq)*m5sq*(-m4sq + m5sq)*m7sq*B0del(0,0,m5sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - ((m1sq - m3sq)*m5sq*(-m4sq + m5sq)*(m5sq - m7sq)*m7sq*B0del(0,0,m5sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + ((m1sq - m3sq)*(m4sq - m5sq)*(m5sq - m7sq)**2*m7sq*B0del(0,0,m5sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (m1sq*(m1sq - m3sq)*m5sq*B0del(0,0,m5sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + (m1sq*m5sq*(-m4sq + m5sq)*B0del(0,0,m5sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) - (2*(m1sq - m3sq)*m5sq*m7sq*B0del(0,0,m5sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + (m5sq*(-m4sq + m5sq)*m7sq*B0del(0,0,m5sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + ((m1sq - m3sq)*m5sq*(-m5sq + m7sq)*B0del(0,0,m5sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + (m3sq*(m4sq - m5sq)*m5sq*B0del(0,0,m5sq,mudim))/(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq)) + ((m4sq - m5sq)*m5sq*m7sq*B0del(0,0,m5sq,mudim))/(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq)) + (2*m1sq*(m1sq - m3sq)*(m4sq - m5sq)*m7**4*B0del(0,0,m7sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + ((m1sq - m3sq)*(m4sq - m5sq)*m7**4*(m5sq - m7sq)*B0del(0,0,m7sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (m1**4*(m1sq - m3sq)*(m4sq - m5sq)*m7sq*B0del(0,0,m7sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (m1**4*(m1sq - m3sq)*(-m4sq + m5sq)*m7sq*B0del(0,0,m7sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - ((m1sq - m3sq)*m5sq*(-m4sq + m5sq)*(m5sq - m7sq)*m7sq*B0del(0,0,m7sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - ((m1sq - m3sq)*(m4sq - m5sq)*(m5sq - m7sq)**2*m7sq*B0del(0,0,m7sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (m1sq*(-m1sq + m3sq)*m7sq*B0del(0,0,m7sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (2*(m1sq - m3sq)*m4sq*m7sq*B0del(0,0,m7sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (m1sq*(m1sq - m3sq)*m7sq*B0del(0,0,m7sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + (2*m1sq*(m4sq - m5sq)*m7sq*B0del(0,0,m7sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) - (2*(m1sq - m3sq)*m5sq*m7sq*B0del(0,0,m7sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + (m5sq*(-m4sq + m5sq)*m7sq*B0del(0,0,m7sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + ((m1sq - m3sq)*(m4sq - m5sq)*m7sq*(-m1**4 + (m4sq - m7sq)*(m5sq - m7sq) + 4*m1sq*m7sq)*B0del(0,0,m7sq,mudim))/((m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) - (2*m3sq*(m4sq - m5sq)*m7sq*B0del(0,0,m7sq,mudim))/(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq)) + ((m4sq - m5sq)*m5sq*m7sq*B0del(0,0,m7sq,mudim))/(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq)) + ((m1sq - m3sq)*(m4sq - m5sq)*m7sq*(-m5**4 + m7**4 + m1sq*(m3sq - m7sq) - m3sq*m7sq + 4*m5sq*m7sq)*B0del(0,0,m7sq,mudim))/((m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))*(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq))) + ((m1sq - m3sq)*m4sq*(m4sq - m7sq)*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + ((m1sq - m3sq)*m5sq*(-m5sq + m7sq)*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + ((m1sq - m3sq)*(m4sq - m5sq)*m7sq*(-m1**4 + (m4sq - m7sq)*(m5sq - m7sq) + 4*m1sq*m7sq)*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/((m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) + (m1**6*(m1sq - m3sq)*(m4sq - m5sq)*B0fin(0,0,m1sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (m1sq*(m1sq - m3sq)*m5**4*(-m4sq + m5sq)*B0fin(0,0,m1sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (m1**4*(m1sq - m3sq)*m5sq*(-m4sq + m5sq)*B0fin(0,0,m1sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (5*m1sq*(m1sq - m3sq)*(m4sq - m5sq)*m7**4*B0fin(0,0,m1sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (3*m1**4*(m1sq - m3sq)*(m4sq - m5sq)*m7sq*B0fin(0,0,m1sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (4*m1**4*(m1sq - m3sq)*(-m4sq + m5sq)*m7sq*B0fin(0,0,m1sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (4*m1sq*(m1sq - m3sq)*m5sq*(-m4sq + m5sq)*m7sq*B0fin(0,0,m1sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + ((m1sq - m3sq)*(m4sq - m5sq)*(m5sq - m7sq)**2*m7sq*B0fin(0,0,m1sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (2*(m1sq - m3sq)*(-m4sq + m5sq)*(m5sq - m7sq)**2*m7sq*B0fin(0,0,m1sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (4*m1sq*(m1sq - m3sq)*(m4sq - m5sq)*m7sq*(m5sq + m7sq)*B0fin(0,0,m1sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + ((m1sq - m3sq)*(m4sq - m5sq)*(m5**3 - m5*m7sq)**2*B0fin(0,0,m1sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (m1sq*(m1sq - m3sq)*m4sq*B0fin(0,0,m1sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (m1sq*(m1sq - m3sq)*m7sq*B0fin(0,0,m1sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) - (m1sq*(m1sq - m3sq)*m5sq*B0fin(0,0,m1sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + (m1sq*(m4sq - m5sq)*m5sq*B0fin(0,0,m1sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) - (m1sq*(m4sq - m5sq)*(m1sq - m7sq)*B0fin(0,0,m1sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) - (m1sq*(m1sq - m3sq)*m7sq*B0fin(0,0,m1sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) - (2*m1sq*(m4sq - m5sq)*m7sq*B0fin(0,0,m1sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + (m3sq*m5sq*(-m4sq + m5sq)*B0fin(0,0,m3sq,mudim))/(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq)) + (m3sq*(m4sq - m5sq)*(m3sq - m7sq)*B0fin(0,0,m3sq,mudim))/(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq)) + (2*m3sq*(m4sq - m5sq)*m7sq*B0fin(0,0,m3sq,mudim))/(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq)) + (m1sq*(m1sq - m3sq)*m4sq*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) - ((m1sq - m3sq)*m4sq*(m4sq - m7sq)*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) - (2*(m1sq - m3sq)*m4sq*m7sq*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) - (m1sq*(m1sq - m3sq)*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + ((m1sq - m3sq)*m4sq*(m4sq - m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (m1sq*(m4sq - m5sq)*(m1sq - m7sq)*(B0del(0,0,m5sq,mudim) - B0fin(0,0,m5sq,mudim)))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + (m3sq*(m4sq - m5sq)*(-m3sq + m7sq)*(B0del(0,0,m5sq,mudim) - B0fin(0,0,m5sq,mudim)))/(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq)) + ((m1sq - m3sq)*(m4sq - m5sq)*m7sq*(-m5**4 + m7**4 + m1sq*(m3sq - m7sq) - m3sq*m7sq + 4*m5sq*m7sq)*(B0del(0,0,m5sq,mudim) - B0fin(0,0,m5sq,mudim)))/((m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))*(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq))) + (m1**6*(m1sq - m3sq)*(m4sq - m5sq)*B0fin(0,0,m5sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (m1sq*(m1sq - m3sq)*m5**4*(-m4sq + m5sq)*B0fin(0,0,m5sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (m1**4*(m1sq - m3sq)*m5sq*(-m4sq + m5sq)*B0fin(0,0,m5sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (3*m1sq*(m1sq - m3sq)*(m4sq - m5sq)*m7**4*B0fin(0,0,m5sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + ((m1sq - m3sq)*(-m4sq + m5sq)*m7**4*(m5sq - m7sq)*B0fin(0,0,m5sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (3*m1**4*(m1sq - m3sq)*(-m4sq + m5sq)*m7sq*B0fin(0,0,m5sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (3*(m1sq - m3sq)*m5sq*(-m4sq + m5sq)*(m5sq - m7sq)*m7sq*B0fin(0,0,m5sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (2*(m1sq - m3sq)*(-m4sq + m5sq)*(m5sq - m7sq)**2*m7sq*B0fin(0,0,m5sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + ((m1sq - m3sq)*(m4sq - m5sq)*(m5**3 - m5*m7sq)**2*B0fin(0,0,m5sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (m1sq*(m1sq - m3sq)*m5sq*B0fin(0,0,m5sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + (m1sq*(m4sq - m5sq)*m5sq*B0fin(0,0,m5sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + ((m1sq - m3sq)*m5sq*(m5sq - m7sq)*B0fin(0,0,m5sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + (2*(m1sq - m3sq)*m5sq*m7sq*B0fin(0,0,m5sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) - (m5sq*(-m4sq + m5sq)*m7sq*B0fin(0,0,m5sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + (m3sq*m5sq*(-m4sq + m5sq)*B0fin(0,0,m5sq,mudim))/(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq)) + (m5sq*(-m4sq + m5sq)*m7sq*B0fin(0,0,m5sq,mudim))/(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq)) + (2*m1sq*(m1sq - m3sq)*(-m4sq + m5sq)*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (m1**4*(m1sq - m3sq)*(m4sq - m5sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (2*m1sq*(m1sq - m3sq)*m5sq*(-m4sq + m5sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + ((m1sq - m3sq)*(m4sq - m5sq)*(m5sq - m7sq)**2*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (m1sq*(m1sq - m3sq)*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + (m1sq*m5sq*(-m4sq + m5sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + (m1sq*(m4sq - m5sq)*(m1sq - m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + ((m1sq - m3sq)*m5sq*(-m5sq + m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + (m3sq*(m4sq - m5sq)*m5sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim))/(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq)) + (m3sq*(m4sq - m5sq)*(-m3sq + m7sq)*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim))/(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq)) + (2*m1sq*(m1sq - m3sq)*(-m4sq + m5sq)*m7**4*B0fin(0,0,m7sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + ((m1sq - m3sq)*(-m4sq + m5sq)*m7**4*(m5sq - m7sq)*B0fin(0,0,m7sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (4*m1**4*(m1sq - m3sq)*(m4sq - m5sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (4*m1sq*(m1sq - m3sq)*m5sq*(-m4sq + m5sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (3*(m1sq - m3sq)*m5sq*(-m4sq + m5sq)*(m5sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + ((m1sq - m3sq)*(m4sq - m5sq)*(m5sq - m7sq)**2*m7sq*B0fin(0,0,m7sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (4*m1sq*(m1sq - m3sq)*(m4sq - m5sq)*m7sq*(m5sq + m7sq)*B0fin(0,0,m7sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (m1sq*(m1sq - m3sq)*m7sq*B0fin(0,0,m7sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) - (2*(m1sq - m3sq)*m4sq*m7sq*B0fin(0,0,m7sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) - (m1sq*(m1sq - m3sq)*m7sq*B0fin(0,0,m7sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) - (2*m1sq*(m4sq - m5sq)*m7sq*B0fin(0,0,m7sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + (2*(m1sq - m3sq)*m5sq*m7sq*B0fin(0,0,m7sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) - (m5sq*(-m4sq + m5sq)*m7sq*B0fin(0,0,m7sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + ((m1sq - m3sq)*(m4sq - m5sq)*m7sq*(m1**4 - 4*m1sq*m7sq + (m4sq - m7sq)*(-m5sq + m7sq))*B0fin(0,0,m7sq,mudim))/((m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) + (2*m3sq*(m4sq - m5sq)*m7sq*B0fin(0,0,m7sq,mudim))/(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq)) + (m5sq*(-m4sq + m5sq)*m7sq*B0fin(0,0,m7sq,mudim))/(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq)) - ((m1sq - m3sq)*(m4sq - m5sq)*m7sq*(-m5**4 + m7**4 + m1sq*(m3sq - m7sq) - m3sq*m7sq + 4*m5sq*m7sq)*B0fin(0,0,m7sq,mudim))/((m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))*(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq))) + (m1**4*(m1sq - m3sq)*(m4sq - m5sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - ((m1sq - m3sq)*(m4sq - m5sq)*(m5sq - m7sq)**2*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (m1sq*(-m1sq + m3sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (m1sq*(m1sq - m3sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + (2*m1sq*(m4sq - m5sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + ((m1sq - m3sq)*(m4sq - m5sq)*m7sq*(-m1**4 + (m4sq - m7sq)*(m5sq - m7sq) + 4*m1sq*m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) - (2*m3sq*(m4sq - m5sq)*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim))/(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq)) + (2*(m1sq - m3sq)*m4sq*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (2*m1sq*(m1sq - m3sq)*(m4sq - m5sq)*m7**4*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + ((m1sq - m3sq)*(m4sq - m5sq)*m7**4*(m5sq - m7sq)*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (m1**4*(m1sq - m3sq)*(-m4sq + m5sq)*m7sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - ((m1sq - m3sq)*m5sq*(-m4sq + m5sq)*(m5sq - m7sq)*m7sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (2*(m1sq - m3sq)*m5sq*m7sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + (m5sq*(-m4sq + m5sq)*m7sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + ((m4sq - m5sq)*m5sq*m7sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq)) + ((m1sq - m3sq)*(m4sq - m5sq)*m7sq*(-m5**4 + m7**4 + m1sq*(m3sq - m7sq) - m3sq*m7sq + 4*m5sq*m7sq)*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))*(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq))) - ((m1sq - m3sq)*(m1sq - m4sq - m7sq)*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) - (m1**4*(m1sq - m3sq)*(m4sq - m5sq)*(m1sq + m5sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + ((m1sq - m3sq)*m5**4*(-m4sq + m5sq)*(m1sq + m5sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (2*m1sq*(m1sq - m3sq)*m5sq*(-m4sq + m5sq)*(m1sq + m5sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - ((m1sq - m3sq)*(m4sq - m5sq)*m7**4*(m1sq + m5sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (2*m1sq*(m1sq - m3sq)*(m4sq - m5sq)*m7sq*(m1sq + m5sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (2*(m1sq - m3sq)*m5sq*(-m4sq + m5sq)*m7sq*(m1sq + m5sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + ((m1sq - m3sq)*(m1sq - m5sq - m7sq)*(m1sq + m5sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) - ((m4sq - m5sq)*(-m1sq + m5sq - m7sq)*(m1sq + m5sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + ((m4sq - m5sq)*(-m3sq + m5sq - m7sq)*(m3sq + m5sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq)) - T134fin(m7,m4,m1,mudim) + ((m1sq - m3sq)*(m1sq - m4sq - m7sq)*T134fin(m7,m4,m1,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + T134fin(m7,m4,m3,mudim) + T134fin(m7,m5,m1,mudim) + (2*(m1sq - m3sq)*(m4sq - m5sq)*m7**4*T134fin(m7,m5,m1,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (2*m1sq*(m1sq - m3sq)*(m4sq - m5sq)*m7sq*T134fin(m7,m5,m1,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (2*(m1sq - m3sq)*m5sq*(-m4sq + m5sq)*m7sq*T134fin(m7,m5,m1,mudim))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + ((m4sq - m5sq)*(-m1sq + m5sq - m7sq)*T134fin(m7,m5,m1,mudim))/(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq)) + ((m1sq - m3sq)*(m1sq - m5sq - m7sq)*T134fin(m7,m5,m1,mudim))/(4*m5sq*m7sq - (-m1sq + m5sq + m7sq)**2) - T134fin(m7,m5,m3,mudim) + ((m4sq - m5sq)*(-m3sq + m5sq - m7sq)*T134fin(m7,m5,m3,mudim))/(4*m3sq*m7sq - (m3sq - m5sq + m7sq)**2))/((m1sq - m3sq)**2*(m4sq - m5sq)**2)
		def eval_134():
			return ((m1**6*(m1sq - m3sq)*(m4sq - m6sq))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (m1sq*(m1sq - m3sq)*m4**4*(m4sq - m6sq))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (m1**4*(m1sq - m3sq)*m4sq*(m4sq - m6sq))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (3*m1sq*(m1sq - m3sq)*(m4sq - m6sq)*m7**4)/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m1**4*(m1sq - m3sq)*(m4sq - m6sq)*m7sq)/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m1sq*(m1sq - m3sq)*m4sq*(m4sq - m6sq)*m7sq)/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (4*(m1sq - m3sq)*m4sq*(m4sq - m6sq)*(m4sq - m7sq)*m7sq)/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - ((m1sq - m3sq)*(m4sq - m6sq)*(m4sq - m7sq)**2*m7sq)/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (4*m1sq*(m1sq - m3sq)*(m4sq - m6sq)*m7sq*(m4sq + m7sq))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (2*m1**4*(m1sq - m3sq)*(m4sq - m6sq)*(m1sq + m4sq + m7sq))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (2*(m1sq - m3sq)*m4**4*(m4sq - m6sq)*(m1sq + m4sq + m7sq))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (4*m1sq*(m1sq - m3sq)*m4sq*(m4sq - m6sq)*(m1sq + m4sq + m7sq))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*(m1sq - m3sq)*(m4sq - m6sq)*m7**4*(m1sq + m4sq + m7sq))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + ((m1sq - m3sq)*(m4sq - m6sq)*(m4**3 - m4*m7sq)**2)/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m1sq*(m1sq - m3sq)*(m4sq - m6sq)*m7**4*B0del(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (2*m1**4*(m1sq - m3sq)*(m4sq - m6sq)*m7sq*B0del(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (2*m1sq*(m1sq - m3sq)*m4sq*(m4sq - m6sq)*m7sq*B0del(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m1sq*(m1sq - m3sq)*m4sq*B0del(0,0,m1sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (m1sq*m4sq*(m4sq - m6sq)*B0del(0,0,m1sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (m1sq*(m1sq - m3sq)*m7sq*B0del(0,0,m1sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) - (2*m1sq*(m4sq - m6sq)*m7sq*B0del(0,0,m1sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (m1sq*(m4sq - m6sq)*(-m1sq + m7sq)*B0del(0,0,m1sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) - (m1sq*(m1sq - m3sq)*m6sq*B0del(0,0,m1sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (m1sq*(-m1sq + m3sq)*m7sq*B0del(0,0,m1sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) - (m3sq*m4sq*(m4sq - m6sq)*B0del(0,0,m3sq,mudim))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) + (m3sq*(m4sq - m6sq)*(m3sq - m7sq)*B0del(0,0,m3sq,mudim))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) + (2*m3sq*(m4sq - m6sq)*m7sq*B0del(0,0,m3sq,mudim))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) - ((m1sq - m3sq)*(m4sq - m6sq)*m7**4*(m4sq - m7sq)*B0del(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (2*m1sq*(m1sq - m3sq)*m4sq*(m4sq - m6sq)*m7sq*B0del(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - ((m1sq - m3sq)*m4sq*(m4sq - m6sq)*(m4sq - m7sq)*m7sq*B0del(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - ((m1sq - m3sq)*(m4sq - m6sq)*(m4sq - m7sq)**2*m7sq*B0del(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m1sq*(m1sq - m3sq)*m4sq*B0del(0,0,m4sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (m1sq*m4sq*(m4sq - m6sq)*B0del(0,0,m4sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) - (2*(m1sq - m3sq)*m4sq*m7sq*B0del(0,0,m4sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (m4sq*(m4sq - m6sq)*m7sq*B0del(0,0,m4sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + ((m1sq - m3sq)*m4sq*(-m4sq + m7sq)*B0del(0,0,m4sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) - (m3sq*m4sq*(m4sq - m6sq)*B0del(0,0,m4sq,mudim))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) + (m4sq*(-m4sq + m6sq)*m7sq*B0del(0,0,m4sq,mudim))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) - (m1sq*(m1sq - m3sq)*m6sq*B0del(0,0,m6sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + ((m1sq - m3sq)*m6sq*(m6sq - m7sq)*B0del(0,0,m6sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (2*(m1sq - m3sq)*m6sq*m7sq*B0del(0,0,m6sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) - (2*m1sq*(m1sq - m3sq)*(m4sq - m6sq)*m7**4*B0del(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - ((m1sq - m3sq)*(m4sq - m6sq)*m7**4*(m4sq - m7sq)*B0del(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - ((m1sq - m3sq)*m4sq*(m4sq - m6sq)*(m4sq - m7sq)*m7sq*B0del(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + ((m1sq - m3sq)*(m4sq - m6sq)*(m4sq - m7sq)**2*m7sq*B0del(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m1sq*(m1sq - m3sq)*m7sq*B0del(0,0,m7sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) - (2*(m1sq - m3sq)*m4sq*m7sq*B0del(0,0,m7sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) - (2*m1sq*(m4sq - m6sq)*m7sq*B0del(0,0,m7sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (m4sq*(m4sq - m6sq)*m7sq*B0del(0,0,m7sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (2*m3sq*(m4sq - m6sq)*m7sq*B0del(0,0,m7sq,mudim))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) + (m4sq*(-m4sq + m6sq)*m7sq*B0del(0,0,m7sq,mudim))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) - ((m1sq - m3sq)*(m4sq - m6sq)*m7sq*(-m4**4 + m7**4 + m1sq*(m3sq - m7sq) - m3sq*m7sq + 4*m4sq*m7sq)*B0del(0,0,m7sq,mudim))/((m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m1sq*(-m1sq + m3sq)*m7sq*B0del(0,0,m7sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (2*(m1sq - m3sq)*m6sq*m7sq*B0del(0,0,m7sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + ((m1sq - m3sq)*(m4sq - m6sq)*m7sq*(m1**4 - 4*m1sq*m7sq + (m4sq - m7sq)*(-m6sq + m7sq))*B0del(0,0,m7sq,mudim))/((m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + ((m1sq - m3sq)*m4sq*(-m4sq + m7sq)*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + ((m1sq - m3sq)*m6sq*(m6sq - m7sq)*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + ((m1sq - m3sq)*(m4sq - m6sq)*m7sq*(m1**4 - 4*m1sq*m7sq + (m4sq - m7sq)*(-m6sq + m7sq))*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/((m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (m1**6*(m1sq - m3sq)*(m4sq - m6sq)*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m1sq*(m1sq - m3sq)*m4**4*(m4sq - m6sq)*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m1**4*(m1sq - m3sq)*m4sq*(m4sq - m6sq)*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (5*m1sq*(m1sq - m3sq)*(m4sq - m6sq)*m7**4*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m1**4*(m1sq - m3sq)*(m4sq - m6sq)*m7sq*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (4*m1sq*(m1sq - m3sq)*m4sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + ((m1sq - m3sq)*(m4sq - m6sq)*(m4sq - m7sq)**2*m7sq*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (4*m1sq*(m1sq - m3sq)*(m4sq - m6sq)*m7sq*(m4sq + m7sq)*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - ((m1sq - m3sq)*(m4sq - m6sq)*(m4**3 - m4*m7sq)**2*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (m1sq*(m1sq - m3sq)*m4sq*B0fin(0,0,m1sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) - (m1sq*m4sq*(m4sq - m6sq)*B0fin(0,0,m1sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (m1sq*(m4sq - m6sq)*(m1sq - m7sq)*B0fin(0,0,m1sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) - (m1sq*(m1sq - m3sq)*m7sq*B0fin(0,0,m1sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (2*m1sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m1sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (m1sq*(m1sq - m3sq)*m6sq*B0fin(0,0,m1sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (m1sq*(m1sq - m3sq)*m7sq*B0fin(0,0,m1sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (m3sq*m4sq*(m4sq - m6sq)*B0fin(0,0,m3sq,mudim))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) - (m3sq*(m4sq - m6sq)*(m3sq - m7sq)*B0fin(0,0,m3sq,mudim))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) - (2*m3sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m3sq,mudim))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) + (m1sq*(m4sq - m6sq)*(-m1sq + m7sq)*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (m3sq*(m4sq - m6sq)*(m3sq - m7sq)*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) - ((m1sq - m3sq)*(m4sq - m6sq)*m7sq*(-m4**4 + m7**4 + m1sq*(m3sq - m7sq) - m3sq*m7sq + 4*m4sq*m7sq)*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/((m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (m1**6*(m1sq - m3sq)*(m4sq - m6sq)*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m1sq*(m1sq - m3sq)*m4**4*(m4sq - m6sq)*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m1**4*(m1sq - m3sq)*m4sq*(m4sq - m6sq)*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (3*m1sq*(m1sq - m3sq)*(m4sq - m6sq)*m7**4*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + ((m1sq - m3sq)*(m4sq - m6sq)*m7**4*(m4sq - m7sq)*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (3*m1**4*(m1sq - m3sq)*(m4sq - m6sq)*m7sq*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (3*(m1sq - m3sq)*m4sq*(m4sq - m6sq)*(m4sq - m7sq)*m7sq*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*(m1sq - m3sq)*(m4sq - m6sq)*(m4sq - m7sq)**2*m7sq*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - ((m1sq - m3sq)*(m4sq - m6sq)*(m4**3 - m4*m7sq)**2*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (m1sq*(m1sq - m3sq)*m4sq*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) - (m1sq*m4sq*(m4sq - m6sq)*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + ((m1sq - m3sq)*m4sq*(m4sq - m7sq)*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (2*(m1sq - m3sq)*m4sq*m7sq*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) - (m4sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (m3sq*m4sq*(m4sq - m6sq)*B0fin(0,0,m4sq,mudim))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) + (m4sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m4sq,mudim))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) + (2*m1sq*(m1sq - m3sq)*(m4sq - m6sq)*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (m1**4*(m1sq - m3sq)*(m4sq - m6sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (2*m1sq*(m1sq - m3sq)*m4sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - ((m1sq - m3sq)*(m4sq - m6sq)*(m4sq - m7sq)**2*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m1sq*(m1sq - m3sq)*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (m1sq*m4sq*(m4sq - m6sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (m1sq*(m4sq - m6sq)*(-m1sq + m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + ((m1sq - m3sq)*m4sq*(-m4sq + m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) - (m3sq*m4sq*(m4sq - m6sq)*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) + (m3sq*(m4sq - m6sq)*(m3sq - m7sq)*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) + (m1sq*(m1sq - m3sq)*m6sq*B0fin(0,0,m6sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) - ((m1sq - m3sq)*m6sq*(m6sq - m7sq)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) - (2*(m1sq - m3sq)*m6sq*m7sq*B0fin(0,0,m6sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) - (m1sq*(m1sq - m3sq)*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + ((m1sq - m3sq)*m6sq*(m6sq - m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (2*m1sq*(m1sq - m3sq)*(m4sq - m6sq)*m7**4*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + ((m1sq - m3sq)*(m4sq - m6sq)*m7**4*(m4sq - m7sq)*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (4*m1**4*(m1sq - m3sq)*(m4sq - m6sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (4*m1sq*(m1sq - m3sq)*m4sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (3*(m1sq - m3sq)*m4sq*(m4sq - m6sq)*(m4sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - ((m1sq - m3sq)*(m4sq - m6sq)*(m4sq - m7sq)**2*m7sq*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (4*m1sq*(m1sq - m3sq)*(m4sq - m6sq)*m7sq*(m4sq + m7sq)*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (m1sq*(m1sq - m3sq)*m7sq*B0fin(0,0,m7sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (2*(m1sq - m3sq)*m4sq*m7sq*B0fin(0,0,m7sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (2*m1sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m7sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) - (m4sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m7sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) - (2*m3sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m7sq,mudim))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) + (m4sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m7sq,mudim))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) + ((m1sq - m3sq)*(m4sq - m6sq)*m7sq*(-m4**4 + m7**4 + m1sq*(m3sq - m7sq) - m3sq*m7sq + 4*m4sq*m7sq)*B0fin(0,0,m7sq,mudim))/((m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m1sq*(m1sq - m3sq)*m7sq*B0fin(0,0,m7sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) - (2*(m1sq - m3sq)*m6sq*m7sq*B0fin(0,0,m7sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) - ((m1sq - m3sq)*(m4sq - m6sq)*m7sq*(m1**4 - 4*m1sq*m7sq + (m4sq - m7sq)*(-m6sq + m7sq))*B0fin(0,0,m7sq,mudim))/((m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (m1**4*(m1sq - m3sq)*(m4sq - m6sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + ((m1sq - m3sq)*(m4sq - m6sq)*(m4sq - m7sq)**2*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m1sq*(m1sq - m3sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) - (2*m1sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (m1sq*(-m1sq + m3sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + ((m1sq - m3sq)*(m4sq - m6sq)*m7sq*(m1**4 - 4*m1sq*m7sq + (m4sq - m7sq)*(-m6sq + m7sq))*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (2*m3sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) - (2*m1sq*(m1sq - m3sq)*(m4sq - m6sq)*m7**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - ((m1sq - m3sq)*(m4sq - m6sq)*m7**4*(m4sq - m7sq)*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m1**4*(m1sq - m3sq)*(m4sq - m6sq)*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - ((m1sq - m3sq)*m4sq*(m4sq - m6sq)*(m4sq - m7sq)*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (2*(m1sq - m3sq)*m4sq*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (m4sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + (m4sq*(-m4sq + m6sq)*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) - ((m1sq - m3sq)*(m4sq - m6sq)*m7sq*(-m4**4 + m7**4 + m1sq*(m3sq - m7sq) - m3sq*m7sq + 4*m4sq*m7sq)*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (2*(m1sq - m3sq)*m6sq*m7sq*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + (m1**4*(m1sq - m3sq)*(m4sq - m6sq)*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + ((m1sq - m3sq)*m4**4*(m4sq - m6sq)*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (2*m1sq*(m1sq - m3sq)*m4sq*(m4sq - m6sq)*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + ((m1sq - m3sq)*(m4sq - m6sq)*m7**4*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (2*m1sq*(m1sq - m3sq)*(m4sq - m6sq)*m7sq*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (2*(m1sq - m3sq)*m4sq*(m4sq - m6sq)*m7sq*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + ((m1sq - m3sq)*(m1sq - m4sq - m7sq)*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) + ((m4sq - m6sq)*(-m1sq + m4sq - m7sq)*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq)) - ((m4sq - m6sq)*(-m3sq + m4sq - m7sq)*(m3sq + m4sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) - ((m1sq - m3sq)*(m1sq - m6sq - m7sq)*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + T134fin(m7,m4,m1,mudim) + (2*(-m1sq + m3sq)*(m4sq - m6sq)*m7**4*T134fin(m7,m4,m1,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m1sq*(m1sq - m3sq)*(m4sq - m6sq)*m7sq*T134fin(m7,m4,m1,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*(m1sq - m3sq)*m4sq*(m4sq - m6sq)*m7sq*T134fin(m7,m4,m1,mudim))/((m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + ((m4sq - m6sq)*(-m1sq + m4sq - m7sq)*T134fin(m7,m4,m1,mudim))/(4*m1sq*m7sq - (m1sq - m4sq + m7sq)**2) + ((m1sq - m3sq)*(m1sq - m4sq - m7sq)*T134fin(m7,m4,m1,mudim))/(4*m4sq*m7sq - (-m1sq + m4sq + m7sq)**2) - T134fin(m7,m4,m3,mudim) + ((m4sq - m6sq)*(-m3sq + m4sq - m7sq)*T134fin(m7,m4,m3,mudim))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) - T134fin(m7,m6,m1,mudim) + ((m1sq - m3sq)*(m1sq - m6sq - m7sq)*T134fin(m7,m6,m1,mudim))/(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq)) + T134fin(m7,m6,m3,mudim))/((m1sq - m3sq)**2*(m4sq - m6sq)**2)
		def eval_135():
			return ((7*m1sq*m4**4)/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (3*m1**4*m4sq)/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (7*m1sq*m7**4)/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (7*m1sq*m5**4)/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (3*m1**4*m5sq)/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (7*m1sq*m7**4)/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (7*m1sq*m6**4)/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (3*m1**4*m6sq)/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (7*m1sq*m7**4)/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (5*m4**4*(m4sq - m7sq))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (5*m7**4*(m4sq - m7sq))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m4sq*(m4sq - m7sq)**3)/(m1**2*(m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (5*m5**4*(m5sq - m7sq))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (m5sq*(m5sq - m7sq)**3)/(m1**2*(m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (5*m6**4*(m6sq - m7sq))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (m6sq*(m6sq - m7sq)**3)/(m1**2*(m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (3*m1**4*m7sq)/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m1sq*m4sq*m7sq)/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (3*m1**4*m7sq)/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (2*m1sq*m5sq*m7sq)/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (3*m1**4*m7sq)/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (2*m1sq*m6sq*m7sq)/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + ((m5sq - m7sq)**3*m7sq)/(m1**2*(m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + ((m6sq - m7sq)**3*m7sq)/(m1**2*(m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (m7sq*(-m4sq + m7sq)**3)/(m1**2*(m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (4*m4sq*m7sq*(-m1sq + m4sq + m7sq))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m1**4*(m1sq + m4sq + m7sq))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m4**4*(m1sq + m4sq + m7sq))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m7**4*(m1sq + m4sq + m7sq))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (4*m4sq*m7sq*(m1sq + m4sq + m7sq))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (4*m1sq*(m4sq + m7sq)*(m1sq + m4sq + m7sq))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (5*m7**4*(-m5sq + m7sq))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (4*m5sq*m7sq*(-m1sq + m5sq + m7sq))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (2*m1**4*(m1sq + m5sq + m7sq))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (2*m5**4*(m1sq + m5sq + m7sq))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (2*m7**4*(m1sq + m5sq + m7sq))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (4*m5sq*m7sq*(m1sq + m5sq + m7sq))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (4*m1sq*(m5sq + m7sq)*(m1sq + m5sq + m7sq))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (5*m7**4*(-m6sq + m7sq))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (4*m6sq*m7sq*(-m1sq + m6sq + m7sq))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (2*m1**4*(m1sq + m6sq + m7sq))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (2*m6**4*(m1sq + m6sq + m7sq))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (2*m7**4*(m1sq + m6sq + m7sq))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (4*m6sq*m7sq*(m1sq + m6sq + m7sq))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (4*m1sq*(m6sq + m7sq)*(m1sq + m6sq + m7sq))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (4*m1sq*m4sq*m7sq*B0del(0,0,m1sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (4*m1sq*m5sq*m7sq*B0del(0,0,m1sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (4*m1sq*m6sq*m7sq*B0del(0,0,m1sq,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*m1sq*m4sq*m7sq*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m4sq*(m4sq - m7sq)*m7sq*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m4sq*m7sq*(-m1sq + m4sq + m7sq)*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (2*m1sq*m5sq*m7sq*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (2*m5sq*(m5sq - m7sq)*m7sq*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (2*m5sq*m7sq*(-m1sq + m5sq + m7sq)*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (2*m1sq*m6sq*m7sq*B0del(0,0,m6sq,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (2*m6sq*(m6sq - m7sq)*m7sq*B0del(0,0,m6sq,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (2*m6sq*m7sq*(-m1sq + m6sq + m7sq)*B0del(0,0,m6sq,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*m1sq*m4sq*m7sq*B0del(0,0,m7sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (2*m1sq*m5sq*m7sq*B0del(0,0,m7sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (2*m1sq*m6sq*m7sq*B0del(0,0,m7sq,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (2*m4sq*(m4sq - m7sq)*m7sq*B0del(0,0,m7sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m5sq*(m5sq - m7sq)*m7sq*B0del(0,0,m7sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (2*m6sq*(m6sq - m7sq)*m7sq*B0del(0,0,m7sq,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*m4sq*m7sq*(-m1sq + m4sq + m7sq)*B0del(0,0,m7sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (2*m5sq*m7sq*(-m1sq + m5sq + m7sq)*B0del(0,0,m7sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (2*m6sq*m7sq*(-m1sq + m6sq + m7sq)*B0del(0,0,m7sq,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (7*m1sq*m4**4*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (3*m1**4*m4sq*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (7*m1sq*m7**4*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (7*m1sq*m5**4*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (3*m1**4*m5sq*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (7*m1sq*m7**4*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (7*m1sq*m6**4*B0fin(0,0,m1sq,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (3*m1**4*m6sq*B0fin(0,0,m1sq,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (7*m1sq*m7**4*B0fin(0,0,m1sq,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (5*m4**4*(m4sq - m7sq)*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (m4sq*(m4sq - m7sq)**3*B0fin(0,0,m1sq,mudim))/(m1**2*(m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (5*m5**4*(m5sq - m7sq)*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (5*m7**4*(m5sq - m7sq)*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (m5sq*(m5sq - m7sq)**3*B0fin(0,0,m1sq,mudim))/(m1**2*(m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (5*m6**4*(m6sq - m7sq)*B0fin(0,0,m1sq,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (5*m7**4*(m6sq - m7sq)*B0fin(0,0,m1sq,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (m6sq*(m6sq - m7sq)**3*B0fin(0,0,m1sq,mudim))/(m1**2*(m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (3*m1**4*m7sq*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (6*m1sq*m4sq*m7sq*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (3*m1**4*m7sq*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (6*m1sq*m5sq*m7sq*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (3*m1**4*m7sq*B0fin(0,0,m1sq,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (6*m1sq*m6sq*m7sq*B0fin(0,0,m1sq,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + ((m4sq - m7sq)**3*m7sq*B0fin(0,0,m1sq,mudim))/(m1**2*(m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (5*m7**4*(-m4sq + m7sq)*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m7sq*(-m5sq + m7sq)**3*B0fin(0,0,m1sq,mudim))/(m1**2*(m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (m7sq*(-m6sq + m7sq)**3*B0fin(0,0,m1sq,mudim))/(m1**2*(m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (7*m1sq*m4**4*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (3*m1**4*m4sq*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (5*m4**4*(m4sq - m7sq)*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (m4sq*(m4sq - m7sq)**3*B0fin(0,0,m4sq,mudim))/(m1**2*(m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (3*m1sq*m4sq*m7sq*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m4sq*(m4sq - m7sq)*m7sq*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m4sq*m7sq*(-m1sq + m4sq + m7sq)*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m1sq*m4sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m4sq*(m4sq - m7sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (7*m1sq*m5**4*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (3*m1**4*m5sq*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (5*m5**4*(m5sq - m7sq)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (m5sq*(m5sq - m7sq)**3*B0fin(0,0,m5sq,mudim))/(m1**2*(m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (3*m1sq*m5sq*m7sq*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (m5sq*(m5sq - m7sq)*m7sq*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (2*m5sq*m7sq*(-m1sq + m5sq + m7sq)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (2*m1sq*m5sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (2*m5sq*(m5sq - m7sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (7*m1sq*m6**4*B0fin(0,0,m6sq,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (3*m1**4*m6sq*B0fin(0,0,m6sq,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (5*m6**4*(m6sq - m7sq)*B0fin(0,0,m6sq,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (m6sq*(m6sq - m7sq)**3*B0fin(0,0,m6sq,mudim))/(m1**2*(m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (3*m1sq*m6sq*m7sq*B0fin(0,0,m6sq,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m6sq,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (2*m6sq*m7sq*(-m1sq + m6sq + m7sq)*B0fin(0,0,m6sq,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (2*m1sq*m6sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (2*m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (7*m1sq*m7**4*B0fin(0,0,m7sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (7*m1sq*m7**4*B0fin(0,0,m7sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (7*m1sq*m7**4*B0fin(0,0,m7sq,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (5*m7**4*(m5sq - m7sq)*B0fin(0,0,m7sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (5*m7**4*(m6sq - m7sq)*B0fin(0,0,m7sq,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (3*m1**4*m7sq*B0fin(0,0,m7sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (3*m1sq*m4sq*m7sq*B0fin(0,0,m7sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (3*m1**4*m7sq*B0fin(0,0,m7sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (3*m1sq*m5sq*m7sq*B0fin(0,0,m7sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (3*m1**4*m7sq*B0fin(0,0,m7sq,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (3*m1sq*m6sq*m7sq*B0fin(0,0,m7sq,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (m4sq*(m4sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + ((m4sq - m7sq)**3*m7sq*B0fin(0,0,m7sq,mudim))/(m1**2*(m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m5sq*(m5sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (5*m7**4*(-m4sq + m7sq)*B0fin(0,0,m7sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m4sq*m7sq*(-m1sq + m4sq + m7sq)*B0fin(0,0,m7sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m7sq*(-m5sq + m7sq)**3*B0fin(0,0,m7sq,mudim))/(m1**2*(m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (2*m5sq*m7sq*(-m1sq + m5sq + m7sq)*B0fin(0,0,m7sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (m7sq*(-m6sq + m7sq)**3*B0fin(0,0,m7sq,mudim))/(m1**2*(m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (2*m6sq*m7sq*(-m1sq + m6sq + m7sq)*B0fin(0,0,m7sq,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*m1sq*m4sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (2*m1sq*m5sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (2*m1sq*m6sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (2*m4sq*(m4sq - m7sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m5sq*(m5sq - m7sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (2*m6sq*(m6sq - m7sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (2*m4sq*m7sq*(-m1sq + m4sq + m7sq)*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (2*m5sq*m7sq*(-m1sq + m5sq + m7sq)*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (2*m6sq*m7sq*(-m1sq + m6sq + m7sq)*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (m1**4*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (m4**4*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) - (m7**4*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m4sq*m7sq*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (2*m1sq*(m4sq + m7sq)*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (m1**4*(m1sq + m5sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (m5**4*(m1sq + m5sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (m7**4*(m1sq + m5sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (2*m5sq*m7sq*(m1sq + m5sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) - (2*m1sq*(m5sq + m7sq)*(m1sq + m5sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (m1**4*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (m6**4*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) + (m7**4*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (2*m6sq*m7sq*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (2*m1sq*(m6sq + m7sq)*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2) - (4*m4sq*m7sq*T134fin(m7,m4,m1,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2) + (4*m5sq*m7sq*T134fin(m7,m5,m1,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (4*m6sq*m7sq*T134fin(m7,m6,m1,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1 + m6 - m7)**2*(m1 - m6 + m7)**2*(-m1 + m6 + m7)**2*(m1 + m6 + m7)**2))/2.
		def eval_136():
			return (-((m1sq*(m4sq - m5sq)*m5sq*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq*m7sq - (m1sq - m5sq + m7sq)**2))) + (m1sq*(m4sq - m5sq)*(m1sq - m7sq)*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq*m7sq - (m1sq - m5sq + m7sq)**2)) + (2*m1sq*(m4sq - m5sq)*m7sq*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq*m7sq - (m1sq - m5sq + m7sq)**2)) + (m2sq*(m4sq - m5sq)*m5sq*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(4*m2sq*m7sq - (m2sq - m5sq + m7sq)**2)) - (2*m2sq*(m4sq - m5sq)*m7sq*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(4*m2sq*m7sq - (m2sq - m5sq + m7sq)**2)) + (m2sq*(m4sq - m5sq)*(m2sq - m7sq)*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + (2*m3sq*(m4sq - m5sq)*m7sq*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)*(m2sq - m3sq)*(4*m3sq*m7sq - (m3sq - m5sq + m7sq)**2)) + (m3sq*m5sq*(-m4sq + m5sq)*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq))) + (m3sq*(m4sq - m5sq)*(m3sq - m7sq)*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq))) - (m1sq*(m4sq - m5sq)*m5sq*B0del(0,0,m5sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq*m7sq - (m1sq - m5sq + m7sq)**2)) + (m2sq*(m4sq - m5sq)*m5sq*B0del(0,0,m5sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(4*m2sq*m7sq - (m2sq - m5sq + m7sq)**2)) + (m3sq*m5sq*(-m4sq + m5sq)*B0del(0,0,m5sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq))) - (m5sq*(-m4sq + m5sq)*m7sq*(3*m5**4 - 2*m3sq*m5sq + 3*m7**4 - 2*m3sq*m7sq + 10*m5sq*m7sq + m2sq*(m3sq - 2*(m5sq + m7sq)) + m1sq*(m2sq + m3sq - 2*(m5sq + m7sq)))*B0del(0,0,m5sq,mudim))/((m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))*(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq))) + (2*m1sq*(m4sq - m5sq)*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq*m7sq - (m1sq - m5sq + m7sq)**2)) - (2*m2sq*(m4sq - m5sq)*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(4*m2sq*m7sq - (m2sq - m5sq + m7sq)**2)) + (2*m3sq*(m4sq - m5sq)*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)*(m2sq - m3sq)*(4*m3sq*m7sq - (m3sq - m5sq + m7sq)**2)) - ((m4sq - m5sq)*m7sq*(m3sq*m5**4 - 2*m5**6 - m3sq*m7**4 + 12*m5sq*m7**4 + m7**6 + 5*m5**4*m7sq - 4*m3sq*m5sq*m7sq + m2sq*(m5**4 - m7**4 + m3sq*m7sq - 4*m5sq*m7sq) + m1sq*(m5**4 - m7**4 + m3sq*m7sq - 4*m5sq*m7sq + m2sq*(-m3sq + m7sq)))*B0del(0,0,m7sq,mudim))/((m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))*(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq))) - (m5sq*(-m4sq + m5sq)*m7sq*(3*m5**4 - 2*m3sq*m5sq + 3*m7**4 - 2*m3sq*m7sq + 10*m5sq*m7sq + m2sq*(m3sq - 2*(m5sq + m7sq)) + m1sq*(m2sq + m3sq - 2*(m5sq + m7sq)))*B0del(0,0,m7sq,mudim))/((m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))*(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq))) + (m1sq*(m4sq - m5sq)*m5sq*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq*m7sq - (m1sq - m5sq + m7sq)**2)) - (m1sq*(m4sq - m5sq)*(m1sq - m7sq)*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq*m7sq - (m1sq - m5sq + m7sq)**2)) - (2*m1sq*(m4sq - m5sq)*m7sq*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq*m7sq - (m1sq - m5sq + m7sq)**2)) - (m2sq*(m4sq - m5sq)*m5sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(4*m2sq*m7sq - (m2sq - m5sq + m7sq)**2)) + (2*m2sq*(m4sq - m5sq)*m7sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(4*m2sq*m7sq - (m2sq - m5sq + m7sq)**2)) - (m2sq*(m4sq - m5sq)*(m2sq - m7sq)*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) - (2*m3sq*(m4sq - m5sq)*m7sq*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(m2sq - m3sq)*(4*m3sq*m7sq - (m3sq - m5sq + m7sq)**2)) - (m3sq*m5sq*(-m4sq + m5sq)*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq))) - (m3sq*(m4sq - m5sq)*(m3sq - m7sq)*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq))) + (m1sq*(m4sq - m5sq)*(m1sq - m7sq)*(B0del(0,0,m5sq,mudim) - B0fin(0,0,m5sq,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq*m7sq - (m1sq - m5sq + m7sq)**2)) + (m2sq*(m4sq - m5sq)*(m2sq - m7sq)*(B0del(0,0,m5sq,mudim) - B0fin(0,0,m5sq,mudim)))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + (m3sq*(m4sq - m5sq)*(m3sq - m7sq)*(B0del(0,0,m5sq,mudim) - B0fin(0,0,m5sq,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq))) - ((m4sq - m5sq)*m7sq*(m3sq*m5**4 - 2*m5**6 - m3sq*m7**4 + 12*m5sq*m7**4 + m7**6 + 5*m5**4*m7sq - 4*m3sq*m5sq*m7sq + m2sq*(m5**4 - m7**4 + m3sq*m7sq - 4*m5sq*m7sq) + m1sq*(m5**4 - m7**4 + m3sq*m7sq - 4*m5sq*m7sq + m2sq*(-m3sq + m7sq)))*(B0del(0,0,m5sq,mudim) - B0fin(0,0,m5sq,mudim)))/((m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))*(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq))) + (m1sq*(m4sq - m5sq)*m5sq*B0fin(0,0,m5sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq*m7sq - (m1sq - m5sq + m7sq)**2)) - (m2sq*(m4sq - m5sq)*m5sq*B0fin(0,0,m5sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(4*m2sq*m7sq - (m2sq - m5sq + m7sq)**2)) - (m3sq*m5sq*(-m4sq + m5sq)*B0fin(0,0,m5sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq))) + (m5sq*(-m4sq + m5sq)*m7sq*(3*m5**4 - 2*m3sq*m5sq + 3*m7**4 - 2*m3sq*m7sq + 10*m5sq*m7sq + m2sq*(m3sq - 2*(m5sq + m7sq)) + m1sq*(m2sq + m3sq - 2*(m5sq + m7sq)))*B0fin(0,0,m5sq,mudim))/((m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))*(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq))) - (m1sq*(m4sq - m5sq)*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq*m7sq - (m1sq - m5sq + m7sq)**2)) + (m1sq*(m4sq - m5sq)*(m1sq - m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq*m7sq - (m1sq - m5sq + m7sq)**2)) + (m2sq*(m4sq - m5sq)*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(4*m2sq*m7sq - (m2sq - m5sq + m7sq)**2)) + (m2sq*(m4sq - m5sq)*(m2sq - m7sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + (m3sq*m5sq*(-m4sq + m5sq)*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq))) + (m3sq*(m4sq - m5sq)*(m3sq - m7sq)*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq))) - (2*m1sq*(m4sq - m5sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq*m7sq - (m1sq - m5sq + m7sq)**2)) + (2*m2sq*(m4sq - m5sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(4*m2sq*m7sq - (m2sq - m5sq + m7sq)**2)) - (2*m3sq*(m4sq - m5sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(m2sq - m3sq)*(4*m3sq*m7sq - (m3sq - m5sq + m7sq)**2)) + ((m4sq - m5sq)*m7sq*(m3sq*m5**4 - 2*m5**6 - m3sq*m7**4 + 12*m5sq*m7**4 + m7**6 + 5*m5**4*m7sq - 4*m3sq*m5sq*m7sq + m2sq*(m5**4 - m7**4 + m3sq*m7sq - 4*m5sq*m7sq) + m1sq*(m5**4 - m7**4 + m3sq*m7sq - 4*m5sq*m7sq + m2sq*(-m3sq + m7sq)))*B0fin(0,0,m7sq,mudim))/((m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))*(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq))) + (m5sq*(-m4sq + m5sq)*m7sq*(3*m5**4 - 2*m3sq*m5sq + 3*m7**4 - 2*m3sq*m7sq + 10*m5sq*m7sq + m2sq*(m3sq - 2*(m5sq + m7sq)) + m1sq*(m2sq + m3sq - 2*(m5sq + m7sq)))*B0fin(0,0,m7sq,mudim))/((m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))*(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq))) + (2*m1sq*(m4sq - m5sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq*m7sq - (m1sq - m5sq + m7sq)**2)) - (2*m2sq*(m4sq - m5sq)*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(4*m2sq*m7sq - (m2sq - m5sq + m7sq)**2)) + (2*m3sq*(m4sq - m5sq)*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(m2sq - m3sq)*(4*m3sq*m7sq - (m3sq - m5sq + m7sq)**2)) - ((m4sq - m5sq)*m7sq*(m3sq*m5**4 - 2*m5**6 - m3sq*m7**4 + 12*m5sq*m7**4 + m7**6 + 5*m5**4*m7sq - 4*m3sq*m5sq*m7sq + m2sq*(m5**4 - m7**4 + m3sq*m7sq - 4*m5sq*m7sq) + m1sq*(m5**4 - m7**4 + m3sq*m7sq - 4*m5sq*m7sq + m2sq*(-m3sq + m7sq)))*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))*(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq))) - (m5sq*(-m4sq + m5sq)*m7sq*(3*m5**4 - 2*m3sq*m5sq + 3*m7**4 - 2*m3sq*m7sq + 10*m5sq*m7sq + m2sq*(m3sq - 2*(m5sq + m7sq)) + m1sq*(m2sq + m3sq - 2*(m5sq + m7sq)))*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))*(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq))) - ((m4sq - m5sq)*(m1sq - m5sq + m7sq)*(m1sq + m5sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) + ((m4sq - m5sq)*(m2sq - m5sq + m7sq)*(m2sq + m5sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + (m3sq*m4sq*(m3sq + m5sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq))) - (m3sq*m5sq*(m3sq + m5sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq))) - (m4sq*(m5sq - m7sq)*(m3sq + m5sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq))) + (m5sq*(m5sq - m7sq)*(m3sq + m5sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq))) + T134fin(m7,m4,m1,mudim)/((m1sq - m2sq)*(m1sq - m3sq)) - T134fin(m7,m4,m2,mudim)/((m1sq - m2sq)*(m2sq - m3sq)) - T134fin(m7,m4,m3,mudim)/((m1sq - m3sq)*(-m2sq + m3sq)) - T134fin(m7,m5,m1,mudim)/((m1sq - m2sq)*(m1sq - m3sq)) + ((m4sq - m5sq)*(m1sq - m5sq + m7sq)*T134fin(m7,m5,m1,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) + T134fin(m7,m5,m2,mudim)/((m1sq - m2sq)*(m2sq - m3sq)) - ((m4sq - m5sq)*(m2sq - m5sq + m7sq)*T134fin(m7,m5,m2,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + (m3**4*T134fin(m7,m5,m3,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq))) - (m3sq*m4sq*T134fin(m7,m5,m3,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq))) - (m3sq*m5sq*T134fin(m7,m5,m3,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq))) + (m4sq*(m5sq - m7sq)*T134fin(m7,m5,m3,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq))) - (2*m3sq*m7sq*T134fin(m7,m5,m3,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq))) + (m7sq*(-m5sq + m7sq)*T134fin(m7,m5,m3,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m5sq - m7sq)**2 - 2*m3sq*(m5sq + m7sq))))/(m4sq - m5sq)**2
		def eval_137():
			return ((-2*m1sq*(m4sq - m6sq)*m7sq*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq*m7sq - (m1sq - m4sq + m7sq)**2)) - (m1sq*m4sq*(m4sq - m6sq)*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + (m1sq*(m4sq - m6sq)*(m1sq - m7sq)*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) - (m2sq*m4sq*(m4sq - m6sq)*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(4*m2sq*m7sq - (m2sq - m4sq + m7sq)**2)) + (m2sq*(m4sq - m6sq)*(m2sq - m7sq)*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(4*m2sq*m7sq - (m2sq - m4sq + m7sq)**2)) + (2*m2sq*(m4sq - m6sq)*m7sq*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(4*m2sq*m7sq - (m2sq - m4sq + m7sq)**2)) - (2*m3sq*(m4sq - m6sq)*m7sq*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)*(m2sq - m3sq)*(4*m3sq*m7sq - (m3sq - m4sq + m7sq)**2)) + (m3sq*m4sq*(m4sq - m6sq)*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (m3sq*(m4sq - m6sq)*(m3sq - m7sq)*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (m2sq*m4sq*(m4sq - m6sq)*B0del(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(4*m2sq*m7sq - (m2sq - m4sq + m7sq)**2)) - (m1sq*m4sq*(m4sq - m6sq)*B0del(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + (m3sq*m4sq*(m4sq - m6sq)*B0del(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (m4sq*(m4sq - m6sq)*m7sq*(3*m4**4 - 2*m3sq*m4sq + 3*m7**4 - 2*m3sq*m7sq + 10*m4sq*m7sq + m2sq*(m3sq - 2*(m4sq + m7sq)) + m1sq*(m2sq + m3sq - 2*(m4sq + m7sq)))*B0del(0,0,m4sq,mudim))/((m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (2*m1sq*(m4sq - m6sq)*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq*m7sq - (m1sq - m4sq + m7sq)**2)) + (2*m2sq*(m4sq - m6sq)*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(4*m2sq*m7sq - (m2sq - m4sq + m7sq)**2)) - (2*m3sq*(m4sq - m6sq)*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)*(m2sq - m3sq)*(4*m3sq*m7sq - (m3sq - m4sq + m7sq)**2)) + ((m4sq - m6sq)*m7sq*(m3sq*m4**4 - 2*m4**6 - m3sq*m7**4 + 12*m4sq*m7**4 + m7**6 + 5*m4**4*m7sq - 4*m3sq*m4sq*m7sq + m2sq*(m4**4 - m7**4 + m3sq*m7sq - 4*m4sq*m7sq) + m1sq*(m4**4 - m7**4 + m3sq*m7sq - 4*m4sq*m7sq + m2sq*(-m3sq + m7sq)))*B0del(0,0,m7sq,mudim))/((m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (m4sq*(m4sq - m6sq)*m7sq*(3*m4**4 - 2*m3sq*m4sq + 3*m7**4 - 2*m3sq*m7sq + 10*m4sq*m7sq + m2sq*(m3sq - 2*(m4sq + m7sq)) + m1sq*(m2sq + m3sq - 2*(m4sq + m7sq)))*B0del(0,0,m7sq,mudim))/((m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (2*m1sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq*m7sq - (m1sq - m4sq + m7sq)**2)) + (m1sq*m4sq*(m4sq - m6sq)*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) - (m1sq*(m4sq - m6sq)*(m1sq - m7sq)*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + (m2sq*m4sq*(m4sq - m6sq)*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(4*m2sq*m7sq - (m2sq - m4sq + m7sq)**2)) - (m2sq*(m4sq - m6sq)*(m2sq - m7sq)*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(4*m2sq*m7sq - (m2sq - m4sq + m7sq)**2)) - (2*m2sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(4*m2sq*m7sq - (m2sq - m4sq + m7sq)**2)) + (2*m3sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(m2sq - m3sq)*(4*m3sq*m7sq - (m3sq - m4sq + m7sq)**2)) - (m3sq*m4sq*(m4sq - m6sq)*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m3sq*(m4sq - m6sq)*(m3sq - m7sq)*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m2sq*(m4sq - m6sq)*(m2sq - m7sq)*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/((m1sq - m2sq)*(m2sq - m3sq)*(4*m2sq*m7sq - (m2sq - m4sq + m7sq)**2)) + (m1sq*(m4sq - m6sq)*(m1sq - m7sq)*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) - (m3sq*(m4sq - m6sq)*(m3sq - m7sq)*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + ((m4sq - m6sq)*m7sq*(m3sq*m4**4 - 2*m4**6 - m3sq*m7**4 + 12*m4sq*m7**4 + m7**6 + 5*m4**4*m7sq - 4*m3sq*m4sq*m7sq + m2sq*(m4**4 - m7**4 + m3sq*m7sq - 4*m4sq*m7sq) + m1sq*(m4**4 - m7**4 + m3sq*m7sq - 4*m4sq*m7sq + m2sq*(-m3sq + m7sq)))*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/((m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m2sq*m4sq*(m4sq - m6sq)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(4*m2sq*m7sq - (m2sq - m4sq + m7sq)**2)) + (m1sq*m4sq*(m4sq - m6sq)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) - (m3sq*m4sq*(m4sq - m6sq)*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m4sq*(m4sq - m6sq)*m7sq*(3*m4**4 - 2*m3sq*m4sq + 3*m7**4 - 2*m3sq*m7sq + 10*m4sq*m7sq + m2sq*(m3sq - 2*(m4sq + m7sq)) + m1sq*(m2sq + m3sq - 2*(m4sq + m7sq)))*B0fin(0,0,m4sq,mudim))/((m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (m1sq*m4sq*(m4sq - m6sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + (m1sq*(m4sq - m6sq)*(m1sq - m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) - (m2sq*m4sq*(m4sq - m6sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(4*m2sq*m7sq - (m2sq - m4sq + m7sq)**2)) + (m2sq*(m4sq - m6sq)*(m2sq - m7sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(4*m2sq*m7sq - (m2sq - m4sq + m7sq)**2)) + (m3sq*m4sq*(m4sq - m6sq)*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (m3sq*(m4sq - m6sq)*(m3sq - m7sq)*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (2*m1sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq*m7sq - (m1sq - m4sq + m7sq)**2)) - (2*m2sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(4*m2sq*m7sq - (m2sq - m4sq + m7sq)**2)) + (2*m3sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(m2sq - m3sq)*(4*m3sq*m7sq - (m3sq - m4sq + m7sq)**2)) - ((m4sq - m6sq)*m7sq*(m3sq*m4**4 - 2*m4**6 - m3sq*m7**4 + 12*m4sq*m7**4 + m7**6 + 5*m4**4*m7sq - 4*m3sq*m4sq*m7sq + m2sq*(m4**4 - m7**4 + m3sq*m7sq - 4*m4sq*m7sq) + m1sq*(m4**4 - m7**4 + m3sq*m7sq - 4*m4sq*m7sq + m2sq*(-m3sq + m7sq)))*B0fin(0,0,m7sq,mudim))/((m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m4sq*(m4sq - m6sq)*m7sq*(3*m4**4 - 2*m3sq*m4sq + 3*m7**4 - 2*m3sq*m7sq + 10*m4sq*m7sq + m2sq*(m3sq - 2*(m4sq + m7sq)) + m1sq*(m2sq + m3sq - 2*(m4sq + m7sq)))*B0fin(0,0,m7sq,mudim))/((m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (2*m1sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq*m7sq - (m1sq - m4sq + m7sq)**2)) + (2*m2sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(4*m2sq*m7sq - (m2sq - m4sq + m7sq)**2)) - (2*m3sq*(m4sq - m6sq)*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(m2sq - m3sq)*(4*m3sq*m7sq - (m3sq - m4sq + m7sq)**2)) + ((m4sq - m6sq)*m7sq*(m3sq*m4**4 - 2*m4**6 - m3sq*m7**4 + 12*m4sq*m7**4 + m7**6 + 5*m4**4*m7sq - 4*m3sq*m4sq*m7sq + m2sq*(m4**4 - m7**4 + m3sq*m7sq - 4*m4sq*m7sq) + m1sq*(m4**4 - m7**4 + m3sq*m7sq - 4*m4sq*m7sq + m2sq*(-m3sq + m7sq)))*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (m4sq*(m4sq - m6sq)*m7sq*(3*m4**4 - 2*m3sq*m4sq + 3*m7**4 - 2*m3sq*m7sq + 10*m4sq*m7sq + m2sq*(m3sq - 2*(m4sq + m7sq)) + m1sq*(m2sq + m3sq - 2*(m4sq + m7sq)))*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + ((m4sq - m6sq)*(m1sq - m4sq + m7sq)*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) - ((m4sq - m6sq)*(m2sq - m4sq + m7sq)*(m2sq + m4sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) - (m3sq*m4sq*(m3sq + m4sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m3sq*m6sq*(m3sq + m4sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m4sq*(m4sq - m7sq)*(m3sq + m4sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (m6sq*(m4sq - m7sq)*(m3sq + m4sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - T134fin(m7,m4,m1,mudim)/((m1sq - m2sq)*(m1sq - m3sq)) - ((m4sq - m6sq)*(m1sq - m4sq + m7sq)*T134fin(m7,m4,m1,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + T134fin(m7,m4,m2,mudim)/((m1sq - m2sq)*(m2sq - m3sq)) + ((m4sq - m6sq)*(m2sq - m4sq + m7sq)*T134fin(m7,m4,m2,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) + (m3**4*T134fin(m7,m4,m3,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (m3sq*m4sq*T134fin(m7,m4,m3,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (m3sq*m6sq*T134fin(m7,m4,m3,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m6sq*(m4sq - m7sq)*T134fin(m7,m4,m3,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (2*m3sq*m7sq*T134fin(m7,m4,m3,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m7sq*(-m4sq + m7sq)*T134fin(m7,m4,m3,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + T134fin(m7,m6,m1,mudim)/((m1sq - m2sq)*(m1sq - m3sq)) - T134fin(m7,m6,m2,mudim)/((m1sq - m2sq)*(m2sq - m3sq)) - T134fin(m7,m6,m3,mudim)/((m1sq - m3sq)*(-m2sq + m3sq)))/(m4sq - m6sq)**2
		def eval_138():
			return (-(((m1sq - m2sq)*m2sq*m4sq*B0del(0,0,m2sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(4*m4sq*m7sq - (-m2sq + m4sq + m7sq)**2))) + (m2sq*(-m1sq + m2sq)*m5sq*B0del(0,0,m2sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) - ((m1sq - m2sq)*m2sq*m6sq*B0del(0,0,m2sq,mudim))/((m4sq - m6sq)*(m5sq - m6sq)*(4*m6sq*m7sq - (-m2sq + m6sq + m7sq)**2)) - ((m1sq - m2sq)*m2sq*m7sq*(3*m2**4 + m5sq*m6sq + 3*m7**4 - 2*m2sq*(m4sq + m5sq + m6sq - 5*m7sq) + m4sq*(m5sq + m6sq - 2*m7sq) - 2*m5sq*m7sq - 2*m6sq*m7sq)*B0del(0,0,m2sq,mudim))/((4*m4sq*m7sq - (-m2sq + m4sq + m7sq)**2)*(4*m5sq*m7sq - (-m2sq + m5sq + m7sq)**2)*(4*m6sq*m7sq - (-m2sq + m6sq + m7sq)**2)) - ((m1sq - m2sq)*m4sq*(m4sq - m7sq)*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) - ((m1sq - m2sq)*m2sq*m4sq*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(4*m4sq*m7sq - (-m2sq + m4sq + m7sq)**2)) + (2*(m1sq - m2sq)*m4sq*m7sq*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(4*m4sq*m7sq - (-m2sq + m4sq + m7sq)**2)) + (m2sq*(-m1sq + m2sq)*m5sq*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + ((m1sq - m2sq)*m5sq*(m5sq - m7sq)*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) - (2*(m1sq - m2sq)*m5sq*m7sq*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(4*m5sq*m7sq - (-m2sq + m5sq + m7sq)**2)) + ((m1sq - m2sq)*m6sq*(m6sq - m7sq)*B0del(0,0,m6sq,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) - ((m1sq - m2sq)*m2sq*m6sq*B0del(0,0,m6sq,mudim))/((m4sq - m6sq)*(m5sq - m6sq)*(4*m6sq*m7sq - (-m2sq + m6sq + m7sq)**2)) + (2*(m1sq - m2sq)*m6sq*m7sq*B0del(0,0,m6sq,mudim))/((m4sq - m6sq)*(m5sq - m6sq)*(4*m6sq*m7sq - (-m2sq + m6sq + m7sq)**2)) + (2*(m1sq - m2sq)*m4sq*m7sq*B0del(0,0,m7sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(4*m4sq*m7sq - (-m2sq + m4sq + m7sq)**2)) - (2*(m1sq - m2sq)*m5sq*m7sq*B0del(0,0,m7sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(4*m5sq*m7sq - (-m2sq + m5sq + m7sq)**2)) + (2*(m1sq - m2sq)*m6sq*m7sq*B0del(0,0,m7sq,mudim))/((m4sq - m6sq)*(m5sq - m6sq)*(4*m6sq*m7sq - (-m2sq + m6sq + m7sq)**2)) - ((m1sq - m2sq)*m2sq*m7sq*(3*m2**4 + m5sq*m6sq + 3*m7**4 - 2*m2sq*(m4sq + m5sq + m6sq - 5*m7sq) + m4sq*(m5sq + m6sq - 2*m7sq) - 2*m5sq*m7sq - 2*m6sq*m7sq)*B0del(0,0,m7sq,mudim))/((4*m4sq*m7sq - (-m2sq + m4sq + m7sq)**2)*(4*m5sq*m7sq - (-m2sq + m5sq + m7sq)**2)*(4*m6sq*m7sq - (-m2sq + m6sq + m7sq)**2)) + ((m1sq - m2sq)*m7sq*(2*m2**6 + 4*m2sq*(m4sq + m5sq + m6sq - 3*m7sq)*m7sq + (m4sq - m7sq)*(-m5sq + m7sq)*(-m6sq + m7sq) - m2**4*(m4sq + m5sq + m6sq + 5*m7sq))*B0del(0,0,m7sq,mudim))/((m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) - ((m1sq - m2sq)*m4sq*(m4sq - m7sq)*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)))/((m4sq - m5sq)*(m4sq - m6sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) + ((m1sq - m2sq)*m5sq*(m5sq - m7sq)*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)))/((m4sq - m5sq)*(m5sq - m6sq)*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + ((m1sq - m2sq)*m6sq*(m6sq - m7sq)*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)))/((m4sq - m6sq)*(-m5sq + m6sq)*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + ((m1sq - m2sq)*m7sq*(2*m2**6 + 4*m2sq*(m4sq + m5sq + m6sq - 3*m7sq)*m7sq + (m4sq - m7sq)*(-m5sq + m7sq)*(-m6sq + m7sq) - m2**4*(m4sq + m5sq + m6sq + 5*m7sq))*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)))/((m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + ((m1sq - m2sq)*m2sq*m4sq*B0fin(0,0,m2sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(4*m4sq*m7sq - (-m2sq + m4sq + m7sq)**2)) - (m2sq*(-m1sq + m2sq)*m5sq*B0fin(0,0,m2sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + ((m1sq - m2sq)*m2sq*m6sq*B0fin(0,0,m2sq,mudim))/((m4sq - m6sq)*(m5sq - m6sq)*(4*m6sq*m7sq - (-m2sq + m6sq + m7sq)**2)) + ((m1sq - m2sq)*m2sq*m7sq*(3*m2**4 + m5sq*m6sq + 3*m7**4 - 2*m2sq*(m4sq + m5sq + m6sq - 5*m7sq) + m4sq*(m5sq + m6sq - 2*m7sq) - 2*m5sq*m7sq - 2*m6sq*m7sq)*B0fin(0,0,m2sq,mudim))/((4*m4sq*m7sq - (-m2sq + m4sq + m7sq)**2)*(4*m5sq*m7sq - (-m2sq + m5sq + m7sq)**2)*(4*m6sq*m7sq - (-m2sq + m6sq + m7sq)**2)) + ((m1sq - m2sq)*m4sq*(m4sq - m7sq)*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) + ((m1sq - m2sq)*m2sq*m4sq*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(4*m4sq*m7sq - (-m2sq + m4sq + m7sq)**2)) - (2*(m1sq - m2sq)*m4sq*m7sq*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(4*m4sq*m7sq - (-m2sq + m4sq + m7sq)**2)) - ((m1sq - m2sq)*m4sq*(m4sq - m7sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) - ((m1sq - m2sq)*m2sq*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(4*m4sq*m7sq - (-m2sq + m4sq + m7sq)**2)) - (m2sq*(-m1sq + m2sq)*m5sq*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) - ((m1sq - m2sq)*m5sq*(m5sq - m7sq)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + (2*(m1sq - m2sq)*m5sq*m7sq*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(4*m5sq*m7sq - (-m2sq + m5sq + m7sq)**2)) + (m2sq*(-m1sq + m2sq)*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + ((m1sq - m2sq)*m5sq*(m5sq - m7sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) - ((m1sq - m2sq)*m6sq*(m6sq - m7sq)*B0fin(0,0,m6sq,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + ((m1sq - m2sq)*m2sq*m6sq*B0fin(0,0,m6sq,mudim))/((m4sq - m6sq)*(m5sq - m6sq)*(4*m6sq*m7sq - (-m2sq + m6sq + m7sq)**2)) - (2*(m1sq - m2sq)*m6sq*m7sq*B0fin(0,0,m6sq,mudim))/((m4sq - m6sq)*(m5sq - m6sq)*(4*m6sq*m7sq - (-m2sq + m6sq + m7sq)**2)) + ((m1sq - m2sq)*m6sq*(m6sq - m7sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) - ((m1sq - m2sq)*m2sq*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m6sq)*(m5sq - m6sq)*(4*m6sq*m7sq - (-m2sq + m6sq + m7sq)**2)) - (2*(m1sq - m2sq)*m4sq*m7sq*B0fin(0,0,m7sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(4*m4sq*m7sq - (-m2sq + m4sq + m7sq)**2)) + (2*(m1sq - m2sq)*m5sq*m7sq*B0fin(0,0,m7sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(4*m5sq*m7sq - (-m2sq + m5sq + m7sq)**2)) - (2*(m1sq - m2sq)*m6sq*m7sq*B0fin(0,0,m7sq,mudim))/((m4sq - m6sq)*(m5sq - m6sq)*(4*m6sq*m7sq - (-m2sq + m6sq + m7sq)**2)) + ((m1sq - m2sq)*m2sq*m7sq*(3*m2**4 + m5sq*m6sq + 3*m7**4 - 2*m2sq*(m4sq + m5sq + m6sq - 5*m7sq) + m4sq*(m5sq + m6sq - 2*m7sq) - 2*m5sq*m7sq - 2*m6sq*m7sq)*B0fin(0,0,m7sq,mudim))/((4*m4sq*m7sq - (-m2sq + m4sq + m7sq)**2)*(4*m5sq*m7sq - (-m2sq + m5sq + m7sq)**2)*(4*m6sq*m7sq - (-m2sq + m6sq + m7sq)**2)) - ((m1sq - m2sq)*m7sq*(2*m2**6 + 4*m2sq*(m4sq + m5sq + m6sq - 3*m7sq)*m7sq + (m4sq - m7sq)*(-m5sq + m7sq)*(-m6sq + m7sq) - m2**4*(m4sq + m5sq + m6sq + 5*m7sq))*B0fin(0,0,m7sq,mudim))/((m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) - ((m1sq - m2sq)*m2sq*m7sq*(3*m2**4 + m5sq*m6sq + 3*m7**4 - 2*m2sq*(m4sq + m5sq + m6sq - 5*m7sq) + m4sq*(m5sq + m6sq - 2*m7sq) - 2*m5sq*m7sq - 2*m6sq*m7sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((4*m4sq*m7sq - (-m2sq + m4sq + m7sq)**2)*(4*m5sq*m7sq - (-m2sq + m5sq + m7sq)**2)*(4*m6sq*m7sq - (-m2sq + m6sq + m7sq)**2)) + ((m1sq - m2sq)*m7sq*(2*m2**6 + 4*m2sq*(m4sq + m5sq + m6sq - 3*m7sq)*m7sq + (m4sq - m7sq)*(-m5sq + m7sq)*(-m6sq + m7sq) - m2**4*(m4sq + m5sq + m6sq + 5*m7sq))*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + (2*(m1sq - m2sq)*m4sq*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(4*m4sq*m7sq - (-m2sq + m4sq + m7sq)**2)) - (2*(m1sq - m2sq)*m5sq*m7sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(4*m5sq*m7sq - (-m2sq + m5sq + m7sq)**2)) + (2*(m1sq - m2sq)*m6sq*m7sq*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/((m4sq - m6sq)*(m5sq - m6sq)*(4*m6sq*m7sq - (-m2sq + m6sq + m7sq)**2)) + ((m1sq - m2sq)*(m2sq - m4sq - m7sq)*(m2sq + m4sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m5sq)*(m4sq - m6sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) + (m2**4*(m2sq + m5sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m5sq)*(m5sq - m6sq)*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) - (m2sq*(m5sq + m7sq)*(m2sq + m5sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m5sq)*(m5sq - m6sq)*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + (m1sq*(-m2sq + m5sq + m7sq)*(m2sq + m5sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m5sq)*(m5sq - m6sq)*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + (m2**4*(m2sq + m6sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m6sq)*(-m5sq + m6sq)*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) - (m2sq*(m6sq + m7sq)*(m2sq + m6sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m6sq)*(-m5sq + m6sq)*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + (m1sq*(-m2sq + m6sq + m7sq)*(m2sq + m6sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m6sq)*(-m5sq + m6sq)*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) + T134fin(m7,m4,m1,mudim)/((m4sq - m5sq)*(m4sq - m6sq)) - T134fin(m7,m4,m2,mudim)/((m4sq - m5sq)*(m4sq - m6sq)) + ((m1sq - m2sq)*(m2sq - m4sq - m7sq)*T134fin(m7,m4,m2,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(4*m4sq*m7sq - (-m2sq + m4sq + m7sq)**2)) - T134fin(m7,m5,m1,mudim)/((m4sq - m5sq)*(m5sq - m6sq)) + ((m5sq - m7sq)**2*T134fin(m7,m5,m2,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) - (m2sq*(m5sq + m7sq)*T134fin(m7,m5,m2,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) - (m1sq*(-m2sq + m5sq + m7sq)*T134fin(m7,m5,m2,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) - T134fin(m7,m6,m1,mudim)/((m4sq - m6sq)*(-m5sq + m6sq)) + ((m6sq - m7sq)**2*T134fin(m7,m6,m2,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) - (m2sq*(m6sq + m7sq)*T134fin(m7,m6,m2,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))) - (m1sq*(-m2sq + m6sq + m7sq)*T134fin(m7,m6,m2,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m2**4 + (m6sq - m7sq)**2 - 2*m2sq*(m6sq + m7sq))))/(m1sq - m2sq)**2
		def eval_139():
			return ((m1sq*(m1sq - m3sq)*m4sq*B0del(0,0,m1sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(4*m4sq*m7sq - (-m1sq + m4sq + m7sq)**2)) + (m1sq*(m1sq - m3sq)*m5sq*B0del(0,0,m1sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) + (m1sq*(m1sq - m3sq)*m6sq*B0del(0,0,m1sq,mudim))/((m4sq - m6sq)*(m5sq - m6sq)*(4*m6sq*m7sq - (-m1sq + m6sq + m7sq)**2)) + (m1sq*(m1sq - m3sq)*m7sq*(3*m1**4 + m5sq*m6sq + 3*m7**4 - 2*m1sq*(m4sq + m5sq + m6sq - 5*m7sq) + m4sq*(m5sq + m6sq - 2*m7sq) - 2*m5sq*m7sq - 2*m6sq*m7sq)*B0del(0,0,m1sq,mudim))/((4*m4sq*m7sq - (-m1sq + m4sq + m7sq)**2)*(4*m5sq*m7sq - (-m1sq + m5sq + m7sq)**2)*(4*m6sq*m7sq - (-m1sq + m6sq + m7sq)**2)) + ((m1sq - m3sq)*m4sq*(m4sq - m7sq)*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + (m1sq*(m1sq - m3sq)*m4sq*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(4*m4sq*m7sq - (-m1sq + m4sq + m7sq)**2)) - (2*(m1sq - m3sq)*m4sq*m7sq*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(4*m4sq*m7sq - (-m1sq + m4sq + m7sq)**2)) + (m1sq*(m1sq - m3sq)*m5sq*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) - ((m1sq - m3sq)*m5sq*(m5sq - m7sq)*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) + (2*(m1sq - m3sq)*m5sq*m7sq*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(4*m5sq*m7sq - (-m1sq + m5sq + m7sq)**2)) - ((m1sq - m3sq)*m6sq*(m6sq - m7sq)*B0del(0,0,m6sq,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (m1sq*(m1sq - m3sq)*m6sq*B0del(0,0,m6sq,mudim))/((m4sq - m6sq)*(m5sq - m6sq)*(4*m6sq*m7sq - (-m1sq + m6sq + m7sq)**2)) - (2*(m1sq - m3sq)*m6sq*m7sq*B0del(0,0,m6sq,mudim))/((m4sq - m6sq)*(m5sq - m6sq)*(4*m6sq*m7sq - (-m1sq + m6sq + m7sq)**2)) - (2*(m1sq - m3sq)*m4sq*m7sq*B0del(0,0,m7sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(4*m4sq*m7sq - (-m1sq + m4sq + m7sq)**2)) + (2*(m1sq - m3sq)*m5sq*m7sq*B0del(0,0,m7sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(4*m5sq*m7sq - (-m1sq + m5sq + m7sq)**2)) - (2*(m1sq - m3sq)*m6sq*m7sq*B0del(0,0,m7sq,mudim))/((m4sq - m6sq)*(m5sq - m6sq)*(4*m6sq*m7sq - (-m1sq + m6sq + m7sq)**2)) + (m1sq*(m1sq - m3sq)*m7sq*(3*m1**4 + m5sq*m6sq + 3*m7**4 - 2*m1sq*(m4sq + m5sq + m6sq - 5*m7sq) + m4sq*(m5sq + m6sq - 2*m7sq) - 2*m5sq*m7sq - 2*m6sq*m7sq)*B0del(0,0,m7sq,mudim))/((4*m4sq*m7sq - (-m1sq + m4sq + m7sq)**2)*(4*m5sq*m7sq - (-m1sq + m5sq + m7sq)**2)*(4*m6sq*m7sq - (-m1sq + m6sq + m7sq)**2)) - ((m1sq - m3sq)*m7sq*(2*m1**6 + 4*m1sq*(m4sq + m5sq + m6sq - 3*m7sq)*m7sq + (m4sq - m7sq)*(-m5sq + m7sq)*(-m6sq + m7sq) - m1**4*(m4sq + m5sq + m6sq + 5*m7sq))*B0del(0,0,m7sq,mudim))/((m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + ((m1sq - m3sq)*m4sq*(m4sq - m7sq)*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/((m4sq - m5sq)*(m4sq - m6sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) - ((m1sq - m3sq)*m5sq*(m5sq - m7sq)*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/((m4sq - m5sq)*(m5sq - m6sq)*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) - ((m1sq - m3sq)*m6sq*(m6sq - m7sq)*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - ((m1sq - m3sq)*m7sq*(2*m1**6 + 4*m1sq*(m4sq + m5sq + m6sq - 3*m7sq)*m7sq + (m4sq - m7sq)*(-m5sq + m7sq)*(-m6sq + m7sq) - m1**4*(m4sq + m5sq + m6sq + 5*m7sq))*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/((m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (m1sq*(m1sq - m3sq)*m4sq*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(4*m4sq*m7sq - (-m1sq + m4sq + m7sq)**2)) - (m1sq*(m1sq - m3sq)*m5sq*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) - (m1sq*(m1sq - m3sq)*m6sq*B0fin(0,0,m1sq,mudim))/((m4sq - m6sq)*(m5sq - m6sq)*(4*m6sq*m7sq - (-m1sq + m6sq + m7sq)**2)) - (m1sq*(m1sq - m3sq)*m7sq*(3*m1**4 + m5sq*m6sq + 3*m7**4 - 2*m1sq*(m4sq + m5sq + m6sq - 5*m7sq) + m4sq*(m5sq + m6sq - 2*m7sq) - 2*m5sq*m7sq - 2*m6sq*m7sq)*B0fin(0,0,m1sq,mudim))/((4*m4sq*m7sq - (-m1sq + m4sq + m7sq)**2)*(4*m5sq*m7sq - (-m1sq + m5sq + m7sq)**2)*(4*m6sq*m7sq - (-m1sq + m6sq + m7sq)**2)) - ((m1sq - m3sq)*m4sq*(m4sq - m7sq)*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) - (m1sq*(m1sq - m3sq)*m4sq*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(4*m4sq*m7sq - (-m1sq + m4sq + m7sq)**2)) + (2*(m1sq - m3sq)*m4sq*m7sq*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(4*m4sq*m7sq - (-m1sq + m4sq + m7sq)**2)) + ((m1sq - m3sq)*m4sq*(m4sq - m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + (m1sq*(m1sq - m3sq)*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(4*m4sq*m7sq - (-m1sq + m4sq + m7sq)**2)) - (m1sq*(m1sq - m3sq)*m5sq*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) + ((m1sq - m3sq)*m5sq*(m5sq - m7sq)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) - (2*(m1sq - m3sq)*m5sq*m7sq*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(4*m5sq*m7sq - (-m1sq + m5sq + m7sq)**2)) + (m1sq*(m1sq - m3sq)*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) - ((m1sq - m3sq)*m5sq*(m5sq - m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) + ((m1sq - m3sq)*m6sq*(m6sq - m7sq)*B0fin(0,0,m6sq,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (m1sq*(m1sq - m3sq)*m6sq*B0fin(0,0,m6sq,mudim))/((m4sq - m6sq)*(m5sq - m6sq)*(4*m6sq*m7sq - (-m1sq + m6sq + m7sq)**2)) + (2*(m1sq - m3sq)*m6sq*m7sq*B0fin(0,0,m6sq,mudim))/((m4sq - m6sq)*(m5sq - m6sq)*(4*m6sq*m7sq - (-m1sq + m6sq + m7sq)**2)) - ((m1sq - m3sq)*m6sq*(m6sq - m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (m1sq*(m1sq - m3sq)*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m6sq)*(m5sq - m6sq)*(4*m6sq*m7sq - (-m1sq + m6sq + m7sq)**2)) + (2*(m1sq - m3sq)*m4sq*m7sq*B0fin(0,0,m7sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(4*m4sq*m7sq - (-m1sq + m4sq + m7sq)**2)) - (2*(m1sq - m3sq)*m5sq*m7sq*B0fin(0,0,m7sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(4*m5sq*m7sq - (-m1sq + m5sq + m7sq)**2)) + (2*(m1sq - m3sq)*m6sq*m7sq*B0fin(0,0,m7sq,mudim))/((m4sq - m6sq)*(m5sq - m6sq)*(4*m6sq*m7sq - (-m1sq + m6sq + m7sq)**2)) - (m1sq*(m1sq - m3sq)*m7sq*(3*m1**4 + m5sq*m6sq + 3*m7**4 - 2*m1sq*(m4sq + m5sq + m6sq - 5*m7sq) + m4sq*(m5sq + m6sq - 2*m7sq) - 2*m5sq*m7sq - 2*m6sq*m7sq)*B0fin(0,0,m7sq,mudim))/((4*m4sq*m7sq - (-m1sq + m4sq + m7sq)**2)*(4*m5sq*m7sq - (-m1sq + m5sq + m7sq)**2)*(4*m6sq*m7sq - (-m1sq + m6sq + m7sq)**2)) + ((m1sq - m3sq)*m7sq*(2*m1**6 + 4*m1sq*(m4sq + m5sq + m6sq - 3*m7sq)*m7sq + (m4sq - m7sq)*(-m5sq + m7sq)*(-m6sq + m7sq) - m1**4*(m4sq + m5sq + m6sq + 5*m7sq))*B0fin(0,0,m7sq,mudim))/((m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (m1sq*(m1sq - m3sq)*m7sq*(3*m1**4 + m5sq*m6sq + 3*m7**4 - 2*m1sq*(m4sq + m5sq + m6sq - 5*m7sq) + m4sq*(m5sq + m6sq - 2*m7sq) - 2*m5sq*m7sq - 2*m6sq*m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((4*m4sq*m7sq - (-m1sq + m4sq + m7sq)**2)*(4*m5sq*m7sq - (-m1sq + m5sq + m7sq)**2)*(4*m6sq*m7sq - (-m1sq + m6sq + m7sq)**2)) - ((m1sq - m3sq)*m7sq*(2*m1**6 + 4*m1sq*(m4sq + m5sq + m6sq - 3*m7sq)*m7sq + (m4sq - m7sq)*(-m5sq + m7sq)*(-m6sq + m7sq) - m1**4*(m4sq + m5sq + m6sq + 5*m7sq))*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (2*(m1sq - m3sq)*m4sq*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(4*m4sq*m7sq - (-m1sq + m4sq + m7sq)**2)) + (2*(m1sq - m3sq)*m5sq*m7sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(4*m5sq*m7sq - (-m1sq + m5sq + m7sq)**2)) - (2*(m1sq - m3sq)*m6sq*m7sq*B0fin(0,0,m6sq,mudim)*B0fin(0,0,m7sq,mudim))/((m4sq - m6sq)*(m5sq - m6sq)*(4*m6sq*m7sq - (-m1sq + m6sq + m7sq)**2)) - ((m1sq - m3sq)*(m1sq - m4sq - m7sq)*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m5sq)*(m4sq - m6sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + ((m1sq - m3sq)*(m1sq - m5sq - m7sq)*(m1sq + m5sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m5sq)*(m5sq - m6sq)*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) + (m1**4*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (m1sq*m3sq*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (m1sq*(m6sq + m7sq)*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + (m3sq*(m6sq + m7sq)*(m1sq + m6sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - T134fin(m7,m4,m1,mudim)/((m4sq - m5sq)*(m4sq - m6sq)) + ((m1sq - m3sq)*(m1sq - m4sq - m7sq)*T134fin(m7,m4,m1,mudim))/((m4sq - m5sq)*(m4sq - m6sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + T134fin(m7,m4,m3,mudim)/((m4sq - m5sq)*(m4sq - m6sq)) + T134fin(m7,m5,m1,mudim)/((m4sq - m5sq)*(m5sq - m6sq)) + ((m1sq - m3sq)*(m1sq - m5sq - m7sq)*T134fin(m7,m5,m1,mudim))/((m4sq - m5sq)*(m5sq - m6sq)*(4*m5sq*m7sq - (-m1sq + m5sq + m7sq)**2)) - T134fin(m7,m5,m3,mudim)/((m4sq - m5sq)*(m5sq - m6sq)) + (m1sq*m3sq*T134fin(m7,m6,m1,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (m1sq*m6sq*T134fin(m7,m6,m1,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) + ((m6sq - m7sq)**2*T134fin(m7,m6,m1,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (m1sq*m7sq*T134fin(m7,m6,m1,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - (m3sq*(m6sq + m7sq)*T134fin(m7,m6,m1,mudim))/((m4sq - m6sq)*(-m5sq + m6sq)*(m1**4 + (m6sq - m7sq)**2 - 2*m1sq*(m6sq + m7sq))) - T134fin(m7,m6,m3,mudim)/((m4sq - m6sq)*(-m5sq + m6sq)))/(m1sq - m3sq)**2
		def eval_140():
			return ((m2sq - m3sq)*(m5sq - m6sq)*T134fin(m7,m4,m1,mudim) - (m1sq - m3sq)*(m5sq - m6sq)*T134fin(m7,m4,m2,mudim) + m1sq*m5sq*T134fin(m7,m4,m3,mudim) - m2sq*m5sq*T134fin(m7,m4,m3,mudim) - m1sq*m6sq*T134fin(m7,m4,m3,mudim) + m2sq*m6sq*T134fin(m7,m4,m3,mudim) - m2sq*m4sq*T134fin(m7,m5,m1,mudim) + m3sq*m4sq*T134fin(m7,m5,m1,mudim) + m2sq*m6sq*T134fin(m7,m5,m1,mudim) - m3sq*m6sq*T134fin(m7,m5,m1,mudim) + m1sq*m4sq*T134fin(m7,m5,m2,mudim) - m3sq*m4sq*T134fin(m7,m5,m2,mudim) - m1sq*m6sq*T134fin(m7,m5,m2,mudim) + m3sq*m6sq*T134fin(m7,m5,m2,mudim) - m1sq*m4sq*T134fin(m7,m5,m3,mudim) + m2sq*m4sq*T134fin(m7,m5,m3,mudim) + m1sq*m6sq*T134fin(m7,m5,m3,mudim) - m2sq*m6sq*T134fin(m7,m5,m3,mudim) + m2sq*m4sq*T134fin(m7,m6,m1,mudim) - m3sq*m4sq*T134fin(m7,m6,m1,mudim) - m2sq*m5sq*T134fin(m7,m6,m1,mudim) + m3sq*m5sq*T134fin(m7,m6,m1,mudim) - m1sq*m4sq*T134fin(m7,m6,m2,mudim) + m3sq*m4sq*T134fin(m7,m6,m2,mudim) + m1sq*m5sq*T134fin(m7,m6,m2,mudim) - m3sq*m5sq*T134fin(m7,m6,m2,mudim) + m1sq*m4sq*T134fin(m7,m6,m3,mudim) - m2sq*m4sq*T134fin(m7,m6,m3,mudim) - m1sq*m5sq*T134fin(m7,m6,m3,mudim) + m2sq*m5sq*T134fin(m7,m6,m3,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m2sq - m3sq)*(m4sq - m5sq)*(m4sq - m6sq)*(m5sq - m6sq))

		cond_m1_0 = cond(m1, 0)
		cond_m2_0 = cond(m2, 0)
		cond_m3_0 = cond(m3, 0)
		cond_m4_0 = cond(m4, 0)
		cond_m5_0 = cond(m5, 0)
		cond_m6_0 = cond(m6, 0)
		cond_m7_0 = cond(m7, 0)
		cond_m7_m6 = cond(m7, m6)
		cond_m7_m5 = cond(m7, m5)
		cond_m6_m5 = cond(m6, m5)
		cond_m7_m4 = cond(m7, m4)
		cond_m6_m4 = cond(m6, m4)
		cond_m5_m4 = cond(m5, m4)
		cond_m7_m3 = cond(m7, m3)
		cond_m6_m3 = cond(m6, m3)
		cond_m5_m3 = cond(m5, m3)
		cond_m4_m3 = cond(m4, m3)
		cond_m7_m2 = cond(m7, m2)
		cond_m6_m2 = cond(m6, m2)
		cond_m5_m2 = cond(m5, m2)
		cond_m4_m2 = cond(m4, m2)
		cond_m3_m2 = cond(m3, m2)
		cond_m7_m1 = cond(m7, m1)
		cond_m6_m1 = cond(m6, m1)
		cond_m5_m1 = cond(m5, m1)
		cond_m4_m1 = cond(m4, m1)
		cond_m3_m1 = cond(m3, m1)
		cond_m2_m1 = cond(m2, m1)

		conditions = [
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_1()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_2()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_3()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_3()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_3()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_4()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_4()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_4()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_m6, lambda: eval_25()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_m5, lambda: eval_25()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_m5 and cond_m7_0, lambda: eval_5()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_m4, lambda: eval_25()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_m4 and cond_m7_0, lambda: eval_5()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_0 and cond_m7_0, lambda: eval_5()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_31()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_8()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_8()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_8()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_31()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_8()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_8()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_8()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_6()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_31()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_8()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_8()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_8()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_6()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_6()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0, lambda: eval_40()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_0, lambda: eval_40()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m7_0, lambda: eval_7()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_0, lambda: eval_40()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m7_0, lambda: eval_7()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m6_0 and cond_m7_0, lambda: eval_7()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_45()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_8()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_8()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_8()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_45()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_8()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_8()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_8()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_9()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_45()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_8()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_8()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_8()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_9()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_9()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_24()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_24()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m4, lambda: eval_24()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_0, lambda: eval_27()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_10()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_10()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_11()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_10()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_11()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_11()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_10()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_10()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_11()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_10()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_11()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_11()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_29()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_12()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_12()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_12()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_10()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_10()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_11()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_10()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_11()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_11()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_29()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_12()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_12()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_12()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_29()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_12()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_12()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_12()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_34()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m7_m6, lambda: eval_37()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m7_m6, lambda: eval_37()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m6_0 and cond_m7_m5, lambda: eval_37()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m6_m5 and cond_m7_0, lambda: eval_38()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m7_m6, lambda: eval_13()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m6_0 and cond_m7_m5, lambda: eval_13()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m6_m5 and cond_m7_0, lambda: eval_14()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m6_0 and cond_m7_m4, lambda: eval_13()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m6_m4 and cond_m7_0, lambda: eval_14()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m6_0 and cond_m7_0, lambda: eval_14()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_m6, lambda: eval_13()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_m5, lambda: eval_13()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m6_m5 and cond_m7_0, lambda: eval_14()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_m4, lambda: eval_13()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m6_m4 and cond_m7_0, lambda: eval_14()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m6_0 and cond_m7_0, lambda: eval_14()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_42()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_19()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_19()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_19()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_m5, lambda: eval_38()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m7_m5, lambda: eval_39()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_m4, lambda: eval_38()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m7_m4, lambda: eval_39()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_0, lambda: eval_38()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m7_0, lambda: eval_40()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m6_0 and cond_m7_m4, lambda: eval_39()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m6_m4 and cond_m7_0, lambda: eval_40()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_m3, lambda: eval_17()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m7_m3, lambda: eval_15()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_0, lambda: eval_17()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m7_0, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m6_0 and cond_m7_m3, lambda: eval_15()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m6_m3 and cond_m7_0, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_0, lambda: eval_17()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m7_0, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m6_0 and cond_m7_0, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_15()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_18()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m2, lambda: eval_17()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_m2, lambda: eval_15()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_0, lambda: eval_17()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m7_0, lambda: eval_18()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_m2, lambda: eval_15()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m6_m2 and cond_m7_0, lambda: eval_18()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_0, lambda: eval_17()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m7_0, lambda: eval_18()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m6_0 and cond_m7_0, lambda: eval_18()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_15()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_18()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_18()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_43()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_16()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_16()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_16()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_44()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_19()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_19()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_19()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_m6, lambda: eval_13()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_m5, lambda: eval_13()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_m5 and cond_m7_0, lambda: eval_14()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_m4, lambda: eval_13()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_m4 and cond_m7_0, lambda: eval_14()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_0 and cond_m7_0, lambda: eval_14()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_42()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_19()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_19()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_19()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_42()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_19()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_19()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_19()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_43()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_17()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_m1, lambda: eval_15()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_17()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m7_0, lambda: eval_18()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_m1, lambda: eval_15()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_m1 and cond_m7_0, lambda: eval_18()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_17()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m7_0, lambda: eval_18()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m6_0 and cond_m7_0, lambda: eval_18()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_15()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_18()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_18()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_43()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_16()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_16()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_16()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_44()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_19()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_19()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_19()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_43()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_16()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_16()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_16()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_45()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_44()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_19()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_19()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_19()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_45()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0, lambda: eval_47()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_0, lambda: eval_47()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m6_0, lambda: eval_47()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m7_0, lambda: eval_47()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_0, lambda: eval_17()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m6_0, lambda: eval_17()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m7_0, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m6_0, lambda: eval_17()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m7_0, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m6_0 and cond_m7_0, lambda: eval_18()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_0, lambda: eval_17()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m6_0, lambda: eval_17()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m7_0, lambda: eval_18()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m6_0, lambda: eval_17()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m7_0, lambda: eval_18()),
			(cond_m1_0 and cond_m3_0 and cond_m6_0 and cond_m7_0, lambda: eval_18()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_48()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_19()),
			(cond_m1_0 and cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_19()),
			(cond_m1_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_19()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0, lambda: eval_17()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_0, lambda: eval_17()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m7_0, lambda: eval_18()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_0, lambda: eval_17()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m7_0, lambda: eval_18()),
			(cond_m2_0 and cond_m3_0 and cond_m6_0 and cond_m7_0, lambda: eval_18()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_48()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_19()),
			(cond_m2_0 and cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_19()),
			(cond_m2_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_19()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_48()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_19()),
			(cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_19()),
			(cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_19()),
			(cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_48()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m4, lambda: eval_20()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_59()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_59()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_59()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_21()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_59()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_59()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_59()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_21()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_65()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_65()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_88()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_65()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_88()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_88()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_59()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_59()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_59()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_21()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_65()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_65()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_88()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_65()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_88()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_88()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_65()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_65()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_88()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_65()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_88()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_88()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_22()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_23()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_23()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_23()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_24()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_59()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_59()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m4, lambda: eval_59()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_0, lambda: eval_62()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_59()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_59()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m4, lambda: eval_59()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_0, lambda: eval_62()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_79()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_79()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_105()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_79()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_105()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_105()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m7_m6, lambda: eval_25()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m6_m4 and cond_m7_m5, lambda: eval_25()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m6_m5 and cond_m7_m4, lambda: eval_26()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m7_m6, lambda: eval_74()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m6_m3 and cond_m7_m5, lambda: eval_74()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m3, lambda: eval_75()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m7_m6, lambda: eval_74()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m6_0 and cond_m7_m5, lambda: eval_74()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m6_m5 and cond_m7_0, lambda: eval_75()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m4, lambda: eval_74()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m3, lambda: eval_75()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m4, lambda: eval_74()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m6_m4 and cond_m7_0, lambda: eval_75()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m3, lambda: eval_75()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m6_m3 and cond_m7_0, lambda: eval_75()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m7_m6, lambda: eval_74()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m6_m2 and cond_m7_m5, lambda: eval_74()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m2, lambda: eval_75()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m7_m6, lambda: eval_74()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m6_0 and cond_m7_m5, lambda: eval_74()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m6_m5 and cond_m7_0, lambda: eval_75()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m4, lambda: eval_74()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m2, lambda: eval_75()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m4, lambda: eval_74()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m6_m4 and cond_m7_0, lambda: eval_75()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m2, lambda: eval_75()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m2 and cond_m7_0, lambda: eval_75()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m7_m6, lambda: eval_80()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m6_0 and cond_m7_m5, lambda: eval_80()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m6_m5 and cond_m7_0, lambda: eval_131()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m4, lambda: eval_80()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m6_m4 and cond_m7_0, lambda: eval_131()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m6_0 and cond_m7_0, lambda: eval_131()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m3, lambda: eval_79()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m2, lambda: eval_81()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m3, lambda: eval_79()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m3 and cond_m7_0, lambda: eval_140()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m2, lambda: eval_81()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m2 and cond_m7_0, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_79()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_81()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_140()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m4, lambda: eval_27()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m7_m4, lambda: eval_28()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_28()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m3, lambda: eval_75()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m7_m3, lambda: eval_76()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_76()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m3, lambda: eval_75()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m7_m3, lambda: eval_76()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_0, lambda: eval_75()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m7_0, lambda: eval_33()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_76()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_33()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_76()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_76()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_33()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m2, lambda: eval_75()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m7_m2, lambda: eval_76()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_76()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m2, lambda: eval_75()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m7_m2, lambda: eval_76()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_0, lambda: eval_75()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m7_0, lambda: eval_33()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_76()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_33()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_76()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_76()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_33()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_m2, lambda: eval_80()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m7_m2, lambda: eval_65()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_0, lambda: eval_80()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m7_0, lambda: eval_107()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m6_0 and cond_m7_m2, lambda: eval_65()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m6_m2 and cond_m7_0, lambda: eval_107()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_0, lambda: eval_80()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m7_0, lambda: eval_107()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m6_0 and cond_m7_0, lambda: eval_107()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_65()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_107()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_107()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_81()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_81()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_108()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_81()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_108()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_108()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_59()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_59()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m4, lambda: eval_59()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_0, lambda: eval_62()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_79()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_79()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_105()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_79()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_105()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_105()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_79()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_79()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_105()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_79()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_105()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_105()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_29()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_30()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_30()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_30()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m7_m6, lambda: eval_74()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_m1 and cond_m7_m5, lambda: eval_74()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m1, lambda: eval_75()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m7_m6, lambda: eval_74()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m6_0 and cond_m7_m5, lambda: eval_74()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m6_m5 and cond_m7_0, lambda: eval_75()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m4, lambda: eval_74()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m1, lambda: eval_75()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m4, lambda: eval_74()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m6_m4 and cond_m7_0, lambda: eval_75()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m1, lambda: eval_75()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m1 and cond_m7_0, lambda: eval_75()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m7_m6, lambda: eval_80()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m6_0 and cond_m7_m5, lambda: eval_80()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m6_m5 and cond_m7_0, lambda: eval_131()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m4, lambda: eval_80()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m6_m4 and cond_m7_0, lambda: eval_131()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4 and cond_m6_0 and cond_m7_0, lambda: eval_131()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m3, lambda: eval_79()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m1, lambda: eval_81()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m3, lambda: eval_79()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m3 and cond_m7_0, lambda: eval_140()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m1, lambda: eval_81()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m1 and cond_m7_0, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_79()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_81()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_140()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_m6, lambda: eval_80()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_m5, lambda: eval_80()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m6_m5 and cond_m7_0, lambda: eval_131()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_m4, lambda: eval_80()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m6_m4 and cond_m7_0, lambda: eval_131()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4 and cond_m6_0 and cond_m7_0, lambda: eval_131()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_31()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_82()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_82()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_82()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_79()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_81()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_79()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_140()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_81()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_79()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_81()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_140()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_31()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_82()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_82()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_82()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_32()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_80()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_80()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_80()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_75()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m7_m1, lambda: eval_76()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_76()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_75()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m7_m1, lambda: eval_76()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_75()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m7_0, lambda: eval_33()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_76()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_33()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_76()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_76()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_33()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_80()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m7_m1, lambda: eval_65()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_80()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m7_0, lambda: eval_107()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m6_0 and cond_m7_m1, lambda: eval_65()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m6_m1 and cond_m7_0, lambda: eval_107()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_80()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m7_0, lambda: eval_107()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m6_0 and cond_m7_0, lambda: eval_107()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_65()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_107()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_107()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_81()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_81()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_108()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_81()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_108()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_108()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_80()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_m1, lambda: eval_65()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_80()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m7_0, lambda: eval_107()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_m1, lambda: eval_65()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m6_m1 and cond_m7_0, lambda: eval_107()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_80()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m7_0, lambda: eval_107()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m6_0 and cond_m7_0, lambda: eval_107()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_65()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_107()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_107()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_34()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_70()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_35()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_36()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_36()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_36()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_81()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_81()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_108()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_81()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_108()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_108()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_35()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_36()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_36()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_36()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m7_m6, lambda: eval_37()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m7_m6, lambda: eval_74()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m7_m6, lambda: eval_74()),
			(cond_m1_0 and cond_m2_0 and cond_m6_0 and cond_m7_m5, lambda: eval_74()),
			(cond_m1_0 and cond_m2_0 and cond_m6_m5 and cond_m7_0, lambda: eval_75()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m7_m6, lambda: eval_74()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m7_m6, lambda: eval_74()),
			(cond_m1_0 and cond_m3_0 and cond_m6_0 and cond_m7_m5, lambda: eval_74()),
			(cond_m1_0 and cond_m3_0 and cond_m6_m5 and cond_m7_0, lambda: eval_75()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m7_m6, lambda: eval_137()),
			(cond_m1_0 and cond_m4_0 and cond_m6_0 and cond_m7_m5, lambda: eval_137()),
			(cond_m1_0 and cond_m4_0 and cond_m6_m5 and cond_m7_0, lambda: eval_136()),
			(cond_m1_0 and cond_m5_0 and cond_m6_0 and cond_m7_m4, lambda: eval_137()),
			(cond_m1_0 and cond_m5_0 and cond_m6_m4 and cond_m7_0, lambda: eval_136()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_0 and cond_m7_0, lambda: eval_136()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m6_m5, lambda: eval_38()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m7_m5, lambda: eval_39()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m6_m5, lambda: eval_75()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m7_m5, lambda: eval_76()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m6_m4, lambda: eval_75()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m7_m4, lambda: eval_76()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m6_0, lambda: eval_75()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m7_0, lambda: eval_77()),
			(cond_m1_0 and cond_m2_0 and cond_m6_0 and cond_m7_m4, lambda: eval_76()),
			(cond_m1_0 and cond_m2_0 and cond_m6_m4 and cond_m7_0, lambda: eval_77()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m6_m5, lambda: eval_75()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m7_m5, lambda: eval_76()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m6_m4, lambda: eval_75()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m7_m4, lambda: eval_76()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m6_0, lambda: eval_75()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m7_0, lambda: eval_77()),
			(cond_m1_0 and cond_m3_0 and cond_m6_0 and cond_m7_m4, lambda: eval_76()),
			(cond_m1_0 and cond_m3_0 and cond_m6_m4 and cond_m7_0, lambda: eval_77()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m6_m3, lambda: eval_137()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m7_m3, lambda: eval_79()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m6_0, lambda: eval_137()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m7_0, lambda: eval_140()),
			(cond_m1_0 and cond_m4_0 and cond_m6_0 and cond_m7_m3, lambda: eval_79()),
			(cond_m1_0 and cond_m4_0 and cond_m6_m3 and cond_m7_0, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m6_0, lambda: eval_137()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m7_0, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_0 and cond_m7_0, lambda: eval_140()),
			(cond_m1_0 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_79()),
			(cond_m1_0 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_140()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_140()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_m4, lambda: eval_40()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m6_m4, lambda: eval_40()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m7_m4, lambda: eval_41()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_m3, lambda: eval_139()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m6_m3, lambda: eval_139()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m7_m3, lambda: eval_139()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_0, lambda: eval_139()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m6_0, lambda: eval_139()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m7_0, lambda: eval_139()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m6_m3, lambda: eval_139()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m7_m3, lambda: eval_139()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m6_0, lambda: eval_139()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m7_0, lambda: eval_139()),
			(cond_m1_0 and cond_m2_0 and cond_m6_0 and cond_m7_m3, lambda: eval_139()),
			(cond_m1_0 and cond_m2_0 and cond_m6_m3 and cond_m7_0, lambda: eval_139()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_m2, lambda: eval_139()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m6_m2, lambda: eval_139()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m7_m2, lambda: eval_139()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_0, lambda: eval_139()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m6_0, lambda: eval_139()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m7_0, lambda: eval_139()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m6_m2, lambda: eval_139()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m7_m2, lambda: eval_139()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m6_0, lambda: eval_139()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m7_0, lambda: eval_139()),
			(cond_m1_0 and cond_m3_0 and cond_m6_0 and cond_m7_m2, lambda: eval_139()),
			(cond_m1_0 and cond_m3_0 and cond_m6_m2 and cond_m7_0, lambda: eval_139()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_0, lambda: eval_80()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m6_0, lambda: eval_80()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m7_0, lambda: eval_138()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m6_0, lambda: eval_80()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m7_0, lambda: eval_138()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_0 and cond_m7_0, lambda: eval_138()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m6_m2, lambda: eval_137()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m7_m2, lambda: eval_81()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m6_0, lambda: eval_137()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m7_0, lambda: eval_140()),
			(cond_m1_0 and cond_m4_0 and cond_m6_0 and cond_m7_m2, lambda: eval_81()),
			(cond_m1_0 and cond_m4_0 and cond_m6_m2 and cond_m7_0, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m6_0, lambda: eval_137()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m7_0, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_0 and cond_m7_0, lambda: eval_140()),
			(cond_m1_0 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_81()),
			(cond_m1_0 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_140()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_140()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m7_m6, lambda: eval_74()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m7_m6, lambda: eval_74()),
			(cond_m2_0 and cond_m3_0 and cond_m6_0 and cond_m7_m5, lambda: eval_74()),
			(cond_m2_0 and cond_m3_0 and cond_m6_m5 and cond_m7_0, lambda: eval_75()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m7_m6, lambda: eval_137()),
			(cond_m2_0 and cond_m4_0 and cond_m6_0 and cond_m7_m5, lambda: eval_137()),
			(cond_m2_0 and cond_m4_0 and cond_m6_m5 and cond_m7_0, lambda: eval_136()),
			(cond_m2_0 and cond_m5_0 and cond_m6_0 and cond_m7_m4, lambda: eval_137()),
			(cond_m2_0 and cond_m5_0 and cond_m6_m4 and cond_m7_0, lambda: eval_136()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_0 and cond_m7_0, lambda: eval_136()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_m5, lambda: eval_75()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m7_m5, lambda: eval_76()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_m4, lambda: eval_75()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m7_m4, lambda: eval_76()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_0, lambda: eval_75()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m7_0, lambda: eval_77()),
			(cond_m2_0 and cond_m3_0 and cond_m6_0 and cond_m7_m4, lambda: eval_76()),
			(cond_m2_0 and cond_m3_0 and cond_m6_m4 and cond_m7_0, lambda: eval_77()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_m3, lambda: eval_137()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m7_m3, lambda: eval_79()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_0, lambda: eval_137()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m7_0, lambda: eval_140()),
			(cond_m2_0 and cond_m4_0 and cond_m6_0 and cond_m7_m3, lambda: eval_79()),
			(cond_m2_0 and cond_m4_0 and cond_m6_m3 and cond_m7_0, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_0, lambda: eval_137()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m7_0, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_0 and cond_m7_0, lambda: eval_140()),
			(cond_m2_0 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_79()),
			(cond_m2_0 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_140()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_140()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_m6, lambda: eval_137()),
			(cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_m5, lambda: eval_137()),
			(cond_m3_0 and cond_m4_0 and cond_m6_m5 and cond_m7_0, lambda: eval_136()),
			(cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_m4, lambda: eval_137()),
			(cond_m3_0 and cond_m5_0 and cond_m6_m4 and cond_m7_0, lambda: eval_136()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_0 and cond_m7_0, lambda: eval_136()),
			(cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_42()),
			(cond_m4_0 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_137()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_137()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_137()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m2, lambda: eval_137()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_m2, lambda: eval_79()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_0, lambda: eval_137()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m7_0, lambda: eval_140()),
			(cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_m2, lambda: eval_79()),
			(cond_m3_0 and cond_m4_0 and cond_m6_m2 and cond_m7_0, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_0, lambda: eval_137()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m7_0, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_0 and cond_m7_0, lambda: eval_140()),
			(cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_79()),
			(cond_m3_0 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_140()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_140()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_43()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_80()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_80()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_80()),
			(cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_44()),
			(cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_137()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_137()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_137()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_m1, lambda: eval_139()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_m1, lambda: eval_139()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m7_m1, lambda: eval_139()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_0, lambda: eval_139()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m6_0, lambda: eval_139()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m7_0, lambda: eval_139()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_m1, lambda: eval_139()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m7_m1, lambda: eval_139()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m6_0, lambda: eval_139()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m7_0, lambda: eval_139()),
			(cond_m2_0 and cond_m3_0 and cond_m6_0 and cond_m7_m1, lambda: eval_139()),
			(cond_m2_0 and cond_m3_0 and cond_m6_m1 and cond_m7_0, lambda: eval_139()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_0, lambda: eval_80()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m6_0, lambda: eval_80()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m7_0, lambda: eval_138()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m6_0, lambda: eval_80()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m7_0, lambda: eval_138()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_0 and cond_m7_0, lambda: eval_138()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_137()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m7_m1, lambda: eval_81()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_137()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m7_0, lambda: eval_140()),
			(cond_m2_0 and cond_m4_0 and cond_m6_0 and cond_m7_m1, lambda: eval_81()),
			(cond_m2_0 and cond_m4_0 and cond_m6_m1 and cond_m7_0, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_137()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m7_0, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_0 and cond_m7_0, lambda: eval_140()),
			(cond_m2_0 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_81()),
			(cond_m2_0 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_140()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_140()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_0, lambda: eval_80()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m6_0, lambda: eval_80()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m7_0, lambda: eval_138()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m6_0, lambda: eval_80()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m7_0, lambda: eval_138()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_0 and cond_m7_0, lambda: eval_138()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_45()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_82()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_82()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_137()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_m1, lambda: eval_81()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_137()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m7_0, lambda: eval_140()),
			(cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_m1, lambda: eval_81()),
			(cond_m3_0 and cond_m4_0 and cond_m6_m1 and cond_m7_0, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_137()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m7_0, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_0 and cond_m7_0, lambda: eval_140()),
			(cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_81()),
			(cond_m3_0 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_140()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_140()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_45()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_82()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_82()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_82()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_82()),
			(cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_46()),
			(cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_137()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_137()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_137()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0, lambda: eval_47()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0, lambda: eval_139()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0, lambda: eval_139()),
			(cond_m1_0 and cond_m2_0 and cond_m6_0, lambda: eval_139()),
			(cond_m1_0 and cond_m2_0 and cond_m7_0, lambda: eval_139()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0, lambda: eval_139()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0, lambda: eval_139()),
			(cond_m1_0 and cond_m3_0 and cond_m6_0, lambda: eval_139()),
			(cond_m1_0 and cond_m3_0 and cond_m7_0, lambda: eval_139()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0, lambda: eval_137()),
			(cond_m1_0 and cond_m4_0 and cond_m6_0, lambda: eval_137()),
			(cond_m1_0 and cond_m4_0 and cond_m7_0, lambda: eval_140()),
			(cond_m1_0 and cond_m5_0 and cond_m6_0, lambda: eval_137()),
			(cond_m1_0 and cond_m5_0 and cond_m7_0, lambda: eval_140()),
			(cond_m1_0 and cond_m6_0 and cond_m7_0, lambda: eval_140()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0, lambda: eval_139()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0, lambda: eval_139()),
			(cond_m2_0 and cond_m3_0 and cond_m6_0, lambda: eval_139()),
			(cond_m2_0 and cond_m3_0 and cond_m7_0, lambda: eval_139()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0, lambda: eval_137()),
			(cond_m2_0 and cond_m4_0 and cond_m6_0, lambda: eval_137()),
			(cond_m2_0 and cond_m4_0 and cond_m7_0, lambda: eval_140()),
			(cond_m2_0 and cond_m5_0 and cond_m6_0, lambda: eval_137()),
			(cond_m2_0 and cond_m5_0 and cond_m7_0, lambda: eval_140()),
			(cond_m2_0 and cond_m6_0 and cond_m7_0, lambda: eval_140()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0, lambda: eval_137()),
			(cond_m3_0 and cond_m4_0 and cond_m6_0, lambda: eval_137()),
			(cond_m3_0 and cond_m4_0 and cond_m7_0, lambda: eval_140()),
			(cond_m3_0 and cond_m5_0 and cond_m6_0, lambda: eval_137()),
			(cond_m3_0 and cond_m5_0 and cond_m7_0, lambda: eval_140()),
			(cond_m3_0 and cond_m6_0 and cond_m7_0, lambda: eval_140()),
			(cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_48()),
			(cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_137()),
			(cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_137()),
			(cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_137()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_51()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_51()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_49()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_49()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_49()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_85()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_51()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_49()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_49()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_49()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_85()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_49()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_49()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_49()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_85()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_56()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_56()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_50()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_56()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_50()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_50()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m4, lambda: eval_51()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m4, lambda: eval_51()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_116()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_116()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_116()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_97()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m6_m5 and cond_m7_m5, lambda: eval_59()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m6_m4 and cond_m7_m4, lambda: eval_59()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m6_m3 and cond_m7_m4, lambda: eval_59()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m3, lambda: eval_62()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m6_m5 and cond_m7_m5, lambda: eval_59()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m6_m4 and cond_m7_m4, lambda: eval_59()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m2 and cond_m7_m4, lambda: eval_59()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m2, lambda: eval_62()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_103()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_103()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m6_0 and cond_m7_m4, lambda: eval_103()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m6_m4 and cond_m7_0, lambda: eval_126()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m3 and cond_m7_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m2 and cond_m7_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m2, lambda: eval_136()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_98()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m2 and cond_m7_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m3 and cond_m7_m2, lambda: eval_136()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m6_0 and cond_m7_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m6_m3 and cond_m7_0, lambda: eval_98()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_0 and cond_m7_m2, lambda: eval_136()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m2 and cond_m7_0, lambda: eval_98()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m7_m6, lambda: eval_60()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m6_m3 and cond_m7_m5, lambda: eval_60()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m6_m5 and cond_m7_m3, lambda: eval_61()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m4, lambda: eval_60()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m6_m4 and cond_m7_m3, lambda: eval_61()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m6_m3 and cond_m7_m3, lambda: eval_61()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m7_m6, lambda: eval_60()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m6_m2 and cond_m7_m5, lambda: eval_60()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m6_m5 and cond_m7_m2, lambda: eval_61()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m4, lambda: eval_60()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m6_m4 and cond_m7_m2, lambda: eval_61()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m2 and cond_m7_m2, lambda: eval_61()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m7_m6, lambda: eval_138()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m6_m2 and cond_m7_m5, lambda: eval_138()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m6_m5 and cond_m7_m2, lambda: eval_99()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m7_m6, lambda: eval_138()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m6_0 and cond_m7_m5, lambda: eval_138()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m6_m5 and cond_m7_0, lambda: eval_100()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m4, lambda: eval_138()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m6_m4 and cond_m7_m2, lambda: eval_99()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m4, lambda: eval_138()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m6_m4 and cond_m7_0, lambda: eval_100()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m6_0 and cond_m7_m2, lambda: eval_99()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m6_m2 and cond_m7_0, lambda: eval_100()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m3, lambda: eval_136()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m3 and cond_m7_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m2 and cond_m7_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m3, lambda: eval_136()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m3 and cond_m7_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m3, lambda: eval_136()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m3 and cond_m7_0, lambda: eval_121()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m6_0 and cond_m7_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m6_m2 and cond_m7_0, lambda: eval_121()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_121()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3, lambda: eval_62()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m7_m3, lambda: eval_63()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_63()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_63()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2, lambda: eval_62()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m7_m2, lambda: eval_63()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_63()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_63()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_m2, lambda: eval_131()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m7_m2, lambda: eval_119()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_119()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_m2, lambda: eval_131()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m7_m2, lambda: eval_119()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_0, lambda: eval_131()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m7_0, lambda: eval_101()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_119()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_101()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_119()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_119()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_101()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_116()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_116()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_116()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_102()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m4, lambda: eval_51()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_116()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_116()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_116()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_97()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_116()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_116()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_116()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_97()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_65()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_65()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_52()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_65()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_52()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_52()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m6_m5 and cond_m7_m5, lambda: eval_59()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m6_m4 and cond_m7_m4, lambda: eval_59()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m1 and cond_m7_m4, lambda: eval_59()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m1, lambda: eval_62()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_103()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_103()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4 and cond_m6_0 and cond_m7_m4, lambda: eval_103()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4 and cond_m6_m4 and cond_m7_0, lambda: eval_126()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m3 and cond_m7_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m1 and cond_m7_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m1, lambda: eval_136()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_98()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m1 and cond_m7_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m3 and cond_m7_m1, lambda: eval_136()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1 and cond_m6_0 and cond_m7_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1 and cond_m6_m3 and cond_m7_0, lambda: eval_98()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_0 and cond_m7_m1, lambda: eval_136()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m1 and cond_m7_0, lambda: eval_98()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_103()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_103()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m4, lambda: eval_103()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_0, lambda: eval_126()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_68()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_68()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_53()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_68()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_53()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_53()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_136()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_98()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_136()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_98()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_136()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_98()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_68()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_68()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_53()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_68()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_53()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_53()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_65()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_69()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_65()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_54()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_69()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_54()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_65()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_54()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_54()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_69()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_54()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_54()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m7_m6, lambda: eval_60()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m6_m1 and cond_m7_m5, lambda: eval_60()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m6_m5 and cond_m7_m1, lambda: eval_61()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m4, lambda: eval_60()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m6_m4 and cond_m7_m1, lambda: eval_61()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m1 and cond_m7_m1, lambda: eval_61()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m7_m6, lambda: eval_138()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m6_m1 and cond_m7_m5, lambda: eval_138()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m6_m5 and cond_m7_m1, lambda: eval_99()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m7_m6, lambda: eval_138()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m6_0 and cond_m7_m5, lambda: eval_138()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m6_m5 and cond_m7_0, lambda: eval_100()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m4, lambda: eval_138()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m6_m4 and cond_m7_m1, lambda: eval_99()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m4, lambda: eval_138()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1 and cond_m6_m4 and cond_m7_0, lambda: eval_100()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4 and cond_m6_0 and cond_m7_m1, lambda: eval_99()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4 and cond_m6_m1 and cond_m7_0, lambda: eval_100()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m3, lambda: eval_136()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m3 and cond_m7_m1, lambda: eval_140()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m1 and cond_m7_m1, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m3, lambda: eval_136()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m3 and cond_m7_m1, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m3, lambda: eval_136()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m3 and cond_m7_0, lambda: eval_121()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3 and cond_m6_0 and cond_m7_m1, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3 and cond_m6_m1 and cond_m7_0, lambda: eval_121()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_121()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m7_m6, lambda: eval_138()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m6_m1 and cond_m7_m5, lambda: eval_138()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m1, lambda: eval_99()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m7_m6, lambda: eval_138()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m6_0 and cond_m7_m5, lambda: eval_138()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m6_m5 and cond_m7_0, lambda: eval_100()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m4, lambda: eval_138()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m1, lambda: eval_99()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m4, lambda: eval_138()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1 and cond_m6_m4 and cond_m7_0, lambda: eval_100()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m1, lambda: eval_99()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4 and cond_m6_m1 and cond_m7_0, lambda: eval_100()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m7_m6, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m6_0 and cond_m7_m5, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m6_m5 and cond_m7_0, lambda: eval_128()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m4, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0 and cond_m6_m4 and cond_m7_0, lambda: eval_128()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4 and cond_m6_0 and cond_m7_0, lambda: eval_128()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m3, lambda: eval_68()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m1, lambda: eval_71()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m3, lambda: eval_68()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m3 and cond_m7_0, lambda: eval_72()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m1, lambda: eval_71()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3 and cond_m6_m1 and cond_m7_0, lambda: eval_72()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_68()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_72()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_72()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_71()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_72()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_72()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_136()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_140()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_136()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_136()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_121()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_121()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_121()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_68()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_71()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_68()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_72()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_71()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_72()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_68()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_72()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_72()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_71()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_72()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_72()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_69()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_69()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_55()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_69()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_55()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_55()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_62()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m7_m1, lambda: eval_63()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_63()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_63()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_131()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m7_m1, lambda: eval_119()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_119()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_131()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m7_m1, lambda: eval_119()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_131()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m7_0, lambda: eval_101()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_119()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_101()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_119()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_119()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_101()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_116()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_116()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_116()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_102()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_131()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m7_m1, lambda: eval_119()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_119()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_131()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m7_m1, lambda: eval_119()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_131()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m7_0, lambda: eval_101()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_119()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_101()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_119()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_119()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_101()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m7_m1, lambda: eval_56()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m7_0, lambda: eval_57()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m6_0 and cond_m7_m1, lambda: eval_56()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m6_m1 and cond_m7_0, lambda: eval_57()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m7_0, lambda: eval_57()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m6_0 and cond_m7_0, lambda: eval_57()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_56()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_57()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_57()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_71()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_71()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_58()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_71()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_58()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_58()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_116()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_116()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_116()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_102()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_71()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_71()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_58()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_71()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_58()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_58()),
			(cond_m1_0 and cond_m2_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_59()),
			(cond_m1_0 and cond_m3_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_59()),
			(cond_m1_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_116()),
			(cond_m1_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_116()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m4, lambda: eval_116()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_0, lambda: eval_130()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m7_m6, lambda: eval_60()),
			(cond_m1_0 and cond_m2_0 and cond_m6_m4 and cond_m7_m5, lambda: eval_60()),
			(cond_m1_0 and cond_m2_0 and cond_m6_m5 and cond_m7_m4, lambda: eval_61()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m7_m6, lambda: eval_60()),
			(cond_m1_0 and cond_m3_0 and cond_m6_m4 and cond_m7_m5, lambda: eval_60()),
			(cond_m1_0 and cond_m3_0 and cond_m6_m5 and cond_m7_m4, lambda: eval_61()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m7_m6, lambda: eval_140()),
			(cond_m1_0 and cond_m4_0 and cond_m6_m3 and cond_m7_m5, lambda: eval_140()),
			(cond_m1_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m3, lambda: eval_136()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m7_m6, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_0 and cond_m7_m5, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_m5 and cond_m7_0, lambda: eval_136()),
			(cond_m1_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m4, lambda: eval_140()),
			(cond_m1_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m3, lambda: eval_136()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m4, lambda: eval_140()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_m4 and cond_m7_0, lambda: eval_136()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m3, lambda: eval_136()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_m3 and cond_m7_0, lambda: eval_136()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m6_m4, lambda: eval_62()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m7_m4, lambda: eval_63()),
			(cond_m1_0 and cond_m2_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_63()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m4, lambda: eval_62()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m7_m4, lambda: eval_63()),
			(cond_m1_0 and cond_m3_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_63()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m3, lambda: eval_136()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m7_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m4_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m3, lambda: eval_136()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m7_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_0, lambda: eval_136()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m7_0, lambda: eval_118()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_118()),
			(cond_m1_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_118()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m7_m6, lambda: eval_74()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m7_m6, lambda: eval_74()),
			(cond_m1_0 and cond_m2_0 and cond_m6_m3 and cond_m7_m5, lambda: eval_74()),
			(cond_m1_0 and cond_m2_0 and cond_m6_m5 and cond_m7_m3, lambda: eval_75()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m7_m6, lambda: eval_74()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m7_m6, lambda: eval_74()),
			(cond_m1_0 and cond_m3_0 and cond_m6_m2 and cond_m7_m5, lambda: eval_74()),
			(cond_m1_0 and cond_m3_0 and cond_m6_m5 and cond_m7_m2, lambda: eval_75()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m7_m6, lambda: eval_138()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m7_m6, lambda: eval_138()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_0 and cond_m7_m5, lambda: eval_138()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_m5 and cond_m7_0, lambda: eval_131()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m7_m6, lambda: eval_140()),
			(cond_m1_0 and cond_m4_0 and cond_m6_m2 and cond_m7_m5, lambda: eval_140()),
			(cond_m1_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m2, lambda: eval_136()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m7_m6, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_0 and cond_m7_m5, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_m5 and cond_m7_0, lambda: eval_136()),
			(cond_m1_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m4, lambda: eval_140()),
			(cond_m1_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m2, lambda: eval_136()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m4, lambda: eval_140()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_m4 and cond_m7_0, lambda: eval_136()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m2, lambda: eval_136()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_m2 and cond_m7_0, lambda: eval_136()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m6_m5, lambda: eval_75()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m7_m5, lambda: eval_76()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m6_m4, lambda: eval_75()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m7_m4, lambda: eval_76()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m6_m3, lambda: eval_75()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m7_m3, lambda: eval_77()),
			(cond_m1_0 and cond_m2_0 and cond_m6_m3 and cond_m7_m4, lambda: eval_76()),
			(cond_m1_0 and cond_m2_0 and cond_m6_m4 and cond_m7_m3, lambda: eval_77()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m6_m5, lambda: eval_75()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m7_m5, lambda: eval_76()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m6_m4, lambda: eval_75()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m7_m4, lambda: eval_76()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m2, lambda: eval_75()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m7_m2, lambda: eval_77()),
			(cond_m1_0 and cond_m3_0 and cond_m6_m2 and cond_m7_m4, lambda: eval_76()),
			(cond_m1_0 and cond_m3_0 and cond_m6_m4 and cond_m7_m2, lambda: eval_77()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m6_m5, lambda: eval_131()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m7_m5, lambda: eval_138()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m6_m4, lambda: eval_131()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m7_m4, lambda: eval_138()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m6_0, lambda: eval_131()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m7_0, lambda: eval_132()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_0 and cond_m7_m4, lambda: eval_138()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_m4 and cond_m7_0, lambda: eval_132()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m7_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m7_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m4_0 and cond_m6_m2 and cond_m7_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m4_0 and cond_m6_m3 and cond_m7_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m7_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m6_0, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m7_0, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_0 and cond_m7_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_m3 and cond_m7_0, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m7_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m6_0, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m7_0, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_0 and cond_m7_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_m2 and cond_m7_0, lambda: eval_140()),
			(cond_m1_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_m3 and cond_m7_0, lambda: eval_140()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_m2 and cond_m7_0, lambda: eval_140()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_m3, lambda: eval_77()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m6_m3, lambda: eval_77()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m7_m3, lambda: eval_78()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m6_m3, lambda: eval_77()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m7_m3, lambda: eval_78()),
			(cond_m1_0 and cond_m2_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_78()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_m2, lambda: eval_77()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m6_m2, lambda: eval_77()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m7_m2, lambda: eval_78()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m6_m2, lambda: eval_77()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m7_m2, lambda: eval_78()),
			(cond_m1_0 and cond_m3_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_78()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_m2, lambda: eval_138()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m6_m2, lambda: eval_138()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m7_m2, lambda: eval_119()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_0, lambda: eval_138()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m6_0, lambda: eval_138()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m7_0, lambda: eval_120()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m6_m2, lambda: eval_138()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m7_m2, lambda: eval_119()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m6_0, lambda: eval_138()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m7_0, lambda: eval_120()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_119()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_120()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m2, lambda: eval_136()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m7_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m4_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m2, lambda: eval_136()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m7_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_0, lambda: eval_136()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m7_0, lambda: eval_121()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_121()),
			(cond_m1_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_121()),
			(cond_m2_0 and cond_m3_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_59()),
			(cond_m2_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_116()),
			(cond_m2_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_116()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m4, lambda: eval_116()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_0, lambda: eval_130()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m7_m6, lambda: eval_60()),
			(cond_m2_0 and cond_m3_0 and cond_m6_m4 and cond_m7_m5, lambda: eval_60()),
			(cond_m2_0 and cond_m3_0 and cond_m6_m5 and cond_m7_m4, lambda: eval_61()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m7_m6, lambda: eval_140()),
			(cond_m2_0 and cond_m4_0 and cond_m6_m3 and cond_m7_m5, lambda: eval_140()),
			(cond_m2_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m3, lambda: eval_136()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m7_m6, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_0 and cond_m7_m5, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_m5 and cond_m7_0, lambda: eval_136()),
			(cond_m2_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m4, lambda: eval_140()),
			(cond_m2_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m3, lambda: eval_136()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m4, lambda: eval_140()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_m4 and cond_m7_0, lambda: eval_136()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m3, lambda: eval_136()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_m3 and cond_m7_0, lambda: eval_136()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m4, lambda: eval_62()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m7_m4, lambda: eval_63()),
			(cond_m2_0 and cond_m3_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_63()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m3, lambda: eval_136()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m7_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m4_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m3, lambda: eval_136()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m7_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_0, lambda: eval_136()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m7_0, lambda: eval_118()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_118()),
			(cond_m2_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_118()),
			(cond_m3_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_116()),
			(cond_m3_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_116()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m4, lambda: eval_116()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_0, lambda: eval_130()),
			(cond_m4_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_79()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_79()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_64()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_79()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_64()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_64()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m7_m6, lambda: eval_140()),
			(cond_m3_0 and cond_m4_0 and cond_m6_m2 and cond_m7_m5, lambda: eval_140()),
			(cond_m3_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m2, lambda: eval_136()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m7_m6, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_0 and cond_m7_m5, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_m5 and cond_m7_0, lambda: eval_136()),
			(cond_m3_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m4, lambda: eval_140()),
			(cond_m3_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m2, lambda: eval_136()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m4, lambda: eval_140()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_m4 and cond_m7_0, lambda: eval_136()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m2, lambda: eval_136()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_m2 and cond_m7_0, lambda: eval_136()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m7_m6, lambda: eval_80()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_0 and cond_m7_m5, lambda: eval_80()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_m5 and cond_m7_0, lambda: eval_131()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m4, lambda: eval_80()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_m4 and cond_m7_0, lambda: eval_131()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_0 and cond_m7_0, lambda: eval_131()),
			(cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m3, lambda: eval_79()),
			(cond_m4_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m2, lambda: eval_81()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m3, lambda: eval_79()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_m3 and cond_m7_0, lambda: eval_140()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m2, lambda: eval_81()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_m2 and cond_m7_0, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_79()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_81()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_140()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m2, lambda: eval_136()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m7_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m4_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m2, lambda: eval_136()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m7_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_0, lambda: eval_136()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m7_0, lambda: eval_118()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_118()),
			(cond_m3_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_118()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_m2, lambda: eval_80()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m7_m2, lambda: eval_65()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_0, lambda: eval_80()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m7_0, lambda: eval_66()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_0 and cond_m7_m2, lambda: eval_65()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_m2 and cond_m7_0, lambda: eval_66()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_0, lambda: eval_80()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m7_0, lambda: eval_66()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_0 and cond_m7_0, lambda: eval_66()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_65()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_66()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_66()),
			(cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_81()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_81()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_67()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_81()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_67()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_67()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m7_m6, lambda: eval_74()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m7_m6, lambda: eval_74()),
			(cond_m2_0 and cond_m3_0 and cond_m6_m1 and cond_m7_m5, lambda: eval_74()),
			(cond_m2_0 and cond_m3_0 and cond_m6_m5 and cond_m7_m1, lambda: eval_75()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m7_m6, lambda: eval_138()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m7_m6, lambda: eval_138()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_0 and cond_m7_m5, lambda: eval_138()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_m5 and cond_m7_0, lambda: eval_131()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m7_m6, lambda: eval_140()),
			(cond_m2_0 and cond_m4_0 and cond_m6_m1 and cond_m7_m5, lambda: eval_140()),
			(cond_m2_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m1, lambda: eval_136()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m7_m6, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_0 and cond_m7_m5, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_m5 and cond_m7_0, lambda: eval_136()),
			(cond_m2_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m4, lambda: eval_140()),
			(cond_m2_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m1, lambda: eval_136()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m4, lambda: eval_140()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_m4 and cond_m7_0, lambda: eval_136()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m1, lambda: eval_136()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_m1 and cond_m7_0, lambda: eval_136()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m7_m6, lambda: eval_138()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m7_m6, lambda: eval_138()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_0 and cond_m7_m5, lambda: eval_138()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_m5 and cond_m7_0, lambda: eval_131()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m6_m5, lambda: eval_75()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m7_m5, lambda: eval_76()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m6_m4, lambda: eval_75()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m7_m4, lambda: eval_76()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m1, lambda: eval_75()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m7_m1, lambda: eval_77()),
			(cond_m2_0 and cond_m3_0 and cond_m6_m1 and cond_m7_m4, lambda: eval_76()),
			(cond_m2_0 and cond_m3_0 and cond_m6_m4 and cond_m7_m1, lambda: eval_77()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m6_m5, lambda: eval_131()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m7_m5, lambda: eval_138()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m6_m4, lambda: eval_131()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m7_m4, lambda: eval_138()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4 and cond_m6_0, lambda: eval_131()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4 and cond_m7_0, lambda: eval_132()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_0 and cond_m7_m4, lambda: eval_138()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_m4 and cond_m7_0, lambda: eval_132()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m7_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m1, lambda: eval_140()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m7_m1, lambda: eval_140()),
			(cond_m2_0 and cond_m4_0 and cond_m6_m1 and cond_m7_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m4_0 and cond_m6_m3 and cond_m7_m1, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m7_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3 and cond_m6_0, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3 and cond_m7_0, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_0 and cond_m7_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_m3 and cond_m7_0, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m1, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m7_m1, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1 and cond_m6_0, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1 and cond_m7_0, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_0 and cond_m7_m1, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_m1 and cond_m7_0, lambda: eval_140()),
			(cond_m2_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m1, lambda: eval_140()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_m3 and cond_m7_0, lambda: eval_140()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m1, lambda: eval_140()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_m1 and cond_m7_0, lambda: eval_140()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m6_m5, lambda: eval_131()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m7_m5, lambda: eval_138()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m6_m4, lambda: eval_131()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m7_m4, lambda: eval_138()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4 and cond_m6_0, lambda: eval_131()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4 and cond_m7_0, lambda: eval_132()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_0 and cond_m7_m4, lambda: eval_138()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_m4 and cond_m7_0, lambda: eval_132()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m7_m6, lambda: eval_82()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_0 and cond_m7_m5, lambda: eval_82()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_m5 and cond_m7_0, lambda: eval_133()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m7_m6, lambda: eval_140()),
			(cond_m3_0 and cond_m4_0 and cond_m6_m1 and cond_m7_m5, lambda: eval_140()),
			(cond_m3_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m1, lambda: eval_136()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m7_m6, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_0 and cond_m7_m5, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_m5 and cond_m7_0, lambda: eval_136()),
			(cond_m3_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m4, lambda: eval_140()),
			(cond_m3_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m1, lambda: eval_136()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m4, lambda: eval_140()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_m4 and cond_m7_0, lambda: eval_136()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m1, lambda: eval_136()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_m1 and cond_m7_0, lambda: eval_136()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m7_m6, lambda: eval_82()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_0 and cond_m7_m5, lambda: eval_82()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_m5 and cond_m7_0, lambda: eval_133()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m4, lambda: eval_82()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_m4 and cond_m7_0, lambda: eval_133()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_0 and cond_m7_0, lambda: eval_133()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m4, lambda: eval_82()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_m4 and cond_m7_0, lambda: eval_133()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_0 and cond_m7_0, lambda: eval_133()),
			(cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m3, lambda: eval_79()),
			(cond_m4_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m1, lambda: eval_83()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m3, lambda: eval_79()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_m3 and cond_m7_0, lambda: eval_140()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m1, lambda: eval_83()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_m1 and cond_m7_0, lambda: eval_140()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_79()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_140()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_83()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_140()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m3, lambda: eval_82()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m7_m3, lambda: eval_68()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3 and cond_m6_0, lambda: eval_82()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3 and cond_m7_0, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_0 and cond_m7_m3, lambda: eval_68()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_m3 and cond_m7_0, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0 and cond_m6_0, lambda: eval_82()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0 and cond_m7_0, lambda: eval_139()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m7_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m1, lambda: eval_140()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m7_m1, lambda: eval_140()),
			(cond_m3_0 and cond_m4_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m4_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m7_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2 and cond_m6_0, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2 and cond_m7_0, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m1, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m7_m1, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1 and cond_m6_0, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1 and cond_m7_0, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_140()),
			(cond_m3_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_140()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_140()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_140()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_140()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m2, lambda: eval_82()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m7_m2, lambda: eval_68()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2 and cond_m6_0, lambda: eval_82()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2 and cond_m7_0, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_0 and cond_m7_m2, lambda: eval_68()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_m2 and cond_m7_0, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0 and cond_m6_0, lambda: eval_82()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0 and cond_m7_0, lambda: eval_139()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_80()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m7_m1, lambda: eval_69()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_80()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1 and cond_m7_0, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_0 and cond_m7_m1, lambda: eval_69()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_m1 and cond_m7_0, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_80()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0 and cond_m7_0, lambda: eval_138()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_0 and cond_m7_0, lambda: eval_139()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_68()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_139()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_0 and cond_m7_0, lambda: eval_139()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_68()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_139()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_139()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_0 and cond_m7_0, lambda: eval_138()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_69()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_138()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_138()),
			(cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_81()),
			(cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_83()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_81()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_140()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_83()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_140()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_81()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_140()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_83()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_140()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_m1, lambda: eval_77()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m6_m1, lambda: eval_77()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m7_m1, lambda: eval_78()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_77()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m7_m1, lambda: eval_78()),
			(cond_m2_0 and cond_m3_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_78()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_m1, lambda: eval_138()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m6_m1, lambda: eval_138()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m7_m1, lambda: eval_119()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_0, lambda: eval_138()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m6_0, lambda: eval_138()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m7_0, lambda: eval_120()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_138()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m7_m1, lambda: eval_119()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_138()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1 and cond_m7_0, lambda: eval_120()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_119()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_120()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_136()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m7_m1, lambda: eval_140()),
			(cond_m2_0 and cond_m4_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_136()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m7_m1, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_136()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1 and cond_m7_0, lambda: eval_121()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_121()),
			(cond_m2_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_140()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_140()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_121()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_m1, lambda: eval_138()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m6_m1, lambda: eval_138()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m7_m1, lambda: eval_119()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_0, lambda: eval_138()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m6_0, lambda: eval_138()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m7_0, lambda: eval_120()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m6_m1, lambda: eval_138()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m7_m1, lambda: eval_119()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1 and cond_m6_0, lambda: eval_138()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1 and cond_m7_0, lambda: eval_120()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_0 and cond_m7_m1, lambda: eval_119()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_m1 and cond_m7_0, lambda: eval_120()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_0, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m6_0, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m7_0, lambda: eval_135()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0 and cond_m6_0, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0 and cond_m7_0, lambda: eval_135()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_82()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m7_m1, lambda: eval_71()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_82()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1 and cond_m7_0, lambda: eval_72()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_0 and cond_m7_m1, lambda: eval_71()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_m1 and cond_m7_0, lambda: eval_72()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_82()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0 and cond_m7_0, lambda: eval_72()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_136()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m7_m1, lambda: eval_140()),
			(cond_m3_0 and cond_m4_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_136()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m7_m1, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_136()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m7_0, lambda: eval_121()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_121()),
			(cond_m3_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_140()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_140()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_121()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_82()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m7_m1, lambda: eval_71()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_82()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m7_0, lambda: eval_72()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_0 and cond_m7_m1, lambda: eval_71()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_m1 and cond_m7_0, lambda: eval_72()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_82()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m7_0, lambda: eval_72()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_0 and cond_m7_0, lambda: eval_135()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_0 and cond_m7_0, lambda: eval_72()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_71()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_72()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_72()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_0 and cond_m7_0, lambda: eval_72()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_71()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_72()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_72()),
			(cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_83()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_83()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_73()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_83()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_73()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_73()),
			(cond_m1_0 and cond_m2_0 and cond_m7_m6, lambda: eval_74()),
			(cond_m1_0 and cond_m3_0 and cond_m7_m6, lambda: eval_74()),
			(cond_m1_0 and cond_m4_0 and cond_m7_m6, lambda: eval_140()),
			(cond_m1_0 and cond_m5_0 and cond_m7_m6, lambda: eval_140()),
			(cond_m1_0 and cond_m6_0 and cond_m7_m5, lambda: eval_140()),
			(cond_m1_0 and cond_m6_m5 and cond_m7_0, lambda: eval_136()),
			(cond_m1_0 and cond_m2_0 and cond_m6_m5, lambda: eval_75()),
			(cond_m1_0 and cond_m2_0 and cond_m7_m5, lambda: eval_76()),
			(cond_m1_0 and cond_m3_0 and cond_m6_m5, lambda: eval_75()),
			(cond_m1_0 and cond_m3_0 and cond_m7_m5, lambda: eval_76()),
			(cond_m1_0 and cond_m4_0 and cond_m6_m5, lambda: eval_136()),
			(cond_m1_0 and cond_m4_0 and cond_m7_m5, lambda: eval_140()),
			(cond_m1_0 and cond_m5_0 and cond_m6_m4, lambda: eval_136()),
			(cond_m1_0 and cond_m5_0 and cond_m7_m4, lambda: eval_140()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_0, lambda: eval_136()),
			(cond_m1_0 and cond_m5_m4 and cond_m7_0, lambda: eval_137()),
			(cond_m1_0 and cond_m6_0 and cond_m7_m4, lambda: eval_140()),
			(cond_m1_0 and cond_m6_m4 and cond_m7_0, lambda: eval_137()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4, lambda: eval_77()),
			(cond_m1_0 and cond_m2_0 and cond_m6_m4, lambda: eval_77()),
			(cond_m1_0 and cond_m2_0 and cond_m7_m4, lambda: eval_78()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4, lambda: eval_77()),
			(cond_m1_0 and cond_m3_0 and cond_m6_m4, lambda: eval_77()),
			(cond_m1_0 and cond_m3_0 and cond_m7_m4, lambda: eval_78()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m4_0 and cond_m6_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m4_0 and cond_m7_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_0, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m3 and cond_m7_0, lambda: eval_140()),
			(cond_m1_0 and cond_m5_0 and cond_m6_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m5_0 and cond_m7_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_0, lambda: eval_140()),
			(cond_m1_0 and cond_m5_m3 and cond_m7_0, lambda: eval_140()),
			(cond_m1_0 and cond_m6_0 and cond_m7_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m6_m3 and cond_m7_0, lambda: eval_140()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3, lambda: eval_139()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3, lambda: eval_139()),
			(cond_m1_0 and cond_m2_0 and cond_m6_m3, lambda: eval_139()),
			(cond_m1_0 and cond_m2_0 and cond_m7_m3, lambda: eval_139()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2, lambda: eval_139()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2, lambda: eval_139()),
			(cond_m1_0 and cond_m3_0 and cond_m6_m2, lambda: eval_139()),
			(cond_m1_0 and cond_m3_0 and cond_m7_m2, lambda: eval_139()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0, lambda: eval_138()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0, lambda: eval_138()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_0, lambda: eval_138()),
			(cond_m1_0 and cond_m3_m2 and cond_m7_0, lambda: eval_138()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m4_0 and cond_m6_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m4_0 and cond_m7_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_0, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m2 and cond_m7_0, lambda: eval_140()),
			(cond_m1_0 and cond_m5_0 and cond_m6_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m5_0 and cond_m7_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_0, lambda: eval_140()),
			(cond_m1_0 and cond_m5_m2 and cond_m7_0, lambda: eval_140()),
			(cond_m1_0 and cond_m6_0 and cond_m7_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m6_m2 and cond_m7_0, lambda: eval_140()),
			(cond_m2_0 and cond_m3_0 and cond_m7_m6, lambda: eval_74()),
			(cond_m2_0 and cond_m4_0 and cond_m7_m6, lambda: eval_140()),
			(cond_m2_0 and cond_m5_0 and cond_m7_m6, lambda: eval_140()),
			(cond_m2_0 and cond_m6_0 and cond_m7_m5, lambda: eval_140()),
			(cond_m2_0 and cond_m6_m5 and cond_m7_0, lambda: eval_136()),
			(cond_m2_0 and cond_m3_0 and cond_m6_m5, lambda: eval_75()),
			(cond_m2_0 and cond_m3_0 and cond_m7_m5, lambda: eval_76()),
			(cond_m2_0 and cond_m4_0 and cond_m6_m5, lambda: eval_136()),
			(cond_m2_0 and cond_m4_0 and cond_m7_m5, lambda: eval_140()),
			(cond_m2_0 and cond_m5_0 and cond_m6_m4, lambda: eval_136()),
			(cond_m2_0 and cond_m5_0 and cond_m7_m4, lambda: eval_140()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_0, lambda: eval_136()),
			(cond_m2_0 and cond_m5_m4 and cond_m7_0, lambda: eval_137()),
			(cond_m2_0 and cond_m6_0 and cond_m7_m4, lambda: eval_140()),
			(cond_m2_0 and cond_m6_m4 and cond_m7_0, lambda: eval_137()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4, lambda: eval_77()),
			(cond_m2_0 and cond_m3_0 and cond_m6_m4, lambda: eval_77()),
			(cond_m2_0 and cond_m3_0 and cond_m7_m4, lambda: eval_78()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m4_0 and cond_m6_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m4_0 and cond_m7_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_0, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m3 and cond_m7_0, lambda: eval_140()),
			(cond_m2_0 and cond_m5_0 and cond_m6_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m5_0 and cond_m7_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_0, lambda: eval_140()),
			(cond_m2_0 and cond_m5_m3 and cond_m7_0, lambda: eval_140()),
			(cond_m2_0 and cond_m6_0 and cond_m7_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m6_m3 and cond_m7_0, lambda: eval_140()),
			(cond_m3_0 and cond_m4_0 and cond_m7_m6, lambda: eval_140()),
			(cond_m3_0 and cond_m5_0 and cond_m7_m6, lambda: eval_140()),
			(cond_m3_0 and cond_m6_0 and cond_m7_m5, lambda: eval_140()),
			(cond_m3_0 and cond_m6_m5 and cond_m7_0, lambda: eval_136()),
			(cond_m3_0 and cond_m4_0 and cond_m6_m5, lambda: eval_136()),
			(cond_m3_0 and cond_m4_0 and cond_m7_m5, lambda: eval_140()),
			(cond_m3_0 and cond_m5_0 and cond_m6_m4, lambda: eval_136()),
			(cond_m3_0 and cond_m5_0 and cond_m7_m4, lambda: eval_140()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_0, lambda: eval_136()),
			(cond_m3_0 and cond_m5_m4 and cond_m7_0, lambda: eval_137()),
			(cond_m3_0 and cond_m6_0 and cond_m7_m4, lambda: eval_140()),
			(cond_m3_0 and cond_m6_m4 and cond_m7_0, lambda: eval_137()),
			(cond_m4_0 and cond_m5_0 and cond_m7_m6, lambda: eval_137()),
			(cond_m4_0 and cond_m6_0 and cond_m7_m5, lambda: eval_137()),
			(cond_m4_0 and cond_m6_m5 and cond_m7_0, lambda: eval_136()),
			(cond_m5_0 and cond_m6_0 and cond_m7_m4, lambda: eval_137()),
			(cond_m5_0 and cond_m6_m4 and cond_m7_0, lambda: eval_136()),
			(cond_m5_m4 and cond_m6_0 and cond_m7_0, lambda: eval_136()),
			(cond_m4_0 and cond_m5_0 and cond_m6_m3, lambda: eval_137()),
			(cond_m4_0 and cond_m5_0 and cond_m7_m3, lambda: eval_79()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_0, lambda: eval_137()),
			(cond_m4_0 and cond_m5_m3 and cond_m7_0, lambda: eval_140()),
			(cond_m4_0 and cond_m6_0 and cond_m7_m3, lambda: eval_79()),
			(cond_m4_0 and cond_m6_m3 and cond_m7_0, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_0, lambda: eval_137()),
			(cond_m4_m3 and cond_m5_0 and cond_m7_0, lambda: eval_140()),
			(cond_m4_m3 and cond_m6_0 and cond_m7_0, lambda: eval_140()),
			(cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_79()),
			(cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_140()),
			(cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_140()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m4_0 and cond_m6_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m4_0 and cond_m7_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_0, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m2 and cond_m7_0, lambda: eval_140()),
			(cond_m3_0 and cond_m5_0 and cond_m6_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m5_0 and cond_m7_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_0, lambda: eval_140()),
			(cond_m3_0 and cond_m5_m2 and cond_m7_0, lambda: eval_140()),
			(cond_m3_0 and cond_m6_0 and cond_m7_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m6_m2 and cond_m7_0, lambda: eval_140()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0, lambda: eval_80()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_0, lambda: eval_80()),
			(cond_m3_m2 and cond_m4_0 and cond_m7_0, lambda: eval_138()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_0, lambda: eval_80()),
			(cond_m3_m2 and cond_m5_0 and cond_m7_0, lambda: eval_138()),
			(cond_m4_0 and cond_m5_0 and cond_m6_m2, lambda: eval_137()),
			(cond_m4_0 and cond_m5_0 and cond_m7_m2, lambda: eval_81()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_0, lambda: eval_137()),
			(cond_m4_0 and cond_m5_m2 and cond_m7_0, lambda: eval_140()),
			(cond_m4_0 and cond_m6_0 and cond_m7_m2, lambda: eval_81()),
			(cond_m4_0 and cond_m6_m2 and cond_m7_0, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_0, lambda: eval_137()),
			(cond_m4_m2 and cond_m5_0 and cond_m7_0, lambda: eval_140()),
			(cond_m3_m2 and cond_m6_0 and cond_m7_0, lambda: eval_138()),
			(cond_m4_m2 and cond_m6_0 and cond_m7_0, lambda: eval_140()),
			(cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_81()),
			(cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_140()),
			(cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_140()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1, lambda: eval_139()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1, lambda: eval_139()),
			(cond_m2_0 and cond_m3_0 and cond_m6_m1, lambda: eval_139()),
			(cond_m2_0 and cond_m3_0 and cond_m7_m1, lambda: eval_139()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0, lambda: eval_138()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0, lambda: eval_138()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_0, lambda: eval_138()),
			(cond_m2_0 and cond_m3_m1 and cond_m7_0, lambda: eval_138()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1, lambda: eval_140()),
			(cond_m2_0 and cond_m4_0 and cond_m6_m1, lambda: eval_140()),
			(cond_m2_0 and cond_m4_0 and cond_m7_m1, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_0, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m1 and cond_m7_0, lambda: eval_140()),
			(cond_m2_0 and cond_m5_0 and cond_m6_m1, lambda: eval_140()),
			(cond_m2_0 and cond_m5_0 and cond_m7_m1, lambda: eval_140()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_0, lambda: eval_140()),
			(cond_m2_0 and cond_m5_m1 and cond_m7_0, lambda: eval_140()),
			(cond_m2_0 and cond_m6_0 and cond_m7_m1, lambda: eval_140()),
			(cond_m2_0 and cond_m6_m1 and cond_m7_0, lambda: eval_140()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0, lambda: eval_138()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0, lambda: eval_138()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_0, lambda: eval_138()),
			(cond_m2_m1 and cond_m3_0 and cond_m7_0, lambda: eval_138()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0, lambda: eval_82()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_0, lambda: eval_82()),
			(cond_m2_m1 and cond_m4_0 and cond_m7_0, lambda: eval_139()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1, lambda: eval_140()),
			(cond_m3_0 and cond_m4_0 and cond_m6_m1, lambda: eval_140()),
			(cond_m3_0 and cond_m4_0 and cond_m7_m1, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_0, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m1 and cond_m7_0, lambda: eval_140()),
			(cond_m3_0 and cond_m5_0 and cond_m6_m1, lambda: eval_140()),
			(cond_m3_0 and cond_m5_0 and cond_m7_m1, lambda: eval_140()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_0, lambda: eval_140()),
			(cond_m3_0 and cond_m5_m1 and cond_m7_0, lambda: eval_140()),
			(cond_m3_0 and cond_m6_0 and cond_m7_m1, lambda: eval_140()),
			(cond_m3_0 and cond_m6_m1 and cond_m7_0, lambda: eval_140()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0, lambda: eval_82()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_0, lambda: eval_82()),
			(cond_m3_m1 and cond_m4_0 and cond_m7_0, lambda: eval_139()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_0, lambda: eval_82()),
			(cond_m2_m1 and cond_m5_0 and cond_m7_0, lambda: eval_139()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_0, lambda: eval_82()),
			(cond_m3_m1 and cond_m5_0 and cond_m7_0, lambda: eval_139()),
			(cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_137()),
			(cond_m4_0 and cond_m5_0 and cond_m7_m1, lambda: eval_83()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_137()),
			(cond_m4_0 and cond_m5_m1 and cond_m7_0, lambda: eval_140()),
			(cond_m4_0 and cond_m6_0 and cond_m7_m1, lambda: eval_83()),
			(cond_m4_0 and cond_m6_m1 and cond_m7_0, lambda: eval_140()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_137()),
			(cond_m4_m1 and cond_m5_0 and cond_m7_0, lambda: eval_140()),
			(cond_m2_m1 and cond_m6_0 and cond_m7_0, lambda: eval_139()),
			(cond_m3_m1 and cond_m6_0 and cond_m7_0, lambda: eval_139()),
			(cond_m4_m1 and cond_m6_0 and cond_m7_0, lambda: eval_140()),
			(cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_83()),
			(cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_140()),
			(cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_140()),
			(cond_m1_0 and cond_m2_0, lambda: eval_139()),
			(cond_m1_0 and cond_m3_0, lambda: eval_139()),
			(cond_m1_0 and cond_m4_0, lambda: eval_140()),
			(cond_m1_0 and cond_m5_0, lambda: eval_140()),
			(cond_m1_0 and cond_m6_0, lambda: eval_140()),
			(cond_m1_0 and cond_m7_0, lambda: eval_140()),
			(cond_m2_0 and cond_m3_0, lambda: eval_139()),
			(cond_m2_0 and cond_m4_0, lambda: eval_140()),
			(cond_m2_0 and cond_m5_0, lambda: eval_140()),
			(cond_m2_0 and cond_m6_0, lambda: eval_140()),
			(cond_m2_0 and cond_m7_0, lambda: eval_140()),
			(cond_m3_0 and cond_m4_0, lambda: eval_140()),
			(cond_m3_0 and cond_m5_0, lambda: eval_140()),
			(cond_m3_0 and cond_m6_0, lambda: eval_140()),
			(cond_m3_0 and cond_m7_0, lambda: eval_140()),
			(cond_m4_0 and cond_m5_0, lambda: eval_137()),
			(cond_m4_0 and cond_m6_0, lambda: eval_137()),
			(cond_m4_0 and cond_m7_0, lambda: eval_140()),
			(cond_m5_0 and cond_m6_0, lambda: eval_137()),
			(cond_m5_0 and cond_m7_0, lambda: eval_140()),
			(cond_m6_0 and cond_m7_0, lambda: eval_140()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_86()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_86()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_86()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_91()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_91()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_91()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_84()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_96()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m6_m4 and cond_m7_m4, lambda: eval_86()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_116()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m6_m3 and cond_m7_m3, lambda: eval_116()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m2 and cond_m7_m3, lambda: eval_116()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3 and cond_m7_m2, lambda: eval_130()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m6_m5 and cond_m7_m5, lambda: eval_103()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m6_m4 and cond_m7_m4, lambda: eval_103()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m6_m2 and cond_m7_m4, lambda: eval_103()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m6_m4 and cond_m7_m2, lambda: eval_126()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m3 and cond_m7_m3, lambda: eval_137()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m6_m2 and cond_m7_m3, lambda: eval_137()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m6_m3 and cond_m7_m2, lambda: eval_136()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m6_m2 and cond_m7_m3, lambda: eval_137()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m6_m3 and cond_m7_m2, lambda: eval_136()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m2 and cond_m7_m2, lambda: eval_136()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m7_m6, lambda: eval_132()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m6_m2 and cond_m7_m5, lambda: eval_132()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m6_m5 and cond_m7_m2, lambda: eval_131()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_m4, lambda: eval_132()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m6_m4 and cond_m7_m2, lambda: eval_131()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m6_m2 and cond_m7_m2, lambda: eval_131()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_m3, lambda: eval_130()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m3 and cond_m7_m2, lambda: eval_117()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m6_m2 and cond_m7_m2, lambda: eval_117()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_117()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2, lambda: eval_126()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m7_m2, lambda: eval_104()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_104()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_104()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_96()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_96()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_96()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_99()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_99()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_99()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_85()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4 and cond_m6_m4 and cond_m7_m4, lambda: eval_86()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_116()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1 and cond_m6_m3 and cond_m7_m3, lambda: eval_116()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m1 and cond_m7_m3, lambda: eval_116()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3 and cond_m7_m1, lambda: eval_130()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m4, lambda: eval_86()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_133()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_133()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_133()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_87()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_116()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_116()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_116()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_130()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_133()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_133()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_133()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_87()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_119()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_119()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_131()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_119()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_119()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_88()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_119()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_131()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_119()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_88()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_131()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_88()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m6_m5 and cond_m7_m5, lambda: eval_103()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1 and cond_m6_m4 and cond_m7_m4, lambda: eval_103()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4 and cond_m6_m1 and cond_m7_m4, lambda: eval_103()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4 and cond_m6_m4 and cond_m7_m1, lambda: eval_126()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m3 and cond_m7_m3, lambda: eval_137()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3 and cond_m6_m1 and cond_m7_m3, lambda: eval_137()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3 and cond_m6_m3 and cond_m7_m1, lambda: eval_136()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1 and cond_m6_m1 and cond_m7_m3, lambda: eval_137()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1 and cond_m6_m3 and cond_m7_m1, lambda: eval_136()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m1 and cond_m7_m1, lambda: eval_136()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m6_m5 and cond_m7_m5, lambda: eval_103()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1 and cond_m6_m4 and cond_m7_m4, lambda: eval_103()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4 and cond_m6_m1 and cond_m7_m4, lambda: eval_103()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m1, lambda: eval_126()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_128()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_128()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4 and cond_m6_0 and cond_m7_m4, lambda: eval_128()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4 and cond_m6_m4 and cond_m7_0, lambda: eval_125()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m3 and cond_m7_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3 and cond_m6_m1 and cond_m7_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m1, lambda: eval_109()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_89()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0 and cond_m6_m1 and cond_m7_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0 and cond_m6_m3 and cond_m7_m1, lambda: eval_109()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1 and cond_m6_0 and cond_m7_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1 and cond_m6_m3 and cond_m7_0, lambda: eval_89()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3 and cond_m6_0 and cond_m7_m1, lambda: eval_109()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3 and cond_m6_m1 and cond_m7_0, lambda: eval_89()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_137()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_137()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_136()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_137()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_136()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_136()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_109()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_89()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_109()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_89()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_109()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_89()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_99()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_99()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_99()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_90()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_90()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_90()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m7_m6, lambda: eval_132()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m6_m1 and cond_m7_m5, lambda: eval_132()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m6_m5 and cond_m7_m1, lambda: eval_131()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m4, lambda: eval_132()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1 and cond_m6_m4 and cond_m7_m1, lambda: eval_131()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4 and cond_m6_m1 and cond_m7_m1, lambda: eval_131()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m3, lambda: eval_130()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m3 and cond_m7_m1, lambda: eval_117()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3 and cond_m6_m1 and cond_m7_m1, lambda: eval_117()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_117()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m7_m6, lambda: eval_132()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m6_m1 and cond_m7_m5, lambda: eval_132()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m6_m5 and cond_m7_m1, lambda: eval_131()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m4, lambda: eval_132()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1 and cond_m6_m4 and cond_m7_m1, lambda: eval_131()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4 and cond_m6_m1 and cond_m7_m1, lambda: eval_131()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m7_m6, lambda: eval_135()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m6_m1 and cond_m7_m5, lambda: eval_135()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m6_m5 and cond_m7_m1, lambda: eval_91()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m7_m6, lambda: eval_135()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m6_0 and cond_m7_m5, lambda: eval_135()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m6_m5 and cond_m7_0, lambda: eval_92()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m4, lambda: eval_135()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0 and cond_m6_m4 and cond_m7_m1, lambda: eval_91()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m4, lambda: eval_135()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1 and cond_m6_m4 and cond_m7_0, lambda: eval_92()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4 and cond_m6_0 and cond_m7_m1, lambda: eval_91()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4 and cond_m6_m1 and cond_m7_0, lambda: eval_92()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m3, lambda: eval_133()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m3 and cond_m7_m1, lambda: eval_122()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3 and cond_m6_m1 and cond_m7_m1, lambda: eval_122()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m3, lambda: eval_133()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m3 and cond_m7_m1, lambda: eval_122()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m3, lambda: eval_133()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m3 and cond_m7_0, lambda: eval_114()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3 and cond_m6_0 and cond_m7_m1, lambda: eval_122()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3 and cond_m6_m1 and cond_m7_0, lambda: eval_114()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_122()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_122()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_114()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_130()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_117()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_117()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_117()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_133()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_122()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_122()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_133()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_122()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_133()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_114()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_122()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_114()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_122()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_122()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_114()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_131()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_131()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_131()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_93()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_126()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m7_m1, lambda: eval_104()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_104()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_104()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_96()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_126()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m7_m1, lambda: eval_104()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_104()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_104()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_128()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m7_m1, lambda: eval_112()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_112()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_128()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m7_m1, lambda: eval_112()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_128()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m7_0, lambda: eval_94()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_112()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_94()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_112()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_112()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_94()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_109()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_109()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_109()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_95()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_96()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_109()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_109()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_109()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_95()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m4, lambda: eval_96()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_m5 and cond_m7_m5, lambda: eval_116()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_m4 and cond_m7_m4, lambda: eval_116()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_m3 and cond_m7_m4, lambda: eval_116()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m3, lambda: eval_130()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m7_m6, lambda: eval_137()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_m3 and cond_m7_m5, lambda: eval_137()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_m5 and cond_m7_m3, lambda: eval_136()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m4, lambda: eval_137()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_m4 and cond_m7_m3, lambda: eval_136()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_m3 and cond_m7_m3, lambda: eval_136()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3, lambda: eval_130()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m7_m3, lambda: eval_117()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_117()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_117()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_m5 and cond_m7_m5, lambda: eval_103()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_m5 and cond_m7_m5, lambda: eval_116()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_m4 and cond_m7_m4, lambda: eval_116()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_m2 and cond_m7_m4, lambda: eval_116()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m2, lambda: eval_130()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m7_m6, lambda: eval_132()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_m4 and cond_m7_m5, lambda: eval_132()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_m5 and cond_m7_m4, lambda: eval_131()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m7_m6, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_m3 and cond_m7_m5, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_m5 and cond_m7_m3, lambda: eval_136()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m7_m6, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_m2 and cond_m7_m5, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_m5 and cond_m7_m2, lambda: eval_136()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_m3 and cond_m7_m4, lambda: eval_140()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_m4 and cond_m7_m3, lambda: eval_136()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_m2 and cond_m7_m4, lambda: eval_140()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_m4 and cond_m7_m2, lambda: eval_136()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_m2 and cond_m7_m3, lambda: eval_136()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_m3 and cond_m7_m2, lambda: eval_136()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m6_m4, lambda: eval_126()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m7_m4, lambda: eval_104()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_m4 and cond_m7_m4, lambda: eval_104()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m6_m3, lambda: eval_136()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m7_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_m3 and cond_m7_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m6_m3, lambda: eval_136()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m7_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m2, lambda: eval_136()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m7_m2, lambda: eval_137()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_m2 and cond_m7_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_m3 and cond_m7_m2, lambda: eval_137()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_m3 and cond_m7_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_m2 and cond_m7_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m2, lambda: eval_137()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m7_m6, lambda: eval_138()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m7_m6, lambda: eval_138()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_m2 and cond_m7_m5, lambda: eval_138()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_m5 and cond_m7_m2, lambda: eval_131()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m7_m6, lambda: eval_137()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_m2 and cond_m7_m5, lambda: eval_137()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_m5 and cond_m7_m2, lambda: eval_136()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m4, lambda: eval_137()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_m4 and cond_m7_m2, lambda: eval_136()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_m2 and cond_m7_m2, lambda: eval_136()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m6_m5, lambda: eval_131()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m7_m5, lambda: eval_138()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m6_m4, lambda: eval_131()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m7_m4, lambda: eval_138()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m6_m2, lambda: eval_131()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m7_m2, lambda: eval_132()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_m2 and cond_m7_m4, lambda: eval_138()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_m4 and cond_m7_m2, lambda: eval_132()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m3, lambda: eval_137()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m7_m3, lambda: eval_137()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m6_m2, lambda: eval_137()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m7_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_m2 and cond_m7_m3, lambda: eval_137()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_m3 and cond_m7_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m6_m2, lambda: eval_137()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m7_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_m2 and cond_m7_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m3, lambda: eval_137()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_m3 and cond_m7_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_m2 and cond_m7_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_m2, lambda: eval_132()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m6_m2, lambda: eval_132()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m7_m2, lambda: eval_138()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m6_m2, lambda: eval_132()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m7_m2, lambda: eval_138()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_138()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2, lambda: eval_130()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m7_m2, lambda: eval_117()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_117()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_117()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m4, lambda: eval_96()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_m5 and cond_m7_m5, lambda: eval_116()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_m4 and cond_m7_m4, lambda: eval_116()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_m3 and cond_m7_m4, lambda: eval_116()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m3, lambda: eval_130()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m7_m6, lambda: eval_137()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_m3 and cond_m7_m5, lambda: eval_137()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_m5 and cond_m7_m3, lambda: eval_136()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m4, lambda: eval_137()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_m4 and cond_m7_m3, lambda: eval_136()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_m3 and cond_m7_m3, lambda: eval_136()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3, lambda: eval_130()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m7_m3, lambda: eval_117()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_117()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_117()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m4, lambda: eval_96()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_136()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_136()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_136()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_97()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_m5 and cond_m7_m5, lambda: eval_116()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_m4 and cond_m7_m4, lambda: eval_116()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_m2 and cond_m7_m4, lambda: eval_116()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m2, lambda: eval_130()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_131()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_131()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_0 and cond_m7_m4, lambda: eval_131()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_m4 and cond_m7_0, lambda: eval_126()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_m3 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_m2 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m2, lambda: eval_136()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_98()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_m2 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_m3 and cond_m7_m2, lambda: eval_136()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_0 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_m3 and cond_m7_0, lambda: eval_98()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_0 and cond_m7_m2, lambda: eval_136()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_m2 and cond_m7_0, lambda: eval_98()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m7_m6, lambda: eval_137()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_m2 and cond_m7_m5, lambda: eval_137()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_m5 and cond_m7_m2, lambda: eval_136()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m4, lambda: eval_137()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_m4 and cond_m7_m2, lambda: eval_136()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_m2 and cond_m7_m2, lambda: eval_136()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m7_m6, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_m2 and cond_m7_m5, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_m5 and cond_m7_m2, lambda: eval_99()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m7_m6, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_0 and cond_m7_m5, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_m5 and cond_m7_0, lambda: eval_100()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m4, lambda: eval_138()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_m4 and cond_m7_m2, lambda: eval_99()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m4, lambda: eval_138()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_m4 and cond_m7_0, lambda: eval_100()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_0 and cond_m7_m2, lambda: eval_99()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_m2 and cond_m7_0, lambda: eval_100()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m3, lambda: eval_136()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_m3 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_m2 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m3, lambda: eval_136()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_m3 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m3, lambda: eval_136()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_m3 and cond_m7_0, lambda: eval_121()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_0 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_m2 and cond_m7_0, lambda: eval_121()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_121()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2, lambda: eval_130()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m7_m2, lambda: eval_117()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_117()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_117()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_m2, lambda: eval_131()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m7_m2, lambda: eval_119()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_119()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_m2, lambda: eval_131()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m7_m2, lambda: eval_119()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_0, lambda: eval_131()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m7_0, lambda: eval_101()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_119()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_101()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_119()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_119()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_101()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_136()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_136()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_136()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_102()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_m5 and cond_m7_m5, lambda: eval_103()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_m5 and cond_m7_m5, lambda: eval_116()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_m4 and cond_m7_m4, lambda: eval_116()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_m1 and cond_m7_m4, lambda: eval_116()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m1, lambda: eval_130()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_103()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4 and cond_m7_m6, lambda: eval_132()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_m4 and cond_m7_m5, lambda: eval_132()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_m5 and cond_m7_m4, lambda: eval_131()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3 and cond_m7_m6, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_m3 and cond_m7_m5, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_m5 and cond_m7_m3, lambda: eval_136()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1 and cond_m7_m6, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_m1 and cond_m7_m5, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_m5 and cond_m7_m1, lambda: eval_136()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_m3 and cond_m7_m4, lambda: eval_140()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_m4 and cond_m7_m3, lambda: eval_136()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_m1 and cond_m7_m4, lambda: eval_140()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_m4 and cond_m7_m1, lambda: eval_136()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_m1 and cond_m7_m3, lambda: eval_136()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_m3 and cond_m7_m1, lambda: eval_136()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4 and cond_m7_m6, lambda: eval_132()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_m4 and cond_m7_m5, lambda: eval_132()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_m5 and cond_m7_m4, lambda: eval_131()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4 and cond_m6_m4, lambda: eval_126()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4 and cond_m7_m4, lambda: eval_104()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_m4 and cond_m7_m4, lambda: eval_104()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3 and cond_m6_m3, lambda: eval_136()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3 and cond_m7_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_m3 and cond_m7_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1 and cond_m6_m3, lambda: eval_136()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1 and cond_m7_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m1, lambda: eval_136()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m7_m1, lambda: eval_137()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_m1 and cond_m7_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_m3 and cond_m7_m1, lambda: eval_137()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_m3 and cond_m7_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_m1 and cond_m7_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m1, lambda: eval_137()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4 and cond_m6_m4, lambda: eval_126()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4 and cond_m7_m4, lambda: eval_104()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_104()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_133()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_m5 and cond_m7_m5, lambda: eval_116()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_m4 and cond_m7_m4, lambda: eval_116()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_m1 and cond_m7_m4, lambda: eval_116()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m1, lambda: eval_130()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_133()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_133()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_0 and cond_m7_m4, lambda: eval_133()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_m4 and cond_m7_0, lambda: eval_127()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_133()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_0 and cond_m7_m4, lambda: eval_133()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_m4 and cond_m7_0, lambda: eval_127()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_m3 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_m1 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m1, lambda: eval_136()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_105()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_m1 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_m3 and cond_m7_m1, lambda: eval_136()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_0 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_m3 and cond_m7_0, lambda: eval_105()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_0 and cond_m7_m1, lambda: eval_136()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_m1 and cond_m7_0, lambda: eval_105()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3 and cond_m7_m6, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_m3 and cond_m7_m5, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_m5 and cond_m7_m3, lambda: eval_133()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0 and cond_m7_m6, lambda: eval_139()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2 and cond_m7_m6, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_m2 and cond_m7_m5, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_m5 and cond_m7_m2, lambda: eval_136()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1 and cond_m7_m6, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_m1 and cond_m7_m5, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_m5 and cond_m7_m1, lambda: eval_136()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_m2 and cond_m7_m4, lambda: eval_140()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_m4 and cond_m7_m2, lambda: eval_136()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_m1 and cond_m7_m4, lambda: eval_140()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_m4 and cond_m7_m1, lambda: eval_136()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_m1 and cond_m7_m2, lambda: eval_136()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_m2 and cond_m7_m1, lambda: eval_136()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2 and cond_m7_m6, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_m2 and cond_m7_m5, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_m5 and cond_m7_m2, lambda: eval_133()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0 and cond_m7_m6, lambda: eval_139()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1 and cond_m7_m6, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_m1 and cond_m7_m5, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_m5 and cond_m7_m1, lambda: eval_131()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0 and cond_m7_m6, lambda: eval_138()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_0 and cond_m7_m5, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_m5 and cond_m7_0, lambda: eval_133()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_m3 and cond_m7_m4, lambda: eval_139()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_m4 and cond_m7_m3, lambda: eval_133()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_0 and cond_m7_m4, lambda: eval_139()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_m4 and cond_m7_0, lambda: eval_133()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_0 and cond_m7_m3, lambda: eval_133()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_m3 and cond_m7_0, lambda: eval_133()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_0 and cond_m7_m5, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_m5 and cond_m7_0, lambda: eval_133()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_m2 and cond_m7_m4, lambda: eval_139()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_m4 and cond_m7_m2, lambda: eval_133()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_0 and cond_m7_m4, lambda: eval_139()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_m4 and cond_m7_0, lambda: eval_133()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_0 and cond_m7_m2, lambda: eval_133()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_m2 and cond_m7_0, lambda: eval_133()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_0 and cond_m7_m5, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_m5 and cond_m7_0, lambda: eval_131()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_m1 and cond_m7_m4, lambda: eval_138()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_m4 and cond_m7_m1, lambda: eval_131()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_0 and cond_m7_m4, lambda: eval_138()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_m4 and cond_m7_0, lambda: eval_131()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_0 and cond_m7_m1, lambda: eval_131()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_m1 and cond_m7_0, lambda: eval_131()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_m2 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_m3 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_m1 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_m3 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_m1 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_m2 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_m2 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_m3 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_0 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_m3 and cond_m7_0, lambda: eval_140()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_0 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_m2 and cond_m7_0, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_m1 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_m3 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_0 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_m3 and cond_m7_0, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_0 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_m1 and cond_m7_0, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_140()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3 and cond_m6_m3, lambda: eval_133()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3 and cond_m7_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0 and cond_m6_m3, lambda: eval_133()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0 and cond_m7_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3 and cond_m6_0, lambda: eval_133()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2 and cond_m6_m2, lambda: eval_136()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2 and cond_m7_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1 and cond_m6_m2, lambda: eval_136()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1 and cond_m7_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m1, lambda: eval_136()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m7_m1, lambda: eval_137()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_137()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_137()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2 and cond_m6_m2, lambda: eval_133()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2 and cond_m7_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0 and cond_m6_m2, lambda: eval_133()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0 and cond_m7_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2 and cond_m6_0, lambda: eval_133()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1 and cond_m6_m2, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1 and cond_m7_m2, lambda: eval_119()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_m1, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m7_m1, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_119()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0 and cond_m6_m2, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0 and cond_m7_m2, lambda: eval_119()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2 and cond_m6_0, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_m1, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m7_m1, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1 and cond_m6_0, lambda: eval_138()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3 and cond_m7_0, lambda: eval_106()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_106()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_106()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2 and cond_m7_0, lambda: eval_106()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_106()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_106()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2 and cond_m7_0, lambda: eval_107()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_119()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_107()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1 and cond_m7_0, lambda: eval_107()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_107()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_119()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_138()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_119()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_107()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_138()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_107()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_136()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_108()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_136()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_108()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_136()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_108()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m7_m6, lambda: eval_138()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1 and cond_m7_m6, lambda: eval_138()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_m1 and cond_m7_m5, lambda: eval_138()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_m5 and cond_m7_m1, lambda: eval_131()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1 and cond_m7_m6, lambda: eval_137()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_m1 and cond_m7_m5, lambda: eval_137()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_m5 and cond_m7_m1, lambda: eval_136()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m4, lambda: eval_137()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_m4 and cond_m7_m1, lambda: eval_136()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_m1 and cond_m7_m1, lambda: eval_136()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m7_m6, lambda: eval_138()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1 and cond_m7_m6, lambda: eval_138()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_m1 and cond_m7_m5, lambda: eval_138()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_m5 and cond_m7_m1, lambda: eval_131()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m7_m6, lambda: eval_135()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m6_m5, lambda: eval_131()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m7_m5, lambda: eval_138()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1 and cond_m6_m4, lambda: eval_131()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1 and cond_m7_m4, lambda: eval_138()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4 and cond_m6_m1, lambda: eval_131()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4 and cond_m7_m1, lambda: eval_132()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_m1 and cond_m7_m4, lambda: eval_138()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_m4 and cond_m7_m1, lambda: eval_132()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m3, lambda: eval_137()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1 and cond_m7_m3, lambda: eval_137()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3 and cond_m6_m1, lambda: eval_137()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3 and cond_m7_m1, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_m1 and cond_m7_m3, lambda: eval_137()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_m3 and cond_m7_m1, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1 and cond_m6_m1, lambda: eval_137()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1 and cond_m7_m1, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_m1 and cond_m7_m1, lambda: eval_140()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m3, lambda: eval_137()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_m3 and cond_m7_m1, lambda: eval_140()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_m1 and cond_m7_m1, lambda: eval_140()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m6_m5, lambda: eval_131()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m7_m5, lambda: eval_138()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1 and cond_m6_m4, lambda: eval_131()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1 and cond_m7_m4, lambda: eval_138()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4 and cond_m6_m1, lambda: eval_131()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4 and cond_m7_m1, lambda: eval_132()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_m1 and cond_m7_m4, lambda: eval_138()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_m4 and cond_m7_m1, lambda: eval_132()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m6_m5, lambda: eval_128()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m7_m5, lambda: eval_135()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0 and cond_m7_m6, lambda: eval_135()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1 and cond_m7_m6, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_m1 and cond_m7_m5, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_m5 and cond_m7_m1, lambda: eval_109()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0 and cond_m7_m6, lambda: eval_139()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m7_m6, lambda: eval_137()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_m1 and cond_m7_m5, lambda: eval_137()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_m5 and cond_m7_m1, lambda: eval_136()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m4, lambda: eval_137()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_m4 and cond_m7_m1, lambda: eval_136()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_m1 and cond_m7_m1, lambda: eval_136()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m7_m6, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_m1 and cond_m7_m5, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_m5 and cond_m7_m1, lambda: eval_109()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m7_m6, lambda: eval_139()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_0 and cond_m7_m5, lambda: eval_135()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_m5 and cond_m7_0, lambda: eval_128()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_0 and cond_m7_m5, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_m5 and cond_m7_0, lambda: eval_110()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m4, lambda: eval_139()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_m4 and cond_m7_m1, lambda: eval_109()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m4, lambda: eval_139()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_m4 and cond_m7_0, lambda: eval_110()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_0 and cond_m7_m1, lambda: eval_109()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_m1 and cond_m7_0, lambda: eval_110()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_0 and cond_m7_m5, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_m5 and cond_m7_0, lambda: eval_110()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m4, lambda: eval_139()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_m4 and cond_m7_m1, lambda: eval_109()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m4, lambda: eval_139()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_m4 and cond_m7_0, lambda: eval_110()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_0 and cond_m7_m1, lambda: eval_109()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_m1 and cond_m7_0, lambda: eval_110()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m3, lambda: eval_136()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_m3 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_m1 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m3, lambda: eval_136()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_m3 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m3, lambda: eval_136()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_m3 and cond_m7_0, lambda: eval_124()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_0 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_m1 and cond_m7_0, lambda: eval_124()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_124()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0 and cond_m6_m4, lambda: eval_128()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0 and cond_m7_m4, lambda: eval_135()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4 and cond_m6_0, lambda: eval_128()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1 and cond_m7_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3 and cond_m6_m1, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3 and cond_m7_m1, lambda: eval_122()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_m1 and cond_m7_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_m3 and cond_m7_m1, lambda: eval_122()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0 and cond_m7_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3 and cond_m6_0, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0 and cond_m6_m1, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0 and cond_m7_m1, lambda: eval_122()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1 and cond_m6_0, lambda: eval_139()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m2, lambda: eval_137()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m7_m2, lambda: eval_137()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2 and cond_m6_m1, lambda: eval_137()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2 and cond_m7_m1, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_137()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1 and cond_m6_m1, lambda: eval_137()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1 and cond_m7_m1, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_140()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_137()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_140()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_140()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m7_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2 and cond_m6_m1, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2 and cond_m7_m1, lambda: eval_122()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_122()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m7_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2 and cond_m6_0, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0 and cond_m6_m1, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0 and cond_m7_m1, lambda: eval_122()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1 and cond_m6_0, lambda: eval_139()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_131()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1 and cond_m7_m1, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_131()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0 and cond_m7_m1, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_131()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4 and cond_m7_0, lambda: eval_129()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_0 and cond_m7_m4, lambda: eval_135()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_m4 and cond_m7_0, lambda: eval_129()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3 and cond_m7_0, lambda: eval_123()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_0 and cond_m7_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_m3 and cond_m7_0, lambda: eval_123()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1 and cond_m7_0, lambda: eval_123()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_0 and cond_m7_m1, lambda: eval_122()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_m1 and cond_m7_0, lambda: eval_123()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_m3 and cond_m7_m1, lambda: eval_122()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_m3 and cond_m7_0, lambda: eval_123()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_0 and cond_m7_m1, lambda: eval_122()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_m1 and cond_m7_0, lambda: eval_123()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2 and cond_m7_0, lambda: eval_123()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_123()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1 and cond_m7_0, lambda: eval_123()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_122()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_123()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_122()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_123()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_122()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_123()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1 and cond_m7_0, lambda: eval_111()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_111()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_138()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_138()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_111()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_136()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_136()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_136()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_124()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_124()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_124()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1, lambda: eval_132()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m6_m1, lambda: eval_132()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m7_m1, lambda: eval_138()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_132()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1 and cond_m7_m1, lambda: eval_138()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_138()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_130()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1 and cond_m7_m1, lambda: eval_117()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_117()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_117()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_m1, lambda: eval_132()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m6_m1, lambda: eval_132()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m7_m1, lambda: eval_138()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_132()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1 and cond_m7_m1, lambda: eval_138()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_138()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_m1, lambda: eval_135()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m6_m1, lambda: eval_135()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m7_m1, lambda: eval_112()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_0, lambda: eval_135()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m6_0, lambda: eval_135()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_135()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0 and cond_m7_m1, lambda: eval_112()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_135()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_133()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1 and cond_m7_m1, lambda: eval_122()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_122()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_133()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0 and cond_m7_m1, lambda: eval_122()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_133()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_130()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m7_m1, lambda: eval_117()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_117()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_117()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_133()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m7_m1, lambda: eval_122()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_122()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_133()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m7_m1, lambda: eval_122()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_133()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m7_0, lambda: eval_113()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1 and cond_m7_0, lambda: eval_113()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_112()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_113()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1 and cond_m7_0, lambda: eval_114()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_122()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_114()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_122()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_122()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_114()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m7_0, lambda: eval_114()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_122()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_114()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_122()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_122()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_114()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_136()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_136()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_136()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_115()),
			(cond_m1_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_116()),
			(cond_m1_0 and cond_m5_m4 and cond_m7_m6, lambda: eval_137()),
			(cond_m1_0 and cond_m6_m4 and cond_m7_m5, lambda: eval_137()),
			(cond_m1_0 and cond_m6_m5 and cond_m7_m4, lambda: eval_136()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_m4, lambda: eval_130()),
			(cond_m1_0 and cond_m5_m4 and cond_m7_m4, lambda: eval_117()),
			(cond_m1_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_117()),
			(cond_m1_0 and cond_m4_m3 and cond_m7_m6, lambda: eval_140()),
			(cond_m1_0 and cond_m5_m3 and cond_m7_m6, lambda: eval_140()),
			(cond_m1_0 and cond_m6_m3 and cond_m7_m5, lambda: eval_140()),
			(cond_m1_0 and cond_m6_m5 and cond_m7_m3, lambda: eval_136()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_m5, lambda: eval_136()),
			(cond_m1_0 and cond_m4_m3 and cond_m7_m5, lambda: eval_140()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_m4, lambda: eval_136()),
			(cond_m1_0 and cond_m5_m3 and cond_m7_m4, lambda: eval_140()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_m3, lambda: eval_136()),
			(cond_m1_0 and cond_m5_m4 and cond_m7_m3, lambda: eval_137()),
			(cond_m1_0 and cond_m6_m3 and cond_m7_m4, lambda: eval_140()),
			(cond_m1_0 and cond_m6_m4 and cond_m7_m3, lambda: eval_137()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3, lambda: eval_137()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_m3, lambda: eval_137()),
			(cond_m1_0 and cond_m4_m3 and cond_m7_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_m3, lambda: eval_137()),
			(cond_m1_0 and cond_m5_m3 and cond_m7_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m3_m2 and cond_m7_m6, lambda: eval_138()),
			(cond_m1_0 and cond_m4_m2 and cond_m7_m6, lambda: eval_140()),
			(cond_m1_0 and cond_m5_m2 and cond_m7_m6, lambda: eval_140()),
			(cond_m1_0 and cond_m6_m2 and cond_m7_m5, lambda: eval_140()),
			(cond_m1_0 and cond_m6_m5 and cond_m7_m2, lambda: eval_136()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_m5, lambda: eval_131()),
			(cond_m1_0 and cond_m3_m2 and cond_m7_m5, lambda: eval_138()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_m5, lambda: eval_136()),
			(cond_m1_0 and cond_m4_m2 and cond_m7_m5, lambda: eval_140()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_m4, lambda: eval_136()),
			(cond_m1_0 and cond_m5_m2 and cond_m7_m4, lambda: eval_140()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_m2, lambda: eval_136()),
			(cond_m1_0 and cond_m5_m4 and cond_m7_m2, lambda: eval_137()),
			(cond_m1_0 and cond_m6_m2 and cond_m7_m4, lambda: eval_140()),
			(cond_m1_0 and cond_m6_m4 and cond_m7_m2, lambda: eval_137()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4, lambda: eval_132()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_m4, lambda: eval_132()),
			(cond_m1_0 and cond_m3_m2 and cond_m7_m4, lambda: eval_138()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m2 and cond_m7_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m3 and cond_m7_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m5_m2 and cond_m7_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m5_m3 and cond_m7_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m6_m2 and cond_m7_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m6_m3 and cond_m7_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2, lambda: eval_138()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2, lambda: eval_138()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_m2, lambda: eval_138()),
			(cond_m1_0 and cond_m3_m2 and cond_m7_m2, lambda: eval_138()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2, lambda: eval_137()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_m2, lambda: eval_137()),
			(cond_m1_0 and cond_m4_m2 and cond_m7_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_m2, lambda: eval_137()),
			(cond_m1_0 and cond_m5_m2 and cond_m7_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_140()),
			(cond_m2_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_116()),
			(cond_m2_0 and cond_m5_m4 and cond_m7_m6, lambda: eval_137()),
			(cond_m2_0 and cond_m6_m4 and cond_m7_m5, lambda: eval_137()),
			(cond_m2_0 and cond_m6_m5 and cond_m7_m4, lambda: eval_136()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_m4, lambda: eval_130()),
			(cond_m2_0 and cond_m5_m4 and cond_m7_m4, lambda: eval_117()),
			(cond_m2_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_117()),
			(cond_m2_0 and cond_m4_m3 and cond_m7_m6, lambda: eval_140()),
			(cond_m2_0 and cond_m5_m3 and cond_m7_m6, lambda: eval_140()),
			(cond_m2_0 and cond_m6_m3 and cond_m7_m5, lambda: eval_140()),
			(cond_m2_0 and cond_m6_m5 and cond_m7_m3, lambda: eval_136()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_m5, lambda: eval_136()),
			(cond_m2_0 and cond_m4_m3 and cond_m7_m5, lambda: eval_140()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_m4, lambda: eval_136()),
			(cond_m2_0 and cond_m5_m3 and cond_m7_m4, lambda: eval_140()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_m3, lambda: eval_136()),
			(cond_m2_0 and cond_m5_m4 and cond_m7_m3, lambda: eval_137()),
			(cond_m2_0 and cond_m6_m3 and cond_m7_m4, lambda: eval_140()),
			(cond_m2_0 and cond_m6_m4 and cond_m7_m3, lambda: eval_137()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3, lambda: eval_137()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_m3, lambda: eval_137()),
			(cond_m2_0 and cond_m4_m3 and cond_m7_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_m3, lambda: eval_137()),
			(cond_m2_0 and cond_m5_m3 and cond_m7_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_140()),
			(cond_m3_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_116()),
			(cond_m3_0 and cond_m5_m4 and cond_m7_m6, lambda: eval_137()),
			(cond_m3_0 and cond_m6_m4 and cond_m7_m5, lambda: eval_137()),
			(cond_m3_0 and cond_m6_m5 and cond_m7_m4, lambda: eval_136()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_m4, lambda: eval_130()),
			(cond_m3_0 and cond_m5_m4 and cond_m7_m4, lambda: eval_117()),
			(cond_m3_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_117()),
			(cond_m4_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_136()),
			(cond_m5_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_136()),
			(cond_m5_m4 and cond_m6_0 and cond_m7_m4, lambda: eval_136()),
			(cond_m5_m4 and cond_m6_m4 and cond_m7_0, lambda: eval_130()),
			(cond_m4_0 and cond_m5_m3 and cond_m7_m6, lambda: eval_140()),
			(cond_m4_0 and cond_m6_m3 and cond_m7_m5, lambda: eval_140()),
			(cond_m4_0 and cond_m6_m5 and cond_m7_m3, lambda: eval_136()),
			(cond_m4_m3 and cond_m5_0 and cond_m7_m6, lambda: eval_140()),
			(cond_m4_m3 and cond_m6_0 and cond_m7_m5, lambda: eval_140()),
			(cond_m4_m3 and cond_m6_m5 and cond_m7_0, lambda: eval_136()),
			(cond_m5_0 and cond_m6_m3 and cond_m7_m4, lambda: eval_140()),
			(cond_m5_0 and cond_m6_m4 and cond_m7_m3, lambda: eval_136()),
			(cond_m5_m3 and cond_m6_0 and cond_m7_m4, lambda: eval_140()),
			(cond_m5_m3 and cond_m6_m4 and cond_m7_0, lambda: eval_136()),
			(cond_m5_m4 and cond_m6_0 and cond_m7_m3, lambda: eval_136()),
			(cond_m5_m4 and cond_m6_m3 and cond_m7_0, lambda: eval_136()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_m3, lambda: eval_136()),
			(cond_m4_0 and cond_m5_m3 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_m3, lambda: eval_136()),
			(cond_m4_m3 and cond_m5_0 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_0, lambda: eval_136()),
			(cond_m4_m3 and cond_m5_m3 and cond_m7_0, lambda: eval_118()),
			(cond_m4_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_118()),
			(cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_140()),
			(cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_140()),
			(cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_118()),
			(cond_m3_0 and cond_m4_m2 and cond_m7_m6, lambda: eval_140()),
			(cond_m3_0 and cond_m5_m2 and cond_m7_m6, lambda: eval_140()),
			(cond_m3_0 and cond_m6_m2 and cond_m7_m5, lambda: eval_140()),
			(cond_m3_0 and cond_m6_m5 and cond_m7_m2, lambda: eval_136()),
			(cond_m3_m2 and cond_m4_0 and cond_m7_m6, lambda: eval_138()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_m5, lambda: eval_136()),
			(cond_m3_0 and cond_m4_m2 and cond_m7_m5, lambda: eval_140()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_m4, lambda: eval_136()),
			(cond_m3_0 and cond_m5_m2 and cond_m7_m4, lambda: eval_140()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_m2, lambda: eval_136()),
			(cond_m3_0 and cond_m5_m4 and cond_m7_m2, lambda: eval_137()),
			(cond_m3_0 and cond_m6_m2 and cond_m7_m4, lambda: eval_140()),
			(cond_m3_0 and cond_m6_m4 and cond_m7_m2, lambda: eval_137()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_m5, lambda: eval_131()),
			(cond_m3_m2 and cond_m4_0 and cond_m7_m5, lambda: eval_138()),
			(cond_m3_m2 and cond_m5_0 and cond_m7_m6, lambda: eval_138()),
			(cond_m4_0 and cond_m5_m2 and cond_m7_m6, lambda: eval_140()),
			(cond_m4_0 and cond_m6_m2 and cond_m7_m5, lambda: eval_140()),
			(cond_m4_0 and cond_m6_m5 and cond_m7_m2, lambda: eval_136()),
			(cond_m4_m2 and cond_m5_0 and cond_m7_m6, lambda: eval_140()),
			(cond_m3_m2 and cond_m6_0 and cond_m7_m5, lambda: eval_138()),
			(cond_m3_m2 and cond_m6_m5 and cond_m7_0, lambda: eval_131()),
			(cond_m4_m2 and cond_m6_0 and cond_m7_m5, lambda: eval_140()),
			(cond_m4_m2 and cond_m6_m5 and cond_m7_0, lambda: eval_136()),
			(cond_m5_0 and cond_m6_m2 and cond_m7_m4, lambda: eval_140()),
			(cond_m5_0 and cond_m6_m4 and cond_m7_m2, lambda: eval_136()),
			(cond_m5_m2 and cond_m6_0 and cond_m7_m4, lambda: eval_140()),
			(cond_m5_m2 and cond_m6_m4 and cond_m7_0, lambda: eval_136()),
			(cond_m5_m4 and cond_m6_0 and cond_m7_m2, lambda: eval_136()),
			(cond_m5_m4 and cond_m6_m2 and cond_m7_0, lambda: eval_136()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_m4, lambda: eval_131()),
			(cond_m3_m2 and cond_m5_0 and cond_m7_m4, lambda: eval_138()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_0, lambda: eval_131()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_m3, lambda: eval_140()),
			(cond_m4_0 and cond_m5_m2 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_m2, lambda: eval_140()),
			(cond_m4_0 and cond_m5_m3 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_0 and cond_m6_m2 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_0 and cond_m6_m3 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_m3, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_0 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_0, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_m2, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_0 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_0, lambda: eval_140()),
			(cond_m3_m2 and cond_m5_m4 and cond_m7_0, lambda: eval_132()),
			(cond_m3_m2 and cond_m6_0 and cond_m7_m4, lambda: eval_138()),
			(cond_m3_m2 and cond_m6_m4 and cond_m7_0, lambda: eval_132()),
			(cond_m4_m2 and cond_m5_m3 and cond_m7_0, lambda: eval_140()),
			(cond_m4_m2 and cond_m6_0 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_m2 and cond_m6_m3 and cond_m7_0, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_m2 and cond_m7_0, lambda: eval_140()),
			(cond_m4_m3 and cond_m6_0 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_m3 and cond_m6_m2 and cond_m7_0, lambda: eval_140()),
			(cond_m5_0 and cond_m6_m2 and cond_m7_m3, lambda: eval_140()),
			(cond_m5_0 and cond_m6_m3 and cond_m7_m2, lambda: eval_140()),
			(cond_m5_m2 and cond_m6_0 and cond_m7_m3, lambda: eval_140()),
			(cond_m5_m2 and cond_m6_m3 and cond_m7_0, lambda: eval_140()),
			(cond_m5_m3 and cond_m6_0 and cond_m7_m2, lambda: eval_140()),
			(cond_m5_m3 and cond_m6_m2 and cond_m7_0, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2, lambda: eval_137()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_m2, lambda: eval_137()),
			(cond_m3_0 and cond_m4_m2 and cond_m7_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_m2, lambda: eval_137()),
			(cond_m3_0 and cond_m5_m2 and cond_m7_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_140()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_m2, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_0 and cond_m7_m2, lambda: eval_119()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_0, lambda: eval_138()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_m2, lambda: eval_138()),
			(cond_m3_m2 and cond_m5_0 and cond_m7_m2, lambda: eval_119()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_0, lambda: eval_138()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_m2, lambda: eval_136()),
			(cond_m4_0 and cond_m5_m2 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_m2, lambda: eval_136()),
			(cond_m4_m2 and cond_m5_0 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_0, lambda: eval_136()),
			(cond_m3_m2 and cond_m4_m2 and cond_m7_0, lambda: eval_120()),
			(cond_m3_m2 and cond_m5_m2 and cond_m7_0, lambda: eval_120()),
			(cond_m3_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_119()),
			(cond_m3_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_120()),
			(cond_m4_m2 and cond_m5_m2 and cond_m7_0, lambda: eval_121()),
			(cond_m4_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_121()),
			(cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_140()),
			(cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_140()),
			(cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_121()),
			(cond_m2_0 and cond_m3_m1 and cond_m7_m6, lambda: eval_138()),
			(cond_m2_0 and cond_m4_m1 and cond_m7_m6, lambda: eval_140()),
			(cond_m2_0 and cond_m5_m1 and cond_m7_m6, lambda: eval_140()),
			(cond_m2_0 and cond_m6_m1 and cond_m7_m5, lambda: eval_140()),
			(cond_m2_0 and cond_m6_m5 and cond_m7_m1, lambda: eval_136()),
			(cond_m2_m1 and cond_m3_0 and cond_m7_m6, lambda: eval_138()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_m5, lambda: eval_131()),
			(cond_m2_0 and cond_m3_m1 and cond_m7_m5, lambda: eval_138()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_m5, lambda: eval_136()),
			(cond_m2_0 and cond_m4_m1 and cond_m7_m5, lambda: eval_140()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_m4, lambda: eval_136()),
			(cond_m2_0 and cond_m5_m1 and cond_m7_m4, lambda: eval_140()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_m1, lambda: eval_136()),
			(cond_m2_0 and cond_m5_m4 and cond_m7_m1, lambda: eval_137()),
			(cond_m2_0 and cond_m6_m1 and cond_m7_m4, lambda: eval_140()),
			(cond_m2_0 and cond_m6_m4 and cond_m7_m1, lambda: eval_137()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_m5, lambda: eval_131()),
			(cond_m2_m1 and cond_m3_0 and cond_m7_m5, lambda: eval_138()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4, lambda: eval_132()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_m4, lambda: eval_132()),
			(cond_m2_0 and cond_m3_m1 and cond_m7_m4, lambda: eval_138()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m1 and cond_m7_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_m1, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m3 and cond_m7_m1, lambda: eval_140()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m5_m1 and cond_m7_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_m1, lambda: eval_140()),
			(cond_m2_0 and cond_m5_m3 and cond_m7_m1, lambda: eval_140()),
			(cond_m2_0 and cond_m6_m1 and cond_m7_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m6_m3 and cond_m7_m1, lambda: eval_140()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4, lambda: eval_132()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_m4, lambda: eval_132()),
			(cond_m2_m1 and cond_m3_0 and cond_m7_m4, lambda: eval_138()),
			(cond_m2_m1 and cond_m4_0 and cond_m7_m6, lambda: eval_139()),
			(cond_m3_0 and cond_m4_m1 and cond_m7_m6, lambda: eval_140()),
			(cond_m3_0 and cond_m5_m1 and cond_m7_m6, lambda: eval_140()),
			(cond_m3_0 and cond_m6_m1 and cond_m7_m5, lambda: eval_140()),
			(cond_m3_0 and cond_m6_m5 and cond_m7_m1, lambda: eval_136()),
			(cond_m3_m1 and cond_m4_0 and cond_m7_m6, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_m5, lambda: eval_133()),
			(cond_m2_m1 and cond_m4_0 and cond_m7_m5, lambda: eval_139()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_m5, lambda: eval_136()),
			(cond_m3_0 and cond_m4_m1 and cond_m7_m5, lambda: eval_140()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_m4, lambda: eval_136()),
			(cond_m3_0 and cond_m5_m1 and cond_m7_m4, lambda: eval_140()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_m1, lambda: eval_136()),
			(cond_m3_0 and cond_m5_m4 and cond_m7_m1, lambda: eval_137()),
			(cond_m3_0 and cond_m6_m1 and cond_m7_m4, lambda: eval_140()),
			(cond_m3_0 and cond_m6_m4 and cond_m7_m1, lambda: eval_137()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_m5, lambda: eval_133()),
			(cond_m3_m1 and cond_m4_0 and cond_m7_m5, lambda: eval_139()),
			(cond_m2_m1 and cond_m5_0 and cond_m7_m6, lambda: eval_139()),
			(cond_m3_m1 and cond_m5_0 and cond_m7_m6, lambda: eval_139()),
			(cond_m4_0 and cond_m5_m1 and cond_m7_m6, lambda: eval_140()),
			(cond_m4_0 and cond_m6_m1 and cond_m7_m5, lambda: eval_140()),
			(cond_m4_0 and cond_m6_m5 and cond_m7_m1, lambda: eval_136()),
			(cond_m4_m1 and cond_m5_0 and cond_m7_m6, lambda: eval_140()),
			(cond_m2_m1 and cond_m6_0 and cond_m7_m5, lambda: eval_139()),
			(cond_m2_m1 and cond_m6_m5 and cond_m7_0, lambda: eval_133()),
			(cond_m3_m1 and cond_m6_0 and cond_m7_m5, lambda: eval_139()),
			(cond_m3_m1 and cond_m6_m5 and cond_m7_0, lambda: eval_133()),
			(cond_m4_m1 and cond_m6_0 and cond_m7_m5, lambda: eval_140()),
			(cond_m4_m1 and cond_m6_m5 and cond_m7_0, lambda: eval_136()),
			(cond_m5_0 and cond_m6_m1 and cond_m7_m4, lambda: eval_140()),
			(cond_m5_0 and cond_m6_m4 and cond_m7_m1, lambda: eval_136()),
			(cond_m5_m1 and cond_m6_0 and cond_m7_m4, lambda: eval_140()),
			(cond_m5_m1 and cond_m6_m4 and cond_m7_0, lambda: eval_136()),
			(cond_m5_m4 and cond_m6_0 and cond_m7_m1, lambda: eval_136()),
			(cond_m5_m4 and cond_m6_m1 and cond_m7_0, lambda: eval_136()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_m4, lambda: eval_133()),
			(cond_m2_m1 and cond_m5_0 and cond_m7_m4, lambda: eval_139()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_0, lambda: eval_133()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_m4, lambda: eval_133()),
			(cond_m3_m1 and cond_m5_0 and cond_m7_m4, lambda: eval_139()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_0, lambda: eval_133()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_m3, lambda: eval_140()),
			(cond_m4_0 and cond_m5_m1 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_m1, lambda: eval_140()),
			(cond_m4_0 and cond_m5_m3 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_0 and cond_m6_m1 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_0 and cond_m6_m3 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_m3, lambda: eval_140()),
			(cond_m4_m1 and cond_m5_0 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_0, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_m1, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_0 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_0, lambda: eval_140()),
			(cond_m2_m1 and cond_m5_m4 and cond_m7_0, lambda: eval_134()),
			(cond_m2_m1 and cond_m6_0 and cond_m7_m4, lambda: eval_139()),
			(cond_m2_m1 and cond_m6_m4 and cond_m7_0, lambda: eval_134()),
			(cond_m3_m1 and cond_m5_m4 and cond_m7_0, lambda: eval_134()),
			(cond_m3_m1 and cond_m6_0 and cond_m7_m4, lambda: eval_139()),
			(cond_m3_m1 and cond_m6_m4 and cond_m7_0, lambda: eval_134()),
			(cond_m4_m1 and cond_m5_m3 and cond_m7_0, lambda: eval_140()),
			(cond_m4_m1 and cond_m6_0 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_m1 and cond_m6_m3 and cond_m7_0, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_m1 and cond_m7_0, lambda: eval_140()),
			(cond_m4_m3 and cond_m6_0 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_m3 and cond_m6_m1 and cond_m7_0, lambda: eval_140()),
			(cond_m5_0 and cond_m6_m1 and cond_m7_m3, lambda: eval_140()),
			(cond_m5_0 and cond_m6_m3 and cond_m7_m1, lambda: eval_140()),
			(cond_m5_m1 and cond_m6_0 and cond_m7_m3, lambda: eval_140()),
			(cond_m5_m1 and cond_m6_m3 and cond_m7_0, lambda: eval_140()),
			(cond_m5_m3 and cond_m6_0 and cond_m7_m1, lambda: eval_140()),
			(cond_m5_m3 and cond_m6_m1 and cond_m7_0, lambda: eval_140()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_0 and cond_m7_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0, lambda: eval_139()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m1 and cond_m7_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_m1, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m2 and cond_m7_m1, lambda: eval_140()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m5_m1 and cond_m7_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_m1, lambda: eval_140()),
			(cond_m3_0 and cond_m5_m2 and cond_m7_m1, lambda: eval_140()),
			(cond_m3_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_140()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_0 and cond_m7_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0, lambda: eval_139()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_m1, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_0 and cond_m7_m1, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0, lambda: eval_138()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_0, lambda: eval_139()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m5_0 and cond_m7_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_0, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_0, lambda: eval_139()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m5_0 and cond_m7_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_0, lambda: eval_139()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_0, lambda: eval_138()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_m1, lambda: eval_138()),
			(cond_m3_m2 and cond_m5_0 and cond_m7_m1, lambda: eval_138()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_0, lambda: eval_138()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_m2, lambda: eval_140()),
			(cond_m4_0 and cond_m5_m1 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_m1, lambda: eval_140()),
			(cond_m4_0 and cond_m5_m2 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_m2, lambda: eval_140()),
			(cond_m4_m1 and cond_m5_0 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_0, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_m1, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_0 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_0, lambda: eval_140()),
			(cond_m2_m1 and cond_m4_m3 and cond_m7_0, lambda: eval_139()),
			(cond_m2_m1 and cond_m5_m3 and cond_m7_0, lambda: eval_139()),
			(cond_m2_m1 and cond_m6_0 and cond_m7_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m6_m3 and cond_m7_0, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_m2 and cond_m7_0, lambda: eval_139()),
			(cond_m3_m1 and cond_m5_m2 and cond_m7_0, lambda: eval_139()),
			(cond_m3_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_139()),
			(cond_m3_m2 and cond_m4_m1 and cond_m7_0, lambda: eval_138()),
			(cond_m3_m2 and cond_m5_m1 and cond_m7_0, lambda: eval_138()),
			(cond_m3_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_138()),
			(cond_m3_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_138()),
			(cond_m4_m1 and cond_m5_m2 and cond_m7_0, lambda: eval_140()),
			(cond_m4_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_m1 and cond_m7_0, lambda: eval_140()),
			(cond_m4_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_140()),
			(cond_m5_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_140()),
			(cond_m5_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_140()),
			(cond_m5_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_140()),
			(cond_m5_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_140()),
			(cond_m5_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_140()),
			(cond_m5_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_140()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1, lambda: eval_138()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1, lambda: eval_138()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_m1, lambda: eval_138()),
			(cond_m2_0 and cond_m3_m1 and cond_m7_m1, lambda: eval_138()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1, lambda: eval_137()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_m1, lambda: eval_137()),
			(cond_m2_0 and cond_m4_m1 and cond_m7_m1, lambda: eval_140()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_137()),
			(cond_m2_0 and cond_m5_m1 and cond_m7_m1, lambda: eval_140()),
			(cond_m2_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_140()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1, lambda: eval_138()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1, lambda: eval_138()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_m1, lambda: eval_138()),
			(cond_m2_m1 and cond_m3_0 and cond_m7_m1, lambda: eval_138()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0, lambda: eval_135()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0, lambda: eval_135()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_m1, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_0 and cond_m7_m1, lambda: eval_122()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0, lambda: eval_139()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1, lambda: eval_137()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_m1, lambda: eval_137()),
			(cond_m3_0 and cond_m4_m1 and cond_m7_m1, lambda: eval_140()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_137()),
			(cond_m3_0 and cond_m5_m1 and cond_m7_m1, lambda: eval_140()),
			(cond_m3_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_140()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_m1, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_0 and cond_m7_m1, lambda: eval_122()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0, lambda: eval_139()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_0, lambda: eval_135()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_0, lambda: eval_139()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_139()),
			(cond_m2_m1 and cond_m5_0 and cond_m7_m1, lambda: eval_122()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_0, lambda: eval_139()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_139()),
			(cond_m3_m1 and cond_m5_0 and cond_m7_m1, lambda: eval_122()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_139()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_136()),
			(cond_m4_0 and cond_m5_m1 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_136()),
			(cond_m4_m1 and cond_m5_0 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_136()),
			(cond_m2_m1 and cond_m3_m1 and cond_m7_0, lambda: eval_135()),
			(cond_m2_m1 and cond_m4_m1 and cond_m7_0, lambda: eval_123()),
			(cond_m2_m1 and cond_m5_m1 and cond_m7_0, lambda: eval_123()),
			(cond_m2_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_122()),
			(cond_m2_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_123()),
			(cond_m3_m1 and cond_m4_m1 and cond_m7_0, lambda: eval_123()),
			(cond_m3_m1 and cond_m5_m1 and cond_m7_0, lambda: eval_123()),
			(cond_m3_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_122()),
			(cond_m3_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_123()),
			(cond_m4_m1 and cond_m5_m1 and cond_m7_0, lambda: eval_124()),
			(cond_m4_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_124()),
			(cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_140()),
			(cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_140()),
			(cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_124()),
			(cond_m1_0 and cond_m7_m6, lambda: eval_140()),
			(cond_m1_0 and cond_m6_m5, lambda: eval_136()),
			(cond_m1_0 and cond_m7_m5, lambda: eval_140()),
			(cond_m1_0 and cond_m5_m4, lambda: eval_137()),
			(cond_m1_0 and cond_m6_m4, lambda: eval_137()),
			(cond_m1_0 and cond_m7_m4, lambda: eval_140()),
			(cond_m1_0 and cond_m4_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m5_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m6_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m7_m3, lambda: eval_140()),
			(cond_m1_0 and cond_m3_m2, lambda: eval_138()),
			(cond_m1_0 and cond_m4_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m5_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m6_m2, lambda: eval_140()),
			(cond_m1_0 and cond_m7_m2, lambda: eval_140()),
			(cond_m2_0 and cond_m7_m6, lambda: eval_140()),
			(cond_m2_0 and cond_m6_m5, lambda: eval_136()),
			(cond_m2_0 and cond_m7_m5, lambda: eval_140()),
			(cond_m2_0 and cond_m5_m4, lambda: eval_137()),
			(cond_m2_0 and cond_m6_m4, lambda: eval_137()),
			(cond_m2_0 and cond_m7_m4, lambda: eval_140()),
			(cond_m2_0 and cond_m4_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m5_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m6_m3, lambda: eval_140()),
			(cond_m2_0 and cond_m7_m3, lambda: eval_140()),
			(cond_m3_0 and cond_m7_m6, lambda: eval_140()),
			(cond_m3_0 and cond_m6_m5, lambda: eval_136()),
			(cond_m3_0 and cond_m7_m5, lambda: eval_140()),
			(cond_m3_0 and cond_m5_m4, lambda: eval_137()),
			(cond_m3_0 and cond_m6_m4, lambda: eval_137()),
			(cond_m3_0 and cond_m7_m4, lambda: eval_140()),
			(cond_m4_0 and cond_m7_m6, lambda: eval_140()),
			(cond_m4_0 and cond_m6_m5, lambda: eval_136()),
			(cond_m4_0 and cond_m7_m5, lambda: eval_140()),
			(cond_m5_0 and cond_m7_m6, lambda: eval_140()),
			(cond_m6_0 and cond_m7_m5, lambda: eval_140()),
			(cond_m6_m5 and cond_m7_0, lambda: eval_136()),
			(cond_m5_0 and cond_m6_m4, lambda: eval_136()),
			(cond_m5_0 and cond_m7_m4, lambda: eval_140()),
			(cond_m5_m4 and cond_m6_0, lambda: eval_136()),
			(cond_m5_m4 and cond_m7_0, lambda: eval_137()),
			(cond_m6_0 and cond_m7_m4, lambda: eval_140()),
			(cond_m6_m4 and cond_m7_0, lambda: eval_137()),
			(cond_m4_0 and cond_m5_m3, lambda: eval_140()),
			(cond_m4_0 and cond_m6_m3, lambda: eval_140()),
			(cond_m4_0 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_0, lambda: eval_140()),
			(cond_m4_m3 and cond_m6_0, lambda: eval_140()),
			(cond_m5_0 and cond_m6_m3, lambda: eval_140()),
			(cond_m5_0 and cond_m7_m3, lambda: eval_140()),
			(cond_m5_m3 and cond_m6_0, lambda: eval_140()),
			(cond_m4_m3 and cond_m7_0, lambda: eval_140()),
			(cond_m5_m3 and cond_m7_0, lambda: eval_140()),
			(cond_m6_0 and cond_m7_m3, lambda: eval_140()),
			(cond_m6_m3 and cond_m7_0, lambda: eval_140()),
			(cond_m3_0 and cond_m4_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m5_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m6_m2, lambda: eval_140()),
			(cond_m3_0 and cond_m7_m2, lambda: eval_140()),
			(cond_m3_m2 and cond_m4_0, lambda: eval_138()),
			(cond_m3_m2 and cond_m5_0, lambda: eval_138()),
			(cond_m4_0 and cond_m5_m2, lambda: eval_140()),
			(cond_m4_0 and cond_m6_m2, lambda: eval_140()),
			(cond_m4_0 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_0, lambda: eval_140()),
			(cond_m3_m2 and cond_m6_0, lambda: eval_138()),
			(cond_m4_m2 and cond_m6_0, lambda: eval_140()),
			(cond_m5_0 and cond_m6_m2, lambda: eval_140()),
			(cond_m5_0 and cond_m7_m2, lambda: eval_140()),
			(cond_m5_m2 and cond_m6_0, lambda: eval_140()),
			(cond_m3_m2 and cond_m7_0, lambda: eval_138()),
			(cond_m4_m2 and cond_m7_0, lambda: eval_140()),
			(cond_m5_m2 and cond_m7_0, lambda: eval_140()),
			(cond_m6_0 and cond_m7_m2, lambda: eval_140()),
			(cond_m6_m2 and cond_m7_0, lambda: eval_140()),
			(cond_m2_0 and cond_m3_m1, lambda: eval_138()),
			(cond_m2_0 and cond_m4_m1, lambda: eval_140()),
			(cond_m2_0 and cond_m5_m1, lambda: eval_140()),
			(cond_m2_0 and cond_m6_m1, lambda: eval_140()),
			(cond_m2_0 and cond_m7_m1, lambda: eval_140()),
			(cond_m2_m1 and cond_m3_0, lambda: eval_138()),
			(cond_m2_m1 and cond_m4_0, lambda: eval_139()),
			(cond_m3_0 and cond_m4_m1, lambda: eval_140()),
			(cond_m3_0 and cond_m5_m1, lambda: eval_140()),
			(cond_m3_0 and cond_m6_m1, lambda: eval_140()),
			(cond_m3_0 and cond_m7_m1, lambda: eval_140()),
			(cond_m3_m1 and cond_m4_0, lambda: eval_139()),
			(cond_m2_m1 and cond_m5_0, lambda: eval_139()),
			(cond_m3_m1 and cond_m5_0, lambda: eval_139()),
			(cond_m4_0 and cond_m5_m1, lambda: eval_140()),
			(cond_m4_0 and cond_m6_m1, lambda: eval_140()),
			(cond_m4_0 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_m1 and cond_m5_0, lambda: eval_140()),
			(cond_m2_m1 and cond_m6_0, lambda: eval_139()),
			(cond_m3_m1 and cond_m6_0, lambda: eval_139()),
			(cond_m4_m1 and cond_m6_0, lambda: eval_140()),
			(cond_m5_0 and cond_m6_m1, lambda: eval_140()),
			(cond_m5_0 and cond_m7_m1, lambda: eval_140()),
			(cond_m5_m1 and cond_m6_0, lambda: eval_140()),
			(cond_m2_m1 and cond_m7_0, lambda: eval_139()),
			(cond_m3_m1 and cond_m7_0, lambda: eval_139()),
			(cond_m4_m1 and cond_m7_0, lambda: eval_140()),
			(cond_m5_m1 and cond_m7_0, lambda: eval_140()),
			(cond_m6_0 and cond_m7_m1, lambda: eval_140()),
			(cond_m6_m1 and cond_m7_0, lambda: eval_140()),
			(cond_m1_0, lambda: eval_140()),
			(cond_m2_0, lambda: eval_140()),
			(cond_m3_0, lambda: eval_140()),
			(cond_m4_0, lambda: eval_140()),
			(cond_m5_0, lambda: eval_140()),
			(cond_m6_0, lambda: eval_140()),
			(cond_m7_0, lambda: eval_140()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_125()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_126()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_127()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_127()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_131()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_131()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_131()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_126()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4 and cond_m6_m4 and cond_m7_m4, lambda: eval_125()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_133()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1 and cond_m6_m3 and cond_m7_m3, lambda: eval_133()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3 and cond_m6_m1 and cond_m7_m3, lambda: eval_133()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3 and cond_m7_m1, lambda: eval_127()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_133()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_133()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_133()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_127()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_132()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_132()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_131()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_132()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_131()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_131()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m6_m5 and cond_m7_m5, lambda: eval_128()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1 and cond_m6_m4 and cond_m7_m4, lambda: eval_128()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4 and cond_m6_m1 and cond_m7_m4, lambda: eval_128()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4 and cond_m6_m4 and cond_m7_m1, lambda: eval_125()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m3 and cond_m7_m3, lambda: eval_134()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3 and cond_m6_m1 and cond_m7_m3, lambda: eval_134()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3 and cond_m6_m3 and cond_m7_m1, lambda: eval_133()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1 and cond_m6_m1 and cond_m7_m3, lambda: eval_134()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1 and cond_m6_m3 and cond_m7_m1, lambda: eval_133()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3 and cond_m6_m1 and cond_m7_m1, lambda: eval_133()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_134()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_134()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_133()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_134()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_133()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_133()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_126()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_132()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_132()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_132()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m7_m6, lambda: eval_129()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m6_m1 and cond_m7_m5, lambda: eval_129()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m6_m5 and cond_m7_m1, lambda: eval_128()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m4, lambda: eval_129()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1 and cond_m6_m4 and cond_m7_m1, lambda: eval_128()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4 and cond_m6_m1 and cond_m7_m1, lambda: eval_128()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m3, lambda: eval_127()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m3 and cond_m7_m1, lambda: eval_134()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3 and cond_m6_m1 and cond_m7_m1, lambda: eval_134()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_134()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_127()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_134()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_134()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_134()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_126()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_125()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m7_m1, lambda: eval_129()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_129()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_129()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_127()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_127()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_130()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_m4 and cond_m7_m4, lambda: eval_126()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_136()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_m3 and cond_m7_m3, lambda: eval_136()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_m2 and cond_m7_m3, lambda: eval_136()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_m3 and cond_m7_m2, lambda: eval_130()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_m5 and cond_m7_m5, lambda: eval_131()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_m4 and cond_m7_m4, lambda: eval_131()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_m2 and cond_m7_m4, lambda: eval_131()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_m4 and cond_m7_m2, lambda: eval_126()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_m3 and cond_m7_m3, lambda: eval_137()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_m2 and cond_m7_m3, lambda: eval_137()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_m3 and cond_m7_m2, lambda: eval_136()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_m2 and cond_m7_m3, lambda: eval_137()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_m3 and cond_m7_m2, lambda: eval_136()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_m2 and cond_m7_m2, lambda: eval_136()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m7_m6, lambda: eval_132()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_m2 and cond_m7_m5, lambda: eval_132()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_m5 and cond_m7_m2, lambda: eval_131()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_m4, lambda: eval_132()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_m4 and cond_m7_m2, lambda: eval_131()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_m2 and cond_m7_m2, lambda: eval_131()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_m3, lambda: eval_130()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_m3 and cond_m7_m2, lambda: eval_137()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_m2 and cond_m7_m2, lambda: eval_137()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_137()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2, lambda: eval_126()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m7_m2, lambda: eval_132()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_132()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_132()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_130()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_m4 and cond_m7_m4, lambda: eval_127()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_m4 and cond_m7_m4, lambda: eval_127()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_136()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_m3 and cond_m7_m3, lambda: eval_136()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_m1 and cond_m7_m3, lambda: eval_136()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_m3 and cond_m7_m1, lambda: eval_130()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_m5 and cond_m7_m5, lambda: eval_133()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_m4 and cond_m7_m4, lambda: eval_133()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_m3 and cond_m7_m4, lambda: eval_133()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_m4 and cond_m7_m3, lambda: eval_127()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_m5 and cond_m7_m5, lambda: eval_133()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_m4 and cond_m7_m4, lambda: eval_133()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_m2 and cond_m7_m4, lambda: eval_133()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_m4 and cond_m7_m2, lambda: eval_127()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_m5 and cond_m7_m5, lambda: eval_131()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_m4 and cond_m7_m4, lambda: eval_131()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_m1 and cond_m7_m4, lambda: eval_131()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_m4 and cond_m7_m1, lambda: eval_126()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_m3 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_m2 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_m3 and cond_m7_m2, lambda: eval_136()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_m3 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_m1 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_m3 and cond_m7_m1, lambda: eval_136()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_m2 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_m3 and cond_m7_m2, lambda: eval_136()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_m1 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_m3 and cond_m7_m1, lambda: eval_136()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_m1 and cond_m7_m2, lambda: eval_136()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_m2 and cond_m7_m1, lambda: eval_136()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3 and cond_m7_m6, lambda: eval_134()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_m3 and cond_m7_m5, lambda: eval_134()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_m5 and cond_m7_m3, lambda: eval_133()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_m3 and cond_m7_m4, lambda: eval_134()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_m4 and cond_m7_m3, lambda: eval_133()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_m3 and cond_m7_m3, lambda: eval_133()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2 and cond_m7_m6, lambda: eval_134()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_m2 and cond_m7_m5, lambda: eval_134()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_m5 and cond_m7_m2, lambda: eval_133()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_m2 and cond_m7_m4, lambda: eval_134()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_m4 and cond_m7_m2, lambda: eval_133()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_m2 and cond_m7_m2, lambda: eval_133()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2 and cond_m7_m6, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_m2 and cond_m7_m5, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_m5 and cond_m7_m2, lambda: eval_131()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1 and cond_m7_m6, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_m1 and cond_m7_m5, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_m5 and cond_m7_m1, lambda: eval_131()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_m2 and cond_m7_m4, lambda: eval_138()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_m4 and cond_m7_m2, lambda: eval_131()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_m1 and cond_m7_m4, lambda: eval_138()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_m4 and cond_m7_m1, lambda: eval_131()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_m1 and cond_m7_m2, lambda: eval_131()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_m2 and cond_m7_m1, lambda: eval_131()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_m2 and cond_m7_m3, lambda: eval_136()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_m3 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_m2 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_m2 and cond_m7_m3, lambda: eval_136()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_m3 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_m1 and cond_m7_m3, lambda: eval_136()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_m3 and cond_m7_m1, lambda: eval_137()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_m1 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_m2 and cond_m7_m1, lambda: eval_137()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_137()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3, lambda: eval_127()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3 and cond_m7_m3, lambda: eval_134()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_134()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_134()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2, lambda: eval_127()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2 and cond_m7_m2, lambda: eval_134()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_134()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_134()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2 and cond_m6_m2, lambda: eval_131()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2 and cond_m7_m2, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1 and cond_m6_m2, lambda: eval_131()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1 and cond_m7_m2, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_m1, lambda: eval_131()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m7_m1, lambda: eval_132()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_132()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_138()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_138()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_132()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_136()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_136()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_136()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_130()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_m5 and cond_m7_m5, lambda: eval_128()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_m5 and cond_m7_m5, lambda: eval_133()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_m4 and cond_m7_m4, lambda: eval_133()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_m1 and cond_m7_m4, lambda: eval_133()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_m4 and cond_m7_m1, lambda: eval_127()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_m5 and cond_m7_m5, lambda: eval_133()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_m4 and cond_m7_m4, lambda: eval_133()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_m1 and cond_m7_m4, lambda: eval_133()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_m4 and cond_m7_m1, lambda: eval_127()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_m3 and cond_m7_m3, lambda: eval_137()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_m1 and cond_m7_m3, lambda: eval_137()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_m3 and cond_m7_m1, lambda: eval_136()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_m1 and cond_m7_m3, lambda: eval_137()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_m3 and cond_m7_m1, lambda: eval_136()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_m1 and cond_m7_m1, lambda: eval_136()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4 and cond_m7_m6, lambda: eval_129()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_m4 and cond_m7_m5, lambda: eval_129()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_m5 and cond_m7_m4, lambda: eval_128()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3 and cond_m7_m6, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_m3 and cond_m7_m5, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_m5 and cond_m7_m3, lambda: eval_133()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1 and cond_m7_m6, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_m1 and cond_m7_m5, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_m5 and cond_m7_m1, lambda: eval_133()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_m3 and cond_m7_m4, lambda: eval_139()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_m4 and cond_m7_m3, lambda: eval_133()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_m1 and cond_m7_m4, lambda: eval_139()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_m4 and cond_m7_m1, lambda: eval_133()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_m1 and cond_m7_m3, lambda: eval_133()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_m3 and cond_m7_m1, lambda: eval_133()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2 and cond_m7_m6, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_m2 and cond_m7_m5, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_m5 and cond_m7_m2, lambda: eval_133()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1 and cond_m7_m6, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_m1 and cond_m7_m5, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_m5 and cond_m7_m1, lambda: eval_133()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_m2 and cond_m7_m4, lambda: eval_139()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_m4 and cond_m7_m2, lambda: eval_133()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_m1 and cond_m7_m4, lambda: eval_139()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_m4 and cond_m7_m1, lambda: eval_133()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_m1 and cond_m7_m2, lambda: eval_133()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_m2 and cond_m7_m1, lambda: eval_133()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1 and cond_m7_m6, lambda: eval_132()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_m1 and cond_m7_m5, lambda: eval_132()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_m5 and cond_m7_m1, lambda: eval_131()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_m1 and cond_m7_m4, lambda: eval_132()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_m4 and cond_m7_m1, lambda: eval_131()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_m1 and cond_m7_m1, lambda: eval_131()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_m2 and cond_m7_m3, lambda: eval_137()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_m3 and cond_m7_m2, lambda: eval_137()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_m1 and cond_m7_m3, lambda: eval_137()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_m3 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_m1 and cond_m7_m2, lambda: eval_137()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_m2 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_m1 and cond_m7_m3, lambda: eval_137()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_m3 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_m1 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_137()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_140()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4 and cond_m6_m4, lambda: eval_125()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4 and cond_m7_m4, lambda: eval_129()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_m4 and cond_m7_m4, lambda: eval_129()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3 and cond_m6_m3, lambda: eval_133()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3 and cond_m7_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_m3 and cond_m7_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1 and cond_m6_m3, lambda: eval_133()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1 and cond_m7_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3 and cond_m6_m1, lambda: eval_133()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3 and cond_m7_m1, lambda: eval_134()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_m1 and cond_m7_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_m3 and cond_m7_m1, lambda: eval_134()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_m3 and cond_m7_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_m1 and cond_m7_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_m3 and cond_m7_m1, lambda: eval_134()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2 and cond_m6_m2, lambda: eval_133()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2 and cond_m7_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1 and cond_m6_m2, lambda: eval_133()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1 and cond_m7_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2 and cond_m6_m1, lambda: eval_133()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2 and cond_m7_m1, lambda: eval_134()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_134()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_134()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1 and cond_m6_m2, lambda: eval_132()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1 and cond_m7_m2, lambda: eval_132()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2 and cond_m6_m1, lambda: eval_132()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2 and cond_m7_m1, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_132()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1 and cond_m6_m1, lambda: eval_132()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1 and cond_m7_m1, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_138()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_132()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_138()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_138()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_137()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_137()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_136()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_137()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_136()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_136()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m7_m6, lambda: eval_135()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1 and cond_m7_m6, lambda: eval_135()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_m1 and cond_m7_m5, lambda: eval_135()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_m5 and cond_m7_m1, lambda: eval_128()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1 and cond_m7_m6, lambda: eval_134()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_m1 and cond_m7_m5, lambda: eval_134()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_m5 and cond_m7_m1, lambda: eval_133()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m4, lambda: eval_134()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_m4 and cond_m7_m1, lambda: eval_133()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_m1 and cond_m7_m1, lambda: eval_133()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m7_m6, lambda: eval_134()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_m1 and cond_m7_m5, lambda: eval_134()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_m5 and cond_m7_m1, lambda: eval_133()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m4, lambda: eval_134()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_m4 and cond_m7_m1, lambda: eval_133()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_m1 and cond_m7_m1, lambda: eval_133()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m3, lambda: eval_130()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_m3 and cond_m7_m1, lambda: eval_137()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_m1 and cond_m7_m1, lambda: eval_137()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_137()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m6_m5, lambda: eval_128()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m7_m5, lambda: eval_135()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1 and cond_m6_m4, lambda: eval_128()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1 and cond_m7_m4, lambda: eval_135()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4 and cond_m6_m1, lambda: eval_128()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4 and cond_m7_m1, lambda: eval_129()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_m1 and cond_m7_m4, lambda: eval_135()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_m4 and cond_m7_m1, lambda: eval_129()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m3, lambda: eval_134()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1 and cond_m7_m3, lambda: eval_134()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3 and cond_m6_m1, lambda: eval_134()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3 and cond_m7_m1, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_m1 and cond_m7_m3, lambda: eval_134()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_m3 and cond_m7_m1, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1 and cond_m6_m1, lambda: eval_134()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1 and cond_m7_m1, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_m1 and cond_m7_m1, lambda: eval_139()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m3, lambda: eval_134()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_m3 and cond_m7_m1, lambda: eval_139()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_m1 and cond_m7_m1, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m2, lambda: eval_134()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m7_m2, lambda: eval_134()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2 and cond_m6_m1, lambda: eval_134()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2 and cond_m7_m1, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_134()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1 and cond_m6_m1, lambda: eval_134()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1 and cond_m7_m1, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_139()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_134()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_139()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_139()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_126()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1 and cond_m7_m1, lambda: eval_132()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_132()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_132()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_130()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_137()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_137()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_137()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1, lambda: eval_129()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m6_m1, lambda: eval_129()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m7_m1, lambda: eval_135()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_129()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1 and cond_m7_m1, lambda: eval_135()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_135()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_127()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1 and cond_m7_m1, lambda: eval_134()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_134()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_134()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_127()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m7_m1, lambda: eval_134()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_134()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_134()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_130()),
			(cond_m5_m4 and cond_m6_m4 and cond_m7_m4, lambda: eval_130()),
			(cond_m4_m3 and cond_m6_m5 and cond_m7_m5, lambda: eval_136()),
			(cond_m5_m3 and cond_m6_m4 and cond_m7_m4, lambda: eval_136()),
			(cond_m5_m4 and cond_m6_m3 and cond_m7_m4, lambda: eval_136()),
			(cond_m5_m4 and cond_m6_m4 and cond_m7_m3, lambda: eval_130()),
			(cond_m4_m3 and cond_m5_m3 and cond_m7_m6, lambda: eval_137()),
			(cond_m4_m3 and cond_m6_m3 and cond_m7_m5, lambda: eval_137()),
			(cond_m4_m3 and cond_m6_m5 and cond_m7_m3, lambda: eval_136()),
			(cond_m5_m3 and cond_m6_m3 and cond_m7_m4, lambda: eval_137()),
			(cond_m5_m3 and cond_m6_m4 and cond_m7_m3, lambda: eval_136()),
			(cond_m5_m4 and cond_m6_m3 and cond_m7_m3, lambda: eval_136()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_m3, lambda: eval_130()),
			(cond_m4_m3 and cond_m5_m3 and cond_m7_m3, lambda: eval_137()),
			(cond_m4_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_137()),
			(cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_137()),
			(cond_m3_m2 and cond_m6_m5 and cond_m7_m5, lambda: eval_131()),
			(cond_m4_m2 and cond_m6_m5 and cond_m7_m5, lambda: eval_136()),
			(cond_m5_m2 and cond_m6_m4 and cond_m7_m4, lambda: eval_136()),
			(cond_m5_m4 and cond_m6_m2 and cond_m7_m4, lambda: eval_136()),
			(cond_m5_m4 and cond_m6_m4 and cond_m7_m2, lambda: eval_130()),
			(cond_m3_m2 and cond_m5_m4 and cond_m7_m6, lambda: eval_132()),
			(cond_m3_m2 and cond_m6_m4 and cond_m7_m5, lambda: eval_132()),
			(cond_m3_m2 and cond_m6_m5 and cond_m7_m4, lambda: eval_131()),
			(cond_m4_m2 and cond_m5_m3 and cond_m7_m6, lambda: eval_140()),
			(cond_m4_m2 and cond_m6_m3 and cond_m7_m5, lambda: eval_140()),
			(cond_m4_m2 and cond_m6_m5 and cond_m7_m3, lambda: eval_136()),
			(cond_m4_m3 and cond_m5_m2 and cond_m7_m6, lambda: eval_140()),
			(cond_m4_m3 and cond_m6_m2 and cond_m7_m5, lambda: eval_140()),
			(cond_m4_m3 and cond_m6_m5 and cond_m7_m2, lambda: eval_136()),
			(cond_m5_m2 and cond_m6_m3 and cond_m7_m4, lambda: eval_140()),
			(cond_m5_m2 and cond_m6_m4 and cond_m7_m3, lambda: eval_136()),
			(cond_m5_m3 and cond_m6_m2 and cond_m7_m4, lambda: eval_140()),
			(cond_m5_m3 and cond_m6_m4 and cond_m7_m2, lambda: eval_136()),
			(cond_m5_m4 and cond_m6_m2 and cond_m7_m3, lambda: eval_136()),
			(cond_m5_m4 and cond_m6_m3 and cond_m7_m2, lambda: eval_136()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_m4, lambda: eval_126()),
			(cond_m3_m2 and cond_m5_m4 and cond_m7_m4, lambda: eval_132()),
			(cond_m3_m2 and cond_m6_m4 and cond_m7_m4, lambda: eval_132()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_m3, lambda: eval_136()),
			(cond_m4_m2 and cond_m5_m3 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_m2 and cond_m6_m3 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_m3, lambda: eval_136()),
			(cond_m4_m3 and cond_m5_m2 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_m2, lambda: eval_136()),
			(cond_m4_m3 and cond_m5_m3 and cond_m7_m2, lambda: eval_137()),
			(cond_m4_m3 and cond_m6_m2 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_m3 and cond_m6_m3 and cond_m7_m2, lambda: eval_137()),
			(cond_m5_m2 and cond_m6_m3 and cond_m7_m3, lambda: eval_140()),
			(cond_m5_m3 and cond_m6_m2 and cond_m7_m3, lambda: eval_140()),
			(cond_m5_m3 and cond_m6_m3 and cond_m7_m2, lambda: eval_137()),
			(cond_m3_m2 and cond_m4_m2 and cond_m7_m6, lambda: eval_138()),
			(cond_m3_m2 and cond_m5_m2 and cond_m7_m6, lambda: eval_138()),
			(cond_m3_m2 and cond_m6_m2 and cond_m7_m5, lambda: eval_138()),
			(cond_m3_m2 and cond_m6_m5 and cond_m7_m2, lambda: eval_131()),
			(cond_m4_m2 and cond_m5_m2 and cond_m7_m6, lambda: eval_137()),
			(cond_m4_m2 and cond_m6_m2 and cond_m7_m5, lambda: eval_137()),
			(cond_m4_m2 and cond_m6_m5 and cond_m7_m2, lambda: eval_136()),
			(cond_m5_m2 and cond_m6_m2 and cond_m7_m4, lambda: eval_137()),
			(cond_m5_m2 and cond_m6_m4 and cond_m7_m2, lambda: eval_136()),
			(cond_m5_m4 and cond_m6_m2 and cond_m7_m2, lambda: eval_136()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_m5, lambda: eval_131()),
			(cond_m3_m2 and cond_m4_m2 and cond_m7_m5, lambda: eval_138()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_m4, lambda: eval_131()),
			(cond_m3_m2 and cond_m5_m2 and cond_m7_m4, lambda: eval_138()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_m2, lambda: eval_131()),
			(cond_m3_m2 and cond_m5_m4 and cond_m7_m2, lambda: eval_132()),
			(cond_m3_m2 and cond_m6_m2 and cond_m7_m4, lambda: eval_138()),
			(cond_m3_m2 and cond_m6_m4 and cond_m7_m2, lambda: eval_132()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_m3, lambda: eval_137()),
			(cond_m4_m2 and cond_m5_m2 and cond_m7_m3, lambda: eval_137()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_m2, lambda: eval_137()),
			(cond_m4_m2 and cond_m5_m3 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_m2 and cond_m6_m2 and cond_m7_m3, lambda: eval_137()),
			(cond_m4_m2 and cond_m6_m3 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_m2, lambda: eval_137()),
			(cond_m4_m3 and cond_m5_m2 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_m3 and cond_m6_m2 and cond_m7_m2, lambda: eval_140()),
			(cond_m5_m2 and cond_m6_m2 and cond_m7_m3, lambda: eval_137()),
			(cond_m5_m2 and cond_m6_m3 and cond_m7_m2, lambda: eval_140()),
			(cond_m5_m3 and cond_m6_m2 and cond_m7_m2, lambda: eval_140()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2, lambda: eval_132()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_m2, lambda: eval_132()),
			(cond_m3_m2 and cond_m4_m2 and cond_m7_m2, lambda: eval_138()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_m2, lambda: eval_132()),
			(cond_m3_m2 and cond_m5_m2 and cond_m7_m2, lambda: eval_138()),
			(cond_m3_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_138()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_m2, lambda: eval_130()),
			(cond_m4_m2 and cond_m5_m2 and cond_m7_m2, lambda: eval_137()),
			(cond_m4_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_137()),
			(cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_137()),
			(cond_m2_m1 and cond_m6_m5 and cond_m7_m5, lambda: eval_133()),
			(cond_m3_m1 and cond_m6_m5 and cond_m7_m5, lambda: eval_133()),
			(cond_m4_m1 and cond_m6_m5 and cond_m7_m5, lambda: eval_136()),
			(cond_m5_m1 and cond_m6_m4 and cond_m7_m4, lambda: eval_136()),
			(cond_m5_m4 and cond_m6_m1 and cond_m7_m4, lambda: eval_136()),
			(cond_m5_m4 and cond_m6_m4 and cond_m7_m1, lambda: eval_130()),
			(cond_m2_m1 and cond_m5_m4 and cond_m7_m6, lambda: eval_134()),
			(cond_m2_m1 and cond_m6_m4 and cond_m7_m5, lambda: eval_134()),
			(cond_m2_m1 and cond_m6_m5 and cond_m7_m4, lambda: eval_133()),
			(cond_m3_m1 and cond_m5_m4 and cond_m7_m6, lambda: eval_134()),
			(cond_m3_m1 and cond_m6_m4 and cond_m7_m5, lambda: eval_134()),
			(cond_m3_m1 and cond_m6_m5 and cond_m7_m4, lambda: eval_133()),
			(cond_m4_m1 and cond_m5_m3 and cond_m7_m6, lambda: eval_140()),
			(cond_m4_m1 and cond_m6_m3 and cond_m7_m5, lambda: eval_140()),
			(cond_m4_m1 and cond_m6_m5 and cond_m7_m3, lambda: eval_136()),
			(cond_m4_m3 and cond_m5_m1 and cond_m7_m6, lambda: eval_140()),
			(cond_m4_m3 and cond_m6_m1 and cond_m7_m5, lambda: eval_140()),
			(cond_m4_m3 and cond_m6_m5 and cond_m7_m1, lambda: eval_136()),
			(cond_m5_m1 and cond_m6_m3 and cond_m7_m4, lambda: eval_140()),
			(cond_m5_m1 and cond_m6_m4 and cond_m7_m3, lambda: eval_136()),
			(cond_m5_m3 and cond_m6_m1 and cond_m7_m4, lambda: eval_140()),
			(cond_m5_m3 and cond_m6_m4 and cond_m7_m1, lambda: eval_136()),
			(cond_m5_m4 and cond_m6_m1 and cond_m7_m3, lambda: eval_136()),
			(cond_m5_m4 and cond_m6_m3 and cond_m7_m1, lambda: eval_136()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_m4, lambda: eval_127()),
			(cond_m2_m1 and cond_m5_m4 and cond_m7_m4, lambda: eval_134()),
			(cond_m2_m1 and cond_m6_m4 and cond_m7_m4, lambda: eval_134()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_m4, lambda: eval_127()),
			(cond_m3_m1 and cond_m5_m4 and cond_m7_m4, lambda: eval_134()),
			(cond_m3_m1 and cond_m6_m4 and cond_m7_m4, lambda: eval_134()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_m3, lambda: eval_136()),
			(cond_m4_m1 and cond_m5_m3 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_m1 and cond_m6_m3 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_m3, lambda: eval_136()),
			(cond_m4_m3 and cond_m5_m1 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_m1, lambda: eval_136()),
			(cond_m4_m3 and cond_m5_m3 and cond_m7_m1, lambda: eval_137()),
			(cond_m4_m3 and cond_m6_m1 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_m3 and cond_m6_m3 and cond_m7_m1, lambda: eval_137()),
			(cond_m5_m1 and cond_m6_m3 and cond_m7_m3, lambda: eval_140()),
			(cond_m5_m3 and cond_m6_m1 and cond_m7_m3, lambda: eval_140()),
			(cond_m5_m3 and cond_m6_m3 and cond_m7_m1, lambda: eval_137()),
			(cond_m2_m1 and cond_m4_m3 and cond_m7_m6, lambda: eval_139()),
			(cond_m2_m1 and cond_m5_m3 and cond_m7_m6, lambda: eval_139()),
			(cond_m2_m1 and cond_m6_m3 and cond_m7_m5, lambda: eval_139()),
			(cond_m2_m1 and cond_m6_m5 and cond_m7_m3, lambda: eval_133()),
			(cond_m3_m1 and cond_m4_m2 and cond_m7_m6, lambda: eval_139()),
			(cond_m3_m1 and cond_m5_m2 and cond_m7_m6, lambda: eval_139()),
			(cond_m3_m1 and cond_m6_m2 and cond_m7_m5, lambda: eval_139()),
			(cond_m3_m1 and cond_m6_m5 and cond_m7_m2, lambda: eval_133()),
			(cond_m3_m2 and cond_m4_m1 and cond_m7_m6, lambda: eval_138()),
			(cond_m3_m2 and cond_m5_m1 and cond_m7_m6, lambda: eval_138()),
			(cond_m3_m2 and cond_m6_m1 and cond_m7_m5, lambda: eval_138()),
			(cond_m3_m2 and cond_m6_m5 and cond_m7_m1, lambda: eval_131()),
			(cond_m4_m1 and cond_m5_m2 and cond_m7_m6, lambda: eval_140()),
			(cond_m4_m1 and cond_m6_m2 and cond_m7_m5, lambda: eval_140()),
			(cond_m4_m1 and cond_m6_m5 and cond_m7_m2, lambda: eval_136()),
			(cond_m4_m2 and cond_m5_m1 and cond_m7_m6, lambda: eval_140()),
			(cond_m4_m2 and cond_m6_m1 and cond_m7_m5, lambda: eval_140()),
			(cond_m4_m2 and cond_m6_m5 and cond_m7_m1, lambda: eval_136()),
			(cond_m5_m1 and cond_m6_m2 and cond_m7_m4, lambda: eval_140()),
			(cond_m5_m1 and cond_m6_m4 and cond_m7_m2, lambda: eval_136()),
			(cond_m5_m2 and cond_m6_m1 and cond_m7_m4, lambda: eval_140()),
			(cond_m5_m2 and cond_m6_m4 and cond_m7_m1, lambda: eval_136()),
			(cond_m5_m4 and cond_m6_m1 and cond_m7_m2, lambda: eval_136()),
			(cond_m5_m4 and cond_m6_m2 and cond_m7_m1, lambda: eval_136()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_m5, lambda: eval_133()),
			(cond_m2_m1 and cond_m4_m3 and cond_m7_m5, lambda: eval_139()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_m4, lambda: eval_133()),
			(cond_m2_m1 and cond_m5_m3 and cond_m7_m4, lambda: eval_139()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_m3, lambda: eval_133()),
			(cond_m2_m1 and cond_m5_m4 and cond_m7_m3, lambda: eval_134()),
			(cond_m2_m1 and cond_m6_m3 and cond_m7_m4, lambda: eval_139()),
			(cond_m2_m1 and cond_m6_m4 and cond_m7_m3, lambda: eval_134()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_m5, lambda: eval_133()),
			(cond_m3_m1 and cond_m4_m2 and cond_m7_m5, lambda: eval_139()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_m4, lambda: eval_133()),
			(cond_m3_m1 and cond_m5_m2 and cond_m7_m4, lambda: eval_139()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_m2, lambda: eval_133()),
			(cond_m3_m1 and cond_m5_m4 and cond_m7_m2, lambda: eval_134()),
			(cond_m3_m1 and cond_m6_m2 and cond_m7_m4, lambda: eval_139()),
			(cond_m3_m1 and cond_m6_m4 and cond_m7_m2, lambda: eval_134()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_m5, lambda: eval_131()),
			(cond_m3_m2 and cond_m4_m1 and cond_m7_m5, lambda: eval_138()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_m4, lambda: eval_131()),
			(cond_m3_m2 and cond_m5_m1 and cond_m7_m4, lambda: eval_138()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_m1, lambda: eval_131()),
			(cond_m3_m2 and cond_m5_m4 and cond_m7_m1, lambda: eval_132()),
			(cond_m3_m2 and cond_m6_m1 and cond_m7_m4, lambda: eval_138()),
			(cond_m3_m2 and cond_m6_m4 and cond_m7_m1, lambda: eval_132()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_m3, lambda: eval_140()),
			(cond_m4_m1 and cond_m5_m2 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_m2, lambda: eval_140()),
			(cond_m4_m1 and cond_m5_m3 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_m1 and cond_m6_m2 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_m1 and cond_m6_m3 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_m3, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_m1 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_m1, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_m3 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_m2 and cond_m6_m1 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_m2 and cond_m6_m3 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_m2, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_m1 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_m1, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_m2 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_m3 and cond_m6_m1 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_m3 and cond_m6_m2 and cond_m7_m1, lambda: eval_140()),
			(cond_m5_m1 and cond_m6_m2 and cond_m7_m3, lambda: eval_140()),
			(cond_m5_m1 and cond_m6_m3 and cond_m7_m2, lambda: eval_140()),
			(cond_m5_m2 and cond_m6_m1 and cond_m7_m3, lambda: eval_140()),
			(cond_m5_m2 and cond_m6_m3 and cond_m7_m1, lambda: eval_140()),
			(cond_m5_m3 and cond_m6_m1 and cond_m7_m2, lambda: eval_140()),
			(cond_m5_m3 and cond_m6_m2 and cond_m7_m1, lambda: eval_140()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3, lambda: eval_134()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_m3, lambda: eval_134()),
			(cond_m2_m1 and cond_m4_m3 and cond_m7_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_m3, lambda: eval_134()),
			(cond_m2_m1 and cond_m5_m3 and cond_m7_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m6_m3 and cond_m7_m3, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2, lambda: eval_134()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_m2, lambda: eval_134()),
			(cond_m3_m1 and cond_m4_m2 and cond_m7_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_m2, lambda: eval_134()),
			(cond_m3_m1 and cond_m5_m2 and cond_m7_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_139()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_m2, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_m1 and cond_m7_m2, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_m1, lambda: eval_138()),
			(cond_m3_m2 and cond_m4_m2 and cond_m7_m1, lambda: eval_138()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_m2, lambda: eval_138()),
			(cond_m3_m2 and cond_m5_m1 and cond_m7_m2, lambda: eval_138()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_m1, lambda: eval_138()),
			(cond_m3_m2 and cond_m5_m2 and cond_m7_m1, lambda: eval_138()),
			(cond_m3_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_138()),
			(cond_m3_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_138()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_m2, lambda: eval_136()),
			(cond_m4_m1 and cond_m5_m2 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_m2, lambda: eval_136()),
			(cond_m4_m2 and cond_m5_m1 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_m1, lambda: eval_136()),
			(cond_m4_m2 and cond_m5_m2 and cond_m7_m1, lambda: eval_137()),
			(cond_m4_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_137()),
			(cond_m5_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_140()),
			(cond_m5_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_140()),
			(cond_m5_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_137()),
			(cond_m2_m1 and cond_m3_m1 and cond_m7_m6, lambda: eval_135()),
			(cond_m2_m1 and cond_m4_m1 and cond_m7_m6, lambda: eval_139()),
			(cond_m2_m1 and cond_m5_m1 and cond_m7_m6, lambda: eval_139()),
			(cond_m2_m1 and cond_m6_m1 and cond_m7_m5, lambda: eval_139()),
			(cond_m2_m1 and cond_m6_m5 and cond_m7_m1, lambda: eval_133()),
			(cond_m3_m1 and cond_m4_m1 and cond_m7_m6, lambda: eval_139()),
			(cond_m3_m1 and cond_m5_m1 and cond_m7_m6, lambda: eval_139()),
			(cond_m3_m1 and cond_m6_m1 and cond_m7_m5, lambda: eval_139()),
			(cond_m3_m1 and cond_m6_m5 and cond_m7_m1, lambda: eval_133()),
			(cond_m4_m1 and cond_m5_m1 and cond_m7_m6, lambda: eval_137()),
			(cond_m4_m1 and cond_m6_m1 and cond_m7_m5, lambda: eval_137()),
			(cond_m4_m1 and cond_m6_m5 and cond_m7_m1, lambda: eval_136()),
			(cond_m5_m1 and cond_m6_m1 and cond_m7_m4, lambda: eval_137()),
			(cond_m5_m1 and cond_m6_m4 and cond_m7_m1, lambda: eval_136()),
			(cond_m5_m4 and cond_m6_m1 and cond_m7_m1, lambda: eval_136()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_m5, lambda: eval_128()),
			(cond_m2_m1 and cond_m3_m1 and cond_m7_m5, lambda: eval_135()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_m5, lambda: eval_133()),
			(cond_m2_m1 and cond_m4_m1 and cond_m7_m5, lambda: eval_139()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_m4, lambda: eval_133()),
			(cond_m2_m1 and cond_m5_m1 and cond_m7_m4, lambda: eval_139()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_m1, lambda: eval_133()),
			(cond_m2_m1 and cond_m5_m4 and cond_m7_m1, lambda: eval_134()),
			(cond_m2_m1 and cond_m6_m1 and cond_m7_m4, lambda: eval_139()),
			(cond_m2_m1 and cond_m6_m4 and cond_m7_m1, lambda: eval_134()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_m5, lambda: eval_133()),
			(cond_m3_m1 and cond_m4_m1 and cond_m7_m5, lambda: eval_139()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_m4, lambda: eval_133()),
			(cond_m3_m1 and cond_m5_m1 and cond_m7_m4, lambda: eval_139()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_m1, lambda: eval_133()),
			(cond_m3_m1 and cond_m5_m4 and cond_m7_m1, lambda: eval_134()),
			(cond_m3_m1 and cond_m6_m1 and cond_m7_m4, lambda: eval_139()),
			(cond_m3_m1 and cond_m6_m4 and cond_m7_m1, lambda: eval_134()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_m3, lambda: eval_137()),
			(cond_m4_m1 and cond_m5_m1 and cond_m7_m3, lambda: eval_137()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_m1, lambda: eval_137()),
			(cond_m4_m1 and cond_m5_m3 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_m1 and cond_m6_m1 and cond_m7_m3, lambda: eval_137()),
			(cond_m4_m1 and cond_m6_m3 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_m1, lambda: eval_137()),
			(cond_m4_m3 and cond_m5_m1 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_m3 and cond_m6_m1 and cond_m7_m1, lambda: eval_140()),
			(cond_m5_m1 and cond_m6_m1 and cond_m7_m3, lambda: eval_137()),
			(cond_m5_m1 and cond_m6_m3 and cond_m7_m1, lambda: eval_140()),
			(cond_m5_m3 and cond_m6_m1 and cond_m7_m1, lambda: eval_140()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4, lambda: eval_129()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_m4, lambda: eval_129()),
			(cond_m2_m1 and cond_m3_m1 and cond_m7_m4, lambda: eval_135()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_m1 and cond_m7_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_m1, lambda: eval_139()),
			(cond_m2_m1 and cond_m4_m3 and cond_m7_m1, lambda: eval_139()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m5_m1 and cond_m7_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_m1, lambda: eval_139()),
			(cond_m2_m1 and cond_m5_m3 and cond_m7_m1, lambda: eval_139()),
			(cond_m2_m1 and cond_m6_m1 and cond_m7_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m6_m3 and cond_m7_m1, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_m1 and cond_m7_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_m1, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_m2 and cond_m7_m1, lambda: eval_139()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m5_m1 and cond_m7_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_m1, lambda: eval_139()),
			(cond_m3_m1 and cond_m5_m2 and cond_m7_m1, lambda: eval_139()),
			(cond_m3_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_139()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1, lambda: eval_132()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_m1, lambda: eval_132()),
			(cond_m3_m2 and cond_m4_m1 and cond_m7_m1, lambda: eval_138()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_m1, lambda: eval_132()),
			(cond_m3_m2 and cond_m5_m1 and cond_m7_m1, lambda: eval_138()),
			(cond_m3_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_138()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_m2, lambda: eval_137()),
			(cond_m4_m1 and cond_m5_m1 and cond_m7_m2, lambda: eval_137()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_m1, lambda: eval_137()),
			(cond_m4_m1 and cond_m5_m2 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_137()),
			(cond_m4_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_m1, lambda: eval_137()),
			(cond_m4_m2 and cond_m5_m1 and cond_m7_m1, lambda: eval_140()),
			(cond_m4_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_140()),
			(cond_m5_m1 and cond_m6_m1 and cond_m7_m2, lambda: eval_137()),
			(cond_m5_m1 and cond_m6_m2 and cond_m7_m1, lambda: eval_140()),
			(cond_m5_m2 and cond_m6_m1 and cond_m7_m1, lambda: eval_140()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1, lambda: eval_135()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1, lambda: eval_135()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_m1, lambda: eval_135()),
			(cond_m2_m1 and cond_m3_m1 and cond_m7_m1, lambda: eval_135()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1, lambda: eval_134()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_m1, lambda: eval_134()),
			(cond_m2_m1 and cond_m4_m1 and cond_m7_m1, lambda: eval_139()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_134()),
			(cond_m2_m1 and cond_m5_m1 and cond_m7_m1, lambda: eval_139()),
			(cond_m2_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1, lambda: eval_134()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_m1, lambda: eval_134()),
			(cond_m3_m1 and cond_m4_m1 and cond_m7_m1, lambda: eval_139()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_134()),
			(cond_m3_m1 and cond_m5_m1 and cond_m7_m1, lambda: eval_139()),
			(cond_m3_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_139()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_130()),
			(cond_m4_m1 and cond_m5_m1 and cond_m7_m1, lambda: eval_137()),
			(cond_m4_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_137()),
			(cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_137()),
			(cond_m6_m5 and cond_m7_m5, lambda: eval_136()),
			(cond_m5_m4 and cond_m7_m6, lambda: eval_137()),
			(cond_m6_m4 and cond_m7_m5, lambda: eval_137()),
			(cond_m6_m5 and cond_m7_m4, lambda: eval_136()),
			(cond_m5_m4 and cond_m6_m4, lambda: eval_130()),
			(cond_m5_m4 and cond_m7_m4, lambda: eval_137()),
			(cond_m6_m4 and cond_m7_m4, lambda: eval_137()),
			(cond_m4_m3 and cond_m7_m6, lambda: eval_140()),
			(cond_m5_m3 and cond_m7_m6, lambda: eval_140()),
			(cond_m6_m3 and cond_m7_m5, lambda: eval_140()),
			(cond_m6_m5 and cond_m7_m3, lambda: eval_136()),
			(cond_m4_m3 and cond_m6_m5, lambda: eval_136()),
			(cond_m4_m3 and cond_m7_m5, lambda: eval_140()),
			(cond_m5_m3 and cond_m6_m4, lambda: eval_136()),
			(cond_m5_m3 and cond_m7_m4, lambda: eval_140()),
			(cond_m5_m4 and cond_m6_m3, lambda: eval_136()),
			(cond_m5_m4 and cond_m7_m3, lambda: eval_137()),
			(cond_m6_m3 and cond_m7_m4, lambda: eval_140()),
			(cond_m6_m4 and cond_m7_m3, lambda: eval_137()),
			(cond_m4_m3 and cond_m5_m3, lambda: eval_137()),
			(cond_m4_m3 and cond_m6_m3, lambda: eval_137()),
			(cond_m4_m3 and cond_m7_m3, lambda: eval_140()),
			(cond_m5_m3 and cond_m6_m3, lambda: eval_137()),
			(cond_m5_m3 and cond_m7_m3, lambda: eval_140()),
			(cond_m6_m3 and cond_m7_m3, lambda: eval_140()),
			(cond_m3_m2 and cond_m7_m6, lambda: eval_138()),
			(cond_m4_m2 and cond_m7_m6, lambda: eval_140()),
			(cond_m5_m2 and cond_m7_m6, lambda: eval_140()),
			(cond_m6_m2 and cond_m7_m5, lambda: eval_140()),
			(cond_m6_m5 and cond_m7_m2, lambda: eval_136()),
			(cond_m3_m2 and cond_m6_m5, lambda: eval_131()),
			(cond_m3_m2 and cond_m7_m5, lambda: eval_138()),
			(cond_m4_m2 and cond_m6_m5, lambda: eval_136()),
			(cond_m4_m2 and cond_m7_m5, lambda: eval_140()),
			(cond_m5_m2 and cond_m6_m4, lambda: eval_136()),
			(cond_m5_m2 and cond_m7_m4, lambda: eval_140()),
			(cond_m5_m4 and cond_m6_m2, lambda: eval_136()),
			(cond_m5_m4 and cond_m7_m2, lambda: eval_137()),
			(cond_m6_m2 and cond_m7_m4, lambda: eval_140()),
			(cond_m6_m4 and cond_m7_m2, lambda: eval_137()),
			(cond_m3_m2 and cond_m5_m4, lambda: eval_132()),
			(cond_m3_m2 and cond_m6_m4, lambda: eval_132()),
			(cond_m3_m2 and cond_m7_m4, lambda: eval_138()),
			(cond_m4_m2 and cond_m5_m3, lambda: eval_140()),
			(cond_m4_m2 and cond_m6_m3, lambda: eval_140()),
			(cond_m4_m2 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_m2, lambda: eval_140()),
			(cond_m4_m3 and cond_m6_m2, lambda: eval_140()),
			(cond_m4_m3 and cond_m7_m2, lambda: eval_140()),
			(cond_m5_m2 and cond_m6_m3, lambda: eval_140()),
			(cond_m5_m2 and cond_m7_m3, lambda: eval_140()),
			(cond_m5_m3 and cond_m6_m2, lambda: eval_140()),
			(cond_m5_m3 and cond_m7_m2, lambda: eval_140()),
			(cond_m6_m2 and cond_m7_m3, lambda: eval_140()),
			(cond_m6_m3 and cond_m7_m2, lambda: eval_140()),
			(cond_m3_m2 and cond_m4_m2, lambda: eval_138()),
			(cond_m3_m2 and cond_m5_m2, lambda: eval_138()),
			(cond_m3_m2 and cond_m6_m2, lambda: eval_138()),
			(cond_m3_m2 and cond_m7_m2, lambda: eval_138()),
			(cond_m4_m2 and cond_m5_m2, lambda: eval_137()),
			(cond_m4_m2 and cond_m6_m2, lambda: eval_137()),
			(cond_m4_m2 and cond_m7_m2, lambda: eval_140()),
			(cond_m5_m2 and cond_m6_m2, lambda: eval_137()),
			(cond_m5_m2 and cond_m7_m2, lambda: eval_140()),
			(cond_m6_m2 and cond_m7_m2, lambda: eval_140()),
			(cond_m2_m1 and cond_m7_m6, lambda: eval_139()),
			(cond_m3_m1 and cond_m7_m6, lambda: eval_139()),
			(cond_m4_m1 and cond_m7_m6, lambda: eval_140()),
			(cond_m5_m1 and cond_m7_m6, lambda: eval_140()),
			(cond_m6_m1 and cond_m7_m5, lambda: eval_140()),
			(cond_m6_m5 and cond_m7_m1, lambda: eval_136()),
			(cond_m2_m1 and cond_m6_m5, lambda: eval_133()),
			(cond_m2_m1 and cond_m7_m5, lambda: eval_139()),
			(cond_m3_m1 and cond_m6_m5, lambda: eval_133()),
			(cond_m3_m1 and cond_m7_m5, lambda: eval_139()),
			(cond_m4_m1 and cond_m6_m5, lambda: eval_136()),
			(cond_m4_m1 and cond_m7_m5, lambda: eval_140()),
			(cond_m5_m1 and cond_m6_m4, lambda: eval_136()),
			(cond_m5_m1 and cond_m7_m4, lambda: eval_140()),
			(cond_m5_m4 and cond_m6_m1, lambda: eval_136()),
			(cond_m5_m4 and cond_m7_m1, lambda: eval_137()),
			(cond_m6_m1 and cond_m7_m4, lambda: eval_140()),
			(cond_m6_m4 and cond_m7_m1, lambda: eval_137()),
			(cond_m2_m1 and cond_m5_m4, lambda: eval_134()),
			(cond_m2_m1 and cond_m6_m4, lambda: eval_134()),
			(cond_m2_m1 and cond_m7_m4, lambda: eval_139()),
			(cond_m3_m1 and cond_m5_m4, lambda: eval_134()),
			(cond_m3_m1 and cond_m6_m4, lambda: eval_134()),
			(cond_m3_m1 and cond_m7_m4, lambda: eval_139()),
			(cond_m4_m1 and cond_m5_m3, lambda: eval_140()),
			(cond_m4_m1 and cond_m6_m3, lambda: eval_140()),
			(cond_m4_m1 and cond_m7_m3, lambda: eval_140()),
			(cond_m4_m3 and cond_m5_m1, lambda: eval_140()),
			(cond_m4_m3 and cond_m6_m1, lambda: eval_140()),
			(cond_m4_m3 and cond_m7_m1, lambda: eval_140()),
			(cond_m5_m1 and cond_m6_m3, lambda: eval_140()),
			(cond_m5_m1 and cond_m7_m3, lambda: eval_140()),
			(cond_m5_m3 and cond_m6_m1, lambda: eval_140()),
			(cond_m5_m3 and cond_m7_m1, lambda: eval_140()),
			(cond_m6_m1 and cond_m7_m3, lambda: eval_140()),
			(cond_m6_m3 and cond_m7_m1, lambda: eval_140()),
			(cond_m2_m1 and cond_m4_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m5_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m6_m3, lambda: eval_139()),
			(cond_m2_m1 and cond_m7_m3, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m5_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m6_m2, lambda: eval_139()),
			(cond_m3_m1 and cond_m7_m2, lambda: eval_139()),
			(cond_m3_m2 and cond_m4_m1, lambda: eval_138()),
			(cond_m3_m2 and cond_m5_m1, lambda: eval_138()),
			(cond_m3_m2 and cond_m6_m1, lambda: eval_138()),
			(cond_m3_m2 and cond_m7_m1, lambda: eval_138()),
			(cond_m4_m1 and cond_m5_m2, lambda: eval_140()),
			(cond_m4_m1 and cond_m6_m2, lambda: eval_140()),
			(cond_m4_m1 and cond_m7_m2, lambda: eval_140()),
			(cond_m4_m2 and cond_m5_m1, lambda: eval_140()),
			(cond_m4_m2 and cond_m6_m1, lambda: eval_140()),
			(cond_m4_m2 and cond_m7_m1, lambda: eval_140()),
			(cond_m5_m1 and cond_m6_m2, lambda: eval_140()),
			(cond_m5_m1 and cond_m7_m2, lambda: eval_140()),
			(cond_m5_m2 and cond_m6_m1, lambda: eval_140()),
			(cond_m5_m2 and cond_m7_m1, lambda: eval_140()),
			(cond_m6_m1 and cond_m7_m2, lambda: eval_140()),
			(cond_m6_m2 and cond_m7_m1, lambda: eval_140()),
			(cond_m2_m1 and cond_m3_m1, lambda: eval_135()),
			(cond_m2_m1 and cond_m4_m1, lambda: eval_139()),
			(cond_m2_m1 and cond_m5_m1, lambda: eval_139()),
			(cond_m2_m1 and cond_m6_m1, lambda: eval_139()),
			(cond_m2_m1 and cond_m7_m1, lambda: eval_139()),
			(cond_m3_m1 and cond_m4_m1, lambda: eval_139()),
			(cond_m3_m1 and cond_m5_m1, lambda: eval_139()),
			(cond_m3_m1 and cond_m6_m1, lambda: eval_139()),
			(cond_m3_m1 and cond_m7_m1, lambda: eval_139()),
			(cond_m4_m1 and cond_m5_m1, lambda: eval_137()),
			(cond_m4_m1 and cond_m6_m1, lambda: eval_137()),
			(cond_m4_m1 and cond_m7_m1, lambda: eval_140()),
			(cond_m5_m1 and cond_m6_m1, lambda: eval_137()),
			(cond_m5_m1 and cond_m7_m1, lambda: eval_140()),
			(cond_m6_m1 and cond_m7_m1, lambda: eval_140()),
			(cond_m7_m6, lambda: eval_140()),
			(cond_m6_m5, lambda: eval_136()),
			(cond_m7_m5, lambda: eval_140()),
			(cond_m5_m4, lambda: eval_137()),
			(cond_m6_m4, lambda: eval_137()),
			(cond_m7_m4, lambda: eval_140()),
			(cond_m4_m3, lambda: eval_140()),
			(cond_m5_m3, lambda: eval_140()),
			(cond_m6_m3, lambda: eval_140()),
			(cond_m7_m3, lambda: eval_140()),
			(cond_m3_m2, lambda: eval_138()),
			(cond_m4_m2, lambda: eval_140()),
			(cond_m5_m2, lambda: eval_140()),
			(cond_m6_m2, lambda: eval_140()),
			(cond_m7_m2, lambda: eval_140()),
			(cond_m2_m1, lambda: eval_139()),
			(cond_m3_m1, lambda: eval_139()),
			(cond_m4_m1, lambda: eval_140()),
			(cond_m5_m1, lambda: eval_140()),
			(cond_m6_m1, lambda: eval_140()),
			(cond_m7_m1, lambda: eval_140()),
			(True, lambda: eval_140())
		]

		for condition,action in conditions:
			if condition:
				res = action()
				return res * mass_scale**(-6.)

	except Exception as e:
		raise Exception(f"There was an error when evaluating the T1113334 integral with masses {m1}, {m2}, {m3}, {m4}, {m5}, {m6}, {m7} from {e}")