# This file is automatically generated. Do not modify it manually!
from functools import lru_cache

from .config import cond, Number, getMudim, getDiffeps
from .OneLoop import B0fin, B0del
from .T134 import T134fin


@lru_cache(maxsize=150)
def T1113344(m1: Number, m2: Number, m3: Number, m4: Number, m5: Number, m6: Number, m7, mudim = None) -> Number:
	""" Computes the UV-finite part of the T1113344 integral.

	Args:
		m1: internal mass
		m2: internal mass
		m3: internal mass
		m4: internal mass
		m5: internal mass
		m6: internal mass
		m7: internal mass
		mudim: squared renormalization scale (if `None`, the global value is used)

	Returns:
		finite part of the T1113344 integral.
	"""

	try:

		if mudim is None:
			mudim = getMudim()

		# rescale masses for better numerical stability
		mass_scale = max([m1, m2, m3, m4, m5, m6, m7])
		if mass_scale <= getDiffeps():
			return 0
		m1 /= mass_scale
		m2 /= mass_scale
		m3 /= mass_scale
		m4 /= mass_scale
		m5 /= mass_scale
		m6 /= mass_scale
		m7 /= mass_scale
		mudim /= mass_scale**2
		m1, m2, m3 = sorted([m1, m2, m3])
		m4, m5 = sorted([m4, m5])
		m6, m7 = sorted([m6, m7])

		m1sq = m1**2
		m2sq = m2**2
		m3sq = m3**2
		m4sq = m4**2
		m5sq = m5**2
		m6sq = m6**2
		m7sq = m7**2

		def eval_1():
			return 0
		def eval_2():
			return (7*m7sq - 2*m7sq*B0fin(0,0,m7sq,mudim) - 4*T134fin(m7,0,0,mudim))/(2.*m7**8)
		def eval_3():
			return (7*m5sq - 2*m5sq*B0fin(0,0,m5sq,mudim) - 4*T134fin(m5,0,0,mudim))/(2.*m5**8)
		def eval_4():
			return (3*m3sq + 2*m3sq*B0fin(0,0,m3sq,mudim) - 2*T134fin(m3,0,0,mudim))/m3**8
		def eval_5():
			return (-7 + 30*B0fin(0,0,m5sq,mudim))/(18.*m5**6)
		def eval_6():
			return -0.5*(16*m3sq + 2*m3sq*B0del(0,0,m3sq,mudim) + 6*m3sq*B0fin(0,0,m3sq,mudim) + m3sq*B0fin(0,0,m3sq,mudim)**2 - 8*T134fin(m3,0,0,mudim))/m3**8
		def eval_7():
			return -0.5*(16*m3sq + 2*m3sq*B0del(0,0,m3sq,mudim) + 6*m3sq*B0fin(0,0,m3sq,mudim) + m3sq*B0fin(0,0,m3sq,mudim)**2 - 8*T134fin(m3,0,0,mudim))/m3**8
		def eval_8():
			return (-6*m2sq + 4*T134fin(m2,0,0,mudim))/m2**8
		def eval_9():
			return (-m5**10 + m5**6*m7**4 + m5**4*m7**6 + 4*m5sq*m7**8 - m7**10 + 4*m5**8*m7sq + 2*m5**4*m7**4*(m5sq + m7sq)*B0del(0,0,m5sq,mudim) + 2*m5**4*m7**4*(m5sq + m7sq)*B0del(0,0,m7sq,mudim) - 2*m5**6*m7**4*B0fin(0,0,m5sq,mudim) + 12*m5**4*m7**6*B0fin(0,0,m5sq,mudim) - 8*m5sq*m7**8*B0fin(0,0,m5sq,mudim) + 2*m7**10*B0fin(0,0,m5sq,mudim) + 2*m5**10*B0fin(0,0,m7sq,mudim) + 12*m5**6*m7**4*B0fin(0,0,m7sq,mudim) - 2*m5**4*m7**6*B0fin(0,0,m7sq,mudim) - 8*m5**8*m7sq*B0fin(0,0,m7sq,mudim) + 2*m5**6*m7**4*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim) + 2*m5**4*m7**6*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim) - 4*m5**4*m7**4*T134fin(m7,m5,0,mudim))/(2.*m5**4*m7**4*(m5sq - m7sq)**4)
		def eval_10():
			return (5*m3**6*m7**4 + 3*m3**4*m7**6 - m3sq*m7**8 - 3*m3**8*m7sq + 2*m3**4*m7**6*B0del(0,0,m3sq,mudim) + 2*m3**4*m7**6*B0del(0,0,m7sq,mudim) + 4*m3**4*m7**6*B0fin(0,0,m3sq,mudim) - 2*m3sq*m7**8*B0fin(0,0,m3sq,mudim) + 2*m3**6*m7**4*B0fin(0,0,m7sq,mudim) + 2*m3**4*m7**6*B0fin(0,0,m7sq,mudim) - 2*m3**8*m7sq*B0fin(0,0,m7sq,mudim) + 2*m3**4*m7**6*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim) + m3**4*m7**4*T134fin(m3,0,0,mudim) - 2*m3sq*m7**6*T134fin(m3,0,0,mudim) + m7**8*T134fin(m3,0,0,mudim) + 2*m3**8*T134fin(m7,0,0,mudim) + m3sq*m7**6*T134fin(m7,0,0,mudim) - 3*m3**6*m7sq*T134fin(m7,0,0,mudim) - m3**4*m7**4*T134fin(m7,m3,0,mudim) - m3sq*m7**6*T134fin(m7,m3,0,mudim))/(m3**6*m7**6*(m3sq - m7sq)**2)
		def eval_11():
			return (5*m3**6*m5**4 + 3*m3**4*m5**6 - m3sq*m5**8 - 3*m3**8*m5sq + 2*m3**4*m5**6*B0del(0,0,m3sq,mudim) + 2*m3**4*m5**6*B0del(0,0,m5sq,mudim) + 4*m3**4*m5**6*B0fin(0,0,m3sq,mudim) - 2*m3sq*m5**8*B0fin(0,0,m3sq,mudim) + 2*m3**6*m5**4*B0fin(0,0,m5sq,mudim) + 2*m3**4*m5**6*B0fin(0,0,m5sq,mudim) - 2*m3**8*m5sq*B0fin(0,0,m5sq,mudim) + 2*m3**4*m5**6*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + m3**4*m5**4*T134fin(m3,0,0,mudim) - 2*m3sq*m5**6*T134fin(m3,0,0,mudim) + m5**8*T134fin(m3,0,0,mudim) + 2*m3**8*T134fin(m5,0,0,mudim) + m3sq*m5**6*T134fin(m5,0,0,mudim) - 3*m3**6*m5sq*T134fin(m5,0,0,mudim) - m3**4*m5**4*T134fin(m5,m3,0,mudim) - m3sq*m5**6*T134fin(m5,m3,0,mudim))/(m3**6*m5**6*(m3sq - m5sq)**2)
		def eval_12():
			return (3*m2sq*m3**6 - 3*m2**6*m3sq + 2*m2sq*m3**6*B0fin(0,0,m2sq,mudim) - 2*m2**6*m3sq*B0fin(0,0,m3sq,mudim) - 2*m3**6*T134fin(m2,0,0,mudim) + 2*m2**6*T134fin(m3,0,0,mudim))/(m2**6*m3**6*(m2sq - m3sq))
		def eval_13():
			return -0.027777777777777776*(23 + 30*B0fin(0,0,m4sq,mudim))/m4**6
		def eval_14():
			return (9*m2sq + 2*m2sq*B0del(0,0,m2sq,mudim) + m2sq*B0fin(0,0,m2sq,mudim)**2 - 4*T134fin(m2,0,0,mudim))/(2.*m2**8)
		def eval_15():
			return (9*m2sq + 2*m2sq*B0del(0,0,m2sq,mudim) + m2sq*B0fin(0,0,m2sq,mudim)**2 - 4*T134fin(m2,0,0,mudim))/(2.*m2**8)
		def eval_16():
			return (m1sq - 4*m1sq*B0fin(0,0,m1sq,mudim) - 2*T134fin(m1,0,0,mudim))/m1**8
		def eval_17():
			return (-2*m4**10 + 51*m4**6*m5**4 - 19*m4**4*m5**6 + 43*m4sq*m5**8 - 9*m5**10 + 8*m4**8*m5sq + 18*m4**4*m5**4*(m4sq + m5sq)*B0del(0,0,m4sq,mudim) + 18*m4**4*m5**4*(m4sq + m5sq)*B0del(0,0,m5sq,mudim) - 18*m4**6*m5**4*B0fin(0,0,m4sq,mudim) + 108*m4**4*m5**6*B0fin(0,0,m4sq,mudim) - 72*m4sq*m5**8*B0fin(0,0,m4sq,mudim) + 18*m5**10*B0fin(0,0,m4sq,mudim) - 12*m4**10*B0fin(0,0,m5sq,mudim) - 72*m4**6*m5**4*B0fin(0,0,m5sq,mudim) + 102*m4**4*m5**6*B0fin(0,0,m5sq,mudim) - 30*m4sq*m5**8*B0fin(0,0,m5sq,mudim) + 48*m4**8*m5sq*B0fin(0,0,m5sq,mudim) + 18*m4**6*m5**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) + 18*m4**4*m5**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) - 36*m4**4*m5**4*T134fin(m5,m4,0,mudim))/(18.*m4**2*m5**4*(m4sq - m5sq)**5)
		def eval_18():
			return ((11 - 6*B0fin(0,0,m4sq,mudim))/(m4**6 - m4**4*m5sq) + (-9 + 18*B0fin(0,0,m4sq,mudim))/(m4**6 - m4**4*m5sq) + (9 - 18*B0fin(0,0,m5sq,mudim))/(-(m4sq*m5**4) + m4**4*m5sq) + (18*m5sq*(m4sq + m5sq)*(-2 + B0del(0,0,m4sq,mudim) + B0del(0,0,m5sq,mudim) + B0fin(0,0,m4sq,mudim) + B0fin(0,0,m5sq,mudim) + B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim)))/(-m4sq + m5sq)**5 + (9*(-m4**6 - 7*m4sq*m5**4 - m5**6 - 7*m4**4*m5sq + 2*(m4**3 - m4*m5sq)**2*B0fin(0,0,m4sq,mudim) + 2*(-(m4sq*m5) + m5**3)**2*B0fin(0,0,m5sq,mudim) + 4*m4sq*m5sq*T134fin(m5,m4,0,mudim)))/(m4**2*(m4sq - m5sq)**5))/18.
		def eval_19():
			return (2*(m3sq - 2*m5sq)*m5sq*B0del(0,0,m5sq,mudim) + 2*(m3sq - 2*m5sq)*m5sq*B0fin(0,0,m5sq,mudim) + (m3sq - 2*m5sq)*m5sq*B0fin(0,0,m5sq,mudim)**2 + 2*m5sq*T134fin(m3,0,0,mudim) - 4*(m3sq - m5sq)*T134fin(m5,0,0,mudim) + 2*m5sq*(5*m3sq - 2*m5sq - 2*T134fin(m5,m3,0,mudim) + T134fin(m5,m5,m3,mudim)))/(2.*m3**4*m5**6)
		def eval_20():
			return (4*m2**4*m3**6*(B0del(0,0,m2sq,mudim) + B0del(0,0,m3sq,mudim) - B0fin(0,0,m2sq,mudim) - B0fin(0,0,m3sq,mudim) + B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim)) + m2**4*(m2sq - m3sq)**2*m3sq*(6 + 2*B0del(0,0,m3sq,mudim) - 6*B0fin(0,0,m3sq,mudim) + B0fin(0,0,m3sq,mudim)**2) - 2*m3**4*(m2sq - m3sq)**2*(m2sq + 2*m2sq*B0fin(0,0,m2sq,mudim) - T134fin(m2,0,0,mudim)) + 2*(2*m2sq - m3sq)*(m2**3 - m2*m3sq)**2*(m3sq + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,0,0,mudim)) + 2*m2sq*m3**4*(m2sq + m3sq)*(m2sq + m3sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,m2,0,mudim)))/(2.*m2**4*m3**6*(m2sq - m3sq)**3)
		def eval_21():
			return (4*m2**4*m3**6*(B0del(0,0,m2sq,mudim) + B0del(0,0,m3sq,mudim) - B0fin(0,0,m2sq,mudim) - B0fin(0,0,m3sq,mudim) + B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim)) + m2**4*(m2sq - m3sq)**2*m3sq*(6 + 2*B0del(0,0,m3sq,mudim) - 6*B0fin(0,0,m3sq,mudim) + B0fin(0,0,m3sq,mudim)**2) - 2*m3**4*(m2sq - m3sq)**2*(m2sq + 2*m2sq*B0fin(0,0,m2sq,mudim) - T134fin(m2,0,0,mudim)) + 2*(2*m2sq - m3sq)*(m2**3 - m2*m3sq)**2*(m3sq + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,0,0,mudim)) + 2*m2sq*m3**4*(m2sq + m3sq)*(m2sq + m3sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,m2,0,mudim)))/(2.*m2**4*m3**6*(m2sq - m3sq)**3)
		def eval_22():
			return (-6*m1**4*m2**4 + 3*m1sq*m2**6 + 3*m1**6*m2sq + 2*m1sq*m2**6*B0fin(0,0,m1sq,mudim) - 2*m1**6*m2sq*B0fin(0,0,m2sq,mudim) - 2*m2**6*T134fin(m1,0,0,mudim) - 2*m1**6*T134fin(m2,0,0,mudim) + 4*m1**4*m2sq*T134fin(m2,0,0,mudim))/(m1**4*m2**6*(m1sq - m2sq)**2)
		def eval_23():
			return -0.5*((m3**3 - m3*m7sq)**2*(6 + 2*B0del(0,0,m3sq,mudim) - 6*B0fin(0,0,m3sq,mudim) + B0fin(0,0,m3sq,mudim)**2) + 4*m3**4*m7sq*(B0del(0,0,m3sq,mudim) + B0del(0,0,m7sq,mudim) - B0fin(0,0,m3sq,mudim) - B0fin(0,0,m7sq,mudim) + B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim)) + 2*(m3sq - m7sq)**2*(4*m3sq + 4*m3sq*B0fin(0,0,m3sq,mudim) - 3*T134fin(m3,0,0,mudim)) - (2*(m3**3 - m3*m7sq)**2*(m7**4 + 3*m3sq*m7sq + 2*m7sq*(m3sq + m7sq)*B0fin(0,0,m7sq,mudim) - (2*m3sq + m7sq)*T134fin(m7,0,0,mudim)))/m7**4 + 2*m3sq*(m3sq + m7sq)*(m3sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim) - T134fin(m7,m3,0,mudim)))/(m3**6*(m3sq - m7sq)**3)
		def eval_24():
			return -0.5*((m3**3 - m3*m5sq)**2*(6 + 2*B0del(0,0,m3sq,mudim) - 6*B0fin(0,0,m3sq,mudim) + B0fin(0,0,m3sq,mudim)**2) + 4*m3**4*m5sq*(B0del(0,0,m3sq,mudim) + B0del(0,0,m5sq,mudim) - B0fin(0,0,m3sq,mudim) - B0fin(0,0,m5sq,mudim) + B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim)) + 2*(m3sq - m5sq)**2*(4*m3sq + 4*m3sq*B0fin(0,0,m3sq,mudim) - 3*T134fin(m3,0,0,mudim)) - (2*(m3**3 - m3*m5sq)**2*(m5**4 + 3*m3sq*m5sq + 2*m5sq*(m3sq + m5sq)*B0fin(0,0,m5sq,mudim) - (2*m3sq + m5sq)*T134fin(m5,0,0,mudim)))/m5**4 + 2*m3sq*(m3sq + m5sq)*(m3sq + m5sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) - T134fin(m5,m3,0,mudim)))/(m3**6*(m3sq - m5sq)**3)
		def eval_25():
			return (-10*m2**6*m7**4 + 7*m2**4*m7**6 - 2*m2sq*m7**8 + m2**8*m7sq + (-3*m2**6*m7**4 + m2**4*m7**6)*B0del(0,0,m2sq,mudim) + (-3*m2**6*m7**4 + m2**4*m7**6)*B0del(0,0,m7sq,mudim) - 3*m2**6*m7**4*B0fin(0,0,m2sq,mudim) + m2**4*m7**6*B0fin(0,0,m2sq,mudim) - 7*m2**6*m7**4*B0fin(0,0,m7sq,mudim) + 3*m2**4*m7**6*B0fin(0,0,m7sq,mudim) + 2*m2**8*m7sq*B0fin(0,0,m7sq,mudim) - 3*m2**6*m7**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) + m2**4*m7**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) + 3*m2**4*m7**4*T134fin(m2,0,0,mudim) - 3*m2sq*m7**6*T134fin(m2,0,0,mudim) + m7**8*T134fin(m2,0,0,mudim) - m2**6*m7sq*T134fin(m2,0,0,mudim) - m2**8*T134fin(m7,0,0,mudim) - 3*m2**4*m7**4*T134fin(m7,0,0,mudim) + m2sq*m7**6*T134fin(m7,0,0,mudim) + 3*m2**6*m7sq*T134fin(m7,0,0,mudim) + 2*m2**4*m7**4*T134fin(m7,m2,0,mudim) - m2sq*m7**6*T134fin(m7,m2,0,mudim) + m2**6*m7sq*T134fin(m7,m2,0,mudim))/(m2**6*m7**4*(m2sq - m7sq)**3)
		def eval_26():
			return (-10*m2**6*m5**4 + 7*m2**4*m5**6 - 2*m2sq*m5**8 + m2**8*m5sq + (-3*m2**6*m5**4 + m2**4*m5**6)*B0del(0,0,m2sq,mudim) + (-3*m2**6*m5**4 + m2**4*m5**6)*B0del(0,0,m5sq,mudim) - 3*m2**6*m5**4*B0fin(0,0,m2sq,mudim) + m2**4*m5**6*B0fin(0,0,m2sq,mudim) - 7*m2**6*m5**4*B0fin(0,0,m5sq,mudim) + 3*m2**4*m5**6*B0fin(0,0,m5sq,mudim) + 2*m2**8*m5sq*B0fin(0,0,m5sq,mudim) - 3*m2**6*m5**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + m2**4*m5**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 3*m2**4*m5**4*T134fin(m2,0,0,mudim) - 3*m2sq*m5**6*T134fin(m2,0,0,mudim) + m5**8*T134fin(m2,0,0,mudim) - m2**6*m5sq*T134fin(m2,0,0,mudim) - m2**8*T134fin(m5,0,0,mudim) - 3*m2**4*m5**4*T134fin(m5,0,0,mudim) + m2sq*m5**6*T134fin(m5,0,0,mudim) + 3*m2**6*m5sq*T134fin(m5,0,0,mudim) + 2*m2**4*m5**4*T134fin(m5,m2,0,mudim) - m2sq*m5**6*T134fin(m5,m2,0,mudim) + m2**6*m5sq*T134fin(m5,m2,0,mudim))/(m2**6*m5**4*(m2sq - m5sq)**3)
		def eval_27():
			return -0.5*(((m2sq - m3sq)**2*(6 + 2*B0del(0,0,m2sq,mudim) - 6*B0fin(0,0,m2sq,mudim) + B0fin(0,0,m2sq,mudim)**2))/m2**4 + 4*(B0del(0,0,m2sq,mudim) + B0del(0,0,m3sq,mudim) - B0fin(0,0,m2sq,mudim) - B0fin(0,0,m3sq,mudim) + B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim)) - (2*(m2sq - 2*m3sq)*(m2sq - m3sq)**2*(m2sq + 2*m2sq*B0fin(0,0,m2sq,mudim) - T134fin(m2,0,0,mudim)))/(m2**6*m3**2) - (2*(m2sq - m3sq)**2*(m3sq + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,0,0,mudim)))/(m2**2*m3**4) + (2*(m2sq + m3sq)*(m2sq + m3sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,m2,0,mudim)))/(m2**2*m3**2))/(m2sq - m3sq)**3
		def eval_28():
			return -0.5*(((m2sq - m3sq)**2*(6 + 2*B0del(0,0,m2sq,mudim) - 6*B0fin(0,0,m2sq,mudim) + B0fin(0,0,m2sq,mudim)**2))/m2**4 + 4*(B0del(0,0,m2sq,mudim) + B0del(0,0,m3sq,mudim) - B0fin(0,0,m2sq,mudim) - B0fin(0,0,m3sq,mudim) + B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim)) - (2*(m2sq - 2*m3sq)*(m2sq - m3sq)**2*(m2sq + 2*m2sq*B0fin(0,0,m2sq,mudim) - T134fin(m2,0,0,mudim)))/(m2**6*m3**2) - (2*(m2sq - m3sq)**2*(m3sq + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,0,0,mudim)))/(m2**2*m3**4) + (2*(m2sq + m3sq)*(m2sq + m3sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,m2,0,mudim)))/(m2**2*m3**2))/(m2sq - m3sq)**3
		def eval_29():
			return (-6*m1**4*m3**4 + 3*m1sq*m3**6 + 3*m1**6*m3sq - 2*m1sq*m3**6*B0fin(0,0,m1sq,mudim) + 2*m1**6*m3sq*B0fin(0,0,m3sq,mudim) + 4*m1sq*m3**4*T134fin(m1,0,0,mudim) - 2*m3**6*T134fin(m1,0,0,mudim) - 2*m1**6*T134fin(m3,0,0,mudim))/(m1**6*m3**4*(m1sq - m3sq)**2)
		def eval_30():
			return ((-2*m3sq)/(m6**4 - m6sq*m7sq) + (2*m3sq)/(-m7**4 + m6sq*m7sq) + (2*m3sq*m6sq*B0del(0,0,m3sq,mudim))/((m3sq - m6sq)**2*(m6sq - m7sq)) + (2*m3sq*m7sq*B0del(0,0,m3sq,mudim))/((m3sq - m7sq)**2*(-m6sq + m7sq)) + (2*m3sq*m6sq*B0del(0,0,m6sq,mudim))/((m3sq - m6sq)**2*(m6sq - m7sq)) + (2*m3sq*m7sq*B0del(0,0,m7sq,mudim))/((m3sq - m7sq)**2*(-m6sq + m7sq)) - (2*m3sq*m6sq*B0fin(0,0,m3sq,mudim))/((m3sq - m6sq)**2*(m6sq - m7sq)) + (2*m3sq*m7sq*B0fin(0,0,m3sq,mudim))/((m3sq - m7sq)**2*(m6sq - m7sq)) - (2*m3sq*m6sq*B0fin(0,0,m6sq,mudim))/((m3sq - m6sq)**2*(m6sq - m7sq)) + (2*m3sq*m6sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim))/((m3sq - m6sq)**2*(m6sq - m7sq)) - (1 + 2*B0fin(0,0,m6sq,mudim))/(m6sq - m7sq) - (m3sq*(1 + 2*B0fin(0,0,m6sq,mudim)))/(m6**4 - m6sq*m7sq) + ((m3sq + m6sq)*(m3sq + m6sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m3sq - m6sq)**2*(m6sq - m7sq)) + (2*m3sq*m7sq*B0fin(0,0,m7sq,mudim))/((m3sq - m7sq)**2*(m6sq - m7sq)) + (2*m3sq*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim))/((m3sq - m7sq)**2*(-m6sq + m7sq)) + (1 + 2*B0fin(0,0,m7sq,mudim))/(m6sq - m7sq) + (m3sq*(1 + 2*B0fin(0,0,m7sq,mudim)))/(m7**2*(m6sq - m7sq)) + ((m3sq + m7sq)*(m3sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m3sq - m7sq)**2*(-m6sq + m7sq)) + (2*m3sq*T134fin(m6,0,0,mudim))/(m6**6 - m6**4*m7sq) + T134fin(m6,0,0,mudim)/(m6**4 - m6sq*m7sq) - ((m3sq + m6sq)*T134fin(m6,m3,0,mudim))/((m3sq - m6sq)**2*(m6sq - m7sq)) + (2*m3sq*T134fin(m7,0,0,mudim))/(-(m6sq*m7**4) + m7**6) + T134fin(m7,0,0,mudim)/(m7**4 - m6sq*m7sq) + ((m3sq + m7sq)*T134fin(m7,m3,0,mudim))/((m3sq - m7sq)**2*(m6sq - m7sq)))/m3**4
		def eval_31():
			return ((-2*m3sq*B0del(0,0,m5sq,mudim))/(m5sq - m7sq)**2 - (2*m3sq*B0del(0,0,m7sq,mudim))/(m5sq - m7sq)**2 + (2*m3sq*B0fin(0,0,m5sq,mudim))/(m5sq - m7sq)**2 + (m3sq*(1 + 2*B0fin(0,0,m5sq,mudim)))/(m5**2*m7**2) + (2*m3sq*B0fin(0,0,m7sq,mudim))/(m5sq - m7sq)**2 - (2*m3sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/(m5sq - m7sq)**2 + (m3sq*(1 + 2*B0fin(0,0,m7sq,mudim)))/(m5**2*m7**2) - (m3sq*(m5sq + m7sq)*(m5sq + m7sq + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m5**2*m7**2*(m5sq - m7sq)**2) + T134fin(m3,0,0,mudim)/(m5**2*m7**2) - (m3sq*T134fin(m5,0,0,mudim))/(m5**4*m7**2) + T134fin(m5,0,0,mudim)/(m5**2*m7**2) - T134fin(m5,m3,0,mudim)/(m5**2*m7**2) - (m3sq*T134fin(m7,0,0,mudim))/(m5**2*m7**4) + T134fin(m7,0,0,mudim)/(m5**2*m7**2) - T134fin(m7,m3,0,mudim)/(m5**2*m7**2) - T134fin(m7,m5,0,mudim)/(m5**2*m7**2) + (m3sq*(m5sq + m7sq)*T134fin(m7,m5,0,mudim))/(m5**2*m7**2*(m5sq - m7sq)**2) + T134fin(m7,m5,m3,mudim)/(m5**2*m7**2))/m3**4
		def eval_32():
			return ((-2*m3sq)/(m4**4 - m4sq*m5sq) + (2*m3sq)/(-m5**4 + m4sq*m5sq) + (2*m3sq*m4sq*B0del(0,0,m3sq,mudim))/((m3sq - m4sq)**2*(m4sq - m5sq)) + (2*m3sq*m5sq*B0del(0,0,m3sq,mudim))/((m3sq - m5sq)**2*(-m4sq + m5sq)) + (2*m3sq*m4sq*B0del(0,0,m4sq,mudim))/((m3sq - m4sq)**2*(m4sq - m5sq)) + (2*m3sq*m5sq*B0del(0,0,m5sq,mudim))/((m3sq - m5sq)**2*(-m4sq + m5sq)) - (2*m3sq*m4sq*B0fin(0,0,m3sq,mudim))/((m3sq - m4sq)**2*(m4sq - m5sq)) + (2*m3sq*m5sq*B0fin(0,0,m3sq,mudim))/((m3sq - m5sq)**2*(m4sq - m5sq)) - (2*m3sq*m4sq*B0fin(0,0,m4sq,mudim))/((m3sq - m4sq)**2*(m4sq - m5sq)) + (2*m3sq*m4sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim))/((m3sq - m4sq)**2*(m4sq - m5sq)) - (1 + 2*B0fin(0,0,m4sq,mudim))/(m4sq - m5sq) - (m3sq*(1 + 2*B0fin(0,0,m4sq,mudim)))/(m4**4 - m4sq*m5sq) + ((m3sq + m4sq)*(m3sq + m4sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim)))/((m3sq - m4sq)**2*(m4sq - m5sq)) + (2*m3sq*m5sq*B0fin(0,0,m5sq,mudim))/((m3sq - m5sq)**2*(m4sq - m5sq)) + (2*m3sq*m5sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim))/((m3sq - m5sq)**2*(-m4sq + m5sq)) + (1 + 2*B0fin(0,0,m5sq,mudim))/(m4sq - m5sq) + (m3sq*(1 + 2*B0fin(0,0,m5sq,mudim)))/(m5**2*(m4sq - m5sq)) + ((m3sq + m5sq)*(m3sq + m5sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim)))/((m3sq - m5sq)**2*(-m4sq + m5sq)) + (2*m3sq*T134fin(m4,0,0,mudim))/(m4**6 - m4**4*m5sq) + T134fin(m4,0,0,mudim)/(m4**4 - m4sq*m5sq) - ((m3sq + m4sq)*T134fin(m4,m3,0,mudim))/((m3sq - m4sq)**2*(m4sq - m5sq)) + (2*m3sq*T134fin(m5,0,0,mudim))/(-(m4sq*m5**4) + m5**6) + T134fin(m5,0,0,mudim)/(m5**4 - m4sq*m5sq) + ((m3sq + m5sq)*T134fin(m5,m3,0,mudim))/((m3sq - m5sq)**2*(m4sq - m5sq)))/m3**4
		def eval_33():
			return (2*m2**4*m3sq*m7**4*(m3**3 - m3*m7sq)**2*B0del(0,0,m2sq,mudim) - 2*m2sq*m3**4*m7**4*(m2**3 - m2*m7sq)**2*B0del(0,0,m3sq,mudim) - 2*m2sq*m3**4*m7**4*(m2**3 - m2*m7sq)**2*B0del(0,0,m7sq,mudim) + 2*m2**4*m3sq*m7**4*(m3**3 - m3*m7sq)**2*B0del(0,0,m7sq,mudim) - 2*m2**4*m3sq*m7**4*(m3**3 - m3*m7sq)**2*B0fin(0,0,m2sq,mudim) - m2sq*m3**4*(m2sq - m7sq)**2*(m3sq - m7sq)**2*m7sq*(1 + 2*B0fin(0,0,m2sq,mudim)) + 2*m2sq*m3**4*m7**4*(m2**3 - m2*m7sq)**2*B0fin(0,0,m3sq,mudim) + m2**4*m3sq*(m2sq - m7sq)**2*(m3sq - m7sq)**2*m7sq*(1 + 2*B0fin(0,0,m3sq,mudim)) + 2*m2sq*m3**4*m7**4*(m2**3 - m2*m7sq)**2*B0fin(0,0,m7sq,mudim) - 2*m2**4*m3sq*m7**4*(m3**3 - m3*m7sq)**2*B0fin(0,0,m7sq,mudim) + 2*m2**4*m3sq*m7**4*(m3**3 - m3*m7sq)**2*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) - 2*m2sq*m3**4*m7**4*(m2**3 - m2*m7sq)**2*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim) + m2sq*(m2sq - m3sq)*m3sq*(m2sq - m7sq)**2*(m3sq - m7sq)**2*m7sq*(1 + 2*B0fin(0,0,m7sq,mudim)) + m2sq*m3**4*(m3sq - m7sq)**2*m7sq*(m2sq + m7sq)*(m2sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)) - m2**4*m3sq*(m2sq - m7sq)**2*m7sq*(m3sq + m7sq)*(m3sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)) + m3**4*(m2sq - m7sq)**2*(m3sq - m7sq)**2*m7sq*T134fin(m2,0,0,mudim) - m2**4*(m2sq - m7sq)**2*(m3sq - m7sq)**2*m7sq*T134fin(m3,0,0,mudim) - m2sq*(m2sq - m3sq)*m3sq*(m2sq - m7sq)**2*(m3sq - m7sq)**2*T134fin(m7,0,0,mudim) - m2sq*m3**4*(m3sq - m7sq)**2*m7sq*(m2sq + m7sq)*T134fin(m7,m2,0,mudim) + m2**4*m3sq*(m2sq - m7sq)**2*m7sq*(m3sq + m7sq)*T134fin(m7,m3,0,mudim))/(m2**4*m3**4*(m2sq - m3sq)*m7**4*(m2sq - m7sq)**2*(m3sq - m7sq)**2)
		def eval_34():
			return (2*m2**4*m3sq*m5**4*(m3**3 - m3*m5sq)**2*B0del(0,0,m2sq,mudim) - 2*m2sq*m3**4*m5**4*(m2**3 - m2*m5sq)**2*B0del(0,0,m3sq,mudim) - 2*m2sq*m3**4*m5**4*(m2**3 - m2*m5sq)**2*B0del(0,0,m5sq,mudim) + 2*m2**4*m3sq*m5**4*(m3**3 - m3*m5sq)**2*B0del(0,0,m5sq,mudim) - 2*m2**4*m3sq*m5**4*(m3**3 - m3*m5sq)**2*B0fin(0,0,m2sq,mudim) - m2sq*m3**4*(m2sq - m5sq)**2*(m3sq - m5sq)**2*m5sq*(1 + 2*B0fin(0,0,m2sq,mudim)) + 2*m2sq*m3**4*m5**4*(m2**3 - m2*m5sq)**2*B0fin(0,0,m3sq,mudim) + m2**4*m3sq*(m2sq - m5sq)**2*(m3sq - m5sq)**2*m5sq*(1 + 2*B0fin(0,0,m3sq,mudim)) + 2*m2sq*m3**4*m5**4*(m2**3 - m2*m5sq)**2*B0fin(0,0,m5sq,mudim) - 2*m2**4*m3sq*m5**4*(m3**3 - m3*m5sq)**2*B0fin(0,0,m5sq,mudim) + 2*m2**4*m3sq*m5**4*(m3**3 - m3*m5sq)**2*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m2sq*m3**4*m5**4*(m2**3 - m2*m5sq)**2*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + m2sq*(m2sq - m3sq)*m3sq*(m2sq - m5sq)**2*(m3sq - m5sq)**2*m5sq*(1 + 2*B0fin(0,0,m5sq,mudim)) + m2sq*m3**4*(m3sq - m5sq)**2*m5sq*(m2sq + m5sq)*(m2sq + m5sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim)) - m2**4*m3sq*(m2sq - m5sq)**2*m5sq*(m3sq + m5sq)*(m3sq + m5sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim)) + m3**4*(m2sq - m5sq)**2*(m3sq - m5sq)**2*m5sq*T134fin(m2,0,0,mudim) - m2**4*(m2sq - m5sq)**2*(m3sq - m5sq)**2*m5sq*T134fin(m3,0,0,mudim) - m2sq*(m2sq - m3sq)*m3sq*(m2sq - m5sq)**2*(m3sq - m5sq)**2*T134fin(m5,0,0,mudim) - m2sq*m3**4*(m3sq - m5sq)**2*m5sq*(m2sq + m5sq)*T134fin(m5,m2,0,mudim) + m2**4*m3sq*(m2sq - m5sq)**2*m5sq*(m3sq + m5sq)*T134fin(m5,m3,0,mudim))/(m2**4*m3**4*(m2sq - m3sq)*m5**4*(m2sq - m5sq)**2*(m3sq - m5sq)**2)
		def eval_35():
			return (3*m1sq*m2**6*m3**4 - 3*m1**6*m2sq*m3**4 - 3*m1sq*m2**4*m3**6 + 3*m1**4*m2sq*m3**6 + 3*m1**6*m2**4*m3sq - 3*m1**4*m2**6*m3sq + 2*m1sq*m2**4*m3**4*(m2sq - m3sq)*B0fin(0,0,m1sq,mudim) + 2*m1**4*m2sq*m3**4*(-m1sq + m3sq)*B0fin(0,0,m2sq,mudim) + 2*m1**6*m2**4*m3sq*B0fin(0,0,m3sq,mudim) - 2*m1**4*m2**6*m3sq*B0fin(0,0,m3sq,mudim) - 2*m2**6*m3**4*T134fin(m1,0,0,mudim) + 2*m2**4*m3**6*T134fin(m1,0,0,mudim) + 2*m1**6*m3**4*T134fin(m2,0,0,mudim) - 2*m1**4*m3**6*T134fin(m2,0,0,mudim) - 2*m1**6*m2**4*T134fin(m3,0,0,mudim) + 2*m1**4*m2**6*T134fin(m3,0,0,mudim))/(m1**4*m2**4*(m1sq - m2sq)*m3**4*(m1sq - m3sq)*(m2sq - m3sq))
		def eval_36():
			return (17 - 60*B0fin(0,0,m4sq,mudim))/(450.*m4**6)
		def eval_37():
			return -0.16666666666666666*(9*m3sq + 12*m3sq*B0del(0,0,m3sq,mudim) + 6*m3sq*B0fin(0,0,m3sq,mudim) + 6*m3sq*B0fin(0,0,m3sq,mudim)**2 - 6*T134fin(m3,0,0,mudim) - 2*T134fin(m3,m3,m3,mudim))/m3**8
		def eval_38():
			return -0.16666666666666666*(9*m3sq + 12*m3sq*B0del(0,0,m3sq,mudim) + 6*m3sq*B0fin(0,0,m3sq,mudim) + 6*m3sq*B0fin(0,0,m3sq,mudim)**2 - 6*T134fin(m3,0,0,mudim) - 2*T134fin(m3,m3,m3,mudim))/m3**8
		def eval_39():
			return (25 + 24*B0fin(0,0,m1sq,mudim))/(36.*m1**6)
		def eval_40():
			return (25 + 24*B0fin(0,0,m1sq,mudim))/(36.*m1**6)
		def eval_41():
			return (5*m4**10 + 176*m4**6*m5**4 + 40*m4**4*m5**6 + 259*m4sq*m5**8 - 23*m5**10 - 25*m4**8*m5sq + 36*m4sq*m5**4*(m4**4 + 2*m5**4 + 3*m4sq*m5sq)*B0del(0,0,m4sq,mudim) + 36*m4sq*m5**4*(m4**4 + 2*m5**4 + 3*m4sq*m5sq)*B0del(0,0,m5sq,mudim) - 72*m4**6*m5**4*B0fin(0,0,m4sq,mudim) + 252*m4**4*m5**6*B0fin(0,0,m4sq,mudim) + 36*m4sq*m5**8*B0fin(0,0,m4sq,mudim) - 6*m4**10*B0fin(0,0,m5sq,mudim) - 96*m4**6*m5**4*B0fin(0,0,m5sq,mudim) + 348*m4**4*m5**6*B0fin(0,0,m5sq,mudim) - 30*m4sq*m5**8*B0fin(0,0,m5sq,mudim) - 30*m5**10*B0fin(0,0,m5sq,mudim) + 30*m4**8*m5sq*B0fin(0,0,m5sq,mudim) + 36*m4**6*m5**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) + 108*m4**4*m5**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) + 72*m4sq*m5**8*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) - 72*m4**4*m5**4*T134fin(m5,m4,0,mudim) - 144*m4sq*m5**6*T134fin(m5,m4,0,mudim))/(36.*m5**4*(m4sq - m5sq)**6)
		def eval_42():
			return -((3*m4**6 + 21*m4sq*m6**4 + 3*m6**6 + 21*m4**4*m6sq + 2*(m4**6 + 5*m4sq*m6**4 + m6**6 + 5*m4**4*m6sq)*B0del(0,0,m4sq,mudim) + 2*(m4**6 + 5*m4sq*m6**4 + m6**6 + 5*m4**4*m6sq)*B0del(0,0,m6sq,mudim) - 7*m4**6*B0fin(0,0,m4sq,mudim) + 21*m4sq*m6**4*B0fin(0,0,m4sq,mudim) - m6**6*B0fin(0,0,m4sq,mudim) + 11*m4**4*m6sq*B0fin(0,0,m4sq,mudim) - m4**6*B0fin(0,0,m6sq,mudim) + 11*m4sq*m6**4*B0fin(0,0,m6sq,mudim) - 7*m6**6*B0fin(0,0,m6sq,mudim) + 21*m4**4*m6sq*B0fin(0,0,m6sq,mudim) + 2*m4**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) + 10*m4sq*m6**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m6**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) + 10*m4**4*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m4**4*T134fin(m6,m4,0,mudim) - 4*m6**4*T134fin(m6,m4,0,mudim) - 16*m4sq*m6sq*T134fin(m6,m4,0,mudim))/(m4sq - m6sq)**6)
		def eval_43():
			return -0.05555555555555555*(-11*m4**10 + 32*m4**6*m5**4 + 32*m4**4*m5**6 + 51*m4sq*m5**8 - 11*m5**10 + 51*m4**8*m5sq + 36*m4**4*m5**4*(m4sq + m5sq)*B0del(0,0,m4sq,mudim) + 36*m4**4*m5**4*(m4sq + m5sq)*B0del(0,0,m5sq,mudim) + 84*m4**6*m5**4*B0fin(0,0,m4sq,mudim) + 36*m4**4*m5**6*B0fin(0,0,m4sq,mudim) - 24*m4sq*m5**8*B0fin(0,0,m4sq,mudim) + 6*m5**10*B0fin(0,0,m4sq,mudim) - 30*m4**8*m5sq*B0fin(0,0,m4sq,mudim) + 6*m4**10*B0fin(0,0,m5sq,mudim) + 36*m4**6*m5**4*B0fin(0,0,m5sq,mudim) + 84*m4**4*m5**6*B0fin(0,0,m5sq,mudim) - 30*m4sq*m5**8*B0fin(0,0,m5sq,mudim) - 24*m4**8*m5sq*B0fin(0,0,m5sq,mudim) + 36*m4**6*m5**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) + 36*m4**4*m5**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) - 72*m4**4*m5**4*T134fin(m5,m4,0,mudim))/(m4**2*m5**2*(m4sq - m5sq)**6)
		def eval_44():
			return (-23*m4**10 + 40*m4**6*m7**4 + 176*m4**4*m7**6 - 25*m4sq*m7**8 + 5*m7**10 + 259*m4**8*m7sq + 36*m4**4*m7sq*(2*m4**4 + m7**4 + 3*m4sq*m7sq)*B0del(0,0,m4sq,mudim) + 36*m4**4*m7sq*(2*m4**4 + m7**4 + 3*m4sq*m7sq)*B0del(0,0,m7sq,mudim) - 30*m4**10*B0fin(0,0,m4sq,mudim) + 348*m4**6*m7**4*B0fin(0,0,m4sq,mudim) - 96*m4**4*m7**6*B0fin(0,0,m4sq,mudim) + 30*m4sq*m7**8*B0fin(0,0,m4sq,mudim) - 6*m7**10*B0fin(0,0,m4sq,mudim) - 30*m4**8*m7sq*B0fin(0,0,m4sq,mudim) + 252*m4**6*m7**4*B0fin(0,0,m7sq,mudim) - 72*m4**4*m7**6*B0fin(0,0,m7sq,mudim) + 36*m4**8*m7sq*B0fin(0,0,m7sq,mudim) + 108*m4**6*m7**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) + 36*m4**4*m7**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) + 72*m4**8*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) - 72*m4**4*m7**4*T134fin(m7,m4,0,mudim) - 144*m4**6*m7sq*T134fin(m7,m4,0,mudim))/(36.*m4**4*(m4sq - m7sq)**6)
		def eval_45():
			return (-23*m4**10 + 40*m4**6*m5**4 + 176*m4**4*m5**6 - 25*m4sq*m5**8 + 5*m5**10 + 259*m4**8*m5sq + 36*m4**4*m5sq*(2*m4**4 + m5**4 + 3*m4sq*m5sq)*B0del(0,0,m4sq,mudim) + 36*m4**4*m5sq*(2*m4**4 + m5**4 + 3*m4sq*m5sq)*B0del(0,0,m5sq,mudim) - 30*m4**10*B0fin(0,0,m4sq,mudim) + 348*m4**6*m5**4*B0fin(0,0,m4sq,mudim) - 96*m4**4*m5**6*B0fin(0,0,m4sq,mudim) + 30*m4sq*m5**8*B0fin(0,0,m4sq,mudim) - 6*m5**10*B0fin(0,0,m4sq,mudim) - 30*m4**8*m5sq*B0fin(0,0,m4sq,mudim) + 252*m4**6*m5**4*B0fin(0,0,m5sq,mudim) - 72*m4**4*m5**6*B0fin(0,0,m5sq,mudim) + 36*m4**8*m5sq*B0fin(0,0,m5sq,mudim) + 108*m4**6*m5**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) + 36*m4**4*m5**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) + 72*m4**8*m5sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) - 72*m4**4*m5**4*T134fin(m5,m4,0,mudim) - 144*m4**6*m5sq*T134fin(m5,m4,0,mudim))/(36.*m4**4*(m4sq - m5sq)**6)
		def eval_46():
			return (m3**6 + 22*m3sq*m4**4 - 4*m4**6 - 7*m3**4*m4sq + 6*m3sq*m4**4*B0del(0,0,m3sq,mudim) - 2*m4sq*(m3**4 + 2*m4**4 - 6*m3sq*m4sq)*B0del(0,0,m4sq,mudim) + 6*m3sq*m4**4*B0fin(0,0,m3sq,mudim) + 2*m3**6*B0fin(0,0,m4sq,mudim) + 20*m3sq*m4**4*B0fin(0,0,m4sq,mudim) - 4*m4**6*B0fin(0,0,m4sq,mudim) - 12*m3**4*m4sq*B0fin(0,0,m4sq,mudim) + 6*m3sq*m4**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + 3*m3sq*m4**4*B0fin(0,0,m4sq,mudim)**2 - 2*m4**6*B0fin(0,0,m4sq,mudim)**2 - m3**4*m4sq*B0fin(0,0,m4sq,mudim)**2 + 2*m3**4*T134fin(m4,0,0,mudim) + 8*m4**4*T134fin(m4,0,0,mudim) - 10*m3sq*m4sq*T134fin(m4,0,0,mudim) - 8*m4**4*T134fin(m4,m3,0,mudim) + 2*m3sq*m4sq*T134fin(m4,m3,0,mudim) + 2*m4**4*T134fin(m4,m4,m3,mudim) - 2*m3sq*m4sq*T134fin(m4,m4,m3,mudim))/(2.*m3**4*m4**4*(m3**4 + 4*m4**4 - 5*m3sq*m4sq))
		def eval_47():
			return (4*m1**4*m2**4*(B0del(0,0,m1sq,mudim) + B0del(0,0,m2sq,mudim) - B0fin(0,0,m1sq,mudim) - B0fin(0,0,m2sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim)) + (m1**3 - m1*m2sq)**2*(3*(m1sq + m2sq) + 2*m2sq*B0del(0,0,m2sq,mudim) - 2*(m1sq + 2*m2sq)*B0fin(0,0,m2sq,mudim) + m2sq*B0fin(0,0,m2sq,mudim)**2) - 2*(-(m1sq*m2) + m2**3)**2*(m1sq + 2*m1sq*B0fin(0,0,m1sq,mudim) - T134fin(m1,0,0,mudim)) - 2*(m1**3 - m1*m2sq)**2*(m1sq - 2*m2sq - 2*m1sq*B0fin(0,0,m2sq,mudim) + T134fin(m2,0,0,mudim)) + 2*m1sq*m2sq*(m1sq + m2sq)*(m1sq + m2sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim) - T134fin(m2,m1,0,mudim)))/(2.*m1**2*m2**4*(m1sq - m2sq)**4)
		def eval_48():
			return (4*m1**4*m2**4*(B0del(0,0,m1sq,mudim) + B0del(0,0,m2sq,mudim) - B0fin(0,0,m1sq,mudim) - B0fin(0,0,m2sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim)) + (m1**3 - m1*m2sq)**2*(3*(m1sq + m2sq) + 2*m2sq*B0del(0,0,m2sq,mudim) - 2*(m1sq + 2*m2sq)*B0fin(0,0,m2sq,mudim) + m2sq*B0fin(0,0,m2sq,mudim)**2) - 2*(-(m1sq*m2) + m2**3)**2*(m1sq + 2*m1sq*B0fin(0,0,m1sq,mudim) - T134fin(m1,0,0,mudim)) - 2*(m1**3 - m1*m2sq)**2*(m1sq - 2*m2sq - 2*m1sq*B0fin(0,0,m2sq,mudim) + T134fin(m2,0,0,mudim)) + 2*m1sq*m2sq*(m1sq + m2sq)*(m1sq + m2sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim) - T134fin(m2,m1,0,mudim)))/(2.*m1**2*m2**4*(m1sq - m2sq)**4)
		def eval_49():
			return -0.5*(2*m1sq*m3**4*(-4*m1sq + (3*m1sq + m3sq)*B0del(0,0,m1sq,mudim) + (3*m1sq + m3sq)*B0del(0,0,m3sq,mudim) + m1sq*B0fin(0,0,m1sq,mudim) - m3sq*B0fin(0,0,m1sq,mudim) + m1sq*B0fin(0,0,m3sq,mudim) - m3sq*B0fin(0,0,m3sq,mudim) + 3*m1sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + m3sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim)) + m1sq*(m1sq - m3sq)**2*m3sq*(6 + 2*B0del(0,0,m3sq,mudim) - 6*B0fin(0,0,m3sq,mudim) + B0fin(0,0,m3sq,mudim)**2) - 2*(-(m1sq*m3) + m3**3)**2*(2*m1sq - m3sq + 2*m3sq*B0fin(0,0,m1sq,mudim) - T134fin(m1,0,0,mudim)) + 2*(m1**3 - m1*m3sq)**2*(m3sq + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,0,0,mudim)) + 2*m1sq*m3sq*(2*m1**4 + 4*m3**4 + 6*m1sq*m3sq + 4*m1sq*m3sq*B0fin(0,0,m1sq,mudim) + 4*m3**4*B0fin(0,0,m3sq,mudim) - m1sq*T134fin(m3,m1,0,mudim) - 3*m3sq*T134fin(m3,m1,0,mudim)))/(m1**2*m3**4*(m1sq - m3sq)**4)
		def eval_50():
			return -0.5*(2*m1sq*m3**4*(-4*m1sq + (3*m1sq + m3sq)*B0del(0,0,m1sq,mudim) + (3*m1sq + m3sq)*B0del(0,0,m3sq,mudim) + m1sq*B0fin(0,0,m1sq,mudim) - m3sq*B0fin(0,0,m1sq,mudim) + m1sq*B0fin(0,0,m3sq,mudim) - m3sq*B0fin(0,0,m3sq,mudim) + 3*m1sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + m3sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim)) + m1sq*(m1sq - m3sq)**2*m3sq*(6 + 2*B0del(0,0,m3sq,mudim) - 6*B0fin(0,0,m3sq,mudim) + B0fin(0,0,m3sq,mudim)**2) - 2*(-(m1sq*m3) + m3**3)**2*(2*m1sq - m3sq + 2*m3sq*B0fin(0,0,m1sq,mudim) - T134fin(m1,0,0,mudim)) + 2*(m1**3 - m1*m3sq)**2*(m3sq + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,0,0,mudim)) + 2*m1sq*m3sq*(2*m1**4 + 4*m3**4 + 6*m1sq*m3sq + 4*m1sq*m3sq*B0fin(0,0,m1sq,mudim) + 4*m3**4*B0fin(0,0,m3sq,mudim) - m1sq*T134fin(m3,m1,0,mudim) - 3*m3sq*T134fin(m3,m1,0,mudim)))/(m1**2*m3**4*(m1sq - m3sq)**4)
		def eval_51():
			return -0.5*(m1sq*(m1sq - m2sq)**2*m2sq*(6 + 2*B0del(0,0,m1sq,mudim) - 6*B0fin(0,0,m1sq,mudim) + B0fin(0,0,m1sq,mudim)**2) + 2*m1**4*m2sq*(-4*m2sq + (m1sq + 3*m2sq)*B0del(0,0,m1sq,mudim) + (m1sq + 3*m2sq)*B0del(0,0,m2sq,mudim) - m1sq*B0fin(0,0,m1sq,mudim) + m2sq*B0fin(0,0,m1sq,mudim) - m1sq*B0fin(0,0,m2sq,mudim) + m2sq*B0fin(0,0,m2sq,mudim) + m1sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 3*m2sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim)) + 2*(-(m1sq*m2) + m2**3)**2*(m1sq + 2*m1sq*B0fin(0,0,m1sq,mudim) - T134fin(m1,0,0,mudim)) + 2*(m1**3 - m1*m2sq)**2*(m1sq - 2*m2sq - 2*m1sq*B0fin(0,0,m2sq,mudim) + T134fin(m2,0,0,mudim)) + 2*m1sq*m2sq*(4*m1**4 + 2*m2**4 + 6*m1sq*m2sq + 4*m1**4*B0fin(0,0,m1sq,mudim) + 4*m1sq*m2sq*B0fin(0,0,m2sq,mudim) - 3*m1sq*T134fin(m2,m1,0,mudim) - m2sq*T134fin(m2,m1,0,mudim)))/(m2**2*(m1**3 - m1*m2sq)**4)
		def eval_52():
			return -0.5*(m1sq*(m1sq - m2sq)**2*m2sq*(6 + 2*B0del(0,0,m1sq,mudim) - 6*B0fin(0,0,m1sq,mudim) + B0fin(0,0,m1sq,mudim)**2) + 2*m1**4*m2sq*(-4*m2sq + (m1sq + 3*m2sq)*B0del(0,0,m1sq,mudim) + (m1sq + 3*m2sq)*B0del(0,0,m2sq,mudim) - m1sq*B0fin(0,0,m1sq,mudim) + m2sq*B0fin(0,0,m1sq,mudim) - m1sq*B0fin(0,0,m2sq,mudim) + m2sq*B0fin(0,0,m2sq,mudim) + m1sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 3*m2sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim)) + 2*(-(m1sq*m2) + m2**3)**2*(m1sq + 2*m1sq*B0fin(0,0,m1sq,mudim) - T134fin(m1,0,0,mudim)) + 2*(m1**3 - m1*m2sq)**2*(m1sq - 2*m2sq - 2*m1sq*B0fin(0,0,m2sq,mudim) + T134fin(m2,0,0,mudim)) + 2*m1sq*m2sq*(4*m1**4 + 2*m2**4 + 6*m1sq*m2sq + 4*m1**4*B0fin(0,0,m1sq,mudim) + 4*m1sq*m2sq*B0fin(0,0,m2sq,mudim) - 3*m1sq*T134fin(m2,m1,0,mudim) - m2sq*T134fin(m2,m1,0,mudim)))/(m2**2*(m1**3 - m1*m2sq)**4)
		def eval_53():
			return (-4*m3**10 - 48*m3**6*m7**4 + 30*m3**4*m7**6 - 4*m3sq*m7**8 + 50*m3**8*m7sq - 2*m3sq*(2*m3**8 + 12*m3**4*m7**4 - 7*m3sq*m7**6 + m7**8 - 14*m3**6*m7sq)*B0del(0,0,m3sq,mudim) + 2*(-3*m3**6*m7**4 + 2*m3**4*m7**6 + 7*m3**8*m7sq)*B0del(0,0,m7sq,mudim) - 4*m3**10*B0fin(0,0,m3sq,mudim) + 12*m3**6*m7**4*B0fin(0,0,m3sq,mudim) - 10*m3**4*m7**6*B0fin(0,0,m3sq,mudim) + 2*m3sq*m7**8*B0fin(0,0,m3sq,mudim) + 12*m3**8*m7sq*B0fin(0,0,m3sq,mudim) - 2*m3**10*B0fin(0,0,m3sq,mudim)**2 - 9*m3**6*m7**4*B0fin(0,0,m3sq,mudim)**2 + 5*m3**4*m7**6*B0fin(0,0,m3sq,mudim)**2 - m3sq*m7**8*B0fin(0,0,m3sq,mudim)**2 + 7*m3**8*m7sq*B0fin(0,0,m3sq,mudim)**2 - 6*m3**6*m7**4*B0fin(0,0,m7sq,mudim) + 4*m3**4*m7**6*B0fin(0,0,m7sq,mudim) + 14*m3**8*m7sq*B0fin(0,0,m7sq,mudim) - 6*m3**6*m7**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim) + 4*m3**4*m7**6*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim) + 14*m3**8*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim) + 8*m3**8*T134fin(m3,0,0,mudim) + 30*m3**4*m7**4*T134fin(m3,0,0,mudim) - 14*m3sq*m7**6*T134fin(m3,0,0,mudim) + 2*m7**8*T134fin(m3,0,0,mudim) - 26*m3**6*m7sq*T134fin(m3,0,0,mudim) - 8*m3**8*T134fin(m7,m3,0,mudim) - 8*m3**4*m7**4*T134fin(m7,m3,0,mudim) + 2*m3sq*m7**6*T134fin(m7,m3,0,mudim) + 2*m3**6*m7sq*T134fin(m7,m3,0,mudim) + 2*m3**8*T134fin(m7,m3,m3,mudim) + 6*m3**4*m7**4*T134fin(m7,m3,m3,mudim) - 2*m3sq*m7**6*T134fin(m7,m3,m3,mudim) - 6*m3**6*m7sq*T134fin(m7,m3,m3,mudim))/(2.*m3**6*m7**2*(m3sq - m7sq)**3*(4*m3sq - m7sq))
		def eval_54():
			return (-4*m3**10 - 48*m3**6*m5**4 + 30*m3**4*m5**6 - 4*m3sq*m5**8 + 50*m3**8*m5sq - 2*m3sq*(2*m3**8 + 12*m3**4*m5**4 - 7*m3sq*m5**6 + m5**8 - 14*m3**6*m5sq)*B0del(0,0,m3sq,mudim) + 2*(-3*m3**6*m5**4 + 2*m3**4*m5**6 + 7*m3**8*m5sq)*B0del(0,0,m5sq,mudim) - 4*m3**10*B0fin(0,0,m3sq,mudim) + 12*m3**6*m5**4*B0fin(0,0,m3sq,mudim) - 10*m3**4*m5**6*B0fin(0,0,m3sq,mudim) + 2*m3sq*m5**8*B0fin(0,0,m3sq,mudim) + 12*m3**8*m5sq*B0fin(0,0,m3sq,mudim) - 2*m3**10*B0fin(0,0,m3sq,mudim)**2 - 9*m3**6*m5**4*B0fin(0,0,m3sq,mudim)**2 + 5*m3**4*m5**6*B0fin(0,0,m3sq,mudim)**2 - m3sq*m5**8*B0fin(0,0,m3sq,mudim)**2 + 7*m3**8*m5sq*B0fin(0,0,m3sq,mudim)**2 - 6*m3**6*m5**4*B0fin(0,0,m5sq,mudim) + 4*m3**4*m5**6*B0fin(0,0,m5sq,mudim) + 14*m3**8*m5sq*B0fin(0,0,m5sq,mudim) - 6*m3**6*m5**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + 4*m3**4*m5**6*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + 14*m3**8*m5sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + 8*m3**8*T134fin(m3,0,0,mudim) + 30*m3**4*m5**4*T134fin(m3,0,0,mudim) - 14*m3sq*m5**6*T134fin(m3,0,0,mudim) + 2*m5**8*T134fin(m3,0,0,mudim) - 26*m3**6*m5sq*T134fin(m3,0,0,mudim) - 8*m3**8*T134fin(m5,m3,0,mudim) - 8*m3**4*m5**4*T134fin(m5,m3,0,mudim) + 2*m3sq*m5**6*T134fin(m5,m3,0,mudim) + 2*m3**6*m5sq*T134fin(m5,m3,0,mudim) + 2*m3**8*T134fin(m5,m3,m3,mudim) + 6*m3**4*m5**4*T134fin(m5,m3,m3,mudim) - 2*m3sq*m5**6*T134fin(m5,m3,m3,mudim) - 6*m3**6*m5sq*T134fin(m5,m3,m3,mudim))/(2.*m3**6*m5**2*(m3sq - m5sq)**3*(4*m3sq - m5sq))
		def eval_55():
			return (7*m1sq + (5*m3**4)/m1**2 + m3**6/m1**4 - 5*m3sq + (2*(m1**4 + m3**4)*B0del(0,0,m1sq,mudim))/m1**2 + 4*m3sq*B0del(0,0,m3sq,mudim) - (8*m3**4*B0fin(0,0,m1sq,mudim))/m1**2 + (2*m3**6*B0fin(0,0,m1sq,mudim))/m1**4 + 10*m3sq*B0fin(0,0,m1sq,mudim) + m1sq*B0fin(0,0,m1sq,mudim)**2 + (m3**4*B0fin(0,0,m1sq,mudim)**2)/m1**2 - 2*m3sq*B0fin(0,0,m1sq,mudim)**2 - 4*m1sq*B0fin(0,0,m3sq,mudim) + 8*m3sq*B0fin(0,0,m3sq,mudim) + 4*m3sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 2*T134fin(m1,0,0,mudim) - (2*m3**4*T134fin(m1,0,0,mudim))/m1**4 + (4*m3sq*T134fin(m1,0,0,mudim))/m1**2 - 4*T134fin(m3,0,0,mudim) + (2*m1sq*T134fin(m3,0,0,mudim))/m3**2 + (2*m3sq*T134fin(m3,0,0,mudim))/m1**2 - 2*T134fin(m3,m1,0,mudim) - (2*m3sq*T134fin(m3,m1,0,mudim))/m1**2)/(2.*(m1sq - m3sq)**4)
		def eval_56():
			return (7*m1sq + (5*m3**4)/m1**2 + m3**6/m1**4 - 5*m3sq + (2*(m1**4 + m3**4)*B0del(0,0,m1sq,mudim))/m1**2 + 4*m3sq*B0del(0,0,m3sq,mudim) - (8*m3**4*B0fin(0,0,m1sq,mudim))/m1**2 + (2*m3**6*B0fin(0,0,m1sq,mudim))/m1**4 + 10*m3sq*B0fin(0,0,m1sq,mudim) + m1sq*B0fin(0,0,m1sq,mudim)**2 + (m3**4*B0fin(0,0,m1sq,mudim)**2)/m1**2 - 2*m3sq*B0fin(0,0,m1sq,mudim)**2 - 4*m1sq*B0fin(0,0,m3sq,mudim) + 8*m3sq*B0fin(0,0,m3sq,mudim) + 4*m3sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 2*T134fin(m1,0,0,mudim) - (2*m3**4*T134fin(m1,0,0,mudim))/m1**4 + (4*m3sq*T134fin(m1,0,0,mudim))/m1**2 - 4*T134fin(m3,0,0,mudim) + (2*m1sq*T134fin(m3,0,0,mudim))/m3**2 + (2*m3sq*T134fin(m3,0,0,mudim))/m1**2 - 2*T134fin(m3,m1,0,mudim) - (2*m3sq*T134fin(m3,m1,0,mudim))/m1**2)/(2.*(m1sq - m3sq)**4)
		def eval_57():
			return (-7*m5**6*(m4sq - m6sq)**5 + m6**6*(m4sq - m6sq)**5 + 7*m4**6*(m5sq - m6sq)**5 + 13*m4sq*m6**4*(m5sq - m6sq)**5 + 5*m4**4*(m5sq - m6sq)**5*m6sq + 13*m5sq*m6**4*(-m4sq + m6sq)**5 + 5*m5**4*m6sq*(-m4sq + m6sq)**5 + m6**6*(-m5sq + m6sq)**5 + 2*m4**6*(m5sq - m6sq)**5*B0del(0,0,m4sq,mudim) + 4*m4sq*m6**4*(m5sq - m6sq)**5*B0del(0,0,m4sq,mudim) + 6*m4**4*(m5sq - m6sq)**5*m6sq*B0del(0,0,m4sq,mudim) - 2*m5**6*(m4sq - m6sq)**5*B0del(0,0,m5sq,mudim) + 4*m5sq*m6**4*(-m4sq + m6sq)**5*B0del(0,0,m5sq,mudim) + 6*m5**4*m6sq*(-m4sq + m6sq)**5*B0del(0,0,m5sq,mudim) - 2*m5**6*(m4sq - m6sq)**5*B0del(0,0,m6sq,mudim) + 2*m4**6*(m5sq - m6sq)**5*B0del(0,0,m6sq,mudim) + 4*m4sq*m6**4*(m5sq - m6sq)**5*B0del(0,0,m6sq,mudim) + 6*m4**4*(m5sq - m6sq)**5*m6sq*B0del(0,0,m6sq,mudim) + 4*m5sq*m6**4*(-m4sq + m6sq)**5*B0del(0,0,m6sq,mudim) + 6*m5**4*m6sq*(-m4sq + m6sq)**5*B0del(0,0,m6sq,mudim) - 4*m4**6*(m5sq - m6sq)**5*B0fin(0,0,m4sq,mudim) + 2*m4sq*m6**4*(m5sq - m6sq)**5*B0fin(0,0,m4sq,mudim) + 14*m4**4*(m5sq - m6sq)**5*m6sq*B0fin(0,0,m4sq,mudim) + 4*m5**6*(m4sq - m6sq)**5*B0fin(0,0,m5sq,mudim) + 2*m5sq*m6**4*(-m4sq + m6sq)**5*B0fin(0,0,m5sq,mudim) + 14*m5**4*m6sq*(-m4sq + m6sq)**5*B0fin(0,0,m5sq,mudim) + 2*m5**6*(m4sq - m6sq)**5*B0fin(0,0,m6sq,mudim) + 2*m6**6*(m4sq - m6sq)**5*B0fin(0,0,m6sq,mudim) - 2*m4**6*(m5sq - m6sq)**5*B0fin(0,0,m6sq,mudim) + 16*m4**4*(m5sq - m6sq)**5*m6sq*B0fin(0,0,m6sq,mudim) + 16*m5**4*m6sq*(-m4sq + m6sq)**5*B0fin(0,0,m6sq,mudim) + 2*m6**6*(-m5sq + m6sq)**5*B0fin(0,0,m6sq,mudim) + 2*m4**6*(m5sq - m6sq)**5*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) + 4*m4sq*m6**4*(m5sq - m6sq)**5*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) + 6*m4**4*(m5sq - m6sq)**5*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m5**6*(m4sq - m6sq)**5*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) + 4*m5sq*m6**4*(-m4sq + m6sq)**5*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) + 6*m5**4*m6sq*(-m4sq + m6sq)**5*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m4**4*(m5sq - m6sq)**5*T134fin(m6,m4,0,mudim) + 8*m4sq*m6sq*(-m5sq + m6sq)**5*T134fin(m6,m4,0,mudim) + 4*m5**4*(m4sq - m6sq)**5*T134fin(m6,m5,0,mudim) + 8*m5sq*(m4sq - m6sq)**5*m6sq*T134fin(m6,m5,0,mudim))/(2.*(m4sq - m5sq)*(m4sq - m6sq)**5*(m5sq - m6sq)**5)
		def eval_58():
			return (((m5sq - m7sq)**4*(4*m4sq*m5**6*(m4sq + m5sq)*(4 + B0del(0,0,m4sq,mudim) + 4*B0fin(0,0,m4sq,mudim)) + 4*m4sq*m5**6*(m4sq + m5sq)*(6 + B0del(0,0,m5sq,mudim) - 3*B0fin(0,0,m5sq,mudim)) - ((2*(m4sq - m5sq)**4*m5sq)/3. + 4*m4sq*m5**6*(m4sq + m5sq)*(4 + B0fin(0,0,m4sq,mudim)))*(3 - B0fin(0,0,m5sq,mudim)) + (2*(m4sq - m5sq)**4*m5sq*(-2 + 3*B0fin(0,0,m5sq,mudim)))/9.))/m5**4 + 4*(m4sq - m5sq)**4*m7sq*(-((m4sq*(m5sq - m7sq)**4*(m4sq + m7sq)*B0del(0,0,m4sq,mudim))/(m4sq - m7sq)**4) + m5sq*(m5sq + m7sq)*B0del(0,0,m5sq,mudim) - (2*m4sq*(m5sq - m7sq)**4*(m4sq + m7sq)*B0fin(0,0,m4sq,mudim))/(m4sq - m7sq)**4 + 2*m5sq*(m5sq + m7sq)*B0fin(0,0,m5sq,mudim) + (-((m4sq*(m5sq - m7sq)**4*(m4sq + m7sq))/(m4sq - m7sq)**4) + m5sq*(m5sq + m7sq))*(B0del(0,0,m7sq,mudim) - B0fin(0,0,m7sq,mudim)) + ((-2*m4sq*(m5sq - m7sq)**4*(m4sq + m7sq))/(m4sq - m7sq)**4 + 2*m5sq*(m5sq + m7sq) - (m4sq*(m5sq - m7sq)**4*(m4sq + m7sq)*B0fin(0,0,m4sq,mudim))/(m4sq - m7sq)**4 + m5sq*(m5sq + m7sq)*B0fin(0,0,m5sq,mudim))*(-1 + B0fin(0,0,m7sq,mudim))) + 2*(m5sq - m7sq)**4*(2*(m4sq + m5sq)**3 - (m4sq - m5sq)**2*(m4sq + m5sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim)) - 4*m4sq*m5sq*T134fin(m5,m4,0,mudim)) + (2*(m4sq - m5sq)**4*(m5sq - m7sq)**4*(-m4**6 - 7*m4sq*m7**4 - m7**6 - 7*m4**4*m7sq + 2*(m4**3 - m4*m7sq)**2*B0fin(0,0,m4sq,mudim) + 2*(-(m4sq*m7) + m7**3)**2*B0fin(0,0,m7sq,mudim) + 4*m4sq*m7sq*T134fin(m7,m4,0,mudim)))/(m4sq - m7sq)**4 + 2*(m4sq - m5sq)**4*(2*(m5sq + m7sq)**3 - (m5sq - m7sq)**2*(m5sq + m7sq + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)) - 4*m5sq*m7sq*T134fin(m7,m5,0,mudim)))/(4.*(m4sq - m5sq)**5*(m5sq - m7sq)**5)
		def eval_59():
			return (-(m4**6*(m4sq - m6sq)**5) + 5*m4sq*(m4sq - m6sq)**5*m7**4 + 7*(m4sq - m6sq)**5*m7**6 + m4**6*(m4sq - m7sq)**5 - 5*m4sq*m6**4*(m4sq - m7sq)**5 - 7*m6**6*(m4sq - m7sq)**5 - 13*m4**4*m6sq*(m4sq - m7sq)**5 + 13*m4**4*(m4sq - m6sq)**5*m7sq + 6*m4sq*(m4sq - m6sq)**5*m7**4*B0del(0,0,m4sq,mudim) + 2*(m4sq - m6sq)**5*m7**6*B0del(0,0,m4sq,mudim) - 6*m4sq*m6**4*(m4sq - m7sq)**5*B0del(0,0,m4sq,mudim) - 2*m6**6*(m4sq - m7sq)**5*B0del(0,0,m4sq,mudim) - 4*m4**4*m6sq*(m4sq - m7sq)**5*B0del(0,0,m4sq,mudim) + 4*m4**4*(m4sq - m6sq)**5*m7sq*B0del(0,0,m4sq,mudim) - 6*m4sq*m6**4*(m4sq - m7sq)**5*B0del(0,0,m6sq,mudim) - 2*m6**6*(m4sq - m7sq)**5*B0del(0,0,m6sq,mudim) - 4*m4**4*m6sq*(m4sq - m7sq)**5*B0del(0,0,m6sq,mudim) + 6*m4sq*(m4sq - m6sq)**5*m7**4*B0del(0,0,m7sq,mudim) + 2*(m4sq - m6sq)**5*m7**6*B0del(0,0,m7sq,mudim) + 4*m4**4*(m4sq - m6sq)**5*m7sq*B0del(0,0,m7sq,mudim) - 2*m4**6*(m4sq - m6sq)**5*B0fin(0,0,m4sq,mudim) + 16*m4sq*(m4sq - m6sq)**5*m7**4*B0fin(0,0,m4sq,mudim) - 2*(m4sq - m6sq)**5*m7**6*B0fin(0,0,m4sq,mudim) + 2*m4**6*(m4sq - m7sq)**5*B0fin(0,0,m4sq,mudim) - 16*m4sq*m6**4*(m4sq - m7sq)**5*B0fin(0,0,m4sq,mudim) + 2*m6**6*(m4sq - m7sq)**5*B0fin(0,0,m4sq,mudim) - 14*m4sq*m6**4*(m4sq - m7sq)**5*B0fin(0,0,m6sq,mudim) + 4*m6**6*(m4sq - m7sq)**5*B0fin(0,0,m6sq,mudim) - 2*m4**4*m6sq*(m4sq - m7sq)**5*B0fin(0,0,m6sq,mudim) - 6*m4sq*m6**4*(m4sq - m7sq)**5*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m6**6*(m4sq - m7sq)**5*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m4**4*m6sq*(m4sq - m7sq)**5*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) + 14*m4sq*(m4sq - m6sq)**5*m7**4*B0fin(0,0,m7sq,mudim) - 4*(m4sq - m6sq)**5*m7**6*B0fin(0,0,m7sq,mudim) + 2*m4**4*(m4sq - m6sq)**5*m7sq*B0fin(0,0,m7sq,mudim) + 6*m4sq*(m4sq - m6sq)**5*m7**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) + 2*(m4sq - m6sq)**5*m7**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) + 4*m4**4*(m4sq - m6sq)**5*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) + 4*m6**4*(m4sq - m7sq)**5*T134fin(m6,m4,0,mudim) + 8*m4sq*m6sq*(m4sq - m7sq)**5*T134fin(m6,m4,0,mudim) - 4*(m4sq - m6sq)**5*m7**4*T134fin(m7,m4,0,mudim) - 8*m4sq*(m4sq - m6sq)**5*m7sq*T134fin(m7,m4,0,mudim))/(2.*(m4sq - m6sq)**5*(m4sq - m7sq)**5*(m6sq - m7sq))
		def eval_60():
			return (((m4sq - m5sq)**4*(m4sq - m7sq)**4*(11 - 6*B0fin(0,0,m4sq,mudim)))/m4**2 - 18*m4sq*m5sq*(m4sq + m5sq)*(m4sq - m7sq)**4*(-2 + B0del(0,0,m4sq,mudim) + B0del(0,0,m5sq,mudim) + B0fin(0,0,m4sq,mudim) + B0fin(0,0,m5sq,mudim) + B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim)) + 18*(m4sq - m5sq)**4*m7sq*(-(m4sq*(m4sq + m7sq)*B0del(0,0,m4sq,mudim)) + (m5sq*(m4sq - m7sq)**4*(m5sq + m7sq)*B0del(0,0,m5sq,mudim))/(m5sq - m7sq)**4 - 2*m4sq*(m4sq + m7sq)*B0fin(0,0,m4sq,mudim) + (2*m5sq*(m4sq - m7sq)**4*(m5sq + m7sq)*B0fin(0,0,m5sq,mudim))/(m5sq - m7sq)**4 + (-(m4sq*(m4sq + m7sq)) + (m5sq*(m4sq - m7sq)**4*(m5sq + m7sq))/(m5sq - m7sq)**4)*(B0del(0,0,m7sq,mudim) - B0fin(0,0,m7sq,mudim)) + (-2*m4sq*(m4sq + m7sq) + (2*m5sq*(m4sq - m7sq)**4*(m5sq + m7sq))/(m5sq - m7sq)**4 - m4sq*(m4sq + m7sq)*B0fin(0,0,m4sq,mudim) + (m5sq*(m4sq - m7sq)**4*(m5sq + m7sq)*B0fin(0,0,m5sq,mudim))/(m5sq - m7sq)**4)*(-1 + B0fin(0,0,m7sq,mudim))) + 9*(m4sq - m7sq)**4*(-m4**6 - 7*m4sq*m5**4 - m5**6 - 7*m4**4*m5sq + 2*(m4**3 - m4*m5sq)**2*B0fin(0,0,m4sq,mudim) + 2*(-(m4sq*m5) + m5**3)**2*B0fin(0,0,m5sq,mudim) + 4*m4sq*m5sq*T134fin(m5,m4,0,mudim)) + 9*(m4sq - m5sq)**4*(-m4**6 - 7*m4sq*m7**4 - m7**6 - 7*m4**4*m7sq + 2*(m4**3 - m4*m7sq)**2*B0fin(0,0,m4sq,mudim) + 2*(-(m4sq*m7) + m7**3)**2*B0fin(0,0,m7sq,mudim) + 4*m4sq*m7sq*T134fin(m7,m4,0,mudim)) - (9*(m4sq - m5sq)**4*(m4sq - m7sq)**4*(-m5**6 - 7*m5sq*m7**4 - m7**6 - 7*m5**4*m7sq + 2*(m5**3 - m5*m7sq)**2*B0fin(0,0,m5sq,mudim) + 2*(-(m5sq*m7) + m7**3)**2*B0fin(0,0,m7sq,mudim) + 4*m5sq*m7sq*T134fin(m7,m5,0,mudim)))/(m5sq - m7sq)**4)/(18.*(m4sq - m5sq)**5*(m4sq - m7sq)**5)
		def eval_61():
			return ((-4*m3sq*m4sq*(B0del(0,0,m4sq,mudim) + B0del(0,0,m5sq,mudim) - B0fin(0,0,m4sq,mudim) - B0fin(0,0,m5sq,mudim) + B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim)))/(m4sq - m5sq)**3 + (6*m3sq - 4*m5sq + 2*(m3sq - 2*m5sq)*B0del(0,0,m5sq,mudim) - 2*(3*m3sq + 2*m5sq)*B0fin(0,0,m5sq,mudim) + (m3sq - 2*m5sq)*B0fin(0,0,m5sq,mudim)**2)/(m5**4 - m4sq*m5sq) + (2*(m3sq*m4sq + 2*m3sq*m4sq*B0fin(0,0,m4sq,mudim) + (-m3sq + m4sq)*T134fin(m4,0,0,mudim)))/(m4**2*m5**2*(m4sq - m5sq)) + (2*T134fin(m4,m3,0,mudim))/(m5**4 - m4sq*m5sq) + (2*(m3sq*m5sq + 2*m3sq*m5sq*B0fin(0,0,m5sq,mudim) + (-m3sq + m5sq)*T134fin(m5,0,0,mudim)))/(-(m4sq*m5**4) + m5**6) + (2*T134fin(m5,m3,0,mudim))/(m5**2*(m4sq - m5sq)) + (2*(m3sq*(m4sq + m5sq)*(m4sq + m5sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim)) + ((m4sq - m5sq)**2 - m3sq*(m4sq + m5sq))*T134fin(m5,m4,0,mudim)))/(m5**2*(-m4sq + m5sq)**3) + (2*T134fin(m5,m4,m3,mudim))/(m5**2*(m4sq - m5sq)) + (2*T134fin(m5,m5,m3,mudim))/(m5**4 - m4sq*m5sq))/(2.*m3**4)
		def eval_62():
			return (-(((m4sq - m5sq)**2*(-6*m3sq + 4*m4sq - 2*(m3sq - 2*m4sq)*B0del(0,0,m4sq,mudim) + (6*m3sq + 4*m4sq)*B0fin(0,0,m4sq,mudim) - (m3sq - 2*m4sq)*B0fin(0,0,m4sq,mudim)**2))/m4**2) + 4*m3sq*m5sq*(B0del(0,0,m4sq,mudim) + B0del(0,0,m5sq,mudim) - B0fin(0,0,m4sq,mudim) - B0fin(0,0,m5sq,mudim) + B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim)) + (2*(m4sq - m5sq)**2*(m3sq*m4sq + 2*m3sq*m4sq*B0fin(0,0,m4sq,mudim) + (-m3sq + m4sq)*T134fin(m4,0,0,mudim)))/m4**4 - (2*(m4sq - m5sq)**2*T134fin(m4,m3,0,mudim))/m4**2 + (2*(m4sq - m5sq)**2*T134fin(m4,m4,m3,mudim))/m4**2 - (2*(m4sq - m5sq)**2*(m3sq*m5sq + 2*m3sq*m5sq*B0fin(0,0,m5sq,mudim) + (-m3sq + m5sq)*T134fin(m5,0,0,mudim)))/(m4**2*m5**2) + (2*(m4sq - m5sq)**2*T134fin(m5,m3,0,mudim))/m4**2 + (2*(m3sq*(m4sq + m5sq)*(m4sq + m5sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim)) + ((m4sq - m5sq)**2 - m3sq*(m4sq + m5sq))*T134fin(m5,m4,0,mudim)))/m4**2 - (2*(m4sq - m5sq)**2*T134fin(m5,m4,m3,mudim))/m4**2)/(2.*m3**4*(m4sq - m5sq)**3)
		def eval_63():
			return (2*(m1sq*(m2sq - m3sq)**3*B0del(0,0,m1sq,mudim) - m2sq*(m1sq - m3sq)**3*B0del(0,0,m2sq,mudim) + (-(m2sq*(m1sq - m3sq)**3) + m1sq*(m2sq - m3sq)**3)*B0del(0,0,m3sq,mudim) - m1sq*(m2sq - m3sq)**3*B0fin(0,0,m1sq,mudim) + m2sq*(m1sq - m3sq)**3*B0fin(0,0,m2sq,mudim) + (m2sq*(m1sq - m3sq)**3 - m1sq*(m2sq - m3sq)**3 + m1sq*(m2sq - m3sq)**3*B0fin(0,0,m1sq,mudim) - m2sq*(m1sq - m3sq)**3*B0fin(0,0,m2sq,mudim))*B0fin(0,0,m3sq,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)**3*(m2sq - m3sq)**3) - (6 + 2*B0del(0,0,m3sq,mudim) - 6*B0fin(0,0,m3sq,mudim) + B0fin(0,0,m3sq,mudim)**2)/(2.*m3**2*(-m1sq + m3sq)*(-m2sq + m3sq)) + (-m1sq - 2*m1sq*B0fin(0,0,m1sq,mudim) + T134fin(m1,0,0,mudim))/(m1**2*(m1sq - m2sq)*m3**2*(m1sq - m3sq)) + (-m2sq - 2*m2sq*B0fin(0,0,m2sq,mudim) + T134fin(m2,0,0,mudim))/(m2**2*(-m1sq + m2sq)*m3**2*(m2sq - m3sq)) + (-m3sq - 2*m3sq*B0fin(0,0,m3sq,mudim) + T134fin(m3,0,0,mudim))/(m3**4*(-m1sq + m3sq)*(-m2sq + m3sq)) + ((m1sq + m3sq)*(m1sq + m3sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,m1,0,mudim)))/((m1sq - m2sq)*m3**2*(m1sq - m3sq)**3) - ((m2sq + m3sq)*(m2sq + m3sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,m2,0,mudim)))/((m1sq - m2sq)*m3**2*(m2sq - m3sq)**3)
		def eval_64():
			return (2*(m1sq*(m2sq - m3sq)**3*B0del(0,0,m1sq,mudim) - m2sq*(m1sq - m3sq)**3*B0del(0,0,m2sq,mudim) + (-(m2sq*(m1sq - m3sq)**3) + m1sq*(m2sq - m3sq)**3)*B0del(0,0,m3sq,mudim) - m1sq*(m2sq - m3sq)**3*B0fin(0,0,m1sq,mudim) + m2sq*(m1sq - m3sq)**3*B0fin(0,0,m2sq,mudim) + (m2sq*(m1sq - m3sq)**3 - m1sq*(m2sq - m3sq)**3 + m1sq*(m2sq - m3sq)**3*B0fin(0,0,m1sq,mudim) - m2sq*(m1sq - m3sq)**3*B0fin(0,0,m2sq,mudim))*B0fin(0,0,m3sq,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)**3*(m2sq - m3sq)**3) - (6 + 2*B0del(0,0,m3sq,mudim) - 6*B0fin(0,0,m3sq,mudim) + B0fin(0,0,m3sq,mudim)**2)/(2.*m3**2*(-m1sq + m3sq)*(-m2sq + m3sq)) + (-m1sq - 2*m1sq*B0fin(0,0,m1sq,mudim) + T134fin(m1,0,0,mudim))/(m1**2*(m1sq - m2sq)*m3**2*(m1sq - m3sq)) + (-m2sq - 2*m2sq*B0fin(0,0,m2sq,mudim) + T134fin(m2,0,0,mudim))/(m2**2*(-m1sq + m2sq)*m3**2*(m2sq - m3sq)) + (-m3sq - 2*m3sq*B0fin(0,0,m3sq,mudim) + T134fin(m3,0,0,mudim))/(m3**4*(-m1sq + m3sq)*(-m2sq + m3sq)) + ((m1sq + m3sq)*(m1sq + m3sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,m1,0,mudim)))/((m1sq - m2sq)*m3**2*(m1sq - m3sq)**3) - ((m2sq + m3sq)*(m2sq + m3sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,m2,0,mudim)))/((m1sq - m2sq)*m3**2*(m2sq - m3sq)**3)
		def eval_65():
			return (6 + 2*B0del(0,0,m2sq,mudim) - 6*B0fin(0,0,m2sq,mudim) + B0fin(0,0,m2sq,mudim)**2)/(2.*m2**2*(m1sq - m2sq)*(m2sq - m3sq)) + (2*(-(m1sq*(m2sq - m3sq)**3*B0del(0,0,m1sq,mudim)) - (m1sq - m2sq)**3*m3sq*B0del(0,0,m3sq,mudim) - (m1sq*(m2sq - m3sq)**3 + (m1sq - m2sq)**3*m3sq)*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)) - (-1 + B0fin(0,0,m2sq,mudim))*(m1sq*(m2sq - m3sq)**3*B0fin(0,0,m1sq,mudim) + (m1sq - m2sq)**3*m3sq*B0fin(0,0,m3sq,mudim))))/((-m1sq + m2sq)**3*(m1sq - m3sq)*(m2sq - m3sq)**3) + (-m1sq - 2*m1sq*B0fin(0,0,m1sq,mudim) + T134fin(m1,0,0,mudim))/(m1**2*m2**2*(m1sq - m2sq)*(m1sq - m3sq)) + (m2sq + 2*m2sq*B0fin(0,0,m2sq,mudim) - T134fin(m2,0,0,mudim))/(m2**4*(m1sq - m2sq)*(m2sq - m3sq)) + ((m1sq + m2sq)*(m1sq + m2sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim) - T134fin(m2,m1,0,mudim)))/(m2**2*(m1sq - m2sq)**3*(m1sq - m3sq)) + (m3sq + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,0,0,mudim))/(m2**2*m3**2*(m2sq - m3sq)*(-m1sq + m3sq)) + ((m2sq + m3sq)*(m2sq + m3sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,m2,0,mudim)))/(m2**2*(m1sq - m3sq)*(m2sq - m3sq)**3)
		def eval_66():
			return (6 + 2*B0del(0,0,m2sq,mudim) - 6*B0fin(0,0,m2sq,mudim) + B0fin(0,0,m2sq,mudim)**2)/(2.*m2**2*(m1sq - m2sq)*(m2sq - m3sq)) + (2*(-(m1sq*(m2sq - m3sq)**3*B0del(0,0,m1sq,mudim)) - (m1sq - m2sq)**3*m3sq*B0del(0,0,m3sq,mudim) - (m1sq*(m2sq - m3sq)**3 + (m1sq - m2sq)**3*m3sq)*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)) - (-1 + B0fin(0,0,m2sq,mudim))*(m1sq*(m2sq - m3sq)**3*B0fin(0,0,m1sq,mudim) + (m1sq - m2sq)**3*m3sq*B0fin(0,0,m3sq,mudim))))/((-m1sq + m2sq)**3*(m1sq - m3sq)*(m2sq - m3sq)**3) + (-m1sq - 2*m1sq*B0fin(0,0,m1sq,mudim) + T134fin(m1,0,0,mudim))/(m1**2*m2**2*(m1sq - m2sq)*(m1sq - m3sq)) + (m2sq + 2*m2sq*B0fin(0,0,m2sq,mudim) - T134fin(m2,0,0,mudim))/(m2**4*(m1sq - m2sq)*(m2sq - m3sq)) + ((m1sq + m2sq)*(m1sq + m2sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim) - T134fin(m2,m1,0,mudim)))/(m2**2*(m1sq - m2sq)**3*(m1sq - m3sq)) + (m3sq + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,0,0,mudim))/(m2**2*m3**2*(m2sq - m3sq)*(-m1sq + m3sq)) + ((m2sq + m3sq)*(m2sq + m3sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,m2,0,mudim)))/(m2**2*(m1sq - m3sq)*(m2sq - m3sq)**3)
		def eval_67():
			return -0.5*(6 + 2*B0del(0,0,m1sq,mudim) - 6*B0fin(0,0,m1sq,mudim) + B0fin(0,0,m1sq,mudim)**2)/(m1**2*(m1sq - m2sq)*(m1sq - m3sq)) + (2*(-(m2sq*(m1sq - m3sq)**3*B0del(0,0,m2sq,mudim)) + (m1sq - m2sq)**3*m3sq*B0del(0,0,m3sq,mudim) - (m2sq*(m1sq - m3sq)**3 - (m1sq - m2sq)**3*m3sq)*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)) - (-1 + B0fin(0,0,m1sq,mudim))*(m2sq*(m1sq - m3sq)**3*B0fin(0,0,m2sq,mudim) - (m1sq - m2sq)**3*m3sq*B0fin(0,0,m3sq,mudim))))/((m1sq - m2sq)**3*(m1sq - m3sq)**3*(m2sq - m3sq)) + (-m1sq - 2*m1sq*B0fin(0,0,m1sq,mudim) + T134fin(m1,0,0,mudim))/(m1**4*(m1sq - m2sq)*(m1sq - m3sq)) + (m2sq + 2*m2sq*B0fin(0,0,m2sq,mudim) - T134fin(m2,0,0,mudim))/(m1**2*m2**2*(m1sq - m2sq)*(m2sq - m3sq)) - ((m1sq + m2sq)*(m1sq + m2sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim) - T134fin(m2,m1,0,mudim)))/(m1**2*(m1sq - m2sq)**3*(m2sq - m3sq)) + (m3sq + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,0,0,mudim))/(m1**2*m3**2*(m1sq - m3sq)*(-m2sq + m3sq)) - ((m1sq + m3sq)*(m1sq + m3sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,m1,0,mudim)))/(m1**2*(m1sq - m3sq)**3*(-m2sq + m3sq))
		def eval_68():
			return -0.5*(6 + 2*B0del(0,0,m1sq,mudim) - 6*B0fin(0,0,m1sq,mudim) + B0fin(0,0,m1sq,mudim)**2)/(m1**2*(m1sq - m2sq)*(m1sq - m3sq)) + (2*(-(m2sq*(m1sq - m3sq)**3*B0del(0,0,m2sq,mudim)) + (m1sq - m2sq)**3*m3sq*B0del(0,0,m3sq,mudim) - (m2sq*(m1sq - m3sq)**3 - (m1sq - m2sq)**3*m3sq)*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)) - (-1 + B0fin(0,0,m1sq,mudim))*(m2sq*(m1sq - m3sq)**3*B0fin(0,0,m2sq,mudim) - (m1sq - m2sq)**3*m3sq*B0fin(0,0,m3sq,mudim))))/((m1sq - m2sq)**3*(m1sq - m3sq)**3*(m2sq - m3sq)) + (-m1sq - 2*m1sq*B0fin(0,0,m1sq,mudim) + T134fin(m1,0,0,mudim))/(m1**4*(m1sq - m2sq)*(m1sq - m3sq)) + (m2sq + 2*m2sq*B0fin(0,0,m2sq,mudim) - T134fin(m2,0,0,mudim))/(m1**2*m2**2*(m1sq - m2sq)*(m2sq - m3sq)) - ((m1sq + m2sq)*(m1sq + m2sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim) - T134fin(m2,m1,0,mudim)))/(m1**2*(m1sq - m2sq)**3*(m2sq - m3sq)) + (m3sq + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,0,0,mudim))/(m1**2*m3**2*(m1sq - m3sq)*(-m2sq + m3sq)) - ((m1sq + m3sq)*(m1sq + m3sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,m1,0,mudim)))/(m1**2*(m1sq - m3sq)**3*(-m2sq + m3sq))
		def eval_69():
			return ((m4**4*(m4sq + m6sq))/((m4sq - m6sq)**4*(m6sq - m7sq)) + (m6**4*(m4sq + m6sq))/((m4sq - m6sq)**4*(m6sq - m7sq)) - (m5**4*(m5sq + m6sq))/((m5sq - m6sq)**4*(m6sq - m7sq)) - (m6**4*(m5sq + m6sq))/((m5sq - m6sq)**4*(m6sq - m7sq)) + (2*m4sq*m7sq*(m4sq + m7sq))/((m4sq - m7sq)**4*(m6sq - m7sq)) + (m5**4*(m5sq + m7sq))/((m5sq - m7sq)**4*(m6sq - m7sq)) + (m7**4*(m5sq + m7sq))/((m5sq - m7sq)**4*(m6sq - m7sq)) + (m4**4*(m4sq + m7sq))/((m4sq - m7sq)**4*(-m6sq + m7sq)) + (m7**4*(m4sq + m7sq))/((m4sq - m7sq)**4*(-m6sq + m7sq)) + (2*m4sq*m7sq*(m4sq + m7sq))/((m4sq - m7sq)**4*(-m6sq + m7sq)) + (m4sq*m6sq*(m4sq + m6sq)*B0del(0,0,m4sq,mudim))/((m4sq - m6sq)**4*(m6sq - m7sq)) + (m4sq*m7sq*(m4sq + m7sq)*B0del(0,0,m4sq,mudim))/((m4sq - m7sq)**4*(-m6sq + m7sq)) - (m5sq*m6sq*(m5sq + m6sq)*B0del(0,0,m5sq,mudim))/((m5sq - m6sq)**4*(m6sq - m7sq)) + (m5sq*m7sq*(m5sq + m7sq)*B0del(0,0,m5sq,mudim))/((m5sq - m7sq)**4*(m6sq - m7sq)) + (m4sq*m6sq*(m4sq + m6sq)*B0fin(0,0,m4sq,mudim))/((m4sq - m6sq)**4*(m6sq - m7sq)) + (m4sq*m7sq*(m4sq + m7sq)*B0fin(0,0,m4sq,mudim))/((m4sq - m7sq)**4*(-m6sq + m7sq)) - (m5sq*m6sq*(m5sq + m6sq)*B0fin(0,0,m5sq,mudim))/((m5sq - m6sq)**4*(m6sq - m7sq)) + (m5sq*m7sq*(m5sq + m7sq)*B0fin(0,0,m5sq,mudim))/((m5sq - m7sq)**4*(m6sq - m7sq)) + (m4sq*m6sq*(m4sq + m6sq)*(B0del(0,0,m6sq,mudim) - B0fin(0,0,m6sq,mudim)))/((m4sq - m6sq)**4*(m6sq - m7sq)) - (m5sq*m6sq*(m5sq + m6sq)*(B0del(0,0,m6sq,mudim) - B0fin(0,0,m6sq,mudim)))/((m5sq - m6sq)**4*(m6sq - m7sq)) + (2*m4sq*m6sq*(m4sq + m6sq)*B0fin(0,0,m6sq,mudim))/((m4sq - m6sq)**4*(m6sq - m7sq)) - (2*m5sq*m6sq*(m5sq + m6sq)*B0fin(0,0,m6sq,mudim))/((m5sq - m6sq)**4*(m6sq - m7sq)) + (m4sq*m6sq*(m4sq + m6sq)*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m6sq)**4*(m6sq - m7sq)) - (m5sq*m6sq*(m5sq + m6sq)*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim))/((m5sq - m6sq)**4*(m6sq - m7sq)) - (m4**4*(m4sq + m6sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/(2.*(m4sq - m6sq)**4*(m6sq - m7sq)) - (m6**4*(m4sq + m6sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/(2.*(m4sq - m6sq)**4*(m6sq - m7sq)) + (m4sq*m6sq*(m4sq + m6sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m6sq)**4*(m6sq - m7sq)) + (m5**4*(m5sq + m6sq + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/(2.*(m5sq - m6sq)**4*(m6sq - m7sq)) + (m6**4*(m5sq + m6sq + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/(2.*(m5sq - m6sq)**4*(m6sq - m7sq)) - (m5sq*m6sq*(m5sq + m6sq + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m5sq - m6sq)**4*(m6sq - m7sq)) + (m5sq*m7sq*(m5sq + m7sq)*(B0del(0,0,m7sq,mudim) - B0fin(0,0,m7sq,mudim)))/((m5sq - m7sq)**4*(m6sq - m7sq)) + (m4sq*m7sq*(m4sq + m7sq)*(B0del(0,0,m7sq,mudim) - B0fin(0,0,m7sq,mudim)))/((m4sq - m7sq)**4*(-m6sq + m7sq)) + (2*m5sq*m7sq*(m5sq + m7sq)*B0fin(0,0,m7sq,mudim))/((m5sq - m7sq)**4*(m6sq - m7sq)) + (2*m4sq*m7sq*(m4sq + m7sq)*B0fin(0,0,m7sq,mudim))/((m4sq - m7sq)**4*(-m6sq + m7sq)) + (m4sq*m7sq*(m4sq + m7sq)*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m4sq - m7sq)**4*(-m6sq + m7sq)) + (m5sq*m7sq*(m5sq + m7sq)*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/((m5sq - m7sq)**4*(m6sq - m7sq)) + (m4**4*(m4sq + m7sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(2.*(m4sq - m7sq)**4*(m6sq - m7sq)) - (m7**4*(m4sq + m7sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(2.*(m4sq - m7sq)**4*(-m6sq + m7sq)) + (m4sq*m7sq*(m4sq + m7sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m7sq)**4*(-m6sq + m7sq)) + (m5**4*(m5sq + m7sq + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(2.*(m5sq - m7sq)**4*(-m6sq + m7sq)) + (m7**4*(m5sq + m7sq + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(2.*(m5sq - m7sq)**4*(-m6sq + m7sq)) - (m5sq*m7sq*(m5sq + m7sq + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m5sq - m7sq)**4*(-m6sq + m7sq)) - (2*m4sq*m6sq*T134fin(m6,m4,0,mudim))/((m4sq - m6sq)**4*(m6sq - m7sq)) + (2*m5sq*m6sq*T134fin(m6,m5,0,mudim))/((m5sq - m6sq)**4*(m6sq - m7sq)) - (2*m4sq*m7sq*T134fin(m7,m4,0,mudim))/((m4sq - m7sq)**4*(-m6sq + m7sq)) + (2*m5sq*m7sq*T134fin(m7,m5,0,mudim))/((m5sq - m7sq)**4*(-m6sq + m7sq)))/(m4sq - m5sq)
		def eval_70():
			return (21*m2sq + 12*m2sq*B0del(0,0,m2sq,mudim) + 12*m2sq*B0fin(0,0,m2sq,mudim) + 6*m2sq*B0fin(0,0,m2sq,mudim)**2 - 9*T134fin(m2,0,0,mudim) - T134fin(m2,m2,m2,mudim))/(9.*m2**8)
		def eval_71():
			return (21*m2sq + 12*m2sq*B0del(0,0,m2sq,mudim) + 12*m2sq*B0fin(0,0,m2sq,mudim) + 6*m2sq*B0fin(0,0,m2sq,mudim)**2 - 9*T134fin(m2,0,0,mudim) - T134fin(m2,m2,m2,mudim))/(9.*m2**8)
		def eval_72():
			return (16 - 9*B0del(0,0,m1sq,mudim) + 96*B0fin(0,0,m1sq,mudim))/(576.*m1**6)
		def eval_73():
			return (-3*m1sq + 6*m1sq*B0del(0,0,m1sq,mudim) + 6*m1sq*B0fin(0,0,m1sq,mudim) + 3*m1sq*B0fin(0,0,m1sq,mudim)**2 - 2*T134fin(m1,m1,m1,mudim))/(9.*m1**8)
		def eval_74():
			return (16 - 9*B0del(0,0,m1sq,mudim) + 96*B0fin(0,0,m1sq,mudim))/(576.*m1**6)
		def eval_75():
			return -0.1111111111111111*(m3**8 + 70*m3**4*m4**4 - 144*m3sq*m4**6 + 72*m4**8 - 17*m3**6*m4sq - 18*m3sq*m4**4*(m3sq - 2*m4sq)*B0del(0,0,m3sq,mudim) - 36*m4**6*(m3sq - 2*m4sq)*B0del(0,0,m4sq,mudim) - 36*m3sq*m4**6*B0fin(0,0,m3sq,mudim) - 3*m3**8*B0fin(0,0,m4sq,mudim) - 66*m3**4*m4**4*B0fin(0,0,m4sq,mudim) + 36*m3sq*m4**6*B0fin(0,0,m4sq,mudim) + 72*m4**8*B0fin(0,0,m4sq,mudim) + 24*m3**6*m4sq*B0fin(0,0,m4sq,mudim) - 18*m3**4*m4**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + 36*m3sq*m4**6*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + 9*m3**4*m4**4*B0fin(0,0,m4sq,mudim)**2 - 36*m3sq*m4**6*B0fin(0,0,m4sq,mudim)**2 + 36*m4**8*B0fin(0,0,m4sq,mudim)**2 + 18*m3sq*m4**4*T134fin(m4,m4,m3,mudim) - 36*m4**6*T134fin(m4,m4,m3,mudim))/(m3**6*m4**4*(m3sq - 4*m4sq)**2)
		def eval_76():
			return (-66*m2**4*m3**4 + 102*m2sq*m3**6 - 12*m3**8 + 12*m2**6*m3sq + 18*m2sq*m3**6*B0del(0,0,m2sq,mudim) + 6*(-11*m2**4*m3**4 + 14*m2sq*m3**6 - 2*m3**8 + 2*m2**6*m3sq)*B0del(0,0,m3sq,mudim) + 18*m2sq*m3**6*B0fin(0,0,m2sq,mudim) - 66*m2**4*m3**4*B0fin(0,0,m3sq,mudim) + 84*m2sq*m3**6*B0fin(0,0,m3sq,mudim) - 12*m3**8*B0fin(0,0,m3sq,mudim) + 12*m2**6*m3sq*B0fin(0,0,m3sq,mudim) + 18*m2sq*m3**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) - 33*m2**4*m3**4*B0fin(0,0,m3sq,mudim)**2 + 33*m2sq*m3**6*B0fin(0,0,m3sq,mudim)**2 - 6*m3**8*B0fin(0,0,m3sq,mudim)**2 + 6*m2**6*m3sq*B0fin(0,0,m3sq,mudim)**2 - 6*m2**6*T134fin(m3,0,0,mudim) - 54*m2sq*m3**4*T134fin(m3,0,0,mudim) + 24*m3**6*T134fin(m3,0,0,mudim) + 36*m2**4*m3sq*T134fin(m3,0,0,mudim) + 6*m2sq*m3**4*T134fin(m3,m2,0,mudim) - 24*m3**6*T134fin(m3,m2,0,mudim) - 6*m2sq*m3**4*T134fin(m3,m3,m2,mudim) + 6*m3**6*T134fin(m3,m3,m2,mudim) - 2*m2**6*T134fin(m3,m3,m3,mudim) - 8*m2sq*m3**4*T134fin(m3,m3,m3,mudim) + 10*m2**4*m3sq*T134fin(m3,m3,m3,mudim))/(6.*m3**6*(m2sq - 4*m3sq)*(m2**3 - m2*m3sq)**2)
		def eval_77():
			return (-66*m2**4*m3**4 + 102*m2sq*m3**6 - 12*m3**8 + 12*m2**6*m3sq + 18*m2sq*m3**6*B0del(0,0,m2sq,mudim) + 6*(-11*m2**4*m3**4 + 14*m2sq*m3**6 - 2*m3**8 + 2*m2**6*m3sq)*B0del(0,0,m3sq,mudim) + 18*m2sq*m3**6*B0fin(0,0,m2sq,mudim) - 66*m2**4*m3**4*B0fin(0,0,m3sq,mudim) + 84*m2sq*m3**6*B0fin(0,0,m3sq,mudim) - 12*m3**8*B0fin(0,0,m3sq,mudim) + 12*m2**6*m3sq*B0fin(0,0,m3sq,mudim) + 18*m2sq*m3**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) - 33*m2**4*m3**4*B0fin(0,0,m3sq,mudim)**2 + 33*m2sq*m3**6*B0fin(0,0,m3sq,mudim)**2 - 6*m3**8*B0fin(0,0,m3sq,mudim)**2 + 6*m2**6*m3sq*B0fin(0,0,m3sq,mudim)**2 - 6*m2**6*T134fin(m3,0,0,mudim) - 54*m2sq*m3**4*T134fin(m3,0,0,mudim) + 24*m3**6*T134fin(m3,0,0,mudim) + 36*m2**4*m3sq*T134fin(m3,0,0,mudim) + 6*m2sq*m3**4*T134fin(m3,m2,0,mudim) - 24*m3**6*T134fin(m3,m2,0,mudim) - 6*m2sq*m3**4*T134fin(m3,m3,m2,mudim) + 6*m3**6*T134fin(m3,m3,m2,mudim) - 2*m2**6*T134fin(m3,m3,m3,mudim) - 8*m2sq*m3**4*T134fin(m3,m3,m3,mudim) + 10*m2**4*m3sq*T134fin(m3,m3,m3,mudim))/(6.*m3**6*(m2sq - 4*m3sq)*(m2**3 - m2*m3sq)**2)
		def eval_78():
			return -0.05555555555555555*(-2*m1**8 - 39*m1**4*m2**4 + 89*m1sq*m2**6 - 11*m2**8 + 35*m1**6*m2sq + 18*m1sq*m2**4*(m1sq + m2sq)*B0del(0,0,m1sq,mudim) + 18*m1sq*m2**4*(m1sq + m2sq)*B0del(0,0,m2sq,mudim) + 18*m1**4*m2**4*B0fin(0,0,m1sq,mudim) + 18*m1sq*m2**6*B0fin(0,0,m1sq,mudim) + 6*m1**8*B0fin(0,0,m2sq,mudim) + 72*m1**4*m2**4*B0fin(0,0,m2sq,mudim) + 12*m1sq*m2**6*B0fin(0,0,m2sq,mudim) - 12*m2**8*B0fin(0,0,m2sq,mudim) - 42*m1**6*m2sq*B0fin(0,0,m2sq,mudim) + 18*m1**4*m2**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 18*m1sq*m2**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 36*m1sq*m2**4*T134fin(m2,m1,0,mudim))/(m2**4*(-m1sq + m2sq)**5)
		def eval_79():
			return (6*m2**4 + 6*m1sq*m2sq + 6*m2sq*(m1sq + m2sq)*B0del(0,0,m2sq,mudim) + 6*m2sq*(m1sq + m2sq)*B0fin(0,0,m2sq,mudim) + 3*m2sq*(m1sq + m2sq)*B0fin(0,0,m2sq,mudim)**2 + 3*m2sq*T134fin(m1,0,0,mudim) - 3*m1sq*T134fin(m2,0,0,mudim) - 6*m2sq*T134fin(m2,m1,0,mudim) + 3*m2sq*T134fin(m2,m2,m1,mudim) - m1sq*T134fin(m2,m2,m2,mudim) - 2*m2sq*T134fin(m2,m2,m2,mudim))/(3.*m2**6*(m1sq - m2sq)**2)
		def eval_80():
			return -0.05555555555555555*(-2*m1**8 - 39*m1**4*m2**4 + 89*m1sq*m2**6 - 11*m2**8 + 35*m1**6*m2sq + 18*m1sq*m2**4*(m1sq + m2sq)*B0del(0,0,m1sq,mudim) + 18*m1sq*m2**4*(m1sq + m2sq)*B0del(0,0,m2sq,mudim) + 18*m1**4*m2**4*B0fin(0,0,m1sq,mudim) + 18*m1sq*m2**6*B0fin(0,0,m1sq,mudim) + 6*m1**8*B0fin(0,0,m2sq,mudim) + 72*m1**4*m2**4*B0fin(0,0,m2sq,mudim) + 12*m1sq*m2**6*B0fin(0,0,m2sq,mudim) - 12*m2**8*B0fin(0,0,m2sq,mudim) - 42*m1**6*m2sq*B0fin(0,0,m2sq,mudim) + 18*m1**4*m2**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 18*m1sq*m2**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 36*m1sq*m2**4*T134fin(m2,m1,0,mudim))/(m2**4*(-m1sq + m2sq)**5)
		def eval_81():
			return (-20*m3**12 - 165*m3**8*m4**4 + 247*m3**6*m4**6 - 135*m3**4*m4**8 + 46*m3sq*m4**10 - 4*m4**12 + 103*m3**10*m4sq + (-8*m3**12 - 46*m3**8*m4**4 + 76*m3**6*m4**6 - 28*m3**4*m4**8 + 6*m3sq*m4**10 + 36*m3**10*m4sq)*B0del(0,0,m3sq,mudim) + (32*m3**8*m4**4 + 54*m3**6*m4**6 - 70*m3**4*m4**8 + 36*m3sq*m4**10 - 4*m4**12 - 12*m3**10*m4sq)*B0del(0,0,m4sq,mudim) - 8*m3**12*B0fin(0,0,m3sq,mudim) - 46*m3**8*m4**4*B0fin(0,0,m3sq,mudim) + 76*m3**6*m4**6*B0fin(0,0,m3sq,mudim) - 28*m3**4*m4**8*B0fin(0,0,m3sq,mudim) + 6*m3sq*m4**10*B0fin(0,0,m3sq,mudim) + 36*m3**10*m4sq*B0fin(0,0,m3sq,mudim) - 4*m3**12*B0fin(0,0,m3sq,mudim)**2 - 60*m3**8*m4**4*B0fin(0,0,m3sq,mudim)**2 + 52*m3**6*m4**6*B0fin(0,0,m3sq,mudim)**2 - 16*m3**4*m4**8*B0fin(0,0,m3sq,mudim)**2 + 28*m3**10*m4sq*B0fin(0,0,m3sq,mudim)**2 + 8*m3**12*B0fin(0,0,m4sq,mudim) + 66*m3**8*m4**4*B0fin(0,0,m4sq,mudim) + 88*m3**6*m4**6*B0fin(0,0,m4sq,mudim) - 112*m3**4*m4**8*B0fin(0,0,m4sq,mudim) + 44*m3sq*m4**10*B0fin(0,0,m4sq,mudim) - 4*m4**12*B0fin(0,0,m4sq,mudim) - 54*m3**10*m4sq*B0fin(0,0,m4sq,mudim) + 74*m3**8*m4**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) - 28*m3**6*m4**6*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + 4*m3**4*m4**8*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + 6*m3sq*m4**10*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) - 20*m3**10*m4sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) - 21*m3**8*m4**4*B0fin(0,0,m4sq,mudim)**2 + 41*m3**6*m4**6*B0fin(0,0,m4sq,mudim)**2 - 37*m3**4*m4**8*B0fin(0,0,m4sq,mudim)**2 + 15*m3sq*m4**10*B0fin(0,0,m4sq,mudim)**2 - 2*m4**12*B0fin(0,0,m4sq,mudim)**2 + 4*m3**10*m4sq*B0fin(0,0,m4sq,mudim)**2 - 118*m3**6*m4**4*T134fin(m4,m3,0,mudim) + 100*m3**4*m4**6*T134fin(m4,m3,0,mudim) - 50*m3sq*m4**8*T134fin(m4,m3,0,mudim) + 8*m4**10*T134fin(m4,m3,0,mudim) + 24*m3**8*m4sq*T134fin(m4,m3,0,mudim) + 4*m3**10*T134fin(m4,m3,m3,mudim) + 74*m3**6*m4**4*T134fin(m4,m3,m3,mudim) - 82*m3**4*m4**6*T134fin(m4,m3,m3,mudim) + 42*m3sq*m4**8*T134fin(m4,m3,m3,mudim) - 8*m4**10*T134fin(m4,m3,m3,mudim) - 30*m3**8*m4sq*T134fin(m4,m3,m3,mudim) - 26*m3**6*m4**4*T134fin(m4,m4,m3,mudim) + 30*m3**4*m4**6*T134fin(m4,m4,m3,mudim) - 14*m3sq*m4**8*T134fin(m4,m4,m3,mudim) + 2*m4**10*T134fin(m4,m4,m3,mudim) + 8*m3**8*m4sq*T134fin(m4,m4,m3,mudim))/(2.*m4**2*(m3**3 - m3*m4sq)**4*(4*m3**4 + 4*m4**4 - 17*m3sq*m4sq))
		def eval_82():
			return (-30*m2**4*m4**4 + 72*m2sq*m4**6 - 8*m4**8 + 2*m2**6*m4sq + (-10*m2**4*m4**4 + 28*m2sq*m4**6)*B0del(0,0,m2sq,mudim) + 2*m4sq*(m2**6 + 22*m2sq*m4**4 - 4*m4**6 - 10*m2**4*m4sq)*B0del(0,0,m4sq,mudim) - 4*m2**4*m4**4*B0fin(0,0,m2sq,mudim) + 4*m2sq*m4**6*B0fin(0,0,m2sq,mudim) - 26*m2**4*m4**4*B0fin(0,0,m4sq,mudim) + 68*m2sq*m4**6*B0fin(0,0,m4sq,mudim) - 8*m4**8*B0fin(0,0,m4sq,mudim) + 2*m2**6*m4sq*B0fin(0,0,m4sq,mudim) - 10*m2**4*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 28*m2sq*m4**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 5*m2**4*m4**4*B0fin(0,0,m4sq,mudim)**2 + 8*m2sq*m4**6*B0fin(0,0,m4sq,mudim)**2 - 4*m4**8*B0fin(0,0,m4sq,mudim)**2 + m2**6*m4sq*B0fin(0,0,m4sq,mudim)**2 - 2*m2**6*T134fin(m4,0,0,mudim) - 48*m2sq*m4**4*T134fin(m4,0,0,mudim) + 32*m4**6*T134fin(m4,0,0,mudim) + 18*m2**4*m4sq*T134fin(m4,0,0,mudim) + 16*m2sq*m4**4*T134fin(m4,m2,0,mudim) - 32*m4**6*T134fin(m4,m2,0,mudim) - 2*m2**4*m4sq*T134fin(m4,m2,0,mudim) - 6*m2sq*m4**4*T134fin(m4,m4,m2,mudim) + 4*m4**6*T134fin(m4,m4,m2,mudim) + 2*m2**4*m4sq*T134fin(m4,m4,m2,mudim))/(2.*m2**4*(m2 - m4)*m4**4*(m2 + m4)*(m2sq - 4*m4sq)**2)
		def eval_83():
			return (3*m1**6 + 17*m1sq*m3**4 + 3*m3**6 + m1**4*m3sq + 2*(3*m1sq*m3**4 + m3**6 + 2*m1**4*m3sq)*B0del(0,0,m1sq,mudim) + 2*(3*m1sq*m3**4 + m3**6 + 2*m1**4*m3sq)*B0del(0,0,m3sq,mudim) + 14*m1sq*m3**4*B0fin(0,0,m1sq,mudim) - 2*m1**4*m3sq*B0fin(0,0,m1sq,mudim) - 2*m1**6*B0fin(0,0,m3sq,mudim) + 16*m1sq*m3**4*B0fin(0,0,m3sq,mudim) - 6*m3**6*B0fin(0,0,m3sq,mudim) + 4*m1**4*m3sq*B0fin(0,0,m3sq,mudim) + 6*m1sq*m3**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 2*m3**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 4*m1**4*m3sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 4*m3**4*T134fin(m3,m1,0,mudim) - 8*m1sq*m3sq*T134fin(m3,m1,0,mudim))/(2.*m3**2*(-m1sq + m3sq)**5)
		def eval_84():
			return (3*m1**6 + 17*m1sq*m3**4 + 3*m3**6 + m1**4*m3sq + 2*(3*m1sq*m3**4 + m3**6 + 2*m1**4*m3sq)*B0del(0,0,m1sq,mudim) + 2*(3*m1sq*m3**4 + m3**6 + 2*m1**4*m3sq)*B0del(0,0,m3sq,mudim) + 14*m1sq*m3**4*B0fin(0,0,m1sq,mudim) - 2*m1**4*m3sq*B0fin(0,0,m1sq,mudim) - 2*m1**6*B0fin(0,0,m3sq,mudim) + 16*m1sq*m3**4*B0fin(0,0,m3sq,mudim) - 6*m3**6*B0fin(0,0,m3sq,mudim) + 4*m1**4*m3sq*B0fin(0,0,m3sq,mudim) + 6*m1sq*m3**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 2*m3**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 4*m1**4*m3sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 4*m3**4*T134fin(m3,m1,0,mudim) - 8*m1sq*m3sq*T134fin(m3,m1,0,mudim))/(2.*m3**2*(-m1sq + m3sq)**5)
		def eval_85():
			return (3*m1**6 - 7*m1sq*m2**4 + 15*m2**6 + 13*m1**4*m2sq + 2*(3*m1sq*m2**4 + m2**6 + 2*m1**4*m2sq)*B0del(0,0,m1sq,mudim) + 2*(3*m1sq*m2**4 + m2**6 + 2*m1**4*m2sq)*B0del(0,0,m2sq,mudim) + 14*m1sq*m2**4*B0fin(0,0,m1sq,mudim) - 6*m2**6*B0fin(0,0,m1sq,mudim) + 4*m1**4*m2sq*B0fin(0,0,m1sq,mudim) - 2*m1sq*m2**4*B0fin(0,0,m1sq,mudim)**2 + m2**6*B0fin(0,0,m1sq,mudim)**2 + m1**4*m2sq*B0fin(0,0,m1sq,mudim)**2 - 2*m1**6*B0fin(0,0,m2sq,mudim) + 16*m1sq*m2**4*B0fin(0,0,m2sq,mudim) - 2*m1**4*m2sq*B0fin(0,0,m2sq,mudim) + 10*m1sq*m2**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 2*m1**4*m2sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 2*m1sq*m2**4*B0fin(0,0,m2sq,mudim)**2 + m2**6*B0fin(0,0,m2sq,mudim)**2 + m1**4*m2sq*B0fin(0,0,m2sq,mudim)**2 - 4*m2**4*T134fin(m2,m1,0,mudim) - 8*m1sq*m2sq*T134fin(m2,m1,0,mudim))/(2.*m2**2*(-m1sq + m2sq)**5)
		def eval_86():
			return (3*m1**6 - 7*m1sq*m2**4 + 15*m2**6 + 13*m1**4*m2sq + 2*(3*m1sq*m2**4 + m2**6 + 2*m1**4*m2sq)*B0del(0,0,m1sq,mudim) + 2*(3*m1sq*m2**4 + m2**6 + 2*m1**4*m2sq)*B0del(0,0,m2sq,mudim) + 14*m1sq*m2**4*B0fin(0,0,m1sq,mudim) - 6*m2**6*B0fin(0,0,m1sq,mudim) + 4*m1**4*m2sq*B0fin(0,0,m1sq,mudim) - 2*m1sq*m2**4*B0fin(0,0,m1sq,mudim)**2 + m2**6*B0fin(0,0,m1sq,mudim)**2 + m1**4*m2sq*B0fin(0,0,m1sq,mudim)**2 - 2*m1**6*B0fin(0,0,m2sq,mudim) + 16*m1sq*m2**4*B0fin(0,0,m2sq,mudim) - 2*m1**4*m2sq*B0fin(0,0,m2sq,mudim) + 10*m1sq*m2**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 2*m1**4*m2sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 2*m1sq*m2**4*B0fin(0,0,m2sq,mudim)**2 + m2**6*B0fin(0,0,m2sq,mudim)**2 + m1**4*m2sq*B0fin(0,0,m2sq,mudim)**2 - 4*m2**4*T134fin(m2,m1,0,mudim) - 8*m1sq*m2sq*T134fin(m2,m1,0,mudim))/(2.*m2**2*(-m1sq + m2sq)**5)
		def eval_87():
			return (4*m1sq*m6**4 + 20*m1**4*m6sq + 2*(m1**6 + 2*m1sq*m6**4 + 3*m1**4*m6sq)*B0del(0,0,m1sq,mudim) + 2*(m1**6 + 2*m1sq*m6**4 + 3*m1**4*m6sq)*B0del(0,0,m6sq,mudim) - 7*m1**6*B0fin(0,0,m1sq,mudim) + 7*m1sq*m6**4*B0fin(0,0,m1sq,mudim) - m6**6*B0fin(0,0,m1sq,mudim) + 13*m1**4*m6sq*B0fin(0,0,m1sq,mudim) + m1**6*B0fin(0,0,m6sq,mudim) - 5*m1sq*m6**4*B0fin(0,0,m6sq,mudim) - m6**6*B0fin(0,0,m6sq,mudim) + 17*m1**4*m6sq*B0fin(0,0,m6sq,mudim) + 2*m1**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 4*m1sq*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 6*m1**4*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m1**4*T134fin(m6,m1,0,mudim) - 8*m1sq*m6sq*T134fin(m6,m1,0,mudim))/(2.*m1**2*(m1sq - m6sq)**5)
		def eval_88():
			return (4*m1sq*m4**4 + 20*m1**4*m4sq + 2*(m1**6 + 2*m1sq*m4**4 + 3*m1**4*m4sq)*B0del(0,0,m1sq,mudim) + 2*(m1**6 + 2*m1sq*m4**4 + 3*m1**4*m4sq)*B0del(0,0,m4sq,mudim) - 7*m1**6*B0fin(0,0,m1sq,mudim) + 7*m1sq*m4**4*B0fin(0,0,m1sq,mudim) - m4**6*B0fin(0,0,m1sq,mudim) + 13*m1**4*m4sq*B0fin(0,0,m1sq,mudim) + m1**6*B0fin(0,0,m4sq,mudim) - 5*m1sq*m4**4*B0fin(0,0,m4sq,mudim) - m4**6*B0fin(0,0,m4sq,mudim) + 17*m1**4*m4sq*B0fin(0,0,m4sq,mudim) + 2*m1**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 4*m1sq*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 6*m1**4*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 4*m1**4*T134fin(m4,m1,0,mudim) - 8*m1sq*m4sq*T134fin(m4,m1,0,mudim))/(2.*m1**2*(m1sq - m4sq)**5)
		def eval_89():
			return (15*m1**6 + 13*m1sq*m3**4 + 3*m3**6 - 7*m1**4*m3sq + 2*(m1**6 + 2*m1sq*m3**4 + 3*m1**4*m3sq)*B0del(0,0,m1sq,mudim) + 2*(m1**6 + 2*m1sq*m3**4 + 3*m1**4*m3sq)*B0del(0,0,m3sq,mudim) - 2*m1sq*m3**4*B0fin(0,0,m1sq,mudim) - 2*m3**6*B0fin(0,0,m1sq,mudim) + 16*m1**4*m3sq*B0fin(0,0,m1sq,mudim) + m1**6*B0fin(0,0,m1sq,mudim)**2 + m1sq*m3**4*B0fin(0,0,m1sq,mudim)**2 - 2*m1**4*m3sq*B0fin(0,0,m1sq,mudim)**2 - 6*m1**6*B0fin(0,0,m3sq,mudim) + 4*m1sq*m3**4*B0fin(0,0,m3sq,mudim) + 14*m1**4*m3sq*B0fin(0,0,m3sq,mudim) + 2*m1sq*m3**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 10*m1**4*m3sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + m1**6*B0fin(0,0,m3sq,mudim)**2 + m1sq*m3**4*B0fin(0,0,m3sq,mudim)**2 - 2*m1**4*m3sq*B0fin(0,0,m3sq,mudim)**2 - 4*m1**4*T134fin(m3,m1,0,mudim) - 8*m1sq*m3sq*T134fin(m3,m1,0,mudim))/(2.*m1**2*(m1sq - m3sq)**5)
		def eval_90():
			return (15*m1**6 + 13*m1sq*m3**4 + 3*m3**6 - 7*m1**4*m3sq + 2*(m1**6 + 2*m1sq*m3**4 + 3*m1**4*m3sq)*B0del(0,0,m1sq,mudim) + 2*(m1**6 + 2*m1sq*m3**4 + 3*m1**4*m3sq)*B0del(0,0,m3sq,mudim) - 2*m1sq*m3**4*B0fin(0,0,m1sq,mudim) - 2*m3**6*B0fin(0,0,m1sq,mudim) + 16*m1**4*m3sq*B0fin(0,0,m1sq,mudim) + m1**6*B0fin(0,0,m1sq,mudim)**2 + m1sq*m3**4*B0fin(0,0,m1sq,mudim)**2 - 2*m1**4*m3sq*B0fin(0,0,m1sq,mudim)**2 - 6*m1**6*B0fin(0,0,m3sq,mudim) + 4*m1sq*m3**4*B0fin(0,0,m3sq,mudim) + 14*m1**4*m3sq*B0fin(0,0,m3sq,mudim) + 2*m1sq*m3**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 10*m1**4*m3sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + m1**6*B0fin(0,0,m3sq,mudim)**2 + m1sq*m3**4*B0fin(0,0,m3sq,mudim)**2 - 2*m1**4*m3sq*B0fin(0,0,m3sq,mudim)**2 - 4*m1**4*T134fin(m3,m1,0,mudim) - 8*m1sq*m3sq*T134fin(m3,m1,0,mudim))/(2.*m1**2*(m1sq - m3sq)**5)
		def eval_91():
			return (3*m1**6 + m1sq*m2**4 + 3*m2**6 + 17*m1**4*m2sq + 2*(m1**6 + 2*m1sq*m2**4 + 3*m1**4*m2sq)*B0del(0,0,m1sq,mudim) + 2*(m1**6 + 2*m1sq*m2**4 + 3*m1**4*m2sq)*B0del(0,0,m2sq,mudim) - 6*m1**6*B0fin(0,0,m1sq,mudim) + 4*m1sq*m2**4*B0fin(0,0,m1sq,mudim) - 2*m2**6*B0fin(0,0,m1sq,mudim) + 16*m1**4*m2sq*B0fin(0,0,m1sq,mudim) - 2*m1sq*m2**4*B0fin(0,0,m2sq,mudim) + 14*m1**4*m2sq*B0fin(0,0,m2sq,mudim) + 2*m1**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 4*m1sq*m2**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 6*m1**4*m2sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 4*m1**4*T134fin(m2,m1,0,mudim) - 8*m1sq*m2sq*T134fin(m2,m1,0,mudim))/(2.*m1**2*(m1sq - m2sq)**5)
		def eval_92():
			return (3*m1**6 + m1sq*m2**4 + 3*m2**6 + 17*m1**4*m2sq + 2*(m1**6 + 2*m1sq*m2**4 + 3*m1**4*m2sq)*B0del(0,0,m1sq,mudim) + 2*(m1**6 + 2*m1sq*m2**4 + 3*m1**4*m2sq)*B0del(0,0,m2sq,mudim) - 6*m1**6*B0fin(0,0,m1sq,mudim) + 4*m1sq*m2**4*B0fin(0,0,m1sq,mudim) - 2*m2**6*B0fin(0,0,m1sq,mudim) + 16*m1**4*m2sq*B0fin(0,0,m1sq,mudim) - 2*m1sq*m2**4*B0fin(0,0,m2sq,mudim) + 14*m1**4*m2sq*B0fin(0,0,m2sq,mudim) + 2*m1**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 4*m1sq*m2**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 6*m1**4*m2sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 4*m1**4*T134fin(m2,m1,0,mudim) - 8*m1sq*m2sq*T134fin(m2,m1,0,mudim))/(2.*m1**2*(m1sq - m2sq)**5)
		def eval_93():
			return -0.027777777777777776*(-25*m1**8 - 24*m1**4*m7**4 + 46*m1sq*m7**6 - 7*m7**8 + 154*m1**6*m7sq + 36*m1**4*m7sq*(m1sq + m7sq)*B0del(0,0,m1sq,mudim) + 36*m1**4*m7sq*(m1sq + m7sq)*B0del(0,0,m7sq,mudim) - 24*m1**8*B0fin(0,0,m1sq,mudim) + 144*m1**4*m7**4*B0fin(0,0,m1sq,mudim) - 66*m1sq*m7**6*B0fin(0,0,m1sq,mudim) + 12*m7**8*B0fin(0,0,m1sq,mudim) + 6*m1**6*m7sq*B0fin(0,0,m1sq,mudim) + 36*m1**4*m7**4*B0fin(0,0,m7sq,mudim) - 18*m1sq*m7**6*B0fin(0,0,m7sq,mudim) + 54*m1**6*m7sq*B0fin(0,0,m7sq,mudim) + 36*m1**4*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) + 36*m1**6*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 72*m1**4*m7sq*T134fin(m7,m1,0,mudim))/(m1**4*(m1sq - m7sq)**5)
		def eval_94():
			return (8*m1**8 + 20*m1**4*m7**4 - 9*m1sq*m7**6 + m7**8 - 20*m1**6*m7sq + 8*(m1**8 - m1**6*m7sq)*B0del(0,0,m1sq,mudim) + 4*m1**4*(m1sq - m7sq)*m7sq*B0del(0,0,m7sq,mudim) + 8*m1**8*B0fin(0,0,m1sq,mudim) + 2*m1**4*m7**4*B0fin(0,0,m1sq,mudim) - m1sq*m7**6*B0fin(0,0,m1sq,mudim) + 4*m1**8*B0fin(0,0,m1sq,mudim)**2 + 2*m1**4*m7**4*B0fin(0,0,m1sq,mudim)**2 - 6*m1**6*m7sq*B0fin(0,0,m1sq,mudim)**2 - 6*m1**4*m7**4*B0fin(0,0,m7sq,mudim) + m1sq*m7**6*B0fin(0,0,m7sq,mudim) - 4*m1**6*m7sq*B0fin(0,0,m7sq,mudim) - 4*m1**4*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) + 4*m1**6*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 4*m1**6*T134fin(m7,m1,m1,mudim) + 4*m1**4*m7sq*T134fin(m7,m1,m1,mudim))/(2.*m1**4*(m1 - m7)*m7**4*(m1 + m7)*(-4*m1sq + m7sq)**2)
		def eval_95():
			return (8*m1**8 + 20*m1**4*m5**4 - 9*m1sq*m5**6 + m5**8 - 20*m1**6*m5sq + 8*(m1**8 - m1**6*m5sq)*B0del(0,0,m1sq,mudim) + 4*m1**4*(m1sq - m5sq)*m5sq*B0del(0,0,m5sq,mudim) + 8*m1**8*B0fin(0,0,m1sq,mudim) + 2*m1**4*m5**4*B0fin(0,0,m1sq,mudim) - m1sq*m5**6*B0fin(0,0,m1sq,mudim) + 4*m1**8*B0fin(0,0,m1sq,mudim)**2 + 2*m1**4*m5**4*B0fin(0,0,m1sq,mudim)**2 - 6*m1**6*m5sq*B0fin(0,0,m1sq,mudim)**2 - 6*m1**4*m5**4*B0fin(0,0,m5sq,mudim) + m1sq*m5**6*B0fin(0,0,m5sq,mudim) - 4*m1**6*m5sq*B0fin(0,0,m5sq,mudim) - 4*m1**4*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 4*m1**6*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 4*m1**6*T134fin(m5,m1,m1,mudim) + 4*m1**4*m5sq*T134fin(m5,m1,m1,mudim))/(2.*m1**4*(m1 - m5)*m5**4*(m1 + m5)*(-4*m1sq + m5sq)**2)
		def eval_96():
			return -0.027777777777777776*(-25*m1**8 - 24*m1**4*m5**4 + 46*m1sq*m5**6 - 7*m5**8 + 154*m1**6*m5sq + 36*m1**4*m5sq*(m1sq + m5sq)*B0del(0,0,m1sq,mudim) + 36*m1**4*m5sq*(m1sq + m5sq)*B0del(0,0,m5sq,mudim) - 24*m1**8*B0fin(0,0,m1sq,mudim) + 144*m1**4*m5**4*B0fin(0,0,m1sq,mudim) - 66*m1sq*m5**6*B0fin(0,0,m1sq,mudim) + 12*m5**8*B0fin(0,0,m1sq,mudim) + 6*m1**6*m5sq*B0fin(0,0,m1sq,mudim) + 36*m1**4*m5**4*B0fin(0,0,m5sq,mudim) - 18*m1sq*m5**6*B0fin(0,0,m5sq,mudim) + 54*m1**6*m5sq*B0fin(0,0,m5sq,mudim) + 36*m1**4*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 36*m1**6*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 72*m1**4*m5sq*T134fin(m5,m1,0,mudim))/(m1**4*(m1sq - m5sq)**5)
		def eval_97():
			return (12*m2**8 + 66*m2**4*m3**4 - 12*m2sq*m3**6 - 102*m2**6*m3sq + 6*(2*m2**8 + 11*m2**4*m3**4 - 2*m2sq*m3**6 - 14*m2**6*m3sq)*B0del(0,0,m2sq,mudim) - 18*m2**6*m3sq*B0del(0,0,m3sq,mudim) + 12*m2**8*B0fin(0,0,m2sq,mudim) + 66*m2**4*m3**4*B0fin(0,0,m2sq,mudim) - 12*m2sq*m3**6*B0fin(0,0,m2sq,mudim) - 84*m2**6*m3sq*B0fin(0,0,m2sq,mudim) + 6*m2**8*B0fin(0,0,m2sq,mudim)**2 + 33*m2**4*m3**4*B0fin(0,0,m2sq,mudim)**2 - 6*m2sq*m3**6*B0fin(0,0,m2sq,mudim)**2 - 33*m2**6*m3sq*B0fin(0,0,m2sq,mudim)**2 - 18*m2**6*m3sq*B0fin(0,0,m3sq,mudim) - 18*m2**6*m3sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) - 24*m2**6*T134fin(m2,0,0,mudim) - 36*m2sq*m3**4*T134fin(m2,0,0,mudim) + 6*m3**6*T134fin(m2,0,0,mudim) + 54*m2**4*m3sq*T134fin(m2,0,0,mudim) - 10*m2sq*m3**4*T134fin(m2,m2,m2,mudim) + 2*m3**6*T134fin(m2,m2,m2,mudim) + 8*m2**4*m3sq*T134fin(m2,m2,m2,mudim) + 24*m2**6*T134fin(m3,m2,0,mudim) - 6*m2**4*m3sq*T134fin(m3,m2,0,mudim) - 6*m2**6*T134fin(m3,m2,m2,mudim) + 6*m2**4*m3sq*T134fin(m3,m2,m2,mudim))/(6.*m2**6*m3**2*(m2sq - m3sq)**2*(4*m2sq - m3sq))
		def eval_98():
			return (12*m2**8 + 66*m2**4*m3**4 - 12*m2sq*m3**6 - 102*m2**6*m3sq + 6*(2*m2**8 + 11*m2**4*m3**4 - 2*m2sq*m3**6 - 14*m2**6*m3sq)*B0del(0,0,m2sq,mudim) - 18*m2**6*m3sq*B0del(0,0,m3sq,mudim) + 12*m2**8*B0fin(0,0,m2sq,mudim) + 66*m2**4*m3**4*B0fin(0,0,m2sq,mudim) - 12*m2sq*m3**6*B0fin(0,0,m2sq,mudim) - 84*m2**6*m3sq*B0fin(0,0,m2sq,mudim) + 6*m2**8*B0fin(0,0,m2sq,mudim)**2 + 33*m2**4*m3**4*B0fin(0,0,m2sq,mudim)**2 - 6*m2sq*m3**6*B0fin(0,0,m2sq,mudim)**2 - 33*m2**6*m3sq*B0fin(0,0,m2sq,mudim)**2 - 18*m2**6*m3sq*B0fin(0,0,m3sq,mudim) - 18*m2**6*m3sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) - 24*m2**6*T134fin(m2,0,0,mudim) - 36*m2sq*m3**4*T134fin(m2,0,0,mudim) + 6*m3**6*T134fin(m2,0,0,mudim) + 54*m2**4*m3sq*T134fin(m2,0,0,mudim) - 10*m2sq*m3**4*T134fin(m2,m2,m2,mudim) + 2*m3**6*T134fin(m2,m2,m2,mudim) + 8*m2**4*m3sq*T134fin(m2,m2,m2,mudim) + 24*m2**6*T134fin(m3,m2,0,mudim) - 6*m2**4*m3sq*T134fin(m3,m2,0,mudim) - 6*m2**6*T134fin(m3,m2,m2,mudim) + 6*m2**4*m3sq*T134fin(m3,m2,m2,mudim))/(6.*m2**6*m3**2*(m2sq - m3sq)**2*(4*m2sq - m3sq))
		def eval_99():
			return -0.05555555555555555*(-11*m1**8 - 39*m1**4*m3**4 + 35*m1sq*m3**6 - 2*m3**8 + 89*m1**6*m3sq + 18*m1**4*m3sq*(m1sq + m3sq)*B0del(0,0,m1sq,mudim) + 18*m1**4*m3sq*(m1sq + m3sq)*B0del(0,0,m3sq,mudim) - 12*m1**8*B0fin(0,0,m1sq,mudim) + 72*m1**4*m3**4*B0fin(0,0,m1sq,mudim) - 42*m1sq*m3**6*B0fin(0,0,m1sq,mudim) + 6*m3**8*B0fin(0,0,m1sq,mudim) + 12*m1**6*m3sq*B0fin(0,0,m1sq,mudim) + 18*m1**4*m3**4*B0fin(0,0,m3sq,mudim) + 18*m1**6*m3sq*B0fin(0,0,m3sq,mudim) + 18*m1**4*m3**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 18*m1**6*m3sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 36*m1**4*m3sq*T134fin(m3,m1,0,mudim))/(m1**4*(m1sq - m3sq)**5)
		def eval_100():
			return (6*m1**4 + 6*m1sq*m3sq + 6*m1sq*(m1sq + m3sq)*B0del(0,0,m1sq,mudim) + 6*m1sq*(m1sq + m3sq)*B0fin(0,0,m1sq,mudim) + 3*m1sq*(m1sq + m3sq)*B0fin(0,0,m1sq,mudim)**2 - 3*m3sq*T134fin(m1,0,0,mudim) - 2*m1sq*T134fin(m1,m1,m1,mudim) - m3sq*T134fin(m1,m1,m1,mudim) + 3*m1sq*T134fin(m3,0,0,mudim) - 6*m1sq*T134fin(m3,m1,0,mudim) + 3*m1sq*T134fin(m3,m1,m1,mudim))/(3.*m1**6*(m1sq - m3sq)**2)
		def eval_101():
			return -0.05555555555555555*(-11*m1**8 - 39*m1**4*m3**4 + 35*m1sq*m3**6 - 2*m3**8 + 89*m1**6*m3sq + 18*m1**4*m3sq*(m1sq + m3sq)*B0del(0,0,m1sq,mudim) + 18*m1**4*m3sq*(m1sq + m3sq)*B0del(0,0,m3sq,mudim) - 12*m1**8*B0fin(0,0,m1sq,mudim) + 72*m1**4*m3**4*B0fin(0,0,m1sq,mudim) - 42*m1sq*m3**6*B0fin(0,0,m1sq,mudim) + 6*m3**8*B0fin(0,0,m1sq,mudim) + 12*m1**6*m3sq*B0fin(0,0,m1sq,mudim) + 18*m1**4*m3**4*B0fin(0,0,m3sq,mudim) + 18*m1**6*m3sq*B0fin(0,0,m3sq,mudim) + 18*m1**4*m3**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 18*m1**6*m3sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 36*m1**4*m3sq*T134fin(m3,m1,0,mudim))/(m1**4*(m1sq - m3sq)**5)
		def eval_102():
			return -0.5*(-2*m3sq*(m4sq - m5sq)**4*m5sq*(m3**4 - m3sq*(m4sq - 3*m5sq) + (m4sq - m5sq)*m5sq)*B0del(0,0,m3sq,mudim) + 2*m3**4*m4sq*(m3sq - 4*m5sq)*(m4sq - m5sq)*m5sq*(-m4**4 + m3sq*m4sq + m5**4 - 4*m4sq*m5sq)*B0del(0,0,m4sq,mudim) + (m4sq - m5sq)**3*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))*((2*m3sq*m5**4 + 2*m5**6 - m3**4*m5sq)*B0del(0,0,m5sq,mudim) - m3**4*(m3sq - 4*m5sq)*(-2 + B0fin(0,0,m5sq,mudim))) + (m4sq - m5sq)*m5sq*(2*(-(m4sq*m5) + m5**3)**4 - 4*m3sq*m5**4*(m4sq - m5sq)**2*(m4sq + m5sq) - 2*m3**6*(m4**6 + 5*m4sq*m5**4 - 3*m5**6 + 5*m4**4*m5sq) + m3**4*(m4**8 + 56*m4**4*m5**4 - 24*m4sq*m5**6 + 3*m5**8 - 4*m4**6*m5sq) + m3**8*(m4**4 - m5**4 + 2*m4sq*m5sq))*(B0del(0,0,m5sq,mudim) - B0fin(0,0,m5sq,mudim)) + (m4sq - m5sq)*(1 - B0fin(0,0,m5sq,mudim))*(2*m3sq*(m4sq - m5sq)**3*m5sq*(m3**4 - m3sq*(m4sq - 3*m5sq) + (m4sq - m5sq)*m5sq)*B0fin(0,0,m3sq,mudim) - 2*m3**4*m4sq*(m3sq - 4*m5sq)*m5sq*(-m4**4 + m3sq*m4sq + m5**4 - 4*m4sq*m5sq)*B0fin(0,0,m4sq,mudim) + (m4sq - m5sq)**2*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))*(m3**6 - 4*m3**4*m5sq + m5sq*(m3**4 - 2*m5**4 - 2*m3sq*m5sq)*B0fin(0,0,m5sq,mudim))) + 2*m5sq*(2*m3**4*m4sq*(m3sq - 4*m5sq)*(m4sq - m5sq)**3*(B0fin(0,0,m3sq,mudim) + B0fin(0,0,m4sq,mudim)) + 2*m5**4*(m4sq - m5sq)**3*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))*B0fin(0,0,m5sq,mudim) - m3sq*(m4sq - m5sq)**3*m5sq*(2*m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + 3*m5sq))*(B0fin(0,0,m3sq,mudim) + B0fin(0,0,m5sq,mudim)) + m3**4*m4sq*(m3sq - 4*m5sq)*(-4*m5sq*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq)) + (-(m3**4*(m4sq + m5sq)) - (m4sq - m5sq)*(m4sq + m5sq)**2 + m3sq*(2*m4**4 + m5**4 + 5*m4sq*m5sq))*B0fin(0,0,m4sq,mudim) + (-(m3**4*(m4sq + m5sq)) - (m4sq - m5sq)*(m4sq + m5sq)**2 + m3sq*(2*m4**4 + m5**4 + 5*m4sq*m5sq))*B0fin(0,0,m5sq,mudim))) - 2*m5sq*(2*m3**4*m4sq*(m3sq - 4*m5sq)*(m4sq - m5sq)**3*(B0del(0,0,m3sq,mudim) + B0del(0,0,m4sq,mudim) + B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim)) + m3sq*m5sq*(-m4sq + m5sq)**3*(2*m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + 3*m5sq))*(B0del(0,0,m3sq,mudim) + B0del(0,0,m5sq,mudim) + B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim)) + m3**4*m4sq*(m3sq - 4*m5sq)*(-((m3**4*(m4sq + m5sq) + (m4sq - m5sq)*(m4sq + m5sq)**2 - m3sq*(2*m4**4 + m5**4 + 5*m4sq*m5sq))*B0del(0,0,m4sq,mudim)) - (m3**4*(m4sq + m5sq) + (m4sq - m5sq)*(m4sq + m5sq)**2 - m3sq*(2*m4**4 + m5**4 + 5*m4sq*m5sq))*B0del(0,0,m5sq,mudim) - 4*m5sq*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))*B0fin(0,0,m4sq,mudim) - (4*m5sq*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq)) + (m3**4*(m4sq + m5sq) + (m4sq - m5sq)*(m4sq + m5sq)**2 - m3sq*(2*m4**4 + m5**4 + 5*m4sq*m5sq))*B0fin(0,0,m4sq,mudim))*B0fin(0,0,m5sq,mudim)) + m5**4*(m4sq - m5sq)**3*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))*(2*B0del(0,0,m5sq,mudim) + B0fin(0,0,m5sq,mudim)**2)) + 2*m3sq*(m3sq - 4*m5sq)*m5sq*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))*(2*m3sq*(m4sq + m5sq)**2 + (m4sq - m5sq)*(m3sq + m4sq - m5sq)*(m4sq + m5sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim)) + (-2*m3sq*m4sq - (m4sq - m5sq)**2)*T134fin(m5,m4,0,mudim)) + 2*m3sq*(m3sq - 4*m5sq)*(m3sq + m4sq - m5sq)*m5sq*(-m4sq + m5sq)**3*(m3sq + m4sq + m5sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) - T134fin(m5,m4,m3,mudim)) + 2*m3sq*(m4sq - m5sq)**3*m5sq*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))*(m3sq + 2*m5sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 4*m5sq*B0fin(0,0,m5sq,mudim) - T134fin(m5,m5,m3,mudim)))/(m3**6*m5**2*(m3sq - 4*m5sq)*(m4sq - m5sq)**4*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq)))
		def eval_103():
			return (2*m3**8*m4**4 - 8*m3**6*m4**6 + 14*m3**4*m4**8 - 8*m3sq*m4**10 + 2*m3**8*m6**4 + 52*m3**4*m4**4*m6**4 + 16*m3sq*m4**6*m6**4 - 24*m3**6*m4sq*m6**4 - 8*m3**6*m6**6 + 16*m3sq*m4**4*m6**6 + 24*m3**4*m4sq*m6**6 + 14*m3**4*m6**8 - 8*m3sq*m4sq*m6**8 - 8*m3sq*m6**10 - 24*m3**6*m4**4*m6sq + 24*m3**4*m4**6*m6sq - 8*m3sq*m4**8*m6sq + 4*m3**8*m4sq*m6sq + 2*m3sq*(m3sq - m4sq - m6sq)*(m4sq - m6sq)**4*B0del(0,0,m3sq,mudim) + (-((m4sq - m6sq)**5*(m4sq + m6sq)) + m3**8*(m4sq + m6sq)**2 - 4*m3**6*(m4sq + m6sq)**3 - 2*m3sq*(m4**10 - 10*m4**6*m6**4 + m4sq*m6**8 + 2*m6**10 + 6*m4**8*m6sq) + 2*m3**4*(m4sq + m6sq)**2*(3*m4**4 + 3*m6**4 + 2*m4sq*m6sq))*B0del(0,0,m4sq,mudim) + m3**8*m4**4*B0del(0,0,m6sq,mudim) - 4*m3**6*m4**6*B0del(0,0,m6sq,mudim) + 6*m3**4*m4**8*B0del(0,0,m6sq,mudim) - 4*m3sq*m4**10*B0del(0,0,m6sq,mudim) + m4**12*B0del(0,0,m6sq,mudim) + m3**8*m6**4*B0del(0,0,m6sq,mudim) + 20*m3**4*m4**4*m6**4*B0del(0,0,m6sq,mudim) + 5*m4**8*m6**4*B0del(0,0,m6sq,mudim) - 12*m3**6*m4sq*m6**4*B0del(0,0,m6sq,mudim) - 4*m3**6*m6**6*B0del(0,0,m6sq,mudim) + 20*m3sq*m4**4*m6**6*B0del(0,0,m6sq,mudim) + 16*m3**4*m4sq*m6**6*B0del(0,0,m6sq,mudim) + 6*m3**4*m6**8*B0del(0,0,m6sq,mudim) - 5*m4**4*m6**8*B0del(0,0,m6sq,mudim) - 12*m3sq*m4sq*m6**8*B0del(0,0,m6sq,mudim) - 2*m3sq*m6**10*B0del(0,0,m6sq,mudim) + 4*m4sq*m6**10*B0del(0,0,m6sq,mudim) - m6**12*B0del(0,0,m6sq,mudim) - 12*m3**6*m4**4*m6sq*B0del(0,0,m6sq,mudim) + 16*m3**4*m4**6*m6sq*B0del(0,0,m6sq,mudim) - 2*m3sq*m4**8*m6sq*B0del(0,0,m6sq,mudim) - 4*m4**10*m6sq*B0del(0,0,m6sq,mudim) + 2*m3**8*m4sq*m6sq*B0del(0,0,m6sq,mudim) + 2*m3sq*m4**10*B0fin(0,0,m3sq,mudim) - 2*m4**12*B0fin(0,0,m3sq,mudim) + 4*m3sq*m4**6*m6**4*B0fin(0,0,m3sq,mudim) - 30*m4**8*m6**4*B0fin(0,0,m3sq,mudim) + 4*m3sq*m4**4*m6**6*B0fin(0,0,m3sq,mudim) + 40*m4**6*m6**6*B0fin(0,0,m3sq,mudim) - 30*m4**4*m6**8*B0fin(0,0,m3sq,mudim) - 6*m3sq*m4sq*m6**8*B0fin(0,0,m3sq,mudim) + 2*m3sq*m6**10*B0fin(0,0,m3sq,mudim) + 12*m4sq*m6**10*B0fin(0,0,m3sq,mudim) - 2*m6**12*B0fin(0,0,m3sq,mudim) - 6*m3sq*m4**8*m6sq*B0fin(0,0,m3sq,mudim) + 12*m4**10*m6sq*B0fin(0,0,m3sq,mudim) - 2*m3**8*m4**4*B0fin(0,0,m4sq,mudim) + 7*m3**6*m4**6*B0fin(0,0,m4sq,mudim) - 7*m3**4*m4**8*B0fin(0,0,m4sq,mudim) + 3*m3sq*m4**10*B0fin(0,0,m4sq,mudim) - m4**12*B0fin(0,0,m4sq,mudim) + 18*m3**4*m4**4*m6**4*B0fin(0,0,m4sq,mudim) + 22*m3sq*m4**6*m6**4*B0fin(0,0,m4sq,mudim) - 15*m4**8*m6**4*B0fin(0,0,m4sq,mudim) - 27*m3**6*m4sq*m6**4*B0fin(0,0,m4sq,mudim) + m3**6*m6**6*B0fin(0,0,m4sq,mudim) + 22*m3sq*m4**4*m6**6*B0fin(0,0,m4sq,mudim) + 20*m4**6*m6**6*B0fin(0,0,m4sq,mudim) + 40*m3**4*m4sq*m6**6*B0fin(0,0,m4sq,mudim) - 3*m3**4*m6**8*B0fin(0,0,m4sq,mudim) - 15*m4**4*m6**8*B0fin(0,0,m4sq,mudim) - 25*m3sq*m4sq*m6**8*B0fin(0,0,m4sq,mudim) + 3*m3sq*m6**10*B0fin(0,0,m4sq,mudim) + 6*m4sq*m6**10*B0fin(0,0,m4sq,mudim) - m6**12*B0fin(0,0,m4sq,mudim) - 13*m3**6*m4**4*m6sq*B0fin(0,0,m4sq,mudim) + 16*m3**4*m4**6*m6sq*B0fin(0,0,m4sq,mudim) - 25*m3sq*m4**8*m6sq*B0fin(0,0,m4sq,mudim) + 6*m4**10*m6sq*B0fin(0,0,m4sq,mudim) + 6*m3**8*m4sq*m6sq*B0fin(0,0,m4sq,mudim) + m3**4*m4**8*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) - m4**12*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + 6*m3**4*m4**4*m6**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + 8*m3sq*m4**6*m6**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) - 5*m4**8*m6**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) - 12*m3sq*m4**4*m6**6*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) - 4*m3**4*m4sq*m6**6*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + m3**4*m6**8*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + 5*m4**4*m6**8*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + 8*m3sq*m4sq*m6**8*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) - 2*m3sq*m6**10*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) - 4*m4sq*m6**10*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + m6**12*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) - 4*m3**4*m4**6*m6sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) - 2*m3sq*m4**8*m6sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + 4*m4**10*m6sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + m3**6*m4**6*B0fin(0,0,m6sq,mudim) - 3*m3**4*m4**8*B0fin(0,0,m6sq,mudim) + 3*m3sq*m4**10*B0fin(0,0,m6sq,mudim) - m4**12*B0fin(0,0,m6sq,mudim) - 2*m3**8*m6**4*B0fin(0,0,m6sq,mudim) + 18*m3**4*m4**4*m6**4*B0fin(0,0,m6sq,mudim) + 22*m3sq*m4**6*m6**4*B0fin(0,0,m6sq,mudim) - 15*m4**8*m6**4*B0fin(0,0,m6sq,mudim) - 13*m3**6*m4sq*m6**4*B0fin(0,0,m6sq,mudim) + 7*m3**6*m6**6*B0fin(0,0,m6sq,mudim) + 22*m3sq*m4**4*m6**6*B0fin(0,0,m6sq,mudim) + 20*m4**6*m6**6*B0fin(0,0,m6sq,mudim) + 16*m3**4*m4sq*m6**6*B0fin(0,0,m6sq,mudim) - 7*m3**4*m6**8*B0fin(0,0,m6sq,mudim) - 15*m4**4*m6**8*B0fin(0,0,m6sq,mudim) - 25*m3sq*m4sq*m6**8*B0fin(0,0,m6sq,mudim) + 3*m3sq*m6**10*B0fin(0,0,m6sq,mudim) + 6*m4sq*m6**10*B0fin(0,0,m6sq,mudim) - m6**12*B0fin(0,0,m6sq,mudim) - 27*m3**6*m4**4*m6sq*B0fin(0,0,m6sq,mudim) + 40*m3**4*m4**6*m6sq*B0fin(0,0,m6sq,mudim) - 25*m3sq*m4**8*m6sq*B0fin(0,0,m6sq,mudim) + 6*m4**10*m6sq*B0fin(0,0,m6sq,mudim) + 6*m3**8*m4sq*m6sq*B0fin(0,0,m6sq,mudim) + m3**4*m4**8*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m3sq*m4**10*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) + m4**12*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) + 6*m3**4*m4**4*m6**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) - 12*m3sq*m4**6*m6**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) + 5*m4**8*m6**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) + 8*m3sq*m4**4*m6**6*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m3**4*m4sq*m6**6*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) + m3**4*m6**8*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) - 5*m4**4*m6**8*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m3sq*m4sq*m6**8*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) + 4*m4sq*m6**10*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) - m6**12*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m3**4*m4**6*m6sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) + 8*m3sq*m4**8*m6sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m4**10*m6sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) + m3**8*m4**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m3**6*m4**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) + 5*m3**4*m4**8*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m3sq*m4**10*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) + m3**8*m6**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) + 14*m3**4*m4**4*m6**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) + 12*m3sq*m4**6*m6**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) - 12*m3**6*m4sq*m6**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m3**6*m6**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) + 12*m3sq*m4**4*m6**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) + 20*m3**4*m4sq*m6**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) + 5*m3**4*m6**8*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) - 10*m3sq*m4sq*m6**8*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m3sq*m6**10*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) - 12*m3**6*m4**4*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) + 20*m3**4*m4**6*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) - 10*m3sq*m4**8*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m3**8*m4sq*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) + 8*m3**6*m4**4*T134fin(m6,m4,0,mudim) - 12*m3**4*m4**6*T134fin(m6,m4,0,mudim) + 8*m3sq*m4**8*T134fin(m6,m4,0,mudim) - 2*m4**10*T134fin(m6,m4,0,mudim) - 2*m3**8*m4sq*T134fin(m6,m4,0,mudim) + 8*m3**6*m6**4*T134fin(m6,m4,0,mudim) - 16*m3sq*m4**4*m6**4*T134fin(m6,m4,0,mudim) - 4*m4**6*m6**4*T134fin(m6,m4,0,mudim) - 20*m3**4*m4sq*m6**4*T134fin(m6,m4,0,mudim) - 12*m3**4*m6**6*T134fin(m6,m4,0,mudim) - 4*m4**4*m6**6*T134fin(m6,m4,0,mudim) + 8*m3sq*m6**8*T134fin(m6,m4,0,mudim) + 6*m4sq*m6**8*T134fin(m6,m4,0,mudim) - 2*m6**10*T134fin(m6,m4,0,mudim) - 2*m3**8*m6sq*T134fin(m6,m4,0,mudim) - 20*m3**4*m4**4*m6sq*T134fin(m6,m4,0,mudim) + 6*m4**8*m6sq*T134fin(m6,m4,0,mudim) + 16*m3**6*m4sq*m6sq*T134fin(m6,m4,0,mudim) - 2*m3sq*m4**8*T134fin(m6,m4,m3,mudim) + 2*m4**10*T134fin(m6,m4,m3,mudim) - 12*m3sq*m4**4*m6**4*T134fin(m6,m4,m3,mudim) + 4*m4**6*m6**4*T134fin(m6,m4,m3,mudim) + 4*m4**4*m6**6*T134fin(m6,m4,m3,mudim) + 8*m3sq*m4sq*m6**6*T134fin(m6,m4,m3,mudim) - 2*m3sq*m6**8*T134fin(m6,m4,m3,mudim) - 6*m4sq*m6**8*T134fin(m6,m4,m3,mudim) + 2*m6**10*T134fin(m6,m4,m3,mudim) + 8*m3sq*m4**6*m6sq*T134fin(m6,m4,m3,mudim) - 6*m4**8*m6sq*T134fin(m6,m4,m3,mudim))/(m3**2*(m4 - m6)**4*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(m4 + m6)**4*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2)
		def eval_104():
			return ((m4sq - m5sq)**2*(6*m3sq - 4*m4sq + 2*(m3sq - 2*m4sq)*B0del(0,0,m4sq,mudim) - 2*(3*m3sq + 2*m4sq)*B0fin(0,0,m4sq,mudim) + (m3sq - 2*m4sq)*B0fin(0,0,m4sq,mudim)**2) + 4*m3sq*(m4sq + m5sq)*(m4sq + m5sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim)) + 8*m3sq*m4sq*m5sq*(B0del(0,0,m4sq,mudim) + B0del(0,0,m5sq,mudim) - B0fin(0,0,m4sq,mudim) - B0fin(0,0,m5sq,mudim) + B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim)) + (m4sq - m5sq)**2*(6*m3sq - 4*m5sq + 2*(m3sq - 2*m5sq)*B0del(0,0,m5sq,mudim) - 2*(3*m3sq + 2*m5sq)*B0fin(0,0,m5sq,mudim) + (m3sq - 2*m5sq)*B0fin(0,0,m5sq,mudim)**2) + 2*(m4sq - m5sq)**2*T134fin(m4,m4,m3,mudim) + 4*((m4sq - m5sq)**2 - m3sq*(m4sq + m5sq))*T134fin(m5,m4,0,mudim) - 4*(m4sq - m5sq)**2*T134fin(m5,m4,m3,mudim) + 2*(m4sq - m5sq)**2*T134fin(m5,m5,m3,mudim))/(2.*m3**4*(m4sq - m5sq)**4)
		def eval_105():
			return ((4*m3sq*(m3**4 - m4**4 + m3sq*(3*m4sq - m7sq) + m4sq*m7sq)*B0del(0,0,m3sq,mudim))/((m3sq - 4*m4sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (4*m3**4*m7sq*(m4**4 - m7**4 + m3sq*m7sq - 4*m4sq*m7sq)*B0del(0,0,m7sq,mudim))/((m4sq - m7sq)**3*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (2*(m4sq*(m3**4 - 2*m4**4 - 2*m3sq*m4sq)*B0del(0,0,m4sq,mudim) + m3**4*(m3sq - 4*m4sq)*(-2 + B0fin(0,0,m4sq,mudim))))/(m4**2*(m3sq - 4*m4sq)*(m4sq - m7sq)) - (2*(4*m3sq*m4**4*(m4sq - m7sq)**2*(m4sq + m7sq) - 2*(m4**3 - m4*m7sq)**4 + 2*m3**6*(-3*m4**6 + 5*m4sq*m7**4 + m7**6 + 5*m4**4*m7sq) - m3**4*(3*m4**8 + 56*m4**4*m7**4 - 4*m4sq*m7**6 + m7**8 - 24*m4**6*m7sq) + m3**8*(m4**4 - m7**4 - 2*m4sq*m7sq))*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/((m3sq - 4*m4sq)*(m4sq - m7sq)**3*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (-1 + B0fin(0,0,m4sq,mudim))*((4*m3sq*(m3**4 - m4**4 + m3sq*(3*m4sq - m7sq) + m4sq*m7sq)*B0fin(0,0,m3sq,mudim))/((m3sq - 4*m4sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (2*(m3**6 - 4*m3**4*m4sq + m4sq*(m3**4 - 2*m4**4 - 2*m3sq*m4sq)*B0fin(0,0,m4sq,mudim)))/(m4**2*(m3sq - 4*m4sq)*(m4sq - m7sq)) + (4*m3**4*m7sq*(m4**4 - m7**4 + m3sq*m7sq - 4*m4sq*m7sq)*B0fin(0,0,m7sq,mudim))/((m4sq - m7sq)**3*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)))) + (4*((2*m4**4*(m4sq - m7sq)**3*B0fin(0,0,m4sq,mudim))/(m3sq - 4*m4sq) - (m3sq*m4sq*(m4sq - m7sq)**3*(2*m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(3*m4sq + m7sq))*(B0fin(0,0,m3sq,mudim) + B0fin(0,0,m4sq,mudim)))/((m3sq - 4*m4sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m3sq*m4sq*(m4sq - m7sq)**3*(2*m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(3*m4sq + m7sq))*(B0del(0,0,m3sq,mudim) + B0del(0,0,m4sq,mudim) + B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim)))/((m3sq - 4*m4sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m4**4*(m4sq - m7sq)**3*(2*B0del(0,0,m4sq,mudim) + B0fin(0,0,m4sq,mudim)**2))/(-m3sq + 4*m4sq) + (2*m3**4*(m4sq - m7sq)**3*m7sq*(B0fin(0,0,m3sq,mudim) + B0fin(0,0,m7sq,mudim)))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) - m3sq*m4sq*m7sq*(-4*m3sq + (-m3sq - m4sq + m7sq - (m3sq*m7sq)/m4**2 + (m4sq - m7sq)**3/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)))*B0fin(0,0,m4sq,mudim) + (-m3sq - m4sq + m7sq - (m3sq*m7sq)/m4**2 + (m4sq - m7sq)**3/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)))*B0fin(0,0,m7sq,mudim)) + (2*m3**4*m7sq*(-m4sq + m7sq)**3*(B0del(0,0,m3sq,mudim) + B0del(0,0,m7sq,mudim) + B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim)))/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)) + m3sq*m4sq*m7sq*((-m3sq - m4sq + m7sq - (m3sq*m7sq)/m4**2 + (m4sq - m7sq)**3/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)))*B0del(0,0,m4sq,mudim) + (-m3sq - m4sq + m7sq - (m3sq*m7sq)/m4**2 + (m4sq - m7sq)**3/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)))*B0del(0,0,m7sq,mudim) - 4*m3sq*B0fin(0,0,m4sq,mudim) + (-4*m3sq + (-m3sq - m4sq + m7sq - (m3sq*m7sq)/m4**2 + (m4sq - m7sq)**3/(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)))*B0fin(0,0,m4sq,mudim))*B0fin(0,0,m7sq,mudim))))/(m4sq - m7sq)**4 + (4*m3sq*(m3sq + 2*m4sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 4*m4sq*B0fin(0,0,m4sq,mudim) - T134fin(m4,m4,m3,mudim)))/((m3sq - 4*m4sq)*(m4sq - m7sq)) + (4*m3sq*(-2*m3sq*(m4sq + m7sq)**2 + (m4sq - m7sq)*(m3sq - m4sq + m7sq)*(m4sq + m7sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)) + (m4**4 + m7**4 + 2*m3sq*m7sq - 2*m4sq*m7sq)*T134fin(m7,m4,0,mudim)))/(m4sq - m7sq)**4 - (4*m3sq*(m3sq - m4sq + m7sq)*(m3sq + m4sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim) - T134fin(m7,m4,m3,mudim)))/((m4sq - m7sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))))/(4.*m3**6)
		def eval_106():
			return ((4*m3sq*(m3**4 - m4**4 + m3sq*(3*m4sq - m5sq) + m4sq*m5sq)*B0del(0,0,m3sq,mudim))/((m3sq - 4*m4sq)*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))) + (4*m3**4*m5sq*(m4**4 - m5**4 + m3sq*m5sq - 4*m4sq*m5sq)*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)**3*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))) - (2*(m4sq*(m3**4 - 2*m4**4 - 2*m3sq*m4sq)*B0del(0,0,m4sq,mudim) + m3**4*(m3sq - 4*m4sq)*(-2 + B0fin(0,0,m4sq,mudim))))/(m4**2*(m3sq - 4*m4sq)*(m4sq - m5sq)) - (2*(4*m3sq*m4**4*(m4sq - m5sq)**2*(m4sq + m5sq) - 2*(m4**3 - m4*m5sq)**4 + 2*m3**6*(-3*m4**6 + 5*m4sq*m5**4 + m5**6 + 5*m4**4*m5sq) - m3**4*(3*m4**8 + 56*m4**4*m5**4 - 4*m4sq*m5**6 + m5**8 - 24*m4**6*m5sq) + m3**8*(m4**4 - m5**4 - 2*m4sq*m5sq))*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/((m3sq - 4*m4sq)*(m4sq - m5sq)**3*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))) + (-1 + B0fin(0,0,m4sq,mudim))*((4*m3sq*(m3**4 - m4**4 + m3sq*(3*m4sq - m5sq) + m4sq*m5sq)*B0fin(0,0,m3sq,mudim))/((m3sq - 4*m4sq)*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))) - (2*(m3**6 - 4*m3**4*m4sq + m4sq*(m3**4 - 2*m4**4 - 2*m3sq*m4sq)*B0fin(0,0,m4sq,mudim)))/(m4**2*(m3sq - 4*m4sq)*(m4sq - m5sq)) + (4*m3**4*m5sq*(m4**4 - m5**4 + m3sq*m5sq - 4*m4sq*m5sq)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)**3*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq)))) + (4*((2*m4**4*(m4sq - m5sq)**3*B0fin(0,0,m4sq,mudim))/(m3sq - 4*m4sq) - (m3sq*m4sq*(m4sq - m5sq)**3*(2*m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(3*m4sq + m5sq))*(B0fin(0,0,m3sq,mudim) + B0fin(0,0,m4sq,mudim)))/((m3sq - 4*m4sq)*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))) + (m3sq*m4sq*(m4sq - m5sq)**3*(2*m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(3*m4sq + m5sq))*(B0del(0,0,m3sq,mudim) + B0del(0,0,m4sq,mudim) + B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim)))/((m3sq - 4*m4sq)*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))) + (m4**4*(m4sq - m5sq)**3*(2*B0del(0,0,m4sq,mudim) + B0fin(0,0,m4sq,mudim)**2))/(-m3sq + 4*m4sq) + (2*m3**4*(m4sq - m5sq)**3*m5sq*(B0fin(0,0,m3sq,mudim) + B0fin(0,0,m5sq,mudim)))/(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq)) - m3sq*m4sq*m5sq*(-4*m3sq + (-m3sq - m4sq + m5sq - (m3sq*m5sq)/m4**2 + (m4sq - m5sq)**3/(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq)))*B0fin(0,0,m4sq,mudim) + (-m3sq - m4sq + m5sq - (m3sq*m5sq)/m4**2 + (m4sq - m5sq)**3/(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq)))*B0fin(0,0,m5sq,mudim)) + (2*m3**4*m5sq*(-m4sq + m5sq)**3*(B0del(0,0,m3sq,mudim) + B0del(0,0,m5sq,mudim) + B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim)))/(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq)) + m3sq*m4sq*m5sq*((-m3sq - m4sq + m5sq - (m3sq*m5sq)/m4**2 + (m4sq - m5sq)**3/(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq)))*B0del(0,0,m4sq,mudim) + (-m3sq - m4sq + m5sq - (m3sq*m5sq)/m4**2 + (m4sq - m5sq)**3/(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq)))*B0del(0,0,m5sq,mudim) - 4*m3sq*B0fin(0,0,m4sq,mudim) + (-4*m3sq + (-m3sq - m4sq + m5sq - (m3sq*m5sq)/m4**2 + (m4sq - m5sq)**3/(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq)))*B0fin(0,0,m4sq,mudim))*B0fin(0,0,m5sq,mudim))))/(m4sq - m5sq)**4 + (4*m3sq*(m3sq + 2*m4sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 4*m4sq*B0fin(0,0,m4sq,mudim) - T134fin(m4,m4,m3,mudim)))/((m3sq - 4*m4sq)*(m4sq - m5sq)) + (4*m3sq*(-2*m3sq*(m4sq + m5sq)**2 + (m4sq - m5sq)*(m3sq - m4sq + m5sq)*(m4sq + m5sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim)) + (m4**4 + m5**4 + 2*m3sq*m5sq - 2*m4sq*m5sq)*T134fin(m5,m4,0,mudim)))/(m4sq - m5sq)**4 - (4*m3sq*(m3sq - m4sq + m5sq)*(m3sq + m4sq + m5sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) - T134fin(m5,m4,m3,mudim)))/((m4sq - m5sq)*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))))/(4.*m3**6)
		def eval_107():
			return (18*m2sq*m3**6*m4**4 - 18*m2**6*m3sq*m4**4 + 4*m2**6*m4**6 - 82*m2sq*m3**4*m4**6 - 4*m3**6*m4**6 + 82*m2**4*m3sq*m4**6 - 20*m2**4*m4**8 + 20*m3**4*m4**8 + 16*m2sq*m4**10 - 16*m3sq*m4**10 + 2*m2**6*m3**4*m4sq - 2*m2**4*m3**6*m4sq + 6*m2sq*m3sq*m4**4*(m3**4 + 4*m4**4 - 5*m3sq*m4sq)*B0del(0,0,m2sq,mudim) - 6*m2sq*m3sq*m4**4*(m2**4 + 4*m4**4 - 5*m2sq*m4sq)*B0del(0,0,m3sq,mudim) + 12*m2sq*m3**6*m4**4*B0del(0,0,m4sq,mudim) - 12*m2**6*m3sq*m4**4*B0del(0,0,m4sq,mudim) + 4*m2**6*m4**6*B0del(0,0,m4sq,mudim) - 52*m2sq*m3**4*m4**6*B0del(0,0,m4sq,mudim) - 4*m3**6*m4**6*B0del(0,0,m4sq,mudim) + 52*m2**4*m3sq*m4**6*B0del(0,0,m4sq,mudim) - 20*m2**4*m4**8*B0del(0,0,m4sq,mudim) + 20*m3**4*m4**8*B0del(0,0,m4sq,mudim) + 16*m2sq*m4**10*B0del(0,0,m4sq,mudim) - 16*m3sq*m4**10*B0del(0,0,m4sq,mudim) + 2*m2**6*m3**4*m4sq*B0del(0,0,m4sq,mudim) - 2*m2**4*m3**6*m4sq*B0del(0,0,m4sq,mudim) + 6*m2sq*m3**6*m4**4*B0fin(0,0,m2sq,mudim) - 30*m2sq*m3**4*m4**6*B0fin(0,0,m2sq,mudim) + 24*m2sq*m3sq*m4**8*B0fin(0,0,m2sq,mudim) - 6*m2**6*m3sq*m4**4*B0fin(0,0,m3sq,mudim) + 30*m2**4*m3sq*m4**6*B0fin(0,0,m3sq,mudim) - 24*m2sq*m3sq*m4**8*B0fin(0,0,m3sq,mudim) + 12*m2sq*m3**6*m4**4*B0fin(0,0,m4sq,mudim) - 12*m2**6*m3sq*m4**4*B0fin(0,0,m4sq,mudim) + 4*m2**6*m4**6*B0fin(0,0,m4sq,mudim) - 52*m2sq*m3**4*m4**6*B0fin(0,0,m4sq,mudim) - 4*m3**6*m4**6*B0fin(0,0,m4sq,mudim) + 52*m2**4*m3sq*m4**6*B0fin(0,0,m4sq,mudim) - 20*m2**4*m4**8*B0fin(0,0,m4sq,mudim) + 20*m3**4*m4**8*B0fin(0,0,m4sq,mudim) + 16*m2sq*m4**10*B0fin(0,0,m4sq,mudim) - 16*m3sq*m4**10*B0fin(0,0,m4sq,mudim) + 2*m2**6*m3**4*m4sq*B0fin(0,0,m4sq,mudim) - 2*m2**4*m3**6*m4sq*B0fin(0,0,m4sq,mudim) + 6*m2sq*m3**6*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 30*m2sq*m3**4*m4**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 24*m2sq*m3sq*m4**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 6*m2**6*m3sq*m4**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + 30*m2**4*m3sq*m4**6*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) - 24*m2sq*m3sq*m4**8*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + 3*m2sq*m3**6*m4**4*B0fin(0,0,m4sq,mudim)**2 - 3*m2**6*m3sq*m4**4*B0fin(0,0,m4sq,mudim)**2 + 2*m2**6*m4**6*B0fin(0,0,m4sq,mudim)**2 - 11*m2sq*m3**4*m4**6*B0fin(0,0,m4sq,mudim)**2 - 2*m3**6*m4**6*B0fin(0,0,m4sq,mudim)**2 + 11*m2**4*m3sq*m4**6*B0fin(0,0,m4sq,mudim)**2 - 10*m2**4*m4**8*B0fin(0,0,m4sq,mudim)**2 + 10*m3**4*m4**8*B0fin(0,0,m4sq,mudim)**2 + 8*m2sq*m4**10*B0fin(0,0,m4sq,mudim)**2 - 8*m3sq*m4**10*B0fin(0,0,m4sq,mudim)**2 + m2**6*m3**4*m4sq*B0fin(0,0,m4sq,mudim)**2 - m2**4*m3**6*m4sq*B0fin(0,0,m4sq,mudim)**2 - 2*m2**6*m3**4*T134fin(m4,0,0,mudim) + 2*m2**4*m3**6*T134fin(m4,0,0,mudim) - 8*m2**6*m4**4*T134fin(m4,0,0,mudim) + 42*m2sq*m3**4*m4**4*T134fin(m4,0,0,mudim) + 8*m3**6*m4**4*T134fin(m4,0,0,mudim) - 42*m2**4*m3sq*m4**4*T134fin(m4,0,0,mudim) + 40*m2**4*m4**6*T134fin(m4,0,0,mudim) - 40*m3**4*m4**6*T134fin(m4,0,0,mudim) - 32*m2sq*m4**8*T134fin(m4,0,0,mudim) + 32*m3sq*m4**8*T134fin(m4,0,0,mudim) - 10*m2sq*m3**6*m4sq*T134fin(m4,0,0,mudim) + 10*m2**6*m3sq*m4sq*T134fin(m4,0,0,mudim) - 10*m2sq*m3**4*m4**4*T134fin(m4,m2,0,mudim) - 8*m3**6*m4**4*T134fin(m4,m2,0,mudim) + 40*m3**4*m4**6*T134fin(m4,m2,0,mudim) + 8*m2sq*m3sq*m4**6*T134fin(m4,m2,0,mudim) - 32*m3sq*m4**8*T134fin(m4,m2,0,mudim) + 2*m2sq*m3**6*m4sq*T134fin(m4,m2,0,mudim) + 8*m2**6*m4**4*T134fin(m4,m3,0,mudim) + 10*m2**4*m3sq*m4**4*T134fin(m4,m3,0,mudim) - 40*m2**4*m4**6*T134fin(m4,m3,0,mudim) - 8*m2sq*m3sq*m4**6*T134fin(m4,m3,0,mudim) + 32*m2sq*m4**8*T134fin(m4,m3,0,mudim) - 2*m2**6*m3sq*m4sq*T134fin(m4,m3,0,mudim) + 10*m2sq*m3**4*m4**4*T134fin(m4,m4,m2,mudim) + 2*m3**6*m4**4*T134fin(m4,m4,m2,mudim) - 10*m3**4*m4**6*T134fin(m4,m4,m2,mudim) - 8*m2sq*m3sq*m4**6*T134fin(m4,m4,m2,mudim) + 8*m3sq*m4**8*T134fin(m4,m4,m2,mudim) - 2*m2sq*m3**6*m4sq*T134fin(m4,m4,m2,mudim) - 2*m2**6*m4**4*T134fin(m4,m4,m3,mudim) - 10*m2**4*m3sq*m4**4*T134fin(m4,m4,m3,mudim) + 10*m2**4*m4**6*T134fin(m4,m4,m3,mudim) + 8*m2sq*m3sq*m4**6*T134fin(m4,m4,m3,mudim) - 8*m2sq*m4**8*T134fin(m4,m4,m3,mudim) + 2*m2**6*m3sq*m4sq*T134fin(m4,m4,m3,mudim))/(2.*m2**2*m3**2*(m2sq - m3sq)*m4**4*(m2sq - 4*m4sq)*(m3sq - 4*m4sq)*(m2sq - m4sq)*(m3sq - m4sq))
		def eval_108():
			return (-2*m3sq*(-(m1sq*(m2sq - m3sq)**4*(m1sq + m3sq)) + m2sq*(m1sq - m3sq)**4*(m2sq + m3sq))*B0del(0,0,m3sq,mudim) + 2*m3sq*(-(m1sq*(m2sq - m3sq)**4*(-((m1sq + m3sq)*B0del(0,0,m1sq,mudim)) - 4*m3sq*B0fin(0,0,m1sq,mudim))) + m1sq*(m2sq - m3sq)**4*(-4*m3sq - (m1sq + m3sq)*B0fin(0,0,m1sq,mudim)) - m2sq*(m1sq - m3sq)**4*((m2sq + m3sq)*B0del(0,0,m2sq,mudim) + 4*m3sq*B0fin(0,0,m2sq,mudim)) + m2sq*(m1sq - m3sq)**4*(4*m3sq + (m2sq + m3sq)*B0fin(0,0,m2sq,mudim))) + m3sq*(-2*m1sq*(m2sq - m3sq)**4*(m1sq + m3sq) + 2*m2sq*(m1sq - m3sq)**4*(m2sq + m3sq) - 2*m1sq*(m2sq - m3sq)**4*(-4*m3sq - (m1sq + m3sq)*B0fin(0,0,m1sq,mudim)) - 2*m2sq*(m1sq - m3sq)**4*(4*m3sq + (m2sq + m3sq)*B0fin(0,0,m2sq,mudim)))*B0fin(0,0,m3sq,mudim) + (m1sq - m2sq)*(m1sq - m3sq)**3*(m2sq - m3sq)**3*(-3 + 2*B0fin(0,0,m3sq,mudim)) + 2*(m2sq - m3sq)**4*m3sq*(2*(m1sq + m3sq)**2 + (m1sq - m3sq)*(m1sq + m3sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim)) - 2*m1sq*T134fin(m3,m1,0,mudim)) - 2*(m1sq - m3sq)**4*m3sq*(2*(m2sq + m3sq)**2 + (m2sq - m3sq)*(m2sq + m3sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim)) - 2*m2sq*T134fin(m3,m2,0,mudim)))/(2.*(m1sq - m2sq)*m3**2*(m1sq - m3sq)**4*(m2sq - m3sq)**4)
		def eval_109():
			return (-2*m3sq*(-(m1sq*(m2sq - m3sq)**4*(m1sq + m3sq)) + m2sq*(m1sq - m3sq)**4*(m2sq + m3sq))*B0del(0,0,m3sq,mudim) + 2*m3sq*(-(m1sq*(m2sq - m3sq)**4*(-((m1sq + m3sq)*B0del(0,0,m1sq,mudim)) - 4*m3sq*B0fin(0,0,m1sq,mudim))) + m1sq*(m2sq - m3sq)**4*(-4*m3sq - (m1sq + m3sq)*B0fin(0,0,m1sq,mudim)) - m2sq*(m1sq - m3sq)**4*((m2sq + m3sq)*B0del(0,0,m2sq,mudim) + 4*m3sq*B0fin(0,0,m2sq,mudim)) + m2sq*(m1sq - m3sq)**4*(4*m3sq + (m2sq + m3sq)*B0fin(0,0,m2sq,mudim))) + m3sq*(-2*m1sq*(m2sq - m3sq)**4*(m1sq + m3sq) + 2*m2sq*(m1sq - m3sq)**4*(m2sq + m3sq) - 2*m1sq*(m2sq - m3sq)**4*(-4*m3sq - (m1sq + m3sq)*B0fin(0,0,m1sq,mudim)) - 2*m2sq*(m1sq - m3sq)**4*(4*m3sq + (m2sq + m3sq)*B0fin(0,0,m2sq,mudim)))*B0fin(0,0,m3sq,mudim) + (m1sq - m2sq)*(m1sq - m3sq)**3*(m2sq - m3sq)**3*(-3 + 2*B0fin(0,0,m3sq,mudim)) + 2*(m2sq - m3sq)**4*m3sq*(2*(m1sq + m3sq)**2 + (m1sq - m3sq)*(m1sq + m3sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim)) - 2*m1sq*T134fin(m3,m1,0,mudim)) - 2*(m1sq - m3sq)**4*m3sq*(2*(m2sq + m3sq)**2 + (m2sq - m3sq)*(m2sq + m3sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim)) - 2*m2sq*T134fin(m3,m2,0,mudim)))/(2.*(m1sq - m2sq)*m3**2*(m1sq - m3sq)**4*(m2sq - m3sq)**4)
		def eval_110():
			return (2*m1**8*m2**4 - 5*m1**6*m2**6 + 3*m1**4*m2**8 + 2*m1**8*m6**4 + 27*m1**4*m2**4*m6**4 - 15*m1sq*m2**6*m6**4 + m2**8*m6**4 - 15*m1**6*m2sq*m6**4 - 5*m1**6*m6**6 - 5*m1sq*m2**4*m6**6 + m2**6*m6**6 + 9*m1**4*m2sq*m6**6 + 6*m1**4*m6**8 + 7*m2**4*m6**8 - 13*m1sq*m2sq*m6**8 + m1sq*m6**10 - m2sq*m6**10 - 7*m1**6*m2**4*m6sq + 3*m1**4*m2**6*m6sq + 4*m1**8*m2sq*m6sq + m1sq*(m2sq - m6sq)**4*(m1sq + m6sq)*B0del(0,0,m1sq,mudim) + (m1sq - m6sq)**3*(m2sq + m6sq)*(-2*m2**4 + m1sq*(m2sq + m6sq))*B0del(0,0,m2sq,mudim) + m1**8*m2**4*B0del(0,0,m6sq,mudim) - 2*m1**6*m2**6*B0del(0,0,m6sq,mudim) + m1**4*m2**8*B0del(0,0,m6sq,mudim) + m1**8*m6**4*B0del(0,0,m6sq,mudim) + 15*m1**4*m2**4*m6**4*B0del(0,0,m6sq,mudim) - 10*m1sq*m2**6*m6**4*B0del(0,0,m6sq,mudim) - 6*m1**6*m2sq*m6**4*B0del(0,0,m6sq,mudim) - 3*m1**6*m6**6*B0del(0,0,m6sq,mudim) - m1sq*m2**4*m6**6*B0del(0,0,m6sq,mudim) + 2*m2**6*m6**6*B0del(0,0,m6sq,mudim) + 2*m1**4*m2sq*m6**6*B0del(0,0,m6sq,mudim) + 4*m1**4*m6**8*B0del(0,0,m6sq,mudim) + 2*m2**4*m6**8*B0del(0,0,m6sq,mudim) - 6*m1sq*m2sq*m6**8*B0del(0,0,m6sq,mudim) - 5*m1**6*m2**4*m6sq*B0del(0,0,m6sq,mudim) + 2*m1**4*m2**6*m6sq*B0del(0,0,m6sq,mudim) + m1sq*m2**8*m6sq*B0del(0,0,m6sq,mudim) + 2*m1**8*m2sq*m6sq*B0del(0,0,m6sq,mudim) + m1**4*m2**8*B0fin(0,0,m1sq,mudim) + 6*m1**4*m2**4*m6**4*B0fin(0,0,m1sq,mudim) - 4*m1sq*m2**6*m6**4*B0fin(0,0,m1sq,mudim) + 6*m1sq*m2**4*m6**6*B0fin(0,0,m1sq,mudim) - 4*m1**4*m2sq*m6**6*B0fin(0,0,m1sq,mudim) + m1**4*m6**8*B0fin(0,0,m1sq,mudim) - 4*m1sq*m2sq*m6**8*B0fin(0,0,m1sq,mudim) + m1sq*m6**10*B0fin(0,0,m1sq,mudim) - 4*m1**4*m2**6*m6sq*B0fin(0,0,m1sq,mudim) + m1sq*m2**8*m6sq*B0fin(0,0,m1sq,mudim) - 2*m1**8*m2**4*B0fin(0,0,m2sq,mudim) + m1**6*m2**6*B0fin(0,0,m2sq,mudim) + 12*m1**4*m2**4*m6**4*B0fin(0,0,m2sq,mudim) + 3*m1sq*m2**6*m6**4*B0fin(0,0,m2sq,mudim) - 17*m1**6*m2sq*m6**4*B0fin(0,0,m2sq,mudim) - 16*m1sq*m2**4*m6**6*B0fin(0,0,m2sq,mudim) - m2**6*m6**6*B0fin(0,0,m2sq,mudim) + 15*m1**4*m2sq*m6**6*B0fin(0,0,m2sq,mudim) + 6*m2**4*m6**8*B0fin(0,0,m2sq,mudim) - 3*m1sq*m2sq*m6**8*B0fin(0,0,m2sq,mudim) - m2sq*m6**10*B0fin(0,0,m2sq,mudim) - 3*m1**4*m2**6*m6sq*B0fin(0,0,m2sq,mudim) + 6*m1**8*m2sq*m6sq*B0fin(0,0,m2sq,mudim) + m1**6*m2**6*B0fin(0,0,m6sq,mudim) - m1**4*m2**8*B0fin(0,0,m6sq,mudim) - 2*m1**8*m6**4*B0fin(0,0,m6sq,mudim) + 30*m1**4*m2**4*m6**4*B0fin(0,0,m6sq,mudim) - 17*m1sq*m2**6*m6**4*B0fin(0,0,m6sq,mudim) - 2*m2**8*m6**4*B0fin(0,0,m6sq,mudim) - 9*m1**6*m2sq*m6**4*B0fin(0,0,m6sq,mudim) + 4*m1**6*m6**6*B0fin(0,0,m6sq,mudim) - 6*m1sq*m2**4*m6**6*B0fin(0,0,m6sq,mudim) + 7*m2**6*m6**6*B0fin(0,0,m6sq,mudim) - 5*m1**4*m2sq*m6**6*B0fin(0,0,m6sq,mudim) - m1**4*m6**8*B0fin(0,0,m6sq,mudim) + m1sq*m2sq*m6**8*B0fin(0,0,m6sq,mudim) + m1sq*m6**10*B0fin(0,0,m6sq,mudim) - m2sq*m6**10*B0fin(0,0,m6sq,mudim) - 12*m1**6*m2**4*m6sq*B0fin(0,0,m6sq,mudim) + m1**4*m2**6*m6sq*B0fin(0,0,m6sq,mudim) + 5*m1sq*m2**8*m6sq*B0fin(0,0,m6sq,mudim) + 6*m1**8*m2sq*m6sq*B0fin(0,0,m6sq,mudim) + m1**4*m2**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 6*m1**4*m2**4*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m1sq*m2**6*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 6*m1sq*m2**4*m6**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m1**4*m2sq*m6**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + m1**4*m6**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m1sq*m2sq*m6**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + m1sq*m6**10*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m1**4*m2**6*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + m1sq*m2**8*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + m1**8*m2**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m1**6*m2**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) + m1**8*m6**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) + 9*m1**4*m2**4*m6**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) - 6*m1sq*m2**6*m6**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) - 6*m1**6*m2sq*m6**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) - 3*m1**6*m6**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) - 7*m1sq*m2**4*m6**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m2**6*m6**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) + 6*m1**4*m2sq*m6**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) + 3*m1**4*m6**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m2**4*m6**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m1sq*m2sq*m6**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) - m1sq*m6**10*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) - 5*m1**6*m2**4*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) + 6*m1**4*m2**6*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m1**8*m2sq*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m1sq*m2**8*T134fin(m6,m1,0,mudim) - 12*m1sq*m2**4*m6**4*T134fin(m6,m1,0,mudim) + 8*m1sq*m2sq*m6**6*T134fin(m6,m1,0,mudim) - 2*m1sq*m6**8*T134fin(m6,m1,0,mudim) + 8*m1sq*m2**6*m6sq*T134fin(m6,m1,0,mudim) + 4*m1**6*m2**4*T134fin(m6,m2,0,mudim) - 2*m1**8*m2sq*T134fin(m6,m2,0,mudim) + 6*m1**6*m6**4*T134fin(m6,m2,0,mudim) + 12*m1sq*m2**4*m6**4*T134fin(m6,m2,0,mudim) - 6*m1**4*m2sq*m6**4*T134fin(m6,m2,0,mudim) - 6*m1**4*m6**6*T134fin(m6,m2,0,mudim) - 4*m2**4*m6**6*T134fin(m6,m2,0,mudim) + 2*m1sq*m2sq*m6**6*T134fin(m6,m2,0,mudim) + 2*m1sq*m6**8*T134fin(m6,m2,0,mudim) - 2*m1**8*m6sq*T134fin(m6,m2,0,mudim) - 12*m1**4*m2**4*m6sq*T134fin(m6,m2,0,mudim) + 6*m1**6*m2sq*m6sq*T134fin(m6,m2,0,mudim))/((m1sq - m2sq)**2*(m1sq - m6sq)**3*(m2sq - m6sq)**4)
		def eval_111():
			return (2*m1**8*m2**4 - 5*m1**6*m2**6 + 3*m1**4*m2**8 + 2*m1**8*m4**4 + 27*m1**4*m2**4*m4**4 - 15*m1sq*m2**6*m4**4 + m2**8*m4**4 - 15*m1**6*m2sq*m4**4 - 5*m1**6*m4**6 - 5*m1sq*m2**4*m4**6 + m2**6*m4**6 + 9*m1**4*m2sq*m4**6 + 6*m1**4*m4**8 + 7*m2**4*m4**8 - 13*m1sq*m2sq*m4**8 + m1sq*m4**10 - m2sq*m4**10 - 7*m1**6*m2**4*m4sq + 3*m1**4*m2**6*m4sq + 4*m1**8*m2sq*m4sq + m1sq*(m2sq - m4sq)**4*(m1sq + m4sq)*B0del(0,0,m1sq,mudim) + (m1sq - m4sq)**3*(m2sq + m4sq)*(-2*m2**4 + m1sq*(m2sq + m4sq))*B0del(0,0,m2sq,mudim) + m1**8*m2**4*B0del(0,0,m4sq,mudim) - 2*m1**6*m2**6*B0del(0,0,m4sq,mudim) + m1**4*m2**8*B0del(0,0,m4sq,mudim) + m1**8*m4**4*B0del(0,0,m4sq,mudim) + 15*m1**4*m2**4*m4**4*B0del(0,0,m4sq,mudim) - 10*m1sq*m2**6*m4**4*B0del(0,0,m4sq,mudim) - 6*m1**6*m2sq*m4**4*B0del(0,0,m4sq,mudim) - 3*m1**6*m4**6*B0del(0,0,m4sq,mudim) - m1sq*m2**4*m4**6*B0del(0,0,m4sq,mudim) + 2*m2**6*m4**6*B0del(0,0,m4sq,mudim) + 2*m1**4*m2sq*m4**6*B0del(0,0,m4sq,mudim) + 4*m1**4*m4**8*B0del(0,0,m4sq,mudim) + 2*m2**4*m4**8*B0del(0,0,m4sq,mudim) - 6*m1sq*m2sq*m4**8*B0del(0,0,m4sq,mudim) - 5*m1**6*m2**4*m4sq*B0del(0,0,m4sq,mudim) + 2*m1**4*m2**6*m4sq*B0del(0,0,m4sq,mudim) + m1sq*m2**8*m4sq*B0del(0,0,m4sq,mudim) + 2*m1**8*m2sq*m4sq*B0del(0,0,m4sq,mudim) + m1**4*m2**8*B0fin(0,0,m1sq,mudim) + 6*m1**4*m2**4*m4**4*B0fin(0,0,m1sq,mudim) - 4*m1sq*m2**6*m4**4*B0fin(0,0,m1sq,mudim) + 6*m1sq*m2**4*m4**6*B0fin(0,0,m1sq,mudim) - 4*m1**4*m2sq*m4**6*B0fin(0,0,m1sq,mudim) + m1**4*m4**8*B0fin(0,0,m1sq,mudim) - 4*m1sq*m2sq*m4**8*B0fin(0,0,m1sq,mudim) + m1sq*m4**10*B0fin(0,0,m1sq,mudim) - 4*m1**4*m2**6*m4sq*B0fin(0,0,m1sq,mudim) + m1sq*m2**8*m4sq*B0fin(0,0,m1sq,mudim) - 2*m1**8*m2**4*B0fin(0,0,m2sq,mudim) + m1**6*m2**6*B0fin(0,0,m2sq,mudim) + 12*m1**4*m2**4*m4**4*B0fin(0,0,m2sq,mudim) + 3*m1sq*m2**6*m4**4*B0fin(0,0,m2sq,mudim) - 17*m1**6*m2sq*m4**4*B0fin(0,0,m2sq,mudim) - 16*m1sq*m2**4*m4**6*B0fin(0,0,m2sq,mudim) - m2**6*m4**6*B0fin(0,0,m2sq,mudim) + 15*m1**4*m2sq*m4**6*B0fin(0,0,m2sq,mudim) + 6*m2**4*m4**8*B0fin(0,0,m2sq,mudim) - 3*m1sq*m2sq*m4**8*B0fin(0,0,m2sq,mudim) - m2sq*m4**10*B0fin(0,0,m2sq,mudim) - 3*m1**4*m2**6*m4sq*B0fin(0,0,m2sq,mudim) + 6*m1**8*m2sq*m4sq*B0fin(0,0,m2sq,mudim) + m1**6*m2**6*B0fin(0,0,m4sq,mudim) - m1**4*m2**8*B0fin(0,0,m4sq,mudim) - 2*m1**8*m4**4*B0fin(0,0,m4sq,mudim) + 30*m1**4*m2**4*m4**4*B0fin(0,0,m4sq,mudim) - 17*m1sq*m2**6*m4**4*B0fin(0,0,m4sq,mudim) - 2*m2**8*m4**4*B0fin(0,0,m4sq,mudim) - 9*m1**6*m2sq*m4**4*B0fin(0,0,m4sq,mudim) + 4*m1**6*m4**6*B0fin(0,0,m4sq,mudim) - 6*m1sq*m2**4*m4**6*B0fin(0,0,m4sq,mudim) + 7*m2**6*m4**6*B0fin(0,0,m4sq,mudim) - 5*m1**4*m2sq*m4**6*B0fin(0,0,m4sq,mudim) - m1**4*m4**8*B0fin(0,0,m4sq,mudim) + m1sq*m2sq*m4**8*B0fin(0,0,m4sq,mudim) + m1sq*m4**10*B0fin(0,0,m4sq,mudim) - m2sq*m4**10*B0fin(0,0,m4sq,mudim) - 12*m1**6*m2**4*m4sq*B0fin(0,0,m4sq,mudim) + m1**4*m2**6*m4sq*B0fin(0,0,m4sq,mudim) + 5*m1sq*m2**8*m4sq*B0fin(0,0,m4sq,mudim) + 6*m1**8*m2sq*m4sq*B0fin(0,0,m4sq,mudim) + m1**4*m2**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 6*m1**4*m2**4*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 4*m1sq*m2**6*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 6*m1sq*m2**4*m4**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 4*m1**4*m2sq*m4**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + m1**4*m4**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 4*m1sq*m2sq*m4**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + m1sq*m4**10*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 4*m1**4*m2**6*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + m1sq*m2**8*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + m1**8*m2**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 2*m1**6*m2**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + m1**8*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 9*m1**4*m2**4*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 6*m1sq*m2**6*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 6*m1**6*m2sq*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 3*m1**6*m4**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 7*m1sq*m2**4*m4**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 2*m2**6*m4**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 6*m1**4*m2sq*m4**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 3*m1**4*m4**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 2*m2**4*m4**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 2*m1sq*m2sq*m4**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - m1sq*m4**10*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 5*m1**6*m2**4*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 6*m1**4*m2**6*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 2*m1**8*m2sq*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 2*m1sq*m2**8*T134fin(m4,m1,0,mudim) - 12*m1sq*m2**4*m4**4*T134fin(m4,m1,0,mudim) + 8*m1sq*m2sq*m4**6*T134fin(m4,m1,0,mudim) - 2*m1sq*m4**8*T134fin(m4,m1,0,mudim) + 8*m1sq*m2**6*m4sq*T134fin(m4,m1,0,mudim) + 4*m1**6*m2**4*T134fin(m4,m2,0,mudim) - 2*m1**8*m2sq*T134fin(m4,m2,0,mudim) + 6*m1**6*m4**4*T134fin(m4,m2,0,mudim) + 12*m1sq*m2**4*m4**4*T134fin(m4,m2,0,mudim) - 6*m1**4*m2sq*m4**4*T134fin(m4,m2,0,mudim) - 6*m1**4*m4**6*T134fin(m4,m2,0,mudim) - 4*m2**4*m4**6*T134fin(m4,m2,0,mudim) + 2*m1sq*m2sq*m4**6*T134fin(m4,m2,0,mudim) + 2*m1sq*m4**8*T134fin(m4,m2,0,mudim) - 2*m1**8*m4sq*T134fin(m4,m2,0,mudim) - 12*m1**4*m2**4*m4sq*T134fin(m4,m2,0,mudim) + 6*m1**6*m2sq*m4sq*T134fin(m4,m2,0,mudim))/((m1sq - m2sq)**2*(m1sq - m4sq)**3*(m2sq - m4sq)**4)
		def eval_112():
			return ((m1sq - m2sq)**2*(m1sq - m3sq)**3*(m2sq - m3sq)**2*(6 + 2*B0del(0,0,m2sq,mudim) - 6*B0fin(0,0,m2sq,mudim) + B0fin(0,0,m2sq,mudim)**2) + 4*(m1sq - m2sq)**2*m2sq*(m1sq - m3sq)**2*m3sq*(-2*m1sq + m2sq + m3sq)*(B0fin(0,0,m2sq,mudim) + B0fin(0,0,m3sq,mudim)) - 4*m1sq*(m2sq - m3sq)**3*((m2sq - m3sq)*(m1**4 - m2sq*m3sq)*B0fin(0,0,m1sq,mudim) + m2sq*(m1sq - m3sq)**2*B0fin(0,0,m2sq,mudim) - (m1sq - m2sq)**2*m3sq*B0fin(0,0,m3sq,mudim)) - 4*(m1sq - m2sq)**2*m2sq*(m1sq - m3sq)**2*m3sq*(-2*m1sq + m2sq + m3sq)*(B0del(0,0,m2sq,mudim) + B0del(0,0,m3sq,mudim) + B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim)) + (m1sq - m2sq)**3*(m1sq - m3sq)**2*(m2sq - m3sq)**2*(6 + 2*B0del(0,0,m3sq,mudim) - 6*B0fin(0,0,m3sq,mudim) + B0fin(0,0,m3sq,mudim)**2) + 4*m1sq*(m2sq - m3sq)**3*((m2sq - m3sq)*(m1**4 - m2sq*m3sq)*B0del(0,0,m1sq,mudim) + m2sq*(m1sq - m3sq)**2*B0del(0,0,m2sq,mudim) - (m1sq - m2sq)**2*m3sq*B0del(0,0,m3sq,mudim) + B0fin(0,0,m1sq,mudim)*(m2sq*(m1sq - m3sq)**2*B0fin(0,0,m2sq,mudim) - (m1sq - m2sq)**2*m3sq*B0fin(0,0,m3sq,mudim))) + 2*(m1sq + m2sq)*(m1sq - m3sq)**2*(m2sq - m3sq)**3*(m1sq + m2sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim) - T134fin(m2,m1,0,mudim)) - 2*(m1sq - m2sq)**2*(m2sq - m3sq)**3*(m1sq + m3sq)*(m1sq + m3sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,m1,0,mudim)) + 2*(m1sq - m2sq)**2*(m1sq - m3sq)**2*(2*m1sq - m2sq - m3sq)*(m2sq + m3sq)*(m2sq + m3sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,m2,0,mudim)))/(2.*(m1sq - m2sq)**3*(m1sq - m3sq)**3*(m2sq - m3sq)**4)
		def eval_113():
			return ((m1sq - m2sq)**2*(m1sq - m3sq)**3*(m2sq - m3sq)**2*(6 + 2*B0del(0,0,m2sq,mudim) - 6*B0fin(0,0,m2sq,mudim) + B0fin(0,0,m2sq,mudim)**2) + 4*(m1sq - m2sq)**2*m2sq*(m1sq - m3sq)**2*m3sq*(-2*m1sq + m2sq + m3sq)*(B0fin(0,0,m2sq,mudim) + B0fin(0,0,m3sq,mudim)) - 4*m1sq*(m2sq - m3sq)**3*((m2sq - m3sq)*(m1**4 - m2sq*m3sq)*B0fin(0,0,m1sq,mudim) + m2sq*(m1sq - m3sq)**2*B0fin(0,0,m2sq,mudim) - (m1sq - m2sq)**2*m3sq*B0fin(0,0,m3sq,mudim)) - 4*(m1sq - m2sq)**2*m2sq*(m1sq - m3sq)**2*m3sq*(-2*m1sq + m2sq + m3sq)*(B0del(0,0,m2sq,mudim) + B0del(0,0,m3sq,mudim) + B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim)) + (m1sq - m2sq)**3*(m1sq - m3sq)**2*(m2sq - m3sq)**2*(6 + 2*B0del(0,0,m3sq,mudim) - 6*B0fin(0,0,m3sq,mudim) + B0fin(0,0,m3sq,mudim)**2) + 4*m1sq*(m2sq - m3sq)**3*((m2sq - m3sq)*(m1**4 - m2sq*m3sq)*B0del(0,0,m1sq,mudim) + m2sq*(m1sq - m3sq)**2*B0del(0,0,m2sq,mudim) - (m1sq - m2sq)**2*m3sq*B0del(0,0,m3sq,mudim) + B0fin(0,0,m1sq,mudim)*(m2sq*(m1sq - m3sq)**2*B0fin(0,0,m2sq,mudim) - (m1sq - m2sq)**2*m3sq*B0fin(0,0,m3sq,mudim))) + 2*(m1sq + m2sq)*(m1sq - m3sq)**2*(m2sq - m3sq)**3*(m1sq + m2sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim) - T134fin(m2,m1,0,mudim)) - 2*(m1sq - m2sq)**2*(m2sq - m3sq)**3*(m1sq + m3sq)*(m1sq + m3sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,m1,0,mudim)) + 2*(m1sq - m2sq)**2*(m1sq - m3sq)**2*(2*m1sq - m2sq - m3sq)*(m2sq + m3sq)*(m2sq + m3sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,m2,0,mudim)))/(2.*(m1sq - m2sq)**3*(m1sq - m3sq)**3*(m2sq - m3sq)**4)
		def eval_114():
			return ((4*m1sq*m2sq*(m2sq - m7sq)**3*(B0del(0,0,m1sq,mudim) + B0del(0,0,m2sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim)))/(m1sq - m2sq)**4 + ((m2sq - m7sq)**3*(3*(m1sq + m2sq) + 2*m2sq*B0del(0,0,m2sq,mudim) - 2*(m1sq + 2*m2sq)*B0fin(0,0,m2sq,mudim) + m2sq*B0fin(0,0,m2sq,mudim)**2))/(-(m1sq*m2) + m2**3)**2 + (4*m1sq*m7sq*(-m2sq + m7sq)**3*(B0del(0,0,m1sq,mudim) + B0del(0,0,m7sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)**2*(m1sq - m7sq)**2) + (2*m7sq*(-(m2sq*(-3*m2**4 + m2sq*m7sq + m1sq*(m2sq + m7sq))*B0del(0,0,m2sq,mudim)) - m2sq*(-3*m2**4 + m2sq*m7sq + m1sq*(m2sq + m7sq))*B0del(0,0,m7sq,mudim) + 4*m2sq*(m2**4 - m1sq*m2sq)*B0fin(0,0,m2sq,mudim) - (4*m1sq*m2**4 - 4*m2**6 + m2sq*(-3*m2**4 + m2sq*m7sq + m1sq*(m2sq + m7sq))*B0fin(0,0,m2sq,mudim))*B0fin(0,0,m7sq,mudim)))/(-(m1sq*m2) + m2**3)**2 + (2*(-2*m1sq*m2sq*(m2sq - m7sq)**3*(B0fin(0,0,m1sq,mudim) + B0fin(0,0,m2sq,mudim)) + (2*m1sq*(m1sq - m2sq)**2*(m2sq - m7sq)**3*m7sq*(B0fin(0,0,m1sq,mudim) + B0fin(0,0,m7sq,mudim)))/(m1sq - m7sq)**2 + (m1sq - m2sq)**2*m7sq*(4*(m1sq - m2sq)*m2sq + (-3*m2**4 + m2sq*m7sq + m1sq*(m2sq + m7sq))*B0fin(0,0,m2sq,mudim) + (-3*m2**4 + m2sq*m7sq + m1sq*(m2sq + m7sq))*B0fin(0,0,m7sq,mudim))))/(m1sq - m2sq)**4 + (2*(m1sq + m2sq)*(m2sq - m7sq)**3*(m1sq + m2sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim) - T134fin(m2,m1,0,mudim)))/(m1sq - m2sq)**4 - (2*(m2sq - m7sq)**3*(m1sq + m7sq)*(m1sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim) - T134fin(m7,m1,0,mudim)))/((m1sq - m2sq)**2*(m1sq - m7sq)**2) + (2*(-(m1sq*m2**4) + 2*m2**6 - 3*m1sq*m7**4 + 2*m2sq*m7**4 - m7**6 + 5*m2**4*m7sq - 4*m1sq*m2sq*m7sq + 2*m2sq*(m2sq - m7sq)*(m1sq + m7sq)*B0fin(0,0,m2sq,mudim) + 2*(m2sq - m7sq)*m7sq*(m1sq + m7sq)*B0fin(0,0,m7sq,mudim) - m2**4*T134fin(m7,m2,0,mudim) + m7**4*T134fin(m7,m2,0,mudim) + 2*m1sq*m7sq*T134fin(m7,m2,0,mudim) - 2*m2sq*m7sq*T134fin(m7,m2,0,mudim)))/(m1sq - m2sq)**2)/(2.*(m2sq - m7sq)**4)
		def eval_115():
			return (4*m1sq*m2**6 + 12*m2**8 + 2*m2**4*m7**4 + 2*m1sq*m2sq*m7**4 - 18*m1sq*m2**4*m7sq - 2*m2**6*m7sq + 2*(m1sq*m2sq*(2*m2**4 + m7**4 - 6*m2sq*m7sq) + m2**4*(6*m2**4 + m7**4 - 4*m2sq*m7sq))*B0del(0,0,m2sq,mudim) + 6*m2**4*(-m1sq + m2sq)*m7sq*B0del(0,0,m7sq,mudim) + 4*m1sq*m2**6*B0fin(0,0,m2sq,mudim) + 12*m2**8*B0fin(0,0,m2sq,mudim) + 2*m2**4*m7**4*B0fin(0,0,m2sq,mudim) + 2*m1sq*m2sq*m7**4*B0fin(0,0,m2sq,mudim) - 12*m1sq*m2**4*m7sq*B0fin(0,0,m2sq,mudim) - 8*m2**6*m7sq*B0fin(0,0,m2sq,mudim) + 2*m1sq*m2**6*B0fin(0,0,m2sq,mudim)**2 + 6*m2**8*B0fin(0,0,m2sq,mudim)**2 + m2**4*m7**4*B0fin(0,0,m2sq,mudim)**2 + m1sq*m2sq*m7**4*B0fin(0,0,m2sq,mudim)**2 - 3*m1sq*m2**4*m7sq*B0fin(0,0,m2sq,mudim)**2 - 7*m2**6*m7sq*B0fin(0,0,m2sq,mudim)**2 - 6*m1sq*m2**4*m7sq*B0fin(0,0,m7sq,mudim) + 6*m2**6*m7sq*B0fin(0,0,m7sq,mudim) - 6*m1sq*m2**4*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) + 6*m2**6*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) + 8*m2**6*T134fin(m1,0,0,mudim) + 2*m2sq*m7**4*T134fin(m1,0,0,mudim) - 10*m2**4*m7sq*T134fin(m1,0,0,mudim) - 8*m1sq*m2**4*T134fin(m2,0,0,mudim) - 2*m1sq*m7**4*T134fin(m2,0,0,mudim) + 10*m1sq*m2sq*m7sq*T134fin(m2,0,0,mudim) - 8*m2**6*T134fin(m2,m1,0,mudim) - 2*m2sq*m7**4*T134fin(m2,m1,0,mudim) + 10*m2**4*m7sq*T134fin(m2,m1,0,mudim) - 8*m2**6*T134fin(m7,m1,0,mudim) - 2*m2sq*m7**4*T134fin(m7,m1,0,mudim) + 10*m2**4*m7sq*T134fin(m7,m1,0,mudim) + 8*m1sq*m2**4*T134fin(m7,m2,0,mudim) + 2*m2sq*m7**4*T134fin(m7,m2,0,mudim) - 8*m2**4*m7sq*T134fin(m7,m2,0,mudim) - 2*m1sq*m2sq*m7sq*T134fin(m7,m2,0,mudim) + 8*m2**6*T134fin(m7,m2,m1,mudim) + 2*m2sq*m7**4*T134fin(m7,m2,m1,mudim) - 10*m2**4*m7sq*T134fin(m7,m2,m1,mudim) - 2*m1sq*m2**4*T134fin(m7,m2,m2,mudim) - 6*m2**6*T134fin(m7,m2,m2,mudim) - 2*m2sq*m7**4*T134fin(m7,m2,m2,mudim) + 8*m2**4*m7sq*T134fin(m7,m2,m2,mudim) + 2*m1sq*m2sq*m7sq*T134fin(m7,m2,m2,mudim))/(2.*m2**4*(m1sq - m2sq)**2*m7**2*(4*m2**4 + m7**4 - 5*m2sq*m7sq))
		def eval_116():
			return (4*m1sq*m2**6 + 12*m2**8 + 2*m2**4*m5**4 + 2*m1sq*m2sq*m5**4 - 18*m1sq*m2**4*m5sq - 2*m2**6*m5sq + 2*(m1sq*m2sq*(2*m2**4 + m5**4 - 6*m2sq*m5sq) + m2**4*(6*m2**4 + m5**4 - 4*m2sq*m5sq))*B0del(0,0,m2sq,mudim) + 6*m2**4*(-m1sq + m2sq)*m5sq*B0del(0,0,m5sq,mudim) + 4*m1sq*m2**6*B0fin(0,0,m2sq,mudim) + 12*m2**8*B0fin(0,0,m2sq,mudim) + 2*m2**4*m5**4*B0fin(0,0,m2sq,mudim) + 2*m1sq*m2sq*m5**4*B0fin(0,0,m2sq,mudim) - 12*m1sq*m2**4*m5sq*B0fin(0,0,m2sq,mudim) - 8*m2**6*m5sq*B0fin(0,0,m2sq,mudim) + 2*m1sq*m2**6*B0fin(0,0,m2sq,mudim)**2 + 6*m2**8*B0fin(0,0,m2sq,mudim)**2 + m2**4*m5**4*B0fin(0,0,m2sq,mudim)**2 + m1sq*m2sq*m5**4*B0fin(0,0,m2sq,mudim)**2 - 3*m1sq*m2**4*m5sq*B0fin(0,0,m2sq,mudim)**2 - 7*m2**6*m5sq*B0fin(0,0,m2sq,mudim)**2 - 6*m1sq*m2**4*m5sq*B0fin(0,0,m5sq,mudim) + 6*m2**6*m5sq*B0fin(0,0,m5sq,mudim) - 6*m1sq*m2**4*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 6*m2**6*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 8*m2**6*T134fin(m1,0,0,mudim) + 2*m2sq*m5**4*T134fin(m1,0,0,mudim) - 10*m2**4*m5sq*T134fin(m1,0,0,mudim) - 8*m1sq*m2**4*T134fin(m2,0,0,mudim) - 2*m1sq*m5**4*T134fin(m2,0,0,mudim) + 10*m1sq*m2sq*m5sq*T134fin(m2,0,0,mudim) - 8*m2**6*T134fin(m2,m1,0,mudim) - 2*m2sq*m5**4*T134fin(m2,m1,0,mudim) + 10*m2**4*m5sq*T134fin(m2,m1,0,mudim) - 8*m2**6*T134fin(m5,m1,0,mudim) - 2*m2sq*m5**4*T134fin(m5,m1,0,mudim) + 10*m2**4*m5sq*T134fin(m5,m1,0,mudim) + 8*m1sq*m2**4*T134fin(m5,m2,0,mudim) + 2*m2sq*m5**4*T134fin(m5,m2,0,mudim) - 8*m2**4*m5sq*T134fin(m5,m2,0,mudim) - 2*m1sq*m2sq*m5sq*T134fin(m5,m2,0,mudim) + 8*m2**6*T134fin(m5,m2,m1,mudim) + 2*m2sq*m5**4*T134fin(m5,m2,m1,mudim) - 10*m2**4*m5sq*T134fin(m5,m2,m1,mudim) - 2*m1sq*m2**4*T134fin(m5,m2,m2,mudim) - 6*m2**6*T134fin(m5,m2,m2,mudim) - 2*m2sq*m5**4*T134fin(m5,m2,m2,mudim) + 8*m2**4*m5sq*T134fin(m5,m2,m2,mudim) + 2*m1sq*m2sq*m5sq*T134fin(m5,m2,m2,mudim))/(2.*m2**4*(m1sq - m2sq)**2*m5**2*(4*m2**4 + m5**4 - 5*m2sq*m5sq))
		def eval_117():
			return ((4*m1sq*m2sq*(m2sq - m5sq)**3*(B0del(0,0,m1sq,mudim) + B0del(0,0,m2sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim)))/(m1sq - m2sq)**4 + ((m2sq - m5sq)**3*(3*(m1sq + m2sq) + 2*m2sq*B0del(0,0,m2sq,mudim) - 2*(m1sq + 2*m2sq)*B0fin(0,0,m2sq,mudim) + m2sq*B0fin(0,0,m2sq,mudim)**2))/(-(m1sq*m2) + m2**3)**2 + (4*m1sq*m5sq*(-m2sq + m5sq)**3*(B0del(0,0,m1sq,mudim) + B0del(0,0,m5sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim)))/((m1sq - m2sq)**2*(m1sq - m5sq)**2) + (2*m5sq*(-(m2sq*(-3*m2**4 + m2sq*m5sq + m1sq*(m2sq + m5sq))*B0del(0,0,m2sq,mudim)) - m2sq*(-3*m2**4 + m2sq*m5sq + m1sq*(m2sq + m5sq))*B0del(0,0,m5sq,mudim) + 4*m2sq*(m2**4 - m1sq*m2sq)*B0fin(0,0,m2sq,mudim) - (4*m1sq*m2**4 - 4*m2**6 + m2sq*(-3*m2**4 + m2sq*m5sq + m1sq*(m2sq + m5sq))*B0fin(0,0,m2sq,mudim))*B0fin(0,0,m5sq,mudim)))/(-(m1sq*m2) + m2**3)**2 + (2*(-2*m1sq*m2sq*(m2sq - m5sq)**3*(B0fin(0,0,m1sq,mudim) + B0fin(0,0,m2sq,mudim)) + (2*m1sq*(m1sq - m2sq)**2*(m2sq - m5sq)**3*m5sq*(B0fin(0,0,m1sq,mudim) + B0fin(0,0,m5sq,mudim)))/(m1sq - m5sq)**2 + (m1sq - m2sq)**2*m5sq*(4*(m1sq - m2sq)*m2sq + (-3*m2**4 + m2sq*m5sq + m1sq*(m2sq + m5sq))*B0fin(0,0,m2sq,mudim) + (-3*m2**4 + m2sq*m5sq + m1sq*(m2sq + m5sq))*B0fin(0,0,m5sq,mudim))))/(m1sq - m2sq)**4 + (2*(m1sq + m2sq)*(m2sq - m5sq)**3*(m1sq + m2sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim) - T134fin(m2,m1,0,mudim)))/(m1sq - m2sq)**4 - (2*(m2sq - m5sq)**3*(m1sq + m5sq)*(m1sq + m5sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) - T134fin(m5,m1,0,mudim)))/((m1sq - m2sq)**2*(m1sq - m5sq)**2) + (2*(-(m1sq*m2**4) + 2*m2**6 - 3*m1sq*m5**4 + 2*m2sq*m5**4 - m5**6 + 5*m2**4*m5sq - 4*m1sq*m2sq*m5sq + 2*m2sq*(m2sq - m5sq)*(m1sq + m5sq)*B0fin(0,0,m2sq,mudim) + 2*(m2sq - m5sq)*m5sq*(m1sq + m5sq)*B0fin(0,0,m5sq,mudim) - m2**4*T134fin(m5,m2,0,mudim) + m5**4*T134fin(m5,m2,0,mudim) + 2*m1sq*m5sq*T134fin(m5,m2,0,mudim) - 2*m2sq*m5sq*T134fin(m5,m2,0,mudim)))/(m1sq - m2sq)**2)/(2.*(m2sq - m5sq)**4)
		def eval_118():
			return (-3 + 2*B0fin(0,0,m2sq,mudim))/(2.*m2**2*(-m1sq + m2sq)*(m2sq - m3sq)) + ((m1sq*((m1sq + m2sq)*B0del(0,0,m1sq,mudim) + 4*m2sq*B0fin(0,0,m1sq,mudim)))/(m1sq - m2sq)**4 + ((m1sq*(m1sq + m2sq))/(m1sq - m2sq)**4 - (m3sq*(m2sq + m3sq))/(m2sq - m3sq)**4)*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)) - (m3sq*((m2sq + m3sq)*B0del(0,0,m3sq,mudim) + 4*m2sq*B0fin(0,0,m3sq,mudim)))/(m2sq - m3sq)**4 + (-1 + B0fin(0,0,m2sq,mudim))*((m1sq*(4*m2sq + (m1sq + m2sq)*B0fin(0,0,m1sq,mudim)))/(m1sq - m2sq)**4 - (m3sq*(4*m2sq + (m2sq + m3sq)*B0fin(0,0,m3sq,mudim)))/(m2sq - m3sq)**4))/(m1sq - m3sq) + (3*m1**4 + m2**4 + 4*m1sq*m2sq + 2*(m1**4 - m1sq*m2sq)*B0fin(0,0,m1sq,mudim) + 2*(m1sq - m2sq)*m2sq*B0fin(0,0,m2sq,mudim) - 2*m1sq*T134fin(m2,m1,0,mudim))/((m1sq - m2sq)**4*(m1sq - m3sq)) + (2*(m2sq + m3sq)**2 + (-m2sq + m3sq)*(m2sq + m3sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim)) - 2*m3sq*T134fin(m3,m2,0,mudim))/((m2sq - m3sq)**4*(-m1sq + m3sq))
		def eval_119():
			return (-3 + 2*B0fin(0,0,m2sq,mudim))/(2.*m2**2*(-m1sq + m2sq)*(m2sq - m3sq)) + ((m1sq*((m1sq + m2sq)*B0del(0,0,m1sq,mudim) + 4*m2sq*B0fin(0,0,m1sq,mudim)))/(m1sq - m2sq)**4 + ((m1sq*(m1sq + m2sq))/(m1sq - m2sq)**4 - (m3sq*(m2sq + m3sq))/(m2sq - m3sq)**4)*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)) - (m3sq*((m2sq + m3sq)*B0del(0,0,m3sq,mudim) + 4*m2sq*B0fin(0,0,m3sq,mudim)))/(m2sq - m3sq)**4 + (-1 + B0fin(0,0,m2sq,mudim))*((m1sq*(4*m2sq + (m1sq + m2sq)*B0fin(0,0,m1sq,mudim)))/(m1sq - m2sq)**4 - (m3sq*(4*m2sq + (m2sq + m3sq)*B0fin(0,0,m3sq,mudim)))/(m2sq - m3sq)**4))/(m1sq - m3sq) + (3*m1**4 + m2**4 + 4*m1sq*m2sq + 2*(m1**4 - m1sq*m2sq)*B0fin(0,0,m1sq,mudim) + 2*(m1sq - m2sq)*m2sq*B0fin(0,0,m2sq,mudim) - 2*m1sq*T134fin(m2,m1,0,mudim))/((m1sq - m2sq)**4*(m1sq - m3sq)) + (2*(m2sq + m3sq)**2 + (-m2sq + m3sq)*(m2sq + m3sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim)) - 2*m3sq*T134fin(m3,m2,0,mudim))/((m2sq - m3sq)**4*(-m1sq + m3sq))
		def eval_120():
			return (-(((m3sq - m5sq)**2*(6*m3sq - 4*m5sq + 2*(m3sq - 2*m5sq)*B0del(0,0,m5sq,mudim) - 2*(3*m3sq + 2*m5sq)*B0fin(0,0,m5sq,mudim) + (m3sq - 2*m5sq)*B0fin(0,0,m5sq,mudim)**2))/(-m4sq + m5sq)) + (2*(m3**3 - m3*m5sq)**2*(-2*(m3sq*(-(m4sq/(m3sq - m4sq)**2) + m5sq/(m3sq - m5sq)**2)*B0fin(0,0,m3sq,mudim) + (m4sq*m5sq*(B0fin(0,0,m4sq,mudim) + B0fin(0,0,m5sq,mudim)))/(m4sq - m5sq)**2 + m3sq*(-((m4sq*B0fin(0,0,m4sq,mudim))/(m3sq - m4sq)**2) + (m5sq*B0fin(0,0,m5sq,mudim))/(m3sq - m5sq)**2)) + 2*(m3sq*(-(m4sq/(m3sq - m4sq)**2) + m5sq/(m3sq - m5sq)**2)*B0del(0,0,m3sq,mudim) + m3sq*(-((m4sq*B0del(0,0,m4sq,mudim))/(m3sq - m4sq)**2) + (m5sq*B0del(0,0,m5sq,mudim))/(m3sq - m5sq)**2) + m3sq*B0fin(0,0,m3sq,mudim)*(-((m4sq*B0fin(0,0,m4sq,mudim))/(m3sq - m4sq)**2) + (m5sq*B0fin(0,0,m5sq,mudim))/(m3sq - m5sq)**2) + (m4sq*m5sq*(B0del(0,0,m4sq,mudim) + B0del(0,0,m5sq,mudim) + B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim)))/(m4sq - m5sq)**2)))/(m4sq - m5sq) + (2*(m3sq - m5sq)**2*(-(m3sq*(m3sq + m4sq)*(m3sq + m4sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim))) + (-m4**4 + 3*m3sq*m4sq)*T134fin(m4,m3,0,mudim)))/((m3sq - m4sq)**2*(m4sq - m5sq)) + (2*(m3sq - m5sq)**2*T134fin(m4,m3,m3,mudim))/(m4sq - m5sq) + (2*(-(m3sq*(m3sq + m5sq)*(m3sq + m5sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim))) + (-m5**4 + 3*m3sq*m5sq)*T134fin(m5,m3,0,mudim)))/(-m4sq + m5sq) + (2*(m3sq - m5sq)**2*T134fin(m5,m3,m3,mudim))/(-m4sq + m5sq) + (2*(m3sq - m5sq)**2*(-(m3sq*(m4sq + m5sq)*(m4sq + m5sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim))) + (-(m4sq - m5sq)**2 + m3sq*(m4sq + m5sq))*T134fin(m5,m4,0,mudim)))/(-m4sq + m5sq)**3 + (2*(m3sq - m5sq)**2*T134fin(m5,m4,m3,mudim))/(-m4sq + m5sq) + (2*(m3sq - m5sq)**2*T134fin(m5,m5,m3,mudim))/(m4sq - m5sq))/(2.*m3**4*(m3sq - m5sq)**3)
		def eval_121():
			return ((m3sq - m4sq)**2*(m4sq - m5sq)**2*(-6*m3sq + 4*m4sq - 2*(m3sq - 2*m4sq)*B0del(0,0,m4sq,mudim) + (6*m3sq + 4*m4sq)*B0fin(0,0,m4sq,mudim) - (m3sq - 2*m4sq)*B0fin(0,0,m4sq,mudim)**2) + 4*m3sq*(m3sq - m4sq)**2*(m4sq - m5sq)**2*(m3sq*(-(m4sq/(m3sq - m4sq)**2) + m5sq/(m3sq - m5sq)**2)*B0del(0,0,m3sq,mudim) + m3sq*(-((m4sq*B0del(0,0,m4sq,mudim))/(m3sq - m4sq)**2) + (m5sq*B0del(0,0,m5sq,mudim))/(m3sq - m5sq)**2) - m3sq*(-(m4sq/(m3sq - m4sq)**2) + m5sq/(m3sq - m5sq)**2)*B0fin(0,0,m3sq,mudim) + (m4sq*m5sq*(B0fin(0,0,m4sq,mudim) + B0fin(0,0,m5sq,mudim)))/(m4sq - m5sq)**2 - m3sq*(-((m4sq*B0fin(0,0,m4sq,mudim))/(m3sq - m4sq)**2) + (m5sq*B0fin(0,0,m5sq,mudim))/(m3sq - m5sq)**2) + m3sq*B0fin(0,0,m3sq,mudim)*(-((m4sq*B0fin(0,0,m4sq,mudim))/(m3sq - m4sq)**2) + (m5sq*B0fin(0,0,m5sq,mudim))/(m3sq - m5sq)**2) - (m4sq*m5sq*(B0del(0,0,m4sq,mudim) + B0del(0,0,m5sq,mudim) + B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim)))/(m4sq - m5sq)**2) + 2*(m4sq - m5sq)**2*(-(m3sq*(m3sq + m4sq)*(m3sq + m4sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim))) + (-m4**4 + 3*m3sq*m4sq)*T134fin(m4,m3,0,mudim)) + 2*(m3sq - m4sq)**2*(m4sq - m5sq)**2*T134fin(m4,m3,m3,mudim) - 2*(m3sq - m4sq)**2*(m4sq - m5sq)**2*T134fin(m4,m4,m3,mudim) + (2*(m3sq - m4sq)**2*(m4sq - m5sq)**2*(m3sq*(m3sq + m5sq)*(m3sq + m5sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim)) + (m5**4 - 3*m3sq*m5sq)*T134fin(m5,m3,0,mudim)))/(m3sq - m5sq)**2 - 2*(m3sq - m4sq)**2*(m4sq - m5sq)**2*T134fin(m5,m3,m3,mudim) + 2*(m3sq - m4sq)**2*(-(m3sq*(m4sq + m5sq)*(m4sq + m5sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim))) + (-(m4sq - m5sq)**2 + m3sq*(m4sq + m5sq))*T134fin(m5,m4,0,mudim)) + 2*(m3sq - m4sq)**2*(m4sq - m5sq)**2*T134fin(m5,m4,m3,mudim))/(2.*m3**4*(m3sq - m4sq)**3*(m4sq - m5sq)**3)
		def eval_122():
			return (3*m1**8*m3**4 - 5*m1**6*m3**6 + 2*m1**4*m3**8 + m1**8*m6**4 + 27*m1**4*m3**4*m6**4 - 15*m1sq*m3**6*m6**4 + 2*m3**8*m6**4 - 15*m1**6*m3sq*m6**4 + m1**6*m6**6 + 9*m1sq*m3**4*m6**6 - 5*m3**6*m6**6 - 5*m1**4*m3sq*m6**6 + 7*m1**4*m6**8 + 6*m3**4*m6**8 - 13*m1sq*m3sq*m6**8 - m1sq*m6**10 + m3sq*m6**10 + 3*m1**6*m3**4*m6sq - 7*m1**4*m3**6*m6sq + 4*m1sq*m3**8*m6sq + (m3sq - m6sq)**3*(m1sq + m6sq)*(-2*m1**4 + m1sq*m3sq + m3sq*m6sq)*B0del(0,0,m1sq,mudim) + m3sq*(m1sq - m6sq)**4*(m3sq + m6sq)*B0del(0,0,m3sq,mudim) + m1**8*m3**4*B0del(0,0,m6sq,mudim) - 2*m1**6*m3**6*B0del(0,0,m6sq,mudim) + m1**4*m3**8*B0del(0,0,m6sq,mudim) + 15*m1**4*m3**4*m6**4*B0del(0,0,m6sq,mudim) - 6*m1sq*m3**6*m6**4*B0del(0,0,m6sq,mudim) + m3**8*m6**4*B0del(0,0,m6sq,mudim) - 10*m1**6*m3sq*m6**4*B0del(0,0,m6sq,mudim) + 2*m1**6*m6**6*B0del(0,0,m6sq,mudim) + 2*m1sq*m3**4*m6**6*B0del(0,0,m6sq,mudim) - 3*m3**6*m6**6*B0del(0,0,m6sq,mudim) - m1**4*m3sq*m6**6*B0del(0,0,m6sq,mudim) + 2*m1**4*m6**8*B0del(0,0,m6sq,mudim) + 4*m3**4*m6**8*B0del(0,0,m6sq,mudim) - 6*m1sq*m3sq*m6**8*B0del(0,0,m6sq,mudim) + 2*m1**6*m3**4*m6sq*B0del(0,0,m6sq,mudim) - 5*m1**4*m3**6*m6sq*B0del(0,0,m6sq,mudim) + 2*m1sq*m3**8*m6sq*B0del(0,0,m6sq,mudim) + m1**8*m3sq*m6sq*B0del(0,0,m6sq,mudim) + m1**6*m3**6*B0fin(0,0,m1sq,mudim) - 2*m1**4*m3**8*B0fin(0,0,m1sq,mudim) + 12*m1**4*m3**4*m6**4*B0fin(0,0,m1sq,mudim) - 17*m1sq*m3**6*m6**4*B0fin(0,0,m1sq,mudim) + 3*m1**6*m3sq*m6**4*B0fin(0,0,m1sq,mudim) - m1**6*m6**6*B0fin(0,0,m1sq,mudim) + 15*m1sq*m3**4*m6**6*B0fin(0,0,m1sq,mudim) - 16*m1**4*m3sq*m6**6*B0fin(0,0,m1sq,mudim) + 6*m1**4*m6**8*B0fin(0,0,m1sq,mudim) - 3*m1sq*m3sq*m6**8*B0fin(0,0,m1sq,mudim) - m1sq*m6**10*B0fin(0,0,m1sq,mudim) - 3*m1**6*m3**4*m6sq*B0fin(0,0,m1sq,mudim) + 6*m1sq*m3**8*m6sq*B0fin(0,0,m1sq,mudim) + m1**8*m3**4*B0fin(0,0,m3sq,mudim) + 6*m1**4*m3**4*m6**4*B0fin(0,0,m3sq,mudim) - 4*m1**6*m3sq*m6**4*B0fin(0,0,m3sq,mudim) - 4*m1sq*m3**4*m6**6*B0fin(0,0,m3sq,mudim) + 6*m1**4*m3sq*m6**6*B0fin(0,0,m3sq,mudim) + m3**4*m6**8*B0fin(0,0,m3sq,mudim) - 4*m1sq*m3sq*m6**8*B0fin(0,0,m3sq,mudim) + m3sq*m6**10*B0fin(0,0,m3sq,mudim) - 4*m1**6*m3**4*m6sq*B0fin(0,0,m3sq,mudim) + m1**8*m3sq*m6sq*B0fin(0,0,m3sq,mudim) - m1**8*m3**4*B0fin(0,0,m6sq,mudim) + m1**6*m3**6*B0fin(0,0,m6sq,mudim) - 2*m1**8*m6**4*B0fin(0,0,m6sq,mudim) + 30*m1**4*m3**4*m6**4*B0fin(0,0,m6sq,mudim) - 9*m1sq*m3**6*m6**4*B0fin(0,0,m6sq,mudim) - 2*m3**8*m6**4*B0fin(0,0,m6sq,mudim) - 17*m1**6*m3sq*m6**4*B0fin(0,0,m6sq,mudim) + 7*m1**6*m6**6*B0fin(0,0,m6sq,mudim) - 5*m1sq*m3**4*m6**6*B0fin(0,0,m6sq,mudim) + 4*m3**6*m6**6*B0fin(0,0,m6sq,mudim) - 6*m1**4*m3sq*m6**6*B0fin(0,0,m6sq,mudim) - m3**4*m6**8*B0fin(0,0,m6sq,mudim) + m1sq*m3sq*m6**8*B0fin(0,0,m6sq,mudim) - m1sq*m6**10*B0fin(0,0,m6sq,mudim) + m3sq*m6**10*B0fin(0,0,m6sq,mudim) + m1**6*m3**4*m6sq*B0fin(0,0,m6sq,mudim) - 12*m1**4*m3**6*m6sq*B0fin(0,0,m6sq,mudim) + 6*m1sq*m3**8*m6sq*B0fin(0,0,m6sq,mudim) + 5*m1**8*m3sq*m6sq*B0fin(0,0,m6sq,mudim) - 2*m1**6*m3**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + m1**4*m3**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 9*m1**4*m3**4*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 6*m1sq*m3**6*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + m3**8*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 6*m1**6*m3sq*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m1**6*m6**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 6*m1sq*m3**4*m6**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 3*m3**6*m6**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 7*m1**4*m3sq*m6**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m1**4*m6**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 3*m3**4*m6**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m1sq*m3sq*m6**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - m3sq*m6**10*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 6*m1**6*m3**4*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 5*m1**4*m3**6*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m1sq*m3**8*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + m1**8*m3**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) + 6*m1**4*m3**4*m6**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m1**6*m3sq*m6**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m1sq*m3**4*m6**6*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) + 6*m1**4*m3sq*m6**6*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) + m3**4*m6**8*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m1sq*m3sq*m6**8*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) + m3sq*m6**10*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m1**6*m3**4*m6sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) + m1**8*m3sq*m6sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) + 4*m1**4*m3**6*T134fin(m6,m1,0,mudim) - 2*m1sq*m3**8*T134fin(m6,m1,0,mudim) - 6*m1sq*m3**4*m6**4*T134fin(m6,m1,0,mudim) + 6*m3**6*m6**4*T134fin(m6,m1,0,mudim) + 12*m1**4*m3sq*m6**4*T134fin(m6,m1,0,mudim) - 4*m1**4*m6**6*T134fin(m6,m1,0,mudim) - 6*m3**4*m6**6*T134fin(m6,m1,0,mudim) + 2*m1sq*m3sq*m6**6*T134fin(m6,m1,0,mudim) + 2*m3sq*m6**8*T134fin(m6,m1,0,mudim) - 12*m1**4*m3**4*m6sq*T134fin(m6,m1,0,mudim) + 6*m1sq*m3**6*m6sq*T134fin(m6,m1,0,mudim) - 2*m3**8*m6sq*T134fin(m6,m1,0,mudim) - 2*m1**8*m3sq*T134fin(m6,m3,0,mudim) - 12*m1**4*m3sq*m6**4*T134fin(m6,m3,0,mudim) + 8*m1sq*m3sq*m6**6*T134fin(m6,m3,0,mudim) - 2*m3sq*m6**8*T134fin(m6,m3,0,mudim) + 8*m1**6*m3sq*m6sq*T134fin(m6,m3,0,mudim))/((m1sq - m3sq)**2*(m1sq - m6sq)**4*(m3sq - m6sq)**3)
		def eval_123():
			return (3*m1**8*m3**4 - 5*m1**6*m3**6 + 2*m1**4*m3**8 + m1**8*m4**4 + 27*m1**4*m3**4*m4**4 - 15*m1sq*m3**6*m4**4 + 2*m3**8*m4**4 - 15*m1**6*m3sq*m4**4 + m1**6*m4**6 + 9*m1sq*m3**4*m4**6 - 5*m3**6*m4**6 - 5*m1**4*m3sq*m4**6 + 7*m1**4*m4**8 + 6*m3**4*m4**8 - 13*m1sq*m3sq*m4**8 - m1sq*m4**10 + m3sq*m4**10 + 3*m1**6*m3**4*m4sq - 7*m1**4*m3**6*m4sq + 4*m1sq*m3**8*m4sq + (m3sq - m4sq)**3*(m1sq + m4sq)*(-2*m1**4 + m1sq*m3sq + m3sq*m4sq)*B0del(0,0,m1sq,mudim) + m3sq*(m1sq - m4sq)**4*(m3sq + m4sq)*B0del(0,0,m3sq,mudim) + m1**8*m3**4*B0del(0,0,m4sq,mudim) - 2*m1**6*m3**6*B0del(0,0,m4sq,mudim) + m1**4*m3**8*B0del(0,0,m4sq,mudim) + 15*m1**4*m3**4*m4**4*B0del(0,0,m4sq,mudim) - 6*m1sq*m3**6*m4**4*B0del(0,0,m4sq,mudim) + m3**8*m4**4*B0del(0,0,m4sq,mudim) - 10*m1**6*m3sq*m4**4*B0del(0,0,m4sq,mudim) + 2*m1**6*m4**6*B0del(0,0,m4sq,mudim) + 2*m1sq*m3**4*m4**6*B0del(0,0,m4sq,mudim) - 3*m3**6*m4**6*B0del(0,0,m4sq,mudim) - m1**4*m3sq*m4**6*B0del(0,0,m4sq,mudim) + 2*m1**4*m4**8*B0del(0,0,m4sq,mudim) + 4*m3**4*m4**8*B0del(0,0,m4sq,mudim) - 6*m1sq*m3sq*m4**8*B0del(0,0,m4sq,mudim) + 2*m1**6*m3**4*m4sq*B0del(0,0,m4sq,mudim) - 5*m1**4*m3**6*m4sq*B0del(0,0,m4sq,mudim) + 2*m1sq*m3**8*m4sq*B0del(0,0,m4sq,mudim) + m1**8*m3sq*m4sq*B0del(0,0,m4sq,mudim) + m1**6*m3**6*B0fin(0,0,m1sq,mudim) - 2*m1**4*m3**8*B0fin(0,0,m1sq,mudim) + 12*m1**4*m3**4*m4**4*B0fin(0,0,m1sq,mudim) - 17*m1sq*m3**6*m4**4*B0fin(0,0,m1sq,mudim) + 3*m1**6*m3sq*m4**4*B0fin(0,0,m1sq,mudim) - m1**6*m4**6*B0fin(0,0,m1sq,mudim) + 15*m1sq*m3**4*m4**6*B0fin(0,0,m1sq,mudim) - 16*m1**4*m3sq*m4**6*B0fin(0,0,m1sq,mudim) + 6*m1**4*m4**8*B0fin(0,0,m1sq,mudim) - 3*m1sq*m3sq*m4**8*B0fin(0,0,m1sq,mudim) - m1sq*m4**10*B0fin(0,0,m1sq,mudim) - 3*m1**6*m3**4*m4sq*B0fin(0,0,m1sq,mudim) + 6*m1sq*m3**8*m4sq*B0fin(0,0,m1sq,mudim) + m1**8*m3**4*B0fin(0,0,m3sq,mudim) + 6*m1**4*m3**4*m4**4*B0fin(0,0,m3sq,mudim) - 4*m1**6*m3sq*m4**4*B0fin(0,0,m3sq,mudim) - 4*m1sq*m3**4*m4**6*B0fin(0,0,m3sq,mudim) + 6*m1**4*m3sq*m4**6*B0fin(0,0,m3sq,mudim) + m3**4*m4**8*B0fin(0,0,m3sq,mudim) - 4*m1sq*m3sq*m4**8*B0fin(0,0,m3sq,mudim) + m3sq*m4**10*B0fin(0,0,m3sq,mudim) - 4*m1**6*m3**4*m4sq*B0fin(0,0,m3sq,mudim) + m1**8*m3sq*m4sq*B0fin(0,0,m3sq,mudim) - m1**8*m3**4*B0fin(0,0,m4sq,mudim) + m1**6*m3**6*B0fin(0,0,m4sq,mudim) - 2*m1**8*m4**4*B0fin(0,0,m4sq,mudim) + 30*m1**4*m3**4*m4**4*B0fin(0,0,m4sq,mudim) - 9*m1sq*m3**6*m4**4*B0fin(0,0,m4sq,mudim) - 2*m3**8*m4**4*B0fin(0,0,m4sq,mudim) - 17*m1**6*m3sq*m4**4*B0fin(0,0,m4sq,mudim) + 7*m1**6*m4**6*B0fin(0,0,m4sq,mudim) - 5*m1sq*m3**4*m4**6*B0fin(0,0,m4sq,mudim) + 4*m3**6*m4**6*B0fin(0,0,m4sq,mudim) - 6*m1**4*m3sq*m4**6*B0fin(0,0,m4sq,mudim) - m3**4*m4**8*B0fin(0,0,m4sq,mudim) + m1sq*m3sq*m4**8*B0fin(0,0,m4sq,mudim) - m1sq*m4**10*B0fin(0,0,m4sq,mudim) + m3sq*m4**10*B0fin(0,0,m4sq,mudim) + m1**6*m3**4*m4sq*B0fin(0,0,m4sq,mudim) - 12*m1**4*m3**6*m4sq*B0fin(0,0,m4sq,mudim) + 6*m1sq*m3**8*m4sq*B0fin(0,0,m4sq,mudim) + 5*m1**8*m3sq*m4sq*B0fin(0,0,m4sq,mudim) - 2*m1**6*m3**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + m1**4*m3**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 9*m1**4*m3**4*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 6*m1sq*m3**6*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + m3**8*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 6*m1**6*m3sq*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 2*m1**6*m4**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 6*m1sq*m3**4*m4**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 3*m3**6*m4**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 7*m1**4*m3sq*m4**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 2*m1**4*m4**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 3*m3**4*m4**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 2*m1sq*m3sq*m4**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - m3sq*m4**10*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 6*m1**6*m3**4*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 5*m1**4*m3**6*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 2*m1sq*m3**8*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + m1**8*m3**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + 6*m1**4*m3**4*m4**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) - 4*m1**6*m3sq*m4**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) - 4*m1sq*m3**4*m4**6*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + 6*m1**4*m3sq*m4**6*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + m3**4*m4**8*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) - 4*m1sq*m3sq*m4**8*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + m3sq*m4**10*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) - 4*m1**6*m3**4*m4sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + m1**8*m3sq*m4sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + 4*m1**4*m3**6*T134fin(m4,m1,0,mudim) - 2*m1sq*m3**8*T134fin(m4,m1,0,mudim) - 6*m1sq*m3**4*m4**4*T134fin(m4,m1,0,mudim) + 6*m3**6*m4**4*T134fin(m4,m1,0,mudim) + 12*m1**4*m3sq*m4**4*T134fin(m4,m1,0,mudim) - 4*m1**4*m4**6*T134fin(m4,m1,0,mudim) - 6*m3**4*m4**6*T134fin(m4,m1,0,mudim) + 2*m1sq*m3sq*m4**6*T134fin(m4,m1,0,mudim) + 2*m3sq*m4**8*T134fin(m4,m1,0,mudim) - 12*m1**4*m3**4*m4sq*T134fin(m4,m1,0,mudim) + 6*m1sq*m3**6*m4sq*T134fin(m4,m1,0,mudim) - 2*m3**8*m4sq*T134fin(m4,m1,0,mudim) - 2*m1**8*m3sq*T134fin(m4,m3,0,mudim) - 12*m1**4*m3sq*m4**4*T134fin(m4,m3,0,mudim) + 8*m1sq*m3sq*m4**6*T134fin(m4,m3,0,mudim) - 2*m3sq*m4**8*T134fin(m4,m3,0,mudim) + 8*m1**6*m3sq*m4sq*T134fin(m4,m3,0,mudim))/((m1sq - m3sq)**2*(m1sq - m4sq)**4*(m3sq - m4sq)**3)
		def eval_124():
			return (-((m1sq - m2sq)**2*(m1sq - m3sq)**2*(m2sq - m3sq)**3*(6 + 2*B0del(0,0,m1sq,mudim) - 6*B0fin(0,0,m1sq,mudim) + B0fin(0,0,m1sq,mudim)**2)) - 4*(m1sq - m2sq)**2*m2sq*(m1sq - m3sq)**3*m3sq*(B0fin(0,0,m2sq,mudim) + B0fin(0,0,m3sq,mudim)) - 4*m1sq*(m2sq - m3sq)**2*(-((m2sq*(m1sq - m3sq)**3 - (m1sq - m2sq)**2*m3sq*(m1sq - 2*m2sq + m3sq))*B0fin(0,0,m1sq,mudim)) - m2sq*(m1sq - m3sq)**3*B0fin(0,0,m2sq,mudim) + (m1sq - m2sq)**2*m3sq*(m1sq - 2*m2sq + m3sq)*B0fin(0,0,m3sq,mudim)) + 4*(m1sq - m2sq)**2*m2sq*(m1sq - m3sq)**3*m3sq*(B0del(0,0,m2sq,mudim) + B0del(0,0,m3sq,mudim) + B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim)) + (m1sq - m2sq)**3*(m1sq - m3sq)**2*(m2sq - m3sq)**2*(6 + 2*B0del(0,0,m3sq,mudim) - 6*B0fin(0,0,m3sq,mudim) + B0fin(0,0,m3sq,mudim)**2) + 4*m1sq*(m2sq - m3sq)**2*(-((m2sq*(m1sq - m3sq)**3 - (m1sq - m2sq)**2*m3sq*(m1sq - 2*m2sq + m3sq))*B0del(0,0,m1sq,mudim)) - m2sq*(m1sq - m3sq)**3*B0del(0,0,m2sq,mudim) + (m1sq - m2sq)**2*m3sq*(m1sq - 2*m2sq + m3sq)*B0del(0,0,m3sq,mudim) - B0fin(0,0,m1sq,mudim)*(m2sq*(m1sq - m3sq)**3*B0fin(0,0,m2sq,mudim) - (m1sq - m2sq)**2*m3sq*(m1sq - 2*m2sq + m3sq)*B0fin(0,0,m3sq,mudim))) - 2*(m1sq + m2sq)*(m1sq - m3sq)**3*(m2sq - m3sq)**2*(m1sq + m2sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim) - T134fin(m2,m1,0,mudim)) + 2*(m1sq - m2sq)**2*(m2sq - m3sq)**2*(m1sq + m3sq)*(m1sq - 2*m2sq + m3sq)*(m1sq + m3sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,m1,0,mudim)) + 2*(m1sq - m2sq)**2*(m1sq - m3sq)**3*(m2sq + m3sq)*(m2sq + m3sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,m2,0,mudim)))/(2.*(m1sq - m2sq)**3*(m1sq - m3sq)**4*(m2sq - m3sq)**3)
		def eval_125():
			return (-((m1sq - m2sq)**2*(m1sq - m3sq)**2*(m2sq - m3sq)**3*(6 + 2*B0del(0,0,m1sq,mudim) - 6*B0fin(0,0,m1sq,mudim) + B0fin(0,0,m1sq,mudim)**2)) - 4*(m1sq - m2sq)**2*m2sq*(m1sq - m3sq)**3*m3sq*(B0fin(0,0,m2sq,mudim) + B0fin(0,0,m3sq,mudim)) - 4*m1sq*(m2sq - m3sq)**2*(-((m2sq*(m1sq - m3sq)**3 - (m1sq - m2sq)**2*m3sq*(m1sq - 2*m2sq + m3sq))*B0fin(0,0,m1sq,mudim)) - m2sq*(m1sq - m3sq)**3*B0fin(0,0,m2sq,mudim) + (m1sq - m2sq)**2*m3sq*(m1sq - 2*m2sq + m3sq)*B0fin(0,0,m3sq,mudim)) + 4*(m1sq - m2sq)**2*m2sq*(m1sq - m3sq)**3*m3sq*(B0del(0,0,m2sq,mudim) + B0del(0,0,m3sq,mudim) + B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim)) + (m1sq - m2sq)**3*(m1sq - m3sq)**2*(m2sq - m3sq)**2*(6 + 2*B0del(0,0,m3sq,mudim) - 6*B0fin(0,0,m3sq,mudim) + B0fin(0,0,m3sq,mudim)**2) + 4*m1sq*(m2sq - m3sq)**2*(-((m2sq*(m1sq - m3sq)**3 - (m1sq - m2sq)**2*m3sq*(m1sq - 2*m2sq + m3sq))*B0del(0,0,m1sq,mudim)) - m2sq*(m1sq - m3sq)**3*B0del(0,0,m2sq,mudim) + (m1sq - m2sq)**2*m3sq*(m1sq - 2*m2sq + m3sq)*B0del(0,0,m3sq,mudim) - B0fin(0,0,m1sq,mudim)*(m2sq*(m1sq - m3sq)**3*B0fin(0,0,m2sq,mudim) - (m1sq - m2sq)**2*m3sq*(m1sq - 2*m2sq + m3sq)*B0fin(0,0,m3sq,mudim))) - 2*(m1sq + m2sq)*(m1sq - m3sq)**3*(m2sq - m3sq)**2*(m1sq + m2sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim) - T134fin(m2,m1,0,mudim)) + 2*(m1sq - m2sq)**2*(m2sq - m3sq)**2*(m1sq + m3sq)*(m1sq - 2*m2sq + m3sq)*(m1sq + m3sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,m1,0,mudim)) + 2*(m1sq - m2sq)**2*(m1sq - m3sq)**3*(m2sq + m3sq)*(m2sq + m3sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,m2,0,mudim)))/(2.*(m1sq - m2sq)**3*(m1sq - m3sq)**4*(m2sq - m3sq)**3)
		def eval_126():
			return -0.5*((2*(m3**3 - m3*m7sq)**2*((3*m1sq + m3sq)*B0del(0,0,m1sq,mudim) + (3*m1sq + m3sq)*B0del(0,0,m3sq,mudim) + 4*m1sq*B0fin(0,0,m1sq,mudim) + 4*m1sq*B0fin(0,0,m3sq,mudim) + 3*m1sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + m3sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim)))/(m1sq - m3sq)**4 + ((m3sq - m7sq)**2*(6 + 2*B0del(0,0,m3sq,mudim) - 6*B0fin(0,0,m3sq,mudim) + B0fin(0,0,m3sq,mudim)**2))/(m1sq - m3sq)**2 - (2*(m3sq - m7sq)**2*m7sq*(-(m1sq*(-3*m1**4 + m3sq*m7sq + m1sq*(m3sq + m7sq))*B0del(0,0,m1sq,mudim)) - m1sq*(-3*m1**4 + m3sq*m7sq + m1sq*(m3sq + m7sq))*B0del(0,0,m7sq,mudim) + 4*m1sq*(m1**4 - m1sq*m3sq)*B0fin(0,0,m1sq,mudim) - (-4*m1**6 + 4*m1**4*m3sq + (-3*m1**6 + m1sq*m3sq*m7sq + m1**4*(m3sq + m7sq))*B0fin(0,0,m1sq,mudim))*B0fin(0,0,m7sq,mudim)))/((m1**3 - m1*m3sq)**2*(m1sq - m7sq)**3) + (4*m3sq*m7sq*(B0del(0,0,m3sq,mudim) + B0del(0,0,m7sq,mudim) + B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim)))/(m1sq - m3sq)**2 - (2*((m3**3 - m3*m7sq)**2*(4*m1sq + (3*m1sq + m3sq)*B0fin(0,0,m1sq,mudim) + (3*m1sq + m3sq)*B0fin(0,0,m3sq,mudim)) + 2*(m1sq - m3sq)**2*m3sq*m7sq*(B0fin(0,0,m3sq,mudim) + B0fin(0,0,m7sq,mudim)) + ((m1sq - m3sq)**2*(-(m3sq*m7) + m7**3)**2*(-4*m1**4 + 4*m1sq*m3sq + (-3*m1**4 + m3sq*m7sq + m1sq*(m3sq + m7sq))*B0fin(0,0,m1sq,mudim) + (-3*m1**4 + m3sq*m7sq + m1sq*(m3sq + m7sq))*B0fin(0,0,m7sq,mudim)))/(m1sq - m7sq)**3))/(m1sq - m3sq)**4 + (2*(m3sq - m7sq)**2*(2*m1**4 + 4*m3**4 + 6*m1sq*m3sq + 4*m1sq*m3sq*B0fin(0,0,m1sq,mudim) + 4*m3**4*B0fin(0,0,m3sq,mudim) - m1sq*T134fin(m3,m1,0,mudim) - 3*m3sq*T134fin(m3,m1,0,mudim)))/(m1sq - m3sq)**4 + (2*(m3sq - m7sq)**2*(-2*m1**6 + m1**4*m3sq - 2*m1sq*m7**4 + 3*m3sq*m7**4 + m7**6 - 5*m1**4*m7sq + 4*m1sq*m3sq*m7sq - 2*m1sq*(m1sq - m7sq)*(m3sq + m7sq)*B0fin(0,0,m1sq,mudim) + 2*m7sq*(-m1sq + m7sq)*(m3sq + m7sq)*B0fin(0,0,m7sq,mudim) + m1**4*T134fin(m7,m1,0,mudim) - m7**4*T134fin(m7,m1,0,mudim) + 2*m1sq*m7sq*T134fin(m7,m1,0,mudim) - 2*m3sq*m7sq*T134fin(m7,m1,0,mudim)))/((m1sq - m3sq)**2*(m1sq - m7sq)**3) + (2*(m3sq + m7sq)*(m3sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim) - T134fin(m7,m3,0,mudim)))/(m1sq - m3sq)**2)/(m3sq - m7sq)**3
		def eval_127():
			return -0.5*(((m1sq - m7sq)**2*(6 + 2*B0del(0,0,m1sq,mudim) - 6*B0fin(0,0,m1sq,mudim) + B0fin(0,0,m1sq,mudim)**2))/(m1sq - m2sq)**2 + (2*(m1**3 - m1*m7sq)**2*((m1sq + 3*m2sq)*B0del(0,0,m1sq,mudim) + (m1sq + 3*m2sq)*B0del(0,0,m2sq,mudim) + 4*m2sq*B0fin(0,0,m1sq,mudim) + 4*m2sq*B0fin(0,0,m2sq,mudim) + m1sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 3*m2sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim)))/(m1sq - m2sq)**4 + (4*m1sq*m7sq*(B0del(0,0,m1sq,mudim) + B0del(0,0,m7sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim)))/(m1sq - m2sq)**2 - (2*(m1sq - m7sq)**2*m7sq*(-(m2sq*(-3*m2**4 + m2sq*m7sq + m1sq*(m2sq + m7sq))*B0del(0,0,m2sq,mudim)) - m2sq*(-3*m2**4 + m2sq*m7sq + m1sq*(m2sq + m7sq))*B0del(0,0,m7sq,mudim) + 4*m2sq*(m2**4 - m1sq*m2sq)*B0fin(0,0,m2sq,mudim) - (4*m1sq*m2**4 - 4*m2**6 + m2sq*(-3*m2**4 + m2sq*m7sq + m1sq*(m2sq + m7sq))*B0fin(0,0,m2sq,mudim))*B0fin(0,0,m7sq,mudim)))/((-(m1sq*m2) + m2**3)**2*(m2sq - m7sq)**3) - (2*((m1**3 - m1*m7sq)**2*(4*m2sq + (m1sq + 3*m2sq)*B0fin(0,0,m1sq,mudim) + (m1sq + 3*m2sq)*B0fin(0,0,m2sq,mudim)) + 2*m1sq*(m1sq - m2sq)**2*m7sq*(B0fin(0,0,m1sq,mudim) + B0fin(0,0,m7sq,mudim)) + ((m1sq - m2sq)**2*(-(m1sq*m7) + m7**3)**2*(4*(m1sq - m2sq)*m2sq + (-3*m2**4 + m2sq*m7sq + m1sq*(m2sq + m7sq))*B0fin(0,0,m2sq,mudim) + (-3*m2**4 + m2sq*m7sq + m1sq*(m2sq + m7sq))*B0fin(0,0,m7sq,mudim)))/(m2sq - m7sq)**3))/(m1sq - m2sq)**4 + (2*(m1sq - m7sq)**2*(4*m1**4 + 2*m2**4 + 6*m1sq*m2sq + 4*m1**4*B0fin(0,0,m1sq,mudim) + 4*m1sq*m2sq*B0fin(0,0,m2sq,mudim) - 3*m1sq*T134fin(m2,m1,0,mudim) - m2sq*T134fin(m2,m1,0,mudim)))/(m1sq - m2sq)**4 + (2*(m1sq + m7sq)*(m1sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim) - T134fin(m7,m1,0,mudim)))/(m1sq - m2sq)**2 + (2*(m1sq - m7sq)**2*(m1sq*m2**4 - 2*m2**6 + 3*m1sq*m7**4 - 2*m2sq*m7**4 + m7**6 - 5*m2**4*m7sq + 4*m1sq*m2sq*m7sq - 2*m2sq*(m2sq - m7sq)*(m1sq + m7sq)*B0fin(0,0,m2sq,mudim) + 2*m7sq*(m1sq + m7sq)*(-m2sq + m7sq)*B0fin(0,0,m7sq,mudim) + m2**4*T134fin(m7,m2,0,mudim) - m7**4*T134fin(m7,m2,0,mudim) - 2*m1sq*m7sq*T134fin(m7,m2,0,mudim) + 2*m2sq*m7sq*T134fin(m7,m2,0,mudim)))/((m1sq - m2sq)**2*(m2sq - m7sq)**3))/(m1sq - m7sq)**3
		def eval_128():
			return -0.5*((2*(m3**3 - m3*m5sq)**2*((3*m1sq + m3sq)*B0del(0,0,m1sq,mudim) + (3*m1sq + m3sq)*B0del(0,0,m3sq,mudim) + 4*m1sq*B0fin(0,0,m1sq,mudim) + 4*m1sq*B0fin(0,0,m3sq,mudim) + 3*m1sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + m3sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim)))/(m1sq - m3sq)**4 + ((m3sq - m5sq)**2*(6 + 2*B0del(0,0,m3sq,mudim) - 6*B0fin(0,0,m3sq,mudim) + B0fin(0,0,m3sq,mudim)**2))/(m1sq - m3sq)**2 - (2*(m3sq - m5sq)**2*m5sq*(-(m1sq*(-3*m1**4 + m3sq*m5sq + m1sq*(m3sq + m5sq))*B0del(0,0,m1sq,mudim)) - m1sq*(-3*m1**4 + m3sq*m5sq + m1sq*(m3sq + m5sq))*B0del(0,0,m5sq,mudim) + 4*m1sq*(m1**4 - m1sq*m3sq)*B0fin(0,0,m1sq,mudim) - (-4*m1**6 + 4*m1**4*m3sq + (-3*m1**6 + m1sq*m3sq*m5sq + m1**4*(m3sq + m5sq))*B0fin(0,0,m1sq,mudim))*B0fin(0,0,m5sq,mudim)))/((m1**3 - m1*m3sq)**2*(m1sq - m5sq)**3) + (4*m3sq*m5sq*(B0del(0,0,m3sq,mudim) + B0del(0,0,m5sq,mudim) + B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim)))/(m1sq - m3sq)**2 - (2*((m3**3 - m3*m5sq)**2*(4*m1sq + (3*m1sq + m3sq)*B0fin(0,0,m1sq,mudim) + (3*m1sq + m3sq)*B0fin(0,0,m3sq,mudim)) + 2*(m1sq - m3sq)**2*m3sq*m5sq*(B0fin(0,0,m3sq,mudim) + B0fin(0,0,m5sq,mudim)) + ((m1sq - m3sq)**2*(-(m3sq*m5) + m5**3)**2*(-4*m1**4 + 4*m1sq*m3sq + (-3*m1**4 + m3sq*m5sq + m1sq*(m3sq + m5sq))*B0fin(0,0,m1sq,mudim) + (-3*m1**4 + m3sq*m5sq + m1sq*(m3sq + m5sq))*B0fin(0,0,m5sq,mudim)))/(m1sq - m5sq)**3))/(m1sq - m3sq)**4 + (2*(m3sq - m5sq)**2*(2*m1**4 + 4*m3**4 + 6*m1sq*m3sq + 4*m1sq*m3sq*B0fin(0,0,m1sq,mudim) + 4*m3**4*B0fin(0,0,m3sq,mudim) - m1sq*T134fin(m3,m1,0,mudim) - 3*m3sq*T134fin(m3,m1,0,mudim)))/(m1sq - m3sq)**4 + (2*(m3sq - m5sq)**2*(-2*m1**6 + m1**4*m3sq - 2*m1sq*m5**4 + 3*m3sq*m5**4 + m5**6 - 5*m1**4*m5sq + 4*m1sq*m3sq*m5sq - 2*m1sq*(m1sq - m5sq)*(m3sq + m5sq)*B0fin(0,0,m1sq,mudim) + 2*m5sq*(-m1sq + m5sq)*(m3sq + m5sq)*B0fin(0,0,m5sq,mudim) + m1**4*T134fin(m5,m1,0,mudim) - m5**4*T134fin(m5,m1,0,mudim) + 2*m1sq*m5sq*T134fin(m5,m1,0,mudim) - 2*m3sq*m5sq*T134fin(m5,m1,0,mudim)))/((m1sq - m3sq)**2*(m1sq - m5sq)**3) + (2*(m3sq + m5sq)*(m3sq + m5sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) - T134fin(m5,m3,0,mudim)))/(m1sq - m3sq)**2)/(m3sq - m5sq)**3
		def eval_129():
			return -0.5*(((m1sq - m5sq)**2*(6 + 2*B0del(0,0,m1sq,mudim) - 6*B0fin(0,0,m1sq,mudim) + B0fin(0,0,m1sq,mudim)**2))/(m1sq - m2sq)**2 + (2*(m1**3 - m1*m5sq)**2*((m1sq + 3*m2sq)*B0del(0,0,m1sq,mudim) + (m1sq + 3*m2sq)*B0del(0,0,m2sq,mudim) + 4*m2sq*B0fin(0,0,m1sq,mudim) + 4*m2sq*B0fin(0,0,m2sq,mudim) + m1sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 3*m2sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim)))/(m1sq - m2sq)**4 + (4*m1sq*m5sq*(B0del(0,0,m1sq,mudim) + B0del(0,0,m5sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim)))/(m1sq - m2sq)**2 - (2*(m1sq - m5sq)**2*m5sq*(-(m2sq*(-3*m2**4 + m2sq*m5sq + m1sq*(m2sq + m5sq))*B0del(0,0,m2sq,mudim)) - m2sq*(-3*m2**4 + m2sq*m5sq + m1sq*(m2sq + m5sq))*B0del(0,0,m5sq,mudim) + 4*m2sq*(m2**4 - m1sq*m2sq)*B0fin(0,0,m2sq,mudim) - (4*m1sq*m2**4 - 4*m2**6 + m2sq*(-3*m2**4 + m2sq*m5sq + m1sq*(m2sq + m5sq))*B0fin(0,0,m2sq,mudim))*B0fin(0,0,m5sq,mudim)))/((-(m1sq*m2) + m2**3)**2*(m2sq - m5sq)**3) - (2*((m1**3 - m1*m5sq)**2*(4*m2sq + (m1sq + 3*m2sq)*B0fin(0,0,m1sq,mudim) + (m1sq + 3*m2sq)*B0fin(0,0,m2sq,mudim)) + 2*m1sq*(m1sq - m2sq)**2*m5sq*(B0fin(0,0,m1sq,mudim) + B0fin(0,0,m5sq,mudim)) + ((m1sq - m2sq)**2*(-(m1sq*m5) + m5**3)**2*(4*(m1sq - m2sq)*m2sq + (-3*m2**4 + m2sq*m5sq + m1sq*(m2sq + m5sq))*B0fin(0,0,m2sq,mudim) + (-3*m2**4 + m2sq*m5sq + m1sq*(m2sq + m5sq))*B0fin(0,0,m5sq,mudim)))/(m2sq - m5sq)**3))/(m1sq - m2sq)**4 + (2*(m1sq - m5sq)**2*(4*m1**4 + 2*m2**4 + 6*m1sq*m2sq + 4*m1**4*B0fin(0,0,m1sq,mudim) + 4*m1sq*m2sq*B0fin(0,0,m2sq,mudim) - 3*m1sq*T134fin(m2,m1,0,mudim) - m2sq*T134fin(m2,m1,0,mudim)))/(m1sq - m2sq)**4 + (2*(m1sq + m5sq)*(m1sq + m5sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) - T134fin(m5,m1,0,mudim)))/(m1sq - m2sq)**2 + (2*(m1sq - m5sq)**2*(m1sq*m2**4 - 2*m2**6 + 3*m1sq*m5**4 - 2*m2sq*m5**4 + m5**6 - 5*m2**4*m5sq + 4*m1sq*m2sq*m5sq - 2*m2sq*(m2sq - m5sq)*(m1sq + m5sq)*B0fin(0,0,m2sq,mudim) + 2*m5sq*(m1sq + m5sq)*(-m2sq + m5sq)*B0fin(0,0,m5sq,mudim) + m2**4*T134fin(m5,m2,0,mudim) - m5**4*T134fin(m5,m2,0,mudim) - 2*m1sq*m5sq*T134fin(m5,m2,0,mudim) + 2*m2sq*m5sq*T134fin(m5,m2,0,mudim)))/((m1sq - m2sq)**2*(m2sq - m5sq)**3))/(m1sq - m5sq)**3
		def eval_130():
			return -0.5*((m1sq - m2sq)**2*(m1sq - m3sq)**2*(m2sq - m3sq)**3*(6 + 2*B0del(0,0,m1sq,mudim) - 6*B0fin(0,0,m1sq,mudim) + B0fin(0,0,m1sq,mudim)**2) - 4*m1sq*m2sq*(m1sq + m2sq - 2*m3sq)*(m1sq - m3sq)**2*(m2sq - m3sq)**2*(B0fin(0,0,m1sq,mudim) + B0fin(0,0,m2sq,mudim)) + 4*m1sq*m2sq*(m1sq + m2sq - 2*m3sq)*(m1sq - m3sq)**2*(m2sq - m3sq)**2*(B0del(0,0,m1sq,mudim) + B0del(0,0,m2sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim)) + (m1sq - m2sq)**2*(m1sq - m3sq)**3*(m2sq - m3sq)**2*(6 + 2*B0del(0,0,m2sq,mudim) - 6*B0fin(0,0,m2sq,mudim) + B0fin(0,0,m2sq,mudim)**2) + 4*m1sq*(m1sq - m2sq)**3*(m2sq - m3sq)**2*m3sq*(B0fin(0,0,m1sq,mudim) + B0fin(0,0,m3sq,mudim)) + 4*m2sq*(-m1sq + m2sq)**3*(m1sq - m3sq)**2*m3sq*(B0fin(0,0,m2sq,mudim) + B0fin(0,0,m3sq,mudim)) - 4*m1sq*(m1sq - m2sq)**3*(m2sq - m3sq)**2*m3sq*(B0del(0,0,m1sq,mudim) + B0del(0,0,m3sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim)) - 4*m2sq*(-m1sq + m2sq)**3*(m1sq - m3sq)**2*m3sq*(B0del(0,0,m2sq,mudim) + B0del(0,0,m3sq,mudim) + B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim)) + 2*(m1sq + m2sq)*(m1sq + m2sq - 2*m3sq)*(m1sq - m3sq)**2*(m2sq - m3sq)**2*(m1sq + m2sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim) - T134fin(m2,m1,0,mudim)) - 2*(m1sq - m2sq)**3*(m2sq - m3sq)**2*(m1sq + m3sq)*(m1sq + m3sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,m1,0,mudim)) + 2*(m1sq - m2sq)**3*(m1sq - m3sq)**2*(m2sq + m3sq)*(m2sq + m3sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,m2,0,mudim)))/((m1sq - m2sq)**4*(m1sq - m3sq)**3*(m2sq - m3sq)**3)
		def eval_131():
			return -0.5*((m1sq - m2sq)**2*(m1sq - m3sq)**2*(m2sq - m3sq)**3*(6 + 2*B0del(0,0,m1sq,mudim) - 6*B0fin(0,0,m1sq,mudim) + B0fin(0,0,m1sq,mudim)**2) - 4*m1sq*m2sq*(m1sq + m2sq - 2*m3sq)*(m1sq - m3sq)**2*(m2sq - m3sq)**2*(B0fin(0,0,m1sq,mudim) + B0fin(0,0,m2sq,mudim)) + 4*m1sq*m2sq*(m1sq + m2sq - 2*m3sq)*(m1sq - m3sq)**2*(m2sq - m3sq)**2*(B0del(0,0,m1sq,mudim) + B0del(0,0,m2sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim)) + (m1sq - m2sq)**2*(m1sq - m3sq)**3*(m2sq - m3sq)**2*(6 + 2*B0del(0,0,m2sq,mudim) - 6*B0fin(0,0,m2sq,mudim) + B0fin(0,0,m2sq,mudim)**2) + 4*m1sq*(m1sq - m2sq)**3*(m2sq - m3sq)**2*m3sq*(B0fin(0,0,m1sq,mudim) + B0fin(0,0,m3sq,mudim)) + 4*m2sq*(-m1sq + m2sq)**3*(m1sq - m3sq)**2*m3sq*(B0fin(0,0,m2sq,mudim) + B0fin(0,0,m3sq,mudim)) - 4*m1sq*(m1sq - m2sq)**3*(m2sq - m3sq)**2*m3sq*(B0del(0,0,m1sq,mudim) + B0del(0,0,m3sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim)) - 4*m2sq*(-m1sq + m2sq)**3*(m1sq - m3sq)**2*m3sq*(B0del(0,0,m2sq,mudim) + B0del(0,0,m3sq,mudim) + B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim)) + 2*(m1sq + m2sq)*(m1sq + m2sq - 2*m3sq)*(m1sq - m3sq)**2*(m2sq - m3sq)**2*(m1sq + m2sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim) - T134fin(m2,m1,0,mudim)) - 2*(m1sq - m2sq)**3*(m2sq - m3sq)**2*(m1sq + m3sq)*(m1sq + m3sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,m1,0,mudim)) + 2*(m1sq - m2sq)**3*(m1sq - m3sq)**2*(m2sq + m3sq)*(m2sq + m3sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,m2,0,mudim)))/((m1sq - m2sq)**4*(m1sq - m3sq)**3*(m2sq - m3sq)**3)
		def eval_132():
			return (-(m1**4/(m1sq - m6sq)**4) + (3*m6**4)/(m1sq - m6sq)**4 + (6*m1sq*m6sq)/(m1sq - m6sq)**4 + m6sq/(m1**3 - m1*m6sq)**2 + m1**4/(m1sq - m7sq)**4 - (3*m7**4)/(m1sq - m7sq)**4 - (6*m1sq*m7sq)/(m1sq - m7sq)**4 - m7sq/(m1**3 - m1*m7sq)**2 + ((2*m6**4)/(m1sq - m6sq)**4 - (2*m7**4)/(m1sq - m7sq)**4 + m1sq*((2*m6sq)/(m1sq - m6sq)**4 - (2*m7sq)/(m1sq - m7sq)**4))*B0del(0,0,m1sq,mudim) + (2*m6sq*(m1sq + m6sq)*B0del(0,0,m6sq,mudim))/(m1sq - m6sq)**4 - (2*m7**4*B0del(0,0,m7sq,mudim))/(m1sq - m7sq)**4 - (2*m1sq*m7sq*B0del(0,0,m7sq,mudim))/(m1sq - m7sq)**4 - (2*m1**4*B0fin(0,0,m1sq,mudim))/(m1sq - m6sq)**4 + (2*m6**4*B0fin(0,0,m1sq,mudim))/(m1sq - m6sq)**4 + (4*m1sq*m6sq*B0fin(0,0,m1sq,mudim))/(m1sq - m6sq)**4 - (m6sq*B0fin(0,0,m1sq,mudim))/(m1**3 - m1*m6sq)**2 + (2*m1**4*B0fin(0,0,m1sq,mudim))/(m1sq - m7sq)**4 - (2*m7**4*B0fin(0,0,m1sq,mudim))/(m1sq - m7sq)**4 - (4*m1sq*m7sq*B0fin(0,0,m1sq,mudim))/(m1sq - m7sq)**4 + (m7sq*B0fin(0,0,m1sq,mudim))/(m1**3 - m1*m7sq)**2 + (4*m1sq*m6sq*B0fin(0,0,m6sq,mudim))/(m1sq - m6sq)**4 - (m6sq*B0fin(0,0,m6sq,mudim))/(m1**3 - m1*m6sq)**2 + (2*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1sq - m6sq)**4 + (2*m1sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1sq - m6sq)**4 - (4*m1sq*m7sq*B0fin(0,0,m7sq,mudim))/(m1sq - m7sq)**4 + (m7sq*B0fin(0,0,m7sq,mudim))/(m1**3 - m1*m7sq)**2 - (2*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/(m1sq - m7sq)**4 - (2*m1sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/(m1sq - m7sq)**4 - (4*m6sq*T134fin(m6,m1,0,mudim))/(m1sq - m6sq)**4 + (4*m7sq*T134fin(m7,m1,0,mudim))/(m1sq - m7sq)**4)/(2.*(m6sq - m7sq))
		def eval_133():
			return (((m1sq - m7sq)**3*(3*(m1sq + m3sq) + 2*m1sq*B0del(0,0,m1sq,mudim) - 2*(2*m1sq + m3sq)*B0fin(0,0,m1sq,mudim) + m1sq*B0fin(0,0,m1sq,mudim)**2))/(m1**3 - m1*m3sq)**2 + (4*m1sq*m3sq*(m1sq - m7sq)**3*(B0del(0,0,m1sq,mudim) + B0del(0,0,m3sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim)))/(m1sq - m3sq)**4 + (2*m7sq*(-(m1sq*(-3*m1**4 + m3sq*m7sq + m1sq*(m3sq + m7sq))*B0del(0,0,m1sq,mudim)) - m1sq*(-3*m1**4 + m3sq*m7sq + m1sq*(m3sq + m7sq))*B0del(0,0,m7sq,mudim) + 4*m1sq*(m1**4 - m1sq*m3sq)*B0fin(0,0,m1sq,mudim) - (-4*m1**6 + 4*m1**4*m3sq + (-3*m1**6 + m1sq*m3sq*m7sq + m1**4*(m3sq + m7sq))*B0fin(0,0,m1sq,mudim))*B0fin(0,0,m7sq,mudim)))/(m1**3 - m1*m3sq)**2 + (4*m3sq*m7sq*(-m1sq + m7sq)**3*(B0del(0,0,m3sq,mudim) + B0del(0,0,m7sq,mudim) + B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)**2*(m3sq - m7sq)**2) + (2*(-2*m1sq*m3sq*(m1sq - m7sq)**3*(B0fin(0,0,m1sq,mudim) + B0fin(0,0,m3sq,mudim)) + (2*(m1sq - m3sq)**2*m3sq*(m1sq - m7sq)**3*m7sq*(B0fin(0,0,m3sq,mudim) + B0fin(0,0,m7sq,mudim)))/(m3sq - m7sq)**2 + (m1sq - m3sq)**2*m7sq*(-4*m1**4 + 4*m1sq*m3sq + (-3*m1**4 + m3sq*m7sq + m1sq*(m3sq + m7sq))*B0fin(0,0,m1sq,mudim) + (-3*m1**4 + m3sq*m7sq + m1sq*(m3sq + m7sq))*B0fin(0,0,m7sq,mudim))))/(m1sq - m3sq)**4 + (2*(m1sq + m3sq)*(m1sq - m7sq)**3*(m1sq + m3sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,m1,0,mudim)))/(m1sq - m3sq)**4 + (2*(2*m1**6 - m1**4*m3sq + 2*m1sq*m7**4 - 3*m3sq*m7**4 - m7**6 + 5*m1**4*m7sq - 4*m1sq*m3sq*m7sq + 2*m1sq*(m1sq - m7sq)*(m3sq + m7sq)*B0fin(0,0,m1sq,mudim) + 2*(m1sq - m7sq)*m7sq*(m3sq + m7sq)*B0fin(0,0,m7sq,mudim) - m1**4*T134fin(m7,m1,0,mudim) + m7**4*T134fin(m7,m1,0,mudim) - 2*m1sq*m7sq*T134fin(m7,m1,0,mudim) + 2*m3sq*m7sq*T134fin(m7,m1,0,mudim)))/(m1sq - m3sq)**2 - (2*(m1sq - m7sq)**3*(m3sq + m7sq)*(m3sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim) - T134fin(m7,m3,0,mudim)))/((m1sq - m3sq)**2*(m3sq - m7sq)**2))/(2.*(m1sq - m7sq)**4)
		def eval_134():
			return (12*m1**8 + 4*m1**6*m3sq + 2*m1**4*m7**4 + 2*m1sq*m3sq*m7**4 - 2*m1**6*m7sq - 18*m1**4*m3sq*m7sq + 2*(6*m1**8 + m1sq*m3sq*m7**4 + 2*m1**6*(m3sq - 2*m7sq) + m1**4*(m7**4 - 6*m3sq*m7sq))*B0del(0,0,m1sq,mudim) + 6*m1**4*(m1sq - m3sq)*m7sq*B0del(0,0,m7sq,mudim) + 12*m1**8*B0fin(0,0,m1sq,mudim) + 4*m1**6*m3sq*B0fin(0,0,m1sq,mudim) + 2*m1**4*m7**4*B0fin(0,0,m1sq,mudim) + 2*m1sq*m3sq*m7**4*B0fin(0,0,m1sq,mudim) - 8*m1**6*m7sq*B0fin(0,0,m1sq,mudim) - 12*m1**4*m3sq*m7sq*B0fin(0,0,m1sq,mudim) + 6*m1**8*B0fin(0,0,m1sq,mudim)**2 + 2*m1**6*m3sq*B0fin(0,0,m1sq,mudim)**2 + m1**4*m7**4*B0fin(0,0,m1sq,mudim)**2 + m1sq*m3sq*m7**4*B0fin(0,0,m1sq,mudim)**2 - 7*m1**6*m7sq*B0fin(0,0,m1sq,mudim)**2 - 3*m1**4*m3sq*m7sq*B0fin(0,0,m1sq,mudim)**2 + 6*m1**6*m7sq*B0fin(0,0,m7sq,mudim) - 6*m1**4*m3sq*m7sq*B0fin(0,0,m7sq,mudim) + 6*m1**6*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 6*m1**4*m3sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 8*m1**4*m3sq*T134fin(m1,0,0,mudim) - 2*m3sq*m7**4*T134fin(m1,0,0,mudim) + 10*m1sq*m3sq*m7sq*T134fin(m1,0,0,mudim) + 8*m1**6*T134fin(m3,0,0,mudim) + 2*m1sq*m7**4*T134fin(m3,0,0,mudim) - 10*m1**4*m7sq*T134fin(m3,0,0,mudim) - 8*m1**6*T134fin(m3,m1,0,mudim) - 2*m1sq*m7**4*T134fin(m3,m1,0,mudim) + 10*m1**4*m7sq*T134fin(m3,m1,0,mudim) + 8*m1**4*m3sq*T134fin(m7,m1,0,mudim) + 2*m1sq*m7**4*T134fin(m7,m1,0,mudim) - 8*m1**4*m7sq*T134fin(m7,m1,0,mudim) - 2*m1sq*m3sq*m7sq*T134fin(m7,m1,0,mudim) - 6*m1**6*T134fin(m7,m1,m1,mudim) - 2*m1**4*m3sq*T134fin(m7,m1,m1,mudim) - 2*m1sq*m7**4*T134fin(m7,m1,m1,mudim) + 8*m1**4*m7sq*T134fin(m7,m1,m1,mudim) + 2*m1sq*m3sq*m7sq*T134fin(m7,m1,m1,mudim) - 8*m1**6*T134fin(m7,m3,0,mudim) - 2*m1sq*m7**4*T134fin(m7,m3,0,mudim) + 10*m1**4*m7sq*T134fin(m7,m3,0,mudim) + 8*m1**6*T134fin(m7,m3,m1,mudim) + 2*m1sq*m7**4*T134fin(m7,m3,m1,mudim) - 10*m1**4*m7sq*T134fin(m7,m3,m1,mudim))/(2.*m1**4*(m1sq - m3sq)**2*m7**2*(4*m1**4 + m7**4 - 5*m1sq*m7sq))
		def eval_135():
			return (-(m1**4/(m1sq - m4sq)**4) + (3*m4**4)/(m1sq - m4sq)**4 + (6*m1sq*m4sq)/(m1sq - m4sq)**4 + m4sq/(m1**3 - m1*m4sq)**2 + m1**4/(m1sq - m5sq)**4 - (3*m5**4)/(m1sq - m5sq)**4 - (6*m1sq*m5sq)/(m1sq - m5sq)**4 - m5sq/(m1**3 - m1*m5sq)**2 + ((2*m4**4)/(m1sq - m4sq)**4 - (2*m5**4)/(m1sq - m5sq)**4 + m1sq*((2*m4sq)/(m1sq - m4sq)**4 - (2*m5sq)/(m1sq - m5sq)**4))*B0del(0,0,m1sq,mudim) + (2*m4sq*(m1sq + m4sq)*B0del(0,0,m4sq,mudim))/(m1sq - m4sq)**4 - (2*m5**4*B0del(0,0,m5sq,mudim))/(m1sq - m5sq)**4 - (2*m1sq*m5sq*B0del(0,0,m5sq,mudim))/(m1sq - m5sq)**4 - (2*m1**4*B0fin(0,0,m1sq,mudim))/(m1sq - m4sq)**4 + (2*m4**4*B0fin(0,0,m1sq,mudim))/(m1sq - m4sq)**4 + (4*m1sq*m4sq*B0fin(0,0,m1sq,mudim))/(m1sq - m4sq)**4 - (m4sq*B0fin(0,0,m1sq,mudim))/(m1**3 - m1*m4sq)**2 + (2*m1**4*B0fin(0,0,m1sq,mudim))/(m1sq - m5sq)**4 - (2*m5**4*B0fin(0,0,m1sq,mudim))/(m1sq - m5sq)**4 - (4*m1sq*m5sq*B0fin(0,0,m1sq,mudim))/(m1sq - m5sq)**4 + (m5sq*B0fin(0,0,m1sq,mudim))/(m1**3 - m1*m5sq)**2 + (4*m1sq*m4sq*B0fin(0,0,m4sq,mudim))/(m1sq - m4sq)**4 - (m4sq*B0fin(0,0,m4sq,mudim))/(m1**3 - m1*m4sq)**2 + (2*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/(m1sq - m4sq)**4 + (2*m1sq*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/(m1sq - m4sq)**4 - (4*m1sq*m5sq*B0fin(0,0,m5sq,mudim))/(m1sq - m5sq)**4 + (m5sq*B0fin(0,0,m5sq,mudim))/(m1**3 - m1*m5sq)**2 - (2*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/(m1sq - m5sq)**4 - (2*m1sq*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/(m1sq - m5sq)**4 - (4*m4sq*T134fin(m4,m1,0,mudim))/(m1sq - m4sq)**4 + (4*m5sq*T134fin(m5,m1,0,mudim))/(m1sq - m5sq)**4)/(2.*(m4sq - m5sq))
		def eval_136():
			return (12*m1**8 + 4*m1**6*m3sq + 2*m1**4*m5**4 + 2*m1sq*m3sq*m5**4 - 2*m1**6*m5sq - 18*m1**4*m3sq*m5sq + 2*(6*m1**8 + m1sq*m3sq*m5**4 + 2*m1**6*(m3sq - 2*m5sq) + m1**4*(m5**4 - 6*m3sq*m5sq))*B0del(0,0,m1sq,mudim) + 6*m1**4*(m1sq - m3sq)*m5sq*B0del(0,0,m5sq,mudim) + 12*m1**8*B0fin(0,0,m1sq,mudim) + 4*m1**6*m3sq*B0fin(0,0,m1sq,mudim) + 2*m1**4*m5**4*B0fin(0,0,m1sq,mudim) + 2*m1sq*m3sq*m5**4*B0fin(0,0,m1sq,mudim) - 8*m1**6*m5sq*B0fin(0,0,m1sq,mudim) - 12*m1**4*m3sq*m5sq*B0fin(0,0,m1sq,mudim) + 6*m1**8*B0fin(0,0,m1sq,mudim)**2 + 2*m1**6*m3sq*B0fin(0,0,m1sq,mudim)**2 + m1**4*m5**4*B0fin(0,0,m1sq,mudim)**2 + m1sq*m3sq*m5**4*B0fin(0,0,m1sq,mudim)**2 - 7*m1**6*m5sq*B0fin(0,0,m1sq,mudim)**2 - 3*m1**4*m3sq*m5sq*B0fin(0,0,m1sq,mudim)**2 + 6*m1**6*m5sq*B0fin(0,0,m5sq,mudim) - 6*m1**4*m3sq*m5sq*B0fin(0,0,m5sq,mudim) + 6*m1**6*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 6*m1**4*m3sq*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 8*m1**4*m3sq*T134fin(m1,0,0,mudim) - 2*m3sq*m5**4*T134fin(m1,0,0,mudim) + 10*m1sq*m3sq*m5sq*T134fin(m1,0,0,mudim) + 8*m1**6*T134fin(m3,0,0,mudim) + 2*m1sq*m5**4*T134fin(m3,0,0,mudim) - 10*m1**4*m5sq*T134fin(m3,0,0,mudim) - 8*m1**6*T134fin(m3,m1,0,mudim) - 2*m1sq*m5**4*T134fin(m3,m1,0,mudim) + 10*m1**4*m5sq*T134fin(m3,m1,0,mudim) + 8*m1**4*m3sq*T134fin(m5,m1,0,mudim) + 2*m1sq*m5**4*T134fin(m5,m1,0,mudim) - 8*m1**4*m5sq*T134fin(m5,m1,0,mudim) - 2*m1sq*m3sq*m5sq*T134fin(m5,m1,0,mudim) - 6*m1**6*T134fin(m5,m1,m1,mudim) - 2*m1**4*m3sq*T134fin(m5,m1,m1,mudim) - 2*m1sq*m5**4*T134fin(m5,m1,m1,mudim) + 8*m1**4*m5sq*T134fin(m5,m1,m1,mudim) + 2*m1sq*m3sq*m5sq*T134fin(m5,m1,m1,mudim) - 8*m1**6*T134fin(m5,m3,0,mudim) - 2*m1sq*m5**4*T134fin(m5,m3,0,mudim) + 10*m1**4*m5sq*T134fin(m5,m3,0,mudim) + 8*m1**6*T134fin(m5,m3,m1,mudim) + 2*m1sq*m5**4*T134fin(m5,m3,m1,mudim) - 10*m1**4*m5sq*T134fin(m5,m3,m1,mudim))/(2.*m1**4*(m1sq - m3sq)**2*m5**2*(4*m1**4 + m5**4 - 5*m1sq*m5sq))
		def eval_137():
			return (((m1sq - m5sq)**3*(3*(m1sq + m3sq) + 2*m1sq*B0del(0,0,m1sq,mudim) - 2*(2*m1sq + m3sq)*B0fin(0,0,m1sq,mudim) + m1sq*B0fin(0,0,m1sq,mudim)**2))/(m1**3 - m1*m3sq)**2 + (4*m1sq*m3sq*(m1sq - m5sq)**3*(B0del(0,0,m1sq,mudim) + B0del(0,0,m3sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim)))/(m1sq - m3sq)**4 + (2*m5sq*(-(m1sq*(-3*m1**4 + m3sq*m5sq + m1sq*(m3sq + m5sq))*B0del(0,0,m1sq,mudim)) - m1sq*(-3*m1**4 + m3sq*m5sq + m1sq*(m3sq + m5sq))*B0del(0,0,m5sq,mudim) + 4*m1sq*(m1**4 - m1sq*m3sq)*B0fin(0,0,m1sq,mudim) - (-4*m1**6 + 4*m1**4*m3sq + (-3*m1**6 + m1sq*m3sq*m5sq + m1**4*(m3sq + m5sq))*B0fin(0,0,m1sq,mudim))*B0fin(0,0,m5sq,mudim)))/(m1**3 - m1*m3sq)**2 + (4*m3sq*m5sq*(-m1sq + m5sq)**3*(B0del(0,0,m3sq,mudim) + B0del(0,0,m5sq,mudim) + B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim)))/((m1sq - m3sq)**2*(m3sq - m5sq)**2) + (2*(-2*m1sq*m3sq*(m1sq - m5sq)**3*(B0fin(0,0,m1sq,mudim) + B0fin(0,0,m3sq,mudim)) + (2*(m1sq - m3sq)**2*m3sq*(m1sq - m5sq)**3*m5sq*(B0fin(0,0,m3sq,mudim) + B0fin(0,0,m5sq,mudim)))/(m3sq - m5sq)**2 + (m1sq - m3sq)**2*m5sq*(-4*m1**4 + 4*m1sq*m3sq + (-3*m1**4 + m3sq*m5sq + m1sq*(m3sq + m5sq))*B0fin(0,0,m1sq,mudim) + (-3*m1**4 + m3sq*m5sq + m1sq*(m3sq + m5sq))*B0fin(0,0,m5sq,mudim))))/(m1sq - m3sq)**4 + (2*(m1sq + m3sq)*(m1sq - m5sq)**3*(m1sq + m3sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,m1,0,mudim)))/(m1sq - m3sq)**4 + (2*(2*m1**6 - m1**4*m3sq + 2*m1sq*m5**4 - 3*m3sq*m5**4 - m5**6 + 5*m1**4*m5sq - 4*m1sq*m3sq*m5sq + 2*m1sq*(m1sq - m5sq)*(m3sq + m5sq)*B0fin(0,0,m1sq,mudim) + 2*(m1sq - m5sq)*m5sq*(m3sq + m5sq)*B0fin(0,0,m5sq,mudim) - m1**4*T134fin(m5,m1,0,mudim) + m5**4*T134fin(m5,m1,0,mudim) - 2*m1sq*m5sq*T134fin(m5,m1,0,mudim) + 2*m3sq*m5sq*T134fin(m5,m1,0,mudim)))/(m1sq - m3sq)**2 - (2*(m1sq - m5sq)**3*(m3sq + m5sq)*(m3sq + m5sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) - T134fin(m5,m3,0,mudim)))/((m1sq - m3sq)**2*(m3sq - m5sq)**2))/(2.*(m1sq - m5sq)**4)
		def eval_138():
			return (2*m1sq*(-(m2sq*(m1sq + m2sq)*(m1sq - m3sq)**4) + (m1sq - m2sq)**4*m3sq*(m1sq + m3sq))*(-B0del(0,0,m1sq,mudim) + B0fin(0,0,m1sq,mudim)) + (m1sq - m2sq)**3*(m1sq - m3sq)**3*(m2sq - m3sq)*(-3 + 2*B0fin(0,0,m1sq,mudim)) - 2*m1sq*(m2sq*(m1sq - m3sq)**4*(-((m1sq + m2sq)*B0del(0,0,m2sq,mudim)) - 4*m1sq*B0fin(0,0,m2sq,mudim)) + (m1sq - m2sq)**4*m3sq*((m1sq + m3sq)*B0del(0,0,m3sq,mudim) + 4*m1sq*B0fin(0,0,m3sq,mudim))) - 2*m1sq*(-1 + B0fin(0,0,m1sq,mudim))*(m2sq*(m1sq - m3sq)**4*(-4*m1sq - (m1sq + m2sq)*B0fin(0,0,m2sq,mudim)) + (m1sq - m2sq)**4*m3sq*(4*m1sq + (m1sq + m3sq)*B0fin(0,0,m3sq,mudim))) + 2*m1sq*(m1sq - m3sq)**4*(2*(m1sq + m2sq)**2 + (-m1sq + m2sq)*(m1sq + m2sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim)) - 2*m2sq*T134fin(m2,m1,0,mudim)) - 2*m1sq*(m1sq - m2sq)**4*(2*(m1sq + m3sq)**2 + (-m1sq + m3sq)*(m1sq + m3sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim)) - 2*m3sq*T134fin(m3,m1,0,mudim)))/(2.*m1**2*(m1sq - m2sq)**4*(m1sq - m3sq)**4*(m2sq - m3sq))
		def eval_139():
			return (2*m1sq*(-(m2sq*(m1sq + m2sq)*(m1sq - m3sq)**4) + (m1sq - m2sq)**4*m3sq*(m1sq + m3sq))*(-B0del(0,0,m1sq,mudim) + B0fin(0,0,m1sq,mudim)) + (m1sq - m2sq)**3*(m1sq - m3sq)**3*(m2sq - m3sq)*(-3 + 2*B0fin(0,0,m1sq,mudim)) - 2*m1sq*(m2sq*(m1sq - m3sq)**4*(-((m1sq + m2sq)*B0del(0,0,m2sq,mudim)) - 4*m1sq*B0fin(0,0,m2sq,mudim)) + (m1sq - m2sq)**4*m3sq*((m1sq + m3sq)*B0del(0,0,m3sq,mudim) + 4*m1sq*B0fin(0,0,m3sq,mudim))) - 2*m1sq*(-1 + B0fin(0,0,m1sq,mudim))*(m2sq*(m1sq - m3sq)**4*(-4*m1sq - (m1sq + m2sq)*B0fin(0,0,m2sq,mudim)) + (m1sq - m2sq)**4*m3sq*(4*m1sq + (m1sq + m3sq)*B0fin(0,0,m3sq,mudim))) + 2*m1sq*(m1sq - m3sq)**4*(2*(m1sq + m2sq)**2 + (-m1sq + m2sq)*(m1sq + m2sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim)) - 2*m2sq*T134fin(m2,m1,0,mudim)) - 2*m1sq*(m1sq - m2sq)**4*(2*(m1sq + m3sq)**2 + (-m1sq + m3sq)*(m1sq + m3sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim)) - 2*m3sq*T134fin(m3,m1,0,mudim)))/(2.*m1**2*(m1sq - m2sq)**4*(m1sq - m3sq)**4*(m2sq - m3sq))
		def eval_140():
			return ((4*m3sq*m4sq*m6sq)/((m4sq - m5sq)*(m4sq - m6sq)**3) - (2*m3sq*m4sq*(m4sq + m6sq))/((m4sq - m5sq)*(m4sq - m6sq)**3) - (2*m3sq*m6sq*(m4sq + m6sq))/((m4sq - m5sq)*(m4sq - m6sq)**3) + (4*m3sq*m5sq*m6sq)/((m4sq - m5sq)*(-m5sq + m6sq)**3) + (2*m3sq*m5sq*(m5sq + m6sq))/((m4sq - m5sq)*(m5sq - m6sq)**3) + (2*m3sq*m6sq*(m5sq + m6sq))/((m4sq - m5sq)*(m5sq - m6sq)**3) + (2*m3sq*m4sq*B0del(0,0,m3sq,mudim))/((m4sq - m5sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) - (2*m3sq*m5sq*B0del(0,0,m3sq,mudim))/((m4sq - m5sq)*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) + (m3sq*(m3**4 + m4sq*m5sq - m6**4 - m3sq*(m4sq + m5sq - 4*m6sq))*B0del(0,0,m3sq,mudim))/((m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) - (m3sq*m6sq*(2*m3sq - m4sq - m5sq + 2*m6sq)*B0del(0,0,m3sq,mudim))/((m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) + (m4sq*m6sq*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)**2) + (m3sq*m4**4*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(-m4sq + m6sq)**3) + (m3sq*m4sq*m6sq*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(-m4sq + m6sq)**3) + (2*m3sq*m4sq*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) - (m4sq*m6sq*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) - (m3sq*m4sq*(-m4**4 + m3sq*m4sq + m6**4 - 4*m4sq*m6sq)*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)**2*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) + (m3sq*m5**4*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)**3) + (m3sq*m5sq*m6sq*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)**3) + (m5sq*m6sq*B0del(0,0,m5sq,mudim))/((-m4sq + m5sq)*(m5sq - m6sq)**2) - (2*m3sq*m5sq*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) + (m5sq*m6sq*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) + (m3sq*m5sq*(-m5**4 + m3sq*m5sq + m6**4 - 4*m5sq*m6sq)*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)**2*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) + (m3sq*m5**4*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)**3) + (m4sq*m6sq*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)**2) + (m3sq*m5sq*m6sq*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)**3) + (m5sq*m6sq*B0del(0,0,m6sq,mudim))/((-m4sq + m5sq)*(m5sq - m6sq)**2) + (m3sq*m4**4*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(-m4sq + m6sq)**3) + (m3sq*m4sq*m6sq*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(-m4sq + m6sq)**3) - (m4sq*m6sq*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) + (m5sq*m6sq*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) - (m3sq*m6sq*(2*m3sq - m4sq - m5sq + 2*m6sq)*B0del(0,0,m6sq,mudim))/((m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) - (2*m3sq*m4sq*B0fin(0,0,m3sq,mudim))/((m4sq - m5sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) + (2*m3sq*m5sq*B0fin(0,0,m3sq,mudim))/((m4sq - m5sq)*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) - (m3sq*(m3**4 + m4sq*m5sq - m6**4 - m3sq*(m4sq + m5sq - 4*m6sq))*B0fin(0,0,m3sq,mudim))/((m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) + (m3sq*m6sq*(2*m3sq - m4sq - m5sq + 2*m6sq)*B0fin(0,0,m3sq,mudim))/((m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) + (m3sq*m4**4*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)**3) - (m4sq*m6sq*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)**2) + (3*m3sq*m4sq*m6sq*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(-m4sq + m6sq)**3) - (2*m3sq*m4sq*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) + (m4sq*m6sq*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) + (m3sq*m4sq*(-m4**4 + m3sq*m4sq + m6**4 - 4*m4sq*m6sq)*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)**2*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) + (2*m3sq*m4sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) + (3*m3sq*m5sq*m6sq*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)**3) + (m5sq*m6sq*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)**2) + (m3sq*m5**4*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(-m5sq + m6sq)**3) + (2*m3sq*m5sq*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) - (m5sq*m6sq*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) - (m3sq*m5sq*(-m5**4 + m3sq*m5sq + m6**4 - 4*m5sq*m6sq)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)**2*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) - (2*m3sq*m5sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) - (m3sq*m4sq*(-m4**4 + m3sq*m4sq + m6**4 - 4*m4sq*m6sq)*(B0del(0,0,m6sq,mudim) - B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m4sq - m6sq)**2*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) + (m3sq*m5sq*(-m5**4 + m3sq*m5sq + m6**4 - 4*m5sq*m6sq)*(B0del(0,0,m6sq,mudim) - B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m5sq - m6sq)**2*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) + (m3sq*(m3**4 + m4sq*m5sq - m6**4 - m3sq*(m4sq + m5sq - 4*m6sq))*(B0del(0,0,m6sq,mudim) - B0fin(0,0,m6sq,mudim)))/((m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) + (m3sq*m4**4*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)**3) - (m4sq*m6sq*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)**2) + (3*m3sq*m5sq*m6sq*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)**3) + (m5sq*m6sq*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)**2) + (3*m3sq*m4sq*m6sq*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(-m4sq + m6sq)**3) + (m3sq*m5**4*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(-m5sq + m6sq)**3) + (m4sq*m6sq*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) - (m5sq*m6sq*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) + (m3sq*m6sq*(2*m3sq - m4sq - m5sq + 2*m6sq)*B0fin(0,0,m6sq,mudim))/((m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) + (m3sq*(m3**4 + m4sq*m5sq - m6**4 - m3sq*(m4sq + m5sq - 4*m6sq))*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim))/((m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) - (m3sq*m6sq*(2*m3sq - m4sq - m5sq + 2*m6sq)*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim))/((m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) + (m4sq*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)**2) + (m3sq*m4**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(-m4sq + m6sq)**3) + (m3sq*m4sq*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(-m4sq + m6sq)**3) - (m4sq*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) - (m3sq*m4sq*(-m4**4 + m3sq*m4sq + m6**4 - 4*m4sq*m6sq)*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m4sq - m6sq)**2*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) + (m3sq*m5**4*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)**3) + (m3sq*m5sq*m6sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)**3) + (m5sq*m6sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim))/((-m4sq + m5sq)*(m5sq - m6sq)**2) + (m5sq*m6sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) + (m3sq*m5sq*(-m5**4 + m3sq*m5sq + m6**4 - 4*m5sq*m6sq)*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)**2*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) - (2*((m4sq + m6sq)/2. + m4sq*B0fin(0,0,m4sq,mudim) + m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m4sq - m6sq)) - (m3sq*m4sq*(m4sq + m6sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m4sq - m6sq)**3) + (m3sq*m6sq*(m4sq + m6sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m4sq - m6sq)**3) + ((m3sq + m4sq - m6sq)*(m3sq + m4sq + m6sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) + (m3sq*m5sq*(m5sq + m6sq + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m5sq - m6sq)**3) + (m5sq + m6sq + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m5sq - m6sq)) - (m3sq*m6sq*(m5sq + m6sq + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m5sq - m6sq)**3) - ((m3sq + m5sq - m6sq)*(m3sq + m5sq + m6sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) + (2*m3sq*m4sq*T134fin(m6,m4,0,mudim))/((m4sq - m5sq)*(m4sq - m6sq)**3) + T134fin(m6,m4,0,mudim)/((m4sq - m5sq)*(m4sq - m6sq)) - ((m3sq + m4sq - m6sq)*T134fin(m6,m4,m3,mudim))/((m4sq - m5sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) + (2*m3sq*m5sq*T134fin(m6,m5,0,mudim))/((-m4sq + m5sq)*(m5sq - m6sq)**3) - T134fin(m6,m5,0,mudim)/((m4sq - m5sq)*(m5sq - m6sq)) + ((m3sq + m5sq - m6sq)*T134fin(m6,m5,m3,mudim))/((m4sq - m5sq)*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))))/m3**4
		def eval_141():
			return ((m4sq - m5sq)**2*(m5sq - m7sq)**2*(-6*m3sq + 4*m5sq - 2*(m3sq - 2*m5sq)*B0del(0,0,m5sq,mudim) + (6*m3sq + 4*m5sq)*B0fin(0,0,m5sq,mudim) - (m3sq - 2*m5sq)*B0fin(0,0,m5sq,mudim)**2) + 4*m3sq*(m4sq - m5sq)**2*(m5sq - m7sq)**2*(m4sq*(-(m5sq/(m4sq - m5sq)**2) + m7sq/(m4sq - m7sq)**2)*B0del(0,0,m4sq,mudim) + m4sq*(-((m5sq*B0del(0,0,m5sq,mudim))/(m4sq - m5sq)**2) + (m7sq*B0del(0,0,m7sq,mudim))/(m4sq - m7sq)**2) - m4sq*(-(m5sq/(m4sq - m5sq)**2) + m7sq/(m4sq - m7sq)**2)*B0fin(0,0,m4sq,mudim) + (m5sq*m7sq*(B0fin(0,0,m5sq,mudim) + B0fin(0,0,m7sq,mudim)))/(m5sq - m7sq)**2 - m4sq*(-((m5sq*B0fin(0,0,m5sq,mudim))/(m4sq - m5sq)**2) + (m7sq*B0fin(0,0,m7sq,mudim))/(m4sq - m7sq)**2) + m4sq*B0fin(0,0,m4sq,mudim)*(-((m5sq*B0fin(0,0,m5sq,mudim))/(m4sq - m5sq)**2) + (m7sq*B0fin(0,0,m7sq,mudim))/(m4sq - m7sq)**2) - (m5sq*m7sq*(B0del(0,0,m5sq,mudim) + B0del(0,0,m7sq,mudim) + B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim)))/(m5sq - m7sq)**2) + 2*(m5sq - m7sq)**2*(-(m3sq*(m4sq + m5sq)*(m4sq + m5sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim))) + (-(m4sq - m5sq)**2 + m3sq*(m4sq + m5sq))*T134fin(m5,m4,0,mudim)) + 2*(m4sq - m5sq)**2*(m5sq - m7sq)**2*T134fin(m5,m4,m3,mudim) - 2*(m4sq - m5sq)**2*(m5sq - m7sq)**2*T134fin(m5,m5,m3,mudim) + (2*(m4sq - m5sq)**2*(m5sq - m7sq)**2*(m3sq*(m4sq + m7sq)*(m4sq + m7sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)) + ((m4sq - m7sq)**2 - m3sq*(m4sq + m7sq))*T134fin(m7,m4,0,mudim)))/(m4sq - m7sq)**2 - 2*(m4sq - m5sq)**2*(m5sq - m7sq)**2*T134fin(m7,m4,m3,mudim) + 2*(m4sq - m5sq)**2*(-(m3sq*(m5sq + m7sq)*(m5sq + m7sq + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim))) + (-(m5sq - m7sq)**2 + m3sq*(m5sq + m7sq))*T134fin(m7,m5,0,mudim)) + 2*(m4sq - m5sq)**2*(m5sq - m7sq)**2*T134fin(m7,m5,m3,mudim))/(2.*m3**4*(m4sq - m5sq)**3*(m5sq - m7sq)**3)
		def eval_142():
			return ((-4*m3sq*m4sq*m6sq)/((m4sq - m6sq)**3*(m6sq - m7sq)) + (2*m3sq*m4sq*(m4sq + m6sq))/((m4sq - m6sq)**3*(m6sq - m7sq)) + (2*m3sq*m6sq*(m4sq + m6sq))/((m4sq - m6sq)**3*(m6sq - m7sq)) + (4*m3sq*m4sq*m7sq)/((m4sq - m7sq)**3*(m6sq - m7sq)) + (2*m3sq*m4sq*(m4sq + m7sq))/((m4sq - m7sq)**3*(-m6sq + m7sq)) + (2*m3sq*m7sq*(m4sq + m7sq))/((m4sq - m7sq)**3*(-m6sq + m7sq)) + (2*m3sq*m6sq*B0del(0,0,m3sq,mudim))/((m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) - (m3sq*m4sq*(2*m3sq + 2*m4sq - m6sq - m7sq)*B0del(0,0,m3sq,mudim))/((m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (2*m3sq*m7sq*B0del(0,0,m3sq,mudim))/((m6sq - m7sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m3sq*(m3**4 - m4**4 + m3sq*(4*m4sq - m6sq - m7sq) + m6sq*m7sq)*B0del(0,0,m3sq,mudim))/((m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m3sq*m6**4*B0del(0,0,m4sq,mudim))/((m4sq - m6sq)**3*(m6sq - m7sq)) + (m3sq*m4sq*m6sq*B0del(0,0,m4sq,mudim))/((m4sq - m6sq)**3*(m6sq - m7sq)) + (m4sq*m6sq*B0del(0,0,m4sq,mudim))/((m4sq - m6sq)**2*(m6sq - m7sq)) - (m4sq*m6sq*B0del(0,0,m4sq,mudim))/((m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m3sq*m7**4*B0del(0,0,m4sq,mudim))/((m4sq - m7sq)**3*(-m6sq + m7sq)) + (m3sq*m4sq*m7sq*B0del(0,0,m4sq,mudim))/((m4sq - m7sq)**3*(-m6sq + m7sq)) + (m4sq*m7sq*B0del(0,0,m4sq,mudim))/((m4sq - m7sq)**2*(-m6sq + m7sq)) - (m3sq*m4sq*(2*m3sq + 2*m4sq - m6sq - m7sq)*B0del(0,0,m4sq,mudim))/((m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m4sq*m7sq*B0del(0,0,m4sq,mudim))/((m6sq - m7sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m3sq*m6**4*B0del(0,0,m6sq,mudim))/((m4sq - m6sq)**3*(m6sq - m7sq)) + (m3sq*m4sq*m6sq*B0del(0,0,m6sq,mudim))/((m4sq - m6sq)**3*(m6sq - m7sq)) + (m4sq*m6sq*B0del(0,0,m6sq,mudim))/((m4sq - m6sq)**2*(m6sq - m7sq)) + (2*m3sq*m6sq*B0del(0,0,m6sq,mudim))/((m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) - (m4sq*m6sq*B0del(0,0,m6sq,mudim))/((m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) - (m3sq*m6sq*(m4**4 - m6**4 + m3sq*m6sq - 4*m4sq*m6sq)*B0del(0,0,m6sq,mudim))/((m4sq - m6sq)**2*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m3sq*m7**4*B0del(0,0,m7sq,mudim))/((m4sq - m7sq)**3*(-m6sq + m7sq)) + (m3sq*m4sq*m7sq*B0del(0,0,m7sq,mudim))/((m4sq - m7sq)**3*(-m6sq + m7sq)) + (m4sq*m7sq*B0del(0,0,m7sq,mudim))/((m4sq - m7sq)**2*(-m6sq + m7sq)) - (2*m3sq*m7sq*B0del(0,0,m7sq,mudim))/((m6sq - m7sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m4sq*m7sq*B0del(0,0,m7sq,mudim))/((m6sq - m7sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (m3sq*m7sq*(m4**4 - m7**4 + m3sq*m7sq - 4*m4sq*m7sq)*B0del(0,0,m7sq,mudim))/((m4sq - m7sq)**2*(-m6sq + m7sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (2*m3sq*m6sq*B0fin(0,0,m3sq,mudim))/((m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m3sq*m4sq*(2*m3sq + 2*m4sq - m6sq - m7sq)*B0fin(0,0,m3sq,mudim))/((m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (2*m3sq*m7sq*B0fin(0,0,m3sq,mudim))/((m6sq - m7sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (m3sq*(m3**4 - m4**4 + m3sq*(4*m4sq - m6sq - m7sq) + m6sq*m7sq)*B0fin(0,0,m3sq,mudim))/((m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (m3sq*m6sq*(m4**4 - m6**4 + m3sq*m6sq - 4*m4sq*m6sq)*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/((m4sq - m6sq)**2*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) - (m3sq*m7sq*(m4**4 - m7**4 + m3sq*m7sq - 4*m4sq*m7sq)*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/((m4sq - m7sq)**2*(-m6sq + m7sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m3sq*(m3**4 - m4**4 + m3sq*(4*m4sq - m6sq - m7sq) + m6sq*m7sq)*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/((m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (3*m3sq*m4sq*m6sq*B0fin(0,0,m4sq,mudim))/((m4sq - m6sq)**3*(m6sq - m7sq)) - (m4sq*m6sq*B0fin(0,0,m4sq,mudim))/((m4sq - m6sq)**2*(m6sq - m7sq)) + (m3sq*m6**4*B0fin(0,0,m4sq,mudim))/((-m4sq + m6sq)**3*(m6sq - m7sq)) + (m4sq*m6sq*B0fin(0,0,m4sq,mudim))/((m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m3sq*m7**4*B0fin(0,0,m4sq,mudim))/((m4sq - m7sq)**3*(m6sq - m7sq)) + (m4sq*m7sq*B0fin(0,0,m4sq,mudim))/((m4sq - m7sq)**2*(m6sq - m7sq)) + (3*m3sq*m4sq*m7sq*B0fin(0,0,m4sq,mudim))/((m4sq - m7sq)**3*(-m6sq + m7sq)) + (m3sq*m4sq*(2*m3sq + 2*m4sq - m6sq - m7sq)*B0fin(0,0,m4sq,mudim))/((m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (m4sq*m7sq*B0fin(0,0,m4sq,mudim))/((m6sq - m7sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (m3sq*m4sq*(2*m3sq + 2*m4sq - m6sq - m7sq)*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim))/((m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m3sq*(m3**4 - m4**4 + m3sq*(4*m4sq - m6sq - m7sq) + m6sq*m7sq)*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim))/((m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (3*m3sq*m4sq*m6sq*B0fin(0,0,m6sq,mudim))/((m4sq - m6sq)**3*(m6sq - m7sq)) - (m4sq*m6sq*B0fin(0,0,m6sq,mudim))/((m4sq - m6sq)**2*(m6sq - m7sq)) + (m3sq*m6**4*B0fin(0,0,m6sq,mudim))/((-m4sq + m6sq)**3*(m6sq - m7sq)) - (2*m3sq*m6sq*B0fin(0,0,m6sq,mudim))/((m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m4sq*m6sq*B0fin(0,0,m6sq,mudim))/((m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m3sq*m6sq*(m4**4 - m6**4 + m3sq*m6sq - 4*m4sq*m6sq)*B0fin(0,0,m6sq,mudim))/((m4sq - m6sq)**2*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) + (2*m3sq*m6sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim))/((m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m3sq*m6**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m6sq)**3*(m6sq - m7sq)) + (m3sq*m4sq*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m6sq)**3*(m6sq - m7sq)) + (m4sq*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m6sq)**2*(m6sq - m7sq)) - (m4sq*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) - (m3sq*m6sq*(m4**4 - m6**4 + m3sq*m6sq - 4*m4sq*m6sq)*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m6sq)**2*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) - (m3sq*m4sq*(m4sq + m6sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m6sq)**3*(m6sq - m7sq)) + (m4sq + m6sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim))/((m4sq - m6sq)*(m6sq - m7sq)) + (m3sq*m6sq*(m4sq + m6sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m6sq)**3*(m6sq - m7sq)) + ((m3sq - m4sq + m6sq)*(m3sq + m4sq + m6sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m3sq*m7**4*B0fin(0,0,m7sq,mudim))/((m4sq - m7sq)**3*(m6sq - m7sq)) + (m4sq*m7sq*B0fin(0,0,m7sq,mudim))/((m4sq - m7sq)**2*(m6sq - m7sq)) + (3*m3sq*m4sq*m7sq*B0fin(0,0,m7sq,mudim))/((m4sq - m7sq)**3*(-m6sq + m7sq)) + (2*m3sq*m7sq*B0fin(0,0,m7sq,mudim))/((m6sq - m7sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (m4sq*m7sq*B0fin(0,0,m7sq,mudim))/((m6sq - m7sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m3sq*m7sq*(m4**4 - m7**4 + m3sq*m7sq - 4*m4sq*m7sq)*B0fin(0,0,m7sq,mudim))/((m4sq - m7sq)**2*(-m6sq + m7sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (2*m3sq*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim))/((m6sq - m7sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m3sq*m7**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m4sq - m7sq)**3*(-m6sq + m7sq)) + (m3sq*m4sq*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m4sq - m7sq)**3*(-m6sq + m7sq)) + (m4sq*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m4sq - m7sq)**2*(-m6sq + m7sq)) + (m4sq*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m6sq - m7sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (m3sq*m7sq*(m4**4 - m7**4 + m3sq*m7sq - 4*m4sq*m7sq)*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m4sq - m7sq)**2*(-m6sq + m7sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (m3sq*m4sq*(m4sq + m7sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m7sq)**3*(-m6sq + m7sq)) + (m4sq + m7sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim))/((m4sq - m7sq)*(-m6sq + m7sq)) + (m3sq*m7sq*(m4sq + m7sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m7sq)**3*(-m6sq + m7sq)) - ((m3sq - m4sq + m7sq)*(m3sq + m4sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m6sq - m7sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - T134fin(m6,m4,0,mudim)/((m4sq - m6sq)*(m6sq - m7sq)) + (2*m3sq*m6sq*T134fin(m6,m4,0,mudim))/((-m4sq + m6sq)**3*(m6sq - m7sq)) - ((m3sq - m4sq + m6sq)*T134fin(m6,m4,m3,mudim))/((m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) - T134fin(m7,m4,0,mudim)/((m4sq - m7sq)*(-m6sq + m7sq)) + (2*m3sq*m7sq*T134fin(m7,m4,0,mudim))/((-m4sq + m7sq)**3*(-m6sq + m7sq)) + ((m3sq - m4sq + m7sq)*T134fin(m7,m4,m3,mudim))/((m6sq - m7sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))))/m3**4
		def eval_143():
			return ((m4sq - m5sq)**2*(m4sq - m7sq)**2*(6*m3sq - 4*m4sq + 2*(m3sq - 2*m4sq)*B0del(0,0,m4sq,mudim) - 2*(3*m3sq + 2*m4sq)*B0fin(0,0,m4sq,mudim) + (m3sq - 2*m4sq)*B0fin(0,0,m4sq,mudim)**2) + 4*m3sq*(m4sq - m5sq)**2*(m4sq - m7sq)**2*(m4sq*(m5sq/(m4sq - m5sq)**2 + m7sq/(m4sq - m7sq)**2)*B0del(0,0,m4sq,mudim) + m4sq*((m5sq*B0del(0,0,m5sq,mudim))/(m4sq - m5sq)**2 + (m7sq*B0del(0,0,m7sq,mudim))/(m4sq - m7sq)**2) - m4sq*(m5sq/(m4sq - m5sq)**2 + m7sq/(m4sq - m7sq)**2)*B0fin(0,0,m4sq,mudim) + (m5sq*m7sq*(B0fin(0,0,m5sq,mudim) + B0fin(0,0,m7sq,mudim)))/(m5sq - m7sq)**2 - m4sq*((m5sq*B0fin(0,0,m5sq,mudim))/(m4sq - m5sq)**2 + (m7sq*B0fin(0,0,m7sq,mudim))/(m4sq - m7sq)**2) + m4sq*B0fin(0,0,m4sq,mudim)*((m5sq*B0fin(0,0,m5sq,mudim))/(m4sq - m5sq)**2 + (m7sq*B0fin(0,0,m7sq,mudim))/(m4sq - m7sq)**2) - (m5sq*m7sq*(B0del(0,0,m5sq,mudim) + B0del(0,0,m7sq,mudim) + B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim)))/(m5sq - m7sq)**2) + 2*(m4sq - m5sq)**2*(m4sq - m7sq)**2*T134fin(m4,m4,m3,mudim) + 2*(m4sq - m7sq)**2*(m3sq*(m4sq + m5sq)*(m4sq + m5sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim)) + ((m4sq - m5sq)**2 - m3sq*(m4sq + m5sq))*T134fin(m5,m4,0,mudim)) - 2*(m4sq - m5sq)**2*(m4sq - m7sq)**2*T134fin(m5,m4,m3,mudim) + 2*(m4sq - m5sq)**2*(m3sq*(m4sq + m7sq)*(m4sq + m7sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)) + ((m4sq - m7sq)**2 - m3sq*(m4sq + m7sq))*T134fin(m7,m4,0,mudim)) - 2*(m4sq - m5sq)**2*(m4sq - m7sq)**2*T134fin(m7,m4,m3,mudim) + (2*(m4sq - m5sq)**2*(m4sq - m7sq)**2*(-(m3sq*(m5sq + m7sq)*(m5sq + m7sq + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim))) + (-(m5sq - m7sq)**2 + m3sq*(m5sq + m7sq))*T134fin(m7,m5,0,mudim)))/(m5sq - m7sq)**2 + 2*(m4sq - m5sq)**2*(m4sq - m7sq)**2*T134fin(m7,m5,m3,mudim))/(2.*m3**4*(m4sq - m5sq)**3*(m4sq - m7sq)**3)
		def eval_144():
			return (3*(m1sq - m2sq)*m3**4*(m1sq - m6sq)**3*(m2sq - m6sq)**3 + (m1sq - m2sq)*m6**4*(m1sq - m6sq)**3*(m2sq - m6sq)**3 - 3*m2**4*(m1sq - m3sq)*(m1sq - m6sq)**3*(m3sq - m6sq)**3 - (m1sq - m3sq)*m6**4*(m1sq - m6sq)**3*(m3sq - m6sq)**3 + 3*m1**4*(m2sq - m3sq)*(m2sq - m6sq)**3*(m3sq - m6sq)**3 + (m2sq - m3sq)*m6**4*(m2sq - m6sq)**3*(m3sq - m6sq)**3 + m1**4*(m2sq - m3sq)*(m2sq - m6sq)**3*(m3sq - m6sq)**3*B0del(0,0,m1sq,mudim) + m1sq*(m2sq - m3sq)*(m2sq - m6sq)**3*(m3sq - m6sq)**3*m6sq*B0del(0,0,m1sq,mudim) - m2**4*(m1sq - m3sq)*(m1sq - m6sq)**3*(m3sq - m6sq)**3*B0del(0,0,m2sq,mudim) - m2sq*(m1sq - m3sq)*(m1sq - m6sq)**3*(m3sq - m6sq)**3*m6sq*B0del(0,0,m2sq,mudim) + (m1sq - m2sq)*m3**4*(m1sq - m6sq)**3*(m2sq - m6sq)**3*B0del(0,0,m3sq,mudim) + (m1sq - m2sq)*m3sq*(m1sq - m6sq)**3*(m2sq - m6sq)**3*m6sq*B0del(0,0,m3sq,mudim) + (m1sq - m2sq)*m3**4*(m1sq - m6sq)**3*(m2sq - m6sq)**3*B0del(0,0,m6sq,mudim) - m2**4*(m1sq - m3sq)*(m1sq - m6sq)**3*(m3sq - m6sq)**3*B0del(0,0,m6sq,mudim) + m1**4*(m2sq - m3sq)*(m2sq - m6sq)**3*(m3sq - m6sq)**3*B0del(0,0,m6sq,mudim) + (m1sq - m2sq)*m3sq*(m1sq - m6sq)**3*(m2sq - m6sq)**3*m6sq*B0del(0,0,m6sq,mudim) - m2sq*(m1sq - m3sq)*(m1sq - m6sq)**3*(m3sq - m6sq)**3*m6sq*B0del(0,0,m6sq,mudim) + m1sq*(m2sq - m3sq)*(m2sq - m6sq)**3*(m3sq - m6sq)**3*m6sq*B0del(0,0,m6sq,mudim) + m1**4*(m2sq - m3sq)*(m2sq - m6sq)**3*(m3sq - m6sq)**3*B0fin(0,0,m1sq,mudim) + m1sq*(m2sq - m3sq)*(m2sq - m6sq)**3*(m3sq - m6sq)**3*m6sq*B0fin(0,0,m1sq,mudim) - m2**4*(m1sq - m3sq)*(m1sq - m6sq)**3*(m3sq - m6sq)**3*B0fin(0,0,m2sq,mudim) - m2sq*(m1sq - m3sq)*(m1sq - m6sq)**3*(m3sq - m6sq)**3*m6sq*B0fin(0,0,m2sq,mudim) + (m1sq - m2sq)*m3**4*(m1sq - m6sq)**3*(m2sq - m6sq)**3*B0fin(0,0,m3sq,mudim) + (m1sq - m2sq)*m3sq*(m1sq - m6sq)**3*(m2sq - m6sq)**3*m6sq*B0fin(0,0,m3sq,mudim) - (m1sq - m2sq)*m3**4*(m1sq - m6sq)**3*(m2sq - m6sq)**3*B0fin(0,0,m6sq,mudim) - 2*(m1sq - m2sq)*m6**4*(m1sq - m6sq)**3*(m2sq - m6sq)**3*B0fin(0,0,m6sq,mudim) + m2**4*(m1sq - m3sq)*(m1sq - m6sq)**3*(m3sq - m6sq)**3*B0fin(0,0,m6sq,mudim) + 2*(m1sq - m3sq)*m6**4*(m1sq - m6sq)**3*(m3sq - m6sq)**3*B0fin(0,0,m6sq,mudim) - m1**4*(m2sq - m3sq)*(m2sq - m6sq)**3*(m3sq - m6sq)**3*B0fin(0,0,m6sq,mudim) - 2*(m2sq - m3sq)*m6**4*(m2sq - m6sq)**3*(m3sq - m6sq)**3*B0fin(0,0,m6sq,mudim) + 5*(m1sq - m2sq)*m3sq*(m1sq - m6sq)**3*(m2sq - m6sq)**3*m6sq*B0fin(0,0,m6sq,mudim) - 5*m2sq*(m1sq - m3sq)*(m1sq - m6sq)**3*(m3sq - m6sq)**3*m6sq*B0fin(0,0,m6sq,mudim) + 5*m1sq*(m2sq - m3sq)*(m2sq - m6sq)**3*(m3sq - m6sq)**3*m6sq*B0fin(0,0,m6sq,mudim) + m1**4*(m2sq - m3sq)*(m2sq - m6sq)**3*(m3sq - m6sq)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + m1sq*(m2sq - m3sq)*(m2sq - m6sq)**3*(m3sq - m6sq)**3*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - m2**4*(m1sq - m3sq)*(m1sq - m6sq)**3*(m3sq - m6sq)**3*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) - m2sq*(m1sq - m3sq)*(m1sq - m6sq)**3*(m3sq - m6sq)**3*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) + (m1sq - m2sq)*m3**4*(m1sq - m6sq)**3*(m2sq - m6sq)**3*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) + (m1sq - m2sq)*m3sq*(m1sq - m6sq)**3*(m2sq - m6sq)**3*m6sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m1sq*(m2sq - m3sq)*(m2sq - m6sq)**3*(m3sq - m6sq)**3*T134fin(m6,m1,0,mudim) + 2*m2sq*(m1sq - m3sq)*(m1sq - m6sq)**3*(m3sq - m6sq)**3*T134fin(m6,m2,0,mudim) - 2*(m1sq - m2sq)*m3sq*(m1sq - m6sq)**3*(m2sq - m6sq)**3*T134fin(m6,m3,0,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m2sq - m3sq)*(m1sq - m6sq)**3*(-m2sq + m6sq)**3*(-m3sq + m6sq)**3)
		def eval_145():
			return (3*(m1sq - m2sq)*m3**4*(m1sq - m4sq)**3*(m2sq - m4sq)**3 + (m1sq - m2sq)*m4**4*(m1sq - m4sq)**3*(m2sq - m4sq)**3 - 3*m2**4*(m1sq - m3sq)*(m1sq - m4sq)**3*(m3sq - m4sq)**3 - (m1sq - m3sq)*m4**4*(m1sq - m4sq)**3*(m3sq - m4sq)**3 + 3*m1**4*(m2sq - m3sq)*(m2sq - m4sq)**3*(m3sq - m4sq)**3 + (m2sq - m3sq)*m4**4*(m2sq - m4sq)**3*(m3sq - m4sq)**3 + m1**4*(m2sq - m3sq)*(m2sq - m4sq)**3*(m3sq - m4sq)**3*B0del(0,0,m1sq,mudim) + m1sq*(m2sq - m3sq)*(m2sq - m4sq)**3*(m3sq - m4sq)**3*m4sq*B0del(0,0,m1sq,mudim) - m2**4*(m1sq - m3sq)*(m1sq - m4sq)**3*(m3sq - m4sq)**3*B0del(0,0,m2sq,mudim) - m2sq*(m1sq - m3sq)*(m1sq - m4sq)**3*(m3sq - m4sq)**3*m4sq*B0del(0,0,m2sq,mudim) + (m1sq - m2sq)*m3**4*(m1sq - m4sq)**3*(m2sq - m4sq)**3*B0del(0,0,m3sq,mudim) + (m1sq - m2sq)*m3sq*(m1sq - m4sq)**3*(m2sq - m4sq)**3*m4sq*B0del(0,0,m3sq,mudim) + (m1sq - m2sq)*m3**4*(m1sq - m4sq)**3*(m2sq - m4sq)**3*B0del(0,0,m4sq,mudim) - m2**4*(m1sq - m3sq)*(m1sq - m4sq)**3*(m3sq - m4sq)**3*B0del(0,0,m4sq,mudim) + m1**4*(m2sq - m3sq)*(m2sq - m4sq)**3*(m3sq - m4sq)**3*B0del(0,0,m4sq,mudim) + (m1sq - m2sq)*m3sq*(m1sq - m4sq)**3*(m2sq - m4sq)**3*m4sq*B0del(0,0,m4sq,mudim) - m2sq*(m1sq - m3sq)*(m1sq - m4sq)**3*(m3sq - m4sq)**3*m4sq*B0del(0,0,m4sq,mudim) + m1sq*(m2sq - m3sq)*(m2sq - m4sq)**3*(m3sq - m4sq)**3*m4sq*B0del(0,0,m4sq,mudim) + m1**4*(m2sq - m3sq)*(m2sq - m4sq)**3*(m3sq - m4sq)**3*B0fin(0,0,m1sq,mudim) + m1sq*(m2sq - m3sq)*(m2sq - m4sq)**3*(m3sq - m4sq)**3*m4sq*B0fin(0,0,m1sq,mudim) - m2**4*(m1sq - m3sq)*(m1sq - m4sq)**3*(m3sq - m4sq)**3*B0fin(0,0,m2sq,mudim) - m2sq*(m1sq - m3sq)*(m1sq - m4sq)**3*(m3sq - m4sq)**3*m4sq*B0fin(0,0,m2sq,mudim) + (m1sq - m2sq)*m3**4*(m1sq - m4sq)**3*(m2sq - m4sq)**3*B0fin(0,0,m3sq,mudim) + (m1sq - m2sq)*m3sq*(m1sq - m4sq)**3*(m2sq - m4sq)**3*m4sq*B0fin(0,0,m3sq,mudim) - (m1sq - m2sq)*m3**4*(m1sq - m4sq)**3*(m2sq - m4sq)**3*B0fin(0,0,m4sq,mudim) - 2*(m1sq - m2sq)*m4**4*(m1sq - m4sq)**3*(m2sq - m4sq)**3*B0fin(0,0,m4sq,mudim) + m2**4*(m1sq - m3sq)*(m1sq - m4sq)**3*(m3sq - m4sq)**3*B0fin(0,0,m4sq,mudim) + 2*(m1sq - m3sq)*m4**4*(m1sq - m4sq)**3*(m3sq - m4sq)**3*B0fin(0,0,m4sq,mudim) - m1**4*(m2sq - m3sq)*(m2sq - m4sq)**3*(m3sq - m4sq)**3*B0fin(0,0,m4sq,mudim) - 2*(m2sq - m3sq)*m4**4*(m2sq - m4sq)**3*(m3sq - m4sq)**3*B0fin(0,0,m4sq,mudim) + 5*(m1sq - m2sq)*m3sq*(m1sq - m4sq)**3*(m2sq - m4sq)**3*m4sq*B0fin(0,0,m4sq,mudim) - 5*m2sq*(m1sq - m3sq)*(m1sq - m4sq)**3*(m3sq - m4sq)**3*m4sq*B0fin(0,0,m4sq,mudim) + 5*m1sq*(m2sq - m3sq)*(m2sq - m4sq)**3*(m3sq - m4sq)**3*m4sq*B0fin(0,0,m4sq,mudim) + m1**4*(m2sq - m3sq)*(m2sq - m4sq)**3*(m3sq - m4sq)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + m1sq*(m2sq - m3sq)*(m2sq - m4sq)**3*(m3sq - m4sq)**3*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - m2**4*(m1sq - m3sq)*(m1sq - m4sq)**3*(m3sq - m4sq)**3*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - m2sq*(m1sq - m3sq)*(m1sq - m4sq)**3*(m3sq - m4sq)**3*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + (m1sq - m2sq)*m3**4*(m1sq - m4sq)**3*(m2sq - m4sq)**3*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + (m1sq - m2sq)*m3sq*(m1sq - m4sq)**3*(m2sq - m4sq)**3*m4sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) - 2*m1sq*(m2sq - m3sq)*(m2sq - m4sq)**3*(m3sq - m4sq)**3*T134fin(m4,m1,0,mudim) + 2*m2sq*(m1sq - m3sq)*(m1sq - m4sq)**3*(m3sq - m4sq)**3*T134fin(m4,m2,0,mudim) - 2*(m1sq - m2sq)*m3sq*(m1sq - m4sq)**3*(m2sq - m4sq)**3*T134fin(m4,m3,0,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m2sq - m3sq)*(m1sq - m4sq)**3*(-m2sq + m4sq)**3*(-m3sq + m4sq)**3)
		def eval_146():
			return (((m3sq - m7sq)**2*(6 + 2*B0del(0,0,m3sq,mudim) - 6*B0fin(0,0,m3sq,mudim) + B0fin(0,0,m3sq,mudim)**2))/((m1sq - m3sq)*(-m2sq + m3sq)) - 4*((m1sq*m3sq*(m3sq - m7sq)**2*(B0fin(0,0,m1sq,mudim) + B0fin(0,0,m3sq,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)**3) - (m2sq*m3sq*(m3sq - m7sq)**2*(B0fin(0,0,m2sq,mudim) + B0fin(0,0,m3sq,mudim)))/((m1sq - m2sq)*(m2sq - m3sq)**3) - (m1sq*(m3sq - m7sq)**2*m7sq*(B0fin(0,0,m1sq,mudim) + B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)*(m1sq - m7sq)**2) + (m2sq*(m3sq - m7sq)**2*m7sq*(B0fin(0,0,m2sq,mudim) + B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)*(m2sq - m3sq)*(m2sq - m7sq)**2) + (m3sq*m7sq*(B0fin(0,0,m3sq,mudim) + B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq))) + 4*((m1sq*m3sq*(m3sq - m7sq)**2*(B0del(0,0,m1sq,mudim) + B0del(0,0,m3sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)**3) - (m2sq*m3sq*(m3sq - m7sq)**2*(B0del(0,0,m2sq,mudim) + B0del(0,0,m3sq,mudim) + B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim)))/((m1sq - m2sq)*(m2sq - m3sq)**3) - (m1sq*(m3sq - m7sq)**2*m7sq*(B0del(0,0,m1sq,mudim) + B0del(0,0,m7sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)*(m1sq - m7sq)**2) + (m2sq*(m3sq - m7sq)**2*m7sq*(B0del(0,0,m2sq,mudim) + B0del(0,0,m7sq,mudim) + B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)*(m2sq - m3sq)*(m2sq - m7sq)**2) + (m3sq*m7sq*(B0del(0,0,m3sq,mudim) + B0del(0,0,m7sq,mudim) + B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq))) + (2*(m1sq + m3sq)*(m3sq - m7sq)**2*(m1sq + m3sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,m1,0,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)**3) - (2*(m2sq + m3sq)*(m3sq - m7sq)**2*(m2sq + m3sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,m2,0,mudim)))/((m1sq - m2sq)*(m2sq - m3sq)**3) - (2*(m3sq - m7sq)**2*(m1sq + m7sq)*(m1sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim) - T134fin(m7,m1,0,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)*(m1sq - m7sq)**2) + (2*(m3sq - m7sq)**2*(m2sq + m7sq)*(m2sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim) - T134fin(m7,m2,0,mudim)))/((m1sq - m2sq)*(m2sq - m3sq)*(m2sq - m7sq)**2) + (2*(m3sq + m7sq)*(m3sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim) - T134fin(m7,m3,0,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)))/(2.*(m3sq - m7sq)**3)
		def eval_147():
			return (((m3sq - m5sq)**2*(6 + 2*B0del(0,0,m3sq,mudim) - 6*B0fin(0,0,m3sq,mudim) + B0fin(0,0,m3sq,mudim)**2))/((m1sq - m3sq)*(-m2sq + m3sq)) - 4*((m1sq*m3sq*(m3sq - m5sq)**2*(B0fin(0,0,m1sq,mudim) + B0fin(0,0,m3sq,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)**3) - (m2sq*m3sq*(m3sq - m5sq)**2*(B0fin(0,0,m2sq,mudim) + B0fin(0,0,m3sq,mudim)))/((m1sq - m2sq)*(m2sq - m3sq)**3) - (m1sq*(m3sq - m5sq)**2*m5sq*(B0fin(0,0,m1sq,mudim) + B0fin(0,0,m5sq,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)*(m1sq - m5sq)**2) + (m2sq*(m3sq - m5sq)**2*m5sq*(B0fin(0,0,m2sq,mudim) + B0fin(0,0,m5sq,mudim)))/((m1sq - m2sq)*(m2sq - m3sq)*(m2sq - m5sq)**2) + (m3sq*m5sq*(B0fin(0,0,m3sq,mudim) + B0fin(0,0,m5sq,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq))) + 4*((m1sq*m3sq*(m3sq - m5sq)**2*(B0del(0,0,m1sq,mudim) + B0del(0,0,m3sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)**3) - (m2sq*m3sq*(m3sq - m5sq)**2*(B0del(0,0,m2sq,mudim) + B0del(0,0,m3sq,mudim) + B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim)))/((m1sq - m2sq)*(m2sq - m3sq)**3) - (m1sq*(m3sq - m5sq)**2*m5sq*(B0del(0,0,m1sq,mudim) + B0del(0,0,m5sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)*(m1sq - m5sq)**2) + (m2sq*(m3sq - m5sq)**2*m5sq*(B0del(0,0,m2sq,mudim) + B0del(0,0,m5sq,mudim) + B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim)))/((m1sq - m2sq)*(m2sq - m3sq)*(m2sq - m5sq)**2) + (m3sq*m5sq*(B0del(0,0,m3sq,mudim) + B0del(0,0,m5sq,mudim) + B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq))) + (2*(m1sq + m3sq)*(m3sq - m5sq)**2*(m1sq + m3sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,m1,0,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)**3) - (2*(m2sq + m3sq)*(m3sq - m5sq)**2*(m2sq + m3sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,m2,0,mudim)))/((m1sq - m2sq)*(m2sq - m3sq)**3) - (2*(m3sq - m5sq)**2*(m1sq + m5sq)*(m1sq + m5sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) - T134fin(m5,m1,0,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)*(m1sq - m5sq)**2) + (2*(m3sq - m5sq)**2*(m2sq + m5sq)*(m2sq + m5sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) - T134fin(m5,m2,0,mudim)))/((m1sq - m2sq)*(m2sq - m3sq)*(m2sq - m5sq)**2) + (2*(m3sq + m5sq)*(m3sq + m5sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) - T134fin(m5,m3,0,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)))/(2.*(m3sq - m5sq)**3)
		def eval_148():
			return (m1**4/((m1sq - m6sq)**2*(m6sq - m7sq)) + m6**4/((m1sq - m6sq)**2*(m6sq - m7sq)) + (m1sq*m2**4)/((m2sq - m6sq)**3*(m6sq - m7sq)) - (2*m2**6)/((m2sq - m6sq)**3*(m6sq - m7sq)) + (3*m1sq*m6**4)/((m2sq - m6sq)**3*(m6sq - m7sq)) - (2*m2sq*m6**4)/((m2sq - m6sq)**3*(m6sq - m7sq)) + m6**6/((m2sq - m6sq)**3*(m6sq - m7sq)) + (2*m1sq*m6sq)/((m1sq - m6sq)**2*(m6sq - m7sq)) - (m2**4*m6sq)/((m2sq - m6sq)**3*(m6sq - m7sq)) + (m1sq*m2**4)/((m2sq - m7sq)**3*(m6sq - m7sq)) + (m1sq*m2sq*m7sq)/((m2sq - m7sq)**3*(m6sq - m7sq)) + m1**4/((m1sq - m7sq)**2*(-m6sq + m7sq)) + m7**4/((m1sq - m7sq)**2*(-m6sq + m7sq)) + (2*m1sq*m2**4)/((m2sq - m7sq)**3*(-m6sq + m7sq)) - (2*m2**6)/((m2sq - m7sq)**3*(-m6sq + m7sq)) + (3*m1sq*m7**4)/((m2sq - m7sq)**3*(-m6sq + m7sq)) - (2*m2sq*m7**4)/((m2sq - m7sq)**3*(-m6sq + m7sq)) + m7**6/((m2sq - m7sq)**3*(-m6sq + m7sq)) + (2*m1sq*m7sq)/((m1sq - m7sq)**2*(-m6sq + m7sq)) - (m2**4*m7sq)/((m2sq - m7sq)**3*(-m6sq + m7sq)) + (m1sq*m2sq*m7sq)/((m2sq - m7sq)**3*(-m6sq + m7sq)) + (2*m1sq*(m1**4 - m6sq*m7sq)*B0del(0,0,m1sq,mudim))/((m1sq - m6sq)**2*(m1sq - m7sq)**2) + ((-3*m2**10 + m2sq*m6**4*m7**4 + 6*m2**6*m6sq*m7sq + m2**8*(m6sq + m7sq) - 3*m2**4*m6sq*m7sq*(m6sq + m7sq) + m1sq*(m2**8 + m6**4*m7**4 - 6*m2**4*m6sq*m7sq + m2**6*(m6sq + m7sq) + m2sq*m6sq*m7sq*(m6sq + m7sq)))*B0del(0,0,m2sq,mudim))/((m2sq - m6sq)**3*(m2sq - m7sq)**3) + (m1sq*m6**4*B0del(0,0,m6sq,mudim))/((m2sq - m6sq)**3*(m6sq - m7sq)) + (m2sq*m6**4*B0del(0,0,m6sq,mudim))/((m2sq - m6sq)**3*(m6sq - m7sq)) + (2*m1sq*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m6sq)**2*(m6sq - m7sq)) - (3*m2**4*m6sq*B0del(0,0,m6sq,mudim))/((m2sq - m6sq)**3*(m6sq - m7sq)) + (m1sq*m2sq*m6sq*B0del(0,0,m6sq,mudim))/((m2sq - m6sq)**3*(m6sq - m7sq)) + (m1sq*m7**4*B0del(0,0,m7sq,mudim))/((m2sq - m7sq)**3*(-m6sq + m7sq)) + (m2sq*m7**4*B0del(0,0,m7sq,mudim))/((m2sq - m7sq)**3*(-m6sq + m7sq)) + (2*m1sq*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m7sq)**2*(-m6sq + m7sq)) - (3*m2**4*m7sq*B0del(0,0,m7sq,mudim))/((m2sq - m7sq)**3*(-m6sq + m7sq)) + (m1sq*m2sq*m7sq*B0del(0,0,m7sq,mudim))/((m2sq - m7sq)**3*(-m6sq + m7sq)) + (2*m1**4*B0fin(0,0,m1sq,mudim))/((m1sq - m6sq)**2*(m6sq - m7sq)) + (2*m1**4*B0fin(0,0,m1sq,mudim))/((m1sq - m7sq)**2*(-m6sq + m7sq)) - (2*m1sq*m2**4*B0fin(0,0,m2sq,mudim))/((m2sq - m6sq)**3*(m6sq - m7sq)) + (m2sq*m6**4*B0fin(0,0,m2sq,mudim))/((m2sq - m6sq)**3*(m6sq - m7sq)) - (3*m2**4*m6sq*B0fin(0,0,m2sq,mudim))/((m2sq - m6sq)**3*(m6sq - m7sq)) + (5*m1sq*m2sq*m6sq*B0fin(0,0,m2sq,mudim))/((m2sq - m6sq)**3*(m6sq - m7sq)) + (m1sq*m6**4*B0fin(0,0,m2sq,mudim))/((-m2sq + m6sq)**3*(m6sq - m7sq)) + (2*m1sq*m2**4*B0fin(0,0,m2sq,mudim))/((m2sq - m7sq)**3*(m6sq - m7sq)) + (m2sq*m7**4*B0fin(0,0,m2sq,mudim))/((m2sq - m7sq)**3*(-m6sq + m7sq)) - (3*m2**4*m7sq*B0fin(0,0,m2sq,mudim))/((m2sq - m7sq)**3*(-m6sq + m7sq)) + (5*m1sq*m2sq*m7sq*B0fin(0,0,m2sq,mudim))/((m2sq - m7sq)**3*(-m6sq + m7sq)) + (m1sq*m7**4*B0fin(0,0,m2sq,mudim))/((-m2sq + m7sq)**3*(-m6sq + m7sq)) + (2*m6**4*B0fin(0,0,m6sq,mudim))/((m1sq - m6sq)**2*(m6sq - m7sq)) + (m1sq*m6**4*B0fin(0,0,m6sq,mudim))/((m2sq - m6sq)**3*(m6sq - m7sq)) - (3*m2sq*m6**4*B0fin(0,0,m6sq,mudim))/((m2sq - m6sq)**3*(m6sq - m7sq)) + (2*m6**6*B0fin(0,0,m6sq,mudim))/((m2sq - m6sq)**3*(m6sq - m7sq)) - (m2**4*m6sq*B0fin(0,0,m6sq,mudim))/((m2sq - m6sq)**3*(m6sq - m7sq)) + (m1sq*m2sq*m6sq*B0fin(0,0,m6sq,mudim))/((m2sq - m6sq)**3*(m6sq - m7sq)) + (2*m1sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m6sq)**2*(m6sq - m7sq)) + (m1sq*m6**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m2sq - m6sq)**3*(m6sq - m7sq)) + (m2sq*m6**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m2sq - m6sq)**3*(m6sq - m7sq)) - (3*m2**4*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m2sq - m6sq)**3*(m6sq - m7sq)) + (m1sq*m2sq*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m2sq - m6sq)**3*(m6sq - m7sq)) + (2*m1sq*m2sq*m7sq*B0fin(0,0,m7sq,mudim))/((m2sq - m7sq)**3*(m6sq - m7sq)) + (2*m7**4*B0fin(0,0,m7sq,mudim))/((m1sq - m7sq)**2*(-m6sq + m7sq)) + (m1sq*m7**4*B0fin(0,0,m7sq,mudim))/((m2sq - m7sq)**3*(-m6sq + m7sq)) - (3*m2sq*m7**4*B0fin(0,0,m7sq,mudim))/((m2sq - m7sq)**3*(-m6sq + m7sq)) + (2*m7**6*B0fin(0,0,m7sq,mudim))/((m2sq - m7sq)**3*(-m6sq + m7sq)) - (m2**4*m7sq*B0fin(0,0,m7sq,mudim))/((m2sq - m7sq)**3*(-m6sq + m7sq)) + (3*m1sq*m2sq*m7sq*B0fin(0,0,m7sq,mudim))/((m2sq - m7sq)**3*(-m6sq + m7sq)) + (2*m1sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m7sq)**2*(-m6sq + m7sq)) + (m1sq*m7**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2sq - m7sq)**3*(-m6sq + m7sq)) + (m2sq*m7**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2sq - m7sq)**3*(-m6sq + m7sq)) - (3*m2**4*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2sq - m7sq)**3*(-m6sq + m7sq)) + (m1sq*m2sq*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2sq - m7sq)**3*(-m6sq + m7sq)) - (m1sq*T134fin(m6,m1,0,mudim))/((m1sq - m6sq)**2*(m6sq - m7sq)) - (m6sq*T134fin(m6,m1,0,mudim))/((m1sq - m6sq)**2*(m6sq - m7sq)) + (m2**4*T134fin(m6,m2,0,mudim))/((m2sq - m6sq)**3*(m6sq - m7sq)) + (2*m2sq*m6sq*T134fin(m6,m2,0,mudim))/((m2sq - m6sq)**3*(m6sq - m7sq)) + (m6**4*T134fin(m6,m2,0,mudim))/((-m2sq + m6sq)**3*(m6sq - m7sq)) + (2*m1sq*m6sq*T134fin(m6,m2,0,mudim))/((-m2sq + m6sq)**3*(m6sq - m7sq)) + (m1sq*T134fin(m7,m1,0,mudim))/((m1sq - m7sq)**2*(m6sq - m7sq)) + (m7sq*T134fin(m7,m1,0,mudim))/((m1sq - m7sq)**2*(m6sq - m7sq)) + (m2**4*T134fin(m7,m2,0,mudim))/((m2sq - m7sq)**3*(-m6sq + m7sq)) + (2*m2sq*m7sq*T134fin(m7,m2,0,mudim))/((m2sq - m7sq)**3*(-m6sq + m7sq)) + (m7**4*T134fin(m7,m2,0,mudim))/((-m2sq + m7sq)**3*(-m6sq + m7sq)) + (2*m1sq*m7sq*T134fin(m7,m2,0,mudim))/((-m2sq + m7sq)**3*(-m6sq + m7sq)))/(m1sq - m2sq)**2
		def eval_149():
			return (((m2sq - m7sq)**2*(6 + 2*B0del(0,0,m2sq,mudim) - 6*B0fin(0,0,m2sq,mudim) + B0fin(0,0,m2sq,mudim)**2))/((m1sq - m2sq)*(m2sq - m3sq)) - 4*((m1sq*m2sq*(m2sq - m7sq)**2*(B0fin(0,0,m1sq,mudim) + B0fin(0,0,m2sq,mudim)))/((m1sq - m2sq)**3*(m1sq - m3sq)) - (m2sq*m3sq*(m2sq - m7sq)**2*(B0fin(0,0,m2sq,mudim) + B0fin(0,0,m3sq,mudim)))/((m2sq - m3sq)**3*(-m1sq + m3sq)) - (m1sq*(m2sq - m7sq)**2*m7sq*(B0fin(0,0,m1sq,mudim) + B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)*(m1sq - m7sq)**2) + (m2sq*m7sq*(B0fin(0,0,m2sq,mudim) + B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)*(m2sq - m3sq)) + (m3sq*(m2sq - m7sq)**2*m7sq*(B0fin(0,0,m3sq,mudim) + B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3sq - m7sq)**2)) + 4*((m1sq*m2sq*(m2sq - m7sq)**2*(B0del(0,0,m1sq,mudim) + B0del(0,0,m2sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim)))/((m1sq - m2sq)**3*(m1sq - m3sq)) - (m2sq*m3sq*(m2sq - m7sq)**2*(B0del(0,0,m2sq,mudim) + B0del(0,0,m3sq,mudim) + B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim)))/((m2sq - m3sq)**3*(-m1sq + m3sq)) - (m1sq*(m2sq - m7sq)**2*m7sq*(B0del(0,0,m1sq,mudim) + B0del(0,0,m7sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)*(m1sq - m7sq)**2) + (m2sq*m7sq*(B0del(0,0,m2sq,mudim) + B0del(0,0,m7sq,mudim) + B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)*(m2sq - m3sq)) + (m3sq*(m2sq - m7sq)**2*m7sq*(B0del(0,0,m3sq,mudim) + B0del(0,0,m7sq,mudim) + B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3sq - m7sq)**2)) + (2*(m1sq + m2sq)*(m2sq - m7sq)**2*(m1sq + m2sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim) - T134fin(m2,m1,0,mudim)))/((m1sq - m2sq)**3*(m1sq - m3sq)) - (2*(m2sq + m3sq)*(m2sq - m7sq)**2*(m2sq + m3sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,m2,0,mudim)))/((m2sq - m3sq)**3*(-m1sq + m3sq)) - (2*(m2sq - m7sq)**2*(m1sq + m7sq)*(m1sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim) - T134fin(m7,m1,0,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)*(m1sq - m7sq)**2) + (2*(m2sq + m7sq)*(m2sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim) - T134fin(m7,m2,0,mudim)))/((m1sq - m2sq)*(m2sq - m3sq)) + (2*(m2sq - m7sq)**2*(m3sq + m7sq)*(m3sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim) - T134fin(m7,m3,0,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3sq - m7sq)**2))/(2.*(m2sq - m7sq)**3)
		def eval_150():
			return (m1**4/((m1sq - m4sq)**2*(m4sq - m5sq)) + m4**4/((m1sq - m4sq)**2*(m4sq - m5sq)) + (m1sq*m2**4)/((m2sq - m4sq)**3*(m4sq - m5sq)) - (2*m2**6)/((m2sq - m4sq)**3*(m4sq - m5sq)) + (3*m1sq*m4**4)/((m2sq - m4sq)**3*(m4sq - m5sq)) - (2*m2sq*m4**4)/((m2sq - m4sq)**3*(m4sq - m5sq)) + m4**6/((m2sq - m4sq)**3*(m4sq - m5sq)) + (2*m1sq*m4sq)/((m1sq - m4sq)**2*(m4sq - m5sq)) - (m2**4*m4sq)/((m2sq - m4sq)**3*(m4sq - m5sq)) + (m1sq*m2**4)/((m2sq - m5sq)**3*(m4sq - m5sq)) + (m1sq*m2sq*m5sq)/((m2sq - m5sq)**3*(m4sq - m5sq)) + m1**4/((m1sq - m5sq)**2*(-m4sq + m5sq)) + m5**4/((m1sq - m5sq)**2*(-m4sq + m5sq)) + (2*m1sq*m2**4)/((m2sq - m5sq)**3*(-m4sq + m5sq)) - (2*m2**6)/((m2sq - m5sq)**3*(-m4sq + m5sq)) + (3*m1sq*m5**4)/((m2sq - m5sq)**3*(-m4sq + m5sq)) - (2*m2sq*m5**4)/((m2sq - m5sq)**3*(-m4sq + m5sq)) + m5**6/((m2sq - m5sq)**3*(-m4sq + m5sq)) + (2*m1sq*m5sq)/((m1sq - m5sq)**2*(-m4sq + m5sq)) - (m2**4*m5sq)/((m2sq - m5sq)**3*(-m4sq + m5sq)) + (m1sq*m2sq*m5sq)/((m2sq - m5sq)**3*(-m4sq + m5sq)) + (2*m1sq*(m1**4 - m4sq*m5sq)*B0del(0,0,m1sq,mudim))/((m1sq - m4sq)**2*(m1sq - m5sq)**2) + ((-3*m2**10 + m2sq*m4**4*m5**4 + 6*m2**6*m4sq*m5sq + m2**8*(m4sq + m5sq) - 3*m2**4*m4sq*m5sq*(m4sq + m5sq) + m1sq*(m2**8 + m4**4*m5**4 - 6*m2**4*m4sq*m5sq + m2**6*(m4sq + m5sq) + m2sq*m4sq*m5sq*(m4sq + m5sq)))*B0del(0,0,m2sq,mudim))/((m2sq - m4sq)**3*(m2sq - m5sq)**3) + (m1sq*m4**4*B0del(0,0,m4sq,mudim))/((m2sq - m4sq)**3*(m4sq - m5sq)) + (m2sq*m4**4*B0del(0,0,m4sq,mudim))/((m2sq - m4sq)**3*(m4sq - m5sq)) + (2*m1sq*m4sq*B0del(0,0,m4sq,mudim))/((m1sq - m4sq)**2*(m4sq - m5sq)) - (3*m2**4*m4sq*B0del(0,0,m4sq,mudim))/((m2sq - m4sq)**3*(m4sq - m5sq)) + (m1sq*m2sq*m4sq*B0del(0,0,m4sq,mudim))/((m2sq - m4sq)**3*(m4sq - m5sq)) + (m1sq*m5**4*B0del(0,0,m5sq,mudim))/((m2sq - m5sq)**3*(-m4sq + m5sq)) + (m2sq*m5**4*B0del(0,0,m5sq,mudim))/((m2sq - m5sq)**3*(-m4sq + m5sq)) + (2*m1sq*m5sq*B0del(0,0,m5sq,mudim))/((m1sq - m5sq)**2*(-m4sq + m5sq)) - (3*m2**4*m5sq*B0del(0,0,m5sq,mudim))/((m2sq - m5sq)**3*(-m4sq + m5sq)) + (m1sq*m2sq*m5sq*B0del(0,0,m5sq,mudim))/((m2sq - m5sq)**3*(-m4sq + m5sq)) + (2*m1**4*B0fin(0,0,m1sq,mudim))/((m1sq - m4sq)**2*(m4sq - m5sq)) + (2*m1**4*B0fin(0,0,m1sq,mudim))/((m1sq - m5sq)**2*(-m4sq + m5sq)) - (2*m1sq*m2**4*B0fin(0,0,m2sq,mudim))/((m2sq - m4sq)**3*(m4sq - m5sq)) + (m2sq*m4**4*B0fin(0,0,m2sq,mudim))/((m2sq - m4sq)**3*(m4sq - m5sq)) - (3*m2**4*m4sq*B0fin(0,0,m2sq,mudim))/((m2sq - m4sq)**3*(m4sq - m5sq)) + (5*m1sq*m2sq*m4sq*B0fin(0,0,m2sq,mudim))/((m2sq - m4sq)**3*(m4sq - m5sq)) + (m1sq*m4**4*B0fin(0,0,m2sq,mudim))/((-m2sq + m4sq)**3*(m4sq - m5sq)) + (2*m1sq*m2**4*B0fin(0,0,m2sq,mudim))/((m2sq - m5sq)**3*(m4sq - m5sq)) + (m2sq*m5**4*B0fin(0,0,m2sq,mudim))/((m2sq - m5sq)**3*(-m4sq + m5sq)) - (3*m2**4*m5sq*B0fin(0,0,m2sq,mudim))/((m2sq - m5sq)**3*(-m4sq + m5sq)) + (5*m1sq*m2sq*m5sq*B0fin(0,0,m2sq,mudim))/((m2sq - m5sq)**3*(-m4sq + m5sq)) + (m1sq*m5**4*B0fin(0,0,m2sq,mudim))/((-m2sq + m5sq)**3*(-m4sq + m5sq)) + (2*m4**4*B0fin(0,0,m4sq,mudim))/((m1sq - m4sq)**2*(m4sq - m5sq)) + (m1sq*m4**4*B0fin(0,0,m4sq,mudim))/((m2sq - m4sq)**3*(m4sq - m5sq)) - (3*m2sq*m4**4*B0fin(0,0,m4sq,mudim))/((m2sq - m4sq)**3*(m4sq - m5sq)) + (2*m4**6*B0fin(0,0,m4sq,mudim))/((m2sq - m4sq)**3*(m4sq - m5sq)) - (m2**4*m4sq*B0fin(0,0,m4sq,mudim))/((m2sq - m4sq)**3*(m4sq - m5sq)) + (m1sq*m2sq*m4sq*B0fin(0,0,m4sq,mudim))/((m2sq - m4sq)**3*(m4sq - m5sq)) + (2*m1sq*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m4sq)**2*(m4sq - m5sq)) + (m1sq*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m2sq - m4sq)**3*(m4sq - m5sq)) + (m2sq*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m2sq - m4sq)**3*(m4sq - m5sq)) - (3*m2**4*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m2sq - m4sq)**3*(m4sq - m5sq)) + (m1sq*m2sq*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m2sq - m4sq)**3*(m4sq - m5sq)) + (2*m1sq*m2sq*m5sq*B0fin(0,0,m5sq,mudim))/((m2sq - m5sq)**3*(m4sq - m5sq)) + (2*m5**4*B0fin(0,0,m5sq,mudim))/((m1sq - m5sq)**2*(-m4sq + m5sq)) + (m1sq*m5**4*B0fin(0,0,m5sq,mudim))/((m2sq - m5sq)**3*(-m4sq + m5sq)) - (3*m2sq*m5**4*B0fin(0,0,m5sq,mudim))/((m2sq - m5sq)**3*(-m4sq + m5sq)) + (2*m5**6*B0fin(0,0,m5sq,mudim))/((m2sq - m5sq)**3*(-m4sq + m5sq)) - (m2**4*m5sq*B0fin(0,0,m5sq,mudim))/((m2sq - m5sq)**3*(-m4sq + m5sq)) + (3*m1sq*m2sq*m5sq*B0fin(0,0,m5sq,mudim))/((m2sq - m5sq)**3*(-m4sq + m5sq)) + (2*m1sq*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1sq - m5sq)**2*(-m4sq + m5sq)) + (m1sq*m5**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim))/((m2sq - m5sq)**3*(-m4sq + m5sq)) + (m2sq*m5**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim))/((m2sq - m5sq)**3*(-m4sq + m5sq)) - (3*m2**4*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim))/((m2sq - m5sq)**3*(-m4sq + m5sq)) + (m1sq*m2sq*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim))/((m2sq - m5sq)**3*(-m4sq + m5sq)) - (m1sq*T134fin(m4,m1,0,mudim))/((m1sq - m4sq)**2*(m4sq - m5sq)) - (m4sq*T134fin(m4,m1,0,mudim))/((m1sq - m4sq)**2*(m4sq - m5sq)) + (m2**4*T134fin(m4,m2,0,mudim))/((m2sq - m4sq)**3*(m4sq - m5sq)) + (2*m2sq*m4sq*T134fin(m4,m2,0,mudim))/((m2sq - m4sq)**3*(m4sq - m5sq)) + (m4**4*T134fin(m4,m2,0,mudim))/((-m2sq + m4sq)**3*(m4sq - m5sq)) + (2*m1sq*m4sq*T134fin(m4,m2,0,mudim))/((-m2sq + m4sq)**3*(m4sq - m5sq)) + (m1sq*T134fin(m5,m1,0,mudim))/((m1sq - m5sq)**2*(m4sq - m5sq)) + (m5sq*T134fin(m5,m1,0,mudim))/((m1sq - m5sq)**2*(m4sq - m5sq)) + (m2**4*T134fin(m5,m2,0,mudim))/((m2sq - m5sq)**3*(-m4sq + m5sq)) + (2*m2sq*m5sq*T134fin(m5,m2,0,mudim))/((m2sq - m5sq)**3*(-m4sq + m5sq)) + (m5**4*T134fin(m5,m2,0,mudim))/((-m2sq + m5sq)**3*(-m4sq + m5sq)) + (2*m1sq*m5sq*T134fin(m5,m2,0,mudim))/((-m2sq + m5sq)**3*(-m4sq + m5sq)))/(m1sq - m2sq)**2
		def eval_151():
			return (((m2sq - m5sq)**2*(6 + 2*B0del(0,0,m2sq,mudim) - 6*B0fin(0,0,m2sq,mudim) + B0fin(0,0,m2sq,mudim)**2))/((m1sq - m2sq)*(m2sq - m3sq)) - 4*((m1sq*m2sq*(m2sq - m5sq)**2*(B0fin(0,0,m1sq,mudim) + B0fin(0,0,m2sq,mudim)))/((m1sq - m2sq)**3*(m1sq - m3sq)) - (m2sq*m3sq*(m2sq - m5sq)**2*(B0fin(0,0,m2sq,mudim) + B0fin(0,0,m3sq,mudim)))/((m2sq - m3sq)**3*(-m1sq + m3sq)) - (m1sq*(m2sq - m5sq)**2*m5sq*(B0fin(0,0,m1sq,mudim) + B0fin(0,0,m5sq,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)*(m1sq - m5sq)**2) + (m2sq*m5sq*(B0fin(0,0,m2sq,mudim) + B0fin(0,0,m5sq,mudim)))/((m1sq - m2sq)*(m2sq - m3sq)) + (m3sq*(m2sq - m5sq)**2*m5sq*(B0fin(0,0,m3sq,mudim) + B0fin(0,0,m5sq,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3sq - m5sq)**2)) + 4*((m1sq*m2sq*(m2sq - m5sq)**2*(B0del(0,0,m1sq,mudim) + B0del(0,0,m2sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim)))/((m1sq - m2sq)**3*(m1sq - m3sq)) - (m2sq*m3sq*(m2sq - m5sq)**2*(B0del(0,0,m2sq,mudim) + B0del(0,0,m3sq,mudim) + B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim)))/((m2sq - m3sq)**3*(-m1sq + m3sq)) - (m1sq*(m2sq - m5sq)**2*m5sq*(B0del(0,0,m1sq,mudim) + B0del(0,0,m5sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)*(m1sq - m5sq)**2) + (m2sq*m5sq*(B0del(0,0,m2sq,mudim) + B0del(0,0,m5sq,mudim) + B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim)))/((m1sq - m2sq)*(m2sq - m3sq)) + (m3sq*(m2sq - m5sq)**2*m5sq*(B0del(0,0,m3sq,mudim) + B0del(0,0,m5sq,mudim) + B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3sq - m5sq)**2)) + (2*(m1sq + m2sq)*(m2sq - m5sq)**2*(m1sq + m2sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim) - T134fin(m2,m1,0,mudim)))/((m1sq - m2sq)**3*(m1sq - m3sq)) - (2*(m2sq + m3sq)*(m2sq - m5sq)**2*(m2sq + m3sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,m2,0,mudim)))/((m2sq - m3sq)**3*(-m1sq + m3sq)) - (2*(m2sq - m5sq)**2*(m1sq + m5sq)*(m1sq + m5sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) - T134fin(m5,m1,0,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)*(m1sq - m5sq)**2) + (2*(m2sq + m5sq)*(m2sq + m5sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) - T134fin(m5,m2,0,mudim)))/((m1sq - m2sq)*(m2sq - m3sq)) + (2*(m2sq - m5sq)**2*(m3sq + m5sq)*(m3sq + m5sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) - T134fin(m5,m3,0,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3sq - m5sq)**2))/(2.*(m2sq - m5sq)**3)
		def eval_152():
			return ((-2*m1**6)/((m1sq - m6sq)**3*(m6sq - m7sq)) + (m1**4*m3sq)/((m1sq - m6sq)**3*(m6sq - m7sq)) - (2*m1sq*m6**4)/((m1sq - m6sq)**3*(m6sq - m7sq)) + (3*m3sq*m6**4)/((m1sq - m6sq)**3*(m6sq - m7sq)) + m6**6/((m1sq - m6sq)**3*(m6sq - m7sq)) + m3**4/((m3sq - m6sq)**2*(m6sq - m7sq)) + m6**4/((m3sq - m6sq)**2*(m6sq - m7sq)) - (m1**4*m6sq)/((m1sq - m6sq)**3*(m6sq - m7sq)) + (2*m3sq*m6sq)/((m3sq - m6sq)**2*(m6sq - m7sq)) + (m1**4*m3sq)/((m1sq - m7sq)**3*(m6sq - m7sq)) + (m1sq*m3sq*m7sq)/((m1sq - m7sq)**3*(m6sq - m7sq)) - (2*m1**6)/((m1sq - m7sq)**3*(-m6sq + m7sq)) + (2*m1**4*m3sq)/((m1sq - m7sq)**3*(-m6sq + m7sq)) - (2*m1sq*m7**4)/((m1sq - m7sq)**3*(-m6sq + m7sq)) + (3*m3sq*m7**4)/((m1sq - m7sq)**3*(-m6sq + m7sq)) + m7**6/((m1sq - m7sq)**3*(-m6sq + m7sq)) + m3**4/((m3sq - m7sq)**2*(-m6sq + m7sq)) + m7**4/((m3sq - m7sq)**2*(-m6sq + m7sq)) - (m1**4*m7sq)/((m1sq - m7sq)**3*(-m6sq + m7sq)) + (m1sq*m3sq*m7sq)/((m1sq - m7sq)**3*(-m6sq + m7sq)) + (2*m3sq*m7sq)/((m3sq - m7sq)**2*(-m6sq + m7sq)) - ((3*m1**10 - m3sq*m6**4*m7**4 - m1**8*(m3sq + m6sq + m7sq) + 3*m1**4*m6sq*m7sq*(2*m3sq + m6sq + m7sq) - m1**6*(6*m6sq*m7sq + m3sq*(m6sq + m7sq)) - m1sq*(m6**4*m7**4 + m3sq*m6sq*m7sq*(m6sq + m7sq)))*B0del(0,0,m1sq,mudim))/((m1sq - m6sq)**3*(m1sq - m7sq)**3) + (2*(m3**6 - m3sq*m6sq*m7sq)*B0del(0,0,m3sq,mudim))/((m3sq - m6sq)**2*(m3sq - m7sq)**2) + (m1sq*m6**4*B0del(0,0,m6sq,mudim))/((m1sq - m6sq)**3*(m6sq - m7sq)) + (m3sq*m6**4*B0del(0,0,m6sq,mudim))/((m1sq - m6sq)**3*(m6sq - m7sq)) - (3*m1**4*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m6sq)**3*(m6sq - m7sq)) + (m1sq*m3sq*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m6sq)**3*(m6sq - m7sq)) + (2*m3sq*m6sq*B0del(0,0,m6sq,mudim))/((m3sq - m6sq)**2*(m6sq - m7sq)) + (m1sq*m7**4*B0del(0,0,m7sq,mudim))/((m1sq - m7sq)**3*(-m6sq + m7sq)) + (m3sq*m7**4*B0del(0,0,m7sq,mudim))/((m1sq - m7sq)**3*(-m6sq + m7sq)) - (3*m1**4*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m7sq)**3*(-m6sq + m7sq)) + (m1sq*m3sq*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m7sq)**3*(-m6sq + m7sq)) + (2*m3sq*m7sq*B0del(0,0,m7sq,mudim))/((m3sq - m7sq)**2*(-m6sq + m7sq)) - (2*m1**4*m3sq*B0fin(0,0,m1sq,mudim))/((m1sq - m6sq)**3*(m6sq - m7sq)) + (m1sq*m6**4*B0fin(0,0,m1sq,mudim))/((m1sq - m6sq)**3*(m6sq - m7sq)) - (3*m1**4*m6sq*B0fin(0,0,m1sq,mudim))/((m1sq - m6sq)**3*(m6sq - m7sq)) + (5*m1sq*m3sq*m6sq*B0fin(0,0,m1sq,mudim))/((m1sq - m6sq)**3*(m6sq - m7sq)) + (m3sq*m6**4*B0fin(0,0,m1sq,mudim))/((-m1sq + m6sq)**3*(m6sq - m7sq)) + (2*m1**4*m3sq*B0fin(0,0,m1sq,mudim))/((m1sq - m7sq)**3*(m6sq - m7sq)) + (m1sq*m7**4*B0fin(0,0,m1sq,mudim))/((m1sq - m7sq)**3*(-m6sq + m7sq)) - (3*m1**4*m7sq*B0fin(0,0,m1sq,mudim))/((m1sq - m7sq)**3*(-m6sq + m7sq)) + (5*m1sq*m3sq*m7sq*B0fin(0,0,m1sq,mudim))/((m1sq - m7sq)**3*(-m6sq + m7sq)) + (m3sq*m7**4*B0fin(0,0,m1sq,mudim))/((-m1sq + m7sq)**3*(-m6sq + m7sq)) + (2*m3**4*B0fin(0,0,m3sq,mudim))/((m3sq - m6sq)**2*(m6sq - m7sq)) + (2*m3**4*B0fin(0,0,m3sq,mudim))/((m3sq - m7sq)**2*(-m6sq + m7sq)) - (3*m1sq*m6**4*B0fin(0,0,m6sq,mudim))/((m1sq - m6sq)**3*(m6sq - m7sq)) + (m3sq*m6**4*B0fin(0,0,m6sq,mudim))/((m1sq - m6sq)**3*(m6sq - m7sq)) + (2*m6**6*B0fin(0,0,m6sq,mudim))/((m1sq - m6sq)**3*(m6sq - m7sq)) + (2*m6**4*B0fin(0,0,m6sq,mudim))/((m3sq - m6sq)**2*(m6sq - m7sq)) - (m1**4*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m6sq)**3*(m6sq - m7sq)) + (m1sq*m3sq*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m6sq)**3*(m6sq - m7sq)) + (m1sq*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m6sq)**3*(m6sq - m7sq)) + (m3sq*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m6sq)**3*(m6sq - m7sq)) - (3*m1**4*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m6sq)**3*(m6sq - m7sq)) + (m1sq*m3sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m6sq)**3*(m6sq - m7sq)) + (2*m3sq*m6sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim))/((m3sq - m6sq)**2*(m6sq - m7sq)) + (2*m1sq*m3sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m7sq)**3*(m6sq - m7sq)) - (3*m1sq*m7**4*B0fin(0,0,m7sq,mudim))/((m1sq - m7sq)**3*(-m6sq + m7sq)) + (m3sq*m7**4*B0fin(0,0,m7sq,mudim))/((m1sq - m7sq)**3*(-m6sq + m7sq)) + (2*m7**6*B0fin(0,0,m7sq,mudim))/((m1sq - m7sq)**3*(-m6sq + m7sq)) + (2*m7**4*B0fin(0,0,m7sq,mudim))/((m3sq - m7sq)**2*(-m6sq + m7sq)) - (m1**4*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m7sq)**3*(-m6sq + m7sq)) + (3*m1sq*m3sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m7sq)**3*(-m6sq + m7sq)) + (m1sq*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m7sq)**3*(-m6sq + m7sq)) + (m3sq*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m7sq)**3*(-m6sq + m7sq)) - (3*m1**4*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m7sq)**3*(-m6sq + m7sq)) + (m1sq*m3sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m7sq)**3*(-m6sq + m7sq)) + (2*m3sq*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim))/((m3sq - m7sq)**2*(-m6sq + m7sq)) + (m1**4*T134fin(m6,m1,0,mudim))/((m1sq - m6sq)**3*(m6sq - m7sq)) + (2*m1sq*m6sq*T134fin(m6,m1,0,mudim))/((m1sq - m6sq)**3*(m6sq - m7sq)) + (m6**4*T134fin(m6,m1,0,mudim))/((-m1sq + m6sq)**3*(m6sq - m7sq)) + (2*m3sq*m6sq*T134fin(m6,m1,0,mudim))/((-m1sq + m6sq)**3*(m6sq - m7sq)) - (m3sq*T134fin(m6,m3,0,mudim))/((m3sq - m6sq)**2*(m6sq - m7sq)) - (m6sq*T134fin(m6,m3,0,mudim))/((m3sq - m6sq)**2*(m6sq - m7sq)) + (m1**4*T134fin(m7,m1,0,mudim))/((m1sq - m7sq)**3*(-m6sq + m7sq)) + (2*m1sq*m7sq*T134fin(m7,m1,0,mudim))/((m1sq - m7sq)**3*(-m6sq + m7sq)) + (m7**4*T134fin(m7,m1,0,mudim))/((-m1sq + m7sq)**3*(-m6sq + m7sq)) + (2*m3sq*m7sq*T134fin(m7,m1,0,mudim))/((-m1sq + m7sq)**3*(-m6sq + m7sq)) + (m3sq*T134fin(m7,m3,0,mudim))/((m3sq - m7sq)**2*(m6sq - m7sq)) + (m7sq*T134fin(m7,m3,0,mudim))/((m3sq - m7sq)**2*(m6sq - m7sq)))/(m1sq - m3sq)**2
		def eval_153():
			return -0.5*(((m1sq - m7sq)**2*(6 + 2*B0del(0,0,m1sq,mudim) - 6*B0fin(0,0,m1sq,mudim) + B0fin(0,0,m1sq,mudim)**2))/((m1sq - m2sq)*(m1sq - m3sq)) - (4*m1sq*m2sq*(m1sq - m7sq)**2*(B0fin(0,0,m1sq,mudim) + B0fin(0,0,m2sq,mudim)))/((m1sq - m2sq)**3*(m2sq - m3sq)) + (4*m1sq*m2sq*(m1sq - m7sq)**2*(B0del(0,0,m1sq,mudim) + B0del(0,0,m2sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim)))/((m1sq - m2sq)**3*(m2sq - m3sq)) - (4*m1sq*m3sq*(m1sq - m7sq)**2*(B0fin(0,0,m1sq,mudim) + B0fin(0,0,m3sq,mudim)))/((m1sq - m3sq)**3*(-m2sq + m3sq)) + (4*m1sq*m3sq*(m1sq - m7sq)**2*(B0del(0,0,m1sq,mudim) + B0del(0,0,m3sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim)))/((m1sq - m3sq)**3*(-m2sq + m3sq)) - (4*m1sq*m7sq*(B0fin(0,0,m1sq,mudim) + B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)) + (4*m2sq*(m1sq - m7sq)**2*m7sq*(B0fin(0,0,m2sq,mudim) + B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)*(m2sq - m3sq)*(m2sq - m7sq)**2) + (4*m3sq*(m1sq - m7sq)**2*m7sq*(B0fin(0,0,m3sq,mudim) + B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3sq - m7sq)**2) + (4*m1sq*m7sq*(B0del(0,0,m1sq,mudim) + B0del(0,0,m7sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)) - (4*m2sq*(m1sq - m7sq)**2*m7sq*(B0del(0,0,m2sq,mudim) + B0del(0,0,m7sq,mudim) + B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)*(m2sq - m3sq)*(m2sq - m7sq)**2) - (4*m3sq*(m1sq - m7sq)**2*m7sq*(B0del(0,0,m3sq,mudim) + B0del(0,0,m7sq,mudim) + B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3sq - m7sq)**2) + (2*(m1sq + m2sq)*(m1sq - m7sq)**2*(m1sq + m2sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim) - T134fin(m2,m1,0,mudim)))/((m1sq - m2sq)**3*(m2sq - m3sq)) + (2*(m1sq + m3sq)*(m1sq - m7sq)**2*(m1sq + m3sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,m1,0,mudim)))/((m1sq - m3sq)**3*(-m2sq + m3sq)) + (2*(m1sq + m7sq)*(m1sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim) - T134fin(m7,m1,0,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)) - (2*(m1sq - m7sq)**2*(m2sq + m7sq)*(m2sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim) - T134fin(m7,m2,0,mudim)))/((m1sq - m2sq)*(m2sq - m3sq)*(m2sq - m7sq)**2) - (2*(m1sq - m7sq)**2*(m3sq + m7sq)*(m3sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim) - T134fin(m7,m3,0,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3sq - m7sq)**2))/(m1sq - m7sq)**3
		def eval_154():
			return ((-2*m1**6)/((m1sq - m4sq)**3*(m4sq - m5sq)) + (m1**4*m3sq)/((m1sq - m4sq)**3*(m4sq - m5sq)) - (2*m1sq*m4**4)/((m1sq - m4sq)**3*(m4sq - m5sq)) + (3*m3sq*m4**4)/((m1sq - m4sq)**3*(m4sq - m5sq)) + m4**6/((m1sq - m4sq)**3*(m4sq - m5sq)) + m3**4/((m3sq - m4sq)**2*(m4sq - m5sq)) + m4**4/((m3sq - m4sq)**2*(m4sq - m5sq)) - (m1**4*m4sq)/((m1sq - m4sq)**3*(m4sq - m5sq)) + (2*m3sq*m4sq)/((m3sq - m4sq)**2*(m4sq - m5sq)) + (m1**4*m3sq)/((m1sq - m5sq)**3*(m4sq - m5sq)) + (m1sq*m3sq*m5sq)/((m1sq - m5sq)**3*(m4sq - m5sq)) - (2*m1**6)/((m1sq - m5sq)**3*(-m4sq + m5sq)) + (2*m1**4*m3sq)/((m1sq - m5sq)**3*(-m4sq + m5sq)) - (2*m1sq*m5**4)/((m1sq - m5sq)**3*(-m4sq + m5sq)) + (3*m3sq*m5**4)/((m1sq - m5sq)**3*(-m4sq + m5sq)) + m5**6/((m1sq - m5sq)**3*(-m4sq + m5sq)) + m3**4/((m3sq - m5sq)**2*(-m4sq + m5sq)) + m5**4/((m3sq - m5sq)**2*(-m4sq + m5sq)) - (m1**4*m5sq)/((m1sq - m5sq)**3*(-m4sq + m5sq)) + (m1sq*m3sq*m5sq)/((m1sq - m5sq)**3*(-m4sq + m5sq)) + (2*m3sq*m5sq)/((m3sq - m5sq)**2*(-m4sq + m5sq)) - ((3*m1**10 - m3sq*m4**4*m5**4 - m1**8*(m3sq + m4sq + m5sq) + 3*m1**4*m4sq*m5sq*(2*m3sq + m4sq + m5sq) - m1**6*(6*m4sq*m5sq + m3sq*(m4sq + m5sq)) - m1sq*(m4**4*m5**4 + m3sq*m4sq*m5sq*(m4sq + m5sq)))*B0del(0,0,m1sq,mudim))/((m1sq - m4sq)**3*(m1sq - m5sq)**3) + (2*(m3**6 - m3sq*m4sq*m5sq)*B0del(0,0,m3sq,mudim))/((m3sq - m4sq)**2*(m3sq - m5sq)**2) + (m1sq*m4**4*B0del(0,0,m4sq,mudim))/((m1sq - m4sq)**3*(m4sq - m5sq)) + (m3sq*m4**4*B0del(0,0,m4sq,mudim))/((m1sq - m4sq)**3*(m4sq - m5sq)) - (3*m1**4*m4sq*B0del(0,0,m4sq,mudim))/((m1sq - m4sq)**3*(m4sq - m5sq)) + (m1sq*m3sq*m4sq*B0del(0,0,m4sq,mudim))/((m1sq - m4sq)**3*(m4sq - m5sq)) + (2*m3sq*m4sq*B0del(0,0,m4sq,mudim))/((m3sq - m4sq)**2*(m4sq - m5sq)) + (m1sq*m5**4*B0del(0,0,m5sq,mudim))/((m1sq - m5sq)**3*(-m4sq + m5sq)) + (m3sq*m5**4*B0del(0,0,m5sq,mudim))/((m1sq - m5sq)**3*(-m4sq + m5sq)) - (3*m1**4*m5sq*B0del(0,0,m5sq,mudim))/((m1sq - m5sq)**3*(-m4sq + m5sq)) + (m1sq*m3sq*m5sq*B0del(0,0,m5sq,mudim))/((m1sq - m5sq)**3*(-m4sq + m5sq)) + (2*m3sq*m5sq*B0del(0,0,m5sq,mudim))/((m3sq - m5sq)**2*(-m4sq + m5sq)) - (2*m1**4*m3sq*B0fin(0,0,m1sq,mudim))/((m1sq - m4sq)**3*(m4sq - m5sq)) + (m1sq*m4**4*B0fin(0,0,m1sq,mudim))/((m1sq - m4sq)**3*(m4sq - m5sq)) - (3*m1**4*m4sq*B0fin(0,0,m1sq,mudim))/((m1sq - m4sq)**3*(m4sq - m5sq)) + (5*m1sq*m3sq*m4sq*B0fin(0,0,m1sq,mudim))/((m1sq - m4sq)**3*(m4sq - m5sq)) + (m3sq*m4**4*B0fin(0,0,m1sq,mudim))/((-m1sq + m4sq)**3*(m4sq - m5sq)) + (2*m1**4*m3sq*B0fin(0,0,m1sq,mudim))/((m1sq - m5sq)**3*(m4sq - m5sq)) + (m1sq*m5**4*B0fin(0,0,m1sq,mudim))/((m1sq - m5sq)**3*(-m4sq + m5sq)) - (3*m1**4*m5sq*B0fin(0,0,m1sq,mudim))/((m1sq - m5sq)**3*(-m4sq + m5sq)) + (5*m1sq*m3sq*m5sq*B0fin(0,0,m1sq,mudim))/((m1sq - m5sq)**3*(-m4sq + m5sq)) + (m3sq*m5**4*B0fin(0,0,m1sq,mudim))/((-m1sq + m5sq)**3*(-m4sq + m5sq)) + (2*m3**4*B0fin(0,0,m3sq,mudim))/((m3sq - m4sq)**2*(m4sq - m5sq)) + (2*m3**4*B0fin(0,0,m3sq,mudim))/((m3sq - m5sq)**2*(-m4sq + m5sq)) - (3*m1sq*m4**4*B0fin(0,0,m4sq,mudim))/((m1sq - m4sq)**3*(m4sq - m5sq)) + (m3sq*m4**4*B0fin(0,0,m4sq,mudim))/((m1sq - m4sq)**3*(m4sq - m5sq)) + (2*m4**6*B0fin(0,0,m4sq,mudim))/((m1sq - m4sq)**3*(m4sq - m5sq)) + (2*m4**4*B0fin(0,0,m4sq,mudim))/((m3sq - m4sq)**2*(m4sq - m5sq)) - (m1**4*m4sq*B0fin(0,0,m4sq,mudim))/((m1sq - m4sq)**3*(m4sq - m5sq)) + (m1sq*m3sq*m4sq*B0fin(0,0,m4sq,mudim))/((m1sq - m4sq)**3*(m4sq - m5sq)) + (m1sq*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m4sq)**3*(m4sq - m5sq)) + (m3sq*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m4sq)**3*(m4sq - m5sq)) - (3*m1**4*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m4sq)**3*(m4sq - m5sq)) + (m1sq*m3sq*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m4sq)**3*(m4sq - m5sq)) + (2*m3sq*m4sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim))/((m3sq - m4sq)**2*(m4sq - m5sq)) + (2*m1sq*m3sq*m5sq*B0fin(0,0,m5sq,mudim))/((m1sq - m5sq)**3*(m4sq - m5sq)) - (3*m1sq*m5**4*B0fin(0,0,m5sq,mudim))/((m1sq - m5sq)**3*(-m4sq + m5sq)) + (m3sq*m5**4*B0fin(0,0,m5sq,mudim))/((m1sq - m5sq)**3*(-m4sq + m5sq)) + (2*m5**6*B0fin(0,0,m5sq,mudim))/((m1sq - m5sq)**3*(-m4sq + m5sq)) + (2*m5**4*B0fin(0,0,m5sq,mudim))/((m3sq - m5sq)**2*(-m4sq + m5sq)) - (m1**4*m5sq*B0fin(0,0,m5sq,mudim))/((m1sq - m5sq)**3*(-m4sq + m5sq)) + (3*m1sq*m3sq*m5sq*B0fin(0,0,m5sq,mudim))/((m1sq - m5sq)**3*(-m4sq + m5sq)) + (m1sq*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1sq - m5sq)**3*(-m4sq + m5sq)) + (m3sq*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1sq - m5sq)**3*(-m4sq + m5sq)) - (3*m1**4*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1sq - m5sq)**3*(-m4sq + m5sq)) + (m1sq*m3sq*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1sq - m5sq)**3*(-m4sq + m5sq)) + (2*m3sq*m5sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim))/((m3sq - m5sq)**2*(-m4sq + m5sq)) + (m1**4*T134fin(m4,m1,0,mudim))/((m1sq - m4sq)**3*(m4sq - m5sq)) + (2*m1sq*m4sq*T134fin(m4,m1,0,mudim))/((m1sq - m4sq)**3*(m4sq - m5sq)) + (m4**4*T134fin(m4,m1,0,mudim))/((-m1sq + m4sq)**3*(m4sq - m5sq)) + (2*m3sq*m4sq*T134fin(m4,m1,0,mudim))/((-m1sq + m4sq)**3*(m4sq - m5sq)) - (m3sq*T134fin(m4,m3,0,mudim))/((m3sq - m4sq)**2*(m4sq - m5sq)) - (m4sq*T134fin(m4,m3,0,mudim))/((m3sq - m4sq)**2*(m4sq - m5sq)) + (m1**4*T134fin(m5,m1,0,mudim))/((m1sq - m5sq)**3*(-m4sq + m5sq)) + (2*m1sq*m5sq*T134fin(m5,m1,0,mudim))/((m1sq - m5sq)**3*(-m4sq + m5sq)) + (m5**4*T134fin(m5,m1,0,mudim))/((-m1sq + m5sq)**3*(-m4sq + m5sq)) + (2*m3sq*m5sq*T134fin(m5,m1,0,mudim))/((-m1sq + m5sq)**3*(-m4sq + m5sq)) + (m3sq*T134fin(m5,m3,0,mudim))/((m3sq - m5sq)**2*(m4sq - m5sq)) + (m5sq*T134fin(m5,m3,0,mudim))/((m3sq - m5sq)**2*(m4sq - m5sq)))/(m1sq - m3sq)**2
		def eval_155():
			return -0.5*(((m1sq - m5sq)**2*(6 + 2*B0del(0,0,m1sq,mudim) - 6*B0fin(0,0,m1sq,mudim) + B0fin(0,0,m1sq,mudim)**2))/((m1sq - m2sq)*(m1sq - m3sq)) - (4*m1sq*m2sq*(m1sq - m5sq)**2*(B0fin(0,0,m1sq,mudim) + B0fin(0,0,m2sq,mudim)))/((m1sq - m2sq)**3*(m2sq - m3sq)) + (4*m1sq*m2sq*(m1sq - m5sq)**2*(B0del(0,0,m1sq,mudim) + B0del(0,0,m2sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim)))/((m1sq - m2sq)**3*(m2sq - m3sq)) - (4*m1sq*m3sq*(m1sq - m5sq)**2*(B0fin(0,0,m1sq,mudim) + B0fin(0,0,m3sq,mudim)))/((m1sq - m3sq)**3*(-m2sq + m3sq)) + (4*m1sq*m3sq*(m1sq - m5sq)**2*(B0del(0,0,m1sq,mudim) + B0del(0,0,m3sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim)))/((m1sq - m3sq)**3*(-m2sq + m3sq)) - (4*m1sq*m5sq*(B0fin(0,0,m1sq,mudim) + B0fin(0,0,m5sq,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)) + (4*m2sq*(m1sq - m5sq)**2*m5sq*(B0fin(0,0,m2sq,mudim) + B0fin(0,0,m5sq,mudim)))/((m1sq - m2sq)*(m2sq - m3sq)*(m2sq - m5sq)**2) + (4*m3sq*(m1sq - m5sq)**2*m5sq*(B0fin(0,0,m3sq,mudim) + B0fin(0,0,m5sq,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3sq - m5sq)**2) + (4*m1sq*m5sq*(B0del(0,0,m1sq,mudim) + B0del(0,0,m5sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)) - (4*m2sq*(m1sq - m5sq)**2*m5sq*(B0del(0,0,m2sq,mudim) + B0del(0,0,m5sq,mudim) + B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim)))/((m1sq - m2sq)*(m2sq - m3sq)*(m2sq - m5sq)**2) - (4*m3sq*(m1sq - m5sq)**2*m5sq*(B0del(0,0,m3sq,mudim) + B0del(0,0,m5sq,mudim) + B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3sq - m5sq)**2) + (2*(m1sq + m2sq)*(m1sq - m5sq)**2*(m1sq + m2sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim) - T134fin(m2,m1,0,mudim)))/((m1sq - m2sq)**3*(m2sq - m3sq)) + (2*(m1sq + m3sq)*(m1sq - m5sq)**2*(m1sq + m3sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,m1,0,mudim)))/((m1sq - m3sq)**3*(-m2sq + m3sq)) + (2*(m1sq + m5sq)*(m1sq + m5sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) - T134fin(m5,m1,0,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)) - (2*(m1sq - m5sq)**2*(m2sq + m5sq)*(m2sq + m5sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) - T134fin(m5,m2,0,mudim)))/((m1sq - m2sq)*(m2sq - m3sq)*(m2sq - m5sq)**2) - (2*(m1sq - m5sq)**2*(m3sq + m5sq)*(m3sq + m5sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) - T134fin(m5,m3,0,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3sq - m5sq)**2))/(m1sq - m5sq)**3
		def eval_156():
			return -((m2**8 + 56*m2**4*m4**4 - 104*m2sq*m4**6 + 48*m4**8 - 10*m2**6*m4sq + 4*m2sq*m4sq*(m2**4 + 6*m4**4 - 4*m2sq*m4sq)*B0del(0,0,m2sq,mudim) + 8*m4**4*(m2**4 + 6*m4**4 - 4*m2sq*m4sq)*B0del(0,0,m4sq,mudim) + 20*m2**4*m4**4*B0fin(0,0,m2sq,mudim) - 24*m2sq*m4**6*B0fin(0,0,m2sq,mudim) - 2*m2**6*m4sq*B0fin(0,0,m2sq,mudim) - 28*m2**4*m4**4*B0fin(0,0,m4sq,mudim) + 16*m2sq*m4**6*B0fin(0,0,m4sq,mudim) + 48*m4**8*B0fin(0,0,m4sq,mudim) + 6*m2**6*m4sq*B0fin(0,0,m4sq,mudim) - 16*m2**4*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 24*m2sq*m4**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 4*m2**6*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 12*m2**4*m4**4*B0fin(0,0,m4sq,mudim)**2 - 28*m2sq*m4**6*B0fin(0,0,m4sq,mudim)**2 + 24*m4**8*B0fin(0,0,m4sq,mudim)**2 - 2*m2**6*m4sq*B0fin(0,0,m4sq,mudim)**2 + 16*m2sq*m4**4*T134fin(m4,m4,m2,mudim) - 24*m4**6*T134fin(m4,m4,m2,mudim) - 4*m2**4*m4sq*T134fin(m4,m4,m2,mudim))/(m2**6*m4**2*(m2sq - 4*m4sq)**3))
		def eval_157():
			return (24*m2**12 + 388*m2**8*m4**4 - 338*m2**6*m4**6 + 542*m2**4*m4**8 - 136*m2sq*m4**10 + 8*m4**12 - 164*m2**10*m4sq + 2*m2sq*(12*m2**10 + 206*m2**6*m4**4 - 120*m2**4*m4**6 + 85*m2sq*m4**8 - 14*m4**10 - 88*m2**8*m4sq)*B0del(0,0,m2sq,mudim) + 2*m4sq*(6*m2**10 - 49*m2**6*m4**4 + 186*m2**4*m4**6 - 54*m2sq*m4**8 + 4*m4**10 - 12*m2**8*m4sq)*B0del(0,0,m4sq,mudim) + 24*m2**12*B0fin(0,0,m2sq,mudim) + 514*m2**8*m4**4*B0fin(0,0,m2sq,mudim) - 240*m2**6*m4**6*B0fin(0,0,m2sq,mudim) + 68*m2**4*m4**8*B0fin(0,0,m2sq,mudim) - 4*m2sq*m4**10*B0fin(0,0,m2sq,mudim) - 200*m2**10*m4sq*B0fin(0,0,m2sq,mudim) + 12*m2**12*B0fin(0,0,m2sq,mudim)**2 + 306*m2**8*m4**4*B0fin(0,0,m2sq,mudim)**2 - 240*m2**6*m4**6*B0fin(0,0,m2sq,mudim)**2 + 32*m2**4*m4**8*B0fin(0,0,m2sq,mudim)**2 - 110*m2**10*m4sq*B0fin(0,0,m2sq,mudim)**2 - 126*m2**8*m4**4*B0fin(0,0,m4sq,mudim) - 98*m2**6*m4**6*B0fin(0,0,m4sq,mudim) + 474*m2**4*m4**8*B0fin(0,0,m4sq,mudim) - 132*m2sq*m4**10*B0fin(0,0,m4sq,mudim) + 8*m4**12*B0fin(0,0,m4sq,mudim) + 36*m2**10*m4sq*B0fin(0,0,m4sq,mudim) - 200*m2**8*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 240*m2**6*m4**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 106*m2**4*m4**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 28*m2sq*m4**10*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 44*m2**10*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 88*m2**8*m4**4*B0fin(0,0,m4sq,mudim)**2 - 169*m2**6*m4**6*B0fin(0,0,m4sq,mudim)**2 + 133*m2**4*m4**8*B0fin(0,0,m4sq,mudim)**2 - 40*m2sq*m4**10*B0fin(0,0,m4sq,mudim)**2 + 4*m4**12*B0fin(0,0,m4sq,mudim)**2 - 16*m2**10*m4sq*B0fin(0,0,m4sq,mudim)**2 + 272*m2**6*m4**4*T134fin(m4,m2,0,mudim) - 642*m2**4*m4**6*T134fin(m4,m2,0,mudim) + 272*m2sq*m4**8*T134fin(m4,m2,0,mudim) - 32*m4**10*T134fin(m4,m2,0,mudim) - 32*m2**8*m4sq*T134fin(m4,m2,0,mudim) - 12*m2**10*T134fin(m4,m2,m2,mudim) - 398*m2**6*m4**4*T134fin(m4,m2,m2,mudim) + 498*m2**4*m4**6*T134fin(m4,m2,m2,mudim) - 240*m2sq*m4**8*T134fin(m4,m2,m2,mudim) + 32*m4**10*T134fin(m4,m2,m2,mudim) + 120*m2**8*m4sq*T134fin(m4,m2,m2,mudim) + 112*m2**6*m4**4*T134fin(m4,m4,m2,mudim) - 114*m2**4*m4**6*T134fin(m4,m4,m2,mudim) + 38*m2sq*m4**8*T134fin(m4,m4,m2,mudim) - 4*m4**10*T134fin(m4,m4,m2,mudim) - 32*m2**8*m4sq*T134fin(m4,m4,m2,mudim))/(2.*m2**4*(4*m2**6*m4 - 21*m2**4*m4**3 + 21*m2sq*m4**5 - 4*m4**7)**2)
		def eval_158():
			return ((128*m1**8 - 48*m1**4*m7**4 + 12*m1sq*m7**6 - m7**8 - 64*m1**6*m7sq)*B0del(0,0,m1sq,mudim) + 8*(16*m1**8 + 24*m1**4*m7**4 - 10*m1sq*m7**6 + m7**8 - 40*m1**6*m7sq + 8*m1**4*(m1sq - m7sq)*m7sq*B0del(0,0,m7sq,mudim) + 4*m1**4*(2*m1**4 + m7**4 - 3*m1sq*m7sq)*B0fin(0,0,m1sq,mudim)**2 - 12*m1**4*m7**4*B0fin(0,0,m7sq,mudim) + 2*m1sq*m7**6*B0fin(0,0,m7sq,mudim) - 8*m1**6*m7sq*B0fin(0,0,m7sq,mudim) + 2*B0fin(0,0,m1sq,mudim)*(8*m1**8 + 2*m1**4*m7**4 - m1sq*m7**6 + 4*m1**4*(m1sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim)) - 8*m1**6*T134fin(m7,m1,m1,mudim) + 8*m1**4*m7sq*T134fin(m7,m1,m1,mudim)))/(32.*m1**4*m7**4*(4*m1sq - m7sq)**3)
		def eval_159():
			return ((128*m1**8 - 48*m1**4*m5**4 + 12*m1sq*m5**6 - m5**8 - 64*m1**6*m5sq)*B0del(0,0,m1sq,mudim) + 8*(16*m1**8 + 24*m1**4*m5**4 - 10*m1sq*m5**6 + m5**8 - 40*m1**6*m5sq + 8*m1**4*(m1sq - m5sq)*m5sq*B0del(0,0,m5sq,mudim) + 4*m1**4*(2*m1**4 + m5**4 - 3*m1sq*m5sq)*B0fin(0,0,m1sq,mudim)**2 - 12*m1**4*m5**4*B0fin(0,0,m5sq,mudim) + 2*m1sq*m5**6*B0fin(0,0,m5sq,mudim) - 8*m1**6*m5sq*B0fin(0,0,m5sq,mudim) + 2*B0fin(0,0,m1sq,mudim)*(8*m1**8 + 2*m1**4*m5**4 - m1sq*m5**6 + 4*m1**4*(m1sq - m5sq)*m5sq*B0fin(0,0,m5sq,mudim)) - 8*m1**6*T134fin(m5,m1,m1,mudim) + 8*m1**4*m5sq*T134fin(m5,m1,m1,mudim)))/(32.*m1**4*m5**4*(4*m1sq - m5sq)**3)
		def eval_160():
			return ((2*(1 + 2*B0del(0,0,m4sq,mudim) - 4*B0fin(0,0,m4sq,mudim) + B0fin(0,0,m4sq,mudim)**2))/(m2**2*m3**2*m4**2) - (2*(3 + 2*B0del(0,0,m4sq,mudim) - 4*B0fin(0,0,m4sq,mudim) + B0fin(0,0,m4sq,mudim)**2))/(m2**2*m3**2*m4**2) + (2*((-2*m3**6*(m3sq - 4*m4sq)**2*(m2**3 - 2*m2*m4sq)**2 + 2*m2**6*(m2sq - 4*m4sq)**2*(m3**3 - 2*m3*m4sq)**2)*B0del(0,0,m4sq,mudim) + 4*m2**4*m3**6*(m3sq - 4*m4sq)**2*((m2sq - 2*m4sq)*B0del(0,0,m2sq,mudim) + 4*m4sq*B0fin(0,0,m2sq,mudim)) - 4*m2**6*m3**4*(m2sq - 4*m4sq)**2*((m3sq - 2*m4sq)*B0del(0,0,m3sq,mudim) + 4*m4sq*B0fin(0,0,m3sq,mudim)) - 2*m2sq*m3sq*(m2**8*(m3**4 - 4*m4**4) + 4*m3**4*m4**4*(m3sq - 4*m4sq)**2 - 8*m2**6*(m3**4 - 4*m4**4)*m4sq - m2**4*(m3**8 + 64*m4**8 - 8*m3**6*m4sq))*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)) + (2*m3**6*(m3sq - 4*m4sq)**2*(m2**6 - 6*m2**4*m4sq) + 2*m2**6*(m2sq - 4*m4sq)**2*(-m3**6 + 6*m3**4*m4sq))*B0fin(0,0,m4sq,mudim) - (-1 + B0fin(0,0,m4sq,mudim))*(2*m3**6*(m3sq - 4*m4sq)**2*(-m2**6 + 6*m2**4*m4sq) - 2*m2**6*(m2sq - 4*m4sq)**2*(-m3**6 + 6*m3**4*m4sq) - 4*m2**4*m3**6*(m3sq - 4*m4sq)**2*(4*m4sq + (m2sq - 2*m4sq)*B0fin(0,0,m2sq,mudim)) + 4*m2**6*m3**4*(m2sq - 4*m4sq)**2*(4*m4sq + (m3sq - 2*m4sq)*B0fin(0,0,m3sq,mudim)) - (-2*m3**6*(m3sq - 4*m4sq)**2*(m2**3 - 2*m2*m4sq)**2 + 2*m2**6*(m2sq - 4*m4sq)**2*(m3**3 - 2*m3*m4sq)**2)*B0fin(0,0,m4sq,mudim))))/(m2**6*m3**6*(m2sq - m3sq)*(m2 - 2*m4)**2*(m3 - 2*m4)**2*(m2 + 2*m4)**2*(m3 + 2*m4)**2) + (4*(3*m2**4 - 8*m4**4 + 2*m2sq*m4sq + 2*(m2**4 - 4*m2sq*m4sq)*B0fin(0,0,m2sq,mudim) + 4*(m2sq - 4*m4sq)*m4sq*B0fin(0,0,m4sq,mudim) - 2*m2sq*T134fin(m4,m4,m2,mudim) + 4*m4sq*T134fin(m4,m4,m2,mudim)))/(m2**4*(m2sq - m3sq)*(m2sq - 4*m4sq)**2) + (4*(3*m3**4 - 8*m4**4 + 2*m3sq*m4sq + 2*(m3**4 - 4*m3sq*m4sq)*B0fin(0,0,m3sq,mudim) + 4*(m3sq - 4*m4sq)*m4sq*B0fin(0,0,m4sq,mudim) - 2*m3sq*T134fin(m4,m4,m3,mudim) + 4*m4sq*T134fin(m4,m4,m3,mudim)))/(m3**4*(-m2sq + m3sq)*(m3sq - 4*m4sq)**2))/4.
		def eval_161():
			return (4*m2**4*m3**6*(m2sq - 4*m4sq)*(m3sq - 4*m4sq)*(m3sq - m4sq)**2*(4*m3sq - m4sq)*m4sq*B0del(0,0,m2sq,mudim) + 2*m2sq*m3**4*(m3sq - 4*m4sq)*(m3sq - m4sq)**3*(4*m3sq - m4sq)*m4sq*(m2**4 - m2sq*(m3sq - 3*m4sq) + (m3sq - m4sq)*m4sq)*B0del(0,0,m2sq,mudim) - 2*m2sq*m3**4*m4**4*(m3sq - 4*m4sq)*(m3sq - m4sq)**2*(4*m3sq - m4sq)*(2*m2**4 + (m3sq - m4sq)**2 - 2*m2sq*(m3sq + 3*m4sq))*B0del(0,0,m2sq,mudim) + 4*m2**4*m3**6*(m2sq - 4*m4sq)*(m3sq - 4*m4sq)*(m3sq - m4sq)**2*(4*m3sq - m4sq)*m4sq*B0del(0,0,m3sq,mudim) + 8*m2**4*m3**6*(m2sq - 4*m4sq)*(m3sq - 4*m4sq)*(m3sq - m4sq)**2*(m2**4 + (m3sq - m4sq)**2 - 2*m2sq*(m3sq + m4sq))*B0del(0,0,m3sq,mudim) - 2*m2**4*m3sq*(m2sq - 4*m4sq)*m4sq*(2*m3**12 + 10*m3**8*m4**4 - 68*m3**6*m4**6 + 39*m3**4*m4**8 - 12*m3sq*m4**10 + m4**12 - 8*m3**10*m4sq + m2**4*(2*m3**8 + 10*m3**4*m4**4 - 10*m3sq*m4**6 + m4**8 - 12*m3**6*m4sq) + m2sq*(-4*m3**10 + 21*m3**6*m4**4 - 4*m3**4*m4**6 + 18*m3sq*m4**8 - 2*m4**10 + 16*m3**8*m4sq))*B0del(0,0,m3sq,mudim) + 2*m2**4*m3sq*(m2sq - 4*m4sq)*(4*m3sq - m4sq)*m4sq*(m3**4*(m2sq - m3sq)*(m3sq - 4*m4sq)*(m2sq - 2*(m3sq + m4sq)) + (m3sq - m4sq)**3*(m2**4 + (m3sq - m4sq)**2 - 2*m2sq*(m3sq + m4sq)))*B0del(0,0,m3sq,mudim) - 4*(m2sq - m3sq)*m4**6*(m3sq - m4sq)**2*(4*m3sq - m4sq)*(m2**4 + m3**4 + m2sq*(m3sq - 4*m4sq) - 4*m3sq*m4sq)*(m2**4 + (m3sq - m4sq)**2 - 2*m2sq*(m3sq + m4sq))*B0del(0,0,m4sq,mudim) - 2*m2sq*m3**4*m4**4*(m3sq - 4*m4sq)*(m3sq - m4sq)**2*(4*m3sq - m4sq)*(2*m2**4 + (m3sq - m4sq)**2 - 2*m2sq*(m3sq + 3*m4sq))*B0del(0,0,m4sq,mudim) - 2*m2**4*m3sq*(m2sq - 4*m4sq)*m4sq*(2*m3**12 + 10*m3**8*m4**4 - 68*m3**6*m4**6 + 39*m3**4*m4**8 - 12*m3sq*m4**10 + m4**12 - 8*m3**10*m4sq + m2**4*(2*m3**8 + 10*m3**4*m4**4 - 10*m3sq*m4**6 + m4**8 - 12*m3**6*m4sq) + m2sq*(-4*m3**10 + 21*m3**6*m4**4 - 4*m3**4*m4**6 + 18*m3sq*m4**8 - 2*m4**10 + 16*m3**8*m4sq))*B0del(0,0,m4sq,mudim) + (m2sq - m3sq)*(m3sq - m4sq)**2*(4*m3sq - m4sq)*m4sq*(m2**4 + (m3sq - m4sq)**2 - 2*m2sq*(m3sq + m4sq))*(2*m3sq*m4**4*(m3sq - 4*m4sq) + 2*m2sq*m4sq*(m3**4 - 4*m4**4 - 3*m3sq*m4sq) + m2**4*(-m3**4 + 2*m4**4 + 2*m3sq*m4sq))*B0del(0,0,m4sq,mudim) - 4*m2**4*m3**6*(m2sq - 4*m4sq)*(m3sq - 4*m4sq)*(m3sq - m4sq)**2*(4*m3sq - m4sq)*m4sq*B0fin(0,0,m2sq,mudim) - 2*m2sq*m3**4*(m3sq - 4*m4sq)*(m3sq - m4sq)**3*(4*m3sq - m4sq)*m4sq*(m2**4 - m2sq*(m3sq - 3*m4sq) + (m3sq - m4sq)*m4sq)*B0fin(0,0,m2sq,mudim) + 2*m2sq*m3**4*m4**4*(m3sq - 4*m4sq)*(m3sq - m4sq)**2*(4*m3sq - m4sq)*(2*m2**4 + (m3sq - m4sq)**2 - 2*m2sq*(m3sq + 3*m4sq))*B0fin(0,0,m2sq,mudim) - 4*m2**4*m3**6*(m2sq - 4*m4sq)*(m3sq - 4*m4sq)*(m3sq - m4sq)**2*(4*m3sq - m4sq)*m4sq*B0fin(0,0,m3sq,mudim) - 8*m2**4*m3**6*(m2sq - 4*m4sq)*(m3sq - 4*m4sq)*(m3sq - m4sq)**2*(m2**4 + (m3sq - m4sq)**2 - 2*m2sq*(m3sq + m4sq))*B0fin(0,0,m3sq,mudim) + 2*m2**4*m3sq*(m2sq - 4*m4sq)*m4sq*(2*m3**12 + 10*m3**8*m4**4 - 68*m3**6*m4**6 + 39*m3**4*m4**8 - 12*m3sq*m4**10 + m4**12 - 8*m3**10*m4sq + m2**4*(2*m3**8 + 10*m3**4*m4**4 - 10*m3sq*m4**6 + m4**8 - 12*m3**6*m4sq) + m2sq*(-4*m3**10 + 21*m3**6*m4**4 - 4*m3**4*m4**6 + 18*m3sq*m4**8 - 2*m4**10 + 16*m3**8*m4sq))*B0fin(0,0,m3sq,mudim) - 2*m2**4*m3sq*(m2sq - 4*m4sq)*(4*m3sq - m4sq)*m4sq*(m3**4*(m2sq - m3sq)*(m3sq - 4*m4sq)*(m2sq - 2*(m3sq + m4sq)) + (m3sq - m4sq)**3*(m2**4 + (m3sq - m4sq)**2 - 2*m2sq*(m3sq + m4sq)))*B0fin(0,0,m3sq,mudim) + 4*m2**4*m3**6*(m2sq - 4*m4sq)*(m3sq - 4*m4sq)*(m3sq - m4sq)**2*(4*m3sq - m4sq)*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) + 4*m2**4*m3**6*(m2sq - 4*m4sq)*(m3sq - 4*m4sq)*(m3sq - m4sq)**2*(m2**4 + (m3sq - m4sq)**2 - 2*m2sq*(m3sq + m4sq))*B0fin(0,0,m3sq,mudim)**2 + 2*m2sq*m3**4*(m3sq - 4*m4sq)*(m3sq - m4sq)**3*(4*m3sq - m4sq)*m4sq*(m2**4 - m2sq*(m3sq - 3*m4sq) + (m3sq - m4sq)*m4sq)*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)) + (m2sq - m3sq)*(m3sq - m4sq)**2*(4*m3sq - m4sq)*m4sq*(m2**4 + (m3sq - m4sq)**2 - 2*m2sq*(m3sq + m4sq))*(2*m3sq*m4**4*(m3sq - 4*m4sq) + 2*m2sq*m4sq*(m3**4 - 4*m4**4 - 3*m3sq*m4sq) + m2**4*(-m3**4 + 2*m4**4 + 2*m3sq*m4sq))*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)) + 2*m2**4*m3sq*(m2sq - 4*m4sq)*(4*m3sq - m4sq)*m4sq*(m3**4*(m2sq - m3sq)*(m3sq - 4*m4sq)*(m2sq - 2*(m3sq + m4sq)) + (m3sq - m4sq)**3*(m2**4 + (m3sq - m4sq)**2 - 2*m2sq*(m3sq + m4sq)))*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)) + 4*(m2sq - m3sq)*m4**6*(m3sq - m4sq)**2*(4*m3sq - m4sq)*(m2**4 + m3**4 + m2sq*(m3sq - 4*m4sq) - 4*m3sq*m4sq)*(m2**4 + (m3sq - m4sq)**2 - 2*m2sq*(m3sq + m4sq))*B0fin(0,0,m4sq,mudim) + 2*m2sq*m3**4*m4**4*(m3sq - 4*m4sq)*(m3sq - m4sq)**2*(4*m3sq - m4sq)*(2*m2**4 + (m3sq - m4sq)**2 - 2*m2sq*(m3sq + 3*m4sq))*B0fin(0,0,m4sq,mudim) + 2*m2**4*m3sq*(m2sq - 4*m4sq)*m4sq*(2*m3**12 + 10*m3**8*m4**4 - 68*m3**6*m4**6 + 39*m3**4*m4**8 - 12*m3sq*m4**10 + m4**12 - 8*m3**10*m4sq + m2**4*(2*m3**8 + 10*m3**4*m4**4 - 10*m3sq*m4**6 + m4**8 - 12*m3**6*m4sq) + m2sq*(-4*m3**10 + 21*m3**6*m4**4 - 4*m3**4*m4**6 + 18*m3sq*m4**8 - 2*m4**10 + 16*m3**8*m4sq))*B0fin(0,0,m4sq,mudim) - (m2sq - m3sq)*(m3sq - m4sq)**2*(4*m3sq - m4sq)*m4sq*(m2**4 + (m3sq - m4sq)**2 - 2*m2sq*(m3sq + m4sq))*(2*m3sq*m4**4*(m3sq - 4*m4sq) + 2*m2sq*m4sq*(m3**4 - 4*m4**4 - 3*m3sq*m4sq) + m2**4*(-m3**4 + 2*m4**4 + 2*m3sq*m4sq))*B0fin(0,0,m4sq,mudim) + 2*m2sq*m3**4*(m3sq - 4*m4sq)*(m3sq - m4sq)**3*(4*m3sq - m4sq)*m4sq*(m2**4 - m2sq*(m3sq - 3*m4sq) + (m3sq - m4sq)*m4sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 2*m2sq*m3**4*m4**4*(m3sq - 4*m4sq)*(m3sq - m4sq)**2*(4*m3sq - m4sq)*(2*m2**4 + (m3sq - m4sq)**2 - 2*m2sq*(m3sq + 3*m4sq))*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 2*m2**4*m3sq*(m2sq - 4*m4sq)*m4sq*(2*m3**12 + 10*m3**8*m4**4 - 68*m3**6*m4**6 + 39*m3**4*m4**8 - 12*m3sq*m4**10 + m4**12 - 8*m3**10*m4sq + m2**4*(2*m3**8 + 10*m3**4*m4**4 - 10*m3sq*m4**6 + m4**8 - 12*m3**6*m4sq) + m2sq*(-4*m3**10 + 21*m3**6*m4**4 - 4*m3**4*m4**6 + 18*m3sq*m4**8 - 2*m4**10 + 16*m3**8*m4sq))*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + 2*m2**4*m3sq*(m2sq - 4*m4sq)*(4*m3sq - m4sq)*m4sq*(m3**4*(m2sq - m3sq)*(m3sq - 4*m4sq)*(m2sq - 2*(m3sq + m4sq)) + (m3sq - m4sq)**3*(m2**4 + (m3sq - m4sq)**2 - 2*m2sq*(m3sq + m4sq)))*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) - 2*(m2sq - m3sq)*m4**6*(m3sq - m4sq)**2*(4*m3sq - m4sq)*(m2**4 + m3**4 + m2sq*(m3sq - 4*m4sq) - 4*m3sq*m4sq)*(m2**4 + (m3sq - m4sq)**2 - 2*m2sq*(m3sq + m4sq))*B0fin(0,0,m4sq,mudim)**2 + (m2sq - m3sq)*(m3sq - m4sq)**2*(4*m3sq - m4sq)*m4sq*(m2**4 + (m3sq - m4sq)**2 - 2*m2sq*(m3sq + m4sq))*(2*m3sq*m4**4*(m3sq - 4*m4sq) + 2*m2sq*m4sq*(m3**4 - 4*m4**4 - 3*m3sq*m4sq) + m2**4*(-m3**4 + 2*m4**4 + 2*m3sq*m4sq))*B0fin(0,0,m4sq,mudim)**2 + 4*m2sq*(m2sq - m3sq)*m3sq*(m2sq - 4*m4sq)*(m3sq - 4*m4sq)*(m3sq - m4sq)*(4*m3sq - m4sq)*m4sq*(m2**4 + (m3sq - m4sq)**2 - 2*m2sq*(m3sq + m4sq))*((m3sq + m4sq)/2. + m3sq*B0fin(0,0,m3sq,mudim) + m4sq*B0fin(0,0,m4sq,mudim)) + 4*m2**4*(m2sq - 4*m4sq)*(m3sq - 4*m4sq)*(2*m3sq - m4sq)*(m3**3 - m3*m4sq)**2*(m2**4 + (m3sq - m4sq)**2 - 2*m2sq*(m3sq + m4sq))*(m3sq + m4sq/2. + 2*m3sq*B0fin(0,0,m3sq,mudim) + m4sq*B0fin(0,0,m4sq,mudim)) - 4*m2sq*m3**4*(m3sq - 4*m4sq)*(m3sq - m4sq)**2*(4*m3sq - m4sq)*m4sq*(m2**4 + (m3sq - m4sq)**2 - 2*m2sq*(m3sq + m4sq))*(m2sq/2. + m4sq + m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim)) + 4*m2**4*m3sq*(m2sq - 4*m4sq)*(m3sq - m4sq)**2*(4*m3sq - m4sq)*m4sq*(m2**4 + (m3sq - m4sq)**2 - 2*m2sq*(m3sq + m4sq))*(m3sq/2. + m4sq + m3sq*B0fin(0,0,m3sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim)) + 2*m2sq*m3**4*(m2sq - 4*m4sq)*(m3sq - 4*m4sq)*(m3sq - m4sq)**2*(m2sq + m3sq - m4sq)*(4*m3sq - m4sq)*m4sq*(m2sq + m3sq + m4sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim)) - 2*m2sq*(m2sq - m3sq)*m3sq*(m2sq - 4*m4sq)*(m3sq - 4*m4sq)*(m3sq - m4sq)*(4*m3sq - m4sq)*m4sq*(m2**4 + (m3sq - m4sq)**2 - 2*m2sq*(m3sq + m4sq))*T134fin(m4,m3,0,mudim) - 2*m2sq*m3**4*(m2sq - 4*m4sq)*(m3sq - 4*m4sq)*(m3sq - m4sq)**2*(m2sq + m3sq - m4sq)*(4*m3sq - m4sq)*m4sq*T134fin(m4,m3,m2,mudim) - 2*m2**4*(m2sq - 4*m4sq)*(m3sq - 4*m4sq)*(2*m3sq - m4sq)*(m3**3 - m3*m4sq)**2*(m2**4 + (m3sq - m4sq)**2 - 2*m2sq*(m3sq + m4sq))*T134fin(m4,m3,m3,mudim) + 2*m2sq*m3**4*(m3sq - 4*m4sq)*(m3sq - m4sq)**2*(4*m3sq - m4sq)*m4sq*(m2**4 + (m3sq - m4sq)**2 - 2*m2sq*(m3sq + m4sq))*T134fin(m4,m4,m2,mudim) - 2*m2**4*m3sq*(m2sq - 4*m4sq)*(m3sq - m4sq)**2*(4*m3sq - m4sq)*m4sq*(m2**4 + (m3sq - m4sq)**2 - 2*m2sq*(m3sq + m4sq))*T134fin(m4,m4,m3,mudim))/(2.*m2**4*m3**4*(m2sq - m3sq)*m4**2*(m2sq - 4*m4sq)*(m3sq - 4*m4sq)*(m3sq - m4sq)**3*(4*m3sq - m4sq)*(m2**4 + (m3sq - m4sq)**2 - 2*m2sq*(m3sq + m4sq)))
		def eval_162():
			return (m1sq*(m1**4 - m2**4 + m1sq*(4*m2sq - m7sq))*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)**4*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))) - ((-m2**4 + m7**4 + m1sq*(m2sq - m7sq) + 3*m2sq*m7sq)*B0del(0,0,m7sq,mudim))/((m1sq - m2sq)*m7**2*(4*m2sq - m7sq)*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))) + ((2*m2**6 + m1sq*m7**4 + 6*m2**4*m7sq - 2*m2sq*(m7**4 + 2*m1sq*m7sq))*B0del(0,0,m2sq,mudim) + (m1sq - m2sq)*(4*m2sq - m7sq)*m7sq*(-2 + B0fin(0,0,m2sq,mudim)))/(2.*(-(m1sq*m2) + m2**3)**2*m7**4*(4*m2sq - m7sq)) + ((m1sq*(m1**4 - m2**4 + m1sq*(4*m2sq - m7sq)))/((m1sq - m2sq)**4*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))) + (m2**4 - m7**4 - 3*m2sq*m7sq + m1sq*(-m2sq + m7sq))/((m1sq - m2sq)*m7**2*(4*m2sq - m7sq)*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))) + (2*m2**6 + m1sq*m7**4 + 6*m2**4*m7sq - 2*m2sq*(m7**4 + 2*m1sq*m7sq))/(2.*(-(m1sq*m2) + m2**3)**2*m7**4*(4*m2sq - m7sq)))*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)) + (1 + 2*B0del(0,0,m2sq,mudim) - 4*B0fin(0,0,m2sq,mudim) + B0fin(0,0,m2sq,mudim)**2)/(-2*m2**4*m7sq + 2*m1sq*m2sq*m7sq) + (-1 + B0fin(0,0,m2sq,mudim))*((m1sq*(m1**4 - m2**4 + m1sq*(4*m2sq - m7sq))*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)**4*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))) + (-2 + (2*m1sq)/m2**2 + 2*m2sq*(m2**(-2) + (-m1sq + m2sq)/m2**4 + (2*(m2sq - m7sq))/(-m7**4 + 4*m2sq*m7sq))*B0fin(0,0,m2sq,mudim))/(4.*(m1sq - m2sq)**2*m7**2) - ((-m2**4 + m7**4 + m1sq*(m2sq - m7sq) + 3*m2sq*m7sq)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*m7**2*(4*m2sq - m7sq)*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq)))) + ((4*m1sq*m2sq*(2*m1sq + 2*m2sq - m7sq)*(B0fin(0,0,m1sq,mudim) + B0fin(0,0,m2sq,mudim)))/(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq)) - (4*(m1sq - m2sq)**2*((m1sq - m2sq)*(6*m2sq - m7sq)*m7sq + 2*(m1sq*(-2*m2sq + m7sq)**2 - m2sq*(8*m2**4 + m7**4 - 5*m2sq*m7sq))*B0fin(0,0,m2sq,mudim)))/(m7**4*(-4*m2sq + m7sq)**2) - (4*m1sq*m2sq*(2*m1sq + 2*m2sq - m7sq)*(B0del(0,0,m1sq,mudim) + B0del(0,0,m2sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim)))/(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq)) + (2*(m1sq - m2sq)**2*(4*(m1sq - m2sq)*(6*m2sq - m7sq)*m7sq*B0fin(0,0,m2sq,mudim) + (2*m1sq*(-2*m2sq + m7sq)**2 - 2*m2sq*(8*m2**4 + m7**4 - 5*m2sq*m7sq))*(2*B0del(0,0,m2sq,mudim) + B0fin(0,0,m2sq,mudim)**2)))/(m7**4*(-4*m2sq + m7sq)**2) - (8*(m1**3 - m1*m2sq)**2*(B0fin(0,0,m1sq,mudim) + B0fin(0,0,m7sq,mudim)))/(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq)) - (4*(m1sq - m2sq)**2*m2sq*((-8*(m1sq - m2sq)*m7sq)/(-4*m2sq + m7sq)**2 + (m7sq/(4*m2sq - m7sq) + (2*(m1sq - m2sq)*(-m7**4 + 2*m2sq*m7sq))/(-4*m2**3 + m2*m7sq)**2 - m7**4/(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq)))*B0fin(0,0,m2sq,mudim) + (m7sq/(4*m2sq - m7sq) + (2*(m1sq - m2sq)*(-m7**4 + 2*m2sq*m7sq))/(-4*m2**3 + m2*m7sq)**2 - m7**4/(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq)))*B0fin(0,0,m7sq,mudim)))/m7**4 + (8*(m1**3 - m1*m2sq)**2*(B0del(0,0,m1sq,mudim) + B0del(0,0,m7sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim)))/(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq)) + (4*(m1sq - m2sq)**2*m2sq*((m7sq/(4*m2sq - m7sq) + (2*(m1sq - m2sq)*(-m7**4 + 2*m2sq*m7sq))/(-4*m2**3 + m2*m7sq)**2 - m7**4/(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq)))*B0del(0,0,m2sq,mudim) + (m7sq/(4*m2sq - m7sq) + (2*(m1sq - m2sq)*(-m7**4 + 2*m2sq*m7sq))/(-4*m2**3 + m2*m7sq)**2 - m7**4/(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq)))*B0del(0,0,m7sq,mudim) + (8*(-m1sq + m2sq)*m7sq*B0fin(0,0,m2sq,mudim))/(-4*m2sq + m7sq)**2 + ((-8*(m1sq - m2sq)*m7sq)/(-4*m2sq + m7sq)**2 + (m7sq/(4*m2sq - m7sq) + (2*(m1sq - m2sq)*(-m7**4 + 2*m2sq*m7sq))/(-4*m2**3 + m2*m7sq)**2 - m7**4/(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq)))*B0fin(0,0,m2sq,mudim))*B0fin(0,0,m7sq,mudim)))/m7**4)/(4.*(m1sq - m2sq)**4) - (m1sq + m2sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim) - T134fin(m2,m1,0,mudim))/((m1sq - m2sq)**3*m7**2) + ((m1sq - m2sq + m7sq)*(m1sq + m2sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim) - T134fin(m7,m2,m1,mudim)))/((m1sq - m2sq)**2*m7**2*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))) + (2*(-m1sq + m2sq)*m7sq*(2*m2sq + m7sq) + (4*m2sq - m7sq)*(m1sq - m2sq + m7sq)*(2*m2sq + m7sq + 4*m2sq*B0fin(0,0,m2sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)) + (4*m2**4 + m7**4 - 6*m2sq*m7sq + m1sq*(-4*m2sq + 2*m7sq))*T134fin(m7,m2,m2,mudim))/((m1sq - m2sq)**2*m7**4*(-2*m2 + m7)**2*(2*m2 + m7)**2)
		def eval_163():
			return (m1sq*(m1**4 - m2**4 + m1sq*(4*m2sq - m5sq))*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)**4*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))) - ((-m2**4 + m5**4 + m1sq*(m2sq - m5sq) + 3*m2sq*m5sq)*B0del(0,0,m5sq,mudim))/((m1sq - m2sq)*m5**2*(4*m2sq - m5sq)*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))) + ((2*m2**6 + m1sq*m5**4 + 6*m2**4*m5sq - 2*m2sq*(m5**4 + 2*m1sq*m5sq))*B0del(0,0,m2sq,mudim) + (m1sq - m2sq)*(4*m2sq - m5sq)*m5sq*(-2 + B0fin(0,0,m2sq,mudim)))/(2.*(-(m1sq*m2) + m2**3)**2*m5**4*(4*m2sq - m5sq)) + ((m1sq*(m1**4 - m2**4 + m1sq*(4*m2sq - m5sq)))/((m1sq - m2sq)**4*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))) + (m2**4 - m5**4 - 3*m2sq*m5sq + m1sq*(-m2sq + m5sq))/((m1sq - m2sq)*m5**2*(4*m2sq - m5sq)*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))) + (2*m2**6 + m1sq*m5**4 + 6*m2**4*m5sq - 2*m2sq*(m5**4 + 2*m1sq*m5sq))/(2.*(-(m1sq*m2) + m2**3)**2*m5**4*(4*m2sq - m5sq)))*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)) + (1 + 2*B0del(0,0,m2sq,mudim) - 4*B0fin(0,0,m2sq,mudim) + B0fin(0,0,m2sq,mudim)**2)/(-2*m2**4*m5sq + 2*m1sq*m2sq*m5sq) + (-1 + B0fin(0,0,m2sq,mudim))*((m1sq*(m1**4 - m2**4 + m1sq*(4*m2sq - m5sq))*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)**4*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))) + (-2 + (2*m1sq)/m2**2 + 2*m2sq*(m2**(-2) + (-m1sq + m2sq)/m2**4 + (2*(m2sq - m5sq))/(-m5**4 + 4*m2sq*m5sq))*B0fin(0,0,m2sq,mudim))/(4.*(m1sq - m2sq)**2*m5**2) - ((-m2**4 + m5**4 + m1sq*(m2sq - m5sq) + 3*m2sq*m5sq)*B0fin(0,0,m5sq,mudim))/((m1sq - m2sq)*m5**2*(4*m2sq - m5sq)*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq)))) + ((4*m1sq*m2sq*(2*m1sq + 2*m2sq - m5sq)*(B0fin(0,0,m1sq,mudim) + B0fin(0,0,m2sq,mudim)))/(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq)) - (4*(m1sq - m2sq)**2*((m1sq - m2sq)*(6*m2sq - m5sq)*m5sq + 2*(m1sq*(-2*m2sq + m5sq)**2 - m2sq*(8*m2**4 + m5**4 - 5*m2sq*m5sq))*B0fin(0,0,m2sq,mudim)))/(m5**4*(-4*m2sq + m5sq)**2) - (4*m1sq*m2sq*(2*m1sq + 2*m2sq - m5sq)*(B0del(0,0,m1sq,mudim) + B0del(0,0,m2sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim)))/(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq)) + (2*(m1sq - m2sq)**2*(4*(m1sq - m2sq)*(6*m2sq - m5sq)*m5sq*B0fin(0,0,m2sq,mudim) + (2*m1sq*(-2*m2sq + m5sq)**2 - 2*m2sq*(8*m2**4 + m5**4 - 5*m2sq*m5sq))*(2*B0del(0,0,m2sq,mudim) + B0fin(0,0,m2sq,mudim)**2)))/(m5**4*(-4*m2sq + m5sq)**2) - (8*(m1**3 - m1*m2sq)**2*(B0fin(0,0,m1sq,mudim) + B0fin(0,0,m5sq,mudim)))/(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq)) - (4*(m1sq - m2sq)**2*m2sq*((-8*(m1sq - m2sq)*m5sq)/(-4*m2sq + m5sq)**2 + (m5sq/(4*m2sq - m5sq) + (2*(m1sq - m2sq)*(-m5**4 + 2*m2sq*m5sq))/(-4*m2**3 + m2*m5sq)**2 - m5**4/(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq)))*B0fin(0,0,m2sq,mudim) + (m5sq/(4*m2sq - m5sq) + (2*(m1sq - m2sq)*(-m5**4 + 2*m2sq*m5sq))/(-4*m2**3 + m2*m5sq)**2 - m5**4/(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq)))*B0fin(0,0,m5sq,mudim)))/m5**4 + (8*(m1**3 - m1*m2sq)**2*(B0del(0,0,m1sq,mudim) + B0del(0,0,m5sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim)))/(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq)) + (4*(m1sq - m2sq)**2*m2sq*((m5sq/(4*m2sq - m5sq) + (2*(m1sq - m2sq)*(-m5**4 + 2*m2sq*m5sq))/(-4*m2**3 + m2*m5sq)**2 - m5**4/(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq)))*B0del(0,0,m2sq,mudim) + (m5sq/(4*m2sq - m5sq) + (2*(m1sq - m2sq)*(-m5**4 + 2*m2sq*m5sq))/(-4*m2**3 + m2*m5sq)**2 - m5**4/(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq)))*B0del(0,0,m5sq,mudim) + (8*(-m1sq + m2sq)*m5sq*B0fin(0,0,m2sq,mudim))/(-4*m2sq + m5sq)**2 + ((-8*(m1sq - m2sq)*m5sq)/(-4*m2sq + m5sq)**2 + (m5sq/(4*m2sq - m5sq) + (2*(m1sq - m2sq)*(-m5**4 + 2*m2sq*m5sq))/(-4*m2**3 + m2*m5sq)**2 - m5**4/(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq)))*B0fin(0,0,m2sq,mudim))*B0fin(0,0,m5sq,mudim)))/m5**4)/(4.*(m1sq - m2sq)**4) - (m1sq + m2sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim) - T134fin(m2,m1,0,mudim))/((m1sq - m2sq)**3*m5**2) + ((m1sq - m2sq + m5sq)*(m1sq + m2sq + m5sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) - T134fin(m5,m2,m1,mudim)))/((m1sq - m2sq)**2*m5**2*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))) + (2*(-m1sq + m2sq)*m5sq*(2*m2sq + m5sq) + (4*m2sq - m5sq)*(m1sq - m2sq + m5sq)*(2*m2sq + m5sq + 4*m2sq*B0fin(0,0,m2sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim)) + (4*m2**4 + m5**4 - 6*m2sq*m5sq + m1sq*(-4*m2sq + 2*m5sq))*T134fin(m5,m2,m2,mudim))/((m1sq - m2sq)**2*m5**4*(-2*m2 + m5)**2*(2*m2 + m5)**2)
		def eval_164():
			return (-20*m2**10*m4**4 + 28*m2**8*m4**6 - 12*m2**6*m4**8 + 2*m2**4*m4**10 + 2*m2**12*m4sq - 36*m2**10*m5**4 - 328*m2**6*m4**4*m5**4 + 164*m2**4*m4**6*m5**4 - 32*m2sq*m4**8*m5**4 - 8*m4**10*m5**4 + 76*m2**8*m4sq*m5**4 + 168*m2**8*m5**6 + 380*m2**4*m4**4*m5**6 + 64*m2sq*m4**6*m5**6 + 40*m4**8*m5**6 - 264*m2**6*m4sq*m5**6 - 316*m2**6*m5**8 - 128*m2sq*m4**4*m5**8 - 80*m4**6*m5**8 + 186*m2**4*m4sq*m5**8 + 270*m2**4*m5**10 + 80*m4**4*m5**10 + 192*m2sq*m4sq*m5**10 - 96*m2sq*m5**12 - 40*m4sq*m5**12 + 8*m5**14 + 2*m2**12*m5sq + 112*m2**8*m4**4*m5sq - 104*m2**6*m4**6*m5sq + 22*m2**4*m4**8*m5sq - 8*m2**10*m4sq*m5sq - 2*m2sq*(m4sq - m5sq)**2*(5*m2**8 + 2*(-(m4sq*m5) + m5**3)**2*(m4sq + 7*m5sq) - m2**6*(9*m4sq + 29*m5sq) - m2sq*(m4**6 + 35*m4sq*m5**4 + 47*m5**6 + 13*m4**4*m5sq) + m2**4*(5*m4**4 + 57*m5**4 + 34*m4sq*m5sq))*B0del(0,0,m2sq,mudim) + 2*m2sq*m4sq*(m2sq - 4*m5sq)**2*(m2**6 - (m4sq - m5sq)**2*(m4sq + m5sq) - m2**4*(5*m4sq + 3*m5sq) + m2sq*(5*m4**4 + 3*m5**4 + 8*m4sq*m5sq))*B0del(0,0,m4sq,mudim) - 26*m2**10*m5**4*B0del(0,0,m5sq,mudim) - 54*m2**6*m4**4*m5**4*B0del(0,0,m5sq,mudim) + 12*m2sq*m4**8*m5**4*B0del(0,0,m5sq,mudim) - 8*m4**10*m5**4*B0del(0,0,m5sq,mudim) + 88*m2**8*m4sq*m5**4*B0del(0,0,m5sq,mudim) + 110*m2**8*m5**6*B0del(0,0,m5sq,mudim) + 160*m2**4*m4**4*m5**6*B0del(0,0,m5sq,mudim) - 56*m2sq*m4**6*m5**6*B0del(0,0,m5sq,mudim) + 40*m4**8*m5**6*B0del(0,0,m5sq,mudim) - 278*m2**6*m4sq*m5**6*B0del(0,0,m5sq,mudim) - 202*m2**6*m5**8*B0del(0,0,m5sq,mudim) - 8*m2sq*m4**4*m5**8*B0del(0,0,m5sq,mudim) - 80*m4**6*m5**8*B0del(0,0,m5sq,mudim) + 192*m2**4*m4sq*m5**8*B0del(0,0,m5sq,mudim) + 176*m2**4*m5**10*B0del(0,0,m5sq,mudim) + 80*m4**4*m5**10*B0del(0,0,m5sq,mudim) + 116*m2sq*m4sq*m5**10*B0del(0,0,m5sq,mudim) - 68*m2sq*m5**12*B0del(0,0,m5sq,mudim) - 40*m4sq*m5**12*B0del(0,0,m5sq,mudim) + 8*m5**14*B0del(0,0,m5sq,mudim) + 2*m2**12*m5sq*B0del(0,0,m5sq,mudim) - 6*m2**8*m4**4*m5sq*B0del(0,0,m5sq,mudim) + 22*m2**6*m4**6*m5sq*B0del(0,0,m5sq,mudim) - 16*m2**4*m4**8*m5sq*B0del(0,0,m5sq,mudim) + 4*m2sq*m4**10*m5sq*B0del(0,0,m5sq,mudim) - 6*m2**10*m4sq*m5sq*B0del(0,0,m5sq,mudim) - 4*m2**10*m4**4*B0fin(0,0,m2sq,mudim) + 4*m2**8*m4**6*B0fin(0,0,m2sq,mudim) - 4*m2**10*m5**4*B0fin(0,0,m2sq,mudim) - 8*m2**6*m4**4*m5**4*B0fin(0,0,m2sq,mudim) + 96*m2**4*m4**6*m5**4*B0fin(0,0,m2sq,mudim) - 20*m2sq*m4**8*m5**4*B0fin(0,0,m2sq,mudim) - 28*m2**8*m4sq*m5**4*B0fin(0,0,m2sq,mudim) + 16*m2**8*m5**6*B0fin(0,0,m2sq,mudim) - 128*m2**4*m4**4*m5**6*B0fin(0,0,m2sq,mudim) + 40*m2sq*m4**6*m5**6*B0fin(0,0,m2sq,mudim) + 40*m2**6*m4sq*m5**6*B0fin(0,0,m2sq,mudim) - 24*m2**6*m5**8*B0fin(0,0,m2sq,mudim) - 40*m2sq*m4**4*m5**8*B0fin(0,0,m2sq,mudim) + 32*m2**4*m4sq*m5**8*B0fin(0,0,m2sq,mudim) + 16*m2**4*m5**10*B0fin(0,0,m2sq,mudim) + 20*m2sq*m4sq*m5**10*B0fin(0,0,m2sq,mudim) - 4*m2sq*m5**12*B0fin(0,0,m2sq,mudim) + 8*m2**8*m4**4*m5sq*B0fin(0,0,m2sq,mudim) - 8*m2**6*m4**6*m5sq*B0fin(0,0,m2sq,mudim) - 16*m2**4*m4**8*m5sq*B0fin(0,0,m2sq,mudim) + 4*m2sq*m4**10*m5sq*B0fin(0,0,m2sq,mudim) + 8*m2**10*m4sq*m5sq*B0fin(0,0,m2sq,mudim) - 14*m2**10*m4**4*B0fin(0,0,m4sq,mudim) + 18*m2**8*m4**6*B0fin(0,0,m4sq,mudim) - 6*m2**6*m4**8*B0fin(0,0,m4sq,mudim) + 2*m2**12*m4sq*B0fin(0,0,m4sq,mudim) - 362*m2**6*m4**4*m5**4*B0fin(0,0,m4sq,mudim) + 176*m2**4*m4**6*m5**4*B0fin(0,0,m4sq,mudim) - 96*m2sq*m4**8*m5**4*B0fin(0,0,m4sq,mudim) + 46*m2**8*m4sq*m5**4*B0fin(0,0,m4sq,mudim) + 336*m2**4*m4**4*m5**6*B0fin(0,0,m4sq,mudim) + 224*m2sq*m4**6*m5**6*B0fin(0,0,m4sq,mudim) - 14*m2**6*m4sq*m5**6*B0fin(0,0,m4sq,mudim) - 160*m2sq*m4**4*m5**8*B0fin(0,0,m4sq,mudim) - 48*m2**4*m4sq*m5**8*B0fin(0,0,m4sq,mudim) + 32*m2sq*m4sq*m5**10*B0fin(0,0,m4sq,mudim) + 128*m2**8*m4**4*m5sq*B0fin(0,0,m4sq,mudim) - 130*m2**6*m4**6*m5sq*B0fin(0,0,m4sq,mudim) + 48*m2**4*m4**8*m5sq*B0fin(0,0,m4sq,mudim) - 18*m2**10*m4sq*m5sq*B0fin(0,0,m4sq,mudim) - 6*m2**10*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 8*m2**8*m4**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 2*m2**6*m4**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 102*m2**6*m4**4*m5**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 80*m2**4*m4**6*m5**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 32*m2sq*m4**8*m5**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 56*m2**8*m4sq*m5**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 48*m2**4*m4**4*m5**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 96*m2sq*m4**6*m5**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 162*m2**6*m4sq*m5**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 96*m2sq*m4**4*m5**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 144*m2**4*m4sq*m5**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 32*m2sq*m4sq*m5**10*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 48*m2**8*m4**4*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 58*m2**6*m4**6*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 16*m2**4*m4**8*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 6*m2**10*m4sq*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 2*m2**10*m4**4*B0fin(0,0,m5sq,mudim) + 6*m2**8*m4**6*B0fin(0,0,m5sq,mudim) - 6*m2**6*m4**8*B0fin(0,0,m5sq,mudim) + 2*m2**4*m4**10*B0fin(0,0,m5sq,mudim) - 32*m2**10*m5**4*B0fin(0,0,m5sq,mudim) + 42*m2**6*m4**4*m5**4*B0fin(0,0,m5sq,mudim) - 108*m2**4*m4**6*m5**4*B0fin(0,0,m5sq,mudim) + 84*m2sq*m4**8*m5**4*B0fin(0,0,m5sq,mudim) - 8*m4**10*m5**4*B0fin(0,0,m5sq,mudim) + 58*m2**8*m4sq*m5**4*B0fin(0,0,m5sq,mudim) + 152*m2**8*m5**6*B0fin(0,0,m5sq,mudim) + 172*m2**4*m4**4*m5**6*B0fin(0,0,m5sq,mudim) - 200*m2sq*m4**6*m5**6*B0fin(0,0,m5sq,mudim) + 40*m4**8*m5**6*B0fin(0,0,m5sq,mudim) - 290*m2**6*m4sq*m5**6*B0fin(0,0,m5sq,mudim) - 292*m2**6*m5**8*B0fin(0,0,m5sq,mudim) + 72*m2sq*m4**4*m5**8*B0fin(0,0,m5sq,mudim) - 80*m4**6*m5**8*B0fin(0,0,m5sq,mudim) + 202*m2**4*m4sq*m5**8*B0fin(0,0,m5sq,mudim) + 254*m2**4*m5**10*B0fin(0,0,m5sq,mudim) + 80*m4**4*m5**10*B0fin(0,0,m5sq,mudim) + 140*m2sq*m4sq*m5**10*B0fin(0,0,m5sq,mudim) - 92*m2sq*m5**12*B0fin(0,0,m5sq,mudim) - 40*m4sq*m5**12*B0fin(0,0,m5sq,mudim) + 8*m5**14*B0fin(0,0,m5sq,mudim) + 2*m2**12*m5sq*B0fin(0,0,m5sq,mudim) - 24*m2**8*m4**4*m5sq*B0fin(0,0,m5sq,mudim) + 34*m2**6*m4**6*m5sq*B0fin(0,0,m5sq,mudim) - 10*m2**4*m4**8*m5sq*B0fin(0,0,m5sq,mudim) - 4*m2sq*m4**10*m5sq*B0fin(0,0,m5sq,mudim) + 2*m2**10*m4sq*m5sq*B0fin(0,0,m5sq,mudim) - 4*m2**10*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 10*m2**8*m4**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 8*m2**6*m4**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m2**4*m4**10*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 10*m2**10*m5**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 114*m2**6*m4**4*m5**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 60*m2**4*m4**6*m5**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 20*m2sq*m4**8*m5**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 42*m2**8*m4sq*m5**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 58*m2**8*m5**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 68*m2**4*m4**4*m5**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 8*m2sq*m4**6*m5**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m2**6*m4sq*m5**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 114*m2**6*m5**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 56*m2sq*m4**4*m5**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 26*m2**4*m4sq*m5**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 94*m2**4*m5**10*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 76*m2sq*m4sq*m5**10*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 28*m2sq*m5**12*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 26*m2**8*m4**4*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 10*m2**6*m4**6*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 6*m2**4*m4**8*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 4*m2sq*m4**10*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 14*m2**10*m4sq*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 4*m2**10*m4**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m2**8*m4**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m2**12*m4sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) - 184*m2**6*m4**4*m5**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) + 64*m2**4*m4**6*m5**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) + 142*m2**8*m4sq*m5**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) + 192*m2**4*m4**4*m5**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) - 64*m2sq*m4**6*m5**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) - 308*m2**6*m4sq*m5**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) + 128*m2sq*m4**4*m5**8*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) + 256*m2**4*m4sq*m5**8*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) - 64*m2sq*m4sq*m5**10*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) + 48*m2**8*m4**4*m5sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) - 20*m2**6*m4**6*m5sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) - 28*m2**10*m4sq*m5sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) + 4*m2**10*m4**4*B0fin(0,0,m5sq,mudim)**2 - 6*m2**8*m4**6*B0fin(0,0,m5sq,mudim)**2 + 4*m2**6*m4**8*B0fin(0,0,m5sq,mudim)**2 - m2**4*m4**10*B0fin(0,0,m5sq,mudim)**2 - m2**12*m4sq*B0fin(0,0,m5sq,mudim)**2 - 8*m2**10*m5**4*B0fin(0,0,m5sq,mudim)**2 + 8*m2**6*m4**4*m5**4*B0fin(0,0,m5sq,mudim)**2 - 2*m2**4*m4**6*m5**4*B0fin(0,0,m5sq,mudim)**2 - 4*m2sq*m4**8*m5**4*B0fin(0,0,m5sq,mudim)**2 - 4*m4**10*m5**4*B0fin(0,0,m5sq,mudim)**2 - 6*m2**8*m4sq*m5**4*B0fin(0,0,m5sq,mudim)**2 + 26*m2**8*m5**6*B0fin(0,0,m5sq,mudim)**2 + 18*m2**4*m4**4*m5**6*B0fin(0,0,m5sq,mudim)**2 + 8*m2sq*m4**6*m5**6*B0fin(0,0,m5sq,mudim)**2 + 20*m4**8*m5**6*B0fin(0,0,m5sq,mudim)**2 + 16*m2**6*m4sq*m5**6*B0fin(0,0,m5sq,mudim)**2 - 44*m2**6*m5**8*B0fin(0,0,m5sq,mudim)**2 - 40*m2sq*m4**4*m5**8*B0fin(0,0,m5sq,mudim)**2 - 40*m4**6*m5**8*B0fin(0,0,m5sq,mudim)**2 - 45*m2**4*m4sq*m5**8*B0fin(0,0,m5sq,mudim)**2 + 41*m2**4*m5**10*B0fin(0,0,m5sq,mudim)**2 + 40*m4**4*m5**10*B0fin(0,0,m5sq,mudim)**2 + 52*m2sq*m4sq*m5**10*B0fin(0,0,m5sq,mudim)**2 - 20*m2sq*m5**12*B0fin(0,0,m5sq,mudim)**2 - 20*m4sq*m5**12*B0fin(0,0,m5sq,mudim)**2 + 4*m5**14*B0fin(0,0,m5sq,mudim)**2 + m2**12*m5sq*B0fin(0,0,m5sq,mudim)**2 - 14*m2**8*m4**4*m5sq*B0fin(0,0,m5sq,mudim)**2 + 16*m2**6*m4**6*m5sq*B0fin(0,0,m5sq,mudim)**2 - 11*m2**4*m4**8*m5sq*B0fin(0,0,m5sq,mudim)**2 + 4*m2sq*m4**10*m5sq*B0fin(0,0,m5sq,mudim)**2 + 4*m2**10*m4sq*m5sq*B0fin(0,0,m5sq,mudim)**2 - 2*m2**12*T134fin(m5,m4,0,mudim) - 12*m2**8*m4**4*T134fin(m5,m4,0,mudim) + 8*m2**6*m4**6*T134fin(m5,m4,0,mudim) - 2*m2**4*m4**8*T134fin(m5,m4,0,mudim) + 8*m2**10*m4sq*T134fin(m5,m4,0,mudim) - 108*m2**8*m5**4*T134fin(m5,m4,0,mudim) - 140*m2**4*m4**4*m5**4*T134fin(m5,m4,0,mudim) + 64*m2sq*m4**6*m5**4*T134fin(m5,m4,0,mudim) - 32*m4**8*m5**4*T134fin(m5,m4,0,mudim) + 184*m2**6*m4sq*m5**4*T134fin(m5,m4,0,mudim) + 232*m2**6*m5**6*T134fin(m5,m4,0,mudim) - 32*m2sq*m4**4*m5**6*T134fin(m5,m4,0,mudim) + 128*m4**6*m5**6*T134fin(m5,m4,0,mudim) - 56*m2**4*m4sq*m5**6*T134fin(m5,m4,0,mudim) - 258*m2**4*m5**8*T134fin(m5,m4,0,mudim) - 192*m4**4*m5**8*T134fin(m5,m4,0,mudim) - 192*m2sq*m4sq*m5**8*T134fin(m5,m4,0,mudim) + 144*m2sq*m5**10*T134fin(m5,m4,0,mudim) + 128*m4sq*m5**10*T134fin(m5,m4,0,mudim) - 32*m5**12*T134fin(m5,m4,0,mudim) + 24*m2**10*m5sq*T134fin(m5,m4,0,mudim) + 88*m2**6*m4**4*m5sq*T134fin(m5,m4,0,mudim) - 56*m2**4*m4**6*m5sq*T134fin(m5,m4,0,mudim) + 16*m2sq*m4**8*m5sq*T134fin(m5,m4,0,mudim) - 72*m2**8*m4sq*m5sq*T134fin(m5,m4,0,mudim) + 2*m2**8*m4**4*T134fin(m5,m4,m2,mudim) - 6*m2**6*m4**6*T134fin(m5,m4,m2,mudim) + 2*m2**4*m4**8*T134fin(m5,m4,m2,mudim) + 2*m2**10*m4sq*T134fin(m5,m4,m2,mudim) + 22*m2**8*m5**4*T134fin(m5,m4,m2,mudim) - 4*m2**4*m4**4*m5**4*T134fin(m5,m4,m2,mudim) - 32*m2sq*m4**6*m5**4*T134fin(m5,m4,m2,mudim) + 32*m4**8*m5**4*T134fin(m5,m4,m2,mudim) + 102*m2**6*m4sq*m5**4*T134fin(m5,m4,m2,mudim) - 86*m2**6*m5**6*T134fin(m5,m4,m2,mudim) - 128*m4**6*m5**6*T134fin(m5,m4,m2,mudim) - 184*m2**4*m4sq*m5**6*T134fin(m5,m4,m2,mudim) + 146*m2**4*m5**8*T134fin(m5,m4,m2,mudim) + 192*m4**4*m5**8*T134fin(m5,m4,m2,mudim) + 160*m2sq*m4sq*m5**8*T134fin(m5,m4,m2,mudim) - 112*m2sq*m5**10*T134fin(m5,m4,m2,mudim) - 128*m4sq*m5**10*T134fin(m5,m4,m2,mudim) + 32*m5**12*T134fin(m5,m4,m2,mudim) - 2*m2**10*m5sq*T134fin(m5,m4,m2,mudim) - 10*m2**6*m4**4*m5sq*T134fin(m5,m4,m2,mudim) + 40*m2**4*m4**6*m5sq*T134fin(m5,m4,m2,mudim) - 16*m2sq*m4**8*m5sq*T134fin(m5,m4,m2,mudim) - 24*m2**8*m4sq*m5sq*T134fin(m5,m4,m2,mudim) + 8*m2**8*m4**4*T134fin(m5,m5,m2,mudim) - 12*m2**6*m4**6*T134fin(m5,m5,m2,mudim) + 8*m2**4*m4**8*T134fin(m5,m5,m2,mudim) - 2*m2sq*m4**10*T134fin(m5,m5,m2,mudim) - 2*m2**10*m4sq*T134fin(m5,m5,m2,mudim) - 12*m2**8*m5**4*T134fin(m5,m5,m2,mudim) - 8*m2**4*m4**4*m5**4*T134fin(m5,m5,m2,mudim) + 12*m2sq*m4**6*m5**4*T134fin(m5,m5,m2,mudim) - 20*m4**8*m5**4*T134fin(m5,m5,m2,mudim) - 4*m2**6*m4sq*m5**4*T134fin(m5,m5,m2,mudim) + 28*m2**6*m5**6*T134fin(m5,m5,m2,mudim) + 20*m2sq*m4**4*m5**6*T134fin(m5,m5,m2,mudim) + 40*m4**6*m5**6*T134fin(m5,m5,m2,mudim) + 24*m2**4*m4sq*m5**6*T134fin(m5,m5,m2,mudim) - 32*m2**4*m5**8*T134fin(m5,m5,m2,mudim) - 40*m4**4*m5**8*T134fin(m5,m5,m2,mudim) - 42*m2sq*m4sq*m5**8*T134fin(m5,m5,m2,mudim) + 18*m2sq*m5**10*T134fin(m5,m5,m2,mudim) + 20*m4sq*m5**10*T134fin(m5,m5,m2,mudim) - 4*m5**12*T134fin(m5,m5,m2,mudim) + 2*m2**10*m5sq*T134fin(m5,m5,m2,mudim) - 12*m2**6*m4**4*m5sq*T134fin(m5,m5,m2,mudim) + 8*m2**4*m4**6*m5sq*T134fin(m5,m5,m2,mudim) - 6*m2sq*m4**8*m5sq*T134fin(m5,m5,m2,mudim) + 4*m4**10*m5sq*T134fin(m5,m5,m2,mudim) + 4*m2**8*m4sq*m5sq*T134fin(m5,m5,m2,mudim))/(2.*m2**4*(m2 - 2*m5)**2*(m2 + m4 - m5)**2*(m2 - m4 + m5)**2*(-m2 + m4 + m5)**2*(m2 + m4 + m5)**2*(m2 + 2*m5)**2*(m4sq - m5sq)**2)
		def eval_165():
			return (-36*m2**10*m4**4 + 168*m2**8*m4**6 - 316*m2**6*m4**8 + 270*m2**4*m4**10 - 96*m2sq*m4**12 + 8*m4**14 + 2*m2**12*m4sq - 20*m2**10*m7**4 - 328*m2**6*m4**4*m7**4 + 380*m2**4*m4**6*m7**4 - 128*m2sq*m4**8*m7**4 + 80*m4**10*m7**4 + 112*m2**8*m4sq*m7**4 + 28*m2**8*m7**6 + 164*m2**4*m4**4*m7**6 + 64*m2sq*m4**6*m7**6 - 80*m4**8*m7**6 - 104*m2**6*m4sq*m7**6 - 12*m2**6*m7**8 - 32*m2sq*m4**4*m7**8 + 40*m4**6*m7**8 + 22*m2**4*m4sq*m7**8 + 2*m2**4*m7**10 - 8*m4**4*m7**10 + 2*m2**12*m7sq + 76*m2**8*m4**4*m7sq - 264*m2**6*m4**6*m7sq + 186*m2**4*m4**8*m7sq + 192*m2sq*m4**10*m7sq - 40*m4**12*m7sq - 8*m2**10*m4sq*m7sq - 2*m2sq*(m4sq - m7sq)**2*(5*m2**8 - m2**6*(29*m4sq + 9*m7sq) + 2*(7*m4sq + m7sq)*(m4**3 - m4*m7sq)**2 - m2sq*(47*m4**6 + 13*m4sq*m7**4 + m7**6 + 35*m4**4*m7sq) + m2**4*(57*m4**4 + 5*m7**4 + 34*m4sq*m7sq))*B0del(0,0,m2sq,mudim) + 2*m4sq*(m2**12 + 4*m4sq*(m4sq - m7sq)**5 - m2**10*(13*m4sq + 3*m7sq) - 2*m2sq*(m4sq - m7sq)**2*(17*m4**6 - 5*m4sq*m7**4 - m7**6 + 5*m4**4*m7sq) - m2**6*(101*m4**6 + 27*m4sq*m7**4 - 11*m7**6 + 139*m4**4*m7sq) + m2**4*(88*m4**8 + 80*m4**4*m7**4 - 8*m7**8 + 96*m4**6*m7sq) + m2**8*(55*m4**4 - 3*m7**4 + 44*m4sq*m7sq))*B0del(0,0,m4sq,mudim) - 10*m2**10*m7**4*B0del(0,0,m7sq,mudim) - 286*m2**6*m4**4*m7**4*B0del(0,0,m7sq,mudim) + 240*m2**4*m4**6*m7**4*B0del(0,0,m7sq,mudim) + 32*m2sq*m4**8*m7**4*B0del(0,0,m7sq,mudim) + 96*m2**8*m4sq*m7**4*B0del(0,0,m7sq,mudim) + 10*m2**8*m7**6*B0del(0,0,m7sq,mudim) + 144*m2**4*m4**4*m7**6*B0del(0,0,m7sq,mudim) + 32*m2sq*m4**6*m7**6*B0del(0,0,m7sq,mudim) - 78*m2**6*m4sq*m7**6*B0del(0,0,m7sq,mudim) - 2*m2**6*m7**8*B0del(0,0,m7sq,mudim) - 32*m2sq*m4**4*m7**8*B0del(0,0,m7sq,mudim) + 16*m2**4*m4sq*m7**8*B0del(0,0,m7sq,mudim) + 2*m2**12*m7sq*B0del(0,0,m7sq,mudim) + 86*m2**8*m4**4*m7sq*B0del(0,0,m7sq,mudim) - 146*m2**6*m4**6*m7sq*B0del(0,0,m7sq,mudim) + 112*m2**4*m4**8*m7sq*B0del(0,0,m7sq,mudim) - 32*m2sq*m4**10*m7sq*B0del(0,0,m7sq,mudim) - 22*m2**10*m4sq*m7sq*B0del(0,0,m7sq,mudim) - 4*m2**10*m4**4*B0fin(0,0,m2sq,mudim) + 16*m2**8*m4**6*B0fin(0,0,m2sq,mudim) - 24*m2**6*m4**8*B0fin(0,0,m2sq,mudim) + 16*m2**4*m4**10*B0fin(0,0,m2sq,mudim) - 4*m2sq*m4**12*B0fin(0,0,m2sq,mudim) - 4*m2**10*m7**4*B0fin(0,0,m2sq,mudim) - 8*m2**6*m4**4*m7**4*B0fin(0,0,m2sq,mudim) - 128*m2**4*m4**6*m7**4*B0fin(0,0,m2sq,mudim) - 40*m2sq*m4**8*m7**4*B0fin(0,0,m2sq,mudim) + 8*m2**8*m4sq*m7**4*B0fin(0,0,m2sq,mudim) + 4*m2**8*m7**6*B0fin(0,0,m2sq,mudim) + 96*m2**4*m4**4*m7**6*B0fin(0,0,m2sq,mudim) + 40*m2sq*m4**6*m7**6*B0fin(0,0,m2sq,mudim) - 8*m2**6*m4sq*m7**6*B0fin(0,0,m2sq,mudim) - 20*m2sq*m4**4*m7**8*B0fin(0,0,m2sq,mudim) - 16*m2**4*m4sq*m7**8*B0fin(0,0,m2sq,mudim) + 4*m2sq*m4sq*m7**10*B0fin(0,0,m2sq,mudim) - 28*m2**8*m4**4*m7sq*B0fin(0,0,m2sq,mudim) + 40*m2**6*m4**6*m7sq*B0fin(0,0,m2sq,mudim) + 32*m2**4*m4**8*m7sq*B0fin(0,0,m2sq,mudim) + 20*m2sq*m4**10*m7sq*B0fin(0,0,m2sq,mudim) + 8*m2**10*m4sq*m7sq*B0fin(0,0,m2sq,mudim) - 32*m2**10*m4**4*B0fin(0,0,m4sq,mudim) + 152*m2**8*m4**6*B0fin(0,0,m4sq,mudim) - 292*m2**6*m4**8*B0fin(0,0,m4sq,mudim) + 254*m2**4*m4**10*B0fin(0,0,m4sq,mudim) - 92*m2sq*m4**12*B0fin(0,0,m4sq,mudim) + 8*m4**14*B0fin(0,0,m4sq,mudim) + 2*m2**12*m4sq*B0fin(0,0,m4sq,mudim) - 2*m2**10*m7**4*B0fin(0,0,m4sq,mudim) + 42*m2**6*m4**4*m7**4*B0fin(0,0,m4sq,mudim) + 172*m2**4*m4**6*m7**4*B0fin(0,0,m4sq,mudim) + 72*m2sq*m4**8*m7**4*B0fin(0,0,m4sq,mudim) + 80*m4**10*m7**4*B0fin(0,0,m4sq,mudim) - 24*m2**8*m4sq*m7**4*B0fin(0,0,m4sq,mudim) + 6*m2**8*m7**6*B0fin(0,0,m4sq,mudim) - 108*m2**4*m4**4*m7**6*B0fin(0,0,m4sq,mudim) - 200*m2sq*m4**6*m7**6*B0fin(0,0,m4sq,mudim) - 80*m4**8*m7**6*B0fin(0,0,m4sq,mudim) + 34*m2**6*m4sq*m7**6*B0fin(0,0,m4sq,mudim) - 6*m2**6*m7**8*B0fin(0,0,m4sq,mudim) + 84*m2sq*m4**4*m7**8*B0fin(0,0,m4sq,mudim) + 40*m4**6*m7**8*B0fin(0,0,m4sq,mudim) - 10*m2**4*m4sq*m7**8*B0fin(0,0,m4sq,mudim) + 2*m2**4*m7**10*B0fin(0,0,m4sq,mudim) - 8*m4**4*m7**10*B0fin(0,0,m4sq,mudim) - 4*m2sq*m4sq*m7**10*B0fin(0,0,m4sq,mudim) + 58*m2**8*m4**4*m7sq*B0fin(0,0,m4sq,mudim) - 290*m2**6*m4**6*m7sq*B0fin(0,0,m4sq,mudim) + 202*m2**4*m4**8*m7sq*B0fin(0,0,m4sq,mudim) + 140*m2sq*m4**10*m7sq*B0fin(0,0,m4sq,mudim) - 40*m4**12*m7sq*B0fin(0,0,m4sq,mudim) + 2*m2**10*m4sq*m7sq*B0fin(0,0,m4sq,mudim) - 10*m2**10*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 58*m2**8*m4**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 114*m2**6*m4**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 94*m2**4*m4**10*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 28*m2sq*m4**12*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 4*m2**10*m7**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 114*m2**6*m4**4*m7**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 68*m2**4*m4**6*m7**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 56*m2sq*m4**8*m7**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 26*m2**8*m4sq*m7**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 10*m2**8*m7**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 60*m2**4*m4**4*m7**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 8*m2sq*m4**6*m7**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 10*m2**6*m4sq*m7**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 8*m2**6*m7**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 20*m2sq*m4**4*m7**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 6*m2**4*m4sq*m7**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 2*m2**4*m7**10*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 4*m2sq*m4sq*m7**10*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 42*m2**8*m4**4*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 2*m2**6*m4**6*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 26*m2**4*m4**8*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 76*m2sq*m4**10*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 14*m2**10*m4sq*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 8*m2**10*m4**4*B0fin(0,0,m4sq,mudim)**2 + 26*m2**8*m4**6*B0fin(0,0,m4sq,mudim)**2 - 44*m2**6*m4**8*B0fin(0,0,m4sq,mudim)**2 + 41*m2**4*m4**10*B0fin(0,0,m4sq,mudim)**2 - 20*m2sq*m4**12*B0fin(0,0,m4sq,mudim)**2 + 4*m4**14*B0fin(0,0,m4sq,mudim)**2 + m2**12*m4sq*B0fin(0,0,m4sq,mudim)**2 + 4*m2**10*m7**4*B0fin(0,0,m4sq,mudim)**2 + 8*m2**6*m4**4*m7**4*B0fin(0,0,m4sq,mudim)**2 + 18*m2**4*m4**6*m7**4*B0fin(0,0,m4sq,mudim)**2 - 40*m2sq*m4**8*m7**4*B0fin(0,0,m4sq,mudim)**2 + 40*m4**10*m7**4*B0fin(0,0,m4sq,mudim)**2 - 14*m2**8*m4sq*m7**4*B0fin(0,0,m4sq,mudim)**2 - 6*m2**8*m7**6*B0fin(0,0,m4sq,mudim)**2 - 2*m2**4*m4**4*m7**6*B0fin(0,0,m4sq,mudim)**2 + 8*m2sq*m4**6*m7**6*B0fin(0,0,m4sq,mudim)**2 - 40*m4**8*m7**6*B0fin(0,0,m4sq,mudim)**2 + 16*m2**6*m4sq*m7**6*B0fin(0,0,m4sq,mudim)**2 + 4*m2**6*m7**8*B0fin(0,0,m4sq,mudim)**2 - 4*m2sq*m4**4*m7**8*B0fin(0,0,m4sq,mudim)**2 + 20*m4**6*m7**8*B0fin(0,0,m4sq,mudim)**2 - 11*m2**4*m4sq*m7**8*B0fin(0,0,m4sq,mudim)**2 - m2**4*m7**10*B0fin(0,0,m4sq,mudim)**2 - 4*m4**4*m7**10*B0fin(0,0,m4sq,mudim)**2 + 4*m2sq*m4sq*m7**10*B0fin(0,0,m4sq,mudim)**2 - m2**12*m7sq*B0fin(0,0,m4sq,mudim)**2 - 6*m2**8*m4**4*m7sq*B0fin(0,0,m4sq,mudim)**2 + 16*m2**6*m4**6*m7sq*B0fin(0,0,m4sq,mudim)**2 - 45*m2**4*m4**8*m7sq*B0fin(0,0,m4sq,mudim)**2 + 52*m2sq*m4**10*m7sq*B0fin(0,0,m4sq,mudim)**2 - 20*m4**12*m7sq*B0fin(0,0,m4sq,mudim)**2 + 4*m2**10*m4sq*m7sq*B0fin(0,0,m4sq,mudim)**2 - 14*m2**10*m7**4*B0fin(0,0,m7sq,mudim) - 362*m2**6*m4**4*m7**4*B0fin(0,0,m7sq,mudim) + 336*m2**4*m4**6*m7**4*B0fin(0,0,m7sq,mudim) - 160*m2sq*m4**8*m7**4*B0fin(0,0,m7sq,mudim) + 128*m2**8*m4sq*m7**4*B0fin(0,0,m7sq,mudim) + 18*m2**8*m7**6*B0fin(0,0,m7sq,mudim) + 176*m2**4*m4**4*m7**6*B0fin(0,0,m7sq,mudim) + 224*m2sq*m4**6*m7**6*B0fin(0,0,m7sq,mudim) - 130*m2**6*m4sq*m7**6*B0fin(0,0,m7sq,mudim) - 6*m2**6*m7**8*B0fin(0,0,m7sq,mudim) - 96*m2sq*m4**4*m7**8*B0fin(0,0,m7sq,mudim) + 48*m2**4*m4sq*m7**8*B0fin(0,0,m7sq,mudim) + 2*m2**12*m7sq*B0fin(0,0,m7sq,mudim) + 46*m2**8*m4**4*m7sq*B0fin(0,0,m7sq,mudim) - 14*m2**6*m4**6*m7sq*B0fin(0,0,m7sq,mudim) - 48*m2**4*m4**8*m7sq*B0fin(0,0,m7sq,mudim) + 32*m2sq*m4**10*m7sq*B0fin(0,0,m7sq,mudim) - 18*m2**10*m4sq*m7sq*B0fin(0,0,m7sq,mudim) - 6*m2**10*m7**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) - 102*m2**6*m4**4*m7**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) + 48*m2**4*m4**6*m7**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) - 96*m2sq*m4**8*m7**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) + 48*m2**8*m4sq*m7**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) + 8*m2**8*m7**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) + 80*m2**4*m4**4*m7**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) + 96*m2sq*m4**6*m7**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) - 58*m2**6*m4sq*m7**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) - 2*m2**6*m7**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) - 32*m2sq*m4**4*m7**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) + 16*m2**4*m4sq*m7**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) - 56*m2**8*m4**4*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) + 162*m2**6*m4**6*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) - 144*m2**4*m4**8*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) + 32*m2sq*m4**10*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) + 6*m2**10*m4sq*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) - 4*m2**10*m7**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) - 184*m2**6*m4**4*m7**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) + 192*m2**4*m4**6*m7**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) + 128*m2sq*m4**8*m7**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) + 48*m2**8*m4sq*m7**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) + 2*m2**8*m7**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) + 64*m2**4*m4**4*m7**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) - 64*m2sq*m4**6*m7**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) - 20*m2**6*m4sq*m7**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) + 2*m2**12*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) + 142*m2**8*m4**4*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) - 308*m2**6*m4**6*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) + 256*m2**4*m4**8*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) - 64*m2sq*m4**10*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) - 28*m2**10*m4sq*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) - 12*m2**8*m4**4*T134fin(m4,m4,m2,mudim) + 28*m2**6*m4**6*T134fin(m4,m4,m2,mudim) - 32*m2**4*m4**8*T134fin(m4,m4,m2,mudim) + 18*m2sq*m4**10*T134fin(m4,m4,m2,mudim) - 4*m4**12*T134fin(m4,m4,m2,mudim) + 2*m2**10*m4sq*T134fin(m4,m4,m2,mudim) + 8*m2**8*m7**4*T134fin(m4,m4,m2,mudim) - 8*m2**4*m4**4*m7**4*T134fin(m4,m4,m2,mudim) + 20*m2sq*m4**6*m7**4*T134fin(m4,m4,m2,mudim) - 40*m4**8*m7**4*T134fin(m4,m4,m2,mudim) - 12*m2**6*m4sq*m7**4*T134fin(m4,m4,m2,mudim) - 12*m2**6*m7**6*T134fin(m4,m4,m2,mudim) + 12*m2sq*m4**4*m7**6*T134fin(m4,m4,m2,mudim) + 40*m4**6*m7**6*T134fin(m4,m4,m2,mudim) + 8*m2**4*m4sq*m7**6*T134fin(m4,m4,m2,mudim) + 8*m2**4*m7**8*T134fin(m4,m4,m2,mudim) - 20*m4**4*m7**8*T134fin(m4,m4,m2,mudim) - 6*m2sq*m4sq*m7**8*T134fin(m4,m4,m2,mudim) - 2*m2sq*m7**10*T134fin(m4,m4,m2,mudim) + 4*m4sq*m7**10*T134fin(m4,m4,m2,mudim) - 2*m2**10*m7sq*T134fin(m4,m4,m2,mudim) - 4*m2**6*m4**4*m7sq*T134fin(m4,m4,m2,mudim) + 24*m2**4*m4**6*m7sq*T134fin(m4,m4,m2,mudim) - 42*m2sq*m4**8*m7sq*T134fin(m4,m4,m2,mudim) + 20*m4**10*m7sq*T134fin(m4,m4,m2,mudim) + 4*m2**8*m4sq*m7sq*T134fin(m4,m4,m2,mudim) - 2*m2**12*T134fin(m7,m4,0,mudim) - 108*m2**8*m4**4*T134fin(m7,m4,0,mudim) + 232*m2**6*m4**6*T134fin(m7,m4,0,mudim) - 258*m2**4*m4**8*T134fin(m7,m4,0,mudim) + 144*m2sq*m4**10*T134fin(m7,m4,0,mudim) - 32*m4**12*T134fin(m7,m4,0,mudim) + 24*m2**10*m4sq*T134fin(m7,m4,0,mudim) - 12*m2**8*m7**4*T134fin(m7,m4,0,mudim) - 140*m2**4*m4**4*m7**4*T134fin(m7,m4,0,mudim) - 32*m2sq*m4**6*m7**4*T134fin(m7,m4,0,mudim) - 192*m4**8*m7**4*T134fin(m7,m4,0,mudim) + 88*m2**6*m4sq*m7**4*T134fin(m7,m4,0,mudim) + 8*m2**6*m7**6*T134fin(m7,m4,0,mudim) + 64*m2sq*m4**4*m7**6*T134fin(m7,m4,0,mudim) + 128*m4**6*m7**6*T134fin(m7,m4,0,mudim) - 56*m2**4*m4sq*m7**6*T134fin(m7,m4,0,mudim) - 2*m2**4*m7**8*T134fin(m7,m4,0,mudim) - 32*m4**4*m7**8*T134fin(m7,m4,0,mudim) + 16*m2sq*m4sq*m7**8*T134fin(m7,m4,0,mudim) + 8*m2**10*m7sq*T134fin(m7,m4,0,mudim) + 184*m2**6*m4**4*m7sq*T134fin(m7,m4,0,mudim) - 56*m2**4*m4**6*m7sq*T134fin(m7,m4,0,mudim) - 192*m2sq*m4**8*m7sq*T134fin(m7,m4,0,mudim) + 128*m4**10*m7sq*T134fin(m7,m4,0,mudim) - 72*m2**8*m4sq*m7sq*T134fin(m7,m4,0,mudim) + 22*m2**8*m4**4*T134fin(m7,m4,m2,mudim) - 86*m2**6*m4**6*T134fin(m7,m4,m2,mudim) + 146*m2**4*m4**8*T134fin(m7,m4,m2,mudim) - 112*m2sq*m4**10*T134fin(m7,m4,m2,mudim) + 32*m4**12*T134fin(m7,m4,m2,mudim) - 2*m2**10*m4sq*T134fin(m7,m4,m2,mudim) + 2*m2**8*m7**4*T134fin(m7,m4,m2,mudim) - 4*m2**4*m4**4*m7**4*T134fin(m7,m4,m2,mudim) + 192*m4**8*m7**4*T134fin(m7,m4,m2,mudim) - 10*m2**6*m4sq*m7**4*T134fin(m7,m4,m2,mudim) - 6*m2**6*m7**6*T134fin(m7,m4,m2,mudim) - 32*m2sq*m4**4*m7**6*T134fin(m7,m4,m2,mudim) - 128*m4**6*m7**6*T134fin(m7,m4,m2,mudim) + 40*m2**4*m4sq*m7**6*T134fin(m7,m4,m2,mudim) + 2*m2**4*m7**8*T134fin(m7,m4,m2,mudim) + 32*m4**4*m7**8*T134fin(m7,m4,m2,mudim) - 16*m2sq*m4sq*m7**8*T134fin(m7,m4,m2,mudim) + 2*m2**10*m7sq*T134fin(m7,m4,m2,mudim) + 102*m2**6*m4**4*m7sq*T134fin(m7,m4,m2,mudim) - 184*m2**4*m4**6*m7sq*T134fin(m7,m4,m2,mudim) + 160*m2sq*m4**8*m7sq*T134fin(m7,m4,m2,mudim) - 128*m4**10*m7sq*T134fin(m7,m4,m2,mudim) - 24*m2**8*m4sq*m7sq*T134fin(m7,m4,m2,mudim))/(2.*m2**4*(m2 - 2*m4)**2*(m2 + 2*m4)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(m4sq - m7sq)**2)
		def eval_166():
			return (-36*m2**10*m4**4 + 168*m2**8*m4**6 - 316*m2**6*m4**8 + 270*m2**4*m4**10 - 96*m2sq*m4**12 + 8*m4**14 + 2*m2**12*m4sq - 20*m2**10*m5**4 - 328*m2**6*m4**4*m5**4 + 380*m2**4*m4**6*m5**4 - 128*m2sq*m4**8*m5**4 + 80*m4**10*m5**4 + 112*m2**8*m4sq*m5**4 + 28*m2**8*m5**6 + 164*m2**4*m4**4*m5**6 + 64*m2sq*m4**6*m5**6 - 80*m4**8*m5**6 - 104*m2**6*m4sq*m5**6 - 12*m2**6*m5**8 - 32*m2sq*m4**4*m5**8 + 40*m4**6*m5**8 + 22*m2**4*m4sq*m5**8 + 2*m2**4*m5**10 - 8*m4**4*m5**10 + 2*m2**12*m5sq + 76*m2**8*m4**4*m5sq - 264*m2**6*m4**6*m5sq + 186*m2**4*m4**8*m5sq + 192*m2sq*m4**10*m5sq - 40*m4**12*m5sq - 8*m2**10*m4sq*m5sq - 2*m2sq*(m4sq - m5sq)**2*(5*m2**8 - m2**6*(29*m4sq + 9*m5sq) + 2*(7*m4sq + m5sq)*(m4**3 - m4*m5sq)**2 - m2sq*(47*m4**6 + 13*m4sq*m5**4 + m5**6 + 35*m4**4*m5sq) + m2**4*(57*m4**4 + 5*m5**4 + 34*m4sq*m5sq))*B0del(0,0,m2sq,mudim) + 2*m4sq*(m2**12 + 4*m4sq*(m4sq - m5sq)**5 - m2**10*(13*m4sq + 3*m5sq) - 2*m2sq*(m4sq - m5sq)**2*(17*m4**6 - 5*m4sq*m5**4 - m5**6 + 5*m4**4*m5sq) - m2**6*(101*m4**6 + 27*m4sq*m5**4 - 11*m5**6 + 139*m4**4*m5sq) + m2**4*(88*m4**8 + 80*m4**4*m5**4 - 8*m5**8 + 96*m4**6*m5sq) + m2**8*(55*m4**4 - 3*m5**4 + 44*m4sq*m5sq))*B0del(0,0,m4sq,mudim) - 10*m2**10*m5**4*B0del(0,0,m5sq,mudim) - 286*m2**6*m4**4*m5**4*B0del(0,0,m5sq,mudim) + 240*m2**4*m4**6*m5**4*B0del(0,0,m5sq,mudim) + 32*m2sq*m4**8*m5**4*B0del(0,0,m5sq,mudim) + 96*m2**8*m4sq*m5**4*B0del(0,0,m5sq,mudim) + 10*m2**8*m5**6*B0del(0,0,m5sq,mudim) + 144*m2**4*m4**4*m5**6*B0del(0,0,m5sq,mudim) + 32*m2sq*m4**6*m5**6*B0del(0,0,m5sq,mudim) - 78*m2**6*m4sq*m5**6*B0del(0,0,m5sq,mudim) - 2*m2**6*m5**8*B0del(0,0,m5sq,mudim) - 32*m2sq*m4**4*m5**8*B0del(0,0,m5sq,mudim) + 16*m2**4*m4sq*m5**8*B0del(0,0,m5sq,mudim) + 2*m2**12*m5sq*B0del(0,0,m5sq,mudim) + 86*m2**8*m4**4*m5sq*B0del(0,0,m5sq,mudim) - 146*m2**6*m4**6*m5sq*B0del(0,0,m5sq,mudim) + 112*m2**4*m4**8*m5sq*B0del(0,0,m5sq,mudim) - 32*m2sq*m4**10*m5sq*B0del(0,0,m5sq,mudim) - 22*m2**10*m4sq*m5sq*B0del(0,0,m5sq,mudim) - 4*m2**10*m4**4*B0fin(0,0,m2sq,mudim) + 16*m2**8*m4**6*B0fin(0,0,m2sq,mudim) - 24*m2**6*m4**8*B0fin(0,0,m2sq,mudim) + 16*m2**4*m4**10*B0fin(0,0,m2sq,mudim) - 4*m2sq*m4**12*B0fin(0,0,m2sq,mudim) - 4*m2**10*m5**4*B0fin(0,0,m2sq,mudim) - 8*m2**6*m4**4*m5**4*B0fin(0,0,m2sq,mudim) - 128*m2**4*m4**6*m5**4*B0fin(0,0,m2sq,mudim) - 40*m2sq*m4**8*m5**4*B0fin(0,0,m2sq,mudim) + 8*m2**8*m4sq*m5**4*B0fin(0,0,m2sq,mudim) + 4*m2**8*m5**6*B0fin(0,0,m2sq,mudim) + 96*m2**4*m4**4*m5**6*B0fin(0,0,m2sq,mudim) + 40*m2sq*m4**6*m5**6*B0fin(0,0,m2sq,mudim) - 8*m2**6*m4sq*m5**6*B0fin(0,0,m2sq,mudim) - 20*m2sq*m4**4*m5**8*B0fin(0,0,m2sq,mudim) - 16*m2**4*m4sq*m5**8*B0fin(0,0,m2sq,mudim) + 4*m2sq*m4sq*m5**10*B0fin(0,0,m2sq,mudim) - 28*m2**8*m4**4*m5sq*B0fin(0,0,m2sq,mudim) + 40*m2**6*m4**6*m5sq*B0fin(0,0,m2sq,mudim) + 32*m2**4*m4**8*m5sq*B0fin(0,0,m2sq,mudim) + 20*m2sq*m4**10*m5sq*B0fin(0,0,m2sq,mudim) + 8*m2**10*m4sq*m5sq*B0fin(0,0,m2sq,mudim) - 32*m2**10*m4**4*B0fin(0,0,m4sq,mudim) + 152*m2**8*m4**6*B0fin(0,0,m4sq,mudim) - 292*m2**6*m4**8*B0fin(0,0,m4sq,mudim) + 254*m2**4*m4**10*B0fin(0,0,m4sq,mudim) - 92*m2sq*m4**12*B0fin(0,0,m4sq,mudim) + 8*m4**14*B0fin(0,0,m4sq,mudim) + 2*m2**12*m4sq*B0fin(0,0,m4sq,mudim) - 2*m2**10*m5**4*B0fin(0,0,m4sq,mudim) + 42*m2**6*m4**4*m5**4*B0fin(0,0,m4sq,mudim) + 172*m2**4*m4**6*m5**4*B0fin(0,0,m4sq,mudim) + 72*m2sq*m4**8*m5**4*B0fin(0,0,m4sq,mudim) + 80*m4**10*m5**4*B0fin(0,0,m4sq,mudim) - 24*m2**8*m4sq*m5**4*B0fin(0,0,m4sq,mudim) + 6*m2**8*m5**6*B0fin(0,0,m4sq,mudim) - 108*m2**4*m4**4*m5**6*B0fin(0,0,m4sq,mudim) - 200*m2sq*m4**6*m5**6*B0fin(0,0,m4sq,mudim) - 80*m4**8*m5**6*B0fin(0,0,m4sq,mudim) + 34*m2**6*m4sq*m5**6*B0fin(0,0,m4sq,mudim) - 6*m2**6*m5**8*B0fin(0,0,m4sq,mudim) + 84*m2sq*m4**4*m5**8*B0fin(0,0,m4sq,mudim) + 40*m4**6*m5**8*B0fin(0,0,m4sq,mudim) - 10*m2**4*m4sq*m5**8*B0fin(0,0,m4sq,mudim) + 2*m2**4*m5**10*B0fin(0,0,m4sq,mudim) - 8*m4**4*m5**10*B0fin(0,0,m4sq,mudim) - 4*m2sq*m4sq*m5**10*B0fin(0,0,m4sq,mudim) + 58*m2**8*m4**4*m5sq*B0fin(0,0,m4sq,mudim) - 290*m2**6*m4**6*m5sq*B0fin(0,0,m4sq,mudim) + 202*m2**4*m4**8*m5sq*B0fin(0,0,m4sq,mudim) + 140*m2sq*m4**10*m5sq*B0fin(0,0,m4sq,mudim) - 40*m4**12*m5sq*B0fin(0,0,m4sq,mudim) + 2*m2**10*m4sq*m5sq*B0fin(0,0,m4sq,mudim) - 10*m2**10*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 58*m2**8*m4**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 114*m2**6*m4**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 94*m2**4*m4**10*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 28*m2sq*m4**12*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 4*m2**10*m5**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 114*m2**6*m4**4*m5**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 68*m2**4*m4**6*m5**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 56*m2sq*m4**8*m5**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 26*m2**8*m4sq*m5**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 10*m2**8*m5**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 60*m2**4*m4**4*m5**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 8*m2sq*m4**6*m5**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 10*m2**6*m4sq*m5**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 8*m2**6*m5**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 20*m2sq*m4**4*m5**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 6*m2**4*m4sq*m5**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 2*m2**4*m5**10*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 4*m2sq*m4sq*m5**10*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 42*m2**8*m4**4*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 2*m2**6*m4**6*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 26*m2**4*m4**8*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 76*m2sq*m4**10*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 14*m2**10*m4sq*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 8*m2**10*m4**4*B0fin(0,0,m4sq,mudim)**2 + 26*m2**8*m4**6*B0fin(0,0,m4sq,mudim)**2 - 44*m2**6*m4**8*B0fin(0,0,m4sq,mudim)**2 + 41*m2**4*m4**10*B0fin(0,0,m4sq,mudim)**2 - 20*m2sq*m4**12*B0fin(0,0,m4sq,mudim)**2 + 4*m4**14*B0fin(0,0,m4sq,mudim)**2 + m2**12*m4sq*B0fin(0,0,m4sq,mudim)**2 + 4*m2**10*m5**4*B0fin(0,0,m4sq,mudim)**2 + 8*m2**6*m4**4*m5**4*B0fin(0,0,m4sq,mudim)**2 + 18*m2**4*m4**6*m5**4*B0fin(0,0,m4sq,mudim)**2 - 40*m2sq*m4**8*m5**4*B0fin(0,0,m4sq,mudim)**2 + 40*m4**10*m5**4*B0fin(0,0,m4sq,mudim)**2 - 14*m2**8*m4sq*m5**4*B0fin(0,0,m4sq,mudim)**2 - 6*m2**8*m5**6*B0fin(0,0,m4sq,mudim)**2 - 2*m2**4*m4**4*m5**6*B0fin(0,0,m4sq,mudim)**2 + 8*m2sq*m4**6*m5**6*B0fin(0,0,m4sq,mudim)**2 - 40*m4**8*m5**6*B0fin(0,0,m4sq,mudim)**2 + 16*m2**6*m4sq*m5**6*B0fin(0,0,m4sq,mudim)**2 + 4*m2**6*m5**8*B0fin(0,0,m4sq,mudim)**2 - 4*m2sq*m4**4*m5**8*B0fin(0,0,m4sq,mudim)**2 + 20*m4**6*m5**8*B0fin(0,0,m4sq,mudim)**2 - 11*m2**4*m4sq*m5**8*B0fin(0,0,m4sq,mudim)**2 - m2**4*m5**10*B0fin(0,0,m4sq,mudim)**2 - 4*m4**4*m5**10*B0fin(0,0,m4sq,mudim)**2 + 4*m2sq*m4sq*m5**10*B0fin(0,0,m4sq,mudim)**2 - m2**12*m5sq*B0fin(0,0,m4sq,mudim)**2 - 6*m2**8*m4**4*m5sq*B0fin(0,0,m4sq,mudim)**2 + 16*m2**6*m4**6*m5sq*B0fin(0,0,m4sq,mudim)**2 - 45*m2**4*m4**8*m5sq*B0fin(0,0,m4sq,mudim)**2 + 52*m2sq*m4**10*m5sq*B0fin(0,0,m4sq,mudim)**2 - 20*m4**12*m5sq*B0fin(0,0,m4sq,mudim)**2 + 4*m2**10*m4sq*m5sq*B0fin(0,0,m4sq,mudim)**2 - 14*m2**10*m5**4*B0fin(0,0,m5sq,mudim) - 362*m2**6*m4**4*m5**4*B0fin(0,0,m5sq,mudim) + 336*m2**4*m4**6*m5**4*B0fin(0,0,m5sq,mudim) - 160*m2sq*m4**8*m5**4*B0fin(0,0,m5sq,mudim) + 128*m2**8*m4sq*m5**4*B0fin(0,0,m5sq,mudim) + 18*m2**8*m5**6*B0fin(0,0,m5sq,mudim) + 176*m2**4*m4**4*m5**6*B0fin(0,0,m5sq,mudim) + 224*m2sq*m4**6*m5**6*B0fin(0,0,m5sq,mudim) - 130*m2**6*m4sq*m5**6*B0fin(0,0,m5sq,mudim) - 6*m2**6*m5**8*B0fin(0,0,m5sq,mudim) - 96*m2sq*m4**4*m5**8*B0fin(0,0,m5sq,mudim) + 48*m2**4*m4sq*m5**8*B0fin(0,0,m5sq,mudim) + 2*m2**12*m5sq*B0fin(0,0,m5sq,mudim) + 46*m2**8*m4**4*m5sq*B0fin(0,0,m5sq,mudim) - 14*m2**6*m4**6*m5sq*B0fin(0,0,m5sq,mudim) - 48*m2**4*m4**8*m5sq*B0fin(0,0,m5sq,mudim) + 32*m2sq*m4**10*m5sq*B0fin(0,0,m5sq,mudim) - 18*m2**10*m4sq*m5sq*B0fin(0,0,m5sq,mudim) - 6*m2**10*m5**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 102*m2**6*m4**4*m5**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 48*m2**4*m4**6*m5**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 96*m2sq*m4**8*m5**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 48*m2**8*m4sq*m5**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 8*m2**8*m5**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 80*m2**4*m4**4*m5**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 96*m2sq*m4**6*m5**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 58*m2**6*m4sq*m5**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m2**6*m5**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 32*m2sq*m4**4*m5**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 16*m2**4*m4sq*m5**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 56*m2**8*m4**4*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 162*m2**6*m4**6*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 144*m2**4*m4**8*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 32*m2sq*m4**10*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 6*m2**10*m4sq*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 4*m2**10*m5**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) - 184*m2**6*m4**4*m5**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) + 192*m2**4*m4**6*m5**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) + 128*m2sq*m4**8*m5**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) + 48*m2**8*m4sq*m5**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m2**8*m5**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) + 64*m2**4*m4**4*m5**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) - 64*m2sq*m4**6*m5**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) - 20*m2**6*m4sq*m5**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m2**12*m5sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) + 142*m2**8*m4**4*m5sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) - 308*m2**6*m4**6*m5sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) + 256*m2**4*m4**8*m5sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) - 64*m2sq*m4**10*m5sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) - 28*m2**10*m4sq*m5sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) - 12*m2**8*m4**4*T134fin(m4,m4,m2,mudim) + 28*m2**6*m4**6*T134fin(m4,m4,m2,mudim) - 32*m2**4*m4**8*T134fin(m4,m4,m2,mudim) + 18*m2sq*m4**10*T134fin(m4,m4,m2,mudim) - 4*m4**12*T134fin(m4,m4,m2,mudim) + 2*m2**10*m4sq*T134fin(m4,m4,m2,mudim) + 8*m2**8*m5**4*T134fin(m4,m4,m2,mudim) - 8*m2**4*m4**4*m5**4*T134fin(m4,m4,m2,mudim) + 20*m2sq*m4**6*m5**4*T134fin(m4,m4,m2,mudim) - 40*m4**8*m5**4*T134fin(m4,m4,m2,mudim) - 12*m2**6*m4sq*m5**4*T134fin(m4,m4,m2,mudim) - 12*m2**6*m5**6*T134fin(m4,m4,m2,mudim) + 12*m2sq*m4**4*m5**6*T134fin(m4,m4,m2,mudim) + 40*m4**6*m5**6*T134fin(m4,m4,m2,mudim) + 8*m2**4*m4sq*m5**6*T134fin(m4,m4,m2,mudim) + 8*m2**4*m5**8*T134fin(m4,m4,m2,mudim) - 20*m4**4*m5**8*T134fin(m4,m4,m2,mudim) - 6*m2sq*m4sq*m5**8*T134fin(m4,m4,m2,mudim) - 2*m2sq*m5**10*T134fin(m4,m4,m2,mudim) + 4*m4sq*m5**10*T134fin(m4,m4,m2,mudim) - 2*m2**10*m5sq*T134fin(m4,m4,m2,mudim) - 4*m2**6*m4**4*m5sq*T134fin(m4,m4,m2,mudim) + 24*m2**4*m4**6*m5sq*T134fin(m4,m4,m2,mudim) - 42*m2sq*m4**8*m5sq*T134fin(m4,m4,m2,mudim) + 20*m4**10*m5sq*T134fin(m4,m4,m2,mudim) + 4*m2**8*m4sq*m5sq*T134fin(m4,m4,m2,mudim) - 2*m2**12*T134fin(m5,m4,0,mudim) - 108*m2**8*m4**4*T134fin(m5,m4,0,mudim) + 232*m2**6*m4**6*T134fin(m5,m4,0,mudim) - 258*m2**4*m4**8*T134fin(m5,m4,0,mudim) + 144*m2sq*m4**10*T134fin(m5,m4,0,mudim) - 32*m4**12*T134fin(m5,m4,0,mudim) + 24*m2**10*m4sq*T134fin(m5,m4,0,mudim) - 12*m2**8*m5**4*T134fin(m5,m4,0,mudim) - 140*m2**4*m4**4*m5**4*T134fin(m5,m4,0,mudim) - 32*m2sq*m4**6*m5**4*T134fin(m5,m4,0,mudim) - 192*m4**8*m5**4*T134fin(m5,m4,0,mudim) + 88*m2**6*m4sq*m5**4*T134fin(m5,m4,0,mudim) + 8*m2**6*m5**6*T134fin(m5,m4,0,mudim) + 64*m2sq*m4**4*m5**6*T134fin(m5,m4,0,mudim) + 128*m4**6*m5**6*T134fin(m5,m4,0,mudim) - 56*m2**4*m4sq*m5**6*T134fin(m5,m4,0,mudim) - 2*m2**4*m5**8*T134fin(m5,m4,0,mudim) - 32*m4**4*m5**8*T134fin(m5,m4,0,mudim) + 16*m2sq*m4sq*m5**8*T134fin(m5,m4,0,mudim) + 8*m2**10*m5sq*T134fin(m5,m4,0,mudim) + 184*m2**6*m4**4*m5sq*T134fin(m5,m4,0,mudim) - 56*m2**4*m4**6*m5sq*T134fin(m5,m4,0,mudim) - 192*m2sq*m4**8*m5sq*T134fin(m5,m4,0,mudim) + 128*m4**10*m5sq*T134fin(m5,m4,0,mudim) - 72*m2**8*m4sq*m5sq*T134fin(m5,m4,0,mudim) + 22*m2**8*m4**4*T134fin(m5,m4,m2,mudim) - 86*m2**6*m4**6*T134fin(m5,m4,m2,mudim) + 146*m2**4*m4**8*T134fin(m5,m4,m2,mudim) - 112*m2sq*m4**10*T134fin(m5,m4,m2,mudim) + 32*m4**12*T134fin(m5,m4,m2,mudim) - 2*m2**10*m4sq*T134fin(m5,m4,m2,mudim) + 2*m2**8*m5**4*T134fin(m5,m4,m2,mudim) - 4*m2**4*m4**4*m5**4*T134fin(m5,m4,m2,mudim) + 192*m4**8*m5**4*T134fin(m5,m4,m2,mudim) - 10*m2**6*m4sq*m5**4*T134fin(m5,m4,m2,mudim) - 6*m2**6*m5**6*T134fin(m5,m4,m2,mudim) - 32*m2sq*m4**4*m5**6*T134fin(m5,m4,m2,mudim) - 128*m4**6*m5**6*T134fin(m5,m4,m2,mudim) + 40*m2**4*m4sq*m5**6*T134fin(m5,m4,m2,mudim) + 2*m2**4*m5**8*T134fin(m5,m4,m2,mudim) + 32*m4**4*m5**8*T134fin(m5,m4,m2,mudim) - 16*m2sq*m4sq*m5**8*T134fin(m5,m4,m2,mudim) + 2*m2**10*m5sq*T134fin(m5,m4,m2,mudim) + 102*m2**6*m4**4*m5sq*T134fin(m5,m4,m2,mudim) - 184*m2**4*m4**6*m5sq*T134fin(m5,m4,m2,mudim) + 160*m2sq*m4**8*m5sq*T134fin(m5,m4,m2,mudim) - 128*m4**10*m5sq*T134fin(m5,m4,m2,mudim) - 24*m2**8*m4sq*m5sq*T134fin(m5,m4,m2,mudim))/(2.*m2**4*(m2 - 2*m4)**2*(m2 + 2*m4)**2*(m2 + m4 - m5)**2*(m2 - m4 + m5)**2*(-m2 + m4 + m5)**2*(m2 + m4 + m5)**2*(m4sq - m5sq)**2)
		def eval_167():
			return -0.5*(8*m2**12*m3**4 - 16*m2**10*m3**6 + 8*m2**8*m3**8 - 16*m2**12*m4**4 - 266*m2**8*m3**4*m4**4 + 150*m2**6*m3**6*m4**4 + 10*m2**4*m3**8*m4**4 + 122*m2**10*m3sq*m4**4 + 116*m2**10*m4**6 - 62*m2**6*m3**4*m4**6 + 34*m2**4*m3**6*m4**6 - 34*m2sq*m3**8*m4**6 - 54*m2**8*m3sq*m4**6 - 268*m2**8*m4**8 - 450*m2**4*m3**4*m4**8 + 188*m2sq*m3**6*m4**8 + 4*m3**8*m4**8 + 526*m2**6*m3sq*m4**8 + 268*m2**6*m4**10 - 202*m2sq*m3**4*m4**10 - 24*m3**6*m4**10 - 42*m2**4*m3sq*m4**10 - 116*m2**4*m4**12 + 36*m3**4*m4**12 + 80*m2sq*m3sq*m4**12 + 16*m2sq*m4**14 - 16*m3sq*m4**14 + 72*m2**10*m3**4*m4sq - 8*m2**8*m3**6*m4sq - 24*m2**6*m3**8*m4sq - 40*m2**12*m3sq*m4sq + 2*m2sq*m3sq*(m3sq - 4*m4sq)*(4*m2**10 + 2*m2sq*(2*m3**4*m4**4 - 3*m3sq*m4**6 + 7*m4**8) - 3*m4**6*(m3sq - m4sq)**2 - 2*m2**8*(4*m3sq + 5*m4sq) + m2**4*(37*m3sq*m4**4 - 30*m4**6 - 14*m3**4*m4sq) + m2**6*(4*m3**4 - 11*m4**4 + 16*m3sq*m4sq))*B0del(0,0,m2sq,mudim) - 2*m2sq*m3sq*(m2sq - m4sq)**2*m4sq*(m2sq - 3*m3sq + 3*m4sq)*(4*m2**4 + 4*m4**4 - 17*m2sq*m4sq)*B0del(0,0,m3sq,mudim) - 16*m2**12*m4**4*B0del(0,0,m4sq,mudim) + 34*m2**8*m3**4*m4**4*B0del(0,0,m4sq,mudim) - 36*m2**6*m3**6*m4**4*B0del(0,0,m4sq,mudim) + 2*m2**4*m3**8*m4**4*B0del(0,0,m4sq,mudim) + 16*m2**10*m3sq*m4**4*B0del(0,0,m4sq,mudim) + 116*m2**10*m4**6*B0del(0,0,m4sq,mudim) + 42*m2**6*m3**4*m4**6*B0del(0,0,m4sq,mudim) + 78*m2**4*m3**6*m4**6*B0del(0,0,m4sq,mudim) - 28*m2sq*m3**8*m4**6*B0del(0,0,m4sq,mudim) - 208*m2**8*m3sq*m4**6*B0del(0,0,m4sq,mudim) - 268*m2**8*m4**8*B0del(0,0,m4sq,mudim) - 376*m2**4*m3**4*m4**8*B0del(0,0,m4sq,mudim) + 152*m2sq*m3**6*m4**8*B0del(0,0,m4sq,mudim) + 4*m3**8*m4**8*B0del(0,0,m4sq,mudim) + 488*m2**6*m3sq*m4**8*B0del(0,0,m4sq,mudim) + 268*m2**6*m4**10*B0del(0,0,m4sq,mudim) - 172*m2sq*m3**4*m4**10*B0del(0,0,m4sq,mudim) - 24*m3**6*m4**10*B0del(0,0,m4sq,mudim) - 72*m2**4*m3sq*m4**10*B0del(0,0,m4sq,mudim) - 116*m2**4*m4**12*B0del(0,0,m4sq,mudim) + 36*m3**4*m4**12*B0del(0,0,m4sq,mudim) + 80*m2sq*m3sq*m4**12*B0del(0,0,m4sq,mudim) + 16*m2sq*m4**14*B0del(0,0,m4sq,mudim) - 16*m3sq*m4**14*B0del(0,0,m4sq,mudim) + 4*m2**10*m3**4*m4sq*B0del(0,0,m4sq,mudim) - 8*m2**8*m3**6*m4sq*B0del(0,0,m4sq,mudim) + 4*m2**6*m3**8*m4sq*B0del(0,0,m4sq,mudim) + 8*m2**12*m3**4*B0fin(0,0,m2sq,mudim) - 16*m2**10*m3**6*B0fin(0,0,m2sq,mudim) + 8*m2**8*m3**8*B0fin(0,0,m2sq,mudim) - 150*m2**8*m3**4*m4**4*B0fin(0,0,m2sq,mudim) + 186*m2**6*m3**6*m4**4*B0fin(0,0,m2sq,mudim) + 8*m2**4*m3**8*m4**4*B0fin(0,0,m2sq,mudim) + 80*m2**10*m3sq*m4**4*B0fin(0,0,m2sq,mudim) - 356*m2**6*m3**4*m4**6*B0fin(0,0,m2sq,mudim) - 44*m2**4*m3**6*m4**6*B0fin(0,0,m2sq,mudim) - 6*m2sq*m3**8*m4**6*B0fin(0,0,m2sq,mudim) + 88*m2**8*m3sq*m4**6*B0fin(0,0,m2sq,mudim) + 76*m2**4*m3**4*m4**8*B0fin(0,0,m2sq,mudim) + 36*m2sq*m3**6*m4**8*B0fin(0,0,m2sq,mudim) + 240*m2**6*m3sq*m4**8*B0fin(0,0,m2sq,mudim) - 54*m2sq*m3**4*m4**10*B0fin(0,0,m2sq,mudim) - 112*m2**4*m3sq*m4**10*B0fin(0,0,m2sq,mudim) + 24*m2sq*m3sq*m4**12*B0fin(0,0,m2sq,mudim) + 44*m2**10*m3**4*m4sq*B0fin(0,0,m2sq,mudim) - 28*m2**6*m3**8*m4sq*B0fin(0,0,m2sq,mudim) - 32*m2**12*m3sq*m4sq*B0fin(0,0,m2sq,mudim) + 4*m2**12*m3**4*B0fin(0,0,m2sq,mudim)**2 - 8*m2**10*m3**6*B0fin(0,0,m2sq,mudim)**2 + 4*m2**8*m3**8*B0fin(0,0,m2sq,mudim)**2 - 68*m2**8*m3**4*m4**4*B0fin(0,0,m2sq,mudim)**2 + 88*m2**6*m3**6*m4**4*B0fin(0,0,m2sq,mudim)**2 + 16*m2**4*m3**8*m4**4*B0fin(0,0,m2sq,mudim)**2 + 112*m2**10*m3sq*m4**4*B0fin(0,0,m2sq,mudim)**2 - 84*m2**6*m3**4*m4**6*B0fin(0,0,m2sq,mudim)**2 - 96*m2**4*m3**6*m4**6*B0fin(0,0,m2sq,mudim)**2 - 240*m2**8*m3sq*m4**6*B0fin(0,0,m2sq,mudim)**2 + 144*m2**4*m3**4*m4**8*B0fin(0,0,m2sq,mudim)**2 + 208*m2**6*m3sq*m4**8*B0fin(0,0,m2sq,mudim)**2 - 64*m2**4*m3sq*m4**10*B0fin(0,0,m2sq,mudim)**2 + 4*m2**10*m3**4*m4sq*B0fin(0,0,m2sq,mudim)**2 + 16*m2**8*m3**6*m4sq*B0fin(0,0,m2sq,mudim)**2 - 20*m2**6*m3**8*m4sq*B0fin(0,0,m2sq,mudim)**2 - 16*m2**12*m3sq*m4sq*B0fin(0,0,m2sq,mudim)**2 - 150*m2**8*m3**4*m4**4*B0fin(0,0,m3sq,mudim) + 26*m2**10*m3sq*m4**4*B0fin(0,0,m3sq,mudim) + 252*m2**6*m3**4*m4**6*B0fin(0,0,m3sq,mudim) + 66*m2**8*m3sq*m4**6*B0fin(0,0,m3sq,mudim) - 150*m2**4*m3**4*m4**8*B0fin(0,0,m3sq,mudim) - 202*m2**6*m3sq*m4**8*B0fin(0,0,m3sq,mudim) + 24*m2sq*m3**4*m4**10*B0fin(0,0,m3sq,mudim) + 142*m2**4*m3sq*m4**10*B0fin(0,0,m3sq,mudim) - 24*m2sq*m3sq*m4**12*B0fin(0,0,m3sq,mudim) + 24*m2**10*m3**4*m4sq*B0fin(0,0,m3sq,mudim) - 8*m2**12*m3sq*m4sq*B0fin(0,0,m3sq,mudim) - 84*m2**8*m3**4*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) - 64*m2**10*m3sq*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) + 84*m2**6*m3**4*m4**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) + 336*m2**8*m3sq*m4**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) - 16*m2**4*m3**4*m4**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) - 336*m2**6*m3sq*m4**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) + 64*m2**4*m3sq*m4**10*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) + 16*m2**10*m3**4*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) - 16*m2**12*m4**4*B0fin(0,0,m4sq,mudim) + 34*m2**8*m3**4*m4**4*B0fin(0,0,m4sq,mudim) - 36*m2**6*m3**6*m4**4*B0fin(0,0,m4sq,mudim) + 2*m2**4*m3**8*m4**4*B0fin(0,0,m4sq,mudim) + 16*m2**10*m3sq*m4**4*B0fin(0,0,m4sq,mudim) + 116*m2**10*m4**6*B0fin(0,0,m4sq,mudim) + 42*m2**6*m3**4*m4**6*B0fin(0,0,m4sq,mudim) + 78*m2**4*m3**6*m4**6*B0fin(0,0,m4sq,mudim) - 28*m2sq*m3**8*m4**6*B0fin(0,0,m4sq,mudim) - 208*m2**8*m3sq*m4**6*B0fin(0,0,m4sq,mudim) - 268*m2**8*m4**8*B0fin(0,0,m4sq,mudim) - 376*m2**4*m3**4*m4**8*B0fin(0,0,m4sq,mudim) + 152*m2sq*m3**6*m4**8*B0fin(0,0,m4sq,mudim) + 4*m3**8*m4**8*B0fin(0,0,m4sq,mudim) + 488*m2**6*m3sq*m4**8*B0fin(0,0,m4sq,mudim) + 268*m2**6*m4**10*B0fin(0,0,m4sq,mudim) - 172*m2sq*m3**4*m4**10*B0fin(0,0,m4sq,mudim) - 24*m3**6*m4**10*B0fin(0,0,m4sq,mudim) - 72*m2**4*m3sq*m4**10*B0fin(0,0,m4sq,mudim) - 116*m2**4*m4**12*B0fin(0,0,m4sq,mudim) + 36*m3**4*m4**12*B0fin(0,0,m4sq,mudim) + 80*m2sq*m3sq*m4**12*B0fin(0,0,m4sq,mudim) + 16*m2sq*m4**14*B0fin(0,0,m4sq,mudim) - 16*m3sq*m4**14*B0fin(0,0,m4sq,mudim) + 4*m2**10*m3**4*m4sq*B0fin(0,0,m4sq,mudim) - 8*m2**8*m3**6*m4sq*B0fin(0,0,m4sq,mudim) + 4*m2**6*m3**8*m4sq*B0fin(0,0,m4sq,mudim) + 70*m2**8*m3**4*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 10*m2**6*m3**6*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 24*m2**4*m3**8*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 80*m2**10*m3sq*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 272*m2**6*m3**4*m4**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 148*m2**4*m3**6*m4**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 6*m2sq*m3**8*m4**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 232*m2**8*m3sq*m4**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 196*m2**4*m3**4*m4**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 36*m2sq*m3**6*m4**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 160*m2**6*m3sq*m4**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 54*m2sq*m3**4*m4**10*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 48*m2**4*m3sq*m4**10*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 24*m2sq*m3sq*m4**12*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 20*m2**10*m3**4*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 32*m2**8*m3**6*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 12*m2**6*m3**8*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 66*m2**8*m3**4*m4**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + 90*m2**10*m3sq*m4**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + 168*m2**6*m3**4*m4**6*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) - 270*m2**8*m3sq*m4**6*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) - 134*m2**4*m3**4*m4**8*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + 134*m2**6*m3sq*m4**8*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + 24*m2sq*m3**4*m4**10*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + 78*m2**4*m3sq*m4**10*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) - 24*m2sq*m3sq*m4**12*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + 8*m2**10*m3**4*m4sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) - 8*m2**12*m3sq*m4sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) - 8*m2**12*m4**4*B0fin(0,0,m4sq,mudim)**2 + 15*m2**8*m3**4*m4**4*B0fin(0,0,m4sq,mudim)**2 - 23*m2**6*m3**6*m4**4*B0fin(0,0,m4sq,mudim)**2 + 13*m2**4*m3**8*m4**4*B0fin(0,0,m4sq,mudim)**2 + 3*m2**10*m3sq*m4**4*B0fin(0,0,m4sq,mudim)**2 + 58*m2**10*m4**6*B0fin(0,0,m4sq,mudim)**2 + 73*m2**6*m3**4*m4**6*B0fin(0,0,m4sq,mudim)**2 - 35*m2**4*m3**6*m4**6*B0fin(0,0,m4sq,mudim)**2 - 11*m2sq*m3**8*m4**6*B0fin(0,0,m4sq,mudim)**2 - 85*m2**8*m3sq*m4**6*B0fin(0,0,m4sq,mudim)**2 - 134*m2**8*m4**8*B0fin(0,0,m4sq,mudim)**2 - 23*m2**4*m3**4*m4**8*B0fin(0,0,m4sq,mudim)**2 + 58*m2sq*m3**6*m4**8*B0fin(0,0,m4sq,mudim)**2 + 2*m3**8*m4**8*B0fin(0,0,m4sq,mudim)**2 + 97*m2**6*m3sq*m4**8*B0fin(0,0,m4sq,mudim)**2 + 134*m2**6*m4**10*B0fin(0,0,m4sq,mudim)**2 - 71*m2sq*m3**4*m4**10*B0fin(0,0,m4sq,mudim)**2 - 12*m3**6*m4**10*B0fin(0,0,m4sq,mudim)**2 - 51*m2**4*m3sq*m4**10*B0fin(0,0,m4sq,mudim)**2 - 58*m2**4*m4**12*B0fin(0,0,m4sq,mudim)**2 + 18*m3**4*m4**12*B0fin(0,0,m4sq,mudim)**2 + 40*m2sq*m3sq*m4**12*B0fin(0,0,m4sq,mudim)**2 + 8*m2sq*m4**14*B0fin(0,0,m4sq,mudim)**2 - 8*m3sq*m4**14*B0fin(0,0,m4sq,mudim)**2 - 12*m2**10*m3**4*m4sq*B0fin(0,0,m4sq,mudim)**2 + 12*m2**8*m3**6*m4sq*B0fin(0,0,m4sq,mudim)**2 - 4*m2**6*m3**8*m4sq*B0fin(0,0,m4sq,mudim)**2 + 4*m2**12*m3sq*m4sq*B0fin(0,0,m4sq,mudim)**2 - 32*m2**10*m4**4*T134fin(m4,m2,0,mudim) + 6*m2**6*m3**4*m4**4*T134fin(m4,m2,0,mudim) - 54*m2**4*m3**6*m4**4*T134fin(m4,m2,0,mudim) + 34*m2sq*m3**8*m4**4*T134fin(m4,m2,0,mudim) + 46*m2**8*m3sq*m4**4*T134fin(m4,m2,0,mudim) + 200*m2**8*m4**6*T134fin(m4,m2,0,mudim) + 312*m2**4*m3**4*m4**6*T134fin(m4,m2,0,mudim) - 180*m2sq*m3**6*m4**6*T134fin(m4,m2,0,mudim) - 8*m3**8*m4**6*T134fin(m4,m2,0,mudim) - 324*m2**6*m3sq*m4**6*T134fin(m4,m2,0,mudim) - 336*m2**6*m4**8*T134fin(m4,m2,0,mudim) + 210*m2sq*m3**4*m4**8*T134fin(m4,m2,0,mudim) + 48*m3**6*m4**8*T134fin(m4,m2,0,mudim) + 78*m2**4*m3sq*m4**8*T134fin(m4,m2,0,mudim) + 200*m2**4*m4**10*T134fin(m4,m2,0,mudim) - 72*m3**4*m4**10*T134fin(m4,m2,0,mudim) - 128*m2sq*m3sq*m4**10*T134fin(m4,m2,0,mudim) - 32*m2sq*m4**12*T134fin(m4,m2,0,mudim) + 32*m3sq*m4**12*T134fin(m4,m2,0,mudim) - 24*m2**8*m3**4*m4sq*T134fin(m4,m2,0,mudim) + 24*m2**6*m3**6*m4sq*T134fin(m4,m2,0,mudim) - 8*m2**4*m3**8*m4sq*T134fin(m4,m2,0,mudim) + 8*m2**10*m3sq*m4sq*T134fin(m4,m2,0,mudim) - 4*m2**10*m3**4*T134fin(m4,m2,m2,mudim) + 8*m2**8*m3**6*T134fin(m4,m2,m2,mudim) - 4*m2**6*m3**8*T134fin(m4,m2,m2,mudim) + 70*m2**6*m3**4*m4**4*T134fin(m4,m2,m2,mudim) - 80*m2**4*m3**6*m4**4*T134fin(m4,m2,m2,mudim) - 26*m2sq*m3**8*m4**4*T134fin(m4,m2,m2,mudim) - 120*m2**8*m3sq*m4**4*T134fin(m4,m2,m2,mudim) + 50*m2**4*m3**4*m4**6*T134fin(m4,m2,m2,mudim) + 140*m2sq*m3**6*m4**6*T134fin(m4,m2,m2,mudim) + 8*m3**8*m4**6*T134fin(m4,m2,m2,mudim) + 296*m2**6*m3sq*m4**6*T134fin(m4,m2,m2,mudim) - 186*m2sq*m3**4*m4**8*T134fin(m4,m2,m2,mudim) - 48*m3**6*m4**8*T134fin(m4,m2,m2,mudim) - 328*m2**4*m3sq*m4**8*T134fin(m4,m2,m2,mudim) + 72*m3**4*m4**10*T134fin(m4,m2,m2,mudim) + 168*m2sq*m3sq*m4**10*T134fin(m4,m2,m2,mudim) - 32*m3sq*m4**12*T134fin(m4,m2,m2,mudim) - 2*m2**8*m3**4*m4sq*T134fin(m4,m2,m2,mudim) - 20*m2**6*m3**6*m4sq*T134fin(m4,m2,m2,mudim) + 22*m2**4*m3**8*m4sq*T134fin(m4,m2,m2,mudim) + 16*m2**10*m3sq*m4sq*T134fin(m4,m2,m2,mudim) + 32*m2**10*m4**4*T134fin(m4,m3,m2,mudim) + 42*m2**6*m3**4*m4**4*T134fin(m4,m3,m2,mudim) + 82*m2**8*m3sq*m4**4*T134fin(m4,m3,m2,mudim) - 200*m2**8*m4**6*T134fin(m4,m3,m2,mudim) - 42*m2**4*m3**4*m4**6*T134fin(m4,m3,m2,mudim) - 252*m2**6*m3sq*m4**6*T134fin(m4,m3,m2,mudim) + 336*m2**6*m4**8*T134fin(m4,m3,m2,mudim) + 8*m2sq*m3**4*m4**8*T134fin(m4,m3,m2,mudim) + 218*m2**4*m3sq*m4**8*T134fin(m4,m3,m2,mudim) - 200*m2**4*m4**10*T134fin(m4,m3,m2,mudim) - 40*m2sq*m3sq*m4**10*T134fin(m4,m3,m2,mudim) + 32*m2sq*m4**12*T134fin(m4,m3,m2,mudim) - 8*m2**8*m3**4*m4sq*T134fin(m4,m3,m2,mudim) - 8*m2**10*m3sq*m4sq*T134fin(m4,m3,m2,mudim) - 38*m2**6*m3**4*m4**4*T134fin(m4,m4,m2,mudim) + 28*m2**4*m3**6*m4**4*T134fin(m4,m4,m2,mudim) + 10*m2sq*m3**8*m4**4*T134fin(m4,m4,m2,mudim) + 32*m2**8*m3sq*m4**4*T134fin(m4,m4,m2,mudim) - 14*m2**4*m3**4*m4**6*T134fin(m4,m4,m2,mudim) - 56*m2sq*m3**6*m4**6*T134fin(m4,m4,m2,mudim) - 2*m3**8*m4**6*T134fin(m4,m4,m2,mudim) - 104*m2**6*m3sq*m4**6*T134fin(m4,m4,m2,mudim) + 78*m2sq*m3**4*m4**8*T134fin(m4,m4,m2,mudim) + 12*m3**6*m4**8*T134fin(m4,m4,m2,mudim) + 120*m2**4*m3sq*m4**8*T134fin(m4,m4,m2,mudim) - 18*m3**4*m4**10*T134fin(m4,m4,m2,mudim) - 56*m2sq*m3sq*m4**10*T134fin(m4,m4,m2,mudim) + 8*m3sq*m4**12*T134fin(m4,m4,m2,mudim) - 8*m2**8*m3**4*m4sq*T134fin(m4,m4,m2,mudim) + 16*m2**6*m3**6*m4sq*T134fin(m4,m4,m2,mudim) - 8*m2**4*m3**8*m4sq*T134fin(m4,m4,m2,mudim) - 58*m2**10*m4**4*T134fin(m4,m4,m3,mudim) - 42*m2**6*m3**4*m4**4*T134fin(m4,m4,m3,mudim) + 68*m2**8*m3sq*m4**4*T134fin(m4,m4,m3,mudim) + 134*m2**8*m4**6*T134fin(m4,m4,m3,mudim) + 42*m2**4*m3**4*m4**6*T134fin(m4,m4,m3,mudim) - 134*m2**6*m4**8*T134fin(m4,m4,m3,mudim) - 8*m2sq*m3**4*m4**8*T134fin(m4,m4,m3,mudim) - 68*m2**4*m3sq*m4**8*T134fin(m4,m4,m3,mudim) + 58*m2**4*m4**10*T134fin(m4,m4,m3,mudim) + 16*m2sq*m3sq*m4**10*T134fin(m4,m4,m3,mudim) - 8*m2sq*m4**12*T134fin(m4,m4,m3,mudim) + 8*m2**12*m4sq*T134fin(m4,m4,m3,mudim) + 8*m2**8*m3**4*m4sq*T134fin(m4,m4,m3,mudim) - 16*m2**10*m3sq*m4sq*T134fin(m4,m4,m3,mudim))/(m2**2*m3**2*(m2sq - m3sq)*m4**2*(m2sq - 4*m4sq)*(m3sq - 4*m4sq)*(m2sq - m4sq)**2*(4*m2sq - m4sq)*(m2**4 + (m3sq - m4sq)**2 - 2*m2sq*(m3sq + m4sq)))
		def eval_168():
			return (20*m1**8*m3**4 - 40*m1**6*m3**6 + 40*m1**4*m3**8 - 20*m1sq*m3**10 + 4*m3**12 - 4*m1**10*m3sq + 20*m1**8*m7**4 + 116*m1**4*m3**4*m7**4 + 36*m1sq*m3**6*m7**4 + 72*m3**8*m7**4 + 12*m1**6*m3sq*m7**4 - 28*m1**6*m7**6 - 92*m1sq*m3**4*m7**6 - 48*m3**6*m7**6 - 24*m1**4*m3sq*m7**6 + 12*m1**4*m7**8 + 20*m3**4*m7**8 + 16*m1sq*m3sq*m7**8 - 2*m1sq*m7**10 - 2*m3sq*m7**10 - 2*m1**10*m7sq - 4*m1**6*m3**4*m7sq + 36*m1**4*m3**6*m7sq + 38*m1sq*m3**8*m7sq - 46*m3**10*m7sq - 22*m1**8*m3sq*m7sq - 2*m1sq*(4*m3sq - m7sq)*m7sq*(5*m1**6 + 3*m3**6 + 3*m3sq*m7**4 - m7**6 - 5*m3**4*m7sq - m1**4*(7*m3sq + 9*m7sq) - m1sq*(m3**4 - 5*m7**4 + 2*m3sq*m7sq))*B0del(0,0,m1sq,mudim) - 2*m3sq*(2*m1**10 - 2*m3**10 - 35*m3**6*m7**4 + 25*m3**4*m7**6 - 9*m3sq*m7**8 + m7**10 + 20*m3**8*m7sq - 2*m1**8*(5*m3sq + 4*m7sq) + m1**4*(-20*m3**6 - 33*m3sq*m7**4 + m7**6 - 28*m3**4*m7sq) + m1sq*(10*m3**8 - 3*m3**4*m7**4 + 22*m3sq*m7**6 - 3*m7**8 - 20*m3**6*m7sq) + m1**6*(20*m3**4 + 7*m7**4 + 36*m3sq*m7sq))*B0del(0,0,m3sq,mudim) + 10*m1**8*m7**4*B0del(0,0,m7sq,mudim) + 36*m1**4*m3**4*m7**4*B0del(0,0,m7sq,mudim) - 16*m1sq*m3**6*m7**4*B0del(0,0,m7sq,mudim) + 2*m3**8*m7**4*B0del(0,0,m7sq,mudim) - 32*m1**6*m3sq*m7**4*B0del(0,0,m7sq,mudim) - 10*m1**6*m7**6*B0del(0,0,m7sq,mudim) - 14*m1sq*m3**4*m7**6*B0del(0,0,m7sq,mudim) + 2*m3**6*m7**6*B0del(0,0,m7sq,mudim) + 22*m1**4*m3sq*m7**6*B0del(0,0,m7sq,mudim) + 2*m1**4*m7**8*B0del(0,0,m7sq,mudim) + 2*m3**4*m7**8*B0del(0,0,m7sq,mudim) - 4*m1sq*m3sq*m7**8*B0del(0,0,m7sq,mudim) - 2*m1**10*m7sq*B0del(0,0,m7sq,mudim) + 12*m1**6*m3**4*m7sq*B0del(0,0,m7sq,mudim) - 28*m1**4*m3**6*m7sq*B0del(0,0,m7sq,mudim) + 22*m1sq*m3**8*m7sq*B0del(0,0,m7sq,mudim) - 6*m3**10*m7sq*B0del(0,0,m7sq,mudim) + 2*m1**8*m3sq*m7sq*B0del(0,0,m7sq,mudim) + 4*m1**8*m7**4*B0fin(0,0,m1sq,mudim) + 10*m1**4*m3**4*m7**4*B0fin(0,0,m1sq,mudim) + 70*m1sq*m3**6*m7**4*B0fin(0,0,m1sq,mudim) + 26*m3**8*m7**4*B0fin(0,0,m1sq,mudim) + 18*m1**6*m3sq*m7**4*B0fin(0,0,m1sq,mudim) - 4*m1**6*m7**6*B0fin(0,0,m1sq,mudim) - 56*m1sq*m3**4*m7**6*B0fin(0,0,m1sq,mudim) - 30*m3**6*m7**6*B0fin(0,0,m1sq,mudim) - 6*m1**4*m3sq*m7**6*B0fin(0,0,m1sq,mudim) + 14*m3**4*m7**8*B0fin(0,0,m1sq,mudim) + 10*m1sq*m3sq*m7**8*B0fin(0,0,m1sq,mudim) - 2*m3sq*m7**10*B0fin(0,0,m1sq,mudim) - 8*m1**6*m3**4*m7sq*B0fin(0,0,m1sq,mudim) + 56*m1**4*m3**6*m7sq*B0fin(0,0,m1sq,mudim) - 24*m1sq*m3**8*m7sq*B0fin(0,0,m1sq,mudim) - 8*m3**10*m7sq*B0fin(0,0,m1sq,mudim) - 16*m1**8*m3sq*m7sq*B0fin(0,0,m1sq,mudim) + 20*m1**8*m3**4*B0fin(0,0,m3sq,mudim) - 40*m1**6*m3**6*B0fin(0,0,m3sq,mudim) + 40*m1**4*m3**8*B0fin(0,0,m3sq,mudim) - 20*m1sq*m3**10*B0fin(0,0,m3sq,mudim) + 4*m3**12*B0fin(0,0,m3sq,mudim) - 4*m1**10*m3sq*B0fin(0,0,m3sq,mudim) + 2*m1**8*m7**4*B0fin(0,0,m3sq,mudim) + 78*m1**4*m3**4*m7**4*B0fin(0,0,m3sq,mudim) + 30*m1sq*m3**6*m7**4*B0fin(0,0,m3sq,mudim) + 8*m3**8*m7**4*B0fin(0,0,m3sq,mudim) + 10*m1**6*m3sq*m7**4*B0fin(0,0,m3sq,mudim) - 6*m1**6*m7**6*B0fin(0,0,m3sq,mudim) - 62*m1sq*m3**4*m7**6*B0fin(0,0,m3sq,mudim) + 4*m3**6*m7**6*B0fin(0,0,m3sq,mudim) - 32*m1**4*m3sq*m7**6*B0fin(0,0,m3sq,mudim) + 6*m1**4*m7**8*B0fin(0,0,m3sq,mudim) + 18*m1sq*m3sq*m7**8*B0fin(0,0,m3sq,mudim) - 2*m1sq*m7**10*B0fin(0,0,m3sq,mudim) - 72*m1**6*m3**4*m7sq*B0fin(0,0,m3sq,mudim) + 104*m1**4*m3**6*m7sq*B0fin(0,0,m3sq,mudim) - 24*m1sq*m3**8*m7sq*B0fin(0,0,m3sq,mudim) - 16*m3**10*m7sq*B0fin(0,0,m3sq,mudim) + 8*m1**8*m3sq*m7sq*B0fin(0,0,m3sq,mudim) + 4*m1**8*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 18*m1**4*m3**4*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 46*m1sq*m3**6*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 18*m3**8*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 42*m1**6*m3sq*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 10*m1**6*m7**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 34*m1sq*m3**4*m7**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 12*m3**6*m7**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 40*m1**4*m3sq*m7**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 8*m1**4*m7**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 2*m3**4*m7**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 14*m1sq*m3sq*m7**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 2*m1sq*m7**10*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 8*m1**6*m3**4*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 56*m1**4*m3**6*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 24*m1sq*m3**8*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 8*m3**10*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 16*m1**8*m3sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 10*m1**8*m3**4*B0fin(0,0,m3sq,mudim)**2 - 20*m1**6*m3**6*B0fin(0,0,m3sq,mudim)**2 + 20*m1**4*m3**8*B0fin(0,0,m3sq,mudim)**2 - 10*m1sq*m3**10*B0fin(0,0,m3sq,mudim)**2 + 2*m3**12*B0fin(0,0,m3sq,mudim)**2 - 2*m1**10*m3sq*B0fin(0,0,m3sq,mudim)**2 - 4*m1**8*m7**4*B0fin(0,0,m3sq,mudim)**2 + 4*m1**4*m3**4*m7**4*B0fin(0,0,m3sq,mudim)**2 - 12*m1sq*m3**6*m7**4*B0fin(0,0,m3sq,mudim)**2 + 16*m3**8*m7**4*B0fin(0,0,m3sq,mudim)**2 - 4*m1**6*m3sq*m7**4*B0fin(0,0,m3sq,mudim)**2 + 6*m1**6*m7**6*B0fin(0,0,m3sq,mudim)**2 + 2*m1sq*m3**4*m7**6*B0fin(0,0,m3sq,mudim)**2 - 14*m3**6*m7**6*B0fin(0,0,m3sq,mudim)**2 + 6*m1**4*m3sq*m7**6*B0fin(0,0,m3sq,mudim)**2 - 4*m1**4*m7**8*B0fin(0,0,m3sq,mudim)**2 + 6*m3**4*m7**8*B0fin(0,0,m3sq,mudim)**2 - 2*m1sq*m3sq*m7**8*B0fin(0,0,m3sq,mudim)**2 + m1sq*m7**10*B0fin(0,0,m3sq,mudim)**2 - m3sq*m7**10*B0fin(0,0,m3sq,mudim)**2 + m1**10*m7sq*B0fin(0,0,m3sq,mudim)**2 - 6*m1**6*m3**4*m7sq*B0fin(0,0,m3sq,mudim)**2 - 10*m1**4*m3**6*m7sq*B0fin(0,0,m3sq,mudim)**2 + 21*m1sq*m3**8*m7sq*B0fin(0,0,m3sq,mudim)**2 - 9*m3**10*m7sq*B0fin(0,0,m3sq,mudim)**2 + 3*m1**8*m3sq*m7sq*B0fin(0,0,m3sq,mudim)**2 + 14*m1**8*m7**4*B0fin(0,0,m7sq,mudim) + 28*m1**4*m3**4*m7**4*B0fin(0,0,m7sq,mudim) - 64*m1sq*m3**6*m7**4*B0fin(0,0,m7sq,mudim) + 38*m3**8*m7**4*B0fin(0,0,m7sq,mudim) - 16*m1**6*m3sq*m7**4*B0fin(0,0,m7sq,mudim) - 18*m1**6*m7**6*B0fin(0,0,m7sq,mudim) + 26*m1sq*m3**4*m7**6*B0fin(0,0,m7sq,mudim) - 22*m3**6*m7**6*B0fin(0,0,m7sq,mudim) + 14*m1**4*m3sq*m7**6*B0fin(0,0,m7sq,mudim) + 6*m1**4*m7**8*B0fin(0,0,m7sq,mudim) + 6*m3**4*m7**8*B0fin(0,0,m7sq,mudim) - 12*m1sq*m3sq*m7**8*B0fin(0,0,m7sq,mudim) - 2*m1**10*m7sq*B0fin(0,0,m7sq,mudim) + 76*m1**6*m3**4*m7sq*B0fin(0,0,m7sq,mudim) - 124*m1**4*m3**6*m7sq*B0fin(0,0,m7sq,mudim) + 86*m1sq*m3**8*m7sq*B0fin(0,0,m7sq,mudim) - 22*m3**10*m7sq*B0fin(0,0,m7sq,mudim) - 14*m1**8*m3sq*m7sq*B0fin(0,0,m7sq,mudim) + 6*m1**8*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 4*m1**4*m3**4*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 18*m3**8*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) + 16*m1**6*m3sq*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 8*m1**6*m7**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) + 12*m3**6*m7**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 4*m1**4*m3sq*m7**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) + 2*m1**4*m7**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 2*m3**4*m7**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) + 64*m1**6*m3**4*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 48*m1**4*m3**6*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) + 8*m3**10*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 24*m1**8*m3sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) + 4*m1**8*m7**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim) + 40*m1**4*m3**4*m7**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim) - 16*m1sq*m3**6*m7**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim) + 20*m3**8*m7**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim) - 48*m1**6*m3sq*m7**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim) - 2*m1**6*m7**6*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim) - 14*m1sq*m3**4*m7**6*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim) - 10*m3**6*m7**6*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim) + 26*m1**4*m3sq*m7**6*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim) + 4*m3**4*m7**8*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim) - 4*m1sq*m3sq*m7**8*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim) - 2*m1**10*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim) - 52*m1**6*m3**4*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim) + 20*m1**4*m3**6*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim) + 22*m1sq*m3**8*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim) - 14*m3**10*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim) + 26*m1**8*m3sq*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim) + 32*m1**6*m3**4*T134fin(m3,m1,0,mudim) - 48*m1**4*m3**6*T134fin(m3,m1,0,mudim) + 32*m1sq*m3**8*T134fin(m3,m1,0,mudim) - 8*m3**10*T134fin(m3,m1,0,mudim) - 8*m1**8*m3sq*T134fin(m3,m1,0,mudim) - 8*m1**6*m7**4*T134fin(m3,m1,0,mudim) - 24*m1sq*m3**4*m7**4*T134fin(m3,m1,0,mudim) - 56*m3**6*m7**4*T134fin(m3,m1,0,mudim) - 40*m1**4*m3sq*m7**4*T134fin(m3,m1,0,mudim) + 12*m1**4*m7**6*T134fin(m3,m1,0,mudim) + 44*m3**4*m7**6*T134fin(m3,m1,0,mudim) + 40*m1sq*m3sq*m7**6*T134fin(m3,m1,0,mudim) - 8*m1sq*m7**8*T134fin(m3,m1,0,mudim) - 16*m3sq*m7**8*T134fin(m3,m1,0,mudim) + 2*m7**10*T134fin(m3,m1,0,mudim) + 2*m1**8*m7sq*T134fin(m3,m1,0,mudim) - 20*m1**4*m3**4*m7sq*T134fin(m3,m1,0,mudim) - 40*m1sq*m3**6*m7sq*T134fin(m3,m1,0,mudim) + 34*m3**8*m7sq*T134fin(m3,m1,0,mudim) + 24*m1**6*m3sq*m7sq*T134fin(m3,m1,0,mudim) - 32*m1**6*m3**4*T134fin(m7,m3,m1,mudim) + 48*m1**4*m3**6*T134fin(m7,m3,m1,mudim) - 32*m1sq*m3**8*T134fin(m7,m3,m1,mudim) + 8*m3**10*T134fin(m7,m3,m1,mudim) + 8*m1**8*m3sq*T134fin(m7,m3,m1,mudim) - 2*m1**6*m7**4*T134fin(m7,m3,m1,mudim) + 10*m1sq*m3**4*m7**4*T134fin(m7,m3,m1,mudim) + 10*m3**6*m7**4*T134fin(m7,m3,m1,mudim) - 18*m1**4*m3sq*m7**4*T134fin(m7,m3,m1,mudim) + 6*m1**4*m7**6*T134fin(m7,m3,m1,mudim) - 10*m3**4*m7**6*T134fin(m7,m3,m1,mudim) + 4*m1sq*m3sq*m7**6*T134fin(m7,m3,m1,mudim) - 2*m1sq*m7**8*T134fin(m7,m3,m1,mudim) + 2*m3sq*m7**8*T134fin(m7,m3,m1,mudim) - 2*m1**8*m7sq*T134fin(m7,m3,m1,mudim) - 36*m1**4*m3**4*m7sq*T134fin(m7,m3,m1,mudim) + 32*m1sq*m3**6*m7sq*T134fin(m7,m3,m1,mudim) - 10*m3**8*m7sq*T134fin(m7,m3,m1,mudim) + 16*m1**6*m3sq*m7sq*T134fin(m7,m3,m1,mudim) + 2*m1**10*T134fin(m7,m3,m3,mudim) + 20*m1**6*m3**4*T134fin(m7,m3,m3,mudim) - 20*m1**4*m3**6*T134fin(m7,m3,m3,mudim) + 10*m1sq*m3**8*T134fin(m7,m3,m3,mudim) - 2*m3**10*T134fin(m7,m3,m3,mudim) - 10*m1**8*m3sq*T134fin(m7,m3,m3,mudim) + 12*m1**6*m7**4*T134fin(m7,m3,m3,mudim) + 4*m1sq*m3**4*m7**4*T134fin(m7,m3,m3,mudim) - 12*m3**6*m7**4*T134fin(m7,m3,m3,mudim) - 4*m1**4*m3sq*m7**4*T134fin(m7,m3,m3,mudim) - 8*m1**4*m7**6*T134fin(m7,m3,m3,mudim) + 8*m3**4*m7**6*T134fin(m7,m3,m3,mudim) + 2*m1sq*m7**8*T134fin(m7,m3,m3,mudim) - 2*m3sq*m7**8*T134fin(m7,m3,m3,mudim) - 8*m1**8*m7sq*T134fin(m7,m3,m3,mudim) - 16*m1sq*m3**6*m7sq*T134fin(m7,m3,m3,mudim) + 8*m3**8*m7sq*T134fin(m7,m3,m3,mudim) + 16*m1**6*m3sq*m7sq*T134fin(m7,m3,m3,mudim))/(2.*(m1 - m3)**3*(m1 + m3)**3*(m1 + m3 - m7)**2*m7**2*(m1 - m3 + m7)**2*(-m1 + m3 + m7)**2*(m1 + m3 + m7)**2*(4*m3sq - m7sq))
		def eval_169():
			return (20*m1**8*m3**4 - 40*m1**6*m3**6 + 40*m1**4*m3**8 - 20*m1sq*m3**10 + 4*m3**12 - 4*m1**10*m3sq + 20*m1**8*m5**4 + 116*m1**4*m3**4*m5**4 + 36*m1sq*m3**6*m5**4 + 72*m3**8*m5**4 + 12*m1**6*m3sq*m5**4 - 28*m1**6*m5**6 - 92*m1sq*m3**4*m5**6 - 48*m3**6*m5**6 - 24*m1**4*m3sq*m5**6 + 12*m1**4*m5**8 + 20*m3**4*m5**8 + 16*m1sq*m3sq*m5**8 - 2*m1sq*m5**10 - 2*m3sq*m5**10 - 2*m1**10*m5sq - 4*m1**6*m3**4*m5sq + 36*m1**4*m3**6*m5sq + 38*m1sq*m3**8*m5sq - 46*m3**10*m5sq - 22*m1**8*m3sq*m5sq - 2*m1sq*(4*m3sq - m5sq)*m5sq*(5*m1**6 + 3*m3**6 + 3*m3sq*m5**4 - m5**6 - 5*m3**4*m5sq - m1**4*(7*m3sq + 9*m5sq) - m1sq*(m3**4 - 5*m5**4 + 2*m3sq*m5sq))*B0del(0,0,m1sq,mudim) - 2*m3sq*(2*m1**10 - 2*m3**10 - 35*m3**6*m5**4 + 25*m3**4*m5**6 - 9*m3sq*m5**8 + m5**10 + 20*m3**8*m5sq - 2*m1**8*(5*m3sq + 4*m5sq) + m1**4*(-20*m3**6 - 33*m3sq*m5**4 + m5**6 - 28*m3**4*m5sq) + m1sq*(10*m3**8 - 3*m3**4*m5**4 + 22*m3sq*m5**6 - 3*m5**8 - 20*m3**6*m5sq) + m1**6*(20*m3**4 + 7*m5**4 + 36*m3sq*m5sq))*B0del(0,0,m3sq,mudim) + 10*m1**8*m5**4*B0del(0,0,m5sq,mudim) + 36*m1**4*m3**4*m5**4*B0del(0,0,m5sq,mudim) - 16*m1sq*m3**6*m5**4*B0del(0,0,m5sq,mudim) + 2*m3**8*m5**4*B0del(0,0,m5sq,mudim) - 32*m1**6*m3sq*m5**4*B0del(0,0,m5sq,mudim) - 10*m1**6*m5**6*B0del(0,0,m5sq,mudim) - 14*m1sq*m3**4*m5**6*B0del(0,0,m5sq,mudim) + 2*m3**6*m5**6*B0del(0,0,m5sq,mudim) + 22*m1**4*m3sq*m5**6*B0del(0,0,m5sq,mudim) + 2*m1**4*m5**8*B0del(0,0,m5sq,mudim) + 2*m3**4*m5**8*B0del(0,0,m5sq,mudim) - 4*m1sq*m3sq*m5**8*B0del(0,0,m5sq,mudim) - 2*m1**10*m5sq*B0del(0,0,m5sq,mudim) + 12*m1**6*m3**4*m5sq*B0del(0,0,m5sq,mudim) - 28*m1**4*m3**6*m5sq*B0del(0,0,m5sq,mudim) + 22*m1sq*m3**8*m5sq*B0del(0,0,m5sq,mudim) - 6*m3**10*m5sq*B0del(0,0,m5sq,mudim) + 2*m1**8*m3sq*m5sq*B0del(0,0,m5sq,mudim) + 4*m1**8*m5**4*B0fin(0,0,m1sq,mudim) + 10*m1**4*m3**4*m5**4*B0fin(0,0,m1sq,mudim) + 70*m1sq*m3**6*m5**4*B0fin(0,0,m1sq,mudim) + 26*m3**8*m5**4*B0fin(0,0,m1sq,mudim) + 18*m1**6*m3sq*m5**4*B0fin(0,0,m1sq,mudim) - 4*m1**6*m5**6*B0fin(0,0,m1sq,mudim) - 56*m1sq*m3**4*m5**6*B0fin(0,0,m1sq,mudim) - 30*m3**6*m5**6*B0fin(0,0,m1sq,mudim) - 6*m1**4*m3sq*m5**6*B0fin(0,0,m1sq,mudim) + 14*m3**4*m5**8*B0fin(0,0,m1sq,mudim) + 10*m1sq*m3sq*m5**8*B0fin(0,0,m1sq,mudim) - 2*m3sq*m5**10*B0fin(0,0,m1sq,mudim) - 8*m1**6*m3**4*m5sq*B0fin(0,0,m1sq,mudim) + 56*m1**4*m3**6*m5sq*B0fin(0,0,m1sq,mudim) - 24*m1sq*m3**8*m5sq*B0fin(0,0,m1sq,mudim) - 8*m3**10*m5sq*B0fin(0,0,m1sq,mudim) - 16*m1**8*m3sq*m5sq*B0fin(0,0,m1sq,mudim) + 20*m1**8*m3**4*B0fin(0,0,m3sq,mudim) - 40*m1**6*m3**6*B0fin(0,0,m3sq,mudim) + 40*m1**4*m3**8*B0fin(0,0,m3sq,mudim) - 20*m1sq*m3**10*B0fin(0,0,m3sq,mudim) + 4*m3**12*B0fin(0,0,m3sq,mudim) - 4*m1**10*m3sq*B0fin(0,0,m3sq,mudim) + 2*m1**8*m5**4*B0fin(0,0,m3sq,mudim) + 78*m1**4*m3**4*m5**4*B0fin(0,0,m3sq,mudim) + 30*m1sq*m3**6*m5**4*B0fin(0,0,m3sq,mudim) + 8*m3**8*m5**4*B0fin(0,0,m3sq,mudim) + 10*m1**6*m3sq*m5**4*B0fin(0,0,m3sq,mudim) - 6*m1**6*m5**6*B0fin(0,0,m3sq,mudim) - 62*m1sq*m3**4*m5**6*B0fin(0,0,m3sq,mudim) + 4*m3**6*m5**6*B0fin(0,0,m3sq,mudim) - 32*m1**4*m3sq*m5**6*B0fin(0,0,m3sq,mudim) + 6*m1**4*m5**8*B0fin(0,0,m3sq,mudim) + 18*m1sq*m3sq*m5**8*B0fin(0,0,m3sq,mudim) - 2*m1sq*m5**10*B0fin(0,0,m3sq,mudim) - 72*m1**6*m3**4*m5sq*B0fin(0,0,m3sq,mudim) + 104*m1**4*m3**6*m5sq*B0fin(0,0,m3sq,mudim) - 24*m1sq*m3**8*m5sq*B0fin(0,0,m3sq,mudim) - 16*m3**10*m5sq*B0fin(0,0,m3sq,mudim) + 8*m1**8*m3sq*m5sq*B0fin(0,0,m3sq,mudim) + 4*m1**8*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 18*m1**4*m3**4*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 46*m1sq*m3**6*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 18*m3**8*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 42*m1**6*m3sq*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 10*m1**6*m5**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 34*m1sq*m3**4*m5**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 12*m3**6*m5**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 40*m1**4*m3sq*m5**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 8*m1**4*m5**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 2*m3**4*m5**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 14*m1sq*m3sq*m5**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 2*m1sq*m5**10*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 8*m1**6*m3**4*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 56*m1**4*m3**6*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 24*m1sq*m3**8*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 8*m3**10*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 16*m1**8*m3sq*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 10*m1**8*m3**4*B0fin(0,0,m3sq,mudim)**2 - 20*m1**6*m3**6*B0fin(0,0,m3sq,mudim)**2 + 20*m1**4*m3**8*B0fin(0,0,m3sq,mudim)**2 - 10*m1sq*m3**10*B0fin(0,0,m3sq,mudim)**2 + 2*m3**12*B0fin(0,0,m3sq,mudim)**2 - 2*m1**10*m3sq*B0fin(0,0,m3sq,mudim)**2 - 4*m1**8*m5**4*B0fin(0,0,m3sq,mudim)**2 + 4*m1**4*m3**4*m5**4*B0fin(0,0,m3sq,mudim)**2 - 12*m1sq*m3**6*m5**4*B0fin(0,0,m3sq,mudim)**2 + 16*m3**8*m5**4*B0fin(0,0,m3sq,mudim)**2 - 4*m1**6*m3sq*m5**4*B0fin(0,0,m3sq,mudim)**2 + 6*m1**6*m5**6*B0fin(0,0,m3sq,mudim)**2 + 2*m1sq*m3**4*m5**6*B0fin(0,0,m3sq,mudim)**2 - 14*m3**6*m5**6*B0fin(0,0,m3sq,mudim)**2 + 6*m1**4*m3sq*m5**6*B0fin(0,0,m3sq,mudim)**2 - 4*m1**4*m5**8*B0fin(0,0,m3sq,mudim)**2 + 6*m3**4*m5**8*B0fin(0,0,m3sq,mudim)**2 - 2*m1sq*m3sq*m5**8*B0fin(0,0,m3sq,mudim)**2 + m1sq*m5**10*B0fin(0,0,m3sq,mudim)**2 - m3sq*m5**10*B0fin(0,0,m3sq,mudim)**2 + m1**10*m5sq*B0fin(0,0,m3sq,mudim)**2 - 6*m1**6*m3**4*m5sq*B0fin(0,0,m3sq,mudim)**2 - 10*m1**4*m3**6*m5sq*B0fin(0,0,m3sq,mudim)**2 + 21*m1sq*m3**8*m5sq*B0fin(0,0,m3sq,mudim)**2 - 9*m3**10*m5sq*B0fin(0,0,m3sq,mudim)**2 + 3*m1**8*m3sq*m5sq*B0fin(0,0,m3sq,mudim)**2 + 14*m1**8*m5**4*B0fin(0,0,m5sq,mudim) + 28*m1**4*m3**4*m5**4*B0fin(0,0,m5sq,mudim) - 64*m1sq*m3**6*m5**4*B0fin(0,0,m5sq,mudim) + 38*m3**8*m5**4*B0fin(0,0,m5sq,mudim) - 16*m1**6*m3sq*m5**4*B0fin(0,0,m5sq,mudim) - 18*m1**6*m5**6*B0fin(0,0,m5sq,mudim) + 26*m1sq*m3**4*m5**6*B0fin(0,0,m5sq,mudim) - 22*m3**6*m5**6*B0fin(0,0,m5sq,mudim) + 14*m1**4*m3sq*m5**6*B0fin(0,0,m5sq,mudim) + 6*m1**4*m5**8*B0fin(0,0,m5sq,mudim) + 6*m3**4*m5**8*B0fin(0,0,m5sq,mudim) - 12*m1sq*m3sq*m5**8*B0fin(0,0,m5sq,mudim) - 2*m1**10*m5sq*B0fin(0,0,m5sq,mudim) + 76*m1**6*m3**4*m5sq*B0fin(0,0,m5sq,mudim) - 124*m1**4*m3**6*m5sq*B0fin(0,0,m5sq,mudim) + 86*m1sq*m3**8*m5sq*B0fin(0,0,m5sq,mudim) - 22*m3**10*m5sq*B0fin(0,0,m5sq,mudim) - 14*m1**8*m3sq*m5sq*B0fin(0,0,m5sq,mudim) + 6*m1**8*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 4*m1**4*m3**4*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 18*m3**8*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 16*m1**6*m3sq*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 8*m1**6*m5**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 12*m3**6*m5**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 4*m1**4*m3sq*m5**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m1**4*m5**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m3**4*m5**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 64*m1**6*m3**4*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 48*m1**4*m3**6*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 8*m3**10*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 24*m1**8*m3sq*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 4*m1**8*m5**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + 40*m1**4*m3**4*m5**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) - 16*m1sq*m3**6*m5**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + 20*m3**8*m5**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) - 48*m1**6*m3sq*m5**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m1**6*m5**6*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) - 14*m1sq*m3**4*m5**6*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) - 10*m3**6*m5**6*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + 26*m1**4*m3sq*m5**6*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + 4*m3**4*m5**8*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) - 4*m1sq*m3sq*m5**8*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m1**10*m5sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) - 52*m1**6*m3**4*m5sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + 20*m1**4*m3**6*m5sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + 22*m1sq*m3**8*m5sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) - 14*m3**10*m5sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + 26*m1**8*m3sq*m5sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + 32*m1**6*m3**4*T134fin(m3,m1,0,mudim) - 48*m1**4*m3**6*T134fin(m3,m1,0,mudim) + 32*m1sq*m3**8*T134fin(m3,m1,0,mudim) - 8*m3**10*T134fin(m3,m1,0,mudim) - 8*m1**8*m3sq*T134fin(m3,m1,0,mudim) - 8*m1**6*m5**4*T134fin(m3,m1,0,mudim) - 24*m1sq*m3**4*m5**4*T134fin(m3,m1,0,mudim) - 56*m3**6*m5**4*T134fin(m3,m1,0,mudim) - 40*m1**4*m3sq*m5**4*T134fin(m3,m1,0,mudim) + 12*m1**4*m5**6*T134fin(m3,m1,0,mudim) + 44*m3**4*m5**6*T134fin(m3,m1,0,mudim) + 40*m1sq*m3sq*m5**6*T134fin(m3,m1,0,mudim) - 8*m1sq*m5**8*T134fin(m3,m1,0,mudim) - 16*m3sq*m5**8*T134fin(m3,m1,0,mudim) + 2*m5**10*T134fin(m3,m1,0,mudim) + 2*m1**8*m5sq*T134fin(m3,m1,0,mudim) - 20*m1**4*m3**4*m5sq*T134fin(m3,m1,0,mudim) - 40*m1sq*m3**6*m5sq*T134fin(m3,m1,0,mudim) + 34*m3**8*m5sq*T134fin(m3,m1,0,mudim) + 24*m1**6*m3sq*m5sq*T134fin(m3,m1,0,mudim) - 32*m1**6*m3**4*T134fin(m5,m3,m1,mudim) + 48*m1**4*m3**6*T134fin(m5,m3,m1,mudim) - 32*m1sq*m3**8*T134fin(m5,m3,m1,mudim) + 8*m3**10*T134fin(m5,m3,m1,mudim) + 8*m1**8*m3sq*T134fin(m5,m3,m1,mudim) - 2*m1**6*m5**4*T134fin(m5,m3,m1,mudim) + 10*m1sq*m3**4*m5**4*T134fin(m5,m3,m1,mudim) + 10*m3**6*m5**4*T134fin(m5,m3,m1,mudim) - 18*m1**4*m3sq*m5**4*T134fin(m5,m3,m1,mudim) + 6*m1**4*m5**6*T134fin(m5,m3,m1,mudim) - 10*m3**4*m5**6*T134fin(m5,m3,m1,mudim) + 4*m1sq*m3sq*m5**6*T134fin(m5,m3,m1,mudim) - 2*m1sq*m5**8*T134fin(m5,m3,m1,mudim) + 2*m3sq*m5**8*T134fin(m5,m3,m1,mudim) - 2*m1**8*m5sq*T134fin(m5,m3,m1,mudim) - 36*m1**4*m3**4*m5sq*T134fin(m5,m3,m1,mudim) + 32*m1sq*m3**6*m5sq*T134fin(m5,m3,m1,mudim) - 10*m3**8*m5sq*T134fin(m5,m3,m1,mudim) + 16*m1**6*m3sq*m5sq*T134fin(m5,m3,m1,mudim) + 2*m1**10*T134fin(m5,m3,m3,mudim) + 20*m1**6*m3**4*T134fin(m5,m3,m3,mudim) - 20*m1**4*m3**6*T134fin(m5,m3,m3,mudim) + 10*m1sq*m3**8*T134fin(m5,m3,m3,mudim) - 2*m3**10*T134fin(m5,m3,m3,mudim) - 10*m1**8*m3sq*T134fin(m5,m3,m3,mudim) + 12*m1**6*m5**4*T134fin(m5,m3,m3,mudim) + 4*m1sq*m3**4*m5**4*T134fin(m5,m3,m3,mudim) - 12*m3**6*m5**4*T134fin(m5,m3,m3,mudim) - 4*m1**4*m3sq*m5**4*T134fin(m5,m3,m3,mudim) - 8*m1**4*m5**6*T134fin(m5,m3,m3,mudim) + 8*m3**4*m5**6*T134fin(m5,m3,m3,mudim) + 2*m1sq*m5**8*T134fin(m5,m3,m3,mudim) - 2*m3sq*m5**8*T134fin(m5,m3,m3,mudim) - 8*m1**8*m5sq*T134fin(m5,m3,m3,mudim) - 16*m1sq*m3**6*m5sq*T134fin(m5,m3,m3,mudim) + 8*m3**8*m5sq*T134fin(m5,m3,m3,mudim) + 16*m1**6*m3sq*m5sq*T134fin(m5,m3,m3,mudim))/(2.*(m1 - m3)**3*(m1 + m3)**3*(m1 + m3 - m5)**2*m5**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*(4*m3sq - m5sq))
		def eval_170():
			return (28*m1**4*m2**4 + 4*m1sq*m2**6 - 12*m2**8 - 20*m1**6*m2sq + 4*m1**4*m7**4 - 4*m2**4*m7**4 - 32*m1sq*m2sq*m7**4 + 2*m1sq*m7**6 + 2*m2sq*m7**6 + 2*m1**6*m7sq + 38*m1sq*m2**4*m7sq + 14*m2**6*m7sq + 10*m1**4*m2sq*m7sq - 2*m1sq*(4*m2sq - m7sq)*(2*m1**4 + 2*m2**4 + m7**4 - 3*m2sq*m7sq - m1sq*(4*m2sq + m7sq))*B0del(0,0,m1sq,mudim) - 2*m2sq*(2*m1**6 + 6*m2**6 + 5*m2sq*m7**4 - m7**6 + m1sq*(-10*m2**4 + 3*m7**4) + 2*m1**4*(m2sq - 3*m7sq) - 10*m2**4*m7sq)*B0del(0,0,m2sq,mudim) + 6*m1**4*m7**4*B0del(0,0,m7sq,mudim) + 6*m2**4*m7**4*B0del(0,0,m7sq,mudim) - 12*m1sq*m2sq*m7**4*B0del(0,0,m7sq,mudim) - 2*m1**6*m7sq*B0del(0,0,m7sq,mudim) + 10*m1sq*m2**4*m7sq*B0del(0,0,m7sq,mudim) - 6*m2**6*m7sq*B0del(0,0,m7sq,mudim) - 2*m1**4*m2sq*m7sq*B0del(0,0,m7sq,mudim) + 32*m1**4*m2**4*B0fin(0,0,m1sq,mudim) - 16*m1sq*m2**6*B0fin(0,0,m1sq,mudim) - 16*m1**6*m2sq*B0fin(0,0,m1sq,mudim) - 2*m1**4*m7**4*B0fin(0,0,m1sq,mudim) - 14*m1sq*m2sq*m7**4*B0fin(0,0,m1sq,mudim) + 2*m1sq*m7**6*B0fin(0,0,m1sq,mudim) + 4*m1**6*m7sq*B0fin(0,0,m1sq,mudim) + 28*m1sq*m2**4*m7sq*B0fin(0,0,m1sq,mudim) + 16*m1**4*m2**4*B0fin(0,0,m1sq,mudim)**2 - 8*m1sq*m2**6*B0fin(0,0,m1sq,mudim)**2 - 8*m1**6*m2sq*B0fin(0,0,m1sq,mudim)**2 - 4*m1**4*m7**4*B0fin(0,0,m1sq,mudim)**2 - 12*m1sq*m2sq*m7**4*B0fin(0,0,m1sq,mudim)**2 + 2*m1sq*m7**6*B0fin(0,0,m1sq,mudim)**2 + 2*m1**6*m7sq*B0fin(0,0,m1sq,mudim)**2 + 18*m1sq*m2**4*m7sq*B0fin(0,0,m1sq,mudim)**2 + 12*m1**4*m2sq*m7sq*B0fin(0,0,m1sq,mudim)**2 - 4*m1**4*m2**4*B0fin(0,0,m2sq,mudim) + 20*m1sq*m2**6*B0fin(0,0,m2sq,mudim) - 12*m2**8*B0fin(0,0,m2sq,mudim) - 4*m1**6*m2sq*B0fin(0,0,m2sq,mudim) - 10*m2**4*m7**4*B0fin(0,0,m2sq,mudim) - 6*m1sq*m2sq*m7**4*B0fin(0,0,m2sq,mudim) + 2*m2sq*m7**6*B0fin(0,0,m2sq,mudim) + 20*m2**6*m7sq*B0fin(0,0,m2sq,mudim) + 12*m1**4*m2sq*m7sq*B0fin(0,0,m2sq,mudim) + 2*m1**4*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 14*m1sq*m2sq*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 2*m1sq*m7**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 24*m1sq*m2**4*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 8*m1**4*m2sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 2*m1**4*m2**4*B0fin(0,0,m2sq,mudim)**2 + 10*m1sq*m2**6*B0fin(0,0,m2sq,mudim)**2 - 6*m2**8*B0fin(0,0,m2sq,mudim)**2 - 2*m1**6*m2sq*B0fin(0,0,m2sq,mudim)**2 - 2*m1**4*m7**4*B0fin(0,0,m2sq,mudim)**2 - 8*m2**4*m7**4*B0fin(0,0,m2sq,mudim)**2 - 6*m1sq*m2sq*m7**4*B0fin(0,0,m2sq,mudim)**2 + m1sq*m7**6*B0fin(0,0,m2sq,mudim)**2 + m2sq*m7**6*B0fin(0,0,m2sq,mudim)**2 + m1**6*m7sq*B0fin(0,0,m2sq,mudim)**2 + 15*m1sq*m2**4*m7sq*B0fin(0,0,m2sq,mudim)**2 + 13*m2**6*m7sq*B0fin(0,0,m2sq,mudim)**2 + 3*m1**4*m2sq*m7sq*B0fin(0,0,m2sq,mudim)**2 + 6*m1**4*m7**4*B0fin(0,0,m7sq,mudim) + 6*m2**4*m7**4*B0fin(0,0,m7sq,mudim) - 12*m1sq*m2sq*m7**4*B0fin(0,0,m7sq,mudim) - 2*m1**6*m7sq*B0fin(0,0,m7sq,mudim) + 10*m1sq*m2**4*m7sq*B0fin(0,0,m7sq,mudim) - 6*m2**6*m7sq*B0fin(0,0,m7sq,mudim) - 2*m1**4*m2sq*m7sq*B0fin(0,0,m7sq,mudim) + 4*m1**4*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 4*m1sq*m2sq*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) + 16*m1sq*m2**4*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 16*m1**4*m2sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) + 2*m1**4*m7**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) + 6*m2**4*m7**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) - 8*m1sq*m2sq*m7**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) - 2*m1**6*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) - 6*m1sq*m2**4*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) - 6*m2**6*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) + 14*m1**4*m2sq*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) - 16*m1sq*m2**4*T134fin(m2,m1,0,mudim) + 8*m2**6*T134fin(m2,m1,0,mudim) + 8*m1**4*m2sq*T134fin(m2,m1,0,mudim) + 4*m1sq*m7**4*T134fin(m2,m1,0,mudim) + 12*m2sq*m7**4*T134fin(m2,m1,0,mudim) - 2*m7**6*T134fin(m2,m1,0,mudim) - 2*m1**4*m7sq*T134fin(m2,m1,0,mudim) - 18*m2**4*m7sq*T134fin(m2,m1,0,mudim) - 12*m1sq*m2sq*m7sq*T134fin(m2,m1,0,mudim) - 16*m1sq*m2**4*T134fin(m7,m1,m1,mudim) + 8*m2**6*T134fin(m7,m1,m1,mudim) + 8*m1**4*m2sq*T134fin(m7,m1,m1,mudim) + 4*m1sq*m7**4*T134fin(m7,m1,m1,mudim) + 12*m2sq*m7**4*T134fin(m7,m1,m1,mudim) - 2*m7**6*T134fin(m7,m1,m1,mudim) - 2*m1**4*m7sq*T134fin(m7,m1,m1,mudim) - 18*m2**4*m7sq*T134fin(m7,m1,m1,mudim) - 12*m1sq*m2sq*m7sq*T134fin(m7,m1,m1,mudim) + 16*m1sq*m2**4*T134fin(m7,m2,m1,mudim) - 8*m2**6*T134fin(m7,m2,m1,mudim) - 8*m1**4*m2sq*T134fin(m7,m2,m1,mudim) - 10*m1sq*m7**4*T134fin(m7,m2,m1,mudim) - 22*m2sq*m7**4*T134fin(m7,m2,m1,mudim) + 4*m7**6*T134fin(m7,m2,m1,mudim) + 2*m1**4*m7sq*T134fin(m7,m2,m1,mudim) + 26*m2**4*m7sq*T134fin(m7,m2,m1,mudim) + 36*m1sq*m2sq*m7sq*T134fin(m7,m2,m1,mudim) + 2*m1**6*T134fin(m7,m2,m2,mudim) - 10*m1sq*m2**4*T134fin(m7,m2,m2,mudim) + 6*m2**6*T134fin(m7,m2,m2,mudim) + 2*m1**4*m2sq*T134fin(m7,m2,m2,mudim) + 6*m1sq*m7**4*T134fin(m7,m2,m2,mudim) + 10*m2sq*m7**4*T134fin(m7,m2,m2,mudim) - 2*m7**6*T134fin(m7,m2,m2,mudim) - 6*m1**4*m7sq*T134fin(m7,m2,m2,mudim) - 14*m2**4*m7sq*T134fin(m7,m2,m2,mudim) - 12*m1sq*m2sq*m7sq*T134fin(m7,m2,m2,mudim))/(2.*(m1sq - m2sq)**3*m7**2*(4*m2sq - m7sq)*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq)))
		def eval_171():
			return (28*m1**4*m2**4 + 4*m1sq*m2**6 - 12*m2**8 - 20*m1**6*m2sq + 4*m1**4*m5**4 - 4*m2**4*m5**4 - 32*m1sq*m2sq*m5**4 + 2*m1sq*m5**6 + 2*m2sq*m5**6 + 2*m1**6*m5sq + 38*m1sq*m2**4*m5sq + 14*m2**6*m5sq + 10*m1**4*m2sq*m5sq - 2*m1sq*(4*m2sq - m5sq)*(2*m1**4 + 2*m2**4 + m5**4 - 3*m2sq*m5sq - m1sq*(4*m2sq + m5sq))*B0del(0,0,m1sq,mudim) - 2*m2sq*(2*m1**6 + 6*m2**6 + 5*m2sq*m5**4 - m5**6 + m1sq*(-10*m2**4 + 3*m5**4) + 2*m1**4*(m2sq - 3*m5sq) - 10*m2**4*m5sq)*B0del(0,0,m2sq,mudim) + 6*m1**4*m5**4*B0del(0,0,m5sq,mudim) + 6*m2**4*m5**4*B0del(0,0,m5sq,mudim) - 12*m1sq*m2sq*m5**4*B0del(0,0,m5sq,mudim) - 2*m1**6*m5sq*B0del(0,0,m5sq,mudim) + 10*m1sq*m2**4*m5sq*B0del(0,0,m5sq,mudim) - 6*m2**6*m5sq*B0del(0,0,m5sq,mudim) - 2*m1**4*m2sq*m5sq*B0del(0,0,m5sq,mudim) + 32*m1**4*m2**4*B0fin(0,0,m1sq,mudim) - 16*m1sq*m2**6*B0fin(0,0,m1sq,mudim) - 16*m1**6*m2sq*B0fin(0,0,m1sq,mudim) - 2*m1**4*m5**4*B0fin(0,0,m1sq,mudim) - 14*m1sq*m2sq*m5**4*B0fin(0,0,m1sq,mudim) + 2*m1sq*m5**6*B0fin(0,0,m1sq,mudim) + 4*m1**6*m5sq*B0fin(0,0,m1sq,mudim) + 28*m1sq*m2**4*m5sq*B0fin(0,0,m1sq,mudim) + 16*m1**4*m2**4*B0fin(0,0,m1sq,mudim)**2 - 8*m1sq*m2**6*B0fin(0,0,m1sq,mudim)**2 - 8*m1**6*m2sq*B0fin(0,0,m1sq,mudim)**2 - 4*m1**4*m5**4*B0fin(0,0,m1sq,mudim)**2 - 12*m1sq*m2sq*m5**4*B0fin(0,0,m1sq,mudim)**2 + 2*m1sq*m5**6*B0fin(0,0,m1sq,mudim)**2 + 2*m1**6*m5sq*B0fin(0,0,m1sq,mudim)**2 + 18*m1sq*m2**4*m5sq*B0fin(0,0,m1sq,mudim)**2 + 12*m1**4*m2sq*m5sq*B0fin(0,0,m1sq,mudim)**2 - 4*m1**4*m2**4*B0fin(0,0,m2sq,mudim) + 20*m1sq*m2**6*B0fin(0,0,m2sq,mudim) - 12*m2**8*B0fin(0,0,m2sq,mudim) - 4*m1**6*m2sq*B0fin(0,0,m2sq,mudim) - 10*m2**4*m5**4*B0fin(0,0,m2sq,mudim) - 6*m1sq*m2sq*m5**4*B0fin(0,0,m2sq,mudim) + 2*m2sq*m5**6*B0fin(0,0,m2sq,mudim) + 20*m2**6*m5sq*B0fin(0,0,m2sq,mudim) + 12*m1**4*m2sq*m5sq*B0fin(0,0,m2sq,mudim) + 2*m1**4*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 14*m1sq*m2sq*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 2*m1sq*m5**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 24*m1sq*m2**4*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 8*m1**4*m2sq*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 2*m1**4*m2**4*B0fin(0,0,m2sq,mudim)**2 + 10*m1sq*m2**6*B0fin(0,0,m2sq,mudim)**2 - 6*m2**8*B0fin(0,0,m2sq,mudim)**2 - 2*m1**6*m2sq*B0fin(0,0,m2sq,mudim)**2 - 2*m1**4*m5**4*B0fin(0,0,m2sq,mudim)**2 - 8*m2**4*m5**4*B0fin(0,0,m2sq,mudim)**2 - 6*m1sq*m2sq*m5**4*B0fin(0,0,m2sq,mudim)**2 + m1sq*m5**6*B0fin(0,0,m2sq,mudim)**2 + m2sq*m5**6*B0fin(0,0,m2sq,mudim)**2 + m1**6*m5sq*B0fin(0,0,m2sq,mudim)**2 + 15*m1sq*m2**4*m5sq*B0fin(0,0,m2sq,mudim)**2 + 13*m2**6*m5sq*B0fin(0,0,m2sq,mudim)**2 + 3*m1**4*m2sq*m5sq*B0fin(0,0,m2sq,mudim)**2 + 6*m1**4*m5**4*B0fin(0,0,m5sq,mudim) + 6*m2**4*m5**4*B0fin(0,0,m5sq,mudim) - 12*m1sq*m2sq*m5**4*B0fin(0,0,m5sq,mudim) - 2*m1**6*m5sq*B0fin(0,0,m5sq,mudim) + 10*m1sq*m2**4*m5sq*B0fin(0,0,m5sq,mudim) - 6*m2**6*m5sq*B0fin(0,0,m5sq,mudim) - 2*m1**4*m2sq*m5sq*B0fin(0,0,m5sq,mudim) + 4*m1**4*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 4*m1sq*m2sq*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 16*m1sq*m2**4*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 16*m1**4*m2sq*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m1**4*m5**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 6*m2**4*m5**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 8*m1sq*m2sq*m5**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m1**6*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 6*m1sq*m2**4*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 6*m2**6*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 14*m1**4*m2sq*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 16*m1sq*m2**4*T134fin(m2,m1,0,mudim) + 8*m2**6*T134fin(m2,m1,0,mudim) + 8*m1**4*m2sq*T134fin(m2,m1,0,mudim) + 4*m1sq*m5**4*T134fin(m2,m1,0,mudim) + 12*m2sq*m5**4*T134fin(m2,m1,0,mudim) - 2*m5**6*T134fin(m2,m1,0,mudim) - 2*m1**4*m5sq*T134fin(m2,m1,0,mudim) - 18*m2**4*m5sq*T134fin(m2,m1,0,mudim) - 12*m1sq*m2sq*m5sq*T134fin(m2,m1,0,mudim) - 16*m1sq*m2**4*T134fin(m5,m1,m1,mudim) + 8*m2**6*T134fin(m5,m1,m1,mudim) + 8*m1**4*m2sq*T134fin(m5,m1,m1,mudim) + 4*m1sq*m5**4*T134fin(m5,m1,m1,mudim) + 12*m2sq*m5**4*T134fin(m5,m1,m1,mudim) - 2*m5**6*T134fin(m5,m1,m1,mudim) - 2*m1**4*m5sq*T134fin(m5,m1,m1,mudim) - 18*m2**4*m5sq*T134fin(m5,m1,m1,mudim) - 12*m1sq*m2sq*m5sq*T134fin(m5,m1,m1,mudim) + 16*m1sq*m2**4*T134fin(m5,m2,m1,mudim) - 8*m2**6*T134fin(m5,m2,m1,mudim) - 8*m1**4*m2sq*T134fin(m5,m2,m1,mudim) - 10*m1sq*m5**4*T134fin(m5,m2,m1,mudim) - 22*m2sq*m5**4*T134fin(m5,m2,m1,mudim) + 4*m5**6*T134fin(m5,m2,m1,mudim) + 2*m1**4*m5sq*T134fin(m5,m2,m1,mudim) + 26*m2**4*m5sq*T134fin(m5,m2,m1,mudim) + 36*m1sq*m2sq*m5sq*T134fin(m5,m2,m1,mudim) + 2*m1**6*T134fin(m5,m2,m2,mudim) - 10*m1sq*m2**4*T134fin(m5,m2,m2,mudim) + 6*m2**6*T134fin(m5,m2,m2,mudim) + 2*m1**4*m2sq*T134fin(m5,m2,m2,mudim) + 6*m1sq*m5**4*T134fin(m5,m2,m2,mudim) + 10*m2sq*m5**4*T134fin(m5,m2,m2,mudim) - 2*m5**6*T134fin(m5,m2,m2,mudim) - 6*m1**4*m5sq*T134fin(m5,m2,m2,mudim) - 14*m2**4*m5sq*T134fin(m5,m2,m2,mudim) - 12*m1sq*m2sq*m5sq*T134fin(m5,m2,m2,mudim))/(2.*(m1sq - m2sq)**3*m5**2*(4*m2sq - m5sq)*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq)))
		def eval_172():
			return -0.5*(4*m1**12 + 40*m1**8*m2**4 - 40*m1**6*m2**6 + 20*m1**4*m2**8 - 4*m1sq*m2**10 - 20*m1**10*m2sq + 72*m1**8*m7**4 + 116*m1**4*m2**4*m7**4 + 12*m1sq*m2**6*m7**4 + 20*m2**8*m7**4 + 36*m1**6*m2sq*m7**4 - 48*m1**6*m7**6 - 24*m1sq*m2**4*m7**6 - 28*m2**6*m7**6 - 92*m1**4*m2sq*m7**6 + 20*m1**4*m7**8 + 12*m2**4*m7**8 + 16*m1sq*m2sq*m7**8 - 2*m1sq*m7**10 - 2*m2sq*m7**10 - 46*m1**10*m7sq + 36*m1**6*m2**4*m7sq - 4*m1**4*m2**6*m7sq - 22*m1sq*m2**8*m7sq - 2*m2**10*m7sq + 38*m1**8*m2sq*m7sq + 2*m1sq*(2*m1**10 - 2*m2**10 - 7*m2**6*m7**4 - m2**4*m7**6 + 3*m2sq*m7**8 - m7**10 + 8*m2**8*m7sq - 10*m1**8*(m2sq + 2*m7sq) + m1**4*(-20*m2**6 + 3*m2sq*m7**4 - 25*m7**6 + 28*m2**4*m7sq) + m1sq*(10*m2**8 + 33*m2**4*m7**4 - 22*m2sq*m7**6 + 9*m7**8 - 36*m2**6*m7sq) + 5*m1**6*(4*m2**4 + 7*m7**4 + 4*m2sq*m7sq))*B0del(0,0,m1sq,mudim) + 2*m2sq*m7sq*(-4*m1sq + m7sq)*(3*m1**6 + 5*m2**6 + 5*m2sq*m7**4 - m7**6 - 9*m2**4*m7sq - m1**4*(m2sq + 5*m7sq) + m1sq*(-7*m2**4 + 3*m7**4 - 2*m2sq*m7sq))*B0del(0,0,m2sq,mudim) + 2*m1**8*m7**4*B0del(0,0,m7sq,mudim) + 36*m1**4*m2**4*m7**4*B0del(0,0,m7sq,mudim) - 32*m1sq*m2**6*m7**4*B0del(0,0,m7sq,mudim) + 10*m2**8*m7**4*B0del(0,0,m7sq,mudim) - 16*m1**6*m2sq*m7**4*B0del(0,0,m7sq,mudim) + 2*m1**6*m7**6*B0del(0,0,m7sq,mudim) + 22*m1sq*m2**4*m7**6*B0del(0,0,m7sq,mudim) - 10*m2**6*m7**6*B0del(0,0,m7sq,mudim) - 14*m1**4*m2sq*m7**6*B0del(0,0,m7sq,mudim) + 2*m1**4*m7**8*B0del(0,0,m7sq,mudim) + 2*m2**4*m7**8*B0del(0,0,m7sq,mudim) - 4*m1sq*m2sq*m7**8*B0del(0,0,m7sq,mudim) - 6*m1**10*m7sq*B0del(0,0,m7sq,mudim) - 28*m1**6*m2**4*m7sq*B0del(0,0,m7sq,mudim) + 12*m1**4*m2**6*m7sq*B0del(0,0,m7sq,mudim) + 2*m1sq*m2**8*m7sq*B0del(0,0,m7sq,mudim) - 2*m2**10*m7sq*B0del(0,0,m7sq,mudim) + 22*m1**8*m2sq*m7sq*B0del(0,0,m7sq,mudim) + 4*m1**12*B0fin(0,0,m1sq,mudim) + 40*m1**8*m2**4*B0fin(0,0,m1sq,mudim) - 40*m1**6*m2**6*B0fin(0,0,m1sq,mudim) + 20*m1**4*m2**8*B0fin(0,0,m1sq,mudim) - 4*m1sq*m2**10*B0fin(0,0,m1sq,mudim) - 20*m1**10*m2sq*B0fin(0,0,m1sq,mudim) + 8*m1**8*m7**4*B0fin(0,0,m1sq,mudim) + 78*m1**4*m2**4*m7**4*B0fin(0,0,m1sq,mudim) + 10*m1sq*m2**6*m7**4*B0fin(0,0,m1sq,mudim) + 2*m2**8*m7**4*B0fin(0,0,m1sq,mudim) + 30*m1**6*m2sq*m7**4*B0fin(0,0,m1sq,mudim) + 4*m1**6*m7**6*B0fin(0,0,m1sq,mudim) - 32*m1sq*m2**4*m7**6*B0fin(0,0,m1sq,mudim) - 6*m2**6*m7**6*B0fin(0,0,m1sq,mudim) - 62*m1**4*m2sq*m7**6*B0fin(0,0,m1sq,mudim) + 6*m2**4*m7**8*B0fin(0,0,m1sq,mudim) + 18*m1sq*m2sq*m7**8*B0fin(0,0,m1sq,mudim) - 2*m2sq*m7**10*B0fin(0,0,m1sq,mudim) - 16*m1**10*m7sq*B0fin(0,0,m1sq,mudim) + 104*m1**6*m2**4*m7sq*B0fin(0,0,m1sq,mudim) - 72*m1**4*m2**6*m7sq*B0fin(0,0,m1sq,mudim) + 8*m1sq*m2**8*m7sq*B0fin(0,0,m1sq,mudim) - 24*m1**8*m2sq*m7sq*B0fin(0,0,m1sq,mudim) + 2*m1**12*B0fin(0,0,m1sq,mudim)**2 + 20*m1**8*m2**4*B0fin(0,0,m1sq,mudim)**2 - 20*m1**6*m2**6*B0fin(0,0,m1sq,mudim)**2 + 10*m1**4*m2**8*B0fin(0,0,m1sq,mudim)**2 - 2*m1sq*m2**10*B0fin(0,0,m1sq,mudim)**2 - 10*m1**10*m2sq*B0fin(0,0,m1sq,mudim)**2 + 16*m1**8*m7**4*B0fin(0,0,m1sq,mudim)**2 + 4*m1**4*m2**4*m7**4*B0fin(0,0,m1sq,mudim)**2 - 4*m1sq*m2**6*m7**4*B0fin(0,0,m1sq,mudim)**2 - 4*m2**8*m7**4*B0fin(0,0,m1sq,mudim)**2 - 12*m1**6*m2sq*m7**4*B0fin(0,0,m1sq,mudim)**2 - 14*m1**6*m7**6*B0fin(0,0,m1sq,mudim)**2 + 6*m1sq*m2**4*m7**6*B0fin(0,0,m1sq,mudim)**2 + 6*m2**6*m7**6*B0fin(0,0,m1sq,mudim)**2 + 2*m1**4*m2sq*m7**6*B0fin(0,0,m1sq,mudim)**2 + 6*m1**4*m7**8*B0fin(0,0,m1sq,mudim)**2 - 4*m2**4*m7**8*B0fin(0,0,m1sq,mudim)**2 - 2*m1sq*m2sq*m7**8*B0fin(0,0,m1sq,mudim)**2 - m1sq*m7**10*B0fin(0,0,m1sq,mudim)**2 + m2sq*m7**10*B0fin(0,0,m1sq,mudim)**2 - 9*m1**10*m7sq*B0fin(0,0,m1sq,mudim)**2 - 10*m1**6*m2**4*m7sq*B0fin(0,0,m1sq,mudim)**2 - 6*m1**4*m2**6*m7sq*B0fin(0,0,m1sq,mudim)**2 + 3*m1sq*m2**8*m7sq*B0fin(0,0,m1sq,mudim)**2 + m2**10*m7sq*B0fin(0,0,m1sq,mudim)**2 + 21*m1**8*m2sq*m7sq*B0fin(0,0,m1sq,mudim)**2 + 26*m1**8*m7**4*B0fin(0,0,m2sq,mudim) + 10*m1**4*m2**4*m7**4*B0fin(0,0,m2sq,mudim) + 18*m1sq*m2**6*m7**4*B0fin(0,0,m2sq,mudim) + 4*m2**8*m7**4*B0fin(0,0,m2sq,mudim) + 70*m1**6*m2sq*m7**4*B0fin(0,0,m2sq,mudim) - 30*m1**6*m7**6*B0fin(0,0,m2sq,mudim) - 6*m1sq*m2**4*m7**6*B0fin(0,0,m2sq,mudim) - 4*m2**6*m7**6*B0fin(0,0,m2sq,mudim) - 56*m1**4*m2sq*m7**6*B0fin(0,0,m2sq,mudim) + 14*m1**4*m7**8*B0fin(0,0,m2sq,mudim) + 10*m1sq*m2sq*m7**8*B0fin(0,0,m2sq,mudim) - 2*m1sq*m7**10*B0fin(0,0,m2sq,mudim) - 8*m1**10*m7sq*B0fin(0,0,m2sq,mudim) + 56*m1**6*m2**4*m7sq*B0fin(0,0,m2sq,mudim) - 8*m1**4*m2**6*m7sq*B0fin(0,0,m2sq,mudim) - 16*m1sq*m2**8*m7sq*B0fin(0,0,m2sq,mudim) - 24*m1**8*m2sq*m7sq*B0fin(0,0,m2sq,mudim) + 18*m1**8*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 18*m1**4*m2**4*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 42*m1sq*m2**6*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 4*m2**8*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 46*m1**6*m2sq*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 12*m1**6*m7**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 40*m1sq*m2**4*m7**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 10*m2**6*m7**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 34*m1**4*m2sq*m7**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 2*m1**4*m7**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 8*m2**4*m7**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 14*m1sq*m2sq*m7**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 2*m2sq*m7**10*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 8*m1**10*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 56*m1**6*m2**4*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 8*m1**4*m2**6*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 16*m1sq*m2**8*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 24*m1**8*m2sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 38*m1**8*m7**4*B0fin(0,0,m7sq,mudim) + 28*m1**4*m2**4*m7**4*B0fin(0,0,m7sq,mudim) - 16*m1sq*m2**6*m7**4*B0fin(0,0,m7sq,mudim) + 14*m2**8*m7**4*B0fin(0,0,m7sq,mudim) - 64*m1**6*m2sq*m7**4*B0fin(0,0,m7sq,mudim) - 22*m1**6*m7**6*B0fin(0,0,m7sq,mudim) + 14*m1sq*m2**4*m7**6*B0fin(0,0,m7sq,mudim) - 18*m2**6*m7**6*B0fin(0,0,m7sq,mudim) + 26*m1**4*m2sq*m7**6*B0fin(0,0,m7sq,mudim) + 6*m1**4*m7**8*B0fin(0,0,m7sq,mudim) + 6*m2**4*m7**8*B0fin(0,0,m7sq,mudim) - 12*m1sq*m2sq*m7**8*B0fin(0,0,m7sq,mudim) - 22*m1**10*m7sq*B0fin(0,0,m7sq,mudim) - 124*m1**6*m2**4*m7sq*B0fin(0,0,m7sq,mudim) + 76*m1**4*m2**6*m7sq*B0fin(0,0,m7sq,mudim) - 14*m1sq*m2**8*m7sq*B0fin(0,0,m7sq,mudim) - 2*m2**10*m7sq*B0fin(0,0,m7sq,mudim) + 86*m1**8*m2sq*m7sq*B0fin(0,0,m7sq,mudim) + 20*m1**8*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) + 40*m1**4*m2**4*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 48*m1sq*m2**6*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) + 4*m2**8*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 16*m1**6*m2sq*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 10*m1**6*m7**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) + 26*m1sq*m2**4*m7**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 2*m2**6*m7**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 14*m1**4*m2sq*m7**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) + 4*m1**4*m7**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 4*m1sq*m2sq*m7**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 14*m1**10*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) + 20*m1**6*m2**4*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 52*m1**4*m2**6*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) + 26*m1sq*m2**8*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 2*m2**10*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) + 22*m1**8*m2sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 18*m1**8*m7**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) - 4*m1**4*m2**4*m7**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) + 16*m1sq*m2**6*m7**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) + 6*m2**8*m7**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) + 12*m1**6*m7**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) - 4*m1sq*m2**4*m7**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) - 8*m2**6*m7**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) - 2*m1**4*m7**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) + 2*m2**4*m7**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) + 8*m1**10*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) - 48*m1**6*m2**4*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) + 64*m1**4*m2**6*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) - 24*m1sq*m2**8*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) - 8*m1**10*T134fin(m2,m1,0,mudim) - 48*m1**6*m2**4*T134fin(m2,m1,0,mudim) + 32*m1**4*m2**6*T134fin(m2,m1,0,mudim) - 8*m1sq*m2**8*T134fin(m2,m1,0,mudim) + 32*m1**8*m2sq*T134fin(m2,m1,0,mudim) - 56*m1**6*m7**4*T134fin(m2,m1,0,mudim) - 40*m1sq*m2**4*m7**4*T134fin(m2,m1,0,mudim) - 8*m2**6*m7**4*T134fin(m2,m1,0,mudim) - 24*m1**4*m2sq*m7**4*T134fin(m2,m1,0,mudim) + 44*m1**4*m7**6*T134fin(m2,m1,0,mudim) + 12*m2**4*m7**6*T134fin(m2,m1,0,mudim) + 40*m1sq*m2sq*m7**6*T134fin(m2,m1,0,mudim) - 16*m1sq*m7**8*T134fin(m2,m1,0,mudim) - 8*m2sq*m7**8*T134fin(m2,m1,0,mudim) + 2*m7**10*T134fin(m2,m1,0,mudim) + 34*m1**8*m7sq*T134fin(m2,m1,0,mudim) - 20*m1**4*m2**4*m7sq*T134fin(m2,m1,0,mudim) + 24*m1sq*m2**6*m7sq*T134fin(m2,m1,0,mudim) + 2*m2**8*m7sq*T134fin(m2,m1,0,mudim) - 40*m1**6*m2sq*m7sq*T134fin(m2,m1,0,mudim) - 2*m1**10*T134fin(m7,m1,m1,mudim) - 20*m1**6*m2**4*T134fin(m7,m1,m1,mudim) + 20*m1**4*m2**6*T134fin(m7,m1,m1,mudim) - 10*m1sq*m2**8*T134fin(m7,m1,m1,mudim) + 2*m2**10*T134fin(m7,m1,m1,mudim) + 10*m1**8*m2sq*T134fin(m7,m1,m1,mudim) - 12*m1**6*m7**4*T134fin(m7,m1,m1,mudim) - 4*m1sq*m2**4*m7**4*T134fin(m7,m1,m1,mudim) + 12*m2**6*m7**4*T134fin(m7,m1,m1,mudim) + 4*m1**4*m2sq*m7**4*T134fin(m7,m1,m1,mudim) + 8*m1**4*m7**6*T134fin(m7,m1,m1,mudim) - 8*m2**4*m7**6*T134fin(m7,m1,m1,mudim) - 2*m1sq*m7**8*T134fin(m7,m1,m1,mudim) + 2*m2sq*m7**8*T134fin(m7,m1,m1,mudim) + 8*m1**8*m7sq*T134fin(m7,m1,m1,mudim) + 16*m1sq*m2**6*m7sq*T134fin(m7,m1,m1,mudim) - 8*m2**8*m7sq*T134fin(m7,m1,m1,mudim) - 16*m1**6*m2sq*m7sq*T134fin(m7,m1,m1,mudim) + 8*m1**10*T134fin(m7,m2,m1,mudim) + 48*m1**6*m2**4*T134fin(m7,m2,m1,mudim) - 32*m1**4*m2**6*T134fin(m7,m2,m1,mudim) + 8*m1sq*m2**8*T134fin(m7,m2,m1,mudim) - 32*m1**8*m2sq*T134fin(m7,m2,m1,mudim) + 10*m1**6*m7**4*T134fin(m7,m2,m1,mudim) - 18*m1sq*m2**4*m7**4*T134fin(m7,m2,m1,mudim) - 2*m2**6*m7**4*T134fin(m7,m2,m1,mudim) + 10*m1**4*m2sq*m7**4*T134fin(m7,m2,m1,mudim) - 10*m1**4*m7**6*T134fin(m7,m2,m1,mudim) + 6*m2**4*m7**6*T134fin(m7,m2,m1,mudim) + 4*m1sq*m2sq*m7**6*T134fin(m7,m2,m1,mudim) + 2*m1sq*m7**8*T134fin(m7,m2,m1,mudim) - 2*m2sq*m7**8*T134fin(m7,m2,m1,mudim) - 10*m1**8*m7sq*T134fin(m7,m2,m1,mudim) - 36*m1**4*m2**4*m7sq*T134fin(m7,m2,m1,mudim) + 16*m1sq*m2**6*m7sq*T134fin(m7,m2,m1,mudim) - 2*m2**8*m7sq*T134fin(m7,m2,m1,mudim) + 32*m1**6*m2sq*m7sq*T134fin(m7,m2,m1,mudim))/((m1 - m2)**3*(m1 + m2)**3*(m1 + m2 - m7)**2*m7**2*(m1 - m2 + m7)**2*(-m1 + m2 + m7)**2*(m1 + m2 + m7)**2*(4*m1sq - m7sq))
		def eval_173():
			return -0.5*(4*m1**12 + 40*m1**8*m2**4 - 40*m1**6*m2**6 + 20*m1**4*m2**8 - 4*m1sq*m2**10 - 20*m1**10*m2sq + 72*m1**8*m5**4 + 116*m1**4*m2**4*m5**4 + 12*m1sq*m2**6*m5**4 + 20*m2**8*m5**4 + 36*m1**6*m2sq*m5**4 - 48*m1**6*m5**6 - 24*m1sq*m2**4*m5**6 - 28*m2**6*m5**6 - 92*m1**4*m2sq*m5**6 + 20*m1**4*m5**8 + 12*m2**4*m5**8 + 16*m1sq*m2sq*m5**8 - 2*m1sq*m5**10 - 2*m2sq*m5**10 - 46*m1**10*m5sq + 36*m1**6*m2**4*m5sq - 4*m1**4*m2**6*m5sq - 22*m1sq*m2**8*m5sq - 2*m2**10*m5sq + 38*m1**8*m2sq*m5sq + 2*m1sq*(2*m1**10 - 2*m2**10 - 7*m2**6*m5**4 - m2**4*m5**6 + 3*m2sq*m5**8 - m5**10 + 8*m2**8*m5sq - 10*m1**8*(m2sq + 2*m5sq) + m1**4*(-20*m2**6 + 3*m2sq*m5**4 - 25*m5**6 + 28*m2**4*m5sq) + m1sq*(10*m2**8 + 33*m2**4*m5**4 - 22*m2sq*m5**6 + 9*m5**8 - 36*m2**6*m5sq) + 5*m1**6*(4*m2**4 + 7*m5**4 + 4*m2sq*m5sq))*B0del(0,0,m1sq,mudim) + 2*m2sq*m5sq*(-4*m1sq + m5sq)*(3*m1**6 + 5*m2**6 + 5*m2sq*m5**4 - m5**6 - 9*m2**4*m5sq - m1**4*(m2sq + 5*m5sq) + m1sq*(-7*m2**4 + 3*m5**4 - 2*m2sq*m5sq))*B0del(0,0,m2sq,mudim) + 2*m1**8*m5**4*B0del(0,0,m5sq,mudim) + 36*m1**4*m2**4*m5**4*B0del(0,0,m5sq,mudim) - 32*m1sq*m2**6*m5**4*B0del(0,0,m5sq,mudim) + 10*m2**8*m5**4*B0del(0,0,m5sq,mudim) - 16*m1**6*m2sq*m5**4*B0del(0,0,m5sq,mudim) + 2*m1**6*m5**6*B0del(0,0,m5sq,mudim) + 22*m1sq*m2**4*m5**6*B0del(0,0,m5sq,mudim) - 10*m2**6*m5**6*B0del(0,0,m5sq,mudim) - 14*m1**4*m2sq*m5**6*B0del(0,0,m5sq,mudim) + 2*m1**4*m5**8*B0del(0,0,m5sq,mudim) + 2*m2**4*m5**8*B0del(0,0,m5sq,mudim) - 4*m1sq*m2sq*m5**8*B0del(0,0,m5sq,mudim) - 6*m1**10*m5sq*B0del(0,0,m5sq,mudim) - 28*m1**6*m2**4*m5sq*B0del(0,0,m5sq,mudim) + 12*m1**4*m2**6*m5sq*B0del(0,0,m5sq,mudim) + 2*m1sq*m2**8*m5sq*B0del(0,0,m5sq,mudim) - 2*m2**10*m5sq*B0del(0,0,m5sq,mudim) + 22*m1**8*m2sq*m5sq*B0del(0,0,m5sq,mudim) + 4*m1**12*B0fin(0,0,m1sq,mudim) + 40*m1**8*m2**4*B0fin(0,0,m1sq,mudim) - 40*m1**6*m2**6*B0fin(0,0,m1sq,mudim) + 20*m1**4*m2**8*B0fin(0,0,m1sq,mudim) - 4*m1sq*m2**10*B0fin(0,0,m1sq,mudim) - 20*m1**10*m2sq*B0fin(0,0,m1sq,mudim) + 8*m1**8*m5**4*B0fin(0,0,m1sq,mudim) + 78*m1**4*m2**4*m5**4*B0fin(0,0,m1sq,mudim) + 10*m1sq*m2**6*m5**4*B0fin(0,0,m1sq,mudim) + 2*m2**8*m5**4*B0fin(0,0,m1sq,mudim) + 30*m1**6*m2sq*m5**4*B0fin(0,0,m1sq,mudim) + 4*m1**6*m5**6*B0fin(0,0,m1sq,mudim) - 32*m1sq*m2**4*m5**6*B0fin(0,0,m1sq,mudim) - 6*m2**6*m5**6*B0fin(0,0,m1sq,mudim) - 62*m1**4*m2sq*m5**6*B0fin(0,0,m1sq,mudim) + 6*m2**4*m5**8*B0fin(0,0,m1sq,mudim) + 18*m1sq*m2sq*m5**8*B0fin(0,0,m1sq,mudim) - 2*m2sq*m5**10*B0fin(0,0,m1sq,mudim) - 16*m1**10*m5sq*B0fin(0,0,m1sq,mudim) + 104*m1**6*m2**4*m5sq*B0fin(0,0,m1sq,mudim) - 72*m1**4*m2**6*m5sq*B0fin(0,0,m1sq,mudim) + 8*m1sq*m2**8*m5sq*B0fin(0,0,m1sq,mudim) - 24*m1**8*m2sq*m5sq*B0fin(0,0,m1sq,mudim) + 2*m1**12*B0fin(0,0,m1sq,mudim)**2 + 20*m1**8*m2**4*B0fin(0,0,m1sq,mudim)**2 - 20*m1**6*m2**6*B0fin(0,0,m1sq,mudim)**2 + 10*m1**4*m2**8*B0fin(0,0,m1sq,mudim)**2 - 2*m1sq*m2**10*B0fin(0,0,m1sq,mudim)**2 - 10*m1**10*m2sq*B0fin(0,0,m1sq,mudim)**2 + 16*m1**8*m5**4*B0fin(0,0,m1sq,mudim)**2 + 4*m1**4*m2**4*m5**4*B0fin(0,0,m1sq,mudim)**2 - 4*m1sq*m2**6*m5**4*B0fin(0,0,m1sq,mudim)**2 - 4*m2**8*m5**4*B0fin(0,0,m1sq,mudim)**2 - 12*m1**6*m2sq*m5**4*B0fin(0,0,m1sq,mudim)**2 - 14*m1**6*m5**6*B0fin(0,0,m1sq,mudim)**2 + 6*m1sq*m2**4*m5**6*B0fin(0,0,m1sq,mudim)**2 + 6*m2**6*m5**6*B0fin(0,0,m1sq,mudim)**2 + 2*m1**4*m2sq*m5**6*B0fin(0,0,m1sq,mudim)**2 + 6*m1**4*m5**8*B0fin(0,0,m1sq,mudim)**2 - 4*m2**4*m5**8*B0fin(0,0,m1sq,mudim)**2 - 2*m1sq*m2sq*m5**8*B0fin(0,0,m1sq,mudim)**2 - m1sq*m5**10*B0fin(0,0,m1sq,mudim)**2 + m2sq*m5**10*B0fin(0,0,m1sq,mudim)**2 - 9*m1**10*m5sq*B0fin(0,0,m1sq,mudim)**2 - 10*m1**6*m2**4*m5sq*B0fin(0,0,m1sq,mudim)**2 - 6*m1**4*m2**6*m5sq*B0fin(0,0,m1sq,mudim)**2 + 3*m1sq*m2**8*m5sq*B0fin(0,0,m1sq,mudim)**2 + m2**10*m5sq*B0fin(0,0,m1sq,mudim)**2 + 21*m1**8*m2sq*m5sq*B0fin(0,0,m1sq,mudim)**2 + 26*m1**8*m5**4*B0fin(0,0,m2sq,mudim) + 10*m1**4*m2**4*m5**4*B0fin(0,0,m2sq,mudim) + 18*m1sq*m2**6*m5**4*B0fin(0,0,m2sq,mudim) + 4*m2**8*m5**4*B0fin(0,0,m2sq,mudim) + 70*m1**6*m2sq*m5**4*B0fin(0,0,m2sq,mudim) - 30*m1**6*m5**6*B0fin(0,0,m2sq,mudim) - 6*m1sq*m2**4*m5**6*B0fin(0,0,m2sq,mudim) - 4*m2**6*m5**6*B0fin(0,0,m2sq,mudim) - 56*m1**4*m2sq*m5**6*B0fin(0,0,m2sq,mudim) + 14*m1**4*m5**8*B0fin(0,0,m2sq,mudim) + 10*m1sq*m2sq*m5**8*B0fin(0,0,m2sq,mudim) - 2*m1sq*m5**10*B0fin(0,0,m2sq,mudim) - 8*m1**10*m5sq*B0fin(0,0,m2sq,mudim) + 56*m1**6*m2**4*m5sq*B0fin(0,0,m2sq,mudim) - 8*m1**4*m2**6*m5sq*B0fin(0,0,m2sq,mudim) - 16*m1sq*m2**8*m5sq*B0fin(0,0,m2sq,mudim) - 24*m1**8*m2sq*m5sq*B0fin(0,0,m2sq,mudim) + 18*m1**8*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 18*m1**4*m2**4*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 42*m1sq*m2**6*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 4*m2**8*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 46*m1**6*m2sq*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 12*m1**6*m5**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 40*m1sq*m2**4*m5**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 10*m2**6*m5**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 34*m1**4*m2sq*m5**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 2*m1**4*m5**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 8*m2**4*m5**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 14*m1sq*m2sq*m5**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 2*m2sq*m5**10*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 8*m1**10*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 56*m1**6*m2**4*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 8*m1**4*m2**6*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 16*m1sq*m2**8*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 24*m1**8*m2sq*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 38*m1**8*m5**4*B0fin(0,0,m5sq,mudim) + 28*m1**4*m2**4*m5**4*B0fin(0,0,m5sq,mudim) - 16*m1sq*m2**6*m5**4*B0fin(0,0,m5sq,mudim) + 14*m2**8*m5**4*B0fin(0,0,m5sq,mudim) - 64*m1**6*m2sq*m5**4*B0fin(0,0,m5sq,mudim) - 22*m1**6*m5**6*B0fin(0,0,m5sq,mudim) + 14*m1sq*m2**4*m5**6*B0fin(0,0,m5sq,mudim) - 18*m2**6*m5**6*B0fin(0,0,m5sq,mudim) + 26*m1**4*m2sq*m5**6*B0fin(0,0,m5sq,mudim) + 6*m1**4*m5**8*B0fin(0,0,m5sq,mudim) + 6*m2**4*m5**8*B0fin(0,0,m5sq,mudim) - 12*m1sq*m2sq*m5**8*B0fin(0,0,m5sq,mudim) - 22*m1**10*m5sq*B0fin(0,0,m5sq,mudim) - 124*m1**6*m2**4*m5sq*B0fin(0,0,m5sq,mudim) + 76*m1**4*m2**6*m5sq*B0fin(0,0,m5sq,mudim) - 14*m1sq*m2**8*m5sq*B0fin(0,0,m5sq,mudim) - 2*m2**10*m5sq*B0fin(0,0,m5sq,mudim) + 86*m1**8*m2sq*m5sq*B0fin(0,0,m5sq,mudim) + 20*m1**8*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 40*m1**4*m2**4*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 48*m1sq*m2**6*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 4*m2**8*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 16*m1**6*m2sq*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 10*m1**6*m5**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 26*m1sq*m2**4*m5**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m2**6*m5**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 14*m1**4*m2sq*m5**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 4*m1**4*m5**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 4*m1sq*m2sq*m5**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 14*m1**10*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 20*m1**6*m2**4*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 52*m1**4*m2**6*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 26*m1sq*m2**8*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m2**10*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 22*m1**8*m2sq*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 18*m1**8*m5**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 4*m1**4*m2**4*m5**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 16*m1sq*m2**6*m5**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 6*m2**8*m5**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 12*m1**6*m5**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 4*m1sq*m2**4*m5**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 8*m2**6*m5**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m1**4*m5**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m2**4*m5**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 8*m1**10*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 48*m1**6*m2**4*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 64*m1**4*m2**6*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 24*m1sq*m2**8*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 8*m1**10*T134fin(m2,m1,0,mudim) - 48*m1**6*m2**4*T134fin(m2,m1,0,mudim) + 32*m1**4*m2**6*T134fin(m2,m1,0,mudim) - 8*m1sq*m2**8*T134fin(m2,m1,0,mudim) + 32*m1**8*m2sq*T134fin(m2,m1,0,mudim) - 56*m1**6*m5**4*T134fin(m2,m1,0,mudim) - 40*m1sq*m2**4*m5**4*T134fin(m2,m1,0,mudim) - 8*m2**6*m5**4*T134fin(m2,m1,0,mudim) - 24*m1**4*m2sq*m5**4*T134fin(m2,m1,0,mudim) + 44*m1**4*m5**6*T134fin(m2,m1,0,mudim) + 12*m2**4*m5**6*T134fin(m2,m1,0,mudim) + 40*m1sq*m2sq*m5**6*T134fin(m2,m1,0,mudim) - 16*m1sq*m5**8*T134fin(m2,m1,0,mudim) - 8*m2sq*m5**8*T134fin(m2,m1,0,mudim) + 2*m5**10*T134fin(m2,m1,0,mudim) + 34*m1**8*m5sq*T134fin(m2,m1,0,mudim) - 20*m1**4*m2**4*m5sq*T134fin(m2,m1,0,mudim) + 24*m1sq*m2**6*m5sq*T134fin(m2,m1,0,mudim) + 2*m2**8*m5sq*T134fin(m2,m1,0,mudim) - 40*m1**6*m2sq*m5sq*T134fin(m2,m1,0,mudim) - 2*m1**10*T134fin(m5,m1,m1,mudim) - 20*m1**6*m2**4*T134fin(m5,m1,m1,mudim) + 20*m1**4*m2**6*T134fin(m5,m1,m1,mudim) - 10*m1sq*m2**8*T134fin(m5,m1,m1,mudim) + 2*m2**10*T134fin(m5,m1,m1,mudim) + 10*m1**8*m2sq*T134fin(m5,m1,m1,mudim) - 12*m1**6*m5**4*T134fin(m5,m1,m1,mudim) - 4*m1sq*m2**4*m5**4*T134fin(m5,m1,m1,mudim) + 12*m2**6*m5**4*T134fin(m5,m1,m1,mudim) + 4*m1**4*m2sq*m5**4*T134fin(m5,m1,m1,mudim) + 8*m1**4*m5**6*T134fin(m5,m1,m1,mudim) - 8*m2**4*m5**6*T134fin(m5,m1,m1,mudim) - 2*m1sq*m5**8*T134fin(m5,m1,m1,mudim) + 2*m2sq*m5**8*T134fin(m5,m1,m1,mudim) + 8*m1**8*m5sq*T134fin(m5,m1,m1,mudim) + 16*m1sq*m2**6*m5sq*T134fin(m5,m1,m1,mudim) - 8*m2**8*m5sq*T134fin(m5,m1,m1,mudim) - 16*m1**6*m2sq*m5sq*T134fin(m5,m1,m1,mudim) + 8*m1**10*T134fin(m5,m2,m1,mudim) + 48*m1**6*m2**4*T134fin(m5,m2,m1,mudim) - 32*m1**4*m2**6*T134fin(m5,m2,m1,mudim) + 8*m1sq*m2**8*T134fin(m5,m2,m1,mudim) - 32*m1**8*m2sq*T134fin(m5,m2,m1,mudim) + 10*m1**6*m5**4*T134fin(m5,m2,m1,mudim) - 18*m1sq*m2**4*m5**4*T134fin(m5,m2,m1,mudim) - 2*m2**6*m5**4*T134fin(m5,m2,m1,mudim) + 10*m1**4*m2sq*m5**4*T134fin(m5,m2,m1,mudim) - 10*m1**4*m5**6*T134fin(m5,m2,m1,mudim) + 6*m2**4*m5**6*T134fin(m5,m2,m1,mudim) + 4*m1sq*m2sq*m5**6*T134fin(m5,m2,m1,mudim) + 2*m1sq*m5**8*T134fin(m5,m2,m1,mudim) - 2*m2sq*m5**8*T134fin(m5,m2,m1,mudim) - 10*m1**8*m5sq*T134fin(m5,m2,m1,mudim) - 36*m1**4*m2**4*m5sq*T134fin(m5,m2,m1,mudim) + 16*m1sq*m2**6*m5sq*T134fin(m5,m2,m1,mudim) - 2*m2**8*m5sq*T134fin(m5,m2,m1,mudim) + 32*m1**6*m2sq*m5sq*T134fin(m5,m2,m1,mudim))/((m1 - m2)**3*(m1 + m2)**3*(m1 + m2 - m5)**2*m5**2*(m1 - m2 + m5)**2*(-m1 + m2 + m5)**2*(m1 + m2 + m5)**2*(4*m1sq - m5sq))
		def eval_174():
			return ((-2*m5**4*(6 + 2*B0del(0,0,m1sq,mudim) - 6*B0fin(0,0,m1sq,mudim) + B0fin(0,0,m1sq,mudim)**2))/(m1**4 - m1sq*m7sq) + (8*m5**4*(m1sq + m7sq - 2*m1sq*B0fin(0,0,m1sq,mudim) - 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1 - m7)**3*(m1 + m7)**3) + (2*(-2*m1sq*(m1 - m7)**4*(m1 + m5 - m7)**2*(m1 + m7)**4*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(4*m1**4*m5**4 - 6*m1sq*m5**6 + m5**8 + (8*m1**4*m5**4 - 8*m1sq*m5**6 + m5**8 + 16*m1**6*m5sq)*B0fin(0,0,m1sq,mudim)) + m1sq*(m1 - m7)**4*(m1 + m5 - m7)**2*(m1 + m7)**4*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(4*(4*m1**4*m5**4 - 6*m1sq*m5**6 + m5**8)*B0fin(0,0,m1sq,mudim) + (8*m1**4*m5**4 - 8*m1sq*m5**6 + m5**8 + 16*m1**6*m5sq)*(2*B0del(0,0,m1sq,mudim) + B0fin(0,0,m1sq,mudim)**2)) - 2*m1sq*m5sq*(m1 - m7)**4*(m1 + m7)**4*(8*m1**4*m5sq*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2 - 2*(-8*m1sq*m5**4 + m5**6 + 12*m1**4*m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2 + 2*m5**4*(-4*m1sq + m5sq)**2*(-3*m1**6 + (m5sq - m7sq)**3 + m1**4*(7*m5sq + m7sq) + m1sq*(-5*m5**4 + 3*m7**4 + 2*m5sq*m7sq)) + (8*m1**4*m5sq*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2 - 4*m1sq*m5**4*(-4*m1sq + m5sq)**2*(m1sq + m5sq - m7sq)*m7sq)*B0fin(0,0,m1sq,mudim) + (8*m1**4*m5sq*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2 - 4*m1sq*m5**4*(-4*m1sq + m5sq)**2*(m1sq + m5sq - m7sq)*m7sq)*B0fin(0,0,m5sq,mudim)) + 2*m1sq*m5sq*(m1 - m7)**4*(m1 + m7)**4*((8*m1**4*m5sq*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2 - 4*m1sq*m5**4*(-4*m1sq + m5sq)**2*(m1sq + m5sq - m7sq)*m7sq)*B0del(0,0,m1sq,mudim) + (8*m1**4*m5sq*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2 - 4*m1sq*m5**4*(-4*m1sq + m5sq)**2*(m1sq + m5sq - m7sq)*m7sq)*B0del(0,0,m5sq,mudim) + (8*m1**4*m5sq*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2 - 2*(-8*m1sq*m5**4 + m5**6 + 12*m1**4*m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2 + 2*m5**4*(-4*m1sq + m5sq)**2*(-3*m1**6 + (m5sq - m7sq)**3 + m1**4*(7*m5sq + m7sq) + m1sq*(-5*m5**4 + 3*m7**4 + 2*m5sq*m7sq)))*B0fin(0,0,m1sq,mudim) + (8*m1**4*m5sq*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2 - 2*(-8*m1sq*m5**4 + m5**6 + 12*m1**4*m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2 + 2*m5**4*(-4*m1sq + m5sq)**2*(-3*m1**6 + (m5sq - m7sq)**3 + m1**4*(7*m5sq + m7sq) + m1sq*(-5*m5**4 + 3*m7**4 + 2*m5sq*m7sq)) + (8*m1**4*m5sq*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2 - 4*m1sq*m5**4*(-4*m1sq + m5sq)**2*(m1sq + m5sq - m7sq)*m7sq)*B0fin(0,0,m1sq,mudim))*B0fin(0,0,m5sq,mudim)) - 8*m1**4*m5**6*(-4*m1sq + m5sq)**2*(m1 - m7)**4*(m1 + m7)**4*(m1sq - m5sq - m7sq)*m7sq*(2 + B0fin(0,0,m5sq,mudim) + B0fin(0,0,m7sq,mudim)) - 2*m5**4*(-4*m1**3 + m1*m5sq)**2*m7sq*(2*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(m1sq - m7sq)**2*(3*m1sq - m7sq) + (m1 - m7)**4*(m1 + m7)**4*(-6*m1**6 - 2*(m5sq - m7sq)**3 + 2*m1**4*(m5sq + 7*m7sq) + 2*m1sq*(3*m5**4 - 5*m7**4 + 2*m5sq*m7sq)) - 4*m1sq*m5sq*(m1 - m7)**4*(m1 + m7)**4*(m1sq - m5sq + m7sq)*B0fin(0,0,m1sq,mudim) - 4*m1sq*m5sq*(m1 - m7)**4*(m1 + m7)**4*(m1sq - m5sq + m7sq)*B0fin(0,0,m7sq,mudim)) + 2*m5**4*(-4*m1**3 + m1*m5sq)**2*m7sq*(-4*m1sq*m5sq*(m1 - m7)**4*(m1 + m7)**4*(m1sq - m5sq + m7sq)*B0del(0,0,m1sq,mudim) - 4*m1sq*m5sq*(m1 - m7)**4*(m1 + m7)**4*(m1sq - m5sq + m7sq)*B0del(0,0,m7sq,mudim) + (2*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(m1sq - m7sq)**2*(3*m1sq - m7sq) + (m1 - m7)**4*(m1 + m7)**4*(-6*m1**6 - 2*(m5sq - m7sq)**3 + 2*m1**4*(m5sq + 7*m7sq) + 2*m1sq*(3*m5**4 - 5*m7**4 + 2*m5sq*m7sq)))*B0fin(0,0,m1sq,mudim) + (2*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(m1sq - m7sq)**2*(3*m1sq - m7sq) + (m1 - m7)**4*(m1 + m7)**4*(-6*m1**6 - 2*(m5sq - m7sq)**3 + 2*m1**4*(m5sq + 7*m7sq) + 2*m1sq*(3*m5**4 - 5*m7**4 + 2*m5sq*m7sq)) - 4*m1sq*m5sq*(m1 - m7)**4*(m1 + m7)**4*(m1sq - m5sq + m7sq)*B0fin(0,0,m1sq,mudim))*B0fin(0,0,m7sq,mudim)) + 8*m1**4*m5**6*(-4*m1sq + m5sq)**2*(m1 - m7)**4*(m1 + m7)**4*(m1sq - m5sq - m7sq)*m7sq*(B0del(0,0,m5sq,mudim) + B0del(0,0,m7sq,mudim) + 2*B0fin(0,0,m5sq,mudim) + 2*B0fin(0,0,m7sq,mudim) + B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))))/(m1**4*(-2*m1 + m5)**2*(2*m1 + m5)**2*(m1 - m7)**4*(m1 + m5 - m7)**2*(m1 + m7)**4*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(m1sq - m7sq)) + (8*m5sq*(2*m5sq*(2*m1sq + m5sq) + (4*m1sq - m5sq)*(2*m1sq + m5sq + 4*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim)) - 4*m1sq*T134fin(m5,m1,m1,mudim)))/((-4*m1sq + m5sq)**2*(m1sq - m7sq)) + (8*m5**4*(-2*(-m1sq + m5sq + m7sq)**2*(m1sq + m5sq + m7sq) + (m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))*(m1sq + m5sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)) + 4*m5sq*m7sq*T134fin(m7,m5,m1,mudim)))/((m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(m1sq - m7sq)))/(16.*m5**6)
		def eval_175():
			return ((-2*m7**4*(6 + 2*B0del(0,0,m1sq,mudim) - 6*B0fin(0,0,m1sq,mudim) + B0fin(0,0,m1sq,mudim)**2))/(m1**4 - m1sq*m5sq) + (8*m7**4*(m1sq + m5sq - 2*m1sq*B0fin(0,0,m1sq,mudim) - 2*m5sq*B0fin(0,0,m5sq,mudim)))/((m1 - m5)**3*(m1 + m5)**3) + (2*(-2*m1sq*(m1 - m5)**4*(m1 + m5)**4*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(4*m1**4*m7**4 - 6*m1sq*m7**6 + m7**8 + (8*m1**4*m7**4 - 8*m1sq*m7**6 + m7**8 + 16*m1**6*m7sq)*B0fin(0,0,m1sq,mudim)) + m1sq*(m1 - m5)**4*(m1 + m5)**4*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(4*(4*m1**4*m7**4 - 6*m1sq*m7**6 + m7**8)*B0fin(0,0,m1sq,mudim) + (8*m1**4*m7**4 - 8*m1sq*m7**6 + m7**8 + 16*m1**6*m7sq)*(2*B0del(0,0,m1sq,mudim) + B0fin(0,0,m1sq,mudim)**2)) - 2*m5sq*m7**4*(-4*m1**3 + m1*m7sq)**2*(2*(m1sq - m5sq)**2*(3*m1sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2 + 2*(m1 - m5)**4*(m1 + m5)**4*(-3*m1**6 + (m5sq - m7sq)**3 + m1**4*(7*m5sq + m7sq) + m1sq*(-5*m5**4 + 3*m7**4 + 2*m5sq*m7sq)) - 4*m1sq*(m1 - m5)**4*(m1 + m5)**4*(m1sq + m5sq - m7sq)*m7sq*B0fin(0,0,m1sq,mudim) - 4*m1sq*(m1 - m5)**4*(m1 + m5)**4*(m1sq + m5sq - m7sq)*m7sq*B0fin(0,0,m5sq,mudim)) + 2*m5sq*m7**4*(-4*m1**3 + m1*m7sq)**2*(-4*m1sq*(m1 - m5)**4*(m1 + m5)**4*(m1sq + m5sq - m7sq)*m7sq*B0del(0,0,m1sq,mudim) - 4*m1sq*(m1 - m5)**4*(m1 + m5)**4*(m1sq + m5sq - m7sq)*m7sq*B0del(0,0,m5sq,mudim) + (2*(m1sq - m5sq)**2*(3*m1sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2 + 2*(m1 - m5)**4*(m1 + m5)**4*(-3*m1**6 + (m5sq - m7sq)**3 + m1**4*(7*m5sq + m7sq) + m1sq*(-5*m5**4 + 3*m7**4 + 2*m5sq*m7sq)))*B0fin(0,0,m1sq,mudim) + (2*(m1sq - m5sq)**2*(3*m1sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2 + 2*(m1 - m5)**4*(m1 + m5)**4*(-3*m1**6 + (m5sq - m7sq)**3 + m1**4*(7*m5sq + m7sq) + m1sq*(-5*m5**4 + 3*m7**4 + 2*m5sq*m7sq)) - 4*m1sq*(m1 - m5)**4*(m1 + m5)**4*(m1sq + m5sq - m7sq)*m7sq*B0fin(0,0,m1sq,mudim))*B0fin(0,0,m5sq,mudim)) - 8*m1**4*(m1 - m5)**4*(m1 + m5)**4*m5sq*m7**6*(m1sq - m5sq - m7sq)*(-4*m1sq + m7sq)**2*(2 + B0fin(0,0,m5sq,mudim) + B0fin(0,0,m7sq,mudim)) - 2*m1sq*(m1 - m5)**4*(m1 + m5)**4*m7sq*(8*m1**4*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*m7sq - 2*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(-8*m1sq*m7**4 + m7**6 + 12*m1**4*m7sq) + m7**4*(-4*m1sq + m7sq)**2*(-6*m1**6 - 2*(m5sq - m7sq)**3 + 2*m1**4*(m5sq + 7*m7sq) + 2*m1sq*(3*m5**4 - 5*m7**4 + 2*m5sq*m7sq)) + (8*m1**4*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*m7sq - 4*m1sq*m5sq*m7**4*(-4*m1sq + m7sq)**2*(m1sq - m5sq + m7sq))*B0fin(0,0,m1sq,mudim) + (8*m1**4*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*m7sq - 4*m1sq*m5sq*m7**4*(-4*m1sq + m7sq)**2*(m1sq - m5sq + m7sq))*B0fin(0,0,m7sq,mudim)) + 2*m1sq*(m1 - m5)**4*(m1 + m5)**4*m7sq*((8*m1**4*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*m7sq - 4*m1sq*m5sq*m7**4*(-4*m1sq + m7sq)**2*(m1sq - m5sq + m7sq))*B0del(0,0,m1sq,mudim) + (8*m1**4*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*m7sq - 4*m1sq*m5sq*m7**4*(-4*m1sq + m7sq)**2*(m1sq - m5sq + m7sq))*B0del(0,0,m7sq,mudim) + (8*m1**4*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*m7sq - 2*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(-8*m1sq*m7**4 + m7**6 + 12*m1**4*m7sq) + m7**4*(-4*m1sq + m7sq)**2*(-6*m1**6 - 2*(m5sq - m7sq)**3 + 2*m1**4*(m5sq + 7*m7sq) + 2*m1sq*(3*m5**4 - 5*m7**4 + 2*m5sq*m7sq)))*B0fin(0,0,m1sq,mudim) + (8*m1**4*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*m7sq - 2*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(-8*m1sq*m7**4 + m7**6 + 12*m1**4*m7sq) + m7**4*(-4*m1sq + m7sq)**2*(-6*m1**6 - 2*(m5sq - m7sq)**3 + 2*m1**4*(m5sq + 7*m7sq) + 2*m1sq*(3*m5**4 - 5*m7**4 + 2*m5sq*m7sq)) + (8*m1**4*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*m7sq - 4*m1sq*m5sq*m7**4*(-4*m1sq + m7sq)**2*(m1sq - m5sq + m7sq))*B0fin(0,0,m1sq,mudim))*B0fin(0,0,m7sq,mudim)) + 8*m1**4*(m1 - m5)**4*(m1 + m5)**4*m5sq*m7**6*(m1sq - m5sq - m7sq)*(-4*m1sq + m7sq)**2*(B0del(0,0,m5sq,mudim) + B0del(0,0,m7sq,mudim) + 2*B0fin(0,0,m5sq,mudim) + 2*B0fin(0,0,m7sq,mudim) + B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))))/(m1**4*(m1 - m5)**4*(m1 + m5)**4*(m1sq - m5sq)*(m1 + m5 - m7)**2*(-2*m1 + m7)**2*(2*m1 + m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2) + (8*m7sq*(8*m1**4 + m7**4 + 6*m1sq*m7sq + 4*(4*m1**4 - m1sq*m7sq)*B0fin(0,0,m1sq,mudim) + (-2*m7**4 + 8*m1sq*m7sq)*B0fin(0,0,m7sq,mudim) - 4*m1sq*T134fin(m7,m1,m1,mudim)))/((m1sq - m5sq)*(-4*m1sq + m7sq)**2) + (8*m7**4*(-2*(-m1sq + m5sq + m7sq)**2*(m1sq + m5sq + m7sq) + (m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))*(m1sq + m5sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)) + 4*m5sq*m7sq*T134fin(m7,m5,m1,mudim)))/((m1sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2))/(16.*m7**6)
		def eval_176():
			return ((-4*m3sq*(m1**4 - m3**4 - 4*m1sq*m3sq + m3sq*m7sq)*B0del(0,0,m3sq,mudim))/(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq)) + (4*(m1sq - m3sq)**3*(m1**4 + (m3sq - m7sq)*m7sq - m1sq*(m3sq + 3*m7sq))*B0del(0,0,m7sq,mudim))/(m7**2*(-4*m1sq + m7sq)*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))) + (2*(m1sq - m3sq)**2*((2*m1**6 + m3sq*m7**4 + 6*m1**4*m7sq - 2*m1sq*(m7**4 + 2*m3sq*m7sq))*B0del(0,0,m1sq,mudim) - (m1sq - m3sq)*(4*m1sq - m7sq)*m7sq*(-2 + B0fin(0,0,m1sq,mudim))))/(4*m1**4*m7**4 - m1sq*m7**6) + ((-4*m3sq*(m1**4 - m3**4 - 4*m1sq*m3sq + m3sq*m7sq))/(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq)) + (4*(m1sq - m3sq)**3*(m1**4 + (m3sq - m7sq)*m7sq - m1sq*(m3sq + 3*m7sq)))/(m7**2*(-4*m1sq + m7sq)*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))) + (2*(m1**3 - m1*m3sq)**2*(m1**(-2) + (m1sq - m3sq)/m1**4 + (2*(m1sq - m7sq))/(-m7**4 + 4*m1sq*m7sq)))/m7**2)*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)) - (2*(m1sq - m3sq)**3*(1 + 2*B0del(0,0,m1sq,mudim) - 4*B0fin(0,0,m1sq,mudim) + B0fin(0,0,m1sq,mudim)**2))/(m1**2*m7**2) + (2*(m1sq - m3sq)**2*(-4*(m1sq - m3sq)*(6*m1sq - m7sq)*m7sq*B0fin(0,0,m1sq,mudim) - (16*m1**6 - 2*m3sq*m7**4 - 2*m1**4*(4*m3sq + 5*m7sq) + 2*m1sq*(m7**4 + 4*m3sq*m7sq))*(2*B0del(0,0,m1sq,mudim) + B0fin(0,0,m1sq,mudim)**2)))/(m7**4*(-4*m1sq + m7sq)**2) - (4*m1sq*m3sq*(2*m1sq + 2*m3sq - m7sq)*(B0del(0,0,m1sq,mudim) + B0del(0,0,m3sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim)))/(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq)) + (-1 + B0fin(0,0,m1sq,mudim))*(((m1sq - m3sq)**2*(-2 + (2*m3sq)/m1**2 + 2*m1sq*(m1**(-2) + (m1sq - m3sq)/m1**4 + (2*(m1sq - m7sq))/(-m7**4 + 4*m1sq*m7sq))*B0fin(0,0,m1sq,mudim)))/m7**2 - (4*m3sq*(m1**4 - m3**4 - 4*m1sq*m3sq + m3sq*m7sq)*B0fin(0,0,m3sq,mudim))/(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq)) + (4*(m1sq - m3sq)**3*(m1**4 + (m3sq - m7sq)*m7sq - m1sq*(m3sq + 3*m7sq))*B0fin(0,0,m7sq,mudim))/(m7**2*(-4*m1sq + m7sq)*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq)))) + (4*(m1**3 - m1*m3sq)**2*((m7sq/(4*m1sq - m7sq) - (2*(m1sq - m3sq)*(-m7**4 + 2*m1sq*m7sq))/(-4*m1**3 + m1*m7sq)**2 - m7**4/(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq)))*B0del(0,0,m1sq,mudim) + (m7sq/(4*m1sq - m7sq) - (2*(m1sq - m3sq)*(-m7**4 + 2*m1sq*m7sq))/(-4*m1**3 + m1*m7sq)**2 - m7**4/(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq)))*B0del(0,0,m7sq,mudim) + (8*(m1sq - m3sq)*m7sq*B0fin(0,0,m1sq,mudim))/(-4*m1sq + m7sq)**2 + ((8*(m1sq - m3sq)*m7sq)/(-4*m1sq + m7sq)**2 + (m7sq/(4*m1sq - m7sq) - (2*(m1sq - m3sq)*(-m7**4 + 2*m1sq*m7sq))/(-4*m1**3 + m1*m7sq)**2 - m7**4/(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq)))*B0fin(0,0,m1sq,mudim))*B0fin(0,0,m7sq,mudim)))/m7**4 + (8*(-(m1sq*m3) + m3**3)**2*(B0del(0,0,m3sq,mudim) + B0del(0,0,m7sq,mudim) + B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim)))/(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq)) + (4*m1sq*(16*m1**12 - 6*m1**10*(12*m3sq + 7*m7sq) - 4*m1**6*(28*m3**6 + 18*m3sq*m7**4 + 5*m7**6 + 15*m3**4*m7sq) + m3sq*m7sq*(4*m3**8 + 2*m3**4*m7**4 + 4*m3sq*m7**6 - m7**8 - 7*m3**6*m7sq) - 2*m1sq*m3sq*(4*m3**8 - 8*m3**4*m7**4 + 20*m3sq*m7**6 - 3*m7**8 + 5*m3**6*m7sq) + 2*m1**4*(24*m3**8 + 37*m3**4*m7**4 + 5*m3sq*m7**6 + m7**8 + 8*m3**6*m7sq) + m1**8*(128*m3**4 + 53*m7**4 + 92*m3sq*m7sq))*B0fin(0,0,m1sq,mudim) - 4*m7sq*(m3sq*m7sq*(-4*m1sq + m7sq)**2*(2*m3**4 + m1sq*(-6*m3sq + m7sq))*B0fin(0,0,m3sq,mudim) + (m1sq - m3sq)**3*((2*m1sq + m7sq)*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq)) + (m1**4*(4*m3sq - 15*m7sq) + 2*m3sq*(m3sq - 2*m7sq)*m7sq + m1sq*(-4*m3**4 + 6*m7**4 + 5*m3sq*m7sq))*B0fin(0,0,m7sq,mudim))))/(m7**4*(-4*m1sq + m7sq)**2*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))) + (4*(m1sq - m3sq)*(m1sq + m3sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,m1,0,mudim)))/m7**2 + (4*(m1sq - m3sq)**2*(2*(m1sq - m3sq)*m7sq*(2*m1sq + m7sq) - (4*m1sq - m7sq)*(m1sq - m3sq - m7sq)*(2*m1sq + m7sq + 4*m1sq*B0fin(0,0,m1sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)) + (4*m1**4 + m7**4 + 2*m3sq*m7sq - 2*m1sq*(2*m3sq + 3*m7sq))*T134fin(m7,m1,m1,mudim)))/(m7**4*(-4*m1sq + m7sq)**2) - (4*(m1sq - m3sq)**2*(m1sq - m3sq - m7sq)*(m1sq + m3sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim) - T134fin(m7,m3,m1,mudim)))/(m7**2*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))))/(4.*(m1sq - m3sq)**4)
		def eval_177():
			return ((-4*m3sq*(m1**4 - m3**4 - 4*m1sq*m3sq + m3sq*m5sq)*B0del(0,0,m3sq,mudim))/(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq)) + (4*(m1sq - m3sq)**3*(m1**4 + (m3sq - m5sq)*m5sq - m1sq*(m3sq + 3*m5sq))*B0del(0,0,m5sq,mudim))/(m5**2*(-4*m1sq + m5sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) + (2*(m1sq - m3sq)**2*((2*m1**6 + m3sq*m5**4 + 6*m1**4*m5sq - 2*m1sq*(m5**4 + 2*m3sq*m5sq))*B0del(0,0,m1sq,mudim) - (m1sq - m3sq)*(4*m1sq - m5sq)*m5sq*(-2 + B0fin(0,0,m1sq,mudim))))/(4*m1**4*m5**4 - m1sq*m5**6) + ((-4*m3sq*(m1**4 - m3**4 - 4*m1sq*m3sq + m3sq*m5sq))/(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq)) + (4*(m1sq - m3sq)**3*(m1**4 + (m3sq - m5sq)*m5sq - m1sq*(m3sq + 3*m5sq)))/(m5**2*(-4*m1sq + m5sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) + (2*(m1**3 - m1*m3sq)**2*(m1**(-2) + (m1sq - m3sq)/m1**4 + (2*(m1sq - m5sq))/(-m5**4 + 4*m1sq*m5sq)))/m5**2)*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)) - (2*(m1sq - m3sq)**3*(1 + 2*B0del(0,0,m1sq,mudim) - 4*B0fin(0,0,m1sq,mudim) + B0fin(0,0,m1sq,mudim)**2))/(m1**2*m5**2) + (2*(m1sq - m3sq)**2*(-4*(m1sq - m3sq)*(6*m1sq - m5sq)*m5sq*B0fin(0,0,m1sq,mudim) - (16*m1**6 - 2*m3sq*m5**4 - 2*m1**4*(4*m3sq + 5*m5sq) + 2*m1sq*(m5**4 + 4*m3sq*m5sq))*(2*B0del(0,0,m1sq,mudim) + B0fin(0,0,m1sq,mudim)**2)))/(m5**4*(-4*m1sq + m5sq)**2) - (4*m1sq*m3sq*(2*m1sq + 2*m3sq - m5sq)*(B0del(0,0,m1sq,mudim) + B0del(0,0,m3sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim)))/(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq)) + (-1 + B0fin(0,0,m1sq,mudim))*(((m1sq - m3sq)**2*(-2 + (2*m3sq)/m1**2 + 2*m1sq*(m1**(-2) + (m1sq - m3sq)/m1**4 + (2*(m1sq - m5sq))/(-m5**4 + 4*m1sq*m5sq))*B0fin(0,0,m1sq,mudim)))/m5**2 - (4*m3sq*(m1**4 - m3**4 - 4*m1sq*m3sq + m3sq*m5sq)*B0fin(0,0,m3sq,mudim))/(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq)) + (4*(m1sq - m3sq)**3*(m1**4 + (m3sq - m5sq)*m5sq - m1sq*(m3sq + 3*m5sq))*B0fin(0,0,m5sq,mudim))/(m5**2*(-4*m1sq + m5sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq)))) + (4*(m1**3 - m1*m3sq)**2*((m5sq/(4*m1sq - m5sq) - (2*(m1sq - m3sq)*(-m5**4 + 2*m1sq*m5sq))/(-4*m1**3 + m1*m5sq)**2 - m5**4/(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq)))*B0del(0,0,m1sq,mudim) + (m5sq/(4*m1sq - m5sq) - (2*(m1sq - m3sq)*(-m5**4 + 2*m1sq*m5sq))/(-4*m1**3 + m1*m5sq)**2 - m5**4/(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq)))*B0del(0,0,m5sq,mudim) + (8*(m1sq - m3sq)*m5sq*B0fin(0,0,m1sq,mudim))/(-4*m1sq + m5sq)**2 + ((8*(m1sq - m3sq)*m5sq)/(-4*m1sq + m5sq)**2 + (m5sq/(4*m1sq - m5sq) - (2*(m1sq - m3sq)*(-m5**4 + 2*m1sq*m5sq))/(-4*m1**3 + m1*m5sq)**2 - m5**4/(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq)))*B0fin(0,0,m1sq,mudim))*B0fin(0,0,m5sq,mudim)))/m5**4 + (8*(-(m1sq*m3) + m3**3)**2*(B0del(0,0,m3sq,mudim) + B0del(0,0,m5sq,mudim) + B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim)))/(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq)) + (4*m1sq*(16*m1**12 - 6*m1**10*(12*m3sq + 7*m5sq) - 4*m1**6*(28*m3**6 + 18*m3sq*m5**4 + 5*m5**6 + 15*m3**4*m5sq) + m3sq*m5sq*(4*m3**8 + 2*m3**4*m5**4 + 4*m3sq*m5**6 - m5**8 - 7*m3**6*m5sq) - 2*m1sq*m3sq*(4*m3**8 - 8*m3**4*m5**4 + 20*m3sq*m5**6 - 3*m5**8 + 5*m3**6*m5sq) + 2*m1**4*(24*m3**8 + 37*m3**4*m5**4 + 5*m3sq*m5**6 + m5**8 + 8*m3**6*m5sq) + m1**8*(128*m3**4 + 53*m5**4 + 92*m3sq*m5sq))*B0fin(0,0,m1sq,mudim) - 4*m5sq*(m3sq*m5sq*(-4*m1sq + m5sq)**2*(2*m3**4 + m1sq*(-6*m3sq + m5sq))*B0fin(0,0,m3sq,mudim) + (m1sq - m3sq)**3*((2*m1sq + m5sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq)) + (m1**4*(4*m3sq - 15*m5sq) + 2*m3sq*(m3sq - 2*m5sq)*m5sq + m1sq*(-4*m3**4 + 6*m5**4 + 5*m3sq*m5sq))*B0fin(0,0,m5sq,mudim))))/(m5**4*(-4*m1sq + m5sq)**2*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) + (4*(m1sq - m3sq)*(m1sq + m3sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,m1,0,mudim)))/m5**2 + (4*(m1sq - m3sq)**2*(2*(m1sq - m3sq)*m5sq*(2*m1sq + m5sq) - (4*m1sq - m5sq)*(m1sq - m3sq - m5sq)*(2*m1sq + m5sq + 4*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim)) + (4*m1**4 + m5**4 + 2*m3sq*m5sq - 2*m1sq*(2*m3sq + 3*m5sq))*T134fin(m5,m1,m1,mudim)))/(m5**4*(-4*m1sq + m5sq)**2) - (4*(m1sq - m3sq)**2*(m1sq - m3sq - m5sq)*(m1sq + m3sq + m5sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) - T134fin(m5,m3,m1,mudim)))/(m5**2*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))))/(4.*(m1sq - m3sq)**4)
		def eval_178():
			return (-2*m4sq*B0del(0,0,m2sq,mudim))/((m2sq - m3sq)*(4*m2sq*m4sq - (m2sq + m4sq - m5sq)**2)*(m4sq - m5sq)) + ((m2**4 - m2sq*(m4sq - 3*m5sq) + (m4sq - m5sq)*m5sq)*B0del(0,0,m2sq,mudim))/(m2**2*(m2sq - m3sq)*(m2sq - 4*m5sq)*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))) + (m5sq*(2*m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + 3*m5sq))*B0del(0,0,m2sq,mudim))/((m2sq - m3sq)*(4*m2sq*m4sq - (m2sq + m4sq - m5sq)**2)*(m4sq - m5sq)*(m2**4 - 4*m2sq*m5sq)) + (2*m4sq*B0del(0,0,m3sq,mudim))/((m2sq - m3sq)*(4*m3sq*m4sq - (m3sq + m4sq - m5sq)**2)*(m4sq - m5sq)) + ((m3**4 - m3sq*(m4sq - 3*m5sq) + (m4sq - m5sq)*m5sq)*B0del(0,0,m3sq,mudim))/(m3**2*(-m2sq + m3sq)*(m3sq - 4*m5sq)*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))) - (m5sq*(2*m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + 3*m5sq))*B0del(0,0,m3sq,mudim))/((m2sq - m3sq)*(4*m3sq*m4sq - (m3sq + m4sq - m5sq)**2)*(m4sq - m5sq)*(m3**4 - 4*m3sq*m5sq)) - (2*m4sq*B0del(0,0,m4sq,mudim))/((m2sq - m3sq)*(4*m2sq*m4sq - (m2sq + m4sq - m5sq)**2)*(m4sq - m5sq)) + (2*m4sq*B0del(0,0,m4sq,mudim))/((m2sq - m3sq)*(4*m3sq*m4sq - (m3sq + m4sq - m5sq)**2)*(m4sq - m5sq)) + (m4sq*(m4**6 + 5*m4sq*m5**4 - 2*m5**6 + 12*m4**4*m5sq + m3sq*(-m4**4 + m5**4 - 4*m4sq*m5sq) + m2sq*(-m4**4 + m3sq*m4sq + m5**4 - 4*m4sq*m5sq))*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)**3*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))) - (m4sq*m5sq*(3*m4**4 + 3*m5**4 + 10*m4sq*m5sq - 2*m3sq*(m4sq + m5sq) + m2sq*(m3sq - 2*(m4sq + m5sq)))*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)**3*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))) + (2*m5**4*(m2**4 + m3**4 + m2sq*(m3sq - 4*m5sq) - 4*m3sq*m5sq)*B0del(0,0,m5sq,mudim))/(m2**4*m3**4*(m2sq - 4*m5sq)*(m3sq - 4*m5sq)*(-m4sq + m5sq)) + (m5sq*(2*m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + 3*m5sq))*B0del(0,0,m5sq,mudim))/((m2sq - m3sq)*(4*m2sq*m4sq - (m2sq + m4sq - m5sq)**2)*(m4sq - m5sq)*(m2**4 - 4*m2sq*m5sq)) - (m5sq*(2*m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + 3*m5sq))*B0del(0,0,m5sq,mudim))/((m2sq - m3sq)*(4*m3sq*m4sq - (m3sq + m4sq - m5sq)**2)*(m4sq - m5sq)*(m3**4 - 4*m3sq*m5sq)) + ((-2*m3**4*m5**4 + 8*m3sq*m5**6 + m2sq*(6*m3sq*m5**4 + 8*m5**6 - 2*m3**4*m5sq) + m2**4*(m3**4 - 2*m5**4 - 2*m3sq*m5sq))*B0del(0,0,m5sq,mudim))/(2.*m2**4*m3**4*(m2sq - 4*m5sq)*(m3sq - 4*m5sq)*(-m4sq + m5sq)) - (m4sq*m5sq*(3*m4**4 + 3*m5**4 + 10*m4sq*m5sq - 2*m3sq*(m4sq + m5sq) + m2sq*(m3sq - 2*(m4sq + m5sq)))*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)**3*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))) + (2*m4sq*B0fin(0,0,m2sq,mudim))/((m2sq - m3sq)*(4*m2sq*m4sq - (m2sq + m4sq - m5sq)**2)*(m4sq - m5sq)) - ((m2**4 - m2sq*(m4sq - 3*m5sq) + (m4sq - m5sq)*m5sq)*B0fin(0,0,m2sq,mudim))/(m2**2*(m2sq - m3sq)*(m2sq - 4*m5sq)*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))) - (m5sq*(2*m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + 3*m5sq))*B0fin(0,0,m2sq,mudim))/((m2sq - m3sq)*(4*m2sq*m4sq - (m2sq + m4sq - m5sq)**2)*(m4sq - m5sq)*(m2**4 - 4*m2sq*m5sq)) - (2*m4sq*B0fin(0,0,m3sq,mudim))/((m2sq - m3sq)*(4*m3sq*m4sq - (m3sq + m4sq - m5sq)**2)*(m4sq - m5sq)) - ((m3**4 - m3sq*(m4sq - 3*m5sq) + (m4sq - m5sq)*m5sq)*B0fin(0,0,m3sq,mudim))/(m3**2*(-m2sq + m3sq)*(m3sq - 4*m5sq)*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))) + (m5sq*(2*m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + 3*m5sq))*B0fin(0,0,m3sq,mudim))/((m2sq - m3sq)*(4*m3sq*m4sq - (m3sq + m4sq - m5sq)**2)*(m4sq - m5sq)*(m3**4 - 4*m3sq*m5sq)) + (2*m4sq*B0fin(0,0,m4sq,mudim))/((m2sq - m3sq)*(4*m2sq*m4sq - (m2sq + m4sq - m5sq)**2)*(m4sq - m5sq)) - (2*m4sq*B0fin(0,0,m4sq,mudim))/((m2sq - m3sq)*(4*m3sq*m4sq - (m3sq + m4sq - m5sq)**2)*(m4sq - m5sq)) - (m4sq*(m4**6 + 5*m4sq*m5**4 - 2*m5**6 + 12*m4**4*m5sq + m3sq*(-m4**4 + m5**4 - 4*m4sq*m5sq) + m2sq*(-m4**4 + m3sq*m4sq + m5**4 - 4*m4sq*m5sq))*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)**3*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))) + (m4sq*m5sq*(3*m4**4 + 3*m5**4 + 10*m4sq*m5sq - 2*m3sq*(m4sq + m5sq) + m2sq*(m3sq - 2*(m4sq + m5sq)))*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)**3*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))) - (2*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m2sq - m3sq)*(4*m2sq*m4sq - (m2sq + m4sq - m5sq)**2)*(m4sq - m5sq)) + (2*m4sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim))/((m2sq - m3sq)*(4*m3sq*m4sq - (m3sq + m4sq - m5sq)**2)*(m4sq - m5sq)) + ((m2**4 - m2sq*(m4sq - 3*m5sq) + (m4sq - m5sq)*m5sq)*(B0del(0,0,m5sq,mudim) - B0fin(0,0,m5sq,mudim)))/(m2**2*(m2sq - m3sq)*(m2sq - 4*m5sq)*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))) + ((m3**4 - m3sq*(m4sq - 3*m5sq) + (m4sq - m5sq)*m5sq)*(B0del(0,0,m5sq,mudim) - B0fin(0,0,m5sq,mudim)))/(m3**2*(-m2sq + m3sq)*(m3sq - 4*m5sq)*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))) + ((-2*m3**4*m5**4 + 8*m3sq*m5**6 + m2sq*(6*m3sq*m5**4 + 8*m5**6 - 2*m3**4*m5sq) + m2**4*(m3**4 - 2*m5**4 - 2*m3sq*m5sq))*(B0del(0,0,m5sq,mudim) - B0fin(0,0,m5sq,mudim)))/(2.*m2**4*m3**4*(m2sq - 4*m5sq)*(m3sq - 4*m5sq)*(-m4sq + m5sq)) + (m4sq*(m4**6 + 5*m4sq*m5**4 - 2*m5**6 + 12*m4**4*m5sq + m3sq*(-m4**4 + m5**4 - 4*m4sq*m5sq) + m2sq*(-m4**4 + m3sq*m4sq + m5**4 - 4*m4sq*m5sq))*(B0del(0,0,m5sq,mudim) - B0fin(0,0,m5sq,mudim)))/((m4sq - m5sq)**3*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))) - (2*m5**4*(m2**4 + m3**4 + m2sq*(m3sq - 4*m5sq) - 4*m3sq*m5sq)*B0fin(0,0,m5sq,mudim))/(m2**4*m3**4*(m2sq - 4*m5sq)*(m3sq - 4*m5sq)*(-m4sq + m5sq)) - (m5sq*(2*m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + 3*m5sq))*B0fin(0,0,m5sq,mudim))/((m2sq - m3sq)*(4*m2sq*m4sq - (m2sq + m4sq - m5sq)**2)*(m4sq - m5sq)*(m2**4 - 4*m2sq*m5sq)) + (m5sq*(2*m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + 3*m5sq))*B0fin(0,0,m5sq,mudim))/((m2sq - m3sq)*(4*m3sq*m4sq - (m3sq + m4sq - m5sq)**2)*(m4sq - m5sq)*(m3**4 - 4*m3sq*m5sq)) - ((-2*m3**4*m5**4 + 8*m3sq*m5**6 + m2sq*(6*m3sq*m5**4 + 8*m5**6 - 2*m3**4*m5sq) + m2**4*(m3**4 - 2*m5**4 - 2*m3sq*m5sq))*B0fin(0,0,m5sq,mudim))/(2.*m2**4*m3**4*(m2sq - 4*m5sq)*(m3sq - 4*m5sq)*(-m4sq + m5sq)) + (m4sq*m5sq*(3*m4**4 + 3*m5**4 + 10*m4sq*m5sq - 2*m3sq*(m4sq + m5sq) + m2sq*(m3sq - 2*(m4sq + m5sq)))*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)**3*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))) + ((m2**4 - m2sq*(m4sq - 3*m5sq) + (m4sq - m5sq)*m5sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim))/(m2**2*(m2sq - m3sq)*(m2sq - 4*m5sq)*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))) + (m5sq*(2*m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + 3*m5sq))*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim))/((m2sq - m3sq)*(4*m2sq*m4sq - (m2sq + m4sq - m5sq)**2)*(m4sq - m5sq)*(m2**4 - 4*m2sq*m5sq)) + ((m3**4 - m3sq*(m4sq - 3*m5sq) + (m4sq - m5sq)*m5sq)*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim))/(m3**2*(-m2sq + m3sq)*(m3sq - 4*m5sq)*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))) - (m5sq*(2*m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + 3*m5sq))*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim))/((m2sq - m3sq)*(4*m3sq*m4sq - (m3sq + m4sq - m5sq)**2)*(m4sq - m5sq)*(m3**4 - 4*m3sq*m5sq)) + (m4sq*(m4**6 + 5*m4sq*m5**4 - 2*m5**6 + 12*m4**4*m5sq + m3sq*(-m4**4 + m5**4 - 4*m4sq*m5sq) + m2sq*(-m4**4 + m3sq*m4sq + m5**4 - 4*m4sq*m5sq))*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)**3*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))) - (m4sq*m5sq*(3*m4**4 + 3*m5**4 + 10*m4sq*m5sq - 2*m3sq*(m4sq + m5sq) + m2sq*(m3sq - 2*(m4sq + m5sq)))*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)**3*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))) + (m5**4*(m2**4 + m3**4 + m2sq*(m3sq - 4*m5sq) - 4*m3sq*m5sq)*B0fin(0,0,m5sq,mudim)**2)/(m2**4*m3**4*(m2sq - 4*m5sq)*(m3sq - 4*m5sq)*(-m4sq + m5sq)) + ((-2*m3**4*m5**4 + 8*m3sq*m5**6 + m2sq*(6*m3sq*m5**4 + 8*m5**6 - 2*m3**4*m5sq) + m2**4*(m3**4 - 2*m5**4 - 2*m3sq*m5sq))*B0fin(0,0,m5sq,mudim)**2)/(2.*m2**4*m3**4*(m2sq - 4*m5sq)*(m3sq - 4*m5sq)*(-m4sq + m5sq)) + (m4sq + m5sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim))/(m2**2*m3**2*(m4sq - m5sq)**2) + ((m2sq + m4sq - m5sq)*(m2sq + m4sq + m5sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim)))/(m2**2*(m2sq - m3sq)*(m4sq - m5sq)*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))) + ((m3sq + m4sq - m5sq)*(m3sq + m4sq + m5sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim)))/(m3**2*(-m2sq + m3sq)*(m4sq - m5sq)*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))) + (m2sq + 2*m5sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 4*m5sq*B0fin(0,0,m5sq,mudim))/(m2**2*(m2sq - m3sq)*(m2sq - 4*m5sq)*(-m4sq + m5sq)) + (m3sq + 2*m5sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 4*m5sq*B0fin(0,0,m5sq,mudim))/(m3**2*(-m2sq + m3sq)*(m3sq - 4*m5sq)*(-m4sq + m5sq)) - T134fin(m5,m4,0,mudim)/(m2**2*m3**2*(m4sq - m5sq)**2) - ((m2sq + m4sq - m5sq)*T134fin(m5,m4,m2,mudim))/(m2**2*(m2sq - m3sq)*(m4sq - m5sq)*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))) - ((m3sq + m4sq - m5sq)*T134fin(m5,m4,m3,mudim))/(m3**2*(-m2sq + m3sq)*(m4sq - m5sq)*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))) + T134fin(m5,m5,m2,mudim)/(m2**2*(m2sq - m3sq)*(m2sq - 4*m5sq)*(m4sq - m5sq)) - T134fin(m5,m5,m3,mudim)/(m3**2*(-m2sq + m3sq)*(m3sq - 4*m5sq)*(-m4sq + m5sq))
		def eval_179():
			return (2*m7sq*B0del(0,0,m2sq,mudim))/((m2sq - m3sq)*(m4sq - m7sq)*(4*m2sq*m7sq - (m2sq - m4sq + m7sq)**2)) + ((m2**4 - m4**4 + m2sq*(3*m4sq - m7sq) + m4sq*m7sq)*B0del(0,0,m2sq,mudim))/(m2**2*(m2sq - m3sq)*(m2sq - 4*m4sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) - (m4sq*(2*m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(3*m4sq + m7sq))*B0del(0,0,m2sq,mudim))/((m2sq - m3sq)*(m2**4 - 4*m2sq*m4sq)*(m4sq - m7sq)*(4*m2sq*m7sq - (m2sq - m4sq + m7sq)**2)) - (2*m7sq*B0del(0,0,m3sq,mudim))/((m2sq - m3sq)*(m4sq - m7sq)*(4*m3sq*m7sq - (m3sq - m4sq + m7sq)**2)) + ((m3**4 - m4**4 + m3sq*(3*m4sq - m7sq) + m4sq*m7sq)*B0del(0,0,m3sq,mudim))/(m3**2*(-m2sq + m3sq)*(m3sq - 4*m4sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m4sq*(2*m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(3*m4sq + m7sq))*B0del(0,0,m3sq,mudim))/((m2sq - m3sq)*(m3**4 - 4*m3sq*m4sq)*(m4sq - m7sq)*(4*m3sq*m7sq - (m3sq - m4sq + m7sq)**2)) + (2*m4**4*(m2**4 + m3**4 + m2sq*(m3sq - 4*m4sq) - 4*m3sq*m4sq)*B0del(0,0,m4sq,mudim))/(m2**4*m3**4*(m2sq - 4*m4sq)*(m3sq - 4*m4sq)*(m4sq - m7sq)) + ((-2*m3**4*m4**4 + 8*m3sq*m4**6 + m2sq*(6*m3sq*m4**4 + 8*m4**6 - 2*m3**4*m4sq) + m2**4*(m3**4 - 2*m4**4 - 2*m3sq*m4sq))*B0del(0,0,m4sq,mudim))/(2.*m2**4*m3**4*(m2sq - 4*m4sq)*(m3sq - 4*m4sq)*(m4sq - m7sq)) - (m4sq*(2*m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(3*m4sq + m7sq))*B0del(0,0,m4sq,mudim))/((m2sq - m3sq)*(m2**4 - 4*m2sq*m4sq)*(m4sq - m7sq)*(4*m2sq*m7sq - (m2sq - m4sq + m7sq)**2)) + (m4sq*(2*m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(3*m4sq + m7sq))*B0del(0,0,m4sq,mudim))/((m2sq - m3sq)*(m3**4 - 4*m3sq*m4sq)*(m4sq - m7sq)*(4*m3sq*m7sq - (m3sq - m4sq + m7sq)**2)) + (m4sq*m7sq*(3*m4**4 + 3*m7**4 + 10*m4sq*m7sq - 2*m3sq*(m4sq + m7sq) + m2sq*(m3sq - 2*(m4sq + m7sq)))*B0del(0,0,m4sq,mudim))/((m4sq - m7sq)**3*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (2*m7sq*B0del(0,0,m7sq,mudim))/((m2sq - m3sq)*(m4sq - m7sq)*(4*m2sq*m7sq - (m2sq - m4sq + m7sq)**2)) - (2*m7sq*B0del(0,0,m7sq,mudim))/((m2sq - m3sq)*(m4sq - m7sq)*(4*m3sq*m7sq - (m3sq - m4sq + m7sq)**2)) - (m7sq*(-2*m4**6 + 12*m4sq*m7**4 + m7**6 + 5*m4**4*m7sq + m3sq*(m4**4 - m7**4 - 4*m4sq*m7sq) + m2sq*(m4**4 - m7**4 + m3sq*m7sq - 4*m4sq*m7sq))*B0del(0,0,m7sq,mudim))/((m4sq - m7sq)**3*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m4sq*m7sq*(3*m4**4 + 3*m7**4 + 10*m4sq*m7sq - 2*m3sq*(m4sq + m7sq) + m2sq*(m3sq - 2*(m4sq + m7sq)))*B0del(0,0,m7sq,mudim))/((m4sq - m7sq)**3*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (2*m7sq*B0fin(0,0,m2sq,mudim))/((m2sq - m3sq)*(m4sq - m7sq)*(4*m2sq*m7sq - (m2sq - m4sq + m7sq)**2)) - ((m2**4 - m4**4 + m2sq*(3*m4sq - m7sq) + m4sq*m7sq)*B0fin(0,0,m2sq,mudim))/(m2**2*(m2sq - m3sq)*(m2sq - 4*m4sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) + (m4sq*(2*m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(3*m4sq + m7sq))*B0fin(0,0,m2sq,mudim))/((m2sq - m3sq)*(m2**4 - 4*m2sq*m4sq)*(m4sq - m7sq)*(4*m2sq*m7sq - (m2sq - m4sq + m7sq)**2)) + (2*m7sq*B0fin(0,0,m3sq,mudim))/((m2sq - m3sq)*(m4sq - m7sq)*(4*m3sq*m7sq - (m3sq - m4sq + m7sq)**2)) - ((m3**4 - m4**4 + m3sq*(3*m4sq - m7sq) + m4sq*m7sq)*B0fin(0,0,m3sq,mudim))/(m3**2*(-m2sq + m3sq)*(m3sq - 4*m4sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (m4sq*(2*m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(3*m4sq + m7sq))*B0fin(0,0,m3sq,mudim))/((m2sq - m3sq)*(m3**4 - 4*m3sq*m4sq)*(m4sq - m7sq)*(4*m3sq*m7sq - (m3sq - m4sq + m7sq)**2)) + ((-2*m3**4*m4**4 + 8*m3sq*m4**6 + m2sq*(6*m3sq*m4**4 + 8*m4**6 - 2*m3**4*m4sq) + m2**4*(m3**4 - 2*m4**4 - 2*m3sq*m4sq))*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/(2.*m2**4*m3**4*(m2sq - 4*m4sq)*(m3sq - 4*m4sq)*(m4sq - m7sq)) + ((m2**4 - m4**4 + m2sq*(3*m4sq - m7sq) + m4sq*m7sq)*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/(m2**2*(m2sq - m3sq)*(m2sq - 4*m4sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) + ((m3**4 - m4**4 + m3sq*(3*m4sq - m7sq) + m4sq*m7sq)*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/(m3**2*(-m2sq + m3sq)*(m3sq - 4*m4sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (m7sq*(-2*m4**6 + 12*m4sq*m7**4 + m7**6 + 5*m4**4*m7sq + m3sq*(m4**4 - m7**4 - 4*m4sq*m7sq) + m2sq*(m4**4 - m7**4 + m3sq*m7sq - 4*m4sq*m7sq))*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/((m4sq - m7sq)**3*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (2*m4**4*(m2**4 + m3**4 + m2sq*(m3sq - 4*m4sq) - 4*m3sq*m4sq)*B0fin(0,0,m4sq,mudim))/(m2**4*m3**4*(m2sq - 4*m4sq)*(m3sq - 4*m4sq)*(m4sq - m7sq)) - ((-2*m3**4*m4**4 + 8*m3sq*m4**6 + m2sq*(6*m3sq*m4**4 + 8*m4**6 - 2*m3**4*m4sq) + m2**4*(m3**4 - 2*m4**4 - 2*m3sq*m4sq))*B0fin(0,0,m4sq,mudim))/(2.*m2**4*m3**4*(m2sq - 4*m4sq)*(m3sq - 4*m4sq)*(m4sq - m7sq)) + (m4sq*(2*m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(3*m4sq + m7sq))*B0fin(0,0,m4sq,mudim))/((m2sq - m3sq)*(m2**4 - 4*m2sq*m4sq)*(m4sq - m7sq)*(4*m2sq*m7sq - (m2sq - m4sq + m7sq)**2)) - (m4sq*(2*m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(3*m4sq + m7sq))*B0fin(0,0,m4sq,mudim))/((m2sq - m3sq)*(m3**4 - 4*m3sq*m4sq)*(m4sq - m7sq)*(4*m3sq*m7sq - (m3sq - m4sq + m7sq)**2)) - (m4sq*m7sq*(3*m4**4 + 3*m7**4 + 10*m4sq*m7sq - 2*m3sq*(m4sq + m7sq) + m2sq*(m3sq - 2*(m4sq + m7sq)))*B0fin(0,0,m4sq,mudim))/((m4sq - m7sq)**3*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + ((m2**4 - m4**4 + m2sq*(3*m4sq - m7sq) + m4sq*m7sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/(m2**2*(m2sq - m3sq)*(m2sq - 4*m4sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) - (m4sq*(2*m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(3*m4sq + m7sq))*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m2sq - m3sq)*(m2**4 - 4*m2sq*m4sq)*(m4sq - m7sq)*(4*m2sq*m7sq - (m2sq - m4sq + m7sq)**2)) + ((m3**4 - m4**4 + m3sq*(3*m4sq - m7sq) + m4sq*m7sq)*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim))/(m3**2*(-m2sq + m3sq)*(m3sq - 4*m4sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m4sq*(2*m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(3*m4sq + m7sq))*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim))/((m2sq - m3sq)*(m3**4 - 4*m3sq*m4sq)*(m4sq - m7sq)*(4*m3sq*m7sq - (m3sq - m4sq + m7sq)**2)) + (m4**4*(m2**4 + m3**4 + m2sq*(m3sq - 4*m4sq) - 4*m3sq*m4sq)*B0fin(0,0,m4sq,mudim)**2)/(m2**4*m3**4*(m2sq - 4*m4sq)*(m3sq - 4*m4sq)*(m4sq - m7sq)) + ((-2*m3**4*m4**4 + 8*m3sq*m4**6 + m2sq*(6*m3sq*m4**4 + 8*m4**6 - 2*m3**4*m4sq) + m2**4*(m3**4 - 2*m4**4 - 2*m3sq*m4sq))*B0fin(0,0,m4sq,mudim)**2)/(2.*m2**4*m3**4*(m2sq - 4*m4sq)*(m3sq - 4*m4sq)*(m4sq - m7sq)) + (m2sq + 2*m4sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 4*m4sq*B0fin(0,0,m4sq,mudim))/(m2**2*(m2sq - m3sq)*(m2sq - 4*m4sq)*(m4sq - m7sq)) + (m3sq + 2*m4sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 4*m4sq*B0fin(0,0,m4sq,mudim))/(m3**2*(-m2sq + m3sq)*(m3sq - 4*m4sq)*(m4sq - m7sq)) - (2*m7sq*B0fin(0,0,m7sq,mudim))/((m2sq - m3sq)*(m4sq - m7sq)*(4*m2sq*m7sq - (m2sq - m4sq + m7sq)**2)) + (2*m7sq*B0fin(0,0,m7sq,mudim))/((m2sq - m3sq)*(m4sq - m7sq)*(4*m3sq*m7sq - (m3sq - m4sq + m7sq)**2)) + (m7sq*(-2*m4**6 + 12*m4sq*m7**4 + m7**6 + 5*m4**4*m7sq + m3sq*(m4**4 - m7**4 - 4*m4sq*m7sq) + m2sq*(m4**4 - m7**4 + m3sq*m7sq - 4*m4sq*m7sq))*B0fin(0,0,m7sq,mudim))/((m4sq - m7sq)**3*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (m4sq*m7sq*(3*m4**4 + 3*m7**4 + 10*m4sq*m7sq - 2*m3sq*(m4sq + m7sq) + m2sq*(m3sq - 2*(m4sq + m7sq)))*B0fin(0,0,m7sq,mudim))/((m4sq - m7sq)**3*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (2*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2sq - m3sq)*(m4sq - m7sq)*(4*m2sq*m7sq - (m2sq - m4sq + m7sq)**2)) - (2*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim))/((m2sq - m3sq)*(m4sq - m7sq)*(4*m3sq*m7sq - (m3sq - m4sq + m7sq)**2)) - (m7sq*(-2*m4**6 + 12*m4sq*m7**4 + m7**6 + 5*m4**4*m7sq + m3sq*(m4**4 - m7**4 - 4*m4sq*m7sq) + m2sq*(m4**4 - m7**4 + m3sq*m7sq - 4*m4sq*m7sq))*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m4sq - m7sq)**3*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m4sq*m7sq*(3*m4**4 + 3*m7**4 + 10*m4sq*m7sq - 2*m3sq*(m4sq + m7sq) + m2sq*(m3sq - 2*(m4sq + m7sq)))*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m4sq - m7sq)**3*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m4sq + m7sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim))/(m2**2*m3**2*(m4sq - m7sq)**2) - ((m2sq - m4sq + m7sq)*(m2sq + m4sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m2**2*(m2sq - m3sq)*(m4sq - m7sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) - ((m3sq - m4sq + m7sq)*(m3sq + m4sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/(m3**2*(-m2sq + m3sq)*(m4sq - m7sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - T134fin(m4,m4,m2,mudim)/((m2sq - m3sq)*(m2**4 - 4*m2sq*m4sq)*(m4sq - m7sq)) - T134fin(m4,m4,m3,mudim)/(m3**2*(-m2sq + m3sq)*(m3sq - 4*m4sq)*(m4sq - m7sq)) - T134fin(m7,m4,0,mudim)/(m2**2*m3**2*(m4sq - m7sq)**2) + ((m2sq - m4sq + m7sq)*T134fin(m7,m4,m2,mudim))/(m2**2*(m2sq - m3sq)*(m4sq - m7sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) + ((m3sq - m4sq + m7sq)*T134fin(m7,m4,m3,mudim))/(m3**2*(-m2sq + m3sq)*(m4sq - m7sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)))
		def eval_180():
			return (2*m5sq*B0del(0,0,m2sq,mudim))/((m2sq - m3sq)*(m4sq - m5sq)*(4*m2sq*m5sq - (m2sq - m4sq + m5sq)**2)) + ((m2**4 - m4**4 + m2sq*(3*m4sq - m5sq) + m4sq*m5sq)*B0del(0,0,m2sq,mudim))/(m2**2*(m2sq - m3sq)*(m2sq - 4*m4sq)*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))) - (m4sq*(2*m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(3*m4sq + m5sq))*B0del(0,0,m2sq,mudim))/((m2sq - m3sq)*(m2**4 - 4*m2sq*m4sq)*(m4sq - m5sq)*(4*m2sq*m5sq - (m2sq - m4sq + m5sq)**2)) - (2*m5sq*B0del(0,0,m3sq,mudim))/((m2sq - m3sq)*(m4sq - m5sq)*(4*m3sq*m5sq - (m3sq - m4sq + m5sq)**2)) + ((m3**4 - m4**4 + m3sq*(3*m4sq - m5sq) + m4sq*m5sq)*B0del(0,0,m3sq,mudim))/(m3**2*(-m2sq + m3sq)*(m3sq - 4*m4sq)*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))) + (m4sq*(2*m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(3*m4sq + m5sq))*B0del(0,0,m3sq,mudim))/((m2sq - m3sq)*(m3**4 - 4*m3sq*m4sq)*(m4sq - m5sq)*(4*m3sq*m5sq - (m3sq - m4sq + m5sq)**2)) + (2*m4**4*(m2**4 + m3**4 + m2sq*(m3sq - 4*m4sq) - 4*m3sq*m4sq)*B0del(0,0,m4sq,mudim))/(m2**4*m3**4*(m2sq - 4*m4sq)*(m3sq - 4*m4sq)*(m4sq - m5sq)) + ((-2*m3**4*m4**4 + 8*m3sq*m4**6 + m2sq*(6*m3sq*m4**4 + 8*m4**6 - 2*m3**4*m4sq) + m2**4*(m3**4 - 2*m4**4 - 2*m3sq*m4sq))*B0del(0,0,m4sq,mudim))/(2.*m2**4*m3**4*(m2sq - 4*m4sq)*(m3sq - 4*m4sq)*(m4sq - m5sq)) - (m4sq*(2*m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(3*m4sq + m5sq))*B0del(0,0,m4sq,mudim))/((m2sq - m3sq)*(m2**4 - 4*m2sq*m4sq)*(m4sq - m5sq)*(4*m2sq*m5sq - (m2sq - m4sq + m5sq)**2)) + (m4sq*(2*m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(3*m4sq + m5sq))*B0del(0,0,m4sq,mudim))/((m2sq - m3sq)*(m3**4 - 4*m3sq*m4sq)*(m4sq - m5sq)*(4*m3sq*m5sq - (m3sq - m4sq + m5sq)**2)) + (m4sq*m5sq*(3*m4**4 + 3*m5**4 + 10*m4sq*m5sq - 2*m3sq*(m4sq + m5sq) + m2sq*(m3sq - 2*(m4sq + m5sq)))*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)**3*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))) + (2*m5sq*B0del(0,0,m5sq,mudim))/((m2sq - m3sq)*(m4sq - m5sq)*(4*m2sq*m5sq - (m2sq - m4sq + m5sq)**2)) - (2*m5sq*B0del(0,0,m5sq,mudim))/((m2sq - m3sq)*(m4sq - m5sq)*(4*m3sq*m5sq - (m3sq - m4sq + m5sq)**2)) - (m5sq*(-2*m4**6 + 12*m4sq*m5**4 + m5**6 + 5*m4**4*m5sq + m3sq*(m4**4 - m5**4 - 4*m4sq*m5sq) + m2sq*(m4**4 - m5**4 + m3sq*m5sq - 4*m4sq*m5sq))*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)**3*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))) + (m4sq*m5sq*(3*m4**4 + 3*m5**4 + 10*m4sq*m5sq - 2*m3sq*(m4sq + m5sq) + m2sq*(m3sq - 2*(m4sq + m5sq)))*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)**3*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))) - (2*m5sq*B0fin(0,0,m2sq,mudim))/((m2sq - m3sq)*(m4sq - m5sq)*(4*m2sq*m5sq - (m2sq - m4sq + m5sq)**2)) - ((m2**4 - m4**4 + m2sq*(3*m4sq - m5sq) + m4sq*m5sq)*B0fin(0,0,m2sq,mudim))/(m2**2*(m2sq - m3sq)*(m2sq - 4*m4sq)*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))) + (m4sq*(2*m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(3*m4sq + m5sq))*B0fin(0,0,m2sq,mudim))/((m2sq - m3sq)*(m2**4 - 4*m2sq*m4sq)*(m4sq - m5sq)*(4*m2sq*m5sq - (m2sq - m4sq + m5sq)**2)) + (2*m5sq*B0fin(0,0,m3sq,mudim))/((m2sq - m3sq)*(m4sq - m5sq)*(4*m3sq*m5sq - (m3sq - m4sq + m5sq)**2)) - ((m3**4 - m4**4 + m3sq*(3*m4sq - m5sq) + m4sq*m5sq)*B0fin(0,0,m3sq,mudim))/(m3**2*(-m2sq + m3sq)*(m3sq - 4*m4sq)*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))) - (m4sq*(2*m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(3*m4sq + m5sq))*B0fin(0,0,m3sq,mudim))/((m2sq - m3sq)*(m3**4 - 4*m3sq*m4sq)*(m4sq - m5sq)*(4*m3sq*m5sq - (m3sq - m4sq + m5sq)**2)) + ((-2*m3**4*m4**4 + 8*m3sq*m4**6 + m2sq*(6*m3sq*m4**4 + 8*m4**6 - 2*m3**4*m4sq) + m2**4*(m3**4 - 2*m4**4 - 2*m3sq*m4sq))*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/(2.*m2**4*m3**4*(m2sq - 4*m4sq)*(m3sq - 4*m4sq)*(m4sq - m5sq)) + ((m2**4 - m4**4 + m2sq*(3*m4sq - m5sq) + m4sq*m5sq)*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/(m2**2*(m2sq - m3sq)*(m2sq - 4*m4sq)*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))) + ((m3**4 - m4**4 + m3sq*(3*m4sq - m5sq) + m4sq*m5sq)*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/(m3**2*(-m2sq + m3sq)*(m3sq - 4*m4sq)*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))) - (m5sq*(-2*m4**6 + 12*m4sq*m5**4 + m5**6 + 5*m4**4*m5sq + m3sq*(m4**4 - m5**4 - 4*m4sq*m5sq) + m2sq*(m4**4 - m5**4 + m3sq*m5sq - 4*m4sq*m5sq))*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/((m4sq - m5sq)**3*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))) - (2*m4**4*(m2**4 + m3**4 + m2sq*(m3sq - 4*m4sq) - 4*m3sq*m4sq)*B0fin(0,0,m4sq,mudim))/(m2**4*m3**4*(m2sq - 4*m4sq)*(m3sq - 4*m4sq)*(m4sq - m5sq)) - ((-2*m3**4*m4**4 + 8*m3sq*m4**6 + m2sq*(6*m3sq*m4**4 + 8*m4**6 - 2*m3**4*m4sq) + m2**4*(m3**4 - 2*m4**4 - 2*m3sq*m4sq))*B0fin(0,0,m4sq,mudim))/(2.*m2**4*m3**4*(m2sq - 4*m4sq)*(m3sq - 4*m4sq)*(m4sq - m5sq)) + (m4sq*(2*m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(3*m4sq + m5sq))*B0fin(0,0,m4sq,mudim))/((m2sq - m3sq)*(m2**4 - 4*m2sq*m4sq)*(m4sq - m5sq)*(4*m2sq*m5sq - (m2sq - m4sq + m5sq)**2)) - (m4sq*(2*m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(3*m4sq + m5sq))*B0fin(0,0,m4sq,mudim))/((m2sq - m3sq)*(m3**4 - 4*m3sq*m4sq)*(m4sq - m5sq)*(4*m3sq*m5sq - (m3sq - m4sq + m5sq)**2)) - (m4sq*m5sq*(3*m4**4 + 3*m5**4 + 10*m4sq*m5sq - 2*m3sq*(m4sq + m5sq) + m2sq*(m3sq - 2*(m4sq + m5sq)))*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)**3*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))) + ((m2**4 - m4**4 + m2sq*(3*m4sq - m5sq) + m4sq*m5sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/(m2**2*(m2sq - m3sq)*(m2sq - 4*m4sq)*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))) - (m4sq*(2*m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(3*m4sq + m5sq))*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m2sq - m3sq)*(m2**4 - 4*m2sq*m4sq)*(m4sq - m5sq)*(4*m2sq*m5sq - (m2sq - m4sq + m5sq)**2)) + ((m3**4 - m4**4 + m3sq*(3*m4sq - m5sq) + m4sq*m5sq)*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim))/(m3**2*(-m2sq + m3sq)*(m3sq - 4*m4sq)*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))) + (m4sq*(2*m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(3*m4sq + m5sq))*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim))/((m2sq - m3sq)*(m3**4 - 4*m3sq*m4sq)*(m4sq - m5sq)*(4*m3sq*m5sq - (m3sq - m4sq + m5sq)**2)) + (m4**4*(m2**4 + m3**4 + m2sq*(m3sq - 4*m4sq) - 4*m3sq*m4sq)*B0fin(0,0,m4sq,mudim)**2)/(m2**4*m3**4*(m2sq - 4*m4sq)*(m3sq - 4*m4sq)*(m4sq - m5sq)) + ((-2*m3**4*m4**4 + 8*m3sq*m4**6 + m2sq*(6*m3sq*m4**4 + 8*m4**6 - 2*m3**4*m4sq) + m2**4*(m3**4 - 2*m4**4 - 2*m3sq*m4sq))*B0fin(0,0,m4sq,mudim)**2)/(2.*m2**4*m3**4*(m2sq - 4*m4sq)*(m3sq - 4*m4sq)*(m4sq - m5sq)) + (m2sq + 2*m4sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 4*m4sq*B0fin(0,0,m4sq,mudim))/(m2**2*(m2sq - m3sq)*(m2sq - 4*m4sq)*(m4sq - m5sq)) + (m3sq + 2*m4sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 4*m4sq*B0fin(0,0,m4sq,mudim))/(m3**2*(-m2sq + m3sq)*(m3sq - 4*m4sq)*(m4sq - m5sq)) - (2*m5sq*B0fin(0,0,m5sq,mudim))/((m2sq - m3sq)*(m4sq - m5sq)*(4*m2sq*m5sq - (m2sq - m4sq + m5sq)**2)) + (2*m5sq*B0fin(0,0,m5sq,mudim))/((m2sq - m3sq)*(m4sq - m5sq)*(4*m3sq*m5sq - (m3sq - m4sq + m5sq)**2)) + (m5sq*(-2*m4**6 + 12*m4sq*m5**4 + m5**6 + 5*m4**4*m5sq + m3sq*(m4**4 - m5**4 - 4*m4sq*m5sq) + m2sq*(m4**4 - m5**4 + m3sq*m5sq - 4*m4sq*m5sq))*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)**3*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))) - (m4sq*m5sq*(3*m4**4 + 3*m5**4 + 10*m4sq*m5sq - 2*m3sq*(m4sq + m5sq) + m2sq*(m3sq - 2*(m4sq + m5sq)))*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)**3*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))) + (2*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim))/((m2sq - m3sq)*(m4sq - m5sq)*(4*m2sq*m5sq - (m2sq - m4sq + m5sq)**2)) - (2*m5sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim))/((m2sq - m3sq)*(m4sq - m5sq)*(4*m3sq*m5sq - (m3sq - m4sq + m5sq)**2)) - (m5sq*(-2*m4**6 + 12*m4sq*m5**4 + m5**6 + 5*m4**4*m5sq + m3sq*(m4**4 - m5**4 - 4*m4sq*m5sq) + m2sq*(m4**4 - m5**4 + m3sq*m5sq - 4*m4sq*m5sq))*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)**3*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))) + (m4sq*m5sq*(3*m4**4 + 3*m5**4 + 10*m4sq*m5sq - 2*m3sq*(m4sq + m5sq) + m2sq*(m3sq - 2*(m4sq + m5sq)))*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)**3*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))) + (m4sq + m5sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim))/(m2**2*m3**2*(m4sq - m5sq)**2) - ((m2sq - m4sq + m5sq)*(m2sq + m4sq + m5sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim)))/(m2**2*(m2sq - m3sq)*(m4sq - m5sq)*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))) - ((m3sq - m4sq + m5sq)*(m3sq + m4sq + m5sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim)))/(m3**2*(-m2sq + m3sq)*(m4sq - m5sq)*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq))) - T134fin(m4,m4,m2,mudim)/((m2sq - m3sq)*(m2**4 - 4*m2sq*m4sq)*(m4sq - m5sq)) - T134fin(m4,m4,m3,mudim)/(m3**2*(-m2sq + m3sq)*(m3sq - 4*m4sq)*(m4sq - m5sq)) - T134fin(m5,m4,0,mudim)/(m2**2*m3**2*(m4sq - m5sq)**2) + ((m2sq - m4sq + m5sq)*T134fin(m5,m4,m2,mudim))/(m2**2*(m2sq - m3sq)*(m4sq - m5sq)*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))) + ((m3sq - m4sq + m5sq)*T134fin(m5,m4,m3,mudim))/(m3**2*(-m2sq + m3sq)*(m4sq - m5sq)*(m3**4 + (m4sq - m5sq)**2 - 2*m3sq*(m4sq + m5sq)))
		def eval_181():
			return (2*m1sq*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))) + (m1sq*(m1**4 - m3**4 + m1sq*(4*m3sq - m7sq))*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)**3*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))) + (m1sq*m3sq*(-2*m1sq - 2*m3sq + m7sq)*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)**3*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))) - (2*m2sq*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m3sq - m7sq)**2 - 2*m2sq*(m3sq + m7sq))) - (m2sq*(m2**4 - m3**4 + m2sq*(4*m3sq - m7sq))*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)**3*(m2**4 + (m3sq - m7sq)**2 - 2*m2sq*(m3sq + m7sq))) + (m2sq*m3sq*(2*m2sq + 2*m3sq - m7sq)*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)**3*(m2**4 + (m3sq - m7sq)**2 - 2*m2sq*(m3sq + m7sq))) + (2*m3**4*B0del(0,0,m3sq,mudim))/((-m1sq + m3sq)*(-m2sq + m3sq)*m7**4*(4*m3sq - m7sq)) + ((2*m3**4 - m7**4 + 2*m3sq*m7sq)*B0del(0,0,m3sq,mudim))/(2.*(m1sq - m3sq)*(-m2sq + m3sq)*m7**4*(4*m3sq - m7sq)) + (m1sq*m3sq*(-2*m1sq - 2*m3sq + m7sq)*B0del(0,0,m3sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)**3*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))) + (m2sq*m3sq*(2*m2sq + 2*m3sq - m7sq)*B0del(0,0,m3sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)**3*(m2**4 + (m3sq - m7sq)**2 - 2*m2sq*(m3sq + m7sq))) + (m3sq*(1/((m1sq - m3sq)*(-m2sq + m3sq)*(4*m3sq - m7sq)) + (m7sq*(1/((m1sq - m3sq)*(4*m1sq*m7sq - (m1sq - m3sq + m7sq)**2)) + 1/((m2sq - m3sq)*(m2**4 + (m3sq - m7sq)**2 - 2*m2sq*(m3sq + m7sq)))))/(m1sq - m2sq))*B0del(0,0,m3sq,mudim))/m7**2 + (2*m1sq*B0del(0,0,m7sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))) - (2*m2sq*B0del(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m3sq - m7sq)**2 - 2*m2sq*(m3sq + m7sq))) + ((-m3**6 + 11*m3sq*m7**4 + m7**6 + m3**4*m7sq + m2sq*(m3**4 - m7**4 - 3*m3sq*m7sq) + m1sq*(m3**4 - m7**4 - 3*m3sq*m7sq + m2sq*(-m3sq + m7sq)))*B0del(0,0,m7sq,mudim))/(m7**2*(-4*m3sq + m7sq)*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))*(m2**4 + (m3sq - m7sq)**2 - 2*m2sq*(m3sq + m7sq))) + (m3sq*(1/((m1sq - m3sq)*(-m2sq + m3sq)*(4*m3sq - m7sq)) + (m7sq*(1/((m1sq - m3sq)*(4*m1sq*m7sq - (m1sq - m3sq + m7sq)**2)) + 1/((m2sq - m3sq)*(m2**4 + (m3sq - m7sq)**2 - 2*m2sq*(m3sq + m7sq)))))/(m1sq - m2sq))*B0del(0,0,m7sq,mudim))/m7**2 - (2*m1sq*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))) - (m1sq*(m1**4 - m3**4 + m1sq*(4*m3sq - m7sq))*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)**3*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))) + (m1sq*m3sq*(2*m1sq + 2*m3sq - m7sq)*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)**3*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))) + (2*m2sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m3sq - m7sq)**2 - 2*m2sq*(m3sq + m7sq))) + (m2sq*(m2**4 - m3**4 + m2sq*(4*m3sq - m7sq))*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)**3*(m2**4 + (m3sq - m7sq)**2 - 2*m2sq*(m3sq + m7sq))) + (m2sq*m3sq*(-2*m2sq - 2*m3sq + m7sq)*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)**3*(m2**4 + (m3sq - m7sq)**2 - 2*m2sq*(m3sq + m7sq))) + ((2*m3**4 - m7**4 + 2*m3sq*m7sq)*(B0del(0,0,m3sq,mudim) - B0fin(0,0,m3sq,mudim)))/(2.*(m1sq - m3sq)*(-m2sq + m3sq)*m7**4*(4*m3sq - m7sq)) + (m1sq*(m1**4 - m3**4 + m1sq*(4*m3sq - m7sq))*(B0del(0,0,m3sq,mudim) - B0fin(0,0,m3sq,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)**3*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))) - (m2sq*(m2**4 - m3**4 + m2sq*(4*m3sq - m7sq))*(B0del(0,0,m3sq,mudim) - B0fin(0,0,m3sq,mudim)))/((m1sq - m2sq)*(m2sq - m3sq)**3*(m2**4 + (m3sq - m7sq)**2 - 2*m2sq*(m3sq + m7sq))) + ((-m3**6 + 11*m3sq*m7**4 + m7**6 + m3**4*m7sq + m2sq*(m3**4 - m7**4 - 3*m3sq*m7sq) + m1sq*(m3**4 - m7**4 - 3*m3sq*m7sq + m2sq*(-m3sq + m7sq)))*(B0del(0,0,m3sq,mudim) - B0fin(0,0,m3sq,mudim)))/(m7**2*(-4*m3sq + m7sq)*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))*(m2**4 + (m3sq - m7sq)**2 - 2*m2sq*(m3sq + m7sq))) + (2*m3**4*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*m7**4*(4*m3sq - m7sq)) + ((2*m3**4 - m7**4 + 2*m3sq*m7sq)*B0fin(0,0,m3sq,mudim))/(2.*(-m1sq + m3sq)*(-m2sq + m3sq)*m7**4*(4*m3sq - m7sq)) + (m1sq*m3sq*(2*m1sq + 2*m3sq - m7sq)*B0fin(0,0,m3sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)**3*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))) + (m2sq*m3sq*(-2*m2sq - 2*m3sq + m7sq)*B0fin(0,0,m3sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)**3*(m2**4 + (m3sq - m7sq)**2 - 2*m2sq*(m3sq + m7sq))) - (m3sq*(1/((m1sq - m3sq)*(-m2sq + m3sq)*(4*m3sq - m7sq)) + (m7sq*(1/((m1sq - m3sq)*(4*m1sq*m7sq - (m1sq - m3sq + m7sq)**2)) + 1/((m2sq - m3sq)*(m2**4 + (m3sq - m7sq)**2 - 2*m2sq*(m3sq + m7sq)))))/(m1sq - m2sq))*B0fin(0,0,m3sq,mudim))/m7**2 + (m1sq*(m1**4 - m3**4 + m1sq*(4*m3sq - m7sq))*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)**3*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))) + (m1sq*m3sq*(-2*m1sq - 2*m3sq + m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)**3*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))) - (m2sq*(m2**4 - m3**4 + m2sq*(4*m3sq - m7sq))*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)**3*(m2**4 + (m3sq - m7sq)**2 - 2*m2sq*(m3sq + m7sq))) + (m2sq*m3sq*(2*m2sq + 2*m3sq - m7sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)**3*(m2**4 + (m3sq - m7sq)**2 - 2*m2sq*(m3sq + m7sq))) + (m3**4*B0fin(0,0,m3sq,mudim)**2)/((-m1sq + m3sq)*(-m2sq + m3sq)*m7**4*(4*m3sq - m7sq)) + ((2*m3**4 - m7**4 + 2*m3sq*m7sq)*B0fin(0,0,m3sq,mudim)**2)/(2.*(m1sq - m3sq)*(-m2sq + m3sq)*m7**4*(4*m3sq - m7sq)) - (2*((m1sq + m3sq)/2. + m1sq*B0fin(0,0,m1sq,mudim) + m3sq*B0fin(0,0,m3sq,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)**2*m7**2) + (m2sq + m3sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)**2*m7**2) - (2*m1sq*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))) + (2*m2sq*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m3sq - m7sq)**2 - 2*m2sq*(m3sq + m7sq))) + ((m3**6 - 11*m3sq*m7**4 - m7**6 - m3**4*m7sq + m2sq*(-m3**4 + m7**4 + 3*m3sq*m7sq) + m1sq*(-m3**4 + m7**4 + m2sq*(m3sq - m7sq) + 3*m3sq*m7sq))*B0fin(0,0,m7sq,mudim))/(m7**2*(-4*m3sq + m7sq)*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))*(m2**4 + (m3sq - m7sq)**2 - 2*m2sq*(m3sq + m7sq))) - (m3sq*(1/((m1sq - m3sq)*(-m2sq + m3sq)*(4*m3sq - m7sq)) + (m7sq*(1/((m1sq - m3sq)*(4*m1sq*m7sq - (m1sq - m3sq + m7sq)**2)) + 1/((m2sq - m3sq)*(m2**4 + (m3sq - m7sq)**2 - 2*m2sq*(m3sq + m7sq)))))/(m1sq - m2sq))*B0fin(0,0,m7sq,mudim))/m7**2 + (2*m1sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))) - (2*m2sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m3sq - m7sq)**2 - 2*m2sq*(m3sq + m7sq))) + ((-m3**6 + 11*m3sq*m7**4 + m7**6 + m3**4*m7sq + m2sq*(m3**4 - m7**4 - 3*m3sq*m7sq) + m1sq*(m3**4 - m7**4 - 3*m3sq*m7sq + m2sq*(-m3sq + m7sq)))*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim))/(m7**2*(-4*m3sq + m7sq)*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))*(m2**4 + (m3sq - m7sq)**2 - 2*m2sq*(m3sq + m7sq))) + (m3sq*(1/((m1sq - m3sq)*(-m2sq + m3sq)*(4*m3sq - m7sq)) + (m7sq*(1/((m1sq - m3sq)*(4*m1sq*m7sq - (m1sq - m3sq + m7sq)**2)) + 1/((m2sq - m3sq)*(m2**4 + (m3sq - m7sq)**2 - 2*m2sq*(m3sq + m7sq)))))/(m1sq - m2sq))*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim))/m7**2 + ((m1sq - m3sq + m7sq)*(m1sq + m3sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)*m7**2*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))) - ((m2sq - m3sq + m7sq)*(m2sq + m3sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)*(m2sq - m3sq)*m7**2*(m2**4 + (m3sq - m7sq)**2 - 2*m2sq*(m3sq + m7sq))) + (2*m3sq + m7sq + 4*m3sq*B0fin(0,0,m3sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*m7**2*(4*m3sq - m7sq)) + T134fin(m3,m1,0,mudim)/((m1sq - m2sq)*(m1sq - m3sq)**2*m7**2) - T134fin(m3,m2,0,mudim)/((m1sq - m2sq)*(m2sq - m3sq)**2*m7**2) - ((m1sq - m3sq + m7sq)*T134fin(m7,m3,m1,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*m7**2*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))) + ((m2sq - m3sq + m7sq)*T134fin(m7,m3,m2,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*m7**2*(m2**4 + (m3sq - m7sq)**2 - 2*m2sq*(m3sq + m7sq))) - T134fin(m7,m3,m3,mudim)/((m1sq - m3sq)*(-m2sq + m3sq)*m7**2*(4*m3sq - m7sq))
		def eval_182():
			return (2*m1sq*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) + (m1sq*(m1**4 - m3**4 + m1sq*(4*m3sq - m5sq))*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)**3*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) + (m1sq*m3sq*(-2*m1sq - 2*m3sq + m5sq)*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)**3*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) - (2*m2sq*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) - (m2sq*(m2**4 - m3**4 + m2sq*(4*m3sq - m5sq))*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)**3*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) + (m2sq*m3sq*(2*m2sq + 2*m3sq - m5sq)*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)**3*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) + (2*m3**4*B0del(0,0,m3sq,mudim))/((-m1sq + m3sq)*(-m2sq + m3sq)*m5**4*(4*m3sq - m5sq)) + ((2*m3**4 - m5**4 + 2*m3sq*m5sq)*B0del(0,0,m3sq,mudim))/(2.*(m1sq - m3sq)*(-m2sq + m3sq)*m5**4*(4*m3sq - m5sq)) + (m1sq*m3sq*(-2*m1sq - 2*m3sq + m5sq)*B0del(0,0,m3sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)**3*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) + (m2sq*m3sq*(2*m2sq + 2*m3sq - m5sq)*B0del(0,0,m3sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)**3*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) + (m3sq*(1/((m1sq - m3sq)*(-m2sq + m3sq)*(4*m3sq - m5sq)) + (m5sq*(1/((m1sq - m3sq)*(4*m1sq*m5sq - (m1sq - m3sq + m5sq)**2)) + 1/((m2sq - m3sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq)))))/(m1sq - m2sq))*B0del(0,0,m3sq,mudim))/m5**2 + (2*m1sq*B0del(0,0,m5sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) - (2*m2sq*B0del(0,0,m5sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) + ((-m3**6 + 11*m3sq*m5**4 + m5**6 + m3**4*m5sq + m2sq*(m3**4 - m5**4 - 3*m3sq*m5sq) + m1sq*(m3**4 - m5**4 - 3*m3sq*m5sq + m2sq*(-m3sq + m5sq)))*B0del(0,0,m5sq,mudim))/(m5**2*(-4*m3sq + m5sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) + (m3sq*(1/((m1sq - m3sq)*(-m2sq + m3sq)*(4*m3sq - m5sq)) + (m5sq*(1/((m1sq - m3sq)*(4*m1sq*m5sq - (m1sq - m3sq + m5sq)**2)) + 1/((m2sq - m3sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq)))))/(m1sq - m2sq))*B0del(0,0,m5sq,mudim))/m5**2 - (2*m1sq*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) - (m1sq*(m1**4 - m3**4 + m1sq*(4*m3sq - m5sq))*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)**3*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) + (m1sq*m3sq*(2*m1sq + 2*m3sq - m5sq)*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)**3*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) + (2*m2sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) + (m2sq*(m2**4 - m3**4 + m2sq*(4*m3sq - m5sq))*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)**3*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) + (m2sq*m3sq*(-2*m2sq - 2*m3sq + m5sq)*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)**3*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) + ((2*m3**4 - m5**4 + 2*m3sq*m5sq)*(B0del(0,0,m3sq,mudim) - B0fin(0,0,m3sq,mudim)))/(2.*(m1sq - m3sq)*(-m2sq + m3sq)*m5**4*(4*m3sq - m5sq)) + (m1sq*(m1**4 - m3**4 + m1sq*(4*m3sq - m5sq))*(B0del(0,0,m3sq,mudim) - B0fin(0,0,m3sq,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)**3*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) - (m2sq*(m2**4 - m3**4 + m2sq*(4*m3sq - m5sq))*(B0del(0,0,m3sq,mudim) - B0fin(0,0,m3sq,mudim)))/((m1sq - m2sq)*(m2sq - m3sq)**3*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) + ((-m3**6 + 11*m3sq*m5**4 + m5**6 + m3**4*m5sq + m2sq*(m3**4 - m5**4 - 3*m3sq*m5sq) + m1sq*(m3**4 - m5**4 - 3*m3sq*m5sq + m2sq*(-m3sq + m5sq)))*(B0del(0,0,m3sq,mudim) - B0fin(0,0,m3sq,mudim)))/(m5**2*(-4*m3sq + m5sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) + (2*m3**4*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*m5**4*(4*m3sq - m5sq)) + ((2*m3**4 - m5**4 + 2*m3sq*m5sq)*B0fin(0,0,m3sq,mudim))/(2.*(-m1sq + m3sq)*(-m2sq + m3sq)*m5**4*(4*m3sq - m5sq)) + (m1sq*m3sq*(2*m1sq + 2*m3sq - m5sq)*B0fin(0,0,m3sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)**3*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) + (m2sq*m3sq*(-2*m2sq - 2*m3sq + m5sq)*B0fin(0,0,m3sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)**3*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) - (m3sq*(1/((m1sq - m3sq)*(-m2sq + m3sq)*(4*m3sq - m5sq)) + (m5sq*(1/((m1sq - m3sq)*(4*m1sq*m5sq - (m1sq - m3sq + m5sq)**2)) + 1/((m2sq - m3sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq)))))/(m1sq - m2sq))*B0fin(0,0,m3sq,mudim))/m5**2 + (m1sq*(m1**4 - m3**4 + m1sq*(4*m3sq - m5sq))*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)**3*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) + (m1sq*m3sq*(-2*m1sq - 2*m3sq + m5sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)**3*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) - (m2sq*(m2**4 - m3**4 + m2sq*(4*m3sq - m5sq))*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)**3*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) + (m2sq*m3sq*(2*m2sq + 2*m3sq - m5sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)**3*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) + (m3**4*B0fin(0,0,m3sq,mudim)**2)/((-m1sq + m3sq)*(-m2sq + m3sq)*m5**4*(4*m3sq - m5sq)) + ((2*m3**4 - m5**4 + 2*m3sq*m5sq)*B0fin(0,0,m3sq,mudim)**2)/(2.*(m1sq - m3sq)*(-m2sq + m3sq)*m5**4*(4*m3sq - m5sq)) - (2*((m1sq + m3sq)/2. + m1sq*B0fin(0,0,m1sq,mudim) + m3sq*B0fin(0,0,m3sq,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)**2*m5**2) + (m2sq + m3sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)**2*m5**2) - (2*m1sq*B0fin(0,0,m5sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) + (2*m2sq*B0fin(0,0,m5sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) + ((m3**6 - 11*m3sq*m5**4 - m5**6 - m3**4*m5sq + m2sq*(-m3**4 + m5**4 + 3*m3sq*m5sq) + m1sq*(-m3**4 + m5**4 + m2sq*(m3sq - m5sq) + 3*m3sq*m5sq))*B0fin(0,0,m5sq,mudim))/(m5**2*(-4*m3sq + m5sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) - (m3sq*(1/((m1sq - m3sq)*(-m2sq + m3sq)*(4*m3sq - m5sq)) + (m5sq*(1/((m1sq - m3sq)*(4*m1sq*m5sq - (m1sq - m3sq + m5sq)**2)) + 1/((m2sq - m3sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq)))))/(m1sq - m2sq))*B0fin(0,0,m5sq,mudim))/m5**2 + (2*m1sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) - (2*m2sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) + ((-m3**6 + 11*m3sq*m5**4 + m5**6 + m3**4*m5sq + m2sq*(m3**4 - m5**4 - 3*m3sq*m5sq) + m1sq*(m3**4 - m5**4 - 3*m3sq*m5sq + m2sq*(-m3sq + m5sq)))*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim))/(m5**2*(-4*m3sq + m5sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) + (m3sq*(1/((m1sq - m3sq)*(-m2sq + m3sq)*(4*m3sq - m5sq)) + (m5sq*(1/((m1sq - m3sq)*(4*m1sq*m5sq - (m1sq - m3sq + m5sq)**2)) + 1/((m2sq - m3sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq)))))/(m1sq - m2sq))*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim))/m5**2 + ((m1sq - m3sq + m5sq)*(m1sq + m3sq + m5sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)*m5**2*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) - ((m2sq - m3sq + m5sq)*(m2sq + m3sq + m5sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim)))/((m1sq - m2sq)*(m2sq - m3sq)*m5**2*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) + (2*m3sq + m5sq + 4*m3sq*B0fin(0,0,m3sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*m5**2*(4*m3sq - m5sq)) + T134fin(m3,m1,0,mudim)/((m1sq - m2sq)*(m1sq - m3sq)**2*m5**2) - T134fin(m3,m2,0,mudim)/((m1sq - m2sq)*(m2sq - m3sq)**2*m5**2) - ((m1sq - m3sq + m5sq)*T134fin(m5,m3,m1,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*m5**2*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) + ((m2sq - m3sq + m5sq)*T134fin(m5,m3,m2,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*m5**2*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) - T134fin(m5,m3,m3,mudim)/((m1sq - m3sq)*(-m2sq + m3sq)*m5**2*(4*m3sq - m5sq))
		def eval_183():
			return ((2*(m1sq - m2sq)*(m2**4 - m5**4 + m5sq*m7sq - m2sq*(3*m5sq + m7sq))*B0del(0,0,m5sq,mudim))/(m5**2*(-4*m2sq + m5sq)*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + (2*(m1sq - m2sq)*m7sq*(-m2**4 + m7**4 + 4*m2sq*m7sq - m5sq*m7sq)*B0del(0,0,m7sq,mudim))/((m2sq - m7sq)**3*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + ((m2sq*(2*m2**4 + m5**4 - 6*m2sq*m5sq) + m1sq*(-2*m2**4 + m5**4 - 2*m2sq*m5sq))/(m5**4*(-4*m2sq + m5sq)*(m2sq - m7sq)) + (2*(m1sq - m2sq)*(4*m2sq*m7**4 - m5sq*m7**4 + m7**6 - m2**4*m7sq))/((m2sq - m7sq)**3*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + (2*(m1sq - m2sq)*(m2**4 - m5**4 + m5sq*m7sq - m2sq*(3*m5sq + m7sq)))/(m5**2*(-4*m2sq + m5sq)*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))))*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)) + ((m2sq*(2*m2**4 + m5**4 - 6*m2sq*m5sq) + m1sq*(-2*m2**4 + m5**4 - 2*m2sq*m5sq))*B0del(0,0,m2sq,mudim) - 4*m2sq*(4*m2sq - m5sq)*m5sq*(2 + B0fin(0,0,m2sq,mudim)))/(m5**4*(-4*m2sq + m5sq)*(m2sq - m7sq)) + (-1 + B0fin(0,0,m2sq,mudim))*((4*m2sq*m5sq*(-4*m2sq + m5sq) + (m2sq*(2*m2**4 + m5**4 - 6*m2sq*m5sq) + m1sq*(-2*m2**4 + m5**4 - 2*m2sq*m5sq))*B0fin(0,0,m2sq,mudim))/(m5**4*(-4*m2sq + m5sq)*(m2sq - m7sq)) + (2*(m1sq - m2sq)*(m2**4 - m5**4 + m5sq*m7sq - m2sq*(3*m5sq + m7sq))*B0fin(0,0,m5sq,mudim))/(m5**2*(-4*m2sq + m5sq)*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) - (2*(m1sq - m2sq)*m7sq*(m2**4 - m7**4 - 4*m2sq*m7sq + m5sq*m7sq)*B0fin(0,0,m7sq,mudim))/((m2sq - m7sq)**3*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)))) + ((m1sq - m2sq)*(2*(2*m2**4*(m2sq - m7sq)**2*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))*B0fin(0,0,m2sq,mudim) + m2sq*(m5**4*(-4*m2sq + m5sq)*(-2*m2sq + m5sq - 2*m7sq)*m7sq - m5sq*(m2sq - m7sq)**2*(m2**4 + 2*m5**4 + m7**4 - 2*m5sq*m7sq - 2*m2sq*(3*m5sq + m7sq)))*B0fin(0,0,m2sq,mudim) + 2*m5**4*(-4*m2sq + m5sq)*(m2sq - m7sq)**2*m7sq*(B0fin(0,0,m5sq,mudim) + B0fin(0,0,m7sq,mudim)) + m2sq*(-(m5sq*(m2sq - m7sq)**2*(m2**4 + 2*m5**4 + m7**4 - 2*m5sq*m7sq - 2*m2sq*(3*m5sq + m7sq))*B0fin(0,0,m5sq,mudim)) + m5**4*(-4*m2sq + m5sq)*(-2*m2sq + m5sq - 2*m7sq)*m7sq*B0fin(0,0,m7sq,mudim))) - 2*(m2sq*(m5**4*(-4*m2sq + m5sq)*(-2*m2sq + m5sq - 2*m7sq)*m7sq - m5sq*(m2sq - m7sq)**2*(m2**4 + 2*m5**4 + m7**4 - 2*m5sq*m7sq - 2*m2sq*(3*m5sq + m7sq)))*B0del(0,0,m2sq,mudim) + m2sq*(-(m5sq*(m2sq - m7sq)**2*(m2**4 + 2*m5**4 + m7**4 - 2*m5sq*m7sq - 2*m2sq*(3*m5sq + m7sq))*B0del(0,0,m5sq,mudim)) + m5**4*(-4*m2sq + m5sq)*(-2*m2sq + m5sq - 2*m7sq)*m7sq*B0del(0,0,m7sq,mudim)) + m2**4*(m2sq - m7sq)**2*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))*(2*B0del(0,0,m2sq,mudim) + B0fin(0,0,m2sq,mudim)**2) + m2sq*B0fin(0,0,m2sq,mudim)*(-(m5sq*(m2sq - m7sq)**2*(m2**4 + 2*m5**4 + m7**4 - 2*m5sq*m7sq - 2*m2sq*(3*m5sq + m7sq))*B0fin(0,0,m5sq,mudim)) + m5**4*(-4*m2sq + m5sq)*(-2*m2sq + m5sq - 2*m7sq)*m7sq*B0fin(0,0,m7sq,mudim)) + 2*m5**4*(-4*m2sq + m5sq)*(m2sq - m7sq)**2*m7sq*(B0del(0,0,m5sq,mudim) + B0del(0,0,m7sq,mudim) + B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim)))))/(m5**4*(4*m2sq - m5sq)*(m2sq - m7sq)**3*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) - (2*T134fin(m2,m1,0,mudim))/(m5**2*(m2sq - m7sq)) + (2*T134fin(m5,m2,m1,mudim))/(m5**2*(m2sq - m7sq)) + (2*((m1sq - m2sq)*(2*m2sq + m5sq + 4*m2sq*B0fin(0,0,m2sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim)) + (-m1sq - 3*m2sq + m5sq)*T134fin(m5,m2,m2,mudim)))/(m5**2*(4*m2sq - m5sq)*(m2sq - m7sq)) + (2*T134fin(m7,m1,0,mudim))/(m5**2*(m2sq - m7sq)) + (2*((m1sq - m2sq)*(m2sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)) + (-m1sq + m7sq)*T134fin(m7,m2,0,mudim)))/(m5**2*(m2sq - m7sq)**2) - (2*T134fin(m7,m5,m1,mudim))/(m5**2*(m2sq - m7sq)) + (2*(-((m1sq - m2sq)*(m2sq - m5sq - m7sq)*(m2sq + m5sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim))) + (m1sq*(m2sq - m5sq - m7sq) + (m5sq - m7sq)**2 - m2sq*(m5sq + m7sq))*T134fin(m7,m5,m2,mudim)))/(m5**2*(m2sq - m7sq)*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))))/(2.*(m1sq - m2sq)**2)
		def eval_184():
			return ((2*(m1sq - m2sq)*m5sq*(-m2**4 + m5**4 + 4*m2sq*m5sq - m5sq*m7sq)*B0del(0,0,m5sq,mudim))/((m2sq - m5sq)**3*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + (2*(m1sq - m2sq)*(m2**4 + (m5sq - m7sq)*m7sq - m2sq*(m5sq + 3*m7sq))*B0del(0,0,m7sq,mudim))/(m7**2*(-4*m2sq + m7sq)*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + ((2*(m1sq - m2sq)*(4*m2sq*m5**4 + m5**6 - m2**4*m5sq - m5**4*m7sq))/((m2sq - m5sq)**3*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + (2*(m1sq - m2sq)*(m2**4 + (m5sq - m7sq)*m7sq - m2sq*(m5sq + 3*m7sq)))/(m7**2*(-4*m2sq + m7sq)*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + (-(m2sq*(2*m2**4 + m7**4 - 6*m2sq*m7sq)) + m1sq*(2*m2**4 - m7**4 + 2*m2sq*m7sq))/((m2sq - m5sq)*m7**4*(4*m2sq - m7sq)))*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)) + ((-(m2sq*(2*m2**4 + m7**4 - 6*m2sq*m7sq)) + m1sq*(2*m2**4 - m7**4 + 2*m2sq*m7sq))*B0del(0,0,m2sq,mudim) + 4*m2sq*(4*m2sq - m7sq)*m7sq*(2 + B0fin(0,0,m2sq,mudim)))/((m2sq - m5sq)*m7**4*(4*m2sq - m7sq)) + (-1 + B0fin(0,0,m2sq,mudim))*((-4*m2sq*m7**4 + 16*m2**4*m7sq + (-(m2sq*(2*m2**4 + m7**4 - 6*m2sq*m7sq)) + m1sq*(2*m2**4 - m7**4 + 2*m2sq*m7sq))*B0fin(0,0,m2sq,mudim))/((m2sq - m5sq)*m7**4*(4*m2sq - m7sq)) - (2*(m1sq - m2sq)*m5sq*(m2**4 - m5**4 - 4*m2sq*m5sq + m5sq*m7sq)*B0fin(0,0,m5sq,mudim))/((m2sq - m5sq)**3*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + (2*(m1sq - m2sq)*(m2**4 + (m5sq - m7sq)*m7sq - m2sq*(m5sq + 3*m7sq))*B0fin(0,0,m7sq,mudim))/(m7**2*(-4*m2sq + m7sq)*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq)))) + ((m1sq - m2sq)*(2*(m2sq*(2*m2**10 + 2*m5**6*m7**4 - 4*m5**4*m7**6 + m5sq*m7**8 + 2*m2sq*(m5**8 + 6*m5**4*m7**4 - m5sq*m7**6) - m5**8*m7sq - m2**8*(8*m5sq + 5*m7sq) - 2*m2**4*(4*m5**6 + 3*m5sq*m7**4 + m7**6 + m5**4*m7sq) + 4*m2**6*(3*m5**4 + 2*m7**4 + 2*m5sq*m7sq))*B0fin(0,0,m2sq,mudim) + m5sq*m7**4*(-4*m2sq + m7sq)*(2*m5**4 + m2sq*(-6*m5sq + m7sq))*B0fin(0,0,m5sq,mudim) - (m2sq - m5sq)**3*m7sq*(m2**4 + 2*m7**4 - m2sq*(m5sq + 6*m7sq))*B0fin(0,0,m7sq,mudim)) - 2*(m2sq*(m5sq*m7**4*(-4*m2sq + m7sq)*(-2*m2sq - 2*m5sq + m7sq) - (m2sq - m5sq)**2*m7sq*(m2**4 + m5**4 + 2*m7**4 - 2*m5sq*m7sq - 2*m2sq*(m5sq + 3*m7sq)))*B0del(0,0,m2sq,mudim) + m2sq*(m5sq*m7**4*(-4*m2sq + m7sq)*(-2*m2sq - 2*m5sq + m7sq)*B0del(0,0,m5sq,mudim) - (m2sq - m5sq)**2*m7sq*(m2**4 + m5**4 + 2*m7**4 - 2*m5sq*m7sq - 2*m2sq*(m5sq + 3*m7sq))*B0del(0,0,m7sq,mudim)) + m2**4*(m2sq - m5sq)**2*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))*(2*B0del(0,0,m2sq,mudim) + B0fin(0,0,m2sq,mudim)**2) + m2sq*B0fin(0,0,m2sq,mudim)*(m5sq*m7**4*(-4*m2sq + m7sq)*(-2*m2sq - 2*m5sq + m7sq)*B0fin(0,0,m5sq,mudim) - (m2sq - m5sq)**2*m7sq*(m2**4 + m5**4 + 2*m7**4 - 2*m5sq*m7sq - 2*m2sq*(m5sq + 3*m7sq))*B0fin(0,0,m7sq,mudim)) - 2*(-(m2sq*m5) + m5**3)**2*m7**4*(4*m2sq - m7sq)*(B0del(0,0,m5sq,mudim) + B0del(0,0,m7sq,mudim) + B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim)))))/((m2sq - m5sq)**3*m7**4*(4*m2sq - m7sq)*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) - (2*T134fin(m2,m1,0,mudim))/((m2sq - m5sq)*m7**2) + (2*T134fin(m5,m1,0,mudim))/((m2sq - m5sq)*m7**2) + (2*((m1sq - m2sq)*(m2sq + m5sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim)) + (-m1sq + m5sq)*T134fin(m5,m2,0,mudim)))/((m2sq - m5sq)**2*m7**2) + (2*T134fin(m7,m2,m1,mudim))/((m2sq - m5sq)*m7**2) + (2*((m1sq - m2sq)*(2*m2sq + m7sq + 4*m2sq*B0fin(0,0,m2sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)) + (-m1sq - 3*m2sq + m7sq)*T134fin(m7,m2,m2,mudim)))/((m2sq - m5sq)*m7**2*(4*m2sq - m7sq)) - (2*T134fin(m7,m5,m1,mudim))/((m2sq - m5sq)*m7**2) + (2*(-((m1sq - m2sq)*(m2sq - m5sq - m7sq)*(m2sq + m5sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim))) + (m1sq*(m2sq - m5sq - m7sq) + (m5sq - m7sq)**2 - m2sq*(m5sq + m7sq))*T134fin(m7,m5,m2,mudim)))/((m2sq - m5sq)*m7**2*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))))/(2.*(m1sq - m2sq)**2)
		def eval_185():
			return (-2*m1sq*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq*m7sq - (m1sq - m2sq + m7sq)**2)) + (m1sq*(m1**4 - m2**4 + m1sq*(4*m2sq - m7sq))*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)**3*(m1sq - m3sq)*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))) - (m1sq*m2sq*(2*m1sq + 2*m2sq - m7sq)*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)**3*(m1sq - m3sq)*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))) + (2*m2**4*B0del(0,0,m2sq,mudim))/((-m1sq + m2sq)*(m2sq - m3sq)*m7**4*(4*m2sq - m7sq)) + ((2*m2**4 - m7**4 + 2*m2sq*m7sq)*B0del(0,0,m2sq,mudim))/(2.*(m1sq - m2sq)*(m2sq - m3sq)*m7**4*(4*m2sq - m7sq)) - (m1sq*m2sq*(2*m1sq + 2*m2sq - m7sq)*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)**3*(m1sq - m3sq)*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))) + (m2sq*m3sq*(2*m2sq + 2*m3sq - m7sq)*B0del(0,0,m2sq,mudim))/((m2sq - m3sq)**3*(-m1sq + m3sq)*(m2**4 + (m3sq - m7sq)**2 - 2*m2sq*(m3sq + m7sq))) + m2sq*(1/((m1sq - m2sq)*(m2sq - m3sq)*(-m7**4 + 4*m2sq*m7sq)) + 1/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq*m7sq - (m1sq - m2sq + m7sq)**2)) + 1/((m1sq - m3sq)*(m2sq - m3sq)*(4*m3sq*m7sq - (-m2sq + m3sq + m7sq)**2)))*B0del(0,0,m2sq,mudim) + (m2sq*m3sq*(2*m2sq + 2*m3sq - m7sq)*B0del(0,0,m3sq,mudim))/((m2sq - m3sq)**3*(-m1sq + m3sq)*(m2**4 + (m3sq - m7sq)**2 - 2*m2sq*(m3sq + m7sq))) + (m3sq*(m2**4 - m3**4 - 4*m2sq*m3sq + m3sq*m7sq)*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)**3*(m2**4 + (m3sq - m7sq)**2 - 2*m2sq*(m3sq + m7sq))) - (2*m3sq*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)*(m2sq - m3sq)*(4*m3sq*m7sq - (-m2sq + m3sq + m7sq)**2)) - (2*m1sq*B0del(0,0,m7sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq*m7sq - (m1sq - m2sq + m7sq)**2)) - (2*m3sq*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)*(m2sq - m3sq)*(4*m3sq*m7sq - (-m2sq + m3sq + m7sq)**2)) + m2sq*(1/((m1sq - m2sq)*(m2sq - m3sq)*(-m7**4 + 4*m2sq*m7sq)) + 1/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq*m7sq - (m1sq - m2sq + m7sq)**2)) + 1/((m1sq - m3sq)*(m2sq - m3sq)*(4*m3sq*m7sq - (-m2sq + m3sq + m7sq)**2)))*B0del(0,0,m7sq,mudim) + ((-m2**6 - m3sq*m7**4 + m7**6 + m2**4*(m3sq + m7sq) + m2sq*(11*m7**4 - 3*m3sq*m7sq) + m1sq*(m2**4 + (m3sq - m7sq)*m7sq - m2sq*(m3sq + 3*m7sq)))*B0del(0,0,m7sq,mudim))/(m7**2*(-4*m2sq + m7sq)*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))*(m2**4 + (m3sq - m7sq)**2 - 2*m2sq*(m3sq + m7sq))) + (2*m1sq*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq*m7sq - (m1sq - m2sq + m7sq)**2)) - (m1sq*(m1**4 - m2**4 + m1sq*(4*m2sq - m7sq))*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)**3*(m1sq - m3sq)*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))) + (m1sq*m2sq*(2*m1sq + 2*m2sq - m7sq)*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)**3*(m1sq - m3sq)*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))) + ((2*m2**4 - m7**4 + 2*m2sq*m7sq)*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)))/(2.*(m1sq - m2sq)*(m2sq - m3sq)*m7**4*(4*m2sq - m7sq)) + (m1sq*(m1**4 - m2**4 + m1sq*(4*m2sq - m7sq))*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)))/((m1sq - m2sq)**3*(m1sq - m3sq)*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))) + (m3sq*(m2**4 - m3**4 - 4*m2sq*m3sq + m3sq*m7sq)*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)**3*(m2**4 + (m3sq - m7sq)**2 - 2*m2sq*(m3sq + m7sq))) + ((-m2**6 - m3sq*m7**4 + m7**6 + m2**4*(m3sq + m7sq) + m2sq*(11*m7**4 - 3*m3sq*m7sq) + m1sq*(m2**4 + (m3sq - m7sq)*m7sq - m2sq*(m3sq + 3*m7sq)))*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)))/(m7**2*(-4*m2sq + m7sq)*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))*(m2**4 + (m3sq - m7sq)**2 - 2*m2sq*(m3sq + m7sq))) + (2*m2**4*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*m7**4*(4*m2sq - m7sq)) + ((2*m2**4 - m7**4 + 2*m2sq*m7sq)*B0fin(0,0,m2sq,mudim))/(2.*(-m1sq + m2sq)*(m2sq - m3sq)*m7**4*(4*m2sq - m7sq)) + (m1sq*m2sq*(2*m1sq + 2*m2sq - m7sq)*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)**3*(m1sq - m3sq)*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))) - (m2sq*m3sq*(2*m2sq + 2*m3sq - m7sq)*B0fin(0,0,m2sq,mudim))/((m2sq - m3sq)**3*(-m1sq + m3sq)*(m2**4 + (m3sq - m7sq)**2 - 2*m2sq*(m3sq + m7sq))) + m2sq*(-(1/((m1sq - m2sq)*(m2sq - m3sq)*(-m7**4 + 4*m2sq*m7sq))) - 1/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq*m7sq - (m1sq - m2sq + m7sq)**2)) - 1/((m1sq - m3sq)*(m2sq - m3sq)*(4*m3sq*m7sq - (-m2sq + m3sq + m7sq)**2)))*B0fin(0,0,m2sq,mudim) + (m1sq*(m1**4 - m2**4 + m1sq*(4*m2sq - m7sq))*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)**3*(m1sq - m3sq)*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))) - (m1sq*m2sq*(2*m1sq + 2*m2sq - m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)**3*(m1sq - m3sq)*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))) + (m2**4*B0fin(0,0,m2sq,mudim)**2)/((-m1sq + m2sq)*(m2sq - m3sq)*m7**4*(4*m2sq - m7sq)) + ((2*m2**4 - m7**4 + 2*m2sq*m7sq)*B0fin(0,0,m2sq,mudim)**2)/(2.*(m1sq - m2sq)*(m2sq - m3sq)*m7**4*(4*m2sq - m7sq)) - (2*((m1sq + m2sq)/2. + m1sq*B0fin(0,0,m1sq,mudim) + m2sq*B0fin(0,0,m2sq,mudim)))/((m1sq - m2sq)**2*(m1sq - m3sq)*m7**2) - (m2sq*m3sq*(2*m2sq + 2*m3sq - m7sq)*B0fin(0,0,m3sq,mudim))/((m2sq - m3sq)**3*(-m1sq + m3sq)*(m2**4 + (m3sq - m7sq)**2 - 2*m2sq*(m3sq + m7sq))) + (m3sq*(-m2**4 + m3**4 + 4*m2sq*m3sq - m3sq*m7sq)*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)**3*(m2**4 + (m3sq - m7sq)**2 - 2*m2sq*(m3sq + m7sq))) + (2*m3sq*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(m2sq - m3sq)*(4*m3sq*m7sq - (-m2sq + m3sq + m7sq)**2)) + (m2sq*m3sq*(2*m2sq + 2*m3sq - m7sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim))/((m2sq - m3sq)**3*(-m1sq + m3sq)*(m2**4 + (m3sq - m7sq)**2 - 2*m2sq*(m3sq + m7sq))) + (m3sq*(m2**4 - m3**4 - 4*m2sq*m3sq + m3sq*m7sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)**3*(m2**4 + (m3sq - m7sq)**2 - 2*m2sq*(m3sq + m7sq))) + (m2sq + m3sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(m2sq - m3sq)**2*m7**2) + (2*m1sq*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq*m7sq - (m1sq - m2sq + m7sq)**2)) + (2*m3sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(m2sq - m3sq)*(4*m3sq*m7sq - (-m2sq + m3sq + m7sq)**2)) + m2sq*(-(1/((m1sq - m2sq)*(m2sq - m3sq)*(-m7**4 + 4*m2sq*m7sq))) - 1/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq*m7sq - (m1sq - m2sq + m7sq)**2)) - 1/((m1sq - m3sq)*(m2sq - m3sq)*(4*m3sq*m7sq - (-m2sq + m3sq + m7sq)**2)))*B0fin(0,0,m7sq,mudim) - ((-m2**6 - m3sq*m7**4 + m7**6 + m2**4*(m3sq + m7sq) + m2sq*(11*m7**4 - 3*m3sq*m7sq) + m1sq*(m2**4 + (m3sq - m7sq)*m7sq - m2sq*(m3sq + 3*m7sq)))*B0fin(0,0,m7sq,mudim))/(m7**2*(-4*m2sq + m7sq)*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))*(m2**4 + (m3sq - m7sq)**2 - 2*m2sq*(m3sq + m7sq))) - (2*m1sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq*m7sq - (m1sq - m2sq + m7sq)**2)) + m2sq*(1/((m1sq - m2sq)*(m2sq - m3sq)*(-m7**4 + 4*m2sq*m7sq)) + 1/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq*m7sq - (m1sq - m2sq + m7sq)**2)) + 1/((m1sq - m3sq)*(m2sq - m3sq)*(4*m3sq*m7sq - (-m2sq + m3sq + m7sq)**2)))*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim) + ((-m2**6 - m3sq*m7**4 + m7**6 + m2**4*(m3sq + m7sq) + m2sq*(11*m7**4 - 3*m3sq*m7sq) + m1sq*(m2**4 + (m3sq - m7sq)*m7sq - m2sq*(m3sq + 3*m7sq)))*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/(m7**2*(-4*m2sq + m7sq)*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))*(m2**4 + (m3sq - m7sq)**2 - 2*m2sq*(m3sq + m7sq))) - (2*m3sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(m2sq - m3sq)*(4*m3sq*m7sq - (-m2sq + m3sq + m7sq)**2)) + ((m1sq - m2sq + m7sq)*(m1sq + m2sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)*m7**2*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))) + (2*m2sq + m7sq + 4*m2sq*B0fin(0,0,m2sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*m7**2*(4*m2sq - m7sq)) - ((-m2sq + m3sq + m7sq)*(m2sq + m3sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)*m7**2*(m2**4 + (m3sq - m7sq)**2 - 2*m2sq*(m3sq + m7sq))) + T134fin(m2,m1,0,mudim)/((m1sq - m2sq)**2*(m1sq - m3sq)*m7**2) + T134fin(m3,m2,0,mudim)/((m2sq - m3sq)**2*(-m1sq + m3sq)*m7**2) - ((m1sq - m2sq + m7sq)*T134fin(m7,m2,m1,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*m7**2*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))) - T134fin(m7,m2,m2,mudim)/((m1sq - m2sq)*(m2sq - m3sq)*(-m7**4 + 4*m2sq*m7sq)) + ((-m2sq + m3sq + m7sq)*T134fin(m7,m3,m2,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*m7**2*(m2**4 + (m3sq - m7sq)**2 - 2*m2sq*(m3sq + m7sq)))
		def eval_186():
			return (-2*m1sq*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq*m5sq - (m1sq - m2sq + m5sq)**2)) + (m1sq*(m1**4 - m2**4 + m1sq*(4*m2sq - m5sq))*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)**3*(m1sq - m3sq)*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))) - (m1sq*m2sq*(2*m1sq + 2*m2sq - m5sq)*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)**3*(m1sq - m3sq)*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))) + (2*m2**4*B0del(0,0,m2sq,mudim))/((-m1sq + m2sq)*(m2sq - m3sq)*m5**4*(4*m2sq - m5sq)) + ((2*m2**4 - m5**4 + 2*m2sq*m5sq)*B0del(0,0,m2sq,mudim))/(2.*(m1sq - m2sq)*(m2sq - m3sq)*m5**4*(4*m2sq - m5sq)) - (m1sq*m2sq*(2*m1sq + 2*m2sq - m5sq)*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)**3*(m1sq - m3sq)*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))) + (m2sq*m3sq*(2*m2sq + 2*m3sq - m5sq)*B0del(0,0,m2sq,mudim))/((m2sq - m3sq)**3*(-m1sq + m3sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) + m2sq*(1/((m1sq - m2sq)*(m2sq - m3sq)*(-m5**4 + 4*m2sq*m5sq)) + 1/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq*m5sq - (m1sq - m2sq + m5sq)**2)) + 1/((m1sq - m3sq)*(m2sq - m3sq)*(4*m3sq*m5sq - (-m2sq + m3sq + m5sq)**2)))*B0del(0,0,m2sq,mudim) + (m2sq*m3sq*(2*m2sq + 2*m3sq - m5sq)*B0del(0,0,m3sq,mudim))/((m2sq - m3sq)**3*(-m1sq + m3sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) + (m3sq*(m2**4 - m3**4 - 4*m2sq*m3sq + m3sq*m5sq)*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)**3*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) - (2*m3sq*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)*(m2sq - m3sq)*(4*m3sq*m5sq - (-m2sq + m3sq + m5sq)**2)) - (2*m1sq*B0del(0,0,m5sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq*m5sq - (m1sq - m2sq + m5sq)**2)) - (2*m3sq*B0del(0,0,m5sq,mudim))/((m1sq - m3sq)*(m2sq - m3sq)*(4*m3sq*m5sq - (-m2sq + m3sq + m5sq)**2)) + m2sq*(1/((m1sq - m2sq)*(m2sq - m3sq)*(-m5**4 + 4*m2sq*m5sq)) + 1/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq*m5sq - (m1sq - m2sq + m5sq)**2)) + 1/((m1sq - m3sq)*(m2sq - m3sq)*(4*m3sq*m5sq - (-m2sq + m3sq + m5sq)**2)))*B0del(0,0,m5sq,mudim) + ((-m2**6 - m3sq*m5**4 + m5**6 + m2**4*(m3sq + m5sq) + m2sq*(11*m5**4 - 3*m3sq*m5sq) + m1sq*(m2**4 + (m3sq - m5sq)*m5sq - m2sq*(m3sq + 3*m5sq)))*B0del(0,0,m5sq,mudim))/(m5**2*(-4*m2sq + m5sq)*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) + (2*m1sq*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq*m5sq - (m1sq - m2sq + m5sq)**2)) - (m1sq*(m1**4 - m2**4 + m1sq*(4*m2sq - m5sq))*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)**3*(m1sq - m3sq)*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))) + (m1sq*m2sq*(2*m1sq + 2*m2sq - m5sq)*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)**3*(m1sq - m3sq)*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))) + ((2*m2**4 - m5**4 + 2*m2sq*m5sq)*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)))/(2.*(m1sq - m2sq)*(m2sq - m3sq)*m5**4*(4*m2sq - m5sq)) + (m1sq*(m1**4 - m2**4 + m1sq*(4*m2sq - m5sq))*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)))/((m1sq - m2sq)**3*(m1sq - m3sq)*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))) + (m3sq*(m2**4 - m3**4 - 4*m2sq*m3sq + m3sq*m5sq)*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)**3*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) + ((-m2**6 - m3sq*m5**4 + m5**6 + m2**4*(m3sq + m5sq) + m2sq*(11*m5**4 - 3*m3sq*m5sq) + m1sq*(m2**4 + (m3sq - m5sq)*m5sq - m2sq*(m3sq + 3*m5sq)))*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)))/(m5**2*(-4*m2sq + m5sq)*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) + (2*m2**4*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*m5**4*(4*m2sq - m5sq)) + ((2*m2**4 - m5**4 + 2*m2sq*m5sq)*B0fin(0,0,m2sq,mudim))/(2.*(-m1sq + m2sq)*(m2sq - m3sq)*m5**4*(4*m2sq - m5sq)) + (m1sq*m2sq*(2*m1sq + 2*m2sq - m5sq)*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)**3*(m1sq - m3sq)*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))) - (m2sq*m3sq*(2*m2sq + 2*m3sq - m5sq)*B0fin(0,0,m2sq,mudim))/((m2sq - m3sq)**3*(-m1sq + m3sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) + m2sq*(-(1/((m1sq - m2sq)*(m2sq - m3sq)*(-m5**4 + 4*m2sq*m5sq))) - 1/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq*m5sq - (m1sq - m2sq + m5sq)**2)) - 1/((m1sq - m3sq)*(m2sq - m3sq)*(4*m3sq*m5sq - (-m2sq + m3sq + m5sq)**2)))*B0fin(0,0,m2sq,mudim) + (m1sq*(m1**4 - m2**4 + m1sq*(4*m2sq - m5sq))*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)**3*(m1sq - m3sq)*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))) - (m1sq*m2sq*(2*m1sq + 2*m2sq - m5sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)**3*(m1sq - m3sq)*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))) + (m2**4*B0fin(0,0,m2sq,mudim)**2)/((-m1sq + m2sq)*(m2sq - m3sq)*m5**4*(4*m2sq - m5sq)) + ((2*m2**4 - m5**4 + 2*m2sq*m5sq)*B0fin(0,0,m2sq,mudim)**2)/(2.*(m1sq - m2sq)*(m2sq - m3sq)*m5**4*(4*m2sq - m5sq)) - (2*((m1sq + m2sq)/2. + m1sq*B0fin(0,0,m1sq,mudim) + m2sq*B0fin(0,0,m2sq,mudim)))/((m1sq - m2sq)**2*(m1sq - m3sq)*m5**2) - (m2sq*m3sq*(2*m2sq + 2*m3sq - m5sq)*B0fin(0,0,m3sq,mudim))/((m2sq - m3sq)**3*(-m1sq + m3sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) + (m3sq*(-m2**4 + m3**4 + 4*m2sq*m3sq - m3sq*m5sq)*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)**3*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) + (2*m3sq*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(m2sq - m3sq)*(4*m3sq*m5sq - (-m2sq + m3sq + m5sq)**2)) + (m2sq*m3sq*(2*m2sq + 2*m3sq - m5sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim))/((m2sq - m3sq)**3*(-m1sq + m3sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) + (m3sq*(m2**4 - m3**4 - 4*m2sq*m3sq + m3sq*m5sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)**3*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) + (m2sq + m3sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(m2sq - m3sq)**2*m5**2) + (2*m1sq*B0fin(0,0,m5sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq*m5sq - (m1sq - m2sq + m5sq)**2)) + (2*m3sq*B0fin(0,0,m5sq,mudim))/((m1sq - m3sq)*(m2sq - m3sq)*(4*m3sq*m5sq - (-m2sq + m3sq + m5sq)**2)) + m2sq*(-(1/((m1sq - m2sq)*(m2sq - m3sq)*(-m5**4 + 4*m2sq*m5sq))) - 1/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq*m5sq - (m1sq - m2sq + m5sq)**2)) - 1/((m1sq - m3sq)*(m2sq - m3sq)*(4*m3sq*m5sq - (-m2sq + m3sq + m5sq)**2)))*B0fin(0,0,m5sq,mudim) - ((-m2**6 - m3sq*m5**4 + m5**6 + m2**4*(m3sq + m5sq) + m2sq*(11*m5**4 - 3*m3sq*m5sq) + m1sq*(m2**4 + (m3sq - m5sq)*m5sq - m2sq*(m3sq + 3*m5sq)))*B0fin(0,0,m5sq,mudim))/(m5**2*(-4*m2sq + m5sq)*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) - (2*m1sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq*m5sq - (m1sq - m2sq + m5sq)**2)) + m2sq*(1/((m1sq - m2sq)*(m2sq - m3sq)*(-m5**4 + 4*m2sq*m5sq)) + 1/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq*m5sq - (m1sq - m2sq + m5sq)**2)) + 1/((m1sq - m3sq)*(m2sq - m3sq)*(4*m3sq*m5sq - (-m2sq + m3sq + m5sq)**2)))*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + ((-m2**6 - m3sq*m5**4 + m5**6 + m2**4*(m3sq + m5sq) + m2sq*(11*m5**4 - 3*m3sq*m5sq) + m1sq*(m2**4 + (m3sq - m5sq)*m5sq - m2sq*(m3sq + 3*m5sq)))*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim))/(m5**2*(-4*m2sq + m5sq)*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) - (2*m3sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1sq - m3sq)*(m2sq - m3sq)*(4*m3sq*m5sq - (-m2sq + m3sq + m5sq)**2)) + ((m1sq - m2sq + m5sq)*(m1sq + m2sq + m5sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)*m5**2*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))) + (2*m2sq + m5sq + 4*m2sq*B0fin(0,0,m2sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*m5**2*(4*m2sq - m5sq)) - ((-m2sq + m3sq + m5sq)*(m2sq + m3sq + m5sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)*m5**2*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) + T134fin(m2,m1,0,mudim)/((m1sq - m2sq)**2*(m1sq - m3sq)*m5**2) + T134fin(m3,m2,0,mudim)/((m2sq - m3sq)**2*(-m1sq + m3sq)*m5**2) - ((m1sq - m2sq + m5sq)*T134fin(m5,m2,m1,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*m5**2*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))) - T134fin(m5,m2,m2,mudim)/((m1sq - m2sq)*(m2sq - m3sq)*(-m5**4 + 4*m2sq*m5sq)) + ((-m2sq + m3sq + m5sq)*T134fin(m5,m3,m2,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*m5**2*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq)))
		def eval_187():
			return ((m5sq*((2*m1sq*(m1sq - m3sq)*m5sq*(-m5**4 + 4*m1sq*m5sq)*m7sq*(m1**4 - m7**4 - 4*m1sq*m7sq + m5sq*m7sq) - (-2*m1**6 - m3sq*m5**4 + 2*m1**4*(m3sq + 3*m5sq) + m1sq*(-m5**4 + 2*m3sq*m5sq))*(m1**3 - m1*m7sq)**2*(4*m5sq*m7sq - (-m1sq + m5sq + m7sq)**2) + 2*(m1sq - m3sq)*m5sq*(m1sq - m7sq)*(m1**3 - m1*m7sq)**2*(m1**4 - m5**4 + m5sq*m7sq - m1sq*(3*m5sq + m7sq)))*(-2 - B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)) - (m1**3 - m1*m7sq)**2*(4*m5sq*m7sq - (-m1sq + m5sq + m7sq)**2)*((2*m1**6 + m3sq*m5**4 - 2*m1**4*(m3sq + 3*m5sq) + m1sq*(m5**4 - 2*m3sq*m5sq))*B0del(0,0,m1sq,mudim) - 2*(m1sq - m3sq)*(2*m1**4 - m5**4 + 2*m1sq*m5sq)*B0fin(0,0,m1sq,mudim)) - 2*(m1sq - m3sq)*m5sq*(m1sq - m7sq)*(m1**3 - m1*m7sq)**2*(m1**4 - m5**4 + m5sq*m7sq - m1sq*(3*m5sq + m7sq))*(B0del(0,0,m5sq,mudim) - 2*B0fin(0,0,m5sq,mudim)) + (-1 - B0fin(0,0,m1sq,mudim))*((m1**3 - m1*m7sq)**2*(4*m5sq*m7sq - (-m1sq + m5sq + m7sq)**2)*(-2*(m1sq - m3sq)*(2*m1**4 - m5**4 + 2*m1sq*m5sq) + (2*m1**6 + m3sq*m5**4 - 2*m1**4*(m3sq + 3*m5sq) + m1sq*(m5**4 - 2*m3sq*m5sq))*B0fin(0,0,m1sq,mudim)) + 2*(m1sq - m3sq)*m5sq*(m1sq - m7sq)*(m1**3 - m1*m7sq)**2*(m1**4 - m5**4 + m5sq*m7sq - m1sq*(3*m5sq + m7sq))*(-2 + B0fin(0,0,m5sq,mudim)) + 2*m1sq*(m1sq - m3sq)*m5sq*(-m5**4 + 4*m1sq*m5sq)*m7sq*(m1**4 - m7**4 - 4*m1sq*m7sq + m5sq*m7sq)*(-2 + B0fin(0,0,m7sq,mudim))) - 2*m1sq*(m1sq - m3sq)*m5sq*(-m5**4 + 4*m1sq*m5sq)*m7sq*(m1**4 - m7**4 - 4*m1sq*m7sq + m5sq*m7sq)*(B0del(0,0,m7sq,mudim) - 2*B0fin(0,0,m7sq,mudim))))/(m1**2*(-m5**4 + 4*m1sq*m5sq)*(4*m5sq*m7sq - (-m1sq + m5sq + m7sq)**2)) + ((m1sq - m3sq)*(-2*(2*m1**4*(m1sq - m7sq)**2*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))*B0fin(0,0,m1sq,mudim) + m1sq*(m5**4*(-4*m1sq + m5sq)*(-2*m1sq + m5sq - 2*m7sq)*m7sq - m5sq*(m1sq - m7sq)**2*(m1**4 + 2*m5**4 + m7**4 - 2*m5sq*m7sq - 2*m1sq*(3*m5sq + m7sq)))*B0fin(0,0,m1sq,mudim) + 2*m5**4*(-4*m1sq + m5sq)*(m1sq - m7sq)**2*m7sq*(B0fin(0,0,m5sq,mudim) + B0fin(0,0,m7sq,mudim)) + m1sq*(-(m5sq*(m1sq - m7sq)**2*(m1**4 + 2*m5**4 + m7**4 - 2*m5sq*m7sq - 2*m1sq*(3*m5sq + m7sq))*B0fin(0,0,m5sq,mudim)) + m5**4*(-4*m1sq + m5sq)*(-2*m1sq + m5sq - 2*m7sq)*m7sq*B0fin(0,0,m7sq,mudim))) + 2*(m1sq*(m5**4*(-4*m1sq + m5sq)*(-2*m1sq + m5sq - 2*m7sq)*m7sq - m5sq*(m1sq - m7sq)**2*(m1**4 + 2*m5**4 + m7**4 - 2*m5sq*m7sq - 2*m1sq*(3*m5sq + m7sq)))*B0del(0,0,m1sq,mudim) + m1sq*(-(m5sq*(m1sq - m7sq)**2*(m1**4 + 2*m5**4 + m7**4 - 2*m5sq*m7sq - 2*m1sq*(3*m5sq + m7sq))*B0del(0,0,m5sq,mudim)) + m5**4*(-4*m1sq + m5sq)*(-2*m1sq + m5sq - 2*m7sq)*m7sq*B0del(0,0,m7sq,mudim)) + m1**4*(m1sq - m7sq)**2*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))*(2*B0del(0,0,m1sq,mudim) + B0fin(0,0,m1sq,mudim)**2) + m1sq*B0fin(0,0,m1sq,mudim)*(-(m5sq*(m1sq - m7sq)**2*(m1**4 + 2*m5**4 + m7**4 - 2*m5sq*m7sq - 2*m1sq*(3*m5sq + m7sq))*B0fin(0,0,m5sq,mudim)) + m5**4*(-4*m1sq + m5sq)*(-2*m1sq + m5sq - 2*m7sq)*m7sq*B0fin(0,0,m7sq,mudim)) + 2*m5**4*(-4*m1sq + m5sq)*(m1sq - m7sq)**2*m7sq*(B0del(0,0,m5sq,mudim) + B0del(0,0,m7sq,mudim) + B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim)))))/((4*m1sq - m5sq)*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) - 2*m5sq*(m1sq - m7sq)**2*T134fin(m3,m1,0,mudim) + (2*m5sq*(m1sq - m7sq)**2*(-((m1sq - m3sq)*(2*m1sq + m5sq + 4*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim))) + (-3*m1sq - m3sq + m5sq)*T134fin(m5,m1,m1,mudim)))/(4*m1sq - m5sq) + 2*m5sq*(m1sq - m7sq)**2*T134fin(m5,m3,m1,mudim) + 2*m5sq*(m1sq - m7sq)*(-((m1sq - m3sq)*(m1sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim))) + (-m3sq + m7sq)*T134fin(m7,m1,0,mudim)) + 2*m5sq*(m1sq - m7sq)**2*T134fin(m7,m3,0,mudim) + (2*m5sq*(m1sq - m7sq)**2*(-((m1sq - m3sq)*(m1sq - m5sq - m7sq)*(m1sq + m5sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim))) + (-(m5sq - m7sq)**2 + m3sq*(m5sq + m7sq) + m1sq*(-m3sq + m5sq + m7sq))*T134fin(m7,m5,m1,mudim)))/(4*m5sq*m7sq - (-m1sq + m5sq + m7sq)**2) - 2*m5sq*(m1sq - m7sq)**2*T134fin(m7,m5,m3,mudim))/(2.*(m1sq - m3sq)**2*m5**4*(m1sq - m7sq)**3)
		def eval_188():
			return ((m7sq*((2*m1sq*(m1sq - m3sq)*m5sq*m7sq*(-m7**4 + 4*m1sq*m7sq)*(m1**4 - m5**4 - 4*m1sq*m5sq + m5sq*m7sq) + 2*(m1sq - m3sq)*(m1sq - m5sq)*(m1**3 - m1*m5sq)**2*m7sq*(m1**4 + (m5sq - m7sq)*m7sq - m1sq*(m5sq + 3*m7sq)) - (m1**3 - m1*m5sq)**2*(4*m5sq*m7sq - (-m1sq + m5sq + m7sq)**2)*(-2*m1**6 - m3sq*m7**4 + 2*m1**4*(m3sq + 3*m7sq) + m1sq*(-m7**4 + 2*m3sq*m7sq)))*(-2 - B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)) - (m1**3 - m1*m5sq)**2*(4*m5sq*m7sq - (-m1sq + m5sq + m7sq)**2)*((2*m1**6 + m3sq*m7**4 - 2*m1**4*(m3sq + 3*m7sq) + m1sq*(m7**4 - 2*m3sq*m7sq))*B0del(0,0,m1sq,mudim) - 2*(m1sq - m3sq)*(2*m1**4 - m7**4 + 2*m1sq*m7sq)*B0fin(0,0,m1sq,mudim)) - 2*m1sq*(m1sq - m3sq)*m5sq*m7sq*(-m7**4 + 4*m1sq*m7sq)*(m1**4 - m5**4 - 4*m1sq*m5sq + m5sq*m7sq)*(B0del(0,0,m5sq,mudim) - 2*B0fin(0,0,m5sq,mudim)) + (-1 - B0fin(0,0,m1sq,mudim))*((m1**3 - m1*m5sq)**2*(4*m5sq*m7sq - (-m1sq + m5sq + m7sq)**2)*(-2*(m1sq - m3sq)*(2*m1**4 - m7**4 + 2*m1sq*m7sq) + (2*m1**6 + m3sq*m7**4 - 2*m1**4*(m3sq + 3*m7sq) + m1sq*(m7**4 - 2*m3sq*m7sq))*B0fin(0,0,m1sq,mudim)) + 2*m1sq*(m1sq - m3sq)*m5sq*m7sq*(-m7**4 + 4*m1sq*m7sq)*(m1**4 - m5**4 - 4*m1sq*m5sq + m5sq*m7sq)*(-2 + B0fin(0,0,m5sq,mudim)) + 2*(m1sq - m3sq)*(m1sq - m5sq)*(m1**3 - m1*m5sq)**2*m7sq*(m1**4 + (m5sq - m7sq)*m7sq - m1sq*(m5sq + 3*m7sq))*(-2 + B0fin(0,0,m7sq,mudim))) - 2*(m1sq - m3sq)*(m1sq - m5sq)*(m1**3 - m1*m5sq)**2*m7sq*(m1**4 + (m5sq - m7sq)*m7sq - m1sq*(m5sq + 3*m7sq))*(B0del(0,0,m7sq,mudim) - 2*B0fin(0,0,m7sq,mudim))))/(m1**2*(-m7**4 + 4*m1sq*m7sq)*(4*m5sq*m7sq - (-m1sq + m5sq + m7sq)**2)) + (2*(m1sq - m3sq)*(m1sq*(m5sq*m7**4*(-4*m1sq + m7sq)*(-2*m1sq - 2*m5sq + m7sq) - (m1sq - m5sq)**2*m7sq*(m1**4 + m5**4 + 2*m7**4 - 2*m5sq*m7sq - 2*m1sq*(m5sq + 3*m7sq)))*B0del(0,0,m1sq,mudim) + m1sq*(m5sq*m7**4*(-4*m1sq + m7sq)*(-2*m1sq - 2*m5sq + m7sq)*B0del(0,0,m5sq,mudim) - (m1sq - m5sq)**2*m7sq*(m1**4 + m5**4 + 2*m7**4 - 2*m5sq*m7sq - 2*m1sq*(m5sq + 3*m7sq))*B0del(0,0,m7sq,mudim)) - 2*m1**4*(m1sq - m5sq)**2*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))*B0fin(0,0,m1sq,mudim) - m1sq*(m5sq*m7**4*(-4*m1sq + m7sq)*(-2*m1sq - 2*m5sq + m7sq) - (m1sq - m5sq)**2*m7sq*(m1**4 + m5**4 + 2*m7**4 - 2*m5sq*m7sq - 2*m1sq*(m5sq + 3*m7sq)))*B0fin(0,0,m1sq,mudim) + m1**4*(m1sq - m5sq)**2*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))*(2*B0del(0,0,m1sq,mudim) + B0fin(0,0,m1sq,mudim)**2) + 2*(-(m1sq*m5) + m5**3)**2*m7**4*(4*m1sq - m7sq)*(B0fin(0,0,m5sq,mudim) + B0fin(0,0,m7sq,mudim)) - m1sq*(m5sq*m7**4*(-4*m1sq + m7sq)*(-2*m1sq - 2*m5sq + m7sq)*B0fin(0,0,m5sq,mudim) - (m1sq - m5sq)**2*m7sq*(m1**4 + m5**4 + 2*m7**4 - 2*m5sq*m7sq - 2*m1sq*(m5sq + 3*m7sq))*B0fin(0,0,m7sq,mudim)) + m1sq*B0fin(0,0,m1sq,mudim)*(m5sq*m7**4*(-4*m1sq + m7sq)*(-2*m1sq - 2*m5sq + m7sq)*B0fin(0,0,m5sq,mudim) - (m1sq - m5sq)**2*m7sq*(m1**4 + m5**4 + 2*m7**4 - 2*m5sq*m7sq - 2*m1sq*(m5sq + 3*m7sq))*B0fin(0,0,m7sq,mudim)) - 2*(-(m1sq*m5) + m5**3)**2*m7**4*(4*m1sq - m7sq)*(B0del(0,0,m5sq,mudim) + B0del(0,0,m7sq,mudim) + B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))))/((4*m1sq - m7sq)*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) - 2*(m1sq - m5sq)**2*m7sq*T134fin(m3,m1,0,mudim) + 2*(m1sq - m5sq)*m7sq*(-((m1sq - m3sq)*(m1sq + m5sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim))) + (-m3sq + m5sq)*T134fin(m5,m1,0,mudim)) + 2*(m1sq - m5sq)**2*m7sq*T134fin(m5,m3,0,mudim) + (2*(m1sq - m5sq)**2*m7sq*(-((m1sq - m3sq)*(2*m1sq + m7sq + 4*m1sq*B0fin(0,0,m1sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim))) + (-3*m1sq - m3sq + m7sq)*T134fin(m7,m1,m1,mudim)))/(4*m1sq - m7sq) + 2*(m1sq - m5sq)**2*m7sq*T134fin(m7,m3,m1,mudim) + (2*(m1sq - m5sq)**2*m7sq*(-((m1sq - m3sq)*(m1sq - m5sq - m7sq)*(m1sq + m5sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim))) + (-(m5sq - m7sq)**2 + m3sq*(m5sq + m7sq) + m1sq*(-m3sq + m5sq + m7sq))*T134fin(m7,m5,m1,mudim)))/(4*m5sq*m7sq - (-m1sq + m5sq + m7sq)**2) - 2*(m1sq - m5sq)**2*m7sq*T134fin(m7,m5,m3,mudim))/(2.*(m1sq - m3sq)**2*(m1sq - m5sq)**3*m7**4)
		def eval_189():
			return (2*m1**4*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*m7**4*(4*m1sq - m7sq)) - ((2*m1**4 - m7**4 + 2*m1sq*m7sq)*B0del(0,0,m1sq,mudim))/(2.*(m1sq - m2sq)*(m1sq - m3sq)*m7**4*(4*m1sq - m7sq)) + (m1sq*m2sq*(2*m1sq + 2*m2sq - m7sq)*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)**3*(m2sq - m3sq)*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))) + (m1sq*m3sq*(2*m1sq + 2*m3sq - m7sq)*B0del(0,0,m1sq,mudim))/((m1sq - m3sq)**3*(-m2sq + m3sq)*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))) + (m1sq*(-(1/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq - m7sq))) + m7sq*(1/((m1sq - m2sq)*(m2sq - m3sq)*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))) + 1/((m1sq - m3sq)*(-m2sq + m3sq)*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq)))))*B0del(0,0,m1sq,mudim))/m7**2 - (2*m2sq*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))) + (m1sq*m2sq*(2*m1sq + 2*m2sq - m7sq)*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)**3*(m2sq - m3sq)*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))) + (m2sq*(m1**4 - m2**4 - 4*m1sq*m2sq + m2sq*m7sq)*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)**3*(m2sq - m3sq)*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))) - (2*m3sq*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))) + (m1sq*m3sq*(2*m1sq + 2*m3sq - m7sq)*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)**3*(-m2sq + m3sq)*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))) + (m3sq*(m1**4 - m3**4 - 4*m1sq*m3sq + m3sq*m7sq)*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)**3*(-m2sq + m3sq)*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))) - (2*m2sq*B0del(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))) - (2*m3sq*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))) + ((-m1**6 + m7sq*(-m2sq + m7sq)*(-m3sq + m7sq) + m1**4*(m2sq + m3sq + m7sq) - m1sq*(-11*m7**4 + 3*m3sq*m7sq + m2sq*(m3sq + 3*m7sq)))*B0del(0,0,m7sq,mudim))/(m7**2*(-4*m1sq + m7sq)*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))) + (m1sq*(-(1/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq - m7sq))) + m7sq*(1/((m1sq - m2sq)*(m2sq - m3sq)*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))) + 1/((m1sq - m3sq)*(-m2sq + m3sq)*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq)))))*B0del(0,0,m7sq,mudim))/m7**2 - ((2*m1**4 - m7**4 + 2*m1sq*m7sq)*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/(2.*(m1sq - m2sq)*(m1sq - m3sq)*m7**4*(4*m1sq - m7sq)) + (m2sq*(m1**4 - m2**4 - 4*m1sq*m2sq + m2sq*m7sq)*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/((m1sq - m2sq)**3*(m2sq - m3sq)*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))) + (m3sq*(m1**4 - m3**4 - 4*m1sq*m3sq + m3sq*m7sq)*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/((m1sq - m3sq)**3*(-m2sq + m3sq)*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))) + ((-m1**6 + m7sq*(-m2sq + m7sq)*(-m3sq + m7sq) + m1**4*(m2sq + m3sq + m7sq) - m1sq*(-11*m7**4 + 3*m3sq*m7sq + m2sq*(m3sq + 3*m7sq)))*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/(m7**2*(-4*m1sq + m7sq)*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))) - (2*m1**4*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*m7**4*(4*m1sq - m7sq)) + ((2*m1**4 - m7**4 + 2*m1sq*m7sq)*B0fin(0,0,m1sq,mudim))/(2.*(m1sq - m2sq)*(m1sq - m3sq)*m7**4*(4*m1sq - m7sq)) - (m1sq*m2sq*(2*m1sq + 2*m2sq - m7sq)*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)**3*(m2sq - m3sq)*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))) - (m1sq*m3sq*(2*m1sq + 2*m3sq - m7sq)*B0fin(0,0,m1sq,mudim))/((m1sq - m3sq)**3*(-m2sq + m3sq)*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))) - (m1sq*(-(1/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq - m7sq))) + m7sq*(1/((m1sq - m2sq)*(m2sq - m3sq)*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))) + 1/((m1sq - m3sq)*(-m2sq + m3sq)*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq)))))*B0fin(0,0,m1sq,mudim))/m7**2 + (m1**4*B0fin(0,0,m1sq,mudim)**2)/((m1sq - m2sq)*(m1sq - m3sq)*m7**4*(4*m1sq - m7sq)) - ((2*m1**4 - m7**4 + 2*m1sq*m7sq)*B0fin(0,0,m1sq,mudim)**2)/(2.*(m1sq - m2sq)*(m1sq - m3sq)*m7**4*(4*m1sq - m7sq)) + (2*m2sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))) - (m1sq*m2sq*(2*m1sq + 2*m2sq - m7sq)*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)**3*(m2sq - m3sq)*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))) + (m2sq*(-m1**4 + m2**4 + 4*m1sq*m2sq - m2sq*m7sq)*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)**3*(m2sq - m3sq)*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))) + (m1sq*m2sq*(2*m1sq + 2*m2sq - m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)**3*(m2sq - m3sq)*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))) + (m2sq*(m1**4 - m2**4 - 4*m1sq*m2sq + m2sq*m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)**3*(m2sq - m3sq)*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))) - (2*((m1sq + m2sq)/2. + m1sq*B0fin(0,0,m1sq,mudim) + m2sq*B0fin(0,0,m2sq,mudim)))/((m1sq - m2sq)**2*(m2sq - m3sq)*m7**2) + (2*m3sq*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))) - (m1sq*m3sq*(2*m1sq + 2*m3sq - m7sq)*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)**3*(-m2sq + m3sq)*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))) + (m3sq*(-m1**4 + m3**4 + 4*m1sq*m3sq - m3sq*m7sq)*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)**3*(-m2sq + m3sq)*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))) + (m1sq*m3sq*(2*m1sq + 2*m3sq - m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)**3*(-m2sq + m3sq)*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))) + (m3sq*(m1**4 - m3**4 - 4*m1sq*m3sq + m3sq*m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)**3*(-m2sq + m3sq)*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))) + (m1sq + m3sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)**2*(m2sq - m3sq)*m7**2) + (2*m2sq*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))) + (2*m3sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))) + ((m1**6 - m7sq*(-m2sq + m7sq)*(-m3sq + m7sq) - m1**4*(m2sq + m3sq + m7sq) + m1sq*(-11*m7**4 + 3*m3sq*m7sq + m2sq*(m3sq + 3*m7sq)))*B0fin(0,0,m7sq,mudim))/(m7**2*(-4*m1sq + m7sq)*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))) - (m1sq*(-(1/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq - m7sq))) + m7sq*(1/((m1sq - m2sq)*(m2sq - m3sq)*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))) + 1/((m1sq - m3sq)*(-m2sq + m3sq)*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq)))))*B0fin(0,0,m7sq,mudim))/m7**2 + ((-m1**6 + m7sq*(-m2sq + m7sq)*(-m3sq + m7sq) + m1**4*(m2sq + m3sq + m7sq) - m1sq*(-11*m7**4 + 3*m3sq*m7sq + m2sq*(m3sq + 3*m7sq)))*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/(m7**2*(-4*m1sq + m7sq)*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))) + (m1sq*(-(1/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq - m7sq))) + m7sq*(1/((m1sq - m2sq)*(m2sq - m3sq)*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))) + 1/((m1sq - m3sq)*(-m2sq + m3sq)*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq)))))*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/m7**2 - (2*m2sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))) - (2*m3sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))) - (2*(m1sq + m7sq/2. + 2*m1sq*B0fin(0,0,m1sq,mudim) + m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)*(-m7**4 + 4*m1sq*m7sq)) + ((m1sq - m2sq - m7sq)*(m1sq + m2sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)*(m2sq - m3sq)*m7**2*(m1**4 + (m2sq - m7sq)**2 - 2*m1sq*(m2sq + m7sq))) + ((m1sq - m3sq - m7sq)*(m1sq + m3sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)*m7**2*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq))) + T134fin(m2,m1,0,mudim)/((m1sq - m2sq)**2*(m2sq - m3sq)*m7**2) + T134fin(m3,m1,0,mudim)/((m1sq - m3sq)**2*(-m2sq + m3sq)*m7**2) + T134fin(m7,m1,m1,mudim)/((m1sq - m2sq)*(m1sq - m3sq)*(-m7**4 + 4*m1sq*m7sq)) + ((m1sq - m2sq - m7sq)*T134fin(m7,m2,m1,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*m7**2*(4*m2sq*m7sq - (-m1sq + m2sq + m7sq)**2)) - ((m1sq - m3sq - m7sq)*T134fin(m7,m3,m1,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*m7**2*(m1**4 + (m3sq - m7sq)**2 - 2*m1sq*(m3sq + m7sq)))
		def eval_190():
			return (2*m1**4*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*m5**4*(4*m1sq - m5sq)) - ((2*m1**4 - m5**4 + 2*m1sq*m5sq)*B0del(0,0,m1sq,mudim))/(2.*(m1sq - m2sq)*(m1sq - m3sq)*m5**4*(4*m1sq - m5sq)) + (m1sq*m2sq*(2*m1sq + 2*m2sq - m5sq)*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)**3*(m2sq - m3sq)*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))) + (m1sq*m3sq*(2*m1sq + 2*m3sq - m5sq)*B0del(0,0,m1sq,mudim))/((m1sq - m3sq)**3*(-m2sq + m3sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) + (m1sq*(-(1/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq - m5sq))) + m5sq*(1/((m1sq - m2sq)*(m2sq - m3sq)*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))) + 1/((m1sq - m3sq)*(-m2sq + m3sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq)))))*B0del(0,0,m1sq,mudim))/m5**2 - (2*m2sq*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))) + (m1sq*m2sq*(2*m1sq + 2*m2sq - m5sq)*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)**3*(m2sq - m3sq)*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))) + (m2sq*(m1**4 - m2**4 - 4*m1sq*m2sq + m2sq*m5sq)*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)**3*(m2sq - m3sq)*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))) - (2*m3sq*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) + (m1sq*m3sq*(2*m1sq + 2*m3sq - m5sq)*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)**3*(-m2sq + m3sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) + (m3sq*(m1**4 - m3**4 - 4*m1sq*m3sq + m3sq*m5sq)*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)**3*(-m2sq + m3sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) - (2*m2sq*B0del(0,0,m5sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))) - (2*m3sq*B0del(0,0,m5sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) + ((-m1**6 + m5sq*(-m2sq + m5sq)*(-m3sq + m5sq) + m1**4*(m2sq + m3sq + m5sq) - m1sq*(-11*m5**4 + 3*m3sq*m5sq + m2sq*(m3sq + 3*m5sq)))*B0del(0,0,m5sq,mudim))/(m5**2*(-4*m1sq + m5sq)*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) + (m1sq*(-(1/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq - m5sq))) + m5sq*(1/((m1sq - m2sq)*(m2sq - m3sq)*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))) + 1/((m1sq - m3sq)*(-m2sq + m3sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq)))))*B0del(0,0,m5sq,mudim))/m5**2 - ((2*m1**4 - m5**4 + 2*m1sq*m5sq)*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/(2.*(m1sq - m2sq)*(m1sq - m3sq)*m5**4*(4*m1sq - m5sq)) + (m2sq*(m1**4 - m2**4 - 4*m1sq*m2sq + m2sq*m5sq)*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/((m1sq - m2sq)**3*(m2sq - m3sq)*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))) + (m3sq*(m1**4 - m3**4 - 4*m1sq*m3sq + m3sq*m5sq)*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/((m1sq - m3sq)**3*(-m2sq + m3sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) + ((-m1**6 + m5sq*(-m2sq + m5sq)*(-m3sq + m5sq) + m1**4*(m2sq + m3sq + m5sq) - m1sq*(-11*m5**4 + 3*m3sq*m5sq + m2sq*(m3sq + 3*m5sq)))*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/(m5**2*(-4*m1sq + m5sq)*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) - (2*m1**4*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*m5**4*(4*m1sq - m5sq)) + ((2*m1**4 - m5**4 + 2*m1sq*m5sq)*B0fin(0,0,m1sq,mudim))/(2.*(m1sq - m2sq)*(m1sq - m3sq)*m5**4*(4*m1sq - m5sq)) - (m1sq*m2sq*(2*m1sq + 2*m2sq - m5sq)*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)**3*(m2sq - m3sq)*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))) - (m1sq*m3sq*(2*m1sq + 2*m3sq - m5sq)*B0fin(0,0,m1sq,mudim))/((m1sq - m3sq)**3*(-m2sq + m3sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) - (m1sq*(-(1/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq - m5sq))) + m5sq*(1/((m1sq - m2sq)*(m2sq - m3sq)*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))) + 1/((m1sq - m3sq)*(-m2sq + m3sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq)))))*B0fin(0,0,m1sq,mudim))/m5**2 + (m1**4*B0fin(0,0,m1sq,mudim)**2)/((m1sq - m2sq)*(m1sq - m3sq)*m5**4*(4*m1sq - m5sq)) - ((2*m1**4 - m5**4 + 2*m1sq*m5sq)*B0fin(0,0,m1sq,mudim)**2)/(2.*(m1sq - m2sq)*(m1sq - m3sq)*m5**4*(4*m1sq - m5sq)) + (2*m2sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))) - (m1sq*m2sq*(2*m1sq + 2*m2sq - m5sq)*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)**3*(m2sq - m3sq)*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))) + (m2sq*(-m1**4 + m2**4 + 4*m1sq*m2sq - m2sq*m5sq)*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)**3*(m2sq - m3sq)*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))) + (m1sq*m2sq*(2*m1sq + 2*m2sq - m5sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)**3*(m2sq - m3sq)*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))) + (m2sq*(m1**4 - m2**4 - 4*m1sq*m2sq + m2sq*m5sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)**3*(m2sq - m3sq)*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))) - (2*((m1sq + m2sq)/2. + m1sq*B0fin(0,0,m1sq,mudim) + m2sq*B0fin(0,0,m2sq,mudim)))/((m1sq - m2sq)**2*(m2sq - m3sq)*m5**2) + (2*m3sq*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) - (m1sq*m3sq*(2*m1sq + 2*m3sq - m5sq)*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)**3*(-m2sq + m3sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) + (m3sq*(-m1**4 + m3**4 + 4*m1sq*m3sq - m3sq*m5sq)*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)**3*(-m2sq + m3sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) + (m1sq*m3sq*(2*m1sq + 2*m3sq - m5sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)**3*(-m2sq + m3sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) + (m3sq*(m1**4 - m3**4 - 4*m1sq*m3sq + m3sq*m5sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)**3*(-m2sq + m3sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) + (m1sq + m3sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)**2*(m2sq - m3sq)*m5**2) + (2*m2sq*B0fin(0,0,m5sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))) + (2*m3sq*B0fin(0,0,m5sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) + ((m1**6 - m5sq*(-m2sq + m5sq)*(-m3sq + m5sq) - m1**4*(m2sq + m3sq + m5sq) + m1sq*(-11*m5**4 + 3*m3sq*m5sq + m2sq*(m3sq + 3*m5sq)))*B0fin(0,0,m5sq,mudim))/(m5**2*(-4*m1sq + m5sq)*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) - (m1sq*(-(1/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq - m5sq))) + m5sq*(1/((m1sq - m2sq)*(m2sq - m3sq)*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))) + 1/((m1sq - m3sq)*(-m2sq + m3sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq)))))*B0fin(0,0,m5sq,mudim))/m5**2 + ((-m1**6 + m5sq*(-m2sq + m5sq)*(-m3sq + m5sq) + m1**4*(m2sq + m3sq + m5sq) - m1sq*(-11*m5**4 + 3*m3sq*m5sq + m2sq*(m3sq + 3*m5sq)))*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/(m5**2*(-4*m1sq + m5sq)*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) + (m1sq*(-(1/((m1sq - m2sq)*(m1sq - m3sq)*(4*m1sq - m5sq))) + m5sq*(1/((m1sq - m2sq)*(m2sq - m3sq)*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))) + 1/((m1sq - m3sq)*(-m2sq + m3sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq)))))*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/m5**2 - (2*m2sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))) - (2*m3sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) - (2*(m1sq + m5sq/2. + 2*m1sq*B0fin(0,0,m1sq,mudim) + m5sq*B0fin(0,0,m5sq,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)*(-m5**4 + 4*m1sq*m5sq)) + ((m1sq - m2sq - m5sq)*(m1sq + m2sq + m5sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim)))/((m1sq - m2sq)*(m2sq - m3sq)*m5**2*(m1**4 + (m2sq - m5sq)**2 - 2*m1sq*(m2sq + m5sq))) + ((m1sq - m3sq - m5sq)*(m1sq + m3sq + m5sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)*m5**2*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) + T134fin(m2,m1,0,mudim)/((m1sq - m2sq)**2*(m2sq - m3sq)*m5**2) + T134fin(m3,m1,0,mudim)/((m1sq - m3sq)**2*(-m2sq + m3sq)*m5**2) + T134fin(m5,m1,m1,mudim)/((m1sq - m2sq)*(m1sq - m3sq)*(-m5**4 + 4*m1sq*m5sq)) + ((m1sq - m2sq - m5sq)*T134fin(m5,m2,m1,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*m5**2*(4*m2sq*m5sq - (-m1sq + m2sq + m5sq)**2)) - ((m1sq - m3sq - m5sq)*T134fin(m5,m3,m1,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*m5**2*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq)))
		def eval_191():
			return -0.5*(4*m1**12 + 86*m1**8*m4**4 - 68*m1**6*m4**6 + 8*m1**4*m4**8 + 10*m1sq*m4**10 - 2*m4**12 - 38*m1**10*m4sq + 86*m1**8*m6**4 + 32*m1**4*m4**4*m6**4 - 28*m1sq*m4**6*m6**4 - 30*m4**8*m6**4 - 44*m1**6*m4sq*m6**4 - 68*m1**6*m6**6 - 28*m1sq*m4**4*m6**6 + 40*m4**6*m6**6 + 24*m1**4*m4sq*m6**6 + 8*m1**4*m6**8 - 30*m4**4*m6**8 + 18*m1sq*m4sq*m6**8 + 10*m1sq*m6**10 + 12*m4sq*m6**10 - 2*m6**12 - 38*m1**10*m6sq - 44*m1**6*m4**4*m6sq + 24*m1**4*m4**6*m6sq + 18*m1sq*m4**8*m6sq + 12*m4**10*m6sq + 28*m1**8*m4sq*m6sq - 4*m1**4*(m1**8 - m1**6*(m4sq + m6sq) + m1sq*(5*m4**6 - 11*m4sq*m6**4 + 5*m6**6 - 11*m4**4*m6sq) - 2*(m4sq - m6sq)**2*(m4**4 + m6**4 + 4*m4sq*m6sq) + m1**4*(-3*m4**4 - 3*m6**4 + 16*m4sq*m6sq))*B0del(0,0,m1sq,mudim) - 4*m1sq*m4sq*(m1**8 - m1**6*(m4sq + m6sq) + m1sq*(5*m4**6 - 11*m4sq*m6**4 + 5*m6**6 - 11*m4**4*m6sq) - 2*(m4sq - m6sq)**2*(m4**4 + m6**4 + 4*m4sq*m6sq) + m1**4*(-3*m4**4 - 3*m6**4 + 16*m4sq*m6sq))*B0del(0,0,m4sq,mudim) + 4*m1**8*m6**4*B0del(0,0,m6sq,mudim) + 44*m1**4*m4**4*m6**4*B0del(0,0,m6sq,mudim) + 16*m1sq*m4**6*m6**4*B0del(0,0,m6sq,mudim) - 64*m1**6*m4sq*m6**4*B0del(0,0,m6sq,mudim) + 12*m1**6*m6**6*B0del(0,0,m6sq,mudim) - 48*m1sq*m4**4*m6**6*B0del(0,0,m6sq,mudim) + 44*m1**4*m4sq*m6**6*B0del(0,0,m6sq,mudim) - 20*m1**4*m6**8*B0del(0,0,m6sq,mudim) + 16*m1sq*m4sq*m6**8*B0del(0,0,m6sq,mudim) + 8*m1sq*m6**10*B0del(0,0,m6sq,mudim) - 4*m1**10*m6sq*B0del(0,0,m6sq,mudim) + 12*m1**6*m4**4*m6sq*B0del(0,0,m6sq,mudim) - 20*m1**4*m4**6*m6sq*B0del(0,0,m6sq,mudim) + 8*m1sq*m4**8*m6sq*B0del(0,0,m6sq,mudim) + 4*m1**8*m4sq*m6sq*B0del(0,0,m6sq,mudim) + 6*m1**12*B0fin(0,0,m1sq,mudim) + 24*m1**8*m4**4*B0fin(0,0,m1sq,mudim) + 12*m1**6*m4**6*B0fin(0,0,m1sq,mudim) - 30*m1**4*m4**8*B0fin(0,0,m1sq,mudim) + 12*m1sq*m4**10*B0fin(0,0,m1sq,mudim) - 24*m1**10*m4sq*B0fin(0,0,m1sq,mudim) + 24*m1**8*m6**4*B0fin(0,0,m1sq,mudim) - 132*m1**4*m4**4*m6**4*B0fin(0,0,m1sq,mudim) + 24*m1sq*m4**6*m6**4*B0fin(0,0,m1sq,mudim) - 36*m1**6*m4sq*m6**4*B0fin(0,0,m1sq,mudim) + 12*m1**6*m6**6*B0fin(0,0,m1sq,mudim) + 24*m1sq*m4**4*m6**6*B0fin(0,0,m1sq,mudim) + 96*m1**4*m4sq*m6**6*B0fin(0,0,m1sq,mudim) - 30*m1**4*m6**8*B0fin(0,0,m1sq,mudim) - 36*m1sq*m4sq*m6**8*B0fin(0,0,m1sq,mudim) + 12*m1sq*m6**10*B0fin(0,0,m1sq,mudim) - 24*m1**10*m6sq*B0fin(0,0,m1sq,mudim) - 36*m1**6*m4**4*m6sq*B0fin(0,0,m1sq,mudim) + 96*m1**4*m4**6*m6sq*B0fin(0,0,m1sq,mudim) - 36*m1sq*m4**8*m6sq*B0fin(0,0,m1sq,mudim) - 5*m1**12*B0fin(0,0,m4sq,mudim) + 37*m1**8*m4**4*B0fin(0,0,m4sq,mudim) - 60*m1**6*m4**6*B0fin(0,0,m4sq,mudim) + 33*m1**4*m4**8*B0fin(0,0,m4sq,mudim) - 4*m1sq*m4**10*B0fin(0,0,m4sq,mudim) - m4**12*B0fin(0,0,m4sq,mudim) - 45*m1**8*m6**4*B0fin(0,0,m4sq,mudim) + 86*m1**4*m4**4*m6**4*B0fin(0,0,m4sq,mudim) + 12*m1sq*m4**6*m6**4*B0fin(0,0,m4sq,mudim) - 5*m4**8*m6**4*B0fin(0,0,m4sq,mudim) + 88*m1**6*m4sq*m6**4*B0fin(0,0,m4sq,mudim) + 40*m1**6*m6**6*B0fin(0,0,m4sq,mudim) - 68*m1sq*m4**4*m6**6*B0fin(0,0,m4sq,mudim) - 96*m1**4*m4sq*m6**6*B0fin(0,0,m4sq,mudim) - 15*m1**4*m6**8*B0fin(0,0,m4sq,mudim) + 5*m4**4*m6**8*B0fin(0,0,m4sq,mudim) + 40*m1sq*m4sq*m6**8*B0fin(0,0,m4sq,mudim) - 4*m4sq*m6**10*B0fin(0,0,m4sq,mudim) + m6**12*B0fin(0,0,m4sq,mudim) + 24*m1**10*m6sq*B0fin(0,0,m4sq,mudim) - 60*m1**6*m4**4*m6sq*B0fin(0,0,m4sq,mudim) + 40*m1**4*m4**6*m6sq*B0fin(0,0,m4sq,mudim) + 20*m1sq*m4**8*m6sq*B0fin(0,0,m4sq,mudim) + 4*m4**10*m6sq*B0fin(0,0,m4sq,mudim) - 28*m1**8*m4sq*m6sq*B0fin(0,0,m4sq,mudim) - 2*m1**12*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 8*m1**8*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 4*m1**6*m4**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 6*m1**4*m4**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 4*m1sq*m4**10*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 4*m1**8*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 24*m1**4*m4**4*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 32*m1sq*m4**6*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 60*m1**6*m4sq*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 16*m1**6*m6**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 32*m1sq*m4**4*m6**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 24*m1**4*m4sq*m6**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 14*m1**4*m6**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 4*m1sq*m4sq*m6**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 4*m1sq*m6**10*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 4*m1**10*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 16*m1**6*m4**4*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 40*m1**4*m4**6*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 4*m1sq*m4**8*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 32*m1**8*m4sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 5*m1**12*B0fin(0,0,m6sq,mudim) - 45*m1**8*m4**4*B0fin(0,0,m6sq,mudim) + 40*m1**6*m4**6*B0fin(0,0,m6sq,mudim) - 15*m1**4*m4**8*B0fin(0,0,m6sq,mudim) + m4**12*B0fin(0,0,m6sq,mudim) + 24*m1**10*m4sq*B0fin(0,0,m6sq,mudim) + 37*m1**8*m6**4*B0fin(0,0,m6sq,mudim) + 86*m1**4*m4**4*m6**4*B0fin(0,0,m6sq,mudim) - 68*m1sq*m4**6*m6**4*B0fin(0,0,m6sq,mudim) + 5*m4**8*m6**4*B0fin(0,0,m6sq,mudim) - 60*m1**6*m4sq*m6**4*B0fin(0,0,m6sq,mudim) - 60*m1**6*m6**6*B0fin(0,0,m6sq,mudim) + 12*m1sq*m4**4*m6**6*B0fin(0,0,m6sq,mudim) + 40*m1**4*m4sq*m6**6*B0fin(0,0,m6sq,mudim) + 33*m1**4*m6**8*B0fin(0,0,m6sq,mudim) - 5*m4**4*m6**8*B0fin(0,0,m6sq,mudim) + 20*m1sq*m4sq*m6**8*B0fin(0,0,m6sq,mudim) - 4*m1sq*m6**10*B0fin(0,0,m6sq,mudim) + 4*m4sq*m6**10*B0fin(0,0,m6sq,mudim) - m6**12*B0fin(0,0,m6sq,mudim) + 88*m1**6*m4**4*m6sq*B0fin(0,0,m6sq,mudim) - 96*m1**4*m4**6*m6sq*B0fin(0,0,m6sq,mudim) + 40*m1sq*m4**8*m6sq*B0fin(0,0,m6sq,mudim) - 4*m4**10*m6sq*B0fin(0,0,m6sq,mudim) - 28*m1**8*m4sq*m6sq*B0fin(0,0,m6sq,mudim) - 2*m1**12*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 4*m1**8*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 16*m1**6*m4**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 14*m1**4*m4**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m1sq*m4**10*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 4*m1**10*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 8*m1**8*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 24*m1**4*m4**4*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 32*m1sq*m4**6*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 16*m1**6*m4sq*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m1**6*m6**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 32*m1sq*m4**4*m6**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 40*m1**4*m4sq*m6**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 6*m1**4*m6**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 4*m1sq*m4sq*m6**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 4*m1sq*m6**10*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 60*m1**6*m4**4*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 24*m1**4*m4**6*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m1sq*m4**8*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 32*m1**8*m4sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m1**12*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m1**8*m4**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) + 16*m1**6*m4**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) - 14*m1**4*m4**8*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) + 4*m1sq*m4**10*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m1**10*m4sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m1**8*m6**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) + 68*m1**4*m4**4*m6**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) - 16*m1sq*m4**6*m6**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) - 48*m1**6*m4sq*m6**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) + 16*m1**6*m6**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) - 16*m1sq*m4**4*m6**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) + 4*m1**4*m4sq*m6**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) - 14*m1**4*m6**8*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) + 12*m1sq*m4sq*m6**8*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) + 4*m1sq*m6**10*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m1**10*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) - 48*m1**6*m4**4*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) + 4*m1**4*m4**6*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) + 12*m1sq*m4**8*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) + 36*m1**8*m4sq*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) + 4*m1**10*T134fin(m6,m4,m1,mudim) - 12*m1**6*m4**4*T134fin(m6,m4,m1,mudim) + 20*m1**4*m4**6*T134fin(m6,m4,m1,mudim) - 8*m1sq*m4**8*T134fin(m6,m4,m1,mudim) - 4*m1**8*m4sq*T134fin(m6,m4,m1,mudim) - 12*m1**6*m6**4*T134fin(m6,m4,m1,mudim) + 48*m1sq*m4**4*m6**4*T134fin(m6,m4,m1,mudim) - 44*m1**4*m4sq*m6**4*T134fin(m6,m4,m1,mudim) + 20*m1**4*m6**6*T134fin(m6,m4,m1,mudim) - 16*m1sq*m4sq*m6**6*T134fin(m6,m4,m1,mudim) - 8*m1sq*m6**8*T134fin(m6,m4,m1,mudim) - 4*m1**8*m6sq*T134fin(m6,m4,m1,mudim) - 44*m1**4*m4**4*m6sq*T134fin(m6,m4,m1,mudim) - 16*m1sq*m4**6*m6sq*T134fin(m6,m4,m1,mudim) + 64*m1**6*m4sq*m6sq*T134fin(m6,m4,m1,mudim))/(m1**2*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**4)
		def eval_192():
			return ((2*m1**6)/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (2*m1sq*m4**4)/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (2*m1sq*m6**4)/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (2*m1sq*m2**4)/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (4*m1sq*m4**4)/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (6*m2sq*m4**4)/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m2**4*m4sq)/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (2*m1sq*m2sq*m4sq)/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (4*m1sq*m6**4)/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (6*m2sq*m6**4)/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (4*m1sq*m4sq*m6sq)/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (6*m2**4*m6sq)/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (6*m1sq*m2sq*m6sq)/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (8*m1sq*m4sq*m6sq)/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (4*m2sq*m4sq*m6sq)/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (m2**8*(m1sq - m2sq))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*(m1sq - m2sq)*m2sq*m4**6)/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 - ((m1sq - m2sq)*m4**8)/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*m2**6*(-m1sq + m2sq)*m4sq)/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (10*m2**4*(-m1sq + m2sq)*m6**4)/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 - (8*(m1sq - m2sq)*m4**4*m6**4)/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*(m1sq - m2sq)*m2sq*m4sq*m6**4)/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (4*(m1sq - m2sq)*m2sq*m6**6)/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*(m1sq - m2sq)*m4sq*m6**6)/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + ((m1sq - m2sq)*m6**8)/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (4*m2**6*(m1sq - m2sq)*m6sq)/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (24*(m1sq - m2sq)*m2sq*m4**4*m6sq)/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (6*(m1sq - m2sq)*m4**6*m6sq)/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (14*m2**4*(m1sq - m2sq)*m4sq*m6sq)/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (m2**4*(m1sq - m2sq))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 + (5*(m1sq - m2sq)*m4**4)/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 + (10*(m1sq - m2sq)*m2sq*m4sq)/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 + (3*(m1sq - m2sq)*m6**4)/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 + (4*m2sq*(-m1sq + m2sq)*m6sq)/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 - (4*(m1sq - m2sq)*m4sq*m6sq)/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 + (2*m1**6*B0del(0,0,m1sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (2*m1**4*m4sq*B0del(0,0,m1sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (2*m1**4*m6sq*B0del(0,0,m1sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (2*m2**6*B0del(0,0,m2sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m2**4*m4sq*B0del(0,0,m2sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m2**4*m6sq*B0del(0,0,m2sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (4*m2**8*(m1sq - m2sq)*B0del(0,0,m2sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*m2**4*(-m1sq + m2sq)*m4**4*B0del(0,0,m2sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (6*(m1sq - m2sq)*m2sq*m4**6*B0del(0,0,m2sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 - (2*(m1sq - m2sq)*m4**8*B0del(0,0,m2sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (6*m2**6*(-m1sq + m2sq)*m4sq*B0del(0,0,m2sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (10*m2**4*(m1sq - m2sq)*m6**4*B0del(0,0,m2sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*(m1sq - m2sq)*m2sq*m4sq*m6**4*B0del(0,0,m2sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (6*m2sq*(-m1sq + m2sq)*m6**6*B0del(0,0,m2sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 - (4*(m1sq - m2sq)*m4sq*m6**6*B0del(0,0,m2sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*(m1sq - m2sq)*m6**8*B0del(0,0,m2sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (10*m2**6*(-m1sq + m2sq)*m6sq*B0del(0,0,m2sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*m2sq*(-m1sq + m2sq)*m4**4*m6sq*B0del(0,0,m2sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (4*(m1sq - m2sq)*m4**6*m6sq*B0del(0,0,m2sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (16*m2**4*(m1sq - m2sq)*m4sq*m6sq*B0del(0,0,m2sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*m2**4*(-m1sq + m2sq)*B0del(0,0,m2sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 + (2*(m1sq - m2sq)*m4**4*B0del(0,0,m2sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 - (2*(m1sq - m2sq)*m6**4*B0del(0,0,m2sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 + (4*(m1sq - m2sq)*m2sq*m6sq*B0del(0,0,m2sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 - (2*m1sq*m4**4*B0del(0,0,m4sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m1**4*m4sq*B0del(0,0,m4sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m2sq*m4**4*B0del(0,0,m4sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (2*m2**4*m4sq*B0del(0,0,m4sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (2*m1sq*m4sq*m6sq*B0del(0,0,m4sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m2sq*m4sq*m6sq*B0del(0,0,m4sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m2**8*(m1sq - m2sq)*B0del(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*m2**4*(-m1sq + m2sq)*m4**4*B0del(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*(m1sq - m2sq)*m2sq*m4**6*B0del(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*m2**6*(-m1sq + m2sq)*m4sq*B0del(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (12*m2**4*(m1sq - m2sq)*m6**4*B0del(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 - (10*(m1sq - m2sq)*m4**4*m6**4*B0del(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (6*m2sq*(-m1sq + m2sq)*m4sq*m6**4*B0del(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (8*m2sq*(-m1sq + m2sq)*m6**6*B0del(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*(m1sq - m2sq)*m4sq*m6**6*B0del(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*(m1sq - m2sq)*m6**8*B0del(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (8*m2**6*(-m1sq + m2sq)*m6sq*B0del(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (4*(m1sq - m2sq)*m2sq*m4**4*m6sq*B0del(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (6*(m1sq - m2sq)*m4**6*m6sq*B0del(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (6*m2**4*(m1sq - m2sq)*m4sq*m6sq*B0del(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*m2**4*(-m1sq + m2sq)*B0del(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 + (2*(m1sq - m2sq)*m4**4*B0del(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 - (2*(m1sq - m2sq)*m6**4*B0del(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 + (4*(m1sq - m2sq)*m2sq*m6sq*B0del(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 - (4*(m1sq - m2sq)*m4sq*m6sq*B0del(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 - (2*m1sq*m6**4*B0del(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m2sq*m6**4*B0del(0,0,m6sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m1**4*m6sq*B0del(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (2*m1sq*m4sq*m6sq*B0del(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (2*m2**4*m6sq*B0del(0,0,m6sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m2sq*m4sq*m6sq*B0del(0,0,m6sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m2**8*(m1sq - m2sq)*B0del(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (12*m2**4*(m1sq - m2sq)*m4**4*B0del(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (8*m2sq*(-m1sq + m2sq)*m4**6*B0del(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*(m1sq - m2sq)*m4**8*B0del(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (8*m2**6*(-m1sq + m2sq)*m4sq*B0del(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (10*m2**4*(m1sq - m2sq)*m6**4*B0del(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 - (14*(m1sq - m2sq)*m4**4*m6**4*B0del(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (4*m2sq*(-m1sq + m2sq)*m4sq*m6**4*B0del(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (10*m2sq*(-m1sq + m2sq)*m6**6*B0del(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*(m1sq - m2sq)*m4sq*m6**6*B0del(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (4*(m1sq - m2sq)*m6**8*B0del(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (6*m2**6*(-m1sq + m2sq)*m6sq*B0del(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (18*m2sq*(-m1sq + m2sq)*m4**4*m6sq*B0del(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (6*(m1sq - m2sq)*m4**6*m6sq*B0del(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (18*m2**4*(m1sq - m2sq)*m4sq*m6sq*B0del(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*m2**4*(-m1sq + m2sq)*B0del(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 - (2*(m1sq - m2sq)*m4**4*B0del(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 + (4*(m1sq - m2sq)*m2sq*m4sq*B0del(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 - (2*(m1sq - m2sq)*m6**4*B0del(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 + (4*(m1sq - m2sq)*m2sq*m6sq*B0del(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 - (8*(m1sq - m2sq)*m4sq*m6sq*B0del(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 - (2*m1sq*m4**4*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m1**4*m4sq*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (2*m1sq*m6**4*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m1**4*m6sq*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (4*m1sq*m4sq*m6sq*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (4*m1sq*m2**4*B0fin(0,0,m2sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (4*m2**6*B0fin(0,0,m2sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m1sq*m4**4*B0fin(0,0,m2sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (4*m2**4*m4sq*B0fin(0,0,m2sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m1sq*m2sq*m4sq*B0fin(0,0,m2sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m1sq*m6**4*B0fin(0,0,m2sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (4*m2**4*m6sq*B0fin(0,0,m2sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m1sq*m2sq*m6sq*B0fin(0,0,m2sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (4*m1sq*m4sq*m6sq*B0fin(0,0,m2sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (6*m2**4*(-m1sq + m2sq)*m4**4*B0fin(0,0,m2sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (6*m2sq*(-m1sq + m2sq)*m4**6*B0fin(0,0,m2sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (6*(m1sq - m2sq)*m4**8*B0fin(0,0,m2sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (6*m2**6*(m1sq - m2sq)*m4sq*B0fin(0,0,m2sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (14*m2**4*(-m1sq + m2sq)*m6**4*B0fin(0,0,m2sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (12*(m1sq - m2sq)*m4**4*m6**4*B0fin(0,0,m2sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (6*(m1sq - m2sq)*m2sq*m4sq*m6**4*B0fin(0,0,m2sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (10*(m1sq - m2sq)*m2sq*m6**6*B0fin(0,0,m2sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 - (2*(m1sq - m2sq)*m6**8*B0fin(0,0,m2sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (6*m2**6*(m1sq - m2sq)*m6sq*B0fin(0,0,m2sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (10*m2sq*(-m1sq + m2sq)*m4**4*m6sq*B0fin(0,0,m2sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 - (16*(m1sq - m2sq)*m4**6*m6sq*B0fin(0,0,m2sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (4*m2**4*(-m1sq + m2sq)*m4sq*m6sq*B0fin(0,0,m2sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*m2**4*(m1sq - m2sq)*B0fin(0,0,m2sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 - (6*(m1sq - m2sq)*m4**4*B0fin(0,0,m2sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 + (4*m2sq*(-m1sq + m2sq)*m4sq*B0fin(0,0,m2sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 + (2*(m1sq - m2sq)*m6**4*B0fin(0,0,m2sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 + (4*m2sq*(-m1sq + m2sq)*m6sq*B0fin(0,0,m2sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 + (4*(m1sq - m2sq)*m4sq*m6sq*B0fin(0,0,m2sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 + (m1**6*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (3*m1sq*m4**4*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (m4**6*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (m1**4*m4sq*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (3*m1sq*m6**4*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (3*m4sq*m6**4*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m6**6*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (4*m1sq*m2**4*B0fin(0,0,m4sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (3*m2**6*B0fin(0,0,m4sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m1sq*m4**4*B0fin(0,0,m4sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (m2sq*m4**4*B0fin(0,0,m4sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (m4**6*B0fin(0,0,m4sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (3*m2**4*m4sq*B0fin(0,0,m4sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m1sq*m2sq*m4sq*B0fin(0,0,m4sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m1sq*m6**4*B0fin(0,0,m4sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (5*m2sq*m6**4*B0fin(0,0,m4sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (3*m4sq*m6**4*B0fin(0,0,m4sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (m6**6*B0fin(0,0,m4sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (3*m1**4*m6sq*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (3*m4**4*m6sq*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (4*m1sq*m4sq*m6sq*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (m2**4*m6sq*B0fin(0,0,m4sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m1sq*m2sq*m6sq*B0fin(0,0,m4sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (3*m4**4*m6sq*B0fin(0,0,m4sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (4*m1sq*m4sq*m6sq*B0fin(0,0,m4sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (8*m2sq*m4sq*m6sq*B0fin(0,0,m4sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (4*m2**8*(m1sq - m2sq)*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (6*m2**4*(-m1sq + m2sq)*m4**4*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*(m1sq - m2sq)*m2sq*m4**6*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*(m1sq - m2sq)*m4**8*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*m2**6*(-m1sq + m2sq)*m4sq*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (24*m2**4*(m1sq - m2sq)*m6**4*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*(m1sq - m2sq)*m4**4*m6**4*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (10*(m1sq - m2sq)*m2sq*m4sq*m6**4*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (16*m2sq*(-m1sq + m2sq)*m6**6*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 - (6*(m1sq - m2sq)*m4sq*m6**6*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (4*(m1sq - m2sq)*m6**8*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (16*m2**6*(-m1sq + m2sq)*m6sq*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (4*m2sq*(-m1sq + m2sq)*m4**4*m6sq*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 - (2*(m1sq - m2sq)*m4**6*m6sq*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*m2**4*(-m1sq + m2sq)*m4sq*m6sq*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*m2**4*(m1sq - m2sq)*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 - (6*(m1sq - m2sq)*m4**4*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 + (4*m2sq*(-m1sq + m2sq)*m4sq*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 - (4*(m1sq - m2sq)*m6**4*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 + (2*(m1sq - m2sq)*m2sq*m6sq*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 + (6*(m1sq - m2sq)*m4sq*m6sq*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 + (m1**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m1sq*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (m1sq*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (2*m1**4*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m2**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (m2sq*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (m2sq*m6**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m2**4*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m2**8*(m1sq - m2sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (8*m2**4*(-m1sq + m2sq)*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (8*(m1sq - m2sq)*m2sq*m4**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 - (2*(m1sq - m2sq)*m4**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (6*m2**4*(m1sq - m2sq)*m6**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*(m1sq - m2sq)*m4**4*m6**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*m2sq*(-m1sq + m2sq)*m6**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 - (2*(m1sq - m2sq)*m4sq*m6**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (6*m2**6*(-m1sq + m2sq)*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (10*(m1sq - m2sq)*m2sq*m4**4*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*(m1sq - m2sq)*m4**6*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*m2**4*(m1sq - m2sq)*m4sq*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (m2**4*(-m1sq + m2sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 + (3*(m1sq - m2sq)*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 + (2*m2sq*(-m1sq + m2sq)*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 - ((m1sq - m2sq)*m6**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 + (2*(m1sq - m2sq)*m2sq*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 + (2*(m1sq - m2sq)*m4sq*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 + (m1**6*B0fin(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (3*m1sq*m4**4*B0fin(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m4**6*B0fin(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (3*m1**4*m4sq*B0fin(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (3*m1sq*m6**4*B0fin(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (3*m4sq*m6**4*B0fin(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (m6**6*B0fin(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m2**6*B0fin(0,0,m6sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (3*m2sq*m4**4*B0fin(0,0,m6sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (m4**6*B0fin(0,0,m6sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (3*m2**4*m4sq*B0fin(0,0,m6sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (3*m2sq*m6**4*B0fin(0,0,m6sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (3*m4sq*m6**4*B0fin(0,0,m6sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (m6**6*B0fin(0,0,m6sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (m1**4*m6sq*B0fin(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (3*m4**4*m6sq*B0fin(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (4*m1sq*m4sq*m6sq*B0fin(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m2**4*m6sq*B0fin(0,0,m6sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (3*m4**4*m6sq*B0fin(0,0,m6sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (4*m2sq*m4sq*m6sq*B0fin(0,0,m6sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m2**8*(-m1sq + m2sq)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (12*m2**4*(-m1sq + m2sq)*m4**4*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (8*(m1sq - m2sq)*m2sq*m4**6*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 - (2*(m1sq - m2sq)*m4**8*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (8*m2**6*(m1sq - m2sq)*m4sq*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (14*m2**4*(-m1sq + m2sq)*m6**4*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (10*(m1sq - m2sq)*m4**4*m6**4*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (28*(m1sq - m2sq)*m2sq*m4sq*m6**4*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (6*(m1sq - m2sq)*m2sq*m6**6*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 - (6*(m1sq - m2sq)*m4sq*m6**6*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (10*m2**6*(m1sq - m2sq)*m6sq*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (14*(m1sq - m2sq)*m2sq*m4**4*m6sq*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 - (2*(m1sq - m2sq)*m4**6*m6sq*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (22*m2**4*(-m1sq + m2sq)*m4sq*m6sq*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (4*m2**4*(m1sq - m2sq)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 + (4*(m1sq - m2sq)*m4**4*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 + (8*m2sq*(-m1sq + m2sq)*m4sq*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 - (2*(m1sq - m2sq)*m6**4*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 + (2*m2sq*(-m1sq + m2sq)*m6sq*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 + (10*(m1sq - m2sq)*m4sq*m6sq*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 + (m1**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (m1sq*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (2*m1**4*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m1sq*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m2**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (m2sq*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m2**4*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (m2sq*m6**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m2**8*(m1sq - m2sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (6*m2**4*(m1sq - m2sq)*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*m2sq*(-m1sq + m2sq)*m4**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (6*m2**6*(-m1sq + m2sq)*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (4*m2**4*(m1sq - m2sq)*m6**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 - (2*(m1sq - m2sq)*m4**4*m6**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*(m1sq - m2sq)*m2sq*m4sq*m6**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (4*m2sq*(-m1sq + m2sq)*m6**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 - (2*(m1sq - m2sq)*m4sq*m6**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*(m1sq - m2sq)*m6**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (4*m2**6*(-m1sq + m2sq)*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (12*m2sq*(-m1sq + m2sq)*m4**4*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*(m1sq - m2sq)*m4**6*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (14*m2**4*(m1sq - m2sq)*m4sq*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (m2**4*(-m1sq + m2sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 - ((m1sq - m2sq)*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 + (2*(m1sq - m2sq)*m2sq*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 - ((m1sq - m2sq)*m6**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 + (2*(m1sq - m2sq)*m2sq*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 - (2*(m1sq - m2sq)*m4sq*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 - (m1**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m1sq*m4**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m1**4*m4sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m1sq*m6**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (m2**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (m2sq*m4**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (2*m2**4*m4sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (m2sq*m6**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m1**4*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (2*m1sq*m4sq*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (2*m2**4*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m2sq*m4sq*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (6*m2**4*(m1sq - m2sq)*m4**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (6*m2sq*(-m1sq + m2sq)*m4**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*(m1sq - m2sq)*m4**8*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*m2**6*(-m1sq + m2sq)*m4sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (6*m2**4*(m1sq - m2sq)*m6**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 - (12*(m1sq - m2sq)*m4**4*m6**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (6*m2sq*(-m1sq + m2sq)*m4sq*m6**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (6*m2sq*(-m1sq + m2sq)*m6**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (4*(m1sq - m2sq)*m4sq*m6**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*(m1sq - m2sq)*m6**8*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*m2**6*(-m1sq + m2sq)*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (6*m2sq*(-m1sq + m2sq)*m4**4*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (4*(m1sq - m2sq)*m4**6*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (4*m2**4*(m1sq - m2sq)*m4sq*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (m2**4*(-m1sq + m2sq)*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 - ((m1sq - m2sq)*m4**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 + (2*(m1sq - m2sq)*m2sq*m4sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 - ((m1sq - m2sq)*m6**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 + (2*(m1sq - m2sq)*m2sq*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 - (6*(m1sq - m2sq)*m4sq*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**2 - (2*m1**4*T134fin(m6,m4,m1,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m1sq*m4sq*T134fin(m6,m4,m1,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m1sq*m6sq*T134fin(m6,m4,m1,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m2**4*T134fin(m6,m4,m2,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (2*m2sq*m4sq*T134fin(m6,m4,m2,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (2*m2sq*m6sq*T134fin(m6,m4,m2,mudim))/((m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m2**6*(-m1sq + m2sq)*T134fin(m6,m4,m2,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*(m1sq - m2sq)*m2sq*m4**4*T134fin(m6,m4,m2,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 - (2*(m1sq - m2sq)*m4**6*T134fin(m6,m4,m2,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*m2**4*(m1sq - m2sq)*m4sq*T134fin(m6,m4,m2,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*(m1sq - m2sq)*m2sq*m6**4*T134fin(m6,m4,m2,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*(m1sq - m2sq)*m4sq*m6**4*T134fin(m6,m4,m2,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 - (2*(m1sq - m2sq)*m6**6*T134fin(m6,m4,m2,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*m2**4*(m1sq - m2sq)*m6sq*T134fin(m6,m4,m2,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (2*(m1sq - m2sq)*m4**4*m6sq*T134fin(m6,m4,m2,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3 + (12*m2sq*(-m1sq + m2sq)*m4sq*m6sq*T134fin(m6,m4,m2,mudim))/(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))**3)/(m1sq - m2sq)**2
		def eval_193():
			return ((-2*m1**4*m3sq)/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (6*m1sq*m4**4)/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (4*m3sq*m4**4)/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m1**4*m4sq)/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (2*m1sq*m3sq*m4sq)/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (6*m1sq*m6**4)/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (4*m3sq*m6**4)/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m3**6)/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (2*m3sq*m4**4)/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (2*m3sq*m6**4)/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (6*m1**4*m6sq)/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (6*m1sq*m3sq*m6sq)/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (4*m1sq*m4sq*m6sq)/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (8*m3sq*m4sq*m6sq)/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (4*m3sq*m4sq*m6sq)/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (m1**8*(-m1sq + m3sq))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (2*m1sq*(m1sq - m3sq)*m4**6)/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + ((m1sq - m3sq)*m4**8)/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (2*m1**6*(m1sq - m3sq)*m4sq)/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (10*m1**4*(m1sq - m3sq)*m6**4)/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (8*(m1sq - m3sq)*m4**4*m6**4)/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (2*m1sq*(m1sq - m3sq)*m4sq*m6**4)/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (4*m1sq*(m1sq - m3sq)*m6**6)/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (2*(m1sq - m3sq)*m4sq*m6**6)/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - ((m1sq - m3sq)*m6**8)/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (4*m1**6*(m1sq - m3sq)*m6sq)/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (24*m1sq*(m1sq - m3sq)*m4**4*m6sq)/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (6*(m1sq - m3sq)*m4**6*m6sq)/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (14*m1**4*(m1sq - m3sq)*m4sq*m6sq)/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (-m1**6 + m1**4*m3sq)/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 - (5*(m1sq - m3sq)*m4**4)/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 - (10*m1sq*(m1sq - m3sq)*m4sq)/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 - (3*(m1sq - m3sq)*m6**4)/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 + (4*m1sq*(m1sq - m3sq)*m6sq)/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 + (4*(m1sq - m3sq)*m4sq*m6sq)/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 - (2*m1**6*B0del(0,0,m1sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m1**4*m4sq*B0del(0,0,m1sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m1**4*m6sq*B0del(0,0,m1sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (4*m1**8*(m1sq - m3sq)*B0del(0,0,m1sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (2*m1**4*(m1sq - m3sq)*m4**4*B0del(0,0,m1sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (6*m1sq*(m1sq - m3sq)*m4**6*B0del(0,0,m1sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (2*(m1sq - m3sq)*m4**8*B0del(0,0,m1sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (6*m1**6*(m1sq - m3sq)*m4sq*B0del(0,0,m1sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (10*m1**4*(m1sq - m3sq)*m6**4*B0del(0,0,m1sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (2*m1sq*(m1sq - m3sq)*m4sq*m6**4*B0del(0,0,m1sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (6*m1sq*(m1sq - m3sq)*m6**6*B0del(0,0,m1sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (4*(m1sq - m3sq)*m4sq*m6**6*B0del(0,0,m1sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (2*(m1sq - m3sq)*m6**8*B0del(0,0,m1sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (10*m1**6*(m1sq - m3sq)*m6sq*B0del(0,0,m1sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (2*m1sq*(m1sq - m3sq)*m4**4*m6sq*B0del(0,0,m1sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (4*(m1sq - m3sq)*m4**6*m6sq*B0del(0,0,m1sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (16*m1**4*(m1sq - m3sq)*m4sq*m6sq*B0del(0,0,m1sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (2*m1**4*(m1sq - m3sq)*B0del(0,0,m1sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 - (2*(m1sq - m3sq)*m4**4*B0del(0,0,m1sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 + (2*(m1sq - m3sq)*m6**4*B0del(0,0,m1sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 - (4*m1sq*(m1sq - m3sq)*m6sq*B0del(0,0,m1sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 + (2*m3**6*B0del(0,0,m3sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (2*m3**4*m4sq*B0del(0,0,m3sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (2*m3**4*m6sq*B0del(0,0,m3sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (2*m1sq*m4**4*B0del(0,0,m4sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (2*m1**4*m4sq*B0del(0,0,m4sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (2*m3sq*m4**4*B0del(0,0,m4sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (2*m3**4*m4sq*B0del(0,0,m4sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (2*m1sq*m4sq*m6sq*B0del(0,0,m4sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (2*m3sq*m4sq*m6sq*B0del(0,0,m4sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (2*m1**8*(m1sq - m3sq)*B0del(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (2*m1**4*(m1sq - m3sq)*m4**4*B0del(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (2*m1sq*(m1sq - m3sq)*m4**6*B0del(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (2*m1**6*(m1sq - m3sq)*m4sq*B0del(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (12*m1**4*(m1sq - m3sq)*m6**4*B0del(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (10*(m1sq - m3sq)*m4**4*m6**4*B0del(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (6*m1sq*(m1sq - m3sq)*m4sq*m6**4*B0del(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (8*m1sq*(m1sq - m3sq)*m6**6*B0del(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (2*(m1sq - m3sq)*m4sq*m6**6*B0del(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (2*(m1sq - m3sq)*m6**8*B0del(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (8*m1**6*(m1sq - m3sq)*m6sq*B0del(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (4*m1sq*(m1sq - m3sq)*m4**4*m6sq*B0del(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (6*(m1sq - m3sq)*m4**6*m6sq*B0del(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (6*m1**4*(m1sq - m3sq)*m4sq*m6sq*B0del(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (2*m1**4*(m1sq - m3sq)*B0del(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 - (2*(m1sq - m3sq)*m4**4*B0del(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 + (2*(m1sq - m3sq)*m6**4*B0del(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 - (4*m1sq*(m1sq - m3sq)*m6sq*B0del(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 + (4*(m1sq - m3sq)*m4sq*m6sq*B0del(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 + (2*m1sq*m6**4*B0del(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (2*m3sq*m6**4*B0del(0,0,m6sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (2*m1**4*m6sq*B0del(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m1sq*m4sq*m6sq*B0del(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m3**4*m6sq*B0del(0,0,m6sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (2*m3sq*m4sq*m6sq*B0del(0,0,m6sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (2*m1**8*(m1sq - m3sq)*B0del(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (12*m1**4*(m1sq - m3sq)*m4**4*B0del(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (8*m1sq*(m1sq - m3sq)*m4**6*B0del(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (2*(m1sq - m3sq)*m4**8*B0del(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (8*m1**6*(m1sq - m3sq)*m4sq*B0del(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (10*m1**4*(m1sq - m3sq)*m6**4*B0del(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (14*(m1sq - m3sq)*m4**4*m6**4*B0del(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (4*m1sq*(m1sq - m3sq)*m4sq*m6**4*B0del(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (10*m1sq*(m1sq - m3sq)*m6**6*B0del(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (2*(m1sq - m3sq)*m4sq*m6**6*B0del(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (4*(m1sq - m3sq)*m6**8*B0del(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (6*m1**6*(m1sq - m3sq)*m6sq*B0del(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (18*m1sq*(m1sq - m3sq)*m4**4*m6sq*B0del(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (6*(m1sq - m3sq)*m4**6*m6sq*B0del(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (18*m1**4*(m1sq - m3sq)*m4sq*m6sq*B0del(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (2*m1**4*(m1sq - m3sq)*B0del(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 + (2*(m1sq - m3sq)*m4**4*B0del(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 - (4*m1sq*(m1sq - m3sq)*m4sq*B0del(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 + (2*(m1sq - m3sq)*m6**4*B0del(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 - (4*m1sq*(m1sq - m3sq)*m6sq*B0del(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 + (8*(m1sq - m3sq)*m4sq*m6sq*B0del(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 + (4*m1**6*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (4*m1**4*m3sq*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m3sq*m4**4*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (4*m1**4*m4sq*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m1sq*m3sq*m4sq*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m3sq*m6**4*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (4*m1**4*m6sq*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m1sq*m3sq*m6sq*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (4*m3sq*m4sq*m6sq*B0fin(0,0,m1sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (6*m1**4*(m1sq - m3sq)*m4**4*B0fin(0,0,m1sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (6*m1sq*(m1sq - m3sq)*m4**6*B0fin(0,0,m1sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (6*(m1sq - m3sq)*m4**8*B0fin(0,0,m1sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (6*m1**6*(m1sq - m3sq)*m4sq*B0fin(0,0,m1sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (14*m1**4*(m1sq - m3sq)*m6**4*B0fin(0,0,m1sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (12*(m1sq - m3sq)*m4**4*m6**4*B0fin(0,0,m1sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (6*m1sq*(m1sq - m3sq)*m4sq*m6**4*B0fin(0,0,m1sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (10*m1sq*(m1sq - m3sq)*m6**6*B0fin(0,0,m1sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (2*(m1sq - m3sq)*m6**8*B0fin(0,0,m1sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (6*m1**6*(m1sq - m3sq)*m6sq*B0fin(0,0,m1sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (10*m1sq*(m1sq - m3sq)*m4**4*m6sq*B0fin(0,0,m1sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (16*(m1sq - m3sq)*m4**6*m6sq*B0fin(0,0,m1sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (4*m1**4*(m1sq - m3sq)*m4sq*m6sq*B0fin(0,0,m1sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (2*m1**4*(m1sq - m3sq)*B0fin(0,0,m1sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 + (6*(m1sq - m3sq)*m4**4*B0fin(0,0,m1sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 + (4*m1sq*(m1sq - m3sq)*m4sq*B0fin(0,0,m1sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 - (2*(m1sq - m3sq)*m6**4*B0fin(0,0,m1sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 + (4*m1sq*(m1sq - m3sq)*m6sq*B0fin(0,0,m1sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 - (4*(m1sq - m3sq)*m4sq*m6sq*B0fin(0,0,m1sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 - (2*m3sq*m4**4*B0fin(0,0,m3sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (2*m3**4*m4sq*B0fin(0,0,m3sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (2*m3sq*m6**4*B0fin(0,0,m3sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (2*m3**4*m6sq*B0fin(0,0,m3sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (4*m3sq*m4sq*m6sq*B0fin(0,0,m3sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (3*m1**6*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (4*m1**4*m3sq*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (m1sq*m4**4*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m3sq*m4**4*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m4**6*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (3*m1**4*m4sq*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m1sq*m3sq*m4sq*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (5*m1sq*m6**4*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m3sq*m6**4*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (3*m4sq*m6**4*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (m6**6*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (m3**6*B0fin(0,0,m4sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (3*m3sq*m4**4*B0fin(0,0,m4sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (m4**6*B0fin(0,0,m4sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (m3**4*m4sq*B0fin(0,0,m4sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (3*m3sq*m6**4*B0fin(0,0,m4sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (3*m4sq*m6**4*B0fin(0,0,m4sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (m6**6*B0fin(0,0,m4sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (m1**4*m6sq*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m1sq*m3sq*m6sq*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (3*m4**4*m6sq*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (8*m1sq*m4sq*m6sq*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (4*m3sq*m4sq*m6sq*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (3*m3**4*m6sq*B0fin(0,0,m4sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (3*m4**4*m6sq*B0fin(0,0,m4sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (4*m3sq*m4sq*m6sq*B0fin(0,0,m4sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (4*m1**8*(m1sq - m3sq)*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (6*m1**4*(m1sq - m3sq)*m4**4*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (2*m1sq*(m1sq - m3sq)*m4**6*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (2*(m1sq - m3sq)*m4**8*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (2*m1**6*(m1sq - m3sq)*m4sq*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (24*m1**4*(m1sq - m3sq)*m6**4*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (2*(m1sq - m3sq)*m4**4*m6**4*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (10*m1sq*(m1sq - m3sq)*m4sq*m6**4*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (16*m1sq*(m1sq - m3sq)*m6**6*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (6*(m1sq - m3sq)*m4sq*m6**6*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (4*(m1sq - m3sq)*m6**8*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (16*m1**6*(m1sq - m3sq)*m6sq*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (4*m1sq*(m1sq - m3sq)*m4**4*m6sq*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (2*(m1sq - m3sq)*m4**6*m6sq*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (2*m1**4*(m1sq - m3sq)*m4sq*m6sq*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (2*m1**4*(m1sq - m3sq)*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 + (6*(m1sq - m3sq)*m4**4*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 + (4*m1sq*(m1sq - m3sq)*m4sq*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 + (4*(m1sq - m3sq)*m6**4*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 - (2*m1sq*(m1sq - m3sq)*m6sq*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 - (6*(m1sq - m3sq)*m4sq*m6sq*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 - (m1**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (m1sq*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m1sq*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m1**4*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (2*m1**8*(m1sq - m3sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (8*m1**4*(m1sq - m3sq)*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (8*m1sq*(m1sq - m3sq)*m4**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (2*(m1sq - m3sq)*m4**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (6*m1**4*(m1sq - m3sq)*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (2*(m1sq - m3sq)*m4**4*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (2*m1sq*(m1sq - m3sq)*m6**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (2*(m1sq - m3sq)*m4sq*m6**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (6*m1**6*(m1sq - m3sq)*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (10*m1sq*(m1sq - m3sq)*m4**4*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (2*(m1sq - m3sq)*m4**6*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (2*m1**4*(m1sq - m3sq)*m4sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (m1**4*(m1sq - m3sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 - (3*(m1sq - m3sq)*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 + (2*m1sq*(m1sq - m3sq)*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 + ((m1sq - m3sq)*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 - (2*m1sq*(m1sq - m3sq)*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 - (2*(m1sq - m3sq)*m4sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 + (m3**6*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (m3sq*m4**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (m3sq*m6**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (2*m3**4*m6sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (m1**6*B0fin(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (3*m1sq*m4**4*B0fin(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (m4**6*B0fin(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (3*m1**4*m4sq*B0fin(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (3*m1sq*m6**4*B0fin(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (3*m4sq*m6**4*B0fin(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m6**6*B0fin(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (m3**6*B0fin(0,0,m6sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (3*m3sq*m4**4*B0fin(0,0,m6sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (m4**6*B0fin(0,0,m6sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (3*m3**4*m4sq*B0fin(0,0,m6sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (3*m3sq*m6**4*B0fin(0,0,m6sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (3*m4sq*m6**4*B0fin(0,0,m6sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (m6**6*B0fin(0,0,m6sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (m1**4*m6sq*B0fin(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (3*m4**4*m6sq*B0fin(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (4*m1sq*m4sq*m6sq*B0fin(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (m3**4*m6sq*B0fin(0,0,m6sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (3*m4**4*m6sq*B0fin(0,0,m6sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (4*m3sq*m4sq*m6sq*B0fin(0,0,m6sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (2*m1**8*(m1sq - m3sq)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (12*m1**4*(m1sq - m3sq)*m4**4*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (8*m1sq*(m1sq - m3sq)*m4**6*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (2*(m1sq - m3sq)*m4**8*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (8*m1**6*(m1sq - m3sq)*m4sq*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (14*m1**4*(m1sq - m3sq)*m6**4*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (10*(m1sq - m3sq)*m4**4*m6**4*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (28*m1sq*(m1sq - m3sq)*m4sq*m6**4*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (6*m1sq*(m1sq - m3sq)*m6**6*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (6*(m1sq - m3sq)*m4sq*m6**6*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (10*m1**6*(m1sq - m3sq)*m6sq*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (14*m1sq*(m1sq - m3sq)*m4**4*m6sq*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (2*(m1sq - m3sq)*m4**6*m6sq*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (22*m1**4*(m1sq - m3sq)*m4sq*m6sq*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (4*m1**4*(m1sq - m3sq)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 - (4*(m1sq - m3sq)*m4**4*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 + (8*m1sq*(m1sq - m3sq)*m4sq*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 + (2*(m1sq - m3sq)*m6**4*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 + (2*m1sq*(m1sq - m3sq)*m6sq*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 - (10*(m1sq - m3sq)*m4sq*m6sq*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 - (m1**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m1sq*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m1**4*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (m1sq*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (2*m1**8*(m1sq - m3sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (6*m1**4*(m1sq - m3sq)*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (2*m1sq*(m1sq - m3sq)*m4**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (6*m1**6*(m1sq - m3sq)*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (4*m1**4*(m1sq - m3sq)*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (2*(m1sq - m3sq)*m4**4*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (2*m1sq*(m1sq - m3sq)*m4sq*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (4*m1sq*(m1sq - m3sq)*m6**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (2*(m1sq - m3sq)*m4sq*m6**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (2*(m1sq - m3sq)*m6**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (4*m1**6*(m1sq - m3sq)*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (12*m1sq*(m1sq - m3sq)*m4**4*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (2*(m1sq - m3sq)*m4**6*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (14*m1**4*(m1sq - m3sq)*m4sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (m1**4*(m1sq - m3sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 + ((m1sq - m3sq)*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 - (2*m1sq*(m1sq - m3sq)*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 + ((m1sq - m3sq)*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 - (2*m1sq*(m1sq - m3sq)*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 + (2*(m1sq - m3sq)*m4sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 + (m3**6*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (m3sq*m4**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (2*m3**4*m4sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (m3sq*m6**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (m1**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (m1sq*m4**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (2*m1**4*m4sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (m1sq*m6**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m3**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (m3sq*m4**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (2*m3**4*m4sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (m3sq*m6**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (2*m1**4*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m1sq*m4sq*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m3**4*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (2*m3sq*m4sq*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (6*m1**4*(m1sq - m3sq)*m4**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (6*m1sq*(m1sq - m3sq)*m4**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (2*(m1sq - m3sq)*m4**8*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (2*m1**6*(m1sq - m3sq)*m4sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (6*m1**4*(m1sq - m3sq)*m6**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (12*(m1sq - m3sq)*m4**4*m6**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (6*m1sq*(m1sq - m3sq)*m4sq*m6**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (6*m1sq*(m1sq - m3sq)*m6**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (4*(m1sq - m3sq)*m4sq*m6**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (2*(m1sq - m3sq)*m6**8*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (2*m1**6*(m1sq - m3sq)*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (6*m1sq*(m1sq - m3sq)*m4**4*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (4*(m1sq - m3sq)*m4**6*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (4*m1**4*(m1sq - m3sq)*m4sq*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (m1**4*(m1sq - m3sq)*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 + ((m1sq - m3sq)*m4**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 - (2*m1sq*(m1sq - m3sq)*m4sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 + ((m1sq - m3sq)*m6**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 - (2*m1sq*(m1sq - m3sq)*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 + (6*(m1sq - m3sq)*m4sq*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**2 + (2*m1**4*T134fin(m6,m4,m1,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (2*m1sq*m4sq*T134fin(m6,m4,m1,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (2*m1sq*m6sq*T134fin(m6,m4,m1,mudim))/((m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m1**6*(m1sq - m3sq)*T134fin(m6,m4,m1,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (2*m1sq*(m1sq - m3sq)*m4**4*T134fin(m6,m4,m1,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (2*(m1sq - m3sq)*m4**6*T134fin(m6,m4,m1,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (2*m1**4*(m1sq - m3sq)*m4sq*T134fin(m6,m4,m1,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (2*m1sq*(m1sq - m3sq)*m6**4*T134fin(m6,m4,m1,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (2*(m1sq - m3sq)*m4sq*m6**4*T134fin(m6,m4,m1,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (2*(m1sq - m3sq)*m6**6*T134fin(m6,m4,m1,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (2*m1**4*(m1sq - m3sq)*m6sq*T134fin(m6,m4,m1,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (2*(m1sq - m3sq)*m4**4*m6sq*T134fin(m6,m4,m1,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 + (12*m1sq*(m1sq - m3sq)*m4sq*m6sq*T134fin(m6,m4,m1,mudim))/(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))**3 - (2*m3**4*T134fin(m6,m4,m3,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (2*m3sq*m4sq*T134fin(m6,m4,m3,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (2*m3sq*m6sq*T134fin(m6,m4,m3,mudim))/((m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2))/(m1sq - m3sq)**2
		def eval_194():
			return (m1**10*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3 + 6*m1**6*m5**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3 + 6*m1**4*m5**6*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3 - 7*m1sq*m5**8*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3 + m5**10*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3 - 7*m1**8*m5sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3 + 10*m1**6*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**4*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3 + 10*m1sq*m5**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**4*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3 + 10*m5**6*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**4*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3 + 10*m1**4*m5sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**4*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3 - 10*m1**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**6*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3 - 10*m5**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**6*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3 - 4*m1sq*m5sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**6*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3 + 5*m1sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**8*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3 + 5*m5sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**8*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3 - (m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**10*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3 - m1**10*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3 - 6*m1**6*m4**4*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3 - 6*m1**4*m4**6*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3 + 7*m1sq*m4**8*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3 - m4**10*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3 + 7*m1**8*m4sq*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3 - 10*m1**6*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**4*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3 - 10*m1sq*m4**4*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**4*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3 - 10*m4**6*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**4*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3 - 10*m1**4*m4sq*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**4*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3 + 10*m1**4*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**6*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3 + 10*m4**4*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**6*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3 + 4*m1sq*m4sq*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**6*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3 - 5*m1sq*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**8*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3 - 5*m4sq*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**8*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3 + (m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**10*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3 - 5*m1**8*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m6sq + 2*m1**4*m5**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m6sq - 4*m1sq*m5**6*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m6sq - 5*m5**8*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m6sq - 4*m1**6*m5sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m6sq + 5*m1**8*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*m6sq - 2*m1**4*m4**4*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*m6sq + 4*m1sq*m4**6*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*m6sq + 5*m4**8*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*m6sq + 4*m1**6*m4sq*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*m6sq + 8*m1**6*m5**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0del(0,0,m1sq,mudim) - 4*m1**4*m5**6*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0del(0,0,m1sq,mudim) - 4*m1**8*m5sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0del(0,0,m1sq,mudim) + 8*m1**4*m5sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**4*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0del(0,0,m1sq,mudim) - 8*m1**6*m4**4*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0del(0,0,m1sq,mudim) + 4*m1**4*m4**6*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0del(0,0,m1sq,mudim) + 4*m1**8*m4sq*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0del(0,0,m1sq,mudim) - 8*m1**4*m4sq*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**4*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0del(0,0,m1sq,mudim) - 4*m1**4*m5**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m6sq*B0del(0,0,m1sq,mudim) - 4*m1**6*m5sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m6sq*B0del(0,0,m1sq,mudim) + 4*m1**4*m4**4*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*m6sq*B0del(0,0,m1sq,mudim) + 4*m1**6*m4sq*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*m6sq*B0del(0,0,m1sq,mudim) + 4*m1**6*m4**4*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0del(0,0,m4sq,mudim) - 8*m1**4*m4**6*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0del(0,0,m4sq,mudim) + 4*m1sq*m4**8*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0del(0,0,m4sq,mudim) - 8*m1sq*m4**4*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**4*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0del(0,0,m4sq,mudim) + 4*m1**4*m4**4*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*m6sq*B0del(0,0,m4sq,mudim) + 4*m1sq*m4**6*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*m6sq*B0del(0,0,m4sq,mudim) - 4*m1**6*m5**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0del(0,0,m5sq,mudim) + 8*m1**4*m5**6*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0del(0,0,m5sq,mudim) - 4*m1sq*m5**8*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0del(0,0,m5sq,mudim) + 8*m1sq*m5**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**4*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0del(0,0,m5sq,mudim) - 4*m1**4*m5**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m6sq*B0del(0,0,m5sq,mudim) - 4*m1sq*m5**6*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m6sq*B0del(0,0,m5sq,mudim) - 4*m1sq*m5**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**4*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0del(0,0,m6sq,mudim) - 4*m1**4*m5sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**4*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0del(0,0,m6sq,mudim) + 8*m1sq*m5sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**6*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0del(0,0,m6sq,mudim) + 4*m1sq*m4**4*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**4*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0del(0,0,m6sq,mudim) + 4*m1**4*m4sq*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**4*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0del(0,0,m6sq,mudim) - 8*m1sq*m4sq*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**6*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0del(0,0,m6sq,mudim) + 8*m1**4*m5**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m6sq*B0del(0,0,m6sq,mudim) - 4*m1sq*m5**6*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m6sq*B0del(0,0,m6sq,mudim) - 4*m1**6*m5sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m6sq*B0del(0,0,m6sq,mudim) - 8*m1**4*m4**4*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*m6sq*B0del(0,0,m6sq,mudim) + 4*m1sq*m4**6*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*m6sq*B0del(0,0,m6sq,mudim) + 4*m1**6*m4sq*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*m6sq*B0del(0,0,m6sq,mudim) + m1**10*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m1sq,mudim) - 4*m1**6*m5**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m1sq,mudim) + 10*m1**4*m5**6*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m1sq,mudim) - 5*m1sq*m5**8*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m1sq,mudim) - 2*m1**8*m5sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m1sq,mudim) + 6*m1**6*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**4*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m1sq,mudim) - 12*m1sq*m5**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**4*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m1sq,mudim) + 6*m1**4*m5sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**4*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m1sq,mudim) - 4*m1**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**6*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m1sq,mudim) + 2*m1sq*m5sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**6*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m1sq,mudim) + m1sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**8*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m1sq,mudim) - m1**10*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m1sq,mudim) + 4*m1**6*m4**4*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m1sq,mudim) - 10*m1**4*m4**6*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m1sq,mudim) + 5*m1sq*m4**8*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m1sq,mudim) + 2*m1**8*m4sq*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m1sq,mudim) - 6*m1**6*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**4*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m1sq,mudim) + 12*m1sq*m4**4*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**4*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m1sq,mudim) - 6*m1**4*m4sq*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**4*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m1sq,mudim) + 4*m1**4*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**6*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m1sq,mudim) - 2*m1sq*m4sq*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**6*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m1sq,mudim) - m1sq*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**8*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m1sq,mudim) - 4*m1**8*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m6sq*B0fin(0,0,m1sq,mudim) - 12*m1**4*m5**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m6sq*B0fin(0,0,m1sq,mudim) + 14*m1sq*m5**6*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m6sq*B0fin(0,0,m1sq,mudim) - 6*m1**6*m5sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m6sq*B0fin(0,0,m1sq,mudim) + 4*m1**8*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*m6sq*B0fin(0,0,m1sq,mudim) + 12*m1**4*m4**4*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*m6sq*B0fin(0,0,m1sq,mudim) - 14*m1sq*m4**6*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*m6sq*B0fin(0,0,m1sq,mudim) + 6*m1**6*m4sq*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*m6sq*B0fin(0,0,m1sq,mudim) - 10*m1**6*m4**4*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m4sq,mudim) + 4*m1**4*m4**6*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m4sq,mudim) + 2*m1sq*m4**8*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m4sq,mudim) - m4**10*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m4sq,mudim) + 5*m1**8*m4sq*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m4sq,mudim) - 6*m1sq*m4**4*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**4*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m4sq,mudim) - 6*m4**6*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**4*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m4sq,mudim) + 12*m1**4*m4sq*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**4*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m4sq,mudim) + 4*m4**4*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**6*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m4sq,mudim) - 2*m1sq*m4sq*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**6*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m4sq,mudim) - m4sq*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**8*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m4sq,mudim) + 12*m1**4*m4**4*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*m6sq*B0fin(0,0,m4sq,mudim) + 6*m1sq*m4**6*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*m6sq*B0fin(0,0,m4sq,mudim) + 4*m4**8*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*m6sq*B0fin(0,0,m4sq,mudim) - 14*m1**6*m4sq*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*m6sq*B0fin(0,0,m4sq,mudim) - 2*m1**6*m4**4*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 2*m1**4*m4**6*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 2*m1sq*m4**8*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 2*m1**8*m4sq*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 6*m1sq*m4**4*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**4*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 6*m1**4*m4sq*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**4*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 4*m1sq*m4sq*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**6*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 8*m1**4*m4**4*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 10*m1**6*m5**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m5sq,mudim) - 4*m1**4*m5**6*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m5sq,mudim) - 2*m1sq*m5**8*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m5sq,mudim) + m5**10*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m5sq,mudim) - 5*m1**8*m5sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m5sq,mudim) + 6*m1sq*m5**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**4*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m5sq,mudim) + 6*m5**6*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**4*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m5sq,mudim) - 12*m1**4*m5sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**4*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m5sq,mudim) - 4*m5**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**6*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m5sq,mudim) + 2*m1sq*m5sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**6*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m5sq,mudim) + m5sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**8*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m5sq,mudim) - 12*m1**4*m5**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m6sq*B0fin(0,0,m5sq,mudim) - 6*m1sq*m5**6*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m6sq*B0fin(0,0,m5sq,mudim) - 4*m5**8*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m6sq*B0fin(0,0,m5sq,mudim) + 14*m1**6*m5sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m6sq*B0fin(0,0,m5sq,mudim) + 2*m1**6*m5**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m1**4*m5**6*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m1sq*m5**8*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m1**8*m5sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 6*m1sq*m5**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**4*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 6*m1**4*m5sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**4*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 4*m1sq*m5sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**6*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 8*m1**4*m5**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - m1**10*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m6sq,mudim) - 2*m1**6*m5**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m6sq,mudim) - 2*m1**4*m5**6*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m6sq,mudim) + 3*m1sq*m5**8*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m6sq,mudim) - m5**10*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m6sq,mudim) + 3*m1**8*m5sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m6sq,mudim) - 6*m1**6*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**4*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m6sq,mudim) + 10*m1sq*m5**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**4*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m6sq,mudim) - 6*m5**6*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**4*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m6sq,mudim) + 10*m1**4*m5sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**4*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m6sq,mudim) + 4*m1**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**6*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m6sq,mudim) + 4*m5**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**6*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m6sq,mudim) + 4*m1sq*m5sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**6*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m6sq,mudim) - m1sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**8*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m6sq,mudim) - m5sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**8*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m6sq,mudim) + m1**10*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m6sq,mudim) + 2*m1**6*m4**4*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m6sq,mudim) + 2*m1**4*m4**6*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m6sq,mudim) - 3*m1sq*m4**8*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m6sq,mudim) + m4**10*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m6sq,mudim) - 3*m1**8*m4sq*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m6sq,mudim) + 6*m1**6*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**4*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m6sq,mudim) - 10*m1sq*m4**4*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**4*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m6sq,mudim) + 6*m4**6*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**4*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m6sq,mudim) - 10*m1**4*m4sq*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**4*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m6sq,mudim) - 4*m1**4*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**6*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m6sq,mudim) - 4*m4**4*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**6*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m6sq,mudim) - 4*m1sq*m4sq*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**6*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m6sq,mudim) + m1sq*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**8*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m6sq,mudim) + m4sq*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**8*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m6sq,mudim) + 4*m1**8*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m6sq*B0fin(0,0,m6sq,mudim) + 24*m1**4*m5**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m6sq*B0fin(0,0,m6sq,mudim) - 16*m1sq*m5**6*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m6sq*B0fin(0,0,m6sq,mudim) + 4*m5**8*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m6sq*B0fin(0,0,m6sq,mudim) - 16*m1**6*m5sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m6sq*B0fin(0,0,m6sq,mudim) - 4*m1**8*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*m6sq*B0fin(0,0,m6sq,mudim) - 24*m1**4*m4**4*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*m6sq*B0fin(0,0,m6sq,mudim) + 16*m1sq*m4**6*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*m6sq*B0fin(0,0,m6sq,mudim) - 4*m4**8*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*m6sq*B0fin(0,0,m6sq,mudim) + 16*m1**6*m4sq*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*m6sq*B0fin(0,0,m6sq,mudim) + 6*m1**6*m5**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 6*m1**4*m5**6*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m1sq*m5**8*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m1**8*m5sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 6*m1sq*m5**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**4*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m1**4*m5sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**4*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 4*m1sq*m5sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**6*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 6*m1**6*m4**4*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 6*m1**4*m4**6*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m1sq*m4**8*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m1**8*m4sq*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 6*m1sq*m4**4*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**4*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m1**4*m4sq*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**4*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m1sq*m4sq*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**6*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 4*m1**4*m5**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m1**6*m5sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m1**4*m4**4*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 4*m1**6*m4sq*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 6*m1**6*m4**4*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) - 6*m1**4*m4**6*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m1sq*m4**8*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m1**8*m4sq*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m1sq*m4**4*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**4*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) + 6*m1**4*m4sq*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**4*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m1sq*m4sq*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**6*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m1**4*m4**4*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) + 4*m1sq*m4**6*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) - 6*m1**6*m5**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) + 6*m1**4*m5**6*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m1sq*m5**8*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m1**8*m5sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m1sq*m5**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**4*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) - 6*m1**4*m5sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**4*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) + 4*m1sq*m5sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**6*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) + 4*m1**4*m5**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m6sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m1sq*m5**6*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m6sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim) + 8*m1**4*m4**4*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*T134fin(m6,m4,m1,mudim) - 4*m1sq*m4**6*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*T134fin(m6,m4,m1,mudim) - 4*m1**6*m4sq*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*T134fin(m6,m4,m1,mudim) + 8*m1sq*m4sq*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*m6**4*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*T134fin(m6,m4,m1,mudim) - 4*m1sq*m4**4*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*m6sq*T134fin(m6,m4,m1,mudim) - 4*m1**4*m4sq*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3*m6sq*T134fin(m6,m4,m1,mudim) - 8*m1**4*m5**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*T134fin(m6,m5,m1,mudim) + 4*m1sq*m5**6*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*T134fin(m6,m5,m1,mudim) + 4*m1**6*m5sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*T134fin(m6,m5,m1,mudim) - 8*m1sq*m5sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*m6**4*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*T134fin(m6,m5,m1,mudim) + 4*m1sq*m5**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m6sq*T134fin(m6,m5,m1,mudim) + 4*m1**4*m5sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m6sq*T134fin(m6,m5,m1,mudim))/(2.*m1**2*(m4sq - m5sq)*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m5 - m6)**3*(m1 + m5 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*(m1 - m5 + m6)**3*(m1 + m5 + m6)**3)
		def eval_195():
			return (10*m1**6*m4**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3 - 12*m1**4*m4**6*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3 - 3*m1**8*m4sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3 - 2*m1**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**6 - 10*m1**6*m4**4*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3 + 12*m1**4*m4**6*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3 + 3*m1**8*m4sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3 + 2*m1**4*m6**6*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3 + 16*m1sq*m4sq*m6**4*(m4sq - m6sq)*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3 - 6*m1sq*m4**4*(m4sq - m6sq)**2*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3 + m4sq*(m4sq - m6sq)**4*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3 - m1**8*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3 + 2*m1**4*m4**4*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3 - 14*m1**6*m4sq*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3 + 6*m1sq*m4sq*(m4sq - m6sq)**2*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3 - (m4sq - m6sq)**4*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3 - 16*m1**4*m6**4*(m1sq + m4sq + m6sq)*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3 + 8*m1**6*m6sq*(m1sq + m4sq + m6sq)*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3 + 8*m1**4*m4sq*m6sq*(m1sq + m4sq + m6sq)*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3 - 16*m1sq*m4sq*(m4sq - m6sq)*m6sq*(m1sq + m4sq + m6sq)*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3 + 8*m1sq*m6**4*(-m4sq + m6sq)*(m1sq + m4sq + m6sq)*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3 - 16*m1sq*m4sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**4*(m4sq - m7sq) + 6*m1sq*m4**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*(m4sq - m7sq)**2 - m4sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*(m4sq - m7sq)**4 + m1**8*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7sq - 2*m1**4*m4**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7sq + 14*m1**6*m4sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7sq - 6*m1sq*m4sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*(m4sq - m7sq)**2*m7sq + (m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*(m4sq - m7sq)**4*m7sq + 16*m1**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**4*(m1sq + m4sq + m7sq) + 8*m1sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**4*(m4sq - m7sq)*(m1sq + m4sq + m7sq) - 8*m1**6*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7sq*(m1sq + m4sq + m7sq) - 8*m1**4*m4sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7sq*(m1sq + m4sq + m7sq) + 16*m1sq*m4sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*(m4sq - m7sq)*m7sq*(m1sq + m4sq + m7sq) + 8*m1**6*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**4*B0del(0,0,m1sq,mudim) - 4*m1**4*m4sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**4*B0del(0,0,m1sq,mudim) - 4*m1**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**6*B0del(0,0,m1sq,mudim) - 8*m1**6*m6**4*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0del(0,0,m1sq,mudim) + 4*m1**4*m4sq*m6**4*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0del(0,0,m1sq,mudim) + 4*m1**4*m6**6*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0del(0,0,m1sq,mudim) + 4*m1**8*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0del(0,0,m1sq,mudim) - 8*m1**4*m4**4*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0del(0,0,m1sq,mudim) + 4*m1**6*m4sq*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0del(0,0,m1sq,mudim) - 4*m1**8*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7sq*B0del(0,0,m1sq,mudim) + 8*m1**4*m4**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7sq*B0del(0,0,m1sq,mudim) - 4*m1**6*m4sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7sq*B0del(0,0,m1sq,mudim) + 8*m1**4*m4sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**4*B0del(0,0,m4sq,mudim) - 8*m1**4*m4sq*m6**4*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0del(0,0,m4sq,mudim) - 6*m1sq*m4sq*m6**4*(m4sq - m6sq)*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0del(0,0,m4sq,mudim) - 2*m1sq*m6**4*(m4sq - m6sq)**2*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0del(0,0,m4sq,mudim) + 4*m1**4*m4**4*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0del(0,0,m4sq,mudim) + 4*m1**6*m4sq*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0del(0,0,m4sq,mudim) - 4*m1sq*m4**4*(m4sq - m6sq)*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0del(0,0,m4sq,mudim) - 4*m1sq*m4sq*(m4sq - m6sq)**2*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0del(0,0,m4sq,mudim) + 2*m1sq*m6**6*(-m4sq + m6sq)*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0del(0,0,m4sq,mudim) + 6*m1sq*m4sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**4*(m4sq - m7sq)*B0del(0,0,m4sq,mudim) + 2*m1sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**6*(m4sq - m7sq)*B0del(0,0,m4sq,mudim) + 2*m1sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**4*(m4sq - m7sq)**2*B0del(0,0,m4sq,mudim) - 4*m1**4*m4**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7sq*B0del(0,0,m4sq,mudim) - 4*m1**6*m4sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7sq*B0del(0,0,m4sq,mudim) + 4*m1sq*m4**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*(m4sq - m7sq)*m7sq*B0del(0,0,m4sq,mudim) + 4*m1sq*m4sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*(m4sq - m7sq)**2*m7sq*B0del(0,0,m4sq,mudim) + 4*m1**6*m6**4*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0del(0,0,m6sq,mudim) + 4*m1**4*m4sq*m6**4*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0del(0,0,m6sq,mudim) - 8*m1**4*m6**6*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0del(0,0,m6sq,mudim) - 6*m1sq*m4sq*m6**4*(m4sq - m6sq)*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0del(0,0,m6sq,mudim) + 2*m1sq*m6**4*(m4sq - m6sq)**2*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0del(0,0,m6sq,mudim) - 4*m1sq*m4**4*(m4sq - m6sq)*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0del(0,0,m6sq,mudim) + 4*m1sq*m4sq*(m4sq - m6sq)**2*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0del(0,0,m6sq,mudim) + 2*m1sq*m6**6*(-m4sq + m6sq)*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0del(0,0,m6sq,mudim) - 4*m1**6*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**4*B0del(0,0,m7sq,mudim) - 4*m1**4*m4sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**4*B0del(0,0,m7sq,mudim) + 8*m1**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**6*B0del(0,0,m7sq,mudim) + 6*m1sq*m4sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**4*(m4sq - m7sq)*B0del(0,0,m7sq,mudim) + 2*m1sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**6*(m4sq - m7sq)*B0del(0,0,m7sq,mudim) - 2*m1sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**4*(m4sq - m7sq)**2*B0del(0,0,m7sq,mudim) + 4*m1sq*m4**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*(m4sq - m7sq)*m7sq*B0del(0,0,m7sq,mudim) - 4*m1sq*m4sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*(m4sq - m7sq)**2*m7sq*B0del(0,0,m7sq,mudim) - m1**10*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m1sq,mudim) - 2*m1**4*m4**6*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m1sq,mudim) + 2*m1**8*m4sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m1sq,mudim) - 2*m1**6*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**4*B0fin(0,0,m1sq,mudim) - 14*m1**4*m4sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**4*B0fin(0,0,m1sq,mudim) + 8*m1**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**6*B0fin(0,0,m1sq,mudim) + m1**10*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m1sq,mudim) + 2*m1**4*m4**6*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m1sq,mudim) - 2*m1**8*m4sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m1sq,mudim) + 2*m1**6*m6**4*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m1sq,mudim) + 14*m1**4*m4sq*m6**4*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m1sq,mudim) - 8*m1**4*m6**6*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m1sq,mudim) - m1sq*m4**4*(m4sq - m6sq)**2*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m1sq,mudim) + 5*m1sq*m6**4*(m4sq - m6sq)**2*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m1sq,mudim) - 8*m1**4*m4**4*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m1sq,mudim) + 10*m1**6*m4sq*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m1sq,mudim) - 4*m1sq*m4sq*(m4sq - m6sq)**2*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m1sq,mudim) + m1sq*m4**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*(m4sq - m7sq)**2*B0fin(0,0,m1sq,mudim) - 5*m1sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**4*(m4sq - m7sq)**2*B0fin(0,0,m1sq,mudim) + 8*m1**4*m4**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7sq*B0fin(0,0,m1sq,mudim) - 10*m1**6*m4sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7sq*B0fin(0,0,m1sq,mudim) + 4*m1sq*m4sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*(m4sq - m7sq)**2*m7sq*B0fin(0,0,m1sq,mudim) - m1**10*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m4sq,mudim) - 2*m1**4*m4**6*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m4sq,mudim) + 2*m1**8*m4sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*B0fin(0,0,m4sq,mudim) - 2*m1**6*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**4*B0fin(0,0,m4sq,mudim) + 26*m1**4*m4sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**4*B0fin(0,0,m4sq,mudim) - 2*m1**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**6*B0fin(0,0,m4sq,mudim) + m1**10*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m4sq,mudim) + 2*m1**4*m4**6*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m4sq,mudim) - 2*m1**8*m4sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m4sq,mudim) + 2*m1**6*m6**4*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m4sq,mudim) - 26*m1**4*m4sq*m6**4*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m4sq,mudim) + 2*m1**4*m6**6*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m4sq,mudim) - 18*m1sq*m4sq*m6**4*(m4sq - m6sq)*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m4sq,mudim) + 2*m1sq*m6**6*(m4sq - m6sq)*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m4sq,mudim) - m1sq*m4**4*(m4sq - m6sq)**2*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m4sq,mudim) - m1sq*m6**4*(m4sq - m6sq)**2*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m4sq,mudim) - 3*m1**8*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m4sq,mudim) - 6*m1**4*m4**4*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m4sq,mudim) + 14*m1**6*m4sq*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m4sq,mudim) - 4*m1sq*m4**4*(m4sq - m6sq)*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m4sq,mudim) - 4*m1sq*m4sq*(m4sq - m6sq)**2*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m4sq,mudim) + (m4sq - m6sq)**4*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m4sq,mudim) + 18*m1sq*m4sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**4*(m4sq - m7sq)*B0fin(0,0,m4sq,mudim) - 2*m1sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**6*(m4sq - m7sq)*B0fin(0,0,m4sq,mudim) + m1sq*m4**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*(m4sq - m7sq)**2*B0fin(0,0,m4sq,mudim) + m1sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**4*(m4sq - m7sq)**2*B0fin(0,0,m4sq,mudim) + 3*m1**8*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7sq*B0fin(0,0,m4sq,mudim) + 6*m1**4*m4**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7sq*B0fin(0,0,m4sq,mudim) - 14*m1**6*m4sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7sq*B0fin(0,0,m4sq,mudim) + 4*m1sq*m4**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*(m4sq - m7sq)*m7sq*B0fin(0,0,m4sq,mudim) + 4*m1sq*m4sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*(m4sq - m7sq)**2*m7sq*B0fin(0,0,m4sq,mudim) - (m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*(m4sq - m7sq)**4*m7sq*B0fin(0,0,m4sq,mudim) + 6*m1**6*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 4*m1**4*m4sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 6*m1**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 6*m1**6*m6**4*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 4*m1**4*m4sq*m6**4*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 6*m1**4*m6**6*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 2*m1sq*m6**4*(m4sq - m6sq)**2*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 2*m1**8*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 2*m1**4*m4**4*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 4*m1**6*m4sq*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 4*m1sq*m4sq*(m4sq - m6sq)**2*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 2*m1sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**4*(m4sq - m7sq)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 2*m1**8*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 2*m1**4*m4**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 4*m1**6*m4sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 4*m1sq*m4sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*(m4sq - m7sq)**2*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 12*m1**6*m6**4*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m6sq,mudim) + 16*m1**4*m4sq*m6**4*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m6sq,mudim) + 2*m1**4*m6**6*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m6sq,mudim) - 18*m1sq*m4sq*m6**4*(m4sq - m6sq)*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m6sq,mudim) + 2*m1sq*m6**6*(m4sq - m6sq)*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m6sq,mudim) + 6*m1sq*m6**4*(m4sq - m6sq)**2*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m6sq,mudim) + 7*m1**8*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m6sq,mudim) + 18*m1**4*m4**4*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m6sq,mudim) - 20*m1**6*m4sq*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m6sq,mudim) - 4*m1sq*m4**4*(m4sq - m6sq)*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m6sq,mudim) - (m4sq - m6sq)**4*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m6sq,mudim) - 2*m1**6*m6**4*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 8*m1**4*m4sq*m6**4*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m1**4*m6**6*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m1sq*m6**4*(m4sq - m6sq)**2*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m1**8*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 6*m1**4*m4**4*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 4*m1sq*m4sq*(m4sq - m6sq)**2*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 6*m1**6*m6**4*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m1**4*m4sq*m6**4*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) - 6*m1**4*m6**6*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) - 6*m1sq*m4sq*m6**4*(m4sq - m6sq)*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m1**8*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) + 6*m1**4*m4**4*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m1sq*m4**4*(m4sq - m6sq)*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m1sq*m6**6*(-m4sq + m6sq)*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) - m1**8*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*(m1sq + m4sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)) - 3*m1**4*m4**4*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*(m1sq + m4sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)) + 3*m1**6*m4sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*(m1sq + m4sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)) + m1**4*m6**4*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*(m1sq + m4sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)) + m1sq*m4**4*(m4sq - m6sq)*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*(m1sq + m4sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)) + m1**6*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*(m1sq + m4sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)) - 2*m1**4*m4sq*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*(m1sq + m4sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)) + 2*m1sq*m4sq*(m4sq - m6sq)*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*(m1sq + m4sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)) - m1sq*m6**4*(-m4sq + m6sq)*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*(m1sq + m4sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)) + 12*m1**6*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**4*B0fin(0,0,m7sq,mudim) - 16*m1**4*m4sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**4*B0fin(0,0,m7sq,mudim) - 2*m1**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**6*B0fin(0,0,m7sq,mudim) + 18*m1sq*m4sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**4*(m4sq - m7sq)*B0fin(0,0,m7sq,mudim) - 2*m1sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**6*(m4sq - m7sq)*B0fin(0,0,m7sq,mudim) - 6*m1sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**4*(m4sq - m7sq)**2*B0fin(0,0,m7sq,mudim) - 7*m1**8*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7sq*B0fin(0,0,m7sq,mudim) - 18*m1**4*m4**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7sq*B0fin(0,0,m7sq,mudim) + 20*m1**6*m4sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7sq*B0fin(0,0,m7sq,mudim) + 4*m1sq*m4**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*(m4sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim) + (m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*(m4sq - m7sq)**4*m7sq*B0fin(0,0,m7sq,mudim) + 2*m1**6*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 8*m1**4*m4sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) + 2*m1**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 2*m1sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**4*(m4sq - m7sq)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 2*m1**8*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) + 6*m1**4*m4**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 4*m1sq*m4sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*(m4sq - m7sq)**2*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim) - 6*m1**6*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) + 4*m1**4*m4sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) + 6*m1**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) + 6*m1sq*m4sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**4*(m4sq - m7sq)*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) + 2*m1sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**6*(m4sq - m7sq)*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) + 2*m1**8*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) - 6*m1**4*m4**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) + 4*m1sq*m4**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*(m4sq - m7sq)*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim) + m1**8*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)) + 3*m1**4*m4**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)) - 3*m1**6*m4sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)) - m1**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**4*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)) - m1sq*m4**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*(m4sq - m7sq)*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)) - m1sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**4*(m4sq - m7sq)*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)) - m1**6*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7sq*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)) + 2*m1**4*m4sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7sq*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)) - 2*m1sq*m4sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*(m4sq - m7sq)*m7sq*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)) + 8*m1**4*m6**4*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*T134fin(m6,m4,m1,mudim) + 4*m1sq*m6**4*(m4sq - m6sq)*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*T134fin(m6,m4,m1,mudim) - 4*m1**6*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*T134fin(m6,m4,m1,mudim) - 4*m1**4*m4sq*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*T134fin(m6,m4,m1,mudim) + 8*m1sq*m4sq*(m4sq - m6sq)*m6sq*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*T134fin(m6,m4,m1,mudim) - 8*m1**4*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**4*T134fin(m7,m4,m1,mudim) - 4*m1sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7**4*(m4sq - m7sq)*T134fin(m7,m4,m1,mudim) + 4*m1**6*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7sq*T134fin(m7,m4,m1,mudim) + 4*m1**4*m4sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*m7sq*T134fin(m7,m4,m1,mudim) - 8*m1sq*m4sq*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*(m4sq - m7sq)*m7sq*T134fin(m7,m4,m1,mudim))/(2.*m1**2*(m1 - m4 - m6)**3*(m1 + m4 - m6)**3*(m1 - m4 + m6)**3*(m1 + m4 + m6)**3*(m1 - m4 - m7)**3*(m1 + m4 - m7)**3*(m1 - m4 + m7)**3*(m1 + m4 + m7)**3*(m6sq - m7sq))
		def eval_196():
			return (2*m1**6)/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (2*m1sq*m4**4)/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (2*m1sq*m6**4)/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (2*m2**6)/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m2sq*m4**4)/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m2sq*m6**4)/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (2*m3**6)/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (2*m3sq*m4**4)/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (2*m3sq*m6**4)/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (4*m1sq*m4sq*m6sq)/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (4*m2sq*m4sq*m6sq)/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (4*m3sq*m4sq*m6sq)/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (2*m1**4*(m1sq - m4sq - m6sq)*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (2*m2**4*(m2sq - m4sq - m6sq)*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (2*m3**6*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (2*m3**4*m4sq*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (2*m3**4*m6sq*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (2*m1sq*m4**4*B0del(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m1**4*m4sq*B0del(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m2sq*m4**4*B0del(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (2*m2**4*m4sq*B0del(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m3sq*m4**4*B0del(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (2*m3**4*m4sq*B0del(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (2*m1sq*m4sq*m6sq*B0del(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m2sq*m4sq*m6sq*B0del(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m3sq*m4sq*m6sq*B0del(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (2*m1sq*m6**4*B0del(0,0,m6sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m2sq*m6**4*B0del(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m3sq*m6**4*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (2*m1**4*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (2*m1sq*m4sq*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (2*m2**4*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m2sq*m4sq*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (2*m3**4*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (2*m3sq*m4sq*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (2*m1sq*m4**4*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m1**4*m4sq*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (2*m1sq*m6**4*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m1**4*m6sq*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (4*m1sq*m4sq*m6sq*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m2sq*m4**4*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (2*m2**4*m4sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m2sq*m6**4*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (2*m2**4*m6sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (4*m2sq*m4sq*m6sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m3sq*m4**4*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (2*m3**4*m4sq*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (2*m3sq*m6**4*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (2*m3**4*m6sq*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (4*m3sq*m4sq*m6sq*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (m1**6*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (3*m1sq*m4**4*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (m4**6*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (m1**4*m4sq*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (3*m1sq*m6**4*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (3*m4sq*m6**4*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m6**6*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m2**6*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (3*m2sq*m4**4*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (m4**6*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (m2**4*m4sq*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (3*m2sq*m6**4*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (3*m4sq*m6**4*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (m6**6*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (m3**6*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (3*m3sq*m4**4*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (m4**6*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (m3**4*m4sq*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (3*m3sq*m6**4*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (3*m4sq*m6**4*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (m6**6*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (3*m1**4*m6sq*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (3*m4**4*m6sq*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (4*m1sq*m4sq*m6sq*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (3*m2**4*m6sq*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (3*m4**4*m6sq*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (4*m2sq*m4sq*m6sq*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (3*m3**4*m6sq*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (3*m4**4*m6sq*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (4*m3sq*m4sq*m6sq*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (m1**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m1sq*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (m1sq*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (2*m1**4*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m2**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (m2sq*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (m2sq*m6**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m2**4*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (m3**6*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (m3sq*m4**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (m3sq*m6**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (2*m3**4*m6sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (m1**6*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (3*m1sq*m4**4*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m4**6*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (3*m1**4*m4sq*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (3*m1sq*m6**4*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (3*m4sq*m6**4*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (m6**6*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m2**6*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (3*m2sq*m4**4*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (m4**6*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (3*m2**4*m4sq*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (3*m2sq*m6**4*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (3*m4sq*m6**4*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (m6**6*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (m3**6*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (3*m3sq*m4**4*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (m4**6*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (3*m3**4*m4sq*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (3*m3sq*m6**4*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (3*m4sq*m6**4*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (m6**6*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (m1**4*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (3*m4**4*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (4*m1sq*m4sq*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m2**4*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (3*m4**4*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (4*m2sq*m4sq*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (m3**4*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (3*m4**4*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (4*m3sq*m4sq*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (m1**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (m1sq*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (2*m1**4*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m1sq*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m2**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (m2sq*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m2**4*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (m2sq*m6**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (m3**6*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (m3sq*m4**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (2*m3**4*m4sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (m3sq*m6**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (m1**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m1sq*m4**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m1**4*m4sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m1sq*m6**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (m2**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (m2sq*m4**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (2*m2**4*m4sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (m2sq*m6**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (m3**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (m3sq*m4**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (2*m3**4*m4sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (m3sq*m6**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (2*m1**4*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (2*m1sq*m4sq*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (2*m2**4*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m2sq*m4sq*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (2*m3**4*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) + (2*m3sq*m4sq*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (2*m1**4*T134fin(m6,m4,m1,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m1sq*m4sq*T134fin(m6,m4,m1,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m1sq*m6sq*T134fin(m6,m4,m1,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m2**4*T134fin(m6,m4,m2,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (2*m2sq*m4sq*T134fin(m6,m4,m2,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (2*m2sq*m6sq*T134fin(m6,m4,m2,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m3**4*T134fin(m6,m4,m3,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (2*m3sq*m4sq*T134fin(m6,m4,m3,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2) - (2*m3sq*m6sq*T134fin(m6,m4,m3,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3 + m4 - m6)**2*(m3 - m4 + m6)**2*(-m3 + m4 + m6)**2*(m3 + m4 + m6)**2)
		def eval_197():
			return ((m2**6*(-m1sq + m2sq))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (3*m2sq*(-m1sq + m2sq)*m4**4)/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (4*m1sq*m2**4*m4sq)/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (4*m2**6*m4sq)/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (3*m2**4*(-m1sq + m2sq)*m4sq)/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (m2sq*(-m1sq + m2sq)*m6**4)/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (m2**6*(m1sq - m2sq))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (3*(m1sq - m2sq)*m2sq*m5**4)/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (4*m1sq*m2**4*m5sq)/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) - (4*m2**6*m5sq)/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (3*m2**4*(-m1sq + m2sq)*m5sq)/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (m2sq*(-m1sq + m2sq)*m6**4)/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + ((m1sq - m2sq)*(-(m5sq*m6) + m6**3)**2)/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) - (m2**4*(-m1sq + m2sq)*m6sq)/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (4*(m1sq - m2sq)*m2sq*m4sq*m6sq)/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (6*m2sq*(-m1sq + m2sq)*m4sq*m6sq)/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (m2**4*(-m1sq + m2sq)*m6sq)/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (2*(m1sq - m2sq)*m2sq*m5sq*m6sq)/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (4*(m1sq - m2sq)*m4sq*(m4sq - m6sq)*m6sq)/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + ((-m1sq + m2sq)*(m4sq - m6sq)**2*m6sq)/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (4*(m1sq - m2sq)*m5sq*(m5sq - m6sq)*m6sq)/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) - (4*m2**4*m4sq*(m4sq + m6sq))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (4*m1sq*m2sq*m4sq*(m4sq + m6sq))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m1sq*m2**4*(m2sq + m4sq + m6sq))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (2*m2**6*(m2sq + m4sq + m6sq))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (2*m1sq*m4**4*(m2sq + m4sq + m6sq))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m1sq*m6**4*(m2sq + m4sq + m6sq))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m2sq*(m4**4 - m6**4)*(m2sq + m4sq + m6sq))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (4*m2**4*m6sq*(m2sq + m4sq + m6sq))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (4*m1sq*m2sq*m6sq*(m2sq + m4sq + m6sq))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (4*m2**4*m5sq*(m5sq + m6sq))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) - (4*m1sq*m2sq*m5sq*(m5sq + m6sq))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) - (2*m1sq*m2**4*(m2sq + m5sq + m6sq))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (2*m2**6*(m2sq + m5sq + m6sq))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (2*m1sq*m5**4*(m2sq + m5sq + m6sq))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) - (2*m1sq*m6**4*(m2sq + m5sq + m6sq))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) - (2*m2sq*(m5**4 - m6**4)*(m2sq + m5sq + m6sq))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) - (4*m2**4*m6sq*(m2sq + m5sq + m6sq))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (4*m1sq*m2sq*m6sq*(m2sq + m5sq + m6sq))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + ((m1sq - m2sq)*(m4**3 - m4*m6sq)**2)/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - ((m1sq - m2sq)*(m5**3 - m5*m6sq)**2)/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (2*m1sq*m4sq*B0del(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) - (2*m1sq*m5sq*B0del(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) + (m1sq*(m1**4 + m4sq*m5sq - m6**4 - m1sq*(m4sq + m5sq - 4*m6sq))*B0del(0,0,m1sq,mudim))/((m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) - (m1sq*m6sq*(2*m1sq - m4sq - m5sq + 2*m6sq)*B0del(0,0,m1sq,mudim))/((m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) + (2*m2sq*(-m1sq + m2sq)*m4**4*B0del(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (m1sq*m2**4*m4sq*B0del(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (3*m2**6*m4sq*B0del(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (m2**4*(-m1sq + m2sq)*m4sq*B0del(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*(m1sq - m2sq)*m2sq*m5**4*B0del(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) - (m1sq*m2**4*m5sq*B0del(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (3*m2**6*m5sq*B0del(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (m2**4*(-m1sq + m2sq)*m5sq*B0del(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) - (m1sq*m4sq*(m4sq - m6sq)**2*B0del(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (m2sq*m4sq*(m4sq - m6sq)**2*B0del(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (m1sq*m5sq*(m5sq - m6sq)**2*B0del(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (m2sq*m5sq*(m5sq - m6sq)**2*B0del(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) - (2*m2sq*(-m1sq + m2sq)*m4sq*m6sq*B0del(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m2sq*(-m1sq + m2sq)*m5sq*m6sq*B0del(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (4*m2**4*m4sq*(m4sq + m6sq)*B0del(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (4*m2**4*m5sq*(m5sq + m6sq)*B0del(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + ((m1sq - m2sq)*(m4**3 - m4*m6sq)**2*B0del(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - ((m1sq - m2sq)*(m5**3 - m5*m6sq)**2*B0del(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (m2sq*m6sq*B0del(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))) - (m2sq*m6sq*B0del(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) + (m2sq*(-m2**4 - m4sq*m5sq + m6**4 + m2sq*(m4sq + m5sq - 4*m6sq))*B0del(0,0,m2sq,mudim))/((m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) + (2*(m1sq - m2sq)*m2sq*m4**4*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (m1sq*m2**4*m4sq*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (3*m2**6*m4sq*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (m2**4*(-m1sq + m2sq)*m4sq*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - ((m1sq - m2sq)*m4**4*(m4sq - m6sq)*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (m1sq*m4sq*(m4sq - m6sq)**2*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (m2sq*m4sq*(m4sq - m6sq)**2*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - ((m1sq - m2sq)*m4sq*(m4sq - m6sq)*m6sq*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (4*m2**4*m4sq*(m4sq + m6sq)*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m1sq*m4sq*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) - (m4sq*m6sq*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) + (m4sq*m6sq*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))) + ((m1sq - m2sq)*m4sq*(m4**4 + m1sq*(m2sq - m4sq) - m2sq*m4sq - m6**4 + 4*m4sq*m6sq)*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))) + (2*m2sq*(-m1sq + m2sq)*m5**4*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) - (m1sq*m2**4*m5sq*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (3*m2**6*m5sq*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (m2**4*(m1sq - m2sq)*m5sq*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + ((m1sq - m2sq)*m5**4*(m5sq - m6sq)*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (m1sq*m5sq*(m5sq - m6sq)**2*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (m2sq*m5sq*(m5sq - m6sq)**2*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + ((m1sq - m2sq)*m5sq*(m5sq - m6sq)*m6sq*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) - (4*m2**4*m5sq*(m5sq + m6sq)*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) - (2*m1sq*m5sq*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) + (m5sq*m6sq*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) - (m5sq*m6sq*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) + ((m1sq - m2sq)*m5sq*(-m5**4 + m2sq*m5sq + m1sq*(-m2sq + m5sq) + m6**4 - 4*m5sq*m6sq)*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) + (2*(m1sq - m2sq)*m2sq*m4**4*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m2sq*(-m1sq + m2sq)*m4**4*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - ((m1sq - m2sq)*m4**4*(m4sq - m6sq)*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + ((m1sq - m2sq)*m5**4*(m5sq - m6sq)*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) - (2*m2sq*(-m1sq + m2sq)*m4sq*m6sq*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m2sq*(-m1sq + m2sq)*m5sq*m6sq*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) - ((m1sq - m2sq)*m4sq*(m4sq - m6sq)*m6sq*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + ((m1sq - m2sq)*m5sq*(m5sq - m6sq)*m6sq*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + ((m1sq - m2sq)*(m4**3 - m4*m6sq)**2*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - ((m1sq - m2sq)*(m5**3 - m5*m6sq)**2*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) - (m4sq*m6sq*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) + (m2sq*m6sq*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))) + (m4sq*m6sq*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))) + (m5sq*m6sq*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) - (m1sq*m6sq*(2*m1sq - m4sq - m5sq + 2*m6sq)*B0del(0,0,m6sq,mudim))/((m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) - (m2sq*m6sq*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) - (m5sq*m6sq*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) - (2*m1sq*m4sq*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) + (2*m1sq*m5sq*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) - (m1sq*(m1**4 + m4sq*m5sq - m6**4 - m1sq*(m4sq + m5sq - 4*m6sq))*B0fin(0,0,m1sq,mudim))/((m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) + (m1sq*m6sq*(2*m1sq - m4sq - m5sq + 2*m6sq)*B0fin(0,0,m1sq,mudim))/((m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) - (m2**6*(-m1sq + m2sq)*B0fin(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (5*m2sq*(-m1sq + m2sq)*m4**4*B0fin(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (3*m1sq*m2**4*m4sq*B0fin(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (m2**6*m4sq*B0fin(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (4*m2**4*(-m1sq + m2sq)*m4sq*B0fin(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (m2sq*(-m1sq + m2sq)*m6**4*B0fin(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (m2**6*(-m1sq + m2sq)*B0fin(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (5*m2sq*(-m1sq + m2sq)*m5**4*B0fin(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) - (3*m1sq*m2**4*m5sq*B0fin(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (m2**6*m5sq*B0fin(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (4*m2**4*(m1sq - m2sq)*m5sq*B0fin(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + ((m1sq - m2sq)*m2sq*m6**4*B0fin(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + ((m1sq - m2sq)*(-(m4sq*m6) + m6**3)**2*B0fin(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - ((m1sq - m2sq)*(-(m5sq*m6) + m6**3)**2*B0fin(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (m1sq*m4sq*(m4sq - m6sq)**2*B0fin(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (m2sq*m4sq*(m4sq - m6sq)**2*B0fin(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (m1sq*m5sq*(m5sq - m6sq)**2*B0fin(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) - (m2sq*m5sq*(m5sq - m6sq)**2*B0fin(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (m2**4*(-m1sq + m2sq)*m6sq*B0fin(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (4*m2sq*(-m1sq + m2sq)*m4sq*m6sq*B0fin(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (m2**4*(m1sq - m2sq)*m6sq*B0fin(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (4*m2sq*(-m1sq + m2sq)*m5sq*m6sq*B0fin(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) - (4*m1sq*m2sq*m4sq*(m4sq + m6sq)*B0fin(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (4*m1sq*m2sq*m5sq*(m5sq + m6sq)*B0fin(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) - (2*(m1sq - m2sq)*(m4**3 - m4*m6sq)**2*B0fin(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*(m1sq - m2sq)*(m5**3 - m5*m6sq)**2*B0fin(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) - (m2sq*m6sq*B0fin(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))) + (m2sq*m6sq*B0fin(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) + (m2sq*(m2**4 + m4sq*m5sq - m6**4 - m2sq*(m4sq + m5sq - 4*m6sq))*B0fin(0,0,m2sq,mudim))/((m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) + (2*m2sq*(-m1sq + m2sq)*m4**4*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (3*m1sq*m2**4*m4sq*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (m2**6*m4sq*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (m2**4*(m1sq - m2sq)*m4sq*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + ((m1sq - m2sq)*m4**4*(m4sq - m6sq)*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (m1sq*m4sq*(m4sq - m6sq)**2*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (m2sq*m4sq*(m4sq - m6sq)**2*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (4*m2sq*(-m1sq + m2sq)*m4sq*m6sq*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (3*(m1sq - m2sq)*m4sq*(m4sq - m6sq)*m6sq*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (4*m1sq*m2sq*m4sq*(m4sq + m6sq)*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (2*m1sq*m4sq*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) + (m4sq*m6sq*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) - (m4sq*m6sq*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))) - ((m1sq - m2sq)*m4sq*(m4**4 + m1sq*(m2sq - m4sq) - m2sq*m4sq - m6**4 + 4*m4sq*m6sq)*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))) + (2*m1sq*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) + (m1sq*m2**4*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (3*m2**6*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (m1sq*m4sq*(m4sq - m6sq)**2*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (m2sq*m4sq*(m4sq - m6sq)**2*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (4*m2**4*m4sq*(m4sq + m6sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*(m1sq - m2sq)*m2sq*m5**4*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) - (3*m1sq*m2**4*m5sq*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (m2**6*m5sq*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (m2**4*(-m1sq + m2sq)*m5sq*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) - ((m1sq - m2sq)*m5**4*(m5sq - m6sq)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) - (m1sq*m5sq*(m5sq - m6sq)**2*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) - (m2sq*m5sq*(m5sq - m6sq)**2*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (4*(m1sq - m2sq)*m2sq*m5sq*m6sq*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (3*(m1sq - m2sq)*m5sq*(m5sq - m6sq)*m6sq*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (4*m1sq*m2sq*m5sq*(m5sq + m6sq)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (2*m1sq*m5sq*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) - (m5sq*m6sq*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) + (m5sq*m6sq*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) + ((m1sq - m2sq)*m5sq*(m5**4 + m1sq*(m2sq - m5sq) - m2sq*m5sq - m6**4 + 4*m5sq*m6sq)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) - (2*m1sq*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) - (m1sq*m2**4*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (3*m2**6*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (m1sq*m5sq*(m5sq - m6sq)**2*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (m2sq*m5sq*(m5sq - m6sq)**2*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) - (4*m2**4*m5sq*(m5sq + m6sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + ((m1sq - m2sq)*m4sq*(m4**4 + m1sq*(m2sq - m4sq) - m2sq*m4sq - m6**4 + 4*m4sq*m6sq)*(B0del(0,0,m6sq,mudim) - B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))) + (m1sq*(m1**4 + m4sq*m5sq - m6**4 - m1sq*(m4sq + m5sq - 4*m6sq))*(B0del(0,0,m6sq,mudim) - B0fin(0,0,m6sq,mudim)))/((m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) + (m2sq*(-m2**4 - m4sq*m5sq + m6**4 + m2sq*(m4sq + m5sq - 4*m6sq))*(B0del(0,0,m6sq,mudim) - B0fin(0,0,m6sq,mudim)))/((m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) + ((m1sq - m2sq)*m5sq*(-m5**4 + m2sq*m5sq + m1sq*(-m2sq + m5sq) + m6**4 - 4*m5sq*m6sq)*(B0del(0,0,m6sq,mudim) - B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) - (m2**6*(-m1sq + m2sq)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (3*m2sq*(-m1sq + m2sq)*m4**4*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (m2**4*(m1sq - m2sq)*m4sq*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (4*m2**4*(-m1sq + m2sq)*m4sq*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (m2sq*(-m1sq + m2sq)*m6**4*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (m2**6*(-m1sq + m2sq)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (3*m2sq*(-m1sq + m2sq)*m5**4*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (3*m2**4*(m1sq - m2sq)*m5sq*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + ((m1sq - m2sq)*m2sq*m6**4*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + ((m1sq - m2sq)*(-(m4sq*m6) + m6**3)**2*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - ((m1sq - m2sq)*(-(m5sq*m6) + m6**3)**2*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + ((m1sq - m2sq)*m4**4*(m4sq - m6sq)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - ((m1sq - m2sq)*m5**4*(m5sq - m6sq)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (m2**4*(-m1sq + m2sq)*m6sq*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (m2**4*(m1sq - m2sq)*m6sq*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) - (3*(m1sq - m2sq)*m4sq*(m4sq - m6sq)*m6sq*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (3*(m1sq - m2sq)*m5sq*(m5sq - m6sq)*m6sq*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) - (2*(m1sq - m2sq)*(m4**3 - m4*m6sq)**2*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*(m1sq - m2sq)*(m5**3 - m5*m6sq)**2*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (m4sq*m6sq*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) - (m2sq*m6sq*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))) - (m4sq*m6sq*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))) - (m5sq*m6sq*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) + (m1sq*m6sq*(2*m1sq - m4sq - m5sq + 2*m6sq)*B0fin(0,0,m6sq,mudim))/((m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) + (m2sq*m6sq*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) + (m5sq*m6sq*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) + (m1sq*(m1**4 + m4sq*m5sq - m6**4 - m1sq*(m4sq + m5sq - 4*m6sq))*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) - (m1sq*m6sq*(2*m1sq - m4sq - m5sq + 2*m6sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) + (2*m2sq*(-m1sq + m2sq)*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (m2**4*(-m1sq + m2sq)*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*(m1sq - m2sq)*m2sq*m5**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (m2**4*(-m1sq + m2sq)*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) - (2*m2sq*(-m1sq + m2sq)*m4sq*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m2sq*(-m1sq + m2sq)*m5sq*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + ((m1sq - m2sq)*(m4**3 - m4*m6sq)**2*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - ((m1sq - m2sq)*(m5**3 - m5*m6sq)**2*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (m2sq*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))) - (m2sq*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) + (m2sq*(-m2**4 - m4sq*m5sq + m6**4 + m2sq*(m4sq + m5sq - 4*m6sq))*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) + (2*(m1sq - m2sq)*m2sq*m4**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (m2**4*(-m1sq + m2sq)*m4sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - ((m1sq - m2sq)*m4**4*(m4sq - m6sq)*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - ((m1sq - m2sq)*m4sq*(m4sq - m6sq)*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (m4sq*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) + (m4sq*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))) + ((m1sq - m2sq)*m4sq*(m4**4 + m1sq*(m2sq - m4sq) - m2sq*m4sq - m6**4 + 4*m4sq*m6sq)*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))) + (2*m2sq*(-m1sq + m2sq)*m5**4*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (m2**4*(m1sq - m2sq)*m5sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + ((m1sq - m2sq)*m5**4*(m5sq - m6sq)*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + ((m1sq - m2sq)*m5sq*(m5sq - m6sq)*m6sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (m5sq*m6sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) - (m5sq*m6sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) + ((m1sq - m2sq)*m5sq*(-m5**4 + m2sq*m5sq + m1sq*(-m2sq + m5sq) + m6**4 - 4*m5sq*m6sq)*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) + ((m1sq + m4sq - m6sq)*(m1sq + m4sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) - (m1sq*m2**4*(m2sq + m4sq + m6sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (m1sq*m4**4*(m2sq + m4sq + m6sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (m2**4*m4sq*(m2sq + m4sq + m6sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m1sq*m2sq*m4sq*(m2sq + m4sq + m6sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (m1sq*m6**4*(m2sq + m4sq + m6sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m2sq*(m4**4 - m6**4)*(m2sq + m4sq + m6sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - ((m4sq - m6sq)**3*(m2sq + m4sq + m6sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (m2**4*m6sq*(m2sq + m4sq + m6sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m1sq*m2sq*m6sq*(m2sq + m4sq + m6sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m1sq*m4sq*m6sq*(m2sq + m4sq + m6sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - ((m1sq + m5sq - m6sq)*(m1sq + m5sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) + (m1sq*m2**4*(m2sq + m5sq + m6sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (m1sq*m5**4*(m2sq + m5sq + m6sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (m2**4*m5sq*(m2sq + m5sq + m6sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) - (2*m1sq*m2sq*m5sq*(m2sq + m5sq + m6sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (m1sq*m6**4*(m2sq + m5sq + m6sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) - (2*m2sq*(m5**4 - m6**4)*(m2sq + m5sq + m6sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + ((m5sq - m6sq)**3*(m2sq + m5sq + m6sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) - (m2**4*m6sq*(m2sq + m5sq + m6sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) - (2*m1sq*m2sq*m6sq*(m2sq + m5sq + m6sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) - (2*m1sq*m5sq*m6sq*(m2sq + m5sq + m6sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) - ((m1sq + m4sq - m6sq)*T134fin(m6,m4,m1,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) + (m2**6*T134fin(m6,m4,m2,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (2*m1sq*m4**4*T134fin(m6,m4,m2,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + (m2**4*m4sq*T134fin(m6,m4,m2,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (2*m1sq*m2sq*m4sq*T134fin(m6,m4,m2,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (3*m2sq*(m4**4 - m6**4)*T134fin(m6,m4,m2,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + ((m4sq - m6sq)**3*T134fin(m6,m4,m2,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (3*m2**4*m6sq*T134fin(m6,m4,m2,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) - (2*m1sq*m4sq*m6sq*T134fin(m6,m4,m2,mudim))/((m4sq - m5sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2) + ((m1sq + m5sq - m6sq)*T134fin(m6,m5,m1,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) - (m2**6*T134fin(m6,m5,m2,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) - (2*m1sq*m5**4*T134fin(m6,m5,m2,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) - (m2**4*m5sq*T134fin(m6,m5,m2,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (2*m1sq*m2sq*m5sq*T134fin(m6,m5,m2,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (3*m2sq*(m5**4 - m6**4)*T134fin(m6,m5,m2,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) - ((m5sq - m6sq)**3*T134fin(m6,m5,m2,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (3*m2**4*m6sq*T134fin(m6,m5,m2,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2) + (2*m1sq*m5sq*m6sq*T134fin(m6,m5,m2,mudim))/((m4sq - m5sq)*(m2 + m5 - m6)**2*(m2 - m5 + m6)**2*(-m2 + m5 + m6)**2*(m2 + m5 + m6)**2))/(m1sq - m2sq)**2
		def eval_198():
			return -(m2**6/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq))) + (m2sq*m4**4)/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (m2**4*m4sq)/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (3*m2sq*m6**4)/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (-(m4sq*m6) + m6**3)**2/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (4*m1sq*m2**4*m6sq)/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (4*m2**6*m6sq)/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (3*m2**4*m6sq)/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (2*m2sq*m4sq*m6sq)/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (4*m4sq*(m4sq - m6sq)*m6sq)/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (4*m2**4*m6sq*(m4sq + m6sq))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (4*m1sq*m2sq*m6sq*(m4sq + m6sq))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (2*m1sq*m2**4*(m2sq + m4sq + m6sq))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (2*m2**6*(m2sq + m4sq + m6sq))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (2*m1sq*m4**4*(m2sq + m4sq + m6sq))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (4*m2**4*m4sq*(m2sq + m4sq + m6sq))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (4*m1sq*m2sq*m4sq*(m2sq + m4sq + m6sq))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (2*m1sq*m6**4*(m2sq + m4sq + m6sq))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (2*m2sq*(m4**4 - m6**4)*(m2sq + m4sq + m6sq))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (m4**3 - m4*m6sq)**2/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + m2**6/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(m6sq - m7sq)) + (3*m2sq*m7**4)/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(m6sq - m7sq)) + (2*m2sq*m4sq*m7sq)/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(m6sq - m7sq)) + (4*m4sq*(m4sq - m7sq)*m7sq)/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(m6sq - m7sq)) + (m2sq*m4**4)/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (m2**4*m4sq)/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (-(m4sq*m7) + m7**3)**2/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) - (4*m1sq*m2**4*m7sq)/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (4*m2**6*m7sq)/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (3*m2**4*m7sq)/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) - (4*m2**4*m7sq*(m4sq + m7sq))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (4*m1sq*m2sq*m7sq*(m4sq + m7sq))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (2*m1sq*m2**4*(m2sq + m4sq + m7sq))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) - (2*m2**6*(m2sq + m4sq + m7sq))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (2*m1sq*m4**4*(m2sq + m4sq + m7sq))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (4*m2**4*m4sq*(m2sq + m4sq + m7sq))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) - (4*m1sq*m2sq*m4sq*(m2sq + m4sq + m7sq))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) - (2*m1sq*m7**4*(m2sq + m4sq + m7sq))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) - (2*m2sq*(m4**4 - m7**4)*(m2sq + m4sq + m7sq))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (m4**3 - m4*m7sq)**2/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(m6sq - m7sq)) + (2*m1sq*m6sq*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)**2*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m6sq - m7sq)) - (m1sq*m4sq*(2*m1sq + 2*m4sq - m6sq - m7sq)*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)**2*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) - (2*m1sq*m7sq*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)**2*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + (m1sq*(m1**4 - m4**4 + m1sq*(4*m4sq - m6sq - m7sq) + m6sq*m7sq)*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)**2*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) - (2*m2sq*m6**4*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + ((-(m4sq*m6) + m6**3)**2*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (m1sq*m2**4*m6sq*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (3*m2**6*m6sq*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (m2**4*m6sq*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (2*m2sq*m4sq*m6sq*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (m1sq*(m4sq - m6sq)**2*m6sq*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (m2sq*(m4sq - m6sq)**2*m6sq*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (4*m2**4*m6sq*(m4sq + m6sq)*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (m2sq*m4sq*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)**2*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m6sq - m7sq)) + (2*m2sq*m7**4*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(m6sq - m7sq)) + ((-(m4sq*m7) + m7**3)**2*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (m1sq*m2**4*m7sq*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) - (3*m2**6*m7sq*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (m2**4*m7sq*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (2*m2sq*m4sq*m7sq*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) - (m1sq*(m4sq - m7sq)**2*m7sq*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) - (m2sq*(m4sq - m7sq)**2*m7sq*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (4*m2**4*m7sq*(m4sq + m7sq)*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) - (m2sq*m4sq*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)**2*(m6sq - m7sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) - (m2sq*(m2**4 - m4**4 + m2sq*(4*m4sq - m6sq - m7sq) + m6sq*m7sq)*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)**2*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) + ((-(m4sq*m6) + m6**3)**2*B0del(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (m6**4*(m4sq - m6sq)*B0del(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (2*m2sq*m4sq*m6sq*B0del(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (m4sq*(m4sq - m6sq)*m6sq*B0del(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (m4sq*m6sq*B0del(0,0,m4sq,mudim))/((m1sq - m2sq)**2*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m2sq*m4sq*B0del(0,0,m4sq,mudim))/((m1sq - m2sq)**2*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m4sq*m6sq*B0del(0,0,m4sq,mudim))/((m1sq - m2sq)**2*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m6sq - m7sq)) + ((-(m4sq*m7) + m7**3)**2*B0del(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (m7**4*(m4sq - m7sq)*B0del(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (2*m2sq*m4sq*m7sq*B0del(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (m4sq*(m4sq - m7sq)*m7sq*B0del(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) - (m1sq*m4sq*(2*m1sq + 2*m4sq - m6sq - m7sq)*B0del(0,0,m4sq,mudim))/((m1sq - m2sq)**2*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + (m4sq*m7sq*B0del(0,0,m4sq,mudim))/((m1sq - m2sq)**2*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) - (m2sq*m4sq*B0del(0,0,m4sq,mudim))/((m1sq - m2sq)**2*(m6sq - m7sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) - (m4sq*m7sq*B0del(0,0,m4sq,mudim))/((m1sq - m2sq)**2*(m6sq - m7sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) + (2*m2sq*m6**4*B0del(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (m6**4*(m4sq - m6sq)*B0del(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (m1sq*m2**4*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (3*m2**6*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (m2**4*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (m4sq*(m4sq - m6sq)*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (m1sq*(m4sq - m6sq)**2*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (m2sq*(m4sq - m6sq)**2*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (4*m2**4*m6sq*(m4sq + m6sq)*B0del(0,0,m6sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (2*m1sq*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m2sq)**2*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m6sq - m7sq)) - (m4sq*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m2sq)**2*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m4sq*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m2sq)**2*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m6sq*(-m4**4 + m6**4 + m1sq*(m2sq - m6sq) - m2sq*m6sq + 4*m4sq*m6sq)*B0del(0,0,m6sq,mudim))/((m1sq - m2sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m2**4*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(m6sq - m7sq)) + (2*m2sq*m7**4*B0del(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (m7**4*(m4sq - m7sq)*B0del(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (m1sq*m2**4*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) - (3*m2**6*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (m4sq*(m4sq - m7sq)*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) - (m1sq*(m4sq - m7sq)**2*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) - (m2sq*(m4sq - m7sq)**2*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (4*m2**4*m7sq*(m4sq + m7sq)*B0del(0,0,m7sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) - (2*m1sq*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m2sq)**2*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + (m4sq*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m2sq)**2*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) - (m4sq*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m2sq)**2*(m6sq - m7sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) + (m7sq*(m4**4 - m7**4 + m2sq*m7sq - 4*m4sq*m7sq + m1sq*(-m2sq + m7sq))*B0del(0,0,m7sq,mudim))/((m1sq - m2sq)*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) - (2*m1sq*m6sq*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)**2*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m1sq*m4sq*(2*m1sq + 2*m4sq - m6sq - m7sq)*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)**2*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + (2*m1sq*m7sq*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)**2*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) - (m1sq*(m1**4 - m4**4 + m1sq*(4*m4sq - m6sq - m7sq) + m6sq*m7sq)*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)**2*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + (m2**6*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (m2sq*m4**4*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (m2**4*m4sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (5*m2sq*m6**4*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (2*(-(m4sq*m6) + m6**3)**2*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (3*m1sq*m2**4*m6sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (m2**6*m6sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (4*m2**4*m6sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (4*m2sq*m4sq*m6sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (m1sq*(m4sq - m6sq)**2*m6sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (m2sq*(m4sq - m6sq)**2*m6sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (4*m1sq*m2sq*m6sq*(m4sq + m6sq)*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + ((m4**3 - m4*m6sq)**2*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (m2sq*m4sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)**2*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m2sq*m4**4*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(m6sq - m7sq)) + (m2**4*m4sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(m6sq - m7sq)) + (4*m2**4*m7sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(m6sq - m7sq)) + (m2**6*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (5*m2sq*m7**4*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) - (2*(-(m4sq*m7) + m7**3)**2*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (3*m1sq*m2**4*m7sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) - (m2**6*m7sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (4*m2sq*m4sq*m7sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (m1sq*(m4sq - m7sq)**2*m7sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (m2sq*(m4sq - m7sq)**2*m7sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) - (4*m1sq*m2sq*m7sq*(m4sq + m7sq)*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + ((m4**3 - m4*m7sq)**2*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (m2sq*m4sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)**2*(m6sq - m7sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) + (m2sq*(m2**4 - m4**4 + m2sq*(4*m4sq - m6sq - m7sq) + m6sq*m7sq)*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)**2*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) + (m6sq*(-m4**4 + m6**4 + m1sq*(m2sq - m6sq) - m2sq*m6sq + 4*m4sq*m6sq)*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/((m1sq - m2sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m1sq*(m1**4 - m4**4 + m1sq*(4*m4sq - m6sq - m7sq) + m6sq*m7sq)*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/((m1sq - m2sq)**2*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) - (m2sq*(m2**4 - m4**4 + m2sq*(4*m4sq - m6sq - m7sq) + m6sq*m7sq)*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/((m1sq - m2sq)**2*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) + (m7sq*(m4**4 - m7**4 + m2sq*m7sq - 4*m4sq*m7sq + m1sq*(-m2sq + m7sq))*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/((m1sq - m2sq)*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) + (m2**6*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (m2sq*m4**4*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (m2**4*m4sq*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (3*m2sq*m6**4*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (2*(-(m4sq*m6) + m6**3)**2*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (3*m2**4*m6sq*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (3*m4sq*(m4sq - m6sq)*m6sq*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (m6**4*(-m4sq + m6sq)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + ((m4**3 - m4*m6sq)**2*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (m4sq*m6sq*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)**2*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m6sq - m7sq)) - (m2sq*m4sq*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)**2*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m6sq - m7sq)) - (m4sq*m6sq*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)**2*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m2sq*m4**4*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(m6sq - m7sq)) + (m2**4*m4sq*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(m6sq - m7sq)) + (m7**4*(m4sq - m7sq)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(m6sq - m7sq)) + (3*m2**4*m7sq*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(m6sq - m7sq)) + (m2**6*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (3*m2sq*m7**4*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) - (2*(-(m4sq*m7) + m7**3)**2*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (3*m4sq*(m4sq - m7sq)*m7sq*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + ((m4**3 - m4*m7sq)**2*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (m1sq*m4sq*(2*m1sq + 2*m4sq - m6sq - m7sq)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)**2*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) - (m4sq*m7sq*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)**2*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + (m2sq*m4sq*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)**2*(m6sq - m7sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) + (m4sq*m7sq*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)**2*(m6sq - m7sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) - (m1sq*m4sq*(2*m1sq + 2*m4sq - m6sq - m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)**2*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + (m1sq*(m1**4 - m4**4 + m1sq*(4*m4sq - m6sq - m7sq) + m6sq*m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)**2*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) - (2*m2sq*m6**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + ((-(m4sq*m6) + m6**3)**2*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (m2**4*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (2*m2sq*m4sq*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (m2sq*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)**2*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m6sq - m7sq)) + (2*m2sq*m7**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(m6sq - m7sq)) + ((-(m4sq*m7) + m7**3)**2*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (m2**4*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (2*m2sq*m4sq*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) - (m2sq*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)**2*(m6sq - m7sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) - (m2sq*(m2**4 - m4**4 + m2sq*(4*m4sq - m6sq - m7sq) + m6sq*m7sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)**2*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) - (2*m2sq*m6**4*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (3*m1sq*m2**4*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (m2**6*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (m2**4*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (4*m2sq*m4sq*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (3*m4sq*(m4sq - m6sq)*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (m1sq*(m4sq - m6sq)**2*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (m2sq*(m4sq - m6sq)**2*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (m6**4*(-m4sq + m6sq)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (4*m1sq*m2sq*m6sq*(m4sq + m6sq)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (2*m1sq*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)**2*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m4sq*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)**2*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m6sq - m7sq)) - (m4sq*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)**2*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m6sq - m7sq)) - (m6sq*(-m4**4 + m6**4 + m1sq*(m2sq - m6sq) - m2sq*m6sq + 4*m4sq*m6sq)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m6sq - m7sq)) + (2*m1sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)**2*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m1sq*m2**4*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (3*m2**6*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (m1sq*(m4sq - m6sq)**2*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (m2sq*(m4sq - m6sq)**2*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (4*m2**4*m6sq*(m4sq + m6sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (2*m2sq*m6**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (m6**4*(m4sq - m6sq)*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (m2**4*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (m4sq*(m4sq - m6sq)*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (m4sq*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)**2*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m4sq*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)**2*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m6sq*(-m4**4 + m6**4 + m1sq*(m2sq - m6sq) - m2sq*m6sq + 4*m4sq*m6sq)*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m6sq - m7sq)) + ((m1sq - m4sq + m6sq)*(m1sq + m4sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m1sq - m2sq)**2*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m6sq - m7sq)) - (m1sq*m2**4*(m2sq + m4sq + m6sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (m1sq*m4**4*(m2sq + m4sq + m6sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (m2**4*m4sq*(m2sq + m4sq + m6sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (2*m1sq*m2sq*m4sq*(m2sq + m4sq + m6sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (m1sq*m6**4*(m2sq + m4sq + m6sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (2*m2sq*(m4**4 - m6**4)*(m2sq + m4sq + m6sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + ((m4sq - m6sq)**3*(m2sq + m4sq + m6sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (m2**4*m6sq*(m2sq + m4sq + m6sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (2*m1sq*m2sq*m6sq*(m2sq + m4sq + m6sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (2*m1sq*m4sq*m6sq*(m2sq + m4sq + m6sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (2*m2sq*m7**4*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(m6sq - m7sq)) + (m7**4*(m4sq - m7sq)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(m6sq - m7sq)) + (4*m2sq*m4sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(m6sq - m7sq)) + (3*m1sq*m2**4*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) - (m2**6*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (m2**4*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (3*m4sq*(m4sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (m1sq*(m4sq - m7sq)**2*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (m2sq*(m4sq - m7sq)**2*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) - (4*m1sq*m2sq*m7sq*(m4sq + m7sq)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (2*m1sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)**2*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) - (m4sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)**2*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + (m4sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)**2*(m6sq - m7sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) + (m7sq*(-m4**4 + m7**4 + m1sq*(m2sq - m7sq) - m2sq*m7sq + 4*m4sq*m7sq)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) - (2*m1sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)**2*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + (m1sq*m2**4*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) - (3*m2**6*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) - (m1sq*(m4sq - m7sq)**2*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) - (m2sq*(m4sq - m7sq)**2*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (4*m2**4*m7sq*(m4sq + m7sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (m2**4*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(m6sq - m7sq)) + (2*m2sq*m7**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (m7**4*(m4sq - m7sq)*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (m4sq*(m4sq - m7sq)*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (m4sq*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)**2*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) - (m4sq*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)**2*(m6sq - m7sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) + (m7sq*(m4**4 - m7**4 + m2sq*m7sq - 4*m4sq*m7sq + m1sq*(-m2sq + m7sq))*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) - ((m1sq - m4sq + m7sq)*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)**2*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) - (m1sq*m2**4*(m2sq + m4sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) - (m1sq*m4**4*(m2sq + m4sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (m2**4*m4sq*(m2sq + m4sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (2*m1sq*m2sq*m4sq*(m2sq + m4sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) - (m1sq*m7**4*(m2sq + m4sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) - (2*m2sq*(m4**4 - m7**4)*(m2sq + m4sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + ((m4sq - m7sq)**3*(m2sq + m4sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) - (m2**4*m7sq*(m2sq + m4sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (2*m1sq*m2sq*m7sq*(m2sq + m4sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (2*m1sq*m4sq*m7sq*(m2sq + m4sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) - ((m1sq - m4sq + m6sq)*T134fin(m6,m4,m1,mudim))/((m1sq - m2sq)**2*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m2**6*T134fin(m6,m4,m2,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (3*m2**4*m4sq*T134fin(m6,m4,m2,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (2*m1sq*m6**4*T134fin(m6,m4,m2,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (3*m2sq*(m4**4 - m6**4)*T134fin(m6,m4,m2,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - ((m4sq - m6sq)**3*T134fin(m6,m4,m2,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + (m2**4*m6sq*T134fin(m6,m4,m2,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (2*m1sq*m2sq*m6sq*T134fin(m6,m4,m2,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) - (2*m1sq*m4sq*m6sq*T134fin(m6,m4,m2,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m6)**2*(m2 - m4 + m6)**2*(-m2 + m4 + m6)**2*(m2 + m4 + m6)**2*(m6sq - m7sq)) + ((m1sq - m4sq + m7sq)*T134fin(m7,m4,m1,mudim))/((m1sq - m2sq)**2*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + (m2**6*T134fin(m7,m4,m2,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) - (3*m2**4*m4sq*T134fin(m7,m4,m2,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (2*m1sq*m7**4*T134fin(m7,m4,m2,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (3*m2sq*(m4**4 - m7**4)*T134fin(m7,m4,m2,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) - ((m4sq - m7sq)**3*T134fin(m7,m4,m2,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) + (m2**4*m7sq*T134fin(m7,m4,m2,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) - (2*m1sq*m2sq*m7sq*T134fin(m7,m4,m2,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq)) - (2*m1sq*m4sq*m7sq*T134fin(m7,m4,m2,mudim))/((m1sq - m2sq)**2*(m2 + m4 - m7)**2*(m2 - m4 + m7)**2*(-m2 + m4 + m7)**2*(m2 + m4 + m7)**2*(-m6sq + m7sq))
		def eval_199():
			return ((m1**6*(m1sq - m3sq))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (3*m1sq*(m1sq - m3sq)*m4**4)/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (4*m1**6*m4sq)/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (3*m1**4*(m1sq - m3sq)*m4sq)/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (4*m1**4*m3sq*m4sq)/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m1sq*(m1sq - m3sq)*m6**4)/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (-m1**8 + m1**6*m3sq)/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (3*m1sq*(m1sq - m3sq)*m5**4)/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (4*m1**6*m5sq)/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + (3*m1**4*(m1sq - m3sq)*m5sq)/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + (4*m1**4*m3sq*m5sq)/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + (m1sq*(m1sq - m3sq)*m6**4)/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + ((m1sq - m3sq)*(-(m4sq*m6) + m6**3)**2)/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - ((m1sq - m3sq)*(-(m5sq*m6) + m6**3)**2)/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (m1**4*(m1sq - m3sq)*m6sq)/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m1sq*(m1sq - m3sq)*m4sq*m6sq)/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (m1**4*(m1sq - m3sq)*m6sq)/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (2*m1sq*(m1sq - m3sq)*m5sq*m6sq)/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (4*(m1sq - m3sq)*m4sq*(m4sq - m6sq)*m6sq)/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (4*(m1sq - m3sq)*m5sq*(m5sq - m6sq)*m6sq)/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (4*m1**4*m4sq*(m4sq + m6sq))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (4*m1sq*m3sq*m4sq*(m4sq + m6sq))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (2*m1**6*(m1sq + m4sq + m6sq))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m1**4*m3sq*(m1sq + m4sq + m6sq))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m1sq*(m4**4 - m6**4)*(m1sq + m4sq + m6sq))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (4*m1**4*m6sq*(m1sq + m4sq + m6sq))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (4*m1sq*m3sq*m6sq*(m1sq + m4sq + m6sq))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m3sq*m4sq*(-m4sq + m6sq)*(m1sq + m4sq + m6sq))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m3sq*m6sq*(-m4sq + m6sq)*(m1sq + m4sq + m6sq))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (4*m1**4*m5sq*(m5sq + m6sq))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (4*m1sq*m3sq*m5sq*(m5sq + m6sq))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + (2*m1**6*(m1sq + m5sq + m6sq))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (2*m1**4*m3sq*(m1sq + m5sq + m6sq))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (2*m1sq*(m5**4 - m6**4)*(m1sq + m5sq + m6sq))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + (2*m3sq*m5sq*(m5sq - m6sq)*(m1sq + m5sq + m6sq))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (4*m1**4*m6sq*(m1sq + m5sq + m6sq))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + (4*m1sq*m3sq*m6sq*(m1sq + m5sq + m6sq))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + (2*m3sq*(m5sq - m6sq)*m6sq*(m1sq + m5sq + m6sq))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - ((m1sq - m3sq)*(m4**3 - m4*m6sq)**2)/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + ((m1sq - m3sq)*(m5**3 - m5*m6sq)**2)/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + (2*m1sq*(m1sq - m3sq)*m4**4*B0del(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (3*m1**6*m4sq*B0del(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m1**4*(m1sq - m3sq)*m4sq*B0del(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (m1**4*m3sq*m4sq*B0del(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (2*m1sq*(m1sq - m3sq)*m5**4*B0del(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + (3*m1**6*m5sq*B0del(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + (m1**4*(m1sq - m3sq)*m5sq*B0del(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (m1**4*m3sq*m5sq*B0del(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (m1sq*m4sq*(m4sq - m6sq)**2*B0del(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m3sq*m4sq*(m4sq - m6sq)**2*B0del(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (m1sq*m5sq*(m5sq - m6sq)**2*B0del(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + (m3sq*m5sq*(m5sq - m6sq)**2*B0del(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (2*m1sq*(m1sq - m3sq)*m4sq*m6sq*B0del(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m1sq*(m1sq - m3sq)*m5sq*m6sq*B0del(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + (4*m1**4*m4sq*(m4sq + m6sq)*B0del(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (4*m1**4*m5sq*(m5sq + m6sq)*B0del(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - ((m1sq - m3sq)*(m4**3 - m4*m6sq)**2*B0del(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + ((m1sq - m3sq)*(m5**3 - m5*m6sq)**2*B0del(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + (m1sq*m6sq*B0del(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) - (m1sq*m6sq*B0del(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) + (m1sq*(-m1**4 - m4sq*m5sq + m6**4 + m1sq*(m4sq + m5sq - 4*m6sq))*B0del(0,0,m1sq,mudim))/((m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) + (2*m3sq*m4sq*B0del(0,0,m3sq,mudim))/((m4sq - m5sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) - (2*m3sq*m5sq*B0del(0,0,m3sq,mudim))/((m4sq - m5sq)*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) + (m3sq*(m3**4 + m4sq*m5sq - m6**4 - m3sq*(m4sq + m5sq - 4*m6sq))*B0del(0,0,m3sq,mudim))/((m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) - (m3sq*m6sq*(2*m3sq - m4sq - m5sq + 2*m6sq)*B0del(0,0,m3sq,mudim))/((m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) - (2*m1sq*(m1sq - m3sq)*m4**4*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (3*m1**6*m4sq*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (m1**4*(m1sq - m3sq)*m4sq*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (m1**4*m3sq*m4sq*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + ((m1sq - m3sq)*m4**4*(m4sq - m6sq)*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m1sq*m4sq*(m4sq - m6sq)**2*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m3sq*m4sq*(m4sq - m6sq)**2*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + ((m1sq - m3sq)*m4sq*(m4sq - m6sq)*m6sq*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (4*m1**4*m4sq*(m4sq + m6sq)*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (m4sq*m6sq*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) + (2*m3sq*m4sq*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) - (m4sq*m6sq*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) + ((m1sq - m3sq)*m4sq*(-m4**4 + m3sq*m4sq + m1sq*(-m3sq + m4sq) + m6**4 - 4*m4sq*m6sq)*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) + (2*m1sq*(m1sq - m3sq)*m5**4*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + (3*m1**6*m5sq*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (m1**4*(m1sq - m3sq)*m5sq*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (m1**4*m3sq*m5sq*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - ((m1sq - m3sq)*m5**4*(m5sq - m6sq)*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + (m1sq*m5sq*(m5sq - m6sq)**2*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + (m3sq*m5sq*(m5sq - m6sq)**2*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - ((m1sq - m3sq)*m5sq*(m5sq - m6sq)*m6sq*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (4*m1**4*m5sq*(m5sq + m6sq)*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (m5sq*m6sq*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) - (2*m3sq*m5sq*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) + (m5sq*m6sq*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) + ((m1sq - m3sq)*m5sq*(m5**4 + m1sq*(m3sq - m5sq) - m3sq*m5sq - m6**4 + 4*m5sq*m6sq)*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) + ((m1sq - m3sq)*m4**4*(m4sq - m6sq)*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - ((m1sq - m3sq)*m5**4*(m5sq - m6sq)*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (2*m1sq*(m1sq - m3sq)*m4sq*m6sq*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m1sq*(m1sq - m3sq)*m5sq*m6sq*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + ((m1sq - m3sq)*m4sq*(m4sq - m6sq)*m6sq*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - ((m1sq - m3sq)*m5sq*(m5sq - m6sq)*m6sq*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - ((m1sq - m3sq)*(m4**3 - m4*m6sq)**2*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + ((m1sq - m3sq)*(m5**3 - m5*m6sq)**2*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + (m1sq*m6sq*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) + (m4sq*m6sq*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) - (m4sq*m6sq*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) - (m1sq*m6sq*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) - (m5sq*m6sq*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) + (m5sq*m6sq*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) - (m3sq*m6sq*(2*m3sq - m4sq - m5sq + 2*m6sq)*B0del(0,0,m6sq,mudim))/((m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) - (m1**6*(m1sq - m3sq)*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (5*m1sq*(m1sq - m3sq)*m4**4*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m1**6*m4sq*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (4*m1**4*(m1sq - m3sq)*m4sq*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (3*m1**4*m3sq*m4sq*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (m1sq*(m1sq - m3sq)*m6**4*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (m1**6*(m1sq - m3sq)*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + (5*m1sq*(m1sq - m3sq)*m5**4*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + (m1**6*m5sq*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (4*m1**4*(m1sq - m3sq)*m5sq*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (3*m1**4*m3sq*m5sq*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (m1sq*(m1sq - m3sq)*m6**4*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - ((m1sq - m3sq)*(-(m4sq*m6) + m6**3)**2*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + ((m1sq - m3sq)*(-(m5sq*m6) + m6**3)**2*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + (m1sq*m4sq*(m4sq - m6sq)**2*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (m3sq*m4sq*(m4sq - m6sq)**2*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m1sq*m5sq*(m5sq - m6sq)**2*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (m3sq*m5sq*(m5sq - m6sq)**2*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + (m1**4*(m1sq - m3sq)*m6sq*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (4*m1sq*(m1sq - m3sq)*m4sq*m6sq*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m1**4*(m1sq - m3sq)*m6sq*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + (4*m1sq*(m1sq - m3sq)*m5sq*m6sq*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (4*m1sq*m3sq*m4sq*(m4sq + m6sq)*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (4*m1sq*m3sq*m5sq*(m5sq + m6sq)*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + (2*(m1sq - m3sq)*(m4**3 - m4*m6sq)**2*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (2*(m1sq - m3sq)*(m5**3 - m5*m6sq)**2*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (m1sq*m6sq*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) + (m1sq*m6sq*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) + (m1sq*(m1**4 + m4sq*m5sq - m6**4 - m1sq*(m4sq + m5sq - 4*m6sq))*B0fin(0,0,m1sq,mudim))/((m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) - (2*m3sq*m4sq*B0fin(0,0,m3sq,mudim))/((m4sq - m5sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) + (2*m3sq*m5sq*B0fin(0,0,m3sq,mudim))/((m4sq - m5sq)*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) - (m3sq*(m3**4 + m4sq*m5sq - m6**4 - m3sq*(m4sq + m5sq - 4*m6sq))*B0fin(0,0,m3sq,mudim))/((m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) + (m3sq*m6sq*(2*m3sq - m4sq - m5sq + 2*m6sq)*B0fin(0,0,m3sq,mudim))/((m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) + (2*m1sq*(m1sq - m3sq)*m4**4*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m1**6*m4sq*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m1**4*(m1sq - m3sq)*m4sq*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (3*m1**4*m3sq*m4sq*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - ((m1sq - m3sq)*m4**4*(m4sq - m6sq)*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (m1sq*m4sq*(m4sq - m6sq)**2*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (m3sq*m4sq*(m4sq - m6sq)**2*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (4*m1sq*(m1sq - m3sq)*m4sq*m6sq*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (3*(m1sq - m3sq)*m4sq*(m4sq - m6sq)*m6sq*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (4*m1sq*m3sq*m4sq*(m4sq + m6sq)*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m4sq*m6sq*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) - (2*m3sq*m4sq*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) + (m4sq*m6sq*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) + ((m1sq - m3sq)*m4sq*(m4**4 + m1sq*(m3sq - m4sq) - m3sq*m4sq - m6**4 + 4*m4sq*m6sq)*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) - (3*m1**6*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (m1**4*m3sq*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m1sq*m4sq*(m4sq - m6sq)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m3sq*m4sq*(m4sq - m6sq)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (4*m1**4*m4sq*(m4sq + m6sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m3sq*m4sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) - (2*m1sq*(m1sq - m3sq)*m5**4*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + (m1**6*m5sq*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + (m1**4*(m1sq - m3sq)*m5sq*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (3*m1**4*m3sq*m5sq*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + ((m1sq - m3sq)*m5**4*(m5sq - m6sq)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (m1sq*m5sq*(m5sq - m6sq)**2*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (m3sq*m5sq*(m5sq - m6sq)**2*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (4*m1sq*(m1sq - m3sq)*m5sq*m6sq*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (3*(m1sq - m3sq)*m5sq*(m5sq - m6sq)*m6sq*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + (4*m1sq*m3sq*m5sq*(m5sq + m6sq)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + (m5sq*m6sq*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) + (2*m3sq*m5sq*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) - (m5sq*m6sq*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) - ((m1sq - m3sq)*m5sq*(m5**4 + m1sq*(m3sq - m5sq) - m3sq*m5sq - m6**4 + 4*m5sq*m6sq)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) + (3*m1**6*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (m1**4*m3sq*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + (m1sq*m5sq*(m5sq - m6sq)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + (m3sq*m5sq*(m5sq - m6sq)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (4*m1**4*m5sq*(m5sq + m6sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (2*m3sq*m5sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) + ((m1sq - m3sq)*m4sq*(-m4**4 + m3sq*m4sq + m1sq*(-m3sq + m4sq) + m6**4 - 4*m4sq*m6sq)*(B0del(0,0,m6sq,mudim) - B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) + (m1sq*(-m1**4 - m4sq*m5sq + m6**4 + m1sq*(m4sq + m5sq - 4*m6sq))*(B0del(0,0,m6sq,mudim) - B0fin(0,0,m6sq,mudim)))/((m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) + (m3sq*(m3**4 + m4sq*m5sq - m6**4 - m3sq*(m4sq + m5sq - 4*m6sq))*(B0del(0,0,m6sq,mudim) - B0fin(0,0,m6sq,mudim)))/((m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) + ((m1sq - m3sq)*m5sq*(m5**4 + m1sq*(m3sq - m5sq) - m3sq*m5sq - m6**4 + 4*m5sq*m6sq)*(B0del(0,0,m6sq,mudim) - B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) - (m1**6*(m1sq - m3sq)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (3*m1sq*(m1sq - m3sq)*m4**4*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (3*m1**4*(m1sq - m3sq)*m4sq*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (m1sq*(m1sq - m3sq)*m6**4*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (m1**6*(m1sq - m3sq)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + (3*m1sq*(m1sq - m3sq)*m5**4*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (3*m1**4*(m1sq - m3sq)*m5sq*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (m1sq*(m1sq - m3sq)*m6**4*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - ((m1sq - m3sq)*(-(m4sq*m6) + m6**3)**2*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + ((m1sq - m3sq)*(-(m5sq*m6) + m6**3)**2*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - ((m1sq - m3sq)*m4**4*(m4sq - m6sq)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + ((m1sq - m3sq)*m5**4*(m5sq - m6sq)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + (m1**4*(m1sq - m3sq)*m6sq*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m1**4*(m1sq - m3sq)*m6sq*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + (3*(m1sq - m3sq)*m4sq*(m4sq - m6sq)*m6sq*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (3*(m1sq - m3sq)*m5sq*(m5sq - m6sq)*m6sq*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + (2*(m1sq - m3sq)*(m4**3 - m4*m6sq)**2*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (2*(m1sq - m3sq)*(m5**3 - m5*m6sq)**2*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (m1sq*m6sq*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) - (m4sq*m6sq*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) + (m4sq*m6sq*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) + (m1sq*m6sq*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) + (m5sq*m6sq*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) - (m5sq*m6sq*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) + (m3sq*m6sq*(2*m3sq - m4sq - m5sq + 2*m6sq)*B0fin(0,0,m6sq,mudim))/((m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) + (2*m1sq*(m1sq - m3sq)*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m1**4*(m1sq - m3sq)*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (2*m1sq*(m1sq - m3sq)*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + (m1**4*(m1sq - m3sq)*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (2*m1sq*(m1sq - m3sq)*m4sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m1sq*(m1sq - m3sq)*m5sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - ((m1sq - m3sq)*(m4**3 - m4*m6sq)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + ((m1sq - m3sq)*(m5**3 - m5*m6sq)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + (m1sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) - (m1sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) + (m1sq*(-m1**4 - m4sq*m5sq + m6**4 + m1sq*(m4sq + m5sq - 4*m6sq))*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) + (m3sq*(m3**4 + m4sq*m5sq - m6**4 - m3sq*(m4sq + m5sq - 4*m6sq))*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim))/((m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) - (m3sq*m6sq*(2*m3sq - m4sq - m5sq + 2*m6sq)*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim))/((m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) - (2*m1sq*(m1sq - m3sq)*m4**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (m1**4*(m1sq - m3sq)*m4sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + ((m1sq - m3sq)*m4**4*(m4sq - m6sq)*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + ((m1sq - m3sq)*m4sq*(m4sq - m6sq)*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (m4sq*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) - (m4sq*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) + ((m1sq - m3sq)*m4sq*(-m4**4 + m3sq*m4sq + m1sq*(-m3sq + m4sq) + m6**4 - 4*m4sq*m6sq)*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) + (2*m1sq*(m1sq - m3sq)*m5**4*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (m1**4*(m1sq - m3sq)*m5sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - ((m1sq - m3sq)*m5**4*(m5sq - m6sq)*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - ((m1sq - m3sq)*m5sq*(m5sq - m6sq)*m6sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (m5sq*m6sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) + (m5sq*m6sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) + ((m1sq - m3sq)*m5sq*(m5**4 + m1sq*(m3sq - m5sq) - m3sq*m5sq - m6**4 + 4*m5sq*m6sq)*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) - (m1**4*m3sq*(m1sq + m4sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m1**4*m4sq*(m1sq + m4sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m1sq*m3sq*m4sq*(m1sq + m4sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m1sq*(m4**4 - m6**4)*(m1sq + m4sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (m3sq*m4sq*(m4sq - m6sq)*(m1sq + m4sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - ((m4sq - m6sq)**3*(m1sq + m4sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (m1**4*m6sq*(m1sq + m4sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m1sq*m3sq*m6sq*(m1sq + m4sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (m3sq*(m4sq - m6sq)*m6sq*(m1sq + m4sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + ((m3sq + m4sq - m6sq)*(m3sq + m4sq + m6sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) + (m1**4*m3sq*(m1sq + m5sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + (m1**4*m5sq*(m1sq + m5sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (2*m1sq*m3sq*m5sq*(m1sq + m5sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (2*m1sq*(m5**4 - m6**4)*(m1sq + m5sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + (m3sq*m5sq*(m5sq - m6sq)*(m1sq + m5sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + ((m5sq - m6sq)**3*(m1sq + m5sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (m1**4*m6sq*(m1sq + m5sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (2*m1sq*m3sq*m6sq*(m1sq + m5sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + (m3sq*m6sq*(-m5sq + m6sq)*(m1sq + m5sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - ((m3sq + m5sq - m6sq)*(m3sq + m5sq + m6sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) + (m1**6*T134fin(m6,m4,m1,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (m1**4*m4sq*T134fin(m6,m4,m1,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (2*m1sq*m3sq*m4sq*T134fin(m6,m4,m1,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (3*m1sq*(m4**4 - m6**4)*T134fin(m6,m4,m1,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + (2*m3sq*m4sq*(m4sq - m6sq)*T134fin(m6,m4,m1,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) + ((m4sq - m6sq)**3*T134fin(m6,m4,m1,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - (3*m1**4*m6sq*T134fin(m6,m4,m1,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2) - ((m3sq + m4sq - m6sq)*T134fin(m6,m4,m3,mudim))/((m4sq - m5sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) - (m1**6*T134fin(m6,m5,m1,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - (m1**4*m5sq*T134fin(m6,m5,m1,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + (2*m1sq*m3sq*m5sq*T134fin(m6,m5,m1,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + (3*m1sq*(m5**4 - m6**4)*T134fin(m6,m5,m1,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) - ((m5sq - m6sq)**3*T134fin(m6,m5,m1,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + (3*m1**4*m6sq*T134fin(m6,m5,m1,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + (2*m3sq*m5sq*(-m5sq + m6sq)*T134fin(m6,m5,m1,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2) + ((m3sq + m5sq - m6sq)*T134fin(m6,m5,m3,mudim))/((m4sq - m5sq)*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))))/(m1sq - m3sq)**2
		def eval_200():
			return m1**6/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (m1sq*m4**4)/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (m1**4*m4sq)/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (3*m1sq*m6**4)/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (-(m4sq*m6) + m6**3)**2/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (4*m1**6*m6sq)/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (3*m1**4*m6sq)/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (4*m1**4*m3sq*m6sq)/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (2*m1sq*m4sq*m6sq)/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (4*m4sq*(m4sq - m6sq)*m6sq)/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (4*m1**4*m6sq*(m4sq + m6sq))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (4*m1sq*m3sq*m6sq*(m4sq + m6sq))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (2*m1**6*(m1sq + m4sq + m6sq))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (2*m1**4*m3sq*(m1sq + m4sq + m6sq))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (4*m1**4*m4sq*(m1sq + m4sq + m6sq))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (4*m1sq*m3sq*m4sq*(m1sq + m4sq + m6sq))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (2*m1sq*(m4**4 - m6**4)*(m1sq + m4sq + m6sq))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (2*m3sq*m4sq*(m4sq - m6sq)*(m1sq + m4sq + m6sq))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (2*m3sq*(m4sq - m6sq)*m6sq*(m1sq + m4sq + m6sq))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m4**3 - m4*m6sq)**2/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m1sq*m4**4)/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + (m1**4*m4sq)/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + (3*m1**4*m7sq)/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + ((m4sq - m7sq)**2*m7sq)/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + m1**6/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (3*m1sq*m7**4)/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (4*m1**6*m7sq)/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) - (4*m1**4*m3sq*m7sq)/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (2*m1sq*m4sq*m7sq)/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (4*m4sq*(m4sq - m7sq)*m7sq)/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) - (4*m1**4*m7sq*(m4sq + m7sq))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (4*m1sq*m3sq*m7sq*(m4sq + m7sq))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) - (2*m1**6*(m1sq + m4sq + m7sq))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (2*m1**4*m3sq*(m1sq + m4sq + m7sq))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (4*m1**4*m4sq*(m1sq + m4sq + m7sq))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) - (4*m1sq*m3sq*m4sq*(m1sq + m4sq + m7sq))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) - (2*m1sq*(m4**4 - m7**4)*(m1sq + m4sq + m7sq))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (2*m3sq*m4sq*(m4sq - m7sq)*(m1sq + m4sq + m7sq))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (2*m3sq*(m4sq - m7sq)*m7sq*(m1sq + m4sq + m7sq))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (m4**3 - m4*m7sq)**2/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (2*m1sq*m6**4*B0del(0,0,m1sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - ((-(m4sq*m6) + m6**3)**2*B0del(0,0,m1sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (3*m1**6*m6sq*B0del(0,0,m1sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (m1**4*m6sq*B0del(0,0,m1sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m1**4*m3sq*m6sq*B0del(0,0,m1sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (2*m1sq*m4sq*m6sq*B0del(0,0,m1sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (m1sq*(m4sq - m6sq)**2*m6sq*B0del(0,0,m1sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (m3sq*(m4sq - m6sq)**2*m6sq*B0del(0,0,m1sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (4*m1**4*m6sq*(m4sq + m6sq)*B0del(0,0,m1sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m1sq*m4sq*B0del(0,0,m1sq,mudim))/((m1sq - m3sq)**2*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m1**4*m7sq*B0del(0,0,m1sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + (2*m1sq*m4sq*m7sq*B0del(0,0,m1sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + ((m4sq - m7sq)**2*m7sq*B0del(0,0,m1sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + (2*m1sq*m7**4*B0del(0,0,m1sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) - (3*m1**6*m7sq*B0del(0,0,m1sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (m1**4*m3sq*m7sq*B0del(0,0,m1sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) - (m1sq*(m4sq - m7sq)**2*m7sq*B0del(0,0,m1sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) - (m3sq*(m4sq - m7sq)**2*m7sq*B0del(0,0,m1sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (4*m1**4*m7sq*(m4sq + m7sq)*B0del(0,0,m1sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) - (m1sq*m4sq*B0del(0,0,m1sq,mudim))/((m1sq - m3sq)**2*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) - (m1sq*(m1**4 - m4**4 + m1sq*(4*m4sq - m6sq - m7sq) + m6sq*m7sq)*B0del(0,0,m1sq,mudim))/((m1sq - m3sq)**2*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + (2*m3sq*m6sq*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)**2*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) - (m3sq*m4sq*(2*m3sq + 2*m4sq - m6sq - m7sq)*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)**2*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (2*m3sq*m7sq*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)**2*(m6sq - m7sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m3sq*(m3**4 - m4**4 + m3sq*(4*m4sq - m6sq - m7sq) + m6sq*m7sq)*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)**2*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - ((-(m4sq*m6) + m6**3)**2*B0del(0,0,m4sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (2*m1sq*m4sq*m6sq*B0del(0,0,m4sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (m4sq*(m4sq - m6sq)*m6sq*B0del(0,0,m4sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m6**4*(-m4sq + m6sq)*B0del(0,0,m4sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m1sq*m4sq*B0del(0,0,m4sq,mudim))/((m1sq - m3sq)**2*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m4sq*m6sq*B0del(0,0,m4sq,mudim))/((m1sq - m3sq)**2*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m6sq - m7sq)) - (m4sq*m6sq*B0del(0,0,m4sq,mudim))/((m1sq - m3sq)**2*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m7**4*(m4sq - m7sq)*B0del(0,0,m4sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + (2*m1sq*m4sq*m7sq*B0del(0,0,m4sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + (m4sq*(m4sq - m7sq)*m7sq*B0del(0,0,m4sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + ((m4sq - m7sq)**2*m7sq*B0del(0,0,m4sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) - (m1sq*m4sq*B0del(0,0,m4sq,mudim))/((m1sq - m3sq)**2*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) - (m4sq*m7sq*B0del(0,0,m4sq,mudim))/((m1sq - m3sq)**2*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) - (m3sq*m4sq*(2*m3sq + 2*m4sq - m6sq - m7sq)*B0del(0,0,m4sq,mudim))/((m1sq - m3sq)**2*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m4sq*m7sq*B0del(0,0,m4sq,mudim))/((m1sq - m3sq)**2*(m6sq - m7sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (2*m1sq*m6**4*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (3*m1**6*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m1**4*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m1**4*m3sq*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (m4sq*(m4sq - m6sq)*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (m1sq*(m4sq - m6sq)**2*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (m3sq*(m4sq - m6sq)**2*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m6**4*(-m4sq + m6sq)*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (4*m1**4*m6sq*(m4sq + m6sq)*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m4sq*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m6sq - m7sq)) + (2*m3sq*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) - (m4sq*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m6sq*(m4**4 - m6**4 + m3sq*m6sq - 4*m4sq*m6sq + m1sq*(-m3sq + m6sq))*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) + (2*m1sq*m7**4*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + (m7**4*(m4sq - m7sq)*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + (m4sq*(m4sq - m7sq)*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) - (3*m1**6*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (m1**4*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (m1**4*m3sq*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) - (m1sq*(m4sq - m7sq)**2*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) - (m3sq*(m4sq - m7sq)**2*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (4*m1**4*m7sq*(m4sq + m7sq)*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) - (m4sq*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) - (2*m3sq*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m6sq - m7sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m4sq*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m6sq - m7sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m7sq*(-m4**4 + m7**4 + m1sq*(m3sq - m7sq) - m3sq*m7sq + 4*m4sq*m7sq)*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (m1**6*B0fin(0,0,m1sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m1sq*m4**4*B0fin(0,0,m1sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m1**4*m4sq*B0fin(0,0,m1sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (5*m1sq*m6**4*B0fin(0,0,m1sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (2*(-(m4sq*m6) + m6**3)**2*B0fin(0,0,m1sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (m1**6*m6sq*B0fin(0,0,m1sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (4*m1**4*m6sq*B0fin(0,0,m1sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (3*m1**4*m3sq*m6sq*B0fin(0,0,m1sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (4*m1sq*m4sq*m6sq*B0fin(0,0,m1sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m1sq*(m4sq - m6sq)**2*m6sq*B0fin(0,0,m1sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m3sq*(m4sq - m6sq)**2*m6sq*B0fin(0,0,m1sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (4*m1sq*m3sq*m6sq*(m4sq + m6sq)*B0fin(0,0,m1sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - ((m4**3 - m4*m6sq)**2*B0fin(0,0,m1sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (m1sq*m4sq*B0fin(0,0,m1sq,mudim))/((m1sq - m3sq)**2*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m1**6*B0fin(0,0,m1sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + (5*m1sq*m7**4*B0fin(0,0,m1sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + (4*m1sq*m4sq*m7sq*B0fin(0,0,m1sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + (m1sq*m4**4*B0fin(0,0,m1sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (m1**4*m4sq*B0fin(0,0,m1sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (2*(-(m4sq*m7) + m7**3)**2*B0fin(0,0,m1sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) - (m1**6*m7sq*B0fin(0,0,m1sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (4*m1**4*m7sq*B0fin(0,0,m1sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (3*m1**4*m3sq*m7sq*B0fin(0,0,m1sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (m1sq*(m4sq - m7sq)**2*m7sq*B0fin(0,0,m1sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (m3sq*(m4sq - m7sq)**2*m7sq*B0fin(0,0,m1sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) - (4*m1sq*m3sq*m7sq*(m4sq + m7sq)*B0fin(0,0,m1sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + ((m4**3 - m4*m7sq)**2*B0fin(0,0,m1sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + (m1sq*m4sq*B0fin(0,0,m1sq,mudim))/((m1sq - m3sq)**2*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + (m1sq*(m1**4 - m4**4 + m1sq*(4*m4sq - m6sq - m7sq) + m6sq*m7sq)*B0fin(0,0,m1sq,mudim))/((m1sq - m3sq)**2*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) - (2*m3sq*m6sq*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)**2*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m3sq*m4sq*(2*m3sq + 2*m4sq - m6sq - m7sq)*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)**2*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (2*m3sq*m7sq*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)**2*(m6sq - m7sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (m3sq*(m3**4 - m4**4 + m3sq*(4*m4sq - m6sq - m7sq) + m6sq*m7sq)*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)**2*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m6sq*(m4**4 - m6**4 + m3sq*m6sq - 4*m4sq*m6sq + m1sq*(-m3sq + m6sq))*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/((m1sq - m3sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) - (m1sq*(m1**4 - m4**4 + m1sq*(4*m4sq - m6sq - m7sq) + m6sq*m7sq)*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/((m1sq - m3sq)**2*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + (m3sq*(m3**4 - m4**4 + m3sq*(4*m4sq - m6sq - m7sq) + m6sq*m7sq)*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/((m1sq - m3sq)**2*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m7sq*(-m4**4 + m7**4 + m1sq*(m3sq - m7sq) - m3sq*m7sq + 4*m4sq*m7sq)*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/((m1sq - m3sq)*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (m1**6*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m1sq*m4**4*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m1**4*m4sq*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (3*m1sq*m6**4*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (2*(-(m4sq*m6) + m6**3)**2*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m6**4*(m4sq - m6sq)*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (3*m1**4*m6sq*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (3*m4sq*(m4sq - m6sq)*m6sq*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - ((m4**3 - m4*m6sq)**2*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (m1sq*m4sq*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)**2*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m6sq - m7sq)) - (m4sq*m6sq*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)**2*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m4sq*m6sq*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)**2*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m1**6*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + (3*m1sq*m7**4*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + (3*m4sq*(m4sq - m7sq)*m7sq*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + (m1sq*m4**4*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (m1**4*m4sq*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (2*(-(m4sq*m7) + m7**3)**2*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (m7**4*(m4sq - m7sq)*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (3*m1**4*m7sq*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + ((m4**3 - m4*m7sq)**2*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + (m1sq*m4sq*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)**2*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + (m4sq*m7sq*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)**2*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + (m3sq*m4sq*(2*m3sq + 2*m4sq - m6sq - m7sq)*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)**2*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (m4sq*m7sq*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)**2*(m6sq - m7sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (2*m1sq*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - ((-(m4sq*m6) + m6**3)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (m1**4*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (2*m1sq*m4sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m1sq*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)**2*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m1**4*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + (2*m1sq*m4sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + ((m4sq - m7sq)**2*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + (2*m1sq*m7**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) - (m1sq*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)**2*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) - (m1sq*(m1**4 - m4**4 + m1sq*(4*m4sq - m6sq - m7sq) + m6sq*m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)**2*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) - (m3sq*m4sq*(2*m3sq + 2*m4sq - m6sq - m7sq)*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)**2*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m3sq*(m3**4 - m4**4 + m3sq*(4*m4sq - m6sq - m7sq) + m6sq*m7sq)*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)**2*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (2*m1sq*m6**4*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m6**4*(m4sq - m6sq)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (m1**6*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (m1**4*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (3*m1**4*m3sq*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (4*m1sq*m4sq*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (3*m4sq*(m4sq - m6sq)*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m1sq*(m4sq - m6sq)**2*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m3sq*(m4sq - m6sq)**2*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (4*m1sq*m3sq*m6sq*(m4sq + m6sq)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (m4sq*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m6sq - m7sq)) - (2*m3sq*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m4sq*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m6sq*(-m4**4 + m6**4 + m1sq*(m3sq - m6sq) - m3sq*m6sq + 4*m4sq*m6sq)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) - (3*m1**6*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m1**4*m3sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (m1sq*(m4sq - m6sq)**2*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (m3sq*(m4sq - m6sq)**2*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (4*m1**4*m6sq*(m4sq + m6sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (2*m3sq*m6sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) - (2*m1sq*m6**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m1**4*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (m4sq*(m4sq - m6sq)*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m6**4*(-m4sq + m6sq)*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m4sq*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m6sq - m7sq)) - (m4sq*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)**2*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m6sq*(m4**4 - m6**4 + m3sq*m6sq - 4*m4sq*m6sq + m1sq*(-m3sq + m6sq))*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) - (m1**4*m3sq*(m1sq + m4sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m1**4*m4sq*(m1sq + m4sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (2*m1sq*m3sq*m4sq*(m1sq + m4sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (2*m1sq*(m4**4 - m6**4)*(m1sq + m4sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (m3sq*m4sq*(m4sq - m6sq)*(m1sq + m4sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + ((m4sq - m6sq)**3*(m1sq + m4sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (m1**4*m6sq*(m1sq + m4sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (2*m1sq*m3sq*m6sq*(m1sq + m4sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m3sq*(m4sq - m6sq)*m6sq*(m1sq + m4sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + ((m3sq - m4sq + m6sq)*(m3sq + m4sq + m6sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m1sq - m3sq)**2*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m1**4*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + (3*m4sq*(m4sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + (2*m1sq*m7**4*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (m7**4*(m4sq - m7sq)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) - (m1**6*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (3*m1**4*m3sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (4*m1sq*m4sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (m1sq*(m4sq - m7sq)**2*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (m3sq*(m4sq - m7sq)**2*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) - (4*m1sq*m3sq*m7sq*(m4sq + m7sq)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (m4sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + (2*m3sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m6sq - m7sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (m4sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m6sq - m7sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (m7sq*(-m4**4 + m7**4 + m1sq*(m3sq - m7sq) - m3sq*m7sq + 4*m4sq*m7sq)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (3*m1**6*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (m1**4*m3sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) - (m1sq*(m4sq - m7sq)**2*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) - (m3sq*(m4sq - m7sq)**2*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (4*m1**4*m7sq*(m4sq + m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) - (2*m3sq*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m6sq - m7sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (2*m1sq*m7**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + (m7**4*(m4sq - m7sq)*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + (m4sq*(m4sq - m7sq)*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + (m1**4*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) - (m4sq*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + (m4sq*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)**2*(m6sq - m7sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m7sq*(-m4**4 + m7**4 + m1sq*(m3sq - m7sq) - m3sq*m7sq + 4*m4sq*m7sq)*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (m1**4*m3sq*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (m1**4*m4sq*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (2*m1sq*m3sq*m4sq*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) - (2*m1sq*(m4**4 - m7**4)*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) - (m3sq*m4sq*(m4sq - m7sq)*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + ((m4sq - m7sq)**3*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) - (m1**4*m7sq*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (2*m1sq*m3sq*m7sq*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (m3sq*(m4sq - m7sq)*m7sq*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) - ((m3sq - m4sq + m7sq)*(m3sq + m4sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)**2*(m6sq - m7sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m1**6*T134fin(m6,m4,m1,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (3*m1**4*m4sq*T134fin(m6,m4,m1,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (3*m1sq*(m4**4 - m6**4)*T134fin(m6,m4,m1,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - ((m4sq - m6sq)**3*T134fin(m6,m4,m1,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m1**4*m6sq*T134fin(m6,m4,m1,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (2*m1sq*m3sq*m6sq*T134fin(m6,m4,m1,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (2*m3sq*m6sq*(-m4sq + m6sq)*T134fin(m6,m4,m1,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - ((m3sq - m4sq + m6sq)*T134fin(m6,m4,m3,mudim))/((m1sq - m3sq)**2*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m1**6*T134fin(m7,m4,m1,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) - (3*m1**4*m4sq*T134fin(m7,m4,m1,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (3*m1sq*(m4**4 - m7**4)*T134fin(m7,m4,m1,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) - ((m4sq - m7sq)**3*T134fin(m7,m4,m1,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (m1**4*m7sq*T134fin(m7,m4,m1,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) - (2*m1sq*m3sq*m7sq*T134fin(m7,m4,m1,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (2*m3sq*m7sq*(-m4sq + m7sq)*T134fin(m7,m4,m1,mudim))/((m1sq - m3sq)**2*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + ((m3sq - m4sq + m7sq)*T134fin(m7,m4,m3,mudim))/((m1sq - m3sq)**2*(m6sq - m7sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)))
		def eval_201():
			return (7*m1sq*m4**4)/(2.*(m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (3*m1**4*m4sq)/(2.*(m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (7*m1sq*m6**4)/(2.*(m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (7*m1sq*m5**4)/(2.*(m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) + (3*m1**4*m5sq)/(2.*(m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) - (7*m1sq*m6**4)/(2.*(m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) - (5*m4**4*(m4sq - m6sq))/(2.*(m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (5*m6**4*(m4sq - m6sq))/(2.*(m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m4sq*(m4sq - m6sq)**3)/(2.*m1**2*(m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (5*m5**4*(m5sq - m6sq))/(2.*(m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) - (m5sq*(m5sq - m6sq)**3)/(2.*m1**2*(m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) - (3*m1**4*m6sq)/(2.*(m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m1sq*m4sq*m6sq)/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (3*m1**4*m6sq)/(2.*(m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) - (m1sq*m5sq*m6sq)/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) + ((m5sq - m6sq)**3*m6sq)/(2.*m1**2*(m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) + (m6sq*(-m4sq + m6sq)**3)/(2.*m1**2*(m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (2*m4sq*m6sq*(-m1sq + m4sq + m6sq))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m1**4*(m1sq + m4sq + m6sq))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m4**4*(m1sq + m4sq + m6sq))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m6**4*(m1sq + m4sq + m6sq))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (2*m4sq*m6sq*(m1sq + m4sq + m6sq))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (2*m1sq*(m4sq + m6sq)*(m1sq + m4sq + m6sq))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (5*m6**4*(-m5sq + m6sq))/(2.*(m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) + (2*m5sq*m6sq*(-m1sq + m5sq + m6sq))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) - (m1**4*(m1sq + m5sq + m6sq))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) - (m5**4*(m1sq + m5sq + m6sq))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) - (m6**4*(m1sq + m5sq + m6sq))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) - (2*m5sq*m6sq*(m1sq + m5sq + m6sq))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) + (2*m1sq*(m5sq + m6sq)*(m1sq + m5sq + m6sq))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) + (3*m1**4*m4sq)/(2.*(m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + (7*m1sq*m5**4)/(2.*(m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(m6sq - m7sq)) + (7*m1sq*m7**4)/(2.*(m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(m6sq - m7sq)) + (5*m4**4*(m4sq - m7sq))/(2.*(m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + (5*m7**4*(m5sq - m7sq))/(2.*(m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(m6sq - m7sq)) + (m5sq*(m5sq - m7sq)**3)/(2.*m1**2*(m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(m6sq - m7sq)) + (3*m1**4*m7sq)/(2.*(m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + (m1sq*m5sq*m7sq)/((m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(m6sq - m7sq)) + ((m4sq - m7sq)**3*m7sq)/(2.*m1**2*(m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + (7*m1sq*m4**4)/(2.*(m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (7*m1sq*m7**4)/(2.*(m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (3*m1**4*m5sq)/(2.*(m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(-m6sq + m7sq)) + (5*m7**4*(m4sq - m7sq))/(2.*(m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (m4sq*(m4sq - m7sq)**3)/(2.*m1**2*(m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (5*m5**4*(m5sq - m7sq))/(2.*(m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(-m6sq + m7sq)) + (m1sq*m4sq*m7sq)/((m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (3*m1**4*m7sq)/(2.*(m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(-m6sq + m7sq)) + ((m5sq - m7sq)**3*m7sq)/(2.*m1**2*(m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(-m6sq + m7sq)) - (2*m4sq*m7sq*(-m1sq + m4sq + m7sq))/((m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (m1**4*(m1sq + m4sq + m7sq))/((m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (m4**4*(m1sq + m4sq + m7sq))/((m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (m7**4*(m1sq + m4sq + m7sq))/((m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (2*m4sq*m7sq*(m1sq + m4sq + m7sq))/((m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) - (2*m1sq*(m4sq + m7sq)*(m1sq + m4sq + m7sq))/((m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (2*m5sq*m7sq*(-m1sq + m5sq + m7sq))/((m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(-m6sq + m7sq)) - (m1**4*(m1sq + m5sq + m7sq))/((m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(-m6sq + m7sq)) - (m5**4*(m1sq + m5sq + m7sq))/((m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(-m6sq + m7sq)) - (m7**4*(m1sq + m5sq + m7sq))/((m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(-m6sq + m7sq)) - (2*m5sq*m7sq*(m1sq + m5sq + m7sq))/((m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(-m6sq + m7sq)) + (2*m1sq*(m5sq + m7sq)*(m1sq + m5sq + m7sq))/((m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(-m6sq + m7sq)) + (2*m1sq*m4sq*m6sq*B0del(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (2*m1sq*m5sq*m6sq*B0del(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) + (2*m1sq*m5sq*m7sq*B0del(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(m6sq - m7sq)) + (2*m1sq*m4sq*m7sq*B0del(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (m1sq*m4sq*m6sq*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m4sq*(m4sq - m6sq)*m6sq*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m4sq*m6sq*(-m1sq + m4sq + m6sq)*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m1sq*m4sq*m7sq*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (m4sq*(m4sq - m7sq)*m7sq*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (m4sq*m7sq*(-m1sq + m4sq + m7sq)*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) - (m1sq*m5sq*m6sq*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) - (m5sq*(m5sq - m6sq)*m6sq*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) - (m5sq*m6sq*(-m1sq + m5sq + m6sq)*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) + (m1sq*m5sq*m7sq*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(m6sq - m7sq)) + (m5sq*(m5sq - m7sq)*m7sq*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(m6sq - m7sq)) - (m5sq*m7sq*(-m1sq + m5sq + m7sq)*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(-m6sq + m7sq)) + (m1sq*m4sq*m6sq*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (m1sq*m5sq*m6sq*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) - (m4sq*(m4sq - m6sq)*m6sq*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m5sq*(m5sq - m6sq)*m6sq*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) + (m4sq*m6sq*(-m1sq + m4sq + m6sq)*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (m5sq*m6sq*(-m1sq + m5sq + m6sq)*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) + (m1sq*m5sq*m7sq*B0del(0,0,m7sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(m6sq - m7sq)) + (m4sq*(m4sq - m7sq)*m7sq*B0del(0,0,m7sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + (m1sq*m4sq*m7sq*B0del(0,0,m7sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (m5sq*(m5sq - m7sq)*m7sq*B0del(0,0,m7sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(-m6sq + m7sq)) + (m4sq*m7sq*(-m1sq + m4sq + m7sq)*B0del(0,0,m7sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) - (m5sq*m7sq*(-m1sq + m5sq + m7sq)*B0del(0,0,m7sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(-m6sq + m7sq)) - (7*m1sq*m4**4*B0fin(0,0,m1sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (3*m1**4*m4sq*B0fin(0,0,m1sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (7*m1sq*m6**4*B0fin(0,0,m1sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (7*m1sq*m5**4*B0fin(0,0,m1sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) - (3*m1**4*m5sq*B0fin(0,0,m1sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) + (7*m1sq*m6**4*B0fin(0,0,m1sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) + (5*m4**4*(m4sq - m6sq)*B0fin(0,0,m1sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (m4sq*(m4sq - m6sq)**3*B0fin(0,0,m1sq,mudim))/(2.*m1**2*(m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (5*m5**4*(m5sq - m6sq)*B0fin(0,0,m1sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) + (5*m6**4*(m5sq - m6sq)*B0fin(0,0,m1sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) + (m5sq*(m5sq - m6sq)**3*B0fin(0,0,m1sq,mudim))/(2.*m1**2*(m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) + (3*m1**4*m6sq*B0fin(0,0,m1sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (3*m1sq*m4sq*m6sq*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (3*m1**4*m6sq*B0fin(0,0,m1sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) + (3*m1sq*m5sq*m6sq*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) + ((m4sq - m6sq)**3*m6sq*B0fin(0,0,m1sq,mudim))/(2.*m1**2*(m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (5*m6**4*(-m4sq + m6sq)*B0fin(0,0,m1sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m6sq*(-m5sq + m6sq)**3*B0fin(0,0,m1sq,mudim))/(2.*m1**2*(m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) + (7*m1sq*m4**4*B0fin(0,0,m1sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + (7*m1sq*m7**4*B0fin(0,0,m1sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + (3*m1**4*m5sq*B0fin(0,0,m1sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(m6sq - m7sq)) + (5*m7**4*(m4sq - m7sq)*B0fin(0,0,m1sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + (m4sq*(m4sq - m7sq)**3*B0fin(0,0,m1sq,mudim))/(2.*m1**2*(m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + (5*m5**4*(m5sq - m7sq)*B0fin(0,0,m1sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(m6sq - m7sq)) + (3*m1sq*m4sq*m7sq*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + (3*m1**4*m7sq*B0fin(0,0,m1sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(m6sq - m7sq)) + ((m5sq - m7sq)**3*m7sq*B0fin(0,0,m1sq,mudim))/(2.*m1**2*(m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(m6sq - m7sq)) + (3*m1**4*m4sq*B0fin(0,0,m1sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (7*m1sq*m5**4*B0fin(0,0,m1sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(-m6sq + m7sq)) + (7*m1sq*m7**4*B0fin(0,0,m1sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(-m6sq + m7sq)) + (5*m4**4*(m4sq - m7sq)*B0fin(0,0,m1sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (5*m7**4*(m5sq - m7sq)*B0fin(0,0,m1sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(-m6sq + m7sq)) + (m5sq*(m5sq - m7sq)**3*B0fin(0,0,m1sq,mudim))/(2.*m1**2*(m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(-m6sq + m7sq)) + (3*m1**4*m7sq*B0fin(0,0,m1sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (3*m1sq*m5sq*m7sq*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(-m6sq + m7sq)) + ((m4sq - m7sq)**3*m7sq*B0fin(0,0,m1sq,mudim))/(2.*m1**2*(m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) - (7*m1sq*m4**4*B0fin(0,0,m4sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (3*m1**4*m4sq*B0fin(0,0,m4sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (5*m4**4*(m4sq - m6sq)*B0fin(0,0,m4sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (m4sq*(m4sq - m6sq)**3*B0fin(0,0,m4sq,mudim))/(2.*m1**2*(m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (3*m1sq*m4sq*m6sq*B0fin(0,0,m4sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m4sq*(m4sq - m6sq)*m6sq*B0fin(0,0,m4sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m4sq*m6sq*(-m1sq + m4sq + m6sq)*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (7*m1sq*m4**4*B0fin(0,0,m4sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + (m4sq*(m4sq - m7sq)**3*B0fin(0,0,m4sq,mudim))/(2.*m1**2*(m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + (3*m1sq*m4sq*m7sq*B0fin(0,0,m4sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + (3*m1**4*m4sq*B0fin(0,0,m4sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (5*m4**4*(m4sq - m7sq)*B0fin(0,0,m4sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (m4sq*(m4sq - m7sq)*m7sq*B0fin(0,0,m4sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (m4sq*m7sq*(-m1sq + m4sq + m7sq)*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (m1sq*m4sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m4sq*(m4sq - m6sq)*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m1sq*m4sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (m4sq*(m4sq - m7sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (7*m1sq*m5**4*B0fin(0,0,m5sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) - (3*m1**4*m5sq*B0fin(0,0,m5sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) - (5*m5**4*(m5sq - m6sq)*B0fin(0,0,m5sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) + (m5sq*(m5sq - m6sq)**3*B0fin(0,0,m5sq,mudim))/(2.*m1**2*(m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) + (3*m1sq*m5sq*m6sq*B0fin(0,0,m5sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) - (m5sq*(m5sq - m6sq)*m6sq*B0fin(0,0,m5sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) - (m5sq*m6sq*(-m1sq + m5sq + m6sq)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) + (3*m1**4*m5sq*B0fin(0,0,m5sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(m6sq - m7sq)) + (5*m5**4*(m5sq - m7sq)*B0fin(0,0,m5sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(m6sq - m7sq)) + (m5sq*(m5sq - m7sq)*m7sq*B0fin(0,0,m5sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(m6sq - m7sq)) + (7*m1sq*m5**4*B0fin(0,0,m5sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(-m6sq + m7sq)) + (m5sq*(m5sq - m7sq)**3*B0fin(0,0,m5sq,mudim))/(2.*m1**2*(m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(-m6sq + m7sq)) + (3*m1sq*m5sq*m7sq*B0fin(0,0,m5sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(-m6sq + m7sq)) - (m5sq*m7sq*(-m1sq + m5sq + m7sq)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(-m6sq + m7sq)) - (m1sq*m5sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) - (m5sq*(m5sq - m6sq)*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) + (m1sq*m5sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(m6sq - m7sq)) + (m5sq*(m5sq - m7sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(m6sq - m7sq)) - (7*m1sq*m6**4*B0fin(0,0,m6sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (7*m1sq*m6**4*B0fin(0,0,m6sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) + (5*m6**4*(m5sq - m6sq)*B0fin(0,0,m6sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) + (3*m1**4*m6sq*B0fin(0,0,m6sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (3*m1sq*m4sq*m6sq*B0fin(0,0,m6sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (3*m1**4*m6sq*B0fin(0,0,m6sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) + (3*m1sq*m5sq*m6sq*B0fin(0,0,m6sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) - (m4sq*(m4sq - m6sq)*m6sq*B0fin(0,0,m6sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + ((m4sq - m6sq)**3*m6sq*B0fin(0,0,m6sq,mudim))/(2.*m1**2*(m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m5sq*(m5sq - m6sq)*m6sq*B0fin(0,0,m6sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) + (5*m6**4*(-m4sq + m6sq)*B0fin(0,0,m6sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m4sq*m6sq*(-m1sq + m4sq + m6sq)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m6sq*(-m5sq + m6sq)**3*B0fin(0,0,m6sq,mudim))/(2.*m1**2*(m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) - (m5sq*m6sq*(-m1sq + m5sq + m6sq)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) + (m1sq*m4sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (m1sq*m5sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) - (m4sq*(m4sq - m6sq)*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m5sq*(m5sq - m6sq)*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) + (m4sq*m6sq*(-m1sq + m4sq + m6sq)*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (m5sq*m6sq*(-m1sq + m5sq + m6sq)*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) - (m1**4*((m1sq + m4sq + m6sq)/2. + m1sq*B0fin(0,0,m1sq,mudim) + m4sq*B0fin(0,0,m4sq,mudim) + m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (m4**4*((m1sq + m4sq + m6sq)/2. + m1sq*B0fin(0,0,m1sq,mudim) + m4sq*B0fin(0,0,m4sq,mudim) + m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (m6**4*((m1sq + m4sq + m6sq)/2. + m1sq*B0fin(0,0,m1sq,mudim) + m4sq*B0fin(0,0,m4sq,mudim) + m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m1**4*((m1sq + m5sq + m6sq)/2. + m1sq*B0fin(0,0,m1sq,mudim) + m5sq*B0fin(0,0,m5sq,mudim) + m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) + (m5**4*((m1sq + m5sq + m6sq)/2. + m1sq*B0fin(0,0,m1sq,mudim) + m5sq*B0fin(0,0,m5sq,mudim) + m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) + (m6**4*((m1sq + m5sq + m6sq)/2. + m1sq*B0fin(0,0,m1sq,mudim) + m5sq*B0fin(0,0,m5sq,mudim) + m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) + (m4sq*m6sq*(m1sq + m4sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (m1sq*(m4sq + m6sq)*(m1sq + m4sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) - (m5sq*m6sq*(m1sq + m5sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) - (m1sq*(m5sq + m6sq)*(m1sq + m5sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) + (7*m1sq*m7**4*B0fin(0,0,m7sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + (5*m7**4*(m4sq - m7sq)*B0fin(0,0,m7sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + (3*m1sq*m4sq*m7sq*B0fin(0,0,m7sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + (3*m1**4*m7sq*B0fin(0,0,m7sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(m6sq - m7sq)) + (m4sq*(m4sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + ((m5sq - m7sq)**3*m7sq*B0fin(0,0,m7sq,mudim))/(2.*m1**2*(m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(m6sq - m7sq)) + (7*m1sq*m7**4*B0fin(0,0,m7sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(-m6sq + m7sq)) + (5*m7**4*(m5sq - m7sq)*B0fin(0,0,m7sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(-m6sq + m7sq)) + (3*m1**4*m7sq*B0fin(0,0,m7sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (3*m1sq*m5sq*m7sq*B0fin(0,0,m7sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(-m6sq + m7sq)) + ((m4sq - m7sq)**3*m7sq*B0fin(0,0,m7sq,mudim))/(2.*m1**2*(m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (m5sq*(m5sq - m7sq)*m7sq*B0fin(0,0,m7sq,mudim))/(2.*(m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(-m6sq + m7sq)) + (m4sq*m7sq*(-m1sq + m4sq + m7sq)*B0fin(0,0,m7sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) - (m5sq*m7sq*(-m1sq + m5sq + m7sq)*B0fin(0,0,m7sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(-m6sq + m7sq)) + (m1sq*m5sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(m6sq - m7sq)) + (m4sq*(m4sq - m7sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(m6sq - m7sq)) + (m1sq*m4sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (m5sq*(m5sq - m7sq)*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(-m6sq + m7sq)) + (m4sq*m7sq*(-m1sq + m4sq + m7sq)*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) - (m5sq*m7sq*(-m1sq + m5sq + m7sq)*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/((m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(-m6sq + m7sq)) - (m1**4*((m1sq + m4sq + m7sq)/2. + m1sq*B0fin(0,0,m1sq,mudim) + m4sq*B0fin(0,0,m4sq,mudim) + m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) - (m4**4*((m1sq + m4sq + m7sq)/2. + m1sq*B0fin(0,0,m1sq,mudim) + m4sq*B0fin(0,0,m4sq,mudim) + m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) - (m7**4*((m1sq + m4sq + m7sq)/2. + m1sq*B0fin(0,0,m1sq,mudim) + m4sq*B0fin(0,0,m4sq,mudim) + m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (m1**4*((m1sq + m5sq + m7sq)/2. + m1sq*B0fin(0,0,m1sq,mudim) + m5sq*B0fin(0,0,m5sq,mudim) + m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(-m6sq + m7sq)) + (m5**4*((m1sq + m5sq + m7sq)/2. + m1sq*B0fin(0,0,m1sq,mudim) + m5sq*B0fin(0,0,m5sq,mudim) + m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(-m6sq + m7sq)) + (m7**4*((m1sq + m5sq + m7sq)/2. + m1sq*B0fin(0,0,m1sq,mudim) + m5sq*B0fin(0,0,m5sq,mudim) + m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(-m6sq + m7sq)) + (m4sq*m7sq*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (m1sq*(m4sq + m7sq)*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) - (m5sq*m7sq*(m1sq + m5sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(-m6sq + m7sq)) - (m1sq*(m5sq + m7sq)*(m1sq + m5sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(-m6sq + m7sq)) - (2*m4sq*m6sq*T134fin(m6,m4,m1,mudim))/((m4sq - m5sq)*(m1 + m4 - m6)**2*(m1 - m4 + m6)**2*(-m1 + m4 + m6)**2*(m1 + m4 + m6)**2*(m6sq - m7sq)) + (2*m5sq*m6sq*T134fin(m6,m5,m1,mudim))/((m4sq - m5sq)*(m1 + m5 - m6)**2*(m1 - m5 + m6)**2*(-m1 + m5 + m6)**2*(m1 + m5 + m6)**2*(m6sq - m7sq)) - (2*m4sq*m7sq*T134fin(m7,m4,m1,mudim))/((m4sq - m5sq)*(m1 + m4 - m7)**2*(m1 - m4 + m7)**2*(-m1 + m4 + m7)**2*(m1 + m4 + m7)**2*(-m6sq + m7sq)) + (2*m5sq*m7sq*T134fin(m7,m5,m1,mudim))/((m4sq - m5sq)*(m1 + m5 - m7)**2*(m1 - m5 + m7)**2*(-m1 + m5 + m7)**2*(m1 + m5 + m7)**2*(-m6sq + m7sq))
		def eval_202():
			return (2*m1sq*m4sq*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) - (2*m1sq*m5sq*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) + (m1sq*(m1**4 + m4sq*m5sq - m6**4 - m1sq*(m4sq + m5sq - 4*m6sq))*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) - (m1sq*m6sq*(2*m1sq - m4sq - m5sq + 2*m6sq)*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) - (2*m2sq*m4sq*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m4sq - m5sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))) + (2*m2sq*m5sq*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m4sq - m5sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) - (m2sq*(m2**4 + m4sq*m5sq - m6**4 - m2sq*(m4sq + m5sq - 4*m6sq))*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) + (m2sq*m6sq*(2*m2sq - m4sq - m5sq + 2*m6sq)*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) - (2*m3sq*m4sq*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m4sq - m5sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) + (2*m3sq*m5sq*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m4sq - m5sq)*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) - (m3sq*(m3**4 + m4sq*m5sq - m6**4 - m3sq*(m4sq + m5sq - 4*m6sq))*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) + (m3sq*m6sq*(2*m3sq - m4sq - m5sq + 2*m6sq)*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) + (2*m1sq*m4sq*B0del(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) - (2*m2sq*m4sq*B0del(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m4sq - m5sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))) - (2*m3sq*m4sq*B0del(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m4sq - m5sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) + (m4sq*(-(m3sq*m4**4) + m4**6 + m3sq*m6**4 + 5*m4sq*m6**4 - 2*m6**6 + 12*m4**4*m6sq - 4*m3sq*m4sq*m6sq + m2sq*(-m4**4 + m3sq*m4sq + m6**4 - 4*m4sq*m6sq) + m1sq*(-m4**4 + m3sq*m4sq + m2sq*(-m3sq + m4sq) + m6**4 - 4*m4sq*m6sq))*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) - (m4sq*m6sq*(3*m4**4 - 2*m3sq*m4sq + 3*m6**4 - 2*m3sq*m6sq + 10*m4sq*m6sq + m2sq*(m3sq - 2*(m4sq + m6sq)) + m1sq*(m2sq + m3sq - 2*(m4sq + m6sq)))*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) - (2*m1sq*m5sq*B0del(0,0,m5sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) + (2*m2sq*m5sq*B0del(0,0,m5sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m4sq - m5sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) + (2*m3sq*m5sq*B0del(0,0,m5sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m4sq - m5sq)*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) - (m5sq*(-(m3sq*m5**4) + m5**6 + m3sq*m6**4 + 5*m5sq*m6**4 - 2*m6**6 + 12*m5**4*m6sq - 4*m3sq*m5sq*m6sq + m2sq*(-m5**4 + m3sq*m5sq + m6**4 - 4*m5sq*m6sq) + m1sq*(-m5**4 + m3sq*m5sq + m2sq*(-m3sq + m5sq) + m6**4 - 4*m5sq*m6sq))*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) + (m5sq*m6sq*(3*m5**4 - 2*m3sq*m5sq + 3*m6**4 - 2*m3sq*m6sq + 10*m5sq*m6sq + m2sq*(m3sq - 2*(m5sq + m6sq)) + m1sq*(m2sq + m3sq - 2*(m5sq + m6sq)))*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) - (m1sq*m6sq*(2*m1sq - m4sq - m5sq + 2*m6sq)*B0del(0,0,m6sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) + (m2sq*m6sq*(2*m2sq - m4sq - m5sq + 2*m6sq)*B0del(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) + (m3sq*m6sq*(2*m3sq - m4sq - m5sq + 2*m6sq)*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) - (m4sq*m6sq*(3*m4**4 - 2*m3sq*m4sq + 3*m6**4 - 2*m3sq*m6sq + 10*m4sq*m6sq + m2sq*(m3sq - 2*(m4sq + m6sq)) + m1sq*(m2sq + m3sq - 2*(m4sq + m6sq)))*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) + (m5sq*m6sq*(3*m5**4 - 2*m3sq*m5sq + 3*m6**4 - 2*m3sq*m6sq + 10*m5sq*m6sq + m2sq*(m3sq - 2*(m5sq + m6sq)) + m1sq*(m2sq + m3sq - 2*(m5sq + m6sq)))*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) - (2*m1sq*m4sq*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) + (2*m1sq*m5sq*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) - (m1sq*(m1**4 + m4sq*m5sq - m6**4 - m1sq*(m4sq + m5sq - 4*m6sq))*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) + (m1sq*m6sq*(2*m1sq - m4sq - m5sq + 2*m6sq)*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) + (2*m2sq*m4sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m4sq - m5sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))) - (2*m2sq*m5sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m4sq - m5sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) + (m2sq*(m2**4 + m4sq*m5sq - m6**4 - m2sq*(m4sq + m5sq - 4*m6sq))*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) - (m2sq*m6sq*(2*m2sq - m4sq - m5sq + 2*m6sq)*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) + (2*m3sq*m4sq*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m4sq - m5sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) - (2*m3sq*m5sq*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m4sq - m5sq)*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) + (m3sq*(m3**4 + m4sq*m5sq - m6**4 - m3sq*(m4sq + m5sq - 4*m6sq))*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) - (m3sq*m6sq*(2*m3sq - m4sq - m5sq + 2*m6sq)*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) - (2*m1sq*m4sq*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) + (2*m2sq*m4sq*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m4sq - m5sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))) + (2*m3sq*m4sq*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m4sq - m5sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) - (m4sq*(-(m3sq*m4**4) + m4**6 + m3sq*m6**4 + 5*m4sq*m6**4 - 2*m6**6 + 12*m4**4*m6sq - 4*m3sq*m4sq*m6sq + m2sq*(-m4**4 + m3sq*m4sq + m6**4 - 4*m4sq*m6sq) + m1sq*(-m4**4 + m3sq*m4sq + m2sq*(-m3sq + m4sq) + m6**4 - 4*m4sq*m6sq))*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) + (m4sq*m6sq*(3*m4**4 - 2*m3sq*m4sq + 3*m6**4 - 2*m3sq*m6sq + 10*m4sq*m6sq + m2sq*(m3sq - 2*(m4sq + m6sq)) + m1sq*(m2sq + m3sq - 2*(m4sq + m6sq)))*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) + (2*m1sq*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) - (2*m2sq*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m4sq - m5sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))) - (2*m3sq*m4sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m4sq - m5sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) + (2*m1sq*m5sq*B0fin(0,0,m5sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) - (2*m2sq*m5sq*B0fin(0,0,m5sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m4sq - m5sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) - (2*m3sq*m5sq*B0fin(0,0,m5sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m4sq - m5sq)*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) + (m5sq*(-(m3sq*m5**4) + m5**6 + m3sq*m6**4 + 5*m5sq*m6**4 - 2*m6**6 + 12*m5**4*m6sq - 4*m3sq*m5sq*m6sq + m2sq*(-m5**4 + m3sq*m5sq + m6**4 - 4*m5sq*m6sq) + m1sq*(-m5**4 + m3sq*m5sq + m2sq*(-m3sq + m5sq) + m6**4 - 4*m5sq*m6sq))*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) - (m5sq*m6sq*(3*m5**4 - 2*m3sq*m5sq + 3*m6**4 - 2*m3sq*m6sq + 10*m5sq*m6sq + m2sq*(m3sq - 2*(m5sq + m6sq)) + m1sq*(m2sq + m3sq - 2*(m5sq + m6sq)))*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) - (2*m1sq*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) + (2*m2sq*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m4sq - m5sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) + (2*m3sq*m5sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m4sq - m5sq)*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) + (m1sq*(m1**4 + m4sq*m5sq - m6**4 - m1sq*(m4sq + m5sq - 4*m6sq))*(B0del(0,0,m6sq,mudim) - B0fin(0,0,m6sq,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) - (m2sq*(m2**4 + m4sq*m5sq - m6**4 - m2sq*(m4sq + m5sq - 4*m6sq))*(B0del(0,0,m6sq,mudim) - B0fin(0,0,m6sq,mudim)))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) - (m3sq*(m3**4 + m4sq*m5sq - m6**4 - m3sq*(m4sq + m5sq - 4*m6sq))*(B0del(0,0,m6sq,mudim) - B0fin(0,0,m6sq,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) + (m4sq*(-(m3sq*m4**4) + m4**6 + m3sq*m6**4 + 5*m4sq*m6**4 - 2*m6**6 + 12*m4**4*m6sq - 4*m3sq*m4sq*m6sq + m2sq*(-m4**4 + m3sq*m4sq + m6**4 - 4*m4sq*m6sq) + m1sq*(-m4**4 + m3sq*m4sq + m2sq*(-m3sq + m4sq) + m6**4 - 4*m4sq*m6sq))*(B0del(0,0,m6sq,mudim) - B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) - (m5sq*(-(m3sq*m5**4) + m5**6 + m3sq*m6**4 + 5*m5sq*m6**4 - 2*m6**6 + 12*m5**4*m6sq - 4*m3sq*m5sq*m6sq + m2sq*(-m5**4 + m3sq*m5sq + m6**4 - 4*m5sq*m6sq) + m1sq*(-m5**4 + m3sq*m5sq + m2sq*(-m3sq + m5sq) + m6**4 - 4*m5sq*m6sq))*(B0del(0,0,m6sq,mudim) - B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) + (m1sq*m6sq*(2*m1sq - m4sq - m5sq + 2*m6sq)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) - (m2sq*m6sq*(2*m2sq - m4sq - m5sq + 2*m6sq)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) - (m3sq*m6sq*(2*m3sq - m4sq - m5sq + 2*m6sq)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) + (m4sq*m6sq*(3*m4**4 - 2*m3sq*m4sq + 3*m6**4 - 2*m3sq*m6sq + 10*m4sq*m6sq + m2sq*(m3sq - 2*(m4sq + m6sq)) + m1sq*(m2sq + m3sq - 2*(m4sq + m6sq)))*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) - (m5sq*m6sq*(3*m5**4 - 2*m3sq*m5sq + 3*m6**4 - 2*m3sq*m6sq + 10*m5sq*m6sq + m2sq*(m3sq - 2*(m5sq + m6sq)) + m1sq*(m2sq + m3sq - 2*(m5sq + m6sq)))*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) + (m1sq*(m1**4 + m4sq*m5sq - m6**4 - m1sq*(m4sq + m5sq - 4*m6sq))*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) - (m1sq*m6sq*(2*m1sq - m4sq - m5sq + 2*m6sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) - (m2sq*(m2**4 + m4sq*m5sq - m6**4 - m2sq*(m4sq + m5sq - 4*m6sq))*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) + (m2sq*m6sq*(2*m2sq - m4sq - m5sq + 2*m6sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) - (m3sq*(m3**4 + m4sq*m5sq - m6**4 - m3sq*(m4sq + m5sq - 4*m6sq))*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) + (m3sq*m6sq*(2*m3sq - m4sq - m5sq + 2*m6sq)*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) + (m4sq*(-(m3sq*m4**4) + m4**6 + m3sq*m6**4 + 5*m4sq*m6**4 - 2*m6**6 + 12*m4**4*m6sq - 4*m3sq*m4sq*m6sq + m2sq*(-m4**4 + m3sq*m4sq + m6**4 - 4*m4sq*m6sq) + m1sq*(-m4**4 + m3sq*m4sq + m2sq*(-m3sq + m4sq) + m6**4 - 4*m4sq*m6sq))*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) - (m4sq*m6sq*(3*m4**4 - 2*m3sq*m4sq + 3*m6**4 - 2*m3sq*m6sq + 10*m4sq*m6sq + m2sq*(m3sq - 2*(m4sq + m6sq)) + m1sq*(m2sq + m3sq - 2*(m4sq + m6sq)))*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) - (m5sq*(-(m3sq*m5**4) + m5**6 + m3sq*m6**4 + 5*m5sq*m6**4 - 2*m6**6 + 12*m5**4*m6sq - 4*m3sq*m5sq*m6sq + m2sq*(-m5**4 + m3sq*m5sq + m6**4 - 4*m5sq*m6sq) + m1sq*(-m5**4 + m3sq*m5sq + m2sq*(-m3sq + m5sq) + m6**4 - 4*m5sq*m6sq))*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) + (m5sq*m6sq*(3*m5**4 - 2*m3sq*m5sq + 3*m6**4 - 2*m3sq*m6sq + 10*m5sq*m6sq + m2sq*(m3sq - 2*(m5sq + m6sq)) + m1sq*(m2sq + m3sq - 2*(m5sq + m6sq)))*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) + ((m1sq + m4sq - m6sq)*(m1sq + m4sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)*(m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) - ((m2sq + m4sq - m6sq)*(m2sq + m4sq + m6sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m1sq - m2sq)*(m2sq - m3sq)*(m4sq - m5sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))) - ((m3sq + m4sq - m6sq)*(m3sq + m4sq + m6sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)*(m4sq - m5sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) - ((m1sq + m5sq - m6sq)*(m1sq + m5sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)*(m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) + ((m2sq + m5sq - m6sq)*(m2sq + m5sq + m6sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m1sq - m2sq)*(m2sq - m3sq)*(m4sq - m5sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) + ((m3sq + m5sq - m6sq)*(m3sq + m5sq + m6sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)*(m4sq - m5sq)*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq))) - ((m1sq + m4sq - m6sq)*T134fin(m6,m4,m1,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) + ((m2sq + m4sq - m6sq)*T134fin(m6,m4,m2,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m4sq - m5sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))) + ((m3sq + m4sq - m6sq)*T134fin(m6,m4,m3,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m4sq - m5sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))) + ((m1sq + m5sq - m6sq)*T134fin(m6,m5,m1,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))) - ((m2sq + m5sq - m6sq)*T134fin(m6,m5,m2,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m4sq - m5sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))) - ((m3sq + m5sq - m6sq)*T134fin(m6,m5,m3,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m4sq - m5sq)*(m3**4 + (m5sq - m6sq)**2 - 2*m3sq*(m5sq + m6sq)))
		def eval_203():
			return (2*m1sq*m6sq*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m6sq - m7sq)) - (m1sq*m4sq*(2*m1sq + 2*m4sq - m6sq - m7sq)*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) - (2*m1sq*m7sq*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + (m1sq*(m1**4 - m4**4 + m1sq*(4*m4sq - m6sq - m7sq) + m6sq*m7sq)*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) - (2*m2sq*m6sq*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m2sq*m4sq*(2*m2sq + 2*m4sq - m6sq - m7sq)*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) + (2*m2sq*m7sq*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m6sq - m7sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) - (m2sq*(m2**4 - m4**4 + m2sq*(4*m4sq - m6sq - m7sq) + m6sq*m7sq)*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) - (2*m3sq*m6sq*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m3sq*m4sq*(2*m3sq + 2*m4sq - m6sq - m7sq)*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (2*m3sq*m7sq*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m6sq - m7sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (m3sq*(m3**4 - m4**4 + m3sq*(4*m4sq - m6sq - m7sq) + m6sq*m7sq)*B0del(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (m4sq*m6sq*(3*m4**4 - 2*m3sq*m4sq + 3*m6**4 - 2*m3sq*m6sq + 10*m4sq*m6sq + m2sq*(m3sq - 2*(m4sq + m6sq)) + m1sq*(m2sq + m3sq - 2*(m4sq + m6sq)))*B0del(0,0,m4sq,mudim))/((m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) - (m1sq*m4sq*(2*m1sq + 2*m4sq - m6sq - m7sq)*B0del(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + (m2sq*m4sq*(2*m2sq + 2*m4sq - m6sq - m7sq)*B0del(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) + (m3sq*m4sq*(2*m3sq + 2*m4sq - m6sq - m7sq)*B0del(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m4sq*m7sq*(3*m4**4 - 2*m3sq*m4sq + 3*m7**4 - 2*m3sq*m7sq + 10*m4sq*m7sq + m2sq*(m3sq - 2*(m4sq + m7sq)) + m1sq*(m2sq + m3sq - 2*(m4sq + m7sq)))*B0del(0,0,m4sq,mudim))/((m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (2*m1sq*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m6sq - m7sq)) - (2*m2sq*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m6sq - m7sq)) - (2*m3sq*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m6sq*(m3sq*m4**4 - 2*m4**6 - m3sq*m6**4 + 12*m4sq*m6**4 + m6**6 + 5*m4**4*m6sq - 4*m3sq*m4sq*m6sq + m2sq*(m4**4 - m6**4 + m3sq*m6sq - 4*m4sq*m6sq) + m1sq*(m4**4 - m6**4 + m3sq*m6sq - 4*m4sq*m6sq + m2sq*(-m3sq + m6sq)))*B0del(0,0,m6sq,mudim))/((m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) - (m4sq*m6sq*(3*m4**4 - 2*m3sq*m4sq + 3*m6**4 - 2*m3sq*m6sq + 10*m4sq*m6sq + m2sq*(m3sq - 2*(m4sq + m6sq)) + m1sq*(m2sq + m3sq - 2*(m4sq + m6sq)))*B0del(0,0,m6sq,mudim))/((m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) - (2*m1sq*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + (2*m2sq*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m6sq - m7sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) + (2*m3sq*m7sq*B0del(0,0,m7sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m6sq - m7sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (m7sq*(m3sq*m4**4 - 2*m4**6 - m3sq*m7**4 + 12*m4sq*m7**4 + m7**6 + 5*m4**4*m7sq - 4*m3sq*m4sq*m7sq + m2sq*(m4**4 - m7**4 + m3sq*m7sq - 4*m4sq*m7sq) + m1sq*(m4**4 - m7**4 + m3sq*m7sq - 4*m4sq*m7sq + m2sq*(-m3sq + m7sq)))*B0del(0,0,m7sq,mudim))/((m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m4sq*m7sq*(3*m4**4 - 2*m3sq*m4sq + 3*m7**4 - 2*m3sq*m7sq + 10*m4sq*m7sq + m2sq*(m3sq - 2*(m4sq + m7sq)) + m1sq*(m2sq + m3sq - 2*(m4sq + m7sq)))*B0del(0,0,m7sq,mudim))/((m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (2*m1sq*m6sq*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m1sq*m4sq*(2*m1sq + 2*m4sq - m6sq - m7sq)*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + (2*m1sq*m7sq*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) - (m1sq*(m1**4 - m4**4 + m1sq*(4*m4sq - m6sq - m7sq) + m6sq*m7sq)*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + (2*m2sq*m6sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m6sq - m7sq)) - (m2sq*m4sq*(2*m2sq + 2*m4sq - m6sq - m7sq)*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) - (2*m2sq*m7sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m6sq - m7sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) + (m2sq*(m2**4 - m4**4 + m2sq*(4*m4sq - m6sq - m7sq) + m6sq*m7sq)*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) + (2*m3sq*m6sq*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) - (m3sq*m4sq*(2*m3sq + 2*m4sq - m6sq - m7sq)*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (2*m3sq*m7sq*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m6sq - m7sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m3sq*(m3**4 - m4**4 + m3sq*(4*m4sq - m6sq - m7sq) + m6sq*m7sq)*B0fin(0,0,m3sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m6sq*(m3sq*m4**4 - 2*m4**6 - m3sq*m6**4 + 12*m4sq*m6**4 + m6**6 + 5*m4**4*m6sq - 4*m3sq*m4sq*m6sq + m2sq*(m4**4 - m6**4 + m3sq*m6sq - 4*m4sq*m6sq) + m1sq*(m4**4 - m6**4 + m3sq*m6sq - 4*m4sq*m6sq + m2sq*(-m3sq + m6sq)))*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/((m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m1sq*(m1**4 - m4**4 + m1sq*(4*m4sq - m6sq - m7sq) + m6sq*m7sq)*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) - (m2sq*(m2**4 - m4**4 + m2sq*(4*m4sq - m6sq - m7sq) + m6sq*m7sq)*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) - (m3sq*(m3**4 - m4**4 + m3sq*(4*m4sq - m6sq - m7sq) + m6sq*m7sq)*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (m7sq*(m3sq*m4**4 - 2*m4**6 - m3sq*m7**4 + 12*m4sq*m7**4 + m7**6 + 5*m4**4*m7sq - 4*m3sq*m4sq*m7sq + m2sq*(m4**4 - m7**4 + m3sq*m7sq - 4*m4sq*m7sq) + m1sq*(m4**4 - m7**4 + m3sq*m7sq - 4*m4sq*m7sq + m2sq*(-m3sq + m7sq)))*(B0del(0,0,m4sq,mudim) - B0fin(0,0,m4sq,mudim)))/((m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m4sq*m6sq*(3*m4**4 - 2*m3sq*m4sq + 3*m6**4 - 2*m3sq*m6sq + 10*m4sq*m6sq + m2sq*(m3sq - 2*(m4sq + m6sq)) + m1sq*(m2sq + m3sq - 2*(m4sq + m6sq)))*B0fin(0,0,m4sq,mudim))/((m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m1sq*m4sq*(2*m1sq + 2*m4sq - m6sq - m7sq)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) - (m2sq*m4sq*(2*m2sq + 2*m4sq - m6sq - m7sq)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) - (m3sq*m4sq*(2*m3sq + 2*m4sq - m6sq - m7sq)*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (m4sq*m7sq*(3*m4**4 - 2*m3sq*m4sq + 3*m7**4 - 2*m3sq*m7sq + 10*m4sq*m7sq + m2sq*(m3sq - 2*(m4sq + m7sq)) + m1sq*(m2sq + m3sq - 2*(m4sq + m7sq)))*B0fin(0,0,m4sq,mudim))/((m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (m1sq*m4sq*(2*m1sq + 2*m4sq - m6sq - m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + (m1sq*(m1**4 - m4**4 + m1sq*(4*m4sq - m6sq - m7sq) + m6sq*m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + (m2sq*m4sq*(2*m2sq + 2*m4sq - m6sq - m7sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) - (m2sq*(m2**4 - m4**4 + m2sq*(4*m4sq - m6sq - m7sq) + m6sq*m7sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) + (m3sq*m4sq*(2*m3sq + 2*m4sq - m6sq - m7sq)*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (m3sq*(m3**4 - m4**4 + m3sq*(4*m4sq - m6sq - m7sq) + m6sq*m7sq)*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (2*m1sq*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m6sq - m7sq)) + (2*m2sq*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m6sq - m7sq)) + (2*m3sq*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) - (m6sq*(m3sq*m4**4 - 2*m4**6 - m3sq*m6**4 + 12*m4sq*m6**4 + m6**6 + 5*m4**4*m6sq - 4*m3sq*m4sq*m6sq + m2sq*(m4**4 - m6**4 + m3sq*m6sq - 4*m4sq*m6sq) + m1sq*(m4**4 - m6**4 + m3sq*m6sq - 4*m4sq*m6sq + m2sq*(-m3sq + m6sq)))*B0fin(0,0,m6sq,mudim))/((m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m4sq*m6sq*(3*m4**4 - 2*m3sq*m4sq + 3*m6**4 - 2*m3sq*m6sq + 10*m4sq*m6sq + m2sq*(m3sq - 2*(m4sq + m6sq)) + m1sq*(m2sq + m3sq - 2*(m4sq + m6sq)))*B0fin(0,0,m6sq,mudim))/((m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) + (2*m1sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m6sq - m7sq)) - (2*m2sq*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m6sq - m7sq)) - (2*m3sq*m6sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m6sq*(m3sq*m4**4 - 2*m4**6 - m3sq*m6**4 + 12*m4sq*m6**4 + m6**6 + 5*m4**4*m6sq - 4*m3sq*m4sq*m6sq + m2sq*(m4**4 - m6**4 + m3sq*m6sq - 4*m4sq*m6sq) + m1sq*(m4**4 - m6**4 + m3sq*m6sq - 4*m4sq*m6sq + m2sq*(-m3sq + m6sq)))*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) - (m4sq*m6sq*(3*m4**4 - 2*m3sq*m4sq + 3*m6**4 - 2*m3sq*m6sq + 10*m4sq*m6sq + m2sq*(m3sq - 2*(m4sq + m6sq)) + m1sq*(m2sq + m3sq - 2*(m4sq + m6sq)))*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) + ((m1sq - m4sq + m6sq)*(m1sq + m4sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m6sq - m7sq)) - ((m2sq - m4sq + m6sq)*(m2sq + m4sq + m6sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m6sq - m7sq)) - ((m3sq - m4sq + m6sq)*(m3sq + m4sq + m6sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) + (2*m1sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) - (2*m2sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m6sq - m7sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) - (2*m3sq*m7sq*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m6sq - m7sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m7sq*(m3sq*m4**4 - 2*m4**6 - m3sq*m7**4 + 12*m4sq*m7**4 + m7**6 + 5*m4**4*m7sq - 4*m3sq*m4sq*m7sq + m2sq*(m4**4 - m7**4 + m3sq*m7sq - 4*m4sq*m7sq) + m1sq*(m4**4 - m7**4 + m3sq*m7sq - 4*m4sq*m7sq + m2sq*(-m3sq + m7sq)))*B0fin(0,0,m7sq,mudim))/((m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (m4sq*m7sq*(3*m4**4 - 2*m3sq*m4sq + 3*m7**4 - 2*m3sq*m7sq + 10*m4sq*m7sq + m2sq*(m3sq - 2*(m4sq + m7sq)) + m1sq*(m2sq + m3sq - 2*(m4sq + m7sq)))*B0fin(0,0,m7sq,mudim))/((m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (2*m1sq*m7sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + (2*m2sq*m7sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m6sq - m7sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) + (2*m3sq*m7sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m7sq,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m6sq - m7sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - (m7sq*(m3sq*m4**4 - 2*m4**6 - m3sq*m7**4 + 12*m4sq*m7**4 + m7**6 + 5*m4**4*m7sq - 4*m3sq*m4sq*m7sq + m2sq*(m4**4 - m7**4 + m3sq*m7sq - 4*m4sq*m7sq) + m1sq*(m4**4 - m7**4 + m3sq*m7sq - 4*m4sq*m7sq + m2sq*(-m3sq + m7sq)))*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) + (m4sq*m7sq*(3*m4**4 - 2*m3sq*m4sq + 3*m7**4 - 2*m3sq*m7sq + 10*m4sq*m7sq + m2sq*(m3sq - 2*(m4sq + m7sq)) + m1sq*(m2sq + m3sq - 2*(m4sq + m7sq)))*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - ((m1sq - m4sq + m7sq)*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)*(m1sq - m3sq)*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + ((m2sq - m4sq + m7sq)*(m2sq + m4sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m2sq)*(m2sq - m3sq)*(m6sq - m7sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) + ((m3sq - m4sq + m7sq)*(m3sq + m4sq + m7sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m1sq - m3sq)*(-m2sq + m3sq)*(m6sq - m7sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq))) - ((m1sq - m4sq + m6sq)*T134fin(m6,m4,m1,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m6sq - m7sq)) + ((m2sq - m4sq + m6sq)*T134fin(m6,m4,m2,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m6sq - m7sq)) + ((m3sq - m4sq + m6sq)*T134fin(m6,m4,m3,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m3**4 + (m4sq - m6sq)**2 - 2*m3sq*(m4sq + m6sq))*(m6sq - m7sq)) + ((m1sq - m4sq + m7sq)*T134fin(m7,m4,m1,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) - ((m2sq - m4sq + m7sq)*T134fin(m7,m4,m2,mudim))/((m1sq - m2sq)*(m2sq - m3sq)*(m6sq - m7sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) - ((m3sq - m4sq + m7sq)*T134fin(m7,m4,m3,mudim))/((m1sq - m3sq)*(-m2sq + m3sq)*(m6sq - m7sq)*(m3**4 + (m4sq - m7sq)**2 - 2*m3sq*(m4sq + m7sq)))
		def eval_204():
			return (((m1sq - m2sq)*m2sq*m6sq*(2*m2sq - m4sq - m5sq + 2*m6sq)*B0del(0,0,m2sq,mudim))/((m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))*(m6sq - m7sq)) + ((m1sq - m2sq)*m2sq*m4sq*(2*m2sq + 2*m4sq - m6sq - m7sq)*B0del(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) + (m2sq*(-m1sq + m2sq)*m5sq*(2*m2sq + 2*m5sq - m6sq - m7sq)*B0del(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + (m2sq*(-m1sq + m2sq)*m7sq*(2*m2sq - m4sq - m5sq + 2*m7sq)*B0del(0,0,m2sq,mudim))/((m6sq - m7sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) - (2*(m1sq - m2sq)*m4sq*m6sq*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m6sq - m7sq)) + ((m1sq - m2sq)*m4sq*(m2**4 - 4*m2sq*m4sq - (m4sq - m6sq)*(m4sq - m7sq))*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) + ((m1sq - m2sq)*m2sq*m4sq*(2*m2sq + 2*m4sq - m6sq - m7sq)*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) + (2*(m1sq - m2sq)*m4sq*m7sq*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m6sq - m7sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) + (2*(m1sq - m2sq)*m5sq*m6sq*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))*(m6sq - m7sq)) + ((m1sq - m2sq)*m5sq*(-m2**4 + 4*m2sq*m5sq + (m5sq - m6sq)*(m5sq - m7sq))*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + (m2sq*(-m1sq + m2sq)*m5sq*(2*m2sq + 2*m5sq - m6sq - m7sq)*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) - (2*(m1sq - m2sq)*m5sq*m7sq*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m6sq - m7sq)*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) - (2*(m1sq - m2sq)*m4sq*m6sq*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m6sq - m7sq)) + (2*(m1sq - m2sq)*m5sq*m6sq*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))*(m6sq - m7sq)) + ((m1sq - m2sq)*m2sq*m6sq*(2*m2sq - m4sq - m5sq + 2*m6sq)*B0del(0,0,m6sq,mudim))/((m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))*(m6sq - m7sq)) + ((m1sq - m2sq)*m6sq*(m2**4 - 4*m2sq*m6sq + (m4sq - m6sq)*(-m5sq + m6sq))*B0del(0,0,m6sq,mudim))/((m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))*(m6sq - m7sq)) + (2*(m1sq - m2sq)*m4sq*m7sq*B0del(0,0,m7sq,mudim))/((m4sq - m5sq)*(m6sq - m7sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) - (2*(m1sq - m2sq)*m5sq*m7sq*B0del(0,0,m7sq,mudim))/((m4sq - m5sq)*(m6sq - m7sq)*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + (m2sq*(-m1sq + m2sq)*m7sq*(2*m2sq - m4sq - m5sq + 2*m7sq)*B0del(0,0,m7sq,mudim))/((m6sq - m7sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) - ((m1sq - m2sq)*m7sq*(m2**4 - 4*m2sq*m7sq + (m4sq - m7sq)*(-m5sq + m7sq))*B0del(0,0,m7sq,mudim))/((m6sq - m7sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + ((m1sq - m2sq)*m6sq*(m2**4 - 4*m2sq*m6sq + (m4sq - m6sq)*(-m5sq + m6sq))*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)))/((m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))*(m6sq - m7sq)) + ((m1sq - m2sq)*m4sq*(m2**4 - 4*m2sq*m4sq - (m4sq - m6sq)*(m4sq - m7sq))*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)))/((m4sq - m5sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) + ((m1sq - m2sq)*m5sq*(-m2**4 + 4*m2sq*m5sq + (m5sq - m6sq)*(m5sq - m7sq))*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)))/((m4sq - m5sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) - ((m1sq - m2sq)*m7sq*(m2**4 - 4*m2sq*m7sq + (m4sq - m7sq)*(-m5sq + m7sq))*(B0del(0,0,m2sq,mudim) - B0fin(0,0,m2sq,mudim)))/((m6sq - m7sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + (m2sq*(-m1sq + m2sq)*m6sq*(2*m2sq - m4sq - m5sq + 2*m6sq)*B0fin(0,0,m2sq,mudim))/((m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))*(m6sq - m7sq)) + (m2sq*(-m1sq + m2sq)*m4sq*(2*m2sq + 2*m4sq - m6sq - m7sq)*B0fin(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) + ((m1sq - m2sq)*m2sq*m5sq*(2*m2sq + 2*m5sq - m6sq - m7sq)*B0fin(0,0,m2sq,mudim))/((m4sq - m5sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + ((m1sq - m2sq)*m2sq*m7sq*(2*m2sq - m4sq - m5sq + 2*m7sq)*B0fin(0,0,m2sq,mudim))/((m6sq - m7sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + (2*(m1sq - m2sq)*m4sq*m6sq*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m6sq - m7sq)) - ((m1sq - m2sq)*m4sq*(m2**4 - 4*m2sq*m4sq - (m4sq - m6sq)*(m4sq - m7sq))*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) + (m2sq*(-m1sq + m2sq)*m4sq*(2*m2sq + 2*m4sq - m6sq - m7sq)*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) - (2*(m1sq - m2sq)*m4sq*m7sq*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m6sq - m7sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) + ((m1sq - m2sq)*m4sq*(m2**4 - 4*m2sq*m4sq - (m4sq - m6sq)*(m4sq - m7sq))*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) + ((m1sq - m2sq)*m2sq*m4sq*(2*m2sq + 2*m4sq - m6sq - m7sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) - (2*(m1sq - m2sq)*m5sq*m6sq*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))*(m6sq - m7sq)) + ((m1sq - m2sq)*m5sq*(m2**4 - 4*m2sq*m5sq - (m5sq - m6sq)*(m5sq - m7sq))*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + ((m1sq - m2sq)*m2sq*m5sq*(2*m2sq + 2*m5sq - m6sq - m7sq)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + (2*(m1sq - m2sq)*m5sq*m7sq*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m6sq - m7sq)*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + ((m1sq - m2sq)*m5sq*(-m2**4 + 4*m2sq*m5sq + (m5sq - m6sq)*(m5sq - m7sq))*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + (m2sq*(-m1sq + m2sq)*m5sq*(2*m2sq + 2*m5sq - m6sq - m7sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + (2*(m1sq - m2sq)*m4sq*m6sq*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m6sq - m7sq)) - (2*(m1sq - m2sq)*m5sq*m6sq*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))*(m6sq - m7sq)) + (m2sq*(-m1sq + m2sq)*m6sq*(2*m2sq - m4sq - m5sq + 2*m6sq)*B0fin(0,0,m6sq,mudim))/((m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))*(m6sq - m7sq)) - ((m1sq - m2sq)*m6sq*(m2**4 - 4*m2sq*m6sq + (m4sq - m6sq)*(-m5sq + m6sq))*B0fin(0,0,m6sq,mudim))/((m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))*(m6sq - m7sq)) + ((m1sq - m2sq)*m2sq*m6sq*(2*m2sq - m4sq - m5sq + 2*m6sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))*(m6sq - m7sq)) + ((m1sq - m2sq)*m6sq*(m2**4 - 4*m2sq*m6sq + (m4sq - m6sq)*(-m5sq + m6sq))*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))*(m6sq - m7sq)) - (2*(m1sq - m2sq)*m4sq*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m6sq - m7sq)) + (2*(m1sq - m2sq)*m5sq*m6sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))*(m6sq - m7sq)) + ((m1sq - m2sq)*(m2sq - m4sq - m6sq)*(m2sq + m4sq + m6sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m2**4 + (m4sq - m6sq)**2 - 2*m2sq*(m4sq + m6sq))*(m6sq - m7sq)) + (m2**4*(m2sq + m5sq + m6sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))*(m6sq - m7sq)) - (m2sq*(m5sq + m6sq)*(m2sq + m5sq + m6sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))*(m6sq - m7sq)) + (m1sq*(-m2sq + m5sq + m6sq)*(m2sq + m5sq + m6sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))*(m6sq - m7sq)) - (2*(m1sq - m2sq)*m4sq*m7sq*B0fin(0,0,m7sq,mudim))/((m4sq - m5sq)*(m6sq - m7sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) + (2*(m1sq - m2sq)*m5sq*m7sq*B0fin(0,0,m7sq,mudim))/((m4sq - m5sq)*(m6sq - m7sq)*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + ((m1sq - m2sq)*m2sq*m7sq*(2*m2sq - m4sq - m5sq + 2*m7sq)*B0fin(0,0,m7sq,mudim))/((m6sq - m7sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + ((m1sq - m2sq)*m7sq*(m2**4 - 4*m2sq*m7sq + (m4sq - m7sq)*(-m5sq + m7sq))*B0fin(0,0,m7sq,mudim))/((m6sq - m7sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + (m2sq*(-m1sq + m2sq)*m7sq*(2*m2sq - m4sq - m5sq + 2*m7sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m6sq - m7sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) - ((m1sq - m2sq)*m7sq*(m2**4 - 4*m2sq*m7sq + (m4sq - m7sq)*(-m5sq + m7sq))*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m7sq,mudim))/((m6sq - m7sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + (2*(m1sq - m2sq)*m4sq*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m4sq - m5sq)*(m6sq - m7sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) - (2*(m1sq - m2sq)*m5sq*m7sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/((m4sq - m5sq)*(m6sq - m7sq)*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + (m2**4*(m2sq + m4sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m5sq)*(m6sq - m7sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) - (m2sq*(m4sq + m7sq)*(m2sq + m4sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m5sq)*(m6sq - m7sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) + (m1sq*(-m2sq + m4sq + m7sq)*(m2sq + m4sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m5sq)*(m6sq - m7sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) + ((m1sq - m2sq)*(m2sq - m5sq - m7sq)*(m2sq + m5sq + m7sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m5sq)*(m6sq - m7sq)*(m2**4 + (m5sq - m7sq)**2 - 2*m2sq*(m5sq + m7sq))) + T134fin(m6,m4,m1,mudim)/((m4sq - m5sq)*(m6sq - m7sq)) - T134fin(m6,m4,m2,mudim)/((m4sq - m5sq)*(m6sq - m7sq)) + ((m1sq - m2sq)*(m2sq - m4sq - m6sq)*T134fin(m6,m4,m2,mudim))/((m4sq - m5sq)*(4*m4sq*m6sq - (-m2sq + m4sq + m6sq)**2)*(m6sq - m7sq)) - T134fin(m6,m5,m1,mudim)/((m4sq - m5sq)*(m6sq - m7sq)) + ((m5sq - m6sq)**2*T134fin(m6,m5,m2,mudim))/((m4sq - m5sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))*(m6sq - m7sq)) - (m2sq*(m5sq + m6sq)*T134fin(m6,m5,m2,mudim))/((m4sq - m5sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))*(m6sq - m7sq)) - (m1sq*(-m2sq + m5sq + m6sq)*T134fin(m6,m5,m2,mudim))/((m4sq - m5sq)*(m2**4 + (m5sq - m6sq)**2 - 2*m2sq*(m5sq + m6sq))*(m6sq - m7sq)) - T134fin(m7,m4,m1,mudim)/((m4sq - m5sq)*(m6sq - m7sq)) + ((m4sq - m7sq)**2*T134fin(m7,m4,m2,mudim))/((m4sq - m5sq)*(m6sq - m7sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) - (m2sq*(m4sq + m7sq)*T134fin(m7,m4,m2,mudim))/((m4sq - m5sq)*(m6sq - m7sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) - (m1sq*(-m2sq + m4sq + m7sq)*T134fin(m7,m4,m2,mudim))/((m4sq - m5sq)*(m6sq - m7sq)*(m2**4 + (m4sq - m7sq)**2 - 2*m2sq*(m4sq + m7sq))) + T134fin(m7,m5,m1,mudim)/((m4sq - m5sq)*(m6sq - m7sq)) - T134fin(m7,m5,m2,mudim)/((m4sq - m5sq)*(m6sq - m7sq)) + ((m1sq - m2sq)*(m2sq - m5sq - m7sq)*T134fin(m7,m5,m2,mudim))/((m4sq - m5sq)*(m6sq - m7sq)*(4*m5sq*m7sq - (-m2sq + m5sq + m7sq)**2)))/(m1sq - m2sq)**2
		def eval_205():
			return ((m1sq*(m1sq - m3sq)*(-2*m1sq + m4sq + m5sq - 2*m6sq)*m6sq*B0del(0,0,m1sq,mudim))/((m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*(m6sq - m7sq)) - (m1sq*(m1sq - m3sq)*m4sq*(2*m1sq + 2*m4sq - m6sq - m7sq)*B0del(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + (m1sq*(m1sq - m3sq)*m5sq*(2*m1sq + 2*m5sq - m6sq - m7sq)*B0del(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) + (m1sq*(m1sq - m3sq)*m7sq*(2*m1sq - m4sq - m5sq + 2*m7sq)*B0del(0,0,m1sq,mudim))/((m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) + (2*(m1sq - m3sq)*m4sq*m6sq*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m6sq - m7sq)) + ((m1sq - m3sq)*m4sq*(-m1**4 + 4*m1sq*m4sq + (m4sq - m6sq)*(m4sq - m7sq))*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) - (m1sq*(m1sq - m3sq)*m4sq*(2*m1sq + 2*m4sq - m6sq - m7sq)*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) - (2*(m1sq - m3sq)*m4sq*m7sq*B0del(0,0,m4sq,mudim))/((m4sq - m5sq)*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) - (2*(m1sq - m3sq)*m5sq*m6sq*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*(m6sq - m7sq)) + ((m1sq - m3sq)*m5sq*(m1**4 - 4*m1sq*m5sq - (m5sq - m6sq)*(m5sq - m7sq))*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) + (m1sq*(m1sq - m3sq)*m5sq*(2*m1sq + 2*m5sq - m6sq - m7sq)*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) + (2*(m1sq - m3sq)*m5sq*m7sq*B0del(0,0,m5sq,mudim))/((m4sq - m5sq)*(m6sq - m7sq)*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) + (2*(m1sq - m3sq)*m4sq*m6sq*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m6sq - m7sq)) - (2*(m1sq - m3sq)*m5sq*m6sq*B0del(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*(m6sq - m7sq)) + (m1sq*(m1sq - m3sq)*(-2*m1sq + m4sq + m5sq - 2*m6sq)*m6sq*B0del(0,0,m6sq,mudim))/((m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*(m6sq - m7sq)) - ((m1sq - m3sq)*m6sq*(m1**4 - 4*m1sq*m6sq + (m4sq - m6sq)*(-m5sq + m6sq))*B0del(0,0,m6sq,mudim))/((m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*(m6sq - m7sq)) - (2*(m1sq - m3sq)*m4sq*m7sq*B0del(0,0,m7sq,mudim))/((m4sq - m5sq)*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + (2*(m1sq - m3sq)*m5sq*m7sq*B0del(0,0,m7sq,mudim))/((m4sq - m5sq)*(m6sq - m7sq)*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) + (m1sq*(m1sq - m3sq)*m7sq*(2*m1sq - m4sq - m5sq + 2*m7sq)*B0del(0,0,m7sq,mudim))/((m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) + ((m1sq - m3sq)*m7sq*(m1**4 - 4*m1sq*m7sq + (m4sq - m7sq)*(-m5sq + m7sq))*B0del(0,0,m7sq,mudim))/((m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) - ((m1sq - m3sq)*m6sq*(m1**4 - 4*m1sq*m6sq + (m4sq - m6sq)*(-m5sq + m6sq))*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/((m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*(m6sq - m7sq)) + ((m1sq - m3sq)*m4sq*(-m1**4 + 4*m1sq*m4sq + (m4sq - m6sq)*(m4sq - m7sq))*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + ((m1sq - m3sq)*m5sq*(m1**4 - 4*m1sq*m5sq - (m5sq - m6sq)*(m5sq - m7sq))*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) + ((m1sq - m3sq)*m7sq*(m1**4 - 4*m1sq*m7sq + (m4sq - m7sq)*(-m5sq + m7sq))*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/((m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) - (m1sq*(m1sq - m3sq)*(-2*m1sq + m4sq + m5sq - 2*m6sq)*m6sq*B0fin(0,0,m1sq,mudim))/((m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*(m6sq - m7sq)) + (m1sq*(m1sq - m3sq)*m4sq*(2*m1sq + 2*m4sq - m6sq - m7sq)*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) - (m1sq*(m1sq - m3sq)*m5sq*(2*m1sq + 2*m5sq - m6sq - m7sq)*B0fin(0,0,m1sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) - (m1sq*(m1sq - m3sq)*m7sq*(2*m1sq - m4sq - m5sq + 2*m7sq)*B0fin(0,0,m1sq,mudim))/((m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) - (2*(m1sq - m3sq)*m4sq*m6sq*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m6sq - m7sq)) + ((m1sq - m3sq)*m4sq*(m1**4 - 4*m1sq*m4sq - (m4sq - m6sq)*(m4sq - m7sq))*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + (m1sq*(m1sq - m3sq)*m4sq*(2*m1sq + 2*m4sq - m6sq - m7sq)*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + (2*(m1sq - m3sq)*m4sq*m7sq*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + ((m1sq - m3sq)*m4sq*(-m1**4 + 4*m1sq*m4sq + (m4sq - m6sq)*(m4sq - m7sq))*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) - (m1sq*(m1sq - m3sq)*m4sq*(2*m1sq + 2*m4sq - m6sq - m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + (2*(m1sq - m3sq)*m5sq*m6sq*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*(m6sq - m7sq)) - ((m1sq - m3sq)*m5sq*(m1**4 - 4*m1sq*m5sq - (m5sq - m6sq)*(m5sq - m7sq))*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) - (m1sq*(m1sq - m3sq)*m5sq*(2*m1sq + 2*m5sq - m6sq - m7sq)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) - (2*(m1sq - m3sq)*m5sq*m7sq*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m6sq - m7sq)*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) + ((m1sq - m3sq)*m5sq*(m1**4 - 4*m1sq*m5sq - (m5sq - m6sq)*(m5sq - m7sq))*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) + (m1sq*(m1sq - m3sq)*m5sq*(2*m1sq + 2*m5sq - m6sq - m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) - (2*(m1sq - m3sq)*m4sq*m6sq*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m6sq - m7sq)) + (2*(m1sq - m3sq)*m5sq*m6sq*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*(m6sq - m7sq)) - (m1sq*(m1sq - m3sq)*(-2*m1sq + m4sq + m5sq - 2*m6sq)*m6sq*B0fin(0,0,m6sq,mudim))/((m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*(m6sq - m7sq)) + ((m1sq - m3sq)*m6sq*(m1**4 - 4*m1sq*m6sq + (m4sq - m6sq)*(-m5sq + m6sq))*B0fin(0,0,m6sq,mudim))/((m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*(m6sq - m7sq)) + (m1sq*(m1sq - m3sq)*(-2*m1sq + m4sq + m5sq - 2*m6sq)*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*(m6sq - m7sq)) - ((m1sq - m3sq)*m6sq*(m1**4 - 4*m1sq*m6sq + (m4sq - m6sq)*(-m5sq + m6sq))*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*(m6sq - m7sq)) + (2*(m1sq - m3sq)*m4sq*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m6sq - m7sq)) - (2*(m1sq - m3sq)*m5sq*m6sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m6sq,mudim))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*(m6sq - m7sq)) - ((m1sq - m3sq)*(m1sq - m4sq - m6sq)*(m1sq + m4sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m6sq - m7sq)) + ((m1sq - m3sq)*(m1sq - m5sq - m6sq)*(m1sq + m5sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m4sq - m5sq)*(m1**4 + (m5sq - m6sq)**2 - 2*m1sq*(m5sq + m6sq))*(m6sq - m7sq)) + (2*(m1sq - m3sq)*m4sq*m7sq*B0fin(0,0,m7sq,mudim))/((m4sq - m5sq)*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) - (2*(m1sq - m3sq)*m5sq*m7sq*B0fin(0,0,m7sq,mudim))/((m4sq - m5sq)*(m6sq - m7sq)*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) - (m1sq*(m1sq - m3sq)*m7sq*(2*m1sq - m4sq - m5sq + 2*m7sq)*B0fin(0,0,m7sq,mudim))/((m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) - ((m1sq - m3sq)*m7sq*(m1**4 - 4*m1sq*m7sq + (m4sq - m7sq)*(-m5sq + m7sq))*B0fin(0,0,m7sq,mudim))/((m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) + (m1sq*(m1sq - m3sq)*m7sq*(2*m1sq - m4sq - m5sq + 2*m7sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) + ((m1sq - m3sq)*m7sq*(m1**4 - 4*m1sq*m7sq + (m4sq - m7sq)*(-m5sq + m7sq))*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m7sq,mudim))/((m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) - (2*(m1sq - m3sq)*m4sq*m7sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m7sq,mudim))/((m4sq - m5sq)*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) + (2*(m1sq - m3sq)*m5sq*m7sq*B0fin(0,0,m5sq,mudim)*B0fin(0,0,m7sq,mudim))/((m4sq - m5sq)*(m6sq - m7sq)*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) + ((m1sq - m3sq)*(m1sq - m4sq - m7sq)*(m1sq + m4sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m5sq)*(m6sq - m7sq)*(m1**4 + (m4sq - m7sq)**2 - 2*m1sq*(m4sq + m7sq))) - ((m1sq - m3sq)*(m1sq - m5sq - m7sq)*(m1sq + m5sq + m7sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim) + 2*m7sq*B0fin(0,0,m7sq,mudim)))/((m4sq - m5sq)*(m6sq - m7sq)*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) - T134fin(m6,m4,m1,mudim)/((m4sq - m5sq)*(m6sq - m7sq)) + ((m1sq - m3sq)*(m1sq - m4sq - m6sq)*T134fin(m6,m4,m1,mudim))/((m4sq - m5sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))*(m6sq - m7sq)) + T134fin(m6,m4,m3,mudim)/((m4sq - m5sq)*(m6sq - m7sq)) + T134fin(m6,m5,m1,mudim)/((m4sq - m5sq)*(m6sq - m7sq)) + ((m1sq - m3sq)*(m1sq - m5sq - m6sq)*T134fin(m6,m5,m1,mudim))/((m4sq - m5sq)*(4*m5sq*m6sq - (-m1sq + m5sq + m6sq)**2)*(m6sq - m7sq)) - T134fin(m6,m5,m3,mudim)/((m4sq - m5sq)*(m6sq - m7sq)) + T134fin(m7,m4,m1,mudim)/((m4sq - m5sq)*(m6sq - m7sq)) + ((m1sq - m3sq)*(m1sq - m4sq - m7sq)*T134fin(m7,m4,m1,mudim))/((m4sq - m5sq)*(m6sq - m7sq)*(4*m4sq*m7sq - (-m1sq + m4sq + m7sq)**2)) - T134fin(m7,m4,m3,mudim)/((m4sq - m5sq)*(m6sq - m7sq)) - T134fin(m7,m5,m1,mudim)/((m4sq - m5sq)*(m6sq - m7sq)) + ((m1sq - m3sq)*(m1sq - m5sq - m7sq)*T134fin(m7,m5,m1,mudim))/((m4sq - m5sq)*(m6sq - m7sq)*(m1**4 + (m5sq - m7sq)**2 - 2*m1sq*(m5sq + m7sq))) + T134fin(m7,m5,m3,mudim)/((m4sq - m5sq)*(m6sq - m7sq)))/(m1sq - m3sq)**2
		def eval_206():
			return ((m2sq - m3sq)*T134fin(m6,m4,m1,mudim) + (-m1sq + m3sq)*T134fin(m6,m4,m2,mudim) + m1sq*T134fin(m6,m4,m3,mudim) - m2sq*T134fin(m6,m4,m3,mudim) - m2sq*T134fin(m6,m5,m1,mudim) + m3sq*T134fin(m6,m5,m1,mudim) + m1sq*T134fin(m6,m5,m2,mudim) - m3sq*T134fin(m6,m5,m2,mudim) - m1sq*T134fin(m6,m5,m3,mudim) + m2sq*T134fin(m6,m5,m3,mudim) - m2sq*T134fin(m7,m4,m1,mudim) + m3sq*T134fin(m7,m4,m1,mudim) + m1sq*T134fin(m7,m4,m2,mudim) - m3sq*T134fin(m7,m4,m2,mudim) - m1sq*T134fin(m7,m4,m3,mudim) + m2sq*T134fin(m7,m4,m3,mudim) + m2sq*T134fin(m7,m5,m1,mudim) - m3sq*T134fin(m7,m5,m1,mudim) - m1sq*T134fin(m7,m5,m2,mudim) + m3sq*T134fin(m7,m5,m2,mudim) + m1sq*T134fin(m7,m5,m3,mudim) - m2sq*T134fin(m7,m5,m3,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m2sq - m3sq)*(m4sq - m5sq)*(m6sq - m7sq))

		cond_m1_0 = cond(m1, 0)
		cond_m2_0 = cond(m2, 0)
		cond_m3_0 = cond(m3, 0)
		cond_m4_0 = cond(m4, 0)
		cond_m5_0 = cond(m5, 0)
		cond_m6_0 = cond(m6, 0)
		cond_m7_0 = cond(m7, 0)
		cond_m7_m6 = cond(m7, m6)
		cond_m7_m5 = cond(m7, m5)
		cond_m6_m5 = cond(m6, m5)
		cond_m7_m4 = cond(m7, m4)
		cond_m6_m4 = cond(m6, m4)
		cond_m5_m4 = cond(m5, m4)
		cond_m7_m3 = cond(m7, m3)
		cond_m6_m3 = cond(m6, m3)
		cond_m5_m3 = cond(m5, m3)
		cond_m4_m3 = cond(m4, m3)
		cond_m7_m2 = cond(m7, m2)
		cond_m6_m2 = cond(m6, m2)
		cond_m5_m2 = cond(m5, m2)
		cond_m4_m2 = cond(m4, m2)
		cond_m3_m2 = cond(m3, m2)
		cond_m7_m1 = cond(m7, m1)
		cond_m6_m1 = cond(m6, m1)
		cond_m5_m1 = cond(m5, m1)
		cond_m4_m1 = cond(m4, m1)
		cond_m3_m1 = cond(m3, m1)
		cond_m2_m1 = cond(m2, m1)

		conditions = [
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_1()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_2()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_2()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_3()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_3()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_4()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_4()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_4()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_m6, lambda: eval_42()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_m5, lambda: eval_5()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_m5 and cond_m7_0, lambda: eval_5()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_m4, lambda: eval_5()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_m4 and cond_m7_0, lambda: eval_5()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_0 and cond_m7_0, lambda: eval_42()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_6()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_6()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_7()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_7()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_6()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_6()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_7()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_7()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_8()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_6()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_6()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_7()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_7()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_8()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_8()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0, lambda: eval_59()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_0, lambda: eval_9()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m7_0, lambda: eval_9()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_0, lambda: eval_9()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m7_0, lambda: eval_9()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m6_0 and cond_m7_0, lambda: eval_57()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_10()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_10()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_11()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_11()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_10()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_10()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_11()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_11()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_12()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_10()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_10()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_11()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_11()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_12()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_12()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_41()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_41()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m4, lambda: eval_13()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_0, lambda: eval_13()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_83()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_19()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_19()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_19()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_19()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_84()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_83()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_19()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_19()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_19()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_19()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_84()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_14()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_14()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_15()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_15()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_83()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_19()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_19()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_19()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_19()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_84()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_14()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_14()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_15()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_15()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_14()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_14()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_15()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_15()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_16()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m7_m6, lambda: eval_57()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m7_m6, lambda: eval_57()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m6_0 and cond_m7_m5, lambda: eval_17()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m6_m5 and cond_m7_0, lambda: eval_17()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m7_m6, lambda: eval_122()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m6_0 and cond_m7_m5, lambda: eval_19()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m6_m5 and cond_m7_0, lambda: eval_19()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m6_0 and cond_m7_m4, lambda: eval_19()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m6_m4 and cond_m7_0, lambda: eval_19()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m6_0 and cond_m7_0, lambda: eval_123()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_m6, lambda: eval_122()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_m5, lambda: eval_19()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m6_m5 and cond_m7_0, lambda: eval_19()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_m4, lambda: eval_19()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m6_m4 and cond_m7_0, lambda: eval_19()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m6_0 and cond_m7_0, lambda: eval_123()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_20()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_20()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_21()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_21()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_m5, lambda: eval_58()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m7_m5, lambda: eval_58()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_m4, lambda: eval_58()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m7_m4, lambda: eval_58()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_0, lambda: eval_59()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m7_0, lambda: eval_59()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m6_0 and cond_m7_m4, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m6_m4 and cond_m7_0, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_m3, lambda: eval_23()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m7_m3, lambda: eval_23()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_0, lambda: eval_31()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m7_0, lambda: eval_31()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m6_0 and cond_m7_m3, lambda: eval_31()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m6_m3 and cond_m7_0, lambda: eval_31()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_0, lambda: eval_31()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m7_0, lambda: eval_31()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m6_0 and cond_m7_0, lambda: eval_24()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_31()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_31()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_24()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m2, lambda: eval_23()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_m2, lambda: eval_23()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_0, lambda: eval_31()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m7_0, lambda: eval_31()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_m2, lambda: eval_31()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m6_m2 and cond_m7_0, lambda: eval_31()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_0, lambda: eval_31()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m7_0, lambda: eval_31()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m6_0 and cond_m7_0, lambda: eval_24()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_31()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_31()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_24()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_25()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_25()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_26()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_26()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_27()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_27()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_28()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_28()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_m6, lambda: eval_122()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_m5, lambda: eval_19()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_m5 and cond_m7_0, lambda: eval_19()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_m4, lambda: eval_19()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_m4 and cond_m7_0, lambda: eval_19()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_0 and cond_m7_0, lambda: eval_123()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_20()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_20()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_21()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_21()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_20()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_20()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_21()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_21()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_22()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_23()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_m1, lambda: eval_23()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_31()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m7_0, lambda: eval_31()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_m1, lambda: eval_31()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_m1 and cond_m7_0, lambda: eval_31()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_31()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m7_0, lambda: eval_31()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m6_0 and cond_m7_0, lambda: eval_24()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_31()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_31()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_24()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_25()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_25()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_26()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_26()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_27()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_27()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_28()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_28()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_25()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_25()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_26()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_26()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_29()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_27()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_27()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_28()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_28()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_29()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0, lambda: eval_69()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_0, lambda: eval_69()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m6_0, lambda: eval_69()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m7_0, lambda: eval_69()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_0, lambda: eval_30()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m6_0, lambda: eval_31()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m7_0, lambda: eval_31()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m6_0, lambda: eval_31()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m7_0, lambda: eval_31()),
			(cond_m1_0 and cond_m2_0 and cond_m6_0 and cond_m7_0, lambda: eval_32()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_0, lambda: eval_30()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m6_0, lambda: eval_31()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m7_0, lambda: eval_31()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m6_0, lambda: eval_31()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m7_0, lambda: eval_31()),
			(cond_m1_0 and cond_m3_0 and cond_m6_0 and cond_m7_0, lambda: eval_32()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_33()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_33()),
			(cond_m1_0 and cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_34()),
			(cond_m1_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_34()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0, lambda: eval_30()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_0, lambda: eval_31()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m7_0, lambda: eval_31()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_0, lambda: eval_31()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m7_0, lambda: eval_31()),
			(cond_m2_0 and cond_m3_0 and cond_m6_0 and cond_m7_0, lambda: eval_32()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_33()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_33()),
			(cond_m2_0 and cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_34()),
			(cond_m2_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_34()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_33()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_33()),
			(cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_34()),
			(cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_34()),
			(cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_35()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m4, lambda: eval_36()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_37()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_37()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_38()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_38()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_37()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_37()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_38()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_38()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_78()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_79()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_79()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_79()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_79()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_80()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_37()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_37()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_38()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_38()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_78()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_79()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_79()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_79()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_79()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_80()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_78()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_79()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_79()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_79()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_79()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_80()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_39()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_39()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_40()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_40()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_41()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_102()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_102()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m4, lambda: eval_46()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_0, lambda: eval_46()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_102()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_102()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m4, lambda: eval_46()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_0, lambda: eval_46()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_108()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_206()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_206()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_206()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_206()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_109()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m7_m6, lambda: eval_42()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m6_m4 and cond_m7_m5, lambda: eval_43()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m6_m5 and cond_m7_m4, lambda: eval_43()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m7_m6, lambda: eval_140()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m6_m3 and cond_m7_m5, lambda: eval_120()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m3, lambda: eval_120()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m7_m6, lambda: eval_140()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m6_0 and cond_m7_m5, lambda: eval_61()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m6_m5 and cond_m7_0, lambda: eval_61()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m4, lambda: eval_120()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m3, lambda: eval_120()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m4, lambda: eval_61()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m6_m4 and cond_m7_0, lambda: eval_61()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m3, lambda: eval_142()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m6_m3 and cond_m7_0, lambda: eval_142()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m7_m6, lambda: eval_140()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m6_m2 and cond_m7_m5, lambda: eval_120()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m2, lambda: eval_120()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m7_m6, lambda: eval_140()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m6_0 and cond_m7_m5, lambda: eval_61()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m6_m5 and cond_m7_0, lambda: eval_61()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m4, lambda: eval_120()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m2, lambda: eval_120()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m4, lambda: eval_61()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m6_m4 and cond_m7_0, lambda: eval_61()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m2, lambda: eval_142()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m2 and cond_m7_0, lambda: eval_142()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m7_m6, lambda: eval_110()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m6_0 and cond_m7_m5, lambda: eval_204()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m6_m5 and cond_m7_0, lambda: eval_204()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m4, lambda: eval_204()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m6_m4 and cond_m7_0, lambda: eval_204()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m6_0 and cond_m7_0, lambda: eval_111()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m3, lambda: eval_112()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m2, lambda: eval_112()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m3, lambda: eval_206()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m3 and cond_m7_0, lambda: eval_206()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m2, lambda: eval_206()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m2 and cond_m7_0, lambda: eval_206()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_206()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_206()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_113()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_206()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_206()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_113()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m4, lambda: eval_44()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m7_m4, lambda: eval_44()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_45()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m3, lambda: eval_141()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m7_m3, lambda: eval_141()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_54()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m3, lambda: eval_141()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m7_m3, lambda: eval_141()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_0, lambda: eval_53()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m7_0, lambda: eval_53()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_62()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_62()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_54()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_62()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_62()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m2, lambda: eval_141()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m7_m2, lambda: eval_141()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_54()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m2, lambda: eval_141()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m7_m2, lambda: eval_141()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_0, lambda: eval_53()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m7_0, lambda: eval_53()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_62()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_62()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_54()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_62()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_62()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_m2, lambda: eval_114()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m7_m2, lambda: eval_114()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_0, lambda: eval_170()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m7_0, lambda: eval_170()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m6_0 and cond_m7_m2, lambda: eval_171()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m6_m2 and cond_m7_0, lambda: eval_171()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_0, lambda: eval_170()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m7_0, lambda: eval_170()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m6_0 and cond_m7_0, lambda: eval_117()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_171()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_171()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_117()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_118()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_206()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_206()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_206()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_206()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_119()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_102()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_102()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m4, lambda: eval_46()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_0, lambda: eval_46()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_108()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_206()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_206()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_206()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_206()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_109()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_108()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_206()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_206()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_206()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_206()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_109()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_47()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_47()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_48()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_48()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m7_m6, lambda: eval_140()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_m1 and cond_m7_m5, lambda: eval_120()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m1, lambda: eval_120()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m7_m6, lambda: eval_140()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m6_0 and cond_m7_m5, lambda: eval_61()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m6_m5 and cond_m7_0, lambda: eval_61()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m4, lambda: eval_120()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m1, lambda: eval_120()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m4, lambda: eval_61()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m6_m4 and cond_m7_0, lambda: eval_61()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m1, lambda: eval_142()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m1 and cond_m7_0, lambda: eval_142()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m7_m6, lambda: eval_110()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m6_0 and cond_m7_m5, lambda: eval_204()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m6_m5 and cond_m7_0, lambda: eval_204()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m4, lambda: eval_204()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m6_m4 and cond_m7_0, lambda: eval_204()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4 and cond_m6_0 and cond_m7_0, lambda: eval_111()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m3, lambda: eval_112()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m1, lambda: eval_112()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m3, lambda: eval_206()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m3 and cond_m7_0, lambda: eval_206()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m1, lambda: eval_206()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m1 and cond_m7_0, lambda: eval_206()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_206()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_206()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_113()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_206()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_206()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_113()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_m6, lambda: eval_110()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_m5, lambda: eval_204()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m6_m5 and cond_m7_0, lambda: eval_204()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_m4, lambda: eval_204()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m6_m4 and cond_m7_0, lambda: eval_204()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4 and cond_m6_0 and cond_m7_0, lambda: eval_111()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_49()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_49()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_50()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_50()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_112()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_112()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_206()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_206()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_206()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_206()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_206()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_206()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_113()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_206()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_206()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_113()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_49()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_49()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_50()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_50()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_51()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_51()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_52()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_52()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_141()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m7_m1, lambda: eval_141()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_54()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_141()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m7_m1, lambda: eval_141()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_53()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m7_0, lambda: eval_53()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_62()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_62()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_54()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_62()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_62()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_114()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m7_m1, lambda: eval_114()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_170()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m7_0, lambda: eval_170()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m6_0 and cond_m7_m1, lambda: eval_171()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m6_m1 and cond_m7_0, lambda: eval_171()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_170()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m7_0, lambda: eval_170()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m6_0 and cond_m7_0, lambda: eval_117()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_171()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_171()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_117()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_118()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_206()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_206()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_206()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_206()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_119()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_114()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_m1, lambda: eval_114()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_170()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m7_0, lambda: eval_170()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_m1, lambda: eval_171()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m6_m1 and cond_m7_0, lambda: eval_171()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_170()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m7_0, lambda: eval_170()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m6_0 and cond_m7_0, lambda: eval_117()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_171()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_171()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_117()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_132()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_132()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_135()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_135()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_55()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_55()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_56()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_56()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_118()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_206()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_206()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_206()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_206()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_119()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_55()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_55()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_56()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_56()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m7_m6, lambda: eval_57()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m7_m6, lambda: eval_140()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m7_m6, lambda: eval_140()),
			(cond_m1_0 and cond_m2_0 and cond_m6_0 and cond_m7_m5, lambda: eval_61()),
			(cond_m1_0 and cond_m2_0 and cond_m6_m5 and cond_m7_0, lambda: eval_61()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m7_m6, lambda: eval_140()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m7_m6, lambda: eval_140()),
			(cond_m1_0 and cond_m3_0 and cond_m6_0 and cond_m7_m5, lambda: eval_61()),
			(cond_m1_0 and cond_m3_0 and cond_m6_m5 and cond_m7_0, lambda: eval_61()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m7_m6, lambda: eval_144()),
			(cond_m1_0 and cond_m4_0 and cond_m6_0 and cond_m7_m5, lambda: eval_206()),
			(cond_m1_0 and cond_m4_0 and cond_m6_m5 and cond_m7_0, lambda: eval_206()),
			(cond_m1_0 and cond_m5_0 and cond_m6_0 and cond_m7_m4, lambda: eval_206()),
			(cond_m1_0 and cond_m5_0 and cond_m6_m4 and cond_m7_0, lambda: eval_206()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_0 and cond_m7_0, lambda: eval_145()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m6_m5, lambda: eval_58()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m7_m5, lambda: eval_58()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m6_m5, lambda: eval_141()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m7_m5, lambda: eval_141()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m6_m4, lambda: eval_141()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m7_m4, lambda: eval_141()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m6_0, lambda: eval_142()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m7_0, lambda: eval_142()),
			(cond_m1_0 and cond_m2_0 and cond_m6_0 and cond_m7_m4, lambda: eval_62()),
			(cond_m1_0 and cond_m2_0 and cond_m6_m4 and cond_m7_0, lambda: eval_62()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m6_m5, lambda: eval_141()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m7_m5, lambda: eval_141()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m6_m4, lambda: eval_141()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m7_m4, lambda: eval_141()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m6_0, lambda: eval_142()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m7_0, lambda: eval_142()),
			(cond_m1_0 and cond_m3_0 and cond_m6_0 and cond_m7_m4, lambda: eval_62()),
			(cond_m1_0 and cond_m3_0 and cond_m6_m4 and cond_m7_0, lambda: eval_62()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m6_m3, lambda: eval_146()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m7_m3, lambda: eval_146()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m6_0, lambda: eval_206()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m7_0, lambda: eval_206()),
			(cond_m1_0 and cond_m4_0 and cond_m6_0 and cond_m7_m3, lambda: eval_206()),
			(cond_m1_0 and cond_m4_0 and cond_m6_m3 and cond_m7_0, lambda: eval_206()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m6_0, lambda: eval_206()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m7_0, lambda: eval_206()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_0 and cond_m7_0, lambda: eval_147()),
			(cond_m1_0 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_206()),
			(cond_m1_0 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_206()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_147()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_m4, lambda: eval_59()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m6_m4, lambda: eval_60()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m7_m4, lambda: eval_60()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_m3, lambda: eval_205()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m6_m3, lambda: eval_205()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m7_m3, lambda: eval_205()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_0, lambda: eval_205()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m6_0, lambda: eval_205()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m7_0, lambda: eval_205()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m6_m3, lambda: eval_205()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m7_m3, lambda: eval_205()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m6_0, lambda: eval_205()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m7_0, lambda: eval_205()),
			(cond_m1_0 and cond_m2_0 and cond_m6_0 and cond_m7_m3, lambda: eval_205()),
			(cond_m1_0 and cond_m2_0 and cond_m6_m3 and cond_m7_0, lambda: eval_205()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_m2, lambda: eval_205()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m6_m2, lambda: eval_205()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m7_m2, lambda: eval_205()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_0, lambda: eval_205()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m6_0, lambda: eval_205()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m7_0, lambda: eval_205()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m6_m2, lambda: eval_205()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m7_m2, lambda: eval_205()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m6_0, lambda: eval_205()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m7_0, lambda: eval_205()),
			(cond_m1_0 and cond_m3_0 and cond_m6_0 and cond_m7_m2, lambda: eval_205()),
			(cond_m1_0 and cond_m3_0 and cond_m6_m2 and cond_m7_0, lambda: eval_205()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_0, lambda: eval_148()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m6_0, lambda: eval_204()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m7_0, lambda: eval_204()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m6_0, lambda: eval_204()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m7_0, lambda: eval_204()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_0 and cond_m7_0, lambda: eval_150()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m6_m2, lambda: eval_149()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m7_m2, lambda: eval_149()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m6_0, lambda: eval_206()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m7_0, lambda: eval_206()),
			(cond_m1_0 and cond_m4_0 and cond_m6_0 and cond_m7_m2, lambda: eval_206()),
			(cond_m1_0 and cond_m4_0 and cond_m6_m2 and cond_m7_0, lambda: eval_206()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m6_0, lambda: eval_206()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m7_0, lambda: eval_206()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_0 and cond_m7_0, lambda: eval_151()),
			(cond_m1_0 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_206()),
			(cond_m1_0 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_206()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_151()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m7_m6, lambda: eval_140()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m7_m6, lambda: eval_140()),
			(cond_m2_0 and cond_m3_0 and cond_m6_0 and cond_m7_m5, lambda: eval_61()),
			(cond_m2_0 and cond_m3_0 and cond_m6_m5 and cond_m7_0, lambda: eval_61()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m7_m6, lambda: eval_144()),
			(cond_m2_0 and cond_m4_0 and cond_m6_0 and cond_m7_m5, lambda: eval_206()),
			(cond_m2_0 and cond_m4_0 and cond_m6_m5 and cond_m7_0, lambda: eval_206()),
			(cond_m2_0 and cond_m5_0 and cond_m6_0 and cond_m7_m4, lambda: eval_206()),
			(cond_m2_0 and cond_m5_0 and cond_m6_m4 and cond_m7_0, lambda: eval_206()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_0 and cond_m7_0, lambda: eval_145()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_m5, lambda: eval_141()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m7_m5, lambda: eval_141()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_m4, lambda: eval_141()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m7_m4, lambda: eval_141()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_0, lambda: eval_142()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m7_0, lambda: eval_142()),
			(cond_m2_0 and cond_m3_0 and cond_m6_0 and cond_m7_m4, lambda: eval_62()),
			(cond_m2_0 and cond_m3_0 and cond_m6_m4 and cond_m7_0, lambda: eval_62()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_m3, lambda: eval_146()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m7_m3, lambda: eval_146()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_0, lambda: eval_206()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m7_0, lambda: eval_206()),
			(cond_m2_0 and cond_m4_0 and cond_m6_0 and cond_m7_m3, lambda: eval_206()),
			(cond_m2_0 and cond_m4_0 and cond_m6_m3 and cond_m7_0, lambda: eval_206()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_0, lambda: eval_206()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m7_0, lambda: eval_206()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_0 and cond_m7_0, lambda: eval_147()),
			(cond_m2_0 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_206()),
			(cond_m2_0 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_206()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_147()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_m6, lambda: eval_144()),
			(cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_m5, lambda: eval_206()),
			(cond_m3_0 and cond_m4_0 and cond_m6_m5 and cond_m7_0, lambda: eval_206()),
			(cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_m4, lambda: eval_206()),
			(cond_m3_0 and cond_m5_0 and cond_m6_m4 and cond_m7_0, lambda: eval_206()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_0 and cond_m7_0, lambda: eval_145()),
			(cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_63()),
			(cond_m4_0 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_63()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_64()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_64()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m2, lambda: eval_146()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_m2, lambda: eval_146()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_0, lambda: eval_206()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m7_0, lambda: eval_206()),
			(cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_m2, lambda: eval_206()),
			(cond_m3_0 and cond_m4_0 and cond_m6_m2 and cond_m7_0, lambda: eval_206()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_0, lambda: eval_206()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m7_0, lambda: eval_206()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_0 and cond_m7_0, lambda: eval_147()),
			(cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_206()),
			(cond_m3_0 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_206()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_147()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_148()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_148()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_150()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_150()),
			(cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_65()),
			(cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_65()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_66()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_66()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_m1, lambda: eval_205()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_m1, lambda: eval_205()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m7_m1, lambda: eval_205()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_0, lambda: eval_205()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m6_0, lambda: eval_205()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m7_0, lambda: eval_205()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_m1, lambda: eval_205()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m7_m1, lambda: eval_205()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m6_0, lambda: eval_205()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m7_0, lambda: eval_205()),
			(cond_m2_0 and cond_m3_0 and cond_m6_0 and cond_m7_m1, lambda: eval_205()),
			(cond_m2_0 and cond_m3_0 and cond_m6_m1 and cond_m7_0, lambda: eval_205()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_0, lambda: eval_148()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m6_0, lambda: eval_204()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m7_0, lambda: eval_204()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m6_0, lambda: eval_204()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m7_0, lambda: eval_204()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_0 and cond_m7_0, lambda: eval_150()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_149()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m7_m1, lambda: eval_149()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_206()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m7_0, lambda: eval_206()),
			(cond_m2_0 and cond_m4_0 and cond_m6_0 and cond_m7_m1, lambda: eval_206()),
			(cond_m2_0 and cond_m4_0 and cond_m6_m1 and cond_m7_0, lambda: eval_206()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_206()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m7_0, lambda: eval_206()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_0 and cond_m7_0, lambda: eval_151()),
			(cond_m2_0 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_206()),
			(cond_m2_0 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_206()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_151()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_0, lambda: eval_148()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m6_0, lambda: eval_204()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m7_0, lambda: eval_204()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m6_0, lambda: eval_204()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m7_0, lambda: eval_204()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_0 and cond_m7_0, lambda: eval_150()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_152()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_152()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_154()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_149()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m7_m1, lambda: eval_149()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_206()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m7_0, lambda: eval_206()),
			(cond_m3_0 and cond_m4_0 and cond_m6_0 and cond_m7_m1, lambda: eval_206()),
			(cond_m3_0 and cond_m4_0 and cond_m6_m1 and cond_m7_0, lambda: eval_206()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_206()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m7_0, lambda: eval_206()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_0 and cond_m7_0, lambda: eval_151()),
			(cond_m3_0 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_206()),
			(cond_m3_0 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_206()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_151()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_152()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_152()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_154()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_154()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_154()),
			(cond_m4_0 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_67()),
			(cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_67()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_68()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_68()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0, lambda: eval_69()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0, lambda: eval_205()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0, lambda: eval_205()),
			(cond_m1_0 and cond_m2_0 and cond_m6_0, lambda: eval_205()),
			(cond_m1_0 and cond_m2_0 and cond_m7_0, lambda: eval_205()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0, lambda: eval_205()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0, lambda: eval_205()),
			(cond_m1_0 and cond_m3_0 and cond_m6_0, lambda: eval_205()),
			(cond_m1_0 and cond_m3_0 and cond_m7_0, lambda: eval_205()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0, lambda: eval_203()),
			(cond_m1_0 and cond_m4_0 and cond_m6_0, lambda: eval_206()),
			(cond_m1_0 and cond_m4_0 and cond_m7_0, lambda: eval_206()),
			(cond_m1_0 and cond_m5_0 and cond_m6_0, lambda: eval_206()),
			(cond_m1_0 and cond_m5_0 and cond_m7_0, lambda: eval_206()),
			(cond_m1_0 and cond_m6_0 and cond_m7_0, lambda: eval_202()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0, lambda: eval_205()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0, lambda: eval_205()),
			(cond_m2_0 and cond_m3_0 and cond_m6_0, lambda: eval_205()),
			(cond_m2_0 and cond_m3_0 and cond_m7_0, lambda: eval_205()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0, lambda: eval_203()),
			(cond_m2_0 and cond_m4_0 and cond_m6_0, lambda: eval_206()),
			(cond_m2_0 and cond_m4_0 and cond_m7_0, lambda: eval_206()),
			(cond_m2_0 and cond_m5_0 and cond_m6_0, lambda: eval_206()),
			(cond_m2_0 and cond_m5_0 and cond_m7_0, lambda: eval_206()),
			(cond_m2_0 and cond_m6_0 and cond_m7_0, lambda: eval_202()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0, lambda: eval_203()),
			(cond_m3_0 and cond_m4_0 and cond_m6_0, lambda: eval_206()),
			(cond_m3_0 and cond_m4_0 and cond_m7_0, lambda: eval_206()),
			(cond_m3_0 and cond_m5_0 and cond_m6_0, lambda: eval_206()),
			(cond_m3_0 and cond_m5_0 and cond_m7_0, lambda: eval_206()),
			(cond_m3_0 and cond_m6_0 and cond_m7_0, lambda: eval_202()),
			(cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_203()),
			(cond_m4_0 and cond_m5_0 and cond_m7_0, lambda: eval_203()),
			(cond_m4_0 and cond_m6_0 and cond_m7_0, lambda: eval_202()),
			(cond_m5_0 and cond_m6_0 and cond_m7_0, lambda: eval_202()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_75()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_75()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_70()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_70()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_71()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_71()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_75()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_70()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_70()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_71()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_71()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_m1, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_71()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_71()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m1, lambda: eval_72()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m1, lambda: eval_73()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m1 and cond_m7_0, lambda: eval_73()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0 and cond_m7_m1, lambda: eval_73()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m1 and cond_m7_0, lambda: eval_73()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_0 and cond_m7_0, lambda: eval_74()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m4, lambda: eval_75()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m4, lambda: eval_75()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_76()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_76()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_77()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_77()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m6_m5 and cond_m7_m5, lambda: eval_102()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m6_m4 and cond_m7_m4, lambda: eval_102()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m6_m3 and cond_m7_m4, lambda: eval_81()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m3, lambda: eval_81()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m6_m5 and cond_m7_m5, lambda: eval_102()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m6_m4 and cond_m7_m4, lambda: eval_102()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m2 and cond_m7_m4, lambda: eval_81()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m2, lambda: eval_81()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_164()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_164()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m6_0 and cond_m7_m4, lambda: eval_82()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m6_m4 and cond_m7_0, lambda: eval_82()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m3 and cond_m7_m3, lambda: eval_182()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m2 and cond_m7_m3, lambda: eval_206()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m2, lambda: eval_206()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_182()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_206()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_206()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m2 and cond_m7_m3, lambda: eval_206()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m3 and cond_m7_m2, lambda: eval_206()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m6_0 and cond_m7_m3, lambda: eval_206()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m6_m3 and cond_m7_0, lambda: eval_206()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_0 and cond_m7_m2, lambda: eval_181()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m2 and cond_m7_0, lambda: eval_181()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m7_m6, lambda: eval_103()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m6_m3 and cond_m7_m5, lambda: eval_104()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m6_m5 and cond_m7_m3, lambda: eval_104()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m4, lambda: eval_104()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m6_m4 and cond_m7_m3, lambda: eval_104()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m6_m3 and cond_m7_m3, lambda: eval_103()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m7_m6, lambda: eval_103()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m6_m2 and cond_m7_m5, lambda: eval_104()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m6_m5 and cond_m7_m2, lambda: eval_104()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m4, lambda: eval_104()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m6_m4 and cond_m7_m2, lambda: eval_104()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m2 and cond_m7_m2, lambda: eval_103()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m7_m6, lambda: eval_197()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m6_m2 and cond_m7_m5, lambda: eval_183()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m6_m5 and cond_m7_m2, lambda: eval_183()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m7_m6, lambda: eval_197()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m6_0 and cond_m7_m5, lambda: eval_184()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m6_m5 and cond_m7_0, lambda: eval_184()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m4, lambda: eval_183()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m6_m4 and cond_m7_m2, lambda: eval_183()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m4, lambda: eval_184()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m6_m4 and cond_m7_0, lambda: eval_184()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m6_0 and cond_m7_m2, lambda: eval_198()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m6_m2 and cond_m7_0, lambda: eval_198()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m3, lambda: eval_206()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m3 and cond_m7_m2, lambda: eval_206()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m2 and cond_m7_m2, lambda: eval_186()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m3, lambda: eval_206()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m3 and cond_m7_m2, lambda: eval_206()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m3, lambda: eval_185()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m3 and cond_m7_0, lambda: eval_185()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m6_0 and cond_m7_m2, lambda: eval_206()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m6_m2 and cond_m7_0, lambda: eval_206()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_186()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_206()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_206()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3, lambda: eval_105()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m7_m3, lambda: eval_105()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_106()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_106()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2, lambda: eval_105()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m7_m2, lambda: eval_105()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_106()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_106()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_m2, lambda: eval_183()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m7_m2, lambda: eval_183()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_163()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_m2, lambda: eval_183()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m7_m2, lambda: eval_183()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_0, lambda: eval_162()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m7_0, lambda: eval_162()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_184()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_184()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_163()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_184()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_184()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_97()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_97()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_98()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_98()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m4, lambda: eval_75()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m3, lambda: eval_76()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_76()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_77()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_77()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m2, lambda: eval_76()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_76()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_77()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_77()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_78()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_79()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_79()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_79()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_79()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_80()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m6_m5 and cond_m7_m5, lambda: eval_102()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m6_m4 and cond_m7_m4, lambda: eval_102()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m1 and cond_m7_m4, lambda: eval_81()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_m1, lambda: eval_81()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_164()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_164()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4 and cond_m6_0 and cond_m7_m4, lambda: eval_82()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4 and cond_m6_m4 and cond_m7_0, lambda: eval_82()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m3 and cond_m7_m3, lambda: eval_182()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m1 and cond_m7_m3, lambda: eval_206()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_m1, lambda: eval_206()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_182()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_206()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_206()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m1 and cond_m7_m3, lambda: eval_206()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m3 and cond_m7_m1, lambda: eval_206()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1 and cond_m6_0 and cond_m7_m3, lambda: eval_206()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1 and cond_m6_m3 and cond_m7_0, lambda: eval_206()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_0 and cond_m7_m1, lambda: eval_181()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m1 and cond_m7_0, lambda: eval_181()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m6_m5 and cond_m7_m5, lambda: eval_164()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m6_m4 and cond_m7_m4, lambda: eval_164()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4 and cond_m6_0 and cond_m7_m4, lambda: eval_82()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4 and cond_m6_m4 and cond_m7_0, lambda: eval_82()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m3 and cond_m7_m3, lambda: eval_83()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3 and cond_m6_0 and cond_m7_m3, lambda: eval_205()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3 and cond_m6_m3 and cond_m7_0, lambda: eval_205()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0 and cond_m6_0 and cond_m7_m3, lambda: eval_205()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0 and cond_m6_m3 and cond_m7_0, lambda: eval_205()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3 and cond_m6_0 and cond_m7_0, lambda: eval_84()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m2 and cond_m7_m2, lambda: eval_182()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m1 and cond_m7_m2, lambda: eval_206()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_m1, lambda: eval_206()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_182()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_206()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_206()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_206()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_206()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_206()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1 and cond_m6_m2 and cond_m7_0, lambda: eval_206()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_m1, lambda: eval_181()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m1 and cond_m7_0, lambda: eval_181()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m2, lambda: eval_83()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2 and cond_m6_0 and cond_m7_m2, lambda: eval_205()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2 and cond_m6_m2 and cond_m7_0, lambda: eval_205()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0 and cond_m6_0 and cond_m7_m2, lambda: eval_205()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0 and cond_m6_m2 and cond_m7_0, lambda: eval_205()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2 and cond_m6_0 and cond_m7_0, lambda: eval_84()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_m1 and cond_m7_m2, lambda: eval_85()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_m2 and cond_m7_m1, lambda: eval_85()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1 and cond_m6_0 and cond_m7_m2, lambda: eval_116()),
			